/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.tool;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.version.Version;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.tag.Tag;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.command.Command;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;

public class Tool
extends Processor {
    private static final String OSGI_OPT_SRC = "OSGI-OPT/src/";
    private final File tmp = Files.createTempDirectory("tool", new FileAttribute[0]).toFile();
    private final File sources = new File(this.tmp, "sources");
    private final File javadoc = new File(this.tmp, "javadoc");
    private final Domain manifest;

    public Tool(Processor parent, Jar jar) throws Exception {
        super(parent);
        this.manifest = Domain.domain((Manifest)jar.getManifest());
        for (Map.Entry e : jar.getResources().entrySet()) {
            if (!((String)e.getKey()).startsWith(OSGI_OPT_SRC)) continue;
            String path = ((String)e.getKey()).substring(OSGI_OPT_SRC.length());
            File out = IO.getFile((File)this.sources, (String)path);
            out.getParentFile().mkdirs();
            IO.copy((InputStream)((Resource)e.getValue()).openInputStream(), (File)out);
        }
    }

    public boolean hasSources() {
        return this.sources.isDirectory();
    }

    public Jar doJavadoc(Map<String, String> options) throws Exception {
        String bundleDescription;
        String version;
        if (!this.hasSources()) {
            return new Jar("empty");
        }
        Command command = new Command();
        command.add(new String[]{this.getProperty("javadoc", "javadoc")});
        command.add(new String[]{"-quiet"});
        command.add(new String[]{"-protected"});
        command.add(new String[]{"-d"});
        command.add(new String[]{this.javadoc.getAbsolutePath()});
        command.add(new String[]{"-charset"});
        command.add(new String[]{"UTF-8"});
        command.add(new String[]{"-sourcepath"});
        command.add(new String[]{this.sources.getAbsolutePath()});
        UTF8Properties pp = new UTF8Properties();
        pp.putAll(options);
        String name = this.manifest.getBundleName();
        if (name == null) {
            name = (String)this.manifest.getBundleSymbolicName().getKey();
        }
        if ((version = this.manifest.getBundleVersion()) == null) {
            version = Version.LOWEST.toString();
        }
        if ((bundleDescription = this.manifest.getBundleDescription()) != null && !Strings.trim((String)bundleDescription).isEmpty()) {
            this.printOverview(name, version, bundleDescription);
        }
        this.set((Properties)pp, "-doctitle", name);
        this.set((Properties)pp, "-windowtitle", name);
        this.set((Properties)pp, "-header", this.manifest.getBundleVendor());
        this.set((Properties)pp, "-bottom", this.manifest.getBundleCopyright());
        this.set((Properties)pp, "-footer", this.manifest.getBundleDocURL());
        command.add(new String[]{"-tag"});
        command.add(new String[]{"Immutable:t:Immutable"});
        command.add(new String[]{"-tag"});
        command.add(new String[]{"ThreadSafe:t:ThreadSafe"});
        command.add(new String[]{"-tag"});
        command.add(new String[]{"NotThreadSafe:t:NotThreadSafe"});
        command.add(new String[]{"-tag"});
        command.add(new String[]{"GuardedBy:mf:Guarded By:"});
        command.add(new String[]{"-tag"});
        command.add(new String[]{"security:m:Required Permissions"});
        command.add(new String[]{"-tag"});
        command.add(new String[]{"noimplement:t:Consumers of this API must not implement this interface"});
        Enumeration<?> e = pp.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = pp.getProperty(key);
            if (!key.startsWith("-")) continue;
            int n = key.lastIndexOf(46);
            if (n > 0) {
                key = key.substring(0, n);
            }
            command.add(new String[]{key});
            command.add(new String[]{value});
        }
        Parameters exports = this.manifest.getExportPackage();
        for (String packageName : exports.keySet()) {
            command.add(new String[]{packageName});
        }
        StringBuilder out = new StringBuilder();
        StringBuilder err = new StringBuilder();
        System.err.println(command);
        int result = command.execute((Appendable)out, (Appendable)err);
        if (result != 0) {
            this.warning("Error during execution of javadoc command: %s\n******************\n%s", new Object[]{out, err});
        }
        Jar jar = new Jar(this.tmp);
        this.addClose((Closeable)jar);
        return jar;
    }

    void printOverview(String name, String version, String bundleDescription) throws FileNotFoundException {
        Tag body = new Tag("body", new Object[0]);
        new Tag(body, "h1", new Object[]{name});
        new Tag(body, "p", new Object[]{"Version " + version});
        new Tag(body, "p", new Object[]{bundleDescription});
        Tag table = new Tag(body, "table", new Object[0]);
        for (String key : this.manifest) {
            if (key.equalsIgnoreCase("Bundle-Description") || key.equalsIgnoreCase("Bundle-Version")) continue;
            Tag tr = new Tag(table, "tr", new Object[0]);
            new Tag(tr, "td", new Object[]{key});
            new Tag(tr, "td", new Object[]{this.manifest.get(key)});
        }
        File overview = new File(this.sources, "overview.html");
        Object object = null;
        Object var8_9 = null;
        try (PrintWriter pw = new PrintWriter(overview);){
            body.print(2, pw);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private void set(Properties pp, String key, String value) {
        if (value == null) {
            return;
        }
        if (pp.containsKey(key)) {
            return;
        }
        pp.put(key, value);
    }

    public Jar doSource() throws IOException {
        if (!this.hasSources()) {
            return new Jar("empty");
        }
        return new Jar(this.sources);
    }

    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            IO.delete((File)this.tmp);
        }
    }
}

