/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.HttpParseException;
import com.sun.jini.jeri.internal.http.MessageReader;
import com.sun.jini.jeri.internal.http.MessageWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

class StartLine {
    final int major;
    final int minor;
    final boolean isRequest;
    final String method;
    final String uri;
    final int status;
    final String reason;

    StartLine(int major, int minor, String method, String uri) {
        this.major = major;
        this.minor = minor;
        this.method = method;
        this.uri = uri;
        this.status = -1;
        this.reason = null;
        this.isRequest = true;
    }

    StartLine(int major, int minor, int status, String reason) {
        this.major = major;
        this.minor = minor;
        this.status = status;
        this.reason = reason;
        this.method = null;
        this.uri = null;
        this.isRequest = false;
    }

    StartLine(InputStream in) throws IOException {
        String line = MessageReader.readLine(in);
        if (line == null) {
            throw new HttpParseException("unexpected EOF in start line");
        }
        try {
            StringTokenizer tok = new StringTokenizer(line, "", true);
            if (line.startsWith("HTTP")) {
                if (!tok.nextToken("/").equals("HTTP")) {
                    throw new HttpParseException();
                }
                tok.nextToken();
                this.major = Integer.parseInt(tok.nextToken("."));
                tok.nextToken();
                this.minor = Integer.parseInt(tok.nextToken(" "));
                tok.nextToken();
                this.status = Integer.parseInt(tok.nextToken());
                tok.nextToken();
                this.reason = tok.nextToken("\n");
                this.method = null;
                this.uri = null;
                this.isRequest = false;
            } else {
                this.method = tok.nextToken(" ");
                tok.nextToken();
                this.uri = tok.nextToken();
                tok.nextToken();
                if (!tok.nextToken("/").equals("HTTP")) {
                    throw new HttpParseException();
                }
                tok.nextToken();
                this.major = Integer.parseInt(tok.nextToken("."));
                tok.nextToken();
                this.minor = Integer.parseInt(tok.nextToken("\n"));
                this.status = -1;
                this.reason = null;
                this.isRequest = true;
            }
        }
        catch (Exception ex) {
            throw (HttpParseException)new HttpParseException("invalid start line").initCause(ex);
        }
    }

    void write(OutputStream out) throws IOException {
        String version = "HTTP/" + this.major + "." + this.minor;
        MessageWriter.writeLine(out, this.isRequest ? this.method + " " + this.uri + " " + version : version + " " + this.status + " " + this.reason);
    }

    static int compareVersions(int major1, int minor1, int major2, int minor2) {
        if (major1 != major2) {
            return major1 > major2 ? 1 : -1;
        }
        if (minor1 != minor2) {
            return minor1 > minor2 ? 1 : -1;
        }
        return 0;
    }
}

