// Code generated by running "go generate" in github.com/charlievieth/strcase. DO NOT EDIT.

//go:build go1.21
// +build go1.21

package tables

import "unicode"

// UnicodeVersion is the Unicode version from which the tables in this package are derived.
const UnicodeVersion = "15.0.0"

func init() {
	// This is essentially a compile time assertion that can only fail if a
	// future Go release updates the version of Unicode it supports. This
	// check is elided if the Unicode versions match.
	//
	// TLDR if you see this panic file an issue:
	// https://github.com/charlievieth/strcase/issues
	//
	if UnicodeVersion != unicode.Version {
		panic("strcase.UnicodeVersion \"" + UnicodeVersion +
			"\" != unicode.Version \"" + unicode.Version + "\"")
	}
}

// A foldPair stores Unicode case folding pairs
type foldPair struct {
	From uint32
	To   uint32
}

// TODO: rename to "foldCase"
//
// CaseFold returns the Unicode simple case-fold for r, if one exists, or r
// unmodified, if one does not exist.
func CaseFold(r rune) rune {
	// TODO: check if r is ASCII here?
	u := uint32(r)
	h := (u * _CaseFoldsSeed) >> _CaseFoldsShift
	p := _CaseFolds[h]
	if p.From == u {
		r = rune(p.To)
	}
	return r
}

// TODO: rename
func FoldMap(r rune) *[4]uint16 {
	u := uint32(r)
	h := (u * _FoldMapSeed) >> _FoldMapShift
	p := &_FoldMap[h]
	if uint32(p[0]) == u {
		return p
	}
	return nil
}

func FoldMapExcludingUpperLower(r rune) [2]rune {
	u := uint32(r)
	h := (u * _FoldMapSeed) >> _FoldMapShift
	p := &_FoldMapExcludingUpperLower[h]
	if uint32(p.r) == u {
		return [2]rune{rune(p.a[0]), rune(p.a[1])}
	}
	return [2]rune{}
}

// ToUpperLower combines unicode.ToUpper and unicode.ToLower in one function.
func ToUpperLower(r rune) (upper, lower rune, foundMapping bool) {
	if r <= 0x80 {
		if 'A' <= r && r <= 'Z' {
			return r, r + ('a' - 'A'), true
		}
		if 'a' <= r && r <= 'z' {
			return r - ('a' - 'A'), r, true
		}
		return r, r, false
	}
	// Hash rune r and see if it's in the _UpperLower table.
	u := uint32(r)
	h := (u | u<<24) * _UpperLowerSeed
	p := &_UpperLower[h>>_UpperLowerShift]
	if p[0] == u || p[1] == u {
		return rune(p[0]), rune(p[1]), true
	}
	// Handle Unicode characters that do not equal
	// their upper and lower case forms.
	return toUpperLowerSpecial(r)
}

const _CaseFoldsSeed = 0xFFE00C86
const _CaseFoldsShift = 19

// _CaseFolds stores all Unicode simple case-folds.
var _CaseFolds = [8192]foldPair{
	66:   {0x1FFC, 0x1FF3},   // 'ῼ' => 'ῳ'
	70:   {0x1FFB, 0x1F7D},   // 'Ώ' => 'ώ'
	74:   {0x1FFA, 0x1F7C},   // 'Ὼ' => 'ὼ'
	78:   {0x1FF9, 0x1F79},   // 'Ό' => 'ό'
	82:   {0x1FF8, 0x1F78},   // 'Ὸ' => 'ὸ'
	129:  {0x1FEC, 0x1FE5},   // 'Ῥ' => 'ῥ'
	133:  {0x1FEB, 0x1F7B},   // 'Ύ' => 'ύ'
	137:  {0x1FEA, 0x1F7A},   // 'Ὺ' => 'ὺ'
	141:  {0x1FE9, 0x1FE1},   // 'Ῡ' => 'ῡ'
	145:  {0x1FE8, 0x1FE0},   // 'Ῠ' => 'ῠ'
	197:  {0x1FDB, 0x1F77},   // 'Ί' => 'ί'
	201:  {0x1FDA, 0x1F76},   // 'Ὶ' => 'ὶ'
	205:  {0x1FD9, 0x1FD1},   // 'Ῑ' => 'ῑ'
	209:  {0x1FD8, 0x1FD0},   // 'Ῐ' => 'ῐ'
	257:  {0x1FCC, 0x1FC3},   // 'ῌ' => 'ῃ'
	261:  {0x1FCB, 0x1F75},   // 'Ή' => 'ή'
	265:  {0x1FCA, 0x1F74},   // 'Ὴ' => 'ὴ'
	269:  {0x1FC9, 0x1F73},   // 'Έ' => 'έ'
	273:  {0x1FC8, 0x1F72},   // 'Ὲ' => 'ὲ'
	306:  {0xA7F5, 0xA7F6},   // 'Ꟶ' => 'ꟶ'
	313:  {0x1FBE, 0x03B9},   // 'ι' => 'ι'
	321:  {0x1FBC, 0x1FB3},   // 'ᾼ' => 'ᾳ'
	325:  {0x1FBB, 0x1F71},   // 'Ά' => 'ά'
	329:  {0x1FBA, 0x1F70},   // 'Ὰ' => 'ὰ'
	333:  {0x1FB9, 0x1FB1},   // 'Ᾱ' => 'ᾱ'
	337:  {0x1FB8, 0x1FB0},   // 'Ᾰ' => 'ᾰ'
	373:  {0x1FAF, 0x1FA7},   // 'ᾯ' => 'ᾧ'
	377:  {0x1FAE, 0x1FA6},   // 'ᾮ' => 'ᾦ'
	381:  {0x1FAD, 0x1FA5},   // 'ᾭ' => 'ᾥ'
	385:  {0x1FAC, 0x1FA4},   // 'ᾬ' => 'ᾤ'
	389:  {0x1FAB, 0x1FA3},   // 'ᾫ' => 'ᾣ'
	393:  {0x1FAA, 0x1FA2},   // 'ᾪ' => 'ᾢ'
	397:  {0x1FA9, 0x1FA1},   // 'ᾩ' => 'ᾡ'
	401:  {0x1FA8, 0x1FA0},   // 'ᾨ' => 'ᾠ'
	422:  {0xA7D8, 0xA7D9},   // 'Ꟙ' => 'ꟙ'
	430:  {0xA7D6, 0xA7D7},   // 'Ꟗ' => 'ꟗ'
	437:  {0x1F9F, 0x1F97},   // 'ᾟ' => 'ᾗ'
	441:  {0x1F9E, 0x1F96},   // 'ᾞ' => 'ᾖ'
	445:  {0x1F9D, 0x1F95},   // 'ᾝ' => 'ᾕ'
	449:  {0x1F9C, 0x1F94},   // 'ᾜ' => 'ᾔ'
	453:  {0x1F9B, 0x1F93},   // 'ᾛ' => 'ᾓ'
	454:  {0xA7D0, 0xA7D1},   // 'Ꟑ' => 'ꟑ'
	457:  {0x1F9A, 0x1F92},   // 'ᾚ' => 'ᾒ'
	461:  {0x1F99, 0x1F91},   // 'ᾙ' => 'ᾑ'
	465:  {0x1F98, 0x1F90},   // 'ᾘ' => 'ᾐ'
	482:  {0xA7C9, 0xA7CA},   // 'Ꟊ' => 'ꟊ'
	490:  {0xA7C7, 0xA7C8},   // 'Ꟈ' => 'ꟈ'
	494:  {0xA7C6, 0x1D8E},   // 'Ᶎ' => 'ᶎ'
	498:  {0xA7C5, 0x0282},   // 'Ʂ' => 'ʂ'
	501:  {0x1F8F, 0x1F87},   // 'ᾏ' => 'ᾇ'
	502:  {0xA7C4, 0xA794},   // 'Ꞔ' => 'ꞔ'
	505:  {0x1F8E, 0x1F86},   // 'ᾎ' => 'ᾆ'
	509:  {0x1F8D, 0x1F85},   // 'ᾍ' => 'ᾅ'
	510:  {0xA7C2, 0xA7C3},   // 'Ꟃ' => 'ꟃ'
	513:  {0x1F8C, 0x1F84},   // 'ᾌ' => 'ᾄ'
	517:  {0x1F8B, 0x1F83},   // 'ᾋ' => 'ᾃ'
	518:  {0xA7C0, 0xA7C1},   // 'Ꟁ' => 'ꟁ'
	521:  {0x1F8A, 0x1F82},   // 'ᾊ' => 'ᾂ'
	525:  {0x1F89, 0x1F81},   // 'ᾉ' => 'ᾁ'
	526:  {0xA7BE, 0xA7BF},   // 'Ꞿ' => 'ꞿ'
	529:  {0x1F88, 0x1F80},   // 'ᾈ' => 'ᾀ'
	534:  {0xA7BC, 0xA7BD},   // 'Ꞽ' => 'ꞽ'
	542:  {0xA7BA, 0xA7BB},   // 'Ꞻ' => 'ꞻ'
	550:  {0xA7B8, 0xA7B9},   // 'Ꞹ' => 'ꞹ'
	558:  {0xA7B6, 0xA7B7},   // 'Ꞷ' => 'ꞷ'
	566:  {0xA7B4, 0xA7B5},   // 'Ꞵ' => 'ꞵ'
	570:  {0xA7B3, 0xAB53},   // 'Ꭓ' => 'ꭓ'
	574:  {0xA7B2, 0x029D},   // 'Ʝ' => 'ʝ'
	578:  {0xA7B1, 0x0287},   // 'Ʇ' => 'ʇ'
	582:  {0xA7B0, 0x029E},   // 'Ʞ' => 'ʞ'
	590:  {0xA7AE, 0x026A},   // 'Ɪ' => 'ɪ'
	594:  {0xA7AD, 0x026C},   // 'Ɬ' => 'ɬ'
	598:  {0xA7AC, 0x0261},   // 'Ɡ' => 'ɡ'
	602:  {0xA7AB, 0x025C},   // 'Ɜ' => 'ɜ'
	606:  {0xA7AA, 0x0266},   // 'Ɦ' => 'ɦ'
	614:  {0xA7A8, 0xA7A9},   // 'Ꞩ' => 'ꞩ'
	622:  {0xA7A6, 0xA7A7},   // 'Ꞧ' => 'ꞧ'
	629:  {0x1F6F, 0x1F67},   // 'Ὧ' => 'ὧ'
	630:  {0xA7A4, 0xA7A5},   // 'Ꞥ' => 'ꞥ'
	633:  {0x1F6E, 0x1F66},   // 'Ὦ' => 'ὦ'
	637:  {0x1F6D, 0x1F65},   // 'Ὥ' => 'ὥ'
	638:  {0xA7A2, 0xA7A3},   // 'Ꞣ' => 'ꞣ'
	641:  {0x1F6C, 0x1F64},   // 'Ὤ' => 'ὤ'
	645:  {0x1F6B, 0x1F63},   // 'Ὣ' => 'ὣ'
	646:  {0xA7A0, 0xA7A1},   // 'Ꞡ' => 'ꞡ'
	649:  {0x1F6A, 0x1F62},   // 'Ὢ' => 'ὢ'
	653:  {0x1F69, 0x1F61},   // 'Ὡ' => 'ὡ'
	654:  {0xA79E, 0xA79F},   // 'Ꞟ' => 'ꞟ'
	657:  {0x1F68, 0x1F60},   // 'Ὠ' => 'ὠ'
	662:  {0xA79C, 0xA79D},   // 'Ꞝ' => 'ꞝ'
	670:  {0xA79A, 0xA79B},   // 'Ꞛ' => 'ꞛ'
	678:  {0xA798, 0xA799},   // 'Ꞙ' => 'ꞙ'
	686:  {0xA796, 0xA797},   // 'Ꞗ' => 'ꞗ'
	693:  {0x1F5F, 0x1F57},   // 'Ὗ' => 'ὗ'
	701:  {0x1F5D, 0x1F55},   // 'Ὕ' => 'ὕ'
	702:  {0xA792, 0xA793},   // 'Ꞓ' => 'ꞓ'
	709:  {0x1F5B, 0x1F53},   // 'Ὓ' => 'ὓ'
	710:  {0xA790, 0xA791},   // 'Ꞑ' => 'ꞑ'
	717:  {0x1F59, 0x1F51},   // 'Ὑ' => 'ὑ'
	722:  {0xA78D, 0x0265},   // 'Ɥ' => 'ɥ'
	730:  {0xA78B, 0xA78C},   // 'Ꞌ' => 'ꞌ'
	750:  {0xA786, 0xA787},   // 'Ꞇ' => 'ꞇ'
	758:  {0xA784, 0xA785},   // 'Ꞅ' => 'ꞅ'
	764:  {0x1F4D, 0x1F45},   // 'Ὅ' => 'ὅ'
	766:  {0xA782, 0xA783},   // 'Ꞃ' => 'ꞃ'
	768:  {0x1F4C, 0x1F44},   // 'Ὄ' => 'ὄ'
	772:  {0x1F4B, 0x1F43},   // 'Ὃ' => 'ὃ'
	774:  {0xA780, 0xA781},   // 'Ꞁ' => 'ꞁ'
	776:  {0x1F4A, 0x1F42},   // 'Ὂ' => 'ὂ'
	780:  {0x1F49, 0x1F41},   // 'Ὁ' => 'ὁ'
	782:  {0xA77E, 0xA77F},   // 'Ꝿ' => 'ꝿ'
	784:  {0x1F48, 0x1F40},   // 'Ὀ' => 'ὀ'
	786:  {0xA77D, 0x1D79},   // 'Ᵹ' => 'ᵹ'
	794:  {0xA77B, 0xA77C},   // 'Ꝼ' => 'ꝼ'
	802:  {0xA779, 0xA77A},   // 'Ꝺ' => 'ꝺ'
	820:  {0x1F3F, 0x1F37},   // 'Ἷ' => 'ἷ'
	824:  {0x1F3E, 0x1F36},   // 'Ἶ' => 'ἶ'
	828:  {0x1F3D, 0x1F35},   // 'Ἵ' => 'ἵ'
	832:  {0x1F3C, 0x1F34},   // 'Ἴ' => 'ἴ'
	836:  {0x1F3B, 0x1F33},   // 'Ἳ' => 'ἳ'
	840:  {0x1F3A, 0x1F32},   // 'Ἲ' => 'ἲ'
	844:  {0x1F39, 0x1F31},   // 'Ἱ' => 'ἱ'
	846:  {0xA76E, 0xA76F},   // 'Ꝯ' => 'ꝯ'
	848:  {0x1F38, 0x1F30},   // 'Ἰ' => 'ἰ'
	854:  {0xA76C, 0xA76D},   // 'Ꝭ' => 'ꝭ'
	862:  {0xA76A, 0xA76B},   // 'Ꝫ' => 'ꝫ'
	870:  {0xA768, 0xA769},   // 'Ꝩ' => 'ꝩ'
	878:  {0xA766, 0xA767},   // 'Ꝧ' => 'ꝧ'
	884:  {0x1F2F, 0x1F27},   // 'Ἧ' => 'ἧ'
	886:  {0xA764, 0xA765},   // 'Ꝥ' => 'ꝥ'
	888:  {0x1F2E, 0x1F26},   // 'Ἦ' => 'ἦ'
	892:  {0x1F2D, 0x1F25},   // 'Ἥ' => 'ἥ'
	894:  {0xA762, 0xA763},   // 'Ꝣ' => 'ꝣ'
	896:  {0x1F2C, 0x1F24},   // 'Ἤ' => 'ἤ'
	900:  {0x1F2B, 0x1F23},   // 'Ἣ' => 'ἣ'
	902:  {0xA760, 0xA761},   // 'Ꝡ' => 'ꝡ'
	904:  {0x1F2A, 0x1F22},   // 'Ἢ' => 'ἢ'
	908:  {0x1F29, 0x1F21},   // 'Ἡ' => 'ἡ'
	910:  {0xA75E, 0xA75F},   // 'Ꝟ' => 'ꝟ'
	912:  {0x1F28, 0x1F20},   // 'Ἠ' => 'ἠ'
	917:  {0xA75C, 0xA75D},   // 'Ꝝ' => 'ꝝ'
	925:  {0xA75A, 0xA75B},   // 'Ꝛ' => 'ꝛ'
	933:  {0xA758, 0xA759},   // 'Ꝙ' => 'ꝙ'
	941:  {0xA756, 0xA757},   // 'Ꝗ' => 'ꝗ'
	949:  {0xA754, 0xA755},   // 'Ꝕ' => 'ꝕ'
	956:  {0x1F1D, 0x1F15},   // 'Ἕ' => 'ἕ'
	957:  {0xA752, 0xA753},   // 'Ꝓ' => 'ꝓ'
	960:  {0x1F1C, 0x1F14},   // 'Ἔ' => 'ἔ'
	964:  {0x1F1B, 0x1F13},   // 'Ἓ' => 'ἓ'
	965:  {0xA750, 0xA751},   // 'Ꝑ' => 'ꝑ'
	968:  {0x1F1A, 0x1F12},   // 'Ἒ' => 'ἒ'
	972:  {0x1F19, 0x1F11},   // 'Ἑ' => 'ἑ'
	973:  {0xA74E, 0xA74F},   // 'Ꝏ' => 'ꝏ'
	976:  {0x1F18, 0x1F10},   // 'Ἐ' => 'ἐ'
	981:  {0xA74C, 0xA74D},   // 'Ꝍ' => 'ꝍ'
	989:  {0xA74A, 0xA74B},   // 'Ꝋ' => 'ꝋ'
	997:  {0xA748, 0xA749},   // 'Ꝉ' => 'ꝉ'
	1005: {0xA746, 0xA747},   // 'Ꝇ' => 'ꝇ'
	1012: {0x1F0F, 0x1F07},   // 'Ἇ' => 'ἇ'
	1013: {0xA744, 0xA745},   // 'Ꝅ' => 'ꝅ'
	1016: {0x1F0E, 0x1F06},   // 'Ἆ' => 'ἆ'
	1020: {0x1F0D, 0x1F05},   // 'Ἅ' => 'ἅ'
	1021: {0xA742, 0xA743},   // 'Ꝃ' => 'ꝃ'
	1024: {0x1F0C, 0x1F04},   // 'Ἄ' => 'ἄ'
	1028: {0x1F0B, 0x1F03},   // 'Ἃ' => 'ἃ'
	1029: {0xA740, 0xA741},   // 'Ꝁ' => 'ꝁ'
	1032: {0x1F0A, 0x1F02},   // 'Ἂ' => 'ἂ'
	1036: {0x1F09, 0x1F01},   // 'Ἁ' => 'ἁ'
	1037: {0xA73E, 0xA73F},   // 'Ꜿ' => 'ꜿ'
	1040: {0x1F08, 0x1F00},   // 'Ἀ' => 'ἀ'
	1045: {0xA73C, 0xA73D},   // 'Ꜽ' => 'ꜽ'
	1053: {0xA73A, 0xA73B},   // 'Ꜻ' => 'ꜻ'
	1061: {0xA738, 0xA739},   // 'Ꜹ' => 'ꜹ'
	1069: {0xA736, 0xA737},   // 'Ꜷ' => 'ꜷ'
	1077: {0xA734, 0xA735},   // 'Ꜵ' => 'ꜵ'
	1080: {0x1EFE, 0x1EFF},   // 'Ỿ' => 'ỿ'
	1085: {0xA732, 0xA733},   // 'Ꜳ' => 'ꜳ'
	1088: {0x1EFC, 0x1EFD},   // 'Ỽ' => 'ỽ'
	1096: {0x1EFA, 0x1EFB},   // 'Ỻ' => 'ỻ'
	1101: {0xA72E, 0xA72F},   // 'Ꜯ' => 'ꜯ'
	1104: {0x1EF8, 0x1EF9},   // 'Ỹ' => 'ỹ'
	1109: {0xA72C, 0xA72D},   // 'Ꜭ' => 'ꜭ'
	1112: {0x1EF6, 0x1EF7},   // 'Ỷ' => 'ỷ'
	1117: {0xA72A, 0xA72B},   // 'Ꜫ' => 'ꜫ'
	1120: {0x1EF4, 0x1EF5},   // 'Ỵ' => 'ỵ'
	1125: {0xA728, 0xA729},   // 'Ꜩ' => 'ꜩ'
	1128: {0x1EF2, 0x1EF3},   // 'Ỳ' => 'ỳ'
	1133: {0xA726, 0xA727},   // 'Ꜧ' => 'ꜧ'
	1136: {0x1EF0, 0x1EF1},   // 'Ự' => 'ự'
	1141: {0xA724, 0xA725},   // 'Ꜥ' => 'ꜥ'
	1144: {0x1EEE, 0x1EEF},   // 'Ữ' => 'ữ'
	1149: {0xA722, 0xA723},   // 'Ꜣ' => 'ꜣ'
	1152: {0x1EEC, 0x1EED},   // 'Ử' => 'ử'
	1160: {0x1EEA, 0x1EEB},   // 'Ừ' => 'ừ'
	1168: {0x1EE8, 0x1EE9},   // 'Ứ' => 'ứ'
	1176: {0x1EE6, 0x1EE7},   // 'Ủ' => 'ủ'
	1184: {0x1EE4, 0x1EE5},   // 'Ụ' => 'ụ'
	1191: {0xFF3A, 0xFF5A},   // 'Ｚ' => 'ｚ'
	1192: {0x1EE2, 0x1EE3},   // 'Ợ' => 'ợ'
	1195: {0xFF39, 0xFF59},   // 'Ｙ' => 'ｙ'
	1199: {0xFF38, 0xFF58},   // 'Ｘ' => 'ｘ'
	1200: {0x1EE0, 0x1EE1},   // 'Ỡ' => 'ỡ'
	1203: {0xFF37, 0xFF57},   // 'Ｗ' => 'ｗ'
	1207: {0xFF36, 0xFF56},   // 'Ｖ' => 'ｖ'
	1208: {0x1EDE, 0x1EDF},   // 'Ở' => 'ở'
	1211: {0xFF35, 0xFF55},   // 'Ｕ' => 'ｕ'
	1215: {0xFF34, 0xFF54},   // 'Ｔ' => 'ｔ'
	1216: {0x1EDC, 0x1EDD},   // 'Ờ' => 'ờ'
	1219: {0xFF33, 0xFF53},   // 'Ｓ' => 'ｓ'
	1223: {0xFF32, 0xFF52},   // 'Ｒ' => 'ｒ'
	1224: {0x1EDA, 0x1EDB},   // 'Ớ' => 'ớ'
	1227: {0xFF31, 0xFF51},   // 'Ｑ' => 'ｑ'
	1231: {0xFF30, 0xFF50},   // 'Ｐ' => 'ｐ'
	1232: {0x1ED8, 0x1ED9},   // 'Ộ' => 'ộ'
	1235: {0xFF2F, 0xFF4F},   // 'Ｏ' => 'ｏ'
	1239: {0xFF2E, 0xFF4E},   // 'Ｎ' => 'ｎ'
	1240: {0x1ED6, 0x1ED7},   // 'Ỗ' => 'ỗ'
	1243: {0xFF2D, 0xFF4D},   // 'Ｍ' => 'ｍ'
	1247: {0xFF2C, 0xFF4C},   // 'Ｌ' => 'ｌ'
	1248: {0x1ED4, 0x1ED5},   // 'Ổ' => 'ổ'
	1251: {0xFF2B, 0xFF4B},   // 'Ｋ' => 'ｋ'
	1255: {0xFF2A, 0xFF4A},   // 'Ｊ' => 'ｊ'
	1256: {0x1ED2, 0x1ED3},   // 'Ồ' => 'ồ'
	1259: {0xFF29, 0xFF49},   // 'Ｉ' => 'ｉ'
	1263: {0xFF28, 0xFF48},   // 'Ｈ' => 'ｈ'
	1264: {0x1ED0, 0x1ED1},   // 'Ố' => 'ố'
	1267: {0xFF27, 0xFF47},   // 'Ｇ' => 'ｇ'
	1271: {0xFF26, 0xFF46},   // 'Ｆ' => 'ｆ'
	1272: {0x1ECE, 0x1ECF},   // 'Ỏ' => 'ỏ'
	1275: {0xFF25, 0xFF45},   // 'Ｅ' => 'ｅ'
	1279: {0xFF24, 0xFF44},   // 'Ｄ' => 'ｄ'
	1280: {0x1ECC, 0x1ECD},   // 'Ọ' => 'ọ'
	1283: {0xFF23, 0xFF43},   // 'Ｃ' => 'ｃ'
	1287: {0xFF22, 0xFF42},   // 'Ｂ' => 'ｂ'
	1288: {0x1ECA, 0x1ECB},   // 'Ị' => 'ị'
	1291: {0xFF21, 0xFF41},   // 'Ａ' => 'ａ'
	1296: {0x1EC8, 0x1EC9},   // 'Ỉ' => 'ỉ'
	1304: {0x1EC6, 0x1EC7},   // 'Ệ' => 'ệ'
	1312: {0x1EC4, 0x1EC5},   // 'Ễ' => 'ễ'
	1320: {0x1EC2, 0x1EC3},   // 'Ể' => 'ể'
	1328: {0x1EC0, 0x1EC1},   // 'Ề' => 'ề'
	1336: {0x1EBE, 0x1EBF},   // 'Ế' => 'ế'
	1344: {0x1EBC, 0x1EBD},   // 'Ẽ' => 'ẽ'
	1352: {0x1EBA, 0x1EBB},   // 'Ẻ' => 'ẻ'
	1360: {0x1EB8, 0x1EB9},   // 'Ẹ' => 'ẹ'
	1368: {0x1EB6, 0x1EB7},   // 'Ặ' => 'ặ'
	1376: {0x1EB4, 0x1EB5},   // 'Ẵ' => 'ẵ'
	1384: {0x1EB2, 0x1EB3},   // 'Ẳ' => 'ẳ'
	1392: {0x1EB0, 0x1EB1},   // 'Ằ' => 'ằ'
	1400: {0x1EAE, 0x1EAF},   // 'Ắ' => 'ắ'
	1408: {0x1EAC, 0x1EAD},   // 'Ậ' => 'ậ'
	1416: {0x1EAA, 0x1EAB},   // 'Ẫ' => 'ẫ'
	1423: {0x1EA8, 0x1EA9},   // 'Ẩ' => 'ẩ'
	1431: {0x1EA6, 0x1EA7},   // 'Ầ' => 'ầ'
	1439: {0x1EA4, 0x1EA5},   // 'Ấ' => 'ấ'
	1447: {0x1EA2, 0x1EA3},   // 'Ả' => 'ả'
	1455: {0x1EA0, 0x1EA1},   // 'Ạ' => 'ạ'
	1463: {0x1E9E, 0x00DF},   // 'ẞ' => 'ß'
	1475: {0x1E9B, 0x1E61},   // 'ẛ' => 'ṡ'
	1503: {0x1E94, 0x1E95},   // 'Ẕ' => 'ẕ'
	1511: {0x1E92, 0x1E93},   // 'Ẓ' => 'ẓ'
	1519: {0x1E90, 0x1E91},   // 'Ẑ' => 'ẑ'
	1527: {0x1E8E, 0x1E8F},   // 'Ẏ' => 'ẏ'
	1535: {0x1E8C, 0x1E8D},   // 'Ẍ' => 'ẍ'
	1543: {0x1E8A, 0x1E8B},   // 'Ẋ' => 'ẋ'
	1551: {0x1E88, 0x1E89},   // 'Ẉ' => 'ẉ'
	1559: {0x1E86, 0x1E87},   // 'Ẇ' => 'ẇ'
	1567: {0x1E84, 0x1E85},   // 'Ẅ' => 'ẅ'
	1575: {0x1E82, 0x1E83},   // 'Ẃ' => 'ẃ'
	1583: {0x1E80, 0x1E81},   // 'Ẁ' => 'ẁ'
	1591: {0x1E7E, 0x1E7F},   // 'Ṿ' => 'ṿ'
	1599: {0x1E7C, 0x1E7D},   // 'Ṽ' => 'ṽ'
	1607: {0x1E7A, 0x1E7B},   // 'Ṻ' => 'ṻ'
	1615: {0x1E78, 0x1E79},   // 'Ṹ' => 'ṹ'
	1623: {0x1E76, 0x1E77},   // 'Ṷ' => 'ṷ'
	1631: {0x1E74, 0x1E75},   // 'Ṵ' => 'ṵ'
	1639: {0x1E72, 0x1E73},   // 'Ṳ' => 'ṳ'
	1647: {0x1E70, 0x1E71},   // 'Ṱ' => 'ṱ'
	1655: {0x1E6E, 0x1E6F},   // 'Ṯ' => 'ṯ'
	1663: {0x1E6C, 0x1E6D},   // 'Ṭ' => 'ṭ'
	1671: {0x1E6A, 0x1E6B},   // 'Ṫ' => 'ṫ'
	1679: {0x1E68, 0x1E69},   // 'Ṩ' => 'ṩ'
	1687: {0x1E66, 0x1E67},   // 'Ṧ' => 'ṧ'
	1692: {0xA69A, 0xA69B},   // 'Ꚛ' => 'ꚛ'
	1695: {0x1E64, 0x1E65},   // 'Ṥ' => 'ṥ'
	1700: {0xA698, 0xA699},   // 'Ꚙ' => 'ꚙ'
	1703: {0x1E62, 0x1E63},   // 'Ṣ' => 'ṣ'
	1708: {0xA696, 0xA697},   // 'Ꚗ' => 'ꚗ'
	1711: {0x1E60, 0x1E61},   // 'Ṡ' => 'ṡ'
	1716: {0xA694, 0xA695},   // 'Ꚕ' => 'ꚕ'
	1719: {0x1E5E, 0x1E5F},   // 'Ṟ' => 'ṟ'
	1724: {0xA692, 0xA693},   // 'Ꚓ' => 'ꚓ'
	1727: {0x1E5C, 0x1E5D},   // 'Ṝ' => 'ṝ'
	1732: {0xA690, 0xA691},   // 'Ꚑ' => 'ꚑ'
	1735: {0x1E5A, 0x1E5B},   // 'Ṛ' => 'ṛ'
	1740: {0xA68E, 0xA68F},   // 'Ꚏ' => 'ꚏ'
	1743: {0x1E58, 0x1E59},   // 'Ṙ' => 'ṙ'
	1748: {0xA68C, 0xA68D},   // 'Ꚍ' => 'ꚍ'
	1751: {0x1E56, 0x1E57},   // 'Ṗ' => 'ṗ'
	1756: {0xA68A, 0xA68B},   // 'Ꚋ' => 'ꚋ'
	1759: {0x1E54, 0x1E55},   // 'Ṕ' => 'ṕ'
	1764: {0xA688, 0xA689},   // 'Ꚉ' => 'ꚉ'
	1767: {0x1E52, 0x1E53},   // 'Ṓ' => 'ṓ'
	1772: {0xA686, 0xA687},   // 'Ꚇ' => 'ꚇ'
	1775: {0x1E50, 0x1E51},   // 'Ṑ' => 'ṑ'
	1780: {0xA684, 0xA685},   // 'Ꚅ' => 'ꚅ'
	1783: {0x1E4E, 0x1E4F},   // 'Ṏ' => 'ṏ'
	1788: {0xA682, 0xA683},   // 'Ꚃ' => 'ꚃ'
	1791: {0x1E4C, 0x1E4D},   // 'Ṍ' => 'ṍ'
	1796: {0xA680, 0xA681},   // 'Ꚁ' => 'ꚁ'
	1799: {0x1E4A, 0x1E4B},   // 'Ṋ' => 'ṋ'
	1807: {0x1E48, 0x1E49},   // 'Ṉ' => 'ṉ'
	1815: {0x1E46, 0x1E47},   // 'Ṇ' => 'ṇ'
	1823: {0x1E44, 0x1E45},   // 'Ṅ' => 'ṅ'
	1831: {0x1E42, 0x1E43},   // 'Ṃ' => 'ṃ'
	1839: {0x1E40, 0x1E41},   // 'Ṁ' => 'ṁ'
	1847: {0x1E3E, 0x1E3F},   // 'Ḿ' => 'ḿ'
	1855: {0x1E3C, 0x1E3D},   // 'Ḽ' => 'ḽ'
	1863: {0x1E3A, 0x1E3B},   // 'Ḻ' => 'ḻ'
	1871: {0x1E38, 0x1E39},   // 'Ḹ' => 'ḹ'
	1876: {0xA66C, 0xA66D},   // 'Ꙭ' => 'ꙭ'
	1879: {0x1E36, 0x1E37},   // 'Ḷ' => 'ḷ'
	1884: {0xA66A, 0xA66B},   // 'Ꙫ' => 'ꙫ'
	1887: {0x1E34, 0x1E35},   // 'Ḵ' => 'ḵ'
	1892: {0xA668, 0xA669},   // 'Ꙩ' => 'ꙩ'
	1895: {0x1E32, 0x1E33},   // 'Ḳ' => 'ḳ'
	1900: {0xA666, 0xA667},   // 'Ꙧ' => 'ꙧ'
	1903: {0x1E30, 0x1E31},   // 'Ḱ' => 'ḱ'
	1908: {0xA664, 0xA665},   // 'Ꙥ' => 'ꙥ'
	1911: {0x1E2E, 0x1E2F},   // 'Ḯ' => 'ḯ'
	1916: {0xA662, 0xA663},   // 'Ꙣ' => 'ꙣ'
	1919: {0x1E2C, 0x1E2D},   // 'Ḭ' => 'ḭ'
	1924: {0xA660, 0xA661},   // 'Ꙡ' => 'ꙡ'
	1927: {0x1E2A, 0x1E2B},   // 'Ḫ' => 'ḫ'
	1932: {0xA65E, 0xA65F},   // 'Ꙟ' => 'ꙟ'
	1935: {0x1E28, 0x1E29},   // 'Ḩ' => 'ḩ'
	1940: {0xA65C, 0xA65D},   // 'Ꙝ' => 'ꙝ'
	1943: {0x1E26, 0x1E27},   // 'Ḧ' => 'ḧ'
	1948: {0xA65A, 0xA65B},   // 'Ꙛ' => 'ꙛ'
	1951: {0x1E24, 0x1E25},   // 'Ḥ' => 'ḥ'
	1956: {0xA658, 0xA659},   // 'Ꙙ' => 'ꙙ'
	1959: {0x1E22, 0x1E23},   // 'Ḣ' => 'ḣ'
	1964: {0xA656, 0xA657},   // 'Ꙗ' => 'ꙗ'
	1967: {0x1E20, 0x1E21},   // 'Ḡ' => 'ḡ'
	1972: {0xA654, 0xA655},   // 'Ꙕ' => 'ꙕ'
	1975: {0x1E1E, 0x1E1F},   // 'Ḟ' => 'ḟ'
	1980: {0xA652, 0xA653},   // 'Ꙓ' => 'ꙓ'
	1983: {0x1E1C, 0x1E1D},   // 'Ḝ' => 'ḝ'
	1988: {0xA650, 0xA651},   // 'Ꙑ' => 'ꙑ'
	1991: {0x1E1A, 0x1E1B},   // 'Ḛ' => 'ḛ'
	1996: {0xA64E, 0xA64F},   // 'Ꙏ' => 'ꙏ'
	1999: {0x1E18, 0x1E19},   // 'Ḙ' => 'ḙ'
	2004: {0xA64C, 0xA64D},   // 'Ꙍ' => 'ꙍ'
	2007: {0x1E16, 0x1E17},   // 'Ḗ' => 'ḗ'
	2012: {0xA64A, 0xA64B},   // 'Ꙋ' => 'ꙋ'
	2015: {0x1E14, 0x1E15},   // 'Ḕ' => 'ḕ'
	2020: {0xA648, 0xA649},   // 'Ꙉ' => 'ꙉ'
	2023: {0x1E12, 0x1E13},   // 'Ḓ' => 'ḓ'
	2028: {0xA646, 0xA647},   // 'Ꙇ' => 'ꙇ'
	2031: {0x1E10, 0x1E11},   // 'Ḑ' => 'ḑ'
	2036: {0xA644, 0xA645},   // 'Ꙅ' => 'ꙅ'
	2039: {0x1E0E, 0x1E0F},   // 'Ḏ' => 'ḏ'
	2044: {0xA642, 0xA643},   // 'Ꙃ' => 'ꙃ'
	2047: {0x1E0C, 0x1E0D},   // 'Ḍ' => 'ḍ'
	2052: {0xA640, 0xA641},   // 'Ꙁ' => 'ꙁ'
	2055: {0x1E0A, 0x1E0B},   // 'Ḋ' => 'ḋ'
	2063: {0x1E08, 0x1E09},   // 'Ḉ' => 'ḉ'
	2070: {0x1E06, 0x1E07},   // 'Ḇ' => 'ḇ'
	2078: {0x1E04, 0x1E05},   // 'Ḅ' => 'ḅ'
	2086: {0x1E02, 0x1E03},   // 'Ḃ' => 'ḃ'
	2094: {0x1E00, 0x1E01},   // 'Ḁ' => 'ḁ'
	2241: {0x16E5F, 0x16E7F}, // '𖹟' => '𖹿'
	2245: {0x16E5E, 0x16E7E}, // '𖹞' => '𖹾'
	2249: {0x16E5D, 0x16E7D}, // '𖹝' => '𖹽'
	2253: {0x16E5C, 0x16E7C}, // '𖹜' => '𖹼'
	2257: {0x16E5B, 0x16E7B}, // '𖹛' => '𖹻'
	2261: {0x16E5A, 0x16E7A}, // '𖹚' => '𖹺'
	2265: {0x16E59, 0x16E79}, // '𖹙' => '𖹹'
	2269: {0x16E58, 0x16E78}, // '𖹘' => '𖹸'
	2273: {0x16E57, 0x16E77}, // '𖹗' => '𖹷'
	2277: {0x16E56, 0x16E76}, // '𖹖' => '𖹶'
	2281: {0x16E55, 0x16E75}, // '𖹕' => '𖹵'
	2285: {0x16E54, 0x16E74}, // '𖹔' => '𖹴'
	2289: {0x16E53, 0x16E73}, // '𖹓' => '𖹳'
	2293: {0x16E52, 0x16E72}, // '𖹒' => '𖹲'
	2297: {0x16E51, 0x16E71}, // '𖹑' => '𖹱'
	2301: {0x16E50, 0x16E70}, // '𖹐' => '𖹰'
	2305: {0x16E4F, 0x16E6F}, // '𖹏' => '𖹯'
	2309: {0x16E4E, 0x16E6E}, // '𖹎' => '𖹮'
	2313: {0x16E4D, 0x16E6D}, // '𖹍' => '𖹭'
	2317: {0x16E4C, 0x16E6C}, // '𖹌' => '𖹬'
	2321: {0x16E4B, 0x16E6B}, // '𖹋' => '𖹫'
	2325: {0x16E4A, 0x16E6A}, // '𖹊' => '𖹪'
	2329: {0x16E49, 0x16E69}, // '𖹉' => '𖹩'
	2333: {0x16E48, 0x16E68}, // '𖹈' => '𖹨'
	2337: {0x16E47, 0x16E67}, // '𖹇' => '𖹧'
	2341: {0x16E46, 0x16E66}, // '𖹆' => '𖹦'
	2345: {0x16E45, 0x16E65}, // '𖹅' => '𖹥'
	2349: {0x16E44, 0x16E64}, // '𖹄' => '𖹤'
	2353: {0x16E43, 0x16E63}, // '𖹃' => '𖹣'
	2357: {0x16E42, 0x16E62}, // '𖹂' => '𖹢'
	2361: {0x16E41, 0x16E61}, // '𖹁' => '𖹡'
	2365: {0x16E40, 0x16E60}, // '𖹀' => '𖹠'
	2736: {0x0556, 0x0586},   // 'Ֆ' => 'ֆ'
	2740: {0x0555, 0x0585},   // 'Օ' => 'օ'
	2744: {0x0554, 0x0584},   // 'Ք' => 'ք'
	2748: {0x0553, 0x0583},   // 'Փ' => 'փ'
	2752: {0x0552, 0x0582},   // 'Ւ' => 'ւ'
	2756: {0x0551, 0x0581},   // 'Ց' => 'ց'
	2760: {0x0550, 0x0580},   // 'Ր' => 'ր'
	2764: {0x054F, 0x057F},   // 'Տ' => 'տ'
	2768: {0x054E, 0x057E},   // 'Վ' => 'վ'
	2772: {0x054D, 0x057D},   // 'Ս' => 'ս'
	2776: {0x054C, 0x057C},   // 'Ռ' => 'ռ'
	2780: {0x054B, 0x057B},   // 'Ջ' => 'ջ'
	2784: {0x054A, 0x057A},   // 'Պ' => 'պ'
	2788: {0x0549, 0x0579},   // 'Չ' => 'չ'
	2792: {0x0548, 0x0578},   // 'Ո' => 'ո'
	2796: {0x0547, 0x0577},   // 'Շ' => 'շ'
	2800: {0x0546, 0x0576},   // 'Ն' => 'ն'
	2804: {0x0545, 0x0575},   // 'Յ' => 'յ'
	2808: {0x0544, 0x0574},   // 'Մ' => 'մ'
	2812: {0x0543, 0x0573},   // 'Ճ' => 'ճ'
	2816: {0x0542, 0x0572},   // 'Ղ' => 'ղ'
	2820: {0x0541, 0x0571},   // 'Ձ' => 'ձ'
	2824: {0x0540, 0x0570},   // 'Հ' => 'հ'
	2828: {0x053F, 0x056F},   // 'Կ' => 'կ'
	2832: {0x053E, 0x056E},   // 'Ծ' => 'ծ'
	2836: {0x053D, 0x056D},   // 'Խ' => 'խ'
	2840: {0x053C, 0x056C},   // 'Լ' => 'լ'
	2844: {0x053B, 0x056B},   // 'Ի' => 'ի'
	2848: {0x053A, 0x056A},   // 'Ժ' => 'ժ'
	2852: {0x0539, 0x0569},   // 'Թ' => 'թ'
	2856: {0x0538, 0x0568},   // 'Ը' => 'ը'
	2860: {0x0537, 0x0567},   // 'Է' => 'է'
	2864: {0x0536, 0x0566},   // 'Զ' => 'զ'
	2868: {0x0535, 0x0565},   // 'Ե' => 'ե'
	2872: {0x0534, 0x0564},   // 'Դ' => 'դ'
	2876: {0x0533, 0x0563},   // 'Գ' => 'գ'
	2880: {0x0532, 0x0562},   // 'Բ' => 'բ'
	2884: {0x0531, 0x0561},   // 'Ա' => 'ա'
	2885: {0x10595, 0x105BC}, // '𐖕' => '𐖼'
	2889: {0x10594, 0x105BB}, // '𐖔' => '𐖻'
	2896: {0x052E, 0x052F},   // 'Ԯ' => 'ԯ'
	2897: {0x10592, 0x105B9}, // '𐖒' => '𐖹'
	2901: {0x10591, 0x105B8}, // '𐖑' => '𐖸'
	2904: {0x052C, 0x052D},   // 'Ԭ' => 'ԭ'
	2905: {0x10590, 0x105B7}, // '𐖐' => '𐖷'
	2909: {0x1058F, 0x105B6}, // '𐖏' => '𐖶'
	2912: {0x052A, 0x052B},   // 'Ԫ' => 'ԫ'
	2913: {0x1058E, 0x105B5}, // '𐖎' => '𐖵'
	2917: {0x1058D, 0x105B4}, // '𐖍' => '𐖴'
	2920: {0x0528, 0x0529},   // 'Ԩ' => 'ԩ'
	2921: {0x1058C, 0x105B3}, // '𐖌' => '𐖳'
	2928: {0x0526, 0x0527},   // 'Ԧ' => 'ԧ'
	2929: {0x1058A, 0x105B1}, // '𐖊' => '𐖱'
	2933: {0x10589, 0x105B0}, // '𐖉' => '𐖰'
	2936: {0x0524, 0x0525},   // 'Ԥ' => 'ԥ'
	2937: {0x10588, 0x105AF}, // '𐖈' => '𐖯'
	2941: {0x10587, 0x105AE}, // '𐖇' => '𐖮'
	2944: {0x0522, 0x0523},   // 'Ԣ' => 'ԣ'
	2945: {0x10586, 0x105AD}, // '𐖆' => '𐖭'
	2949: {0x10585, 0x105AC}, // '𐖅' => '𐖬'
	2952: {0x0520, 0x0521},   // 'Ԡ' => 'ԡ'
	2953: {0x10584, 0x105AB}, // '𐖄' => '𐖫'
	2957: {0x10583, 0x105AA}, // '𐖃' => '𐖪'
	2960: {0x051E, 0x051F},   // 'Ԟ' => 'ԟ'
	2961: {0x10582, 0x105A9}, // '𐖂' => '𐖩'
	2965: {0x10581, 0x105A8}, // '𐖁' => '𐖨'
	2967: {0x051C, 0x051D},   // 'Ԝ' => 'ԝ'
	2969: {0x10580, 0x105A7}, // '𐖀' => '𐖧'
	2973: {0x1057F, 0x105A6}, // '𐕿' => '𐖦'
	2975: {0x051A, 0x051B},   // 'Ԛ' => 'ԛ'
	2977: {0x1057E, 0x105A5}, // '𐕾' => '𐖥'
	2981: {0x1057D, 0x105A4}, // '𐕽' => '𐖤'
	2983: {0x0518, 0x0519},   // 'Ԙ' => 'ԙ'
	2985: {0x1057C, 0x105A3}, // '𐕼' => '𐖣'
	2991: {0x0516, 0x0517},   // 'Ԗ' => 'ԗ'
	2993: {0x1057A, 0x105A1}, // '𐕺' => '𐖡'
	2997: {0x10579, 0x105A0}, // '𐕹' => '𐖠'
	2999: {0x0514, 0x0515},   // 'Ԕ' => 'ԕ'
	3001: {0x10578, 0x1059F}, // '𐕸' => '𐖟'
	3005: {0x10577, 0x1059E}, // '𐕷' => '𐖞'
	3007: {0x0512, 0x0513},   // 'Ԓ' => 'ԓ'
	3009: {0x10576, 0x1059D}, // '𐕶' => '𐖝'
	3013: {0x10575, 0x1059C}, // '𐕵' => '𐖜'
	3015: {0x0510, 0x0511},   // 'Ԑ' => 'ԑ'
	3017: {0x10574, 0x1059B}, // '𐕴' => '𐖛'
	3021: {0x10573, 0x1059A}, // '𐕳' => '𐖚'
	3023: {0x050E, 0x050F},   // 'Ԏ' => 'ԏ'
	3025: {0x10572, 0x10599}, // '𐕲' => '𐖙'
	3029: {0x10571, 0x10598}, // '𐕱' => '𐖘'
	3031: {0x050C, 0x050D},   // 'Ԍ' => 'ԍ'
	3033: {0x10570, 0x10597}, // '𐕰' => '𐖗'
	3039: {0x050A, 0x050B},   // 'Ԋ' => 'ԋ'
	3047: {0x0508, 0x0509},   // 'Ԉ' => 'ԉ'
	3055: {0x0506, 0x0507},   // 'Ԇ' => 'ԇ'
	3063: {0x0504, 0x0505},   // 'Ԅ' => 'ԅ'
	3071: {0x0502, 0x0503},   // 'Ԃ' => 'ԃ'
	3079: {0x0500, 0x0501},   // 'Ԁ' => 'ԁ'
	3087: {0x04FE, 0x04FF},   // 'Ӿ' => 'ӿ'
	3095: {0x04FC, 0x04FD},   // 'Ӽ' => 'ӽ'
	3103: {0x04FA, 0x04FB},   // 'Ӻ' => 'ӻ'
	3111: {0x04F8, 0x04F9},   // 'Ӹ' => 'ӹ'
	3119: {0x04F6, 0x04F7},   // 'Ӷ' => 'ӷ'
	3127: {0x04F4, 0x04F5},   // 'Ӵ' => 'ӵ'
	3135: {0x04F2, 0x04F3},   // 'Ӳ' => 'ӳ'
	3143: {0x04F0, 0x04F1},   // 'Ӱ' => 'ӱ'
	3151: {0x04EE, 0x04EF},   // 'Ӯ' => 'ӯ'
	3159: {0x04EC, 0x04ED},   // 'Ӭ' => 'ӭ'
	3167: {0x04EA, 0x04EB},   // 'Ӫ' => 'ӫ'
	3175: {0x04E8, 0x04E9},   // 'Ө' => 'ө'
	3183: {0x04E6, 0x04E7},   // 'Ӧ' => 'ӧ'
	3191: {0x04E4, 0x04E5},   // 'Ӥ' => 'ӥ'
	3198: {0x2CF2, 0x2CF3},   // 'Ⳳ' => 'ⳳ'
	3199: {0x04E2, 0x04E3},   // 'Ӣ' => 'ӣ'
	3207: {0x04E0, 0x04E1},   // 'Ӡ' => 'ӡ'
	3215: {0x04DE, 0x04DF},   // 'Ӟ' => 'ӟ'
	3218: {0x2CED, 0x2CEE},   // 'Ⳮ' => 'ⳮ'
	3223: {0x04DC, 0x04DD},   // 'Ӝ' => 'ӝ'
	3226: {0x2CEB, 0x2CEC},   // 'Ⳬ' => 'ⳬ'
	3231: {0x04DA, 0x04DB},   // 'Ӛ' => 'ӛ'
	3239: {0x04D8, 0x04D9},   // 'Ә' => 'ә'
	3247: {0x04D6, 0x04D7},   // 'Ӗ' => 'ӗ'
	3255: {0x04D4, 0x04D5},   // 'Ӕ' => 'ӕ'
	3262: {0x2CE2, 0x2CE3},   // 'Ⳣ' => 'ⳣ'
	3263: {0x04D2, 0x04D3},   // 'Ӓ' => 'ӓ'
	3270: {0x2CE0, 0x2CE1},   // 'Ⳡ' => 'ⳡ'
	3271: {0x04D0, 0x04D1},   // 'Ӑ' => 'ӑ'
	3278: {0x2CDE, 0x2CDF},   // 'Ⳟ' => 'ⳟ'
	3283: {0x04CD, 0x04CE},   // 'Ӎ' => 'ӎ'
	3286: {0x2CDC, 0x2CDD},   // 'Ⳝ' => 'ⳝ'
	3291: {0x04CB, 0x04CC},   // 'Ӌ' => 'ӌ'
	3294: {0x2CDA, 0x2CDB},   // 'Ⳛ' => 'ⳛ'
	3299: {0x04C9, 0x04CA},   // 'Ӊ' => 'ӊ'
	3302: {0x2CD8, 0x2CD9},   // 'Ⳙ' => 'ⳙ'
	3307: {0x04C7, 0x04C8},   // 'Ӈ' => 'ӈ'
	3310: {0x2CD6, 0x2CD7},   // 'Ⳗ' => 'ⳗ'
	3315: {0x04C5, 0x04C6},   // 'Ӆ' => 'ӆ'
	3318: {0x2CD4, 0x2CD5},   // 'Ⳕ' => 'ⳕ'
	3323: {0x04C3, 0x04C4},   // 'Ӄ' => 'ӄ'
	3325: {0x24CF, 0x24E9},   // 'Ⓩ' => 'ⓩ'
	3326: {0x2CD2, 0x2CD3},   // 'Ⳓ' => 'ⳓ'
	3329: {0x24CE, 0x24E8},   // 'Ⓨ' => 'ⓨ'
	3331: {0x04C1, 0x04C2},   // 'Ӂ' => 'ӂ'
	3333: {0x24CD, 0x24E7},   // 'Ⓧ' => 'ⓧ'
	3334: {0x2CD0, 0x2CD1},   // 'Ⳑ' => 'ⳑ'
	3335: {0x04C0, 0x04CF},   // 'Ӏ' => 'ӏ'
	3337: {0x24CC, 0x24E6},   // 'Ⓦ' => 'ⓦ'
	3341: {0x24CB, 0x24E5},   // 'Ⓥ' => 'ⓥ'
	3342: {0x2CCE, 0x2CCF},   // 'Ⳏ' => 'ⳏ'
	3343: {0x04BE, 0x04BF},   // 'Ҿ' => 'ҿ'
	3345: {0x24CA, 0x24E4},   // 'Ⓤ' => 'ⓤ'
	3349: {0x24C9, 0x24E3},   // 'Ⓣ' => 'ⓣ'
	3350: {0x2CCC, 0x2CCD},   // 'Ⳍ' => 'ⳍ'
	3351: {0x04BC, 0x04BD},   // 'Ҽ' => 'ҽ'
	3353: {0x24C8, 0x24E2},   // 'Ⓢ' => 'ⓢ'
	3357: {0x24C7, 0x24E1},   // 'Ⓡ' => 'ⓡ'
	3358: {0x2CCA, 0x2CCB},   // 'Ⳋ' => 'ⳋ'
	3359: {0x04BA, 0x04BB},   // 'Һ' => 'һ'
	3361: {0x24C6, 0x24E0},   // 'Ⓠ' => 'ⓠ'
	3365: {0x24C5, 0x24DF},   // 'Ⓟ' => 'ⓟ'
	3366: {0x2CC8, 0x2CC9},   // 'Ⳉ' => 'ⳉ'
	3367: {0x04B8, 0x04B9},   // 'Ҹ' => 'ҹ'
	3369: {0x24C4, 0x24DE},   // 'Ⓞ' => 'ⓞ'
	3373: {0x24C3, 0x24DD},   // 'Ⓝ' => 'ⓝ'
	3374: {0x2CC6, 0x2CC7},   // 'Ⳇ' => 'ⳇ'
	3375: {0x04B6, 0x04B7},   // 'Ҷ' => 'ҷ'
	3376: {0x1CBF, 0x10FF},   // 'Ჿ' => 'ჿ'
	3377: {0x24C2, 0x24DC},   // 'Ⓜ' => 'ⓜ'
	3380: {0x1CBE, 0x10FE},   // 'Ჾ' => 'ჾ'
	3381: {0x24C1, 0x24DB},   // 'Ⓛ' => 'ⓛ'
	3382: {0x2CC4, 0x2CC5},   // 'Ⳅ' => 'ⳅ'
	3383: {0x04B4, 0x04B5},   // 'Ҵ' => 'ҵ'
	3384: {0x1CBD, 0x10FD},   // 'Ჽ' => 'ჽ'
	3385: {0x24C0, 0x24DA},   // 'Ⓚ' => 'ⓚ'
	3389: {0x24BF, 0x24D9},   // 'Ⓙ' => 'ⓙ'
	3390: {0x2CC2, 0x2CC3},   // 'Ⳃ' => 'ⳃ'
	3391: {0x04B2, 0x04B3},   // 'Ҳ' => 'ҳ'
	3393: {0x24BE, 0x24D8},   // 'Ⓘ' => 'ⓘ'
	3396: {0x1CBA, 0x10FA},   // 'Ჺ' => 'ჺ'
	3397: {0x24BD, 0x24D7},   // 'Ⓗ' => 'ⓗ'
	3398: {0x2CC0, 0x2CC1},   // 'Ⳁ' => 'ⳁ'
	3399: {0x04B0, 0x04B1},   // 'Ұ' => 'ұ'
	3400: {0x1CB9, 0x10F9},   // 'Ჹ' => 'ჹ'
	3401: {0x24BC, 0x24D6},   // 'Ⓖ' => 'ⓖ'
	3404: {0x1CB8, 0x10F8},   // 'Ჸ' => 'ჸ'
	3405: {0x24BB, 0x24D5},   // 'Ⓕ' => 'ⓕ'
	3406: {0x2CBE, 0x2CBF},   // 'Ⲿ' => 'ⲿ'
	3407: {0x04AE, 0x04AF},   // 'Ү' => 'ү'
	3408: {0x1CB7, 0x10F7},   // 'Ჷ' => 'ჷ'
	3409: {0x24BA, 0x24D4},   // 'Ⓔ' => 'ⓔ'
	3412: {0x1CB6, 0x10F6},   // 'Ჶ' => 'ჶ'
	3413: {0x24B9, 0x24D3},   // 'Ⓓ' => 'ⓓ'
	3414: {0x2CBC, 0x2CBD},   // 'Ⲽ' => 'ⲽ'
	3415: {0x04AC, 0x04AD},   // 'Ҭ' => 'ҭ'
	3416: {0x1CB5, 0x10F5},   // 'Ჵ' => 'ჵ'
	3417: {0x24B8, 0x24D2},   // 'Ⓒ' => 'ⓒ'
	3420: {0x1CB4, 0x10F4},   // 'Ჴ' => 'ჴ'
	3421: {0x24B7, 0x24D1},   // 'Ⓑ' => 'ⓑ'
	3422: {0x2CBA, 0x2CBB},   // 'Ⲻ' => 'ⲻ'
	3423: {0x04AA, 0x04AB},   // 'Ҫ' => 'ҫ'
	3424: {0x1CB3, 0x10F3},   // 'Ჳ' => 'ჳ'
	3425: {0x24B6, 0x24D0},   // 'Ⓐ' => 'ⓐ'
	3428: {0x1CB2, 0x10F2},   // 'Ჲ' => 'ჲ'
	3430: {0x2CB8, 0x2CB9},   // 'Ⲹ' => 'ⲹ'
	3431: {0x04A8, 0x04A9},   // 'Ҩ' => 'ҩ'
	3432: {0x1CB1, 0x10F1},   // 'Ჱ' => 'ჱ'
	3436: {0x1CB0, 0x10F0},   // 'Ჰ' => 'ჰ'
	3437: {0x2CB6, 0x2CB7},   // 'Ⲷ' => 'ⲷ'
	3439: {0x04A6, 0x04A7},   // 'Ҧ' => 'ҧ'
	3440: {0x1CAF, 0x10EF},   // 'Ჯ' => 'ჯ'
	3444: {0x1CAE, 0x10EE},   // 'Ხ' => 'ხ'
	3445: {0x2CB4, 0x2CB5},   // 'Ⲵ' => 'ⲵ'
	3447: {0x04A4, 0x04A5},   // 'Ҥ' => 'ҥ'
	3448: {0x1CAD, 0x10ED},   // 'Ჭ' => 'ჭ'
	3452: {0x1CAC, 0x10EC},   // 'Წ' => 'წ'
	3453: {0x2CB2, 0x2CB3},   // 'Ⲳ' => 'ⲳ'
	3455: {0x04A2, 0x04A3},   // 'Ң' => 'ң'
	3456: {0x1CAB, 0x10EB},   // 'Ძ' => 'ძ'
	3460: {0x1CAA, 0x10EA},   // 'Ც' => 'ც'
	3461: {0x2CB0, 0x2CB1},   // 'Ⲱ' => 'ⲱ'
	3463: {0x04A0, 0x04A1},   // 'Ҡ' => 'ҡ'
	3464: {0x1CA9, 0x10E9},   // 'Ჩ' => 'ჩ'
	3468: {0x1CA8, 0x10E8},   // 'Შ' => 'შ'
	3469: {0x2CAE, 0x2CAF},   // 'Ⲯ' => 'ⲯ'
	3471: {0x049E, 0x049F},   // 'Ҟ' => 'ҟ'
	3472: {0x1CA7, 0x10E7},   // 'Ყ' => 'ყ'
	3476: {0x1CA6, 0x10E6},   // 'Ღ' => 'ღ'
	3477: {0x2CAC, 0x2CAD},   // 'Ⲭ' => 'ⲭ'
	3479: {0x049C, 0x049D},   // 'Ҝ' => 'ҝ'
	3480: {0x1CA5, 0x10E5},   // 'Ქ' => 'ქ'
	3484: {0x1CA4, 0x10E4},   // 'Ფ' => 'ფ'
	3485: {0x2CAA, 0x2CAB},   // 'Ⲫ' => 'ⲫ'
	3487: {0x049A, 0x049B},   // 'Қ' => 'қ'
	3488: {0x1CA3, 0x10E3},   // 'Უ' => 'უ'
	3492: {0x1CA2, 0x10E2},   // 'Ტ' => 'ტ'
	3493: {0x2CA8, 0x2CA9},   // 'Ⲩ' => 'ⲩ'
	3495: {0x0498, 0x0499},   // 'Ҙ' => 'ҙ'
	3496: {0x1CA1, 0x10E1},   // 'Ს' => 'ს'
	3500: {0x1CA0, 0x10E0},   // 'Რ' => 'რ'
	3501: {0x2CA6, 0x2CA7},   // 'Ⲧ' => 'ⲧ'
	3503: {0x0496, 0x0497},   // 'Җ' => 'җ'
	3504: {0x1C9F, 0x10DF},   // 'Ჟ' => 'ჟ'
	3508: {0x1C9E, 0x10DE},   // 'Პ' => 'პ'
	3509: {0x2CA4, 0x2CA5},   // 'Ⲥ' => 'ⲥ'
	3511: {0x0494, 0x0495},   // 'Ҕ' => 'ҕ'
	3512: {0x1C9D, 0x10DD},   // 'Ო' => 'ო'
	3516: {0x1C9C, 0x10DC},   // 'Ნ' => 'ნ'
	3517: {0x2CA2, 0x2CA3},   // 'Ⲣ' => 'ⲣ'
	3519: {0x0492, 0x0493},   // 'Ғ' => 'ғ'
	3520: {0x1C9B, 0x10DB},   // 'Მ' => 'მ'
	3524: {0x1C9A, 0x10DA},   // 'Ლ' => 'ლ'
	3525: {0x2CA0, 0x2CA1},   // 'Ⲡ' => 'ⲡ'
	3527: {0x0490, 0x0491},   // 'Ґ' => 'ґ'
	3528: {0x1C99, 0x10D9},   // 'Კ' => 'კ'
	3532: {0x1C98, 0x10D8},   // 'Ი' => 'ი'
	3533: {0x2C9E, 0x2C9F},   // 'Ⲟ' => 'ⲟ'
	3535: {0x048E, 0x048F},   // 'Ҏ' => 'ҏ'
	3536: {0x1C97, 0x10D7},   // 'Თ' => 'თ'
	3540: {0x1C96, 0x10D6},   // 'Ზ' => 'ზ'
	3541: {0x2C9C, 0x2C9D},   // 'Ⲝ' => 'ⲝ'
	3543: {0x048C, 0x048D},   // 'Ҍ' => 'ҍ'
	3544: {0x1C95, 0x10D5},   // 'Ვ' => 'ვ'
	3548: {0x1C94, 0x10D4},   // 'Ე' => 'ე'
	3549: {0x2C9A, 0x2C9B},   // 'Ⲛ' => 'ⲛ'
	3551: {0x048A, 0x048B},   // 'Ҋ' => 'ҋ'
	3552: {0x1C93, 0x10D3},   // 'Დ' => 'დ'
	3556: {0x1C92, 0x10D2},   // 'Გ' => 'გ'
	3557: {0x2C98, 0x2C99},   // 'Ⲙ' => 'ⲙ'
	3560: {0x1C91, 0x10D1},   // 'Ბ' => 'ბ'
	3564: {0x1C90, 0x10D0},   // 'Ა' => 'ა'
	3565: {0x2C96, 0x2C97},   // 'Ⲗ' => 'ⲗ'
	3573: {0x2C94, 0x2C95},   // 'Ⲕ' => 'ⲕ'
	3581: {0x2C92, 0x2C93},   // 'Ⲓ' => 'ⲓ'
	3589: {0x2C90, 0x2C91},   // 'Ⲑ' => 'ⲑ'
	3591: {0x0480, 0x0481},   // 'Ҁ' => 'ҁ'
	3596: {0x1C88, 0xA64B},   // 'ᲈ' => 'ꙋ'
	3597: {0x2C8E, 0x2C8F},   // 'Ⲏ' => 'ⲏ'
	3599: {0x047E, 0x047F},   // 'Ѿ' => 'ѿ'
	3600: {0x1C87, 0x0463},   // 'ᲇ' => 'ѣ'
	3604: {0x1C86, 0x044A},   // 'ᲆ' => 'ъ'
	3605: {0x2C8C, 0x2C8D},   // 'Ⲍ' => 'ⲍ'
	3607: {0x047C, 0x047D},   // 'Ѽ' => 'ѽ'
	3608: {0x1C85, 0x0442},   // 'ᲅ' => 'т'
	3612: {0x1C84, 0x0442},   // 'ᲄ' => 'т'
	3613: {0x2C8A, 0x2C8B},   // 'Ⲋ' => 'ⲋ'
	3615: {0x047A, 0x047B},   // 'Ѻ' => 'ѻ'
	3616: {0x1C83, 0x0441},   // 'ᲃ' => 'с'
	3620: {0x1C82, 0x043E},   // 'ᲂ' => 'о'
	3621: {0x2C88, 0x2C89},   // 'Ⲉ' => 'ⲉ'
	3622: {0x0478, 0x0479},   // 'Ѹ' => 'ѹ'
	3624: {0x1C81, 0x0434},   // 'ᲁ' => 'д'
	3628: {0x1C80, 0x0432},   // 'ᲀ' => 'в'
	3629: {0x2C86, 0x2C87},   // 'Ⲇ' => 'ⲇ'
	3630: {0x0476, 0x0477},   // 'Ѷ' => 'ѷ'
	3637: {0x2C84, 0x2C85},   // 'Ⲅ' => 'ⲅ'
	3638: {0x0474, 0x0475},   // 'Ѵ' => 'ѵ'
	3645: {0x2C82, 0x2C83},   // 'Ⲃ' => 'ⲃ'
	3646: {0x0472, 0x0473},   // 'Ѳ' => 'ѳ'
	3653: {0x2C80, 0x2C81},   // 'Ⲁ' => 'ⲁ'
	3654: {0x0470, 0x0471},   // 'Ѱ' => 'ѱ'
	3657: {0x2C7F, 0x0240},   // 'Ɀ' => 'ɀ'
	3660: {0x104D3, 0x104FB}, // '𐓓' => '𐓻'
	3661: {0x2C7E, 0x023F},   // 'Ȿ' => 'ȿ'
	3662: {0x046E, 0x046F},   // 'Ѯ' => 'ѯ'
	3664: {0x104D2, 0x104FA}, // '𐓒' => '𐓺'
	3668: {0x104D1, 0x104F9}, // '𐓑' => '𐓹'
	3670: {0x046C, 0x046D},   // 'Ѭ' => 'ѭ'
	3672: {0x104D0, 0x104F8}, // '𐓐' => '𐓸'
	3676: {0x104CF, 0x104F7}, // '𐓏' => '𐓷'
	3678: {0x046A, 0x046B},   // 'Ѫ' => 'ѫ'
	3680: {0x104CE, 0x104F6}, // '𐓎' => '𐓶'
	3684: {0x104CD, 0x104F5}, // '𐓍' => '𐓵'
	3686: {0x0468, 0x0469},   // 'Ѩ' => 'ѩ'
	3688: {0x104CC, 0x104F4}, // '𐓌' => '𐓴'
	3692: {0x104CB, 0x104F3}, // '𐓋' => '𐓳'
	3694: {0x0466, 0x0467},   // 'Ѧ' => 'ѧ'
	3696: {0x104CA, 0x104F2}, // '𐓊' => '𐓲'
	3697: {0x2C75, 0x2C76},   // 'Ⱶ' => 'ⱶ'
	3700: {0x104C9, 0x104F1}, // '𐓉' => '𐓱'
	3702: {0x0464, 0x0465},   // 'Ѥ' => 'ѥ'
	3704: {0x104C8, 0x104F0}, // '𐓈' => '𐓰'
	3708: {0x104C7, 0x104EF}, // '𐓇' => '𐓯'
	3709: {0x2C72, 0x2C73},   // 'Ⱳ' => 'ⱳ'
	3710: {0x0462, 0x0463},   // 'Ѣ' => 'ѣ'
	3712: {0x104C6, 0x104EE}, // '𐓆' => '𐓮'
	3716: {0x104C5, 0x104ED}, // '𐓅' => '𐓭'
	3717: {0x2C70, 0x0252},   // 'Ɒ' => 'ɒ'
	3718: {0x0460, 0x0461},   // 'Ѡ' => 'ѡ'
	3720: {0x104C4, 0x104EC}, // '𐓄' => '𐓬'
	3721: {0x2C6F, 0x0250},   // 'Ɐ' => 'ɐ'
	3724: {0x104C3, 0x104EB}, // '𐓃' => '𐓫'
	3725: {0x2C6E, 0x0271},   // 'Ɱ' => 'ɱ'
	3728: {0x104C2, 0x104EA}, // '𐓂' => '𐓪'
	3729: {0x2C6D, 0x0251},   // 'Ɑ' => 'ɑ'
	3732: {0x104C1, 0x104E9}, // '𐓁' => '𐓩'
	3736: {0x104C0, 0x104E8}, // '𐓀' => '𐓨'
	3737: {0x2C6B, 0x2C6C},   // 'Ⱬ' => 'ⱬ'
	3740: {0x104BF, 0x104E7}, // '𐒿' => '𐓧'
	3744: {0x104BE, 0x104E6}, // '𐒾' => '𐓦'
	3745: {0x2C69, 0x2C6A},   // 'Ⱪ' => 'ⱪ'
	3748: {0x104BD, 0x104E5}, // '𐒽' => '𐓥'
	3752: {0x104BC, 0x104E4}, // '𐒼' => '𐓤'
	3753: {0x2C67, 0x2C68},   // 'Ⱨ' => 'ⱨ'
	3756: {0x104BB, 0x104E3}, // '𐒻' => '𐓣'
	3760: {0x104BA, 0x104E2}, // '𐒺' => '𐓢'
	3764: {0x104B9, 0x104E1}, // '𐒹' => '𐓡'
	3765: {0x2C64, 0x027D},   // 'Ɽ' => 'ɽ'
	3768: {0x104B8, 0x104E0}, // '𐒸' => '𐓠'
	3769: {0x2C63, 0x1D7D},   // 'Ᵽ' => 'ᵽ'
	3772: {0x104B7, 0x104DF}, // '𐒷' => '𐓟'
	3773: {0x2C62, 0x026B},   // 'Ɫ' => 'ɫ'
	3776: {0x104B6, 0x104DE}, // '𐒶' => '𐓞'
	3780: {0x104B5, 0x104DD}, // '𐒵' => '𐓝'
	3781: {0x2C60, 0x2C61},   // 'Ⱡ' => 'ⱡ'
	3784: {0x104B4, 0x104DC}, // '𐒴' => '𐓜'
	3788: {0x104B3, 0x104DB}, // '𐒳' => '𐓛'
	3792: {0x104B2, 0x104DA}, // '𐒲' => '𐓚'
	3796: {0x104B1, 0x104D9}, // '𐒱' => '𐓙'
	3800: {0x104B0, 0x104D8}, // '𐒰' => '𐓘'
	3804: {0x10CB2, 0x10CF2}, // '𐲲' => '𐳲'
	3808: {0x10CB1, 0x10CF1}, // '𐲱' => '𐳱'
	3812: {0x10CB0, 0x10CF0}, // '𐲰' => '𐳰'
	3816: {0x10CAF, 0x10CEF}, // '𐲯' => '𐳯'
	3820: {0x10CAE, 0x10CEE}, // '𐲮' => '𐳮'
	3824: {0x10CAD, 0x10CED}, // '𐲭' => '𐳭'
	3828: {0x10CAC, 0x10CEC}, // '𐲬' => '𐳬'
	3832: {0x10CAB, 0x10CEB}, // '𐲫' => '𐳫'
	3836: {0x10CAA, 0x10CEA}, // '𐲪' => '𐳪'
	3840: {0x10CA9, 0x10CE9}, // '𐲩' => '𐳩'
	3844: {0x10CA8, 0x10CE8}, // '𐲨' => '𐳨'
	3848: {0x10CA7, 0x10CE7}, // '𐲧' => '𐳧'
	3852: {0x10CA6, 0x10CE6}, // '𐲦' => '𐳦'
	3856: {0x10CA5, 0x10CE5}, // '𐲥' => '𐳥'
	3860: {0x10CA4, 0x10CE4}, // '𐲤' => '𐳤'
	3864: {0x10CA3, 0x10CE3}, // '𐲣' => '𐳣'
	3868: {0x10CA2, 0x10CE2}, // '𐲢' => '𐳢'
	3872: {0x10CA1, 0x10CE1}, // '𐲡' => '𐳡'
	3876: {0x10CA0, 0x10CE0}, // '𐲠' => '𐳠'
	3880: {0x10C9F, 0x10CDF}, // '𐲟' => '𐳟'
	3884: {0x10C9E, 0x10CDE}, // '𐲞' => '𐳞'
	3888: {0x10C9D, 0x10CDD}, // '𐲝' => '𐳝'
	3892: {0x10C9C, 0x10CDC}, // '𐲜' => '𐳜'
	3896: {0x10C9B, 0x10CDB}, // '𐲛' => '𐳛'
	3900: {0x10C9A, 0x10CDA}, // '𐲚' => '𐳚'
	3904: {0x10C99, 0x10CD9}, // '𐲙' => '𐳙'
	3908: {0x10C98, 0x10CD8}, // '𐲘' => '𐳘'
	3912: {0x10C97, 0x10CD7}, // '𐲗' => '𐳗'
	3914: {0x042F, 0x044F},   // 'Я' => 'я'
	3916: {0x10C96, 0x10CD6}, // '𐲖' => '𐳖'
	3918: {0x042E, 0x044E},   // 'Ю' => 'ю'
	3920: {0x10C95, 0x10CD5}, // '𐲕' => '𐳕'
	3922: {0x042D, 0x044D},   // 'Э' => 'э'
	3924: {0x10C94, 0x10CD4}, // '𐲔' => '𐳔'
	3926: {0x042C, 0x044C},   // 'Ь' => 'ь'
	3928: {0x10C93, 0x10CD3}, // '𐲓' => '𐳓'
	3930: {0x042B, 0x044B},   // 'Ы' => 'ы'
	3932: {0x10C92, 0x10CD2}, // '𐲒' => '𐳒'
	3934: {0x042A, 0x044A},   // 'Ъ' => 'ъ'
	3936: {0x10C91, 0x10CD1}, // '𐲑' => '𐳑'
	3938: {0x0429, 0x0449},   // 'Щ' => 'щ'
	3940: {0x10C90, 0x10CD0}, // '𐲐' => '𐳐'
	3942: {0x0428, 0x0448},   // 'Ш' => 'ш'
	3944: {0x10C8F, 0x10CCF}, // '𐲏' => '𐳏'
	3946: {0x0427, 0x0447},   // 'Ч' => 'ч'
	3948: {0x10C8E, 0x10CCE}, // '𐲎' => '𐳎'
	3950: {0x0426, 0x0446},   // 'Ц' => 'ц'
	3952: {0x10C8D, 0x10CCD}, // '𐲍' => '𐳍'
	3954: {0x0425, 0x0445},   // 'Х' => 'х'
	3956: {0x10C8C, 0x10CCC}, // '𐲌' => '𐳌'
	3958: {0x0424, 0x0444},   // 'Ф' => 'ф'
	3960: {0x10C8B, 0x10CCB}, // '𐲋' => '𐳋'
	3962: {0x0423, 0x0443},   // 'У' => 'у'
	3964: {0x10C8A, 0x10CCA}, // '𐲊' => '𐳊'
	3966: {0x0422, 0x0442},   // 'Т' => 'т'
	3968: {0x10C89, 0x10CC9}, // '𐲉' => '𐳉'
	3970: {0x0421, 0x0441},   // 'С' => 'с'
	3972: {0x10C88, 0x10CC8}, // '𐲈' => '𐳈'
	3974: {0x0420, 0x0440},   // 'Р' => 'р'
	3976: {0x10C87, 0x10CC7}, // '𐲇' => '𐳇'
	3977: {0x2C2F, 0x2C5F},   // 'Ⱟ' => 'ⱟ'
	3978: {0x041F, 0x043F},   // 'П' => 'п'
	3980: {0x10C86, 0x10CC6}, // '𐲆' => '𐳆'
	3981: {0x2C2E, 0x2C5E},   // 'Ⱞ' => 'ⱞ'
	3982: {0x041E, 0x043E},   // 'О' => 'о'
	3984: {0x10C85, 0x10CC5}, // '𐲅' => '𐳅'
	3985: {0x2C2D, 0x2C5D},   // 'Ⱝ' => 'ⱝ'
	3986: {0x041D, 0x043D},   // 'Н' => 'н'
	3988: {0x10C84, 0x10CC4}, // '𐲄' => '𐳄'
	3989: {0x2C2C, 0x2C5C},   // 'Ⱜ' => 'ⱜ'
	3990: {0x041C, 0x043C},   // 'М' => 'м'
	3992: {0x10C83, 0x10CC3}, // '𐲃' => '𐳃'
	3993: {0x2C2B, 0x2C5B},   // 'Ⱛ' => 'ⱛ'
	3994: {0x041B, 0x043B},   // 'Л' => 'л'
	3996: {0x10C82, 0x10CC2}, // '𐲂' => '𐳂'
	3997: {0x2C2A, 0x2C5A},   // 'Ⱚ' => 'ⱚ'
	3998: {0x041A, 0x043A},   // 'К' => 'к'
	4000: {0x10C81, 0x10CC1}, // '𐲁' => '𐳁'
	4001: {0x2C29, 0x2C59},   // 'Ⱙ' => 'ⱙ'
	4002: {0x0419, 0x0439},   // 'Й' => 'й'
	4004: {0x10C80, 0x10CC0}, // '𐲀' => '𐳀'
	4005: {0x2C28, 0x2C58},   // 'Ⱘ' => 'ⱘ'
	4006: {0x0418, 0x0438},   // 'И' => 'и'
	4009: {0x2C27, 0x2C57},   // 'Ⱗ' => 'ⱗ'
	4010: {0x0417, 0x0437},   // 'З' => 'з'
	4013: {0x2C26, 0x2C56},   // 'Ⱖ' => 'ⱖ'
	4014: {0x0416, 0x0436},   // 'Ж' => 'ж'
	4017: {0x2C25, 0x2C55},   // 'Ⱕ' => 'ⱕ'
	4018: {0x0415, 0x0435},   // 'Е' => 'е'
	4021: {0x2C24, 0x2C54},   // 'Ⱔ' => 'ⱔ'
	4022: {0x0414, 0x0434},   // 'Д' => 'д'
	4025: {0x2C23, 0x2C53},   // 'Ⱓ' => 'ⱓ'
	4026: {0x0413, 0x0433},   // 'Г' => 'г'
	4029: {0x2C22, 0x2C52},   // 'Ⱒ' => 'ⱒ'
	4030: {0x0412, 0x0432},   // 'В' => 'в'
	4033: {0x2C21, 0x2C51},   // 'Ⱑ' => 'ⱑ'
	4034: {0x0411, 0x0431},   // 'Б' => 'б'
	4037: {0x2C20, 0x2C50},   // 'Ⱐ' => 'ⱐ'
	4038: {0x0410, 0x0430},   // 'А' => 'а'
	4041: {0x2C1F, 0x2C4F},   // 'Ⱏ' => 'ⱏ'
	4042: {0x040F, 0x045F},   // 'Џ' => 'џ'
	4045: {0x2C1E, 0x2C4E},   // 'Ⱎ' => 'ⱎ'
	4046: {0x040E, 0x045E},   // 'Ў' => 'ў'
	4049: {0x2C1D, 0x2C4D},   // 'Ⱍ' => 'ⱍ'
	4050: {0x040D, 0x045D},   // 'Ѝ' => 'ѝ'
	4053: {0x2C1C, 0x2C4C},   // 'Ⱌ' => 'ⱌ'
	4054: {0x040C, 0x045C},   // 'Ќ' => 'ќ'
	4057: {0x2C1B, 0x2C4B},   // 'Ⱋ' => 'ⱋ'
	4058: {0x040B, 0x045B},   // 'Ћ' => 'ћ'
	4061: {0x2C1A, 0x2C4A},   // 'Ⱊ' => 'ⱊ'
	4062: {0x040A, 0x045A},   // 'Њ' => 'њ'
	4065: {0x2C19, 0x2C49},   // 'Ⱉ' => 'ⱉ'
	4066: {0x0409, 0x0459},   // 'Љ' => 'љ'
	4069: {0x2C18, 0x2C48},   // 'Ⱈ' => 'ⱈ'
	4070: {0x0408, 0x0458},   // 'Ј' => 'ј'
	4073: {0x2C17, 0x2C47},   // 'Ⱇ' => 'ⱇ'
	4074: {0x0407, 0x0457},   // 'Ї' => 'ї'
	4077: {0x2C16, 0x2C46},   // 'Ⱆ' => 'ⱆ'
	4078: {0x0406, 0x0456},   // 'І' => 'і'
	4081: {0x2C15, 0x2C45},   // 'Ⱅ' => 'ⱅ'
	4082: {0x0405, 0x0455},   // 'Ѕ' => 'ѕ'
	4085: {0x2C14, 0x2C44},   // 'Ⱄ' => 'ⱄ'
	4086: {0x0404, 0x0454},   // 'Є' => 'є'
	4088: {0x2C13, 0x2C43},   // 'Ⱃ' => 'ⱃ'
	4090: {0x0403, 0x0453},   // 'Ѓ' => 'ѓ'
	4092: {0x2C12, 0x2C42},   // 'Ⱂ' => 'ⱂ'
	4094: {0x0402, 0x0452},   // 'Ђ' => 'ђ'
	4096: {0x2C11, 0x2C41},   // 'Ⱁ' => 'ⱁ'
	4098: {0x0401, 0x0451},   // 'Ё' => 'ё'
	4100: {0x2C10, 0x2C40},   // 'Ⱀ' => 'ⱀ'
	4102: {0x0400, 0x0450},   // 'Ѐ' => 'ѐ'
	4104: {0x2C0F, 0x2C3F},   // 'Ⰿ' => 'ⰿ'
	4106: {0x03FF, 0x037D},   // 'Ͽ' => 'ͽ'
	4108: {0x2C0E, 0x2C3E},   // 'Ⰾ' => 'ⰾ'
	4110: {0x03FE, 0x037C},   // 'Ͼ' => 'ͼ'
	4112: {0x2C0D, 0x2C3D},   // 'Ⰽ' => 'ⰽ'
	4114: {0x03FD, 0x037B},   // 'Ͻ' => 'ͻ'
	4116: {0x2C0C, 0x2C3C},   // 'Ⰼ' => 'ⰼ'
	4120: {0x2C0B, 0x2C3B},   // 'Ⰻ' => 'ⰻ'
	4124: {0x2C0A, 0x2C3A},   // 'Ⰺ' => 'ⰺ'
	4126: {0x03FA, 0x03FB},   // 'Ϻ' => 'ϻ'
	4128: {0x2C09, 0x2C39},   // 'Ⰹ' => 'ⰹ'
	4130: {0x03F9, 0x03F2},   // 'Ϲ' => 'ϲ'
	4132: {0x2C08, 0x2C38},   // 'Ⰸ' => 'ⰸ'
	4136: {0x2C07, 0x2C37},   // 'Ⰷ' => 'ⰷ'
	4138: {0x03F7, 0x03F8},   // 'Ϸ' => 'ϸ'
	4139: {0x13FD, 0x13F5},   // 'ᏽ' => 'Ᏽ'
	4140: {0x2C06, 0x2C36},   // 'Ⰶ' => 'ⰶ'
	4143: {0x13FC, 0x13F4},   // 'ᏼ' => 'Ᏼ'
	4144: {0x2C05, 0x2C35},   // 'Ⰵ' => 'ⰵ'
	4146: {0x03F5, 0x03B5},   // 'ϵ' => 'ε'
	4147: {0x13FB, 0x13F3},   // 'ᏻ' => 'Ᏻ'
	4148: {0x2C04, 0x2C34},   // 'Ⰴ' => 'ⰴ'
	4150: {0x03F4, 0x03B8},   // 'ϴ' => 'θ'
	4151: {0x13FA, 0x13F2},   // 'ᏺ' => 'Ᏺ'
	4152: {0x2C03, 0x2C33},   // 'Ⰳ' => 'ⰳ'
	4155: {0x13F9, 0x13F1},   // 'ᏹ' => 'Ᏹ'
	4156: {0x2C02, 0x2C32},   // 'Ⰲ' => 'ⰲ'
	4159: {0x13F8, 0x13F0},   // 'ᏸ' => 'Ᏸ'
	4160: {0x2C01, 0x2C31},   // 'Ⰱ' => 'ⰱ'
	4162: {0x03F1, 0x03C1},   // 'ϱ' => 'ρ'
	4164: {0x2C00, 0x2C30},   // 'Ⰰ' => 'ⰰ'
	4166: {0x03F0, 0x03BA},   // 'ϰ' => 'κ'
	4174: {0x03EE, 0x03EF},   // 'Ϯ' => 'ϯ'
	4182: {0x03EC, 0x03ED},   // 'Ϭ' => 'ϭ'
	4190: {0x03EA, 0x03EB},   // 'Ϫ' => 'ϫ'
	4198: {0x03E8, 0x03E9},   // 'Ϩ' => 'ϩ'
	4206: {0x03E6, 0x03E7},   // 'Ϧ' => 'ϧ'
	4214: {0x03E4, 0x03E5},   // 'Ϥ' => 'ϥ'
	4222: {0x03E2, 0x03E3},   // 'Ϣ' => 'ϣ'
	4230: {0x03E0, 0x03E1},   // 'Ϡ' => 'ϡ'
	4238: {0x03DE, 0x03DF},   // 'Ϟ' => 'ϟ'
	4246: {0x03DC, 0x03DD},   // 'Ϝ' => 'ϝ'
	4254: {0x03DA, 0x03DB},   // 'Ϛ' => 'ϛ'
	4262: {0x03D8, 0x03D9},   // 'Ϙ' => 'ϙ'
	4270: {0x03D6, 0x03C0},   // 'ϖ' => 'π'
	4273: {0x03D5, 0x03C6},   // 'ϕ' => 'φ'
	4289: {0x03D1, 0x03B8},   // 'ϑ' => 'θ'
	4293: {0x03D0, 0x03B2},   // 'ϐ' => 'β'
	4297: {0x03CF, 0x03D7},   // 'Ϗ' => 'ϗ'
	4347: {0x10427, 0x1044F}, // '𐐧' => '𐑏'
	4349: {0x03C2, 0x03C3},   // 'ς' => 'σ'
	4351: {0x10426, 0x1044E}, // '𐐦' => '𐑎'
	4355: {0x10425, 0x1044D}, // '𐐥' => '𐑍'
	4359: {0x10424, 0x1044C}, // '𐐤' => '𐑌'
	4363: {0x10423, 0x1044B}, // '𐐣' => '𐑋'
	4367: {0x10422, 0x1044A}, // '𐐢' => '𐑊'
	4371: {0x10421, 0x10449}, // '𐐡' => '𐑉'
	4375: {0x10420, 0x10448}, // '𐐠' => '𐑈'
	4379: {0x1041F, 0x10447}, // '𐐟' => '𐑇'
	4383: {0x1041E, 0x10446}, // '𐐞' => '𐑆'
	4387: {0x1041D, 0x10445}, // '𐐝' => '𐑅'
	4391: {0x1041C, 0x10444}, // '𐐜' => '𐑄'
	4395: {0x1041B, 0x10443}, // '𐐛' => '𐑃'
	4399: {0x1041A, 0x10442}, // '𐐚' => '𐑂'
	4403: {0x10419, 0x10441}, // '𐐙' => '𐑁'
	4407: {0x10418, 0x10440}, // '𐐘' => '𐑀'
	4411: {0x10417, 0x1043F}, // '𐐗' => '𐐿'
	4415: {0x10416, 0x1043E}, // '𐐖' => '𐐾'
	4419: {0x10415, 0x1043D}, // '𐐕' => '𐐽'
	4423: {0x10414, 0x1043C}, // '𐐔' => '𐐼'
	4427: {0x10413, 0x1043B}, // '𐐓' => '𐐻'
	4431: {0x10412, 0x1043A}, // '𐐒' => '𐐺'
	4435: {0x10411, 0x10439}, // '𐐑' => '𐐹'
	4439: {0x10410, 0x10438}, // '𐐐' => '𐐸'
	4441: {0x03AB, 0x03CB},   // 'Ϋ' => 'ϋ'
	4443: {0x1040F, 0x10437}, // '𐐏' => '𐐷'
	4445: {0x03AA, 0x03CA},   // 'Ϊ' => 'ϊ'
	4447: {0x1040E, 0x10436}, // '𐐎' => '𐐶'
	4449: {0x03A9, 0x03C9},   // 'Ω' => 'ω'
	4451: {0x1040D, 0x10435}, // '𐐍' => '𐐵'
	4453: {0x03A8, 0x03C8},   // 'Ψ' => 'ψ'
	4455: {0x1040C, 0x10434}, // '𐐌' => '𐐴'
	4457: {0x03A7, 0x03C7},   // 'Χ' => 'χ'
	4459: {0x1040B, 0x10433}, // '𐐋' => '𐐳'
	4461: {0x03A6, 0x03C6},   // 'Φ' => 'φ'
	4463: {0x1040A, 0x10432}, // '𐐊' => '𐐲'
	4465: {0x03A5, 0x03C5},   // 'Υ' => 'υ'
	4467: {0x10409, 0x10431}, // '𐐉' => '𐐱'
	4469: {0x03A4, 0x03C4},   // 'Τ' => 'τ'
	4471: {0x10408, 0x10430}, // '𐐈' => '𐐰'
	4473: {0x03A3, 0x03C3},   // 'Σ' => 'σ'
	4475: {0x10407, 0x1042F}, // '𐐇' => '𐐯'
	4479: {0x10406, 0x1042E}, // '𐐆' => '𐐮'
	4481: {0x03A1, 0x03C1},   // 'Ρ' => 'ρ'
	4483: {0x10405, 0x1042D}, // '𐐅' => '𐐭'
	4485: {0x03A0, 0x03C0},   // 'Π' => 'π'
	4487: {0x10404, 0x1042C}, // '𐐄' => '𐐬'
	4489: {0x039F, 0x03BF},   // 'Ο' => 'ο'
	4491: {0x10403, 0x1042B}, // '𐐃' => '𐐫'
	4493: {0x039E, 0x03BE},   // 'Ξ' => 'ξ'
	4495: {0x10402, 0x1042A}, // '𐐂' => '𐐪'
	4497: {0x039D, 0x03BD},   // 'Ν' => 'ν'
	4499: {0x10401, 0x10429}, // '𐐁' => '𐐩'
	4501: {0x039C, 0x03BC},   // 'Μ' => 'μ'
	4503: {0x10400, 0x10428}, // '𐐀' => '𐐨'
	4505: {0x039B, 0x03BB},   // 'Λ' => 'λ'
	4509: {0x039A, 0x03BA},   // 'Κ' => 'κ'
	4513: {0x0399, 0x03B9},   // 'Ι' => 'ι'
	4517: {0x0398, 0x03B8},   // 'Θ' => 'θ'
	4521: {0x0397, 0x03B7},   // 'Η' => 'η'
	4525: {0x0396, 0x03B6},   // 'Ζ' => 'ζ'
	4529: {0x0395, 0x03B5},   // 'Ε' => 'ε'
	4533: {0x0394, 0x03B4},   // 'Δ' => 'δ'
	4537: {0x0393, 0x03B3},   // 'Γ' => 'γ'
	4541: {0x0392, 0x03B2},   // 'Β' => 'β'
	4545: {0x0391, 0x03B1},   // 'Α' => 'α'
	4553: {0x038F, 0x03CE},   // 'Ώ' => 'ώ'
	4557: {0x038E, 0x03CD},   // 'Ύ' => 'ύ'
	4565: {0x038C, 0x03CC},   // 'Ό' => 'ό'
	4573: {0x038A, 0x03AF},   // 'Ί' => 'ί'
	4577: {0x0389, 0x03AE},   // 'Ή' => 'ή'
	4581: {0x0388, 0x03AD},   // 'Έ' => 'έ'
	4589: {0x0386, 0x03AC},   // 'Ά' => 'ά'
	4617: {0x037F, 0x03F3},   // 'Ϳ' => 'ϳ'
	4624: {0xABBF, 0x13EF},   // 'ꮿ' => 'Ꮿ'
	4628: {0xABBE, 0x13EE},   // 'ꮾ' => 'Ꮾ'
	4632: {0xABBD, 0x13ED},   // 'ꮽ' => 'Ꮽ'
	4636: {0xABBC, 0x13EC},   // 'ꮼ' => 'Ꮼ'
	4640: {0xABBB, 0x13EB},   // 'ꮻ' => 'Ꮻ'
	4644: {0xABBA, 0x13EA},   // 'ꮺ' => 'Ꮺ'
	4648: {0xABB9, 0x13E9},   // 'ꮹ' => 'Ꮹ'
	4652: {0xABB8, 0x13E8},   // 'ꮸ' => 'Ꮸ'
	4653: {0x0376, 0x0377},   // 'Ͷ' => 'ͷ'
	4656: {0xABB7, 0x13E7},   // 'ꮷ' => 'Ꮷ'
	4660: {0xABB6, 0x13E6},   // 'ꮶ' => 'Ꮶ'
	4664: {0xABB5, 0x13E5},   // 'ꮵ' => 'Ꮵ'
	4668: {0xABB4, 0x13E4},   // 'ꮴ' => 'Ꮴ'
	4669: {0x0372, 0x0373},   // 'Ͳ' => 'ͳ'
	4672: {0xABB3, 0x13E3},   // 'ꮳ' => 'Ꮳ'
	4676: {0xABB2, 0x13E2},   // 'ꮲ' => 'Ꮲ'
	4677: {0x0370, 0x0371},   // 'Ͱ' => 'ͱ'
	4680: {0xABB1, 0x13E1},   // 'ꮱ' => 'Ꮱ'
	4684: {0xABB0, 0x13E0},   // 'ꮰ' => 'Ꮰ'
	4688: {0xABAF, 0x13DF},   // 'ꮯ' => 'Ꮯ'
	4692: {0xABAE, 0x13DE},   // 'ꮮ' => 'Ꮮ'
	4696: {0xABAD, 0x13DD},   // 'ꮭ' => 'Ꮭ'
	4700: {0xABAC, 0x13DC},   // 'ꮬ' => 'Ꮬ'
	4704: {0xABAB, 0x13DB},   // 'ꮫ' => 'Ꮫ'
	4708: {0xABAA, 0x13DA},   // 'ꮪ' => 'Ꮪ'
	4712: {0xABA9, 0x13D9},   // 'ꮩ' => 'Ꮩ'
	4716: {0xABA8, 0x13D8},   // 'ꮨ' => 'Ꮨ'
	4720: {0xABA7, 0x13D7},   // 'ꮧ' => 'Ꮧ'
	4724: {0xABA6, 0x13D6},   // 'ꮦ' => 'Ꮦ'
	4728: {0xABA5, 0x13D5},   // 'ꮥ' => 'Ꮥ'
	4732: {0xABA4, 0x13D4},   // 'ꮤ' => 'Ꮤ'
	4736: {0xABA3, 0x13D3},   // 'ꮣ' => 'Ꮣ'
	4740: {0xABA2, 0x13D2},   // 'ꮢ' => 'Ꮢ'
	4744: {0xABA1, 0x13D1},   // 'ꮡ' => 'Ꮡ'
	4748: {0xABA0, 0x13D0},   // 'ꮠ' => 'Ꮠ'
	4752: {0xAB9F, 0x13CF},   // 'ꮟ' => 'Ꮟ'
	4756: {0xAB9E, 0x13CE},   // 'ꮞ' => 'Ꮞ'
	4760: {0xAB9D, 0x13CD},   // 'ꮝ' => 'Ꮝ'
	4764: {0xAB9C, 0x13CC},   // 'ꮜ' => 'Ꮜ'
	4768: {0xAB9B, 0x13CB},   // 'ꮛ' => 'Ꮛ'
	4772: {0xAB9A, 0x13CA},   // 'ꮚ' => 'Ꮚ'
	4776: {0xAB99, 0x13C9},   // 'ꮙ' => 'Ꮙ'
	4780: {0xAB98, 0x13C8},   // 'ꮘ' => 'Ꮘ'
	4784: {0xAB97, 0x13C7},   // 'ꮗ' => 'Ꮗ'
	4788: {0xAB96, 0x13C6},   // 'ꮖ' => 'Ꮖ'
	4792: {0xAB95, 0x13C5},   // 'ꮕ' => 'Ꮕ'
	4796: {0xAB94, 0x13C4},   // 'ꮔ' => 'Ꮔ'
	4800: {0xAB93, 0x13C3},   // 'ꮓ' => 'Ꮓ'
	4804: {0xAB92, 0x13C2},   // 'ꮒ' => 'Ꮒ'
	4808: {0xAB91, 0x13C1},   // 'ꮑ' => 'Ꮑ'
	4812: {0xAB90, 0x13C0},   // 'ꮐ' => 'Ꮐ'
	4816: {0xAB8F, 0x13BF},   // 'ꮏ' => 'Ꮏ'
	4820: {0xAB8E, 0x13BE},   // 'ꮎ' => 'Ꮎ'
	4824: {0xAB8D, 0x13BD},   // 'ꮍ' => 'Ꮍ'
	4828: {0xAB8C, 0x13BC},   // 'ꮌ' => 'Ꮌ'
	4832: {0xAB8B, 0x13BB},   // 'ꮋ' => 'Ꮋ'
	4836: {0xAB8A, 0x13BA},   // 'ꮊ' => 'Ꮊ'
	4840: {0xAB89, 0x13B9},   // 'ꮉ' => 'Ꮉ'
	4844: {0xAB88, 0x13B8},   // 'ꮈ' => 'Ꮈ'
	4848: {0xAB87, 0x13B7},   // 'ꮇ' => 'Ꮇ'
	4849: {0x0345, 0x03B9},   // 'ͅ' => 'ι'
	4852: {0xAB86, 0x13B6},   // 'ꮆ' => 'Ꮆ'
	4856: {0xAB85, 0x13B5},   // 'ꮅ' => 'Ꮅ'
	4860: {0xAB84, 0x13B4},   // 'ꮄ' => 'Ꮄ'
	4864: {0xAB83, 0x13B3},   // 'ꮃ' => 'Ꮃ'
	4868: {0xAB82, 0x13B2},   // 'ꮂ' => 'Ꮂ'
	4872: {0xAB81, 0x13B1},   // 'ꮁ' => 'Ꮁ'
	4876: {0xAB80, 0x13B0},   // 'ꮀ' => 'Ꮀ'
	4880: {0xAB7F, 0x13AF},   // 'ꭿ' => 'Ꭿ'
	4884: {0xAB7E, 0x13AE},   // 'ꭾ' => 'Ꭾ'
	4888: {0xAB7D, 0x13AD},   // 'ꭽ' => 'Ꭽ'
	4892: {0xAB7C, 0x13AC},   // 'ꭼ' => 'Ꭼ'
	4896: {0xAB7B, 0x13AB},   // 'ꭻ' => 'Ꭻ'
	4900: {0xAB7A, 0x13AA},   // 'ꭺ' => 'Ꭺ'
	4904: {0xAB79, 0x13A9},   // 'ꭹ' => 'Ꭹ'
	4908: {0xAB78, 0x13A8},   // 'ꭸ' => 'Ꭸ'
	4912: {0xAB77, 0x13A7},   // 'ꭷ' => 'Ꭷ'
	4916: {0xAB76, 0x13A6},   // 'ꭶ' => 'Ꭶ'
	4920: {0xAB75, 0x13A5},   // 'ꭵ' => 'Ꭵ'
	4924: {0xAB74, 0x13A4},   // 'ꭴ' => 'Ꭴ'
	4928: {0xAB73, 0x13A3},   // 'ꭳ' => 'Ꭳ'
	4932: {0xAB72, 0x13A2},   // 'ꭲ' => 'Ꭲ'
	4936: {0xAB71, 0x13A1},   // 'ꭱ' => 'Ꭱ'
	4940: {0xAB70, 0x13A0},   // 'ꭰ' => 'Ꭰ'
	5835: {0x024E, 0x024F},   // 'Ɏ' => 'ɏ'
	5843: {0x024C, 0x024D},   // 'Ɍ' => 'ɍ'
	5851: {0x024A, 0x024B},   // 'Ɋ' => 'ɋ'
	5859: {0x0248, 0x0249},   // 'Ɉ' => 'ɉ'
	5867: {0x0246, 0x0247},   // 'Ɇ' => 'ɇ'
	5871: {0x0245, 0x028C},   // 'Ʌ' => 'ʌ'
	5875: {0x0244, 0x0289},   // 'Ʉ' => 'ʉ'
	5879: {0x0243, 0x0180},   // 'Ƀ' => 'ƀ'
	5887: {0x0241, 0x0242},   // 'Ɂ' => 'ɂ'
	5899: {0x023E, 0x2C66},   // 'Ⱦ' => 'ⱦ'
	5903: {0x023D, 0x019A},   // 'Ƚ' => 'ƚ'
	5911: {0x023B, 0x023C},   // 'Ȼ' => 'ȼ'
	5915: {0x023A, 0x2C65},   // 'Ⱥ' => 'ⱥ'
	5947: {0x0232, 0x0233},   // 'Ȳ' => 'ȳ'
	5955: {0x0230, 0x0231},   // 'Ȱ' => 'ȱ'
	5963: {0x022E, 0x022F},   // 'Ȯ' => 'ȯ'
	5971: {0x022C, 0x022D},   // 'Ȭ' => 'ȭ'
	5979: {0x022A, 0x022B},   // 'Ȫ' => 'ȫ'
	5987: {0x0228, 0x0229},   // 'Ȩ' => 'ȩ'
	5995: {0x0226, 0x0227},   // 'Ȧ' => 'ȧ'
	6003: {0x0224, 0x0225},   // 'Ȥ' => 'ȥ'
	6011: {0x0222, 0x0223},   // 'Ȣ' => 'ȣ'
	6019: {0x0220, 0x019E},   // 'Ƞ' => 'ƞ'
	6027: {0x021E, 0x021F},   // 'Ȟ' => 'ȟ'
	6035: {0x021C, 0x021D},   // 'Ȝ' => 'ȝ'
	6043: {0x021A, 0x021B},   // 'Ț' => 'ț'
	6051: {0x0218, 0x0219},   // 'Ș' => 'ș'
	6059: {0x0216, 0x0217},   // 'Ȗ' => 'ȗ'
	6067: {0x0214, 0x0215},   // 'Ȕ' => 'ȕ'
	6075: {0x0212, 0x0213},   // 'Ȓ' => 'ȓ'
	6083: {0x0210, 0x0211},   // 'Ȑ' => 'ȑ'
	6091: {0x020E, 0x020F},   // 'Ȏ' => 'ȏ'
	6099: {0x020C, 0x020D},   // 'Ȍ' => 'ȍ'
	6107: {0x020A, 0x020B},   // 'Ȋ' => 'ȋ'
	6115: {0x0208, 0x0209},   // 'Ȉ' => 'ȉ'
	6123: {0x0206, 0x0207},   // 'Ȇ' => 'ȇ'
	6131: {0x0204, 0x0205},   // 'Ȅ' => 'ȅ'
	6139: {0x0202, 0x0203},   // 'Ȃ' => 'ȃ'
	6147: {0x0200, 0x0201},   // 'Ȁ' => 'ȁ'
	6155: {0x01FE, 0x01FF},   // 'Ǿ' => 'ǿ'
	6163: {0x01FC, 0x01FD},   // 'Ǽ' => 'ǽ'
	6171: {0x01FA, 0x01FB},   // 'Ǻ' => 'ǻ'
	6179: {0x01F8, 0x01F9},   // 'Ǹ' => 'ǹ'
	6183: {0x01F7, 0x01BF},   // 'Ƿ' => 'ƿ'
	6187: {0x01F6, 0x0195},   // 'Ƕ' => 'ƕ'
	6195: {0x01F4, 0x01F5},   // 'Ǵ' => 'ǵ'
	6203: {0x01F2, 0x01F3},   // 'ǲ' => 'ǳ'
	6207: {0x01F1, 0x01F3},   // 'Ǳ' => 'ǳ'
	6219: {0x01EE, 0x01EF},   // 'Ǯ' => 'ǯ'
	6227: {0x01EC, 0x01ED},   // 'Ǭ' => 'ǭ'
	6234: {0x01EA, 0x01EB},   // 'Ǫ' => 'ǫ'
	6242: {0x01E8, 0x01E9},   // 'Ǩ' => 'ǩ'
	6250: {0x01E6, 0x01E7},   // 'Ǧ' => 'ǧ'
	6258: {0x01E4, 0x01E5},   // 'Ǥ' => 'ǥ'
	6266: {0x01E2, 0x01E3},   // 'Ǣ' => 'ǣ'
	6274: {0x01E0, 0x01E1},   // 'Ǡ' => 'ǡ'
	6282: {0x01DE, 0x01DF},   // 'Ǟ' => 'ǟ'
	6294: {0x01DB, 0x01DC},   // 'Ǜ' => 'ǜ'
	6302: {0x01D9, 0x01DA},   // 'Ǚ' => 'ǚ'
	6310: {0x01D7, 0x01D8},   // 'Ǘ' => 'ǘ'
	6318: {0x01D5, 0x01D6},   // 'Ǖ' => 'ǖ'
	6326: {0x01D3, 0x01D4},   // 'Ǔ' => 'ǔ'
	6334: {0x01D1, 0x01D2},   // 'Ǒ' => 'ǒ'
	6342: {0x01CF, 0x01D0},   // 'Ǐ' => 'ǐ'
	6350: {0x01CD, 0x01CE},   // 'Ǎ' => 'ǎ'
	6358: {0x01CB, 0x01CC},   // 'ǋ' => 'ǌ'
	6362: {0x01CA, 0x01CC},   // 'Ǌ' => 'ǌ'
	6370: {0x01C8, 0x01C9},   // 'ǈ' => 'ǉ'
	6374: {0x01C7, 0x01C9},   // 'Ǉ' => 'ǉ'
	6382: {0x01C5, 0x01C6},   // 'ǅ' => 'ǆ'
	6386: {0x01C4, 0x01C6},   // 'Ǆ' => 'ǆ'
	6418: {0x01BC, 0x01BD},   // 'Ƽ' => 'ƽ'
	6434: {0x01B8, 0x01B9},   // 'Ƹ' => 'ƹ'
	6438: {0x01B7, 0x0292},   // 'Ʒ' => 'ʒ'
	6446: {0x01B5, 0x01B6},   // 'Ƶ' => 'ƶ'
	6454: {0x01B3, 0x01B4},   // 'Ƴ' => 'ƴ'
	6458: {0x01B2, 0x028B},   // 'Ʋ' => 'ʋ'
	6462: {0x01B1, 0x028A},   // 'Ʊ' => 'ʊ'
	6470: {0x01AF, 0x01B0},   // 'Ư' => 'ư'
	6474: {0x01AE, 0x0288},   // 'Ʈ' => 'ʈ'
	6482: {0x01AC, 0x01AD},   // 'Ƭ' => 'ƭ'
	6494: {0x01A9, 0x0283},   // 'Ʃ' => 'ʃ'
	6502: {0x01A7, 0x01A8},   // 'Ƨ' => 'ƨ'
	6506: {0x01A6, 0x0280},   // 'Ʀ' => 'ʀ'
	6514: {0x01A4, 0x01A5},   // 'Ƥ' => 'ƥ'
	6522: {0x01A2, 0x01A3},   // 'Ƣ' => 'ƣ'
	6530: {0x01A0, 0x01A1},   // 'Ơ' => 'ơ'
	6534: {0x019F, 0x0275},   // 'Ɵ' => 'ɵ'
	6542: {0x019D, 0x0272},   // 'Ɲ' => 'ɲ'
	6546: {0x019C, 0x026F},   // 'Ɯ' => 'ɯ'
	6562: {0x0198, 0x0199},   // 'Ƙ' => 'ƙ'
	6566: {0x0197, 0x0268},   // 'Ɨ' => 'ɨ'
	6570: {0x0196, 0x0269},   // 'Ɩ' => 'ɩ'
	6578: {0x0194, 0x0263},   // 'Ɣ' => 'ɣ'
	6582: {0x0193, 0x0260},   // 'Ɠ' => 'ɠ'
	6590: {0x0191, 0x0192},   // 'Ƒ' => 'ƒ'
	6594: {0x0190, 0x025B},   // 'Ɛ' => 'ɛ'
	6598: {0x018F, 0x0259},   // 'Ə' => 'ə'
	6602: {0x018E, 0x01DD},   // 'Ǝ' => 'ǝ'
	6614: {0x018B, 0x018C},   // 'Ƌ' => 'ƌ'
	6618: {0x018A, 0x0257},   // 'Ɗ' => 'ɗ'
	6622: {0x0189, 0x0256},   // 'Ɖ' => 'ɖ'
	6630: {0x0187, 0x0188},   // 'Ƈ' => 'ƈ'
	6634: {0x0186, 0x0254},   // 'Ɔ' => 'ɔ'
	6642: {0x0184, 0x0185},   // 'Ƅ' => 'ƅ'
	6650: {0x0182, 0x0183},   // 'Ƃ' => 'ƃ'
	6654: {0x0181, 0x0253},   // 'Ɓ' => 'ɓ'
	6662: {0x017F, 0x0073},   // 'ſ' => 's'
	6670: {0x017D, 0x017E},   // 'Ž' => 'ž'
	6678: {0x017B, 0x017C},   // 'Ż' => 'ż'
	6686: {0x0179, 0x017A},   // 'Ź' => 'ź'
	6690: {0x0178, 0x00FF},   // 'Ÿ' => 'ÿ'
	6696: {0x2183, 0x2184},   // 'Ↄ' => 'ↄ'
	6698: {0x0176, 0x0177},   // 'Ŷ' => 'ŷ'
	6706: {0x0174, 0x0175},   // 'Ŵ' => 'ŵ'
	6714: {0x0172, 0x0173},   // 'Ų' => 'ų'
	6722: {0x0170, 0x0171},   // 'Ű' => 'ű'
	6730: {0x016E, 0x016F},   // 'Ů' => 'ů'
	6738: {0x016C, 0x016D},   // 'Ŭ' => 'ŭ'
	6746: {0x016A, 0x016B},   // 'Ū' => 'ū'
	6754: {0x0168, 0x0169},   // 'Ũ' => 'ũ'
	6762: {0x0166, 0x0167},   // 'Ŧ' => 'ŧ'
	6770: {0x0164, 0x0165},   // 'Ť' => 'ť'
	6776: {0x216F, 0x217F},   // 'Ⅿ' => 'ⅿ'
	6778: {0x0162, 0x0163},   // 'Ţ' => 'ţ'
	6780: {0x216E, 0x217E},   // 'Ⅾ' => 'ⅾ'
	6784: {0x216D, 0x217D},   // 'Ⅽ' => 'ⅽ'
	6786: {0x0160, 0x0161},   // 'Š' => 'š'
	6788: {0x216C, 0x217C},   // 'Ⅼ' => 'ⅼ'
	6792: {0x216B, 0x217B},   // 'Ⅻ' => 'ⅻ'
	6794: {0x015E, 0x015F},   // 'Ş' => 'ş'
	6796: {0x216A, 0x217A},   // 'Ⅺ' => 'ⅺ'
	6800: {0x2169, 0x2179},   // 'Ⅹ' => 'ⅹ'
	6802: {0x015C, 0x015D},   // 'Ŝ' => 'ŝ'
	6804: {0x2168, 0x2178},   // 'Ⅸ' => 'ⅸ'
	6808: {0x2167, 0x2177},   // 'Ⅷ' => 'ⅷ'
	6810: {0x015A, 0x015B},   // 'Ś' => 'ś'
	6812: {0x2166, 0x2176},   // 'Ⅶ' => 'ⅶ'
	6816: {0x2165, 0x2175},   // 'Ⅵ' => 'ⅵ'
	6818: {0x0158, 0x0159},   // 'Ř' => 'ř'
	6820: {0x2164, 0x2174},   // 'Ⅴ' => 'ⅴ'
	6824: {0x2163, 0x2173},   // 'Ⅳ' => 'ⅳ'
	6826: {0x0156, 0x0157},   // 'Ŗ' => 'ŗ'
	6828: {0x2162, 0x2172},   // 'Ⅲ' => 'ⅲ'
	6832: {0x2161, 0x2171},   // 'Ⅱ' => 'ⅱ'
	6834: {0x0154, 0x0155},   // 'Ŕ' => 'ŕ'
	6836: {0x2160, 0x2170},   // 'Ⅰ' => 'ⅰ'
	6842: {0x0152, 0x0153},   // 'Œ' => 'œ'
	6850: {0x0150, 0x0151},   // 'Ő' => 'ő'
	6858: {0x014E, 0x014F},   // 'Ŏ' => 'ŏ'
	6866: {0x014C, 0x014D},   // 'Ō' => 'ō'
	6874: {0x014A, 0x014B},   // 'Ŋ' => 'ŋ'
	6885: {0x0147, 0x0148},   // 'Ň' => 'ň'
	6893: {0x0145, 0x0146},   // 'Ņ' => 'ņ'
	6901: {0x0143, 0x0144},   // 'Ń' => 'ń'
	6909: {0x0141, 0x0142},   // 'Ł' => 'ł'
	6917: {0x013F, 0x0140},   // 'Ŀ' => 'ŀ'
	6925: {0x013D, 0x013E},   // 'Ľ' => 'ľ'
	6933: {0x013B, 0x013C},   // 'Ļ' => 'ļ'
	6941: {0x0139, 0x013A},   // 'Ĺ' => 'ĺ'
	6953: {0x0136, 0x0137},   // 'Ķ' => 'ķ'
	6961: {0x0134, 0x0135},   // 'Ĵ' => 'ĵ'
	6969: {0x0132, 0x0133},   // 'Ĳ' => 'ĳ'
	6985: {0x012E, 0x012F},   // 'Į' => 'į'
	6993: {0x012C, 0x012D},   // 'Ĭ' => 'ĭ'
	7001: {0x012A, 0x012B},   // 'Ī' => 'ī'
	7009: {0x0128, 0x0129},   // 'Ĩ' => 'ĩ'
	7017: {0x0126, 0x0127},   // 'Ħ' => 'ħ'
	7019: {0x2132, 0x214E},   // 'Ⅎ' => 'ⅎ'
	7025: {0x0124, 0x0125},   // 'Ĥ' => 'ĥ'
	7033: {0x0122, 0x0123},   // 'Ģ' => 'ģ'
	7041: {0x0120, 0x0121},   // 'Ġ' => 'ġ'
	7047: {0x212B, 0x00E5},   // 'Å' => 'å'
	7049: {0x011E, 0x011F},   // 'Ğ' => 'ğ'
	7051: {0x212A, 0x006B},   // 'K' => 'k'
	7057: {0x011C, 0x011D},   // 'Ĝ' => 'ĝ'
	7065: {0x011A, 0x011B},   // 'Ě' => 'ě'
	7067: {0x2126, 0x03C9},   // 'Ω' => 'ω'
	7073: {0x0118, 0x0119},   // 'Ę' => 'ę'
	7081: {0x0116, 0x0117},   // 'Ė' => 'ė'
	7089: {0x0114, 0x0115},   // 'Ĕ' => 'ĕ'
	7097: {0x0112, 0x0113},   // 'Ē' => 'ē'
	7105: {0x0110, 0x0111},   // 'Đ' => 'đ'
	7113: {0x010E, 0x010F},   // 'Ď' => 'ď'
	7121: {0x010C, 0x010D},   // 'Č' => 'č'
	7129: {0x010A, 0x010B},   // 'Ċ' => 'ċ'
	7137: {0x0108, 0x0109},   // 'Ĉ' => 'ĉ'
	7145: {0x0106, 0x0107},   // 'Ć' => 'ć'
	7153: {0x0104, 0x0105},   // 'Ą' => 'ą'
	7161: {0x0102, 0x0103},   // 'Ă' => 'ă'
	7169: {0x0100, 0x0101},   // 'Ā' => 'ā'
	7305: {0x00DE, 0x00FE},   // 'Þ' => 'þ'
	7309: {0x00DD, 0x00FD},   // 'Ý' => 'ý'
	7313: {0x00DC, 0x00FC},   // 'Ü' => 'ü'
	7317: {0x00DB, 0x00FB},   // 'Û' => 'û'
	7321: {0x00DA, 0x00FA},   // 'Ú' => 'ú'
	7325: {0x00D9, 0x00F9},   // 'Ù' => 'ù'
	7329: {0x00D8, 0x00F8},   // 'Ø' => 'ø'
	7337: {0x00D6, 0x00F6},   // 'Ö' => 'ö'
	7341: {0x00D5, 0x00F5},   // 'Õ' => 'õ'
	7345: {0x00D4, 0x00F4},   // 'Ô' => 'ô'
	7349: {0x00D3, 0x00F3},   // 'Ó' => 'ó'
	7353: {0x00D2, 0x00F2},   // 'Ò' => 'ò'
	7357: {0x00D1, 0x00F1},   // 'Ñ' => 'ñ'
	7361: {0x00D0, 0x00F0},   // 'Ð' => 'ð'
	7365: {0x00CF, 0x00EF},   // 'Ï' => 'ï'
	7369: {0x00CE, 0x00EE},   // 'Î' => 'î'
	7373: {0x00CD, 0x00ED},   // 'Í' => 'í'
	7377: {0x00CC, 0x00EC},   // 'Ì' => 'ì'
	7381: {0x00CB, 0x00EB},   // 'Ë' => 'ë'
	7385: {0x00CA, 0x00EA},   // 'Ê' => 'ê'
	7389: {0x00C9, 0x00E9},   // 'É' => 'é'
	7393: {0x00C8, 0x00E8},   // 'È' => 'è'
	7397: {0x00C7, 0x00E7},   // 'Ç' => 'ç'
	7398: {0x10CD, 0x2D2D},   // 'Ⴭ' => 'ⴭ'
	7401: {0x00C6, 0x00E6},   // 'Æ' => 'æ'
	7405: {0x00C5, 0x00E5},   // 'Å' => 'å'
	7409: {0x00C4, 0x00E4},   // 'Ä' => 'ä'
	7413: {0x00C3, 0x00E3},   // 'Ã' => 'ã'
	7417: {0x00C2, 0x00E2},   // 'Â' => 'â'
	7421: {0x00C1, 0x00E1},   // 'Á' => 'á'
	7422: {0x10C7, 0x2D27},   // 'Ⴧ' => 'ⴧ'
	7425: {0x00C0, 0x00E0},   // 'À' => 'à'
	7430: {0x10C5, 0x2D25},   // 'Ⴥ' => 'ⴥ'
	7434: {0x10C4, 0x2D24},   // 'Ⴤ' => 'ⴤ'
	7438: {0x10C3, 0x2D23},   // 'Ⴣ' => 'ⴣ'
	7442: {0x10C2, 0x2D22},   // 'Ⴢ' => 'ⴢ'
	7446: {0x10C1, 0x2D21},   // 'Ⴡ' => 'ⴡ'
	7450: {0x10C0, 0x2D20},   // 'Ⴠ' => 'ⴠ'
	7454: {0x10BF, 0x2D1F},   // 'Ⴟ' => 'ⴟ'
	7458: {0x10BE, 0x2D1E},   // 'Ⴞ' => 'ⴞ'
	7462: {0x10BD, 0x2D1D},   // 'Ⴝ' => 'ⴝ'
	7466: {0x10BC, 0x2D1C},   // 'Ⴜ' => 'ⴜ'
	7469: {0x00B5, 0x03BC},   // 'µ' => 'μ'
	7470: {0x10BB, 0x2D1B},   // 'Ⴛ' => 'ⴛ'
	7474: {0x10BA, 0x2D1A},   // 'Ⴚ' => 'ⴚ'
	7478: {0x10B9, 0x2D19},   // 'Ⴙ' => 'ⴙ'
	7482: {0x10B8, 0x2D18},   // 'Ⴘ' => 'ⴘ'
	7486: {0x10B7, 0x2D17},   // 'Ⴗ' => 'ⴗ'
	7490: {0x10B6, 0x2D16},   // 'Ⴖ' => 'ⴖ'
	7494: {0x10B5, 0x2D15},   // 'Ⴕ' => 'ⴕ'
	7498: {0x10B4, 0x2D14},   // 'Ⴔ' => 'ⴔ'
	7502: {0x10B3, 0x2D13},   // 'Ⴓ' => 'ⴓ'
	7506: {0x10B2, 0x2D12},   // 'Ⴒ' => 'ⴒ'
	7510: {0x10B1, 0x2D11},   // 'Ⴑ' => 'ⴑ'
	7514: {0x10B0, 0x2D10},   // 'Ⴐ' => 'ⴐ'
	7518: {0x10AF, 0x2D0F},   // 'Ⴏ' => 'ⴏ'
	7522: {0x10AE, 0x2D0E},   // 'Ⴎ' => 'ⴎ'
	7526: {0x10AD, 0x2D0D},   // 'Ⴍ' => 'ⴍ'
	7530: {0x10AC, 0x2D0C},   // 'Ⴌ' => 'ⴌ'
	7534: {0x10AB, 0x2D0B},   // 'Ⴋ' => 'ⴋ'
	7538: {0x10AA, 0x2D0A},   // 'Ⴊ' => 'ⴊ'
	7542: {0x10A9, 0x2D09},   // 'Ⴉ' => 'ⴉ'
	7546: {0x10A8, 0x2D08},   // 'Ⴈ' => 'ⴈ'
	7550: {0x10A7, 0x2D07},   // 'Ⴇ' => 'ⴇ'
	7554: {0x10A6, 0x2D06},   // 'Ⴆ' => 'ⴆ'
	7558: {0x10A5, 0x2D05},   // 'Ⴅ' => 'ⴅ'
	7562: {0x10A4, 0x2D04},   // 'Ⴄ' => 'ⴄ'
	7566: {0x10A3, 0x2D03},   // 'Ⴃ' => 'ⴃ'
	7570: {0x10A2, 0x2D02},   // 'Ⴂ' => 'ⴂ'
	7574: {0x10A1, 0x2D01},   // 'Ⴁ' => 'ⴁ'
	7578: {0x10A0, 0x2D00},   // 'Ⴀ' => 'ⴀ'
	7801: {0x1E921, 0x1E943}, // '𞤡' => '𞥃'
	7805: {0x1E920, 0x1E942}, // '𞤠' => '𞥂'
	7809: {0x1E91F, 0x1E941}, // '𞤟' => '𞥁'
	7813: {0x1E91E, 0x1E940}, // '𞤞' => '𞥀'
	7817: {0x1E91D, 0x1E93F}, // '𞤝' => '𞤿'
	7821: {0x1E91C, 0x1E93E}, // '𞤜' => '𞤾'
	7825: {0x1E91B, 0x1E93D}, // '𞤛' => '𞤽'
	7829: {0x1E91A, 0x1E93C}, // '𞤚' => '𞤼'
	7832: {0x005A, 0x007A},   // 'Z' => 'z'
	7833: {0x1E919, 0x1E93B}, // '𞤙' => '𞤻'
	7836: {0x0059, 0x0079},   // 'Y' => 'y'
	7837: {0x1E918, 0x1E93A}, // '𞤘' => '𞤺'
	7840: {0x0058, 0x0078},   // 'X' => 'x'
	7841: {0x1E917, 0x1E939}, // '𞤗' => '𞤹'
	7844: {0x0057, 0x0077},   // 'W' => 'w'
	7845: {0x1E916, 0x1E938}, // '𞤖' => '𞤸'
	7848: {0x0056, 0x0076},   // 'V' => 'v'
	7849: {0x1E915, 0x1E937}, // '𞤕' => '𞤷'
	7852: {0x0055, 0x0075},   // 'U' => 'u'
	7853: {0x1E914, 0x1E936}, // '𞤔' => '𞤶'
	7856: {0x0054, 0x0074},   // 'T' => 't'
	7857: {0x1E913, 0x1E935}, // '𞤓' => '𞤵'
	7860: {0x0053, 0x0073},   // 'S' => 's'
	7861: {0x1E912, 0x1E934}, // '𞤒' => '𞤴'
	7864: {0x0052, 0x0072},   // 'R' => 'r'
	7865: {0x1E911, 0x1E933}, // '𞤑' => '𞤳'
	7867: {0x118BF, 0x118DF}, // '𑢿' => '𑣟'
	7868: {0x0051, 0x0071},   // 'Q' => 'q'
	7869: {0x1E910, 0x1E932}, // '𞤐' => '𞤲'
	7871: {0x118BE, 0x118DE}, // '𑢾' => '𑣞'
	7872: {0x0050, 0x0070},   // 'P' => 'p'
	7873: {0x1E90F, 0x1E931}, // '𞤏' => '𞤱'
	7875: {0x118BD, 0x118DD}, // '𑢽' => '𑣝'
	7876: {0x004F, 0x006F},   // 'O' => 'o'
	7877: {0x1E90E, 0x1E930}, // '𞤎' => '𞤰'
	7879: {0x118BC, 0x118DC}, // '𑢼' => '𑣜'
	7880: {0x004E, 0x006E},   // 'N' => 'n'
	7881: {0x1E90D, 0x1E92F}, // '𞤍' => '𞤯'
	7883: {0x118BB, 0x118DB}, // '𑢻' => '𑣛'
	7884: {0x004D, 0x006D},   // 'M' => 'm'
	7885: {0x1E90C, 0x1E92E}, // '𞤌' => '𞤮'
	7887: {0x118BA, 0x118DA}, // '𑢺' => '𑣚'
	7888: {0x004C, 0x006C},   // 'L' => 'l'
	7889: {0x1E90B, 0x1E92D}, // '𞤋' => '𞤭'
	7891: {0x118B9, 0x118D9}, // '𑢹' => '𑣙'
	7892: {0x004B, 0x006B},   // 'K' => 'k'
	7893: {0x1E90A, 0x1E92C}, // '𞤊' => '𞤬'
	7895: {0x118B8, 0x118D8}, // '𑢸' => '𑣘'
	7896: {0x004A, 0x006A},   // 'J' => 'j'
	7897: {0x1E909, 0x1E92B}, // '𞤉' => '𞤫'
	7899: {0x118B7, 0x118D7}, // '𑢷' => '𑣗'
	7900: {0x0049, 0x0069},   // 'I' => 'i'
	7901: {0x1E908, 0x1E92A}, // '𞤈' => '𞤪'
	7903: {0x118B6, 0x118D6}, // '𑢶' => '𑣖'
	7904: {0x0048, 0x0068},   // 'H' => 'h'
	7905: {0x1E907, 0x1E929}, // '𞤇' => '𞤩'
	7907: {0x118B5, 0x118D5}, // '𑢵' => '𑣕'
	7908: {0x0047, 0x0067},   // 'G' => 'g'
	7909: {0x1E906, 0x1E928}, // '𞤆' => '𞤨'
	7911: {0x118B4, 0x118D4}, // '𑢴' => '𑣔'
	7912: {0x0046, 0x0066},   // 'F' => 'f'
	7913: {0x1E905, 0x1E927}, // '𞤅' => '𞤧'
	7915: {0x118B3, 0x118D3}, // '𑢳' => '𑣓'
	7916: {0x0045, 0x0065},   // 'E' => 'e'
	7917: {0x1E904, 0x1E926}, // '𞤄' => '𞤦'
	7919: {0x118B2, 0x118D2}, // '𑢲' => '𑣒'
	7920: {0x0044, 0x0064},   // 'D' => 'd'
	7921: {0x1E903, 0x1E925}, // '𞤃' => '𞤥'
	7923: {0x118B1, 0x118D1}, // '𑢱' => '𑣑'
	7924: {0x0043, 0x0063},   // 'C' => 'c'
	7925: {0x1E902, 0x1E924}, // '𞤂' => '𞤤'
	7927: {0x118B0, 0x118D0}, // '𑢰' => '𑣐'
	7928: {0x0042, 0x0062},   // 'B' => 'b'
	7929: {0x1E901, 0x1E923}, // '𞤁' => '𞤣'
	7931: {0x118AF, 0x118CF}, // '𑢯' => '𑣏'
	7932: {0x0041, 0x0061},   // 'A' => 'a'
	7933: {0x1E900, 0x1E922}, // '𞤀' => '𞤢'
	7935: {0x118AE, 0x118CE}, // '𑢮' => '𑣎'
	7939: {0x118AD, 0x118CD}, // '𑢭' => '𑣍'
	7943: {0x118AC, 0x118CC}, // '𑢬' => '𑣌'
	7947: {0x118AB, 0x118CB}, // '𑢫' => '𑣋'
	7951: {0x118AA, 0x118CA}, // '𑢪' => '𑣊'
	7955: {0x118A9, 0x118C9}, // '𑢩' => '𑣉'
	7959: {0x118A8, 0x118C8}, // '𑢨' => '𑣈'
	7963: {0x118A7, 0x118C7}, // '𑢧' => '𑣇'
	7967: {0x118A6, 0x118C6}, // '𑢦' => '𑣆'
	7971: {0x118A5, 0x118C5}, // '𑢥' => '𑣅'
	7975: {0x118A4, 0x118C4}, // '𑢤' => '𑣄'
	7979: {0x118A3, 0x118C3}, // '𑢣' => '𑣃'
	7983: {0x118A2, 0x118C2}, // '𑢢' => '𑣂'
	7987: {0x118A1, 0x118C1}, // '𑢡' => '𑣁'
	7991: {0x118A0, 0x118C0}, // '𑢠' => '𑣀'
}

const _UpperLowerSeed = 0x6AE7FD95
const _UpperLowerShift = 19

// _UpperLower stores upper/lower case pairs of Unicode code points.
// This takes up more space than the stdlib's "unicode" package, but
// is roughly ~4x faster.
var _UpperLower = [8192][2]uint32{
	7648: {0x039C, 0x00B5},   // 'Μ' => 'µ'
	7615: {0x00C0, 0x00E0},   // 'À' => 'à'
	7612: {0x00C1, 0x00E1},   // 'Á' => 'á'
	7609: {0x00C2, 0x00E2},   // 'Â' => 'â'
	7606: {0x00C3, 0x00E3},   // 'Ã' => 'ã'
	7603: {0x00C4, 0x00E4},   // 'Ä' => 'ä'
	7600: {0x00C5, 0x00E5},   // 'Å' => 'å'
	7597: {0x00C6, 0x00E6},   // 'Æ' => 'æ'
	7594: {0x00C7, 0x00E7},   // 'Ç' => 'ç'
	7591: {0x00C8, 0x00E8},   // 'È' => 'è'
	7588: {0x00C9, 0x00E9},   // 'É' => 'é'
	7585: {0x00CA, 0x00EA},   // 'Ê' => 'ê'
	7582: {0x00CB, 0x00EB},   // 'Ë' => 'ë'
	7579: {0x00CC, 0x00EC},   // 'Ì' => 'ì'
	7576: {0x00CD, 0x00ED},   // 'Í' => 'í'
	7573: {0x00CE, 0x00EE},   // 'Î' => 'î'
	7570: {0x00CF, 0x00EF},   // 'Ï' => 'ï'
	7567: {0x00D0, 0x00F0},   // 'Ð' => 'ð'
	7564: {0x00D1, 0x00F1},   // 'Ñ' => 'ñ'
	7561: {0x00D2, 0x00F2},   // 'Ò' => 'ò'
	7558: {0x00D3, 0x00F3},   // 'Ó' => 'ó'
	7555: {0x00D4, 0x00F4},   // 'Ô' => 'ô'
	7552: {0x00D5, 0x00F5},   // 'Õ' => 'õ'
	7549: {0x00D6, 0x00F6},   // 'Ö' => 'ö'
	7543: {0x00D8, 0x00F8},   // 'Ø' => 'ø'
	7540: {0x00D9, 0x00F9},   // 'Ù' => 'ù'
	7537: {0x00DA, 0x00FA},   // 'Ú' => 'ú'
	7534: {0x00DB, 0x00FB},   // 'Û' => 'û'
	7531: {0x00DC, 0x00FC},   // 'Ü' => 'ü'
	7528: {0x00DD, 0x00FD},   // 'Ý' => 'ý'
	7525: {0x00DE, 0x00FE},   // 'Þ' => 'þ'
	7519: {0x00C0, 0x00E0},   // 'À' => 'à'
	7516: {0x00C1, 0x00E1},   // 'Á' => 'á'
	7513: {0x00C2, 0x00E2},   // 'Â' => 'â'
	7510: {0x00C3, 0x00E3},   // 'Ã' => 'ã'
	7507: {0x00C4, 0x00E4},   // 'Ä' => 'ä'
	7504: {0x00C5, 0x00E5},   // 'Å' => 'å'
	7501: {0x00C6, 0x00E6},   // 'Æ' => 'æ'
	7498: {0x00C7, 0x00E7},   // 'Ç' => 'ç'
	7495: {0x00C8, 0x00E8},   // 'È' => 'è'
	7492: {0x00C9, 0x00E9},   // 'É' => 'é'
	7489: {0x00CA, 0x00EA},   // 'Ê' => 'ê'
	7486: {0x00CB, 0x00EB},   // 'Ë' => 'ë'
	7483: {0x00CC, 0x00EC},   // 'Ì' => 'ì'
	7480: {0x00CD, 0x00ED},   // 'Í' => 'í'
	7477: {0x00CE, 0x00EE},   // 'Î' => 'î'
	7474: {0x00CF, 0x00EF},   // 'Ï' => 'ï'
	7471: {0x00D0, 0x00F0},   // 'Ð' => 'ð'
	7468: {0x00D1, 0x00F1},   // 'Ñ' => 'ñ'
	7465: {0x00D2, 0x00F2},   // 'Ò' => 'ò'
	7462: {0x00D3, 0x00F3},   // 'Ó' => 'ó'
	7459: {0x00D4, 0x00F4},   // 'Ô' => 'ô'
	7456: {0x00D5, 0x00F5},   // 'Õ' => 'õ'
	7453: {0x00D6, 0x00F6},   // 'Ö' => 'ö'
	7447: {0x00D8, 0x00F8},   // 'Ø' => 'ø'
	7444: {0x00D9, 0x00F9},   // 'Ù' => 'ù'
	7441: {0x00DA, 0x00FA},   // 'Ú' => 'ú'
	7438: {0x00DB, 0x00FB},   // 'Û' => 'û'
	7435: {0x00DC, 0x00FC},   // 'Ü' => 'ü'
	7432: {0x00DD, 0x00FD},   // 'Ý' => 'ý'
	7429: {0x00DE, 0x00FE},   // 'Þ' => 'þ'
	7426: {0x0178, 0x00FF},   // 'Ÿ' => 'ÿ'
	7423: {0x0100, 0x0101},   // 'Ā' => 'ā'
	7420: {0x0100, 0x0101},   // 'Ā' => 'ā'
	7417: {0x0102, 0x0103},   // 'Ă' => 'ă'
	7414: {0x0102, 0x0103},   // 'Ă' => 'ă'
	7411: {0x0104, 0x0105},   // 'Ą' => 'ą'
	7408: {0x0104, 0x0105},   // 'Ą' => 'ą'
	7405: {0x0106, 0x0107},   // 'Ć' => 'ć'
	7402: {0x0106, 0x0107},   // 'Ć' => 'ć'
	7399: {0x0108, 0x0109},   // 'Ĉ' => 'ĉ'
	7396: {0x0108, 0x0109},   // 'Ĉ' => 'ĉ'
	7393: {0x010A, 0x010B},   // 'Ċ' => 'ċ'
	7390: {0x010A, 0x010B},   // 'Ċ' => 'ċ'
	7387: {0x010C, 0x010D},   // 'Č' => 'č'
	7384: {0x010C, 0x010D},   // 'Č' => 'č'
	7381: {0x010E, 0x010F},   // 'Ď' => 'ď'
	7378: {0x010E, 0x010F},   // 'Ď' => 'ď'
	7375: {0x0110, 0x0111},   // 'Đ' => 'đ'
	7372: {0x0110, 0x0111},   // 'Đ' => 'đ'
	7369: {0x0112, 0x0113},   // 'Ē' => 'ē'
	7366: {0x0112, 0x0113},   // 'Ē' => 'ē'
	7363: {0x0114, 0x0115},   // 'Ĕ' => 'ĕ'
	7360: {0x0114, 0x0115},   // 'Ĕ' => 'ĕ'
	7357: {0x0116, 0x0117},   // 'Ė' => 'ė'
	7354: {0x0116, 0x0117},   // 'Ė' => 'ė'
	7351: {0x0118, 0x0119},   // 'Ę' => 'ę'
	7348: {0x0118, 0x0119},   // 'Ę' => 'ę'
	7345: {0x011A, 0x011B},   // 'Ě' => 'ě'
	7342: {0x011A, 0x011B},   // 'Ě' => 'ě'
	7339: {0x011C, 0x011D},   // 'Ĝ' => 'ĝ'
	7336: {0x011C, 0x011D},   // 'Ĝ' => 'ĝ'
	7333: {0x011E, 0x011F},   // 'Ğ' => 'ğ'
	7330: {0x011E, 0x011F},   // 'Ğ' => 'ğ'
	7327: {0x0120, 0x0121},   // 'Ġ' => 'ġ'
	7324: {0x0120, 0x0121},   // 'Ġ' => 'ġ'
	7321: {0x0122, 0x0123},   // 'Ģ' => 'ģ'
	7318: {0x0122, 0x0123},   // 'Ģ' => 'ģ'
	7315: {0x0124, 0x0125},   // 'Ĥ' => 'ĥ'
	7312: {0x0124, 0x0125},   // 'Ĥ' => 'ĥ'
	7309: {0x0126, 0x0127},   // 'Ħ' => 'ħ'
	7306: {0x0126, 0x0127},   // 'Ħ' => 'ħ'
	7303: {0x0128, 0x0129},   // 'Ĩ' => 'ĩ'
	7300: {0x0128, 0x0129},   // 'Ĩ' => 'ĩ'
	7297: {0x012A, 0x012B},   // 'Ī' => 'ī'
	7294: {0x012A, 0x012B},   // 'Ī' => 'ī'
	7291: {0x012C, 0x012D},   // 'Ĭ' => 'ĭ'
	7288: {0x012C, 0x012D},   // 'Ĭ' => 'ĭ'
	7285: {0x012E, 0x012F},   // 'Į' => 'į'
	7282: {0x012E, 0x012F},   // 'Į' => 'į'
	7279: {0x0130, 0x0069},   // 'İ' => 'i'
	7276: {0x0049, 0x0131},   // 'I' => 'ı'
	7273: {0x0132, 0x0133},   // 'Ĳ' => 'ĳ'
	7270: {0x0132, 0x0133},   // 'Ĳ' => 'ĳ'
	7267: {0x0134, 0x0135},   // 'Ĵ' => 'ĵ'
	7264: {0x0134, 0x0135},   // 'Ĵ' => 'ĵ'
	7261: {0x0136, 0x0137},   // 'Ķ' => 'ķ'
	7258: {0x0136, 0x0137},   // 'Ķ' => 'ķ'
	7252: {0x0139, 0x013A},   // 'Ĺ' => 'ĺ'
	7249: {0x0139, 0x013A},   // 'Ĺ' => 'ĺ'
	7246: {0x013B, 0x013C},   // 'Ļ' => 'ļ'
	7243: {0x013B, 0x013C},   // 'Ļ' => 'ļ'
	7240: {0x013D, 0x013E},   // 'Ľ' => 'ľ'
	7237: {0x013D, 0x013E},   // 'Ľ' => 'ľ'
	7234: {0x013F, 0x0140},   // 'Ŀ' => 'ŀ'
	7231: {0x013F, 0x0140},   // 'Ŀ' => 'ŀ'
	7228: {0x0141, 0x0142},   // 'Ł' => 'ł'
	7225: {0x0141, 0x0142},   // 'Ł' => 'ł'
	7222: {0x0143, 0x0144},   // 'Ń' => 'ń'
	7219: {0x0143, 0x0144},   // 'Ń' => 'ń'
	7216: {0x0145, 0x0146},   // 'Ņ' => 'ņ'
	7213: {0x0145, 0x0146},   // 'Ņ' => 'ņ'
	7210: {0x0147, 0x0148},   // 'Ň' => 'ň'
	7207: {0x0147, 0x0148},   // 'Ň' => 'ň'
	7201: {0x014A, 0x014B},   // 'Ŋ' => 'ŋ'
	7198: {0x014A, 0x014B},   // 'Ŋ' => 'ŋ'
	7195: {0x014C, 0x014D},   // 'Ō' => 'ō'
	7192: {0x014C, 0x014D},   // 'Ō' => 'ō'
	7189: {0x014E, 0x014F},   // 'Ŏ' => 'ŏ'
	7186: {0x014E, 0x014F},   // 'Ŏ' => 'ŏ'
	7183: {0x0150, 0x0151},   // 'Ő' => 'ő'
	7180: {0x0150, 0x0151},   // 'Ő' => 'ő'
	7177: {0x0152, 0x0153},   // 'Œ' => 'œ'
	7174: {0x0152, 0x0153},   // 'Œ' => 'œ'
	7171: {0x0154, 0x0155},   // 'Ŕ' => 'ŕ'
	7168: {0x0154, 0x0155},   // 'Ŕ' => 'ŕ'
	7165: {0x0156, 0x0157},   // 'Ŗ' => 'ŗ'
	7162: {0x0156, 0x0157},   // 'Ŗ' => 'ŗ'
	7159: {0x0158, 0x0159},   // 'Ř' => 'ř'
	7156: {0x0158, 0x0159},   // 'Ř' => 'ř'
	7153: {0x015A, 0x015B},   // 'Ś' => 'ś'
	7150: {0x015A, 0x015B},   // 'Ś' => 'ś'
	7147: {0x015C, 0x015D},   // 'Ŝ' => 'ŝ'
	7144: {0x015C, 0x015D},   // 'Ŝ' => 'ŝ'
	7141: {0x015E, 0x015F},   // 'Ş' => 'ş'
	7138: {0x015E, 0x015F},   // 'Ş' => 'ş'
	7135: {0x0160, 0x0161},   // 'Š' => 'š'
	7132: {0x0160, 0x0161},   // 'Š' => 'š'
	7129: {0x0162, 0x0163},   // 'Ţ' => 'ţ'
	7126: {0x0162, 0x0163},   // 'Ţ' => 'ţ'
	7123: {0x0164, 0x0165},   // 'Ť' => 'ť'
	7120: {0x0164, 0x0165},   // 'Ť' => 'ť'
	7117: {0x0166, 0x0167},   // 'Ŧ' => 'ŧ'
	7114: {0x0166, 0x0167},   // 'Ŧ' => 'ŧ'
	7111: {0x0168, 0x0169},   // 'Ũ' => 'ũ'
	7108: {0x0168, 0x0169},   // 'Ũ' => 'ũ'
	7105: {0x016A, 0x016B},   // 'Ū' => 'ū'
	7102: {0x016A, 0x016B},   // 'Ū' => 'ū'
	7099: {0x016C, 0x016D},   // 'Ŭ' => 'ŭ'
	7096: {0x016C, 0x016D},   // 'Ŭ' => 'ŭ'
	7093: {0x016E, 0x016F},   // 'Ů' => 'ů'
	7090: {0x016E, 0x016F},   // 'Ů' => 'ů'
	7087: {0x0170, 0x0171},   // 'Ű' => 'ű'
	7084: {0x0170, 0x0171},   // 'Ű' => 'ű'
	7081: {0x0172, 0x0173},   // 'Ų' => 'ų'
	7078: {0x0172, 0x0173},   // 'Ų' => 'ų'
	7075: {0x0174, 0x0175},   // 'Ŵ' => 'ŵ'
	7072: {0x0174, 0x0175},   // 'Ŵ' => 'ŵ'
	7069: {0x0176, 0x0177},   // 'Ŷ' => 'ŷ'
	7066: {0x0176, 0x0177},   // 'Ŷ' => 'ŷ'
	7063: {0x0178, 0x00FF},   // 'Ÿ' => 'ÿ'
	7060: {0x0179, 0x017A},   // 'Ź' => 'ź'
	7057: {0x0179, 0x017A},   // 'Ź' => 'ź'
	7054: {0x017B, 0x017C},   // 'Ż' => 'ż'
	7051: {0x017B, 0x017C},   // 'Ż' => 'ż'
	7048: {0x017D, 0x017E},   // 'Ž' => 'ž'
	7045: {0x017D, 0x017E},   // 'Ž' => 'ž'
	7042: {0x0053, 0x017F},   // 'S' => 'ſ'
	7039: {0x0243, 0x0180},   // 'Ƀ' => 'ƀ'
	7036: {0x0181, 0x0253},   // 'Ɓ' => 'ɓ'
	7033: {0x0182, 0x0183},   // 'Ƃ' => 'ƃ'
	7030: {0x0182, 0x0183},   // 'Ƃ' => 'ƃ'
	7027: {0x0184, 0x0185},   // 'Ƅ' => 'ƅ'
	7024: {0x0184, 0x0185},   // 'Ƅ' => 'ƅ'
	7021: {0x0186, 0x0254},   // 'Ɔ' => 'ɔ'
	7018: {0x0187, 0x0188},   // 'Ƈ' => 'ƈ'
	7015: {0x0187, 0x0188},   // 'Ƈ' => 'ƈ'
	7012: {0x0189, 0x0256},   // 'Ɖ' => 'ɖ'
	7009: {0x018A, 0x0257},   // 'Ɗ' => 'ɗ'
	7006: {0x018B, 0x018C},   // 'Ƌ' => 'ƌ'
	7003: {0x018B, 0x018C},   // 'Ƌ' => 'ƌ'
	6997: {0x018E, 0x01DD},   // 'Ǝ' => 'ǝ'
	6994: {0x018F, 0x0259},   // 'Ə' => 'ə'
	6991: {0x0190, 0x025B},   // 'Ɛ' => 'ɛ'
	6988: {0x0191, 0x0192},   // 'Ƒ' => 'ƒ'
	6985: {0x0191, 0x0192},   // 'Ƒ' => 'ƒ'
	6982: {0x0193, 0x0260},   // 'Ɠ' => 'ɠ'
	6979: {0x0194, 0x0263},   // 'Ɣ' => 'ɣ'
	6976: {0x01F6, 0x0195},   // 'Ƕ' => 'ƕ'
	6973: {0x0196, 0x0269},   // 'Ɩ' => 'ɩ'
	6970: {0x0197, 0x0268},   // 'Ɨ' => 'ɨ'
	6967: {0x0198, 0x0199},   // 'Ƙ' => 'ƙ'
	6964: {0x0198, 0x0199},   // 'Ƙ' => 'ƙ'
	6961: {0x023D, 0x019A},   // 'Ƚ' => 'ƚ'
	6955: {0x019C, 0x026F},   // 'Ɯ' => 'ɯ'
	6952: {0x019D, 0x0272},   // 'Ɲ' => 'ɲ'
	6949: {0x0220, 0x019E},   // 'Ƞ' => 'ƞ'
	6946: {0x019F, 0x0275},   // 'Ɵ' => 'ɵ'
	6943: {0x01A0, 0x01A1},   // 'Ơ' => 'ơ'
	6940: {0x01A0, 0x01A1},   // 'Ơ' => 'ơ'
	6937: {0x01A2, 0x01A3},   // 'Ƣ' => 'ƣ'
	6934: {0x01A2, 0x01A3},   // 'Ƣ' => 'ƣ'
	6931: {0x01A4, 0x01A5},   // 'Ƥ' => 'ƥ'
	6928: {0x01A4, 0x01A5},   // 'Ƥ' => 'ƥ'
	6925: {0x01A6, 0x0280},   // 'Ʀ' => 'ʀ'
	6922: {0x01A7, 0x01A8},   // 'Ƨ' => 'ƨ'
	6919: {0x01A7, 0x01A8},   // 'Ƨ' => 'ƨ'
	6916: {0x01A9, 0x0283},   // 'Ʃ' => 'ʃ'
	6907: {0x01AC, 0x01AD},   // 'Ƭ' => 'ƭ'
	6904: {0x01AC, 0x01AD},   // 'Ƭ' => 'ƭ'
	6901: {0x01AE, 0x0288},   // 'Ʈ' => 'ʈ'
	6898: {0x01AF, 0x01B0},   // 'Ư' => 'ư'
	6895: {0x01AF, 0x01B0},   // 'Ư' => 'ư'
	6892: {0x01B1, 0x028A},   // 'Ʊ' => 'ʊ'
	6889: {0x01B2, 0x028B},   // 'Ʋ' => 'ʋ'
	6886: {0x01B3, 0x01B4},   // 'Ƴ' => 'ƴ'
	6883: {0x01B3, 0x01B4},   // 'Ƴ' => 'ƴ'
	6880: {0x01B5, 0x01B6},   // 'Ƶ' => 'ƶ'
	6877: {0x01B5, 0x01B6},   // 'Ƶ' => 'ƶ'
	6874: {0x01B7, 0x0292},   // 'Ʒ' => 'ʒ'
	6871: {0x01B8, 0x01B9},   // 'Ƹ' => 'ƹ'
	6868: {0x01B8, 0x01B9},   // 'Ƹ' => 'ƹ'
	6859: {0x01BC, 0x01BD},   // 'Ƽ' => 'ƽ'
	6856: {0x01BC, 0x01BD},   // 'Ƽ' => 'ƽ'
	6850: {0x01F7, 0x01BF},   // 'Ƿ' => 'ƿ'
	6835: {0x01C4, 0x01C6},   // 'Ǆ' => 'ǆ'
	6829: {0x01C4, 0x01C6},   // 'Ǆ' => 'ǆ'
	6826: {0x01C7, 0x01C9},   // 'Ǉ' => 'ǉ'
	6820: {0x01C7, 0x01C9},   // 'Ǉ' => 'ǉ'
	6817: {0x01CA, 0x01CC},   // 'Ǌ' => 'ǌ'
	6811: {0x01CA, 0x01CC},   // 'Ǌ' => 'ǌ'
	6808: {0x01CD, 0x01CE},   // 'Ǎ' => 'ǎ'
	6805: {0x01CD, 0x01CE},   // 'Ǎ' => 'ǎ'
	6802: {0x01CF, 0x01D0},   // 'Ǐ' => 'ǐ'
	6799: {0x01CF, 0x01D0},   // 'Ǐ' => 'ǐ'
	6796: {0x01D1, 0x01D2},   // 'Ǒ' => 'ǒ'
	6793: {0x01D1, 0x01D2},   // 'Ǒ' => 'ǒ'
	6790: {0x01D3, 0x01D4},   // 'Ǔ' => 'ǔ'
	6787: {0x01D3, 0x01D4},   // 'Ǔ' => 'ǔ'
	6784: {0x01D5, 0x01D6},   // 'Ǖ' => 'ǖ'
	6781: {0x01D5, 0x01D6},   // 'Ǖ' => 'ǖ'
	6778: {0x01D7, 0x01D8},   // 'Ǘ' => 'ǘ'
	6775: {0x01D7, 0x01D8},   // 'Ǘ' => 'ǘ'
	6772: {0x01D9, 0x01DA},   // 'Ǚ' => 'ǚ'
	6769: {0x01D9, 0x01DA},   // 'Ǚ' => 'ǚ'
	6766: {0x01DB, 0x01DC},   // 'Ǜ' => 'ǜ'
	6763: {0x01DB, 0x01DC},   // 'Ǜ' => 'ǜ'
	6760: {0x018E, 0x01DD},   // 'Ǝ' => 'ǝ'
	6757: {0x01DE, 0x01DF},   // 'Ǟ' => 'ǟ'
	6754: {0x01DE, 0x01DF},   // 'Ǟ' => 'ǟ'
	6751: {0x01E0, 0x01E1},   // 'Ǡ' => 'ǡ'
	6748: {0x01E0, 0x01E1},   // 'Ǡ' => 'ǡ'
	6745: {0x01E2, 0x01E3},   // 'Ǣ' => 'ǣ'
	6742: {0x01E2, 0x01E3},   // 'Ǣ' => 'ǣ'
	6739: {0x01E4, 0x01E5},   // 'Ǥ' => 'ǥ'
	6736: {0x01E4, 0x01E5},   // 'Ǥ' => 'ǥ'
	6733: {0x01E6, 0x01E7},   // 'Ǧ' => 'ǧ'
	6730: {0x01E6, 0x01E7},   // 'Ǧ' => 'ǧ'
	6727: {0x01E8, 0x01E9},   // 'Ǩ' => 'ǩ'
	6724: {0x01E8, 0x01E9},   // 'Ǩ' => 'ǩ'
	6721: {0x01EA, 0x01EB},   // 'Ǫ' => 'ǫ'
	6718: {0x01EA, 0x01EB},   // 'Ǫ' => 'ǫ'
	6715: {0x01EC, 0x01ED},   // 'Ǭ' => 'ǭ'
	6712: {0x01EC, 0x01ED},   // 'Ǭ' => 'ǭ'
	6709: {0x01EE, 0x01EF},   // 'Ǯ' => 'ǯ'
	6706: {0x01EE, 0x01EF},   // 'Ǯ' => 'ǯ'
	6700: {0x01F1, 0x01F3},   // 'Ǳ' => 'ǳ'
	6694: {0x01F1, 0x01F3},   // 'Ǳ' => 'ǳ'
	6691: {0x01F4, 0x01F5},   // 'Ǵ' => 'ǵ'
	6688: {0x01F4, 0x01F5},   // 'Ǵ' => 'ǵ'
	6685: {0x01F6, 0x0195},   // 'Ƕ' => 'ƕ'
	6682: {0x01F7, 0x01BF},   // 'Ƿ' => 'ƿ'
	6679: {0x01F8, 0x01F9},   // 'Ǹ' => 'ǹ'
	6676: {0x01F8, 0x01F9},   // 'Ǹ' => 'ǹ'
	6673: {0x01FA, 0x01FB},   // 'Ǻ' => 'ǻ'
	6670: {0x01FA, 0x01FB},   // 'Ǻ' => 'ǻ'
	6667: {0x01FC, 0x01FD},   // 'Ǽ' => 'ǽ'
	6664: {0x01FC, 0x01FD},   // 'Ǽ' => 'ǽ'
	6661: {0x01FE, 0x01FF},   // 'Ǿ' => 'ǿ'
	6658: {0x01FE, 0x01FF},   // 'Ǿ' => 'ǿ'
	6655: {0x0200, 0x0201},   // 'Ȁ' => 'ȁ'
	6652: {0x0200, 0x0201},   // 'Ȁ' => 'ȁ'
	6649: {0x0202, 0x0203},   // 'Ȃ' => 'ȃ'
	6646: {0x0202, 0x0203},   // 'Ȃ' => 'ȃ'
	6643: {0x0204, 0x0205},   // 'Ȅ' => 'ȅ'
	6640: {0x0204, 0x0205},   // 'Ȅ' => 'ȅ'
	6637: {0x0206, 0x0207},   // 'Ȇ' => 'ȇ'
	6634: {0x0206, 0x0207},   // 'Ȇ' => 'ȇ'
	6631: {0x0208, 0x0209},   // 'Ȉ' => 'ȉ'
	6628: {0x0208, 0x0209},   // 'Ȉ' => 'ȉ'
	6625: {0x020A, 0x020B},   // 'Ȋ' => 'ȋ'
	6622: {0x020A, 0x020B},   // 'Ȋ' => 'ȋ'
	6619: {0x020C, 0x020D},   // 'Ȍ' => 'ȍ'
	6616: {0x020C, 0x020D},   // 'Ȍ' => 'ȍ'
	6613: {0x020E, 0x020F},   // 'Ȏ' => 'ȏ'
	6610: {0x020E, 0x020F},   // 'Ȏ' => 'ȏ'
	6607: {0x0210, 0x0211},   // 'Ȑ' => 'ȑ'
	6604: {0x0210, 0x0211},   // 'Ȑ' => 'ȑ'
	6601: {0x0212, 0x0213},   // 'Ȓ' => 'ȓ'
	6598: {0x0212, 0x0213},   // 'Ȓ' => 'ȓ'
	6595: {0x0214, 0x0215},   // 'Ȕ' => 'ȕ'
	6592: {0x0214, 0x0215},   // 'Ȕ' => 'ȕ'
	6589: {0x0216, 0x0217},   // 'Ȗ' => 'ȗ'
	6586: {0x0216, 0x0217},   // 'Ȗ' => 'ȗ'
	6583: {0x0218, 0x0219},   // 'Ș' => 'ș'
	6580: {0x0218, 0x0219},   // 'Ș' => 'ș'
	6577: {0x021A, 0x021B},   // 'Ț' => 'ț'
	6574: {0x021A, 0x021B},   // 'Ț' => 'ț'
	6571: {0x021C, 0x021D},   // 'Ȝ' => 'ȝ'
	6568: {0x021C, 0x021D},   // 'Ȝ' => 'ȝ'
	6565: {0x021E, 0x021F},   // 'Ȟ' => 'ȟ'
	6562: {0x021E, 0x021F},   // 'Ȟ' => 'ȟ'
	6559: {0x0220, 0x019E},   // 'Ƞ' => 'ƞ'
	6553: {0x0222, 0x0223},   // 'Ȣ' => 'ȣ'
	6550: {0x0222, 0x0223},   // 'Ȣ' => 'ȣ'
	6547: {0x0224, 0x0225},   // 'Ȥ' => 'ȥ'
	6544: {0x0224, 0x0225},   // 'Ȥ' => 'ȥ'
	6541: {0x0226, 0x0227},   // 'Ȧ' => 'ȧ'
	6538: {0x0226, 0x0227},   // 'Ȧ' => 'ȧ'
	6535: {0x0228, 0x0229},   // 'Ȩ' => 'ȩ'
	6532: {0x0228, 0x0229},   // 'Ȩ' => 'ȩ'
	6529: {0x022A, 0x022B},   // 'Ȫ' => 'ȫ'
	6526: {0x022A, 0x022B},   // 'Ȫ' => 'ȫ'
	6523: {0x022C, 0x022D},   // 'Ȭ' => 'ȭ'
	6520: {0x022C, 0x022D},   // 'Ȭ' => 'ȭ'
	6517: {0x022E, 0x022F},   // 'Ȯ' => 'ȯ'
	6514: {0x022E, 0x022F},   // 'Ȯ' => 'ȯ'
	6511: {0x0230, 0x0231},   // 'Ȱ' => 'ȱ'
	6508: {0x0230, 0x0231},   // 'Ȱ' => 'ȱ'
	6505: {0x0232, 0x0233},   // 'Ȳ' => 'ȳ'
	6502: {0x0232, 0x0233},   // 'Ȳ' => 'ȳ'
	6481: {0x023A, 0x2C65},   // 'Ⱥ' => 'ⱥ'
	6478: {0x023B, 0x023C},   // 'Ȼ' => 'ȼ'
	6475: {0x023B, 0x023C},   // 'Ȼ' => 'ȼ'
	6472: {0x023D, 0x019A},   // 'Ƚ' => 'ƚ'
	6469: {0x023E, 0x2C66},   // 'Ⱦ' => 'ⱦ'
	6466: {0x2C7E, 0x023F},   // 'Ȿ' => 'ȿ'
	6463: {0x2C7F, 0x0240},   // 'Ɀ' => 'ɀ'
	6460: {0x0241, 0x0242},   // 'Ɂ' => 'ɂ'
	6457: {0x0241, 0x0242},   // 'Ɂ' => 'ɂ'
	6454: {0x0243, 0x0180},   // 'Ƀ' => 'ƀ'
	6451: {0x0244, 0x0289},   // 'Ʉ' => 'ʉ'
	6448: {0x0245, 0x028C},   // 'Ʌ' => 'ʌ'
	6445: {0x0246, 0x0247},   // 'Ɇ' => 'ɇ'
	6442: {0x0246, 0x0247},   // 'Ɇ' => 'ɇ'
	6439: {0x0248, 0x0249},   // 'Ɉ' => 'ɉ'
	6436: {0x0248, 0x0249},   // 'Ɉ' => 'ɉ'
	6433: {0x024A, 0x024B},   // 'Ɋ' => 'ɋ'
	6430: {0x024A, 0x024B},   // 'Ɋ' => 'ɋ'
	6427: {0x024C, 0x024D},   // 'Ɍ' => 'ɍ'
	6424: {0x024C, 0x024D},   // 'Ɍ' => 'ɍ'
	6421: {0x024E, 0x024F},   // 'Ɏ' => 'ɏ'
	6418: {0x024E, 0x024F},   // 'Ɏ' => 'ɏ'
	6415: {0x2C6F, 0x0250},   // 'Ɐ' => 'ɐ'
	6412: {0x2C6D, 0x0251},   // 'Ɑ' => 'ɑ'
	6409: {0x2C70, 0x0252},   // 'Ɒ' => 'ɒ'
	6406: {0x0181, 0x0253},   // 'Ɓ' => 'ɓ'
	6403: {0x0186, 0x0254},   // 'Ɔ' => 'ɔ'
	6397: {0x0189, 0x0256},   // 'Ɖ' => 'ɖ'
	6394: {0x018A, 0x0257},   // 'Ɗ' => 'ɗ'
	6388: {0x018F, 0x0259},   // 'Ə' => 'ə'
	6382: {0x0190, 0x025B},   // 'Ɛ' => 'ɛ'
	6379: {0xA7AB, 0x025C},   // 'Ɜ' => 'ɜ'
	6367: {0x0193, 0x0260},   // 'Ɠ' => 'ɠ'
	6364: {0xA7AC, 0x0261},   // 'Ɡ' => 'ɡ'
	6358: {0x0194, 0x0263},   // 'Ɣ' => 'ɣ'
	6352: {0xA78D, 0x0265},   // 'Ɥ' => 'ɥ'
	6349: {0xA7AA, 0x0266},   // 'Ɦ' => 'ɦ'
	6343: {0x0197, 0x0268},   // 'Ɨ' => 'ɨ'
	6340: {0x0196, 0x0269},   // 'Ɩ' => 'ɩ'
	6337: {0xA7AE, 0x026A},   // 'Ɪ' => 'ɪ'
	6334: {0x2C62, 0x026B},   // 'Ɫ' => 'ɫ'
	6331: {0xA7AD, 0x026C},   // 'Ɬ' => 'ɬ'
	6322: {0x019C, 0x026F},   // 'Ɯ' => 'ɯ'
	6316: {0x2C6E, 0x0271},   // 'Ɱ' => 'ɱ'
	6313: {0x019D, 0x0272},   // 'Ɲ' => 'ɲ'
	6304: {0x019F, 0x0275},   // 'Ɵ' => 'ɵ'
	6280: {0x2C64, 0x027D},   // 'Ɽ' => 'ɽ'
	6271: {0x01A6, 0x0280},   // 'Ʀ' => 'ʀ'
	6265: {0xA7C5, 0x0282},   // 'Ʂ' => 'ʂ'
	6262: {0x01A9, 0x0283},   // 'Ʃ' => 'ʃ'
	6250: {0xA7B1, 0x0287},   // 'Ʇ' => 'ʇ'
	6247: {0x01AE, 0x0288},   // 'Ʈ' => 'ʈ'
	6244: {0x0244, 0x0289},   // 'Ʉ' => 'ʉ'
	6241: {0x01B1, 0x028A},   // 'Ʊ' => 'ʊ'
	6238: {0x01B2, 0x028B},   // 'Ʋ' => 'ʋ'
	6235: {0x0245, 0x028C},   // 'Ʌ' => 'ʌ'
	6217: {0x01B7, 0x0292},   // 'Ʒ' => 'ʒ'
	6184: {0xA7B2, 0x029D},   // 'Ʝ' => 'ʝ'
	6181: {0xA7B0, 0x029E},   // 'Ʞ' => 'ʞ'
	5680: {0x0399, 0x0345},   // 'Ι' => 'ͅ'
	5550: {0x0370, 0x0371},   // 'Ͱ' => 'ͱ'
	5547: {0x0370, 0x0371},   // 'Ͱ' => 'ͱ'
	5544: {0x0372, 0x0373},   // 'Ͳ' => 'ͳ'
	5541: {0x0372, 0x0373},   // 'Ͳ' => 'ͳ'
	5532: {0x0376, 0x0377},   // 'Ͷ' => 'ͷ'
	5529: {0x0376, 0x0377},   // 'Ͷ' => 'ͷ'
	5517: {0x03FD, 0x037B},   // 'Ͻ' => 'ͻ'
	5514: {0x03FE, 0x037C},   // 'Ͼ' => 'ͼ'
	5511: {0x03FF, 0x037D},   // 'Ͽ' => 'ͽ'
	5505: {0x037F, 0x03F3},   // 'Ϳ' => 'ϳ'
	5484: {0x0386, 0x03AC},   // 'Ά' => 'ά'
	5478: {0x0388, 0x03AD},   // 'Έ' => 'έ'
	5475: {0x0389, 0x03AE},   // 'Ή' => 'ή'
	5472: {0x038A, 0x03AF},   // 'Ί' => 'ί'
	5466: {0x038C, 0x03CC},   // 'Ό' => 'ό'
	5460: {0x038E, 0x03CD},   // 'Ύ' => 'ύ'
	5457: {0x038F, 0x03CE},   // 'Ώ' => 'ώ'
	5451: {0x0391, 0x03B1},   // 'Α' => 'α'
	5448: {0x0392, 0x03B2},   // 'Β' => 'β'
	5445: {0x0393, 0x03B3},   // 'Γ' => 'γ'
	5442: {0x0394, 0x03B4},   // 'Δ' => 'δ'
	5439: {0x0395, 0x03B5},   // 'Ε' => 'ε'
	5436: {0x0396, 0x03B6},   // 'Ζ' => 'ζ'
	5433: {0x0397, 0x03B7},   // 'Η' => 'η'
	5430: {0x0398, 0x03B8},   // 'Θ' => 'θ'
	5427: {0x0399, 0x03B9},   // 'Ι' => 'ι'
	5424: {0x039A, 0x03BA},   // 'Κ' => 'κ'
	5421: {0x039B, 0x03BB},   // 'Λ' => 'λ'
	5418: {0x039C, 0x03BC},   // 'Μ' => 'μ'
	5415: {0x039D, 0x03BD},   // 'Ν' => 'ν'
	5412: {0x039E, 0x03BE},   // 'Ξ' => 'ξ'
	5409: {0x039F, 0x03BF},   // 'Ο' => 'ο'
	5406: {0x03A0, 0x03C0},   // 'Π' => 'π'
	5403: {0x03A1, 0x03C1},   // 'Ρ' => 'ρ'
	5397: {0x03A3, 0x03C3},   // 'Σ' => 'σ'
	5394: {0x03A4, 0x03C4},   // 'Τ' => 'τ'
	5391: {0x03A5, 0x03C5},   // 'Υ' => 'υ'
	5388: {0x03A6, 0x03C6},   // 'Φ' => 'φ'
	5385: {0x03A7, 0x03C7},   // 'Χ' => 'χ'
	5382: {0x03A8, 0x03C8},   // 'Ψ' => 'ψ'
	5379: {0x03A9, 0x03C9},   // 'Ω' => 'ω'
	5376: {0x03AA, 0x03CA},   // 'Ϊ' => 'ϊ'
	5373: {0x03AB, 0x03CB},   // 'Ϋ' => 'ϋ'
	5370: {0x0386, 0x03AC},   // 'Ά' => 'ά'
	5367: {0x0388, 0x03AD},   // 'Έ' => 'έ'
	5364: {0x0389, 0x03AE},   // 'Ή' => 'ή'
	5361: {0x038A, 0x03AF},   // 'Ί' => 'ί'
	5355: {0x0391, 0x03B1},   // 'Α' => 'α'
	5352: {0x0392, 0x03B2},   // 'Β' => 'β'
	5349: {0x0393, 0x03B3},   // 'Γ' => 'γ'
	5346: {0x0394, 0x03B4},   // 'Δ' => 'δ'
	5343: {0x0395, 0x03B5},   // 'Ε' => 'ε'
	5340: {0x0396, 0x03B6},   // 'Ζ' => 'ζ'
	5337: {0x0397, 0x03B7},   // 'Η' => 'η'
	5334: {0x0398, 0x03B8},   // 'Θ' => 'θ'
	5331: {0x0399, 0x03B9},   // 'Ι' => 'ι'
	5328: {0x039A, 0x03BA},   // 'Κ' => 'κ'
	5325: {0x039B, 0x03BB},   // 'Λ' => 'λ'
	5322: {0x039C, 0x03BC},   // 'Μ' => 'μ'
	5319: {0x039D, 0x03BD},   // 'Ν' => 'ν'
	5316: {0x039E, 0x03BE},   // 'Ξ' => 'ξ'
	5313: {0x039F, 0x03BF},   // 'Ο' => 'ο'
	5310: {0x03A0, 0x03C0},   // 'Π' => 'π'
	5307: {0x03A1, 0x03C1},   // 'Ρ' => 'ρ'
	5304: {0x03A3, 0x03C2},   // 'Σ' => 'ς'
	5301: {0x03A3, 0x03C3},   // 'Σ' => 'σ'
	5298: {0x03A4, 0x03C4},   // 'Τ' => 'τ'
	5295: {0x03A5, 0x03C5},   // 'Υ' => 'υ'
	5292: {0x03A6, 0x03C6},   // 'Φ' => 'φ'
	5289: {0x03A7, 0x03C7},   // 'Χ' => 'χ'
	5286: {0x03A8, 0x03C8},   // 'Ψ' => 'ψ'
	5283: {0x03A9, 0x03C9},   // 'Ω' => 'ω'
	5280: {0x03AA, 0x03CA},   // 'Ϊ' => 'ϊ'
	5277: {0x03AB, 0x03CB},   // 'Ϋ' => 'ϋ'
	5274: {0x038C, 0x03CC},   // 'Ό' => 'ό'
	5271: {0x038E, 0x03CD},   // 'Ύ' => 'ύ'
	5268: {0x038F, 0x03CE},   // 'Ώ' => 'ώ'
	5265: {0x03CF, 0x03D7},   // 'Ϗ' => 'ϗ'
	5262: {0x0392, 0x03D0},   // 'Β' => 'ϐ'
	5259: {0x0398, 0x03D1},   // 'Θ' => 'ϑ'
	5247: {0x03A6, 0x03D5},   // 'Φ' => 'ϕ'
	5244: {0x03A0, 0x03D6},   // 'Π' => 'ϖ'
	5241: {0x03CF, 0x03D7},   // 'Ϗ' => 'ϗ'
	5238: {0x03D8, 0x03D9},   // 'Ϙ' => 'ϙ'
	5235: {0x03D8, 0x03D9},   // 'Ϙ' => 'ϙ'
	5232: {0x03DA, 0x03DB},   // 'Ϛ' => 'ϛ'
	5229: {0x03DA, 0x03DB},   // 'Ϛ' => 'ϛ'
	5226: {0x03DC, 0x03DD},   // 'Ϝ' => 'ϝ'
	5223: {0x03DC, 0x03DD},   // 'Ϝ' => 'ϝ'
	5220: {0x03DE, 0x03DF},   // 'Ϟ' => 'ϟ'
	5217: {0x03DE, 0x03DF},   // 'Ϟ' => 'ϟ'
	5214: {0x03E0, 0x03E1},   // 'Ϡ' => 'ϡ'
	5211: {0x03E0, 0x03E1},   // 'Ϡ' => 'ϡ'
	5208: {0x03E2, 0x03E3},   // 'Ϣ' => 'ϣ'
	5205: {0x03E2, 0x03E3},   // 'Ϣ' => 'ϣ'
	5202: {0x03E4, 0x03E5},   // 'Ϥ' => 'ϥ'
	5199: {0x03E4, 0x03E5},   // 'Ϥ' => 'ϥ'
	5196: {0x03E6, 0x03E7},   // 'Ϧ' => 'ϧ'
	5193: {0x03E6, 0x03E7},   // 'Ϧ' => 'ϧ'
	5190: {0x03E8, 0x03E9},   // 'Ϩ' => 'ϩ'
	5187: {0x03E8, 0x03E9},   // 'Ϩ' => 'ϩ'
	5184: {0x03EA, 0x03EB},   // 'Ϫ' => 'ϫ'
	5181: {0x03EA, 0x03EB},   // 'Ϫ' => 'ϫ'
	5178: {0x03EC, 0x03ED},   // 'Ϭ' => 'ϭ'
	5175: {0x03EC, 0x03ED},   // 'Ϭ' => 'ϭ'
	5172: {0x03EE, 0x03EF},   // 'Ϯ' => 'ϯ'
	5169: {0x03EE, 0x03EF},   // 'Ϯ' => 'ϯ'
	5166: {0x039A, 0x03F0},   // 'Κ' => 'ϰ'
	5163: {0x03A1, 0x03F1},   // 'Ρ' => 'ϱ'
	5160: {0x03F9, 0x03F2},   // 'Ϲ' => 'ϲ'
	5157: {0x037F, 0x03F3},   // 'Ϳ' => 'ϳ'
	5154: {0x03F4, 0x03B8},   // 'ϴ' => 'θ'
	5151: {0x0395, 0x03F5},   // 'Ε' => 'ϵ'
	5145: {0x03F7, 0x03F8},   // 'Ϸ' => 'ϸ'
	5142: {0x03F7, 0x03F8},   // 'Ϸ' => 'ϸ'
	5139: {0x03F9, 0x03F2},   // 'Ϲ' => 'ϲ'
	5136: {0x03FA, 0x03FB},   // 'Ϻ' => 'ϻ'
	5133: {0x03FA, 0x03FB},   // 'Ϻ' => 'ϻ'
	5127: {0x03FD, 0x037B},   // 'Ͻ' => 'ͻ'
	5124: {0x03FE, 0x037C},   // 'Ͼ' => 'ͼ'
	5121: {0x03FF, 0x037D},   // 'Ͽ' => 'ͽ'
	5118: {0x0400, 0x0450},   // 'Ѐ' => 'ѐ'
	5115: {0x0401, 0x0451},   // 'Ё' => 'ё'
	5112: {0x0402, 0x0452},   // 'Ђ' => 'ђ'
	5109: {0x0403, 0x0453},   // 'Ѓ' => 'ѓ'
	5106: {0x0404, 0x0454},   // 'Є' => 'є'
	5103: {0x0405, 0x0455},   // 'Ѕ' => 'ѕ'
	5100: {0x0406, 0x0456},   // 'І' => 'і'
	5097: {0x0407, 0x0457},   // 'Ї' => 'ї'
	5094: {0x0408, 0x0458},   // 'Ј' => 'ј'
	5091: {0x0409, 0x0459},   // 'Љ' => 'љ'
	5088: {0x040A, 0x045A},   // 'Њ' => 'њ'
	5085: {0x040B, 0x045B},   // 'Ћ' => 'ћ'
	5082: {0x040C, 0x045C},   // 'Ќ' => 'ќ'
	5079: {0x040D, 0x045D},   // 'Ѝ' => 'ѝ'
	5076: {0x040E, 0x045E},   // 'Ў' => 'ў'
	5073: {0x040F, 0x045F},   // 'Џ' => 'џ'
	5070: {0x0410, 0x0430},   // 'А' => 'а'
	5067: {0x0411, 0x0431},   // 'Б' => 'б'
	5064: {0x0412, 0x0432},   // 'В' => 'в'
	5061: {0x0413, 0x0433},   // 'Г' => 'г'
	5058: {0x0414, 0x0434},   // 'Д' => 'д'
	5055: {0x0415, 0x0435},   // 'Е' => 'е'
	5052: {0x0416, 0x0436},   // 'Ж' => 'ж'
	5049: {0x0417, 0x0437},   // 'З' => 'з'
	5046: {0x0418, 0x0438},   // 'И' => 'и'
	5043: {0x0419, 0x0439},   // 'Й' => 'й'
	5040: {0x041A, 0x043A},   // 'К' => 'к'
	5037: {0x041B, 0x043B},   // 'Л' => 'л'
	5034: {0x041C, 0x043C},   // 'М' => 'м'
	5031: {0x041D, 0x043D},   // 'Н' => 'н'
	5028: {0x041E, 0x043E},   // 'О' => 'о'
	5025: {0x041F, 0x043F},   // 'П' => 'п'
	5022: {0x0420, 0x0440},   // 'Р' => 'р'
	5019: {0x0421, 0x0441},   // 'С' => 'с'
	5016: {0x0422, 0x0442},   // 'Т' => 'т'
	5013: {0x0423, 0x0443},   // 'У' => 'у'
	5010: {0x0424, 0x0444},   // 'Ф' => 'ф'
	5007: {0x0425, 0x0445},   // 'Х' => 'х'
	5004: {0x0426, 0x0446},   // 'Ц' => 'ц'
	5001: {0x0427, 0x0447},   // 'Ч' => 'ч'
	4998: {0x0428, 0x0448},   // 'Ш' => 'ш'
	4995: {0x0429, 0x0449},   // 'Щ' => 'щ'
	4992: {0x042A, 0x044A},   // 'Ъ' => 'ъ'
	4989: {0x042B, 0x044B},   // 'Ы' => 'ы'
	4986: {0x042C, 0x044C},   // 'Ь' => 'ь'
	4983: {0x042D, 0x044D},   // 'Э' => 'э'
	4980: {0x042E, 0x044E},   // 'Ю' => 'ю'
	4977: {0x042F, 0x044F},   // 'Я' => 'я'
	4974: {0x0410, 0x0430},   // 'А' => 'а'
	4971: {0x0411, 0x0431},   // 'Б' => 'б'
	4968: {0x0412, 0x0432},   // 'В' => 'в'
	4965: {0x0413, 0x0433},   // 'Г' => 'г'
	4962: {0x0414, 0x0434},   // 'Д' => 'д'
	4959: {0x0415, 0x0435},   // 'Е' => 'е'
	4956: {0x0416, 0x0436},   // 'Ж' => 'ж'
	4953: {0x0417, 0x0437},   // 'З' => 'з'
	4950: {0x0418, 0x0438},   // 'И' => 'и'
	4947: {0x0419, 0x0439},   // 'Й' => 'й'
	4944: {0x041A, 0x043A},   // 'К' => 'к'
	4941: {0x041B, 0x043B},   // 'Л' => 'л'
	4938: {0x041C, 0x043C},   // 'М' => 'м'
	4935: {0x041D, 0x043D},   // 'Н' => 'н'
	4932: {0x041E, 0x043E},   // 'О' => 'о'
	4929: {0x041F, 0x043F},   // 'П' => 'п'
	4926: {0x0420, 0x0440},   // 'Р' => 'р'
	4923: {0x0421, 0x0441},   // 'С' => 'с'
	4920: {0x0422, 0x0442},   // 'Т' => 'т'
	4917: {0x0423, 0x0443},   // 'У' => 'у'
	4914: {0x0424, 0x0444},   // 'Ф' => 'ф'
	4911: {0x0425, 0x0445},   // 'Х' => 'х'
	4908: {0x0426, 0x0446},   // 'Ц' => 'ц'
	4905: {0x0427, 0x0447},   // 'Ч' => 'ч'
	4902: {0x0428, 0x0448},   // 'Ш' => 'ш'
	4899: {0x0429, 0x0449},   // 'Щ' => 'щ'
	4896: {0x042A, 0x044A},   // 'Ъ' => 'ъ'
	4893: {0x042B, 0x044B},   // 'Ы' => 'ы'
	4890: {0x042C, 0x044C},   // 'Ь' => 'ь'
	4887: {0x042D, 0x044D},   // 'Э' => 'э'
	4884: {0x042E, 0x044E},   // 'Ю' => 'ю'
	4881: {0x042F, 0x044F},   // 'Я' => 'я'
	4878: {0x0400, 0x0450},   // 'Ѐ' => 'ѐ'
	4875: {0x0401, 0x0451},   // 'Ё' => 'ё'
	4872: {0x0402, 0x0452},   // 'Ђ' => 'ђ'
	4869: {0x0403, 0x0453},   // 'Ѓ' => 'ѓ'
	4866: {0x0404, 0x0454},   // 'Є' => 'є'
	4863: {0x0405, 0x0455},   // 'Ѕ' => 'ѕ'
	4860: {0x0406, 0x0456},   // 'І' => 'і'
	4857: {0x0407, 0x0457},   // 'Ї' => 'ї'
	4854: {0x0408, 0x0458},   // 'Ј' => 'ј'
	4851: {0x0409, 0x0459},   // 'Љ' => 'љ'
	4848: {0x040A, 0x045A},   // 'Њ' => 'њ'
	4845: {0x040B, 0x045B},   // 'Ћ' => 'ћ'
	4842: {0x040C, 0x045C},   // 'Ќ' => 'ќ'
	4839: {0x040D, 0x045D},   // 'Ѝ' => 'ѝ'
	4836: {0x040E, 0x045E},   // 'Ў' => 'ў'
	4833: {0x040F, 0x045F},   // 'Џ' => 'џ'
	4830: {0x0460, 0x0461},   // 'Ѡ' => 'ѡ'
	4827: {0x0460, 0x0461},   // 'Ѡ' => 'ѡ'
	4824: {0x0462, 0x0463},   // 'Ѣ' => 'ѣ'
	4821: {0x0462, 0x0463},   // 'Ѣ' => 'ѣ'
	4818: {0x0464, 0x0465},   // 'Ѥ' => 'ѥ'
	4815: {0x0464, 0x0465},   // 'Ѥ' => 'ѥ'
	4812: {0x0466, 0x0467},   // 'Ѧ' => 'ѧ'
	4809: {0x0466, 0x0467},   // 'Ѧ' => 'ѧ'
	4806: {0x0468, 0x0469},   // 'Ѩ' => 'ѩ'
	4803: {0x0468, 0x0469},   // 'Ѩ' => 'ѩ'
	4800: {0x046A, 0x046B},   // 'Ѫ' => 'ѫ'
	4797: {0x046A, 0x046B},   // 'Ѫ' => 'ѫ'
	4794: {0x046C, 0x046D},   // 'Ѭ' => 'ѭ'
	4791: {0x046C, 0x046D},   // 'Ѭ' => 'ѭ'
	4788: {0x046E, 0x046F},   // 'Ѯ' => 'ѯ'
	4785: {0x046E, 0x046F},   // 'Ѯ' => 'ѯ'
	4782: {0x0470, 0x0471},   // 'Ѱ' => 'ѱ'
	4779: {0x0470, 0x0471},   // 'Ѱ' => 'ѱ'
	4776: {0x0472, 0x0473},   // 'Ѳ' => 'ѳ'
	4773: {0x0472, 0x0473},   // 'Ѳ' => 'ѳ'
	4770: {0x0474, 0x0475},   // 'Ѵ' => 'ѵ'
	4767: {0x0474, 0x0475},   // 'Ѵ' => 'ѵ'
	4764: {0x0476, 0x0477},   // 'Ѷ' => 'ѷ'
	4761: {0x0476, 0x0477},   // 'Ѷ' => 'ѷ'
	4758: {0x0478, 0x0479},   // 'Ѹ' => 'ѹ'
	4755: {0x0478, 0x0479},   // 'Ѹ' => 'ѹ'
	4752: {0x047A, 0x047B},   // 'Ѻ' => 'ѻ'
	4749: {0x047A, 0x047B},   // 'Ѻ' => 'ѻ'
	4746: {0x047C, 0x047D},   // 'Ѽ' => 'ѽ'
	4743: {0x047C, 0x047D},   // 'Ѽ' => 'ѽ'
	4740: {0x047E, 0x047F},   // 'Ѿ' => 'ѿ'
	4737: {0x047E, 0x047F},   // 'Ѿ' => 'ѿ'
	4734: {0x0480, 0x0481},   // 'Ҁ' => 'ҁ'
	4731: {0x0480, 0x0481},   // 'Ҁ' => 'ҁ'
	4704: {0x048A, 0x048B},   // 'Ҋ' => 'ҋ'
	4701: {0x048A, 0x048B},   // 'Ҋ' => 'ҋ'
	4698: {0x048C, 0x048D},   // 'Ҍ' => 'ҍ'
	4695: {0x048C, 0x048D},   // 'Ҍ' => 'ҍ'
	4692: {0x048E, 0x048F},   // 'Ҏ' => 'ҏ'
	4689: {0x048E, 0x048F},   // 'Ҏ' => 'ҏ'
	4686: {0x0490, 0x0491},   // 'Ґ' => 'ґ'
	4683: {0x0490, 0x0491},   // 'Ґ' => 'ґ'
	4680: {0x0492, 0x0493},   // 'Ғ' => 'ғ'
	4677: {0x0492, 0x0493},   // 'Ғ' => 'ғ'
	4674: {0x0494, 0x0495},   // 'Ҕ' => 'ҕ'
	4671: {0x0494, 0x0495},   // 'Ҕ' => 'ҕ'
	4668: {0x0496, 0x0497},   // 'Җ' => 'җ'
	4665: {0x0496, 0x0497},   // 'Җ' => 'җ'
	4662: {0x0498, 0x0499},   // 'Ҙ' => 'ҙ'
	4659: {0x0498, 0x0499},   // 'Ҙ' => 'ҙ'
	4656: {0x049A, 0x049B},   // 'Қ' => 'қ'
	4653: {0x049A, 0x049B},   // 'Қ' => 'қ'
	4650: {0x049C, 0x049D},   // 'Ҝ' => 'ҝ'
	4647: {0x049C, 0x049D},   // 'Ҝ' => 'ҝ'
	4644: {0x049E, 0x049F},   // 'Ҟ' => 'ҟ'
	4641: {0x049E, 0x049F},   // 'Ҟ' => 'ҟ'
	4638: {0x04A0, 0x04A1},   // 'Ҡ' => 'ҡ'
	4635: {0x04A0, 0x04A1},   // 'Ҡ' => 'ҡ'
	4632: {0x04A2, 0x04A3},   // 'Ң' => 'ң'
	4629: {0x04A2, 0x04A3},   // 'Ң' => 'ң'
	4626: {0x04A4, 0x04A5},   // 'Ҥ' => 'ҥ'
	4623: {0x04A4, 0x04A5},   // 'Ҥ' => 'ҥ'
	4620: {0x04A6, 0x04A7},   // 'Ҧ' => 'ҧ'
	4617: {0x04A6, 0x04A7},   // 'Ҧ' => 'ҧ'
	4614: {0x04A8, 0x04A9},   // 'Ҩ' => 'ҩ'
	4611: {0x04A8, 0x04A9},   // 'Ҩ' => 'ҩ'
	4608: {0x04AA, 0x04AB},   // 'Ҫ' => 'ҫ'
	4605: {0x04AA, 0x04AB},   // 'Ҫ' => 'ҫ'
	4602: {0x04AC, 0x04AD},   // 'Ҭ' => 'ҭ'
	4599: {0x04AC, 0x04AD},   // 'Ҭ' => 'ҭ'
	4596: {0x04AE, 0x04AF},   // 'Ү' => 'ү'
	4593: {0x04AE, 0x04AF},   // 'Ү' => 'ү'
	4590: {0x04B0, 0x04B1},   // 'Ұ' => 'ұ'
	4587: {0x04B0, 0x04B1},   // 'Ұ' => 'ұ'
	4584: {0x04B2, 0x04B3},   // 'Ҳ' => 'ҳ'
	4581: {0x04B2, 0x04B3},   // 'Ҳ' => 'ҳ'
	4578: {0x04B4, 0x04B5},   // 'Ҵ' => 'ҵ'
	4575: {0x04B4, 0x04B5},   // 'Ҵ' => 'ҵ'
	4572: {0x04B6, 0x04B7},   // 'Ҷ' => 'ҷ'
	4569: {0x04B6, 0x04B7},   // 'Ҷ' => 'ҷ'
	4566: {0x04B8, 0x04B9},   // 'Ҹ' => 'ҹ'
	4563: {0x04B8, 0x04B9},   // 'Ҹ' => 'ҹ'
	4560: {0x04BA, 0x04BB},   // 'Һ' => 'һ'
	4557: {0x04BA, 0x04BB},   // 'Һ' => 'һ'
	4554: {0x04BC, 0x04BD},   // 'Ҽ' => 'ҽ'
	4551: {0x04BC, 0x04BD},   // 'Ҽ' => 'ҽ'
	4548: {0x04BE, 0x04BF},   // 'Ҿ' => 'ҿ'
	4545: {0x04BE, 0x04BF},   // 'Ҿ' => 'ҿ'
	4542: {0x04C0, 0x04CF},   // 'Ӏ' => 'ӏ'
	4539: {0x04C1, 0x04C2},   // 'Ӂ' => 'ӂ'
	4536: {0x04C1, 0x04C2},   // 'Ӂ' => 'ӂ'
	4533: {0x04C3, 0x04C4},   // 'Ӄ' => 'ӄ'
	4530: {0x04C3, 0x04C4},   // 'Ӄ' => 'ӄ'
	4527: {0x04C5, 0x04C6},   // 'Ӆ' => 'ӆ'
	4524: {0x04C5, 0x04C6},   // 'Ӆ' => 'ӆ'
	4521: {0x04C7, 0x04C8},   // 'Ӈ' => 'ӈ'
	4518: {0x04C7, 0x04C8},   // 'Ӈ' => 'ӈ'
	4515: {0x04C9, 0x04CA},   // 'Ӊ' => 'ӊ'
	4512: {0x04C9, 0x04CA},   // 'Ӊ' => 'ӊ'
	4509: {0x04CB, 0x04CC},   // 'Ӌ' => 'ӌ'
	4506: {0x04CB, 0x04CC},   // 'Ӌ' => 'ӌ'
	4503: {0x04CD, 0x04CE},   // 'Ӎ' => 'ӎ'
	4500: {0x04CD, 0x04CE},   // 'Ӎ' => 'ӎ'
	4497: {0x04C0, 0x04CF},   // 'Ӏ' => 'ӏ'
	4494: {0x04D0, 0x04D1},   // 'Ӑ' => 'ӑ'
	4491: {0x04D0, 0x04D1},   // 'Ӑ' => 'ӑ'
	4488: {0x04D2, 0x04D3},   // 'Ӓ' => 'ӓ'
	4485: {0x04D2, 0x04D3},   // 'Ӓ' => 'ӓ'
	4482: {0x04D4, 0x04D5},   // 'Ӕ' => 'ӕ'
	4479: {0x04D4, 0x04D5},   // 'Ӕ' => 'ӕ'
	4476: {0x04D6, 0x04D7},   // 'Ӗ' => 'ӗ'
	4473: {0x04D6, 0x04D7},   // 'Ӗ' => 'ӗ'
	4470: {0x04D8, 0x04D9},   // 'Ә' => 'ә'
	4467: {0x04D8, 0x04D9},   // 'Ә' => 'ә'
	4464: {0x04DA, 0x04DB},   // 'Ӛ' => 'ӛ'
	4461: {0x04DA, 0x04DB},   // 'Ӛ' => 'ӛ'
	4458: {0x04DC, 0x04DD},   // 'Ӝ' => 'ӝ'
	4455: {0x04DC, 0x04DD},   // 'Ӝ' => 'ӝ'
	4452: {0x04DE, 0x04DF},   // 'Ӟ' => 'ӟ'
	4449: {0x04DE, 0x04DF},   // 'Ӟ' => 'ӟ'
	4446: {0x04E0, 0x04E1},   // 'Ӡ' => 'ӡ'
	4443: {0x04E0, 0x04E1},   // 'Ӡ' => 'ӡ'
	4440: {0x04E2, 0x04E3},   // 'Ӣ' => 'ӣ'
	4437: {0x04E2, 0x04E3},   // 'Ӣ' => 'ӣ'
	4434: {0x04E4, 0x04E5},   // 'Ӥ' => 'ӥ'
	4431: {0x04E4, 0x04E5},   // 'Ӥ' => 'ӥ'
	4428: {0x04E6, 0x04E7},   // 'Ӧ' => 'ӧ'
	4425: {0x04E6, 0x04E7},   // 'Ӧ' => 'ӧ'
	4422: {0x04E8, 0x04E9},   // 'Ө' => 'ө'
	4419: {0x04E8, 0x04E9},   // 'Ө' => 'ө'
	4416: {0x04EA, 0x04EB},   // 'Ӫ' => 'ӫ'
	4413: {0x04EA, 0x04EB},   // 'Ӫ' => 'ӫ'
	4410: {0x04EC, 0x04ED},   // 'Ӭ' => 'ӭ'
	4407: {0x04EC, 0x04ED},   // 'Ӭ' => 'ӭ'
	4404: {0x04EE, 0x04EF},   // 'Ӯ' => 'ӯ'
	4401: {0x04EE, 0x04EF},   // 'Ӯ' => 'ӯ'
	4398: {0x04F0, 0x04F1},   // 'Ӱ' => 'ӱ'
	4395: {0x04F0, 0x04F1},   // 'Ӱ' => 'ӱ'
	4392: {0x04F2, 0x04F3},   // 'Ӳ' => 'ӳ'
	4389: {0x04F2, 0x04F3},   // 'Ӳ' => 'ӳ'
	4386: {0x04F4, 0x04F5},   // 'Ӵ' => 'ӵ'
	4383: {0x04F4, 0x04F5},   // 'Ӵ' => 'ӵ'
	4380: {0x04F6, 0x04F7},   // 'Ӷ' => 'ӷ'
	4377: {0x04F6, 0x04F7},   // 'Ӷ' => 'ӷ'
	4374: {0x04F8, 0x04F9},   // 'Ӹ' => 'ӹ'
	4371: {0x04F8, 0x04F9},   // 'Ӹ' => 'ӹ'
	4368: {0x04FA, 0x04FB},   // 'Ӻ' => 'ӻ'
	4365: {0x04FA, 0x04FB},   // 'Ӻ' => 'ӻ'
	4362: {0x04FC, 0x04FD},   // 'Ӽ' => 'ӽ'
	4359: {0x04FC, 0x04FD},   // 'Ӽ' => 'ӽ'
	4356: {0x04FE, 0x04FF},   // 'Ӿ' => 'ӿ'
	4353: {0x04FE, 0x04FF},   // 'Ӿ' => 'ӿ'
	4350: {0x0500, 0x0501},   // 'Ԁ' => 'ԁ'
	4347: {0x0500, 0x0501},   // 'Ԁ' => 'ԁ'
	4344: {0x0502, 0x0503},   // 'Ԃ' => 'ԃ'
	4341: {0x0502, 0x0503},   // 'Ԃ' => 'ԃ'
	4338: {0x0504, 0x0505},   // 'Ԅ' => 'ԅ'
	4335: {0x0504, 0x0505},   // 'Ԅ' => 'ԅ'
	4332: {0x0506, 0x0507},   // 'Ԇ' => 'ԇ'
	4329: {0x0506, 0x0507},   // 'Ԇ' => 'ԇ'
	4326: {0x0508, 0x0509},   // 'Ԉ' => 'ԉ'
	4323: {0x0508, 0x0509},   // 'Ԉ' => 'ԉ'
	4320: {0x050A, 0x050B},   // 'Ԋ' => 'ԋ'
	4317: {0x050A, 0x050B},   // 'Ԋ' => 'ԋ'
	4314: {0x050C, 0x050D},   // 'Ԍ' => 'ԍ'
	4311: {0x050C, 0x050D},   // 'Ԍ' => 'ԍ'
	4308: {0x050E, 0x050F},   // 'Ԏ' => 'ԏ'
	4305: {0x050E, 0x050F},   // 'Ԏ' => 'ԏ'
	4302: {0x0510, 0x0511},   // 'Ԑ' => 'ԑ'
	4299: {0x0510, 0x0511},   // 'Ԑ' => 'ԑ'
	4296: {0x0512, 0x0513},   // 'Ԓ' => 'ԓ'
	4293: {0x0512, 0x0513},   // 'Ԓ' => 'ԓ'
	4290: {0x0514, 0x0515},   // 'Ԕ' => 'ԕ'
	4287: {0x0514, 0x0515},   // 'Ԕ' => 'ԕ'
	4284: {0x0516, 0x0517},   // 'Ԗ' => 'ԗ'
	4281: {0x0516, 0x0517},   // 'Ԗ' => 'ԗ'
	4278: {0x0518, 0x0519},   // 'Ԙ' => 'ԙ'
	4275: {0x0518, 0x0519},   // 'Ԙ' => 'ԙ'
	4272: {0x051A, 0x051B},   // 'Ԛ' => 'ԛ'
	4269: {0x051A, 0x051B},   // 'Ԛ' => 'ԛ'
	4266: {0x051C, 0x051D},   // 'Ԝ' => 'ԝ'
	4263: {0x051C, 0x051D},   // 'Ԝ' => 'ԝ'
	4260: {0x051E, 0x051F},   // 'Ԟ' => 'ԟ'
	4257: {0x051E, 0x051F},   // 'Ԟ' => 'ԟ'
	4254: {0x0520, 0x0521},   // 'Ԡ' => 'ԡ'
	4251: {0x0520, 0x0521},   // 'Ԡ' => 'ԡ'
	4248: {0x0522, 0x0523},   // 'Ԣ' => 'ԣ'
	4245: {0x0522, 0x0523},   // 'Ԣ' => 'ԣ'
	4242: {0x0524, 0x0525},   // 'Ԥ' => 'ԥ'
	4239: {0x0524, 0x0525},   // 'Ԥ' => 'ԥ'
	4236: {0x0526, 0x0527},   // 'Ԧ' => 'ԧ'
	4233: {0x0526, 0x0527},   // 'Ԧ' => 'ԧ'
	4230: {0x0528, 0x0529},   // 'Ԩ' => 'ԩ'
	4227: {0x0528, 0x0529},   // 'Ԩ' => 'ԩ'
	4224: {0x052A, 0x052B},   // 'Ԫ' => 'ԫ'
	4221: {0x052A, 0x052B},   // 'Ԫ' => 'ԫ'
	4218: {0x052C, 0x052D},   // 'Ԭ' => 'ԭ'
	4215: {0x052C, 0x052D},   // 'Ԭ' => 'ԭ'
	4212: {0x052E, 0x052F},   // 'Ԯ' => 'ԯ'
	4209: {0x052E, 0x052F},   // 'Ԯ' => 'ԯ'
	4203: {0x0531, 0x0561},   // 'Ա' => 'ա'
	4200: {0x0532, 0x0562},   // 'Բ' => 'բ'
	4197: {0x0533, 0x0563},   // 'Գ' => 'գ'
	4194: {0x0534, 0x0564},   // 'Դ' => 'դ'
	4191: {0x0535, 0x0565},   // 'Ե' => 'ե'
	4188: {0x0536, 0x0566},   // 'Զ' => 'զ'
	4185: {0x0537, 0x0567},   // 'Է' => 'է'
	4182: {0x0538, 0x0568},   // 'Ը' => 'ը'
	4179: {0x0539, 0x0569},   // 'Թ' => 'թ'
	4176: {0x053A, 0x056A},   // 'Ժ' => 'ժ'
	4173: {0x053B, 0x056B},   // 'Ի' => 'ի'
	4170: {0x053C, 0x056C},   // 'Լ' => 'լ'
	4167: {0x053D, 0x056D},   // 'Խ' => 'խ'
	4164: {0x053E, 0x056E},   // 'Ծ' => 'ծ'
	4161: {0x053F, 0x056F},   // 'Կ' => 'կ'
	4158: {0x0540, 0x0570},   // 'Հ' => 'հ'
	4155: {0x0541, 0x0571},   // 'Ձ' => 'ձ'
	4152: {0x0542, 0x0572},   // 'Ղ' => 'ղ'
	4149: {0x0543, 0x0573},   // 'Ճ' => 'ճ'
	4146: {0x0544, 0x0574},   // 'Մ' => 'մ'
	4143: {0x0545, 0x0575},   // 'Յ' => 'յ'
	4140: {0x0546, 0x0576},   // 'Ն' => 'ն'
	4137: {0x0547, 0x0577},   // 'Շ' => 'շ'
	4134: {0x0548, 0x0578},   // 'Ո' => 'ո'
	4131: {0x0549, 0x0579},   // 'Չ' => 'չ'
	4128: {0x054A, 0x057A},   // 'Պ' => 'պ'
	4125: {0x054B, 0x057B},   // 'Ջ' => 'ջ'
	4122: {0x054C, 0x057C},   // 'Ռ' => 'ռ'
	4119: {0x054D, 0x057D},   // 'Ս' => 'ս'
	4116: {0x054E, 0x057E},   // 'Վ' => 'վ'
	4113: {0x054F, 0x057F},   // 'Տ' => 'տ'
	4110: {0x0550, 0x0580},   // 'Ր' => 'ր'
	4107: {0x0551, 0x0581},   // 'Ց' => 'ց'
	4104: {0x0552, 0x0582},   // 'Ւ' => 'ւ'
	4101: {0x0553, 0x0583},   // 'Փ' => 'փ'
	4098: {0x0554, 0x0584},   // 'Ք' => 'ք'
	4095: {0x0555, 0x0585},   // 'Օ' => 'օ'
	4092: {0x0556, 0x0586},   // 'Ֆ' => 'ֆ'
	4059: {0x0531, 0x0561},   // 'Ա' => 'ա'
	4056: {0x0532, 0x0562},   // 'Բ' => 'բ'
	4053: {0x0533, 0x0563},   // 'Գ' => 'գ'
	4050: {0x0534, 0x0564},   // 'Դ' => 'դ'
	4047: {0x0535, 0x0565},   // 'Ե' => 'ե'
	4044: {0x0536, 0x0566},   // 'Զ' => 'զ'
	4041: {0x0537, 0x0567},   // 'Է' => 'է'
	4038: {0x0538, 0x0568},   // 'Ը' => 'ը'
	4035: {0x0539, 0x0569},   // 'Թ' => 'թ'
	4032: {0x053A, 0x056A},   // 'Ժ' => 'ժ'
	4029: {0x053B, 0x056B},   // 'Ի' => 'ի'
	4026: {0x053C, 0x056C},   // 'Լ' => 'լ'
	4023: {0x053D, 0x056D},   // 'Խ' => 'խ'
	4020: {0x053E, 0x056E},   // 'Ծ' => 'ծ'
	4017: {0x053F, 0x056F},   // 'Կ' => 'կ'
	4014: {0x0540, 0x0570},   // 'Հ' => 'հ'
	4011: {0x0541, 0x0571},   // 'Ձ' => 'ձ'
	4008: {0x0542, 0x0572},   // 'Ղ' => 'ղ'
	4005: {0x0543, 0x0573},   // 'Ճ' => 'ճ'
	4002: {0x0544, 0x0574},   // 'Մ' => 'մ'
	3999: {0x0545, 0x0575},   // 'Յ' => 'յ'
	3996: {0x0546, 0x0576},   // 'Ն' => 'ն'
	3993: {0x0547, 0x0577},   // 'Շ' => 'շ'
	3990: {0x0548, 0x0578},   // 'Ո' => 'ո'
	3987: {0x0549, 0x0579},   // 'Չ' => 'չ'
	3984: {0x054A, 0x057A},   // 'Պ' => 'պ'
	3981: {0x054B, 0x057B},   // 'Ջ' => 'ջ'
	3978: {0x054C, 0x057C},   // 'Ռ' => 'ռ'
	3975: {0x054D, 0x057D},   // 'Ս' => 'ս'
	3972: {0x054E, 0x057E},   // 'Վ' => 'վ'
	3969: {0x054F, 0x057F},   // 'Տ' => 'տ'
	3966: {0x0550, 0x0580},   // 'Ր' => 'ր'
	3963: {0x0551, 0x0581},   // 'Ց' => 'ց'
	3960: {0x0552, 0x0582},   // 'Ւ' => 'ւ'
	3957: {0x0553, 0x0583},   // 'Փ' => 'փ'
	3954: {0x0554, 0x0584},   // 'Ք' => 'ք'
	3951: {0x0555, 0x0585},   // 'Օ' => 'օ'
	3948: {0x0556, 0x0586},   // 'Ֆ' => 'ֆ'
	3610: {0x10A0, 0x2D00},   // 'Ⴀ' => 'ⴀ'
	3607: {0x10A1, 0x2D01},   // 'Ⴁ' => 'ⴁ'
	3604: {0x10A2, 0x2D02},   // 'Ⴂ' => 'ⴂ'
	3601: {0x10A3, 0x2D03},   // 'Ⴃ' => 'ⴃ'
	3598: {0x10A4, 0x2D04},   // 'Ⴄ' => 'ⴄ'
	3595: {0x10A5, 0x2D05},   // 'Ⴅ' => 'ⴅ'
	3592: {0x10A6, 0x2D06},   // 'Ⴆ' => 'ⴆ'
	3589: {0x10A7, 0x2D07},   // 'Ⴇ' => 'ⴇ'
	3586: {0x10A8, 0x2D08},   // 'Ⴈ' => 'ⴈ'
	3583: {0x10A9, 0x2D09},   // 'Ⴉ' => 'ⴉ'
	3580: {0x10AA, 0x2D0A},   // 'Ⴊ' => 'ⴊ'
	3577: {0x10AB, 0x2D0B},   // 'Ⴋ' => 'ⴋ'
	3574: {0x10AC, 0x2D0C},   // 'Ⴌ' => 'ⴌ'
	3571: {0x10AD, 0x2D0D},   // 'Ⴍ' => 'ⴍ'
	3568: {0x10AE, 0x2D0E},   // 'Ⴎ' => 'ⴎ'
	3565: {0x10AF, 0x2D0F},   // 'Ⴏ' => 'ⴏ'
	3562: {0x10B0, 0x2D10},   // 'Ⴐ' => 'ⴐ'
	3559: {0x10B1, 0x2D11},   // 'Ⴑ' => 'ⴑ'
	3556: {0x10B2, 0x2D12},   // 'Ⴒ' => 'ⴒ'
	3553: {0x10B3, 0x2D13},   // 'Ⴓ' => 'ⴓ'
	3550: {0x10B4, 0x2D14},   // 'Ⴔ' => 'ⴔ'
	3547: {0x10B5, 0x2D15},   // 'Ⴕ' => 'ⴕ'
	3544: {0x10B6, 0x2D16},   // 'Ⴖ' => 'ⴖ'
	3541: {0x10B7, 0x2D17},   // 'Ⴗ' => 'ⴗ'
	3538: {0x10B8, 0x2D18},   // 'Ⴘ' => 'ⴘ'
	3535: {0x10B9, 0x2D19},   // 'Ⴙ' => 'ⴙ'
	3532: {0x10BA, 0x2D1A},   // 'Ⴚ' => 'ⴚ'
	3529: {0x10BB, 0x2D1B},   // 'Ⴛ' => 'ⴛ'
	3526: {0x10BC, 0x2D1C},   // 'Ⴜ' => 'ⴜ'
	3523: {0x10BD, 0x2D1D},   // 'Ⴝ' => 'ⴝ'
	3520: {0x10BE, 0x2D1E},   // 'Ⴞ' => 'ⴞ'
	3517: {0x10BF, 0x2D1F},   // 'Ⴟ' => 'ⴟ'
	3514: {0x10C0, 0x2D20},   // 'Ⴠ' => 'ⴠ'
	3511: {0x10C1, 0x2D21},   // 'Ⴡ' => 'ⴡ'
	3508: {0x10C2, 0x2D22},   // 'Ⴢ' => 'ⴢ'
	3505: {0x10C3, 0x2D23},   // 'Ⴣ' => 'ⴣ'
	3502: {0x10C4, 0x2D24},   // 'Ⴤ' => 'ⴤ'
	3499: {0x10C5, 0x2D25},   // 'Ⴥ' => 'ⴥ'
	3493: {0x10C7, 0x2D27},   // 'Ⴧ' => 'ⴧ'
	3475: {0x10CD, 0x2D2D},   // 'Ⴭ' => 'ⴭ'
	3466: {0x1C90, 0x10D0},   // 'Ა' => 'ა'
	3463: {0x1C91, 0x10D1},   // 'Ბ' => 'ბ'
	3460: {0x1C92, 0x10D2},   // 'Გ' => 'გ'
	3457: {0x1C93, 0x10D3},   // 'Დ' => 'დ'
	3454: {0x1C94, 0x10D4},   // 'Ე' => 'ე'
	3451: {0x1C95, 0x10D5},   // 'Ვ' => 'ვ'
	3448: {0x1C96, 0x10D6},   // 'Ზ' => 'ზ'
	3445: {0x1C97, 0x10D7},   // 'Თ' => 'თ'
	3442: {0x1C98, 0x10D8},   // 'Ი' => 'ი'
	3439: {0x1C99, 0x10D9},   // 'Კ' => 'კ'
	3436: {0x1C9A, 0x10DA},   // 'Ლ' => 'ლ'
	3433: {0x1C9B, 0x10DB},   // 'Მ' => 'მ'
	3430: {0x1C9C, 0x10DC},   // 'Ნ' => 'ნ'
	3427: {0x1C9D, 0x10DD},   // 'Ო' => 'ო'
	3424: {0x1C9E, 0x10DE},   // 'Პ' => 'პ'
	3421: {0x1C9F, 0x10DF},   // 'Ჟ' => 'ჟ'
	3418: {0x1CA0, 0x10E0},   // 'Რ' => 'რ'
	3415: {0x1CA1, 0x10E1},   // 'Ს' => 'ს'
	3412: {0x1CA2, 0x10E2},   // 'Ტ' => 'ტ'
	3409: {0x1CA3, 0x10E3},   // 'Უ' => 'უ'
	3406: {0x1CA4, 0x10E4},   // 'Ფ' => 'ფ'
	3403: {0x1CA5, 0x10E5},   // 'Ქ' => 'ქ'
	3400: {0x1CA6, 0x10E6},   // 'Ღ' => 'ღ'
	3397: {0x1CA7, 0x10E7},   // 'Ყ' => 'ყ'
	3394: {0x1CA8, 0x10E8},   // 'Შ' => 'შ'
	3391: {0x1CA9, 0x10E9},   // 'Ჩ' => 'ჩ'
	3388: {0x1CAA, 0x10EA},   // 'Ც' => 'ც'
	3385: {0x1CAB, 0x10EB},   // 'Ძ' => 'ძ'
	3382: {0x1CAC, 0x10EC},   // 'Წ' => 'წ'
	3379: {0x1CAD, 0x10ED},   // 'Ჭ' => 'ჭ'
	3376: {0x1CAE, 0x10EE},   // 'Ხ' => 'ხ'
	3373: {0x1CAF, 0x10EF},   // 'Ჯ' => 'ჯ'
	3370: {0x1CB0, 0x10F0},   // 'Ჰ' => 'ჰ'
	3367: {0x1CB1, 0x10F1},   // 'Ჱ' => 'ჱ'
	3364: {0x1CB2, 0x10F2},   // 'Ჲ' => 'ჲ'
	3361: {0x1CB3, 0x10F3},   // 'Ჳ' => 'ჳ'
	3358: {0x1CB4, 0x10F4},   // 'Ჴ' => 'ჴ'
	3355: {0x1CB5, 0x10F5},   // 'Ჵ' => 'ჵ'
	3352: {0x1CB6, 0x10F6},   // 'Ჶ' => 'ჶ'
	3349: {0x1CB7, 0x10F7},   // 'Ჷ' => 'ჷ'
	3346: {0x1CB8, 0x10F8},   // 'Ჸ' => 'ჸ'
	3343: {0x1CB9, 0x10F9},   // 'Ჹ' => 'ჹ'
	3340: {0x1CBA, 0x10FA},   // 'Ჺ' => 'ჺ'
	3331: {0x1CBD, 0x10FD},   // 'Ჽ' => 'ჽ'
	3328: {0x1CBE, 0x10FE},   // 'Ჾ' => 'ჾ'
	3325: {0x1CBF, 0x10FF},   // 'Ჿ' => 'ჿ'
	1306: {0x13A0, 0xAB70},   // 'Ꭰ' => 'ꭰ'
	1303: {0x13A1, 0xAB71},   // 'Ꭱ' => 'ꭱ'
	1300: {0x13A2, 0xAB72},   // 'Ꭲ' => 'ꭲ'
	1297: {0x13A3, 0xAB73},   // 'Ꭳ' => 'ꭳ'
	1294: {0x13A4, 0xAB74},   // 'Ꭴ' => 'ꭴ'
	1291: {0x13A5, 0xAB75},   // 'Ꭵ' => 'ꭵ'
	1288: {0x13A6, 0xAB76},   // 'Ꭶ' => 'ꭶ'
	1285: {0x13A7, 0xAB77},   // 'Ꭷ' => 'ꭷ'
	1282: {0x13A8, 0xAB78},   // 'Ꭸ' => 'ꭸ'
	1279: {0x13A9, 0xAB79},   // 'Ꭹ' => 'ꭹ'
	1276: {0x13AA, 0xAB7A},   // 'Ꭺ' => 'ꭺ'
	1273: {0x13AB, 0xAB7B},   // 'Ꭻ' => 'ꭻ'
	1270: {0x13AC, 0xAB7C},   // 'Ꭼ' => 'ꭼ'
	1267: {0x13AD, 0xAB7D},   // 'Ꭽ' => 'ꭽ'
	1264: {0x13AE, 0xAB7E},   // 'Ꭾ' => 'ꭾ'
	1261: {0x13AF, 0xAB7F},   // 'Ꭿ' => 'ꭿ'
	1258: {0x13B0, 0xAB80},   // 'Ꮀ' => 'ꮀ'
	1255: {0x13B1, 0xAB81},   // 'Ꮁ' => 'ꮁ'
	1252: {0x13B2, 0xAB82},   // 'Ꮂ' => 'ꮂ'
	1249: {0x13B3, 0xAB83},   // 'Ꮃ' => 'ꮃ'
	1246: {0x13B4, 0xAB84},   // 'Ꮄ' => 'ꮄ'
	1243: {0x13B5, 0xAB85},   // 'Ꮅ' => 'ꮅ'
	1240: {0x13B6, 0xAB86},   // 'Ꮆ' => 'ꮆ'
	1237: {0x13B7, 0xAB87},   // 'Ꮇ' => 'ꮇ'
	1234: {0x13B8, 0xAB88},   // 'Ꮈ' => 'ꮈ'
	1231: {0x13B9, 0xAB89},   // 'Ꮉ' => 'ꮉ'
	1228: {0x13BA, 0xAB8A},   // 'Ꮊ' => 'ꮊ'
	1225: {0x13BB, 0xAB8B},   // 'Ꮋ' => 'ꮋ'
	1222: {0x13BC, 0xAB8C},   // 'Ꮌ' => 'ꮌ'
	1219: {0x13BD, 0xAB8D},   // 'Ꮍ' => 'ꮍ'
	1216: {0x13BE, 0xAB8E},   // 'Ꮎ' => 'ꮎ'
	1213: {0x13BF, 0xAB8F},   // 'Ꮏ' => 'ꮏ'
	1210: {0x13C0, 0xAB90},   // 'Ꮐ' => 'ꮐ'
	1207: {0x13C1, 0xAB91},   // 'Ꮑ' => 'ꮑ'
	1204: {0x13C2, 0xAB92},   // 'Ꮒ' => 'ꮒ'
	1201: {0x13C3, 0xAB93},   // 'Ꮓ' => 'ꮓ'
	1198: {0x13C4, 0xAB94},   // 'Ꮔ' => 'ꮔ'
	1195: {0x13C5, 0xAB95},   // 'Ꮕ' => 'ꮕ'
	1192: {0x13C6, 0xAB96},   // 'Ꮖ' => 'ꮖ'
	1189: {0x13C7, 0xAB97},   // 'Ꮗ' => 'ꮗ'
	1186: {0x13C8, 0xAB98},   // 'Ꮘ' => 'ꮘ'
	1183: {0x13C9, 0xAB99},   // 'Ꮙ' => 'ꮙ'
	1180: {0x13CA, 0xAB9A},   // 'Ꮚ' => 'ꮚ'
	1177: {0x13CB, 0xAB9B},   // 'Ꮛ' => 'ꮛ'
	1174: {0x13CC, 0xAB9C},   // 'Ꮜ' => 'ꮜ'
	1171: {0x13CD, 0xAB9D},   // 'Ꮝ' => 'ꮝ'
	1168: {0x13CE, 0xAB9E},   // 'Ꮞ' => 'ꮞ'
	1165: {0x13CF, 0xAB9F},   // 'Ꮟ' => 'ꮟ'
	1162: {0x13D0, 0xABA0},   // 'Ꮠ' => 'ꮠ'
	1159: {0x13D1, 0xABA1},   // 'Ꮡ' => 'ꮡ'
	1156: {0x13D2, 0xABA2},   // 'Ꮢ' => 'ꮢ'
	1153: {0x13D3, 0xABA3},   // 'Ꮣ' => 'ꮣ'
	1150: {0x13D4, 0xABA4},   // 'Ꮤ' => 'ꮤ'
	1147: {0x13D5, 0xABA5},   // 'Ꮥ' => 'ꮥ'
	1144: {0x13D6, 0xABA6},   // 'Ꮦ' => 'ꮦ'
	1141: {0x13D7, 0xABA7},   // 'Ꮧ' => 'ꮧ'
	1138: {0x13D8, 0xABA8},   // 'Ꮨ' => 'ꮨ'
	1135: {0x13D9, 0xABA9},   // 'Ꮩ' => 'ꮩ'
	1131: {0x13DA, 0xABAA},   // 'Ꮪ' => 'ꮪ'
	1128: {0x13DB, 0xABAB},   // 'Ꮫ' => 'ꮫ'
	1125: {0x13DC, 0xABAC},   // 'Ꮬ' => 'ꮬ'
	1122: {0x13DD, 0xABAD},   // 'Ꮭ' => 'ꮭ'
	1119: {0x13DE, 0xABAE},   // 'Ꮮ' => 'ꮮ'
	1116: {0x13DF, 0xABAF},   // 'Ꮯ' => 'ꮯ'
	1113: {0x13E0, 0xABB0},   // 'Ꮰ' => 'ꮰ'
	1110: {0x13E1, 0xABB1},   // 'Ꮱ' => 'ꮱ'
	1107: {0x13E2, 0xABB2},   // 'Ꮲ' => 'ꮲ'
	1104: {0x13E3, 0xABB3},   // 'Ꮳ' => 'ꮳ'
	1101: {0x13E4, 0xABB4},   // 'Ꮴ' => 'ꮴ'
	1098: {0x13E5, 0xABB5},   // 'Ꮵ' => 'ꮵ'
	1095: {0x13E6, 0xABB6},   // 'Ꮶ' => 'ꮶ'
	1092: {0x13E7, 0xABB7},   // 'Ꮷ' => 'ꮷ'
	1089: {0x13E8, 0xABB8},   // 'Ꮸ' => 'ꮸ'
	1086: {0x13E9, 0xABB9},   // 'Ꮹ' => 'ꮹ'
	1083: {0x13EA, 0xABBA},   // 'Ꮺ' => 'ꮺ'
	1080: {0x13EB, 0xABBB},   // 'Ꮻ' => 'ꮻ'
	1077: {0x13EC, 0xABBC},   // 'Ꮼ' => 'ꮼ'
	1074: {0x13ED, 0xABBD},   // 'Ꮽ' => 'ꮽ'
	1071: {0x13EE, 0xABBE},   // 'Ꮾ' => 'ꮾ'
	1068: {0x13EF, 0xABBF},   // 'Ꮿ' => 'ꮿ'
	1065: {0x13F0, 0x13F8},   // 'Ᏸ' => 'ᏸ'
	1062: {0x13F1, 0x13F9},   // 'Ᏹ' => 'ᏹ'
	1059: {0x13F2, 0x13FA},   // 'Ᏺ' => 'ᏺ'
	1056: {0x13F3, 0x13FB},   // 'Ᏻ' => 'ᏻ'
	1053: {0x13F4, 0x13FC},   // 'Ᏼ' => 'ᏼ'
	1050: {0x13F5, 0x13FD},   // 'Ᏽ' => 'ᏽ'
	1041: {0x13F0, 0x13F8},   // 'Ᏸ' => 'ᏸ'
	1038: {0x13F1, 0x13F9},   // 'Ᏹ' => 'ᏹ'
	1035: {0x13F2, 0x13FA},   // 'Ᏺ' => 'ᏺ'
	1032: {0x13F3, 0x13FB},   // 'Ᏻ' => 'ᏻ'
	1029: {0x13F4, 0x13FC},   // 'Ᏼ' => 'ᏼ'
	1026: {0x13F5, 0x13FD},   // 'Ᏽ' => 'ᏽ'
	2679: {0x0412, 0x1C80},   // 'В' => 'ᲀ'
	2676: {0x0414, 0x1C81},   // 'Д' => 'ᲁ'
	2673: {0x041E, 0x1C82},   // 'О' => 'ᲂ'
	2670: {0x0421, 0x1C83},   // 'С' => 'ᲃ'
	2667: {0x0422, 0x1C84},   // 'Т' => 'ᲄ'
	2664: {0x0422, 0x1C85},   // 'Т' => 'ᲅ'
	2661: {0x042A, 0x1C86},   // 'Ъ' => 'ᲆ'
	2658: {0x0462, 0x1C87},   // 'Ѣ' => 'ᲇ'
	2655: {0xA64A, 0x1C88},   // 'Ꙋ' => 'ᲈ'
	2631: {0x1C90, 0x10D0},   // 'Ა' => 'ა'
	2628: {0x1C91, 0x10D1},   // 'Ბ' => 'ბ'
	2625: {0x1C92, 0x10D2},   // 'Გ' => 'გ'
	2622: {0x1C93, 0x10D3},   // 'Დ' => 'დ'
	2619: {0x1C94, 0x10D4},   // 'Ე' => 'ე'
	2616: {0x1C95, 0x10D5},   // 'Ვ' => 'ვ'
	2613: {0x1C96, 0x10D6},   // 'Ზ' => 'ზ'
	2610: {0x1C97, 0x10D7},   // 'Თ' => 'თ'
	2607: {0x1C98, 0x10D8},   // 'Ი' => 'ი'
	2604: {0x1C99, 0x10D9},   // 'Კ' => 'კ'
	2601: {0x1C9A, 0x10DA},   // 'Ლ' => 'ლ'
	2598: {0x1C9B, 0x10DB},   // 'Მ' => 'მ'
	2595: {0x1C9C, 0x10DC},   // 'Ნ' => 'ნ'
	2592: {0x1C9D, 0x10DD},   // 'Ო' => 'ო'
	2589: {0x1C9E, 0x10DE},   // 'Პ' => 'პ'
	2586: {0x1C9F, 0x10DF},   // 'Ჟ' => 'ჟ'
	2583: {0x1CA0, 0x10E0},   // 'Რ' => 'რ'
	2580: {0x1CA1, 0x10E1},   // 'Ს' => 'ს'
	2577: {0x1CA2, 0x10E2},   // 'Ტ' => 'ტ'
	2574: {0x1CA3, 0x10E3},   // 'Უ' => 'უ'
	2571: {0x1CA4, 0x10E4},   // 'Ფ' => 'ფ'
	2568: {0x1CA5, 0x10E5},   // 'Ქ' => 'ქ'
	2565: {0x1CA6, 0x10E6},   // 'Ღ' => 'ღ'
	2562: {0x1CA7, 0x10E7},   // 'Ყ' => 'ყ'
	2559: {0x1CA8, 0x10E8},   // 'Შ' => 'შ'
	2556: {0x1CA9, 0x10E9},   // 'Ჩ' => 'ჩ'
	2553: {0x1CAA, 0x10EA},   // 'Ც' => 'ც'
	2550: {0x1CAB, 0x10EB},   // 'Ძ' => 'ძ'
	2547: {0x1CAC, 0x10EC},   // 'Წ' => 'წ'
	2544: {0x1CAD, 0x10ED},   // 'Ჭ' => 'ჭ'
	2541: {0x1CAE, 0x10EE},   // 'Ხ' => 'ხ'
	2538: {0x1CAF, 0x10EF},   // 'Ჯ' => 'ჯ'
	2535: {0x1CB0, 0x10F0},   // 'Ჰ' => 'ჰ'
	2532: {0x1CB1, 0x10F1},   // 'Ჱ' => 'ჱ'
	2529: {0x1CB2, 0x10F2},   // 'Ჲ' => 'ჲ'
	2526: {0x1CB3, 0x10F3},   // 'Ჳ' => 'ჳ'
	2523: {0x1CB4, 0x10F4},   // 'Ჴ' => 'ჴ'
	2520: {0x1CB5, 0x10F5},   // 'Ჵ' => 'ჵ'
	2517: {0x1CB6, 0x10F6},   // 'Ჶ' => 'ჶ'
	2514: {0x1CB7, 0x10F7},   // 'Ჷ' => 'ჷ'
	2511: {0x1CB8, 0x10F8},   // 'Ჸ' => 'ჸ'
	2508: {0x1CB9, 0x10F9},   // 'Ჹ' => 'ჹ'
	2505: {0x1CBA, 0x10FA},   // 'Ჺ' => 'ჺ'
	2496: {0x1CBD, 0x10FD},   // 'Ჽ' => 'ჽ'
	2493: {0x1CBE, 0x10FE},   // 'Ჾ' => 'ჾ'
	2490: {0x1CBF, 0x10FF},   // 'Ჿ' => 'ჿ'
	1932: {0xA77D, 0x1D79},   // 'Ᵹ' => 'ᵹ'
	1920: {0x2C63, 0x1D7D},   // 'Ᵽ' => 'ᵽ'
	1869: {0xA7C6, 0x1D8E},   // 'Ᶎ' => 'ᶎ'
	1526: {0x1E00, 0x1E01},   // 'Ḁ' => 'ḁ'
	1523: {0x1E00, 0x1E01},   // 'Ḁ' => 'ḁ'
	1520: {0x1E02, 0x1E03},   // 'Ḃ' => 'ḃ'
	1517: {0x1E02, 0x1E03},   // 'Ḃ' => 'ḃ'
	1514: {0x1E04, 0x1E05},   // 'Ḅ' => 'ḅ'
	1511: {0x1E04, 0x1E05},   // 'Ḅ' => 'ḅ'
	1508: {0x1E06, 0x1E07},   // 'Ḇ' => 'ḇ'
	1505: {0x1E06, 0x1E07},   // 'Ḇ' => 'ḇ'
	1502: {0x1E08, 0x1E09},   // 'Ḉ' => 'ḉ'
	1499: {0x1E08, 0x1E09},   // 'Ḉ' => 'ḉ'
	1496: {0x1E0A, 0x1E0B},   // 'Ḋ' => 'ḋ'
	1493: {0x1E0A, 0x1E0B},   // 'Ḋ' => 'ḋ'
	1490: {0x1E0C, 0x1E0D},   // 'Ḍ' => 'ḍ'
	1487: {0x1E0C, 0x1E0D},   // 'Ḍ' => 'ḍ'
	1484: {0x1E0E, 0x1E0F},   // 'Ḏ' => 'ḏ'
	1481: {0x1E0E, 0x1E0F},   // 'Ḏ' => 'ḏ'
	1478: {0x1E10, 0x1E11},   // 'Ḑ' => 'ḑ'
	1475: {0x1E10, 0x1E11},   // 'Ḑ' => 'ḑ'
	1472: {0x1E12, 0x1E13},   // 'Ḓ' => 'ḓ'
	1469: {0x1E12, 0x1E13},   // 'Ḓ' => 'ḓ'
	1466: {0x1E14, 0x1E15},   // 'Ḕ' => 'ḕ'
	1463: {0x1E14, 0x1E15},   // 'Ḕ' => 'ḕ'
	1460: {0x1E16, 0x1E17},   // 'Ḗ' => 'ḗ'
	1457: {0x1E16, 0x1E17},   // 'Ḗ' => 'ḗ'
	1454: {0x1E18, 0x1E19},   // 'Ḙ' => 'ḙ'
	1451: {0x1E18, 0x1E19},   // 'Ḙ' => 'ḙ'
	1448: {0x1E1A, 0x1E1B},   // 'Ḛ' => 'ḛ'
	1445: {0x1E1A, 0x1E1B},   // 'Ḛ' => 'ḛ'
	1442: {0x1E1C, 0x1E1D},   // 'Ḝ' => 'ḝ'
	1439: {0x1E1C, 0x1E1D},   // 'Ḝ' => 'ḝ'
	1436: {0x1E1E, 0x1E1F},   // 'Ḟ' => 'ḟ'
	1433: {0x1E1E, 0x1E1F},   // 'Ḟ' => 'ḟ'
	1430: {0x1E20, 0x1E21},   // 'Ḡ' => 'ḡ'
	1427: {0x1E20, 0x1E21},   // 'Ḡ' => 'ḡ'
	1424: {0x1E22, 0x1E23},   // 'Ḣ' => 'ḣ'
	1421: {0x1E22, 0x1E23},   // 'Ḣ' => 'ḣ'
	1418: {0x1E24, 0x1E25},   // 'Ḥ' => 'ḥ'
	1415: {0x1E24, 0x1E25},   // 'Ḥ' => 'ḥ'
	1412: {0x1E26, 0x1E27},   // 'Ḧ' => 'ḧ'
	1409: {0x1E26, 0x1E27},   // 'Ḧ' => 'ḧ'
	1406: {0x1E28, 0x1E29},   // 'Ḩ' => 'ḩ'
	1403: {0x1E28, 0x1E29},   // 'Ḩ' => 'ḩ'
	1400: {0x1E2A, 0x1E2B},   // 'Ḫ' => 'ḫ'
	1397: {0x1E2A, 0x1E2B},   // 'Ḫ' => 'ḫ'
	1394: {0x1E2C, 0x1E2D},   // 'Ḭ' => 'ḭ'
	1391: {0x1E2C, 0x1E2D},   // 'Ḭ' => 'ḭ'
	1388: {0x1E2E, 0x1E2F},   // 'Ḯ' => 'ḯ'
	1385: {0x1E2E, 0x1E2F},   // 'Ḯ' => 'ḯ'
	1382: {0x1E30, 0x1E31},   // 'Ḱ' => 'ḱ'
	1379: {0x1E30, 0x1E31},   // 'Ḱ' => 'ḱ'
	1376: {0x1E32, 0x1E33},   // 'Ḳ' => 'ḳ'
	1373: {0x1E32, 0x1E33},   // 'Ḳ' => 'ḳ'
	1370: {0x1E34, 0x1E35},   // 'Ḵ' => 'ḵ'
	1367: {0x1E34, 0x1E35},   // 'Ḵ' => 'ḵ'
	1364: {0x1E36, 0x1E37},   // 'Ḷ' => 'ḷ'
	1361: {0x1E36, 0x1E37},   // 'Ḷ' => 'ḷ'
	1358: {0x1E38, 0x1E39},   // 'Ḹ' => 'ḹ'
	1355: {0x1E38, 0x1E39},   // 'Ḹ' => 'ḹ'
	1352: {0x1E3A, 0x1E3B},   // 'Ḻ' => 'ḻ'
	1349: {0x1E3A, 0x1E3B},   // 'Ḻ' => 'ḻ'
	1346: {0x1E3C, 0x1E3D},   // 'Ḽ' => 'ḽ'
	1343: {0x1E3C, 0x1E3D},   // 'Ḽ' => 'ḽ'
	1340: {0x1E3E, 0x1E3F},   // 'Ḿ' => 'ḿ'
	1337: {0x1E3E, 0x1E3F},   // 'Ḿ' => 'ḿ'
	1334: {0x1E40, 0x1E41},   // 'Ṁ' => 'ṁ'
	1331: {0x1E40, 0x1E41},   // 'Ṁ' => 'ṁ'
	1328: {0x1E42, 0x1E43},   // 'Ṃ' => 'ṃ'
	1325: {0x1E42, 0x1E43},   // 'Ṃ' => 'ṃ'
	1322: {0x1E44, 0x1E45},   // 'Ṅ' => 'ṅ'
	1319: {0x1E44, 0x1E45},   // 'Ṅ' => 'ṅ'
	1316: {0x1E46, 0x1E47},   // 'Ṇ' => 'ṇ'
	1313: {0x1E46, 0x1E47},   // 'Ṇ' => 'ṇ'
	1310: {0x1E48, 0x1E49},   // 'Ṉ' => 'ṉ'
	1307: {0x1E48, 0x1E49},   // 'Ṉ' => 'ṉ'
	1304: {0x1E4A, 0x1E4B},   // 'Ṋ' => 'ṋ'
	1301: {0x1E4A, 0x1E4B},   // 'Ṋ' => 'ṋ'
	1298: {0x1E4C, 0x1E4D},   // 'Ṍ' => 'ṍ'
	1295: {0x1E4C, 0x1E4D},   // 'Ṍ' => 'ṍ'
	1292: {0x1E4E, 0x1E4F},   // 'Ṏ' => 'ṏ'
	1289: {0x1E4E, 0x1E4F},   // 'Ṏ' => 'ṏ'
	1286: {0x1E50, 0x1E51},   // 'Ṑ' => 'ṑ'
	1283: {0x1E50, 0x1E51},   // 'Ṑ' => 'ṑ'
	1280: {0x1E52, 0x1E53},   // 'Ṓ' => 'ṓ'
	1277: {0x1E52, 0x1E53},   // 'Ṓ' => 'ṓ'
	1274: {0x1E54, 0x1E55},   // 'Ṕ' => 'ṕ'
	1271: {0x1E54, 0x1E55},   // 'Ṕ' => 'ṕ'
	1268: {0x1E56, 0x1E57},   // 'Ṗ' => 'ṗ'
	1265: {0x1E56, 0x1E57},   // 'Ṗ' => 'ṗ'
	1262: {0x1E58, 0x1E59},   // 'Ṙ' => 'ṙ'
	1259: {0x1E58, 0x1E59},   // 'Ṙ' => 'ṙ'
	1256: {0x1E5A, 0x1E5B},   // 'Ṛ' => 'ṛ'
	1253: {0x1E5A, 0x1E5B},   // 'Ṛ' => 'ṛ'
	1250: {0x1E5C, 0x1E5D},   // 'Ṝ' => 'ṝ'
	1247: {0x1E5C, 0x1E5D},   // 'Ṝ' => 'ṝ'
	1244: {0x1E5E, 0x1E5F},   // 'Ṟ' => 'ṟ'
	1241: {0x1E5E, 0x1E5F},   // 'Ṟ' => 'ṟ'
	1238: {0x1E60, 0x1E61},   // 'Ṡ' => 'ṡ'
	1235: {0x1E60, 0x1E61},   // 'Ṡ' => 'ṡ'
	1232: {0x1E62, 0x1E63},   // 'Ṣ' => 'ṣ'
	1229: {0x1E62, 0x1E63},   // 'Ṣ' => 'ṣ'
	1226: {0x1E64, 0x1E65},   // 'Ṥ' => 'ṥ'
	1223: {0x1E64, 0x1E65},   // 'Ṥ' => 'ṥ'
	1220: {0x1E66, 0x1E67},   // 'Ṧ' => 'ṧ'
	1217: {0x1E66, 0x1E67},   // 'Ṧ' => 'ṧ'
	1214: {0x1E68, 0x1E69},   // 'Ṩ' => 'ṩ'
	1211: {0x1E68, 0x1E69},   // 'Ṩ' => 'ṩ'
	1208: {0x1E6A, 0x1E6B},   // 'Ṫ' => 'ṫ'
	1205: {0x1E6A, 0x1E6B},   // 'Ṫ' => 'ṫ'
	1202: {0x1E6C, 0x1E6D},   // 'Ṭ' => 'ṭ'
	1199: {0x1E6C, 0x1E6D},   // 'Ṭ' => 'ṭ'
	1196: {0x1E6E, 0x1E6F},   // 'Ṯ' => 'ṯ'
	1193: {0x1E6E, 0x1E6F},   // 'Ṯ' => 'ṯ'
	1190: {0x1E70, 0x1E71},   // 'Ṱ' => 'ṱ'
	1187: {0x1E70, 0x1E71},   // 'Ṱ' => 'ṱ'
	1184: {0x1E72, 0x1E73},   // 'Ṳ' => 'ṳ'
	1181: {0x1E72, 0x1E73},   // 'Ṳ' => 'ṳ'
	1178: {0x1E74, 0x1E75},   // 'Ṵ' => 'ṵ'
	1175: {0x1E74, 0x1E75},   // 'Ṵ' => 'ṵ'
	1172: {0x1E76, 0x1E77},   // 'Ṷ' => 'ṷ'
	1169: {0x1E76, 0x1E77},   // 'Ṷ' => 'ṷ'
	1166: {0x1E78, 0x1E79},   // 'Ṹ' => 'ṹ'
	1163: {0x1E78, 0x1E79},   // 'Ṹ' => 'ṹ'
	1160: {0x1E7A, 0x1E7B},   // 'Ṻ' => 'ṻ'
	1157: {0x1E7A, 0x1E7B},   // 'Ṻ' => 'ṻ'
	1154: {0x1E7C, 0x1E7D},   // 'Ṽ' => 'ṽ'
	1151: {0x1E7C, 0x1E7D},   // 'Ṽ' => 'ṽ'
	1148: {0x1E7E, 0x1E7F},   // 'Ṿ' => 'ṿ'
	1145: {0x1E7E, 0x1E7F},   // 'Ṿ' => 'ṿ'
	1142: {0x1E80, 0x1E81},   // 'Ẁ' => 'ẁ'
	1139: {0x1E80, 0x1E81},   // 'Ẁ' => 'ẁ'
	1136: {0x1E82, 0x1E83},   // 'Ẃ' => 'ẃ'
	1133: {0x1E82, 0x1E83},   // 'Ẃ' => 'ẃ'
	1130: {0x1E84, 0x1E85},   // 'Ẅ' => 'ẅ'
	1127: {0x1E84, 0x1E85},   // 'Ẅ' => 'ẅ'
	1124: {0x1E86, 0x1E87},   // 'Ẇ' => 'ẇ'
	1121: {0x1E86, 0x1E87},   // 'Ẇ' => 'ẇ'
	1118: {0x1E88, 0x1E89},   // 'Ẉ' => 'ẉ'
	1115: {0x1E88, 0x1E89},   // 'Ẉ' => 'ẉ'
	1112: {0x1E8A, 0x1E8B},   // 'Ẋ' => 'ẋ'
	1109: {0x1E8A, 0x1E8B},   // 'Ẋ' => 'ẋ'
	1106: {0x1E8C, 0x1E8D},   // 'Ẍ' => 'ẍ'
	1103: {0x1E8C, 0x1E8D},   // 'Ẍ' => 'ẍ'
	1100: {0x1E8E, 0x1E8F},   // 'Ẏ' => 'ẏ'
	1097: {0x1E8E, 0x1E8F},   // 'Ẏ' => 'ẏ'
	1094: {0x1E90, 0x1E91},   // 'Ẑ' => 'ẑ'
	1091: {0x1E90, 0x1E91},   // 'Ẑ' => 'ẑ'
	1088: {0x1E92, 0x1E93},   // 'Ẓ' => 'ẓ'
	1085: {0x1E92, 0x1E93},   // 'Ẓ' => 'ẓ'
	1082: {0x1E94, 0x1E95},   // 'Ẕ' => 'ẕ'
	1079: {0x1E94, 0x1E95},   // 'Ẕ' => 'ẕ'
	1061: {0x1E60, 0x1E9B},   // 'Ṡ' => 'ẛ'
	1052: {0x1E9E, 0x00DF},   // 'ẞ' => 'ß'
	1046: {0x1EA0, 0x1EA1},   // 'Ạ' => 'ạ'
	1043: {0x1EA0, 0x1EA1},   // 'Ạ' => 'ạ'
	1040: {0x1EA2, 0x1EA3},   // 'Ả' => 'ả'
	1037: {0x1EA2, 0x1EA3},   // 'Ả' => 'ả'
	1034: {0x1EA4, 0x1EA5},   // 'Ấ' => 'ấ'
	1031: {0x1EA4, 0x1EA5},   // 'Ấ' => 'ấ'
	1028: {0x1EA6, 0x1EA7},   // 'Ầ' => 'ầ'
	1025: {0x1EA6, 0x1EA7},   // 'Ầ' => 'ầ'
	1022: {0x1EA8, 0x1EA9},   // 'Ẩ' => 'ẩ'
	1019: {0x1EA8, 0x1EA9},   // 'Ẩ' => 'ẩ'
	1016: {0x1EAA, 0x1EAB},   // 'Ẫ' => 'ẫ'
	1013: {0x1EAA, 0x1EAB},   // 'Ẫ' => 'ẫ'
	1010: {0x1EAC, 0x1EAD},   // 'Ậ' => 'ậ'
	1007: {0x1EAC, 0x1EAD},   // 'Ậ' => 'ậ'
	1004: {0x1EAE, 0x1EAF},   // 'Ắ' => 'ắ'
	1001: {0x1EAE, 0x1EAF},   // 'Ắ' => 'ắ'
	998:  {0x1EB0, 0x1EB1},   // 'Ằ' => 'ằ'
	995:  {0x1EB0, 0x1EB1},   // 'Ằ' => 'ằ'
	992:  {0x1EB2, 0x1EB3},   // 'Ẳ' => 'ẳ'
	989:  {0x1EB2, 0x1EB3},   // 'Ẳ' => 'ẳ'
	986:  {0x1EB4, 0x1EB5},   // 'Ẵ' => 'ẵ'
	983:  {0x1EB4, 0x1EB5},   // 'Ẵ' => 'ẵ'
	980:  {0x1EB6, 0x1EB7},   // 'Ặ' => 'ặ'
	977:  {0x1EB6, 0x1EB7},   // 'Ặ' => 'ặ'
	974:  {0x1EB8, 0x1EB9},   // 'Ẹ' => 'ẹ'
	971:  {0x1EB8, 0x1EB9},   // 'Ẹ' => 'ẹ'
	968:  {0x1EBA, 0x1EBB},   // 'Ẻ' => 'ẻ'
	965:  {0x1EBA, 0x1EBB},   // 'Ẻ' => 'ẻ'
	962:  {0x1EBC, 0x1EBD},   // 'Ẽ' => 'ẽ'
	959:  {0x1EBC, 0x1EBD},   // 'Ẽ' => 'ẽ'
	956:  {0x1EBE, 0x1EBF},   // 'Ế' => 'ế'
	953:  {0x1EBE, 0x1EBF},   // 'Ế' => 'ế'
	950:  {0x1EC0, 0x1EC1},   // 'Ề' => 'ề'
	947:  {0x1EC0, 0x1EC1},   // 'Ề' => 'ề'
	944:  {0x1EC2, 0x1EC3},   // 'Ể' => 'ể'
	941:  {0x1EC2, 0x1EC3},   // 'Ể' => 'ể'
	938:  {0x1EC4, 0x1EC5},   // 'Ễ' => 'ễ'
	935:  {0x1EC4, 0x1EC5},   // 'Ễ' => 'ễ'
	932:  {0x1EC6, 0x1EC7},   // 'Ệ' => 'ệ'
	929:  {0x1EC6, 0x1EC7},   // 'Ệ' => 'ệ'
	926:  {0x1EC8, 0x1EC9},   // 'Ỉ' => 'ỉ'
	923:  {0x1EC8, 0x1EC9},   // 'Ỉ' => 'ỉ'
	920:  {0x1ECA, 0x1ECB},   // 'Ị' => 'ị'
	917:  {0x1ECA, 0x1ECB},   // 'Ị' => 'ị'
	914:  {0x1ECC, 0x1ECD},   // 'Ọ' => 'ọ'
	911:  {0x1ECC, 0x1ECD},   // 'Ọ' => 'ọ'
	908:  {0x1ECE, 0x1ECF},   // 'Ỏ' => 'ỏ'
	905:  {0x1ECE, 0x1ECF},   // 'Ỏ' => 'ỏ'
	902:  {0x1ED0, 0x1ED1},   // 'Ố' => 'ố'
	899:  {0x1ED0, 0x1ED1},   // 'Ố' => 'ố'
	896:  {0x1ED2, 0x1ED3},   // 'Ồ' => 'ồ'
	893:  {0x1ED2, 0x1ED3},   // 'Ồ' => 'ồ'
	890:  {0x1ED4, 0x1ED5},   // 'Ổ' => 'ổ'
	887:  {0x1ED4, 0x1ED5},   // 'Ổ' => 'ổ'
	884:  {0x1ED6, 0x1ED7},   // 'Ỗ' => 'ỗ'
	881:  {0x1ED6, 0x1ED7},   // 'Ỗ' => 'ỗ'
	878:  {0x1ED8, 0x1ED9},   // 'Ộ' => 'ộ'
	875:  {0x1ED8, 0x1ED9},   // 'Ộ' => 'ộ'
	872:  {0x1EDA, 0x1EDB},   // 'Ớ' => 'ớ'
	869:  {0x1EDA, 0x1EDB},   // 'Ớ' => 'ớ'
	866:  {0x1EDC, 0x1EDD},   // 'Ờ' => 'ờ'
	863:  {0x1EDC, 0x1EDD},   // 'Ờ' => 'ờ'
	860:  {0x1EDE, 0x1EDF},   // 'Ở' => 'ở'
	857:  {0x1EDE, 0x1EDF},   // 'Ở' => 'ở'
	854:  {0x1EE0, 0x1EE1},   // 'Ỡ' => 'ỡ'
	851:  {0x1EE0, 0x1EE1},   // 'Ỡ' => 'ỡ'
	848:  {0x1EE2, 0x1EE3},   // 'Ợ' => 'ợ'
	845:  {0x1EE2, 0x1EE3},   // 'Ợ' => 'ợ'
	842:  {0x1EE4, 0x1EE5},   // 'Ụ' => 'ụ'
	839:  {0x1EE4, 0x1EE5},   // 'Ụ' => 'ụ'
	836:  {0x1EE6, 0x1EE7},   // 'Ủ' => 'ủ'
	833:  {0x1EE6, 0x1EE7},   // 'Ủ' => 'ủ'
	830:  {0x1EE8, 0x1EE9},   // 'Ứ' => 'ứ'
	827:  {0x1EE8, 0x1EE9},   // 'Ứ' => 'ứ'
	824:  {0x1EEA, 0x1EEB},   // 'Ừ' => 'ừ'
	821:  {0x1EEA, 0x1EEB},   // 'Ừ' => 'ừ'
	818:  {0x1EEC, 0x1EED},   // 'Ử' => 'ử'
	815:  {0x1EEC, 0x1EED},   // 'Ử' => 'ử'
	812:  {0x1EEE, 0x1EEF},   // 'Ữ' => 'ữ'
	809:  {0x1EEE, 0x1EEF},   // 'Ữ' => 'ữ'
	806:  {0x1EF0, 0x1EF1},   // 'Ự' => 'ự'
	803:  {0x1EF0, 0x1EF1},   // 'Ự' => 'ự'
	800:  {0x1EF2, 0x1EF3},   // 'Ỳ' => 'ỳ'
	797:  {0x1EF2, 0x1EF3},   // 'Ỳ' => 'ỳ'
	794:  {0x1EF4, 0x1EF5},   // 'Ỵ' => 'ỵ'
	791:  {0x1EF4, 0x1EF5},   // 'Ỵ' => 'ỵ'
	788:  {0x1EF6, 0x1EF7},   // 'Ỷ' => 'ỷ'
	785:  {0x1EF6, 0x1EF7},   // 'Ỷ' => 'ỷ'
	782:  {0x1EF8, 0x1EF9},   // 'Ỹ' => 'ỹ'
	779:  {0x1EF8, 0x1EF9},   // 'Ỹ' => 'ỹ'
	776:  {0x1EFA, 0x1EFB},   // 'Ỻ' => 'ỻ'
	773:  {0x1EFA, 0x1EFB},   // 'Ỻ' => 'ỻ'
	770:  {0x1EFC, 0x1EFD},   // 'Ỽ' => 'ỽ'
	767:  {0x1EFC, 0x1EFD},   // 'Ỽ' => 'ỽ'
	764:  {0x1EFE, 0x1EFF},   // 'Ỿ' => 'ỿ'
	761:  {0x1EFE, 0x1EFF},   // 'Ỿ' => 'ỿ'
	758:  {0x1F08, 0x1F00},   // 'Ἀ' => 'ἀ'
	755:  {0x1F09, 0x1F01},   // 'Ἁ' => 'ἁ'
	752:  {0x1F0A, 0x1F02},   // 'Ἂ' => 'ἂ'
	749:  {0x1F0B, 0x1F03},   // 'Ἃ' => 'ἃ'
	746:  {0x1F0C, 0x1F04},   // 'Ἄ' => 'ἄ'
	743:  {0x1F0D, 0x1F05},   // 'Ἅ' => 'ἅ'
	740:  {0x1F0E, 0x1F06},   // 'Ἆ' => 'ἆ'
	737:  {0x1F0F, 0x1F07},   // 'Ἇ' => 'ἇ'
	734:  {0x1F08, 0x1F00},   // 'Ἀ' => 'ἀ'
	731:  {0x1F09, 0x1F01},   // 'Ἁ' => 'ἁ'
	728:  {0x1F0A, 0x1F02},   // 'Ἂ' => 'ἂ'
	725:  {0x1F0B, 0x1F03},   // 'Ἃ' => 'ἃ'
	722:  {0x1F0C, 0x1F04},   // 'Ἄ' => 'ἄ'
	719:  {0x1F0D, 0x1F05},   // 'Ἅ' => 'ἅ'
	716:  {0x1F0E, 0x1F06},   // 'Ἆ' => 'ἆ'
	713:  {0x1F0F, 0x1F07},   // 'Ἇ' => 'ἇ'
	710:  {0x1F18, 0x1F10},   // 'Ἐ' => 'ἐ'
	707:  {0x1F19, 0x1F11},   // 'Ἑ' => 'ἑ'
	704:  {0x1F1A, 0x1F12},   // 'Ἒ' => 'ἒ'
	701:  {0x1F1B, 0x1F13},   // 'Ἓ' => 'ἓ'
	698:  {0x1F1C, 0x1F14},   // 'Ἔ' => 'ἔ'
	695:  {0x1F1D, 0x1F15},   // 'Ἕ' => 'ἕ'
	686:  {0x1F18, 0x1F10},   // 'Ἐ' => 'ἐ'
	683:  {0x1F19, 0x1F11},   // 'Ἑ' => 'ἑ'
	680:  {0x1F1A, 0x1F12},   // 'Ἒ' => 'ἒ'
	677:  {0x1F1B, 0x1F13},   // 'Ἓ' => 'ἓ'
	674:  {0x1F1C, 0x1F14},   // 'Ἔ' => 'ἔ'
	671:  {0x1F1D, 0x1F15},   // 'Ἕ' => 'ἕ'
	662:  {0x1F28, 0x1F20},   // 'Ἠ' => 'ἠ'
	659:  {0x1F29, 0x1F21},   // 'Ἡ' => 'ἡ'
	656:  {0x1F2A, 0x1F22},   // 'Ἢ' => 'ἢ'
	653:  {0x1F2B, 0x1F23},   // 'Ἣ' => 'ἣ'
	650:  {0x1F2C, 0x1F24},   // 'Ἤ' => 'ἤ'
	647:  {0x1F2D, 0x1F25},   // 'Ἥ' => 'ἥ'
	644:  {0x1F2E, 0x1F26},   // 'Ἦ' => 'ἦ'
	641:  {0x1F2F, 0x1F27},   // 'Ἧ' => 'ἧ'
	638:  {0x1F28, 0x1F20},   // 'Ἠ' => 'ἠ'
	635:  {0x1F29, 0x1F21},   // 'Ἡ' => 'ἡ'
	632:  {0x1F2A, 0x1F22},   // 'Ἢ' => 'ἢ'
	629:  {0x1F2B, 0x1F23},   // 'Ἣ' => 'ἣ'
	626:  {0x1F2C, 0x1F24},   // 'Ἤ' => 'ἤ'
	623:  {0x1F2D, 0x1F25},   // 'Ἥ' => 'ἥ'
	620:  {0x1F2E, 0x1F26},   // 'Ἦ' => 'ἦ'
	617:  {0x1F2F, 0x1F27},   // 'Ἧ' => 'ἧ'
	614:  {0x1F38, 0x1F30},   // 'Ἰ' => 'ἰ'
	611:  {0x1F39, 0x1F31},   // 'Ἱ' => 'ἱ'
	608:  {0x1F3A, 0x1F32},   // 'Ἲ' => 'ἲ'
	605:  {0x1F3B, 0x1F33},   // 'Ἳ' => 'ἳ'
	602:  {0x1F3C, 0x1F34},   // 'Ἴ' => 'ἴ'
	599:  {0x1F3D, 0x1F35},   // 'Ἵ' => 'ἵ'
	596:  {0x1F3E, 0x1F36},   // 'Ἶ' => 'ἶ'
	593:  {0x1F3F, 0x1F37},   // 'Ἷ' => 'ἷ'
	590:  {0x1F38, 0x1F30},   // 'Ἰ' => 'ἰ'
	587:  {0x1F39, 0x1F31},   // 'Ἱ' => 'ἱ'
	584:  {0x1F3A, 0x1F32},   // 'Ἲ' => 'ἲ'
	581:  {0x1F3B, 0x1F33},   // 'Ἳ' => 'ἳ'
	578:  {0x1F3C, 0x1F34},   // 'Ἴ' => 'ἴ'
	575:  {0x1F3D, 0x1F35},   // 'Ἵ' => 'ἵ'
	572:  {0x1F3E, 0x1F36},   // 'Ἶ' => 'ἶ'
	569:  {0x1F3F, 0x1F37},   // 'Ἷ' => 'ἷ'
	566:  {0x1F48, 0x1F40},   // 'Ὀ' => 'ὀ'
	563:  {0x1F49, 0x1F41},   // 'Ὁ' => 'ὁ'
	560:  {0x1F4A, 0x1F42},   // 'Ὂ' => 'ὂ'
	557:  {0x1F4B, 0x1F43},   // 'Ὃ' => 'ὃ'
	554:  {0x1F4C, 0x1F44},   // 'Ὄ' => 'ὄ'
	551:  {0x1F4D, 0x1F45},   // 'Ὅ' => 'ὅ'
	542:  {0x1F48, 0x1F40},   // 'Ὀ' => 'ὀ'
	539:  {0x1F49, 0x1F41},   // 'Ὁ' => 'ὁ'
	536:  {0x1F4A, 0x1F42},   // 'Ὂ' => 'ὂ'
	533:  {0x1F4B, 0x1F43},   // 'Ὃ' => 'ὃ'
	530:  {0x1F4C, 0x1F44},   // 'Ὄ' => 'ὄ'
	527:  {0x1F4D, 0x1F45},   // 'Ὅ' => 'ὅ'
	515:  {0x1F59, 0x1F51},   // 'Ὑ' => 'ὑ'
	509:  {0x1F5B, 0x1F53},   // 'Ὓ' => 'ὓ'
	503:  {0x1F5D, 0x1F55},   // 'Ὕ' => 'ὕ'
	497:  {0x1F5F, 0x1F57},   // 'Ὗ' => 'ὗ'
	491:  {0x1F59, 0x1F51},   // 'Ὑ' => 'ὑ'
	485:  {0x1F5B, 0x1F53},   // 'Ὓ' => 'ὓ'
	479:  {0x1F5D, 0x1F55},   // 'Ὕ' => 'ὕ'
	473:  {0x1F5F, 0x1F57},   // 'Ὗ' => 'ὗ'
	470:  {0x1F68, 0x1F60},   // 'Ὠ' => 'ὠ'
	467:  {0x1F69, 0x1F61},   // 'Ὡ' => 'ὡ'
	464:  {0x1F6A, 0x1F62},   // 'Ὢ' => 'ὢ'
	461:  {0x1F6B, 0x1F63},   // 'Ὣ' => 'ὣ'
	458:  {0x1F6C, 0x1F64},   // 'Ὤ' => 'ὤ'
	455:  {0x1F6D, 0x1F65},   // 'Ὥ' => 'ὥ'
	452:  {0x1F6E, 0x1F66},   // 'Ὦ' => 'ὦ'
	449:  {0x1F6F, 0x1F67},   // 'Ὧ' => 'ὧ'
	446:  {0x1F68, 0x1F60},   // 'Ὠ' => 'ὠ'
	443:  {0x1F69, 0x1F61},   // 'Ὡ' => 'ὡ'
	440:  {0x1F6A, 0x1F62},   // 'Ὢ' => 'ὢ'
	437:  {0x1F6B, 0x1F63},   // 'Ὣ' => 'ὣ'
	434:  {0x1F6C, 0x1F64},   // 'Ὤ' => 'ὤ'
	431:  {0x1F6D, 0x1F65},   // 'Ὥ' => 'ὥ'
	428:  {0x1F6E, 0x1F66},   // 'Ὦ' => 'ὦ'
	425:  {0x1F6F, 0x1F67},   // 'Ὧ' => 'ὧ'
	422:  {0x1FBA, 0x1F70},   // 'Ὰ' => 'ὰ'
	419:  {0x1FBB, 0x1F71},   // 'Ά' => 'ά'
	416:  {0x1FC8, 0x1F72},   // 'Ὲ' => 'ὲ'
	413:  {0x1FC9, 0x1F73},   // 'Έ' => 'έ'
	410:  {0x1FCA, 0x1F74},   // 'Ὴ' => 'ὴ'
	407:  {0x1FCB, 0x1F75},   // 'Ή' => 'ή'
	404:  {0x1FDA, 0x1F76},   // 'Ὶ' => 'ὶ'
	401:  {0x1FDB, 0x1F77},   // 'Ί' => 'ί'
	398:  {0x1FF8, 0x1F78},   // 'Ὸ' => 'ὸ'
	395:  {0x1FF9, 0x1F79},   // 'Ό' => 'ό'
	392:  {0x1FEA, 0x1F7A},   // 'Ὺ' => 'ὺ'
	389:  {0x1FEB, 0x1F7B},   // 'Ύ' => 'ύ'
	386:  {0x1FFA, 0x1F7C},   // 'Ὼ' => 'ὼ'
	383:  {0x1FFB, 0x1F7D},   // 'Ώ' => 'ώ'
	374:  {0x1F88, 0x1F80},   // 'ᾈ' => 'ᾀ'
	371:  {0x1F89, 0x1F81},   // 'ᾉ' => 'ᾁ'
	368:  {0x1F8A, 0x1F82},   // 'ᾊ' => 'ᾂ'
	365:  {0x1F8B, 0x1F83},   // 'ᾋ' => 'ᾃ'
	362:  {0x1F8C, 0x1F84},   // 'ᾌ' => 'ᾄ'
	359:  {0x1F8D, 0x1F85},   // 'ᾍ' => 'ᾅ'
	356:  {0x1F8E, 0x1F86},   // 'ᾎ' => 'ᾆ'
	353:  {0x1F8F, 0x1F87},   // 'ᾏ' => 'ᾇ'
	350:  {0x1F88, 0x1F80},   // 'ᾈ' => 'ᾀ'
	347:  {0x1F89, 0x1F81},   // 'ᾉ' => 'ᾁ'
	344:  {0x1F8A, 0x1F82},   // 'ᾊ' => 'ᾂ'
	341:  {0x1F8B, 0x1F83},   // 'ᾋ' => 'ᾃ'
	338:  {0x1F8C, 0x1F84},   // 'ᾌ' => 'ᾄ'
	335:  {0x1F8D, 0x1F85},   // 'ᾍ' => 'ᾅ'
	332:  {0x1F8E, 0x1F86},   // 'ᾎ' => 'ᾆ'
	329:  {0x1F8F, 0x1F87},   // 'ᾏ' => 'ᾇ'
	326:  {0x1F98, 0x1F90},   // 'ᾘ' => 'ᾐ'
	323:  {0x1F99, 0x1F91},   // 'ᾙ' => 'ᾑ'
	320:  {0x1F9A, 0x1F92},   // 'ᾚ' => 'ᾒ'
	317:  {0x1F9B, 0x1F93},   // 'ᾛ' => 'ᾓ'
	314:  {0x1F9C, 0x1F94},   // 'ᾜ' => 'ᾔ'
	311:  {0x1F9D, 0x1F95},   // 'ᾝ' => 'ᾕ'
	308:  {0x1F9E, 0x1F96},   // 'ᾞ' => 'ᾖ'
	305:  {0x1F9F, 0x1F97},   // 'ᾟ' => 'ᾗ'
	302:  {0x1F98, 0x1F90},   // 'ᾘ' => 'ᾐ'
	299:  {0x1F99, 0x1F91},   // 'ᾙ' => 'ᾑ'
	296:  {0x1F9A, 0x1F92},   // 'ᾚ' => 'ᾒ'
	293:  {0x1F9B, 0x1F93},   // 'ᾛ' => 'ᾓ'
	290:  {0x1F9C, 0x1F94},   // 'ᾜ' => 'ᾔ'
	287:  {0x1F9D, 0x1F95},   // 'ᾝ' => 'ᾕ'
	284:  {0x1F9E, 0x1F96},   // 'ᾞ' => 'ᾖ'
	281:  {0x1F9F, 0x1F97},   // 'ᾟ' => 'ᾗ'
	278:  {0x1FA8, 0x1FA0},   // 'ᾨ' => 'ᾠ'
	275:  {0x1FA9, 0x1FA1},   // 'ᾩ' => 'ᾡ'
	272:  {0x1FAA, 0x1FA2},   // 'ᾪ' => 'ᾢ'
	269:  {0x1FAB, 0x1FA3},   // 'ᾫ' => 'ᾣ'
	266:  {0x1FAC, 0x1FA4},   // 'ᾬ' => 'ᾤ'
	263:  {0x1FAD, 0x1FA5},   // 'ᾭ' => 'ᾥ'
	260:  {0x1FAE, 0x1FA6},   // 'ᾮ' => 'ᾦ'
	257:  {0x1FAF, 0x1FA7},   // 'ᾯ' => 'ᾧ'
	254:  {0x1FA8, 0x1FA0},   // 'ᾨ' => 'ᾠ'
	251:  {0x1FA9, 0x1FA1},   // 'ᾩ' => 'ᾡ'
	248:  {0x1FAA, 0x1FA2},   // 'ᾪ' => 'ᾢ'
	245:  {0x1FAB, 0x1FA3},   // 'ᾫ' => 'ᾣ'
	242:  {0x1FAC, 0x1FA4},   // 'ᾬ' => 'ᾤ'
	239:  {0x1FAD, 0x1FA5},   // 'ᾭ' => 'ᾥ'
	236:  {0x1FAE, 0x1FA6},   // 'ᾮ' => 'ᾦ'
	233:  {0x1FAF, 0x1FA7},   // 'ᾯ' => 'ᾧ'
	230:  {0x1FB8, 0x1FB0},   // 'Ᾰ' => 'ᾰ'
	227:  {0x1FB9, 0x1FB1},   // 'Ᾱ' => 'ᾱ'
	221:  {0x1FBC, 0x1FB3},   // 'ᾼ' => 'ᾳ'
	206:  {0x1FB8, 0x1FB0},   // 'Ᾰ' => 'ᾰ'
	203:  {0x1FB9, 0x1FB1},   // 'Ᾱ' => 'ᾱ'
	200:  {0x1FBA, 0x1F70},   // 'Ὰ' => 'ὰ'
	197:  {0x1FBB, 0x1F71},   // 'Ά' => 'ά'
	194:  {0x1FBC, 0x1FB3},   // 'ᾼ' => 'ᾳ'
	188:  {0x0399, 0x1FBE},   // 'Ι' => 'ι'
	173:  {0x1FCC, 0x1FC3},   // 'ῌ' => 'ῃ'
	158:  {0x1FC8, 0x1F72},   // 'Ὲ' => 'ὲ'
	155:  {0x1FC9, 0x1F73},   // 'Έ' => 'έ'
	152:  {0x1FCA, 0x1F74},   // 'Ὴ' => 'ὴ'
	149:  {0x1FCB, 0x1F75},   // 'Ή' => 'ή'
	146:  {0x1FCC, 0x1FC3},   // 'ῌ' => 'ῃ'
	134:  {0x1FD8, 0x1FD0},   // 'Ῐ' => 'ῐ'
	131:  {0x1FD9, 0x1FD1},   // 'Ῑ' => 'ῑ'
	110:  {0x1FD8, 0x1FD0},   // 'Ῐ' => 'ῐ'
	107:  {0x1FD9, 0x1FD1},   // 'Ῑ' => 'ῑ'
	104:  {0x1FDA, 0x1F76},   // 'Ὶ' => 'ὶ'
	101:  {0x1FDB, 0x1F77},   // 'Ί' => 'ί'
	86:   {0x1FE8, 0x1FE0},   // 'Ῠ' => 'ῠ'
	83:   {0x1FE9, 0x1FE1},   // 'Ῡ' => 'ῡ'
	71:   {0x1FEC, 0x1FE5},   // 'Ῥ' => 'ῥ'
	62:   {0x1FE8, 0x1FE0},   // 'Ῠ' => 'ῠ'
	59:   {0x1FE9, 0x1FE1},   // 'Ῡ' => 'ῡ'
	56:   {0x1FEA, 0x1F7A},   // 'Ὺ' => 'ὺ'
	53:   {0x1FEB, 0x1F7B},   // 'Ύ' => 'ύ'
	50:   {0x1FEC, 0x1FE5},   // 'Ῥ' => 'ῥ'
	29:   {0x1FFC, 0x1FF3},   // 'ῼ' => 'ῳ'
	14:   {0x1FF8, 0x1F78},   // 'Ὸ' => 'ὸ'
	11:   {0x1FF9, 0x1F79},   // 'Ό' => 'ό'
	8:    {0x1FFA, 0x1F7C},   // 'Ὼ' => 'ὼ'
	5:    {0x1FFB, 0x1F7D},   // 'Ώ' => 'ώ'
	2:    {0x1FFC, 0x1FF3},   // 'ῼ' => 'ῳ'
	7299: {0x2126, 0x03C9},   // 'Ω' => 'ω'
	7287: {0x212A, 0x006B},   // 'K' => 'k'
	7284: {0x212B, 0x00E5},   // 'Å' => 'å'
	7263: {0x2132, 0x214E},   // 'Ⅎ' => 'ⅎ'
	7179: {0x2132, 0x214E},   // 'Ⅎ' => 'ⅎ'
	7125: {0x2160, 0x2170},   // 'Ⅰ' => 'ⅰ'
	7122: {0x2161, 0x2171},   // 'Ⅱ' => 'ⅱ'
	7119: {0x2162, 0x2172},   // 'Ⅲ' => 'ⅲ'
	7116: {0x2163, 0x2173},   // 'Ⅳ' => 'ⅳ'
	7113: {0x2164, 0x2174},   // 'Ⅴ' => 'ⅴ'
	7110: {0x2165, 0x2175},   // 'Ⅵ' => 'ⅵ'
	7107: {0x2166, 0x2176},   // 'Ⅶ' => 'ⅶ'
	7104: {0x2167, 0x2177},   // 'Ⅷ' => 'ⅷ'
	7101: {0x2168, 0x2178},   // 'Ⅸ' => 'ⅸ'
	7098: {0x2169, 0x2179},   // 'Ⅹ' => 'ⅹ'
	7095: {0x216A, 0x217A},   // 'Ⅺ' => 'ⅺ'
	7092: {0x216B, 0x217B},   // 'Ⅻ' => 'ⅻ'
	7089: {0x216C, 0x217C},   // 'Ⅼ' => 'ⅼ'
	7086: {0x216D, 0x217D},   // 'Ⅽ' => 'ⅽ'
	7083: {0x216E, 0x217E},   // 'Ⅾ' => 'ⅾ'
	7080: {0x216F, 0x217F},   // 'Ⅿ' => 'ⅿ'
	7077: {0x2160, 0x2170},   // 'Ⅰ' => 'ⅰ'
	7074: {0x2161, 0x2171},   // 'Ⅱ' => 'ⅱ'
	7071: {0x2162, 0x2172},   // 'Ⅲ' => 'ⅲ'
	7068: {0x2163, 0x2173},   // 'Ⅳ' => 'ⅳ'
	7065: {0x2164, 0x2174},   // 'Ⅴ' => 'ⅴ'
	7062: {0x2165, 0x2175},   // 'Ⅵ' => 'ⅵ'
	7059: {0x2166, 0x2176},   // 'Ⅶ' => 'ⅶ'
	7056: {0x2167, 0x2177},   // 'Ⅷ' => 'ⅷ'
	7053: {0x2168, 0x2178},   // 'Ⅸ' => 'ⅸ'
	7050: {0x2169, 0x2179},   // 'Ⅹ' => 'ⅹ'
	7047: {0x216A, 0x217A},   // 'Ⅺ' => 'ⅺ'
	7044: {0x216B, 0x217B},   // 'Ⅻ' => 'ⅻ'
	7041: {0x216C, 0x217C},   // 'Ⅼ' => 'ⅼ'
	7038: {0x216D, 0x217D},   // 'Ⅽ' => 'ⅽ'
	7035: {0x216E, 0x217E},   // 'Ⅾ' => 'ⅾ'
	7032: {0x216F, 0x217F},   // 'Ⅿ' => 'ⅿ'
	7020: {0x2183, 0x2184},   // 'Ↄ' => 'ↄ'
	7017: {0x2183, 0x2184},   // 'Ↄ' => 'ↄ'
	4562: {0x24B6, 0x24D0},   // 'Ⓐ' => 'ⓐ'
	4559: {0x24B7, 0x24D1},   // 'Ⓑ' => 'ⓑ'
	4556: {0x24B8, 0x24D2},   // 'Ⓒ' => 'ⓒ'
	4553: {0x24B9, 0x24D3},   // 'Ⓓ' => 'ⓓ'
	4550: {0x24BA, 0x24D4},   // 'Ⓔ' => 'ⓔ'
	4547: {0x24BB, 0x24D5},   // 'Ⓕ' => 'ⓕ'
	4544: {0x24BC, 0x24D6},   // 'Ⓖ' => 'ⓖ'
	4541: {0x24BD, 0x24D7},   // 'Ⓗ' => 'ⓗ'
	4538: {0x24BE, 0x24D8},   // 'Ⓘ' => 'ⓘ'
	4535: {0x24BF, 0x24D9},   // 'Ⓙ' => 'ⓙ'
	4532: {0x24C0, 0x24DA},   // 'Ⓚ' => 'ⓚ'
	4529: {0x24C1, 0x24DB},   // 'Ⓛ' => 'ⓛ'
	4526: {0x24C2, 0x24DC},   // 'Ⓜ' => 'ⓜ'
	4523: {0x24C3, 0x24DD},   // 'Ⓝ' => 'ⓝ'
	4520: {0x24C4, 0x24DE},   // 'Ⓞ' => 'ⓞ'
	4517: {0x24C5, 0x24DF},   // 'Ⓟ' => 'ⓟ'
	4514: {0x24C6, 0x24E0},   // 'Ⓠ' => 'ⓠ'
	4511: {0x24C7, 0x24E1},   // 'Ⓡ' => 'ⓡ'
	4508: {0x24C8, 0x24E2},   // 'Ⓢ' => 'ⓢ'
	4505: {0x24C9, 0x24E3},   // 'Ⓣ' => 'ⓣ'
	4502: {0x24CA, 0x24E4},   // 'Ⓤ' => 'ⓤ'
	4499: {0x24CB, 0x24E5},   // 'Ⓥ' => 'ⓥ'
	4496: {0x24CC, 0x24E6},   // 'Ⓦ' => 'ⓦ'
	4493: {0x24CD, 0x24E7},   // 'Ⓧ' => 'ⓧ'
	4490: {0x24CE, 0x24E8},   // 'Ⓨ' => 'ⓨ'
	4487: {0x24CF, 0x24E9},   // 'Ⓩ' => 'ⓩ'
	4484: {0x24B6, 0x24D0},   // 'Ⓐ' => 'ⓐ'
	4481: {0x24B7, 0x24D1},   // 'Ⓑ' => 'ⓑ'
	4478: {0x24B8, 0x24D2},   // 'Ⓒ' => 'ⓒ'
	4475: {0x24B9, 0x24D3},   // 'Ⓓ' => 'ⓓ'
	4472: {0x24BA, 0x24D4},   // 'Ⓔ' => 'ⓔ'
	4469: {0x24BB, 0x24D5},   // 'Ⓕ' => 'ⓕ'
	4466: {0x24BC, 0x24D6},   // 'Ⓖ' => 'ⓖ'
	4463: {0x24BD, 0x24D7},   // 'Ⓗ' => 'ⓗ'
	4460: {0x24BE, 0x24D8},   // 'Ⓘ' => 'ⓘ'
	4457: {0x24BF, 0x24D9},   // 'Ⓙ' => 'ⓙ'
	4454: {0x24C0, 0x24DA},   // 'Ⓚ' => 'ⓚ'
	4451: {0x24C1, 0x24DB},   // 'Ⓛ' => 'ⓛ'
	4448: {0x24C2, 0x24DC},   // 'Ⓜ' => 'ⓜ'
	4445: {0x24C3, 0x24DD},   // 'Ⓝ' => 'ⓝ'
	4442: {0x24C4, 0x24DE},   // 'Ⓞ' => 'ⓞ'
	4439: {0x24C5, 0x24DF},   // 'Ⓟ' => 'ⓟ'
	4436: {0x24C6, 0x24E0},   // 'Ⓠ' => 'ⓠ'
	4433: {0x24C7, 0x24E1},   // 'Ⓡ' => 'ⓡ'
	4430: {0x24C8, 0x24E2},   // 'Ⓢ' => 'ⓢ'
	4427: {0x24C9, 0x24E3},   // 'Ⓣ' => 'ⓣ'
	4424: {0x24CA, 0x24E4},   // 'Ⓤ' => 'ⓤ'
	4421: {0x24CB, 0x24E5},   // 'Ⓥ' => 'ⓥ'
	4418: {0x24CC, 0x24E6},   // 'Ⓦ' => 'ⓦ'
	4415: {0x24CD, 0x24E7},   // 'Ⓧ' => 'ⓧ'
	4412: {0x24CE, 0x24E8},   // 'Ⓨ' => 'ⓨ'
	4409: {0x24CF, 0x24E9},   // 'Ⓩ' => 'ⓩ'
	7154: {0x2C00, 0x2C30},   // 'Ⰰ' => 'ⰰ'
	7151: {0x2C01, 0x2C31},   // 'Ⰱ' => 'ⰱ'
	7148: {0x2C02, 0x2C32},   // 'Ⰲ' => 'ⰲ'
	7145: {0x2C03, 0x2C33},   // 'Ⰳ' => 'ⰳ'
	7142: {0x2C04, 0x2C34},   // 'Ⰴ' => 'ⰴ'
	7139: {0x2C05, 0x2C35},   // 'Ⰵ' => 'ⰵ'
	7136: {0x2C06, 0x2C36},   // 'Ⰶ' => 'ⰶ'
	7133: {0x2C07, 0x2C37},   // 'Ⰷ' => 'ⰷ'
	7130: {0x2C08, 0x2C38},   // 'Ⰸ' => 'ⰸ'
	7127: {0x2C09, 0x2C39},   // 'Ⰹ' => 'ⰹ'
	7124: {0x2C0A, 0x2C3A},   // 'Ⰺ' => 'ⰺ'
	7121: {0x2C0B, 0x2C3B},   // 'Ⰻ' => 'ⰻ'
	7118: {0x2C0C, 0x2C3C},   // 'Ⰼ' => 'ⰼ'
	7115: {0x2C0D, 0x2C3D},   // 'Ⰽ' => 'ⰽ'
	7112: {0x2C0E, 0x2C3E},   // 'Ⰾ' => 'ⰾ'
	7109: {0x2C0F, 0x2C3F},   // 'Ⰿ' => 'ⰿ'
	7106: {0x2C10, 0x2C40},   // 'Ⱀ' => 'ⱀ'
	7103: {0x2C11, 0x2C41},   // 'Ⱁ' => 'ⱁ'
	7100: {0x2C12, 0x2C42},   // 'Ⱂ' => 'ⱂ'
	7097: {0x2C13, 0x2C43},   // 'Ⱃ' => 'ⱃ'
	7094: {0x2C14, 0x2C44},   // 'Ⱄ' => 'ⱄ'
	7091: {0x2C15, 0x2C45},   // 'Ⱅ' => 'ⱅ'
	7088: {0x2C16, 0x2C46},   // 'Ⱆ' => 'ⱆ'
	7085: {0x2C17, 0x2C47},   // 'Ⱇ' => 'ⱇ'
	7082: {0x2C18, 0x2C48},   // 'Ⱈ' => 'ⱈ'
	7079: {0x2C19, 0x2C49},   // 'Ⱉ' => 'ⱉ'
	7076: {0x2C1A, 0x2C4A},   // 'Ⱊ' => 'ⱊ'
	7073: {0x2C1B, 0x2C4B},   // 'Ⱋ' => 'ⱋ'
	7070: {0x2C1C, 0x2C4C},   // 'Ⱌ' => 'ⱌ'
	7067: {0x2C1D, 0x2C4D},   // 'Ⱍ' => 'ⱍ'
	7064: {0x2C1E, 0x2C4E},   // 'Ⱎ' => 'ⱎ'
	7061: {0x2C1F, 0x2C4F},   // 'Ⱏ' => 'ⱏ'
	7058: {0x2C20, 0x2C50},   // 'Ⱐ' => 'ⱐ'
	7055: {0x2C21, 0x2C51},   // 'Ⱑ' => 'ⱑ'
	7052: {0x2C22, 0x2C52},   // 'Ⱒ' => 'ⱒ'
	7049: {0x2C23, 0x2C53},   // 'Ⱓ' => 'ⱓ'
	7046: {0x2C24, 0x2C54},   // 'Ⱔ' => 'ⱔ'
	7043: {0x2C25, 0x2C55},   // 'Ⱕ' => 'ⱕ'
	7040: {0x2C26, 0x2C56},   // 'Ⱖ' => 'ⱖ'
	7037: {0x2C27, 0x2C57},   // 'Ⱗ' => 'ⱗ'
	7034: {0x2C28, 0x2C58},   // 'Ⱘ' => 'ⱘ'
	7031: {0x2C29, 0x2C59},   // 'Ⱙ' => 'ⱙ'
	7028: {0x2C2A, 0x2C5A},   // 'Ⱚ' => 'ⱚ'
	7025: {0x2C2B, 0x2C5B},   // 'Ⱛ' => 'ⱛ'
	7022: {0x2C2C, 0x2C5C},   // 'Ⱜ' => 'ⱜ'
	7019: {0x2C2D, 0x2C5D},   // 'Ⱝ' => 'ⱝ'
	7016: {0x2C2E, 0x2C5E},   // 'Ⱞ' => 'ⱞ'
	7013: {0x2C2F, 0x2C5F},   // 'Ⱟ' => 'ⱟ'
	7010: {0x2C00, 0x2C30},   // 'Ⰰ' => 'ⰰ'
	7007: {0x2C01, 0x2C31},   // 'Ⰱ' => 'ⰱ'
	7004: {0x2C02, 0x2C32},   // 'Ⰲ' => 'ⰲ'
	7001: {0x2C03, 0x2C33},   // 'Ⰳ' => 'ⰳ'
	6998: {0x2C04, 0x2C34},   // 'Ⰴ' => 'ⰴ'
	6995: {0x2C05, 0x2C35},   // 'Ⰵ' => 'ⰵ'
	6992: {0x2C06, 0x2C36},   // 'Ⰶ' => 'ⰶ'
	6989: {0x2C07, 0x2C37},   // 'Ⰷ' => 'ⰷ'
	6986: {0x2C08, 0x2C38},   // 'Ⰸ' => 'ⰸ'
	6983: {0x2C09, 0x2C39},   // 'Ⰹ' => 'ⰹ'
	6980: {0x2C0A, 0x2C3A},   // 'Ⰺ' => 'ⰺ'
	6977: {0x2C0B, 0x2C3B},   // 'Ⰻ' => 'ⰻ'
	6974: {0x2C0C, 0x2C3C},   // 'Ⰼ' => 'ⰼ'
	6971: {0x2C0D, 0x2C3D},   // 'Ⰽ' => 'ⰽ'
	6968: {0x2C0E, 0x2C3E},   // 'Ⰾ' => 'ⰾ'
	6965: {0x2C0F, 0x2C3F},   // 'Ⰿ' => 'ⰿ'
	6962: {0x2C10, 0x2C40},   // 'Ⱀ' => 'ⱀ'
	6959: {0x2C11, 0x2C41},   // 'Ⱁ' => 'ⱁ'
	6956: {0x2C12, 0x2C42},   // 'Ⱂ' => 'ⱂ'
	6953: {0x2C13, 0x2C43},   // 'Ⱃ' => 'ⱃ'
	6950: {0x2C14, 0x2C44},   // 'Ⱄ' => 'ⱄ'
	6947: {0x2C15, 0x2C45},   // 'Ⱅ' => 'ⱅ'
	6944: {0x2C16, 0x2C46},   // 'Ⱆ' => 'ⱆ'
	6941: {0x2C17, 0x2C47},   // 'Ⱇ' => 'ⱇ'
	6938: {0x2C18, 0x2C48},   // 'Ⱈ' => 'ⱈ'
	6935: {0x2C19, 0x2C49},   // 'Ⱉ' => 'ⱉ'
	6932: {0x2C1A, 0x2C4A},   // 'Ⱊ' => 'ⱊ'
	6929: {0x2C1B, 0x2C4B},   // 'Ⱋ' => 'ⱋ'
	6926: {0x2C1C, 0x2C4C},   // 'Ⱌ' => 'ⱌ'
	6923: {0x2C1D, 0x2C4D},   // 'Ⱍ' => 'ⱍ'
	6920: {0x2C1E, 0x2C4E},   // 'Ⱎ' => 'ⱎ'
	6917: {0x2C1F, 0x2C4F},   // 'Ⱏ' => 'ⱏ'
	6914: {0x2C20, 0x2C50},   // 'Ⱐ' => 'ⱐ'
	6911: {0x2C21, 0x2C51},   // 'Ⱑ' => 'ⱑ'
	6908: {0x2C22, 0x2C52},   // 'Ⱒ' => 'ⱒ'
	6905: {0x2C23, 0x2C53},   // 'Ⱓ' => 'ⱓ'
	6902: {0x2C24, 0x2C54},   // 'Ⱔ' => 'ⱔ'
	6899: {0x2C25, 0x2C55},   // 'Ⱕ' => 'ⱕ'
	6896: {0x2C26, 0x2C56},   // 'Ⱖ' => 'ⱖ'
	6893: {0x2C27, 0x2C57},   // 'Ⱗ' => 'ⱗ'
	6890: {0x2C28, 0x2C58},   // 'Ⱘ' => 'ⱘ'
	6887: {0x2C29, 0x2C59},   // 'Ⱙ' => 'ⱙ'
	6884: {0x2C2A, 0x2C5A},   // 'Ⱚ' => 'ⱚ'
	6881: {0x2C2B, 0x2C5B},   // 'Ⱛ' => 'ⱛ'
	6878: {0x2C2C, 0x2C5C},   // 'Ⱜ' => 'ⱜ'
	6875: {0x2C2D, 0x2C5D},   // 'Ⱝ' => 'ⱝ'
	6872: {0x2C2E, 0x2C5E},   // 'Ⱞ' => 'ⱞ'
	6869: {0x2C2F, 0x2C5F},   // 'Ⱟ' => 'ⱟ'
	6866: {0x2C60, 0x2C61},   // 'Ⱡ' => 'ⱡ'
	6863: {0x2C60, 0x2C61},   // 'Ⱡ' => 'ⱡ'
	6860: {0x2C62, 0x026B},   // 'Ɫ' => 'ɫ'
	6857: {0x2C63, 0x1D7D},   // 'Ᵽ' => 'ᵽ'
	6854: {0x2C64, 0x027D},   // 'Ɽ' => 'ɽ'
	6851: {0x023A, 0x2C65},   // 'Ⱥ' => 'ⱥ'
	6848: {0x023E, 0x2C66},   // 'Ⱦ' => 'ⱦ'
	6845: {0x2C67, 0x2C68},   // 'Ⱨ' => 'ⱨ'
	6842: {0x2C67, 0x2C68},   // 'Ⱨ' => 'ⱨ'
	6839: {0x2C69, 0x2C6A},   // 'Ⱪ' => 'ⱪ'
	6836: {0x2C69, 0x2C6A},   // 'Ⱪ' => 'ⱪ'
	6833: {0x2C6B, 0x2C6C},   // 'Ⱬ' => 'ⱬ'
	6830: {0x2C6B, 0x2C6C},   // 'Ⱬ' => 'ⱬ'
	6827: {0x2C6D, 0x0251},   // 'Ɑ' => 'ɑ'
	6824: {0x2C6E, 0x0271},   // 'Ɱ' => 'ɱ'
	6821: {0x2C6F, 0x0250},   // 'Ɐ' => 'ɐ'
	6818: {0x2C70, 0x0252},   // 'Ɒ' => 'ɒ'
	6812: {0x2C72, 0x2C73},   // 'Ⱳ' => 'ⱳ'
	6809: {0x2C72, 0x2C73},   // 'Ⱳ' => 'ⱳ'
	6803: {0x2C75, 0x2C76},   // 'Ⱶ' => 'ⱶ'
	6800: {0x2C75, 0x2C76},   // 'Ⱶ' => 'ⱶ'
	6776: {0x2C7E, 0x023F},   // 'Ȿ' => 'ȿ'
	6773: {0x2C7F, 0x0240},   // 'Ɀ' => 'ɀ'
	6770: {0x2C80, 0x2C81},   // 'Ⲁ' => 'ⲁ'
	6767: {0x2C80, 0x2C81},   // 'Ⲁ' => 'ⲁ'
	6764: {0x2C82, 0x2C83},   // 'Ⲃ' => 'ⲃ'
	6761: {0x2C82, 0x2C83},   // 'Ⲃ' => 'ⲃ'
	6758: {0x2C84, 0x2C85},   // 'Ⲅ' => 'ⲅ'
	6755: {0x2C84, 0x2C85},   // 'Ⲅ' => 'ⲅ'
	6752: {0x2C86, 0x2C87},   // 'Ⲇ' => 'ⲇ'
	6749: {0x2C86, 0x2C87},   // 'Ⲇ' => 'ⲇ'
	6746: {0x2C88, 0x2C89},   // 'Ⲉ' => 'ⲉ'
	6743: {0x2C88, 0x2C89},   // 'Ⲉ' => 'ⲉ'
	6740: {0x2C8A, 0x2C8B},   // 'Ⲋ' => 'ⲋ'
	6737: {0x2C8A, 0x2C8B},   // 'Ⲋ' => 'ⲋ'
	6734: {0x2C8C, 0x2C8D},   // 'Ⲍ' => 'ⲍ'
	6731: {0x2C8C, 0x2C8D},   // 'Ⲍ' => 'ⲍ'
	6728: {0x2C8E, 0x2C8F},   // 'Ⲏ' => 'ⲏ'
	6725: {0x2C8E, 0x2C8F},   // 'Ⲏ' => 'ⲏ'
	6722: {0x2C90, 0x2C91},   // 'Ⲑ' => 'ⲑ'
	6719: {0x2C90, 0x2C91},   // 'Ⲑ' => 'ⲑ'
	6716: {0x2C92, 0x2C93},   // 'Ⲓ' => 'ⲓ'
	6713: {0x2C92, 0x2C93},   // 'Ⲓ' => 'ⲓ'
	6710: {0x2C94, 0x2C95},   // 'Ⲕ' => 'ⲕ'
	6707: {0x2C94, 0x2C95},   // 'Ⲕ' => 'ⲕ'
	6704: {0x2C96, 0x2C97},   // 'Ⲗ' => 'ⲗ'
	6701: {0x2C96, 0x2C97},   // 'Ⲗ' => 'ⲗ'
	6698: {0x2C98, 0x2C99},   // 'Ⲙ' => 'ⲙ'
	6695: {0x2C98, 0x2C99},   // 'Ⲙ' => 'ⲙ'
	6692: {0x2C9A, 0x2C9B},   // 'Ⲛ' => 'ⲛ'
	6689: {0x2C9A, 0x2C9B},   // 'Ⲛ' => 'ⲛ'
	6686: {0x2C9C, 0x2C9D},   // 'Ⲝ' => 'ⲝ'
	6683: {0x2C9C, 0x2C9D},   // 'Ⲝ' => 'ⲝ'
	6680: {0x2C9E, 0x2C9F},   // 'Ⲟ' => 'ⲟ'
	6677: {0x2C9E, 0x2C9F},   // 'Ⲟ' => 'ⲟ'
	6674: {0x2CA0, 0x2CA1},   // 'Ⲡ' => 'ⲡ'
	6671: {0x2CA0, 0x2CA1},   // 'Ⲡ' => 'ⲡ'
	6668: {0x2CA2, 0x2CA3},   // 'Ⲣ' => 'ⲣ'
	6665: {0x2CA2, 0x2CA3},   // 'Ⲣ' => 'ⲣ'
	6662: {0x2CA4, 0x2CA5},   // 'Ⲥ' => 'ⲥ'
	6659: {0x2CA4, 0x2CA5},   // 'Ⲥ' => 'ⲥ'
	6656: {0x2CA6, 0x2CA7},   // 'Ⲧ' => 'ⲧ'
	6653: {0x2CA6, 0x2CA7},   // 'Ⲧ' => 'ⲧ'
	6650: {0x2CA8, 0x2CA9},   // 'Ⲩ' => 'ⲩ'
	6647: {0x2CA8, 0x2CA9},   // 'Ⲩ' => 'ⲩ'
	6644: {0x2CAA, 0x2CAB},   // 'Ⲫ' => 'ⲫ'
	6641: {0x2CAA, 0x2CAB},   // 'Ⲫ' => 'ⲫ'
	6638: {0x2CAC, 0x2CAD},   // 'Ⲭ' => 'ⲭ'
	6635: {0x2CAC, 0x2CAD},   // 'Ⲭ' => 'ⲭ'
	6632: {0x2CAE, 0x2CAF},   // 'Ⲯ' => 'ⲯ'
	6629: {0x2CAE, 0x2CAF},   // 'Ⲯ' => 'ⲯ'
	6626: {0x2CB0, 0x2CB1},   // 'Ⲱ' => 'ⲱ'
	6623: {0x2CB0, 0x2CB1},   // 'Ⲱ' => 'ⲱ'
	6620: {0x2CB2, 0x2CB3},   // 'Ⲳ' => 'ⲳ'
	6617: {0x2CB2, 0x2CB3},   // 'Ⲳ' => 'ⲳ'
	6614: {0x2CB4, 0x2CB5},   // 'Ⲵ' => 'ⲵ'
	6611: {0x2CB4, 0x2CB5},   // 'Ⲵ' => 'ⲵ'
	6608: {0x2CB6, 0x2CB7},   // 'Ⲷ' => 'ⲷ'
	6605: {0x2CB6, 0x2CB7},   // 'Ⲷ' => 'ⲷ'
	6602: {0x2CB8, 0x2CB9},   // 'Ⲹ' => 'ⲹ'
	6599: {0x2CB8, 0x2CB9},   // 'Ⲹ' => 'ⲹ'
	6596: {0x2CBA, 0x2CBB},   // 'Ⲻ' => 'ⲻ'
	6593: {0x2CBA, 0x2CBB},   // 'Ⲻ' => 'ⲻ'
	6590: {0x2CBC, 0x2CBD},   // 'Ⲽ' => 'ⲽ'
	6587: {0x2CBC, 0x2CBD},   // 'Ⲽ' => 'ⲽ'
	6584: {0x2CBE, 0x2CBF},   // 'Ⲿ' => 'ⲿ'
	6581: {0x2CBE, 0x2CBF},   // 'Ⲿ' => 'ⲿ'
	6578: {0x2CC0, 0x2CC1},   // 'Ⳁ' => 'ⳁ'
	6575: {0x2CC0, 0x2CC1},   // 'Ⳁ' => 'ⳁ'
	6572: {0x2CC2, 0x2CC3},   // 'Ⳃ' => 'ⳃ'
	6569: {0x2CC2, 0x2CC3},   // 'Ⳃ' => 'ⳃ'
	6566: {0x2CC4, 0x2CC5},   // 'Ⳅ' => 'ⳅ'
	6563: {0x2CC4, 0x2CC5},   // 'Ⳅ' => 'ⳅ'
	6560: {0x2CC6, 0x2CC7},   // 'Ⳇ' => 'ⳇ'
	6557: {0x2CC6, 0x2CC7},   // 'Ⳇ' => 'ⳇ'
	6554: {0x2CC8, 0x2CC9},   // 'Ⳉ' => 'ⳉ'
	6551: {0x2CC8, 0x2CC9},   // 'Ⳉ' => 'ⳉ'
	6548: {0x2CCA, 0x2CCB},   // 'Ⳋ' => 'ⳋ'
	6545: {0x2CCA, 0x2CCB},   // 'Ⳋ' => 'ⳋ'
	6542: {0x2CCC, 0x2CCD},   // 'Ⳍ' => 'ⳍ'
	6539: {0x2CCC, 0x2CCD},   // 'Ⳍ' => 'ⳍ'
	6536: {0x2CCE, 0x2CCF},   // 'Ⳏ' => 'ⳏ'
	6533: {0x2CCE, 0x2CCF},   // 'Ⳏ' => 'ⳏ'
	6530: {0x2CD0, 0x2CD1},   // 'Ⳑ' => 'ⳑ'
	6527: {0x2CD0, 0x2CD1},   // 'Ⳑ' => 'ⳑ'
	6524: {0x2CD2, 0x2CD3},   // 'Ⳓ' => 'ⳓ'
	6521: {0x2CD2, 0x2CD3},   // 'Ⳓ' => 'ⳓ'
	6518: {0x2CD4, 0x2CD5},   // 'Ⳕ' => 'ⳕ'
	6515: {0x2CD4, 0x2CD5},   // 'Ⳕ' => 'ⳕ'
	6512: {0x2CD6, 0x2CD7},   // 'Ⳗ' => 'ⳗ'
	6509: {0x2CD6, 0x2CD7},   // 'Ⳗ' => 'ⳗ'
	6506: {0x2CD8, 0x2CD9},   // 'Ⳙ' => 'ⳙ'
	6503: {0x2CD8, 0x2CD9},   // 'Ⳙ' => 'ⳙ'
	6500: {0x2CDA, 0x2CDB},   // 'Ⳛ' => 'ⳛ'
	6497: {0x2CDA, 0x2CDB},   // 'Ⳛ' => 'ⳛ'
	6494: {0x2CDC, 0x2CDD},   // 'Ⳝ' => 'ⳝ'
	6491: {0x2CDC, 0x2CDD},   // 'Ⳝ' => 'ⳝ'
	6488: {0x2CDE, 0x2CDF},   // 'Ⳟ' => 'ⳟ'
	6485: {0x2CDE, 0x2CDF},   // 'Ⳟ' => 'ⳟ'
	6482: {0x2CE0, 0x2CE1},   // 'Ⳡ' => 'ⳡ'
	6479: {0x2CE0, 0x2CE1},   // 'Ⳡ' => 'ⳡ'
	6476: {0x2CE2, 0x2CE3},   // 'Ⳣ' => 'ⳣ'
	6473: {0x2CE2, 0x2CE3},   // 'Ⳣ' => 'ⳣ'
	6449: {0x2CEB, 0x2CEC},   // 'Ⳬ' => 'ⳬ'
	6446: {0x2CEB, 0x2CEC},   // 'Ⳬ' => 'ⳬ'
	6443: {0x2CED, 0x2CEE},   // 'Ⳮ' => 'ⳮ'
	6440: {0x2CED, 0x2CEE},   // 'Ⳮ' => 'ⳮ'
	6428: {0x2CF2, 0x2CF3},   // 'Ⳳ' => 'ⳳ'
	6425: {0x2CF2, 0x2CF3},   // 'Ⳳ' => 'ⳳ'
	6386: {0x10A0, 0x2D00},   // 'Ⴀ' => 'ⴀ'
	6383: {0x10A1, 0x2D01},   // 'Ⴁ' => 'ⴁ'
	6380: {0x10A2, 0x2D02},   // 'Ⴂ' => 'ⴂ'
	6377: {0x10A3, 0x2D03},   // 'Ⴃ' => 'ⴃ'
	6374: {0x10A4, 0x2D04},   // 'Ⴄ' => 'ⴄ'
	6371: {0x10A5, 0x2D05},   // 'Ⴅ' => 'ⴅ'
	6368: {0x10A6, 0x2D06},   // 'Ⴆ' => 'ⴆ'
	6365: {0x10A7, 0x2D07},   // 'Ⴇ' => 'ⴇ'
	6362: {0x10A8, 0x2D08},   // 'Ⴈ' => 'ⴈ'
	6359: {0x10A9, 0x2D09},   // 'Ⴉ' => 'ⴉ'
	6356: {0x10AA, 0x2D0A},   // 'Ⴊ' => 'ⴊ'
	6353: {0x10AB, 0x2D0B},   // 'Ⴋ' => 'ⴋ'
	6350: {0x10AC, 0x2D0C},   // 'Ⴌ' => 'ⴌ'
	6347: {0x10AD, 0x2D0D},   // 'Ⴍ' => 'ⴍ'
	6344: {0x10AE, 0x2D0E},   // 'Ⴎ' => 'ⴎ'
	6341: {0x10AF, 0x2D0F},   // 'Ⴏ' => 'ⴏ'
	6338: {0x10B0, 0x2D10},   // 'Ⴐ' => 'ⴐ'
	6335: {0x10B1, 0x2D11},   // 'Ⴑ' => 'ⴑ'
	6332: {0x10B2, 0x2D12},   // 'Ⴒ' => 'ⴒ'
	6329: {0x10B3, 0x2D13},   // 'Ⴓ' => 'ⴓ'
	6326: {0x10B4, 0x2D14},   // 'Ⴔ' => 'ⴔ'
	6323: {0x10B5, 0x2D15},   // 'Ⴕ' => 'ⴕ'
	6320: {0x10B6, 0x2D16},   // 'Ⴖ' => 'ⴖ'
	6317: {0x10B7, 0x2D17},   // 'Ⴗ' => 'ⴗ'
	6314: {0x10B8, 0x2D18},   // 'Ⴘ' => 'ⴘ'
	6311: {0x10B9, 0x2D19},   // 'Ⴙ' => 'ⴙ'
	6308: {0x10BA, 0x2D1A},   // 'Ⴚ' => 'ⴚ'
	6305: {0x10BB, 0x2D1B},   // 'Ⴛ' => 'ⴛ'
	6302: {0x10BC, 0x2D1C},   // 'Ⴜ' => 'ⴜ'
	6299: {0x10BD, 0x2D1D},   // 'Ⴝ' => 'ⴝ'
	6296: {0x10BE, 0x2D1E},   // 'Ⴞ' => 'ⴞ'
	6293: {0x10BF, 0x2D1F},   // 'Ⴟ' => 'ⴟ'
	6290: {0x10C0, 0x2D20},   // 'Ⴠ' => 'ⴠ'
	6287: {0x10C1, 0x2D21},   // 'Ⴡ' => 'ⴡ'
	6284: {0x10C2, 0x2D22},   // 'Ⴢ' => 'ⴢ'
	6281: {0x10C3, 0x2D23},   // 'Ⴣ' => 'ⴣ'
	6278: {0x10C4, 0x2D24},   // 'Ⴤ' => 'ⴤ'
	6275: {0x10C5, 0x2D25},   // 'Ⴥ' => 'ⴥ'
	6269: {0x10C7, 0x2D27},   // 'Ⴧ' => 'ⴧ'
	6251: {0x10CD, 0x2D2D},   // 'Ⴭ' => 'ⴭ'
	3341: {0xA640, 0xA641},   // 'Ꙁ' => 'ꙁ'
	3338: {0xA640, 0xA641},   // 'Ꙁ' => 'ꙁ'
	3335: {0xA642, 0xA643},   // 'Ꙃ' => 'ꙃ'
	3332: {0xA642, 0xA643},   // 'Ꙃ' => 'ꙃ'
	3329: {0xA644, 0xA645},   // 'Ꙅ' => 'ꙅ'
	3326: {0xA644, 0xA645},   // 'Ꙅ' => 'ꙅ'
	3323: {0xA646, 0xA647},   // 'Ꙇ' => 'ꙇ'
	3320: {0xA646, 0xA647},   // 'Ꙇ' => 'ꙇ'
	3317: {0xA648, 0xA649},   // 'Ꙉ' => 'ꙉ'
	3314: {0xA648, 0xA649},   // 'Ꙉ' => 'ꙉ'
	3311: {0xA64A, 0xA64B},   // 'Ꙋ' => 'ꙋ'
	3308: {0xA64A, 0xA64B},   // 'Ꙋ' => 'ꙋ'
	3305: {0xA64C, 0xA64D},   // 'Ꙍ' => 'ꙍ'
	3302: {0xA64C, 0xA64D},   // 'Ꙍ' => 'ꙍ'
	3299: {0xA64E, 0xA64F},   // 'Ꙏ' => 'ꙏ'
	3296: {0xA64E, 0xA64F},   // 'Ꙏ' => 'ꙏ'
	3293: {0xA650, 0xA651},   // 'Ꙑ' => 'ꙑ'
	3290: {0xA650, 0xA651},   // 'Ꙑ' => 'ꙑ'
	3287: {0xA652, 0xA653},   // 'Ꙓ' => 'ꙓ'
	3284: {0xA652, 0xA653},   // 'Ꙓ' => 'ꙓ'
	3281: {0xA654, 0xA655},   // 'Ꙕ' => 'ꙕ'
	3278: {0xA654, 0xA655},   // 'Ꙕ' => 'ꙕ'
	3275: {0xA656, 0xA657},   // 'Ꙗ' => 'ꙗ'
	3272: {0xA656, 0xA657},   // 'Ꙗ' => 'ꙗ'
	3269: {0xA658, 0xA659},   // 'Ꙙ' => 'ꙙ'
	3266: {0xA658, 0xA659},   // 'Ꙙ' => 'ꙙ'
	3263: {0xA65A, 0xA65B},   // 'Ꙛ' => 'ꙛ'
	3260: {0xA65A, 0xA65B},   // 'Ꙛ' => 'ꙛ'
	3257: {0xA65C, 0xA65D},   // 'Ꙝ' => 'ꙝ'
	3254: {0xA65C, 0xA65D},   // 'Ꙝ' => 'ꙝ'
	3251: {0xA65E, 0xA65F},   // 'Ꙟ' => 'ꙟ'
	3248: {0xA65E, 0xA65F},   // 'Ꙟ' => 'ꙟ'
	3245: {0xA660, 0xA661},   // 'Ꙡ' => 'ꙡ'
	3242: {0xA660, 0xA661},   // 'Ꙡ' => 'ꙡ'
	3239: {0xA662, 0xA663},   // 'Ꙣ' => 'ꙣ'
	3236: {0xA662, 0xA663},   // 'Ꙣ' => 'ꙣ'
	3233: {0xA664, 0xA665},   // 'Ꙥ' => 'ꙥ'
	3230: {0xA664, 0xA665},   // 'Ꙥ' => 'ꙥ'
	3227: {0xA666, 0xA667},   // 'Ꙧ' => 'ꙧ'
	3224: {0xA666, 0xA667},   // 'Ꙧ' => 'ꙧ'
	3221: {0xA668, 0xA669},   // 'Ꙩ' => 'ꙩ'
	3218: {0xA668, 0xA669},   // 'Ꙩ' => 'ꙩ'
	3215: {0xA66A, 0xA66B},   // 'Ꙫ' => 'ꙫ'
	3212: {0xA66A, 0xA66B},   // 'Ꙫ' => 'ꙫ'
	3209: {0xA66C, 0xA66D},   // 'Ꙭ' => 'ꙭ'
	3206: {0xA66C, 0xA66D},   // 'Ꙭ' => 'ꙭ'
	3149: {0xA680, 0xA681},   // 'Ꚁ' => 'ꚁ'
	3146: {0xA680, 0xA681},   // 'Ꚁ' => 'ꚁ'
	3143: {0xA682, 0xA683},   // 'Ꚃ' => 'ꚃ'
	3140: {0xA682, 0xA683},   // 'Ꚃ' => 'ꚃ'
	3137: {0xA684, 0xA685},   // 'Ꚅ' => 'ꚅ'
	3134: {0xA684, 0xA685},   // 'Ꚅ' => 'ꚅ'
	3131: {0xA686, 0xA687},   // 'Ꚇ' => 'ꚇ'
	3128: {0xA686, 0xA687},   // 'Ꚇ' => 'ꚇ'
	3125: {0xA688, 0xA689},   // 'Ꚉ' => 'ꚉ'
	3122: {0xA688, 0xA689},   // 'Ꚉ' => 'ꚉ'
	3119: {0xA68A, 0xA68B},   // 'Ꚋ' => 'ꚋ'
	3116: {0xA68A, 0xA68B},   // 'Ꚋ' => 'ꚋ'
	3113: {0xA68C, 0xA68D},   // 'Ꚍ' => 'ꚍ'
	3110: {0xA68C, 0xA68D},   // 'Ꚍ' => 'ꚍ'
	3107: {0xA68E, 0xA68F},   // 'Ꚏ' => 'ꚏ'
	3104: {0xA68E, 0xA68F},   // 'Ꚏ' => 'ꚏ'
	3101: {0xA690, 0xA691},   // 'Ꚑ' => 'ꚑ'
	3098: {0xA690, 0xA691},   // 'Ꚑ' => 'ꚑ'
	3095: {0xA692, 0xA693},   // 'Ꚓ' => 'ꚓ'
	3092: {0xA692, 0xA693},   // 'Ꚓ' => 'ꚓ'
	3089: {0xA694, 0xA695},   // 'Ꚕ' => 'ꚕ'
	3086: {0xA694, 0xA695},   // 'Ꚕ' => 'ꚕ'
	3083: {0xA696, 0xA697},   // 'Ꚗ' => 'ꚗ'
	3080: {0xA696, 0xA697},   // 'Ꚗ' => 'ꚗ'
	3077: {0xA698, 0xA699},   // 'Ꚙ' => 'ꚙ'
	3074: {0xA698, 0xA699},   // 'Ꚙ' => 'ꚙ'
	3071: {0xA69A, 0xA69B},   // 'Ꚛ' => 'ꚛ'
	3068: {0xA69A, 0xA69B},   // 'Ꚛ' => 'ꚛ'
	2663: {0xA722, 0xA723},   // 'Ꜣ' => 'ꜣ'
	2660: {0xA722, 0xA723},   // 'Ꜣ' => 'ꜣ'
	2657: {0xA724, 0xA725},   // 'Ꜥ' => 'ꜥ'
	2654: {0xA724, 0xA725},   // 'Ꜥ' => 'ꜥ'
	2651: {0xA726, 0xA727},   // 'Ꜧ' => 'ꜧ'
	2648: {0xA726, 0xA727},   // 'Ꜧ' => 'ꜧ'
	2645: {0xA728, 0xA729},   // 'Ꜩ' => 'ꜩ'
	2642: {0xA728, 0xA729},   // 'Ꜩ' => 'ꜩ'
	2639: {0xA72A, 0xA72B},   // 'Ꜫ' => 'ꜫ'
	2636: {0xA72A, 0xA72B},   // 'Ꜫ' => 'ꜫ'
	2633: {0xA72C, 0xA72D},   // 'Ꜭ' => 'ꜭ'
	2630: {0xA72C, 0xA72D},   // 'Ꜭ' => 'ꜭ'
	2627: {0xA72E, 0xA72F},   // 'Ꜯ' => 'ꜯ'
	2624: {0xA72E, 0xA72F},   // 'Ꜯ' => 'ꜯ'
	2615: {0xA732, 0xA733},   // 'Ꜳ' => 'ꜳ'
	2612: {0xA732, 0xA733},   // 'Ꜳ' => 'ꜳ'
	2609: {0xA734, 0xA735},   // 'Ꜵ' => 'ꜵ'
	2606: {0xA734, 0xA735},   // 'Ꜵ' => 'ꜵ'
	2603: {0xA736, 0xA737},   // 'Ꜷ' => 'ꜷ'
	2600: {0xA736, 0xA737},   // 'Ꜷ' => 'ꜷ'
	2597: {0xA738, 0xA739},   // 'Ꜹ' => 'ꜹ'
	2594: {0xA738, 0xA739},   // 'Ꜹ' => 'ꜹ'
	2591: {0xA73A, 0xA73B},   // 'Ꜻ' => 'ꜻ'
	2588: {0xA73A, 0xA73B},   // 'Ꜻ' => 'ꜻ'
	2585: {0xA73C, 0xA73D},   // 'Ꜽ' => 'ꜽ'
	2582: {0xA73C, 0xA73D},   // 'Ꜽ' => 'ꜽ'
	2579: {0xA73E, 0xA73F},   // 'Ꜿ' => 'ꜿ'
	2576: {0xA73E, 0xA73F},   // 'Ꜿ' => 'ꜿ'
	2573: {0xA740, 0xA741},   // 'Ꝁ' => 'ꝁ'
	2570: {0xA740, 0xA741},   // 'Ꝁ' => 'ꝁ'
	2567: {0xA742, 0xA743},   // 'Ꝃ' => 'ꝃ'
	2564: {0xA742, 0xA743},   // 'Ꝃ' => 'ꝃ'
	2561: {0xA744, 0xA745},   // 'Ꝅ' => 'ꝅ'
	2558: {0xA744, 0xA745},   // 'Ꝅ' => 'ꝅ'
	2555: {0xA746, 0xA747},   // 'Ꝇ' => 'ꝇ'
	2552: {0xA746, 0xA747},   // 'Ꝇ' => 'ꝇ'
	2549: {0xA748, 0xA749},   // 'Ꝉ' => 'ꝉ'
	2546: {0xA748, 0xA749},   // 'Ꝉ' => 'ꝉ'
	2543: {0xA74A, 0xA74B},   // 'Ꝋ' => 'ꝋ'
	2540: {0xA74A, 0xA74B},   // 'Ꝋ' => 'ꝋ'
	2537: {0xA74C, 0xA74D},   // 'Ꝍ' => 'ꝍ'
	2534: {0xA74C, 0xA74D},   // 'Ꝍ' => 'ꝍ'
	2531: {0xA74E, 0xA74F},   // 'Ꝏ' => 'ꝏ'
	2528: {0xA74E, 0xA74F},   // 'Ꝏ' => 'ꝏ'
	2525: {0xA750, 0xA751},   // 'Ꝑ' => 'ꝑ'
	2522: {0xA750, 0xA751},   // 'Ꝑ' => 'ꝑ'
	2519: {0xA752, 0xA753},   // 'Ꝓ' => 'ꝓ'
	2516: {0xA752, 0xA753},   // 'Ꝓ' => 'ꝓ'
	2513: {0xA754, 0xA755},   // 'Ꝕ' => 'ꝕ'
	2510: {0xA754, 0xA755},   // 'Ꝕ' => 'ꝕ'
	2507: {0xA756, 0xA757},   // 'Ꝗ' => 'ꝗ'
	2504: {0xA756, 0xA757},   // 'Ꝗ' => 'ꝗ'
	2501: {0xA758, 0xA759},   // 'Ꝙ' => 'ꝙ'
	2498: {0xA758, 0xA759},   // 'Ꝙ' => 'ꝙ'
	2495: {0xA75A, 0xA75B},   // 'Ꝛ' => 'ꝛ'
	2492: {0xA75A, 0xA75B},   // 'Ꝛ' => 'ꝛ'
	2489: {0xA75C, 0xA75D},   // 'Ꝝ' => 'ꝝ'
	2486: {0xA75C, 0xA75D},   // 'Ꝝ' => 'ꝝ'
	2483: {0xA75E, 0xA75F},   // 'Ꝟ' => 'ꝟ'
	2480: {0xA75E, 0xA75F},   // 'Ꝟ' => 'ꝟ'
	2477: {0xA760, 0xA761},   // 'Ꝡ' => 'ꝡ'
	2474: {0xA760, 0xA761},   // 'Ꝡ' => 'ꝡ'
	2471: {0xA762, 0xA763},   // 'Ꝣ' => 'ꝣ'
	2468: {0xA762, 0xA763},   // 'Ꝣ' => 'ꝣ'
	2465: {0xA764, 0xA765},   // 'Ꝥ' => 'ꝥ'
	2462: {0xA764, 0xA765},   // 'Ꝥ' => 'ꝥ'
	2459: {0xA766, 0xA767},   // 'Ꝧ' => 'ꝧ'
	2456: {0xA766, 0xA767},   // 'Ꝧ' => 'ꝧ'
	2453: {0xA768, 0xA769},   // 'Ꝩ' => 'ꝩ'
	2450: {0xA768, 0xA769},   // 'Ꝩ' => 'ꝩ'
	2447: {0xA76A, 0xA76B},   // 'Ꝫ' => 'ꝫ'
	2444: {0xA76A, 0xA76B},   // 'Ꝫ' => 'ꝫ'
	2441: {0xA76C, 0xA76D},   // 'Ꝭ' => 'ꝭ'
	2438: {0xA76C, 0xA76D},   // 'Ꝭ' => 'ꝭ'
	2435: {0xA76E, 0xA76F},   // 'Ꝯ' => 'ꝯ'
	2432: {0xA76E, 0xA76F},   // 'Ꝯ' => 'ꝯ'
	2402: {0xA779, 0xA77A},   // 'Ꝺ' => 'ꝺ'
	2399: {0xA779, 0xA77A},   // 'Ꝺ' => 'ꝺ'
	2396: {0xA77B, 0xA77C},   // 'Ꝼ' => 'ꝼ'
	2393: {0xA77B, 0xA77C},   // 'Ꝼ' => 'ꝼ'
	2390: {0xA77D, 0x1D79},   // 'Ᵹ' => 'ᵹ'
	2387: {0xA77E, 0xA77F},   // 'Ꝿ' => 'ꝿ'
	2384: {0xA77E, 0xA77F},   // 'Ꝿ' => 'ꝿ'
	2381: {0xA780, 0xA781},   // 'Ꞁ' => 'ꞁ'
	2378: {0xA780, 0xA781},   // 'Ꞁ' => 'ꞁ'
	2375: {0xA782, 0xA783},   // 'Ꞃ' => 'ꞃ'
	2372: {0xA782, 0xA783},   // 'Ꞃ' => 'ꞃ'
	2369: {0xA784, 0xA785},   // 'Ꞅ' => 'ꞅ'
	2366: {0xA784, 0xA785},   // 'Ꞅ' => 'ꞅ'
	2363: {0xA786, 0xA787},   // 'Ꞇ' => 'ꞇ'
	2360: {0xA786, 0xA787},   // 'Ꞇ' => 'ꞇ'
	2348: {0xA78B, 0xA78C},   // 'Ꞌ' => 'ꞌ'
	2345: {0xA78B, 0xA78C},   // 'Ꞌ' => 'ꞌ'
	2342: {0xA78D, 0x0265},   // 'Ɥ' => 'ɥ'
	2333: {0xA790, 0xA791},   // 'Ꞑ' => 'ꞑ'
	2330: {0xA790, 0xA791},   // 'Ꞑ' => 'ꞑ'
	2327: {0xA792, 0xA793},   // 'Ꞓ' => 'ꞓ'
	2324: {0xA792, 0xA793},   // 'Ꞓ' => 'ꞓ'
	2321: {0xA7C4, 0xA794},   // 'Ꞔ' => 'ꞔ'
	2315: {0xA796, 0xA797},   // 'Ꞗ' => 'ꞗ'
	2312: {0xA796, 0xA797},   // 'Ꞗ' => 'ꞗ'
	2309: {0xA798, 0xA799},   // 'Ꞙ' => 'ꞙ'
	2306: {0xA798, 0xA799},   // 'Ꞙ' => 'ꞙ'
	2303: {0xA79A, 0xA79B},   // 'Ꞛ' => 'ꞛ'
	2300: {0xA79A, 0xA79B},   // 'Ꞛ' => 'ꞛ'
	2297: {0xA79C, 0xA79D},   // 'Ꞝ' => 'ꞝ'
	2294: {0xA79C, 0xA79D},   // 'Ꞝ' => 'ꞝ'
	2291: {0xA79E, 0xA79F},   // 'Ꞟ' => 'ꞟ'
	2288: {0xA79E, 0xA79F},   // 'Ꞟ' => 'ꞟ'
	2285: {0xA7A0, 0xA7A1},   // 'Ꞡ' => 'ꞡ'
	2282: {0xA7A0, 0xA7A1},   // 'Ꞡ' => 'ꞡ'
	2279: {0xA7A2, 0xA7A3},   // 'Ꞣ' => 'ꞣ'
	2276: {0xA7A2, 0xA7A3},   // 'Ꞣ' => 'ꞣ'
	2273: {0xA7A4, 0xA7A5},   // 'Ꞥ' => 'ꞥ'
	2270: {0xA7A4, 0xA7A5},   // 'Ꞥ' => 'ꞥ'
	2267: {0xA7A6, 0xA7A7},   // 'Ꞧ' => 'ꞧ'
	2264: {0xA7A6, 0xA7A7},   // 'Ꞧ' => 'ꞧ'
	2261: {0xA7A8, 0xA7A9},   // 'Ꞩ' => 'ꞩ'
	2258: {0xA7A8, 0xA7A9},   // 'Ꞩ' => 'ꞩ'
	2255: {0xA7AA, 0x0266},   // 'Ɦ' => 'ɦ'
	2252: {0xA7AB, 0x025C},   // 'Ɜ' => 'ɜ'
	2249: {0xA7AC, 0x0261},   // 'Ɡ' => 'ɡ'
	2246: {0xA7AD, 0x026C},   // 'Ɬ' => 'ɬ'
	2243: {0xA7AE, 0x026A},   // 'Ɪ' => 'ɪ'
	2237: {0xA7B0, 0x029E},   // 'Ʞ' => 'ʞ'
	2234: {0xA7B1, 0x0287},   // 'Ʇ' => 'ʇ'
	2231: {0xA7B2, 0x029D},   // 'Ʝ' => 'ʝ'
	2228: {0xA7B3, 0xAB53},   // 'Ꭓ' => 'ꭓ'
	2225: {0xA7B4, 0xA7B5},   // 'Ꞵ' => 'ꞵ'
	2222: {0xA7B4, 0xA7B5},   // 'Ꞵ' => 'ꞵ'
	2219: {0xA7B6, 0xA7B7},   // 'Ꞷ' => 'ꞷ'
	2216: {0xA7B6, 0xA7B7},   // 'Ꞷ' => 'ꞷ'
	2213: {0xA7B8, 0xA7B9},   // 'Ꞹ' => 'ꞹ'
	2210: {0xA7B8, 0xA7B9},   // 'Ꞹ' => 'ꞹ'
	2207: {0xA7BA, 0xA7BB},   // 'Ꞻ' => 'ꞻ'
	2204: {0xA7BA, 0xA7BB},   // 'Ꞻ' => 'ꞻ'
	2201: {0xA7BC, 0xA7BD},   // 'Ꞽ' => 'ꞽ'
	2198: {0xA7BC, 0xA7BD},   // 'Ꞽ' => 'ꞽ'
	2195: {0xA7BE, 0xA7BF},   // 'Ꞿ' => 'ꞿ'
	2192: {0xA7BE, 0xA7BF},   // 'Ꞿ' => 'ꞿ'
	2189: {0xA7C0, 0xA7C1},   // 'Ꟁ' => 'ꟁ'
	2186: {0xA7C0, 0xA7C1},   // 'Ꟁ' => 'ꟁ'
	2183: {0xA7C2, 0xA7C3},   // 'Ꟃ' => 'ꟃ'
	2180: {0xA7C2, 0xA7C3},   // 'Ꟃ' => 'ꟃ'
	2177: {0xA7C4, 0xA794},   // 'Ꞔ' => 'ꞔ'
	2174: {0xA7C5, 0x0282},   // 'Ʂ' => 'ʂ'
	2171: {0xA7C6, 0x1D8E},   // 'Ᶎ' => 'ᶎ'
	2168: {0xA7C7, 0xA7C8},   // 'Ꟈ' => 'ꟈ'
	2165: {0xA7C7, 0xA7C8},   // 'Ꟈ' => 'ꟈ'
	2162: {0xA7C9, 0xA7CA},   // 'Ꟊ' => 'ꟊ'
	2159: {0xA7C9, 0xA7CA},   // 'Ꟊ' => 'ꟊ'
	2141: {0xA7D0, 0xA7D1},   // 'Ꟑ' => 'ꟑ'
	2138: {0xA7D0, 0xA7D1},   // 'Ꟑ' => 'ꟑ'
	2123: {0xA7D6, 0xA7D7},   // 'Ꟗ' => 'ꟗ'
	2120: {0xA7D6, 0xA7D7},   // 'Ꟗ' => 'ꟗ'
	2117: {0xA7D8, 0xA7D9},   // 'Ꟙ' => 'ꟙ'
	2114: {0xA7D8, 0xA7D9},   // 'Ꟙ' => 'ꟙ'
	2030: {0xA7F5, 0xA7F6},   // 'Ꟶ' => 'ꟶ'
	2027: {0xA7F5, 0xA7F6},   // 'Ꟶ' => 'ꟶ'
	7635: {0xA7B3, 0xAB53},   // 'Ꭓ' => 'ꭓ'
	7548: {0x13A0, 0xAB70},   // 'Ꭰ' => 'ꭰ'
	7545: {0x13A1, 0xAB71},   // 'Ꭱ' => 'ꭱ'
	7542: {0x13A2, 0xAB72},   // 'Ꭲ' => 'ꭲ'
	7539: {0x13A3, 0xAB73},   // 'Ꭳ' => 'ꭳ'
	7536: {0x13A4, 0xAB74},   // 'Ꭴ' => 'ꭴ'
	7533: {0x13A5, 0xAB75},   // 'Ꭵ' => 'ꭵ'
	7530: {0x13A6, 0xAB76},   // 'Ꭶ' => 'ꭶ'
	7527: {0x13A7, 0xAB77},   // 'Ꭷ' => 'ꭷ'
	7524: {0x13A8, 0xAB78},   // 'Ꭸ' => 'ꭸ'
	7521: {0x13A9, 0xAB79},   // 'Ꭹ' => 'ꭹ'
	7518: {0x13AA, 0xAB7A},   // 'Ꭺ' => 'ꭺ'
	7515: {0x13AB, 0xAB7B},   // 'Ꭻ' => 'ꭻ'
	7512: {0x13AC, 0xAB7C},   // 'Ꭼ' => 'ꭼ'
	7509: {0x13AD, 0xAB7D},   // 'Ꭽ' => 'ꭽ'
	7506: {0x13AE, 0xAB7E},   // 'Ꭾ' => 'ꭾ'
	7503: {0x13AF, 0xAB7F},   // 'Ꭿ' => 'ꭿ'
	7500: {0x13B0, 0xAB80},   // 'Ꮀ' => 'ꮀ'
	7497: {0x13B1, 0xAB81},   // 'Ꮁ' => 'ꮁ'
	7494: {0x13B2, 0xAB82},   // 'Ꮂ' => 'ꮂ'
	7491: {0x13B3, 0xAB83},   // 'Ꮃ' => 'ꮃ'
	7488: {0x13B4, 0xAB84},   // 'Ꮄ' => 'ꮄ'
	7485: {0x13B5, 0xAB85},   // 'Ꮅ' => 'ꮅ'
	7482: {0x13B6, 0xAB86},   // 'Ꮆ' => 'ꮆ'
	7479: {0x13B7, 0xAB87},   // 'Ꮇ' => 'ꮇ'
	7476: {0x13B8, 0xAB88},   // 'Ꮈ' => 'ꮈ'
	7473: {0x13B9, 0xAB89},   // 'Ꮉ' => 'ꮉ'
	7470: {0x13BA, 0xAB8A},   // 'Ꮊ' => 'ꮊ'
	7467: {0x13BB, 0xAB8B},   // 'Ꮋ' => 'ꮋ'
	7464: {0x13BC, 0xAB8C},   // 'Ꮌ' => 'ꮌ'
	7461: {0x13BD, 0xAB8D},   // 'Ꮍ' => 'ꮍ'
	7458: {0x13BE, 0xAB8E},   // 'Ꮎ' => 'ꮎ'
	7455: {0x13BF, 0xAB8F},   // 'Ꮏ' => 'ꮏ'
	7452: {0x13C0, 0xAB90},   // 'Ꮐ' => 'ꮐ'
	7449: {0x13C1, 0xAB91},   // 'Ꮑ' => 'ꮑ'
	7446: {0x13C2, 0xAB92},   // 'Ꮒ' => 'ꮒ'
	7443: {0x13C3, 0xAB93},   // 'Ꮓ' => 'ꮓ'
	7440: {0x13C4, 0xAB94},   // 'Ꮔ' => 'ꮔ'
	7437: {0x13C5, 0xAB95},   // 'Ꮕ' => 'ꮕ'
	7434: {0x13C6, 0xAB96},   // 'Ꮖ' => 'ꮖ'
	7431: {0x13C7, 0xAB97},   // 'Ꮗ' => 'ꮗ'
	7428: {0x13C8, 0xAB98},   // 'Ꮘ' => 'ꮘ'
	7425: {0x13C9, 0xAB99},   // 'Ꮙ' => 'ꮙ'
	7422: {0x13CA, 0xAB9A},   // 'Ꮚ' => 'ꮚ'
	7419: {0x13CB, 0xAB9B},   // 'Ꮛ' => 'ꮛ'
	7416: {0x13CC, 0xAB9C},   // 'Ꮜ' => 'ꮜ'
	7413: {0x13CD, 0xAB9D},   // 'Ꮝ' => 'ꮝ'
	7410: {0x13CE, 0xAB9E},   // 'Ꮞ' => 'ꮞ'
	7407: {0x13CF, 0xAB9F},   // 'Ꮟ' => 'ꮟ'
	7404: {0x13D0, 0xABA0},   // 'Ꮠ' => 'ꮠ'
	7401: {0x13D1, 0xABA1},   // 'Ꮡ' => 'ꮡ'
	7398: {0x13D2, 0xABA2},   // 'Ꮢ' => 'ꮢ'
	7395: {0x13D3, 0xABA3},   // 'Ꮣ' => 'ꮣ'
	7392: {0x13D4, 0xABA4},   // 'Ꮤ' => 'ꮤ'
	7389: {0x13D5, 0xABA5},   // 'Ꮥ' => 'ꮥ'
	7386: {0x13D6, 0xABA6},   // 'Ꮦ' => 'ꮦ'
	7383: {0x13D7, 0xABA7},   // 'Ꮧ' => 'ꮧ'
	7380: {0x13D8, 0xABA8},   // 'Ꮨ' => 'ꮨ'
	7377: {0x13D9, 0xABA9},   // 'Ꮩ' => 'ꮩ'
	7374: {0x13DA, 0xABAA},   // 'Ꮪ' => 'ꮪ'
	7371: {0x13DB, 0xABAB},   // 'Ꮫ' => 'ꮫ'
	7368: {0x13DC, 0xABAC},   // 'Ꮬ' => 'ꮬ'
	7365: {0x13DD, 0xABAD},   // 'Ꮭ' => 'ꮭ'
	7362: {0x13DE, 0xABAE},   // 'Ꮮ' => 'ꮮ'
	7359: {0x13DF, 0xABAF},   // 'Ꮯ' => 'ꮯ'
	7356: {0x13E0, 0xABB0},   // 'Ꮰ' => 'ꮰ'
	7353: {0x13E1, 0xABB1},   // 'Ꮱ' => 'ꮱ'
	7350: {0x13E2, 0xABB2},   // 'Ꮲ' => 'ꮲ'
	7347: {0x13E3, 0xABB3},   // 'Ꮳ' => 'ꮳ'
	7344: {0x13E4, 0xABB4},   // 'Ꮴ' => 'ꮴ'
	7341: {0x13E5, 0xABB5},   // 'Ꮵ' => 'ꮵ'
	7338: {0x13E6, 0xABB6},   // 'Ꮶ' => 'ꮶ'
	7335: {0x13E7, 0xABB7},   // 'Ꮷ' => 'ꮷ'
	7332: {0x13E8, 0xABB8},   // 'Ꮸ' => 'ꮸ'
	7329: {0x13E9, 0xABB9},   // 'Ꮹ' => 'ꮹ'
	7326: {0x13EA, 0xABBA},   // 'Ꮺ' => 'ꮺ'
	7323: {0x13EB, 0xABBB},   // 'Ꮻ' => 'ꮻ'
	7320: {0x13EC, 0xABBC},   // 'Ꮼ' => 'ꮼ'
	7317: {0x13ED, 0xABBD},   // 'Ꮽ' => 'ꮽ'
	7314: {0x13EE, 0xABBE},   // 'Ꮾ' => 'ꮾ'
	7311: {0x13EF, 0xABBF},   // 'Ꮿ' => 'ꮿ'
	591:  {0xFF21, 0xFF41},   // 'Ａ' => 'ａ'
	588:  {0xFF22, 0xFF42},   // 'Ｂ' => 'ｂ'
	585:  {0xFF23, 0xFF43},   // 'Ｃ' => 'ｃ'
	582:  {0xFF24, 0xFF44},   // 'Ｄ' => 'ｄ'
	579:  {0xFF25, 0xFF45},   // 'Ｅ' => 'ｅ'
	576:  {0xFF26, 0xFF46},   // 'Ｆ' => 'ｆ'
	573:  {0xFF27, 0xFF47},   // 'Ｇ' => 'ｇ'
	570:  {0xFF28, 0xFF48},   // 'Ｈ' => 'ｈ'
	567:  {0xFF29, 0xFF49},   // 'Ｉ' => 'ｉ'
	564:  {0xFF2A, 0xFF4A},   // 'Ｊ' => 'ｊ'
	561:  {0xFF2B, 0xFF4B},   // 'Ｋ' => 'ｋ'
	558:  {0xFF2C, 0xFF4C},   // 'Ｌ' => 'ｌ'
	555:  {0xFF2D, 0xFF4D},   // 'Ｍ' => 'ｍ'
	552:  {0xFF2E, 0xFF4E},   // 'Ｎ' => 'ｎ'
	549:  {0xFF2F, 0xFF4F},   // 'Ｏ' => 'ｏ'
	546:  {0xFF30, 0xFF50},   // 'Ｐ' => 'ｐ'
	543:  {0xFF31, 0xFF51},   // 'Ｑ' => 'ｑ'
	540:  {0xFF32, 0xFF52},   // 'Ｒ' => 'ｒ'
	537:  {0xFF33, 0xFF53},   // 'Ｓ' => 'ｓ'
	534:  {0xFF34, 0xFF54},   // 'Ｔ' => 'ｔ'
	531:  {0xFF35, 0xFF55},   // 'Ｕ' => 'ｕ'
	528:  {0xFF36, 0xFF56},   // 'Ｖ' => 'ｖ'
	525:  {0xFF37, 0xFF57},   // 'Ｗ' => 'ｗ'
	522:  {0xFF38, 0xFF58},   // 'Ｘ' => 'ｘ'
	519:  {0xFF39, 0xFF59},   // 'Ｙ' => 'ｙ'
	516:  {0xFF3A, 0xFF5A},   // 'Ｚ' => 'ｚ'
	495:  {0xFF21, 0xFF41},   // 'Ａ' => 'ａ'
	492:  {0xFF22, 0xFF42},   // 'Ｂ' => 'ｂ'
	489:  {0xFF23, 0xFF43},   // 'Ｃ' => 'ｃ'
	486:  {0xFF24, 0xFF44},   // 'Ｄ' => 'ｄ'
	483:  {0xFF25, 0xFF45},   // 'Ｅ' => 'ｅ'
	480:  {0xFF26, 0xFF46},   // 'Ｆ' => 'ｆ'
	477:  {0xFF27, 0xFF47},   // 'Ｇ' => 'ｇ'
	474:  {0xFF28, 0xFF48},   // 'Ｈ' => 'ｈ'
	471:  {0xFF29, 0xFF49},   // 'Ｉ' => 'ｉ'
	468:  {0xFF2A, 0xFF4A},   // 'Ｊ' => 'ｊ'
	465:  {0xFF2B, 0xFF4B},   // 'Ｋ' => 'ｋ'
	462:  {0xFF2C, 0xFF4C},   // 'Ｌ' => 'ｌ'
	459:  {0xFF2D, 0xFF4D},   // 'Ｍ' => 'ｍ'
	456:  {0xFF2E, 0xFF4E},   // 'Ｎ' => 'ｎ'
	453:  {0xFF2F, 0xFF4F},   // 'Ｏ' => 'ｏ'
	450:  {0xFF30, 0xFF50},   // 'Ｐ' => 'ｐ'
	447:  {0xFF31, 0xFF51},   // 'Ｑ' => 'ｑ'
	444:  {0xFF32, 0xFF52},   // 'Ｒ' => 'ｒ'
	441:  {0xFF33, 0xFF53},   // 'Ｓ' => 'ｓ'
	438:  {0xFF34, 0xFF54},   // 'Ｔ' => 'ｔ'
	435:  {0xFF35, 0xFF55},   // 'Ｕ' => 'ｕ'
	432:  {0xFF36, 0xFF56},   // 'Ｖ' => 'ｖ'
	429:  {0xFF37, 0xFF57},   // 'Ｗ' => 'ｗ'
	426:  {0xFF38, 0xFF58},   // 'Ｘ' => 'ｘ'
	423:  {0xFF39, 0xFF59},   // 'Ｙ' => 'ｙ'
	420:  {0xFF3A, 0xFF5A},   // 'Ｚ' => 'ｚ'
	5041: {0x10400, 0x10428}, // '𐐀' => '𐐨'
	5038: {0x10401, 0x10429}, // '𐐁' => '𐐩'
	5035: {0x10402, 0x1042A}, // '𐐂' => '𐐪'
	5032: {0x10403, 0x1042B}, // '𐐃' => '𐐫'
	5029: {0x10404, 0x1042C}, // '𐐄' => '𐐬'
	5026: {0x10405, 0x1042D}, // '𐐅' => '𐐭'
	5023: {0x10406, 0x1042E}, // '𐐆' => '𐐮'
	5020: {0x10407, 0x1042F}, // '𐐇' => '𐐯'
	5017: {0x10408, 0x10430}, // '𐐈' => '𐐰'
	5014: {0x10409, 0x10431}, // '𐐉' => '𐐱'
	5011: {0x1040A, 0x10432}, // '𐐊' => '𐐲'
	5008: {0x1040B, 0x10433}, // '𐐋' => '𐐳'
	5005: {0x1040C, 0x10434}, // '𐐌' => '𐐴'
	5002: {0x1040D, 0x10435}, // '𐐍' => '𐐵'
	4999: {0x1040E, 0x10436}, // '𐐎' => '𐐶'
	4996: {0x1040F, 0x10437}, // '𐐏' => '𐐷'
	4993: {0x10410, 0x10438}, // '𐐐' => '𐐸'
	4990: {0x10411, 0x10439}, // '𐐑' => '𐐹'
	4987: {0x10412, 0x1043A}, // '𐐒' => '𐐺'
	4984: {0x10413, 0x1043B}, // '𐐓' => '𐐻'
	4981: {0x10414, 0x1043C}, // '𐐔' => '𐐼'
	4978: {0x10415, 0x1043D}, // '𐐕' => '𐐽'
	4975: {0x10416, 0x1043E}, // '𐐖' => '𐐾'
	4972: {0x10417, 0x1043F}, // '𐐗' => '𐐿'
	4969: {0x10418, 0x10440}, // '𐐘' => '𐑀'
	4966: {0x10419, 0x10441}, // '𐐙' => '𐑁'
	4963: {0x1041A, 0x10442}, // '𐐚' => '𐑂'
	4960: {0x1041B, 0x10443}, // '𐐛' => '𐑃'
	4957: {0x1041C, 0x10444}, // '𐐜' => '𐑄'
	4954: {0x1041D, 0x10445}, // '𐐝' => '𐑅'
	4951: {0x1041E, 0x10446}, // '𐐞' => '𐑆'
	4948: {0x1041F, 0x10447}, // '𐐟' => '𐑇'
	4945: {0x10420, 0x10448}, // '𐐠' => '𐑈'
	4942: {0x10421, 0x10449}, // '𐐡' => '𐑉'
	4939: {0x10422, 0x1044A}, // '𐐢' => '𐑊'
	4936: {0x10423, 0x1044B}, // '𐐣' => '𐑋'
	4933: {0x10424, 0x1044C}, // '𐐤' => '𐑌'
	4930: {0x10425, 0x1044D}, // '𐐥' => '𐑍'
	4927: {0x10426, 0x1044E}, // '𐐦' => '𐑎'
	4924: {0x10427, 0x1044F}, // '𐐧' => '𐑏'
	4921: {0x10400, 0x10428}, // '𐐀' => '𐐨'
	4918: {0x10401, 0x10429}, // '𐐁' => '𐐩'
	4915: {0x10402, 0x1042A}, // '𐐂' => '𐐪'
	4912: {0x10403, 0x1042B}, // '𐐃' => '𐐫'
	4909: {0x10404, 0x1042C}, // '𐐄' => '𐐬'
	4906: {0x10405, 0x1042D}, // '𐐅' => '𐐭'
	4903: {0x10406, 0x1042E}, // '𐐆' => '𐐮'
	4900: {0x10407, 0x1042F}, // '𐐇' => '𐐯'
	4897: {0x10408, 0x10430}, // '𐐈' => '𐐰'
	4894: {0x10409, 0x10431}, // '𐐉' => '𐐱'
	4891: {0x1040A, 0x10432}, // '𐐊' => '𐐲'
	4888: {0x1040B, 0x10433}, // '𐐋' => '𐐳'
	4885: {0x1040C, 0x10434}, // '𐐌' => '𐐴'
	4882: {0x1040D, 0x10435}, // '𐐍' => '𐐵'
	4879: {0x1040E, 0x10436}, // '𐐎' => '𐐶'
	4876: {0x1040F, 0x10437}, // '𐐏' => '𐐷'
	4873: {0x10410, 0x10438}, // '𐐐' => '𐐸'
	4870: {0x10411, 0x10439}, // '𐐑' => '𐐹'
	4867: {0x10412, 0x1043A}, // '𐐒' => '𐐺'
	4864: {0x10413, 0x1043B}, // '𐐓' => '𐐻'
	4861: {0x10414, 0x1043C}, // '𐐔' => '𐐼'
	4858: {0x10415, 0x1043D}, // '𐐕' => '𐐽'
	4855: {0x10416, 0x1043E}, // '𐐖' => '𐐾'
	4852: {0x10417, 0x1043F}, // '𐐗' => '𐐿'
	4849: {0x10418, 0x10440}, // '𐐘' => '𐑀'
	4846: {0x10419, 0x10441}, // '𐐙' => '𐑁'
	4843: {0x1041A, 0x10442}, // '𐐚' => '𐑂'
	4840: {0x1041B, 0x10443}, // '𐐛' => '𐑃'
	4837: {0x1041C, 0x10444}, // '𐐜' => '𐑄'
	4834: {0x1041D, 0x10445}, // '𐐝' => '𐑅'
	4831: {0x1041E, 0x10446}, // '𐐞' => '𐑆'
	4828: {0x1041F, 0x10447}, // '𐐟' => '𐑇'
	4825: {0x10420, 0x10448}, // '𐐠' => '𐑈'
	4822: {0x10421, 0x10449}, // '𐐡' => '𐑉'
	4819: {0x10422, 0x1044A}, // '𐐢' => '𐑊'
	4816: {0x10423, 0x1044B}, // '𐐣' => '𐑋'
	4813: {0x10424, 0x1044C}, // '𐐤' => '𐑌'
	4810: {0x10425, 0x1044D}, // '𐐥' => '𐑍'
	4807: {0x10426, 0x1044E}, // '𐐦' => '𐑎'
	4804: {0x10427, 0x1044F}, // '𐐧' => '𐑏'
	4513: {0x104B0, 0x104D8}, // '𐒰' => '𐓘'
	4510: {0x104B1, 0x104D9}, // '𐒱' => '𐓙'
	4507: {0x104B2, 0x104DA}, // '𐒲' => '𐓚'
	4504: {0x104B3, 0x104DB}, // '𐒳' => '𐓛'
	4501: {0x104B4, 0x104DC}, // '𐒴' => '𐓜'
	4498: {0x104B5, 0x104DD}, // '𐒵' => '𐓝'
	4495: {0x104B6, 0x104DE}, // '𐒶' => '𐓞'
	4492: {0x104B7, 0x104DF}, // '𐒷' => '𐓟'
	4489: {0x104B8, 0x104E0}, // '𐒸' => '𐓠'
	4486: {0x104B9, 0x104E1}, // '𐒹' => '𐓡'
	4483: {0x104BA, 0x104E2}, // '𐒺' => '𐓢'
	4480: {0x104BB, 0x104E3}, // '𐒻' => '𐓣'
	4477: {0x104BC, 0x104E4}, // '𐒼' => '𐓤'
	4474: {0x104BD, 0x104E5}, // '𐒽' => '𐓥'
	4471: {0x104BE, 0x104E6}, // '𐒾' => '𐓦'
	4468: {0x104BF, 0x104E7}, // '𐒿' => '𐓧'
	4465: {0x104C0, 0x104E8}, // '𐓀' => '𐓨'
	4462: {0x104C1, 0x104E9}, // '𐓁' => '𐓩'
	4459: {0x104C2, 0x104EA}, // '𐓂' => '𐓪'
	4456: {0x104C3, 0x104EB}, // '𐓃' => '𐓫'
	4453: {0x104C4, 0x104EC}, // '𐓄' => '𐓬'
	4450: {0x104C5, 0x104ED}, // '𐓅' => '𐓭'
	4447: {0x104C6, 0x104EE}, // '𐓆' => '𐓮'
	4444: {0x104C7, 0x104EF}, // '𐓇' => '𐓯'
	4441: {0x104C8, 0x104F0}, // '𐓈' => '𐓰'
	4438: {0x104C9, 0x104F1}, // '𐓉' => '𐓱'
	4435: {0x104CA, 0x104F2}, // '𐓊' => '𐓲'
	4432: {0x104CB, 0x104F3}, // '𐓋' => '𐓳'
	4429: {0x104CC, 0x104F4}, // '𐓌' => '𐓴'
	4426: {0x104CD, 0x104F5}, // '𐓍' => '𐓵'
	4423: {0x104CE, 0x104F6}, // '𐓎' => '𐓶'
	4420: {0x104CF, 0x104F7}, // '𐓏' => '𐓷'
	4417: {0x104D0, 0x104F8}, // '𐓐' => '𐓸'
	4414: {0x104D1, 0x104F9}, // '𐓑' => '𐓹'
	4411: {0x104D2, 0x104FA}, // '𐓒' => '𐓺'
	4408: {0x104D3, 0x104FB}, // '𐓓' => '𐓻'
	4393: {0x104B0, 0x104D8}, // '𐒰' => '𐓘'
	4390: {0x104B1, 0x104D9}, // '𐒱' => '𐓙'
	4387: {0x104B2, 0x104DA}, // '𐒲' => '𐓚'
	4384: {0x104B3, 0x104DB}, // '𐒳' => '𐓛'
	4381: {0x104B4, 0x104DC}, // '𐒴' => '𐓜'
	4378: {0x104B5, 0x104DD}, // '𐒵' => '𐓝'
	4375: {0x104B6, 0x104DE}, // '𐒶' => '𐓞'
	4372: {0x104B7, 0x104DF}, // '𐒷' => '𐓟'
	4369: {0x104B8, 0x104E0}, // '𐒸' => '𐓠'
	4366: {0x104B9, 0x104E1}, // '𐒹' => '𐓡'
	4363: {0x104BA, 0x104E2}, // '𐒺' => '𐓢'
	4360: {0x104BB, 0x104E3}, // '𐒻' => '𐓣'
	4357: {0x104BC, 0x104E4}, // '𐒼' => '𐓤'
	4354: {0x104BD, 0x104E5}, // '𐒽' => '𐓥'
	4351: {0x104BE, 0x104E6}, // '𐒾' => '𐓦'
	4348: {0x104BF, 0x104E7}, // '𐒿' => '𐓧'
	4345: {0x104C0, 0x104E8}, // '𐓀' => '𐓨'
	4342: {0x104C1, 0x104E9}, // '𐓁' => '𐓩'
	4339: {0x104C2, 0x104EA}, // '𐓂' => '𐓪'
	4336: {0x104C3, 0x104EB}, // '𐓃' => '𐓫'
	4333: {0x104C4, 0x104EC}, // '𐓄' => '𐓬'
	4330: {0x104C5, 0x104ED}, // '𐓅' => '𐓭'
	4327: {0x104C6, 0x104EE}, // '𐓆' => '𐓮'
	4324: {0x104C7, 0x104EF}, // '𐓇' => '𐓯'
	4321: {0x104C8, 0x104F0}, // '𐓈' => '𐓰'
	4318: {0x104C9, 0x104F1}, // '𐓉' => '𐓱'
	4315: {0x104CA, 0x104F2}, // '𐓊' => '𐓲'
	4312: {0x104CB, 0x104F3}, // '𐓋' => '𐓳'
	4309: {0x104CC, 0x104F4}, // '𐓌' => '𐓴'
	4306: {0x104CD, 0x104F5}, // '𐓍' => '𐓵'
	4303: {0x104CE, 0x104F6}, // '𐓎' => '𐓶'
	4300: {0x104CF, 0x104F7}, // '𐓏' => '𐓷'
	4297: {0x104D0, 0x104F8}, // '𐓐' => '𐓸'
	4294: {0x104D1, 0x104F9}, // '𐓑' => '𐓹'
	4291: {0x104D2, 0x104FA}, // '𐓒' => '𐓺'
	4288: {0x104D3, 0x104FB}, // '𐓓' => '𐓻'
	3936: {0x10570, 0x10597}, // '𐕰' => '𐖗'
	3933: {0x10571, 0x10598}, // '𐕱' => '𐖘'
	3930: {0x10572, 0x10599}, // '𐕲' => '𐖙'
	3927: {0x10573, 0x1059A}, // '𐕳' => '𐖚'
	3924: {0x10574, 0x1059B}, // '𐕴' => '𐖛'
	3921: {0x10575, 0x1059C}, // '𐕵' => '𐖜'
	3918: {0x10576, 0x1059D}, // '𐕶' => '𐖝'
	3915: {0x10577, 0x1059E}, // '𐕷' => '𐖞'
	3912: {0x10578, 0x1059F}, // '𐕸' => '𐖟'
	3909: {0x10579, 0x105A0}, // '𐕹' => '𐖠'
	3906: {0x1057A, 0x105A1}, // '𐕺' => '𐖡'
	3900: {0x1057C, 0x105A3}, // '𐕼' => '𐖣'
	3897: {0x1057D, 0x105A4}, // '𐕽' => '𐖤'
	3894: {0x1057E, 0x105A5}, // '𐕾' => '𐖥'
	3891: {0x1057F, 0x105A6}, // '𐕿' => '𐖦'
	3888: {0x10580, 0x105A7}, // '𐖀' => '𐖧'
	3885: {0x10581, 0x105A8}, // '𐖁' => '𐖨'
	3882: {0x10582, 0x105A9}, // '𐖂' => '𐖩'
	3879: {0x10583, 0x105AA}, // '𐖃' => '𐖪'
	3876: {0x10584, 0x105AB}, // '𐖄' => '𐖫'
	3873: {0x10585, 0x105AC}, // '𐖅' => '𐖬'
	3870: {0x10586, 0x105AD}, // '𐖆' => '𐖭'
	3867: {0x10587, 0x105AE}, // '𐖇' => '𐖮'
	3864: {0x10588, 0x105AF}, // '𐖈' => '𐖯'
	3861: {0x10589, 0x105B0}, // '𐖉' => '𐖰'
	3858: {0x1058A, 0x105B1}, // '𐖊' => '𐖱'
	3852: {0x1058C, 0x105B3}, // '𐖌' => '𐖳'
	3849: {0x1058D, 0x105B4}, // '𐖍' => '𐖴'
	3846: {0x1058E, 0x105B5}, // '𐖎' => '𐖵'
	3843: {0x1058F, 0x105B6}, // '𐖏' => '𐖶'
	3840: {0x10590, 0x105B7}, // '𐖐' => '𐖷'
	3837: {0x10591, 0x105B8}, // '𐖑' => '𐖸'
	3834: {0x10592, 0x105B9}, // '𐖒' => '𐖹'
	3828: {0x10594, 0x105BB}, // '𐖔' => '𐖻'
	3825: {0x10595, 0x105BC}, // '𐖕' => '𐖼'
	3819: {0x10570, 0x10597}, // '𐕰' => '𐖗'
	3816: {0x10571, 0x10598}, // '𐕱' => '𐖘'
	3813: {0x10572, 0x10599}, // '𐕲' => '𐖙'
	3810: {0x10573, 0x1059A}, // '𐕳' => '𐖚'
	3807: {0x10574, 0x1059B}, // '𐕴' => '𐖛'
	3804: {0x10575, 0x1059C}, // '𐕵' => '𐖜'
	3801: {0x10576, 0x1059D}, // '𐕶' => '𐖝'
	3798: {0x10577, 0x1059E}, // '𐕷' => '𐖞'
	3795: {0x10578, 0x1059F}, // '𐕸' => '𐖟'
	3792: {0x10579, 0x105A0}, // '𐕹' => '𐖠'
	3789: {0x1057A, 0x105A1}, // '𐕺' => '𐖡'
	3783: {0x1057C, 0x105A3}, // '𐕼' => '𐖣'
	3780: {0x1057D, 0x105A4}, // '𐕽' => '𐖤'
	3777: {0x1057E, 0x105A5}, // '𐕾' => '𐖥'
	3774: {0x1057F, 0x105A6}, // '𐕿' => '𐖦'
	3771: {0x10580, 0x105A7}, // '𐖀' => '𐖧'
	3768: {0x10581, 0x105A8}, // '𐖁' => '𐖨'
	3765: {0x10582, 0x105A9}, // '𐖂' => '𐖩'
	3762: {0x10583, 0x105AA}, // '𐖃' => '𐖪'
	3759: {0x10584, 0x105AB}, // '𐖄' => '𐖫'
	3756: {0x10585, 0x105AC}, // '𐖅' => '𐖬'
	3753: {0x10586, 0x105AD}, // '𐖆' => '𐖭'
	3750: {0x10587, 0x105AE}, // '𐖇' => '𐖮'
	3747: {0x10588, 0x105AF}, // '𐖈' => '𐖯'
	3744: {0x10589, 0x105B0}, // '𐖉' => '𐖰'
	3741: {0x1058A, 0x105B1}, // '𐖊' => '𐖱'
	3735: {0x1058C, 0x105B3}, // '𐖌' => '𐖳'
	3732: {0x1058D, 0x105B4}, // '𐖍' => '𐖴'
	3729: {0x1058E, 0x105B5}, // '𐖎' => '𐖵'
	3726: {0x1058F, 0x105B6}, // '𐖏' => '𐖶'
	3723: {0x10590, 0x105B7}, // '𐖐' => '𐖷'
	3720: {0x10591, 0x105B8}, // '𐖑' => '𐖸'
	3717: {0x10592, 0x105B9}, // '𐖒' => '𐖹'
	3711: {0x10594, 0x105BB}, // '𐖔' => '𐖻'
	3708: {0x10595, 0x105BC}, // '𐖕' => '𐖼'
	6702: {0x10C80, 0x10CC0}, // '𐲀' => '𐳀'
	6699: {0x10C81, 0x10CC1}, // '𐲁' => '𐳁'
	6696: {0x10C82, 0x10CC2}, // '𐲂' => '𐳂'
	6693: {0x10C83, 0x10CC3}, // '𐲃' => '𐳃'
	6690: {0x10C84, 0x10CC4}, // '𐲄' => '𐳄'
	6687: {0x10C85, 0x10CC5}, // '𐲅' => '𐳅'
	6684: {0x10C86, 0x10CC6}, // '𐲆' => '𐳆'
	6681: {0x10C87, 0x10CC7}, // '𐲇' => '𐳇'
	6678: {0x10C88, 0x10CC8}, // '𐲈' => '𐳈'
	6675: {0x10C89, 0x10CC9}, // '𐲉' => '𐳉'
	6672: {0x10C8A, 0x10CCA}, // '𐲊' => '𐳊'
	6669: {0x10C8B, 0x10CCB}, // '𐲋' => '𐳋'
	6666: {0x10C8C, 0x10CCC}, // '𐲌' => '𐳌'
	6663: {0x10C8D, 0x10CCD}, // '𐲍' => '𐳍'
	6660: {0x10C8E, 0x10CCE}, // '𐲎' => '𐳎'
	6657: {0x10C8F, 0x10CCF}, // '𐲏' => '𐳏'
	6654: {0x10C90, 0x10CD0}, // '𐲐' => '𐳐'
	6651: {0x10C91, 0x10CD1}, // '𐲑' => '𐳑'
	6648: {0x10C92, 0x10CD2}, // '𐲒' => '𐳒'
	6645: {0x10C93, 0x10CD3}, // '𐲓' => '𐳓'
	6642: {0x10C94, 0x10CD4}, // '𐲔' => '𐳔'
	6639: {0x10C95, 0x10CD5}, // '𐲕' => '𐳕'
	6636: {0x10C96, 0x10CD6}, // '𐲖' => '𐳖'
	6633: {0x10C97, 0x10CD7}, // '𐲗' => '𐳗'
	6630: {0x10C98, 0x10CD8}, // '𐲘' => '𐳘'
	6627: {0x10C99, 0x10CD9}, // '𐲙' => '𐳙'
	6624: {0x10C9A, 0x10CDA}, // '𐲚' => '𐳚'
	6621: {0x10C9B, 0x10CDB}, // '𐲛' => '𐳛'
	6618: {0x10C9C, 0x10CDC}, // '𐲜' => '𐳜'
	6615: {0x10C9D, 0x10CDD}, // '𐲝' => '𐳝'
	6612: {0x10C9E, 0x10CDE}, // '𐲞' => '𐳞'
	6609: {0x10C9F, 0x10CDF}, // '𐲟' => '𐳟'
	6606: {0x10CA0, 0x10CE0}, // '𐲠' => '𐳠'
	6603: {0x10CA1, 0x10CE1}, // '𐲡' => '𐳡'
	6600: {0x10CA2, 0x10CE2}, // '𐲢' => '𐳢'
	6597: {0x10CA3, 0x10CE3}, // '𐲣' => '𐳣'
	6594: {0x10CA4, 0x10CE4}, // '𐲤' => '𐳤'
	6591: {0x10CA5, 0x10CE5}, // '𐲥' => '𐳥'
	6588: {0x10CA6, 0x10CE6}, // '𐲦' => '𐳦'
	6585: {0x10CA7, 0x10CE7}, // '𐲧' => '𐳧'
	6582: {0x10CA8, 0x10CE8}, // '𐲨' => '𐳨'
	6579: {0x10CA9, 0x10CE9}, // '𐲩' => '𐳩'
	6576: {0x10CAA, 0x10CEA}, // '𐲪' => '𐳪'
	6573: {0x10CAB, 0x10CEB}, // '𐲫' => '𐳫'
	6570: {0x10CAC, 0x10CEC}, // '𐲬' => '𐳬'
	6567: {0x10CAD, 0x10CED}, // '𐲭' => '𐳭'
	6564: {0x10CAE, 0x10CEE}, // '𐲮' => '𐳮'
	6561: {0x10CAF, 0x10CEF}, // '𐲯' => '𐳯'
	6558: {0x10CB0, 0x10CF0}, // '𐲰' => '𐳰'
	6555: {0x10CB1, 0x10CF1}, // '𐲱' => '𐳱'
	6552: {0x10CB2, 0x10CF2}, // '𐲲' => '𐳲'
	6510: {0x10C80, 0x10CC0}, // '𐲀' => '𐳀'
	6507: {0x10C81, 0x10CC1}, // '𐲁' => '𐳁'
	6504: {0x10C82, 0x10CC2}, // '𐲂' => '𐳂'
	6501: {0x10C83, 0x10CC3}, // '𐲃' => '𐳃'
	6498: {0x10C84, 0x10CC4}, // '𐲄' => '𐳄'
	6495: {0x10C85, 0x10CC5}, // '𐲅' => '𐳅'
	6492: {0x10C86, 0x10CC6}, // '𐲆' => '𐳆'
	6489: {0x10C87, 0x10CC7}, // '𐲇' => '𐳇'
	6486: {0x10C88, 0x10CC8}, // '𐲈' => '𐳈'
	6483: {0x10C89, 0x10CC9}, // '𐲉' => '𐳉'
	6480: {0x10C8A, 0x10CCA}, // '𐲊' => '𐳊'
	6477: {0x10C8B, 0x10CCB}, // '𐲋' => '𐳋'
	6474: {0x10C8C, 0x10CCC}, // '𐲌' => '𐳌'
	6471: {0x10C8D, 0x10CCD}, // '𐲍' => '𐳍'
	6468: {0x10C8E, 0x10CCE}, // '𐲎' => '𐳎'
	6465: {0x10C8F, 0x10CCF}, // '𐲏' => '𐳏'
	6462: {0x10C90, 0x10CD0}, // '𐲐' => '𐳐'
	6459: {0x10C91, 0x10CD1}, // '𐲑' => '𐳑'
	6456: {0x10C92, 0x10CD2}, // '𐲒' => '𐳒'
	6453: {0x10C93, 0x10CD3}, // '𐲓' => '𐳓'
	6450: {0x10C94, 0x10CD4}, // '𐲔' => '𐳔'
	6447: {0x10C95, 0x10CD5}, // '𐲕' => '𐳕'
	6444: {0x10C96, 0x10CD6}, // '𐲖' => '𐳖'
	6441: {0x10C97, 0x10CD7}, // '𐲗' => '𐳗'
	6438: {0x10C98, 0x10CD8}, // '𐲘' => '𐳘'
	6435: {0x10C99, 0x10CD9}, // '𐲙' => '𐳙'
	6432: {0x10C9A, 0x10CDA}, // '𐲚' => '𐳚'
	6429: {0x10C9B, 0x10CDB}, // '𐲛' => '𐳛'
	6426: {0x10C9C, 0x10CDC}, // '𐲜' => '𐳜'
	6423: {0x10C9D, 0x10CDD}, // '𐲝' => '𐳝'
	6420: {0x10C9E, 0x10CDE}, // '𐲞' => '𐳞'
	6417: {0x10C9F, 0x10CDF}, // '𐲟' => '𐳟'
	6414: {0x10CA0, 0x10CE0}, // '𐲠' => '𐳠'
	6411: {0x10CA1, 0x10CE1}, // '𐲡' => '𐳡'
	6408: {0x10CA2, 0x10CE2}, // '𐲢' => '𐳢'
	6405: {0x10CA3, 0x10CE3}, // '𐲣' => '𐳣'
	6402: {0x10CA4, 0x10CE4}, // '𐲤' => '𐳤'
	6399: {0x10CA5, 0x10CE5}, // '𐲥' => '𐳥'
	6396: {0x10CA6, 0x10CE6}, // '𐲦' => '𐳦'
	6393: {0x10CA7, 0x10CE7}, // '𐲧' => '𐳧'
	6390: {0x10CA8, 0x10CE8}, // '𐲨' => '𐳨'
	6387: {0x10CA9, 0x10CE9}, // '𐲩' => '𐳩'
	6384: {0x10CAA, 0x10CEA}, // '𐲪' => '𐳪'
	6381: {0x10CAB, 0x10CEB}, // '𐲫' => '𐳫'
	6378: {0x10CAC, 0x10CEC}, // '𐲬' => '𐳬'
	6375: {0x10CAD, 0x10CED}, // '𐲭' => '𐳭'
	6372: {0x10CAE, 0x10CEE}, // '𐲮' => '𐳮'
	6369: {0x10CAF, 0x10CEF}, // '𐲯' => '𐳯'
	6366: {0x10CB0, 0x10CF0}, // '𐲰' => '𐳰'
	6363: {0x10CB1, 0x10CF1}, // '𐲱' => '𐳱'
	6360: {0x10CB2, 0x10CF2}, // '𐲲' => '𐳲'
	5579: {0x118A0, 0x118C0}, // '𑢠' => '𑣀'
	5576: {0x118A1, 0x118C1}, // '𑢡' => '𑣁'
	5573: {0x118A2, 0x118C2}, // '𑢢' => '𑣂'
	5570: {0x118A3, 0x118C3}, // '𑢣' => '𑣃'
	5567: {0x118A4, 0x118C4}, // '𑢤' => '𑣄'
	5564: {0x118A5, 0x118C5}, // '𑢥' => '𑣅'
	5561: {0x118A6, 0x118C6}, // '𑢦' => '𑣆'
	5558: {0x118A7, 0x118C7}, // '𑢧' => '𑣇'
	5555: {0x118A8, 0x118C8}, // '𑢨' => '𑣈'
	5552: {0x118A9, 0x118C9}, // '𑢩' => '𑣉'
	5549: {0x118AA, 0x118CA}, // '𑢪' => '𑣊'
	5546: {0x118AB, 0x118CB}, // '𑢫' => '𑣋'
	5543: {0x118AC, 0x118CC}, // '𑢬' => '𑣌'
	5540: {0x118AD, 0x118CD}, // '𑢭' => '𑣍'
	5537: {0x118AE, 0x118CE}, // '𑢮' => '𑣎'
	5534: {0x118AF, 0x118CF}, // '𑢯' => '𑣏'
	5531: {0x118B0, 0x118D0}, // '𑢰' => '𑣐'
	5528: {0x118B1, 0x118D1}, // '𑢱' => '𑣑'
	5525: {0x118B2, 0x118D2}, // '𑢲' => '𑣒'
	5522: {0x118B3, 0x118D3}, // '𑢳' => '𑣓'
	5519: {0x118B4, 0x118D4}, // '𑢴' => '𑣔'
	5516: {0x118B5, 0x118D5}, // '𑢵' => '𑣕'
	5513: {0x118B6, 0x118D6}, // '𑢶' => '𑣖'
	5510: {0x118B7, 0x118D7}, // '𑢷' => '𑣗'
	5507: {0x118B8, 0x118D8}, // '𑢸' => '𑣘'
	5504: {0x118B9, 0x118D9}, // '𑢹' => '𑣙'
	5501: {0x118BA, 0x118DA}, // '𑢺' => '𑣚'
	5498: {0x118BB, 0x118DB}, // '𑢻' => '𑣛'
	5495: {0x118BC, 0x118DC}, // '𑢼' => '𑣜'
	5492: {0x118BD, 0x118DD}, // '𑢽' => '𑣝'
	5489: {0x118BE, 0x118DE}, // '𑢾' => '𑣞'
	5486: {0x118BF, 0x118DF}, // '𑢿' => '𑣟'
	5483: {0x118A0, 0x118C0}, // '𑢠' => '𑣀'
	5480: {0x118A1, 0x118C1}, // '𑢡' => '𑣁'
	5477: {0x118A2, 0x118C2}, // '𑢢' => '𑣂'
	5474: {0x118A3, 0x118C3}, // '𑢣' => '𑣃'
	5471: {0x118A4, 0x118C4}, // '𑢤' => '𑣄'
	5468: {0x118A5, 0x118C5}, // '𑢥' => '𑣅'
	5465: {0x118A6, 0x118C6}, // '𑢦' => '𑣆'
	5462: {0x118A7, 0x118C7}, // '𑢧' => '𑣇'
	5459: {0x118A8, 0x118C8}, // '𑢨' => '𑣈'
	5456: {0x118A9, 0x118C9}, // '𑢩' => '𑣉'
	5453: {0x118AA, 0x118CA}, // '𑢪' => '𑣊'
	5450: {0x118AB, 0x118CB}, // '𑢫' => '𑣋'
	5447: {0x118AC, 0x118CC}, // '𑢬' => '𑣌'
	5444: {0x118AD, 0x118CD}, // '𑢭' => '𑣍'
	5441: {0x118AE, 0x118CE}, // '𑢮' => '𑣎'
	5438: {0x118AF, 0x118CF}, // '𑢯' => '𑣏'
	5435: {0x118B0, 0x118D0}, // '𑢰' => '𑣐'
	5432: {0x118B1, 0x118D1}, // '𑢱' => '𑣑'
	5429: {0x118B2, 0x118D2}, // '𑢲' => '𑣒'
	5426: {0x118B3, 0x118D3}, // '𑢳' => '𑣓'
	5423: {0x118B4, 0x118D4}, // '𑢴' => '𑣔'
	5420: {0x118B5, 0x118D5}, // '𑢵' => '𑣕'
	5417: {0x118B6, 0x118D6}, // '𑢶' => '𑣖'
	5414: {0x118B7, 0x118D7}, // '𑢷' => '𑣗'
	5411: {0x118B8, 0x118D8}, // '𑢸' => '𑣘'
	5408: {0x118B9, 0x118D9}, // '𑢹' => '𑣙'
	5405: {0x118BA, 0x118DA}, // '𑢺' => '𑣚'
	5402: {0x118BB, 0x118DB}, // '𑢻' => '𑣛'
	5399: {0x118BC, 0x118DC}, // '𑢼' => '𑣜'
	5396: {0x118BD, 0x118DD}, // '𑢽' => '𑣝'
	5393: {0x118BE, 0x118DE}, // '𑢾' => '𑣞'
	5390: {0x118BF, 0x118DF}, // '𑢿' => '𑣟'
	5329: {0x16E40, 0x16E60}, // '𖹀' => '𖹠'
	5326: {0x16E41, 0x16E61}, // '𖹁' => '𖹡'
	5323: {0x16E42, 0x16E62}, // '𖹂' => '𖹢'
	5320: {0x16E43, 0x16E63}, // '𖹃' => '𖹣'
	5317: {0x16E44, 0x16E64}, // '𖹄' => '𖹤'
	5314: {0x16E45, 0x16E65}, // '𖹅' => '𖹥'
	5311: {0x16E46, 0x16E66}, // '𖹆' => '𖹦'
	5308: {0x16E47, 0x16E67}, // '𖹇' => '𖹧'
	5305: {0x16E48, 0x16E68}, // '𖹈' => '𖹨'
	5302: {0x16E49, 0x16E69}, // '𖹉' => '𖹩'
	5299: {0x16E4A, 0x16E6A}, // '𖹊' => '𖹪'
	5296: {0x16E4B, 0x16E6B}, // '𖹋' => '𖹫'
	5293: {0x16E4C, 0x16E6C}, // '𖹌' => '𖹬'
	5290: {0x16E4D, 0x16E6D}, // '𖹍' => '𖹭'
	5287: {0x16E4E, 0x16E6E}, // '𖹎' => '𖹮'
	5284: {0x16E4F, 0x16E6F}, // '𖹏' => '𖹯'
	5281: {0x16E50, 0x16E70}, // '𖹐' => '𖹰'
	5278: {0x16E51, 0x16E71}, // '𖹑' => '𖹱'
	5275: {0x16E52, 0x16E72}, // '𖹒' => '𖹲'
	5272: {0x16E53, 0x16E73}, // '𖹓' => '𖹳'
	5269: {0x16E54, 0x16E74}, // '𖹔' => '𖹴'
	5266: {0x16E55, 0x16E75}, // '𖹕' => '𖹵'
	5263: {0x16E56, 0x16E76}, // '𖹖' => '𖹶'
	5260: {0x16E57, 0x16E77}, // '𖹗' => '𖹷'
	5257: {0x16E58, 0x16E78}, // '𖹘' => '𖹸'
	5254: {0x16E59, 0x16E79}, // '𖹙' => '𖹹'
	5251: {0x16E5A, 0x16E7A}, // '𖹚' => '𖹺'
	5248: {0x16E5B, 0x16E7B}, // '𖹛' => '𖹻'
	5245: {0x16E5C, 0x16E7C}, // '𖹜' => '𖹼'
	5242: {0x16E5D, 0x16E7D}, // '𖹝' => '𖹽'
	5239: {0x16E5E, 0x16E7E}, // '𖹞' => '𖹾'
	5236: {0x16E5F, 0x16E7F}, // '𖹟' => '𖹿'
	5233: {0x16E40, 0x16E60}, // '𖹀' => '𖹠'
	5230: {0x16E41, 0x16E61}, // '𖹁' => '𖹡'
	5227: {0x16E42, 0x16E62}, // '𖹂' => '𖹢'
	5224: {0x16E43, 0x16E63}, // '𖹃' => '𖹣'
	5221: {0x16E44, 0x16E64}, // '𖹄' => '𖹤'
	5218: {0x16E45, 0x16E65}, // '𖹅' => '𖹥'
	5215: {0x16E46, 0x16E66}, // '𖹆' => '𖹦'
	5212: {0x16E47, 0x16E67}, // '𖹇' => '𖹧'
	5209: {0x16E48, 0x16E68}, // '𖹈' => '𖹨'
	5206: {0x16E49, 0x16E69}, // '𖹉' => '𖹩'
	5203: {0x16E4A, 0x16E6A}, // '𖹊' => '𖹪'
	5200: {0x16E4B, 0x16E6B}, // '𖹋' => '𖹫'
	5197: {0x16E4C, 0x16E6C}, // '𖹌' => '𖹬'
	5194: {0x16E4D, 0x16E6D}, // '𖹍' => '𖹭'
	5191: {0x16E4E, 0x16E6E}, // '𖹎' => '𖹮'
	5188: {0x16E4F, 0x16E6F}, // '𖹏' => '𖹯'
	5185: {0x16E50, 0x16E70}, // '𖹐' => '𖹰'
	5182: {0x16E51, 0x16E71}, // '𖹑' => '𖹱'
	5179: {0x16E52, 0x16E72}, // '𖹒' => '𖹲'
	5176: {0x16E53, 0x16E73}, // '𖹓' => '𖹳'
	5173: {0x16E54, 0x16E74}, // '𖹔' => '𖹴'
	5170: {0x16E55, 0x16E75}, // '𖹕' => '𖹵'
	5167: {0x16E56, 0x16E76}, // '𖹖' => '𖹶'
	5164: {0x16E57, 0x16E77}, // '𖹗' => '𖹷'
	5161: {0x16E58, 0x16E78}, // '𖹘' => '𖹸'
	5158: {0x16E59, 0x16E79}, // '𖹙' => '𖹹'
	5155: {0x16E5A, 0x16E7A}, // '𖹚' => '𖹺'
	5152: {0x16E5B, 0x16E7B}, // '𖹛' => '𖹻'
	5149: {0x16E5C, 0x16E7C}, // '𖹜' => '𖹼'
	5146: {0x16E5D, 0x16E7D}, // '𖹝' => '𖹽'
	5143: {0x16E5E, 0x16E7E}, // '𖹞' => '𖹾'
	5140: {0x16E5F, 0x16E7F}, // '𖹟' => '𖹿'
	1132: {0x1E900, 0x1E922}, // '𞤀' => '𞤢'
	1129: {0x1E901, 0x1E923}, // '𞤁' => '𞤣'
	1126: {0x1E902, 0x1E924}, // '𞤂' => '𞤤'
	1123: {0x1E903, 0x1E925}, // '𞤃' => '𞤥'
	1120: {0x1E904, 0x1E926}, // '𞤄' => '𞤦'
	1117: {0x1E905, 0x1E927}, // '𞤅' => '𞤧'
	1114: {0x1E906, 0x1E928}, // '𞤆' => '𞤨'
	1111: {0x1E907, 0x1E929}, // '𞤇' => '𞤩'
	1108: {0x1E908, 0x1E92A}, // '𞤈' => '𞤪'
	1105: {0x1E909, 0x1E92B}, // '𞤉' => '𞤫'
	1102: {0x1E90A, 0x1E92C}, // '𞤊' => '𞤬'
	1099: {0x1E90B, 0x1E92D}, // '𞤋' => '𞤭'
	1096: {0x1E90C, 0x1E92E}, // '𞤌' => '𞤮'
	1093: {0x1E90D, 0x1E92F}, // '𞤍' => '𞤯'
	1090: {0x1E90E, 0x1E930}, // '𞤎' => '𞤰'
	1087: {0x1E90F, 0x1E931}, // '𞤏' => '𞤱'
	1084: {0x1E910, 0x1E932}, // '𞤐' => '𞤲'
	1081: {0x1E911, 0x1E933}, // '𞤑' => '𞤳'
	1078: {0x1E912, 0x1E934}, // '𞤒' => '𞤴'
	1075: {0x1E913, 0x1E935}, // '𞤓' => '𞤵'
	1072: {0x1E914, 0x1E936}, // '𞤔' => '𞤶'
	1069: {0x1E915, 0x1E937}, // '𞤕' => '𞤷'
	1066: {0x1E916, 0x1E938}, // '𞤖' => '𞤸'
	1063: {0x1E917, 0x1E939}, // '𞤗' => '𞤹'
	1060: {0x1E918, 0x1E93A}, // '𞤘' => '𞤺'
	1057: {0x1E919, 0x1E93B}, // '𞤙' => '𞤻'
	1054: {0x1E91A, 0x1E93C}, // '𞤚' => '𞤼'
	1051: {0x1E91B, 0x1E93D}, // '𞤛' => '𞤽'
	1048: {0x1E91C, 0x1E93E}, // '𞤜' => '𞤾'
	1045: {0x1E91D, 0x1E93F}, // '𞤝' => '𞤿'
	1042: {0x1E91E, 0x1E940}, // '𞤞' => '𞥀'
	1039: {0x1E91F, 0x1E941}, // '𞤟' => '𞥁'
	1036: {0x1E920, 0x1E942}, // '𞤠' => '𞥂'
	1033: {0x1E921, 0x1E943}, // '𞤡' => '𞥃'
	1030: {0x1E900, 0x1E922}, // '𞤀' => '𞤢'
	1027: {0x1E901, 0x1E923}, // '𞤁' => '𞤣'
	1024: {0x1E902, 0x1E924}, // '𞤂' => '𞤤'
	1021: {0x1E903, 0x1E925}, // '𞤃' => '𞤥'
	1018: {0x1E904, 0x1E926}, // '𞤄' => '𞤦'
	1015: {0x1E905, 0x1E927}, // '𞤅' => '𞤧'
	1012: {0x1E906, 0x1E928}, // '𞤆' => '𞤨'
	1009: {0x1E907, 0x1E929}, // '𞤇' => '𞤩'
	1006: {0x1E908, 0x1E92A}, // '𞤈' => '𞤪'
	1003: {0x1E909, 0x1E92B}, // '𞤉' => '𞤫'
	1000: {0x1E90A, 0x1E92C}, // '𞤊' => '𞤬'
	997:  {0x1E90B, 0x1E92D}, // '𞤋' => '𞤭'
	994:  {0x1E90C, 0x1E92E}, // '𞤌' => '𞤮'
	991:  {0x1E90D, 0x1E92F}, // '𞤍' => '𞤯'
	988:  {0x1E90E, 0x1E930}, // '𞤎' => '𞤰'
	985:  {0x1E90F, 0x1E931}, // '𞤏' => '𞤱'
	982:  {0x1E910, 0x1E932}, // '𞤐' => '𞤲'
	979:  {0x1E911, 0x1E933}, // '𞤑' => '𞤳'
	976:  {0x1E912, 0x1E934}, // '𞤒' => '𞤴'
	973:  {0x1E913, 0x1E935}, // '𞤓' => '𞤵'
	970:  {0x1E914, 0x1E936}, // '𞤔' => '𞤶'
	967:  {0x1E915, 0x1E937}, // '𞤕' => '𞤷'
	964:  {0x1E916, 0x1E938}, // '𞤖' => '𞤸'
	961:  {0x1E917, 0x1E939}, // '𞤗' => '𞤹'
	958:  {0x1E918, 0x1E93A}, // '𞤘' => '𞤺'
	955:  {0x1E919, 0x1E93B}, // '𞤙' => '𞤻'
	952:  {0x1E91A, 0x1E93C}, // '𞤚' => '𞤼'
	949:  {0x1E91B, 0x1E93D}, // '𞤛' => '𞤽'
	946:  {0x1E91C, 0x1E93E}, // '𞤜' => '𞤾'
	943:  {0x1E91D, 0x1E93F}, // '𞤝' => '𞤿'
	940:  {0x1E91E, 0x1E940}, // '𞤞' => '𞥀'
	937:  {0x1E91F, 0x1E941}, // '𞤟' => '𞥁'
	934:  {0x1E920, 0x1E942}, // '𞤠' => '𞥂'
	931:  {0x1E921, 0x1E943}, // '𞤡' => '𞥃'
}

// toUpperLowerSpecial returns the uppercase and lowercase form of r,
// which is a character that is not equal to either its uppercase or
// lowercase form and thus cannot be mapped into the _UpperLower table.
func toUpperLowerSpecial(r rune) (rune, rune, bool) {
	switch r {
	case 'ǅ':
		return 'Ǆ', 'ǆ', true
	case 'ǈ':
		return 'Ǉ', 'ǉ', true
	case 'ǋ':
		return 'Ǌ', 'ǌ', true
	case 'ǲ':
		return 'Ǳ', 'ǳ', true
	}
	return r, r, false
}

const _FoldMapSeed = 0x96480001
const _FoldMapShift = 24

// FoldMap stores the Unicode case-folds for characters that have two or more folds.
var _FoldMap = [256][4]uint16{
	7:   {0x004B, 0x006B, 0x212A},         // ['K' 'k' 'K']
	185: {0x0053, 0x0073, 0x017F},         // ['S' 's' 'ſ']
	208: {0x006B, 0x004B, 0x212A},         // ['k' 'K' 'K']
	130: {0x0073, 0x0053, 0x017F},         // ['s' 'S' 'ſ']
	64:  {0x00B5, 0x039C, 0x03BC},         // ['µ' 'Μ' 'μ']
	165: {0x00C5, 0x00E5, 0x212B},         // ['Å' 'å' 'Å']
	232: {0x00DF, 0x1E9E},                 // ['ß' 'ẞ']
	110: {0x00E5, 0x00C5, 0x212B},         // ['å' 'Å' 'Å']
	117: {0x0130},                         // ['İ']
	11:  {0x0131},                         // ['ı']
	213: {0x017F, 0x0053, 0x0073},         // ['ſ' 'S' 's']
	87:  {0x01C4, 0x01C5, 0x01C6},         // ['Ǆ' 'ǅ' 'ǆ']
	237: {0x01C5, 0x01C4, 0x01C6},         // ['ǅ' 'Ǆ' 'ǆ']
	131: {0x01C6, 0x01C4, 0x01C5},         // ['ǆ' 'Ǆ' 'ǅ']
	25:  {0x01C7, 0x01C8, 0x01C9},         // ['Ǉ' 'ǈ' 'ǉ']
	176: {0x01C8, 0x01C7, 0x01C9},         // ['ǈ' 'Ǉ' 'ǉ']
	70:  {0x01C9, 0x01C7, 0x01C8},         // ['ǉ' 'Ǉ' 'ǈ']
	220: {0x01CA, 0x01CB, 0x01CC},         // ['Ǌ' 'ǋ' 'ǌ']
	115: {0x01CB, 0x01CA, 0x01CC},         // ['ǋ' 'Ǌ' 'ǌ']
	9:   {0x01CC, 0x01CA, 0x01CB},         // ['ǌ' 'Ǌ' 'ǋ']
	193: {0x01F1, 0x01F2, 0x01F3},         // ['Ǳ' 'ǲ' 'ǳ']
	88:  {0x01F2, 0x01F1, 0x01F3},         // ['ǲ' 'Ǳ' 'ǳ']
	238: {0x01F3, 0x01F1, 0x01F2},         // ['ǳ' 'Ǳ' 'ǲ']
	89:  {0x0345, 0x0399, 0x03B9, 0x1FBE}, // ['ͅ' 'Ι' 'ι' 'ι']
	141: {0x0392, 0x03B2, 0x03D0},         // ['Β' 'β' 'ϐ']
	79:  {0x0395, 0x03B5, 0x03F5},         // ['Ε' 'ε' 'ϵ']
	18:  {0x0398, 0x03B8, 0x03D1, 0x03F4}, // ['Θ' 'θ' 'ϑ' 'ϴ']
	169: {0x0399, 0x0345, 0x03B9, 0x1FBE}, // ['Ι' 'ͅ' 'ι' 'ι']
	63:  {0x039A, 0x03BA, 0x03F0},         // ['Κ' 'κ' 'ϰ']
	107: {0x039C, 0x00B5, 0x03BC},         // ['Μ' 'µ' 'μ']
	197: {0x03A0, 0x03C0, 0x03D6},         // ['Π' 'π' 'ϖ']
	91:  {0x03A1, 0x03C1, 0x03F1},         // ['Ρ' 'ρ' 'ϱ']
	135: {0x03A3, 0x03C2, 0x03C3},         // ['Σ' 'ς' 'σ']
	74:  {0x03A6, 0x03C6, 0x03D5},         // ['Φ' 'φ' 'ϕ']
	13:  {0x03A9, 0x03C9, 0x2126},         // ['Ω' 'ω' 'Ω']
	86:  {0x03B2, 0x0392, 0x03D0},         // ['β' 'Β' 'ϐ']
	24:  {0x03B5, 0x0395, 0x03F5},         // ['ε' 'Ε' 'ϵ']
	219: {0x03B8, 0x0398, 0x03D1, 0x03F4}, // ['θ' 'Θ' 'ϑ' 'ϴ']
	114: {0x03B9, 0x0345, 0x0399, 0x1FBE}, // ['ι' 'ͅ' 'Ι' 'ι']
	8:   {0x03BA, 0x039A, 0x03F0},         // ['κ' 'Κ' 'ϰ']
	52:  {0x03BC, 0x00B5, 0x039C},         // ['μ' 'µ' 'Μ']
	142: {0x03C0, 0x03A0, 0x03D6},         // ['π' 'Π' 'ϖ']
	36:  {0x03C1, 0x03A1, 0x03F1},         // ['ρ' 'Ρ' 'ϱ']
	186: {0x03C2, 0x03A3, 0x03C3},         // ['ς' 'Σ' 'σ']
	80:  {0x03C3, 0x03A3, 0x03C2},         // ['σ' 'Σ' 'ς']
	19:  {0x03C6, 0x03A6, 0x03D5},         // ['φ' 'Φ' 'ϕ']
	214: {0x03C9, 0x03A9, 0x2126},         // ['ω' 'Ω' 'Ω']
	242: {0x03D0, 0x0392, 0x03B2},         // ['ϐ' 'Β' 'β']
	136: {0x03D1, 0x0398, 0x03B8, 0x03F4}, // ['ϑ' 'Θ' 'θ' 'ϴ']
	225: {0x03D5, 0x03A6, 0x03C6},         // ['ϕ' 'Φ' 'φ']
	120: {0x03D6, 0x03A0, 0x03C0},         // ['ϖ' 'Π' 'π']
	187: {0x03F0, 0x039A, 0x03BA},         // ['ϰ' 'Κ' 'κ']
	81:  {0x03F1, 0x03A1, 0x03C1},         // ['ϱ' 'Ρ' 'ρ']
	20:  {0x03F4, 0x0398, 0x03B8, 0x03D1}, // ['ϴ' 'Θ' 'θ' 'ϑ']
	170: {0x03F5, 0x0395, 0x03B5},         // ['ϵ' 'Ε' 'ε']
	177: {0x0412, 0x0432, 0x1C80},         // ['В' 'в' 'ᲀ']
	221: {0x0414, 0x0434, 0x1C81},         // ['Д' 'д' 'ᲁ']
	188: {0x041E, 0x043E, 0x1C82},         // ['О' 'о' 'ᲂ']
	127: {0x0421, 0x0441, 0x1C83},         // ['С' 'с' 'ᲃ']
	21:  {0x0422, 0x0442, 0x1C84, 0x1C85}, // ['Т' 'т' 'ᲄ' 'ᲅ']
	199: {0x042A, 0x044A, 0x1C86},         // ['Ъ' 'ъ' 'ᲆ']
	122: {0x0432, 0x0412, 0x1C80},         // ['в' 'В' 'ᲀ']
	166: {0x0434, 0x0414, 0x1C81},         // ['д' 'Д' 'ᲁ']
	133: {0x043E, 0x041E, 0x1C82},         // ['о' 'О' 'ᲂ']
	72:  {0x0441, 0x0421, 0x1C83},         // ['с' 'С' 'ᲃ']
	222: {0x0442, 0x0422, 0x1C84, 0x1C85}, // ['т' 'Т' 'ᲄ' 'ᲅ']
	144: {0x044A, 0x042A, 0x1C86},         // ['ъ' 'Ъ' 'ᲆ']
	167: {0x0462, 0x0463, 0x1C87},         // ['Ѣ' 'ѣ' 'ᲇ']
	61:  {0x0463, 0x0462, 0x1C87},         // ['ѣ' 'Ѣ' 'ᲇ']
	4:   {0x1C80, 0x0412, 0x0432},         // ['ᲀ' 'В' 'в']
	154: {0x1C81, 0x0414, 0x0434},         // ['ᲁ' 'Д' 'д']
	48:  {0x1C82, 0x041E, 0x043E},         // ['ᲂ' 'О' 'о']
	198: {0x1C83, 0x0421, 0x0441},         // ['ᲃ' 'С' 'с']
	93:  {0x1C84, 0x0422, 0x0442, 0x1C85}, // ['ᲄ' 'Т' 'т' 'ᲅ']
	243: {0x1C85, 0x0422, 0x0442, 0x1C84}, // ['ᲅ' 'Т' 'т' 'ᲄ']
	137: {0x1C86, 0x042A, 0x044A},         // ['ᲆ' 'Ъ' 'ъ']
	31:  {0x1C87, 0x0462, 0x0463},         // ['ᲇ' 'Ѣ' 'ѣ']
	182: {0x1C88, 0xA64A, 0xA64B},         // ['ᲈ' 'Ꙋ' 'ꙋ']
	203: {0x1E60, 0x1E61, 0x1E9B},         // ['Ṡ' 'ṡ' 'ẛ']
	97:  {0x1E61, 0x1E60, 0x1E9B},         // ['ṡ' 'Ṡ' 'ẛ']
	109: {0x1E9B, 0x1E60, 0x1E61},         // ['ẛ' 'Ṡ' 'ṡ']
	65:  {0x1FBE, 0x0345, 0x0399, 0x03B9}, // ['ι' 'ͅ' 'Ι' 'ι']
	150: {0x2126, 0x03A9, 0x03C9},         // ['Ω' 'Ω' 'ω']
	239: {0x212A, 0x004B, 0x006B},         // ['K' 'K' 'k']
	134: {0x212B, 0x00C5, 0x00E5},         // ['Å' 'Å' 'å']
	32:  {0xA64A, 0x1C88, 0xA64B},         // ['Ꙋ' 'ᲈ' 'ꙋ']
	183: {0xA64B, 0x1C88, 0xA64A},         // ['ꙋ' 'ᲈ' 'Ꙋ']
}

const _FoldMapExcludingUpperLowerSeed = 0x96480001
const _FoldMapExcludingUpperLowerShift = 24

// _FoldMapExcludingUpperLower stores the Unicode case-folds for charactecrs that
// have two or more folds, but excludes the uppercase and lowercase forms of the
// character.
var _FoldMapExcludingUpperLower = [256]struct {
	r uint16
	a [2]uint16
}{
	7:   {0x004B, [2]uint16{0x212A, 0x212A}}, // 'K': ['K', 'K']
	185: {0x0053, [2]uint16{0x017F, 0x017F}}, // 'S': ['ſ', 'ſ']
	208: {0x006B, [2]uint16{0x212A, 0x212A}}, // 'k': ['K', 'K']
	130: {0x0073, [2]uint16{0x017F, 0x017F}}, // 's': ['ſ', 'ſ']
	64:  {0x00B5, [2]uint16{0x03BC, 0x03BC}}, // 'µ': ['μ', 'μ']
	165: {0x00C5, [2]uint16{0x212B, 0x212B}}, // 'Å': ['Å', 'Å']
	232: {0x00DF, [2]uint16{0x1E9E, 0x1E9E}}, // 'ß': ['ẞ', 'ẞ']
	110: {0x00E5, [2]uint16{0x212B, 0x212B}}, // 'å': ['Å', 'Å']
	117: {0x0130, [2]uint16{0x0130, 0x0130}}, // 'İ': ['İ', 'İ']
	11:  {0x0131, [2]uint16{0x0131, 0x0131}}, // 'ı': ['ı', 'ı']
	213: {0x017F, [2]uint16{0x0073, 0x0073}}, // 'ſ': ['s', 's']
	87:  {0x01C4, [2]uint16{0x01C5, 0x01C5}}, // 'Ǆ': ['ǅ', 'ǅ']
	237: {0x01C5, [2]uint16{0x01C5, 0x01C5}}, // 'ǅ': ['ǅ', 'ǅ']
	131: {0x01C6, [2]uint16{0x01C5, 0x01C5}}, // 'ǆ': ['ǅ', 'ǅ']
	25:  {0x01C7, [2]uint16{0x01C8, 0x01C8}}, // 'Ǉ': ['ǈ', 'ǈ']
	176: {0x01C8, [2]uint16{0x01C8, 0x01C8}}, // 'ǈ': ['ǈ', 'ǈ']
	70:  {0x01C9, [2]uint16{0x01C8, 0x01C8}}, // 'ǉ': ['ǈ', 'ǈ']
	220: {0x01CA, [2]uint16{0x01CB, 0x01CB}}, // 'Ǌ': ['ǋ', 'ǋ']
	115: {0x01CB, [2]uint16{0x01CB, 0x01CB}}, // 'ǋ': ['ǋ', 'ǋ']
	9:   {0x01CC, [2]uint16{0x01CB, 0x01CB}}, // 'ǌ': ['ǋ', 'ǋ']
	193: {0x01F1, [2]uint16{0x01F2, 0x01F2}}, // 'Ǳ': ['ǲ', 'ǲ']
	88:  {0x01F2, [2]uint16{0x01F2, 0x01F2}}, // 'ǲ': ['ǲ', 'ǲ']
	238: {0x01F3, [2]uint16{0x01F2, 0x01F2}}, // 'ǳ': ['ǲ', 'ǲ']
	89:  {0x0345, [2]uint16{0x03B9, 0x1FBE}}, // 'ͅ': ['ι', 'ι']
	141: {0x0392, [2]uint16{0x03D0, 0x03D0}}, // 'Β': ['ϐ', 'ϐ']
	79:  {0x0395, [2]uint16{0x03F5, 0x03F5}}, // 'Ε': ['ϵ', 'ϵ']
	18:  {0x0398, [2]uint16{0x03D1, 0x03F4}}, // 'Θ': ['ϑ', 'ϴ']
	169: {0x0399, [2]uint16{0x0345, 0x1FBE}}, // 'Ι': ['ͅ', 'ι']
	63:  {0x039A, [2]uint16{0x03F0, 0x03F0}}, // 'Κ': ['ϰ', 'ϰ']
	107: {0x039C, [2]uint16{0x00B5, 0x00B5}}, // 'Μ': ['µ', 'µ']
	197: {0x03A0, [2]uint16{0x03D6, 0x03D6}}, // 'Π': ['ϖ', 'ϖ']
	91:  {0x03A1, [2]uint16{0x03F1, 0x03F1}}, // 'Ρ': ['ϱ', 'ϱ']
	135: {0x03A3, [2]uint16{0x03C2, 0x03C2}}, // 'Σ': ['ς', 'ς']
	74:  {0x03A6, [2]uint16{0x03D5, 0x03D5}}, // 'Φ': ['ϕ', 'ϕ']
	13:  {0x03A9, [2]uint16{0x2126, 0x2126}}, // 'Ω': ['Ω', 'Ω']
	86:  {0x03B2, [2]uint16{0x03D0, 0x03D0}}, // 'β': ['ϐ', 'ϐ']
	24:  {0x03B5, [2]uint16{0x03F5, 0x03F5}}, // 'ε': ['ϵ', 'ϵ']
	219: {0x03B8, [2]uint16{0x03D1, 0x03F4}}, // 'θ': ['ϑ', 'ϴ']
	114: {0x03B9, [2]uint16{0x0345, 0x1FBE}}, // 'ι': ['ͅ', 'ι']
	8:   {0x03BA, [2]uint16{0x03F0, 0x03F0}}, // 'κ': ['ϰ', 'ϰ']
	52:  {0x03BC, [2]uint16{0x00B5, 0x00B5}}, // 'μ': ['µ', 'µ']
	142: {0x03C0, [2]uint16{0x03D6, 0x03D6}}, // 'π': ['ϖ', 'ϖ']
	36:  {0x03C1, [2]uint16{0x03F1, 0x03F1}}, // 'ρ': ['ϱ', 'ϱ']
	186: {0x03C2, [2]uint16{0x03C3, 0x03C3}}, // 'ς': ['σ', 'σ']
	80:  {0x03C3, [2]uint16{0x03C2, 0x03C2}}, // 'σ': ['ς', 'ς']
	19:  {0x03C6, [2]uint16{0x03D5, 0x03D5}}, // 'φ': ['ϕ', 'ϕ']
	214: {0x03C9, [2]uint16{0x2126, 0x2126}}, // 'ω': ['Ω', 'Ω']
	242: {0x03D0, [2]uint16{0x03B2, 0x03B2}}, // 'ϐ': ['β', 'β']
	136: {0x03D1, [2]uint16{0x03B8, 0x03F4}}, // 'ϑ': ['θ', 'ϴ']
	225: {0x03D5, [2]uint16{0x03C6, 0x03C6}}, // 'ϕ': ['φ', 'φ']
	120: {0x03D6, [2]uint16{0x03C0, 0x03C0}}, // 'ϖ': ['π', 'π']
	187: {0x03F0, [2]uint16{0x03BA, 0x03BA}}, // 'ϰ': ['κ', 'κ']
	81:  {0x03F1, [2]uint16{0x03C1, 0x03C1}}, // 'ϱ': ['ρ', 'ρ']
	20:  {0x03F4, [2]uint16{0x0398, 0x03D1}}, // 'ϴ': ['Θ', 'ϑ']
	170: {0x03F5, [2]uint16{0x03B5, 0x03B5}}, // 'ϵ': ['ε', 'ε']
	177: {0x0412, [2]uint16{0x1C80, 0x1C80}}, // 'В': ['ᲀ', 'ᲀ']
	221: {0x0414, [2]uint16{0x1C81, 0x1C81}}, // 'Д': ['ᲁ', 'ᲁ']
	188: {0x041E, [2]uint16{0x1C82, 0x1C82}}, // 'О': ['ᲂ', 'ᲂ']
	127: {0x0421, [2]uint16{0x1C83, 0x1C83}}, // 'С': ['ᲃ', 'ᲃ']
	21:  {0x0422, [2]uint16{0x1C84, 0x1C85}}, // 'Т': ['ᲄ', 'ᲅ']
	199: {0x042A, [2]uint16{0x1C86, 0x1C86}}, // 'Ъ': ['ᲆ', 'ᲆ']
	122: {0x0432, [2]uint16{0x1C80, 0x1C80}}, // 'в': ['ᲀ', 'ᲀ']
	166: {0x0434, [2]uint16{0x1C81, 0x1C81}}, // 'д': ['ᲁ', 'ᲁ']
	133: {0x043E, [2]uint16{0x1C82, 0x1C82}}, // 'о': ['ᲂ', 'ᲂ']
	72:  {0x0441, [2]uint16{0x1C83, 0x1C83}}, // 'с': ['ᲃ', 'ᲃ']
	222: {0x0442, [2]uint16{0x1C84, 0x1C85}}, // 'т': ['ᲄ', 'ᲅ']
	144: {0x044A, [2]uint16{0x1C86, 0x1C86}}, // 'ъ': ['ᲆ', 'ᲆ']
	167: {0x0462, [2]uint16{0x1C87, 0x1C87}}, // 'Ѣ': ['ᲇ', 'ᲇ']
	61:  {0x0463, [2]uint16{0x1C87, 0x1C87}}, // 'ѣ': ['ᲇ', 'ᲇ']
	4:   {0x1C80, [2]uint16{0x0432, 0x0432}}, // 'ᲀ': ['в', 'в']
	154: {0x1C81, [2]uint16{0x0434, 0x0434}}, // 'ᲁ': ['д', 'д']
	48:  {0x1C82, [2]uint16{0x043E, 0x043E}}, // 'ᲂ': ['о', 'о']
	198: {0x1C83, [2]uint16{0x0441, 0x0441}}, // 'ᲃ': ['с', 'с']
	93:  {0x1C84, [2]uint16{0x0442, 0x1C85}}, // 'ᲄ': ['т', 'ᲅ']
	243: {0x1C85, [2]uint16{0x0442, 0x1C84}}, // 'ᲅ': ['т', 'ᲄ']
	137: {0x1C86, [2]uint16{0x044A, 0x044A}}, // 'ᲆ': ['ъ', 'ъ']
	31:  {0x1C87, [2]uint16{0x0463, 0x0463}}, // 'ᲇ': ['ѣ', 'ѣ']
	182: {0x1C88, [2]uint16{0xA64B, 0xA64B}}, // 'ᲈ': ['ꙋ', 'ꙋ']
	203: {0x1E60, [2]uint16{0x1E9B, 0x1E9B}}, // 'Ṡ': ['ẛ', 'ẛ']
	97:  {0x1E61, [2]uint16{0x1E9B, 0x1E9B}}, // 'ṡ': ['ẛ', 'ẛ']
	109: {0x1E9B, [2]uint16{0x1E61, 0x1E61}}, // 'ẛ': ['ṡ', 'ṡ']
	65:  {0x1FBE, [2]uint16{0x0345, 0x03B9}}, // 'ι': ['ͅ', 'ι']
	150: {0x2126, [2]uint16{0x03A9, 0x03A9}}, // 'Ω': ['Ω', 'Ω']
	239: {0x212A, [2]uint16{0x004B, 0x004B}}, // 'K': ['K', 'K']
	134: {0x212B, [2]uint16{0x00C5, 0x00C5}}, // 'Å': ['Å', 'Å']
	32:  {0xA64A, [2]uint16{0x1C88, 0x1C88}}, // 'Ꙋ': ['ᲈ', 'ᲈ']
	183: {0xA64B, [2]uint16{0x1C88, 0x1C88}}, // 'ꙋ': ['ᲈ', 'ᲈ']
}
