/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/


#ifndef PARTICLE_H
#define PARTICLE_H

#include <SDL_opengl.h>

#include "Vector.h"
#include "Game.h"

enum BounceType{
	PARTICLE_BOUNCE_NONE,
	PARTICLE_BOUNCE_SLIDE,
	PARTICLE_BOUNCE_ONE
};
enum DrawType{
	PARTICLE_DRAW_SIMPLE,
	PARTICLE_DRAW_MOTION
};

class Particle{
public:
	Particle();
	void Animate(float dtf);
	int Collide(Game*);
	Vector s;
	Vector v;
	Vector a;
	float res;
	float diffuse;
	BounceType bounce;
	int collide;
	float life;
	float startlife;
	char texfile[128];
	float rad;
	float spinoffset;  //degrees
	float spindir;
	GLenum blendmode;
	DrawType drawmode;
};

#endif //PARTICLE_H
