/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.BaseBuildBean;
import org.jfrog.build.api.BuildAgent;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.Governance;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.LicenseControl;
import org.jfrog.build.api.MatrixParameter;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.Vcs;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.api.release.PromotionStatus;

@XStreamAlias(value="build")
@JsonIgnoreProperties(ignoreUnknown=true)
public class Build
extends BaseBuildBean {
    public static final String STARTED_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private String version = "1.0.1";
    private String name;
    private String number;
    private BuildAgent buildAgent;
    private Agent agent;
    private String started;
    private long durationMillis;
    private String principal;
    private String artifactoryPrincipal;
    private String artifactoryPluginVersion;
    private String url;
    private String parentName;
    private String parentNumber;
    private List<Vcs> vcs;
    @Deprecated
    private String parentBuildId;
    private LicenseControl licenseControl;
    private BuildRetention buildRetention;
    @XStreamAlias(value="runParameters")
    private List<MatrixParameter> runParameters;
    @XStreamAlias(value="modules")
    private List<Module> modules;
    private List<PromotionStatus> statuses;
    private List<BuildDependency> buildDependencies;
    private Issues issues;
    private Governance governance;

    public static String formatBuildStarted(long timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(STARTED_FORMAT);
        return dateFormat.format(timestamp);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentNumber() {
        return this.parentNumber;
    }

    public void setParentNumber(String parentNumber) {
        this.parentNumber = parentNumber;
    }

    public List<Vcs> getVcs() {
        return this.vcs;
    }

    public void setVcs(List<Vcs> vcs) {
        this.vcs = vcs;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    public BuildAgent getBuildAgent() {
        return this.buildAgent;
    }

    public void setBuildAgent(BuildAgent buildAgent) {
        this.buildAgent = buildAgent;
    }

    public String getStarted() {
        return this.started;
    }

    public void setStarted(String started) {
        this.started = started;
    }

    public void setStartedDate(Date startedDate) {
        this.started = Build.formatBuildStarted(startedDate.getTime());
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public void setDurationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getArtifactoryPrincipal() {
        return this.artifactoryPrincipal;
    }

    public void setArtifactoryPrincipal(String artifactoryPrincipal) {
        this.artifactoryPrincipal = artifactoryPrincipal;
    }

    public String getArtifactoryPluginVersion() {
        return this.artifactoryPluginVersion;
    }

    public void setArtifactoryPluginVersion(String artifactoryPluginVersion) {
        this.artifactoryPluginVersion = artifactoryPluginVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Deprecated
    public String getParentBuildId() {
        return this.parentBuildId;
    }

    @Deprecated
    public void setParentBuildId(String parentBuildId) {
        this.parentBuildId = parentBuildId;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public Module getModule(String moduleId) {
        if (this.modules != null) {
            for (Module module : this.modules) {
                if (!module.getId().equals(moduleId)) continue;
                return module;
            }
        }
        return null;
    }

    public LicenseControl getLicenseControl() {
        return this.licenseControl;
    }

    public void setLicenseControl(LicenseControl licenseControl) {
        this.licenseControl = licenseControl;
    }

    public BuildRetention getBuildRetention() {
        return this.buildRetention;
    }

    public void setBuildRetention(BuildRetention buildRetention) {
        this.buildRetention = buildRetention;
    }

    public List<MatrixParameter> getRunParameters() {
        return this.runParameters;
    }

    public void setRunParameters(List<MatrixParameter> runParameters) {
        this.runParameters = runParameters;
    }

    public List<PromotionStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<PromotionStatus> statuses) {
        this.statuses = statuses;
    }

    public void addStatus(PromotionStatus promotionStatus) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<PromotionStatus>();
        }
        this.statuses.add(promotionStatus);
    }

    public List<BuildDependency> getBuildDependencies() {
        return this.buildDependencies;
    }

    public void setBuildDependencies(List<BuildDependency> buildDependencies) {
        this.buildDependencies = buildDependencies;
    }

    public void addBuildDependency(BuildDependency buildDependency) {
        if (this.buildDependencies == null) {
            this.buildDependencies = new ArrayList<BuildDependency>();
        }
        this.buildDependencies.add(buildDependency);
    }

    public Issues getIssues() {
        return this.issues;
    }

    public void setIssues(Issues issues) {
        this.issues = issues;
    }

    public Governance getGovernance() {
        return this.governance;
    }

    public void setGovernance(Governance governance) {
        this.governance = governance;
    }

    public void append(Build other) {
        if (this.buildAgent == null) {
            this.setBuildAgent(other.buildAgent);
        }
        this.appendProperties(other);
        this.appendModules(other);
        this.appendBuildDependencies(other);
        if (this.issues == null) {
            this.issues = other.issues;
            return;
        }
        this.issues.append(other.issues);
    }

    private void appendBuildDependencies(Build other) {
        List<BuildDependency> buildDependencies = other.getBuildDependencies();
        if (buildDependencies != null && buildDependencies.size() > 0) {
            if (this.buildDependencies == null) {
                this.setBuildDependencies(buildDependencies);
            } else {
                this.buildDependencies.addAll(buildDependencies);
            }
        }
    }

    private void appendModules(Build other) {
        List<Module> modules = other.getModules();
        if (modules != null && modules.size() > 0) {
            if (this.getModules() == null) {
                this.setModules(modules);
            } else {
                modules.forEach(this::addModule);
            }
        }
    }

    private void appendProperties(Build other) {
        Properties properties = other.getProperties();
        if (properties != null && properties.size() > 0) {
            if (this.getProperties() == null) {
                this.setProperties(properties);
            } else {
                this.getProperties().putAll((Map<?, ?>)properties);
            }
        }
    }

    private void addModule(Module other) {
        List<Module> modules = this.getModules();
        Module currentModule = modules.stream().filter(module -> StringUtils.equals(module.getId(), other.getId())).findAny().orElse(null);
        if (currentModule == null) {
            modules.add(other);
        } else {
            currentModule.append(other);
        }
    }

    public String toString() {
        return "Build{version='" + this.version + '\'' + ", name='" + this.name + '\'' + ", number='" + this.number + '\'' + ", buildAgent=" + this.buildAgent + ", agent=" + this.agent + ", started='" + this.started + '\'' + ", durationMillis=" + this.durationMillis + ", principal='" + this.principal + '\'' + ", artifactoryPrincipal='" + this.artifactoryPrincipal + '\'' + ", artifactoryPluginVersion='" + this.artifactoryPluginVersion + '\'' + ", url='" + this.url + '\'' + ", parentName='" + this.parentName + '\'' + ", parentNumber='" + this.parentNumber + '\'' + ", vcs='" + this.vcs + '\'' + ", parentBuildId='" + this.parentBuildId + '\'' + ", licenseControl=" + this.licenseControl + ", buildRetention=" + this.buildRetention + ", runParameters=" + this.runParameters + ", modules=" + this.modules + ", statuses=" + this.statuses + ", buildDependencies=" + this.buildDependencies + ", issues=" + this.issues + ", governance=" + this.governance + '}';
    }
}

