/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include "suora_key_relations.h"
#include <gaminggear/hid_uid.h>

// TODO maybe default SuoraKey instead of hid
SuoraKeyRelation const suora_key_relations[SUORA_KEYS_NUM] = {
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID}, /* #0 */
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_1, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_2, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_3, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_4, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_5, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID}, /* #10 */
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_TAB, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_Z, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_X, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_C, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_R, SUORA_KEY_RELATION_INVALID}, /* #20 */
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_T, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_G, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_V, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_Q, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_PRINT_SCREEN, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_MACRO,  HID_UID_KB_HOME, 0}, /* M2 */
	{SUORA_KEY_RELATION_TYPE_MACRO,  HID_UID_KB_DELETE, 1}, /* M4 #30 */
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_H, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_W, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x64, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_SCROLL_LOCK, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_PAUSE, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x31, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_MACRO,  HID_UID_KB_PAGE_UP, 2}, /* M3 */
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_E, SUORA_KEY_RELATION_INVALID}, /* #40 */
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F1, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F5, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_0, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_MACRO,  HID_UID_KB_PAGE_DOWN, 3}, /* M6 */
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_A, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F2, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F6, SUORA_KEY_RELATION_INVALID},  /* #50 */ // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_P, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_NUM_LOCK, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_7, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_4, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_1, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_S, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_ENTER, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F7, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_Y, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_MACRO,  HID_UID_KB_END, 4}, /* M5 #60 */
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_7, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F11, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x34, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_D, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_ESCAPE, SUORA_KEY_RELATION_INVALID}, // uses NORMAL; additionally supports NORMAL; does not support
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F8, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_U, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x2f, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_8, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F12, SUORA_KEY_RELATION_INVALID},  /* #70 */ // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_F, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x35, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F9, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_I, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x30, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_9, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F10, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_VALUE_FN, SUORA_KEY_RELATION_INVALID}, // 10 00 00 00
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_SPACE, SUORA_KEY_RELATION_INVALID}, /* #80 */
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x2d, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_O, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_N, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_UP_ARROW, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x2e, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x38, SUORA_KEY_RELATION_INVALID}, /* #90 */
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_DIV, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_8, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_5, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_2, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_0, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_DOWN_ARROW, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_BACKSPACE, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x36, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_MUL, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_9, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_6, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_3, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_DELETE, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_LEFT_ARROW, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_RIGHT_ALT, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_LEFT_GUI, SUORA_KEY_RELATION_INVALID},// 0b 00 01 00
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_RIGHT_SHIFT, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_M, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F3, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x33, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   HID_UID_KB_F4, SUORA_KEY_RELATION_INVALID}, // uses 10; additionally supports ; does not support NORMAL
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_RIGHT_ARROW, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_RIGHT_CONTROL, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_B, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_J, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_K, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_L, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_6, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_LEFT_SHIFT, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_APPLICATION, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_VALUE_GAME_MODE, SUORA_KEY_RELATION_INVALID}, // 05 00 02 00
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_VALUE_MUTE, SUORA_KEY_RELATION_INVALID}, // uses CONSUMER; additionally supports NORMAL; does not support
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_LEFT_ALT, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_VALUE_VOLUMEDOWN, SUORA_KEY_RELATION_INVALID}, // uses CONSUMER; additionally supports NORMAL; does not support
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_VALUE_VOLUMEUP, SUORA_KEY_RELATION_INVALID}, // uses CONSUMER; additionally supports NORMAL; does not support
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_LEFT_CONTROL, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_MACRO,  HID_UID_KB_INSERT, 5}, /* M1 */
	{SUORA_KEY_RELATION_TYPE_NORMAL, 0x37, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_MINUS, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_PLUS, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KB_CAPS_LOCK, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NORMAL, HID_UID_KP_ENTER, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
	{SUORA_KEY_RELATION_TYPE_NONE,   SUORA_KEY_RELATION_INVALID, SUORA_KEY_RELATION_INVALID},
};

gint suora_key_relation_find_by_macro_index(guint macro_index) {
	guint i;

	for (i = 0; i < SUORA_KEYS_NUM; ++i)
		if ((gint)macro_index == suora_key_relations[i].macro_index)
			return i;
	return SUORA_KEY_RELATION_INVALID;
}
