#################################################
#############       WARNING      ################
#################################################
# This file has been automatically generated.
# Any changes you make here will get overridden.
# Instead, make your changes in templates/*.dat
#################################################
from libcpp.map cimport map
from libcpp.pair cimport pair
from libcpp.vector cimport vector
from libcpp.unordered_map cimport unordered_map
from libcpp cimport bool
from libcpp.string cimport string
from cython.operator cimport dereference as deref

cdef extern from "YODA/Config/YodaConfig.h" namespace "YODA":
     string version()


# Import the error handling C++ routine
cdef extern from "errors.hh":
    # Have a look in errors.cpp for implementation specifics
    void yodaerr "translate_yoda_error" ()

ctypedef map[string, string] Annotations
ctypedef double (*dbl_dbl_fptr) (double)


# Math utils {{{
cdef extern from "YODA/Utils/MathUtils.h" namespace "YODA":
    # bool isZero(double a, double tolerance) except +yodaerr
    # bool fuzzyEquals(double a, double b, double tolerance) except +yodaerr
    # bool fuzzyGtrEquals(double a, double b, double tolerance) except +yodaerr
    # bool fuzzyLessEquals(double a, double b, double tolerance) except +yodaerr
    vector[double] linspace(size_t nbins, double start, double end) except +yodaerr
    vector[double] logspace(size_t nbins, double start, double end) except +yodaerr
    int index_between(double&, vector[double]& binedges) except +yodaerr
    double effNumEntries(vector[double]& weights) except +yodaerr
    double mean(vector[int]& sample) except +yodaerr
    double mean(vector[double]& sample, vector[double]& weights) except +yodaerr
    double variance(vector[double]& sample, vector[double]& weights) except +yodaerr
    double stdDev(vector[double]& sample, vector[double]& weights) except +yodaerr
    double stdErr(vector[double]& sample, vector[double]& weights) except +yodaerr
    double RMS(vector[double]& sample, vector[double]& weights) except +yodaerr
    double covariance(vector[int]& sample1, vector[int]& sample2) except +yodaerr
    double correlation(vector[int]& sample1, vector[int]& sample2) except +yodaerr
    double naiveChi2(vector[double]&, vector[double]&, vector[double]&, vector[double]&) except +yodaerr
    double naiveChi2reduced(vector[double]&, vector[double]&, vector[double]&, vector[double]&) except +yodaerr
# }}}


# Path utils {{{
cdef extern from "YODA/Utils/Paths.h" namespace "YODA":
    string libPath()
    string dataPath()
    string getLibPath()
    string getDataPath()
    vector[string] getYodaDataPath()

# }}}


# Dbn0D {{{
cdef extern from "YODA/Dbn.h" namespace "YODA":
    cdef cppclass Dbn0D:
        Dbn0D ()
        Dbn0D (Dbn0D)

        void fill(double weight, double fraction) except +yodaerr
        #void set(double numEntries, vector[double]& sumW, vector[double]& sumW2) except +yodaerr
        void set(double numEntries, double sumW, double sumW2) except +yodaerr
        void reset() except +yodaerr
        void scaleW(double) except +yodaerr

        # Raw distribution running sums
        double numEntries() except +yodaerr
        double effNumEntries() except +yodaerr
        double sumW() except +yodaerr
        double sumW2() except +yodaerr
        #double sumW(size_t) except +yodaerr
        #double sumW2(size_t) except +yodaerr

        double errW() except +yodaerr
        double relErrW() except +yodaerr
        #double mean(size_t) except +yodaerr
        #double variance(size_t) except +yodaerr
        #double stdDev(size_t) except +yodaerr
        #double stdErr(size_t) except +yodaerr
        #double RMS(size_t) except +yodaerr

        Dbn0D operator+ (Dbn0D)
        Dbn0D operator- (Dbn0D)
        # TODO: += and -= operators

#}}} Dbn0D


# Dbn1D {{{
cdef extern from "YODA/Dbn.h" namespace "YODA":
    cdef cppclass Dbn1D:
        Dbn1D ()
        Dbn1D (Dbn1D)

        void fill(double val, double weight, double fraction) except +yodaerr
        void set(double numEntries, vector[double]& sumW, vector[double]& sumW2) except +yodaerr
        void reset() except +yodaerr
        void scaleW(double) except +yodaerr
        void scale(size_t, double) except +yodaerr

        # Raw distribution running sums
        double numEntries() except +yodaerr
        double effNumEntries() except +yodaerr
        double sumW() except +yodaerr
        double sumW2() except +yodaerr
        double errW() except +yodaerr
        double relErrW() except +yodaerr
        double mean(size_t) except +yodaerr
        double variance(size_t) except +yodaerr
        double stdDev(size_t) except +yodaerr
        double stdErr(size_t) except +yodaerr
        double RMS(size_t) except +yodaerr

        double sumWX() except +yodaerr
        double sumWX2() except +yodaerr

        void scaleX(double)
        double xMean() except +yodaerr
        double xVariance() except +yodaerr
        double xStdDev() except +yodaerr
        double xStdErr() except +yodaerr
        double xRMS() except +yodaerr

        Dbn1D operator+ (Dbn1D)
        Dbn1D operator- (Dbn1D)

#}}} Dbn1D


# Dbn2D {{{
cdef extern from "YODA/Dbn.h" namespace "YODA":
    cdef cppclass Dbn2D:
        Dbn2D ()
        Dbn2D (Dbn2D)

        void fill(double x, double y, double weight, double fraction) except +yodaerr
        void set(double numEntries, vector[double]& sumW, vector[double]& sumW2, vector[double]& sumWcross) except +yodaerr
        void reset() except +yodaerr
        void scaleW(double) except +yodaerr
        void scale(size_t, double)

        double numEntries() except +yodaerr
        double effNumEntries() except +yodaerr
        double sumW() except +yodaerr
        double sumW2() except +yodaerr
        double errW() except +yodaerr
        double relErrW() except +yodaerr
        double mean(size_t) except +yodaerr
        double variance(size_t) except +yodaerr
        double stdDev(size_t) except +yodaerr
        double stdErr(size_t) except +yodaerr
        double RMS(size_t) except +yodaerr


        void scaleX(double) except +yodaerr
        double sumWX() except +yodaerr
        double sumWX2() except +yodaerr
        double xMean() except +yodaerr
        double xVariance() except +yodaerr
        double xStdDev() except +yodaerr
        double xStdErr() except +yodaerr
        double xRMS() except +yodaerr

        void scaleY(double) except +yodaerr
        double sumWY() except +yodaerr
        double sumWY2() except +yodaerr
        double yMean() except +yodaerr
        double yVariance() except +yodaerr
        double yStdDev() except +yodaerr
        double yStdErr() except +yodaerr
        double yRMS() except +yodaerr

        double crossTerm(size_t, size_t) except +yodaerr
        void scaleXY(double, double) except +yodaerr

        Dbn2D operator + (Dbn2D)
        Dbn2D operator - (Dbn2D)
        # TODO: += and -= operators

#}}} Dbn2D


# Dbn3D {{{
cdef extern from "YODA/Dbn.h" namespace "YODA":
    cdef cppclass Dbn3D:
        Dbn3D ()
        Dbn3D (Dbn3D)

        void fill(double x, double y, double z, double weight, double fraction)
        void set(double numEntries, vector[double]& sumW, vector[double]& sumW2, vector[double]& sumWcross) except +yodaerr
        void reset() except +yodaerr
        void scaleW(double) except +yodaerr
        void scale(size_t, double) except +yodaerr

        double numEntries()
        double effNumEntries()
        double sumW()
        double sumW2()
        double errW() except +yodaerr
        double relErrW() except +yodaerr
        double mean(size_t) except +yodaerr
        double variance(size_t) except +yodaerr
        double stdDev(size_t) except +yodaerr
        double stdErr(size_t) except +yodaerr
        double RMS(size_t) except +yodaerr

        # void scaleXY(double, double)
        # void scaleYZ(double, double)
        # void scaleXZ(double, double)
        void scaleXYZ(double, double, double)


        void scaleX(double)
        double sumWX()
        double sumWX2()
        double xMean()
        double xVariance()
        double xStdDev()
        double xStdErr()
        double xRMS()

        void scaleY(double)
        double sumWY()
        double sumWY2()
        double yMean()
        double yVariance()
        double yStdDev()
        double yStdErr()
        double yRMS()

        void scaleZ(double)
        double sumWZ()
        double sumWZ2()
        double zMean()
        double zVariance()
        double zStdDev()
        double zStdErr()
        double zRMS()

        double crossTerm(size_t, size_t) except +yodaerr

        Dbn3D operator + (Dbn3D)
        Dbn3D operator - (Dbn3D)
        # TODO: += and -= operators

#}}} Dbn3D


# Estimate {{{
cdef extern from "YODA/Estimate.h" namespace "YODA":
    cdef cppclass Estimate:
        Estimate () except +yodaerr
        Estimate (double val, pair[double, double]& err, string& source) except +yodaerr
        Estimate (Estimate&) except +yodaerr

        void setVal(double val) except +yodaerr
        void setErr(pair[double, double]& err, string& source) except +yodaerr

        void reset() except +yodaerr

        void scale(double) except +yodaerr

        double val() except +yodaerr
        pair[double,double] errDownUp(string& source) except +yodaerr
        pair[double,double] err(string& source) except +yodaerr
        pair[double,double] errNegPos(string& source) except +yodaerr
        double errNeg(string& source) except +yodaerr
        double errPos(string& source) except +yodaerr
        double errDown(string& source) except +yodaerr
        double errUp(string& source) except +yodaerr
        double errAvg(string& source) except +yodaerr
        double errEnv(string& source) except +yodaerr

        pair[double,double] relErrDownUp(string& source) except +yodaerr
        pair[double,double] relErr(string& source) except +yodaerr
        double relErrDown(string& source) except +yodaerr
        double relErrUp(string& source) except +yodaerr
        double relErrAvg(string& source) except +yodaerr
        double relErrEnv(string& source) except +yodaerr

        double valMax(string& source) except +yodaerr
        double valMin(string& source) except +yodaerr

        pair[double,double] quadSum(string&) except +yodaerr
        double quadSumNeg(string&) except +yodaerr
        double quadSumPos(string&) except +yodaerr
        double quadSumAvg(string&) except +yodaerr
        double quadSumEnv(string&) except +yodaerr
        pair[double,double] totalErr(string&) except +yodaerr
        double totalErrNeg(string&) except +yodaerr
        double totalErrPos(string&) except +yodaerr
        double totalErrAvg(string&) except +yodaerr
        double totalErrEnv(string&) except +yodaerr
        pair[double,double] relTotalErr(string&) except +yodaerr
        double relTotalErrNeg(string&) except +yodaerr
        double relTotalErrPos(string&) except +yodaerr
        double relTotalErrAvg(string&) except +yodaerr
        double relTotalErrEnv(string&) except +yodaerr

        vector[string] sources() except +yodaerr
        size_t numErrs() except +yodaerr
        void rmSource(string&) except +yodaerr
        void rmErrs() except +yodaerr

        void deserializeSources(vector[string]& data) except +yodaerr
        bool hasSource(string&) except +yodaerr

        Estimate operator+ (Estimate&)
        Estimate operator- (Estimate&)
        # TODO: += and -= operators

#}}} Estimate


# Point {{{

cdef extern from "YODA/Point.h" namespace "YODA":
    cdef cppclass Point:

        size_t dim() except +yodaerr

        double val(size_t i) except +yodaerr
        void setVal(size_t i, double val) except +yodaerr
        double max(size_t i) except +yodaerr
        double min(size_t i) except +yodaerr

        #double errMinus(size_t i) except +yodaerr
        #void setErrMinus(size_t i, double eminus) except +yodaerr
        #double errPlus(size_t i) except +yodaerr
        #void setErrPlus(size_t i, double eplus) except +yodaerr
        #double errAvg(size_t i) except +yodaerr

        pair[double,double] errs(size_t i) except +yodaerr
        void setErr(size_t i, double e) except +yodaerr
        # void setErrs(size_t i, double e) except +yodaerr
        # void setErrs(size_t i, double eminus, double eplus) except +yodaerr
        void setErrs(size_t i, pair[double,double]& e) except +yodaerr
        void setErrMinus(size_t i, double eminus) except +yodaerr
        void setErrPlus(size_t i, double eplus) except +yodaerr

        void scaleVal(size_t i, double scale) except +yodaerr
        void scaleErr(size_t i, double scale) except +yodaerr
        void scale(size_t i, double scale) except +yodaerr

#}}} Point


# Point1D {{{
cdef extern from "YODA/Point.h" namespace "YODA":
    cdef cppclass Point1D(Point):
        Point1D () except +yodaerr
        Point1D (Point1D p) except +yodaerr
        Point1D (vector[double]& vals, vector[double]& errdn, vector[double]& errup) except +yodaerr

        void clear() except +yodaerr

        double x() except +yodaerr
        double xMin() except +yodaerr
        double xMax() except +yodaerr
        pair[double,double] xErrs() except +yodaerr
        double xErrMinus() except +yodaerr
        double yErrMinus() except +yodaerr
        double xErrPlus() except +yodaerr
        double yErrPlus() except +yodaerr
        double xErrAvg() except +yodaerr

        void scaleX(double) except +yodaerr
        void scale(size_t i, double scale) except +yodaerr

        void setX(double x) except +yodaerr
        #void set(size_t i, double val, double e) except +yodaerr
        #void set(size_t i, double val, double eminus, double eplus) except +yodaerr
        #void set(size_t i, double val, pair[double,double]& e) except +yodaerr
        void setXErrs(pair[double, double]&) except +yodaerr
        void setXErrs(pair[double, double]&, string source) except +yodaerr

        bool operator == (Point1D) except +yodaerr
        bool operator != (Point1D b) except +yodaerr
        bool operator < (Point1D b) except +yodaerr
        bool operator <= (Point1D b) except +yodaerr
        bool operator > (Point1D b) except +yodaerr
        bool operator >= (Point1D b) except +yodaerr
# }}} Point1D


# Point2D {{{
cdef extern from "YODA/Point.h" namespace "YODA":
    cdef cppclass Point2D(Point):
        Point2D () except +yodaerr
        Point2D (Point2D p) except +yodaerr
        Point2D (vector[double]& vals, vector[double]& errdn, vector[double]& errup) except +yodaerr

        void setX(double x) except +yodaerr
        void setY(double y) except +yodaerr
        pair[double,double] xy() except +yodaerr
        void setXY(pair[double,double]&) except +yodaerr
        void setXErrs(pair[double, double]&) except +yodaerr
        void setYErrs(pair[double, double]&) except +yodaerr

        double x() except +yodaerr
        double y() except +yodaerr
        pair[double,double] xErrs() except +yodaerr
        pair[double,double] yErrs() except +yodaerr
        double xErrMinus() except +yodaerr
        double yErrMinus() except +yodaerr
        double xErrPlus() except +yodaerr
        double yErrPlus() except +yodaerr
        double xErrAvg() except +yodaerr
        double yErrAvg() except +yodaerr

        double xMin() except +yodaerr
        double xMax() except +yodaerr
        double yMin() except +yodaerr
        double yMax() except +yodaerr

        void scaleX(double) except +yodaerr
        void scaleY(double) except +yodaerr
        void scaleXY(double, double) except +yodaerr
        void scale(size_t i, double scale) except +yodaerr

        #void set(size_t i, double val, double e) except +yodaerr
        #void set(size_t i, double val, double eminus, double eplus) except +yodaerr
        #void set(size_t i, double val, pair[double,double]& e) except +yodaerr

        bool operator == (Point2D) except +yodaerr
        bool operator != (Point2D b) except +yodaerr
        bool operator < (Point2D b) except +yodaerr
        bool operator <= (Point2D b) except +yodaerr
        bool operator > (Point2D b) except +yodaerr
        bool operator >= (Point2D b) except +yodaerr
# }}} Point2D


# Point3D {{{
cdef extern from "YODA/Point.h" namespace "YODA":
    cdef cppclass Point3D(Point):
        Point3D () except +yodaerr
        Point3D (Point3D& p) except +yodaerr
        Point3D (vector[double]& vals, vector[double]& errdn, vector[double]& errup) except +yodaerr

        void setX(double x) except +yodaerr
        void setY(double y) except +yodaerr
        void setZ(double z) except +yodaerr
        void setXErrs(pair[double, double]&) except +yodaerr
        void setYErrs(pair[double, double]&) except +yodaerr
        void setZErrs(pair[double, double]&) except +yodaerr

        double x() except +yodaerr
        double y() except +yodaerr
        double z() except +yodaerr
        pair[double,double] xErrs() except +yodaerr
        pair[double,double] yErrs() except +yodaerr
        pair[double,double] zErrs() except +yodaerr
        double xErrMinus() except +yodaerr
        double yErrMinus() except +yodaerr
        double zErrMinus() except +yodaerr
        double xErrPlus() except +yodaerr
        double yErrPlus() except +yodaerr
        double zErrPlus() except +yodaerr
        double xErrAvg()
        double yErrAvg()
        double zErrAvg()

        double xMin() except +yodaerr
        double xMax() except +yodaerr
        double yMin() except +yodaerr
        double yMax() except +yodaerr
        double zMin() except +yodaerr
        double zMax() except +yodaerr

        void scaleX(double) except +yodaerr
        void scaleY(double) except +yodaerr
        void scaleZ(double) except +yodaerr
        void scaleXYZ(double, double, double) except +yodaerr
        void scale(size_t i, double scale) except +yodaerr

        #void set(size_t i, double val, double e) except +yodaerr
        #void set(size_t i, double val, double eminus, double eplus) except +yodaerr
        #void set(size_t i, double val, pair[double,double]& e) except +yodaerr

        bool operator == (Point3D b)
        bool operator != (Point3D b)
        bool operator < (Point3D b)
        bool operator <= (Point3D b)
        bool operator > (Point3D b)
        bool operator >= (Point3D b)
#}}} Point3D


# Point4D {{{
cdef extern from "YODA/Point.h" namespace "YODA":
    cdef cppclass Point4D(Point):
        Point4D () except +yodaerr
        Point4D (Point4D& p) except +yodaerr
        Point4D (vector[double]& vals, vector[double]& errdn, vector[double]& errup) except +yodaerr

        void scale(size_t i, double scale) except +yodaerr

        #void set(size_t i, double val, double e) except +yodaerr
        #void set(size_t i, double val, double eminus, double eplus) except +yodaerr
        #void set(size_t i, double val, pair[double,double]& e) except +yodaerr

        bool operator == (Point4D b)
        bool operator != (Point4D b)
        bool operator < (Point4D b)
        bool operator <= (Point4D b)
        bool operator > (Point4D b)
        bool operator >= (Point4D b)
#}}} Point4D



# XAxisMixin {{{
cdef extern from "YODA/Utils/BinnedUtils.h" namespace "YODA":
    cdef cppclass XAxisMixin[T]:
        size_t numBinsX(bool) except +yodaerr
        vector[T] xEdges(bool) except +yodaerr
        vector[T] xWidths(bool) except +yodaerr
        double xMin() except +yodaerr
        double xMax() except +yodaerr

        void rebinXBy(unsigned int n, size_t begin, size_t end) except +yodaerr
        void rebinXTo(vector[double]& edges) except +yodaerr

        double xMean(bool) except +yodaerr
        double xVariance(bool) except +yodaerr
        double xStdDev(bool) except +yodaerr
        double xStdErr(bool) except +yodaerr
        double xRMS(bool) except +yodaerr

#}}} XAxisMixin

# YAxisMixin {{{
cdef extern from "YODA/Utils/BinnedUtils.h" namespace "YODA":
    cdef cppclass YAxisMixin[T]:
        size_t numBinsY(bool) except +yodaerr
        vector[T] yEdges(bool) except +yodaerr
        vector[T] yWidths(bool) except +yodaerr
        double yMin() except +yodaerr
        double yMax() except +yodaerr

        void rebinYBy(unsigned int n, size_t begin, size_t end) except +yodaerr
        void rebinYTo(vector[double]& edges) except +yodaerr

        double yMean(bool) except +yodaerr
        double yVariance(bool) except +yodaerr
        double yStdDev(bool) except +yodaerr
        double yStdErr(bool) except +yodaerr
        double yRMS(bool) except +yodaerr

#}}} YAxisMixin

# ZAxisMixin {{{
cdef extern from "YODA/Utils/BinnedUtils.h" namespace "YODA":
    cdef cppclass ZAxisMixin[T]:
        size_t numBinsZ(bool) except +yodaerr
        vector[T] zEdges(bool) except +yodaerr
        vector[T] zWidths(bool) except +yodaerr
        double zMin() except +yodaerr
        double zMax() except +yodaerr

        void rebinZBy(unsigned int n, size_t begin, size_t end) except +yodaerr
        void rebinZTo(vector[double]& edges) except +yodaerr

        double zMean(bool) except +yodaerr
        double zVariance(bool) except +yodaerr
        double zStdDev(bool) except +yodaerr
        double zStdErr(bool) except +yodaerr
        double zRMS(bool) except +yodaerr

#}}} ZAxisMixin


# AnalysisObject {{{
cdef extern from "YODA/AnalysisObject.h" namespace "YODA":
    cdef cppclass AnalysisObject:
        # Constructors
        AnalysisObject(string type, string path, string title) except +yodaerr
        AnalysisObject(string type, string path, AnalysisObject ao, string title) except +yodaerr
        AnalysisObject()
        #AnalysisObject* newclone() except +yodaerr

        ## String used in automatic type determination
        string type() except +yodaerr

        ## Axis config where applicable
        string _config() except +yodaerr

        ## Data object fill- or plot-space dimension
        int dim() except +yodaerr

        ## Annotations
        vector[string] annotations() except +yodaerr
        bool hasAnnotation(string key) except +yodaerr
        string annotation(string key) except +yodaerr
        string annotation(string key, string default) except +yodaerr
        void setAnnotation(string, string) except +yodaerr
        void rmAnnotation(string name) except +yodaerr
        void clearAnnotations() except +yodaerr

        ## (De-)Serialization
        size_t lengthContent(bool) except +yodaerr
        vector[double] serializeContent(bool) except +yodaerr
        void deserializeContent(vector[double]& data) except +yodaerr
        size_t lengthMeta(bool, bool) except +yodaerr
        vector[string] serializeMeta(bool, bool) except +yodaerr
        void deserializeMeta(vector[string]& data, bool, bool) except +yodaerr

        ## Standard annotations
        string title() except +yodaerr
        void setTitle(string title) except +yodaerr
        string path() except +yodaerr
        void setPath(string title) except +yodaerr
        string name() except +yodaerr
# }}} AnalysisObject


# Fillable {{{
cdef extern from "YODA/Fillable.h" namespace "YODA":
    cdef cppclass Fillable:

        size_t numBins(bool, bool) except +yodaerr
        size_t fillDim() except +yodaerr
        size_t binDim() except +yodaerr

        double numEntries(bool) except +yodaerr
        double effNumEntries(bool) except +yodaerr
        double sumW(bool) except +yodaerr
        double sumW2(bool) except +yodaerr
        double sumWA(size_t, bool) except +yodaerr
        double sumWA2(size_t, bool) except +yodaerr
        double integral(bool) except +yodaerr
        double integralError(bool) except +yodaerr
        double dVol(bool) except +yodaerr
        double density(bool) except +yodaerr
        double densityError(bool) except +yodaerr
        double densitySum(bool) except +yodaerr
        double maxDensity(bool) except +yodaerr

        void normalize(double normto, bool includeoverflows) except +yodaerr
        void scaleW(double scalefactor) except +yodaerr

#}}} Fillable

# Scatter {{{
cdef extern from "YODA/Scatter.h" namespace "YODA":
    cdef cppclass Scatter:

        size_t numPoints() except +yodaerr

        vector[double] vals(size_t) except +yodaerr
        vector[double] mins(size_t) except +yodaerr
        vector[double] maxs(size_t) except +yodaerr
        vector[double] errAvgs(size_t) except +yodaerr
        vector[pair[double,double]] errs(size_t) except +yodaerr

        void scale(size_t i, double factor) except +yodaerr
        void scaleVal(size_t i, double factor) except +yodaerr
        void scaleErr(size_t i, double factor) except +yodaerr

#}}} Scatter


cdef extern from "YODA/Utils/sortedvector.h" namespace "YODA::Utils":
    cdef cppclass sortedvector[T](vector):
        sortedvector(vector[T]) except +yodaerr
        void insert(T) except +yodaerr


# Scatter1D {{{
cdef extern from "YODA/Scatter.h" namespace "YODA":
    cdef cppclass Scatter1D(AnalysisObject,Scatter):
        Scatter1D() except +yodaerr
        Scatter1D(string path, string title) except +yodaerr
        Scatter1D(Scatter1D p, string path)

        Scatter1D clone() except +yodaerr
        Scatter1D* newclone() except +yodaerr

        void reset() except +yodaerr

        vector[Point1D]& points() except +yodaerr
        Point1D& point(size_t index) except +yodaerr

        void addPoint(Point1D&) except +yodaerr
        #void addPoints(sortedvector[Point1D]&) except +yodaerr

        void rmPoint(size_t) except +yodaerr
        void rmPoints(vector[size_t]) except +yodaerr

        void combineWith(Scatter1D&) except +yodaerr
        void combineWith(vector[Scatter1D]&) except +yodaerr

        vector[pair[double,double]] edges(size_t) except +yodaerr

        vector[double] xVals() except +yodaerr
        vector[double] xMins() except +yodaerr
        vector[double] xMaxs() except +yodaerr
        double xMin() except +yodaerr
        double xMax() except +yodaerr
        vector[pair[double,double]] xErrs() except +yodaerr
        vector[double] xErrAvgs() except +yodaerr

#}}} Scatter1D


# Scatter2D {{{
cdef extern from "YODA/Scatter.h" namespace "YODA":
    cdef cppclass Scatter2D(AnalysisObject,Scatter):
        Scatter2D() except +yodaerr
        Scatter2D(string path, string title) except +yodaerr
        Scatter2D(Scatter2D p, string path)

        Scatter2D clone() except +yodaerr
        Scatter2D* newclone() except +yodaerr

        void reset() except +yodaerr

        vector[Point2D]& points() except +yodaerr
        Point2D& point(size_t index) except +yodaerr

        void addPoint(Point2D&) except +yodaerr
        #void addPoints(sortedvector[Point2D]&) except +yodaerr

        void rmPoint(size_t) except +yodaerr
        void rmPoints(vector[size_t]) except +yodaerr

        void combineWith(Scatter2D&) except +yodaerr
        void combineWith(vector[Scatter2D]&) except +yodaerr

        #void scaleX(double) except +yodaerr
        #void scaleY(double) except +yodaerr
        #void scaleXY(double, double) except +yodaerr
        vector[pair[double,double]] edges(size_t) except +yodaerr

        vector[double] xVals() except +yodaerr
        vector[double] xMins() except +yodaerr
        vector[double] xMaxs() except +yodaerr
        vector[double] yVals() except +yodaerr
        vector[double] yMins() except +yodaerr
        vector[double] yMaxs() except +yodaerr
        double xMin() except +yodaerr
        double xMax() except +yodaerr
        double yMin() except +yodaerr
        double yMax() except +yodaerr
        vector[pair[double,double]] xErrs() except +yodaerr
        vector[pair[double,double]] yErrs() except +yodaerr
        vector[double] xErrAvgs() except +yodaerr
        vector[double] yErrAvgs() except +yodaerr

    #void Scatter2D_transformX "YODA::transformX" (Scatter2D&, dbl_dbl_fptr)
    #void Scatter2D_transformY "YODA::transformY" (Scatter2D&, dbl_dbl_fptr)

#}}} Scatter2D


# Scatter3D {{{
cdef extern from "YODA/Scatter.h" namespace "YODA":
    cdef cppclass Scatter3D(AnalysisObject,Scatter):
        Scatter3D() except +yodaerr
        Scatter3D(string path, string title) except +yodaerr
        Scatter3D(Scatter3D p, string path)

        Scatter3D clone() except +yodaerr
        Scatter3D* newclone() except +yodaerr

        void reset() except +yodaerr

        sortedvector[Point3D]& points() except +yodaerr
        Point3D& point(size_t index) except +yodaerr

        void addPoint(Point3D&) except +yodaerr
        #void addPoints(sortedvector[Point3D]&) except +yodaerr

        void rmPoint(size_t) except +yodaerr
        void rmPoints(vector[size_t]) except +yodaerr

        void combineWith(Scatter3D&) except +yodaerr
        void combineWith(vector[Scatter3D]&) except +yodaerr

        #void scaleX(double) except +yodaerr
        #void scaleY(double) except +yodaerr
        #void scaleZ(double) except +yodaerr
        #void scaleXYZ(double, double, double) except +yodaerr
        vector[pair[double,double]] edges(size_t) except +yodaerr

        vector[double] xVals() except +yodaerr
        vector[double] xMins() except +yodaerr
        vector[double] xMaxs() except +yodaerr
        vector[double] yVals() except +yodaerr
        vector[double] yMins() except +yodaerr
        vector[double] yMaxs() except +yodaerr
        vector[double] zVals() except +yodaerr
        vector[double] zMins() except +yodaerr
        vector[double] zMaxs() except +yodaerr
        double xMin() except +yodaerr
        double xMax() except +yodaerr
        double yMin() except +yodaerr
        double yMax() except +yodaerr
        double zMin() except +yodaerr
        double zMax() except +yodaerr
        vector[pair[double,double]] xErrs() except +yodaerr
        vector[pair[double,double]] yErrs() except +yodaerr
        vector[pair[double,double]] zErrs() except +yodaerr
        vector[double] xErrAvgs() except +yodaerr
        vector[double] yErrAvgs() except +yodaerr
        vector[double] zErrAvgs() except +yodaerr

    #void Scatter3D_transformX "YODA::transformX" (Scatter3D&, dbl_dbl_fptr)
    #void Scatter3D_transformY "YODA::transformY" (Scatter3D&, dbl_dbl_fptr)
    #void Scatter3D_transformZ "YODA::transformZ" (Scatter3D&, dbl_dbl_fptr)

#}}} Scatter3D


# Scatter4D {{{
cdef extern from "YODA/Scatter.h" namespace "YODA":
    cdef cppclass Scatter4D(AnalysisObject,Scatter):
        Scatter4D() except +yodaerr
        Scatter4D(string path, string title) except +yodaerr
        Scatter4D(Scatter4D p, string path)

        Scatter4D clone() except +yodaerr
        Scatter4D* newclone() except +yodaerr

        void reset() except +yodaerr

        sortedvector[Point4D]& points() except +yodaerr
        Point4D& point(size_t index) except +yodaerr

        void addPoint(Point4D&) except +yodaerr
        #void addPoints(sortedvector[Point3D]&) except +yodaerr

        void rmPoint(size_t) except +yodaerr
        void rmPoints(vector[size_t]) except +yodaerr

        void combineWith(Scatter4D&) except +yodaerr
        void combineWith(vector[Scatter4D]&) except +yodaerr

        #void scaleX(double) except +yodaerr
        #void scaleY(double) except +yodaerr
        #void scaleZ(double) except +yodaerr
        #void scaleXYZ(double, double, double) except +yodaerr
        vector[pair[double,double]] edges(size_t) except +yodaerr

#}}} Scatter4D


# Estimate0D {{{
cdef extern from "YODA/Estimate0D.h" namespace "YODA":
    cdef cppclass Estimate0D(AnalysisObject,Estimate):
        Estimate0D(string& path, string& title) except +yodaerr
        Estimate0D (double val, pair[double, double]& err, string& source, string& path, string& title) except +yodaerr
        Estimate0D (Estimate0D&) except +yodaerr

        Estimate0D clone() except +yodaerr
        Estimate0D* newclone() except +yodaerr

        Scatter1D mkScatter(string&, string&) except +yodaerr

#}}} Estimate0D

cdef extern from "merge.hh":
    void Estimate0D_iadd_Estimate0D "cython_iadd" (Estimate0D*, Estimate0D*)
    void Estimate0D_isub_Estimate0D "cython_isub" (Estimate0D*, Estimate0D*)
    Estimate0D* Estimate0D_add_Estimate0D "cython_add" (Estimate0D*, Estimate0D*)
    Estimate0D* Estimate0D_sub_Estimate0D "cython_sub" (Estimate0D*, Estimate0D*)
    Estimate0D* Estimate0D_div_Estimate0D "cython_div" (Estimate0D*, Estimate0D*)
    Estimate0D* Estimate0D_eff_Estimate0D "cython_eff" (Estimate0D*, Estimate0D*)


# Counter {{{
cdef extern from "YODA/Counter.h" namespace "YODA":
    cdef cppclass Counter(AnalysisObject,Fillable):
        Counter(string& path, string& title) except +yodaerr

        Counter(Counter& c, string path)

        Counter clone() except +yodaerr
        Counter* newclone() except +yodaerr

        void reset() except +yodaerr

        int fill(double weight, double fraction) except +yodaerr
        void set(double numEntries, double sumW, double sumW2) except +yodaerr

        unsigned long numEntries() except +yodaerr
        double effNumEntries() except +yodaerr

        double sumW() except +yodaerr
        double sumW2() except +yodaerr

        double val() except +yodaerr
        double err() except +yodaerr
        double relErr() except +yodaerr

        Estimate0D mkEstimate(string&) except +yodaerr
        Scatter1D mkScatter(string&) except +yodaerr

        # operator += (Counter)
        # operator -= (Counter)

#}}} Counter

cdef extern from "merge.hh":
    void Counter_iadd_Counter "cython_iadd" (Counter*, Counter*)
    void Counter_isub_Counter "cython_isub" (Counter*, Counter*)
    Counter* Counter_add_Counter "cython_add" (Counter*, Counter*)
    Counter* Counter_sub_Counter "cython_sub" (Counter*, Counter*)
    Estimate0D* Counter_div_Counter "cython_div" (Counter*, Counter*)
    Estimate0D* Counter_eff_Counter "cython_eff" (Counter*, Counter*)
    Estimate0D* Counter_est "cython_est" (Counter*, string&, string&)


# Axis {{{
cdef extern from "YODA/BinnedAxis.h" namespace "YODA":
    cdef cppclass Axis[T]:
        Axis() except +yodaerr
        Axis(vector[T]& edges) except +yodaerr

        size_t numBins(bool) except +yodaerr
        size_t index(T& x) except +yodaerr
        string type() except +yodaerr

        T width(size_t) except +yodaerr
        T max(size_t) except +yodaerr
        T min(size_t) except +yodaerr
        T mid(size_t) except +yodaerr
        T edge(size_t) except +yodaerr

#}}} Axis

# BinnedHisto1D {{{
cdef extern from "YODA/Histo.h" namespace "YODA":
    cdef cppclass BinnedHisto1D[A1](AnalysisObject,Fillable,XAxisMixin[A1]):
        BinnedHisto1D() except +yodaerr

        BinnedHisto1D(vector[A1]& binedges,
                      string& path,
                      string& title) except +yodaerr

        BinnedHisto1D(BinnedHisto1D[A1] &h) except +yodaerr

        BinnedHisto1D[A1] clone() except +yodaerr
        BinnedHisto1D[A1]* newclone() except +yodaerr


        void reset() except +yodaerr

        int fill(A1 x, double weight, double fraction) except +yodaerr

        #void mergeBins(size_t, size_t) except +yodaerr

        vector[Dbn1D]& bins()
        Dbn1D& bin(size_t ix) except +yodaerr
        Dbn1D& binAt(A1 x) except +yodaerr
        size_t indexAt(A1 x) except +yodaerr
        void set(size_t, Dbn1D&) except +yodaerr
        bool isMasked(size_t) except +yodaerr
        bool isVisible(size_t) except +yodaerr

        # Whole histo data
        #double integralTo(int, bool) except +yodaerr
        #double integralRange(int, int) except +yodaerr

        vector[size_t] _global2local(size_t) except +yodaerr
        size_t _local2global(vector[size_t]&) except +yodaerr

        BinnedEstimate1D[A1] mkEstimate(string&, string&, bool) except +yodaerr
        Scatter2D mkScatter(string&, bool, bool, bool, bool) except +yodaerr

        void maskBin(size_t index, bool status) except +yodaerr
        void maskSlice(size_t, size_t, bool) except +yodaerr
        vector[size_t] maskedBins() except +yodaerr

        operator == (BinnedHisto1D[A1])
        operator != (BinnedHisto1D[A1])

#}}} BinnedHisto1D


# BinnedHisto2D {{{
cdef extern from "YODA/Histo.h" namespace "YODA":
    cdef cppclass BinnedHisto2D[A1,A2](AnalysisObject,Fillable,XAxisMixin[A1],YAxisMixin[A2]):
        BinnedHisto2D() except +yodaerr

        BinnedHisto2D(vector[A1]& xedges, vector[A2]& yedges,
                      string path, string title) except +yodaerr

        BinnedHisto2D(BinnedHisto2D[A1,A2]& h)

        BinnedHisto2D[A1,A2] clone() except +yodaerr
        BinnedHisto2D[A1,A2]* newclone() except +yodaerr

        void reset() except +yodaerr

        int fill(A1 x, A2 y, double weight, double fraction) except +yodaerr

        vector[Dbn2D]& bins() except +yodaerr
        Dbn2D& bin(size_t ix) except +yodaerr
        Dbn2D& binAt(A1 x, A2 y) except +yodaerr
        size_t indexAt(A1 x, A2 y) except +yodaerr
        void set(size_t, Dbn2D&) except +yodaerr
        bool isMasked(size_t) except +yodaerr
        bool isVisible(size_t) except +yodaerr

        vector[size_t] _global2local(size_t) except +yodaerr
        size_t _local2global(vector[size_t]&) except +yodaerr

        BinnedEstimate2D[A1,A2] mkEstimate(string&, string&, bool) except +yodaerr
        Scatter3D mkScatter(string&, bool, bool, bool, bool) except +yodaerr

        void maskBin(size_t index, bool status) except +yodaerr
        void maskSlice(size_t, size_t, bool) except +yodaerr
        vector[size_t] maskedBins() except +yodaerr

        operator == (BinnedHisto2D[A1,A2])
        operator != (BinnedHisto2D[A1,A2])

# BinnedHisto2D }}}


# BinnedHisto3D {{{
cdef extern from "YODA/Histo.h" namespace "YODA":
    cdef cppclass BinnedHisto3D[A1,A2,A3](AnalysisObject,Fillable,XAxisMixin[A1],YAxisMixin[A2],ZAxisMixin[A3]):
        BinnedHisto3D() except +yodaerr

        BinnedHisto3D(vector[A1]& xedges, vector[A2]& yedges, vector[A3]& zedges,
                      string path, string title) except +yodaerr

        BinnedHisto3D(BinnedHisto3D[A1,A2,A3]& h)

        BinnedHisto3D[A1,A2,A3] clone() except +yodaerr
        BinnedHisto3D[A1,A2,A3]* newclone() except +yodaerr

        void reset() except +yodaerr

        int fill(A1 x, A2 y, A3 z, double weight, double fraction) except +yodaerr

        # void mergeBins(size_t, size_t) except +yodaerr

        vector[Dbn3D]& bins() except +yodaerr
        Dbn3D& bin(size_t ix) except +yodaerr
        Dbn3D& binAt(A1 x, A2 y, A3 z) except +yodaerr
        size_t indexAt(A1 x, A2 y, A3 z) except +yodaerr
        void set(size_t, Dbn3D&) except +yodaerr
        bool isMasked(size_t) except +yodaerr
        bool isVisible(size_t) except +yodaerr

        vector[size_t] _global2local(size_t) except +yodaerr
        size_t _local2global(vector[size_t]&) except +yodaerr

        BinnedEstimate3D[A1,A2,A3] mkEstimate(string&, string&, bool) except +yodaerr
        Scatter4D mkScatter(string&, bool, bool, bool, bool) except +yodaerr

        void maskBin(size_t index, bool status) except +yodaerr
        void maskSlice(size_t, size_t, bool) except +yodaerr
        vector[size_t] maskedBins() except +yodaerr

        operator == (BinnedHisto3D[A1,A2,A3])
        operator != (BinnedHisto3D[A1,A2,A3])

# BinnedHisto3D }}}


# BinnedProfile1D {{{
cdef extern from "YODA/Profile.h" namespace "YODA":
    cdef cppclass BinnedProfile1D[A1](AnalysisObject,Fillable,XAxisMixin[A1]):
        BinnedProfile1D() except +yodaerr

        BinnedProfile1D(vector[A1]& edges, string path, string title) except +yodaerr

        BinnedProfile1D(BinnedProfile1D[A1]& p) except +yodaerr

        BinnedProfile1D[A1] clone() except +yodaerr
        BinnedProfile1D[A1]* newclone() except +yodaerr

        void reset() except +yodaerr

        int fill(A1 x, double y, double weight, double fraction) except +yodaerr

        #void mergeBins(size_t, size_t) except +yodaerr

        vector[Dbn2D]& bins() except +yodaerr
        Dbn2D& bin(size_t ix) except +yodaerr
        Dbn2D& binAt(A1 x) except +yodaerr
        size_t indexAt(A1 x) except +yodaerr
        void set(size_t, Dbn2D&) except +yodaerr
        bool isMasked(size_t) except +yodaerr
        bool isVisible(size_t) except +yodaerr

        vector[size_t] _global2local(size_t) except +yodaerr
        size_t _local2global(vector[size_t]&) except +yodaerr

        BinnedEstimate1D[A1] mkEstimate(string&, string&, bool) except +yodaerr
        Scatter2D mkScatter(string&, bool, bool, bool, bool) except +yodaerr
        BinnedHisto1D[A1] mkHisto(string&) except +yodaerr

        void maskBin(size_t index, bool status) except +yodaerr
        void maskSlice(size_t, size_t, bool) except +yodaerr
        vector[size_t] maskedBins() except +yodaerr

        operator == (BinnedProfile1D[A1])
        operator != (BinnedProfile1D[A1])

#}}} BinnedProfile1D



# BinnedProfile2D {{{
cdef extern from "YODA/Profile.h" namespace "YODA":
    cdef cppclass BinnedProfile2D[A1,A2](AnalysisObject,Fillable,XAxisMixin[A1],YAxisMixin[A2]):
        BinnedProfile2D() except +yodaerr

        BinnedProfile2D(vector[A1]& xedges, vector[A2]& yedges,
                        string path, string title) except +yodaerr

        BinnedProfile2D(BinnedProfile2D[A1,A2]& p) except +yodaerr

        BinnedProfile2D clone() except +yodaerr
        BinnedProfile2D* newclone() except +yodaerr

        # TODO: add missing functions and enable refs + exceptions when Cython allows

        void reset() except +yodaerr

        int fill(A1 x, A2 y, double z, double weight, double fraction) except +yodaerr

        # void mergeBins(size_t, size_t) except +yodaerr

        vector[Dbn3D]& bins() except +yodaerr
        Dbn3D& bin(size_t ix) except +yodaerr
        Dbn3D& binAt(A1 x, A2 y) except +yodaerr
        size_t indexAt(A1 x, A2 y) except +yodaerr
        void set(size_t, Dbn3D&) except +yodaerr
        bool isMasked(size_t) except +yodaerr
        bool isVisible(size_t) except +yodaerr

        vector[size_t] _global2local(size_t) except +yodaerr
        size_t _local2global(vector[size_t]&) except +yodaerr

        BinnedEstimate2D[A1,A2] mkEstimate(string&, string&, bool) except +yodaerr
        Scatter3D mkScatter(string&, bool, bool, bool, bool) except +yodaerr
        BinnedHisto2D[A1,A2] mkHisto(string&) except +yodaerr

        void maskBin(size_t index, bool status) except +yodaerr
        void maskSlice(size_t, size_t, bool) except +yodaerr
        vector[size_t] maskedBins() except +yodaerr

        operator == (BinnedProfile2D[A1,A2])
        operator != (BinnedProfile2D[A1,A2])

#}}} BinnedProfile2D


# BinnedEstimate1D {{{
cdef extern from "YODA/BinnedEstimate.h" namespace "YODA":
    cdef cppclass BinnedEstimate1D[A1](AnalysisObject, XAxisMixin[A1]):
        BinnedEstimate1D() except +yodaerr
        BinnedEstimate1D(vector[A1]& edges, string path, string title) except +yodaerr
        BinnedEstimate1D(BinnedEstimate1D[A1]& p) except +yodaerr

        BinnedEstimate1D[A1] clone() except +yodaerr
        BinnedEstimate1D[A1]* newclone() except +yodaerr

        void reset() except +yodaerr

        size_t binDim() except +yodaerr
        size_t numBins(bool, bool) except +yodaerr

        void scale(double factor) except +yodaerr

        vector[Estimate]& bins() except +yodaerr
        Estimate& bin(size_t index) except +yodaerr
        Estimate& binAt(A1 x) except +yodaerr
        size_t indexAt(A1 x) except +yodaerr
        void set(size_t, Estimate&) except +yodaerr
        bool isMasked(size_t) except +yodaerr
        bool isVisible(size_t) except +yodaerr

        vector[size_t] _global2local(size_t) except +yodaerr
        size_t _local2global(vector[size_t]&) except +yodaerr

        vector[string] sources() except +yodaerr
        double areaUnderCurve(bool,bool,bool)

        vector[vector[double]] covarianceMatrix(bool,bool,bool,string) except +yodaerr

        Scatter2D mkScatter(string&, string&, bool, bool) except +yodaerr

        void maskBin(size_t index, bool status) except +yodaerr
        void maskSlice(size_t, size_t, bool) except +yodaerr
        vector[size_t] maskedBins() except +yodaerr

        operator == (BinnedEstimate1D[A1])
        operator != (BinnedEstimate1D[A1])

#}}} BinnedEstimate1D


cdef extern from "YODA/BinnedEstimate.h" namespace "YODA":
    cdef cppclass BinnedEstimate2D[A1,A2](AnalysisObject, XAxisMixin[A1], YAxisMixin[A2]):
        BinnedEstimate2D() except +yodaerr
        BinnedEstimate2D(vector[A1]& xedges, vector[A2]& yedges, string path, string title) except +yodaerr
        BinnedEstimate2D(BinnedEstimate2D[A1,A2]& p) except +yodaerr

        BinnedEstimate2D[A1,A2] clone() except +yodaerr
        BinnedEstimate2D[A1,A2]* newclone() except +yodaerr

        void reset() except +yodaerr

        size_t binDim() except +yodaerr
        size_t numBins(bool, bool) except +yodaerr

        void scale(double factor) except +yodaerr

        # TODO: have to ignore exception handling on ref-returning methods until Cython bug is fixed
        vector[Estimate]& bins() except +yodaerr
        Estimate& bin(size_t index) except +yodaerr
        Estimate& binAt(A1 x, A2 y) except +yodaerr
        size_t indexAt(A1 x, A2 y) except +yodaerr
        void set(size_t, Estimate&) except +yodaerr
        bool isMasked(size_t) except +yodaerr
        bool isVisible(size_t) except +yodaerr

        vector[size_t] _global2local(size_t) except +yodaerr
        size_t _local2global(vector[size_t]&) except +yodaerr

        vector[string] sources() except +yodaerr

        double areaUnderCurve(bool,bool,bool)

        vector[vector[double]] covarianceMatrix(bool,bool,bool,string) except +yodaerr

        Scatter3D mkScatter(string&, string&, bool, bool) except +yodaerr

        void maskBin(size_t index, bool status) except +yodaerr
        void maskSlice(size_t, size_t, bool) except +yodaerr
        vector[size_t] maskedBins() except +yodaerr

        operator == (BinnedEstimate2D[A1,A2])
        operator != (BinnedEstimate2D[A1,A2])

#}}} BinnedEstimate2D


# BinnedEstimate3D {{{
cdef extern from "YODA/BinnedEstimate.h" namespace "YODA":
    cdef cppclass BinnedEstimate3D[A1,A2,A3](AnalysisObject, XAxisMixin[A1], YAxisMixin[A2], ZAxisMixin[A3]):
        BinnedEstimate3D() except +yodaerr
        BinnedEstimate3D(vector[A1]& xedges, vector[A2]& yedges, vector[A3]& zedges, string path, string title) except +yodaerr
        BinnedEstimate3D(BinnedEstimate3D[A1,A2,A3]& p) except +yodaerr

        BinnedEstimate3D[A1,A2,A3] clone() except +yodaerr
        BinnedEstimate3D[A1,A2,A3]* newclone() except +yodaerr

        void reset() except +yodaerr

        size_t binDim() except +yodaerr
        size_t numBins(bool, bool) except +yodaerr

        void scale(double factor) except +yodaerr

        # TODO: have to ignore exception handling on ref-returning methods until Cython bug is fixed
        vector[Estimate]& bins() except +yodaerr
        Estimate& bin(size_t index) except +yodaerr
        Estimate& binAt(A1 x, A2 y, A3 z) except +yodaerr
        size_t indexAt(A1 x, A2 y, A3 z) except +yodaerr
        void set(size_t, Estimate&) except +yodaerr
        bool isMasked(size_t) except +yodaerr
        bool isVisible(size_t) except +yodaerr

        vector[size_t] _global2local(size_t) except +yodaerr
        size_t _local2global(vector[size_t]&) except +yodaerr

        vector[string] sources() except +yodaerr

        double areaUnderCurve(bool,bool,bool)

        vector[vector[double]] covarianceMatrix(bool,bool,bool,string) except +yodaerr

        Scatter4D mkScatter(string&, string&, bool, bool) except +yodaerr

        void maskBin(size_t index, bool status) except +yodaerr
        void maskSlice(size_t, size_t, bool) except +yodaerr
        vector[size_t] maskedBins() except +yodaerr

        operator == (BinnedEstimate3D[A1,A2,A3])
        operator != (BinnedEstimate3D[A1,A2,A3])

#}}} BinnedEstimate3D


# Streams {{{

cdef extern from "<iostream>" namespace "std":
    cdef cppclass istream:
        istringstream()
        string& str(string&)

cdef extern from "<sstream>" namespace "std":
    cdef cppclass istringstream:
        istringstream()
        string& str(string&)
    cdef cppclass ostringstream:
        ostringstream()
        string& str()


cdef extern from "YODA/IO.h" namespace "YODA":
    void IO_read_from_file "YODA::read" (string&, vector[AnalysisObject*]&, string&, string&) except +yodaerr
    void IO_read_from_stream "YODA::read" (istream&, vector[AnalysisObject*]& aos, string&, string&, string&) except +yodaerr
    void IO_read_from_stringstream "YODA::read" (istringstream&, vector[AnalysisObject*]& aos, string&, string&, string&) except +yodaerr

cdef extern from "YODA/Reader.h" namespace "YODA":
    cdef cppclass Reader:
        void read(istringstream&, vector[AnalysisObject*]&, string&, string&) except +yodaerr
        void read_from_file "YODA::Reader::read" (string&, vector[AnalysisObject*]&, string&, string&) except +yodaerr

cdef extern from "YODA/ReaderYODA.h" namespace "YODA":
    Reader& ReaderYODA_create "YODA::ReaderYODA::create" ()

cdef extern from "YODA/ReaderFLAT.h" namespace "YODA":
    Reader& ReaderFLAT_create "YODA::ReaderFLAT::create" ()

cdef extern from "YODA/Reader.h" namespace "YODA":
    Reader& Reader_create "YODA::mkReader" (string& filename)


cdef extern from "YODA/IO.h" namespace "YODA":
    void IO_write_to_file "YODA::write" (string&, vector[AnalysisObject*]&, int) except +yodaerr

cdef extern from "YODA/Writer.h" namespace "YODA":
    cdef cppclass Writer:
        void write(ostringstream&, vector[AnalysisObject*]&) except +yodaerr
        void write_to_file "YODA::Writer::write" (string&, vector[AnalysisObject*]&) except +yodaerr
        void setPrecision(int precision)
        void useCompression(bool compress)
    Writer& Writer_create "YODA::mkWriter" (string& filename)

cdef extern from "YODA/WriterYODA.h" namespace "YODA":
    Writer& WriterYODA_create "YODA::WriterYODA::create" ()

cdef extern from "YODA/WriterYODA1.h" namespace "YODA":
    Writer& WriterYODA1_create "YODA::WriterYODA1::create" ()

cdef extern from "YODA/WriterFLAT.h" namespace "YODA":
    Writer& WriterFLAT_create "YODA::WriterFLAT::create" ()

# Streams }}}


cdef extern from "merge.hh":

    void BE_iadd_d "cython_iadd" (BinnedEstimate1D[double]*, BinnedEstimate1D[double]*)
    BinnedEstimate1D[double]* BE_add_d "cython_add" (BinnedEstimate1D[double]*, BinnedEstimate1D[double]*)
    void BE_isub_d "cython_isub" (BinnedEstimate1D[double]*, BinnedEstimate1D[double]*)
    BinnedEstimate1D[double]* BE_sub_d "cython_sub" (BinnedEstimate1D[double]*, BinnedEstimate1D[double]*)
    bool BE_eq_d "cython_eq" (BinnedEstimate1D[double]*, BinnedEstimate1D[double]*)
    bool BE_ne_d "cython_ne" (BinnedEstimate1D[double]*, BinnedEstimate1D[double]*)
    BinnedEstimate1D[double]* BE_div_d "cython_div" (BinnedEstimate1D[double]*, BinnedEstimate1D[double]*)
    BinnedEstimate1D[double]* BE_eff_d "cython_div" (BinnedEstimate1D[double]*, BinnedEstimate1D[double]*)
    void BE_iadd_i "cython_iadd" (BinnedEstimate1D[int]*, BinnedEstimate1D[int]*)
    BinnedEstimate1D[int]* BE_add_i "cython_add" (BinnedEstimate1D[int]*, BinnedEstimate1D[int]*)
    void BE_isub_i "cython_isub" (BinnedEstimate1D[int]*, BinnedEstimate1D[int]*)
    BinnedEstimate1D[int]* BE_sub_i "cython_sub" (BinnedEstimate1D[int]*, BinnedEstimate1D[int]*)
    bool BE_eq_i "cython_eq" (BinnedEstimate1D[int]*, BinnedEstimate1D[int]*)
    bool BE_ne_i "cython_ne" (BinnedEstimate1D[int]*, BinnedEstimate1D[int]*)
    BinnedEstimate1D[int]* BE_div_i "cython_div" (BinnedEstimate1D[int]*, BinnedEstimate1D[int]*)
    BinnedEstimate1D[int]* BE_eff_i "cython_div" (BinnedEstimate1D[int]*, BinnedEstimate1D[int]*)
    void BE_iadd_s "cython_iadd" (BinnedEstimate1D[string]*, BinnedEstimate1D[string]*)
    BinnedEstimate1D[string]* BE_add_s "cython_add" (BinnedEstimate1D[string]*, BinnedEstimate1D[string]*)
    void BE_isub_s "cython_isub" (BinnedEstimate1D[string]*, BinnedEstimate1D[string]*)
    BinnedEstimate1D[string]* BE_sub_s "cython_sub" (BinnedEstimate1D[string]*, BinnedEstimate1D[string]*)
    bool BE_eq_s "cython_eq" (BinnedEstimate1D[string]*, BinnedEstimate1D[string]*)
    bool BE_ne_s "cython_ne" (BinnedEstimate1D[string]*, BinnedEstimate1D[string]*)
    BinnedEstimate1D[string]* BE_div_s "cython_div" (BinnedEstimate1D[string]*, BinnedEstimate1D[string]*)
    BinnedEstimate1D[string]* BE_eff_s "cython_div" (BinnedEstimate1D[string]*, BinnedEstimate1D[string]*)

    void BH_iadd_d "cython_iadd" (BinnedHisto1D[double]*, BinnedHisto1D[double]*)
    BinnedHisto1D[double]* BH_add_d "cython_add" (BinnedHisto1D[double]*, BinnedHisto1D[double]*)
    void BH_isub_d "cython_isub" (BinnedHisto1D[double]*, BinnedHisto1D[double]*)
    BinnedHisto1D[double]* BH_sub_d "cython_sub" (BinnedHisto1D[double]*, BinnedHisto1D[double]*)
    bool BH_eq_d "cython_eq" (BinnedHisto1D[double]*, BinnedHisto1D[double]*)
    bool BH_ne_d "cython_ne" (BinnedHisto1D[double]*, BinnedHisto1D[double]*)
    BinnedEstimate1D[double]* BH_div_d "cython_div" (BinnedHisto1D[double]*, BinnedHisto1D[double]*)
    BinnedEstimate1D[double]* BH_eff_d "cython_div" (BinnedHisto1D[double]*, BinnedHisto1D[double]*)
    BinnedEstimate1D[double]* BH_est_d "cython_est" (BinnedHisto1D[double]*, string&, string&, bool)
    void BH_iadd_i "cython_iadd" (BinnedHisto1D[int]*, BinnedHisto1D[int]*)
    BinnedHisto1D[int]* BH_add_i "cython_add" (BinnedHisto1D[int]*, BinnedHisto1D[int]*)
    void BH_isub_i "cython_isub" (BinnedHisto1D[int]*, BinnedHisto1D[int]*)
    BinnedHisto1D[int]* BH_sub_i "cython_sub" (BinnedHisto1D[int]*, BinnedHisto1D[int]*)
    bool BH_eq_i "cython_eq" (BinnedHisto1D[int]*, BinnedHisto1D[int]*)
    bool BH_ne_i "cython_ne" (BinnedHisto1D[int]*, BinnedHisto1D[int]*)
    BinnedEstimate1D[int]* BH_div_i "cython_div" (BinnedHisto1D[int]*, BinnedHisto1D[int]*)
    BinnedEstimate1D[int]* BH_eff_i "cython_div" (BinnedHisto1D[int]*, BinnedHisto1D[int]*)
    BinnedEstimate1D[int]* BH_est_i "cython_est" (BinnedHisto1D[int]*, string&, string&, bool)
    void BH_iadd_s "cython_iadd" (BinnedHisto1D[string]*, BinnedHisto1D[string]*)
    BinnedHisto1D[string]* BH_add_s "cython_add" (BinnedHisto1D[string]*, BinnedHisto1D[string]*)
    void BH_isub_s "cython_isub" (BinnedHisto1D[string]*, BinnedHisto1D[string]*)
    BinnedHisto1D[string]* BH_sub_s "cython_sub" (BinnedHisto1D[string]*, BinnedHisto1D[string]*)
    bool BH_eq_s "cython_eq" (BinnedHisto1D[string]*, BinnedHisto1D[string]*)
    bool BH_ne_s "cython_ne" (BinnedHisto1D[string]*, BinnedHisto1D[string]*)
    BinnedEstimate1D[string]* BH_div_s "cython_div" (BinnedHisto1D[string]*, BinnedHisto1D[string]*)
    BinnedEstimate1D[string]* BH_eff_s "cython_div" (BinnedHisto1D[string]*, BinnedHisto1D[string]*)
    BinnedEstimate1D[string]* BH_est_s "cython_est" (BinnedHisto1D[string]*, string&, string&, bool)

    void BP_iadd_d "cython_iadd" (BinnedProfile1D[double]*, BinnedProfile1D[double]*)
    BinnedProfile1D[double]* BP_add_d "cython_add" (BinnedProfile1D[double]*, BinnedProfile1D[double]*)
    void BP_isub_d "cython_isub" (BinnedProfile1D[double]*, BinnedProfile1D[double]*)
    BinnedProfile1D[double]* BP_sub_d "cython_sub" (BinnedProfile1D[double]*, BinnedProfile1D[double]*)
    bool BP_eq_d "cython_eq" (BinnedProfile1D[double]*, BinnedProfile1D[double]*)
    bool BP_ne_d "cython_ne" (BinnedProfile1D[double]*, BinnedProfile1D[double]*)
    BinnedEstimate1D[double]* BP_div_d "cython_div" (BinnedProfile1D[double]*, BinnedProfile1D[double]*)
    BinnedEstimate1D[double]* BP_eff_d "cython_div" (BinnedProfile1D[double]*, BinnedProfile1D[double]*)
    BinnedEstimate1D[double]* BP_est_d "cython_est" (BinnedProfile1D[double]*, string&, string&, bool)
    BinnedHisto1D[double]* BP_hist_d "cython_hist" (BinnedProfile1D[double]*, string&)
    void BP_iadd_i "cython_iadd" (BinnedProfile1D[int]*, BinnedProfile1D[int]*)
    BinnedProfile1D[int]* BP_add_i "cython_add" (BinnedProfile1D[int]*, BinnedProfile1D[int]*)
    void BP_isub_i "cython_isub" (BinnedProfile1D[int]*, BinnedProfile1D[int]*)
    BinnedProfile1D[int]* BP_sub_i "cython_sub" (BinnedProfile1D[int]*, BinnedProfile1D[int]*)
    bool BP_eq_i "cython_eq" (BinnedProfile1D[int]*, BinnedProfile1D[int]*)
    bool BP_ne_i "cython_ne" (BinnedProfile1D[int]*, BinnedProfile1D[int]*)
    BinnedEstimate1D[int]* BP_div_i "cython_div" (BinnedProfile1D[int]*, BinnedProfile1D[int]*)
    BinnedEstimate1D[int]* BP_eff_i "cython_div" (BinnedProfile1D[int]*, BinnedProfile1D[int]*)
    BinnedEstimate1D[int]* BP_est_i "cython_est" (BinnedProfile1D[int]*, string&, string&, bool)
    BinnedHisto1D[int]* BP_hist_i "cython_hist" (BinnedProfile1D[int]*, string&)
    void BP_iadd_s "cython_iadd" (BinnedProfile1D[string]*, BinnedProfile1D[string]*)
    BinnedProfile1D[string]* BP_add_s "cython_add" (BinnedProfile1D[string]*, BinnedProfile1D[string]*)
    void BP_isub_s "cython_isub" (BinnedProfile1D[string]*, BinnedProfile1D[string]*)
    BinnedProfile1D[string]* BP_sub_s "cython_sub" (BinnedProfile1D[string]*, BinnedProfile1D[string]*)
    bool BP_eq_s "cython_eq" (BinnedProfile1D[string]*, BinnedProfile1D[string]*)
    bool BP_ne_s "cython_ne" (BinnedProfile1D[string]*, BinnedProfile1D[string]*)
    BinnedEstimate1D[string]* BP_div_s "cython_div" (BinnedProfile1D[string]*, BinnedProfile1D[string]*)
    BinnedEstimate1D[string]* BP_eff_s "cython_div" (BinnedProfile1D[string]*, BinnedProfile1D[string]*)
    BinnedEstimate1D[string]* BP_est_s "cython_est" (BinnedProfile1D[string]*, string&, string&, bool)
    BinnedHisto1D[string]* BP_hist_s "cython_hist" (BinnedProfile1D[string]*, string&)

    void BE_iadd_dd "cython_iadd" (BinnedEstimate2D[double,double]*, BinnedEstimate2D[double,double]*)
    BinnedEstimate2D[double,double]* BE_add_dd "cython_add" (BinnedEstimate2D[double,double]*, BinnedEstimate2D[double,double]*)
    void BE_isub_dd "cython_isub" (BinnedEstimate2D[double,double]*, BinnedEstimate2D[double,double]*)
    BinnedEstimate2D[double,double]* BE_sub_dd "cython_sub" (BinnedEstimate2D[double,double]*, BinnedEstimate2D[double,double]*)
    bool BE_eq_dd "cython_eq" (BinnedEstimate2D[double,double]*, BinnedEstimate2D[double,double]*)
    bool BE_ne_dd "cython_ne" (BinnedEstimate2D[double,double]*, BinnedEstimate2D[double,double]*)
    BinnedEstimate2D[double,double]* BE_div_dd "cython_div" (BinnedEstimate2D[double,double]*, BinnedEstimate2D[double,double]*)
    BinnedEstimate2D[double,double]* BE_eff_dd "cython_div" (BinnedEstimate2D[double,double]*, BinnedEstimate2D[double,double]*)
    void BE_iadd_di "cython_iadd" (BinnedEstimate2D[double,int]*, BinnedEstimate2D[double,int]*)
    BinnedEstimate2D[double,int]* BE_add_di "cython_add" (BinnedEstimate2D[double,int]*, BinnedEstimate2D[double,int]*)
    void BE_isub_di "cython_isub" (BinnedEstimate2D[double,int]*, BinnedEstimate2D[double,int]*)
    BinnedEstimate2D[double,int]* BE_sub_di "cython_sub" (BinnedEstimate2D[double,int]*, BinnedEstimate2D[double,int]*)
    bool BE_eq_di "cython_eq" (BinnedEstimate2D[double,int]*, BinnedEstimate2D[double,int]*)
    bool BE_ne_di "cython_ne" (BinnedEstimate2D[double,int]*, BinnedEstimate2D[double,int]*)
    BinnedEstimate2D[double,int]* BE_div_di "cython_div" (BinnedEstimate2D[double,int]*, BinnedEstimate2D[double,int]*)
    BinnedEstimate2D[double,int]* BE_eff_di "cython_div" (BinnedEstimate2D[double,int]*, BinnedEstimate2D[double,int]*)
    void BE_iadd_ds "cython_iadd" (BinnedEstimate2D[double,string]*, BinnedEstimate2D[double,string]*)
    BinnedEstimate2D[double,string]* BE_add_ds "cython_add" (BinnedEstimate2D[double,string]*, BinnedEstimate2D[double,string]*)
    void BE_isub_ds "cython_isub" (BinnedEstimate2D[double,string]*, BinnedEstimate2D[double,string]*)
    BinnedEstimate2D[double,string]* BE_sub_ds "cython_sub" (BinnedEstimate2D[double,string]*, BinnedEstimate2D[double,string]*)
    bool BE_eq_ds "cython_eq" (BinnedEstimate2D[double,string]*, BinnedEstimate2D[double,string]*)
    bool BE_ne_ds "cython_ne" (BinnedEstimate2D[double,string]*, BinnedEstimate2D[double,string]*)
    BinnedEstimate2D[double,string]* BE_div_ds "cython_div" (BinnedEstimate2D[double,string]*, BinnedEstimate2D[double,string]*)
    BinnedEstimate2D[double,string]* BE_eff_ds "cython_div" (BinnedEstimate2D[double,string]*, BinnedEstimate2D[double,string]*)
    void BE_iadd_id "cython_iadd" (BinnedEstimate2D[int,double]*, BinnedEstimate2D[int,double]*)
    BinnedEstimate2D[int,double]* BE_add_id "cython_add" (BinnedEstimate2D[int,double]*, BinnedEstimate2D[int,double]*)
    void BE_isub_id "cython_isub" (BinnedEstimate2D[int,double]*, BinnedEstimate2D[int,double]*)
    BinnedEstimate2D[int,double]* BE_sub_id "cython_sub" (BinnedEstimate2D[int,double]*, BinnedEstimate2D[int,double]*)
    bool BE_eq_id "cython_eq" (BinnedEstimate2D[int,double]*, BinnedEstimate2D[int,double]*)
    bool BE_ne_id "cython_ne" (BinnedEstimate2D[int,double]*, BinnedEstimate2D[int,double]*)
    BinnedEstimate2D[int,double]* BE_div_id "cython_div" (BinnedEstimate2D[int,double]*, BinnedEstimate2D[int,double]*)
    BinnedEstimate2D[int,double]* BE_eff_id "cython_div" (BinnedEstimate2D[int,double]*, BinnedEstimate2D[int,double]*)
    void BE_iadd_ii "cython_iadd" (BinnedEstimate2D[int,int]*, BinnedEstimate2D[int,int]*)
    BinnedEstimate2D[int,int]* BE_add_ii "cython_add" (BinnedEstimate2D[int,int]*, BinnedEstimate2D[int,int]*)
    void BE_isub_ii "cython_isub" (BinnedEstimate2D[int,int]*, BinnedEstimate2D[int,int]*)
    BinnedEstimate2D[int,int]* BE_sub_ii "cython_sub" (BinnedEstimate2D[int,int]*, BinnedEstimate2D[int,int]*)
    bool BE_eq_ii "cython_eq" (BinnedEstimate2D[int,int]*, BinnedEstimate2D[int,int]*)
    bool BE_ne_ii "cython_ne" (BinnedEstimate2D[int,int]*, BinnedEstimate2D[int,int]*)
    BinnedEstimate2D[int,int]* BE_div_ii "cython_div" (BinnedEstimate2D[int,int]*, BinnedEstimate2D[int,int]*)
    BinnedEstimate2D[int,int]* BE_eff_ii "cython_div" (BinnedEstimate2D[int,int]*, BinnedEstimate2D[int,int]*)
    void BE_iadd_is "cython_iadd" (BinnedEstimate2D[int,string]*, BinnedEstimate2D[int,string]*)
    BinnedEstimate2D[int,string]* BE_add_is "cython_add" (BinnedEstimate2D[int,string]*, BinnedEstimate2D[int,string]*)
    void BE_isub_is "cython_isub" (BinnedEstimate2D[int,string]*, BinnedEstimate2D[int,string]*)
    BinnedEstimate2D[int,string]* BE_sub_is "cython_sub" (BinnedEstimate2D[int,string]*, BinnedEstimate2D[int,string]*)
    bool BE_eq_is "cython_eq" (BinnedEstimate2D[int,string]*, BinnedEstimate2D[int,string]*)
    bool BE_ne_is "cython_ne" (BinnedEstimate2D[int,string]*, BinnedEstimate2D[int,string]*)
    BinnedEstimate2D[int,string]* BE_div_is "cython_div" (BinnedEstimate2D[int,string]*, BinnedEstimate2D[int,string]*)
    BinnedEstimate2D[int,string]* BE_eff_is "cython_div" (BinnedEstimate2D[int,string]*, BinnedEstimate2D[int,string]*)
    void BE_iadd_sd "cython_iadd" (BinnedEstimate2D[string,double]*, BinnedEstimate2D[string,double]*)
    BinnedEstimate2D[string,double]* BE_add_sd "cython_add" (BinnedEstimate2D[string,double]*, BinnedEstimate2D[string,double]*)
    void BE_isub_sd "cython_isub" (BinnedEstimate2D[string,double]*, BinnedEstimate2D[string,double]*)
    BinnedEstimate2D[string,double]* BE_sub_sd "cython_sub" (BinnedEstimate2D[string,double]*, BinnedEstimate2D[string,double]*)
    bool BE_eq_sd "cython_eq" (BinnedEstimate2D[string,double]*, BinnedEstimate2D[string,double]*)
    bool BE_ne_sd "cython_ne" (BinnedEstimate2D[string,double]*, BinnedEstimate2D[string,double]*)
    BinnedEstimate2D[string,double]* BE_div_sd "cython_div" (BinnedEstimate2D[string,double]*, BinnedEstimate2D[string,double]*)
    BinnedEstimate2D[string,double]* BE_eff_sd "cython_div" (BinnedEstimate2D[string,double]*, BinnedEstimate2D[string,double]*)
    void BE_iadd_si "cython_iadd" (BinnedEstimate2D[string,int]*, BinnedEstimate2D[string,int]*)
    BinnedEstimate2D[string,int]* BE_add_si "cython_add" (BinnedEstimate2D[string,int]*, BinnedEstimate2D[string,int]*)
    void BE_isub_si "cython_isub" (BinnedEstimate2D[string,int]*, BinnedEstimate2D[string,int]*)
    BinnedEstimate2D[string,int]* BE_sub_si "cython_sub" (BinnedEstimate2D[string,int]*, BinnedEstimate2D[string,int]*)
    bool BE_eq_si "cython_eq" (BinnedEstimate2D[string,int]*, BinnedEstimate2D[string,int]*)
    bool BE_ne_si "cython_ne" (BinnedEstimate2D[string,int]*, BinnedEstimate2D[string,int]*)
    BinnedEstimate2D[string,int]* BE_div_si "cython_div" (BinnedEstimate2D[string,int]*, BinnedEstimate2D[string,int]*)
    BinnedEstimate2D[string,int]* BE_eff_si "cython_div" (BinnedEstimate2D[string,int]*, BinnedEstimate2D[string,int]*)
    void BE_iadd_ss "cython_iadd" (BinnedEstimate2D[string,string]*, BinnedEstimate2D[string,string]*)
    BinnedEstimate2D[string,string]* BE_add_ss "cython_add" (BinnedEstimate2D[string,string]*, BinnedEstimate2D[string,string]*)
    void BE_isub_ss "cython_isub" (BinnedEstimate2D[string,string]*, BinnedEstimate2D[string,string]*)
    BinnedEstimate2D[string,string]* BE_sub_ss "cython_sub" (BinnedEstimate2D[string,string]*, BinnedEstimate2D[string,string]*)
    bool BE_eq_ss "cython_eq" (BinnedEstimate2D[string,string]*, BinnedEstimate2D[string,string]*)
    bool BE_ne_ss "cython_ne" (BinnedEstimate2D[string,string]*, BinnedEstimate2D[string,string]*)
    BinnedEstimate2D[string,string]* BE_div_ss "cython_div" (BinnedEstimate2D[string,string]*, BinnedEstimate2D[string,string]*)
    BinnedEstimate2D[string,string]* BE_eff_ss "cython_div" (BinnedEstimate2D[string,string]*, BinnedEstimate2D[string,string]*)

    void BH_iadd_dd "cython_iadd" (BinnedHisto2D[double,double]*, BinnedHisto2D[double,double]*)
    BinnedHisto2D[double,double]* BH_add_dd "cython_add" (BinnedHisto2D[double,double]*, BinnedHisto2D[double,double]*)
    void BH_isub_dd "cython_isub" (BinnedHisto2D[double,double]*, BinnedHisto2D[double,double]*)
    BinnedHisto2D[double,double]* BH_sub_dd "cython_sub" (BinnedHisto2D[double,double]*, BinnedHisto2D[double,double]*)
    bool BH_eq_dd "cython_eq" (BinnedHisto2D[double,double]*, BinnedHisto2D[double,double]*)
    bool BH_ne_dd "cython_ne" (BinnedHisto2D[double,double]*, BinnedHisto2D[double,double]*)
    BinnedEstimate2D[double,double]* BH_div_dd "cython_div" (BinnedHisto2D[double,double]*, BinnedHisto2D[double,double]*)
    BinnedEstimate2D[double,double]* BH_eff_dd "cython_div" (BinnedHisto2D[double,double]*, BinnedHisto2D[double,double]*)
    BinnedEstimate2D[double,double]* BH_est_dd "cython_est" (BinnedHisto2D[double,double]*, string&, string&, bool)
    void BH_iadd_di "cython_iadd" (BinnedHisto2D[double,int]*, BinnedHisto2D[double,int]*)
    BinnedHisto2D[double,int]* BH_add_di "cython_add" (BinnedHisto2D[double,int]*, BinnedHisto2D[double,int]*)
    void BH_isub_di "cython_isub" (BinnedHisto2D[double,int]*, BinnedHisto2D[double,int]*)
    BinnedHisto2D[double,int]* BH_sub_di "cython_sub" (BinnedHisto2D[double,int]*, BinnedHisto2D[double,int]*)
    bool BH_eq_di "cython_eq" (BinnedHisto2D[double,int]*, BinnedHisto2D[double,int]*)
    bool BH_ne_di "cython_ne" (BinnedHisto2D[double,int]*, BinnedHisto2D[double,int]*)
    BinnedEstimate2D[double,int]* BH_div_di "cython_div" (BinnedHisto2D[double,int]*, BinnedHisto2D[double,int]*)
    BinnedEstimate2D[double,int]* BH_eff_di "cython_div" (BinnedHisto2D[double,int]*, BinnedHisto2D[double,int]*)
    BinnedEstimate2D[double,int]* BH_est_di "cython_est" (BinnedHisto2D[double,int]*, string&, string&, bool)
    void BH_iadd_ds "cython_iadd" (BinnedHisto2D[double,string]*, BinnedHisto2D[double,string]*)
    BinnedHisto2D[double,string]* BH_add_ds "cython_add" (BinnedHisto2D[double,string]*, BinnedHisto2D[double,string]*)
    void BH_isub_ds "cython_isub" (BinnedHisto2D[double,string]*, BinnedHisto2D[double,string]*)
    BinnedHisto2D[double,string]* BH_sub_ds "cython_sub" (BinnedHisto2D[double,string]*, BinnedHisto2D[double,string]*)
    bool BH_eq_ds "cython_eq" (BinnedHisto2D[double,string]*, BinnedHisto2D[double,string]*)
    bool BH_ne_ds "cython_ne" (BinnedHisto2D[double,string]*, BinnedHisto2D[double,string]*)
    BinnedEstimate2D[double,string]* BH_div_ds "cython_div" (BinnedHisto2D[double,string]*, BinnedHisto2D[double,string]*)
    BinnedEstimate2D[double,string]* BH_eff_ds "cython_div" (BinnedHisto2D[double,string]*, BinnedHisto2D[double,string]*)
    BinnedEstimate2D[double,string]* BH_est_ds "cython_est" (BinnedHisto2D[double,string]*, string&, string&, bool)
    void BH_iadd_id "cython_iadd" (BinnedHisto2D[int,double]*, BinnedHisto2D[int,double]*)
    BinnedHisto2D[int,double]* BH_add_id "cython_add" (BinnedHisto2D[int,double]*, BinnedHisto2D[int,double]*)
    void BH_isub_id "cython_isub" (BinnedHisto2D[int,double]*, BinnedHisto2D[int,double]*)
    BinnedHisto2D[int,double]* BH_sub_id "cython_sub" (BinnedHisto2D[int,double]*, BinnedHisto2D[int,double]*)
    bool BH_eq_id "cython_eq" (BinnedHisto2D[int,double]*, BinnedHisto2D[int,double]*)
    bool BH_ne_id "cython_ne" (BinnedHisto2D[int,double]*, BinnedHisto2D[int,double]*)
    BinnedEstimate2D[int,double]* BH_div_id "cython_div" (BinnedHisto2D[int,double]*, BinnedHisto2D[int,double]*)
    BinnedEstimate2D[int,double]* BH_eff_id "cython_div" (BinnedHisto2D[int,double]*, BinnedHisto2D[int,double]*)
    BinnedEstimate2D[int,double]* BH_est_id "cython_est" (BinnedHisto2D[int,double]*, string&, string&, bool)
    void BH_iadd_ii "cython_iadd" (BinnedHisto2D[int,int]*, BinnedHisto2D[int,int]*)
    BinnedHisto2D[int,int]* BH_add_ii "cython_add" (BinnedHisto2D[int,int]*, BinnedHisto2D[int,int]*)
    void BH_isub_ii "cython_isub" (BinnedHisto2D[int,int]*, BinnedHisto2D[int,int]*)
    BinnedHisto2D[int,int]* BH_sub_ii "cython_sub" (BinnedHisto2D[int,int]*, BinnedHisto2D[int,int]*)
    bool BH_eq_ii "cython_eq" (BinnedHisto2D[int,int]*, BinnedHisto2D[int,int]*)
    bool BH_ne_ii "cython_ne" (BinnedHisto2D[int,int]*, BinnedHisto2D[int,int]*)
    BinnedEstimate2D[int,int]* BH_div_ii "cython_div" (BinnedHisto2D[int,int]*, BinnedHisto2D[int,int]*)
    BinnedEstimate2D[int,int]* BH_eff_ii "cython_div" (BinnedHisto2D[int,int]*, BinnedHisto2D[int,int]*)
    BinnedEstimate2D[int,int]* BH_est_ii "cython_est" (BinnedHisto2D[int,int]*, string&, string&, bool)
    void BH_iadd_is "cython_iadd" (BinnedHisto2D[int,string]*, BinnedHisto2D[int,string]*)
    BinnedHisto2D[int,string]* BH_add_is "cython_add" (BinnedHisto2D[int,string]*, BinnedHisto2D[int,string]*)
    void BH_isub_is "cython_isub" (BinnedHisto2D[int,string]*, BinnedHisto2D[int,string]*)
    BinnedHisto2D[int,string]* BH_sub_is "cython_sub" (BinnedHisto2D[int,string]*, BinnedHisto2D[int,string]*)
    bool BH_eq_is "cython_eq" (BinnedHisto2D[int,string]*, BinnedHisto2D[int,string]*)
    bool BH_ne_is "cython_ne" (BinnedHisto2D[int,string]*, BinnedHisto2D[int,string]*)
    BinnedEstimate2D[int,string]* BH_div_is "cython_div" (BinnedHisto2D[int,string]*, BinnedHisto2D[int,string]*)
    BinnedEstimate2D[int,string]* BH_eff_is "cython_div" (BinnedHisto2D[int,string]*, BinnedHisto2D[int,string]*)
    BinnedEstimate2D[int,string]* BH_est_is "cython_est" (BinnedHisto2D[int,string]*, string&, string&, bool)
    void BH_iadd_sd "cython_iadd" (BinnedHisto2D[string,double]*, BinnedHisto2D[string,double]*)
    BinnedHisto2D[string,double]* BH_add_sd "cython_add" (BinnedHisto2D[string,double]*, BinnedHisto2D[string,double]*)
    void BH_isub_sd "cython_isub" (BinnedHisto2D[string,double]*, BinnedHisto2D[string,double]*)
    BinnedHisto2D[string,double]* BH_sub_sd "cython_sub" (BinnedHisto2D[string,double]*, BinnedHisto2D[string,double]*)
    bool BH_eq_sd "cython_eq" (BinnedHisto2D[string,double]*, BinnedHisto2D[string,double]*)
    bool BH_ne_sd "cython_ne" (BinnedHisto2D[string,double]*, BinnedHisto2D[string,double]*)
    BinnedEstimate2D[string,double]* BH_div_sd "cython_div" (BinnedHisto2D[string,double]*, BinnedHisto2D[string,double]*)
    BinnedEstimate2D[string,double]* BH_eff_sd "cython_div" (BinnedHisto2D[string,double]*, BinnedHisto2D[string,double]*)
    BinnedEstimate2D[string,double]* BH_est_sd "cython_est" (BinnedHisto2D[string,double]*, string&, string&, bool)
    void BH_iadd_si "cython_iadd" (BinnedHisto2D[string,int]*, BinnedHisto2D[string,int]*)
    BinnedHisto2D[string,int]* BH_add_si "cython_add" (BinnedHisto2D[string,int]*, BinnedHisto2D[string,int]*)
    void BH_isub_si "cython_isub" (BinnedHisto2D[string,int]*, BinnedHisto2D[string,int]*)
    BinnedHisto2D[string,int]* BH_sub_si "cython_sub" (BinnedHisto2D[string,int]*, BinnedHisto2D[string,int]*)
    bool BH_eq_si "cython_eq" (BinnedHisto2D[string,int]*, BinnedHisto2D[string,int]*)
    bool BH_ne_si "cython_ne" (BinnedHisto2D[string,int]*, BinnedHisto2D[string,int]*)
    BinnedEstimate2D[string,int]* BH_div_si "cython_div" (BinnedHisto2D[string,int]*, BinnedHisto2D[string,int]*)
    BinnedEstimate2D[string,int]* BH_eff_si "cython_div" (BinnedHisto2D[string,int]*, BinnedHisto2D[string,int]*)
    BinnedEstimate2D[string,int]* BH_est_si "cython_est" (BinnedHisto2D[string,int]*, string&, string&, bool)
    void BH_iadd_ss "cython_iadd" (BinnedHisto2D[string,string]*, BinnedHisto2D[string,string]*)
    BinnedHisto2D[string,string]* BH_add_ss "cython_add" (BinnedHisto2D[string,string]*, BinnedHisto2D[string,string]*)
    void BH_isub_ss "cython_isub" (BinnedHisto2D[string,string]*, BinnedHisto2D[string,string]*)
    BinnedHisto2D[string,string]* BH_sub_ss "cython_sub" (BinnedHisto2D[string,string]*, BinnedHisto2D[string,string]*)
    bool BH_eq_ss "cython_eq" (BinnedHisto2D[string,string]*, BinnedHisto2D[string,string]*)
    bool BH_ne_ss "cython_ne" (BinnedHisto2D[string,string]*, BinnedHisto2D[string,string]*)
    BinnedEstimate2D[string,string]* BH_div_ss "cython_div" (BinnedHisto2D[string,string]*, BinnedHisto2D[string,string]*)
    BinnedEstimate2D[string,string]* BH_eff_ss "cython_div" (BinnedHisto2D[string,string]*, BinnedHisto2D[string,string]*)
    BinnedEstimate2D[string,string]* BH_est_ss "cython_est" (BinnedHisto2D[string,string]*, string&, string&, bool)

    void BP_iadd_dd "cython_iadd" (BinnedProfile2D[double,double]*, BinnedProfile2D[double,double]*)
    BinnedProfile2D[double,double]* BP_add_dd "cython_add" (BinnedProfile2D[double,double]*, BinnedProfile2D[double,double]*)
    void BP_isub_dd "cython_isub" (BinnedProfile2D[double,double]*, BinnedProfile2D[double,double]*)
    BinnedProfile2D[double,double]* BP_sub_dd "cython_sub" (BinnedProfile2D[double,double]*, BinnedProfile2D[double,double]*)
    bool BP_eq_dd "cython_eq" (BinnedProfile2D[double,double]*, BinnedProfile2D[double,double]*)
    bool BP_ne_dd "cython_ne" (BinnedProfile2D[double,double]*, BinnedProfile2D[double,double]*)
    BinnedEstimate2D[double,double]* BP_div_dd "cython_div" (BinnedProfile2D[double,double]*, BinnedProfile2D[double,double]*)
    BinnedEstimate2D[double,double]* BP_eff_dd "cython_div" (BinnedProfile2D[double,double]*, BinnedProfile2D[double,double]*)
    BinnedEstimate2D[double,double]* BP_est_dd "cython_est" (BinnedProfile2D[double,double]*, string&, string&, bool)
    BinnedHisto2D[double,double]* BP_hist_dd "cython_hist" (BinnedProfile2D[double,double]*, string&)
    void BP_iadd_di "cython_iadd" (BinnedProfile2D[double,int]*, BinnedProfile2D[double,int]*)
    BinnedProfile2D[double,int]* BP_add_di "cython_add" (BinnedProfile2D[double,int]*, BinnedProfile2D[double,int]*)
    void BP_isub_di "cython_isub" (BinnedProfile2D[double,int]*, BinnedProfile2D[double,int]*)
    BinnedProfile2D[double,int]* BP_sub_di "cython_sub" (BinnedProfile2D[double,int]*, BinnedProfile2D[double,int]*)
    bool BP_eq_di "cython_eq" (BinnedProfile2D[double,int]*, BinnedProfile2D[double,int]*)
    bool BP_ne_di "cython_ne" (BinnedProfile2D[double,int]*, BinnedProfile2D[double,int]*)
    BinnedEstimate2D[double,int]* BP_div_di "cython_div" (BinnedProfile2D[double,int]*, BinnedProfile2D[double,int]*)
    BinnedEstimate2D[double,int]* BP_eff_di "cython_div" (BinnedProfile2D[double,int]*, BinnedProfile2D[double,int]*)
    BinnedEstimate2D[double,int]* BP_est_di "cython_est" (BinnedProfile2D[double,int]*, string&, string&, bool)
    BinnedHisto2D[double,int]* BP_hist_di "cython_hist" (BinnedProfile2D[double,int]*, string&)
    void BP_iadd_ds "cython_iadd" (BinnedProfile2D[double,string]*, BinnedProfile2D[double,string]*)
    BinnedProfile2D[double,string]* BP_add_ds "cython_add" (BinnedProfile2D[double,string]*, BinnedProfile2D[double,string]*)
    void BP_isub_ds "cython_isub" (BinnedProfile2D[double,string]*, BinnedProfile2D[double,string]*)
    BinnedProfile2D[double,string]* BP_sub_ds "cython_sub" (BinnedProfile2D[double,string]*, BinnedProfile2D[double,string]*)
    bool BP_eq_ds "cython_eq" (BinnedProfile2D[double,string]*, BinnedProfile2D[double,string]*)
    bool BP_ne_ds "cython_ne" (BinnedProfile2D[double,string]*, BinnedProfile2D[double,string]*)
    BinnedEstimate2D[double,string]* BP_div_ds "cython_div" (BinnedProfile2D[double,string]*, BinnedProfile2D[double,string]*)
    BinnedEstimate2D[double,string]* BP_eff_ds "cython_div" (BinnedProfile2D[double,string]*, BinnedProfile2D[double,string]*)
    BinnedEstimate2D[double,string]* BP_est_ds "cython_est" (BinnedProfile2D[double,string]*, string&, string&, bool)
    BinnedHisto2D[double,string]* BP_hist_ds "cython_hist" (BinnedProfile2D[double,string]*, string&)
    void BP_iadd_id "cython_iadd" (BinnedProfile2D[int,double]*, BinnedProfile2D[int,double]*)
    BinnedProfile2D[int,double]* BP_add_id "cython_add" (BinnedProfile2D[int,double]*, BinnedProfile2D[int,double]*)
    void BP_isub_id "cython_isub" (BinnedProfile2D[int,double]*, BinnedProfile2D[int,double]*)
    BinnedProfile2D[int,double]* BP_sub_id "cython_sub" (BinnedProfile2D[int,double]*, BinnedProfile2D[int,double]*)
    bool BP_eq_id "cython_eq" (BinnedProfile2D[int,double]*, BinnedProfile2D[int,double]*)
    bool BP_ne_id "cython_ne" (BinnedProfile2D[int,double]*, BinnedProfile2D[int,double]*)
    BinnedEstimate2D[int,double]* BP_div_id "cython_div" (BinnedProfile2D[int,double]*, BinnedProfile2D[int,double]*)
    BinnedEstimate2D[int,double]* BP_eff_id "cython_div" (BinnedProfile2D[int,double]*, BinnedProfile2D[int,double]*)
    BinnedEstimate2D[int,double]* BP_est_id "cython_est" (BinnedProfile2D[int,double]*, string&, string&, bool)
    BinnedHisto2D[int,double]* BP_hist_id "cython_hist" (BinnedProfile2D[int,double]*, string&)
    void BP_iadd_ii "cython_iadd" (BinnedProfile2D[int,int]*, BinnedProfile2D[int,int]*)
    BinnedProfile2D[int,int]* BP_add_ii "cython_add" (BinnedProfile2D[int,int]*, BinnedProfile2D[int,int]*)
    void BP_isub_ii "cython_isub" (BinnedProfile2D[int,int]*, BinnedProfile2D[int,int]*)
    BinnedProfile2D[int,int]* BP_sub_ii "cython_sub" (BinnedProfile2D[int,int]*, BinnedProfile2D[int,int]*)
    bool BP_eq_ii "cython_eq" (BinnedProfile2D[int,int]*, BinnedProfile2D[int,int]*)
    bool BP_ne_ii "cython_ne" (BinnedProfile2D[int,int]*, BinnedProfile2D[int,int]*)
    BinnedEstimate2D[int,int]* BP_div_ii "cython_div" (BinnedProfile2D[int,int]*, BinnedProfile2D[int,int]*)
    BinnedEstimate2D[int,int]* BP_eff_ii "cython_div" (BinnedProfile2D[int,int]*, BinnedProfile2D[int,int]*)
    BinnedEstimate2D[int,int]* BP_est_ii "cython_est" (BinnedProfile2D[int,int]*, string&, string&, bool)
    BinnedHisto2D[int,int]* BP_hist_ii "cython_hist" (BinnedProfile2D[int,int]*, string&)
    void BP_iadd_is "cython_iadd" (BinnedProfile2D[int,string]*, BinnedProfile2D[int,string]*)
    BinnedProfile2D[int,string]* BP_add_is "cython_add" (BinnedProfile2D[int,string]*, BinnedProfile2D[int,string]*)
    void BP_isub_is "cython_isub" (BinnedProfile2D[int,string]*, BinnedProfile2D[int,string]*)
    BinnedProfile2D[int,string]* BP_sub_is "cython_sub" (BinnedProfile2D[int,string]*, BinnedProfile2D[int,string]*)
    bool BP_eq_is "cython_eq" (BinnedProfile2D[int,string]*, BinnedProfile2D[int,string]*)
    bool BP_ne_is "cython_ne" (BinnedProfile2D[int,string]*, BinnedProfile2D[int,string]*)
    BinnedEstimate2D[int,string]* BP_div_is "cython_div" (BinnedProfile2D[int,string]*, BinnedProfile2D[int,string]*)
    BinnedEstimate2D[int,string]* BP_eff_is "cython_div" (BinnedProfile2D[int,string]*, BinnedProfile2D[int,string]*)
    BinnedEstimate2D[int,string]* BP_est_is "cython_est" (BinnedProfile2D[int,string]*, string&, string&, bool)
    BinnedHisto2D[int,string]* BP_hist_is "cython_hist" (BinnedProfile2D[int,string]*, string&)
    void BP_iadd_sd "cython_iadd" (BinnedProfile2D[string,double]*, BinnedProfile2D[string,double]*)
    BinnedProfile2D[string,double]* BP_add_sd "cython_add" (BinnedProfile2D[string,double]*, BinnedProfile2D[string,double]*)
    void BP_isub_sd "cython_isub" (BinnedProfile2D[string,double]*, BinnedProfile2D[string,double]*)
    BinnedProfile2D[string,double]* BP_sub_sd "cython_sub" (BinnedProfile2D[string,double]*, BinnedProfile2D[string,double]*)
    bool BP_eq_sd "cython_eq" (BinnedProfile2D[string,double]*, BinnedProfile2D[string,double]*)
    bool BP_ne_sd "cython_ne" (BinnedProfile2D[string,double]*, BinnedProfile2D[string,double]*)
    BinnedEstimate2D[string,double]* BP_div_sd "cython_div" (BinnedProfile2D[string,double]*, BinnedProfile2D[string,double]*)
    BinnedEstimate2D[string,double]* BP_eff_sd "cython_div" (BinnedProfile2D[string,double]*, BinnedProfile2D[string,double]*)
    BinnedEstimate2D[string,double]* BP_est_sd "cython_est" (BinnedProfile2D[string,double]*, string&, string&, bool)
    BinnedHisto2D[string,double]* BP_hist_sd "cython_hist" (BinnedProfile2D[string,double]*, string&)
    void BP_iadd_si "cython_iadd" (BinnedProfile2D[string,int]*, BinnedProfile2D[string,int]*)
    BinnedProfile2D[string,int]* BP_add_si "cython_add" (BinnedProfile2D[string,int]*, BinnedProfile2D[string,int]*)
    void BP_isub_si "cython_isub" (BinnedProfile2D[string,int]*, BinnedProfile2D[string,int]*)
    BinnedProfile2D[string,int]* BP_sub_si "cython_sub" (BinnedProfile2D[string,int]*, BinnedProfile2D[string,int]*)
    bool BP_eq_si "cython_eq" (BinnedProfile2D[string,int]*, BinnedProfile2D[string,int]*)
    bool BP_ne_si "cython_ne" (BinnedProfile2D[string,int]*, BinnedProfile2D[string,int]*)
    BinnedEstimate2D[string,int]* BP_div_si "cython_div" (BinnedProfile2D[string,int]*, BinnedProfile2D[string,int]*)
    BinnedEstimate2D[string,int]* BP_eff_si "cython_div" (BinnedProfile2D[string,int]*, BinnedProfile2D[string,int]*)
    BinnedEstimate2D[string,int]* BP_est_si "cython_est" (BinnedProfile2D[string,int]*, string&, string&, bool)
    BinnedHisto2D[string,int]* BP_hist_si "cython_hist" (BinnedProfile2D[string,int]*, string&)
    void BP_iadd_ss "cython_iadd" (BinnedProfile2D[string,string]*, BinnedProfile2D[string,string]*)
    BinnedProfile2D[string,string]* BP_add_ss "cython_add" (BinnedProfile2D[string,string]*, BinnedProfile2D[string,string]*)
    void BP_isub_ss "cython_isub" (BinnedProfile2D[string,string]*, BinnedProfile2D[string,string]*)
    BinnedProfile2D[string,string]* BP_sub_ss "cython_sub" (BinnedProfile2D[string,string]*, BinnedProfile2D[string,string]*)
    bool BP_eq_ss "cython_eq" (BinnedProfile2D[string,string]*, BinnedProfile2D[string,string]*)
    bool BP_ne_ss "cython_ne" (BinnedProfile2D[string,string]*, BinnedProfile2D[string,string]*)
    BinnedEstimate2D[string,string]* BP_div_ss "cython_div" (BinnedProfile2D[string,string]*, BinnedProfile2D[string,string]*)
    BinnedEstimate2D[string,string]* BP_eff_ss "cython_div" (BinnedProfile2D[string,string]*, BinnedProfile2D[string,string]*)
    BinnedEstimate2D[string,string]* BP_est_ss "cython_est" (BinnedProfile2D[string,string]*, string&, string&, bool)
    BinnedHisto2D[string,string]* BP_hist_ss "cython_hist" (BinnedProfile2D[string,string]*, string&)

    void BE_iadd_ddd "cython_iadd" (BinnedEstimate3D[double,double,double]*, BinnedEstimate3D[double,double,double]*)
    BinnedEstimate3D[double,double,double]* BE_add_ddd "cython_add" (BinnedEstimate3D[double,double,double]*, BinnedEstimate3D[double,double,double]*)
    void BE_isub_ddd "cython_isub" (BinnedEstimate3D[double,double,double]*, BinnedEstimate3D[double,double,double]*)
    BinnedEstimate3D[double,double,double]* BE_sub_ddd "cython_sub" (BinnedEstimate3D[double,double,double]*, BinnedEstimate3D[double,double,double]*)
    bool BE_eq_ddd "cython_eq" (BinnedEstimate3D[double,double,double]*, BinnedEstimate3D[double,double,double]*)
    bool BE_ne_ddd "cython_ne" (BinnedEstimate3D[double,double,double]*, BinnedEstimate3D[double,double,double]*)
    BinnedEstimate3D[double,double,double]* BE_div_ddd "cython_div" (BinnedEstimate3D[double,double,double]*, BinnedEstimate3D[double,double,double]*)
    BinnedEstimate3D[double,double,double]* BE_eff_ddd "cython_div" (BinnedEstimate3D[double,double,double]*, BinnedEstimate3D[double,double,double]*)
    void BE_iadd_ddi "cython_iadd" (BinnedEstimate3D[double,double,int]*, BinnedEstimate3D[double,double,int]*)
    BinnedEstimate3D[double,double,int]* BE_add_ddi "cython_add" (BinnedEstimate3D[double,double,int]*, BinnedEstimate3D[double,double,int]*)
    void BE_isub_ddi "cython_isub" (BinnedEstimate3D[double,double,int]*, BinnedEstimate3D[double,double,int]*)
    BinnedEstimate3D[double,double,int]* BE_sub_ddi "cython_sub" (BinnedEstimate3D[double,double,int]*, BinnedEstimate3D[double,double,int]*)
    bool BE_eq_ddi "cython_eq" (BinnedEstimate3D[double,double,int]*, BinnedEstimate3D[double,double,int]*)
    bool BE_ne_ddi "cython_ne" (BinnedEstimate3D[double,double,int]*, BinnedEstimate3D[double,double,int]*)
    BinnedEstimate3D[double,double,int]* BE_div_ddi "cython_div" (BinnedEstimate3D[double,double,int]*, BinnedEstimate3D[double,double,int]*)
    BinnedEstimate3D[double,double,int]* BE_eff_ddi "cython_div" (BinnedEstimate3D[double,double,int]*, BinnedEstimate3D[double,double,int]*)
    void BE_iadd_dds "cython_iadd" (BinnedEstimate3D[double,double,string]*, BinnedEstimate3D[double,double,string]*)
    BinnedEstimate3D[double,double,string]* BE_add_dds "cython_add" (BinnedEstimate3D[double,double,string]*, BinnedEstimate3D[double,double,string]*)
    void BE_isub_dds "cython_isub" (BinnedEstimate3D[double,double,string]*, BinnedEstimate3D[double,double,string]*)
    BinnedEstimate3D[double,double,string]* BE_sub_dds "cython_sub" (BinnedEstimate3D[double,double,string]*, BinnedEstimate3D[double,double,string]*)
    bool BE_eq_dds "cython_eq" (BinnedEstimate3D[double,double,string]*, BinnedEstimate3D[double,double,string]*)
    bool BE_ne_dds "cython_ne" (BinnedEstimate3D[double,double,string]*, BinnedEstimate3D[double,double,string]*)
    BinnedEstimate3D[double,double,string]* BE_div_dds "cython_div" (BinnedEstimate3D[double,double,string]*, BinnedEstimate3D[double,double,string]*)
    BinnedEstimate3D[double,double,string]* BE_eff_dds "cython_div" (BinnedEstimate3D[double,double,string]*, BinnedEstimate3D[double,double,string]*)
    void BE_iadd_did "cython_iadd" (BinnedEstimate3D[double,int,double]*, BinnedEstimate3D[double,int,double]*)
    BinnedEstimate3D[double,int,double]* BE_add_did "cython_add" (BinnedEstimate3D[double,int,double]*, BinnedEstimate3D[double,int,double]*)
    void BE_isub_did "cython_isub" (BinnedEstimate3D[double,int,double]*, BinnedEstimate3D[double,int,double]*)
    BinnedEstimate3D[double,int,double]* BE_sub_did "cython_sub" (BinnedEstimate3D[double,int,double]*, BinnedEstimate3D[double,int,double]*)
    bool BE_eq_did "cython_eq" (BinnedEstimate3D[double,int,double]*, BinnedEstimate3D[double,int,double]*)
    bool BE_ne_did "cython_ne" (BinnedEstimate3D[double,int,double]*, BinnedEstimate3D[double,int,double]*)
    BinnedEstimate3D[double,int,double]* BE_div_did "cython_div" (BinnedEstimate3D[double,int,double]*, BinnedEstimate3D[double,int,double]*)
    BinnedEstimate3D[double,int,double]* BE_eff_did "cython_div" (BinnedEstimate3D[double,int,double]*, BinnedEstimate3D[double,int,double]*)
    void BE_iadd_dii "cython_iadd" (BinnedEstimate3D[double,int,int]*, BinnedEstimate3D[double,int,int]*)
    BinnedEstimate3D[double,int,int]* BE_add_dii "cython_add" (BinnedEstimate3D[double,int,int]*, BinnedEstimate3D[double,int,int]*)
    void BE_isub_dii "cython_isub" (BinnedEstimate3D[double,int,int]*, BinnedEstimate3D[double,int,int]*)
    BinnedEstimate3D[double,int,int]* BE_sub_dii "cython_sub" (BinnedEstimate3D[double,int,int]*, BinnedEstimate3D[double,int,int]*)
    bool BE_eq_dii "cython_eq" (BinnedEstimate3D[double,int,int]*, BinnedEstimate3D[double,int,int]*)
    bool BE_ne_dii "cython_ne" (BinnedEstimate3D[double,int,int]*, BinnedEstimate3D[double,int,int]*)
    BinnedEstimate3D[double,int,int]* BE_div_dii "cython_div" (BinnedEstimate3D[double,int,int]*, BinnedEstimate3D[double,int,int]*)
    BinnedEstimate3D[double,int,int]* BE_eff_dii "cython_div" (BinnedEstimate3D[double,int,int]*, BinnedEstimate3D[double,int,int]*)
    void BE_iadd_dis "cython_iadd" (BinnedEstimate3D[double,int,string]*, BinnedEstimate3D[double,int,string]*)
    BinnedEstimate3D[double,int,string]* BE_add_dis "cython_add" (BinnedEstimate3D[double,int,string]*, BinnedEstimate3D[double,int,string]*)
    void BE_isub_dis "cython_isub" (BinnedEstimate3D[double,int,string]*, BinnedEstimate3D[double,int,string]*)
    BinnedEstimate3D[double,int,string]* BE_sub_dis "cython_sub" (BinnedEstimate3D[double,int,string]*, BinnedEstimate3D[double,int,string]*)
    bool BE_eq_dis "cython_eq" (BinnedEstimate3D[double,int,string]*, BinnedEstimate3D[double,int,string]*)
    bool BE_ne_dis "cython_ne" (BinnedEstimate3D[double,int,string]*, BinnedEstimate3D[double,int,string]*)
    BinnedEstimate3D[double,int,string]* BE_div_dis "cython_div" (BinnedEstimate3D[double,int,string]*, BinnedEstimate3D[double,int,string]*)
    BinnedEstimate3D[double,int,string]* BE_eff_dis "cython_div" (BinnedEstimate3D[double,int,string]*, BinnedEstimate3D[double,int,string]*)
    void BE_iadd_dsd "cython_iadd" (BinnedEstimate3D[double,string,double]*, BinnedEstimate3D[double,string,double]*)
    BinnedEstimate3D[double,string,double]* BE_add_dsd "cython_add" (BinnedEstimate3D[double,string,double]*, BinnedEstimate3D[double,string,double]*)
    void BE_isub_dsd "cython_isub" (BinnedEstimate3D[double,string,double]*, BinnedEstimate3D[double,string,double]*)
    BinnedEstimate3D[double,string,double]* BE_sub_dsd "cython_sub" (BinnedEstimate3D[double,string,double]*, BinnedEstimate3D[double,string,double]*)
    bool BE_eq_dsd "cython_eq" (BinnedEstimate3D[double,string,double]*, BinnedEstimate3D[double,string,double]*)
    bool BE_ne_dsd "cython_ne" (BinnedEstimate3D[double,string,double]*, BinnedEstimate3D[double,string,double]*)
    BinnedEstimate3D[double,string,double]* BE_div_dsd "cython_div" (BinnedEstimate3D[double,string,double]*, BinnedEstimate3D[double,string,double]*)
    BinnedEstimate3D[double,string,double]* BE_eff_dsd "cython_div" (BinnedEstimate3D[double,string,double]*, BinnedEstimate3D[double,string,double]*)
    void BE_iadd_dsi "cython_iadd" (BinnedEstimate3D[double,string,int]*, BinnedEstimate3D[double,string,int]*)
    BinnedEstimate3D[double,string,int]* BE_add_dsi "cython_add" (BinnedEstimate3D[double,string,int]*, BinnedEstimate3D[double,string,int]*)
    void BE_isub_dsi "cython_isub" (BinnedEstimate3D[double,string,int]*, BinnedEstimate3D[double,string,int]*)
    BinnedEstimate3D[double,string,int]* BE_sub_dsi "cython_sub" (BinnedEstimate3D[double,string,int]*, BinnedEstimate3D[double,string,int]*)
    bool BE_eq_dsi "cython_eq" (BinnedEstimate3D[double,string,int]*, BinnedEstimate3D[double,string,int]*)
    bool BE_ne_dsi "cython_ne" (BinnedEstimate3D[double,string,int]*, BinnedEstimate3D[double,string,int]*)
    BinnedEstimate3D[double,string,int]* BE_div_dsi "cython_div" (BinnedEstimate3D[double,string,int]*, BinnedEstimate3D[double,string,int]*)
    BinnedEstimate3D[double,string,int]* BE_eff_dsi "cython_div" (BinnedEstimate3D[double,string,int]*, BinnedEstimate3D[double,string,int]*)
    void BE_iadd_dss "cython_iadd" (BinnedEstimate3D[double,string,string]*, BinnedEstimate3D[double,string,string]*)
    BinnedEstimate3D[double,string,string]* BE_add_dss "cython_add" (BinnedEstimate3D[double,string,string]*, BinnedEstimate3D[double,string,string]*)
    void BE_isub_dss "cython_isub" (BinnedEstimate3D[double,string,string]*, BinnedEstimate3D[double,string,string]*)
    BinnedEstimate3D[double,string,string]* BE_sub_dss "cython_sub" (BinnedEstimate3D[double,string,string]*, BinnedEstimate3D[double,string,string]*)
    bool BE_eq_dss "cython_eq" (BinnedEstimate3D[double,string,string]*, BinnedEstimate3D[double,string,string]*)
    bool BE_ne_dss "cython_ne" (BinnedEstimate3D[double,string,string]*, BinnedEstimate3D[double,string,string]*)
    BinnedEstimate3D[double,string,string]* BE_div_dss "cython_div" (BinnedEstimate3D[double,string,string]*, BinnedEstimate3D[double,string,string]*)
    BinnedEstimate3D[double,string,string]* BE_eff_dss "cython_div" (BinnedEstimate3D[double,string,string]*, BinnedEstimate3D[double,string,string]*)
    void BE_iadd_idd "cython_iadd" (BinnedEstimate3D[int,double,double]*, BinnedEstimate3D[int,double,double]*)
    BinnedEstimate3D[int,double,double]* BE_add_idd "cython_add" (BinnedEstimate3D[int,double,double]*, BinnedEstimate3D[int,double,double]*)
    void BE_isub_idd "cython_isub" (BinnedEstimate3D[int,double,double]*, BinnedEstimate3D[int,double,double]*)
    BinnedEstimate3D[int,double,double]* BE_sub_idd "cython_sub" (BinnedEstimate3D[int,double,double]*, BinnedEstimate3D[int,double,double]*)
    bool BE_eq_idd "cython_eq" (BinnedEstimate3D[int,double,double]*, BinnedEstimate3D[int,double,double]*)
    bool BE_ne_idd "cython_ne" (BinnedEstimate3D[int,double,double]*, BinnedEstimate3D[int,double,double]*)
    BinnedEstimate3D[int,double,double]* BE_div_idd "cython_div" (BinnedEstimate3D[int,double,double]*, BinnedEstimate3D[int,double,double]*)
    BinnedEstimate3D[int,double,double]* BE_eff_idd "cython_div" (BinnedEstimate3D[int,double,double]*, BinnedEstimate3D[int,double,double]*)
    void BE_iadd_idi "cython_iadd" (BinnedEstimate3D[int,double,int]*, BinnedEstimate3D[int,double,int]*)
    BinnedEstimate3D[int,double,int]* BE_add_idi "cython_add" (BinnedEstimate3D[int,double,int]*, BinnedEstimate3D[int,double,int]*)
    void BE_isub_idi "cython_isub" (BinnedEstimate3D[int,double,int]*, BinnedEstimate3D[int,double,int]*)
    BinnedEstimate3D[int,double,int]* BE_sub_idi "cython_sub" (BinnedEstimate3D[int,double,int]*, BinnedEstimate3D[int,double,int]*)
    bool BE_eq_idi "cython_eq" (BinnedEstimate3D[int,double,int]*, BinnedEstimate3D[int,double,int]*)
    bool BE_ne_idi "cython_ne" (BinnedEstimate3D[int,double,int]*, BinnedEstimate3D[int,double,int]*)
    BinnedEstimate3D[int,double,int]* BE_div_idi "cython_div" (BinnedEstimate3D[int,double,int]*, BinnedEstimate3D[int,double,int]*)
    BinnedEstimate3D[int,double,int]* BE_eff_idi "cython_div" (BinnedEstimate3D[int,double,int]*, BinnedEstimate3D[int,double,int]*)
    void BE_iadd_ids "cython_iadd" (BinnedEstimate3D[int,double,string]*, BinnedEstimate3D[int,double,string]*)
    BinnedEstimate3D[int,double,string]* BE_add_ids "cython_add" (BinnedEstimate3D[int,double,string]*, BinnedEstimate3D[int,double,string]*)
    void BE_isub_ids "cython_isub" (BinnedEstimate3D[int,double,string]*, BinnedEstimate3D[int,double,string]*)
    BinnedEstimate3D[int,double,string]* BE_sub_ids "cython_sub" (BinnedEstimate3D[int,double,string]*, BinnedEstimate3D[int,double,string]*)
    bool BE_eq_ids "cython_eq" (BinnedEstimate3D[int,double,string]*, BinnedEstimate3D[int,double,string]*)
    bool BE_ne_ids "cython_ne" (BinnedEstimate3D[int,double,string]*, BinnedEstimate3D[int,double,string]*)
    BinnedEstimate3D[int,double,string]* BE_div_ids "cython_div" (BinnedEstimate3D[int,double,string]*, BinnedEstimate3D[int,double,string]*)
    BinnedEstimate3D[int,double,string]* BE_eff_ids "cython_div" (BinnedEstimate3D[int,double,string]*, BinnedEstimate3D[int,double,string]*)
    void BE_iadd_iid "cython_iadd" (BinnedEstimate3D[int,int,double]*, BinnedEstimate3D[int,int,double]*)
    BinnedEstimate3D[int,int,double]* BE_add_iid "cython_add" (BinnedEstimate3D[int,int,double]*, BinnedEstimate3D[int,int,double]*)
    void BE_isub_iid "cython_isub" (BinnedEstimate3D[int,int,double]*, BinnedEstimate3D[int,int,double]*)
    BinnedEstimate3D[int,int,double]* BE_sub_iid "cython_sub" (BinnedEstimate3D[int,int,double]*, BinnedEstimate3D[int,int,double]*)
    bool BE_eq_iid "cython_eq" (BinnedEstimate3D[int,int,double]*, BinnedEstimate3D[int,int,double]*)
    bool BE_ne_iid "cython_ne" (BinnedEstimate3D[int,int,double]*, BinnedEstimate3D[int,int,double]*)
    BinnedEstimate3D[int,int,double]* BE_div_iid "cython_div" (BinnedEstimate3D[int,int,double]*, BinnedEstimate3D[int,int,double]*)
    BinnedEstimate3D[int,int,double]* BE_eff_iid "cython_div" (BinnedEstimate3D[int,int,double]*, BinnedEstimate3D[int,int,double]*)
    void BE_iadd_iii "cython_iadd" (BinnedEstimate3D[int,int,int]*, BinnedEstimate3D[int,int,int]*)
    BinnedEstimate3D[int,int,int]* BE_add_iii "cython_add" (BinnedEstimate3D[int,int,int]*, BinnedEstimate3D[int,int,int]*)
    void BE_isub_iii "cython_isub" (BinnedEstimate3D[int,int,int]*, BinnedEstimate3D[int,int,int]*)
    BinnedEstimate3D[int,int,int]* BE_sub_iii "cython_sub" (BinnedEstimate3D[int,int,int]*, BinnedEstimate3D[int,int,int]*)
    bool BE_eq_iii "cython_eq" (BinnedEstimate3D[int,int,int]*, BinnedEstimate3D[int,int,int]*)
    bool BE_ne_iii "cython_ne" (BinnedEstimate3D[int,int,int]*, BinnedEstimate3D[int,int,int]*)
    BinnedEstimate3D[int,int,int]* BE_div_iii "cython_div" (BinnedEstimate3D[int,int,int]*, BinnedEstimate3D[int,int,int]*)
    BinnedEstimate3D[int,int,int]* BE_eff_iii "cython_div" (BinnedEstimate3D[int,int,int]*, BinnedEstimate3D[int,int,int]*)
    void BE_iadd_iis "cython_iadd" (BinnedEstimate3D[int,int,string]*, BinnedEstimate3D[int,int,string]*)
    BinnedEstimate3D[int,int,string]* BE_add_iis "cython_add" (BinnedEstimate3D[int,int,string]*, BinnedEstimate3D[int,int,string]*)
    void BE_isub_iis "cython_isub" (BinnedEstimate3D[int,int,string]*, BinnedEstimate3D[int,int,string]*)
    BinnedEstimate3D[int,int,string]* BE_sub_iis "cython_sub" (BinnedEstimate3D[int,int,string]*, BinnedEstimate3D[int,int,string]*)
    bool BE_eq_iis "cython_eq" (BinnedEstimate3D[int,int,string]*, BinnedEstimate3D[int,int,string]*)
    bool BE_ne_iis "cython_ne" (BinnedEstimate3D[int,int,string]*, BinnedEstimate3D[int,int,string]*)
    BinnedEstimate3D[int,int,string]* BE_div_iis "cython_div" (BinnedEstimate3D[int,int,string]*, BinnedEstimate3D[int,int,string]*)
    BinnedEstimate3D[int,int,string]* BE_eff_iis "cython_div" (BinnedEstimate3D[int,int,string]*, BinnedEstimate3D[int,int,string]*)
    void BE_iadd_isd "cython_iadd" (BinnedEstimate3D[int,string,double]*, BinnedEstimate3D[int,string,double]*)
    BinnedEstimate3D[int,string,double]* BE_add_isd "cython_add" (BinnedEstimate3D[int,string,double]*, BinnedEstimate3D[int,string,double]*)
    void BE_isub_isd "cython_isub" (BinnedEstimate3D[int,string,double]*, BinnedEstimate3D[int,string,double]*)
    BinnedEstimate3D[int,string,double]* BE_sub_isd "cython_sub" (BinnedEstimate3D[int,string,double]*, BinnedEstimate3D[int,string,double]*)
    bool BE_eq_isd "cython_eq" (BinnedEstimate3D[int,string,double]*, BinnedEstimate3D[int,string,double]*)
    bool BE_ne_isd "cython_ne" (BinnedEstimate3D[int,string,double]*, BinnedEstimate3D[int,string,double]*)
    BinnedEstimate3D[int,string,double]* BE_div_isd "cython_div" (BinnedEstimate3D[int,string,double]*, BinnedEstimate3D[int,string,double]*)
    BinnedEstimate3D[int,string,double]* BE_eff_isd "cython_div" (BinnedEstimate3D[int,string,double]*, BinnedEstimate3D[int,string,double]*)
    void BE_iadd_isi "cython_iadd" (BinnedEstimate3D[int,string,int]*, BinnedEstimate3D[int,string,int]*)
    BinnedEstimate3D[int,string,int]* BE_add_isi "cython_add" (BinnedEstimate3D[int,string,int]*, BinnedEstimate3D[int,string,int]*)
    void BE_isub_isi "cython_isub" (BinnedEstimate3D[int,string,int]*, BinnedEstimate3D[int,string,int]*)
    BinnedEstimate3D[int,string,int]* BE_sub_isi "cython_sub" (BinnedEstimate3D[int,string,int]*, BinnedEstimate3D[int,string,int]*)
    bool BE_eq_isi "cython_eq" (BinnedEstimate3D[int,string,int]*, BinnedEstimate3D[int,string,int]*)
    bool BE_ne_isi "cython_ne" (BinnedEstimate3D[int,string,int]*, BinnedEstimate3D[int,string,int]*)
    BinnedEstimate3D[int,string,int]* BE_div_isi "cython_div" (BinnedEstimate3D[int,string,int]*, BinnedEstimate3D[int,string,int]*)
    BinnedEstimate3D[int,string,int]* BE_eff_isi "cython_div" (BinnedEstimate3D[int,string,int]*, BinnedEstimate3D[int,string,int]*)
    void BE_iadd_iss "cython_iadd" (BinnedEstimate3D[int,string,string]*, BinnedEstimate3D[int,string,string]*)
    BinnedEstimate3D[int,string,string]* BE_add_iss "cython_add" (BinnedEstimate3D[int,string,string]*, BinnedEstimate3D[int,string,string]*)
    void BE_isub_iss "cython_isub" (BinnedEstimate3D[int,string,string]*, BinnedEstimate3D[int,string,string]*)
    BinnedEstimate3D[int,string,string]* BE_sub_iss "cython_sub" (BinnedEstimate3D[int,string,string]*, BinnedEstimate3D[int,string,string]*)
    bool BE_eq_iss "cython_eq" (BinnedEstimate3D[int,string,string]*, BinnedEstimate3D[int,string,string]*)
    bool BE_ne_iss "cython_ne" (BinnedEstimate3D[int,string,string]*, BinnedEstimate3D[int,string,string]*)
    BinnedEstimate3D[int,string,string]* BE_div_iss "cython_div" (BinnedEstimate3D[int,string,string]*, BinnedEstimate3D[int,string,string]*)
    BinnedEstimate3D[int,string,string]* BE_eff_iss "cython_div" (BinnedEstimate3D[int,string,string]*, BinnedEstimate3D[int,string,string]*)
    void BE_iadd_sdd "cython_iadd" (BinnedEstimate3D[string,double,double]*, BinnedEstimate3D[string,double,double]*)
    BinnedEstimate3D[string,double,double]* BE_add_sdd "cython_add" (BinnedEstimate3D[string,double,double]*, BinnedEstimate3D[string,double,double]*)
    void BE_isub_sdd "cython_isub" (BinnedEstimate3D[string,double,double]*, BinnedEstimate3D[string,double,double]*)
    BinnedEstimate3D[string,double,double]* BE_sub_sdd "cython_sub" (BinnedEstimate3D[string,double,double]*, BinnedEstimate3D[string,double,double]*)
    bool BE_eq_sdd "cython_eq" (BinnedEstimate3D[string,double,double]*, BinnedEstimate3D[string,double,double]*)
    bool BE_ne_sdd "cython_ne" (BinnedEstimate3D[string,double,double]*, BinnedEstimate3D[string,double,double]*)
    BinnedEstimate3D[string,double,double]* BE_div_sdd "cython_div" (BinnedEstimate3D[string,double,double]*, BinnedEstimate3D[string,double,double]*)
    BinnedEstimate3D[string,double,double]* BE_eff_sdd "cython_div" (BinnedEstimate3D[string,double,double]*, BinnedEstimate3D[string,double,double]*)
    void BE_iadd_sdi "cython_iadd" (BinnedEstimate3D[string,double,int]*, BinnedEstimate3D[string,double,int]*)
    BinnedEstimate3D[string,double,int]* BE_add_sdi "cython_add" (BinnedEstimate3D[string,double,int]*, BinnedEstimate3D[string,double,int]*)
    void BE_isub_sdi "cython_isub" (BinnedEstimate3D[string,double,int]*, BinnedEstimate3D[string,double,int]*)
    BinnedEstimate3D[string,double,int]* BE_sub_sdi "cython_sub" (BinnedEstimate3D[string,double,int]*, BinnedEstimate3D[string,double,int]*)
    bool BE_eq_sdi "cython_eq" (BinnedEstimate3D[string,double,int]*, BinnedEstimate3D[string,double,int]*)
    bool BE_ne_sdi "cython_ne" (BinnedEstimate3D[string,double,int]*, BinnedEstimate3D[string,double,int]*)
    BinnedEstimate3D[string,double,int]* BE_div_sdi "cython_div" (BinnedEstimate3D[string,double,int]*, BinnedEstimate3D[string,double,int]*)
    BinnedEstimate3D[string,double,int]* BE_eff_sdi "cython_div" (BinnedEstimate3D[string,double,int]*, BinnedEstimate3D[string,double,int]*)
    void BE_iadd_sds "cython_iadd" (BinnedEstimate3D[string,double,string]*, BinnedEstimate3D[string,double,string]*)
    BinnedEstimate3D[string,double,string]* BE_add_sds "cython_add" (BinnedEstimate3D[string,double,string]*, BinnedEstimate3D[string,double,string]*)
    void BE_isub_sds "cython_isub" (BinnedEstimate3D[string,double,string]*, BinnedEstimate3D[string,double,string]*)
    BinnedEstimate3D[string,double,string]* BE_sub_sds "cython_sub" (BinnedEstimate3D[string,double,string]*, BinnedEstimate3D[string,double,string]*)
    bool BE_eq_sds "cython_eq" (BinnedEstimate3D[string,double,string]*, BinnedEstimate3D[string,double,string]*)
    bool BE_ne_sds "cython_ne" (BinnedEstimate3D[string,double,string]*, BinnedEstimate3D[string,double,string]*)
    BinnedEstimate3D[string,double,string]* BE_div_sds "cython_div" (BinnedEstimate3D[string,double,string]*, BinnedEstimate3D[string,double,string]*)
    BinnedEstimate3D[string,double,string]* BE_eff_sds "cython_div" (BinnedEstimate3D[string,double,string]*, BinnedEstimate3D[string,double,string]*)
    void BE_iadd_sid "cython_iadd" (BinnedEstimate3D[string,int,double]*, BinnedEstimate3D[string,int,double]*)
    BinnedEstimate3D[string,int,double]* BE_add_sid "cython_add" (BinnedEstimate3D[string,int,double]*, BinnedEstimate3D[string,int,double]*)
    void BE_isub_sid "cython_isub" (BinnedEstimate3D[string,int,double]*, BinnedEstimate3D[string,int,double]*)
    BinnedEstimate3D[string,int,double]* BE_sub_sid "cython_sub" (BinnedEstimate3D[string,int,double]*, BinnedEstimate3D[string,int,double]*)
    bool BE_eq_sid "cython_eq" (BinnedEstimate3D[string,int,double]*, BinnedEstimate3D[string,int,double]*)
    bool BE_ne_sid "cython_ne" (BinnedEstimate3D[string,int,double]*, BinnedEstimate3D[string,int,double]*)
    BinnedEstimate3D[string,int,double]* BE_div_sid "cython_div" (BinnedEstimate3D[string,int,double]*, BinnedEstimate3D[string,int,double]*)
    BinnedEstimate3D[string,int,double]* BE_eff_sid "cython_div" (BinnedEstimate3D[string,int,double]*, BinnedEstimate3D[string,int,double]*)
    void BE_iadd_sii "cython_iadd" (BinnedEstimate3D[string,int,int]*, BinnedEstimate3D[string,int,int]*)
    BinnedEstimate3D[string,int,int]* BE_add_sii "cython_add" (BinnedEstimate3D[string,int,int]*, BinnedEstimate3D[string,int,int]*)
    void BE_isub_sii "cython_isub" (BinnedEstimate3D[string,int,int]*, BinnedEstimate3D[string,int,int]*)
    BinnedEstimate3D[string,int,int]* BE_sub_sii "cython_sub" (BinnedEstimate3D[string,int,int]*, BinnedEstimate3D[string,int,int]*)
    bool BE_eq_sii "cython_eq" (BinnedEstimate3D[string,int,int]*, BinnedEstimate3D[string,int,int]*)
    bool BE_ne_sii "cython_ne" (BinnedEstimate3D[string,int,int]*, BinnedEstimate3D[string,int,int]*)
    BinnedEstimate3D[string,int,int]* BE_div_sii "cython_div" (BinnedEstimate3D[string,int,int]*, BinnedEstimate3D[string,int,int]*)
    BinnedEstimate3D[string,int,int]* BE_eff_sii "cython_div" (BinnedEstimate3D[string,int,int]*, BinnedEstimate3D[string,int,int]*)
    void BE_iadd_sis "cython_iadd" (BinnedEstimate3D[string,int,string]*, BinnedEstimate3D[string,int,string]*)
    BinnedEstimate3D[string,int,string]* BE_add_sis "cython_add" (BinnedEstimate3D[string,int,string]*, BinnedEstimate3D[string,int,string]*)
    void BE_isub_sis "cython_isub" (BinnedEstimate3D[string,int,string]*, BinnedEstimate3D[string,int,string]*)
    BinnedEstimate3D[string,int,string]* BE_sub_sis "cython_sub" (BinnedEstimate3D[string,int,string]*, BinnedEstimate3D[string,int,string]*)
    bool BE_eq_sis "cython_eq" (BinnedEstimate3D[string,int,string]*, BinnedEstimate3D[string,int,string]*)
    bool BE_ne_sis "cython_ne" (BinnedEstimate3D[string,int,string]*, BinnedEstimate3D[string,int,string]*)
    BinnedEstimate3D[string,int,string]* BE_div_sis "cython_div" (BinnedEstimate3D[string,int,string]*, BinnedEstimate3D[string,int,string]*)
    BinnedEstimate3D[string,int,string]* BE_eff_sis "cython_div" (BinnedEstimate3D[string,int,string]*, BinnedEstimate3D[string,int,string]*)
    void BE_iadd_ssd "cython_iadd" (BinnedEstimate3D[string,string,double]*, BinnedEstimate3D[string,string,double]*)
    BinnedEstimate3D[string,string,double]* BE_add_ssd "cython_add" (BinnedEstimate3D[string,string,double]*, BinnedEstimate3D[string,string,double]*)
    void BE_isub_ssd "cython_isub" (BinnedEstimate3D[string,string,double]*, BinnedEstimate3D[string,string,double]*)
    BinnedEstimate3D[string,string,double]* BE_sub_ssd "cython_sub" (BinnedEstimate3D[string,string,double]*, BinnedEstimate3D[string,string,double]*)
    bool BE_eq_ssd "cython_eq" (BinnedEstimate3D[string,string,double]*, BinnedEstimate3D[string,string,double]*)
    bool BE_ne_ssd "cython_ne" (BinnedEstimate3D[string,string,double]*, BinnedEstimate3D[string,string,double]*)
    BinnedEstimate3D[string,string,double]* BE_div_ssd "cython_div" (BinnedEstimate3D[string,string,double]*, BinnedEstimate3D[string,string,double]*)
    BinnedEstimate3D[string,string,double]* BE_eff_ssd "cython_div" (BinnedEstimate3D[string,string,double]*, BinnedEstimate3D[string,string,double]*)
    void BE_iadd_ssi "cython_iadd" (BinnedEstimate3D[string,string,int]*, BinnedEstimate3D[string,string,int]*)
    BinnedEstimate3D[string,string,int]* BE_add_ssi "cython_add" (BinnedEstimate3D[string,string,int]*, BinnedEstimate3D[string,string,int]*)
    void BE_isub_ssi "cython_isub" (BinnedEstimate3D[string,string,int]*, BinnedEstimate3D[string,string,int]*)
    BinnedEstimate3D[string,string,int]* BE_sub_ssi "cython_sub" (BinnedEstimate3D[string,string,int]*, BinnedEstimate3D[string,string,int]*)
    bool BE_eq_ssi "cython_eq" (BinnedEstimate3D[string,string,int]*, BinnedEstimate3D[string,string,int]*)
    bool BE_ne_ssi "cython_ne" (BinnedEstimate3D[string,string,int]*, BinnedEstimate3D[string,string,int]*)
    BinnedEstimate3D[string,string,int]* BE_div_ssi "cython_div" (BinnedEstimate3D[string,string,int]*, BinnedEstimate3D[string,string,int]*)
    BinnedEstimate3D[string,string,int]* BE_eff_ssi "cython_div" (BinnedEstimate3D[string,string,int]*, BinnedEstimate3D[string,string,int]*)
    void BE_iadd_sss "cython_iadd" (BinnedEstimate3D[string,string,string]*, BinnedEstimate3D[string,string,string]*)
    BinnedEstimate3D[string,string,string]* BE_add_sss "cython_add" (BinnedEstimate3D[string,string,string]*, BinnedEstimate3D[string,string,string]*)
    void BE_isub_sss "cython_isub" (BinnedEstimate3D[string,string,string]*, BinnedEstimate3D[string,string,string]*)
    BinnedEstimate3D[string,string,string]* BE_sub_sss "cython_sub" (BinnedEstimate3D[string,string,string]*, BinnedEstimate3D[string,string,string]*)
    bool BE_eq_sss "cython_eq" (BinnedEstimate3D[string,string,string]*, BinnedEstimate3D[string,string,string]*)
    bool BE_ne_sss "cython_ne" (BinnedEstimate3D[string,string,string]*, BinnedEstimate3D[string,string,string]*)
    BinnedEstimate3D[string,string,string]* BE_div_sss "cython_div" (BinnedEstimate3D[string,string,string]*, BinnedEstimate3D[string,string,string]*)
    BinnedEstimate3D[string,string,string]* BE_eff_sss "cython_div" (BinnedEstimate3D[string,string,string]*, BinnedEstimate3D[string,string,string]*)

    void BH_iadd_ddd "cython_iadd" (BinnedHisto3D[double,double,double]*, BinnedHisto3D[double,double,double]*)
    BinnedHisto3D[double,double,double]* BH_add_ddd "cython_add" (BinnedHisto3D[double,double,double]*, BinnedHisto3D[double,double,double]*)
    void BH_isub_ddd "cython_isub" (BinnedHisto3D[double,double,double]*, BinnedHisto3D[double,double,double]*)
    BinnedHisto3D[double,double,double]* BH_sub_ddd "cython_sub" (BinnedHisto3D[double,double,double]*, BinnedHisto3D[double,double,double]*)
    bool BH_eq_ddd "cython_eq" (BinnedHisto3D[double,double,double]*, BinnedHisto3D[double,double,double]*)
    bool BH_ne_ddd "cython_ne" (BinnedHisto3D[double,double,double]*, BinnedHisto3D[double,double,double]*)
    BinnedEstimate3D[double,double,double]* BH_div_ddd "cython_div" (BinnedHisto3D[double,double,double]*, BinnedHisto3D[double,double,double]*)
    BinnedEstimate3D[double,double,double]* BH_eff_ddd "cython_div" (BinnedHisto3D[double,double,double]*, BinnedHisto3D[double,double,double]*)
    BinnedEstimate3D[double,double,double]* BH_est_ddd "cython_est" (BinnedHisto3D[double,double,double]*, string&, string&, bool)