/*
 *
 * Copyright (c) 2011-2016 The University of Waikato, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This file is part of libprotoident.
 *
 * This code has been developed by the University of Waikato WAND
 * research group. For further information please see http://www.wand.net.nz/
 *
 * libprotoident is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * libprotoident is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */

#include <string.h>

#include "libprotoident.h"
#include "proto_manager.h"
#include "proto_common.h"

static inline bool match_telnet_exploit(lpi_data_t *data, lpi_module_t *mod UNUSED) {

	/* Anyone firing up a telnet session and immediately sending 'root',
	 * as opposed to the initial telnet commands, is probably up to no
	 * good */

	if (data->server_port != 23 && data->client_port != 23)
		return false;

	if (MATCH(data->payload[0], 'r', 'o', 'o', 't'))
		return true;
	if (MATCH(data->payload[1], 'r', 'o', 'o', 't'))
		return true;

	/* This is a common way for telnet servers to drop unwanted clients 
	 *
	 * Full string is: 
	 *
	 * %connection closed by remote host! */
	if (MATCH(data->payload[0], 0x0d, 0x0a, '%', 'c') && 
			data->payload_len[1] == 0)
		return true;
	if (MATCH(data->payload[1], 0x0d, 0x0a, '%', 'c') &&
			data->payload_len[0] == 0)
		return true;

	return false;
}

static lpi_module_t lpi_telnet_exploit = {
	LPI_PROTO_TELNET_EXPLOIT,
	LPI_CATEGORY_MALWARE,
	"TelnetExploit",
	20,
	match_telnet_exploit
};

void register_telnet_exploit(LPIModuleMap *mod_map) {
	register_protocol(&lpi_telnet_exploit, mod_map);
}

