/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.ItemType;

public class Outermost
extends SystemFunctionCall {
    boolean presorted = false;

    public ItemType getItemType() {
        return this.getArguments()[0].getItemType();
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e2 = super.optimize(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        if ((this.argument[0].getSpecialProperties() & 0x80000) != 0) {
            return this.argument[0];
        }
        this.presorted = (this.argument[0].getSpecialProperties() & 0x20000) != 0;
        return this;
    }

    public Expression copy() {
        Outermost o = (Outermost)super.copy();
        o.presorted = this.presorted;
        return o;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.outermost(this.argument[0].iterate(context));
    }

    public int computeSpecialProperties() {
        return 655360;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return SequenceTool.toLazySequence(this.outermost(arguments[0].iterate()));
    }

    public SequenceIterator outermost(SequenceIterator in) throws XPathException {
        if (!this.presorted) {
            in = new DocumentOrderIterator(in, GlobalOrderComparer.getInstance());
        }
        return new OutermostIterator(in);
    }

    private class OutermostIterator
    implements SequenceIterator {
        SequenceIterator in;
        NodeInfo current = null;
        int position = 0;

        public OutermostIterator(SequenceIterator in) {
            this.in = in;
        }

        public NodeInfo next() throws XPathException {
            NodeInfo next;
            do {
                if ((next = (NodeInfo)this.in.next()) != null) continue;
                this.current = null;
                this.position = -1;
                return null;
            } while (this.current != null && Navigator.isAncestorOrSelf(this.current, next));
            this.current = next;
            ++this.position;
            return this.current;
        }

        public void close() {
            this.in.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new OutermostIterator(this.in.getAnother());
        }

        public int getProperties() {
            return 0;
        }
    }
}

