% podman-load 1

## NAME
podman\-load - Load image(s) from a tar archive into container storage

## SYNOPSIS
**podman load** [*options*]

**podman image load** [*options*]

## DESCRIPTION
**podman load** loads an image from either an **oci-archive** or a **docker-archive** stored on the local machine into container storage. **podman load** reads from stdin by default or a file if the **input** option is set.
**podman load** is used for loading from the archive generated by **podman save**, that includes the image parent layers. To load the archive of container's filesystem created by **podman export**, use **podman import**.

The local client further supports loading an **oci-dir** or a **docker-dir** as created with **podman save** (1).

The **quiet** option suppresses the progress output when set.
Note: `:` is a restricted character and cannot be part of the file name.

## OPTIONS

#### **--help**, **-h**

Print usage statement

#### **--input**, **-i**=*input*

Load the specified input file instead of from stdin.  The file can be on the local file system or on a server (e.g., https://server.com/archive.tar). Also supports loading in compressed files.

The remote client, including Mac and Windows (excluding WSL2) machines, requires the use of this option.

NOTE: Use the environment variable `TMPDIR` to change the temporary storage location of container images. Podman defaults to use `/var/tmp`.

#### **--quiet**, **-q**

Suppress the progress output

## EXAMPLES

Create an image from a compressed tar file, without showing progress.
```
$ podman load --quiet -i fedora.tar.gz
```

Create an image from the archive.tar file pulled from a URL, without showing progress.
```
$ podman load -q -i https://server.com/archive.tar
```

Create an image from stdin using bash redirection from a tar file.
```
$ podman load < fedora.tar
Getting image source signatures
Copying blob sha256:5bef08742407efd622d243692b79ba0055383bbce12900324f75e56f589aedb0
 0 B / 4.03 MB [---------------------------------------------------------------]
Copying config sha256:7328f6f8b41890597575cbaadc884e7386ae0acc53b747401ebce5cf0d624560
 0 B / 1.48 KB [---------------------------------------------------------------]
Writing manifest to image destination
Storing signatures
Loaded image:  registry.fedoraproject.org/fedora:latest
```

Create an image from stdin using a pipe.
```
$ cat fedora.tar | podman load
Getting image source signatures
Copying blob sha256:5bef08742407efd622d243692b79ba0055383bbce12900324f75e56f589aedb0
 0 B / 4.03 MB [---------------------------------------------------------------]
Copying config sha256:7328f6f8b41890597575cbaadc884e7386ae0acc53b747401ebce5cf0d624560
 0 B / 1.48 KB [---------------------------------------------------------------]
Writing manifest to image destination
Storing signatures
Loaded image:  registry.fedoraproject.org/fedora:latest
```

## SEE ALSO
**[podman(1)](podman.1.md)**, **[podman-save(1)](podman-save.1.md)**

## HISTORY
July 2017, Originally compiled by Urvashi Mohnani <umohnani@redhat.com>
