/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFResourceAdapter;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNStreamData;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNPath;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.ByteNumberFormat;

public abstract class DBNPathBase
extends DBNNode
implements DBNLazyNode {
    private static final Log log = Log.getLog(DBNPath.class);
    private static final DBNNode[] EMPTY_NODES = new DBNNode[0];
    private static final ByteNumberFormat numberFormat = new ByteNumberFormat();
    private DBNNode[] children;
    private transient Long size;
    private transient FileTime lastModified;

    protected DBNPathBase(DBNNode parentNode) {
        super(parentNode);
    }

    public abstract Path getPath();

    protected abstract void setPath(Path var1);

    @Override
    protected void dispose(boolean reflect) {
        this.children = null;
        super.dispose(reflect);
    }

    @Override
    public String getNodeType() {
        return DBNNode.NodePathType.dbvfs.name() + ".path";
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    public String getNodeDisplayName() {
        return this.getPath().getFileName().toString();
    }

    @Override
    public String getNodeDescription() {
        return null;
    }

    @Override
    public DBPImage getNodeIcon() {
        return this.getOwnerProject().getWorkspace().getResourceIcon(this);
    }

    @Override
    public boolean allowsChildren() {
        return this.isDirectory();
    }

    public boolean isDirectory() {
        DBNFileSystemRoot rootNode = this.getFileSystemRoot();
        return rootNode != null && rootNode.getRoot().getFileSystem().isDirectory(this.getPath());
    }

    @Override
    public DBNNode[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && this.isDirectory() && !monitor.isForceCacheUsage()) {
            this.children = this.readChildNodes(monitor);
        }
        return this.children;
    }

    protected DBNNode[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        List<DBNNode> result;
        block15: {
            Path path = this.getPath();
            if (this.isDirectory() && Files.exists(path, new LinkOption[0])) {
                try {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (Stream<Path> fileList = Files.list(path);){
                        result = new ArrayList<DBNNode>();
                        Iterator srcFile = fileList.iterator();
                        while (srcFile.hasNext()) {
                            if (monitor.isCanceled()) {
                                break block15;
                            }
                            result.add(this.makeNode((Path)srcFile.next()));
                        }
                        break block15;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new DBException("Error reading directory members", e);
                }
            }
            result = Collections.emptyList();
        }
        if (result.isEmpty()) {
            return EMPTY_NODES;
        }
        this.filterChildren(result);
        DBNNode[] childNodes = result.toArray(new DBNNode[0]);
        this.sortChildren(childNodes);
        return childNodes;
    }

    public DBNPathBase getChild(Path thePath) {
        if (this.children == null) {
            return null;
        }
        DBNNode[] dBNNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode child = dBNNodeArray[n2];
            if (child instanceof DBNPathBase && thePath.equals(((DBNPathBase)child).getPath())) {
                return (DBNPathBase)child;
            }
            ++n2;
        }
        return null;
    }

    public DBNPathBase getChild(String name) {
        if (this.children == null) {
            return null;
        }
        DBNNode[] dBNNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode child = dBNNodeArray[n2];
            if (child.getName().equals(name)) {
                return (DBNPathBase)child;
            }
            ++n2;
        }
        return null;
    }

    public void addChildResource(Path path) {
        if (this.children == null) {
            return;
        }
        DBNPath child = new DBNPath(this, path);
        this.children = (DBNNode[])ArrayUtils.add(DBNNode.class, (Object[])this.children, (Object)child);
        this.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, child));
    }

    public void removeChildResource(Path path) {
        if (this.children == null) {
            return;
        }
        DBNPathBase child = this.getChild(path);
        if (child != null) {
            this.children = (DBNNode[])ArrayUtils.remove(DBNNode.class, (Object[])this.children, (Object)child);
            this.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.REMOVE, child));
        }
    }

    private DBNPathBase makeNode(Path resource) {
        return new DBNPath(this, resource);
    }

    @Override
    public boolean isManagable() {
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        this.children = null;
        this.size = null;
        this.lastModified = null;
        this.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, DBNEvent.NodeChange.REFRESH, this));
        return this;
    }

    @Override
    @Deprecated
    public String getNodeItemPath() {
        return this.getParentNode().getNodeItemPath() + "/" + this.getName();
    }

    @Override
    public boolean supportsRename() {
        return true;
    }

    @Override
    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        Path path = this.getPath();
        try {
            this.setPath(Files.move(path, path.getParent().resolve(newName), new CopyOption[0]));
        }
        catch (IOException e) {
            throw new DBException("Cannot rename resource '" + String.valueOf(this.getPath()) + "'", e);
        }
        catch (UnsupportedOperationException e) {
            throw new DBException("File rename is not supported by file system '" + path.getFileSystem().provider().getScheme(), e);
        }
        this.getModel().fireNodeUpdate(this, this, DBNEvent.NodeChange.REFRESH);
    }

    @Override
    public boolean supportsDrop(DBNNode otherNode) {
        if (otherNode == null) {
            return true;
        }
        if (!this.isDirectory()) {
            return this.getParentNode().supportsDrop(otherNode);
        }
        DBPProject dBPProject = this.getOwnerProject();
        if (dBPProject instanceof DBFResourceAdapter) {
            DBNStreamData source;
            DBFResourceAdapter rm = (DBFResourceAdapter)((Object)dBPProject);
            return (otherNode.getAdapter(Path.class) != null || otherNode instanceof DBNStreamData && (source = (DBNStreamData)((Object)otherNode)).supportsStreamData()) && otherNode != this && otherNode.getParentNode() != this && !this.isChildOf(otherNode);
        }
        return false;
    }

    @Override
    public void dropNodes(DBRProgressMonitor monitor, Collection<DBNNode> nodes) throws DBException {
        Path folder;
        Path thisResource = this.getPath();
        if (thisResource == null) {
            return;
        }
        DBNNode nodeToRefresh = this;
        if (this.isDirectory()) {
            folder = thisResource;
        } else {
            folder = thisResource.getParent();
            nodeToRefresh = this.getParentNode();
        }
        if (nodes.isEmpty()) {
            return;
        }
        boolean doCopy = !this.isTheSameFileSystem(nodes.iterator().next());
        String action = (doCopy ? "Copy" : "Move") + " resource(s)";
        String message = action + "\n" + nodes.stream().map(DBNNode::getNodeDisplayName).collect(Collectors.joining(",")) + "\ninto folder " + String.valueOf(folder) + "?";
        if (!DBWorkbench.getPlatformUI().confirmAction(action, message)) {
            return;
        }
        monitor.beginTask("Drop files", nodes.size());
        try {
            try {
                for (DBNNode node : nodes) {
                    if (monitor.isCanceled()) break;
                    Path resource = node.getAdapter(Path.class);
                    if (resource == null) {
                        try {
                            Throwable throwable = null;
                            Object var10_14 = null;
                            try (InputStream inputStream = node.getAdapter(InputStream.class);){
                                if (inputStream == null) continue;
                                monitor.subTask("Copy file");
                                Files.copy(inputStream, folder.resolve(node.getNodeDisplayName()), new CopyOption[0]);
                                continue;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            monitor.worked(1);
                        }
                    }
                    if (Files.notExists(resource, new LinkOption[0])) {
                        log.debug("Resource " + String.valueOf(resource) + " doesn't not exists");
                        continue;
                    }
                    if (!Files.isRegularFile(resource, new LinkOption[0])) {
                        log.debug("Resource " + String.valueOf(resource) + " is not a file");
                        continue;
                    }
                    if (resource.getParent().equals(folder)) continue;
                    boolean doCopy2 = !this.isTheSameFileSystem(node);
                    boolean doDelete = false;
                    monitor.subTask((doCopy2 ? "Copy" : "Move") + " file " + String.valueOf(resource));
                    try {
                        Path targetFile = folder.resolve(resource.getFileName().toString());
                        if (!doCopy2) {
                            boolean wasMoved = false;
                            try {
                                Files.move(resource, targetFile, new CopyOption[0]);
                                wasMoved = true;
                            }
                            catch (Exception exception) {
                                log.debug("Underlying FS doesn't support file move. Do copy instead");
                            }
                            if (!wasMoved) {
                                doCopy2 = true;
                                doDelete = true;
                            }
                        }
                        if (doCopy2) {
                            CopyOption[] options = new CopyOption[]{};
                            if (Files.exists(targetFile, new LinkOption[0])) {
                                options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            }
                            Files.copy(resource, targetFile, options);
                        }
                        if (!doDelete) continue;
                        Files.delete(resource);
                    }
                    finally {
                        monitor.worked(1);
                    }
                }
                nodeToRefresh.refreshNode(monitor, this);
            }
            catch (Exception e) {
                throw new DBException("Error creating NIO resource", e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean isTheSameFileSystem(DBNNode node) {
        return false;
    }

    protected void filterChildren(List<DBNNode> list) {
    }

    protected void sortChildren(DBNNode[] list) {
        Arrays.sort(list, (o1, o2) -> {
            if (o1 instanceof DBNPathBase) {
                DBNPathBase p1 = (DBNPathBase)o1;
                if (o2 instanceof DBNPathBase) {
                    DBNPathBase p2 = (DBNPathBase)o2;
                    if (p1.isDirectory() && !p2.isDirectory()) {
                        return -1;
                    }
                    if (p2.isDirectory() && !p1.isDirectory()) {
                        return 1;
                    }
                }
            }
            return o1.getNodeDisplayName().compareToIgnoreCase(o2.getNodeDisplayName());
        });
    }

    public Collection<DBPDataSourceContainer> getAssociatedDataSources() {
        return Collections.emptyList();
    }

    public void refreshResourceState(Object source) {
        this.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, this));
    }

    @Property(viewable=true, order=10)
    public String getResourcePath() {
        return this.getPath() == null ? "" : this.getPath().toAbsolutePath().toString();
    }

    @Property(viewable=false, order=11)
    public String getResourceLocation() {
        return this.getPath() == null ? "" : this.getPath().toString();
    }

    @Property(viewable=true, order=11)
    public String getResourceSize() throws IOException {
        if (this.size == null) {
            try {
                this.size = this.getPath() == null ? 0L : Files.size(this.getPath());
            }
            catch (IOException e) {
                log.debug("Error reading file '" + String.valueOf(this.getPath()) + "' size", e);
            }
            if (this.size == null) {
                this.size = 0L;
            }
        }
        return numberFormat.format((Object)this.size);
    }

    @Property(viewable=true, order=11)
    public String getResourceLastModified() throws IOException {
        if (this.lastModified == null) {
            this.lastModified = Files.getLastModifiedTime(this.getPath(), new LinkOption[0]);
        }
        if (this.lastModified.toMillis() <= 0L) {
            return null;
        }
        return this.lastModified.toString();
    }

    protected boolean isResourceExists() {
        return this.getPath() != null && Files.exists(this.getPath(), new LinkOption[0]);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        DBFResourceAdapter rm;
        T result;
        DBPProject dBPProject;
        if (adapter == Path.class) {
            return adapter.cast(this.getPath());
        }
        DBNFileSystemRoot rootNode = this.getFileSystemRoot();
        if (rootNode != null && (dBPProject = this.getOwnerProject()) instanceof DBFResourceAdapter && (result = (rm = (DBFResourceAdapter)((Object)dBPProject)).adaptResource(rootNode.getRoot(), this.getPath(), adapter)) != null) {
            return result;
        }
        return super.getAdapter(adapter);
    }

    @Nullable
    private DBNFileSystemRoot getFileSystemRoot() {
        return this instanceof DBNFileSystemRoot ? (DBNFileSystemRoot)this : DBNUtils.getParentOfType(DBNFileSystemRoot.class, this);
    }

    @Override
    public String toString() {
        Path path = this.getPath();
        return path == null ? super.toString() : path.toString();
    }

    @Override
    public boolean needsInitialization() {
        return this.children == null;
    }
}

