/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.cert.extensions.V3Extension;

public class NetscapeCertType
implements V3Extension {
    String value = null;

    @Override
    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.BIT_STRING)) {
            throw new Exception("Wrong ASN.1 type for NetscapeCertType");
        }
        byte[] o = (byte[])asn1object.getValue();
        StringBuffer buff = new StringBuffer();
        if ((o[1] & 0xFFFFFF80) != 0) {
            buff.append("SSL client, ");
        }
        if ((o[1] & 0x40) != 0) {
            buff.append("SSL server, ");
        }
        if ((o[1] & 0x20) != 0) {
            buff.append("S/MIME, ");
        }
        if ((o[1] & 0x10) != 0) {
            buff.append("Object Signing, ");
        }
        if ((o[1] & 8) != 0) {
            buff.append("Reserved, ");
        }
        if ((o[1] & 4) != 0) {
            buff.append("SSL CA, ");
        }
        if ((o[1] & 2) != 0) {
            buff.append("S/MIME CA, ");
        }
        if ((o[1] & 1) != 0) {
            buff.append("Object Signing CA, ");
        }
        this.value = buff.toString();
        if (this.value.endsWith(", ")) {
            this.value = this.value.substring(0, this.value.length() - 2);
        }
    }

    public String toString() {
        return this.value;
    }
}

