/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.jndi.SchemaOps;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.broker.DataQuery;
import com.ca.directory.jxplorer.broker.JNDIDataBroker;
import com.ca.directory.jxplorer.search.SearchModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

public class JXWReplaceGUI
extends CBDialog {
    public JTextField findValue;
    public JTextField replaceValue;
    public JTextField searchAttributeTextField = null;
    public JRadioButton fullTree;
    public JRadioButton subTree;
    public JRadioButton plainText;
    public JRadioButton regExp;
    public JRadioButton prompt;
    public JRadioButton replaceAll;
    public CBJComboBox filterList;
    public CBJComboBox searchAttributeCombo = null;
    public CBButton dryRun;
    private static String defaultFindValue = "";
    private static String defaultReplaceValue = "";
    private static String defaultSearchAttribute = null;
    private static boolean defaultFullTree = false;
    private static boolean defaultPlainText = true;
    private static boolean defaultPrompt = true;
    final String ALL_ENTRIES = "<" + CBIntText.get((String)"all entries") + ">";
    protected SearchModel searchModel;
    protected JXplorerBrowser owningBrowser;
    private boolean findMode;
    private ArrayList<String> knownAttributes = new ArrayList();
    private static Logger log = Logger.getLogger(JXWReplaceGUI.class.getName());
    private static String ATT_START = "<$";
    private static String ATT_START_ESCAPED = "<\\$";
    private static String ATT_END = ">";
    static Pattern attEscapePattern = Pattern.compile(ATT_START_ESCAPED + "(.*?)" + ATT_END);

    public JXWReplaceGUI(JXplorerBrowser owner, boolean findOnly) {
        super((Frame)owner, CBIntText.get((String)"Text Replace"), "workbench.replace");
        this.findMode = findOnly;
        this.owningBrowser = owner;
        if (findOnly) {
            this.setSize(420, 250);
        } else {
            this.setSize(420, 270);
        }
        CBPanel display = this.getDisplayPanel();
        display.add((Component)new JLabel("   " + CBIntText.get((String)"Attribute:")));
        try {
            SchemaOps schema = owner.getSearchBroker().getSchemaOps();
            if (schema != null) {
                this.knownAttributes = schema.getKnownAttributeNames();
            }
            this.searchAttributeCombo = new CBJComboBox(this.knownAttributes.toArray());
            display.addGreedyWide((Component)this.searchAttributeCombo, 2);
            if (defaultSearchAttribute != null) {
                this.searchAttributeCombo.setSelectedItem((Object)defaultSearchAttribute);
            }
        }
        catch (NamingException e) {
            this.searchAttributeTextField = new JTextField(" ", 30);
            display.addGreedyWide((Component)this.searchAttributeTextField, 2);
        }
        display.addLine((Component)new JLabel("  "));
        display.add((Component)new JLabel("   " + CBIntText.get((String)"Text to Find") + ":"));
        this.findValue = new JTextField(defaultFindValue, 30);
        display.addWide((Component)this.findValue, 2);
        display.addLine((Component)new JLabel("  "));
        if (this.findMode) {
            this.replaceValue = new JTextField();
        } else {
            display.add((Component)new JLabel("   " + CBIntText.get((String)"Replace With") + ":"));
            this.replaceValue = new JTextField(defaultReplaceValue, 30);
            display.addWide((Component)this.replaceValue, 2);
            display.addLine((Component)new JLabel("  "));
        }
        this.searchModel = new SearchModel();
        ArrayList filterNames = this.searchModel.getFilterNames(2);
        Collections.sort(filterNames);
        filterNames.add(0, this.ALL_ENTRIES);
        this.filterList = new CBJComboBox(filterNames.toArray());
        display.add((Component)new JLabel("   " + CBIntText.get((String)"Search Filter") + ":"));
        display.addWide((Component)this.filterList, 2);
        display.addLine((Component)new JLabel("  "));
        if (!this.findMode) {
            CBPanel dryRunInset = new CBPanel();
            dryRunInset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Method")));
            this.prompt = new JRadioButton(CBIntText.get((String)"Prompt"), defaultPrompt);
            dryRunInset.addln((Component)this.prompt);
            this.replaceAll = new JRadioButton(CBIntText.get((String)"Replace All"), !defaultPrompt);
            dryRunInset.addln((Component)this.replaceAll);
            ButtonGroup methodGroup = new ButtonGroup();
            methodGroup.add(this.prompt);
            methodGroup.add(this.replaceAll);
            display.add((Component)dryRunInset);
        } else {
            display.add((Component)new JLabel(" "));
        }
        CBPanel scopeInset = new CBPanel();
        scopeInset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Scope")));
        this.fullTree = new JRadioButton(CBIntText.get((String)"Full Tree"), defaultFullTree);
        scopeInset.addln((Component)this.fullTree);
        this.subTree = new JRadioButton(CBIntText.get((String)"Sub Tree"), !defaultFullTree);
        scopeInset.addln((Component)this.subTree);
        ButtonGroup scopeGroup = new ButtonGroup();
        scopeGroup.add(this.fullTree);
        scopeGroup.add(this.subTree);
        display.add((Component)scopeInset);
        CBPanel regexpInset = new CBPanel();
        regexpInset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Matching")));
        this.plainText = new JRadioButton(CBIntText.get((String)"Plain Text"), defaultPlainText);
        regexpInset.addln((Component)this.plainText);
        this.regExp = new JRadioButton(CBIntText.get((String)"Use RegExp"), !defaultPlainText);
        regexpInset.add((Component)this.regExp);
        ButtonGroup regExpGroup = new ButtonGroup();
        regExpGroup.add(this.plainText);
        regExpGroup.add(this.regExp);
        display.add((Component)regexpInset);
        if (this.findMode) {
            this.OK.setText(CBIntText.get((String)"Find"));
        } else {
            this.dryRun = new CBButton(CBIntText.get((String)"Test"), CBIntText.get((String)"Test search and replace without modifying the directory."));
            this.buttonPanel.add((Component)this.dryRun, 0);
            this.OK.setText(CBIntText.get((String)"Replace"));
            this.dryRun.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JXWReplaceGUI.this.doDryRun();
                }
            });
        }
        CBUtility.center((Component)((Object)this), (Component)owner);
    }

    public void doOK() {
        this.doSearch(false);
    }

    public void doDryRun() {
        this.doSearch(true);
    }

    protected void doSearch(boolean doDryRun) {
        String replaceText;
        String attribute = this.searchAttributeCombo == null ? this.searchAttributeTextField.getText() : this.searchAttributeCombo.getSelectedItem().toString();
        attribute = attribute.trim();
        String findText = this.findValue.getText().trim();
        ArrayList<String> attributesOfInterest = this.getAllAttributesInvolvedInSearch(findText, replaceText = this.replaceValue.getText().trim(), attribute);
        if (attributesOfInterest == null) {
            return;
        }
        String selectedSearch = this.filterList.getSelectedItem().toString();
        String searchFilter = this.constructSearchFilter(selectedSearch, attribute, findText);
        boolean fullTreeScope = this.fullTree.isSelected();
        DN searchBaseDN = fullTreeScope ? this.owningBrowser.getTree().getRootDN() : this.owningBrowser.getTree().getCurrentDN();
        boolean evalRegExp = this.regExp.isSelected();
        defaultSearchAttribute = attribute;
        defaultFindValue = findText;
        defaultReplaceValue = replaceText;
        defaultFullTree = fullTreeScope;
        defaultPlainText = !evalRegExp;
        JNDIDataBroker broker = this.owningBrowser.getSearchBroker();
        if (this.findMode) {
            broker.extendedRequest((DataQuery)new FindQuery(this, this.owningBrowser, searchBaseDN, searchFilter, evalRegExp, doDryRun, false, attribute, attributesOfInterest, this.findValue.getText(), null));
        } else {
            boolean promptUser;
            defaultPrompt = promptUser = this.prompt.isSelected();
            broker.extendedRequest((DataQuery)new FindQuery(this, this.owningBrowser, searchBaseDN, searchFilter, evalRegExp, doDryRun, promptUser, attribute, attributesOfInterest, this.findValue.getText(), this.replaceValue.getText()));
        }
    }

    private ArrayList<String> getAllAttributesInvolvedInSearch(String findText, String replaceText, String attribute) {
        ArrayList<String> involvedAtts = new ArrayList<String>();
        involvedAtts.add(attribute);
        if (findText.indexOf(ATT_START) < 0 && replaceText.indexOf(ATT_START) < 0) {
            return involvedAtts;
        }
        ArrayList<String> unknownAtts = new ArrayList<String>();
        Matcher m = attEscapePattern.matcher(findText + replaceText);
        while (m.find()) {
            String candidate = m.group(1);
            if (this.knownAttributes.contains(candidate)) {
                involvedAtts.add(candidate);
                continue;
            }
            unknownAtts.add(candidate);
        }
        if (unknownAtts.size() > 0) {
            StringBuffer msg = new StringBuffer(CBIntText.get((String)"Some <$...> attributes were unknown: \n"));
            for (String att : unknownAtts) {
                msg.append(" * ").append(att).append("\n");
            }
            msg.append(CBIntText.get((String)"Check spelling and case."));
            JOptionPane.showMessageDialog((Component)((Object)this), msg.toString(), CBIntText.get((String)"Parsing Error"), 0);
            return null;
        }
        return involvedAtts;
    }

    private String constructSearchFilter(String selectedSearch, String attribute, String findVal) {
        if (this.ALL_ENTRIES.equals(selectedSearch) || selectedSearch == null) {
            return "(" + attribute + "=*)";
        }
        String filter = this.searchModel.getFilter(selectedSearch);
        if (findVal == null || findVal.length() == 0) {
            return filter;
        }
        return "(&(" + attribute + "=*)" + filter + ")";
    }

    static class SearchTableModel
    extends AbstractTableModel {
        private ArrayList<FindResult> results;
        private boolean replacing;

        public SearchTableModel(ArrayList<FindResult> resultSet, boolean showReplacementColumn) {
            this.results = resultSet;
            this.replacing = showReplacementColumn;
        }

        @Override
        public int getColumnCount() {
            return this.replacing ? 3 : 2;
        }

        @Override
        public int getRowCount() {
            return this.results.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.results.get(row);
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return CBIntText.get((String)"Entry DN");
                }
                case 1: {
                    return CBIntText.get((String)"Old Value");
                }
                case 2: {
                    return CBIntText.get((String)"New Value");
                }
            }
            return " - ";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return FindResult.class;
        }
    }

    static class FancyTableCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        Color highlightColour = new Color(180, 212, 255);

        FancyTableCellRenderer() {
        }

        public void setValue(Object value) {
            this.setText(value.toString());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof FindResult) {
                FindResult result = (FindResult)value;
                switch (column) {
                    case 0: {
                        this.setForeground(Color.blue);
                        this.setValue(result.name.toString());
                        this.setToolTipText(result.name.toString());
                        break;
                    }
                    case 1: {
                        this.setForeground(Color.black);
                        String text = result.originalText;
                        int offset = 0;
                        if (result.getFindRegionStart(0) > 20) {
                            offset = result.getFindRegionStart(0) - 20;
                            text = "..." + text.substring(offset + 3);
                        }
                        this.setValue(text);
                        try {
                            for (int i = 0; i < result.numberOfFindRegions(); ++i) {
                                this.getHighlighter().addHighlight(result.getFindRegionStart(i) - offset, result.getFindRegionEnd(i) - offset, new DefaultHighlighter.DefaultHighlightPainter(this.highlightColour));
                            }
                            break;
                        }
                        catch (BadLocationException e) {
                            log.severe("oops " + e.getMessage());
                            break;
                        }
                    }
                    case 2: {
                        this.setForeground(Color.black);
                        int replaceOffset = 0;
                        String replaceText = result.replacementText;
                        if (result.getReplaceRegionStart(0) > 20) {
                            replaceOffset = result.getReplaceRegionStart(0) - 20;
                            replaceText = "..." + replaceText.substring(replaceOffset + 3);
                        }
                        this.setValue(replaceText);
                        try {
                            for (int i = 0; i < result.numberOfFindRegions(); ++i) {
                                this.getHighlighter().addHighlight(result.getReplaceRegionStart(i) - replaceOffset, result.getReplaceRegionEnd(i) - replaceOffset, new DefaultHighlighter.DefaultHighlightPainter(this.highlightColour));
                            }
                            break;
                        }
                        catch (BadLocationException e) {
                            log.severe("oops " + e.getMessage());
                            break;
                        }
                    }
                    default: {
                        this.setValue("<error>");
                    }
                }
            } else {
                this.setValue("oops - unexpected class in result table: " + value.getClass().toString());
            }
            return this;
        }
    }

    static class FindResult {
        public DN name;
        private String originalText;
        private String replacementText;
        int[] findStart;
        int[] findEnd;
        int[] replaceStart;
        int[] replaceEnd;

        public FindResult(DN entryDN, String entryOriginalText) {
            this.name = entryDN;
            this.originalText = entryOriginalText;
        }

        public FindResult(DN entryDN, String entryOriginalText, String entryReplacementText) {
            this.name = entryDN;
            this.originalText = entryOriginalText;
            this.replacementText = entryReplacementText;
        }

        public void setReplacementText(String replacement) {
            this.replacementText = replacement;
        }

        public String getReplacementText() {
            return this.replacementText;
        }

        public void addFindRegion(int startPos, int endPos) {
            if (this.findStart == null) {
                this.findStart = new int[]{startPos};
                this.findEnd = new int[]{endPos};
            } else {
                int[] startList = new int[this.findStart.length + 1];
                int[] endList = new int[this.findStart.length + 1];
                for (int i = 0; i < this.findStart.length; ++i) {
                    startList[i] = this.findStart[i];
                    endList[i] = this.findEnd[i];
                }
                startList[this.findStart.length] = startPos;
                endList[this.findStart.length] = endPos;
                this.findStart = startList;
                this.findEnd = endList;
            }
        }

        public int numberOfFindRegions() {
            return this.findStart == null ? 0 : this.findStart.length;
        }

        public int getFindRegionStart(int index) {
            if (index >= 0 && index < this.findStart.length) {
                return this.findStart[index];
            }
            return 0;
        }

        public int getFindRegionEnd(int index) {
            if (index >= 0 && index < this.findEnd.length) {
                return this.findEnd[index];
            }
            return 0;
        }

        public void addReplaceRegion(int startPos, int endPos) {
            if (this.replaceStart == null) {
                this.replaceStart = new int[]{startPos};
                this.replaceEnd = new int[]{endPos};
            } else {
                int[] startList = new int[this.replaceStart.length + 1];
                int[] endList = new int[this.replaceStart.length + 1];
                for (int i = 0; i < this.replaceStart.length; ++i) {
                    startList[i] = this.replaceStart[i];
                    endList[i] = this.replaceEnd[i];
                }
                startList[this.replaceStart.length] = startPos;
                endList[this.replaceStart.length] = endPos;
                this.replaceStart = startList;
                this.replaceEnd = endList;
            }
        }

        public int numberOfReplaceRegions() {
            return this.replaceStart == null ? 0 : this.replaceStart.length;
        }

        public int getReplaceRegionStart(int index) {
            if (index >= 0 && index < this.replaceStart.length) {
                return this.replaceStart[index];
            }
            return 0;
        }

        public int getReplaceRegionEnd(int index) {
            if (index >= 0 && index < this.replaceEnd.length) {
                return this.replaceEnd[index];
            }
            return 0;
        }

        public void debugPrint() {
            int i;
            int lastEnd = 0;
            for (i = 0; i < this.numberOfFindRegions(); ++i) {
                System.out.println("(" + lastEnd + ", " + this.replaceStart[i] + ")- " + this.replacementText.substring(lastEnd, this.replaceStart[i]));
                System.out.println("(" + this.replaceStart[i] + ", " + this.replaceEnd[i] + ")+ " + this.replacementText.substring(this.replaceStart[i], this.replaceEnd[i]));
                lastEnd = this.replaceEnd[i];
            }
            for (i = 0; i < this.numberOfFindRegions(); ++i) {
                System.out.print(this.replacementText.substring(i == 0 ? 0 : this.replaceEnd[i - 1], this.replaceStart[i]));
                System.out.print("/" + this.replacementText.substring(this.replaceStart[i], this.replaceEnd[i]) + "/");
            }
            System.out.println(this.replacementText.substring(this.replaceEnd[this.numberOfFindRegions() - 1]));
        }
    }

    static class FindQuery
    extends DataQuery {
        DN searchBaseDN;
        String searchBase;
        String searchFilter;
        boolean evalRegExp;
        boolean dryRun;
        boolean promptUser;
        boolean replace;
        String mainAttribute;
        ArrayList<String> attributesOfInterest;
        String findText;
        String replaceText = null;
        JXWReplaceGUI parent;
        final JXplorerBrowser browser;
        private ArrayList<FindResult> resultSet;

        public FindQuery(JXWReplaceGUI parent, JXplorerBrowser owningBrowser, DN searchBaseDN, String searchFilter, boolean evalRegExp, boolean dryRun, boolean promptUser, String mainAttribute, ArrayList<String> attributes, String findText, String replaceText) {
            super(256);
            this.searchBaseDN = searchBaseDN;
            this.searchBase = searchBaseDN.toString();
            this.searchFilter = searchFilter;
            this.evalRegExp = evalRegExp;
            this.dryRun = dryRun;
            this.attributesOfInterest = attributes;
            this.mainAttribute = mainAttribute;
            this.findText = findText;
            this.parent = parent;
            this.promptUser = promptUser;
            this.browser = owningBrowser;
            this.resultSet = new ArrayList(10);
            this.replaceText = replaceText;
            this.replace = replaceText != null;
            log.fine("Search/Replace Query:  searchBase: " + searchBaseDN + " filter: " + searchFilter + " regexp? " + evalRegExp + " find text: " + findText);
        }

        public FindQuery() {
            this.browser = null;
        }

        public void doExtendedRequest(DataBroker broker) {
            ProgressMonitor progressMonitor = new ProgressMonitor((Component)((Object)this.parent), CBIntText.get((String)"Finding Matches"), "", 0, 100);
            try {
                progressMonitor.setProgress(5);
                progressMonitor.setMillisToPopup(1000);
                DXNamingEnumeration findResults = broker.unthreadedSearch(this.searchBaseDN, this.searchFilter, this.searchLevel, this.attributesOfInterest.toArray(new String[0]));
                progressMonitor.setProgress(25);
                ArrayList findList = findResults.getArrayList();
                int size = findList.size();
                progressMonitor.setNote(CBIntText.get((String)"Processing {0} results", (Object[])new String[]{String.valueOf(size)}));
                this.processResults(findList, progressMonitor, broker);
            }
            catch (NamingException e) {
                this.setException(e);
            }
            progressMonitor.close();
            this.showResultSet();
        }

        public void processResults(ArrayList<SearchResult> findList, ProgressMonitor progressMonitor, DataBroker broker) throws NamingException {
            boolean substituteFind = this.findText.indexOf(ATT_START) > -1;
            boolean substituteReplace = this.replace && this.replaceText.indexOf(ATT_START) > -1;
            Pattern matchingFindPattern = null;
            if (this.evalRegExp) {
                matchingFindPattern = Pattern.compile(this.findText);
            }
            DXAttribute newAtt = new DXAttribute(this.mainAttribute);
            ArrayList<FindResult> pendingChanges = new ArrayList<FindResult>();
            for (int entryNo = 0; entryNo < findList.size(); ++entryNo) {
                SearchResult foundObject = findList.get(entryNo);
                DN foundObjectDN = this.getDN(foundObject.getName());
                DXAttributes allAtts = new DXAttributes(foundObject.getAttributes());
                DXAttribute searchAtt = allAtts.get(this.mainAttribute);
                if (searchAtt != null) {
                    for (int attCount = 0; attCount < searchAtt.size(); ++attCount) {
                        if (searchAtt.get(attCount) == null) continue;
                        String textToProcess = searchAtt.get(attCount).toString();
                        String findTerm = substituteFind ? this.insertAttributeValues(this.findText, allAtts, foundObjectDN) : this.findText;
                        FindResult newResult = null;
                        String replaceTerm = null;
                        if (this.replace) {
                            String string = replaceTerm = substituteReplace ? this.insertAttributeValues(this.replaceText, allAtts, foundObjectDN) : this.replaceText;
                        }
                        if (this.evalRegExp) {
                            if (substituteFind) {
                                matchingFindPattern = Pattern.compile(findTerm);
                            }
                            newResult = this.processSearchReplaceText(textToProcess, matchingFindPattern, replaceTerm, foundObjectDN, this.replace);
                        } else {
                            newResult = this.processSearchReplaceText(textToProcess, findTerm, replaceTerm, foundObjectDN, this.replace);
                        }
                        if (newResult == null) continue;
                        this.resultSet.add(newResult);
                        if (!this.replace || this.dryRun) continue;
                        newAtt.add((Object)newResult.replacementText);
                    }
                    if (this.replace && !this.dryRun && newAtt.size() > 0) {
                        this.updateDirectory(broker, newAtt, pendingChanges, foundObject, (Attribute)searchAtt);
                        newAtt.clear();
                    }
                }
                progressMonitor.setProgress(25 + entryNo * 75 / findList.size());
                if (!progressMonitor.isCanceled()) continue;
                throw new NamingException(CBIntText.get((String)"user cancelled search"));
            }
        }

        FindResult processSearchReplaceText(String textToProcess, Pattern matchingFindPattern, String replaceTerm, DN foundObjectDN, boolean doReplace) {
            FindResult newResult = null;
            Matcher matcher = matchingFindPattern.matcher(textToProcess);
            if (matcher.find()) {
                newResult = new FindResult(foundObjectDN, textToProcess);
                newResult.addFindRegion(matcher.start(), matcher.end());
                while (matcher.find()) {
                    newResult.addFindRegion(matcher.start(), matcher.end());
                }
                if (doReplace) {
                    matcher.reset();
                    StringBuffer replaceBuffer = new StringBuffer();
                    int lastFindEnd = 0;
                    int lastBufferLength = 0;
                    while (matcher.find()) {
                        matcher.appendReplacement(replaceBuffer, replaceTerm);
                        int currentUnmodifiedSpan = matcher.start() - lastFindEnd;
                        lastFindEnd = matcher.end();
                        int bufferLength = replaceBuffer.length();
                        int replacementTextLength = bufferLength - lastBufferLength - currentUnmodifiedSpan;
                        lastBufferLength = bufferLength;
                        newResult.addReplaceRegion(bufferLength - replacementTextLength, bufferLength);
                    }
                    matcher.appendTail(replaceBuffer);
                    newResult.replacementText = replaceBuffer.toString();
                }
            }
            return newResult;
        }

        FindResult processSearchReplaceText(String textToProcess, String findTerm, String replaceTerm, DN foundObjectDN, boolean doReplace) {
            FindResult newResult = null;
            if (textToProcess.contains(findTerm)) {
                newResult = new FindResult(foundObjectDN, textToProcess);
                int start = 0;
                while ((start = textToProcess.indexOf(findTerm, start)) > -1) {
                    int end = start + findTerm.length();
                    newResult.addFindRegion(start, end);
                    start = end;
                }
                if (doReplace) {
                    start = 0;
                    int findTermLength = findTerm.length();
                    int replaceTermLength = replaceTerm.length();
                    StringBuffer replacementTextBuffer = new StringBuffer(textToProcess);
                    while ((start = replacementTextBuffer.indexOf(findTerm, start)) > -1) {
                        replacementTextBuffer.delete(start, start + findTermLength);
                        replacementTextBuffer.insert(start, replaceTerm);
                        int end = start + replaceTermLength;
                        newResult.addReplaceRegion(start, end);
                        start = end;
                    }
                    newResult.replacementText = replacementTextBuffer.toString();
                }
            }
            return newResult;
        }

        private String insertAttributeValues(String text, DXAttributes atts, DN dn) {
            Matcher m = attEscapePattern.matcher(text);
            StringBuffer buffy = new StringBuffer();
            while (m.find()) {
                String id = m.group(1);
                String value = "";
                try {
                    Object o;
                    if (atts.get(id) != null && (o = atts.get(id).get()) != null) {
                        value = o.toString();
                    }
                }
                catch (NamingException e) {
                    log.fine("error getting replacement value for <$" + id + "> term: " + e.getMessage());
                }
                m.appendReplacement(buffy, value);
            }
            m.appendTail(buffy);
            return buffy.toString();
        }

        private void updateDirectory(DataBroker broker, DXAttribute newAtt, ArrayList<FindResult> pendingChanges, SearchResult foundObject, Attribute att) throws NamingException {
            DN entryDN = this.getDN(foundObject.getName());
            DXEntry oldEntry = new DXEntry(att, entryDN);
            DXEntry newEntry = new DXEntry((Attribute)newAtt, entryDN);
            if (!this.promptUser || this.prompt(entryDN, att, (Attribute)newAtt)) {
                log.fine("modifying entry: " + entryDN.toString() + " writing value: " + newAtt.toDebugString());
                broker.unthreadedModify(oldEntry, newEntry);
            }
        }

        protected boolean prompt(DN entryDN, Attribute oldAtt, Attribute newAtt) throws NamingException {
            String message = CBIntText.get((String)"Confirm change of ") + entryDN.toString() + "\n from: " + DXAttribute.toFormattedString((Attribute)oldAtt) + "\n   to: " + DXAttribute.toFormattedString((Attribute)newAtt);
            int result = JOptionPane.showConfirmDialog((Component)((Object)this.parent), message, CBIntText.get((String)"Confirm Change"), 1);
            if (result == 2) {
                throw new NamingException(CBIntText.get((String)"user cancelled search"));
            }
            return result == 0;
        }

        void showResultSet() {
            if (this.resultSet.size() == 0) {
                JOptionPane.showMessageDialog(null, CBIntText.get((String)"No matching results were found"), CBIntText.get((String)"No Results"), 2);
            } else {
                SearchTableModel dataModel = new SearchTableModel(this.resultSet, this.replaceText != null);
                final JTable table = new JTable(dataModel);
                FancyTableCellRenderer fancyRenderer = new FancyTableCellRenderer();
                table.setDefaultRenderer(FindResult.class, fancyRenderer);
                table.getColumnModel().setColumnMargin(10);
                JScrollPane scrollpane = new JScrollPane(table);
                final CBDialog resultDialog = new CBDialog((Frame)this.browser, CBIntText.get((String)"Results"), null);
                resultDialog.setSize(800, 600);
                resultDialog.makeHeavy();
                resultDialog.add((Component)scrollpane);
                CBUtility.center((Component)resultDialog, (Component)this.browser);
                table.addMouseMotionListener(new MouseAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (table.columnAtPoint(new Point(e.getX(), e.getY())) == 0) {
                            CBUtility.setHandCursor((Component)table);
                        } else {
                            CBUtility.setNormalCursor((Component)table);
                        }
                    }
                });
                table.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (table.columnAtPoint(new Point(e.getX(), e.getY())) == 0) {
                            int row = table.rowAtPoint(new Point(e.getX(), e.getY()));
                            FindResult result = (FindResult)FindQuery.this.resultSet.get(row);
                            DN targetDN = result.name;
                            FindQuery.this.browser.getTree().readAndExpandDN(targetDN);
                            resultDialog.doCancel();
                            FindQuery.this.parent.doCancel();
                            FindQuery.this.browser.getTreeTabPane().setSelectedComponent(FindQuery.this.browser.getExplorePanel());
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (table.columnAtPoint(new Point(e.getX(), e.getY())) == 0) {
                            CBUtility.setHandCursor((Component)table);
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (table.columnAtPoint(new Point(e.getX(), e.getY())) != 0) {
                            CBUtility.setNormalCursor((Component)table);
                        }
                    }
                });
                resultDialog.setVisible(true);
            }
        }

        public DN getDN(String name) {
            if (name.endsWith(this.searchBase)) {
                return new DN(name);
            }
            return new DN(name + "," + this.searchBase);
        }
    }
}

