/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.testprovider;

import java.util.ArrayList;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;

class TreeEntry
extends BasicAttributes {
    public static String OBJECTCLASS = "objectClass";
    public static String PLACEHOLDER = "placeHolder";
    Name name;
    ArrayList<TreeEntry> children;

    public TreeEntry(Name entryName) {
        this(entryName, new String[]{OBJECTCLASS, PLACEHOLDER});
    }

    private void setup(Name entryName) {
        this.name = entryName;
        this.children = new ArrayList();
    }

    public TreeEntry(Name entryName, String[] attributeNamesAndValues) {
        super(true);
        this.setup(entryName);
        for (int i = 0; i < attributeNamesAndValues.length; i += 2) {
            this.put(new BasicAttribute(attributeNamesAndValues[i], attributeNamesAndValues[i + 1]));
        }
    }

    public TreeEntry(Name entryName, Attributes entryAtts) {
        super(true);
        this.setup(entryName);
        NamingEnumeration<? extends Attribute> newAtts = entryAtts.getAll();
        while (newAtts.hasMoreElements()) {
            this.put((Attribute)newAtts.nextElement());
        }
    }

    @Override
    public Object clone() {
        return new TreeEntry(this.getName(), (Attributes)super.clone());
    }

    public Attributes cloneAtts() {
        BasicAttributes newAtts = new BasicAttributes();
        NamingEnumeration<Attribute> atts = this.getAll();
        while (atts.hasMoreElements()) {
            newAtts.put((BasicAttribute)((BasicAttribute)atts.nextElement()).clone());
        }
        return newAtts;
    }

    public void addChild(TreeEntry child) {
        this.children.add(child);
    }

    public void removeChild(TreeEntry child) {
        this.children.remove(child);
    }

    public void replaceChild(TreeEntry oldChild, TreeEntry newChild) {
        this.children.remove(oldChild);
        this.children.add(newChild);
    }

    public ArrayList<TreeEntry> getChildren() {
        return this.children;
    }

    public Name getParent() {
        if (this.name.size() == 0) {
            return null;
        }
        return this.name.getPrefix(this.name.size() - 1);
    }

    public void setName(Name newName) {
        this.name = newName;
    }

    public Name getName() {
        return this.name;
    }

    public String getStringName() {
        return this.name.toString();
    }

    @Override
    public String toString() {
        try {
            StringBuffer text = new StringBuffer(this.getStringName()).append("\n");
            for (TreeEntry child : this.children) {
                text.append("     -> ").append(child.getName()).append("\n");
            }
            NamingEnumeration<Attribute> atts = this.getAll();
            while (atts.hasMoreElements()) {
                Attribute att = (Attribute)atts.nextElement();
                text.append("    * ").append(att.getID());
                NamingEnumeration<?> vals = att.getAll();
                while (vals.hasMore()) {
                    text.append(" : " + vals.next());
                }
                text.append("\n");
            }
            return text.toString();
        }
        catch (NamingException e) {
            return "unexpected exception: " + e.toString();
        }
    }

    @Override
    public boolean equals(Object obj) {
        try {
            return ((TreeEntry)obj).getName().equals(this.name);
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

