/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-line-mode.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_EDITOR_LINE_MODE_H_
#define _IANJUTA_EDITOR_LINE_MODE_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-editor.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_EDITOR_LINE_MODE (ianjuta_editor_line_mode_get_type ())
#define IANJUTA_EDITOR_LINE_MODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_EDITOR_LINE_MODE, IAnjutaEditorLineMode))
#define IANJUTA_IS_EDITOR_LINE_MODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_EDITOR_LINE_MODE))
#define IANJUTA_EDITOR_LINE_MODE_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_EDITOR_LINE_MODE, IAnjutaEditorLineModeIface))

#define IANJUTA_TYPE_EDITOR_LINE_MODE_TYPE (ianjuta_editor_line_mode_type_get_type())

#define IANJUTA_EDITOR_LINE_MODE_ERROR ianjuta_editor_line_mode_error_quark()

typedef struct _IAnjutaEditorLineMode IAnjutaEditorLineMode;
typedef struct _IAnjutaEditorLineModeIface IAnjutaEditorLineModeIface;

/**
   * IAnjutaEditorLineModeType:
   * @IANJUTA_EDITOR_LINE_MODE_LF: Line-Feed (Unix)
   * @IANJUTA_EDITOR_LINE_MODE_CR: Carat return (Max)
   * @IANJUTA_EDITOR_LINE_MODE_CRLF: Caret return + line-feed (Windows)
   *
   * This enumeration is used to specify the type of text. Note that not all
   * editors implement this.
   */
typedef enum {
	IANJUTA_EDITOR_LINE_MODE_LF,
	IANJUTA_EDITOR_LINE_MODE_CR,
	IANJUTA_EDITOR_LINE_MODE_CRLF
} IAnjutaEditorLineModeType;


struct _IAnjutaEditorLineModeIface {
	IAnjutaEditorIface g_iface;
	

	void (*convert) (IAnjutaEditorLineMode *obj, IAnjutaEditorLineModeType mode, GError **err);
	void (*fix) (IAnjutaEditorLineMode *obj, GError **err);
	IAnjutaEditorLineModeType (*get) (IAnjutaEditorLineMode *obj, GError **err);
	void (*set) (IAnjutaEditorLineMode *obj, IAnjutaEditorLineModeType mode, GError **err);

};

GType ianjuta_editor_line_mode_type_get_type (void);

GQuark ianjuta_editor_line_mode_error_quark     (void);
GType  ianjuta_editor_line_mode_get_type        (void);

void ianjuta_editor_line_mode_convert (IAnjutaEditorLineMode *obj, IAnjutaEditorLineModeType mode, GError **err);

void ianjuta_editor_line_mode_fix (IAnjutaEditorLineMode *obj, GError **err);

IAnjutaEditorLineModeType ianjuta_editor_line_mode_get (IAnjutaEditorLineMode *obj, GError **err);

void ianjuta_editor_line_mode_set (IAnjutaEditorLineMode *obj, IAnjutaEditorLineModeType mode, GError **err);


G_END_DECLS

#endif
