/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javaslang.Kind2;
import javaslang.Lazy;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.AbstractMap;
import javaslang.collection.Collections;
import javaslang.collection.HashArrayMappedTrie;
import javaslang.collection.HashSet;
import javaslang.collection.Iterator;
import javaslang.collection.Seq;
import javaslang.collection.Set;
import javaslang.collection.Traversable;
import javaslang.control.Option;

public final class HashMap<K, V>
extends AbstractMap<K, V, HashMap<K, V>>
implements Kind2<HashMap<?, ?>, K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final HashMap<?, ?> EMPTY = new HashMap(HashArrayMappedTrie.empty());
    private final HashArrayMappedTrie<K, V> trie;
    private final transient Lazy<Integer> hash;

    private HashMap(HashArrayMappedTrie<K, V> trie) {
        this.trie = trie;
        this.hash = Lazy.of(() -> Traversable.hash(trie::iterator));
    }

    public static <K, V> Collector<Tuple2<K, V>, ArrayList<Tuple2<K, V>>, HashMap<K, V>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Tuple2> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, HashMap> finisher = HashMap::ofEntries;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <K, V> HashMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> HashMap<K, V> narrow(HashMap<? extends K, ? extends V> hashMap) {
        return hashMap;
    }

    public static <K, V> HashMap<K, V> of(Tuple2<? extends K, ? extends V> entry) {
        return new HashMap(HashArrayMappedTrie.empty().put(entry._1, entry._2));
    }

    public static <K, V> HashMap<K, V> ofAll(Map<? extends K, ? extends V> map) {
        Objects.requireNonNull(map, "map is null");
        HashArrayMappedTrie<K, V> tree = HashArrayMappedTrie.empty();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            tree = tree.put(entry.getKey(), entry.getValue());
        }
        return HashMap.wrap(tree);
    }

    public static <K, V> HashMap<K, V> of(K key, V value) {
        return new HashMap(HashArrayMappedTrie.empty().put(key, value));
    }

    public static <K, V> HashMap<K, V> of(Object ... pairs) {
        Objects.requireNonNull(pairs, "pairs is null");
        if ((pairs.length & 1) != 0) {
            throw new IllegalArgumentException("Odd length of key-value pairs list");
        }
        HashArrayMappedTrie<Object, Object> trie = HashArrayMappedTrie.empty();
        for (int i = 0; i < pairs.length; i += 2) {
            trie = trie.put(pairs[i], pairs[i + 1]);
        }
        return HashMap.wrap(trie);
    }

    public static <K, V> HashMap<K, V> tabulate(int n, Function<? super Integer, ? extends Tuple2<? extends K, ? extends V>> f) {
        Objects.requireNonNull(f, "f is null");
        return HashMap.ofEntries(Collections.tabulate(n, f));
    }

    public static <K, V> HashMap<K, V> fill(int n, Supplier<? extends Tuple2<? extends K, ? extends V>> s) {
        Objects.requireNonNull(s, "s is null");
        return HashMap.ofEntries(Collections.fill(n, s));
    }

    @SafeVarargs
    public static <K, V> HashMap<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        Objects.requireNonNull(entries, "entries is null");
        HashArrayMappedTrie<K, V> trie = HashArrayMappedTrie.empty();
        for (Map.Entry<K, V> entry : entries) {
            trie = trie.put(entry.getKey(), entry.getValue());
        }
        return HashMap.wrap(trie);
    }

    @SafeVarargs
    public static <K, V> HashMap<K, V> ofEntries(Tuple2<? extends K, ? extends V> ... entries) {
        Objects.requireNonNull(entries, "entries is null");
        HashArrayMappedTrie trie = HashArrayMappedTrie.empty();
        for (Tuple2<? extends K, ? extends V> entry : entries) {
            trie = trie.put(entry._1, entry._2);
        }
        return HashMap.wrap(trie);
    }

    public static <K, V> HashMap<K, V> ofEntries(Iterable<? extends Tuple2<? extends K, ? extends V>> entries) {
        Objects.requireNonNull(entries, "entries is null");
        if (entries instanceof HashMap) {
            return (HashMap)entries;
        }
        HashArrayMappedTrie trie = HashArrayMappedTrie.empty();
        for (Tuple2<K, V> tuple2 : entries) {
            trie = trie.put(tuple2._1, tuple2._2);
        }
        return HashMap.wrap(trie);
    }

    @Override
    HashMap<K, V> createFromEntries(Iterable<? extends Tuple2<? extends K, ? extends V>> entries) {
        return HashMap.ofEntries(entries);
    }

    @Override
    HashMap<K, V> emptyInstance() {
        return HashMap.empty();
    }

    @Override
    public <K2, V2> HashMap<K2, V2> bimap(Function<? super K, ? extends K2> keyMapper, Function<? super V, ? extends V2> valueMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        Objects.requireNonNull(valueMapper, "valueMapper is null");
        Traversable entries = this.iterator().map((T entry) -> Tuple.of(keyMapper.apply((Object)entry._1), valueMapper.apply((Object)entry._2)));
        return HashMap.ofEntries(entries);
    }

    @Override
    public boolean containsKey(K key) {
        return this.trie.containsKey(key);
    }

    @Override
    public <K2, V2> HashMap<K2, V2> flatMap(BiFunction<? super K, ? super V, ? extends Iterable<Tuple2<K2, V2>>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.foldLeft(HashMap.empty(), (acc, entry) -> {
            for (Tuple2 mappedEntry : (Iterable)mapper.apply((Object)entry._1, (Object)entry._2)) {
                acc = (HashMap)acc.put(mappedEntry);
            }
            return acc;
        });
    }

    @Override
    public Option<V> get(K key) {
        return this.trie.get(key);
    }

    @Override
    public Tuple2<K, V> head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty HashMap");
        }
        return (Tuple2)this.iterator().next();
    }

    @Override
    public HashMap<K, V> init() {
        if (this.trie.isEmpty()) {
            throw new UnsupportedOperationException("init of empty HashMap");
        }
        return this.remove(((Tuple2)this.last())._1);
    }

    @Override
    public boolean isEmpty() {
        return this.trie.isEmpty();
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        return this.trie.iterator();
    }

    @Override
    public Set<K> keySet() {
        return HashSet.ofAll(this.iterator().map(Tuple2::_1));
    }

    @Override
    public <K2, V2> HashMap<K2, V2> map(BiFunction<? super K, ? super V, Tuple2<K2, V2>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.foldLeft(HashMap.empty(), (acc, entry) -> (HashMap)acc.put(entry.map(mapper)));
    }

    @Override
    public <V2> HashMap<K, V2> mapValues(Function<? super V, ? extends V2> valueMapper) {
        Objects.requireNonNull(valueMapper, "valueMapper is null");
        return this.map((T k, U v) -> Tuple.of(k, valueMapper.apply((Object)v)));
    }

    @Override
    public HashMap<K, V> put(K key, V value) {
        return new HashMap<K, V>(this.trie.put(key, value));
    }

    @Override
    public HashMap<K, V> remove(K key) {
        HashArrayMappedTrie<K, V> result = this.trie.remove(key);
        return result.size() == this.trie.size() ? this : HashMap.wrap(result);
    }

    @Override
    public HashMap<K, V> removeAll(Iterable<? extends K> keys) {
        Objects.requireNonNull(keys, "keys is null");
        HashArrayMappedTrie<K, V> result = this.trie;
        for (K key : keys) {
            result = result.remove(key);
        }
        return result.size() == this.trie.size() ? this : HashMap.wrap(result);
    }

    @Override
    public HashMap<K, V> retainAll(Iterable<? extends Tuple2<K, V>> elements) {
        Objects.requireNonNull(elements, "elements is null");
        HashArrayMappedTrie tree = HashArrayMappedTrie.empty();
        for (Tuple2<K, V> entry : elements) {
            if (!this.contains(entry)) continue;
            tree = tree.put(entry._1, entry._2);
        }
        return HashMap.wrap(tree);
    }

    @Override
    public int size() {
        return this.trie.size();
    }

    @Override
    public HashMap<K, V> tail() {
        if (this.trie.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty HashMap");
        }
        return this.remove(((Tuple2)this.head())._1);
    }

    @Override
    public java.util.HashMap<K, V> toJavaMap() {
        return this.toJavaMap(java.util.HashMap::new, t -> t);
    }

    @Override
    public Seq<V> values() {
        return this.map(Tuple2::_2);
    }

    @Override
    public int hashCode() {
        return this.hash.get();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HashMap) {
            HashMap that = (HashMap)o;
            return this.corresponds(that, Objects::equals);
        }
        return false;
    }

    private Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    @Override
    public String stringPrefix() {
        return "HashMap";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private static <K, V> HashMap<K, V> wrap(HashArrayMappedTrie<K, V> trie) {
        return trie.isEmpty() ? HashMap.empty() : new HashMap<K, V>(trie);
    }
}

