/*
    SPDX-FileCopyrightText: 2009, 2010 Alex Richardson <alex.richardson@gmx.de>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_STRUCTURESMANAGER_HPP
#define KASTEN_STRUCTURESMANAGER_HPP

// tool
#include "structuredefinitionfile.hpp"
// KF
#include <KSharedConfig>
// Std
#include <map>
#include <memory>

class QUrl;

namespace Kasten {

class StructureMetaData;
class StructureInstallJob;
class StructureUninstallJob;

class StructuresManager
{
public:
    StructuresManager();
    ~StructuresManager();

public:
    void reloadPaths();

    [[nodiscard]]
    StructureInstallJob* installStructureFromFile(const QUrl& structureFileUrl);

    [[nodiscard]]
    StructureUninstallJob* uninstallStructure(const QString& structureId);

public:
    [[nodiscard]]
    const std::map<QString, std::unique_ptr<StructureDefinitionFile>>& structureDefs() const;

    [[nodiscard]]
    KSharedConfig::Ptr config() const;

    [[nodiscard]]
    StructureDefinitionFile* definition(const QString& pluginName) const;

    [[nodiscard]]
    static QStringList installableMimeTypes();

    [[nodiscard]]
    static QString userStructuresRootDir();

private:
    void addStructDef(const StructureMetaData& metaData, StructureDefinitionFile::Location location);

private:
    std::map<QString, std::unique_ptr<StructureDefinitionFile>> mDefs;
    KSharedConfig::Ptr mConfig;
};

}

#endif
