import fs$8, { existsSync, promises as promises$1, statSync as statSync$1, realpathSync, readFileSync, mkdirSync, writeFileSync } from 'node:fs';
import { join, resolve, isAbsolute, relative, dirname, normalize, basename, toNamespacedPath } from 'pathe';
import { g as getCoverageProvider, C as CoverageProviderMap } from './coverage.CqfT4xaf.js';
import { searchForWorkspaceRoot, version, createServer, mergeConfig } from 'vite';
import { f as findUp, p as prompt } from './index.CM5UI-4O.js';
import { A as API_PATH, e as extraInlineDeps, d as defaultPort, a as defaultBrowserPort, b as defaultInspectPort, w as workspacesFiles, C as CONFIG_NAMES, c as configFiles } from './constants.CaAN7icJ.js';
import { MessageChannel, isMainThread } from 'node:worker_threads';
import { c as commonjsGlobal, g as getDefaultExportFromCjs } from './_commonjsHelpers.BFTU3MAI.js';
import require$$0 from 'os';
import p from 'path';
import require$$0$1 from 'util';
import { b as braces_1, p as picomatch$1, u as utils$d, m as mm } from './index.BMmMjLIQ.js';
import require$$0$2 from 'stream';
import require$$0$4 from 'events';
import require$$0$3 from 'fs';
import { ViteNodeRunner } from 'vite-node/client';
import { SnapshotManager } from '@vitest/snapshot/manager';
import { ViteNodeServer } from 'vite-node/server';
import { v as version$1 } from './cac.DGgmCKmU.js';
import { hasFailed, createFileTask, getTasks, getTests, getNames } from '@vitest/runner/utils';
import { n as noop$1, b as isPrimitive, c as groupBy, A as AggregateErrorPonyfill, a as slash$1, t as toArray, d as deepMerge, e as nanoid, w as wildcardPatternToRegExp, f as stdout } from './base.DSsbfkDg.js';
import { createDefer, toArray as toArray$1, notNullish } from '@vitest/utils';
import { b as isWindows } from './env.BU041cs9.js';
import { rootDir, distDir } from '../path.js';
import { c as createBirpc } from './index.BpSiYbpB.js';
import { s as stringify, p as parse$3, w as wrapSerializableConfig, j as Typechecker, R as ReportersMap, g as BenchmarkReportsMap, e as TestFile, f as TestSuite, d as TestCase, k as RandomSequencer, h as BaseSequencer, l as findNodeAround, m as generateCodeFrame, n as highlightCode, i as TestProject, L as Logger, o as BlobReporter, r as readBlobs } from './index.JbiJutJ_.js';
import require$$0$5 from 'zlib';
import require$$0$6 from 'buffer';
import require$$1 from 'crypto';
import require$$1$1 from 'https';
import require$$2 from 'http';
import require$$3 from 'net';
import require$$4 from 'tls';
import require$$7 from 'url';
import { parseErrorStacktrace } from '@vitest/utils/source-map';
import v8 from 'node:v8';
import * as nodeos from 'node:os';
import nodeos__default, { tmpdir } from 'node:os';
import EventEmitter$2 from 'node:events';
import Tinypool$1, { Tinypool } from 'tinypool';
import crypto, { createHash as createHash$2 } from 'node:crypto';
import { mkdir, writeFile, rm } from 'node:fs/promises';
import path$8, { win32 } from 'node:path';
import process$1 from 'node:process';
import { builtinModules, createRequire } from 'node:module';
import url, { fileURLToPath as fileURLToPath$1, pathToFileURL as pathToFileURL$1, URL as URL$2 } from 'node:url';
import assert from 'node:assert';
import { format as format$2, inspect } from 'node:util';
import c from 'tinyrainbow';
import { isCI, provider as provider$1 } from 'std-env';
import { normalizeRequestId, cleanUrl } from 'vite-node/utils';
import MagicString from 'magic-string';
import { esmWalker } from '@vitest/utils/ast';
import { a as removeUndefinedValues } from './index.DYufA6CZ.js';
import readline from 'node:readline';
import { s as stripAnsi } from './utils.DpP_sDwr.js';

async function getModuleGraph(ctx, projectName, id, browser = false) {
  const graph = {};
  const externalized = /* @__PURE__ */ new Set();
  const inlined = /* @__PURE__ */ new Set();
  const project = ctx.getProjectByName(projectName);
  function clearId(id2) {
    return id2?.replace(/\?v=\w+$/, "") || "";
  }
  async function get(mod, seen = /* @__PURE__ */ new Map()) {
    if (!mod || !mod.id) {
      return;
    }
    if (mod.id === "\0@vitest/browser/context") {
      return;
    }
    if (seen.has(mod)) {
      return seen.get(mod);
    }
    let id2 = clearId(mod.id);
    seen.set(mod, id2);
    const rewrote = browser ? mod.file?.includes(project.browser.vite.config.cacheDir) ? mod.id : false : await project.vitenode.shouldExternalize(id2);
    if (rewrote) {
      id2 = rewrote;
      externalized.add(id2);
      seen.set(mod, id2);
    } else {
      inlined.add(id2);
    }
    const mods = Array.from(mod.importedModules).filter(
      (i) => i.id && !i.id.includes("/vitest/dist/")
    );
    graph[id2] = (await Promise.all(mods.map((m) => get(m, seen)))).filter(
      Boolean
    );
    return id2;
  }
  if (browser && project.browser) {
    await get(project.browser.vite.moduleGraph.getModuleById(id));
  } else {
    await get(project.server.moduleGraph.getModuleById(id));
  }
  return {
    graph,
    externalized: Array.from(externalized),
    inlined: Array.from(inlined)
  };
}

function cloneByOwnProperties(value) {
  return Object.getOwnPropertyNames(value).reduce(
    (clone, prop) => ({
      ...clone,
      [prop]: value[prop]
    }),
    {}
  );
}
function stringifyReplace(key, value) {
  if (value instanceof Error) {
    const cloned = cloneByOwnProperties(value);
    return {
      name: value.name,
      message: value.message,
      stack: value.stack,
      ...cloned
    };
  } else {
    return value;
  }
}

var tasks = {};

var utils$c = {};

var array$1 = {};

Object.defineProperty(array$1, "__esModule", { value: true });
array$1.splitWhen = array$1.flatten = void 0;
function flatten(items) {
    return items.reduce((collection, item) => [].concat(collection, item), []);
}
array$1.flatten = flatten;
function splitWhen(items, predicate) {
    const result = [[]];
    let groupIndex = 0;
    for (const item of items) {
        if (predicate(item)) {
            groupIndex++;
            result[groupIndex] = [];
        }
        else {
            result[groupIndex].push(item);
        }
    }
    return result;
}
array$1.splitWhen = splitWhen;

var errno$1 = {};

Object.defineProperty(errno$1, "__esModule", { value: true });
errno$1.isEnoentCodeError = void 0;
function isEnoentCodeError(error) {
    return error.code === 'ENOENT';
}
errno$1.isEnoentCodeError = isEnoentCodeError;

var fs$7 = {};

Object.defineProperty(fs$7, "__esModule", { value: true });
fs$7.createDirentFromStats = void 0;
let DirentFromStats$1 = class DirentFromStats {
    constructor(name, stats) {
        this.name = name;
        this.isBlockDevice = stats.isBlockDevice.bind(stats);
        this.isCharacterDevice = stats.isCharacterDevice.bind(stats);
        this.isDirectory = stats.isDirectory.bind(stats);
        this.isFIFO = stats.isFIFO.bind(stats);
        this.isFile = stats.isFile.bind(stats);
        this.isSocket = stats.isSocket.bind(stats);
        this.isSymbolicLink = stats.isSymbolicLink.bind(stats);
    }
};
function createDirentFromStats$1(name, stats) {
    return new DirentFromStats$1(name, stats);
}
fs$7.createDirentFromStats = createDirentFromStats$1;

var path$7 = {};

Object.defineProperty(path$7, "__esModule", { value: true });
path$7.convertPosixPathToPattern = path$7.convertWindowsPathToPattern = path$7.convertPathToPattern = path$7.escapePosixPath = path$7.escapeWindowsPath = path$7.escape = path$7.removeLeadingDotSegment = path$7.makeAbsolute = path$7.unixify = void 0;
const os = require$$0;
const path$6 = p;
const IS_WINDOWS_PLATFORM = os.platform() === 'win32';
const LEADING_DOT_SEGMENT_CHARACTERS_COUNT = 2; // ./ or .\\
/**
 * All non-escaped special characters.
 * Posix: ()*?[]{|}, !+@ before (, ! at the beginning, \\ before non-special characters.
 * Windows: (){}[], !+@ before (, ! at the beginning.
 */
const POSIX_UNESCAPED_GLOB_SYMBOLS_RE = /(\\?)([()*?[\]{|}]|^!|[!+@](?=\()|\\(?![!()*+?@[\]{|}]))/g;
const WINDOWS_UNESCAPED_GLOB_SYMBOLS_RE = /(\\?)([()[\]{}]|^!|[!+@](?=\())/g;
/**
 * The device path (\\.\ or \\?\).
 * https://learn.microsoft.com/en-us/dotnet/standard/io/file-path-formats#dos-device-paths
 */
const DOS_DEVICE_PATH_RE = /^\\\\([.?])/;
/**
 * All backslashes except those escaping special characters.
 * Windows: !()+@{}
 * https://learn.microsoft.com/en-us/windows/win32/fileio/naming-a-file#naming-conventions
 */
const WINDOWS_BACKSLASHES_RE = /\\(?![!()+@[\]{}])/g;
/**
 * Designed to work only with simple paths: `dir\\file`.
 */
function unixify(filepath) {
    return filepath.replace(/\\/g, '/');
}
path$7.unixify = unixify;
function makeAbsolute(cwd, filepath) {
    return path$6.resolve(cwd, filepath);
}
path$7.makeAbsolute = makeAbsolute;
function removeLeadingDotSegment(entry) {
    // We do not use `startsWith` because this is 10x slower than current implementation for some cases.
    // eslint-disable-next-line @typescript-eslint/prefer-string-starts-ends-with
    if (entry.charAt(0) === '.') {
        const secondCharactery = entry.charAt(1);
        if (secondCharactery === '/' || secondCharactery === '\\') {
            return entry.slice(LEADING_DOT_SEGMENT_CHARACTERS_COUNT);
        }
    }
    return entry;
}
path$7.removeLeadingDotSegment = removeLeadingDotSegment;
path$7.escape = IS_WINDOWS_PLATFORM ? escapeWindowsPath : escapePosixPath;
function escapeWindowsPath(pattern) {
    return pattern.replace(WINDOWS_UNESCAPED_GLOB_SYMBOLS_RE, '\\$2');
}
path$7.escapeWindowsPath = escapeWindowsPath;
function escapePosixPath(pattern) {
    return pattern.replace(POSIX_UNESCAPED_GLOB_SYMBOLS_RE, '\\$2');
}
path$7.escapePosixPath = escapePosixPath;
path$7.convertPathToPattern = IS_WINDOWS_PLATFORM ? convertWindowsPathToPattern : convertPosixPathToPattern;
function convertWindowsPathToPattern(filepath) {
    return escapeWindowsPath(filepath)
        .replace(DOS_DEVICE_PATH_RE, '//$1')
        .replace(WINDOWS_BACKSLASHES_RE, '/');
}
path$7.convertWindowsPathToPattern = convertWindowsPathToPattern;
function convertPosixPathToPattern(filepath) {
    return escapePosixPath(filepath);
}
path$7.convertPosixPathToPattern = convertPosixPathToPattern;

var pattern$1 = {};

/*!
 * is-extglob <https://github.com/jonschlinkert/is-extglob>
 *
 * Copyright (c) 2014-2016, Jon Schlinkert.
 * Licensed under the MIT License.
 */

var isExtglob$1 = function isExtglob(str) {
  if (typeof str !== 'string' || str === '') {
    return false;
  }

  var match;
  while ((match = /(\\).|([@?!+*]\(.*\))/g.exec(str))) {
    if (match[2]) return true;
    str = str.slice(match.index + match[0].length);
  }

  return false;
};

/*!
 * is-glob <https://github.com/jonschlinkert/is-glob>
 *
 * Copyright (c) 2014-2017, Jon Schlinkert.
 * Released under the MIT License.
 */

var isExtglob = isExtglob$1;
var chars = { '{': '}', '(': ')', '[': ']'};
var strictCheck = function(str) {
  if (str[0] === '!') {
    return true;
  }
  var index = 0;
  var pipeIndex = -2;
  var closeSquareIndex = -2;
  var closeCurlyIndex = -2;
  var closeParenIndex = -2;
  var backSlashIndex = -2;
  while (index < str.length) {
    if (str[index] === '*') {
      return true;
    }

    if (str[index + 1] === '?' && /[\].+)]/.test(str[index])) {
      return true;
    }

    if (closeSquareIndex !== -1 && str[index] === '[' && str[index + 1] !== ']') {
      if (closeSquareIndex < index) {
        closeSquareIndex = str.indexOf(']', index);
      }
      if (closeSquareIndex > index) {
        if (backSlashIndex === -1 || backSlashIndex > closeSquareIndex) {
          return true;
        }
        backSlashIndex = str.indexOf('\\', index);
        if (backSlashIndex === -1 || backSlashIndex > closeSquareIndex) {
          return true;
        }
      }
    }

    if (closeCurlyIndex !== -1 && str[index] === '{' && str[index + 1] !== '}') {
      closeCurlyIndex = str.indexOf('}', index);
      if (closeCurlyIndex > index) {
        backSlashIndex = str.indexOf('\\', index);
        if (backSlashIndex === -1 || backSlashIndex > closeCurlyIndex) {
          return true;
        }
      }
    }

    if (closeParenIndex !== -1 && str[index] === '(' && str[index + 1] === '?' && /[:!=]/.test(str[index + 2]) && str[index + 3] !== ')') {
      closeParenIndex = str.indexOf(')', index);
      if (closeParenIndex > index) {
        backSlashIndex = str.indexOf('\\', index);
        if (backSlashIndex === -1 || backSlashIndex > closeParenIndex) {
          return true;
        }
      }
    }

    if (pipeIndex !== -1 && str[index] === '(' && str[index + 1] !== '|') {
      if (pipeIndex < index) {
        pipeIndex = str.indexOf('|', index);
      }
      if (pipeIndex !== -1 && str[pipeIndex + 1] !== ')') {
        closeParenIndex = str.indexOf(')', pipeIndex);
        if (closeParenIndex > pipeIndex) {
          backSlashIndex = str.indexOf('\\', pipeIndex);
          if (backSlashIndex === -1 || backSlashIndex > closeParenIndex) {
            return true;
          }
        }
      }
    }

    if (str[index] === '\\') {
      var open = str[index + 1];
      index += 2;
      var close = chars[open];

      if (close) {
        var n = str.indexOf(close, index);
        if (n !== -1) {
          index = n + 1;
        }
      }

      if (str[index] === '!') {
        return true;
      }
    } else {
      index++;
    }
  }
  return false;
};

var relaxedCheck = function(str) {
  if (str[0] === '!') {
    return true;
  }
  var index = 0;
  while (index < str.length) {
    if (/[*?{}()[\]]/.test(str[index])) {
      return true;
    }

    if (str[index] === '\\') {
      var open = str[index + 1];
      index += 2;
      var close = chars[open];

      if (close) {
        var n = str.indexOf(close, index);
        if (n !== -1) {
          index = n + 1;
        }
      }

      if (str[index] === '!') {
        return true;
      }
    } else {
      index++;
    }
  }
  return false;
};

var isGlob$1 = function isGlob(str, options) {
  if (typeof str !== 'string' || str === '') {
    return false;
  }

  if (isExtglob(str)) {
    return true;
  }

  var check = strictCheck;

  // optionally relax check
  if (options && options.strict === false) {
    check = relaxedCheck;
  }

  return check(str);
};

var isGlob = isGlob$1;
var pathPosixDirname = p.posix.dirname;
var isWin32 = require$$0.platform() === 'win32';

var slash = '/';
var backslash = /\\/g;
var enclosure = /[\{\[].*[\}\]]$/;
var globby = /(^|[^\\])([\{\[]|\([^\)]+$)/;
var escaped = /\\([\!\*\?\|\[\]\(\)\{\}])/g;

/**
 * @param {string} str
 * @param {Object} opts
 * @param {boolean} [opts.flipBackslashes=true]
 * @returns {string}
 */
var globParent$1 = function globParent(str, opts) {
  var options = Object.assign({ flipBackslashes: true }, opts);

  // flip windows path separators
  if (options.flipBackslashes && isWin32 && str.indexOf(slash) < 0) {
    str = str.replace(backslash, slash);
  }

  // special case for strings ending in enclosure containing path separator
  if (enclosure.test(str)) {
    str += slash;
  }

  // preserves full path in case of trailing path separator
  str += 'a';

  // remove path parts that are globby
  do {
    str = pathPosixDirname(str);
  } while (isGlob(str) || globby.test(str));

  // remove escape chars and return result
  return str.replace(escaped, '$1');
};

const util = require$$0$1;
const braces = braces_1;
const picomatch = picomatch$1;
const utils$b = utils$d;
const isEmptyString = val => val === '' || val === './';

/**
 * Returns an array of strings that match one or more glob patterns.
 *
 * ```js
 * const mm = require('micromatch');
 * // mm(list, patterns[, options]);
 *
 * console.log(mm(['a.js', 'a.txt'], ['*.js']));
 * //=> [ 'a.js' ]
 * ```
 * @param {String|Array<string>} `list` List of strings to match.
 * @param {String|Array<string>} `patterns` One or more glob patterns to use for matching.
 * @param {Object} `options` See available [options](#options)
 * @return {Array} Returns an array of matches
 * @summary false
 * @api public
 */

const micromatch$1 = (list, patterns, options) => {
  patterns = [].concat(patterns);
  list = [].concat(list);

  let omit = new Set();
  let keep = new Set();
  let items = new Set();
  let negatives = 0;

  let onResult = state => {
    items.add(state.output);
    if (options && options.onResult) {
      options.onResult(state);
    }
  };

  for (let i = 0; i < patterns.length; i++) {
    let isMatch = picomatch(String(patterns[i]), { ...options, onResult }, true);
    let negated = isMatch.state.negated || isMatch.state.negatedExtglob;
    if (negated) negatives++;

    for (let item of list) {
      let matched = isMatch(item, true);

      let match = negated ? !matched.isMatch : matched.isMatch;
      if (!match) continue;

      if (negated) {
        omit.add(matched.output);
      } else {
        omit.delete(matched.output);
        keep.add(matched.output);
      }
    }
  }

  let result = negatives === patterns.length ? [...items] : [...keep];
  let matches = result.filter(item => !omit.has(item));

  if (options && matches.length === 0) {
    if (options.failglob === true) {
      throw new Error(`No matches found for "${patterns.join(', ')}"`);
    }

    if (options.nonull === true || options.nullglob === true) {
      return options.unescape ? patterns.map(p => p.replace(/\\/g, '')) : patterns;
    }
  }

  return matches;
};

/**
 * Backwards compatibility
 */

micromatch$1.match = micromatch$1;

/**
 * Returns a matcher function from the given glob `pattern` and `options`.
 * The returned function takes a string to match as its only argument and returns
 * true if the string is a match.
 *
 * ```js
 * const mm = require('micromatch');
 * // mm.matcher(pattern[, options]);
 *
 * const isMatch = mm.matcher('*.!(*a)');
 * console.log(isMatch('a.a')); //=> false
 * console.log(isMatch('a.b')); //=> true
 * ```
 * @param {String} `pattern` Glob pattern
 * @param {Object} `options`
 * @return {Function} Returns a matcher function.
 * @api public
 */

micromatch$1.matcher = (pattern, options) => picomatch(pattern, options);

/**
 * Returns true if **any** of the given glob `patterns` match the specified `string`.
 *
 * ```js
 * const mm = require('micromatch');
 * // mm.isMatch(string, patterns[, options]);
 *
 * console.log(mm.isMatch('a.a', ['b.*', '*.a'])); //=> true
 * console.log(mm.isMatch('a.a', 'b.*')); //=> false
 * ```
 * @param {String} `str` The string to test.
 * @param {String|Array} `patterns` One or more glob patterns to use for matching.
 * @param {Object} `[options]` See available [options](#options).
 * @return {Boolean} Returns true if any patterns match `str`
 * @api public
 */

micromatch$1.isMatch = (str, patterns, options) => picomatch(patterns, options)(str);

/**
 * Backwards compatibility
 */

micromatch$1.any = micromatch$1.isMatch;

/**
 * Returns a list of strings that _**do not match any**_ of the given `patterns`.
 *
 * ```js
 * const mm = require('micromatch');
 * // mm.not(list, patterns[, options]);
 *
 * console.log(mm.not(['a.a', 'b.b', 'c.c'], '*.a'));
 * //=> ['b.b', 'c.c']
 * ```
 * @param {Array} `list` Array of strings to match.
 * @param {String|Array} `patterns` One or more glob pattern to use for matching.
 * @param {Object} `options` See available [options](#options) for changing how matches are performed
 * @return {Array} Returns an array of strings that **do not match** the given patterns.
 * @api public
 */

micromatch$1.not = (list, patterns, options = {}) => {
  patterns = [].concat(patterns).map(String);
  let result = new Set();
  let items = [];

  let onResult = state => {
    if (options.onResult) options.onResult(state);
    items.push(state.output);
  };

  let matches = new Set(micromatch$1(list, patterns, { ...options, onResult }));

  for (let item of items) {
    if (!matches.has(item)) {
      result.add(item);
    }
  }
  return [...result];
};

/**
 * Returns true if the given `string` contains the given pattern. Similar
 * to [.isMatch](#isMatch) but the pattern can match any part of the string.
 *
 * ```js
 * var mm = require('micromatch');
 * // mm.contains(string, pattern[, options]);
 *
 * console.log(mm.contains('aa/bb/cc', '*b'));
 * //=> true
 * console.log(mm.contains('aa/bb/cc', '*d'));
 * //=> false
 * ```
 * @param {String} `str` The string to match.
 * @param {String|Array} `patterns` Glob pattern to use for matching.
 * @param {Object} `options` See available [options](#options) for changing how matches are performed
 * @return {Boolean} Returns true if any of the patterns matches any part of `str`.
 * @api public
 */

micromatch$1.contains = (str, pattern, options) => {
  if (typeof str !== 'string') {
    throw new TypeError(`Expected a string: "${util.inspect(str)}"`);
  }

  if (Array.isArray(pattern)) {
    return pattern.some(p => micromatch$1.contains(str, p, options));
  }

  if (typeof pattern === 'string') {
    if (isEmptyString(str) || isEmptyString(pattern)) {
      return false;
    }

    if (str.includes(pattern) || (str.startsWith('./') && str.slice(2).includes(pattern))) {
      return true;
    }
  }

  return micromatch$1.isMatch(str, pattern, { ...options, contains: true });
};

/**
 * Filter the keys of the given object with the given `glob` pattern
 * and `options`. Does not attempt to match nested keys. If you need this feature,
 * use [glob-object][] instead.
 *
 * ```js
 * const mm = require('micromatch');
 * // mm.matchKeys(object, patterns[, options]);
 *
 * const obj = { aa: 'a', ab: 'b', ac: 'c' };
 * console.log(mm.matchKeys(obj, '*b'));
 * //=> { ab: 'b' }
 * ```
 * @param {Object} `object` The object with keys to filter.
 * @param {String|Array} `patterns` One or more glob patterns to use for matching.
 * @param {Object} `options` See available [options](#options) for changing how matches are performed
 * @return {Object} Returns an object with only keys that match the given patterns.
 * @api public
 */

micromatch$1.matchKeys = (obj, patterns, options) => {
  if (!utils$b.isObject(obj)) {
    throw new TypeError('Expected the first argument to be an object');
  }
  let keys = micromatch$1(Object.keys(obj), patterns, options);
  let res = {};
  for (let key of keys) res[key] = obj[key];
  return res;
};

/**
 * Returns true if some of the strings in the given `list` match any of the given glob `patterns`.
 *
 * ```js
 * const mm = require('micromatch');
 * // mm.some(list, patterns[, options]);
 *
 * console.log(mm.some(['foo.js', 'bar.js'], ['*.js', '!foo.js']));
 * // true
 * console.log(mm.some(['foo.js'], ['*.js', '!foo.js']));
 * // false
 * ```
 * @param {String|Array} `list` The string or array of strings to test. Returns as soon as the first match is found.
 * @param {String|Array} `patterns` One or more glob patterns to use for matching.
 * @param {Object} `options` See available [options](#options) for changing how matches are performed
 * @return {Boolean} Returns true if any `patterns` matches any of the strings in `list`
 * @api public
 */

micromatch$1.some = (list, patterns, options) => {
  let items = [].concat(list);

  for (let pattern of [].concat(patterns)) {
    let isMatch = picomatch(String(pattern), options);
    if (items.some(item => isMatch(item))) {
      return true;
    }
  }
  return false;
};

/**
 * Returns true if every string in the given `list` matches
 * any of the given glob `patterns`.
 *
 * ```js
 * const mm = require('micromatch');
 * // mm.every(list, patterns[, options]);
 *
 * console.log(mm.every('foo.js', ['foo.js']));
 * // true
 * console.log(mm.every(['foo.js', 'bar.js'], ['*.js']));
 * // true
 * console.log(mm.every(['foo.js', 'bar.js'], ['*.js', '!foo.js']));
 * // false
 * console.log(mm.every(['foo.js'], ['*.js', '!foo.js']));
 * // false
 * ```
 * @param {String|Array} `list` The string or array of strings to test.
 * @param {String|Array} `patterns` One or more glob patterns to use for matching.
 * @param {Object} `options` See available [options](#options) for changing how matches are performed
 * @return {Boolean} Returns true if all `patterns` matches all of the strings in `list`
 * @api public
 */

micromatch$1.every = (list, patterns, options) => {
  let items = [].concat(list);

  for (let pattern of [].concat(patterns)) {
    let isMatch = picomatch(String(pattern), options);
    if (!items.every(item => isMatch(item))) {
      return false;
    }
  }
  return true;
};

/**
 * Returns true if **all** of the given `patterns` match
 * the specified string.
 *
 * ```js
 * const mm = require('micromatch');
 * // mm.all(string, patterns[, options]);
 *
 * console.log(mm.all('foo.js', ['foo.js']));
 * // true
 *
 * console.log(mm.all('foo.js', ['*.js', '!foo.js']));
 * // false
 *
 * console.log(mm.all('foo.js', ['*.js', 'foo.js']));
 * // true
 *
 * console.log(mm.all('foo.js', ['*.js', 'f*', '*o*', '*o.js']));
 * // true
 * ```
 * @param {String|Array} `str` The string to test.
 * @param {String|Array} `patterns` One or more glob patterns to use for matching.
 * @param {Object} `options` See available [options](#options) for changing how matches are performed
 * @return {Boolean} Returns true if any patterns match `str`
 * @api public
 */

micromatch$1.all = (str, patterns, options) => {
  if (typeof str !== 'string') {
    throw new TypeError(`Expected a string: "${util.inspect(str)}"`);
  }

  return [].concat(patterns).every(p => picomatch(p, options)(str));
};

/**
 * Returns an array of matches captured by `pattern` in `string, or `null` if the pattern did not match.
 *
 * ```js
 * const mm = require('micromatch');
 * // mm.capture(pattern, string[, options]);
 *
 * console.log(mm.capture('test/*.js', 'test/foo.js'));
 * //=> ['foo']
 * console.log(mm.capture('test/*.js', 'foo/bar.css'));
 * //=> null
 * ```
 * @param {String} `glob` Glob pattern to use for matching.
 * @param {String} `input` String to match
 * @param {Object} `options` See available [options](#options) for changing how matches are performed
 * @return {Array|null} Returns an array of captures if the input matches the glob pattern, otherwise `null`.
 * @api public
 */

micromatch$1.capture = (glob, input, options) => {
  let posix = utils$b.isWindows(options);
  let regex = picomatch.makeRe(String(glob), { ...options, capture: true });
  let match = regex.exec(posix ? utils$b.toPosixSlashes(input) : input);

  if (match) {
    return match.slice(1).map(v => v === void 0 ? '' : v);
  }
};

/**
 * Create a regular expression from the given glob `pattern`.
 *
 * ```js
 * const mm = require('micromatch');
 * // mm.makeRe(pattern[, options]);
 *
 * console.log(mm.makeRe('*.js'));
 * //=> /^(?:(\.[\\\/])?(?!\.)(?=.)[^\/]*?\.js)$/
 * ```
 * @param {String} `pattern` A glob pattern to convert to regex.
 * @param {Object} `options`
 * @return {RegExp} Returns a regex created from the given pattern.
 * @api public
 */

micromatch$1.makeRe = (...args) => picomatch.makeRe(...args);

/**
 * Scan a glob pattern to separate the pattern into segments. Used
 * by the [split](#split) method.
 *
 * ```js
 * const mm = require('micromatch');
 * const state = mm.scan(pattern[, options]);
 * ```
 * @param {String} `pattern`
 * @param {Object} `options`
 * @return {Object} Returns an object with
 * @api public
 */

micromatch$1.scan = (...args) => picomatch.scan(...args);

/**
 * Parse a glob pattern to create the source string for a regular
 * expression.
 *
 * ```js
 * const mm = require('micromatch');
 * const state = mm.parse(pattern[, options]);
 * ```
 * @param {String} `glob`
 * @param {Object} `options`
 * @return {Object} Returns an object with useful properties and output to be used as regex source string.
 * @api public
 */

micromatch$1.parse = (patterns, options) => {
  let res = [];
  for (let pattern of [].concat(patterns || [])) {
    for (let str of braces(String(pattern), options)) {
      res.push(picomatch.parse(str, options));
    }
  }
  return res;
};

/**
 * Process the given brace `pattern`.
 *
 * ```js
 * const { braces } = require('micromatch');
 * console.log(braces('foo/{a,b,c}/bar'));
 * //=> [ 'foo/(a|b|c)/bar' ]
 *
 * console.log(braces('foo/{a,b,c}/bar', { expand: true }));
 * //=> [ 'foo/a/bar', 'foo/b/bar', 'foo/c/bar' ]
 * ```
 * @param {String} `pattern` String with brace pattern to process.
 * @param {Object} `options` Any [options](#options) to change how expansion is performed. See the [braces][] library for all available options.
 * @return {Array}
 * @api public
 */

micromatch$1.braces = (pattern, options) => {
  if (typeof pattern !== 'string') throw new TypeError('Expected a string');
  if ((options && options.nobrace === true) || !/\{.*\}/.test(pattern)) {
    return [pattern];
  }
  return braces(pattern, options);
};

/**
 * Expand braces
 */

micromatch$1.braceExpand = (pattern, options) => {
  if (typeof pattern !== 'string') throw new TypeError('Expected a string');
  return micromatch$1.braces(pattern, { ...options, expand: true });
};

/**
 * Expose micromatch
 */

var micromatch_1 = micromatch$1;

Object.defineProperty(pattern$1, "__esModule", { value: true });
pattern$1.removeDuplicateSlashes = pattern$1.matchAny = pattern$1.convertPatternsToRe = pattern$1.makeRe = pattern$1.getPatternParts = pattern$1.expandBraceExpansion = pattern$1.expandPatternsWithBraceExpansion = pattern$1.isAffectDepthOfReadingPattern = pattern$1.endsWithSlashGlobStar = pattern$1.hasGlobStar = pattern$1.getBaseDirectory = pattern$1.isPatternRelatedToParentDirectory = pattern$1.getPatternsOutsideCurrentDirectory = pattern$1.getPatternsInsideCurrentDirectory = pattern$1.getPositivePatterns = pattern$1.getNegativePatterns = pattern$1.isPositivePattern = pattern$1.isNegativePattern = pattern$1.convertToNegativePattern = pattern$1.convertToPositivePattern = pattern$1.isDynamicPattern = pattern$1.isStaticPattern = void 0;
const path$5 = p;
const globParent = globParent$1;
const micromatch = micromatch_1;
const GLOBSTAR = '**';
const ESCAPE_SYMBOL = '\\';
const COMMON_GLOB_SYMBOLS_RE = /[*?]|^!/;
const REGEX_CHARACTER_CLASS_SYMBOLS_RE = /\[[^[]*]/;
const REGEX_GROUP_SYMBOLS_RE = /(?:^|[^!*+?@])\([^(]*\|[^|]*\)/;
const GLOB_EXTENSION_SYMBOLS_RE = /[!*+?@]\([^(]*\)/;
const BRACE_EXPANSION_SEPARATORS_RE = /,|\.\./;
/**
 * Matches a sequence of two or more consecutive slashes, excluding the first two slashes at the beginning of the string.
 * The latter is due to the presence of the device path at the beginning of the UNC path.
 */
const DOUBLE_SLASH_RE = /(?!^)\/{2,}/g;
function isStaticPattern(pattern, options = {}) {
    return !isDynamicPattern(pattern, options);
}
pattern$1.isStaticPattern = isStaticPattern;
function isDynamicPattern(pattern, options = {}) {
    /**
     * A special case with an empty string is necessary for matching patterns that start with a forward slash.
     * An empty string cannot be a dynamic pattern.
     * For example, the pattern `/lib/*` will be spread into parts: '', 'lib', '*'.
     */
    if (pattern === '') {
        return false;
    }
    /**
     * When the `caseSensitiveMatch` option is disabled, all patterns must be marked as dynamic, because we cannot check
     * filepath directly (without read directory).
     */
    if (options.caseSensitiveMatch === false || pattern.includes(ESCAPE_SYMBOL)) {
        return true;
    }
    if (COMMON_GLOB_SYMBOLS_RE.test(pattern) || REGEX_CHARACTER_CLASS_SYMBOLS_RE.test(pattern) || REGEX_GROUP_SYMBOLS_RE.test(pattern)) {
        return true;
    }
    if (options.extglob !== false && GLOB_EXTENSION_SYMBOLS_RE.test(pattern)) {
        return true;
    }
    if (options.braceExpansion !== false && hasBraceExpansion(pattern)) {
        return true;
    }
    return false;
}
pattern$1.isDynamicPattern = isDynamicPattern;
function hasBraceExpansion(pattern) {
    const openingBraceIndex = pattern.indexOf('{');
    if (openingBraceIndex === -1) {
        return false;
    }
    const closingBraceIndex = pattern.indexOf('}', openingBraceIndex + 1);
    if (closingBraceIndex === -1) {
        return false;
    }
    const braceContent = pattern.slice(openingBraceIndex, closingBraceIndex);
    return BRACE_EXPANSION_SEPARATORS_RE.test(braceContent);
}
function convertToPositivePattern(pattern) {
    return isNegativePattern(pattern) ? pattern.slice(1) : pattern;
}
pattern$1.convertToPositivePattern = convertToPositivePattern;
function convertToNegativePattern(pattern) {
    return '!' + pattern;
}
pattern$1.convertToNegativePattern = convertToNegativePattern;
function isNegativePattern(pattern) {
    return pattern.startsWith('!') && pattern[1] !== '(';
}
pattern$1.isNegativePattern = isNegativePattern;
function isPositivePattern(pattern) {
    return !isNegativePattern(pattern);
}
pattern$1.isPositivePattern = isPositivePattern;
function getNegativePatterns(patterns) {
    return patterns.filter(isNegativePattern);
}
pattern$1.getNegativePatterns = getNegativePatterns;
function getPositivePatterns$1(patterns) {
    return patterns.filter(isPositivePattern);
}
pattern$1.getPositivePatterns = getPositivePatterns$1;
/**
 * Returns patterns that can be applied inside the current directory.
 *
 * @example
 * // ['./*', '*', 'a/*']
 * getPatternsInsideCurrentDirectory(['./*', '*', 'a/*', '../*', './../*'])
 */
function getPatternsInsideCurrentDirectory(patterns) {
    return patterns.filter((pattern) => !isPatternRelatedToParentDirectory(pattern));
}
pattern$1.getPatternsInsideCurrentDirectory = getPatternsInsideCurrentDirectory;
/**
 * Returns patterns to be expanded relative to (outside) the current directory.
 *
 * @example
 * // ['../*', './../*']
 * getPatternsInsideCurrentDirectory(['./*', '*', 'a/*', '../*', './../*'])
 */
function getPatternsOutsideCurrentDirectory(patterns) {
    return patterns.filter(isPatternRelatedToParentDirectory);
}
pattern$1.getPatternsOutsideCurrentDirectory = getPatternsOutsideCurrentDirectory;
function isPatternRelatedToParentDirectory(pattern) {
    return pattern.startsWith('..') || pattern.startsWith('./..');
}
pattern$1.isPatternRelatedToParentDirectory = isPatternRelatedToParentDirectory;
function getBaseDirectory(pattern) {
    return globParent(pattern, { flipBackslashes: false });
}
pattern$1.getBaseDirectory = getBaseDirectory;
function hasGlobStar(pattern) {
    return pattern.includes(GLOBSTAR);
}
pattern$1.hasGlobStar = hasGlobStar;
function endsWithSlashGlobStar(pattern) {
    return pattern.endsWith('/' + GLOBSTAR);
}
pattern$1.endsWithSlashGlobStar = endsWithSlashGlobStar;
function isAffectDepthOfReadingPattern(pattern) {
    const basename = path$5.basename(pattern);
    return endsWithSlashGlobStar(pattern) || isStaticPattern(basename);
}
pattern$1.isAffectDepthOfReadingPattern = isAffectDepthOfReadingPattern;
function expandPatternsWithBraceExpansion(patterns) {
    return patterns.reduce((collection, pattern) => {
        return collection.concat(expandBraceExpansion(pattern));
    }, []);
}
pattern$1.expandPatternsWithBraceExpansion = expandPatternsWithBraceExpansion;
function expandBraceExpansion(pattern) {
    const patterns = micromatch.braces(pattern, { expand: true, nodupes: true, keepEscaping: true });
    /**
     * Sort the patterns by length so that the same depth patterns are processed side by side.
     * `a/{b,}/{c,}/*` – `['a///*', 'a/b//*', 'a//c/*', 'a/b/c/*']`
     */
    patterns.sort((a, b) => a.length - b.length);
    /**
     * Micromatch can return an empty string in the case of patterns like `{a,}`.
     */
    return patterns.filter((pattern) => pattern !== '');
}
pattern$1.expandBraceExpansion = expandBraceExpansion;
function getPatternParts(pattern, options) {
    let { parts } = micromatch.scan(pattern, Object.assign(Object.assign({}, options), { parts: true }));
    /**
     * The scan method returns an empty array in some cases.
     * See micromatch/picomatch#58 for more details.
     */
    if (parts.length === 0) {
        parts = [pattern];
    }
    /**
     * The scan method does not return an empty part for the pattern with a forward slash.
     * This is another part of micromatch/picomatch#58.
     */
    if (parts[0].startsWith('/')) {
        parts[0] = parts[0].slice(1);
        parts.unshift('');
    }
    return parts;
}
pattern$1.getPatternParts = getPatternParts;
function makeRe(pattern, options) {
    return micromatch.makeRe(pattern, options);
}
pattern$1.makeRe = makeRe;
function convertPatternsToRe(patterns, options) {
    return patterns.map((pattern) => makeRe(pattern, options));
}
pattern$1.convertPatternsToRe = convertPatternsToRe;
function matchAny(entry, patternsRe) {
    return patternsRe.some((patternRe) => patternRe.test(entry));
}
pattern$1.matchAny = matchAny;
/**
 * This package only works with forward slashes as a path separator.
 * Because of this, we cannot use the standard `path.normalize` method, because on Windows platform it will use of backslashes.
 */
function removeDuplicateSlashes(pattern) {
    return pattern.replace(DOUBLE_SLASH_RE, '/');
}
pattern$1.removeDuplicateSlashes = removeDuplicateSlashes;

var stream$4 = {};

/*
 * merge2
 * https://github.com/teambition/merge2
 *
 * Copyright (c) 2014-2020 Teambition
 * Licensed under the MIT license.
 */
const Stream = require$$0$2;
const PassThrough = Stream.PassThrough;
const slice = Array.prototype.slice;

var merge2_1 = merge2$1;

function merge2$1 () {
  const streamsQueue = [];
  const args = slice.call(arguments);
  let merging = false;
  let options = args[args.length - 1];

  if (options && !Array.isArray(options) && options.pipe == null) {
    args.pop();
  } else {
    options = {};
  }

  const doEnd = options.end !== false;
  const doPipeError = options.pipeError === true;
  if (options.objectMode == null) {
    options.objectMode = true;
  }
  if (options.highWaterMark == null) {
    options.highWaterMark = 64 * 1024;
  }
  const mergedStream = PassThrough(options);

  function addStream () {
    for (let i = 0, len = arguments.length; i < len; i++) {
      streamsQueue.push(pauseStreams(arguments[i], options));
    }
    mergeStream();
    return this
  }

  function mergeStream () {
    if (merging) {
      return
    }
    merging = true;

    let streams = streamsQueue.shift();
    if (!streams) {
      process.nextTick(endStream);
      return
    }
    if (!Array.isArray(streams)) {
      streams = [streams];
    }

    let pipesCount = streams.length + 1;

    function next () {
      if (--pipesCount > 0) {
        return
      }
      merging = false;
      mergeStream();
    }

    function pipe (stream) {
      function onend () {
        stream.removeListener('merge2UnpipeEnd', onend);
        stream.removeListener('end', onend);
        if (doPipeError) {
          stream.removeListener('error', onerror);
        }
        next();
      }
      function onerror (err) {
        mergedStream.emit('error', err);
      }
      // skip ended stream
      if (stream._readableState.endEmitted) {
        return next()
      }

      stream.on('merge2UnpipeEnd', onend);
      stream.on('end', onend);

      if (doPipeError) {
        stream.on('error', onerror);
      }

      stream.pipe(mergedStream, { end: false });
      // compatible for old stream
      stream.resume();
    }

    for (let i = 0; i < streams.length; i++) {
      pipe(streams[i]);
    }

    next();
  }

  function endStream () {
    merging = false;
    // emit 'queueDrain' when all streams merged.
    mergedStream.emit('queueDrain');
    if (doEnd) {
      mergedStream.end();
    }
  }

  mergedStream.setMaxListeners(0);
  mergedStream.add = addStream;
  mergedStream.on('unpipe', function (stream) {
    stream.emit('merge2UnpipeEnd');
  });

  if (args.length) {
    addStream.apply(null, args);
  }
  return mergedStream
}

// check and pause streams for pipe.
function pauseStreams (streams, options) {
  if (!Array.isArray(streams)) {
    // Backwards-compat with old-style streams
    if (!streams._readableState && streams.pipe) {
      streams = streams.pipe(PassThrough(options));
    }
    if (!streams._readableState || !streams.pause || !streams.pipe) {
      throw new Error('Only readable stream can be merged.')
    }
    streams.pause();
  } else {
    for (let i = 0, len = streams.length; i < len; i++) {
      streams[i] = pauseStreams(streams[i], options);
    }
  }
  return streams
}

Object.defineProperty(stream$4, "__esModule", { value: true });
stream$4.merge = void 0;
const merge2 = merge2_1;
function merge(streams) {
    const mergedStream = merge2(streams);
    streams.forEach((stream) => {
        stream.once('error', (error) => mergedStream.emit('error', error));
    });
    mergedStream.once('close', () => propagateCloseEventToSources(streams));
    mergedStream.once('end', () => propagateCloseEventToSources(streams));
    return mergedStream;
}
stream$4.merge = merge;
function propagateCloseEventToSources(streams) {
    streams.forEach((stream) => stream.emit('close'));
}

var string$1 = {};

Object.defineProperty(string$1, "__esModule", { value: true });
string$1.isEmpty = string$1.isString = void 0;
function isString(input) {
    return typeof input === 'string';
}
string$1.isString = isString;
function isEmpty(input) {
    return input === '';
}
string$1.isEmpty = isEmpty;

Object.defineProperty(utils$c, "__esModule", { value: true });
utils$c.string = utils$c.stream = utils$c.pattern = utils$c.path = utils$c.fs = utils$c.errno = utils$c.array = void 0;
const array = array$1;
utils$c.array = array;
const errno = errno$1;
utils$c.errno = errno;
const fs$6 = fs$7;
utils$c.fs = fs$6;
const path$4 = path$7;
utils$c.path = path$4;
const pattern = pattern$1;
utils$c.pattern = pattern;
const stream$3 = stream$4;
utils$c.stream = stream$3;
const string = string$1;
utils$c.string = string;

Object.defineProperty(tasks, "__esModule", { value: true });
tasks.convertPatternGroupToTask = tasks.convertPatternGroupsToTasks = tasks.groupPatternsByBaseDirectory = tasks.getNegativePatternsAsPositive = tasks.getPositivePatterns = tasks.convertPatternsToTasks = tasks.generate = void 0;
const utils$a = utils$c;
function generate(input, settings) {
    const patterns = processPatterns(input, settings);
    const ignore = processPatterns(settings.ignore, settings);
    const positivePatterns = getPositivePatterns(patterns);
    const negativePatterns = getNegativePatternsAsPositive(patterns, ignore);
    const staticPatterns = positivePatterns.filter((pattern) => utils$a.pattern.isStaticPattern(pattern, settings));
    const dynamicPatterns = positivePatterns.filter((pattern) => utils$a.pattern.isDynamicPattern(pattern, settings));
    const staticTasks = convertPatternsToTasks(staticPatterns, negativePatterns, /* dynamic */ false);
    const dynamicTasks = convertPatternsToTasks(dynamicPatterns, negativePatterns, /* dynamic */ true);
    return staticTasks.concat(dynamicTasks);
}
tasks.generate = generate;
function processPatterns(input, settings) {
    let patterns = input;
    /**
     * The original pattern like `{,*,**,a/*}` can lead to problems checking the depth when matching entry
     * and some problems with the micromatch package (see fast-glob issues: #365, #394).
     *
     * To solve this problem, we expand all patterns containing brace expansion. This can lead to a slight slowdown
     * in matching in the case of a large set of patterns after expansion.
     */
    if (settings.braceExpansion) {
        patterns = utils$a.pattern.expandPatternsWithBraceExpansion(patterns);
    }
    /**
     * If the `baseNameMatch` option is enabled, we must add globstar to patterns, so that they can be used
     * at any nesting level.
     *
     * We do this here, because otherwise we have to complicate the filtering logic. For example, we need to change
     * the pattern in the filter before creating a regular expression. There is no need to change the patterns
     * in the application. Only on the input.
     */
    if (settings.baseNameMatch) {
        patterns = patterns.map((pattern) => pattern.includes('/') ? pattern : `**/${pattern}`);
    }
    /**
     * This method also removes duplicate slashes that may have been in the pattern or formed as a result of expansion.
     */
    return patterns.map((pattern) => utils$a.pattern.removeDuplicateSlashes(pattern));
}
/**
 * Returns tasks grouped by basic pattern directories.
 *
 * Patterns that can be found inside (`./`) and outside (`../`) the current directory are handled separately.
 * This is necessary because directory traversal starts at the base directory and goes deeper.
 */
function convertPatternsToTasks(positive, negative, dynamic) {
    const tasks = [];
    const patternsOutsideCurrentDirectory = utils$a.pattern.getPatternsOutsideCurrentDirectory(positive);
    const patternsInsideCurrentDirectory = utils$a.pattern.getPatternsInsideCurrentDirectory(positive);
    const outsideCurrentDirectoryGroup = groupPatternsByBaseDirectory(patternsOutsideCurrentDirectory);
    const insideCurrentDirectoryGroup = groupPatternsByBaseDirectory(patternsInsideCurrentDirectory);
    tasks.push(...convertPatternGroupsToTasks(outsideCurrentDirectoryGroup, negative, dynamic));
    /*
     * For the sake of reducing future accesses to the file system, we merge all tasks within the current directory
     * into a global task, if at least one pattern refers to the root (`.`). In this case, the global task covers the rest.
     */
    if ('.' in insideCurrentDirectoryGroup) {
        tasks.push(convertPatternGroupToTask('.', patternsInsideCurrentDirectory, negative, dynamic));
    }
    else {
        tasks.push(...convertPatternGroupsToTasks(insideCurrentDirectoryGroup, negative, dynamic));
    }
    return tasks;
}
tasks.convertPatternsToTasks = convertPatternsToTasks;
function getPositivePatterns(patterns) {
    return utils$a.pattern.getPositivePatterns(patterns);
}
tasks.getPositivePatterns = getPositivePatterns;
function getNegativePatternsAsPositive(patterns, ignore) {
    const negative = utils$a.pattern.getNegativePatterns(patterns).concat(ignore);
    const positive = negative.map(utils$a.pattern.convertToPositivePattern);
    return positive;
}
tasks.getNegativePatternsAsPositive = getNegativePatternsAsPositive;
function groupPatternsByBaseDirectory(patterns) {
    const group = {};
    return patterns.reduce((collection, pattern) => {
        const base = utils$a.pattern.getBaseDirectory(pattern);
        if (base in collection) {
            collection[base].push(pattern);
        }
        else {
            collection[base] = [pattern];
        }
        return collection;
    }, group);
}
tasks.groupPatternsByBaseDirectory = groupPatternsByBaseDirectory;
function convertPatternGroupsToTasks(positive, negative, dynamic) {
    return Object.keys(positive).map((base) => {
        return convertPatternGroupToTask(base, positive[base], negative, dynamic);
    });
}
tasks.convertPatternGroupsToTasks = convertPatternGroupsToTasks;
function convertPatternGroupToTask(base, positive, negative, dynamic) {
    return {
        dynamic,
        positive,
        negative,
        base,
        patterns: [].concat(positive, negative.map(utils$a.pattern.convertToNegativePattern))
    };
}
tasks.convertPatternGroupToTask = convertPatternGroupToTask;

var async$7 = {};

var async$6 = {};

var out$3 = {};

var async$5 = {};

var async$4 = {};

var out$2 = {};

var async$3 = {};

var out$1 = {};

var async$2 = {};

Object.defineProperty(async$2, "__esModule", { value: true });
async$2.read = void 0;
function read$4(path, settings, callback) {
    settings.fs.lstat(path, (lstatError, lstat) => {
        if (lstatError !== null) {
            callFailureCallback$2(callback, lstatError);
            return;
        }
        if (!lstat.isSymbolicLink() || !settings.followSymbolicLink) {
            callSuccessCallback$2(callback, lstat);
            return;
        }
        settings.fs.stat(path, (statError, stat) => {
            if (statError !== null) {
                if (settings.throwErrorOnBrokenSymbolicLink) {
                    callFailureCallback$2(callback, statError);
                    return;
                }
                callSuccessCallback$2(callback, lstat);
                return;
            }
            if (settings.markSymbolicLink) {
                stat.isSymbolicLink = () => true;
            }
            callSuccessCallback$2(callback, stat);
        });
    });
}
async$2.read = read$4;
function callFailureCallback$2(callback, error) {
    callback(error);
}
function callSuccessCallback$2(callback, result) {
    callback(null, result);
}

var sync$7 = {};

Object.defineProperty(sync$7, "__esModule", { value: true });
sync$7.read = void 0;
function read$3(path, settings) {
    const lstat = settings.fs.lstatSync(path);
    if (!lstat.isSymbolicLink() || !settings.followSymbolicLink) {
        return lstat;
    }
    try {
        const stat = settings.fs.statSync(path);
        if (settings.markSymbolicLink) {
            stat.isSymbolicLink = () => true;
        }
        return stat;
    }
    catch (error) {
        if (!settings.throwErrorOnBrokenSymbolicLink) {
            return lstat;
        }
        throw error;
    }
}
sync$7.read = read$3;

var settings$3 = {};

var fs$5 = {};

(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.createFileSystemAdapter = exports.FILE_SYSTEM_ADAPTER = void 0;
	const fs = require$$0$3;
	exports.FILE_SYSTEM_ADAPTER = {
	    lstat: fs.lstat,
	    stat: fs.stat,
	    lstatSync: fs.lstatSync,
	    statSync: fs.statSync
	};
	function createFileSystemAdapter(fsMethods) {
	    if (fsMethods === undefined) {
	        return exports.FILE_SYSTEM_ADAPTER;
	    }
	    return Object.assign(Object.assign({}, exports.FILE_SYSTEM_ADAPTER), fsMethods);
	}
	exports.createFileSystemAdapter = createFileSystemAdapter; 
} (fs$5));

Object.defineProperty(settings$3, "__esModule", { value: true });
const fs$4 = fs$5;
let Settings$2 = class Settings {
    constructor(_options = {}) {
        this._options = _options;
        this.followSymbolicLink = this._getValue(this._options.followSymbolicLink, true);
        this.fs = fs$4.createFileSystemAdapter(this._options.fs);
        this.markSymbolicLink = this._getValue(this._options.markSymbolicLink, false);
        this.throwErrorOnBrokenSymbolicLink = this._getValue(this._options.throwErrorOnBrokenSymbolicLink, true);
    }
    _getValue(option, value) {
        return option !== null && option !== void 0 ? option : value;
    }
};
settings$3.default = Settings$2;

Object.defineProperty(out$1, "__esModule", { value: true });
out$1.statSync = out$1.stat = out$1.Settings = void 0;
const async$1 = async$2;
const sync$6 = sync$7;
const settings_1$3 = settings$3;
out$1.Settings = settings_1$3.default;
function stat(path, optionsOrSettingsOrCallback, callback) {
    if (typeof optionsOrSettingsOrCallback === 'function') {
        async$1.read(path, getSettings$2(), optionsOrSettingsOrCallback);
        return;
    }
    async$1.read(path, getSettings$2(optionsOrSettingsOrCallback), callback);
}
out$1.stat = stat;
function statSync(path, optionsOrSettings) {
    const settings = getSettings$2(optionsOrSettings);
    return sync$6.read(path, settings);
}
out$1.statSync = statSync;
function getSettings$2(settingsOrOptions = {}) {
    if (settingsOrOptions instanceof settings_1$3.default) {
        return settingsOrOptions;
    }
    return new settings_1$3.default(settingsOrOptions);
}

/*! queue-microtask. MIT License. Feross Aboukhadijeh <https://feross.org/opensource> */

let promise;

var queueMicrotask_1 = typeof queueMicrotask === 'function'
  ? queueMicrotask.bind(typeof window !== 'undefined' ? window : commonjsGlobal)
  // reuse resolved promise, and allocate it lazily
  : cb => (promise || (promise = Promise.resolve()))
    .then(cb)
    .catch(err => setTimeout(() => { throw err }, 0));

/*! run-parallel. MIT License. Feross Aboukhadijeh <https://feross.org/opensource> */

var runParallel_1 = runParallel;

const queueMicrotask$1 = queueMicrotask_1;

function runParallel (tasks, cb) {
  let results, pending, keys;
  let isSync = true;

  if (Array.isArray(tasks)) {
    results = [];
    pending = tasks.length;
  } else {
    keys = Object.keys(tasks);
    results = {};
    pending = keys.length;
  }

  function done (err) {
    function end () {
      if (cb) cb(err, results);
      cb = null;
    }
    if (isSync) queueMicrotask$1(end);
    else end();
  }

  function each (i, err, result) {
    results[i] = result;
    if (--pending === 0 || err) {
      done(err);
    }
  }

  if (!pending) {
    // empty
    done(null);
  } else if (keys) {
    // object
    keys.forEach(function (key) {
      tasks[key](function (err, result) { each(key, err, result); });
    });
  } else {
    // array
    tasks.forEach(function (task, i) {
      task(function (err, result) { each(i, err, result); });
    });
  }

  isSync = false;
}

var constants$1 = {};

Object.defineProperty(constants$1, "__esModule", { value: true });
constants$1.IS_SUPPORT_READDIR_WITH_FILE_TYPES = void 0;
const NODE_PROCESS_VERSION_PARTS = process.versions.node.split('.');
if (NODE_PROCESS_VERSION_PARTS[0] === undefined || NODE_PROCESS_VERSION_PARTS[1] === undefined) {
    throw new Error(`Unexpected behavior. The 'process.versions.node' variable has invalid value: ${process.versions.node}`);
}
const MAJOR_VERSION = Number.parseInt(NODE_PROCESS_VERSION_PARTS[0], 10);
const MINOR_VERSION = Number.parseInt(NODE_PROCESS_VERSION_PARTS[1], 10);
const SUPPORTED_MAJOR_VERSION = 10;
const SUPPORTED_MINOR_VERSION = 10;
const IS_MATCHED_BY_MAJOR = MAJOR_VERSION > SUPPORTED_MAJOR_VERSION;
const IS_MATCHED_BY_MAJOR_AND_MINOR = MAJOR_VERSION === SUPPORTED_MAJOR_VERSION && MINOR_VERSION >= SUPPORTED_MINOR_VERSION;
/**
 * IS `true` for Node.js 10.10 and greater.
 */
constants$1.IS_SUPPORT_READDIR_WITH_FILE_TYPES = IS_MATCHED_BY_MAJOR || IS_MATCHED_BY_MAJOR_AND_MINOR;

var utils$9 = {};

var fs$3 = {};

Object.defineProperty(fs$3, "__esModule", { value: true });
fs$3.createDirentFromStats = void 0;
class DirentFromStats {
    constructor(name, stats) {
        this.name = name;
        this.isBlockDevice = stats.isBlockDevice.bind(stats);
        this.isCharacterDevice = stats.isCharacterDevice.bind(stats);
        this.isDirectory = stats.isDirectory.bind(stats);
        this.isFIFO = stats.isFIFO.bind(stats);
        this.isFile = stats.isFile.bind(stats);
        this.isSocket = stats.isSocket.bind(stats);
        this.isSymbolicLink = stats.isSymbolicLink.bind(stats);
    }
}
function createDirentFromStats(name, stats) {
    return new DirentFromStats(name, stats);
}
fs$3.createDirentFromStats = createDirentFromStats;

Object.defineProperty(utils$9, "__esModule", { value: true });
utils$9.fs = void 0;
const fs$2 = fs$3;
utils$9.fs = fs$2;

var common$6 = {};

Object.defineProperty(common$6, "__esModule", { value: true });
common$6.joinPathSegments = void 0;
function joinPathSegments$1(a, b, separator) {
    /**
     * The correct handling of cases when the first segment is a root (`/`, `C:/`) or UNC path (`//?/C:/`).
     */
    if (a.endsWith(separator)) {
        return a + b;
    }
    return a + separator + b;
}
common$6.joinPathSegments = joinPathSegments$1;

Object.defineProperty(async$3, "__esModule", { value: true });
async$3.readdir = async$3.readdirWithFileTypes = async$3.read = void 0;
const fsStat$5 = out$1;
const rpl = runParallel_1;
const constants_1$1 = constants$1;
const utils$8 = utils$9;
const common$5 = common$6;
function read$2(directory, settings, callback) {
    if (!settings.stats && constants_1$1.IS_SUPPORT_READDIR_WITH_FILE_TYPES) {
        readdirWithFileTypes$1(directory, settings, callback);
        return;
    }
    readdir$1(directory, settings, callback);
}
async$3.read = read$2;
function readdirWithFileTypes$1(directory, settings, callback) {
    settings.fs.readdir(directory, { withFileTypes: true }, (readdirError, dirents) => {
        if (readdirError !== null) {
            callFailureCallback$1(callback, readdirError);
            return;
        }
        const entries = dirents.map((dirent) => ({
            dirent,
            name: dirent.name,
            path: common$5.joinPathSegments(directory, dirent.name, settings.pathSegmentSeparator)
        }));
        if (!settings.followSymbolicLinks) {
            callSuccessCallback$1(callback, entries);
            return;
        }
        const tasks = entries.map((entry) => makeRplTaskEntry(entry, settings));
        rpl(tasks, (rplError, rplEntries) => {
            if (rplError !== null) {
                callFailureCallback$1(callback, rplError);
                return;
            }
            callSuccessCallback$1(callback, rplEntries);
        });
    });
}
async$3.readdirWithFileTypes = readdirWithFileTypes$1;
function makeRplTaskEntry(entry, settings) {
    return (done) => {
        if (!entry.dirent.isSymbolicLink()) {
            done(null, entry);
            return;
        }
        settings.fs.stat(entry.path, (statError, stats) => {
            if (statError !== null) {
                if (settings.throwErrorOnBrokenSymbolicLink) {
                    done(statError);
                    return;
                }
                done(null, entry);
                return;
            }
            entry.dirent = utils$8.fs.createDirentFromStats(entry.name, stats);
            done(null, entry);
        });
    };
}
function readdir$1(directory, settings, callback) {
    settings.fs.readdir(directory, (readdirError, names) => {
        if (readdirError !== null) {
            callFailureCallback$1(callback, readdirError);
            return;
        }
        const tasks = names.map((name) => {
            const path = common$5.joinPathSegments(directory, name, settings.pathSegmentSeparator);
            return (done) => {
                fsStat$5.stat(path, settings.fsStatSettings, (error, stats) => {
                    if (error !== null) {
                        done(error);
                        return;
                    }
                    const entry = {
                        name,
                        path,
                        dirent: utils$8.fs.createDirentFromStats(name, stats)
                    };
                    if (settings.stats) {
                        entry.stats = stats;
                    }
                    done(null, entry);
                });
            };
        });
        rpl(tasks, (rplError, entries) => {
            if (rplError !== null) {
                callFailureCallback$1(callback, rplError);
                return;
            }
            callSuccessCallback$1(callback, entries);
        });
    });
}
async$3.readdir = readdir$1;
function callFailureCallback$1(callback, error) {
    callback(error);
}
function callSuccessCallback$1(callback, result) {
    callback(null, result);
}

var sync$5 = {};

Object.defineProperty(sync$5, "__esModule", { value: true });
sync$5.readdir = sync$5.readdirWithFileTypes = sync$5.read = void 0;
const fsStat$4 = out$1;
const constants_1 = constants$1;
const utils$7 = utils$9;
const common$4 = common$6;
function read$1(directory, settings) {
    if (!settings.stats && constants_1.IS_SUPPORT_READDIR_WITH_FILE_TYPES) {
        return readdirWithFileTypes(directory, settings);
    }
    return readdir(directory, settings);
}
sync$5.read = read$1;
function readdirWithFileTypes(directory, settings) {
    const dirents = settings.fs.readdirSync(directory, { withFileTypes: true });
    return dirents.map((dirent) => {
        const entry = {
            dirent,
            name: dirent.name,
            path: common$4.joinPathSegments(directory, dirent.name, settings.pathSegmentSeparator)
        };
        if (entry.dirent.isSymbolicLink() && settings.followSymbolicLinks) {
            try {
                const stats = settings.fs.statSync(entry.path);
                entry.dirent = utils$7.fs.createDirentFromStats(entry.name, stats);
            }
            catch (error) {
                if (settings.throwErrorOnBrokenSymbolicLink) {
                    throw error;
                }
            }
        }
        return entry;
    });
}
sync$5.readdirWithFileTypes = readdirWithFileTypes;
function readdir(directory, settings) {
    const names = settings.fs.readdirSync(directory);
    return names.map((name) => {
        const entryPath = common$4.joinPathSegments(directory, name, settings.pathSegmentSeparator);
        const stats = fsStat$4.statSync(entryPath, settings.fsStatSettings);
        const entry = {
            name,
            path: entryPath,
            dirent: utils$7.fs.createDirentFromStats(name, stats)
        };
        if (settings.stats) {
            entry.stats = stats;
        }
        return entry;
    });
}
sync$5.readdir = readdir;

var settings$2 = {};

var fs$1 = {};

(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.createFileSystemAdapter = exports.FILE_SYSTEM_ADAPTER = void 0;
	const fs = require$$0$3;
	exports.FILE_SYSTEM_ADAPTER = {
	    lstat: fs.lstat,
	    stat: fs.stat,
	    lstatSync: fs.lstatSync,
	    statSync: fs.statSync,
	    readdir: fs.readdir,
	    readdirSync: fs.readdirSync
	};
	function createFileSystemAdapter(fsMethods) {
	    if (fsMethods === undefined) {
	        return exports.FILE_SYSTEM_ADAPTER;
	    }
	    return Object.assign(Object.assign({}, exports.FILE_SYSTEM_ADAPTER), fsMethods);
	}
	exports.createFileSystemAdapter = createFileSystemAdapter; 
} (fs$1));

Object.defineProperty(settings$2, "__esModule", { value: true });
const path$3 = p;
const fsStat$3 = out$1;
const fs = fs$1;
let Settings$1 = class Settings {
    constructor(_options = {}) {
        this._options = _options;
        this.followSymbolicLinks = this._getValue(this._options.followSymbolicLinks, false);
        this.fs = fs.createFileSystemAdapter(this._options.fs);
        this.pathSegmentSeparator = this._getValue(this._options.pathSegmentSeparator, path$3.sep);
        this.stats = this._getValue(this._options.stats, false);
        this.throwErrorOnBrokenSymbolicLink = this._getValue(this._options.throwErrorOnBrokenSymbolicLink, true);
        this.fsStatSettings = new fsStat$3.Settings({
            followSymbolicLink: this.followSymbolicLinks,
            fs: this.fs,
            throwErrorOnBrokenSymbolicLink: this.throwErrorOnBrokenSymbolicLink
        });
    }
    _getValue(option, value) {
        return option !== null && option !== void 0 ? option : value;
    }
};
settings$2.default = Settings$1;

Object.defineProperty(out$2, "__esModule", { value: true });
out$2.Settings = out$2.scandirSync = out$2.scandir = void 0;
const async = async$3;
const sync$4 = sync$5;
const settings_1$2 = settings$2;
out$2.Settings = settings_1$2.default;
function scandir(path, optionsOrSettingsOrCallback, callback) {
    if (typeof optionsOrSettingsOrCallback === 'function') {
        async.read(path, getSettings$1(), optionsOrSettingsOrCallback);
        return;
    }
    async.read(path, getSettings$1(optionsOrSettingsOrCallback), callback);
}
out$2.scandir = scandir;
function scandirSync(path, optionsOrSettings) {
    const settings = getSettings$1(optionsOrSettings);
    return sync$4.read(path, settings);
}
out$2.scandirSync = scandirSync;
function getSettings$1(settingsOrOptions = {}) {
    if (settingsOrOptions instanceof settings_1$2.default) {
        return settingsOrOptions;
    }
    return new settings_1$2.default(settingsOrOptions);
}

var queue = {exports: {}};

function reusify$1 (Constructor) {
  var head = new Constructor();
  var tail = head;

  function get () {
    var current = head;

    if (current.next) {
      head = current.next;
    } else {
      head = new Constructor();
      tail = head;
    }

    current.next = null;

    return current
  }

  function release (obj) {
    tail.next = obj;
    tail = obj;
  }

  return {
    get: get,
    release: release
  }
}

var reusify_1 = reusify$1;

/* eslint-disable no-var */

var reusify = reusify_1;

function fastqueue (context, worker, _concurrency) {
  if (typeof context === 'function') {
    _concurrency = worker;
    worker = context;
    context = null;
  }

  if (!(_concurrency >= 1)) {
    throw new Error('fastqueue concurrency must be equal to or greater than 1')
  }

  var cache = reusify(Task);
  var queueHead = null;
  var queueTail = null;
  var _running = 0;
  var errorHandler = null;

  var self = {
    push: push,
    drain: noop,
    saturated: noop,
    pause: pause,
    paused: false,

    get concurrency () {
      return _concurrency
    },
    set concurrency (value) {
      if (!(value >= 1)) {
        throw new Error('fastqueue concurrency must be equal to or greater than 1')
      }
      _concurrency = value;

      if (self.paused) return
      for (; queueHead && _running < _concurrency;) {
        _running++;
        release();
      }
    },

    running: running,
    resume: resume,
    idle: idle,
    length: length,
    getQueue: getQueue,
    unshift: unshift,
    empty: noop,
    kill: kill,
    killAndDrain: killAndDrain,
    error: error
  };

  return self

  function running () {
    return _running
  }

  function pause () {
    self.paused = true;
  }

  function length () {
    var current = queueHead;
    var counter = 0;

    while (current) {
      current = current.next;
      counter++;
    }

    return counter
  }

  function getQueue () {
    var current = queueHead;
    var tasks = [];

    while (current) {
      tasks.push(current.value);
      current = current.next;
    }

    return tasks
  }

  function resume () {
    if (!self.paused) return
    self.paused = false;
    if (queueHead === null) {
      _running++;
      release();
      return
    }
    for (; queueHead && _running < _concurrency;) {
      _running++;
      release();
    }
  }

  function idle () {
    return _running === 0 && self.length() === 0
  }

  function push (value, done) {
    var current = cache.get();

    current.context = context;
    current.release = release;
    current.value = value;
    current.callback = done || noop;
    current.errorHandler = errorHandler;

    if (_running >= _concurrency || self.paused) {
      if (queueTail) {
        queueTail.next = current;
        queueTail = current;
      } else {
        queueHead = current;
        queueTail = current;
        self.saturated();
      }
    } else {
      _running++;
      worker.call(context, current.value, current.worked);
    }
  }

  function unshift (value, done) {
    var current = cache.get();

    current.context = context;
    current.release = release;
    current.value = value;
    current.callback = done || noop;
    current.errorHandler = errorHandler;

    if (_running >= _concurrency || self.paused) {
      if (queueHead) {
        current.next = queueHead;
        queueHead = current;
      } else {
        queueHead = current;
        queueTail = current;
        self.saturated();
      }
    } else {
      _running++;
      worker.call(context, current.value, current.worked);
    }
  }

  function release (holder) {
    if (holder) {
      cache.release(holder);
    }
    var next = queueHead;
    if (next && _running <= _concurrency) {
      if (!self.paused) {
        if (queueTail === queueHead) {
          queueTail = null;
        }
        queueHead = next.next;
        next.next = null;
        worker.call(context, next.value, next.worked);
        if (queueTail === null) {
          self.empty();
        }
      } else {
        _running--;
      }
    } else if (--_running === 0) {
      self.drain();
    }
  }

  function kill () {
    queueHead = null;
    queueTail = null;
    self.drain = noop;
  }

  function killAndDrain () {
    queueHead = null;
    queueTail = null;
    self.drain();
    self.drain = noop;
  }

  function error (handler) {
    errorHandler = handler;
  }
}

function noop () {}

function Task () {
  this.value = null;
  this.callback = noop;
  this.next = null;
  this.release = noop;
  this.context = null;
  this.errorHandler = null;

  var self = this;

  this.worked = function worked (err, result) {
    var callback = self.callback;
    var errorHandler = self.errorHandler;
    var val = self.value;
    self.value = null;
    self.callback = noop;
    if (self.errorHandler) {
      errorHandler(err, val);
    }
    callback.call(self.context, err, result);
    self.release(self);
  };
}

function queueAsPromised (context, worker, _concurrency) {
  if (typeof context === 'function') {
    _concurrency = worker;
    worker = context;
    context = null;
  }

  function asyncWrapper (arg, cb) {
    worker.call(this, arg)
      .then(function (res) {
        cb(null, res);
      }, cb);
  }

  var queue = fastqueue(context, asyncWrapper, _concurrency);

  var pushCb = queue.push;
  var unshiftCb = queue.unshift;

  queue.push = push;
  queue.unshift = unshift;
  queue.drained = drained;

  return queue

  function push (value) {
    var p = new Promise(function (resolve, reject) {
      pushCb(value, function (err, result) {
        if (err) {
          reject(err);
          return
        }
        resolve(result);
      });
    });

    // Let's fork the promise chain to
    // make the error bubble up to the user but
    // not lead to a unhandledRejection
    p.catch(noop);

    return p
  }

  function unshift (value) {
    var p = new Promise(function (resolve, reject) {
      unshiftCb(value, function (err, result) {
        if (err) {
          reject(err);
          return
        }
        resolve(result);
      });
    });

    // Let's fork the promise chain to
    // make the error bubble up to the user but
    // not lead to a unhandledRejection
    p.catch(noop);

    return p
  }

  function drained () {
    if (queue.idle()) {
      return new Promise(function (resolve) {
        resolve();
      })
    }

    var previousDrain = queue.drain;

    var p = new Promise(function (resolve) {
      queue.drain = function () {
        previousDrain();
        resolve();
      };
    });

    return p
  }
}

queue.exports = fastqueue;
queue.exports.promise = queueAsPromised;

var queueExports = queue.exports;

var common$3 = {};

Object.defineProperty(common$3, "__esModule", { value: true });
common$3.joinPathSegments = common$3.replacePathSegmentSeparator = common$3.isAppliedFilter = common$3.isFatalError = void 0;
function isFatalError(settings, error) {
    if (settings.errorFilter === null) {
        return true;
    }
    return !settings.errorFilter(error);
}
common$3.isFatalError = isFatalError;
function isAppliedFilter(filter, value) {
    return filter === null || filter(value);
}
common$3.isAppliedFilter = isAppliedFilter;
function replacePathSegmentSeparator(filepath, separator) {
    return filepath.split(/[/\\]/).join(separator);
}
common$3.replacePathSegmentSeparator = replacePathSegmentSeparator;
function joinPathSegments(a, b, separator) {
    if (a === '') {
        return b;
    }
    /**
     * The correct handling of cases when the first segment is a root (`/`, `C:/`) or UNC path (`//?/C:/`).
     */
    if (a.endsWith(separator)) {
        return a + b;
    }
    return a + separator + b;
}
common$3.joinPathSegments = joinPathSegments;

var reader$1 = {};

Object.defineProperty(reader$1, "__esModule", { value: true });
const common$2 = common$3;
let Reader$1 = class Reader {
    constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._root = common$2.replacePathSegmentSeparator(_root, _settings.pathSegmentSeparator);
    }
};
reader$1.default = Reader$1;

Object.defineProperty(async$4, "__esModule", { value: true });
const events_1 = require$$0$4;
const fsScandir$2 = out$2;
const fastq = queueExports;
const common$1 = common$3;
const reader_1$4 = reader$1;
class AsyncReader extends reader_1$4.default {
    constructor(_root, _settings) {
        super(_root, _settings);
        this._settings = _settings;
        this._scandir = fsScandir$2.scandir;
        this._emitter = new events_1.EventEmitter();
        this._queue = fastq(this._worker.bind(this), this._settings.concurrency);
        this._isFatalError = false;
        this._isDestroyed = false;
        this._queue.drain = () => {
            if (!this._isFatalError) {
                this._emitter.emit('end');
            }
        };
    }
    read() {
        this._isFatalError = false;
        this._isDestroyed = false;
        setImmediate(() => {
            this._pushToQueue(this._root, this._settings.basePath);
        });
        return this._emitter;
    }
    get isDestroyed() {
        return this._isDestroyed;
    }
    destroy() {
        if (this._isDestroyed) {
            throw new Error('The reader is already destroyed');
        }
        this._isDestroyed = true;
        this._queue.killAndDrain();
    }
    onEntry(callback) {
        this._emitter.on('entry', callback);
    }
    onError(callback) {
        this._emitter.once('error', callback);
    }
    onEnd(callback) {
        this._emitter.once('end', callback);
    }
    _pushToQueue(directory, base) {
        const queueItem = { directory, base };
        this._queue.push(queueItem, (error) => {
            if (error !== null) {
                this._handleError(error);
            }
        });
    }
    _worker(item, done) {
        this._scandir(item.directory, this._settings.fsScandirSettings, (error, entries) => {
            if (error !== null) {
                done(error, undefined);
                return;
            }
            for (const entry of entries) {
                this._handleEntry(entry, item.base);
            }
            done(null, undefined);
        });
    }
    _handleError(error) {
        if (this._isDestroyed || !common$1.isFatalError(this._settings, error)) {
            return;
        }
        this._isFatalError = true;
        this._isDestroyed = true;
        this._emitter.emit('error', error);
    }
    _handleEntry(entry, base) {
        if (this._isDestroyed || this._isFatalError) {
            return;
        }
        const fullpath = entry.path;
        if (base !== undefined) {
            entry.path = common$1.joinPathSegments(base, entry.name, this._settings.pathSegmentSeparator);
        }
        if (common$1.isAppliedFilter(this._settings.entryFilter, entry)) {
            this._emitEntry(entry);
        }
        if (entry.dirent.isDirectory() && common$1.isAppliedFilter(this._settings.deepFilter, entry)) {
            this._pushToQueue(fullpath, base === undefined ? undefined : entry.path);
        }
    }
    _emitEntry(entry) {
        this._emitter.emit('entry', entry);
    }
}
async$4.default = AsyncReader;

Object.defineProperty(async$5, "__esModule", { value: true });
const async_1$4 = async$4;
class AsyncProvider {
    constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._reader = new async_1$4.default(this._root, this._settings);
        this._storage = [];
    }
    read(callback) {
        this._reader.onError((error) => {
            callFailureCallback(callback, error);
        });
        this._reader.onEntry((entry) => {
            this._storage.push(entry);
        });
        this._reader.onEnd(() => {
            callSuccessCallback(callback, this._storage);
        });
        this._reader.read();
    }
}
async$5.default = AsyncProvider;
function callFailureCallback(callback, error) {
    callback(error);
}
function callSuccessCallback(callback, entries) {
    callback(null, entries);
}

var stream$2 = {};

Object.defineProperty(stream$2, "__esModule", { value: true });
const stream_1$5 = require$$0$2;
const async_1$3 = async$4;
class StreamProvider {
    constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._reader = new async_1$3.default(this._root, this._settings);
        this._stream = new stream_1$5.Readable({
            objectMode: true,
            read: () => { },
            destroy: () => {
                if (!this._reader.isDestroyed) {
                    this._reader.destroy();
                }
            }
        });
    }
    read() {
        this._reader.onError((error) => {
            this._stream.emit('error', error);
        });
        this._reader.onEntry((entry) => {
            this._stream.push(entry);
        });
        this._reader.onEnd(() => {
            this._stream.push(null);
        });
        this._reader.read();
        return this._stream;
    }
}
stream$2.default = StreamProvider;

var sync$3 = {};

var sync$2 = {};

Object.defineProperty(sync$2, "__esModule", { value: true });
const fsScandir$1 = out$2;
const common = common$3;
const reader_1$3 = reader$1;
class SyncReader extends reader_1$3.default {
    constructor() {
        super(...arguments);
        this._scandir = fsScandir$1.scandirSync;
        this._storage = [];
        this._queue = new Set();
    }
    read() {
        this._pushToQueue(this._root, this._settings.basePath);
        this._handleQueue();
        return this._storage;
    }
    _pushToQueue(directory, base) {
        this._queue.add({ directory, base });
    }
    _handleQueue() {
        for (const item of this._queue.values()) {
            this._handleDirectory(item.directory, item.base);
        }
    }
    _handleDirectory(directory, base) {
        try {
            const entries = this._scandir(directory, this._settings.fsScandirSettings);
            for (const entry of entries) {
                this._handleEntry(entry, base);
            }
        }
        catch (error) {
            this._handleError(error);
        }
    }
    _handleError(error) {
        if (!common.isFatalError(this._settings, error)) {
            return;
        }
        throw error;
    }
    _handleEntry(entry, base) {
        const fullpath = entry.path;
        if (base !== undefined) {
            entry.path = common.joinPathSegments(base, entry.name, this._settings.pathSegmentSeparator);
        }
        if (common.isAppliedFilter(this._settings.entryFilter, entry)) {
            this._pushToStorage(entry);
        }
        if (entry.dirent.isDirectory() && common.isAppliedFilter(this._settings.deepFilter, entry)) {
            this._pushToQueue(fullpath, base === undefined ? undefined : entry.path);
        }
    }
    _pushToStorage(entry) {
        this._storage.push(entry);
    }
}
sync$2.default = SyncReader;

Object.defineProperty(sync$3, "__esModule", { value: true });
const sync_1$3 = sync$2;
class SyncProvider {
    constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._reader = new sync_1$3.default(this._root, this._settings);
    }
    read() {
        return this._reader.read();
    }
}
sync$3.default = SyncProvider;

var settings$1 = {};

Object.defineProperty(settings$1, "__esModule", { value: true });
const path$2 = p;
const fsScandir = out$2;
class Settings {
    constructor(_options = {}) {
        this._options = _options;
        this.basePath = this._getValue(this._options.basePath, undefined);
        this.concurrency = this._getValue(this._options.concurrency, Number.POSITIVE_INFINITY);
        this.deepFilter = this._getValue(this._options.deepFilter, null);
        this.entryFilter = this._getValue(this._options.entryFilter, null);
        this.errorFilter = this._getValue(this._options.errorFilter, null);
        this.pathSegmentSeparator = this._getValue(this._options.pathSegmentSeparator, path$2.sep);
        this.fsScandirSettings = new fsScandir.Settings({
            followSymbolicLinks: this._options.followSymbolicLinks,
            fs: this._options.fs,
            pathSegmentSeparator: this._options.pathSegmentSeparator,
            stats: this._options.stats,
            throwErrorOnBrokenSymbolicLink: this._options.throwErrorOnBrokenSymbolicLink
        });
    }
    _getValue(option, value) {
        return option !== null && option !== void 0 ? option : value;
    }
}
settings$1.default = Settings;

Object.defineProperty(out$3, "__esModule", { value: true });
out$3.Settings = out$3.walkStream = out$3.walkSync = out$3.walk = void 0;
const async_1$2 = async$5;
const stream_1$4 = stream$2;
const sync_1$2 = sync$3;
const settings_1$1 = settings$1;
out$3.Settings = settings_1$1.default;
function walk(directory, optionsOrSettingsOrCallback, callback) {
    if (typeof optionsOrSettingsOrCallback === 'function') {
        new async_1$2.default(directory, getSettings()).read(optionsOrSettingsOrCallback);
        return;
    }
    new async_1$2.default(directory, getSettings(optionsOrSettingsOrCallback)).read(callback);
}
out$3.walk = walk;
function walkSync(directory, optionsOrSettings) {
    const settings = getSettings(optionsOrSettings);
    const provider = new sync_1$2.default(directory, settings);
    return provider.read();
}
out$3.walkSync = walkSync;
function walkStream(directory, optionsOrSettings) {
    const settings = getSettings(optionsOrSettings);
    const provider = new stream_1$4.default(directory, settings);
    return provider.read();
}
out$3.walkStream = walkStream;
function getSettings(settingsOrOptions = {}) {
    if (settingsOrOptions instanceof settings_1$1.default) {
        return settingsOrOptions;
    }
    return new settings_1$1.default(settingsOrOptions);
}

var reader = {};

Object.defineProperty(reader, "__esModule", { value: true });
const path$1 = p;
const fsStat$2 = out$1;
const utils$6 = utils$c;
class Reader {
    constructor(_settings) {
        this._settings = _settings;
        this._fsStatSettings = new fsStat$2.Settings({
            followSymbolicLink: this._settings.followSymbolicLinks,
            fs: this._settings.fs,
            throwErrorOnBrokenSymbolicLink: this._settings.followSymbolicLinks
        });
    }
    _getFullEntryPath(filepath) {
        return path$1.resolve(this._settings.cwd, filepath);
    }
    _makeEntry(stats, pattern) {
        const entry = {
            name: pattern,
            path: pattern,
            dirent: utils$6.fs.createDirentFromStats(pattern, stats)
        };
        if (this._settings.stats) {
            entry.stats = stats;
        }
        return entry;
    }
    _isFatalError(error) {
        return !utils$6.errno.isEnoentCodeError(error) && !this._settings.suppressErrors;
    }
}
reader.default = Reader;

var stream$1 = {};

Object.defineProperty(stream$1, "__esModule", { value: true });
const stream_1$3 = require$$0$2;
const fsStat$1 = out$1;
const fsWalk$2 = out$3;
const reader_1$2 = reader;
class ReaderStream extends reader_1$2.default {
    constructor() {
        super(...arguments);
        this._walkStream = fsWalk$2.walkStream;
        this._stat = fsStat$1.stat;
    }
    dynamic(root, options) {
        return this._walkStream(root, options);
    }
    static(patterns, options) {
        const filepaths = patterns.map(this._getFullEntryPath, this);
        const stream = new stream_1$3.PassThrough({ objectMode: true });
        stream._write = (index, _enc, done) => {
            return this._getEntry(filepaths[index], patterns[index], options)
                .then((entry) => {
                if (entry !== null && options.entryFilter(entry)) {
                    stream.push(entry);
                }
                if (index === filepaths.length - 1) {
                    stream.end();
                }
                done();
            })
                .catch(done);
        };
        for (let i = 0; i < filepaths.length; i++) {
            stream.write(i);
        }
        return stream;
    }
    _getEntry(filepath, pattern, options) {
        return this._getStat(filepath)
            .then((stats) => this._makeEntry(stats, pattern))
            .catch((error) => {
            if (options.errorFilter(error)) {
                return null;
            }
            throw error;
        });
    }
    _getStat(filepath) {
        return new Promise((resolve, reject) => {
            this._stat(filepath, this._fsStatSettings, (error, stats) => {
                return error === null ? resolve(stats) : reject(error);
            });
        });
    }
}
stream$1.default = ReaderStream;

Object.defineProperty(async$6, "__esModule", { value: true });
const fsWalk$1 = out$3;
const reader_1$1 = reader;
const stream_1$2 = stream$1;
class ReaderAsync extends reader_1$1.default {
    constructor() {
        super(...arguments);
        this._walkAsync = fsWalk$1.walk;
        this._readerStream = new stream_1$2.default(this._settings);
    }
    dynamic(root, options) {
        return new Promise((resolve, reject) => {
            this._walkAsync(root, options, (error, entries) => {
                if (error === null) {
                    resolve(entries);
                }
                else {
                    reject(error);
                }
            });
        });
    }
    async static(patterns, options) {
        const entries = [];
        const stream = this._readerStream.static(patterns, options);
        // After #235, replace it with an asynchronous iterator.
        return new Promise((resolve, reject) => {
            stream.once('error', reject);
            stream.on('data', (entry) => entries.push(entry));
            stream.once('end', () => resolve(entries));
        });
    }
}
async$6.default = ReaderAsync;

var provider = {};

var deep = {};

var partial = {};

var matcher = {};

Object.defineProperty(matcher, "__esModule", { value: true });
const utils$5 = utils$c;
class Matcher {
    constructor(_patterns, _settings, _micromatchOptions) {
        this._patterns = _patterns;
        this._settings = _settings;
        this._micromatchOptions = _micromatchOptions;
        this._storage = [];
        this._fillStorage();
    }
    _fillStorage() {
        for (const pattern of this._patterns) {
            const segments = this._getPatternSegments(pattern);
            const sections = this._splitSegmentsIntoSections(segments);
            this._storage.push({
                complete: sections.length <= 1,
                pattern,
                segments,
                sections
            });
        }
    }
    _getPatternSegments(pattern) {
        const parts = utils$5.pattern.getPatternParts(pattern, this._micromatchOptions);
        return parts.map((part) => {
            const dynamic = utils$5.pattern.isDynamicPattern(part, this._settings);
            if (!dynamic) {
                return {
                    dynamic: false,
                    pattern: part
                };
            }
            return {
                dynamic: true,
                pattern: part,
                patternRe: utils$5.pattern.makeRe(part, this._micromatchOptions)
            };
        });
    }
    _splitSegmentsIntoSections(segments) {
        return utils$5.array.splitWhen(segments, (segment) => segment.dynamic && utils$5.pattern.hasGlobStar(segment.pattern));
    }
}
matcher.default = Matcher;

Object.defineProperty(partial, "__esModule", { value: true });
const matcher_1 = matcher;
class PartialMatcher extends matcher_1.default {
    match(filepath) {
        const parts = filepath.split('/');
        const levels = parts.length;
        const patterns = this._storage.filter((info) => !info.complete || info.segments.length > levels);
        for (const pattern of patterns) {
            const section = pattern.sections[0];
            /**
             * In this case, the pattern has a globstar and we must read all directories unconditionally,
             * but only if the level has reached the end of the first group.
             *
             * fixtures/{a,b}/**
             *  ^ true/false  ^ always true
            */
            if (!pattern.complete && levels > section.length) {
                return true;
            }
            const match = parts.every((part, index) => {
                const segment = pattern.segments[index];
                if (segment.dynamic && segment.patternRe.test(part)) {
                    return true;
                }
                if (!segment.dynamic && segment.pattern === part) {
                    return true;
                }
                return false;
            });
            if (match) {
                return true;
            }
        }
        return false;
    }
}
partial.default = PartialMatcher;

Object.defineProperty(deep, "__esModule", { value: true });
const utils$4 = utils$c;
const partial_1 = partial;
class DeepFilter {
    constructor(_settings, _micromatchOptions) {
        this._settings = _settings;
        this._micromatchOptions = _micromatchOptions;
    }
    getFilter(basePath, positive, negative) {
        const matcher = this._getMatcher(positive);
        const negativeRe = this._getNegativePatternsRe(negative);
        return (entry) => this._filter(basePath, entry, matcher, negativeRe);
    }
    _getMatcher(patterns) {
        return new partial_1.default(patterns, this._settings, this._micromatchOptions);
    }
    _getNegativePatternsRe(patterns) {
        const affectDepthOfReadingPatterns = patterns.filter(utils$4.pattern.isAffectDepthOfReadingPattern);
        return utils$4.pattern.convertPatternsToRe(affectDepthOfReadingPatterns, this._micromatchOptions);
    }
    _filter(basePath, entry, matcher, negativeRe) {
        if (this._isSkippedByDeep(basePath, entry.path)) {
            return false;
        }
        if (this._isSkippedSymbolicLink(entry)) {
            return false;
        }
        const filepath = utils$4.path.removeLeadingDotSegment(entry.path);
        if (this._isSkippedByPositivePatterns(filepath, matcher)) {
            return false;
        }
        return this._isSkippedByNegativePatterns(filepath, negativeRe);
    }
    _isSkippedByDeep(basePath, entryPath) {
        /**
         * Avoid unnecessary depth calculations when it doesn't matter.
         */
        if (this._settings.deep === Infinity) {
            return false;
        }
        return this._getEntryLevel(basePath, entryPath) >= this._settings.deep;
    }
    _getEntryLevel(basePath, entryPath) {
        const entryPathDepth = entryPath.split('/').length;
        if (basePath === '') {
            return entryPathDepth;
        }
        const basePathDepth = basePath.split('/').length;
        return entryPathDepth - basePathDepth;
    }
    _isSkippedSymbolicLink(entry) {
        return !this._settings.followSymbolicLinks && entry.dirent.isSymbolicLink();
    }
    _isSkippedByPositivePatterns(entryPath, matcher) {
        return !this._settings.baseNameMatch && !matcher.match(entryPath);
    }
    _isSkippedByNegativePatterns(entryPath, patternsRe) {
        return !utils$4.pattern.matchAny(entryPath, patternsRe);
    }
}
deep.default = DeepFilter;

var entry$1 = {};

Object.defineProperty(entry$1, "__esModule", { value: true });
const utils$3 = utils$c;
class EntryFilter {
    constructor(_settings, _micromatchOptions) {
        this._settings = _settings;
        this._micromatchOptions = _micromatchOptions;
        this.index = new Map();
    }
    getFilter(positive, negative) {
        const positiveRe = utils$3.pattern.convertPatternsToRe(positive, this._micromatchOptions);
        const negativeRe = utils$3.pattern.convertPatternsToRe(negative, Object.assign(Object.assign({}, this._micromatchOptions), { dot: true }));
        return (entry) => this._filter(entry, positiveRe, negativeRe);
    }
    _filter(entry, positiveRe, negativeRe) {
        const filepath = utils$3.path.removeLeadingDotSegment(entry.path);
        if (this._settings.unique && this._isDuplicateEntry(filepath)) {
            return false;
        }
        if (this._onlyFileFilter(entry) || this._onlyDirectoryFilter(entry)) {
            return false;
        }
        if (this._isSkippedByAbsoluteNegativePatterns(filepath, negativeRe)) {
            return false;
        }
        const isDirectory = entry.dirent.isDirectory();
        const isMatched = this._isMatchToPatterns(filepath, positiveRe, isDirectory) && !this._isMatchToPatterns(filepath, negativeRe, isDirectory);
        if (this._settings.unique && isMatched) {
            this._createIndexRecord(filepath);
        }
        return isMatched;
    }
    _isDuplicateEntry(filepath) {
        return this.index.has(filepath);
    }
    _createIndexRecord(filepath) {
        this.index.set(filepath, undefined);
    }
    _onlyFileFilter(entry) {
        return this._settings.onlyFiles && !entry.dirent.isFile();
    }
    _onlyDirectoryFilter(entry) {
        return this._settings.onlyDirectories && !entry.dirent.isDirectory();
    }
    _isSkippedByAbsoluteNegativePatterns(entryPath, patternsRe) {
        if (!this._settings.absolute) {
            return false;
        }
        const fullpath = utils$3.path.makeAbsolute(this._settings.cwd, entryPath);
        return utils$3.pattern.matchAny(fullpath, patternsRe);
    }
    _isMatchToPatterns(filepath, patternsRe, isDirectory) {
        // Trying to match files and directories by patterns.
        const isMatched = utils$3.pattern.matchAny(filepath, patternsRe);
        // A pattern with a trailling slash can be used for directory matching.
        // To apply such pattern, we need to add a tralling slash to the path.
        if (!isMatched && isDirectory) {
            return utils$3.pattern.matchAny(filepath + '/', patternsRe);
        }
        return isMatched;
    }
}
entry$1.default = EntryFilter;

var error = {};

Object.defineProperty(error, "__esModule", { value: true });
const utils$2 = utils$c;
class ErrorFilter {
    constructor(_settings) {
        this._settings = _settings;
    }
    getFilter() {
        return (error) => this._isNonFatalError(error);
    }
    _isNonFatalError(error) {
        return utils$2.errno.isEnoentCodeError(error) || this._settings.suppressErrors;
    }
}
error.default = ErrorFilter;

var entry = {};

Object.defineProperty(entry, "__esModule", { value: true });
const utils$1 = utils$c;
class EntryTransformer {
    constructor(_settings) {
        this._settings = _settings;
    }
    getTransformer() {
        return (entry) => this._transform(entry);
    }
    _transform(entry) {
        let filepath = entry.path;
        if (this._settings.absolute) {
            filepath = utils$1.path.makeAbsolute(this._settings.cwd, filepath);
            filepath = utils$1.path.unixify(filepath);
        }
        if (this._settings.markDirectories && entry.dirent.isDirectory()) {
            filepath += '/';
        }
        if (!this._settings.objectMode) {
            return filepath;
        }
        return Object.assign(Object.assign({}, entry), { path: filepath });
    }
}
entry.default = EntryTransformer;

Object.defineProperty(provider, "__esModule", { value: true });
const path = p;
const deep_1 = deep;
const entry_1 = entry$1;
const error_1 = error;
const entry_2 = entry;
class Provider {
    constructor(_settings) {
        this._settings = _settings;
        this.errorFilter = new error_1.default(this._settings);
        this.entryFilter = new entry_1.default(this._settings, this._getMicromatchOptions());
        this.deepFilter = new deep_1.default(this._settings, this._getMicromatchOptions());
        this.entryTransformer = new entry_2.default(this._settings);
    }
    _getRootDirectory(task) {
        return path.resolve(this._settings.cwd, task.base);
    }
    _getReaderOptions(task) {
        const basePath = task.base === '.' ? '' : task.base;
        return {
            basePath,
            pathSegmentSeparator: '/',
            concurrency: this._settings.concurrency,
            deepFilter: this.deepFilter.getFilter(basePath, task.positive, task.negative),
            entryFilter: this.entryFilter.getFilter(task.positive, task.negative),
            errorFilter: this.errorFilter.getFilter(),
            followSymbolicLinks: this._settings.followSymbolicLinks,
            fs: this._settings.fs,
            stats: this._settings.stats,
            throwErrorOnBrokenSymbolicLink: this._settings.throwErrorOnBrokenSymbolicLink,
            transform: this.entryTransformer.getTransformer()
        };
    }
    _getMicromatchOptions() {
        return {
            dot: this._settings.dot,
            matchBase: this._settings.baseNameMatch,
            nobrace: !this._settings.braceExpansion,
            nocase: !this._settings.caseSensitiveMatch,
            noext: !this._settings.extglob,
            noglobstar: !this._settings.globstar,
            posix: true,
            strictSlashes: false
        };
    }
}
provider.default = Provider;

Object.defineProperty(async$7, "__esModule", { value: true });
const async_1$1 = async$6;
const provider_1$2 = provider;
class ProviderAsync extends provider_1$2.default {
    constructor() {
        super(...arguments);
        this._reader = new async_1$1.default(this._settings);
    }
    async read(task) {
        const root = this._getRootDirectory(task);
        const options = this._getReaderOptions(task);
        const entries = await this.api(root, task, options);
        return entries.map((entry) => options.transform(entry));
    }
    api(root, task, options) {
        if (task.dynamic) {
            return this._reader.dynamic(root, options);
        }
        return this._reader.static(task.patterns, options);
    }
}
async$7.default = ProviderAsync;

var stream = {};

Object.defineProperty(stream, "__esModule", { value: true });
const stream_1$1 = require$$0$2;
const stream_2 = stream$1;
const provider_1$1 = provider;
class ProviderStream extends provider_1$1.default {
    constructor() {
        super(...arguments);
        this._reader = new stream_2.default(this._settings);
    }
    read(task) {
        const root = this._getRootDirectory(task);
        const options = this._getReaderOptions(task);
        const source = this.api(root, task, options);
        const destination = new stream_1$1.Readable({ objectMode: true, read: () => { } });
        source
            .once('error', (error) => destination.emit('error', error))
            .on('data', (entry) => destination.emit('data', options.transform(entry)))
            .once('end', () => destination.emit('end'));
        destination
            .once('close', () => source.destroy());
        return destination;
    }
    api(root, task, options) {
        if (task.dynamic) {
            return this._reader.dynamic(root, options);
        }
        return this._reader.static(task.patterns, options);
    }
}
stream.default = ProviderStream;

var sync$1 = {};

var sync = {};

Object.defineProperty(sync, "__esModule", { value: true });
const fsStat = out$1;
const fsWalk = out$3;
const reader_1 = reader;
class ReaderSync extends reader_1.default {
    constructor() {
        super(...arguments);
        this._walkSync = fsWalk.walkSync;
        this._statSync = fsStat.statSync;
    }
    dynamic(root, options) {
        return this._walkSync(root, options);
    }
    static(patterns, options) {
        const entries = [];
        for (const pattern of patterns) {
            const filepath = this._getFullEntryPath(pattern);
            const entry = this._getEntry(filepath, pattern, options);
            if (entry === null || !options.entryFilter(entry)) {
                continue;
            }
            entries.push(entry);
        }
        return entries;
    }
    _getEntry(filepath, pattern, options) {
        try {
            const stats = this._getStat(filepath);
            return this._makeEntry(stats, pattern);
        }
        catch (error) {
            if (options.errorFilter(error)) {
                return null;
            }
            throw error;
        }
    }
    _getStat(filepath) {
        return this._statSync(filepath, this._fsStatSettings);
    }
}
sync.default = ReaderSync;

Object.defineProperty(sync$1, "__esModule", { value: true });
const sync_1$1 = sync;
const provider_1 = provider;
class ProviderSync extends provider_1.default {
    constructor() {
        super(...arguments);
        this._reader = new sync_1$1.default(this._settings);
    }
    read(task) {
        const root = this._getRootDirectory(task);
        const options = this._getReaderOptions(task);
        const entries = this.api(root, task, options);
        return entries.map(options.transform);
    }
    api(root, task, options) {
        if (task.dynamic) {
            return this._reader.dynamic(root, options);
        }
        return this._reader.static(task.patterns, options);
    }
}
sync$1.default = ProviderSync;

var settings = {};

(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.DEFAULT_FILE_SYSTEM_ADAPTER = void 0;
	const fs = require$$0$3;
	const os = require$$0;
	/**
	 * The `os.cpus` method can return zero. We expect the number of cores to be greater than zero.
	 * https://github.com/nodejs/node/blob/7faeddf23a98c53896f8b574a6e66589e8fb1eb8/lib/os.js#L106-L107
	 */
	const CPU_COUNT = Math.max(os.cpus().length, 1);
	exports.DEFAULT_FILE_SYSTEM_ADAPTER = {
	    lstat: fs.lstat,
	    lstatSync: fs.lstatSync,
	    stat: fs.stat,
	    statSync: fs.statSync,
	    readdir: fs.readdir,
	    readdirSync: fs.readdirSync
	};
	class Settings {
	    constructor(_options = {}) {
	        this._options = _options;
	        this.absolute = this._getValue(this._options.absolute, false);
	        this.baseNameMatch = this._getValue(this._options.baseNameMatch, false);
	        this.braceExpansion = this._getValue(this._options.braceExpansion, true);
	        this.caseSensitiveMatch = this._getValue(this._options.caseSensitiveMatch, true);
	        this.concurrency = this._getValue(this._options.concurrency, CPU_COUNT);
	        this.cwd = this._getValue(this._options.cwd, process.cwd());
	        this.deep = this._getValue(this._options.deep, Infinity);
	        this.dot = this._getValue(this._options.dot, false);
	        this.extglob = this._getValue(this._options.extglob, true);
	        this.followSymbolicLinks = this._getValue(this._options.followSymbolicLinks, true);
	        this.fs = this._getFileSystemMethods(this._options.fs);
	        this.globstar = this._getValue(this._options.globstar, true);
	        this.ignore = this._getValue(this._options.ignore, []);
	        this.markDirectories = this._getValue(this._options.markDirectories, false);
	        this.objectMode = this._getValue(this._options.objectMode, false);
	        this.onlyDirectories = this._getValue(this._options.onlyDirectories, false);
	        this.onlyFiles = this._getValue(this._options.onlyFiles, true);
	        this.stats = this._getValue(this._options.stats, false);
	        this.suppressErrors = this._getValue(this._options.suppressErrors, false);
	        this.throwErrorOnBrokenSymbolicLink = this._getValue(this._options.throwErrorOnBrokenSymbolicLink, false);
	        this.unique = this._getValue(this._options.unique, true);
	        if (this.onlyDirectories) {
	            this.onlyFiles = false;
	        }
	        if (this.stats) {
	            this.objectMode = true;
	        }
	        // Remove the cast to the array in the next major (#404).
	        this.ignore = [].concat(this.ignore);
	    }
	    _getValue(option, value) {
	        return option === undefined ? value : option;
	    }
	    _getFileSystemMethods(methods = {}) {
	        return Object.assign(Object.assign({}, exports.DEFAULT_FILE_SYSTEM_ADAPTER), methods);
	    }
	}
	exports.default = Settings; 
} (settings));

const taskManager = tasks;
const async_1 = async$7;
const stream_1 = stream;
const sync_1 = sync$1;
const settings_1 = settings;
const utils = utils$c;
async function FastGlob(source, options) {
    assertPatternsInput(source);
    const works = getWorks(source, async_1.default, options);
    const result = await Promise.all(works);
    return utils.array.flatten(result);
}
// https://github.com/typescript-eslint/typescript-eslint/issues/60
// eslint-disable-next-line no-redeclare
(function (FastGlob) {
    FastGlob.glob = FastGlob;
    FastGlob.globSync = sync;
    FastGlob.globStream = stream;
    FastGlob.async = FastGlob;
    function sync(source, options) {
        assertPatternsInput(source);
        const works = getWorks(source, sync_1.default, options);
        return utils.array.flatten(works);
    }
    FastGlob.sync = sync;
    function stream(source, options) {
        assertPatternsInput(source);
        const works = getWorks(source, stream_1.default, options);
        /**
         * The stream returned by the provider cannot work with an asynchronous iterator.
         * To support asynchronous iterators, regardless of the number of tasks, we always multiplex streams.
         * This affects performance (+25%). I don't see best solution right now.
         */
        return utils.stream.merge(works);
    }
    FastGlob.stream = stream;
    function generateTasks(source, options) {
        assertPatternsInput(source);
        const patterns = [].concat(source);
        const settings = new settings_1.default(options);
        return taskManager.generate(patterns, settings);
    }
    FastGlob.generateTasks = generateTasks;
    function isDynamicPattern(source, options) {
        assertPatternsInput(source);
        const settings = new settings_1.default(options);
        return utils.pattern.isDynamicPattern(source, settings);
    }
    FastGlob.isDynamicPattern = isDynamicPattern;
    function escapePath(source) {
        assertPatternsInput(source);
        return utils.path.escape(source);
    }
    FastGlob.escapePath = escapePath;
    function convertPathToPattern(source) {
        assertPatternsInput(source);
        return utils.path.convertPathToPattern(source);
    }
    FastGlob.convertPathToPattern = convertPathToPattern;
    (function (posix) {
        function escapePath(source) {
            assertPatternsInput(source);
            return utils.path.escapePosixPath(source);
        }
        posix.escapePath = escapePath;
        function convertPathToPattern(source) {
            assertPatternsInput(source);
            return utils.path.convertPosixPathToPattern(source);
        }
        posix.convertPathToPattern = convertPathToPattern;
    })(FastGlob.posix || (FastGlob.posix = {}));
    (function (win32) {
        function escapePath(source) {
            assertPatternsInput(source);
            return utils.path.escapeWindowsPath(source);
        }
        win32.escapePath = escapePath;
        function convertPathToPattern(source) {
            assertPatternsInput(source);
            return utils.path.convertWindowsPathToPattern(source);
        }
        win32.convertPathToPattern = convertPathToPattern;
    })(FastGlob.win32 || (FastGlob.win32 = {}));
})(FastGlob || (FastGlob = {}));
function getWorks(source, _Provider, options) {
    const patterns = [].concat(source);
    const settings = new settings_1.default(options);
    const tasks = taskManager.generate(patterns, settings);
    const provider = new _Provider(settings);
    return tasks.map(provider.read, provider);
}
function assertPatternsInput(input) {
    const source = [].concat(input);
    const isValidSource = source.every((item) => utils.string.isString(item) && !utils.string.isEmpty(item));
    if (!isValidSource) {
        throw new TypeError('Patterns must be a string (non empty) or an array of strings');
    }
}
var out = FastGlob;

var fg = /*@__PURE__*/getDefaultExportFromCjs(out);

var bufferUtil$1 = {exports: {}};

const BINARY_TYPES$2 = ['nodebuffer', 'arraybuffer', 'fragments'];
const hasBlob$1 = typeof Blob !== 'undefined';

if (hasBlob$1) BINARY_TYPES$2.push('blob');

var constants = {
  BINARY_TYPES: BINARY_TYPES$2,
  EMPTY_BUFFER: Buffer.alloc(0),
  GUID: '258EAFA5-E914-47DA-95CA-C5AB0DC85B11',
  hasBlob: hasBlob$1,
  kForOnEventAttribute: Symbol('kIsForOnEventAttribute'),
  kListener: Symbol('kListener'),
  kStatusCode: Symbol('status-code'),
  kWebSocket: Symbol('websocket'),
  NOOP: () => {}
};

var unmask$1;
var mask;

const { EMPTY_BUFFER: EMPTY_BUFFER$3 } = constants;

const FastBuffer$2 = Buffer[Symbol.species];

/**
 * Merges an array of buffers into a new buffer.
 *
 * @param {Buffer[]} list The array of buffers to concat
 * @param {Number} totalLength The total length of buffers in the list
 * @return {Buffer} The resulting buffer
 * @public
 */
function concat$1(list, totalLength) {
  if (list.length === 0) return EMPTY_BUFFER$3;
  if (list.length === 1) return list[0];

  const target = Buffer.allocUnsafe(totalLength);
  let offset = 0;

  for (let i = 0; i < list.length; i++) {
    const buf = list[i];
    target.set(buf, offset);
    offset += buf.length;
  }

  if (offset < totalLength) {
    return new FastBuffer$2(target.buffer, target.byteOffset, offset);
  }

  return target;
}

/**
 * Masks a buffer using the given mask.
 *
 * @param {Buffer} source The buffer to mask
 * @param {Buffer} mask The mask to use
 * @param {Buffer} output The buffer where to store the result
 * @param {Number} offset The offset at which to start writing
 * @param {Number} length The number of bytes to mask.
 * @public
 */
function _mask(source, mask, output, offset, length) {
  for (let i = 0; i < length; i++) {
    output[offset + i] = source[i] ^ mask[i & 3];
  }
}

/**
 * Unmasks a buffer using the given mask.
 *
 * @param {Buffer} buffer The buffer to unmask
 * @param {Buffer} mask The mask to use
 * @public
 */
function _unmask(buffer, mask) {
  for (let i = 0; i < buffer.length; i++) {
    buffer[i] ^= mask[i & 3];
  }
}

/**
 * Converts a buffer to an `ArrayBuffer`.
 *
 * @param {Buffer} buf The buffer to convert
 * @return {ArrayBuffer} Converted buffer
 * @public
 */
function toArrayBuffer$1(buf) {
  if (buf.length === buf.buffer.byteLength) {
    return buf.buffer;
  }

  return buf.buffer.slice(buf.byteOffset, buf.byteOffset + buf.length);
}

/**
 * Converts `data` to a `Buffer`.
 *
 * @param {*} data The data to convert
 * @return {Buffer} The buffer
 * @throws {TypeError}
 * @public
 */
function toBuffer$2(data) {
  toBuffer$2.readOnly = true;

  if (Buffer.isBuffer(data)) return data;

  let buf;

  if (data instanceof ArrayBuffer) {
    buf = new FastBuffer$2(data);
  } else if (ArrayBuffer.isView(data)) {
    buf = new FastBuffer$2(data.buffer, data.byteOffset, data.byteLength);
  } else {
    buf = Buffer.from(data);
    toBuffer$2.readOnly = false;
  }

  return buf;
}

bufferUtil$1.exports = {
  concat: concat$1,
  mask: _mask,
  toArrayBuffer: toArrayBuffer$1,
  toBuffer: toBuffer$2,
  unmask: _unmask
};

/* istanbul ignore else  */
if (!process.env.WS_NO_BUFFER_UTIL) {
  try {
    const bufferUtil = require('bufferutil');

    mask = bufferUtil$1.exports.mask = function (source, mask, output, offset, length) {
      if (length < 48) _mask(source, mask, output, offset, length);
      else bufferUtil.mask(source, mask, output, offset, length);
    };

    unmask$1 = bufferUtil$1.exports.unmask = function (buffer, mask) {
      if (buffer.length < 32) _unmask(buffer, mask);
      else bufferUtil.unmask(buffer, mask);
    };
  } catch (e) {
    // Continue regardless of the error.
  }
}

var bufferUtilExports = bufferUtil$1.exports;

const kDone = Symbol('kDone');
const kRun = Symbol('kRun');

/**
 * A very simple job queue with adjustable concurrency. Adapted from
 * https://github.com/STRML/async-limiter
 */
let Limiter$1 = class Limiter {
  /**
   * Creates a new `Limiter`.
   *
   * @param {Number} [concurrency=Infinity] The maximum number of jobs allowed
   *     to run concurrently
   */
  constructor(concurrency) {
    this[kDone] = () => {
      this.pending--;
      this[kRun]();
    };
    this.concurrency = concurrency || Infinity;
    this.jobs = [];
    this.pending = 0;
  }

  /**
   * Adds a job to the queue.
   *
   * @param {Function} job The job to run
   * @public
   */
  add(job) {
    this.jobs.push(job);
    this[kRun]();
  }

  /**
   * Removes a job from the queue and runs it if possible.
   *
   * @private
   */
  [kRun]() {
    if (this.pending === this.concurrency) return;

    if (this.jobs.length) {
      const job = this.jobs.shift();

      this.pending++;
      job(this[kDone]);
    }
  }
};

var limiter = Limiter$1;

const zlib = require$$0$5;

const bufferUtil = bufferUtilExports;
const Limiter = limiter;
const { kStatusCode: kStatusCode$2 } = constants;

const FastBuffer$1 = Buffer[Symbol.species];
const TRAILER = Buffer.from([0x00, 0x00, 0xff, 0xff]);
const kPerMessageDeflate = Symbol('permessage-deflate');
const kTotalLength = Symbol('total-length');
const kCallback = Symbol('callback');
const kBuffers = Symbol('buffers');
const kError$1 = Symbol('error');

//
// We limit zlib concurrency, which prevents severe memory fragmentation
// as documented in https://github.com/nodejs/node/issues/8871#issuecomment-250915913
// and https://github.com/websockets/ws/issues/1202
//
// Intentionally global; it's the global thread pool that's an issue.
//
let zlibLimiter;

/**
 * permessage-deflate implementation.
 */
let PerMessageDeflate$4 = class PerMessageDeflate {
  /**
   * Creates a PerMessageDeflate instance.
   *
   * @param {Object} [options] Configuration options
   * @param {(Boolean|Number)} [options.clientMaxWindowBits] Advertise support
   *     for, or request, a custom client window size
   * @param {Boolean} [options.clientNoContextTakeover=false] Advertise/
   *     acknowledge disabling of client context takeover
   * @param {Number} [options.concurrencyLimit=10] The number of concurrent
   *     calls to zlib
   * @param {(Boolean|Number)} [options.serverMaxWindowBits] Request/confirm the
   *     use of a custom server window size
   * @param {Boolean} [options.serverNoContextTakeover=false] Request/accept
   *     disabling of server context takeover
   * @param {Number} [options.threshold=1024] Size (in bytes) below which
   *     messages should not be compressed if context takeover is disabled
   * @param {Object} [options.zlibDeflateOptions] Options to pass to zlib on
   *     deflate
   * @param {Object} [options.zlibInflateOptions] Options to pass to zlib on
   *     inflate
   * @param {Boolean} [isServer=false] Create the instance in either server or
   *     client mode
   * @param {Number} [maxPayload=0] The maximum allowed message length
   */
  constructor(options, isServer, maxPayload) {
    this._maxPayload = maxPayload | 0;
    this._options = options || {};
    this._threshold =
      this._options.threshold !== undefined ? this._options.threshold : 1024;
    this._isServer = !!isServer;
    this._deflate = null;
    this._inflate = null;

    this.params = null;

    if (!zlibLimiter) {
      const concurrency =
        this._options.concurrencyLimit !== undefined
          ? this._options.concurrencyLimit
          : 10;
      zlibLimiter = new Limiter(concurrency);
    }
  }

  /**
   * @type {String}
   */
  static get extensionName() {
    return 'permessage-deflate';
  }

  /**
   * Create an extension negotiation offer.
   *
   * @return {Object} Extension parameters
   * @public
   */
  offer() {
    const params = {};

    if (this._options.serverNoContextTakeover) {
      params.server_no_context_takeover = true;
    }
    if (this._options.clientNoContextTakeover) {
      params.client_no_context_takeover = true;
    }
    if (this._options.serverMaxWindowBits) {
      params.server_max_window_bits = this._options.serverMaxWindowBits;
    }
    if (this._options.clientMaxWindowBits) {
      params.client_max_window_bits = this._options.clientMaxWindowBits;
    } else if (this._options.clientMaxWindowBits == null) {
      params.client_max_window_bits = true;
    }

    return params;
  }

  /**
   * Accept an extension negotiation offer/response.
   *
   * @param {Array} configurations The extension negotiation offers/reponse
   * @return {Object} Accepted configuration
   * @public
   */
  accept(configurations) {
    configurations = this.normalizeParams(configurations);

    this.params = this._isServer
      ? this.acceptAsServer(configurations)
      : this.acceptAsClient(configurations);

    return this.params;
  }

  /**
   * Releases all resources used by the extension.
   *
   * @public
   */
  cleanup() {
    if (this._inflate) {
      this._inflate.close();
      this._inflate = null;
    }

    if (this._deflate) {
      const callback = this._deflate[kCallback];

      this._deflate.close();
      this._deflate = null;

      if (callback) {
        callback(
          new Error(
            'The deflate stream was closed while data was being processed'
          )
        );
      }
    }
  }

  /**
   *  Accept an extension negotiation offer.
   *
   * @param {Array} offers The extension negotiation offers
   * @return {Object} Accepted configuration
   * @private
   */
  acceptAsServer(offers) {
    const opts = this._options;
    const accepted = offers.find((params) => {
      if (
        (opts.serverNoContextTakeover === false &&
          params.server_no_context_takeover) ||
        (params.server_max_window_bits &&
          (opts.serverMaxWindowBits === false ||
            (typeof opts.serverMaxWindowBits === 'number' &&
              opts.serverMaxWindowBits > params.server_max_window_bits))) ||
        (typeof opts.clientMaxWindowBits === 'number' &&
          !params.client_max_window_bits)
      ) {
        return false;
      }

      return true;
    });

    if (!accepted) {
      throw new Error('None of the extension offers can be accepted');
    }

    if (opts.serverNoContextTakeover) {
      accepted.server_no_context_takeover = true;
    }
    if (opts.clientNoContextTakeover) {
      accepted.client_no_context_takeover = true;
    }
    if (typeof opts.serverMaxWindowBits === 'number') {
      accepted.server_max_window_bits = opts.serverMaxWindowBits;
    }
    if (typeof opts.clientMaxWindowBits === 'number') {
      accepted.client_max_window_bits = opts.clientMaxWindowBits;
    } else if (
      accepted.client_max_window_bits === true ||
      opts.clientMaxWindowBits === false
    ) {
      delete accepted.client_max_window_bits;
    }

    return accepted;
  }

  /**
   * Accept the extension negotiation response.
   *
   * @param {Array} response The extension negotiation response
   * @return {Object} Accepted configuration
   * @private
   */
  acceptAsClient(response) {
    const params = response[0];

    if (
      this._options.clientNoContextTakeover === false &&
      params.client_no_context_takeover
    ) {
      throw new Error('Unexpected parameter "client_no_context_takeover"');
    }

    if (!params.client_max_window_bits) {
      if (typeof this._options.clientMaxWindowBits === 'number') {
        params.client_max_window_bits = this._options.clientMaxWindowBits;
      }
    } else if (
      this._options.clientMaxWindowBits === false ||
      (typeof this._options.clientMaxWindowBits === 'number' &&
        params.client_max_window_bits > this._options.clientMaxWindowBits)
    ) {
      throw new Error(
        'Unexpected or invalid parameter "client_max_window_bits"'
      );
    }

    return params;
  }

  /**
   * Normalize parameters.
   *
   * @param {Array} configurations The extension negotiation offers/reponse
   * @return {Array} The offers/response with normalized parameters
   * @private
   */
  normalizeParams(configurations) {
    configurations.forEach((params) => {
      Object.keys(params).forEach((key) => {
        let value = params[key];

        if (value.length > 1) {
          throw new Error(`Parameter "${key}" must have only a single value`);
        }

        value = value[0];

        if (key === 'client_max_window_bits') {
          if (value !== true) {
            const num = +value;
            if (!Number.isInteger(num) || num < 8 || num > 15) {
              throw new TypeError(
                `Invalid value for parameter "${key}": ${value}`
              );
            }
            value = num;
          } else if (!this._isServer) {
            throw new TypeError(
              `Invalid value for parameter "${key}": ${value}`
            );
          }
        } else if (key === 'server_max_window_bits') {
          const num = +value;
          if (!Number.isInteger(num) || num < 8 || num > 15) {
            throw new TypeError(
              `Invalid value for parameter "${key}": ${value}`
            );
          }
          value = num;
        } else if (
          key === 'client_no_context_takeover' ||
          key === 'server_no_context_takeover'
        ) {
          if (value !== true) {
            throw new TypeError(
              `Invalid value for parameter "${key}": ${value}`
            );
          }
        } else {
          throw new Error(`Unknown parameter "${key}"`);
        }

        params[key] = value;
      });
    });

    return configurations;
  }

  /**
   * Decompress data. Concurrency limited.
   *
   * @param {Buffer} data Compressed data
   * @param {Boolean} fin Specifies whether or not this is the last fragment
   * @param {Function} callback Callback
   * @public
   */
  decompress(data, fin, callback) {
    zlibLimiter.add((done) => {
      this._decompress(data, fin, (err, result) => {
        done();
        callback(err, result);
      });
    });
  }

  /**
   * Compress data. Concurrency limited.
   *
   * @param {(Buffer|String)} data Data to compress
   * @param {Boolean} fin Specifies whether or not this is the last fragment
   * @param {Function} callback Callback
   * @public
   */
  compress(data, fin, callback) {
    zlibLimiter.add((done) => {
      this._compress(data, fin, (err, result) => {
        done();
        callback(err, result);
      });
    });
  }

  /**
   * Decompress data.
   *
   * @param {Buffer} data Compressed data
   * @param {Boolean} fin Specifies whether or not this is the last fragment
   * @param {Function} callback Callback
   * @private
   */
  _decompress(data, fin, callback) {
    const endpoint = this._isServer ? 'client' : 'server';

    if (!this._inflate) {
      const key = `${endpoint}_max_window_bits`;
      const windowBits =
        typeof this.params[key] !== 'number'
          ? zlib.Z_DEFAULT_WINDOWBITS
          : this.params[key];

      this._inflate = zlib.createInflateRaw({
        ...this._options.zlibInflateOptions,
        windowBits
      });
      this._inflate[kPerMessageDeflate] = this;
      this._inflate[kTotalLength] = 0;
      this._inflate[kBuffers] = [];
      this._inflate.on('error', inflateOnError);
      this._inflate.on('data', inflateOnData);
    }

    this._inflate[kCallback] = callback;

    this._inflate.write(data);
    if (fin) this._inflate.write(TRAILER);

    this._inflate.flush(() => {
      const err = this._inflate[kError$1];

      if (err) {
        this._inflate.close();
        this._inflate = null;
        callback(err);
        return;
      }

      const data = bufferUtil.concat(
        this._inflate[kBuffers],
        this._inflate[kTotalLength]
      );

      if (this._inflate._readableState.endEmitted) {
        this._inflate.close();
        this._inflate = null;
      } else {
        this._inflate[kTotalLength] = 0;
        this._inflate[kBuffers] = [];

        if (fin && this.params[`${endpoint}_no_context_takeover`]) {
          this._inflate.reset();
        }
      }

      callback(null, data);
    });
  }

  /**
   * Compress data.
   *
   * @param {(Buffer|String)} data Data to compress
   * @param {Boolean} fin Specifies whether or not this is the last fragment
   * @param {Function} callback Callback
   * @private
   */
  _compress(data, fin, callback) {
    const endpoint = this._isServer ? 'server' : 'client';

    if (!this._deflate) {
      const key = `${endpoint}_max_window_bits`;
      const windowBits =
        typeof this.params[key] !== 'number'
          ? zlib.Z_DEFAULT_WINDOWBITS
          : this.params[key];

      this._deflate = zlib.createDeflateRaw({
        ...this._options.zlibDeflateOptions,
        windowBits
      });

      this._deflate[kTotalLength] = 0;
      this._deflate[kBuffers] = [];

      this._deflate.on('data', deflateOnData);
    }

    this._deflate[kCallback] = callback;

    this._deflate.write(data);
    this._deflate.flush(zlib.Z_SYNC_FLUSH, () => {
      if (!this._deflate) {
        //
        // The deflate stream was closed while data was being processed.
        //
        return;
      }

      let data = bufferUtil.concat(
        this._deflate[kBuffers],
        this._deflate[kTotalLength]
      );

      if (fin) {
        data = new FastBuffer$1(data.buffer, data.byteOffset, data.length - 4);
      }

      //
      // Ensure that the callback will not be called again in
      // `PerMessageDeflate#cleanup()`.
      //
      this._deflate[kCallback] = null;

      this._deflate[kTotalLength] = 0;
      this._deflate[kBuffers] = [];

      if (fin && this.params[`${endpoint}_no_context_takeover`]) {
        this._deflate.reset();
      }

      callback(null, data);
    });
  }
};

var permessageDeflate = PerMessageDeflate$4;

/**
 * The listener of the `zlib.DeflateRaw` stream `'data'` event.
 *
 * @param {Buffer} chunk A chunk of data
 * @private
 */
function deflateOnData(chunk) {
  this[kBuffers].push(chunk);
  this[kTotalLength] += chunk.length;
}

/**
 * The listener of the `zlib.InflateRaw` stream `'data'` event.
 *
 * @param {Buffer} chunk A chunk of data
 * @private
 */
function inflateOnData(chunk) {
  this[kTotalLength] += chunk.length;

  if (
    this[kPerMessageDeflate]._maxPayload < 1 ||
    this[kTotalLength] <= this[kPerMessageDeflate]._maxPayload
  ) {
    this[kBuffers].push(chunk);
    return;
  }

  this[kError$1] = new RangeError('Max payload size exceeded');
  this[kError$1].code = 'WS_ERR_UNSUPPORTED_MESSAGE_LENGTH';
  this[kError$1][kStatusCode$2] = 1009;
  this.removeListener('data', inflateOnData);
  this.reset();
}

/**
 * The listener of the `zlib.InflateRaw` stream `'error'` event.
 *
 * @param {Error} err The emitted error
 * @private
 */
function inflateOnError(err) {
  //
  // There is no need to call `Zlib#close()` as the handle is automatically
  // closed when an error is emitted.
  //
  this[kPerMessageDeflate]._inflate = null;
  err[kStatusCode$2] = 1007;
  this[kCallback](err);
}

var validation = {exports: {}};

var isValidUTF8_1;

const { isUtf8 } = require$$0$6;

const { hasBlob } = constants;

//
// Allowed token characters:
//
// '!', '#', '$', '%', '&', ''', '*', '+', '-',
// '.', 0-9, A-Z, '^', '_', '`', a-z, '|', '~'
//
// tokenChars[32] === 0 // ' '
// tokenChars[33] === 1 // '!'
// tokenChars[34] === 0 // '"'
// ...
//
// prettier-ignore
const tokenChars$2 = [
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // 0 - 15
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // 16 - 31
  0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, // 32 - 47
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, // 48 - 63
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // 64 - 79
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, // 80 - 95
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // 96 - 111
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0 // 112 - 127
];

/**
 * Checks if a status code is allowed in a close frame.
 *
 * @param {Number} code The status code
 * @return {Boolean} `true` if the status code is valid, else `false`
 * @public
 */
function isValidStatusCode$2(code) {
  return (
    (code >= 1000 &&
      code <= 1014 &&
      code !== 1004 &&
      code !== 1005 &&
      code !== 1006) ||
    (code >= 3000 && code <= 4999)
  );
}

/**
 * Checks if a given buffer contains only correct UTF-8.
 * Ported from https://www.cl.cam.ac.uk/%7Emgk25/ucs/utf8_check.c by
 * Markus Kuhn.
 *
 * @param {Buffer} buf The buffer to check
 * @return {Boolean} `true` if `buf` contains only correct UTF-8, else `false`
 * @public
 */
function _isValidUTF8(buf) {
  const len = buf.length;
  let i = 0;

  while (i < len) {
    if ((buf[i] & 0x80) === 0) {
      // 0xxxxxxx
      i++;
    } else if ((buf[i] & 0xe0) === 0xc0) {
      // 110xxxxx 10xxxxxx
      if (
        i + 1 === len ||
        (buf[i + 1] & 0xc0) !== 0x80 ||
        (buf[i] & 0xfe) === 0xc0 // Overlong
      ) {
        return false;
      }

      i += 2;
    } else if ((buf[i] & 0xf0) === 0xe0) {
      // 1110xxxx 10xxxxxx 10xxxxxx
      if (
        i + 2 >= len ||
        (buf[i + 1] & 0xc0) !== 0x80 ||
        (buf[i + 2] & 0xc0) !== 0x80 ||
        (buf[i] === 0xe0 && (buf[i + 1] & 0xe0) === 0x80) || // Overlong
        (buf[i] === 0xed && (buf[i + 1] & 0xe0) === 0xa0) // Surrogate (U+D800 - U+DFFF)
      ) {
        return false;
      }

      i += 3;
    } else if ((buf[i] & 0xf8) === 0xf0) {
      // 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx
      if (
        i + 3 >= len ||
        (buf[i + 1] & 0xc0) !== 0x80 ||
        (buf[i + 2] & 0xc0) !== 0x80 ||
        (buf[i + 3] & 0xc0) !== 0x80 ||
        (buf[i] === 0xf0 && (buf[i + 1] & 0xf0) === 0x80) || // Overlong
        (buf[i] === 0xf4 && buf[i + 1] > 0x8f) ||
        buf[i] > 0xf4 // > U+10FFFF
      ) {
        return false;
      }

      i += 4;
    } else {
      return false;
    }
  }

  return true;
}

/**
 * Determines whether a value is a `Blob`.
 *
 * @param {*} value The value to be tested
 * @return {Boolean} `true` if `value` is a `Blob`, else `false`
 * @private
 */
function isBlob$2(value) {
  return (
    hasBlob &&
    typeof value === 'object' &&
    typeof value.arrayBuffer === 'function' &&
    typeof value.type === 'string' &&
    typeof value.stream === 'function' &&
    (value[Symbol.toStringTag] === 'Blob' ||
      value[Symbol.toStringTag] === 'File')
  );
}

validation.exports = {
  isBlob: isBlob$2,
  isValidStatusCode: isValidStatusCode$2,
  isValidUTF8: _isValidUTF8,
  tokenChars: tokenChars$2
};

if (isUtf8) {
  isValidUTF8_1 = validation.exports.isValidUTF8 = function (buf) {
    return buf.length < 24 ? _isValidUTF8(buf) : isUtf8(buf);
  };
} /* istanbul ignore else  */ else if (!process.env.WS_NO_UTF_8_VALIDATE) {
  try {
    const isValidUTF8 = require('utf-8-validate');

    isValidUTF8_1 = validation.exports.isValidUTF8 = function (buf) {
      return buf.length < 32 ? _isValidUTF8(buf) : isValidUTF8(buf);
    };
  } catch (e) {
    // Continue regardless of the error.
  }
}

var validationExports = validation.exports;

const { Writable } = require$$0$2;

const PerMessageDeflate$3 = permessageDeflate;
const {
  BINARY_TYPES: BINARY_TYPES$1,
  EMPTY_BUFFER: EMPTY_BUFFER$2,
  kStatusCode: kStatusCode$1,
  kWebSocket: kWebSocket$3
} = constants;
const { concat, toArrayBuffer, unmask } = bufferUtilExports;
const { isValidStatusCode: isValidStatusCode$1, isValidUTF8 } = validationExports;

const FastBuffer = Buffer[Symbol.species];

const GET_INFO = 0;
const GET_PAYLOAD_LENGTH_16 = 1;
const GET_PAYLOAD_LENGTH_64 = 2;
const GET_MASK = 3;
const GET_DATA = 4;
const INFLATING = 5;
const DEFER_EVENT = 6;

/**
 * HyBi Receiver implementation.
 *
 * @extends Writable
 */
let Receiver$1 = class Receiver extends Writable {
  /**
   * Creates a Receiver instance.
   *
   * @param {Object} [options] Options object
   * @param {Boolean} [options.allowSynchronousEvents=true] Specifies whether
   *     any of the `'message'`, `'ping'`, and `'pong'` events can be emitted
   *     multiple times in the same tick
   * @param {String} [options.binaryType=nodebuffer] The type for binary data
   * @param {Object} [options.extensions] An object containing the negotiated
   *     extensions
   * @param {Boolean} [options.isServer=false] Specifies whether to operate in
   *     client or server mode
   * @param {Number} [options.maxPayload=0] The maximum allowed message length
   * @param {Boolean} [options.skipUTF8Validation=false] Specifies whether or
   *     not to skip UTF-8 validation for text and close messages
   */
  constructor(options = {}) {
    super();

    this._allowSynchronousEvents =
      options.allowSynchronousEvents !== undefined
        ? options.allowSynchronousEvents
        : true;
    this._binaryType = options.binaryType || BINARY_TYPES$1[0];
    this._extensions = options.extensions || {};
    this._isServer = !!options.isServer;
    this._maxPayload = options.maxPayload | 0;
    this._skipUTF8Validation = !!options.skipUTF8Validation;
    this[kWebSocket$3] = undefined;

    this._bufferedBytes = 0;
    this._buffers = [];

    this._compressed = false;
    this._payloadLength = 0;
    this._mask = undefined;
    this._fragmented = 0;
    this._masked = false;
    this._fin = false;
    this._opcode = 0;

    this._totalPayloadLength = 0;
    this._messageLength = 0;
    this._fragments = [];

    this._errored = false;
    this._loop = false;
    this._state = GET_INFO;
  }

  /**
   * Implements `Writable.prototype._write()`.
   *
   * @param {Buffer} chunk The chunk of data to write
   * @param {String} encoding The character encoding of `chunk`
   * @param {Function} cb Callback
   * @private
   */
  _write(chunk, encoding, cb) {
    if (this._opcode === 0x08 && this._state == GET_INFO) return cb();

    this._bufferedBytes += chunk.length;
    this._buffers.push(chunk);
    this.startLoop(cb);
  }

  /**
   * Consumes `n` bytes from the buffered data.
   *
   * @param {Number} n The number of bytes to consume
   * @return {Buffer} The consumed bytes
   * @private
   */
  consume(n) {
    this._bufferedBytes -= n;

    if (n === this._buffers[0].length) return this._buffers.shift();

    if (n < this._buffers[0].length) {
      const buf = this._buffers[0];
      this._buffers[0] = new FastBuffer(
        buf.buffer,
        buf.byteOffset + n,
        buf.length - n
      );

      return new FastBuffer(buf.buffer, buf.byteOffset, n);
    }

    const dst = Buffer.allocUnsafe(n);

    do {
      const buf = this._buffers[0];
      const offset = dst.length - n;

      if (n >= buf.length) {
        dst.set(this._buffers.shift(), offset);
      } else {
        dst.set(new Uint8Array(buf.buffer, buf.byteOffset, n), offset);
        this._buffers[0] = new FastBuffer(
          buf.buffer,
          buf.byteOffset + n,
          buf.length - n
        );
      }

      n -= buf.length;
    } while (n > 0);

    return dst;
  }

  /**
   * Starts the parsing loop.
   *
   * @param {Function} cb Callback
   * @private
   */
  startLoop(cb) {
    this._loop = true;

    do {
      switch (this._state) {
        case GET_INFO:
          this.getInfo(cb);
          break;
        case GET_PAYLOAD_LENGTH_16:
          this.getPayloadLength16(cb);
          break;
        case GET_PAYLOAD_LENGTH_64:
          this.getPayloadLength64(cb);
          break;
        case GET_MASK:
          this.getMask();
          break;
        case GET_DATA:
          this.getData(cb);
          break;
        case INFLATING:
        case DEFER_EVENT:
          this._loop = false;
          return;
      }
    } while (this._loop);

    if (!this._errored) cb();
  }

  /**
   * Reads the first two bytes of a frame.
   *
   * @param {Function} cb Callback
   * @private
   */
  getInfo(cb) {
    if (this._bufferedBytes < 2) {
      this._loop = false;
      return;
    }

    const buf = this.consume(2);

    if ((buf[0] & 0x30) !== 0x00) {
      const error = this.createError(
        RangeError,
        'RSV2 and RSV3 must be clear',
        true,
        1002,
        'WS_ERR_UNEXPECTED_RSV_2_3'
      );

      cb(error);
      return;
    }

    const compressed = (buf[0] & 0x40) === 0x40;

    if (compressed && !this._extensions[PerMessageDeflate$3.extensionName]) {
      const error = this.createError(
        RangeError,
        'RSV1 must be clear',
        true,
        1002,
        'WS_ERR_UNEXPECTED_RSV_1'
      );

      cb(error);
      return;
    }

    this._fin = (buf[0] & 0x80) === 0x80;
    this._opcode = buf[0] & 0x0f;
    this._payloadLength = buf[1] & 0x7f;

    if (this._opcode === 0x00) {
      if (compressed) {
        const error = this.createError(
          RangeError,
          'RSV1 must be clear',
          true,
          1002,
          'WS_ERR_UNEXPECTED_RSV_1'
        );

        cb(error);
        return;
      }

      if (!this._fragmented) {
        const error = this.createError(
          RangeError,
          'invalid opcode 0',
          true,
          1002,
          'WS_ERR_INVALID_OPCODE'
        );

        cb(error);
        return;
      }

      this._opcode = this._fragmented;
    } else if (this._opcode === 0x01 || this._opcode === 0x02) {
      if (this._fragmented) {
        const error = this.createError(
          RangeError,
          `invalid opcode ${this._opcode}`,
          true,
          1002,
          'WS_ERR_INVALID_OPCODE'
        );

        cb(error);
        return;
      }

      this._compressed = compressed;
    } else if (this._opcode > 0x07 && this._opcode < 0x0b) {
      if (!this._fin) {
        const error = this.createError(
          RangeError,
          'FIN must be set',
          true,
          1002,
          'WS_ERR_EXPECTED_FIN'
        );

        cb(error);
        return;
      }

      if (compressed) {
        const error = this.createError(
          RangeError,
          'RSV1 must be clear',
          true,
          1002,
          'WS_ERR_UNEXPECTED_RSV_1'
        );

        cb(error);
        return;
      }

      if (
        this._payloadLength > 0x7d ||
        (this._opcode === 0x08 && this._payloadLength === 1)
      ) {
        const error = this.createError(
          RangeError,
          `invalid payload length ${this._payloadLength}`,
          true,
          1002,
          'WS_ERR_INVALID_CONTROL_PAYLOAD_LENGTH'
        );

        cb(error);
        return;
      }
    } else {
      const error = this.createError(
        RangeError,
        `invalid opcode ${this._opcode}`,
        true,
        1002,
        'WS_ERR_INVALID_OPCODE'
      );

      cb(error);
      return;
    }

    if (!this._fin && !this._fragmented) this._fragmented = this._opcode;
    this._masked = (buf[1] & 0x80) === 0x80;

    if (this._isServer) {
      if (!this._masked) {
        const error = this.createError(
          RangeError,
          'MASK must be set',
          true,
          1002,
          'WS_ERR_EXPECTED_MASK'
        );

        cb(error);
        return;
      }
    } else if (this._masked) {
      const error = this.createError(
        RangeError,
        'MASK must be clear',
        true,
        1002,
        'WS_ERR_UNEXPECTED_MASK'
      );

      cb(error);
      return;
    }

    if (this._payloadLength === 126) this._state = GET_PAYLOAD_LENGTH_16;
    else if (this._payloadLength === 127) this._state = GET_PAYLOAD_LENGTH_64;
    else this.haveLength(cb);
  }

  /**
   * Gets extended payload length (7+16).
   *
   * @param {Function} cb Callback
   * @private
   */
  getPayloadLength16(cb) {
    if (this._bufferedBytes < 2) {
      this._loop = false;
      return;
    }

    this._payloadLength = this.consume(2).readUInt16BE(0);
    this.haveLength(cb);
  }

  /**
   * Gets extended payload length (7+64).
   *
   * @param {Function} cb Callback
   * @private
   */
  getPayloadLength64(cb) {
    if (this._bufferedBytes < 8) {
      this._loop = false;
      return;
    }

    const buf = this.consume(8);
    const num = buf.readUInt32BE(0);

    //
    // The maximum safe integer in JavaScript is 2^53 - 1. An error is returned
    // if payload length is greater than this number.
    //
    if (num > Math.pow(2, 53 - 32) - 1) {
      const error = this.createError(
        RangeError,
        'Unsupported WebSocket frame: payload length > 2^53 - 1',
        false,
        1009,
        'WS_ERR_UNSUPPORTED_DATA_PAYLOAD_LENGTH'
      );

      cb(error);
      return;
    }

    this._payloadLength = num * Math.pow(2, 32) + buf.readUInt32BE(4);
    this.haveLength(cb);
  }

  /**
   * Payload length has been read.
   *
   * @param {Function} cb Callback
   * @private
   */
  haveLength(cb) {
    if (this._payloadLength && this._opcode < 0x08) {
      this._totalPayloadLength += this._payloadLength;
      if (this._totalPayloadLength > this._maxPayload && this._maxPayload > 0) {
        const error = this.createError(
          RangeError,
          'Max payload size exceeded',
          false,
          1009,
          'WS_ERR_UNSUPPORTED_MESSAGE_LENGTH'
        );

        cb(error);
        return;
      }
    }

    if (this._masked) this._state = GET_MASK;
    else this._state = GET_DATA;
  }

  /**
   * Reads mask bytes.
   *
   * @private
   */
  getMask() {
    if (this._bufferedBytes < 4) {
      this._loop = false;
      return;
    }

    this._mask = this.consume(4);
    this._state = GET_DATA;
  }

  /**
   * Reads data bytes.
   *
   * @param {Function} cb Callback
   * @private
   */
  getData(cb) {
    let data = EMPTY_BUFFER$2;

    if (this._payloadLength) {
      if (this._bufferedBytes < this._payloadLength) {
        this._loop = false;
        return;
      }

      data = this.consume(this._payloadLength);

      if (
        this._masked &&
        (this._mask[0] | this._mask[1] | this._mask[2] | this._mask[3]) !== 0
      ) {
        unmask(data, this._mask);
      }
    }

    if (this._opcode > 0x07) {
      this.controlMessage(data, cb);
      return;
    }

    if (this._compressed) {
      this._state = INFLATING;
      this.decompress(data, cb);
      return;
    }

    if (data.length) {
      //
      // This message is not compressed so its length is the sum of the payload
      // length of all fragments.
      //
      this._messageLength = this._totalPayloadLength;
      this._fragments.push(data);
    }

    this.dataMessage(cb);
  }

  /**
   * Decompresses data.
   *
   * @param {Buffer} data Compressed data
   * @param {Function} cb Callback
   * @private
   */
  decompress(data, cb) {
    const perMessageDeflate = this._extensions[PerMessageDeflate$3.extensionName];

    perMessageDeflate.decompress(data, this._fin, (err, buf) => {
      if (err) return cb(err);

      if (buf.length) {
        this._messageLength += buf.length;
        if (this._messageLength > this._maxPayload && this._maxPayload > 0) {
          const error = this.createError(
            RangeError,
            'Max payload size exceeded',
            false,
            1009,
            'WS_ERR_UNSUPPORTED_MESSAGE_LENGTH'
          );

          cb(error);
          return;
        }

        this._fragments.push(buf);
      }

      this.dataMessage(cb);
      if (this._state === GET_INFO) this.startLoop(cb);
    });
  }

  /**
   * Handles a data message.
   *
   * @param {Function} cb Callback
   * @private
   */
  dataMessage(cb) {
    if (!this._fin) {
      this._state = GET_INFO;
      return;
    }

    const messageLength = this._messageLength;
    const fragments = this._fragments;

    this._totalPayloadLength = 0;
    this._messageLength = 0;
    this._fragmented = 0;
    this._fragments = [];

    if (this._opcode === 2) {
      let data;

      if (this._binaryType === 'nodebuffer') {
        data = concat(fragments, messageLength);
      } else if (this._binaryType === 'arraybuffer') {
        data = toArrayBuffer(concat(fragments, messageLength));
      } else if (this._binaryType === 'blob') {
        data = new Blob(fragments);
      } else {
        data = fragments;
      }

      if (this._allowSynchronousEvents) {
        this.emit('message', data, true);
        this._state = GET_INFO;
      } else {
        this._state = DEFER_EVENT;
        setImmediate(() => {
          this.emit('message', data, true);
          this._state = GET_INFO;
          this.startLoop(cb);
        });
      }
    } else {
      const buf = concat(fragments, messageLength);

      if (!this._skipUTF8Validation && !isValidUTF8(buf)) {
        const error = this.createError(
          Error,
          'invalid UTF-8 sequence',
          true,
          1007,
          'WS_ERR_INVALID_UTF8'
        );

        cb(error);
        return;
      }

      if (this._state === INFLATING || this._allowSynchronousEvents) {
        this.emit('message', buf, false);
        this._state = GET_INFO;
      } else {
        this._state = DEFER_EVENT;
        setImmediate(() => {
          this.emit('message', buf, false);
          this._state = GET_INFO;
          this.startLoop(cb);
        });
      }
    }
  }

  /**
   * Handles a control message.
   *
   * @param {Buffer} data Data to handle
   * @return {(Error|RangeError|undefined)} A possible error
   * @private
   */
  controlMessage(data, cb) {
    if (this._opcode === 0x08) {
      if (data.length === 0) {
        this._loop = false;
        this.emit('conclude', 1005, EMPTY_BUFFER$2);
        this.end();
      } else {
        const code = data.readUInt16BE(0);

        if (!isValidStatusCode$1(code)) {
          const error = this.createError(
            RangeError,
            `invalid status code ${code}`,
            true,
            1002,
            'WS_ERR_INVALID_CLOSE_CODE'
          );

          cb(error);
          return;
        }

        const buf = new FastBuffer(
          data.buffer,
          data.byteOffset + 2,
          data.length - 2
        );

        if (!this._skipUTF8Validation && !isValidUTF8(buf)) {
          const error = this.createError(
            Error,
            'invalid UTF-8 sequence',
            true,
            1007,
            'WS_ERR_INVALID_UTF8'
          );

          cb(error);
          return;
        }

        this._loop = false;
        this.emit('conclude', code, buf);
        this.end();
      }

      this._state = GET_INFO;
      return;
    }

    if (this._allowSynchronousEvents) {
      this.emit(this._opcode === 0x09 ? 'ping' : 'pong', data);
      this._state = GET_INFO;
    } else {
      this._state = DEFER_EVENT;
      setImmediate(() => {
        this.emit(this._opcode === 0x09 ? 'ping' : 'pong', data);
        this._state = GET_INFO;
        this.startLoop(cb);
      });
    }
  }

  /**
   * Builds an error object.
   *
   * @param {function(new:Error|RangeError)} ErrorCtor The error constructor
   * @param {String} message The error message
   * @param {Boolean} prefix Specifies whether or not to add a default prefix to
   *     `message`
   * @param {Number} statusCode The status code
   * @param {String} errorCode The exposed error code
   * @return {(Error|RangeError)} The error
   * @private
   */
  createError(ErrorCtor, message, prefix, statusCode, errorCode) {
    this._loop = false;
    this._errored = true;

    const err = new ErrorCtor(
      prefix ? `Invalid WebSocket frame: ${message}` : message
    );

    Error.captureStackTrace(err, this.createError);
    err.code = errorCode;
    err[kStatusCode$1] = statusCode;
    return err;
  }
};

var receiver = Receiver$1;

/* eslint no-unused-vars: ["error", { "varsIgnorePattern": "^Duplex" }] */
const { randomFillSync } = require$$1;

const PerMessageDeflate$2 = permessageDeflate;
const { EMPTY_BUFFER: EMPTY_BUFFER$1, kWebSocket: kWebSocket$2, NOOP: NOOP$1 } = constants;
const { isBlob: isBlob$1, isValidStatusCode } = validationExports;
const { mask: applyMask, toBuffer: toBuffer$1 } = bufferUtilExports;

const kByteLength = Symbol('kByteLength');
const maskBuffer = Buffer.alloc(4);
const RANDOM_POOL_SIZE = 8 * 1024;
let randomPool;
let randomPoolPointer = RANDOM_POOL_SIZE;

const DEFAULT = 0;
const DEFLATING = 1;
const GET_BLOB_DATA = 2;

/**
 * HyBi Sender implementation.
 */
let Sender$1 = class Sender {
  /**
   * Creates a Sender instance.
   *
   * @param {Duplex} socket The connection socket
   * @param {Object} [extensions] An object containing the negotiated extensions
   * @param {Function} [generateMask] The function used to generate the masking
   *     key
   */
  constructor(socket, extensions, generateMask) {
    this._extensions = extensions || {};

    if (generateMask) {
      this._generateMask = generateMask;
      this._maskBuffer = Buffer.alloc(4);
    }

    this._socket = socket;

    this._firstFragment = true;
    this._compress = false;

    this._bufferedBytes = 0;
    this._queue = [];
    this._state = DEFAULT;
    this.onerror = NOOP$1;
    this[kWebSocket$2] = undefined;
  }

  /**
   * Frames a piece of data according to the HyBi WebSocket protocol.
   *
   * @param {(Buffer|String)} data The data to frame
   * @param {Object} options Options object
   * @param {Boolean} [options.fin=false] Specifies whether or not to set the
   *     FIN bit
   * @param {Function} [options.generateMask] The function used to generate the
   *     masking key
   * @param {Boolean} [options.mask=false] Specifies whether or not to mask
   *     `data`
   * @param {Buffer} [options.maskBuffer] The buffer used to store the masking
   *     key
   * @param {Number} options.opcode The opcode
   * @param {Boolean} [options.readOnly=false] Specifies whether `data` can be
   *     modified
   * @param {Boolean} [options.rsv1=false] Specifies whether or not to set the
   *     RSV1 bit
   * @return {(Buffer|String)[]} The framed data
   * @public
   */
  static frame(data, options) {
    let mask;
    let merge = false;
    let offset = 2;
    let skipMasking = false;

    if (options.mask) {
      mask = options.maskBuffer || maskBuffer;

      if (options.generateMask) {
        options.generateMask(mask);
      } else {
        if (randomPoolPointer === RANDOM_POOL_SIZE) {
          /* istanbul ignore else  */
          if (randomPool === undefined) {
            //
            // This is lazily initialized because server-sent frames must not
            // be masked so it may never be used.
            //
            randomPool = Buffer.alloc(RANDOM_POOL_SIZE);
          }

          randomFillSync(randomPool, 0, RANDOM_POOL_SIZE);
          randomPoolPointer = 0;
        }

        mask[0] = randomPool[randomPoolPointer++];
        mask[1] = randomPool[randomPoolPointer++];
        mask[2] = randomPool[randomPoolPointer++];
        mask[3] = randomPool[randomPoolPointer++];
      }

      skipMasking = (mask[0] | mask[1] | mask[2] | mask[3]) === 0;
      offset = 6;
    }

    let dataLength;

    if (typeof data === 'string') {
      if (
        (!options.mask || skipMasking) &&
        options[kByteLength] !== undefined
      ) {
        dataLength = options[kByteLength];
      } else {
        data = Buffer.from(data);
        dataLength = data.length;
      }
    } else {
      dataLength = data.length;
      merge = options.mask && options.readOnly && !skipMasking;
    }

    let payloadLength = dataLength;

    if (dataLength >= 65536) {
      offset += 8;
      payloadLength = 127;
    } else if (dataLength > 125) {
      offset += 2;
      payloadLength = 126;
    }

    const target = Buffer.allocUnsafe(merge ? dataLength + offset : offset);

    target[0] = options.fin ? options.opcode | 0x80 : options.opcode;
    if (options.rsv1) target[0] |= 0x40;

    target[1] = payloadLength;

    if (payloadLength === 126) {
      target.writeUInt16BE(dataLength, 2);
    } else if (payloadLength === 127) {
      target[2] = target[3] = 0;
      target.writeUIntBE(dataLength, 4, 6);
    }

    if (!options.mask) return [target, data];

    target[1] |= 0x80;
    target[offset - 4] = mask[0];
    target[offset - 3] = mask[1];
    target[offset - 2] = mask[2];
    target[offset - 1] = mask[3];

    if (skipMasking) return [target, data];

    if (merge) {
      applyMask(data, mask, target, offset, dataLength);
      return [target];
    }

    applyMask(data, mask, data, 0, dataLength);
    return [target, data];
  }

  /**
   * Sends a close message to the other peer.
   *
   * @param {Number} [code] The status code component of the body
   * @param {(String|Buffer)} [data] The message component of the body
   * @param {Boolean} [mask=false] Specifies whether or not to mask the message
   * @param {Function} [cb] Callback
   * @public
   */
  close(code, data, mask, cb) {
    let buf;

    if (code === undefined) {
      buf = EMPTY_BUFFER$1;
    } else if (typeof code !== 'number' || !isValidStatusCode(code)) {
      throw new TypeError('First argument must be a valid error code number');
    } else if (data === undefined || !data.length) {
      buf = Buffer.allocUnsafe(2);
      buf.writeUInt16BE(code, 0);
    } else {
      const length = Buffer.byteLength(data);

      if (length > 123) {
        throw new RangeError('The message must not be greater than 123 bytes');
      }

      buf = Buffer.allocUnsafe(2 + length);
      buf.writeUInt16BE(code, 0);

      if (typeof data === 'string') {
        buf.write(data, 2);
      } else {
        buf.set(data, 2);
      }
    }

    const options = {
      [kByteLength]: buf.length,
      fin: true,
      generateMask: this._generateMask,
      mask,
      maskBuffer: this._maskBuffer,
      opcode: 0x08,
      readOnly: false,
      rsv1: false
    };

    if (this._state !== DEFAULT) {
      this.enqueue([this.dispatch, buf, false, options, cb]);
    } else {
      this.sendFrame(Sender.frame(buf, options), cb);
    }
  }

  /**
   * Sends a ping message to the other peer.
   *
   * @param {*} data The message to send
   * @param {Boolean} [mask=false] Specifies whether or not to mask `data`
   * @param {Function} [cb] Callback
   * @public
   */
  ping(data, mask, cb) {
    let byteLength;
    let readOnly;

    if (typeof data === 'string') {
      byteLength = Buffer.byteLength(data);
      readOnly = false;
    } else if (isBlob$1(data)) {
      byteLength = data.size;
      readOnly = false;
    } else {
      data = toBuffer$1(data);
      byteLength = data.length;
      readOnly = toBuffer$1.readOnly;
    }

    if (byteLength > 125) {
      throw new RangeError('The data size must not be greater than 125 bytes');
    }

    const options = {
      [kByteLength]: byteLength,
      fin: true,
      generateMask: this._generateMask,
      mask,
      maskBuffer: this._maskBuffer,
      opcode: 0x09,
      readOnly,
      rsv1: false
    };

    if (isBlob$1(data)) {
      if (this._state !== DEFAULT) {
        this.enqueue([this.getBlobData, data, false, options, cb]);
      } else {
        this.getBlobData(data, false, options, cb);
      }
    } else if (this._state !== DEFAULT) {
      this.enqueue([this.dispatch, data, false, options, cb]);
    } else {
      this.sendFrame(Sender.frame(data, options), cb);
    }
  }

  /**
   * Sends a pong message to the other peer.
   *
   * @param {*} data The message to send
   * @param {Boolean} [mask=false] Specifies whether or not to mask `data`
   * @param {Function} [cb] Callback
   * @public
   */
  pong(data, mask, cb) {
    let byteLength;
    let readOnly;

    if (typeof data === 'string') {
      byteLength = Buffer.byteLength(data);
      readOnly = false;
    } else if (isBlob$1(data)) {
      byteLength = data.size;
      readOnly = false;
    } else {
      data = toBuffer$1(data);
      byteLength = data.length;
      readOnly = toBuffer$1.readOnly;
    }

    if (byteLength > 125) {
      throw new RangeError('The data size must not be greater than 125 bytes');
    }

    const options = {
      [kByteLength]: byteLength,
      fin: true,
      generateMask: this._generateMask,
      mask,
      maskBuffer: this._maskBuffer,
      opcode: 0x0a,
      readOnly,
      rsv1: false
    };

    if (isBlob$1(data)) {
      if (this._state !== DEFAULT) {
        this.enqueue([this.getBlobData, data, false, options, cb]);
      } else {
        this.getBlobData(data, false, options, cb);
      }
    } else if (this._state !== DEFAULT) {
      this.enqueue([this.dispatch, data, false, options, cb]);
    } else {
      this.sendFrame(Sender.frame(data, options), cb);
    }
  }

  /**
   * Sends a data message to the other peer.
   *
   * @param {*} data The message to send
   * @param {Object} options Options object
   * @param {Boolean} [options.binary=false] Specifies whether `data` is binary
   *     or text
   * @param {Boolean} [options.compress=false] Specifies whether or not to
   *     compress `data`
   * @param {Boolean} [options.fin=false] Specifies whether the fragment is the
   *     last one
   * @param {Boolean} [options.mask=false] Specifies whether or not to mask
   *     `data`
   * @param {Function} [cb] Callback
   * @public
   */
  send(data, options, cb) {
    const perMessageDeflate = this._extensions[PerMessageDeflate$2.extensionName];
    let opcode = options.binary ? 2 : 1;
    let rsv1 = options.compress;

    let byteLength;
    let readOnly;

    if (typeof data === 'string') {
      byteLength = Buffer.byteLength(data);
      readOnly = false;
    } else if (isBlob$1(data)) {
      byteLength = data.size;
      readOnly = false;
    } else {
      data = toBuffer$1(data);
      byteLength = data.length;
      readOnly = toBuffer$1.readOnly;
    }

    if (this._firstFragment) {
      this._firstFragment = false;
      if (
        rsv1 &&
        perMessageDeflate &&
        perMessageDeflate.params[
          perMessageDeflate._isServer
            ? 'server_no_context_takeover'
            : 'client_no_context_takeover'
        ]
      ) {
        rsv1 = byteLength >= perMessageDeflate._threshold;
      }
      this._compress = rsv1;
    } else {
      rsv1 = false;
      opcode = 0;
    }

    if (options.fin) this._firstFragment = true;

    const opts = {
      [kByteLength]: byteLength,
      fin: options.fin,
      generateMask: this._generateMask,
      mask: options.mask,
      maskBuffer: this._maskBuffer,
      opcode,
      readOnly,
      rsv1
    };

    if (isBlob$1(data)) {
      if (this._state !== DEFAULT) {
        this.enqueue([this.getBlobData, data, this._compress, opts, cb]);
      } else {
        this.getBlobData(data, this._compress, opts, cb);
      }
    } else if (this._state !== DEFAULT) {
      this.enqueue([this.dispatch, data, this._compress, opts, cb]);
    } else {
      this.dispatch(data, this._compress, opts, cb);
    }
  }

  /**
   * Gets the contents of a blob as binary data.
   *
   * @param {Blob} blob The blob
   * @param {Boolean} [compress=false] Specifies whether or not to compress
   *     the data
   * @param {Object} options Options object
   * @param {Boolean} [options.fin=false] Specifies whether or not to set the
   *     FIN bit
   * @param {Function} [options.generateMask] The function used to generate the
   *     masking key
   * @param {Boolean} [options.mask=false] Specifies whether or not to mask
   *     `data`
   * @param {Buffer} [options.maskBuffer] The buffer used to store the masking
   *     key
   * @param {Number} options.opcode The opcode
   * @param {Boolean} [options.readOnly=false] Specifies whether `data` can be
   *     modified
   * @param {Boolean} [options.rsv1=false] Specifies whether or not to set the
   *     RSV1 bit
   * @param {Function} [cb] Callback
   * @private
   */
  getBlobData(blob, compress, options, cb) {
    this._bufferedBytes += options[kByteLength];
    this._state = GET_BLOB_DATA;

    blob
      .arrayBuffer()
      .then((arrayBuffer) => {
        if (this._socket.destroyed) {
          const err = new Error(
            'The socket was closed while the blob was being read'
          );

          //
          // `callCallbacks` is called in the next tick to ensure that errors
          // that might be thrown in the callbacks behave like errors thrown
          // outside the promise chain.
          //
          process.nextTick(callCallbacks, this, err, cb);
          return;
        }

        this._bufferedBytes -= options[kByteLength];
        const data = toBuffer$1(arrayBuffer);

        if (!compress) {
          this._state = DEFAULT;
          this.sendFrame(Sender.frame(data, options), cb);
          this.dequeue();
        } else {
          this.dispatch(data, compress, options, cb);
        }
      })
      .catch((err) => {
        //
        // `onError` is called in the next tick for the same reason that
        // `callCallbacks` above is.
        //
        process.nextTick(onError, this, err, cb);
      });
  }

  /**
   * Dispatches a message.
   *
   * @param {(Buffer|String)} data The message to send
   * @param {Boolean} [compress=false] Specifies whether or not to compress
   *     `data`
   * @param {Object} options Options object
   * @param {Boolean} [options.fin=false] Specifies whether or not to set the
   *     FIN bit
   * @param {Function} [options.generateMask] The function used to generate the
   *     masking key
   * @param {Boolean} [options.mask=false] Specifies whether or not to mask
   *     `data`
   * @param {Buffer} [options.maskBuffer] The buffer used to store the masking
   *     key
   * @param {Number} options.opcode The opcode
   * @param {Boolean} [options.readOnly=false] Specifies whether `data` can be
   *     modified
   * @param {Boolean} [options.rsv1=false] Specifies whether or not to set the
   *     RSV1 bit
   * @param {Function} [cb] Callback
   * @private
   */
  dispatch(data, compress, options, cb) {
    if (!compress) {
      this.sendFrame(Sender.frame(data, options), cb);
      return;
    }

    const perMessageDeflate = this._extensions[PerMessageDeflate$2.extensionName];

    this._bufferedBytes += options[kByteLength];
    this._state = DEFLATING;
    perMessageDeflate.compress(data, options.fin, (_, buf) => {
      if (this._socket.destroyed) {
        const err = new Error(
          'The socket was closed while data was being compressed'
        );

        callCallbacks(this, err, cb);
        return;
      }

      this._bufferedBytes -= options[kByteLength];
      this._state = DEFAULT;
      options.readOnly = false;
      this.sendFrame(Sender.frame(buf, options), cb);
      this.dequeue();
    });
  }

  /**
   * Executes queued send operations.
   *
   * @private
   */
  dequeue() {
    while (this._state === DEFAULT && this._queue.length) {
      const params = this._queue.shift();

      this._bufferedBytes -= params[3][kByteLength];
      Reflect.apply(params[0], this, params.slice(1));
    }
  }

  /**
   * Enqueues a send operation.
   *
   * @param {Array} params Send operation parameters.
   * @private
   */
  enqueue(params) {
    this._bufferedBytes += params[3][kByteLength];
    this._queue.push(params);
  }

  /**
   * Sends a frame.
   *
   * @param {Buffer[]} list The frame to send
   * @param {Function} [cb] Callback
   * @private
   */
  sendFrame(list, cb) {
    if (list.length === 2) {
      this._socket.cork();
      this._socket.write(list[0]);
      this._socket.write(list[1], cb);
      this._socket.uncork();
    } else {
      this._socket.write(list[0], cb);
    }
  }
};

var sender = Sender$1;

/**
 * Calls queued callbacks with an error.
 *
 * @param {Sender} sender The `Sender` instance
 * @param {Error} err The error to call the callbacks with
 * @param {Function} [cb] The first callback
 * @private
 */
function callCallbacks(sender, err, cb) {
  if (typeof cb === 'function') cb(err);

  for (let i = 0; i < sender._queue.length; i++) {
    const params = sender._queue[i];
    const callback = params[params.length - 1];

    if (typeof callback === 'function') callback(err);
  }
}

/**
 * Handles a `Sender` error.
 *
 * @param {Sender} sender The `Sender` instance
 * @param {Error} err The error
 * @param {Function} [cb] The first pending callback
 * @private
 */
function onError(sender, err, cb) {
  callCallbacks(sender, err, cb);
  sender.onerror(err);
}

const { kForOnEventAttribute: kForOnEventAttribute$1, kListener: kListener$1 } = constants;

const kCode = Symbol('kCode');
const kData = Symbol('kData');
const kError = Symbol('kError');
const kMessage = Symbol('kMessage');
const kReason = Symbol('kReason');
const kTarget = Symbol('kTarget');
const kType = Symbol('kType');
const kWasClean = Symbol('kWasClean');

/**
 * Class representing an event.
 */
class Event {
  /**
   * Create a new `Event`.
   *
   * @param {String} type The name of the event
   * @throws {TypeError} If the `type` argument is not specified
   */
  constructor(type) {
    this[kTarget] = null;
    this[kType] = type;
  }

  /**
   * @type {*}
   */
  get target() {
    return this[kTarget];
  }

  /**
   * @type {String}
   */
  get type() {
    return this[kType];
  }
}

Object.defineProperty(Event.prototype, 'target', { enumerable: true });
Object.defineProperty(Event.prototype, 'type', { enumerable: true });

/**
 * Class representing a close event.
 *
 * @extends Event
 */
class CloseEvent extends Event {
  /**
   * Create a new `CloseEvent`.
   *
   * @param {String} type The name of the event
   * @param {Object} [options] A dictionary object that allows for setting
   *     attributes via object members of the same name
   * @param {Number} [options.code=0] The status code explaining why the
   *     connection was closed
   * @param {String} [options.reason=''] A human-readable string explaining why
   *     the connection was closed
   * @param {Boolean} [options.wasClean=false] Indicates whether or not the
   *     connection was cleanly closed
   */
  constructor(type, options = {}) {
    super(type);

    this[kCode] = options.code === undefined ? 0 : options.code;
    this[kReason] = options.reason === undefined ? '' : options.reason;
    this[kWasClean] = options.wasClean === undefined ? false : options.wasClean;
  }

  /**
   * @type {Number}
   */
  get code() {
    return this[kCode];
  }

  /**
   * @type {String}
   */
  get reason() {
    return this[kReason];
  }

  /**
   * @type {Boolean}
   */
  get wasClean() {
    return this[kWasClean];
  }
}

Object.defineProperty(CloseEvent.prototype, 'code', { enumerable: true });
Object.defineProperty(CloseEvent.prototype, 'reason', { enumerable: true });
Object.defineProperty(CloseEvent.prototype, 'wasClean', { enumerable: true });

/**
 * Class representing an error event.
 *
 * @extends Event
 */
class ErrorEvent extends Event {
  /**
   * Create a new `ErrorEvent`.
   *
   * @param {String} type The name of the event
   * @param {Object} [options] A dictionary object that allows for setting
   *     attributes via object members of the same name
   * @param {*} [options.error=null] The error that generated this event
   * @param {String} [options.message=''] The error message
   */
  constructor(type, options = {}) {
    super(type);

    this[kError] = options.error === undefined ? null : options.error;
    this[kMessage] = options.message === undefined ? '' : options.message;
  }

  /**
   * @type {*}
   */
  get error() {
    return this[kError];
  }

  /**
   * @type {String}
   */
  get message() {
    return this[kMessage];
  }
}

Object.defineProperty(ErrorEvent.prototype, 'error', { enumerable: true });
Object.defineProperty(ErrorEvent.prototype, 'message', { enumerable: true });

/**
 * Class representing a message event.
 *
 * @extends Event
 */
class MessageEvent extends Event {
  /**
   * Create a new `MessageEvent`.
   *
   * @param {String} type The name of the event
   * @param {Object} [options] A dictionary object that allows for setting
   *     attributes via object members of the same name
   * @param {*} [options.data=null] The message content
   */
  constructor(type, options = {}) {
    super(type);

    this[kData] = options.data === undefined ? null : options.data;
  }

  /**
   * @type {*}
   */
  get data() {
    return this[kData];
  }
}

Object.defineProperty(MessageEvent.prototype, 'data', { enumerable: true });

/**
 * This provides methods for emulating the `EventTarget` interface. It's not
 * meant to be used directly.
 *
 * @mixin
 */
const EventTarget = {
  /**
   * Register an event listener.
   *
   * @param {String} type A string representing the event type to listen for
   * @param {(Function|Object)} handler The listener to add
   * @param {Object} [options] An options object specifies characteristics about
   *     the event listener
   * @param {Boolean} [options.once=false] A `Boolean` indicating that the
   *     listener should be invoked at most once after being added. If `true`,
   *     the listener would be automatically removed when invoked.
   * @public
   */
  addEventListener(type, handler, options = {}) {
    for (const listener of this.listeners(type)) {
      if (
        !options[kForOnEventAttribute$1] &&
        listener[kListener$1] === handler &&
        !listener[kForOnEventAttribute$1]
      ) {
        return;
      }
    }

    let wrapper;

    if (type === 'message') {
      wrapper = function onMessage(data, isBinary) {
        const event = new MessageEvent('message', {
          data: isBinary ? data : data.toString()
        });

        event[kTarget] = this;
        callListener(handler, this, event);
      };
    } else if (type === 'close') {
      wrapper = function onClose(code, message) {
        const event = new CloseEvent('close', {
          code,
          reason: message.toString(),
          wasClean: this._closeFrameReceived && this._closeFrameSent
        });

        event[kTarget] = this;
        callListener(handler, this, event);
      };
    } else if (type === 'error') {
      wrapper = function onError(error) {
        const event = new ErrorEvent('error', {
          error,
          message: error.message
        });

        event[kTarget] = this;
        callListener(handler, this, event);
      };
    } else if (type === 'open') {
      wrapper = function onOpen() {
        const event = new Event('open');

        event[kTarget] = this;
        callListener(handler, this, event);
      };
    } else {
      return;
    }

    wrapper[kForOnEventAttribute$1] = !!options[kForOnEventAttribute$1];
    wrapper[kListener$1] = handler;

    if (options.once) {
      this.once(type, wrapper);
    } else {
      this.on(type, wrapper);
    }
  },

  /**
   * Remove an event listener.
   *
   * @param {String} type A string representing the event type to remove
   * @param {(Function|Object)} handler The listener to remove
   * @public
   */
  removeEventListener(type, handler) {
    for (const listener of this.listeners(type)) {
      if (listener[kListener$1] === handler && !listener[kForOnEventAttribute$1]) {
        this.removeListener(type, listener);
        break;
      }
    }
  }
};

var eventTarget = {
  CloseEvent,
  ErrorEvent,
  Event,
  EventTarget,
  MessageEvent
};

/**
 * Call an event listener
 *
 * @param {(Function|Object)} listener The listener to call
 * @param {*} thisArg The value to use as `this`` when calling the listener
 * @param {Event} event The event to pass to the listener
 * @private
 */
function callListener(listener, thisArg, event) {
  if (typeof listener === 'object' && listener.handleEvent) {
    listener.handleEvent.call(listener, event);
  } else {
    listener.call(thisArg, event);
  }
}

const { tokenChars: tokenChars$1 } = validationExports;

/**
 * Adds an offer to the map of extension offers or a parameter to the map of
 * parameters.
 *
 * @param {Object} dest The map of extension offers or parameters
 * @param {String} name The extension or parameter name
 * @param {(Object|Boolean|String)} elem The extension parameters or the
 *     parameter value
 * @private
 */
function push(dest, name, elem) {
  if (dest[name] === undefined) dest[name] = [elem];
  else dest[name].push(elem);
}

/**
 * Parses the `Sec-WebSocket-Extensions` header into an object.
 *
 * @param {String} header The field value of the header
 * @return {Object} The parsed object
 * @public
 */
function parse$2(header) {
  const offers = Object.create(null);
  let params = Object.create(null);
  let mustUnescape = false;
  let isEscaping = false;
  let inQuotes = false;
  let extensionName;
  let paramName;
  let start = -1;
  let code = -1;
  let end = -1;
  let i = 0;

  for (; i < header.length; i++) {
    code = header.charCodeAt(i);

    if (extensionName === undefined) {
      if (end === -1 && tokenChars$1[code] === 1) {
        if (start === -1) start = i;
      } else if (
        i !== 0 &&
        (code === 0x20 /* ' ' */ || code === 0x09) /* '\t' */
      ) {
        if (end === -1 && start !== -1) end = i;
      } else if (code === 0x3b /* ';' */ || code === 0x2c /* ',' */) {
        if (start === -1) {
          throw new SyntaxError(`Unexpected character at index ${i}`);
        }

        if (end === -1) end = i;
        const name = header.slice(start, end);
        if (code === 0x2c) {
          push(offers, name, params);
          params = Object.create(null);
        } else {
          extensionName = name;
        }

        start = end = -1;
      } else {
        throw new SyntaxError(`Unexpected character at index ${i}`);
      }
    } else if (paramName === undefined) {
      if (end === -1 && tokenChars$1[code] === 1) {
        if (start === -1) start = i;
      } else if (code === 0x20 || code === 0x09) {
        if (end === -1 && start !== -1) end = i;
      } else if (code === 0x3b || code === 0x2c) {
        if (start === -1) {
          throw new SyntaxError(`Unexpected character at index ${i}`);
        }

        if (end === -1) end = i;
        push(params, header.slice(start, end), true);
        if (code === 0x2c) {
          push(offers, extensionName, params);
          params = Object.create(null);
          extensionName = undefined;
        }

        start = end = -1;
      } else if (code === 0x3d /* '=' */ && start !== -1 && end === -1) {
        paramName = header.slice(start, i);
        start = end = -1;
      } else {
        throw new SyntaxError(`Unexpected character at index ${i}`);
      }
    } else {
      //
      // The value of a quoted-string after unescaping must conform to the
      // token ABNF, so only token characters are valid.
      // Ref: https://tools.ietf.org/html/rfc6455#section-9.1
      //
      if (isEscaping) {
        if (tokenChars$1[code] !== 1) {
          throw new SyntaxError(`Unexpected character at index ${i}`);
        }
        if (start === -1) start = i;
        else if (!mustUnescape) mustUnescape = true;
        isEscaping = false;
      } else if (inQuotes) {
        if (tokenChars$1[code] === 1) {
          if (start === -1) start = i;
        } else if (code === 0x22 /* '"' */ && start !== -1) {
          inQuotes = false;
          end = i;
        } else if (code === 0x5c /* '\' */) {
          isEscaping = true;
        } else {
          throw new SyntaxError(`Unexpected character at index ${i}`);
        }
      } else if (code === 0x22 && header.charCodeAt(i - 1) === 0x3d) {
        inQuotes = true;
      } else if (end === -1 && tokenChars$1[code] === 1) {
        if (start === -1) start = i;
      } else if (start !== -1 && (code === 0x20 || code === 0x09)) {
        if (end === -1) end = i;
      } else if (code === 0x3b || code === 0x2c) {
        if (start === -1) {
          throw new SyntaxError(`Unexpected character at index ${i}`);
        }

        if (end === -1) end = i;
        let value = header.slice(start, end);
        if (mustUnescape) {
          value = value.replace(/\\/g, '');
          mustUnescape = false;
        }
        push(params, paramName, value);
        if (code === 0x2c) {
          push(offers, extensionName, params);
          params = Object.create(null);
          extensionName = undefined;
        }

        paramName = undefined;
        start = end = -1;
      } else {
        throw new SyntaxError(`Unexpected character at index ${i}`);
      }
    }
  }

  if (start === -1 || inQuotes || code === 0x20 || code === 0x09) {
    throw new SyntaxError('Unexpected end of input');
  }

  if (end === -1) end = i;
  const token = header.slice(start, end);
  if (extensionName === undefined) {
    push(offers, token, params);
  } else {
    if (paramName === undefined) {
      push(params, token, true);
    } else if (mustUnescape) {
      push(params, paramName, token.replace(/\\/g, ''));
    } else {
      push(params, paramName, token);
    }
    push(offers, extensionName, params);
  }

  return offers;
}

/**
 * Builds the `Sec-WebSocket-Extensions` header field value.
 *
 * @param {Object} extensions The map of extensions and parameters to format
 * @return {String} A string representing the given object
 * @public
 */
function format$1(extensions) {
  return Object.keys(extensions)
    .map((extension) => {
      let configurations = extensions[extension];
      if (!Array.isArray(configurations)) configurations = [configurations];
      return configurations
        .map((params) => {
          return [extension]
            .concat(
              Object.keys(params).map((k) => {
                let values = params[k];
                if (!Array.isArray(values)) values = [values];
                return values
                  .map((v) => (v === true ? k : `${k}=${v}`))
                  .join('; ');
              })
            )
            .join('; ');
        })
        .join(', ');
    })
    .join(', ');
}

var extension$1 = { format: format$1, parse: parse$2 };

/* eslint no-unused-vars: ["error", { "varsIgnorePattern": "^Duplex|Readable$", "caughtErrors": "none" }] */

const EventEmitter$1 = require$$0$4;
const https = require$$1$1;
const http$1 = require$$2;
const net = require$$3;
const tls = require$$4;
const { randomBytes, createHash: createHash$1 } = require$$1;
const { URL: URL$1 } = require$$7;

const PerMessageDeflate$1 = permessageDeflate;
const Receiver = receiver;
const Sender = sender;
const { isBlob } = validationExports;

const {
  BINARY_TYPES,
  EMPTY_BUFFER,
  GUID: GUID$1,
  kForOnEventAttribute,
  kListener,
  kStatusCode,
  kWebSocket: kWebSocket$1,
  NOOP
} = constants;
const {
  EventTarget: { addEventListener, removeEventListener }
} = eventTarget;
const { format, parse: parse$1 } = extension$1;
const { toBuffer } = bufferUtilExports;

const closeTimeout = 30 * 1000;
const kAborted = Symbol('kAborted');
const protocolVersions = [8, 13];
const readyStates = ['CONNECTING', 'OPEN', 'CLOSING', 'CLOSED'];
const subprotocolRegex = /^[!#$%&'*+\-.0-9A-Z^_`|a-z~]+$/;

/**
 * Class representing a WebSocket.
 *
 * @extends EventEmitter
 */
let WebSocket$1 = class WebSocket extends EventEmitter$1 {
  /**
   * Create a new `WebSocket`.
   *
   * @param {(String|URL)} address The URL to which to connect
   * @param {(String|String[])} [protocols] The subprotocols
   * @param {Object} [options] Connection options
   */
  constructor(address, protocols, options) {
    super();

    this._binaryType = BINARY_TYPES[0];
    this._closeCode = 1006;
    this._closeFrameReceived = false;
    this._closeFrameSent = false;
    this._closeMessage = EMPTY_BUFFER;
    this._closeTimer = null;
    this._errorEmitted = false;
    this._extensions = {};
    this._paused = false;
    this._protocol = '';
    this._readyState = WebSocket.CONNECTING;
    this._receiver = null;
    this._sender = null;
    this._socket = null;

    if (address !== null) {
      this._bufferedAmount = 0;
      this._isServer = false;
      this._redirects = 0;

      if (protocols === undefined) {
        protocols = [];
      } else if (!Array.isArray(protocols)) {
        if (typeof protocols === 'object' && protocols !== null) {
          options = protocols;
          protocols = [];
        } else {
          protocols = [protocols];
        }
      }

      initAsClient(this, address, protocols, options);
    } else {
      this._autoPong = options.autoPong;
      this._isServer = true;
    }
  }

  /**
   * For historical reasons, the custom "nodebuffer" type is used by the default
   * instead of "blob".
   *
   * @type {String}
   */
  get binaryType() {
    return this._binaryType;
  }

  set binaryType(type) {
    if (!BINARY_TYPES.includes(type)) return;

    this._binaryType = type;

    //
    // Allow to change `binaryType` on the fly.
    //
    if (this._receiver) this._receiver._binaryType = type;
  }

  /**
   * @type {Number}
   */
  get bufferedAmount() {
    if (!this._socket) return this._bufferedAmount;

    return this._socket._writableState.length + this._sender._bufferedBytes;
  }

  /**
   * @type {String}
   */
  get extensions() {
    return Object.keys(this._extensions).join();
  }

  /**
   * @type {Boolean}
   */
  get isPaused() {
    return this._paused;
  }

  /**
   * @type {Function}
   */
  /* istanbul ignore next */
  get onclose() {
    return null;
  }

  /**
   * @type {Function}
   */
  /* istanbul ignore next */
  get onerror() {
    return null;
  }

  /**
   * @type {Function}
   */
  /* istanbul ignore next */
  get onopen() {
    return null;
  }

  /**
   * @type {Function}
   */
  /* istanbul ignore next */
  get onmessage() {
    return null;
  }

  /**
   * @type {String}
   */
  get protocol() {
    return this._protocol;
  }

  /**
   * @type {Number}
   */
  get readyState() {
    return this._readyState;
  }

  /**
   * @type {String}
   */
  get url() {
    return this._url;
  }

  /**
   * Set up the socket and the internal resources.
   *
   * @param {Duplex} socket The network socket between the server and client
   * @param {Buffer} head The first packet of the upgraded stream
   * @param {Object} options Options object
   * @param {Boolean} [options.allowSynchronousEvents=false] Specifies whether
   *     any of the `'message'`, `'ping'`, and `'pong'` events can be emitted
   *     multiple times in the same tick
   * @param {Function} [options.generateMask] The function used to generate the
   *     masking key
   * @param {Number} [options.maxPayload=0] The maximum allowed message size
   * @param {Boolean} [options.skipUTF8Validation=false] Specifies whether or
   *     not to skip UTF-8 validation for text and close messages
   * @private
   */
  setSocket(socket, head, options) {
    const receiver = new Receiver({
      allowSynchronousEvents: options.allowSynchronousEvents,
      binaryType: this.binaryType,
      extensions: this._extensions,
      isServer: this._isServer,
      maxPayload: options.maxPayload,
      skipUTF8Validation: options.skipUTF8Validation
    });

    const sender = new Sender(socket, this._extensions, options.generateMask);

    this._receiver = receiver;
    this._sender = sender;
    this._socket = socket;

    receiver[kWebSocket$1] = this;
    sender[kWebSocket$1] = this;
    socket[kWebSocket$1] = this;

    receiver.on('conclude', receiverOnConclude);
    receiver.on('drain', receiverOnDrain);
    receiver.on('error', receiverOnError);
    receiver.on('message', receiverOnMessage);
    receiver.on('ping', receiverOnPing);
    receiver.on('pong', receiverOnPong);

    sender.onerror = senderOnError;

    //
    // These methods may not be available if `socket` is just a `Duplex`.
    //
    if (socket.setTimeout) socket.setTimeout(0);
    if (socket.setNoDelay) socket.setNoDelay();

    if (head.length > 0) socket.unshift(head);

    socket.on('close', socketOnClose);
    socket.on('data', socketOnData);
    socket.on('end', socketOnEnd);
    socket.on('error', socketOnError$1);

    this._readyState = WebSocket.OPEN;
    this.emit('open');
  }

  /**
   * Emit the `'close'` event.
   *
   * @private
   */
  emitClose() {
    if (!this._socket) {
      this._readyState = WebSocket.CLOSED;
      this.emit('close', this._closeCode, this._closeMessage);
      return;
    }

    if (this._extensions[PerMessageDeflate$1.extensionName]) {
      this._extensions[PerMessageDeflate$1.extensionName].cleanup();
    }

    this._receiver.removeAllListeners();
    this._readyState = WebSocket.CLOSED;
    this.emit('close', this._closeCode, this._closeMessage);
  }

  /**
   * Start a closing handshake.
   *
   *          +----------+   +-----------+   +----------+
   *     - - -|ws.close()|-->|close frame|-->|ws.close()|- - -
   *    |     +----------+   +-----------+   +----------+     |
   *          +----------+   +-----------+         |
   * CLOSING  |ws.close()|<--|close frame|<--+-----+       CLOSING
   *          +----------+   +-----------+   |
   *    |           |                        |   +---+        |
   *                +------------------------+-->|fin| - - - -
   *    |         +---+                      |   +---+
   *     - - - - -|fin|<---------------------+
   *              +---+
   *
   * @param {Number} [code] Status code explaining why the connection is closing
   * @param {(String|Buffer)} [data] The reason why the connection is
   *     closing
   * @public
   */
  close(code, data) {
    if (this.readyState === WebSocket.CLOSED) return;
    if (this.readyState === WebSocket.CONNECTING) {
      const msg = 'WebSocket was closed before the connection was established';
      abortHandshake$1(this, this._req, msg);
      return;
    }

    if (this.readyState === WebSocket.CLOSING) {
      if (
        this._closeFrameSent &&
        (this._closeFrameReceived || this._receiver._writableState.errorEmitted)
      ) {
        this._socket.end();
      }

      return;
    }

    this._readyState = WebSocket.CLOSING;
    this._sender.close(code, data, !this._isServer, (err) => {
      //
      // This error is handled by the `'error'` listener on the socket. We only
      // want to know if the close frame has been sent here.
      //
      if (err) return;

      this._closeFrameSent = true;

      if (
        this._closeFrameReceived ||
        this._receiver._writableState.errorEmitted
      ) {
        this._socket.end();
      }
    });

    setCloseTimer(this);
  }

  /**
   * Pause the socket.
   *
   * @public
   */
  pause() {
    if (
      this.readyState === WebSocket.CONNECTING ||
      this.readyState === WebSocket.CLOSED
    ) {
      return;
    }

    this._paused = true;
    this._socket.pause();
  }

  /**
   * Send a ping.
   *
   * @param {*} [data] The data to send
   * @param {Boolean} [mask] Indicates whether or not to mask `data`
   * @param {Function} [cb] Callback which is executed when the ping is sent
   * @public
   */
  ping(data, mask, cb) {
    if (this.readyState === WebSocket.CONNECTING) {
      throw new Error('WebSocket is not open: readyState 0 (CONNECTING)');
    }

    if (typeof data === 'function') {
      cb = data;
      data = mask = undefined;
    } else if (typeof mask === 'function') {
      cb = mask;
      mask = undefined;
    }

    if (typeof data === 'number') data = data.toString();

    if (this.readyState !== WebSocket.OPEN) {
      sendAfterClose(this, data, cb);
      return;
    }

    if (mask === undefined) mask = !this._isServer;
    this._sender.ping(data || EMPTY_BUFFER, mask, cb);
  }

  /**
   * Send a pong.
   *
   * @param {*} [data] The data to send
   * @param {Boolean} [mask] Indicates whether or not to mask `data`
   * @param {Function} [cb] Callback which is executed when the pong is sent
   * @public
   */
  pong(data, mask, cb) {
    if (this.readyState === WebSocket.CONNECTING) {
      throw new Error('WebSocket is not open: readyState 0 (CONNECTING)');
    }

    if (typeof data === 'function') {
      cb = data;
      data = mask = undefined;
    } else if (typeof mask === 'function') {
      cb = mask;
      mask = undefined;
    }

    if (typeof data === 'number') data = data.toString();

    if (this.readyState !== WebSocket.OPEN) {
      sendAfterClose(this, data, cb);
      return;
    }

    if (mask === undefined) mask = !this._isServer;
    this._sender.pong(data || EMPTY_BUFFER, mask, cb);
  }

  /**
   * Resume the socket.
   *
   * @public
   */
  resume() {
    if (
      this.readyState === WebSocket.CONNECTING ||
      this.readyState === WebSocket.CLOSED
    ) {
      return;
    }

    this._paused = false;
    if (!this._receiver._writableState.needDrain) this._socket.resume();
  }

  /**
   * Send a data message.
   *
   * @param {*} data The message to send
   * @param {Object} [options] Options object
   * @param {Boolean} [options.binary] Specifies whether `data` is binary or
   *     text
   * @param {Boolean} [options.compress] Specifies whether or not to compress
   *     `data`
   * @param {Boolean} [options.fin=true] Specifies whether the fragment is the
   *     last one
   * @param {Boolean} [options.mask] Specifies whether or not to mask `data`
   * @param {Function} [cb] Callback which is executed when data is written out
   * @public
   */
  send(data, options, cb) {
    if (this.readyState === WebSocket.CONNECTING) {
      throw new Error('WebSocket is not open: readyState 0 (CONNECTING)');
    }

    if (typeof options === 'function') {
      cb = options;
      options = {};
    }

    if (typeof data === 'number') data = data.toString();

    if (this.readyState !== WebSocket.OPEN) {
      sendAfterClose(this, data, cb);
      return;
    }

    const opts = {
      binary: typeof data !== 'string',
      mask: !this._isServer,
      compress: true,
      fin: true,
      ...options
    };

    if (!this._extensions[PerMessageDeflate$1.extensionName]) {
      opts.compress = false;
    }

    this._sender.send(data || EMPTY_BUFFER, opts, cb);
  }

  /**
   * Forcibly close the connection.
   *
   * @public
   */
  terminate() {
    if (this.readyState === WebSocket.CLOSED) return;
    if (this.readyState === WebSocket.CONNECTING) {
      const msg = 'WebSocket was closed before the connection was established';
      abortHandshake$1(this, this._req, msg);
      return;
    }

    if (this._socket) {
      this._readyState = WebSocket.CLOSING;
      this._socket.destroy();
    }
  }
};

/**
 * @constant {Number} CONNECTING
 * @memberof WebSocket
 */
Object.defineProperty(WebSocket$1, 'CONNECTING', {
  enumerable: true,
  value: readyStates.indexOf('CONNECTING')
});

/**
 * @constant {Number} CONNECTING
 * @memberof WebSocket.prototype
 */
Object.defineProperty(WebSocket$1.prototype, 'CONNECTING', {
  enumerable: true,
  value: readyStates.indexOf('CONNECTING')
});

/**
 * @constant {Number} OPEN
 * @memberof WebSocket
 */
Object.defineProperty(WebSocket$1, 'OPEN', {
  enumerable: true,
  value: readyStates.indexOf('OPEN')
});

/**
 * @constant {Number} OPEN
 * @memberof WebSocket.prototype
 */
Object.defineProperty(WebSocket$1.prototype, 'OPEN', {
  enumerable: true,
  value: readyStates.indexOf('OPEN')
});

/**
 * @constant {Number} CLOSING
 * @memberof WebSocket
 */
Object.defineProperty(WebSocket$1, 'CLOSING', {
  enumerable: true,
  value: readyStates.indexOf('CLOSING')
});

/**
 * @constant {Number} CLOSING
 * @memberof WebSocket.prototype
 */
Object.defineProperty(WebSocket$1.prototype, 'CLOSING', {
  enumerable: true,
  value: readyStates.indexOf('CLOSING')
});

/**
 * @constant {Number} CLOSED
 * @memberof WebSocket
 */
Object.defineProperty(WebSocket$1, 'CLOSED', {
  enumerable: true,
  value: readyStates.indexOf('CLOSED')
});

/**
 * @constant {Number} CLOSED
 * @memberof WebSocket.prototype
 */
Object.defineProperty(WebSocket$1.prototype, 'CLOSED', {
  enumerable: true,
  value: readyStates.indexOf('CLOSED')
});

[
  'binaryType',
  'bufferedAmount',
  'extensions',
  'isPaused',
  'protocol',
  'readyState',
  'url'
].forEach((property) => {
  Object.defineProperty(WebSocket$1.prototype, property, { enumerable: true });
});

//
// Add the `onopen`, `onerror`, `onclose`, and `onmessage` attributes.
// See https://html.spec.whatwg.org/multipage/comms.html#the-websocket-interface
//
['open', 'error', 'close', 'message'].forEach((method) => {
  Object.defineProperty(WebSocket$1.prototype, `on${method}`, {
    enumerable: true,
    get() {
      for (const listener of this.listeners(method)) {
        if (listener[kForOnEventAttribute]) return listener[kListener];
      }

      return null;
    },
    set(handler) {
      for (const listener of this.listeners(method)) {
        if (listener[kForOnEventAttribute]) {
          this.removeListener(method, listener);
          break;
        }
      }

      if (typeof handler !== 'function') return;

      this.addEventListener(method, handler, {
        [kForOnEventAttribute]: true
      });
    }
  });
});

WebSocket$1.prototype.addEventListener = addEventListener;
WebSocket$1.prototype.removeEventListener = removeEventListener;

var websocket = WebSocket$1;

/**
 * Initialize a WebSocket client.
 *
 * @param {WebSocket} websocket The client to initialize
 * @param {(String|URL)} address The URL to which to connect
 * @param {Array} protocols The subprotocols
 * @param {Object} [options] Connection options
 * @param {Boolean} [options.allowSynchronousEvents=true] Specifies whether any
 *     of the `'message'`, `'ping'`, and `'pong'` events can be emitted multiple
 *     times in the same tick
 * @param {Boolean} [options.autoPong=true] Specifies whether or not to
 *     automatically send a pong in response to a ping
 * @param {Function} [options.finishRequest] A function which can be used to
 *     customize the headers of each http request before it is sent
 * @param {Boolean} [options.followRedirects=false] Whether or not to follow
 *     redirects
 * @param {Function} [options.generateMask] The function used to generate the
 *     masking key
 * @param {Number} [options.handshakeTimeout] Timeout in milliseconds for the
 *     handshake request
 * @param {Number} [options.maxPayload=104857600] The maximum allowed message
 *     size
 * @param {Number} [options.maxRedirects=10] The maximum number of redirects
 *     allowed
 * @param {String} [options.origin] Value of the `Origin` or
 *     `Sec-WebSocket-Origin` header
 * @param {(Boolean|Object)} [options.perMessageDeflate=true] Enable/disable
 *     permessage-deflate
 * @param {Number} [options.protocolVersion=13] Value of the
 *     `Sec-WebSocket-Version` header
 * @param {Boolean} [options.skipUTF8Validation=false] Specifies whether or
 *     not to skip UTF-8 validation for text and close messages
 * @private
 */
function initAsClient(websocket, address, protocols, options) {
  const opts = {
    allowSynchronousEvents: true,
    autoPong: true,
    protocolVersion: protocolVersions[1],
    maxPayload: 100 * 1024 * 1024,
    skipUTF8Validation: false,
    perMessageDeflate: true,
    followRedirects: false,
    maxRedirects: 10,
    ...options,
    socketPath: undefined,
    hostname: undefined,
    protocol: undefined,
    timeout: undefined,
    method: 'GET',
    host: undefined,
    path: undefined,
    port: undefined
  };

  websocket._autoPong = opts.autoPong;

  if (!protocolVersions.includes(opts.protocolVersion)) {
    throw new RangeError(
      `Unsupported protocol version: ${opts.protocolVersion} ` +
        `(supported versions: ${protocolVersions.join(', ')})`
    );
  }

  let parsedUrl;

  if (address instanceof URL$1) {
    parsedUrl = address;
  } else {
    try {
      parsedUrl = new URL$1(address);
    } catch (e) {
      throw new SyntaxError(`Invalid URL: ${address}`);
    }
  }

  if (parsedUrl.protocol === 'http:') {
    parsedUrl.protocol = 'ws:';
  } else if (parsedUrl.protocol === 'https:') {
    parsedUrl.protocol = 'wss:';
  }

  websocket._url = parsedUrl.href;

  const isSecure = parsedUrl.protocol === 'wss:';
  const isIpcUrl = parsedUrl.protocol === 'ws+unix:';
  let invalidUrlMessage;

  if (parsedUrl.protocol !== 'ws:' && !isSecure && !isIpcUrl) {
    invalidUrlMessage =
      'The URL\'s protocol must be one of "ws:", "wss:", ' +
      '"http:", "https", or "ws+unix:"';
  } else if (isIpcUrl && !parsedUrl.pathname) {
    invalidUrlMessage = "The URL's pathname is empty";
  } else if (parsedUrl.hash) {
    invalidUrlMessage = 'The URL contains a fragment identifier';
  }

  if (invalidUrlMessage) {
    const err = new SyntaxError(invalidUrlMessage);

    if (websocket._redirects === 0) {
      throw err;
    } else {
      emitErrorAndClose(websocket, err);
      return;
    }
  }

  const defaultPort = isSecure ? 443 : 80;
  const key = randomBytes(16).toString('base64');
  const request = isSecure ? https.request : http$1.request;
  const protocolSet = new Set();
  let perMessageDeflate;

  opts.createConnection =
    opts.createConnection || (isSecure ? tlsConnect : netConnect);
  opts.defaultPort = opts.defaultPort || defaultPort;
  opts.port = parsedUrl.port || defaultPort;
  opts.host = parsedUrl.hostname.startsWith('[')
    ? parsedUrl.hostname.slice(1, -1)
    : parsedUrl.hostname;
  opts.headers = {
    ...opts.headers,
    'Sec-WebSocket-Version': opts.protocolVersion,
    'Sec-WebSocket-Key': key,
    Connection: 'Upgrade',
    Upgrade: 'websocket'
  };
  opts.path = parsedUrl.pathname + parsedUrl.search;
  opts.timeout = opts.handshakeTimeout;

  if (opts.perMessageDeflate) {
    perMessageDeflate = new PerMessageDeflate$1(
      opts.perMessageDeflate !== true ? opts.perMessageDeflate : {},
      false,
      opts.maxPayload
    );
    opts.headers['Sec-WebSocket-Extensions'] = format({
      [PerMessageDeflate$1.extensionName]: perMessageDeflate.offer()
    });
  }
  if (protocols.length) {
    for (const protocol of protocols) {
      if (
        typeof protocol !== 'string' ||
        !subprotocolRegex.test(protocol) ||
        protocolSet.has(protocol)
      ) {
        throw new SyntaxError(
          'An invalid or duplicated subprotocol was specified'
        );
      }

      protocolSet.add(protocol);
    }

    opts.headers['Sec-WebSocket-Protocol'] = protocols.join(',');
  }
  if (opts.origin) {
    if (opts.protocolVersion < 13) {
      opts.headers['Sec-WebSocket-Origin'] = opts.origin;
    } else {
      opts.headers.Origin = opts.origin;
    }
  }
  if (parsedUrl.username || parsedUrl.password) {
    opts.auth = `${parsedUrl.username}:${parsedUrl.password}`;
  }

  if (isIpcUrl) {
    const parts = opts.path.split(':');

    opts.socketPath = parts[0];
    opts.path = parts[1];
  }

  let req;

  if (opts.followRedirects) {
    if (websocket._redirects === 0) {
      websocket._originalIpc = isIpcUrl;
      websocket._originalSecure = isSecure;
      websocket._originalHostOrSocketPath = isIpcUrl
        ? opts.socketPath
        : parsedUrl.host;

      const headers = options && options.headers;

      //
      // Shallow copy the user provided options so that headers can be changed
      // without mutating the original object.
      //
      options = { ...options, headers: {} };

      if (headers) {
        for (const [key, value] of Object.entries(headers)) {
          options.headers[key.toLowerCase()] = value;
        }
      }
    } else if (websocket.listenerCount('redirect') === 0) {
      const isSameHost = isIpcUrl
        ? websocket._originalIpc
          ? opts.socketPath === websocket._originalHostOrSocketPath
          : false
        : websocket._originalIpc
          ? false
          : parsedUrl.host === websocket._originalHostOrSocketPath;

      if (!isSameHost || (websocket._originalSecure && !isSecure)) {
        //
        // Match curl 7.77.0 behavior and drop the following headers. These
        // headers are also dropped when following a redirect to a subdomain.
        //
        delete opts.headers.authorization;
        delete opts.headers.cookie;

        if (!isSameHost) delete opts.headers.host;

        opts.auth = undefined;
      }
    }

    //
    // Match curl 7.77.0 behavior and make the first `Authorization` header win.
    // If the `Authorization` header is set, then there is nothing to do as it
    // will take precedence.
    //
    if (opts.auth && !options.headers.authorization) {
      options.headers.authorization =
        'Basic ' + Buffer.from(opts.auth).toString('base64');
    }

    req = websocket._req = request(opts);

    if (websocket._redirects) {
      //
      // Unlike what is done for the `'upgrade'` event, no early exit is
      // triggered here if the user calls `websocket.close()` or
      // `websocket.terminate()` from a listener of the `'redirect'` event. This
      // is because the user can also call `request.destroy()` with an error
      // before calling `websocket.close()` or `websocket.terminate()` and this
      // would result in an error being emitted on the `request` object with no
      // `'error'` event listeners attached.
      //
      websocket.emit('redirect', websocket.url, req);
    }
  } else {
    req = websocket._req = request(opts);
  }

  if (opts.timeout) {
    req.on('timeout', () => {
      abortHandshake$1(websocket, req, 'Opening handshake has timed out');
    });
  }

  req.on('error', (err) => {
    if (req === null || req[kAborted]) return;

    req = websocket._req = null;
    emitErrorAndClose(websocket, err);
  });

  req.on('response', (res) => {
    const location = res.headers.location;
    const statusCode = res.statusCode;

    if (
      location &&
      opts.followRedirects &&
      statusCode >= 300 &&
      statusCode < 400
    ) {
      if (++websocket._redirects > opts.maxRedirects) {
        abortHandshake$1(websocket, req, 'Maximum redirects exceeded');
        return;
      }

      req.abort();

      let addr;

      try {
        addr = new URL$1(location, address);
      } catch (e) {
        const err = new SyntaxError(`Invalid URL: ${location}`);
        emitErrorAndClose(websocket, err);
        return;
      }

      initAsClient(websocket, addr, protocols, options);
    } else if (!websocket.emit('unexpected-response', req, res)) {
      abortHandshake$1(
        websocket,
        req,
        `Unexpected server response: ${res.statusCode}`
      );
    }
  });

  req.on('upgrade', (res, socket, head) => {
    websocket.emit('upgrade', res);

    //
    // The user may have closed the connection from a listener of the
    // `'upgrade'` event.
    //
    if (websocket.readyState !== WebSocket$1.CONNECTING) return;

    req = websocket._req = null;

    const upgrade = res.headers.upgrade;

    if (upgrade === undefined || upgrade.toLowerCase() !== 'websocket') {
      abortHandshake$1(websocket, socket, 'Invalid Upgrade header');
      return;
    }

    const digest = createHash$1('sha1')
      .update(key + GUID$1)
      .digest('base64');

    if (res.headers['sec-websocket-accept'] !== digest) {
      abortHandshake$1(websocket, socket, 'Invalid Sec-WebSocket-Accept header');
      return;
    }

    const serverProt = res.headers['sec-websocket-protocol'];
    let protError;

    if (serverProt !== undefined) {
      if (!protocolSet.size) {
        protError = 'Server sent a subprotocol but none was requested';
      } else if (!protocolSet.has(serverProt)) {
        protError = 'Server sent an invalid subprotocol';
      }
    } else if (protocolSet.size) {
      protError = 'Server sent no subprotocol';
    }

    if (protError) {
      abortHandshake$1(websocket, socket, protError);
      return;
    }

    if (serverProt) websocket._protocol = serverProt;

    const secWebSocketExtensions = res.headers['sec-websocket-extensions'];

    if (secWebSocketExtensions !== undefined) {
      if (!perMessageDeflate) {
        const message =
          'Server sent a Sec-WebSocket-Extensions header but no extension ' +
          'was requested';
        abortHandshake$1(websocket, socket, message);
        return;
      }

      let extensions;

      try {
        extensions = parse$1(secWebSocketExtensions);
      } catch (err) {
        const message = 'Invalid Sec-WebSocket-Extensions header';
        abortHandshake$1(websocket, socket, message);
        return;
      }

      const extensionNames = Object.keys(extensions);

      if (
        extensionNames.length !== 1 ||
        extensionNames[0] !== PerMessageDeflate$1.extensionName
      ) {
        const message = 'Server indicated an extension that was not requested';
        abortHandshake$1(websocket, socket, message);
        return;
      }

      try {
        perMessageDeflate.accept(extensions[PerMessageDeflate$1.extensionName]);
      } catch (err) {
        const message = 'Invalid Sec-WebSocket-Extensions header';
        abortHandshake$1(websocket, socket, message);
        return;
      }

      websocket._extensions[PerMessageDeflate$1.extensionName] =
        perMessageDeflate;
    }

    websocket.setSocket(socket, head, {
      allowSynchronousEvents: opts.allowSynchronousEvents,
      generateMask: opts.generateMask,
      maxPayload: opts.maxPayload,
      skipUTF8Validation: opts.skipUTF8Validation
    });
  });

  if (opts.finishRequest) {
    opts.finishRequest(req, websocket);
  } else {
    req.end();
  }
}

/**
 * Emit the `'error'` and `'close'` events.
 *
 * @param {WebSocket} websocket The WebSocket instance
 * @param {Error} The error to emit
 * @private
 */
function emitErrorAndClose(websocket, err) {
  websocket._readyState = WebSocket$1.CLOSING;
  //
  // The following assignment is practically useless and is done only for
  // consistency.
  //
  websocket._errorEmitted = true;
  websocket.emit('error', err);
  websocket.emitClose();
}

/**
 * Create a `net.Socket` and initiate a connection.
 *
 * @param {Object} options Connection options
 * @return {net.Socket} The newly created socket used to start the connection
 * @private
 */
function netConnect(options) {
  options.path = options.socketPath;
  return net.connect(options);
}

/**
 * Create a `tls.TLSSocket` and initiate a connection.
 *
 * @param {Object} options Connection options
 * @return {tls.TLSSocket} The newly created socket used to start the connection
 * @private
 */
function tlsConnect(options) {
  options.path = undefined;

  if (!options.servername && options.servername !== '') {
    options.servername = net.isIP(options.host) ? '' : options.host;
  }

  return tls.connect(options);
}

/**
 * Abort the handshake and emit an error.
 *
 * @param {WebSocket} websocket The WebSocket instance
 * @param {(http.ClientRequest|net.Socket|tls.Socket)} stream The request to
 *     abort or the socket to destroy
 * @param {String} message The error message
 * @private
 */
function abortHandshake$1(websocket, stream, message) {
  websocket._readyState = WebSocket$1.CLOSING;

  const err = new Error(message);
  Error.captureStackTrace(err, abortHandshake$1);

  if (stream.setHeader) {
    stream[kAborted] = true;
    stream.abort();

    if (stream.socket && !stream.socket.destroyed) {
      //
      // On Node.js >= 14.3.0 `request.abort()` does not destroy the socket if
      // called after the request completed. See
      // https://github.com/websockets/ws/issues/1869.
      //
      stream.socket.destroy();
    }

    process.nextTick(emitErrorAndClose, websocket, err);
  } else {
    stream.destroy(err);
    stream.once('error', websocket.emit.bind(websocket, 'error'));
    stream.once('close', websocket.emitClose.bind(websocket));
  }
}

/**
 * Handle cases where the `ping()`, `pong()`, or `send()` methods are called
 * when the `readyState` attribute is `CLOSING` or `CLOSED`.
 *
 * @param {WebSocket} websocket The WebSocket instance
 * @param {*} [data] The data to send
 * @param {Function} [cb] Callback
 * @private
 */
function sendAfterClose(websocket, data, cb) {
  if (data) {
    const length = isBlob(data) ? data.size : toBuffer(data).length;

    //
    // The `_bufferedAmount` property is used only when the peer is a client and
    // the opening handshake fails. Under these circumstances, in fact, the
    // `setSocket()` method is not called, so the `_socket` and `_sender`
    // properties are set to `null`.
    //
    if (websocket._socket) websocket._sender._bufferedBytes += length;
    else websocket._bufferedAmount += length;
  }

  if (cb) {
    const err = new Error(
      `WebSocket is not open: readyState ${websocket.readyState} ` +
        `(${readyStates[websocket.readyState]})`
    );
    process.nextTick(cb, err);
  }
}

/**
 * The listener of the `Receiver` `'conclude'` event.
 *
 * @param {Number} code The status code
 * @param {Buffer} reason The reason for closing
 * @private
 */
function receiverOnConclude(code, reason) {
  const websocket = this[kWebSocket$1];

  websocket._closeFrameReceived = true;
  websocket._closeMessage = reason;
  websocket._closeCode = code;

  if (websocket._socket[kWebSocket$1] === undefined) return;

  websocket._socket.removeListener('data', socketOnData);
  process.nextTick(resume, websocket._socket);

  if (code === 1005) websocket.close();
  else websocket.close(code, reason);
}

/**
 * The listener of the `Receiver` `'drain'` event.
 *
 * @private
 */
function receiverOnDrain() {
  const websocket = this[kWebSocket$1];

  if (!websocket.isPaused) websocket._socket.resume();
}

/**
 * The listener of the `Receiver` `'error'` event.
 *
 * @param {(RangeError|Error)} err The emitted error
 * @private
 */
function receiverOnError(err) {
  const websocket = this[kWebSocket$1];

  if (websocket._socket[kWebSocket$1] !== undefined) {
    websocket._socket.removeListener('data', socketOnData);

    //
    // On Node.js < 14.0.0 the `'error'` event is emitted synchronously. See
    // https://github.com/websockets/ws/issues/1940.
    //
    process.nextTick(resume, websocket._socket);

    websocket.close(err[kStatusCode]);
  }

  if (!websocket._errorEmitted) {
    websocket._errorEmitted = true;
    websocket.emit('error', err);
  }
}

/**
 * The listener of the `Receiver` `'finish'` event.
 *
 * @private
 */
function receiverOnFinish() {
  this[kWebSocket$1].emitClose();
}

/**
 * The listener of the `Receiver` `'message'` event.
 *
 * @param {Buffer|ArrayBuffer|Buffer[])} data The message
 * @param {Boolean} isBinary Specifies whether the message is binary or not
 * @private
 */
function receiverOnMessage(data, isBinary) {
  this[kWebSocket$1].emit('message', data, isBinary);
}

/**
 * The listener of the `Receiver` `'ping'` event.
 *
 * @param {Buffer} data The data included in the ping frame
 * @private
 */
function receiverOnPing(data) {
  const websocket = this[kWebSocket$1];

  if (websocket._autoPong) websocket.pong(data, !this._isServer, NOOP);
  websocket.emit('ping', data);
}

/**
 * The listener of the `Receiver` `'pong'` event.
 *
 * @param {Buffer} data The data included in the pong frame
 * @private
 */
function receiverOnPong(data) {
  this[kWebSocket$1].emit('pong', data);
}

/**
 * Resume a readable stream
 *
 * @param {Readable} stream The readable stream
 * @private
 */
function resume(stream) {
  stream.resume();
}

/**
 * The `Sender` error event handler.
 *
 * @param {Error} The error
 * @private
 */
function senderOnError(err) {
  const websocket = this[kWebSocket$1];

  if (websocket.readyState === WebSocket$1.CLOSED) return;
  if (websocket.readyState === WebSocket$1.OPEN) {
    websocket._readyState = WebSocket$1.CLOSING;
    setCloseTimer(websocket);
  }

  //
  // `socket.end()` is used instead of `socket.destroy()` to allow the other
  // peer to finish sending queued data. There is no need to set a timer here
  // because `CLOSING` means that it is already set or not needed.
  //
  this._socket.end();

  if (!websocket._errorEmitted) {
    websocket._errorEmitted = true;
    websocket.emit('error', err);
  }
}

/**
 * Set a timer to destroy the underlying raw socket of a WebSocket.
 *
 * @param {WebSocket} websocket The WebSocket instance
 * @private
 */
function setCloseTimer(websocket) {
  websocket._closeTimer = setTimeout(
    websocket._socket.destroy.bind(websocket._socket),
    closeTimeout
  );
}

/**
 * The listener of the socket `'close'` event.
 *
 * @private
 */
function socketOnClose() {
  const websocket = this[kWebSocket$1];

  this.removeListener('close', socketOnClose);
  this.removeListener('data', socketOnData);
  this.removeListener('end', socketOnEnd);

  websocket._readyState = WebSocket$1.CLOSING;

  let chunk;

  //
  // The close frame might not have been received or the `'end'` event emitted,
  // for example, if the socket was destroyed due to an error. Ensure that the
  // `receiver` stream is closed after writing any remaining buffered data to
  // it. If the readable side of the socket is in flowing mode then there is no
  // buffered data as everything has been already written and `readable.read()`
  // will return `null`. If instead, the socket is paused, any possible buffered
  // data will be read as a single chunk.
  //
  if (
    !this._readableState.endEmitted &&
    !websocket._closeFrameReceived &&
    !websocket._receiver._writableState.errorEmitted &&
    (chunk = websocket._socket.read()) !== null
  ) {
    websocket._receiver.write(chunk);
  }

  websocket._receiver.end();

  this[kWebSocket$1] = undefined;

  clearTimeout(websocket._closeTimer);

  if (
    websocket._receiver._writableState.finished ||
    websocket._receiver._writableState.errorEmitted
  ) {
    websocket.emitClose();
  } else {
    websocket._receiver.on('error', receiverOnFinish);
    websocket._receiver.on('finish', receiverOnFinish);
  }
}

/**
 * The listener of the socket `'data'` event.
 *
 * @param {Buffer} chunk A chunk of data
 * @private
 */
function socketOnData(chunk) {
  if (!this[kWebSocket$1]._receiver.write(chunk)) {
    this.pause();
  }
}

/**
 * The listener of the socket `'end'` event.
 *
 * @private
 */
function socketOnEnd() {
  const websocket = this[kWebSocket$1];

  websocket._readyState = WebSocket$1.CLOSING;
  websocket._receiver.end();
  this.end();
}

/**
 * The listener of the socket `'error'` event.
 *
 * @private
 */
function socketOnError$1() {
  const websocket = this[kWebSocket$1];

  this.removeListener('error', socketOnError$1);
  this.on('error', NOOP);

  if (websocket) {
    websocket._readyState = WebSocket$1.CLOSING;
    this.destroy();
  }
}

const { tokenChars } = validationExports;

/**
 * Parses the `Sec-WebSocket-Protocol` header into a set of subprotocol names.
 *
 * @param {String} header The field value of the header
 * @return {Set} The subprotocol names
 * @public
 */
function parse(header) {
  const protocols = new Set();
  let start = -1;
  let end = -1;
  let i = 0;

  for (i; i < header.length; i++) {
    const code = header.charCodeAt(i);

    if (end === -1 && tokenChars[code] === 1) {
      if (start === -1) start = i;
    } else if (
      i !== 0 &&
      (code === 0x20 /* ' ' */ || code === 0x09) /* '\t' */
    ) {
      if (end === -1 && start !== -1) end = i;
    } else if (code === 0x2c /* ',' */) {
      if (start === -1) {
        throw new SyntaxError(`Unexpected character at index ${i}`);
      }

      if (end === -1) end = i;

      const protocol = header.slice(start, end);

      if (protocols.has(protocol)) {
        throw new SyntaxError(`The "${protocol}" subprotocol is duplicated`);
      }

      protocols.add(protocol);
      start = end = -1;
    } else {
      throw new SyntaxError(`Unexpected character at index ${i}`);
    }
  }

  if (start === -1 || end !== -1) {
    throw new SyntaxError('Unexpected end of input');
  }

  const protocol = header.slice(start, i);

  if (protocols.has(protocol)) {
    throw new SyntaxError(`The "${protocol}" subprotocol is duplicated`);
  }

  protocols.add(protocol);
  return protocols;
}

var subprotocol$1 = { parse };

/* eslint no-unused-vars: ["error", { "varsIgnorePattern": "^Duplex$", "caughtErrors": "none" }] */

const EventEmitter = require$$0$4;
const http = require$$2;
const { createHash } = require$$1;

const extension = extension$1;
const PerMessageDeflate = permessageDeflate;
const subprotocol = subprotocol$1;
const WebSocket = websocket;
const { GUID, kWebSocket } = constants;

const keyRegex = /^[+/0-9A-Za-z]{22}==$/;

const RUNNING = 0;
const CLOSING = 1;
const CLOSED = 2;

/**
 * Class representing a WebSocket server.
 *
 * @extends EventEmitter
 */
class WebSocketServer extends EventEmitter {
  /**
   * Create a `WebSocketServer` instance.
   *
   * @param {Object} options Configuration options
   * @param {Boolean} [options.allowSynchronousEvents=true] Specifies whether
   *     any of the `'message'`, `'ping'`, and `'pong'` events can be emitted
   *     multiple times in the same tick
   * @param {Boolean} [options.autoPong=true] Specifies whether or not to
   *     automatically send a pong in response to a ping
   * @param {Number} [options.backlog=511] The maximum length of the queue of
   *     pending connections
   * @param {Boolean} [options.clientTracking=true] Specifies whether or not to
   *     track clients
   * @param {Function} [options.handleProtocols] A hook to handle protocols
   * @param {String} [options.host] The hostname where to bind the server
   * @param {Number} [options.maxPayload=104857600] The maximum allowed message
   *     size
   * @param {Boolean} [options.noServer=false] Enable no server mode
   * @param {String} [options.path] Accept only connections matching this path
   * @param {(Boolean|Object)} [options.perMessageDeflate=false] Enable/disable
   *     permessage-deflate
   * @param {Number} [options.port] The port where to bind the server
   * @param {(http.Server|https.Server)} [options.server] A pre-created HTTP/S
   *     server to use
   * @param {Boolean} [options.skipUTF8Validation=false] Specifies whether or
   *     not to skip UTF-8 validation for text and close messages
   * @param {Function} [options.verifyClient] A hook to reject connections
   * @param {Function} [options.WebSocket=WebSocket] Specifies the `WebSocket`
   *     class to use. It must be the `WebSocket` class or class that extends it
   * @param {Function} [callback] A listener for the `listening` event
   */
  constructor(options, callback) {
    super();

    options = {
      allowSynchronousEvents: true,
      autoPong: true,
      maxPayload: 100 * 1024 * 1024,
      skipUTF8Validation: false,
      perMessageDeflate: false,
      handleProtocols: null,
      clientTracking: true,
      verifyClient: null,
      noServer: false,
      backlog: null, // use default (511 as implemented in net.js)
      server: null,
      host: null,
      path: null,
      port: null,
      WebSocket,
      ...options
    };

    if (
      (options.port == null && !options.server && !options.noServer) ||
      (options.port != null && (options.server || options.noServer)) ||
      (options.server && options.noServer)
    ) {
      throw new TypeError(
        'One and only one of the "port", "server", or "noServer" options ' +
          'must be specified'
      );
    }

    if (options.port != null) {
      this._server = http.createServer((req, res) => {
        const body = http.STATUS_CODES[426];

        res.writeHead(426, {
          'Content-Length': body.length,
          'Content-Type': 'text/plain'
        });
        res.end(body);
      });
      this._server.listen(
        options.port,
        options.host,
        options.backlog,
        callback
      );
    } else if (options.server) {
      this._server = options.server;
    }

    if (this._server) {
      const emitConnection = this.emit.bind(this, 'connection');

      this._removeListeners = addListeners(this._server, {
        listening: this.emit.bind(this, 'listening'),
        error: this.emit.bind(this, 'error'),
        upgrade: (req, socket, head) => {
          this.handleUpgrade(req, socket, head, emitConnection);
        }
      });
    }

    if (options.perMessageDeflate === true) options.perMessageDeflate = {};
    if (options.clientTracking) {
      this.clients = new Set();
      this._shouldEmitClose = false;
    }

    this.options = options;
    this._state = RUNNING;
  }

  /**
   * Returns the bound address, the address family name, and port of the server
   * as reported by the operating system if listening on an IP socket.
   * If the server is listening on a pipe or UNIX domain socket, the name is
   * returned as a string.
   *
   * @return {(Object|String|null)} The address of the server
   * @public
   */
  address() {
    if (this.options.noServer) {
      throw new Error('The server is operating in "noServer" mode');
    }

    if (!this._server) return null;
    return this._server.address();
  }

  /**
   * Stop the server from accepting new connections and emit the `'close'` event
   * when all existing connections are closed.
   *
   * @param {Function} [cb] A one-time listener for the `'close'` event
   * @public
   */
  close(cb) {
    if (this._state === CLOSED) {
      if (cb) {
        this.once('close', () => {
          cb(new Error('The server is not running'));
        });
      }

      process.nextTick(emitClose, this);
      return;
    }

    if (cb) this.once('close', cb);

    if (this._state === CLOSING) return;
    this._state = CLOSING;

    if (this.options.noServer || this.options.server) {
      if (this._server) {
        this._removeListeners();
        this._removeListeners = this._server = null;
      }

      if (this.clients) {
        if (!this.clients.size) {
          process.nextTick(emitClose, this);
        } else {
          this._shouldEmitClose = true;
        }
      } else {
        process.nextTick(emitClose, this);
      }
    } else {
      const server = this._server;

      this._removeListeners();
      this._removeListeners = this._server = null;

      //
      // The HTTP/S server was created internally. Close it, and rely on its
      // `'close'` event.
      //
      server.close(() => {
        emitClose(this);
      });
    }
  }

  /**
   * See if a given request should be handled by this server instance.
   *
   * @param {http.IncomingMessage} req Request object to inspect
   * @return {Boolean} `true` if the request is valid, else `false`
   * @public
   */
  shouldHandle(req) {
    if (this.options.path) {
      const index = req.url.indexOf('?');
      const pathname = index !== -1 ? req.url.slice(0, index) : req.url;

      if (pathname !== this.options.path) return false;
    }

    return true;
  }

  /**
   * Handle a HTTP Upgrade request.
   *
   * @param {http.IncomingMessage} req The request object
   * @param {Duplex} socket The network socket between the server and client
   * @param {Buffer} head The first packet of the upgraded stream
   * @param {Function} cb Callback
   * @public
   */
  handleUpgrade(req, socket, head, cb) {
    socket.on('error', socketOnError);

    const key = req.headers['sec-websocket-key'];
    const upgrade = req.headers.upgrade;
    const version = +req.headers['sec-websocket-version'];

    if (req.method !== 'GET') {
      const message = 'Invalid HTTP method';
      abortHandshakeOrEmitwsClientError(this, req, socket, 405, message);
      return;
    }

    if (upgrade === undefined || upgrade.toLowerCase() !== 'websocket') {
      const message = 'Invalid Upgrade header';
      abortHandshakeOrEmitwsClientError(this, req, socket, 400, message);
      return;
    }

    if (key === undefined || !keyRegex.test(key)) {
      const message = 'Missing or invalid Sec-WebSocket-Key header';
      abortHandshakeOrEmitwsClientError(this, req, socket, 400, message);
      return;
    }

    if (version !== 8 && version !== 13) {
      const message = 'Missing or invalid Sec-WebSocket-Version header';
      abortHandshakeOrEmitwsClientError(this, req, socket, 400, message);
      return;
    }

    if (!this.shouldHandle(req)) {
      abortHandshake(socket, 400);
      return;
    }

    const secWebSocketProtocol = req.headers['sec-websocket-protocol'];
    let protocols = new Set();

    if (secWebSocketProtocol !== undefined) {
      try {
        protocols = subprotocol.parse(secWebSocketProtocol);
      } catch (err) {
        const message = 'Invalid Sec-WebSocket-Protocol header';
        abortHandshakeOrEmitwsClientError(this, req, socket, 400, message);
        return;
      }
    }

    const secWebSocketExtensions = req.headers['sec-websocket-extensions'];
    const extensions = {};

    if (
      this.options.perMessageDeflate &&
      secWebSocketExtensions !== undefined
    ) {
      const perMessageDeflate = new PerMessageDeflate(
        this.options.perMessageDeflate,
        true,
        this.options.maxPayload
      );

      try {
        const offers = extension.parse(secWebSocketExtensions);

        if (offers[PerMessageDeflate.extensionName]) {
          perMessageDeflate.accept(offers[PerMessageDeflate.extensionName]);
          extensions[PerMessageDeflate.extensionName] = perMessageDeflate;
        }
      } catch (err) {
        const message =
          'Invalid or unacceptable Sec-WebSocket-Extensions header';
        abortHandshakeOrEmitwsClientError(this, req, socket, 400, message);
        return;
      }
    }

    //
    // Optionally call external client verification handler.
    //
    if (this.options.verifyClient) {
      const info = {
        origin:
          req.headers[`${version === 8 ? 'sec-websocket-origin' : 'origin'}`],
        secure: !!(req.socket.authorized || req.socket.encrypted),
        req
      };

      if (this.options.verifyClient.length === 2) {
        this.options.verifyClient(info, (verified, code, message, headers) => {
          if (!verified) {
            return abortHandshake(socket, code || 401, message, headers);
          }

          this.completeUpgrade(
            extensions,
            key,
            protocols,
            req,
            socket,
            head,
            cb
          );
        });
        return;
      }

      if (!this.options.verifyClient(info)) return abortHandshake(socket, 401);
    }

    this.completeUpgrade(extensions, key, protocols, req, socket, head, cb);
  }

  /**
   * Upgrade the connection to WebSocket.
   *
   * @param {Object} extensions The accepted extensions
   * @param {String} key The value of the `Sec-WebSocket-Key` header
   * @param {Set} protocols The subprotocols
   * @param {http.IncomingMessage} req The request object
   * @param {Duplex} socket The network socket between the server and client
   * @param {Buffer} head The first packet of the upgraded stream
   * @param {Function} cb Callback
   * @throws {Error} If called more than once with the same socket
   * @private
   */
  completeUpgrade(extensions, key, protocols, req, socket, head, cb) {
    //
    // Destroy the socket if the client has already sent a FIN packet.
    //
    if (!socket.readable || !socket.writable) return socket.destroy();

    if (socket[kWebSocket]) {
      throw new Error(
        'server.handleUpgrade() was called more than once with the same ' +
          'socket, possibly due to a misconfiguration'
      );
    }

    if (this._state > RUNNING) return abortHandshake(socket, 503);

    const digest = createHash('sha1')
      .update(key + GUID)
      .digest('base64');

    const headers = [
      'HTTP/1.1 101 Switching Protocols',
      'Upgrade: websocket',
      'Connection: Upgrade',
      `Sec-WebSocket-Accept: ${digest}`
    ];

    const ws = new this.options.WebSocket(null, undefined, this.options);

    if (protocols.size) {
      //
      // Optionally call external protocol selection handler.
      //
      const protocol = this.options.handleProtocols
        ? this.options.handleProtocols(protocols, req)
        : protocols.values().next().value;

      if (protocol) {
        headers.push(`Sec-WebSocket-Protocol: ${protocol}`);
        ws._protocol = protocol;
      }
    }

    if (extensions[PerMessageDeflate.extensionName]) {
      const params = extensions[PerMessageDeflate.extensionName].params;
      const value = extension.format({
        [PerMessageDeflate.extensionName]: [params]
      });
      headers.push(`Sec-WebSocket-Extensions: ${value}`);
      ws._extensions = extensions;
    }

    //
    // Allow external modification/inspection of handshake headers.
    //
    this.emit('headers', headers, req);

    socket.write(headers.concat('\r\n').join('\r\n'));
    socket.removeListener('error', socketOnError);

    ws.setSocket(socket, head, {
      allowSynchronousEvents: this.options.allowSynchronousEvents,
      maxPayload: this.options.maxPayload,
      skipUTF8Validation: this.options.skipUTF8Validation
    });

    if (this.clients) {
      this.clients.add(ws);
      ws.on('close', () => {
        this.clients.delete(ws);

        if (this._shouldEmitClose && !this.clients.size) {
          process.nextTick(emitClose, this);
        }
      });
    }

    cb(ws, req);
  }
}

var websocketServer = WebSocketServer;

/**
 * Add event listeners on an `EventEmitter` using a map of <event, listener>
 * pairs.
 *
 * @param {EventEmitter} server The event emitter
 * @param {Object.<String, Function>} map The listeners to add
 * @return {Function} A function that will remove the added listeners when
 *     called
 * @private
 */
function addListeners(server, map) {
  for (const event of Object.keys(map)) server.on(event, map[event]);

  return function removeListeners() {
    for (const event of Object.keys(map)) {
      server.removeListener(event, map[event]);
    }
  };
}

/**
 * Emit a `'close'` event on an `EventEmitter`.
 *
 * @param {EventEmitter} server The event emitter
 * @private
 */
function emitClose(server) {
  server._state = CLOSED;
  server.emit('close');
}

/**
 * Handle socket errors.
 *
 * @private
 */
function socketOnError() {
  this.destroy();
}

/**
 * Close the connection when preconditions are not fulfilled.
 *
 * @param {Duplex} socket The socket of the upgrade request
 * @param {Number} code The HTTP response status code
 * @param {String} [message] The HTTP response body
 * @param {Object} [headers] Additional HTTP response headers
 * @private
 */
function abortHandshake(socket, code, message, headers) {
  //
  // The socket is writable unless the user destroyed or ended it before calling
  // `server.handleUpgrade()` or in the `verifyClient` function, which is a user
  // error. Handling this does not make much sense as the worst that can happen
  // is that some of the data written by the user might be discarded due to the
  // call to `socket.end()` below, which triggers an `'error'` event that in
  // turn causes the socket to be destroyed.
  //
  message = message || http.STATUS_CODES[code];
  headers = {
    Connection: 'close',
    'Content-Type': 'text/html',
    'Content-Length': Buffer.byteLength(message),
    ...headers
  };

  socket.once('finish', socket.destroy);

  socket.end(
    `HTTP/1.1 ${code} ${http.STATUS_CODES[code]}\r\n` +
      Object.keys(headers)
        .map((h) => `${h}: ${headers[h]}`)
        .join('\r\n') +
      '\r\n\r\n' +
      message
  );
}

/**
 * Emit a `'wsClientError'` event on a `WebSocketServer` if there is at least
 * one listener for it, otherwise call `abortHandshake()`.
 *
 * @param {WebSocketServer} server The WebSocket server
 * @param {http.IncomingMessage} req The request object
 * @param {Duplex} socket The socket of the upgrade request
 * @param {Number} code The HTTP response status code
 * @param {String} message The HTTP response body
 * @private
 */
function abortHandshakeOrEmitwsClientError(server, req, socket, code, message) {
  if (server.listenerCount('wsClientError')) {
    const err = new Error(message);
    Error.captureStackTrace(err, abortHandshakeOrEmitwsClientError);

    server.emit('wsClientError', err, socket, req);
  } else {
    abortHandshake(socket, code, message);
  }
}

var WebSocketServer$1 = /*@__PURE__*/getDefaultExportFromCjs(websocketServer);

function setup(ctx, _server) {
  const wss = new WebSocketServer$1({ noServer: true });
  const clients = /* @__PURE__ */ new Map();
  const server = _server || ctx.server;
  server.httpServer?.on("upgrade", (request, socket, head) => {
    if (!request.url) {
      return;
    }
    const { pathname } = new URL(request.url, "http://localhost");
    if (pathname !== API_PATH) {
      return;
    }
    wss.handleUpgrade(request, socket, head, (ws) => {
      wss.emit("connection", ws, request);
      setupClient(ws);
    });
  });
  function setupClient(ws) {
    const rpc = createBirpc(
      {
        async onTaskUpdate(packs) {
          ctx.state.updateTasks(packs);
          await ctx.report("onTaskUpdate", packs);
        },
        getFiles() {
          return ctx.state.getFiles();
        },
        getPaths() {
          return ctx.state.getPaths();
        },
        async readTestFile(id) {
          if (!ctx.state.filesMap.has(id) || !existsSync(id)) {
            return null;
          }
          return promises$1.readFile(id, "utf-8");
        },
        async saveTestFile(id, content) {
          if (!ctx.state.filesMap.has(id) || !existsSync(id)) {
            throw new Error(
              `Test file "${id}" was not registered, so it cannot be updated using the API.`
            );
          }
          return promises$1.writeFile(id, content, "utf-8");
        },
        async rerun(files) {
          await ctx.rerunFiles(files);
        },
        getConfig() {
          return ctx.getCoreWorkspaceProject().getSerializableConfig();
        },
        async getTransformResult(projectName, id, browser = false) {
          const project = ctx.getProjectByName(projectName);
          const result = browser ? await project.browser.vite.transformRequest(id) : await project.vitenode.transformRequest(id);
          if (result) {
            try {
              result.source = result.source || await promises$1.readFile(id, "utf-8");
            } catch {
            }
            return result;
          }
        },
        async getModuleGraph(project, id, browser) {
          return getModuleGraph(ctx, project, id, browser);
        },
        updateSnapshot(file) {
          if (!file) {
            return ctx.updateSnapshot();
          }
          return ctx.updateSnapshot([file.filepath]);
        },
        getUnhandledErrors() {
          return ctx.state.getUnhandledErrors();
        },
        async getTestFiles() {
          const spec = await ctx.globTestFiles();
          return spec.map(([project, file]) => [
            {
              name: project.config.name,
              root: project.config.root
            },
            file
          ]);
        }
      },
      {
        post: (msg) => ws.send(msg),
        on: (fn) => ws.on("message", fn),
        eventNames: [
          "onUserConsoleLog",
          "onFinished",
          "onFinishedReportCoverage",
          "onCollected",
          "onTaskUpdate"
        ],
        serialize: (data) => stringify(data, stringifyReplace),
        deserialize: parse$3,
        onTimeoutError(functionName) {
          throw new Error(`[vitest-api]: Timeout calling "${functionName}"`);
        }
      }
    );
    clients.set(ws, rpc);
    ws.on("close", () => {
      clients.delete(ws);
    });
  }
  ctx.reporters.push(new WebSocketReporter(ctx, wss, clients));
}
class WebSocketReporter {
  constructor(ctx, wss, clients) {
    this.ctx = ctx;
    this.wss = wss;
    this.clients = clients;
  }
  onCollected(files) {
    if (this.clients.size === 0) {
      return;
    }
    this.clients.forEach((client) => {
      client.onCollected?.(files)?.catch?.(noop$1);
    });
  }
  onSpecsCollected(specs) {
    if (this.clients.size === 0) {
      return;
    }
    this.clients.forEach((client) => {
      client.onSpecsCollected?.(specs)?.catch?.(noop$1);
    });
  }
  async onTaskUpdate(packs) {
    if (this.clients.size === 0) {
      return;
    }
    packs.forEach(([taskId, result]) => {
      const project = this.ctx.getProjectByTaskId(taskId);
      const task = this.ctx.state.idMap.get(taskId);
      const isBrowser = task && task.file.pool === "browser";
      result?.errors?.forEach((error) => {
        if (isPrimitive(error)) {
          return;
        }
        const stacks = isBrowser ? project.browser?.parseErrorStacktrace(error) : parseErrorStacktrace(error);
        error.stacks = stacks;
      });
    });
    this.clients.forEach((client) => {
      client.onTaskUpdate?.(packs)?.catch?.(noop$1);
    });
  }
  onFinished(files, errors) {
    this.clients.forEach((client) => {
      client.onFinished?.(files, errors)?.catch?.(noop$1);
    });
  }
  onFinishedReportCoverage() {
    this.clients.forEach((client) => {
      client.onFinishedReportCoverage?.()?.catch?.(noop$1);
    });
  }
  onUserConsoleLog(log) {
    this.clients.forEach((client) => {
      client.onUserConsoleLog?.(log)?.catch?.(noop$1);
    });
  }
}

var setup$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  WebSocketReporter: WebSocketReporter,
  setup: setup
});

const envsOrder = ["node", "jsdom", "happy-dom", "edge-runtime"];
function getTransformMode(patterns, filename) {
  if (patterns.web && mm.isMatch(filename, patterns.web)) {
    return "web";
  }
  if (patterns.ssr && mm.isMatch(filename, patterns.ssr)) {
    return "ssr";
  }
  return void 0;
}
async function groupFilesByEnv(files) {
  const filesWithEnv = await Promise.all(
    files.map(async ([project, file]) => {
      const code = await promises$1.readFile(file, "utf-8");
      let env = code.match(/@(?:vitest|jest)-environment\s+([\w-]+)\b/)?.[1];
      if (!env) {
        for (const [glob, target] of project.config.environmentMatchGlobs || []) {
          if (mm.isMatch(file, glob, { cwd: project.config.root })) {
            env = target;
            break;
          }
        }
      }
      env ||= project.config.environment || "node";
      const transformMode = getTransformMode(
        project.config.testTransformMode,
        file
      );
      let envOptionsJson = code.match(/@(?:vitest|jest)-environment-options\s+(.+)/)?.[1];
      if (envOptionsJson?.endsWith("*/")) {
        envOptionsJson = envOptionsJson.slice(0, -2);
      }
      const envOptions = JSON.parse(envOptionsJson || "null");
      const envKey = env === "happy-dom" ? "happyDOM" : env;
      const environment = {
        name: env,
        transformMode,
        options: envOptions ? { [envKey]: envOptions } : null
      };
      return {
        file,
        project,
        environment
      };
    })
  );
  return groupBy(filesWithEnv, ({ environment }) => environment.name);
}

const created = /* @__PURE__ */ new Set();
const promises = /* @__PURE__ */ new Map();
function createMethodsRPC(project, options = {}) {
  const ctx = project.ctx;
  const cacheFs = options.cacheFs ?? false;
  return {
    snapshotSaved(snapshot) {
      ctx.snapshot.add(snapshot);
    },
    resolveSnapshotPath(testPath) {
      return ctx.snapshot.resolvePath(testPath);
    },
    async getSourceMap(id, force) {
      if (force) {
        const mod = project.server.moduleGraph.getModuleById(id);
        if (mod) {
          project.server.moduleGraph.invalidateModule(mod);
        }
      }
      const r = await project.vitenode.transformRequest(id);
      return r?.map;
    },
    async fetch(id, transformMode) {
      const result = await project.vitenode.fetchResult(id, transformMode);
      const code = result.code;
      if (!cacheFs || result.externalize) {
        return result;
      }
      if ("id" in result && typeof result.id === "string") {
        return { id: result.id };
      }
      if (code == null) {
        throw new Error(`Failed to fetch module ${id}`);
      }
      const dir = join(project.tmpDir, transformMode);
      const name = createHash$2("sha1").update(id).digest("hex");
      const tmp = join(dir, name);
      if (promises.has(tmp)) {
        await promises.get(tmp);
        return { id: tmp };
      }
      if (!created.has(dir)) {
        await mkdir(dir, { recursive: true });
        created.add(dir);
      }
      promises.set(
        tmp,
        writeFile(tmp, code, "utf-8").finally(() => promises.delete(tmp))
      );
      await promises.get(tmp);
      Object.assign(result, { id: tmp });
      return { id: tmp };
    },
    resolveId(id, importer, transformMode) {
      return project.vitenode.resolveId(id, importer, transformMode);
    },
    transform(id, environment) {
      return project.vitenode.transformModule(id, environment);
    },
    onPathsCollected(paths) {
      ctx.state.collectPaths(paths);
      return ctx.report("onPathsCollected", paths);
    },
    onCollected(files) {
      ctx.state.collectFiles(project, files);
      return ctx.report("onCollected", files);
    },
    onAfterSuiteRun(meta) {
      ctx.coverageProvider?.onAfterSuiteRun(meta);
    },
    onTaskUpdate(packs) {
      ctx.state.updateTasks(packs);
      return ctx.report("onTaskUpdate", packs);
    },
    onUserConsoleLog(log) {
      ctx.state.updateUserLog(log);
      ctx.report("onUserConsoleLog", log);
    },
    onUnhandledError(err, type) {
      ctx.state.catchError(err, type);
    },
    onFinished(files) {
      return ctx.report("onFinished", files, ctx.state.getUnhandledErrors());
    },
    onCancel(reason) {
      ctx.cancelCurrentRun(reason);
    },
    getCountOfFailedTests() {
      return ctx.state.getCountOfFailedTests();
    }
  };
}

function createChildProcessChannel$1(project) {
  const emitter = new EventEmitter$2();
  const cleanup = () => emitter.removeAllListeners();
  const events = { message: "message", response: "response" };
  const channel = {
    onMessage: (callback) => emitter.on(events.message, callback),
    postMessage: (message) => emitter.emit(events.response, message)
  };
  const rpc = createBirpc(createMethodsRPC(project, { cacheFs: true }), {
    eventNames: ["onCancel"],
    serialize: v8.serialize,
    deserialize: (v) => v8.deserialize(Buffer.from(v)),
    post(v) {
      emitter.emit(events.message, v);
    },
    on(fn) {
      emitter.on(events.response, fn);
    },
    onTimeoutError(functionName) {
      throw new Error(`[vitest-pool]: Timeout calling "${functionName}"`);
    }
  });
  project.ctx.onCancel((reason) => rpc.onCancel(reason));
  return { channel, cleanup };
}
function createForksPool(ctx, { execArgv, env }) {
  const numCpus = typeof nodeos.availableParallelism === "function" ? nodeos.availableParallelism() : nodeos.cpus().length;
  const threadsCount = ctx.config.watch ? Math.max(Math.floor(numCpus / 2), 1) : Math.max(numCpus - 1, 1);
  const poolOptions = ctx.config.poolOptions?.forks ?? {};
  const maxThreads = poolOptions.maxForks ?? ctx.config.maxWorkers ?? threadsCount;
  const minThreads = poolOptions.minForks ?? ctx.config.minWorkers ?? threadsCount;
  const worker = resolve(ctx.distPath, "workers/forks.js");
  const options = {
    runtime: "child_process",
    filename: resolve(ctx.distPath, "worker.js"),
    maxThreads,
    minThreads,
    env,
    execArgv: [...poolOptions.execArgv ?? [], ...execArgv],
    terminateTimeout: ctx.config.teardownTimeout,
    concurrentTasksPerWorker: 1
  };
  const isolated = poolOptions.isolate ?? true;
  if (isolated) {
    options.isolateWorkers = true;
  }
  if (poolOptions.singleFork || !ctx.config.fileParallelism) {
    options.maxThreads = 1;
    options.minThreads = 1;
  }
  const pool = new Tinypool(options);
  const runWithFiles = (name) => {
    let id = 0;
    async function runFiles(project, config, files, environment, invalidates = []) {
      ctx.state.clearFiles(project, files);
      const { channel, cleanup } = createChildProcessChannel$1(project);
      const workerId = ++id;
      const data = {
        pool: "forks",
        worker,
        config,
        files,
        invalidates,
        environment,
        workerId,
        projectName: project.getName(),
        providedContext: project.getProvidedContext()
      };
      try {
        await pool.run(data, { name, channel });
      } catch (error) {
        if (error instanceof Error && /Failed to terminate worker/.test(error.message)) {
          ctx.state.addProcessTimeoutCause(
            `Failed to terminate worker while running ${files.join(", ")}.`
          );
        } else if (ctx.isCancelling && error instanceof Error && /The task has been cancelled/.test(error.message)) {
          ctx.state.cancelFiles(files, project);
        } else {
          throw error;
        }
      } finally {
        cleanup();
      }
    }
    return async (specs, invalidates) => {
      ctx.onCancel(() => pool.cancelPendingTasks());
      const configs = /* @__PURE__ */ new Map();
      const getConfig = (project) => {
        if (configs.has(project)) {
          return configs.get(project);
        }
        const _config = project.getSerializableConfig();
        const config = wrapSerializableConfig(_config);
        configs.set(project, config);
        return config;
      };
      const workspaceMap = /* @__PURE__ */ new Map();
      for (const [project, file] of specs) {
        const workspaceFiles = workspaceMap.get(file) ?? [];
        workspaceFiles.push(project);
        workspaceMap.set(file, workspaceFiles);
      }
      const singleFork = specs.filter(
        ([project]) => project.config.poolOptions?.forks?.singleFork
      );
      const multipleForks = specs.filter(
        ([project]) => !project.config.poolOptions?.forks?.singleFork
      );
      if (multipleForks.length) {
        const filesByEnv = await groupFilesByEnv(multipleForks);
        const files = Object.values(filesByEnv).flat();
        const results = [];
        if (isolated) {
          results.push(
            ...await Promise.allSettled(
              files.map(
                ({ file, environment, project }) => runFiles(
                  project,
                  getConfig(project),
                  [file],
                  environment,
                  invalidates
                )
              )
            )
          );
        } else {
          const grouped = groupBy(
            files,
            ({ project, environment }) => project.getName() + environment.name + JSON.stringify(environment.options)
          );
          for (const group of Object.values(grouped)) {
            results.push(
              ...await Promise.allSettled(
                group.map(
                  ({ file, environment, project }) => runFiles(
                    project,
                    getConfig(project),
                    [file],
                    environment,
                    invalidates
                  )
                )
              )
            );
            await new Promise(
              (resolve2) => pool.queueSize === 0 ? resolve2() : pool.once("drain", resolve2)
            );
            await pool.recycleWorkers();
          }
        }
        const errors = results.filter((r) => r.status === "rejected").map((r) => r.reason);
        if (errors.length > 0) {
          throw new AggregateError(
            errors,
            "Errors occurred while running tests. For more information, see serialized error."
          );
        }
      }
      if (singleFork.length) {
        const filesByEnv = await groupFilesByEnv(singleFork);
        const envs = envsOrder.concat(
          Object.keys(filesByEnv).filter((env2) => !envsOrder.includes(env2))
        );
        for (const env2 of envs) {
          const files = filesByEnv[env2];
          if (!files?.length) {
            continue;
          }
          const filesByOptions = groupBy(
            files,
            ({ project, environment }) => project.getName() + JSON.stringify(environment.options)
          );
          for (const files2 of Object.values(filesByOptions)) {
            await pool.recycleWorkers();
            const filenames = files2.map((f) => f.file);
            await runFiles(
              files2[0].project,
              getConfig(files2[0].project),
              filenames,
              files2[0].environment,
              invalidates
            );
          }
        }
      }
    };
  };
  return {
    name: "forks",
    runTests: runWithFiles("run"),
    collectTests: runWithFiles("collect"),
    close: () => pool.destroy()
  };
}

function createWorkerChannel$1(project) {
  const channel = new MessageChannel();
  const port = channel.port2;
  const workerPort = channel.port1;
  const rpc = createBirpc(createMethodsRPC(project), {
    eventNames: ["onCancel"],
    post(v) {
      port.postMessage(v);
    },
    on(fn) {
      port.on("message", fn);
    },
    onTimeoutError(functionName) {
      throw new Error(`[vitest-pool]: Timeout calling "${functionName}"`);
    }
  });
  project.ctx.onCancel((reason) => rpc.onCancel(reason));
  return { workerPort, port };
}
function createThreadsPool(ctx, { execArgv, env }) {
  const numCpus = typeof nodeos.availableParallelism === "function" ? nodeos.availableParallelism() : nodeos.cpus().length;
  const threadsCount = ctx.config.watch ? Math.max(Math.floor(numCpus / 2), 1) : Math.max(numCpus - 1, 1);
  const poolOptions = ctx.config.poolOptions?.threads ?? {};
  const maxThreads = poolOptions.maxThreads ?? ctx.config.maxWorkers ?? threadsCount;
  const minThreads = poolOptions.minThreads ?? ctx.config.minWorkers ?? threadsCount;
  const worker = resolve(ctx.distPath, "workers/threads.js");
  const options = {
    filename: resolve(ctx.distPath, "worker.js"),
    // TODO: investigate further
    // It seems atomics introduced V8 Fatal Error https://github.com/vitest-dev/vitest/issues/1191
    useAtomics: poolOptions.useAtomics ?? false,
    maxThreads,
    minThreads,
    env,
    execArgv: [...poolOptions.execArgv ?? [], ...execArgv],
    terminateTimeout: ctx.config.teardownTimeout,
    concurrentTasksPerWorker: 1
  };
  const isolated = poolOptions.isolate ?? true;
  if (isolated) {
    options.isolateWorkers = true;
  }
  if (poolOptions.singleThread || !ctx.config.fileParallelism) {
    options.maxThreads = 1;
    options.minThreads = 1;
  }
  const pool = new Tinypool$1(options);
  const runWithFiles = (name) => {
    let id = 0;
    async function runFiles(project, config, files, environment, invalidates = []) {
      ctx.state.clearFiles(project, files);
      const { workerPort, port } = createWorkerChannel$1(project);
      const workerId = ++id;
      const data = {
        pool: "threads",
        worker,
        port: workerPort,
        config,
        files,
        invalidates,
        environment,
        workerId,
        projectName: project.getName(),
        providedContext: project.getProvidedContext()
      };
      try {
        await pool.run(data, { transferList: [workerPort], name });
      } catch (error) {
        if (error instanceof Error && /Failed to terminate worker/.test(error.message)) {
          ctx.state.addProcessTimeoutCause(
            `Failed to terminate worker while running ${files.join(
              ", "
            )}. 
See https://vitest.dev/guide/common-errors.html#failed-to-terminate-worker for troubleshooting.`
          );
        } else if (ctx.isCancelling && error instanceof Error && /The task has been cancelled/.test(error.message)) {
          ctx.state.cancelFiles(files, project);
        } else {
          throw error;
        }
      } finally {
        port.close();
        workerPort.close();
      }
    }
    return async (specs, invalidates) => {
      ctx.onCancel(() => pool.cancelPendingTasks());
      const configs = /* @__PURE__ */ new Map();
      const getConfig = (project) => {
        if (configs.has(project)) {
          return configs.get(project);
        }
        const config = project.getSerializableConfig();
        configs.set(project, config);
        return config;
      };
      const workspaceMap = /* @__PURE__ */ new Map();
      for (const [project, file] of specs) {
        const workspaceFiles = workspaceMap.get(file) ?? [];
        workspaceFiles.push(project);
        workspaceMap.set(file, workspaceFiles);
      }
      const singleThreads = specs.filter(
        ([project]) => project.config.poolOptions?.threads?.singleThread
      );
      const multipleThreads = specs.filter(
        ([project]) => !project.config.poolOptions?.threads?.singleThread
      );
      if (multipleThreads.length) {
        const filesByEnv = await groupFilesByEnv(multipleThreads);
        const files = Object.values(filesByEnv).flat();
        const results = [];
        if (isolated) {
          results.push(
            ...await Promise.allSettled(
              files.map(
                ({ file, environment, project }) => runFiles(
                  project,
                  getConfig(project),
                  [file],
                  environment,
                  invalidates
                )
              )
            )
          );
        } else {
          const grouped = groupBy(
            files,
            ({ project, environment }) => project.getName() + environment.name + JSON.stringify(environment.options)
          );
          for (const group of Object.values(grouped)) {
            results.push(
              ...await Promise.allSettled(
                group.map(
                  ({ file, environment, project }) => runFiles(
                    project,
                    getConfig(project),
                    [file],
                    environment,
                    invalidates
                  )
                )
              )
            );
            await new Promise(
              (resolve2) => pool.queueSize === 0 ? resolve2() : pool.once("drain", resolve2)
            );
            await pool.recycleWorkers();
          }
        }
        const errors = results.filter((r) => r.status === "rejected").map((r) => r.reason);
        if (errors.length > 0) {
          throw new AggregateErrorPonyfill(
            errors,
            "Errors occurred while running tests. For more information, see serialized error."
          );
        }
      }
      if (singleThreads.length) {
        const filesByEnv = await groupFilesByEnv(singleThreads);
        const envs = envsOrder.concat(
          Object.keys(filesByEnv).filter((env2) => !envsOrder.includes(env2))
        );
        for (const env2 of envs) {
          const files = filesByEnv[env2];
          if (!files?.length) {
            continue;
          }
          const filesByOptions = groupBy(
            files,
            ({ project, environment }) => project.getName() + JSON.stringify(environment.options)
          );
          for (const files2 of Object.values(filesByOptions)) {
            await pool.recycleWorkers();
            const filenames = files2.map((f) => f.file);
            await runFiles(
              files2[0].project,
              getConfig(files2[0].project),
              filenames,
              files2[0].environment,
              invalidates
            );
          }
        }
      }
    };
  };
  return {
    name: "threads",
    runTests: runWithFiles("run"),
    collectTests: runWithFiles("collect"),
    close: () => pool.destroy()
  };
}

function getDefaultThreadsCount(config) {
  const numCpus = typeof nodeos.availableParallelism === "function" ? nodeos.availableParallelism() : nodeos.cpus().length;
  return config.watch ? Math.max(Math.floor(numCpus / 2), 1) : Math.max(numCpus - 1, 1);
}
function getWorkerMemoryLimit(config) {
  const memoryLimit = config.poolOptions?.vmThreads?.memoryLimit;
  if (memoryLimit) {
    return memoryLimit;
  }
  return 1 / (config.poolOptions?.vmThreads?.maxThreads ?? getDefaultThreadsCount(config));
}
function stringToBytes(input, percentageReference) {
  if (input === null || input === void 0) {
    return input;
  }
  if (typeof input === "string") {
    if (Number.isNaN(Number.parseFloat(input.slice(-1)))) {
      let [, numericString, trailingChars] = input.match(/(.*?)([^0-9.-]+)$/) || [];
      if (trailingChars && numericString) {
        const numericValue = Number.parseFloat(numericString);
        trailingChars = trailingChars.toLowerCase();
        switch (trailingChars) {
          case "%":
            input = numericValue / 100;
            break;
          case "kb":
          case "k":
            return numericValue * 1e3;
          case "kib":
            return numericValue * 1024;
          case "mb":
          case "m":
            return numericValue * 1e3 * 1e3;
          case "mib":
            return numericValue * 1024 * 1024;
          case "gb":
          case "g":
            return numericValue * 1e3 * 1e3 * 1e3;
          case "gib":
            return numericValue * 1024 * 1024 * 1024;
        }
      }
    } else {
      input = Number.parseFloat(input);
    }
  }
  if (typeof input === "number") {
    if (input <= 1 && input > 0) {
      if (percentageReference) {
        return Math.floor(input * percentageReference);
      } else {
        throw new Error(
          "For a percentage based memory limit a percentageReference must be supplied"
        );
      }
    } else if (input > 1) {
      return Math.floor(input);
    } else {
      throw new Error('Unexpected numerical input for "memoryLimit"');
    }
  }
  return null;
}

const suppressWarningsPath$1 = resolve(rootDir, "./suppress-warnings.cjs");
function createWorkerChannel(project) {
  const channel = new MessageChannel();
  const port = channel.port2;
  const workerPort = channel.port1;
  const rpc = createBirpc(createMethodsRPC(project), {
    eventNames: ["onCancel"],
    post(v) {
      port.postMessage(v);
    },
    on(fn) {
      port.on("message", fn);
    },
    onTimeoutError(functionName) {
      throw new Error(`[vitest-pool]: Timeout calling "${functionName}"`);
    }
  });
  project.ctx.onCancel((reason) => rpc.onCancel(reason));
  return { workerPort, port };
}
function createVmThreadsPool(ctx, { execArgv, env }) {
  const numCpus = typeof nodeos.availableParallelism === "function" ? nodeos.availableParallelism() : nodeos.cpus().length;
  const threadsCount = ctx.config.watch ? Math.max(Math.floor(numCpus / 2), 1) : Math.max(numCpus - 1, 1);
  const poolOptions = ctx.config.poolOptions?.vmThreads ?? {};
  const maxThreads = poolOptions.maxThreads ?? ctx.config.maxWorkers ?? threadsCount;
  const minThreads = poolOptions.minThreads ?? ctx.config.minWorkers ?? threadsCount;
  const worker = resolve(ctx.distPath, "workers/vmThreads.js");
  const options = {
    filename: resolve(ctx.distPath, "worker.js"),
    // TODO: investigate further
    // It seems atomics introduced V8 Fatal Error https://github.com/vitest-dev/vitest/issues/1191
    useAtomics: poolOptions.useAtomics ?? false,
    maxThreads,
    minThreads,
    env,
    execArgv: [
      "--experimental-import-meta-resolve",
      "--experimental-vm-modules",
      "--require",
      suppressWarningsPath$1,
      ...poolOptions.execArgv ?? [],
      ...execArgv
    ],
    terminateTimeout: ctx.config.teardownTimeout,
    concurrentTasksPerWorker: 1,
    maxMemoryLimitBeforeRecycle: getMemoryLimit$1(ctx.config) || void 0
  };
  if (poolOptions.singleThread || !ctx.config.fileParallelism) {
    options.maxThreads = 1;
    options.minThreads = 1;
  }
  const pool = new Tinypool$1(options);
  const runWithFiles = (name) => {
    let id = 0;
    async function runFiles(project, config, files, environment, invalidates = []) {
      ctx.state.clearFiles(project, files);
      const { workerPort, port } = createWorkerChannel(project);
      const workerId = ++id;
      const data = {
        pool: "vmThreads",
        worker,
        port: workerPort,
        config,
        files,
        invalidates,
        environment,
        workerId,
        projectName: project.getName(),
        providedContext: project.getProvidedContext()
      };
      try {
        await pool.run(data, { transferList: [workerPort], name });
      } catch (error) {
        if (error instanceof Error && /Failed to terminate worker/.test(error.message)) {
          ctx.state.addProcessTimeoutCause(
            `Failed to terminate worker while running ${files.join(
              ", "
            )}. 
See https://vitest.dev/guide/common-errors.html#failed-to-terminate-worker for troubleshooting.`
          );
        } else if (ctx.isCancelling && error instanceof Error && /The task has been cancelled/.test(error.message)) {
          ctx.state.cancelFiles(files, project);
        } else {
          throw error;
        }
      } finally {
        port.close();
        workerPort.close();
      }
    }
    return async (specs, invalidates) => {
      ctx.onCancel(() => pool.cancelPendingTasks());
      const configs = /* @__PURE__ */ new Map();
      const getConfig = (project) => {
        if (configs.has(project)) {
          return configs.get(project);
        }
        const config = project.getSerializableConfig();
        configs.set(project, config);
        return config;
      };
      const filesByEnv = await groupFilesByEnv(specs);
      const promises = Object.values(filesByEnv).flat();
      const results = await Promise.allSettled(
        promises.map(
          ({ file, environment, project }) => runFiles(
            project,
            getConfig(project),
            [file],
            environment,
            invalidates
          )
        )
      );
      const errors = results.filter((r) => r.status === "rejected").map((r) => r.reason);
      if (errors.length > 0) {
        throw new AggregateErrorPonyfill(
          errors,
          "Errors occurred while running tests. For more information, see serialized error."
        );
      }
    };
  };
  return {
    name: "vmThreads",
    runTests: runWithFiles("run"),
    collectTests: runWithFiles("collect"),
    close: () => pool.destroy()
  };
}
function getMemoryLimit$1(config) {
  const memory = nodeos.totalmem();
  const limit = getWorkerMemoryLimit(config);
  if (typeof memory === "number") {
    return stringToBytes(limit, config.watch ? memory / 2 : memory);
  }
  if (typeof limit === "number" && limit > 1 || typeof limit === "string" && limit.at(-1) !== "%") {
    return stringToBytes(limit);
  }
  return null;
}

function createTypecheckPool(ctx) {
  const promisesMap = /* @__PURE__ */ new WeakMap();
  const rerunTriggered = /* @__PURE__ */ new WeakMap();
  async function onParseEnd(project, { files, sourceErrors }) {
    const checker = project.typechecker;
    await ctx.report("onTaskUpdate", checker.getTestPacks());
    if (!project.config.typecheck.ignoreSourceErrors) {
      sourceErrors.forEach(
        (error) => ctx.state.catchError(error, "Unhandled Source Error")
      );
    }
    const processError = !hasFailed(files) && !sourceErrors.length && checker.getExitCode();
    if (processError) {
      const error = new Error(checker.getOutput());
      error.stack = "";
      ctx.state.catchError(error, "Typecheck Error");
    }
    promisesMap.get(project)?.resolve();
    rerunTriggered.set(project, false);
    if (ctx.config.watch && !ctx.runningPromise) {
      await ctx.report("onFinished", files, []);
      await ctx.report("onWatcherStart", files, [
        ...project.config.typecheck.ignoreSourceErrors ? [] : sourceErrors,
        ...ctx.state.getUnhandledErrors()
      ]);
    }
  }
  async function createWorkspaceTypechecker(project, files) {
    const checker = project.typechecker ?? new Typechecker(project);
    if (project.typechecker) {
      return checker;
    }
    project.typechecker = checker;
    checker.setFiles(files);
    checker.onParseStart(async () => {
      ctx.state.collectFiles(project, checker.getTestFiles());
      await ctx.report("onCollected");
    });
    checker.onParseEnd((result) => onParseEnd(project, result));
    checker.onWatcherRerun(async () => {
      rerunTriggered.set(project, true);
      if (!ctx.runningPromise) {
        ctx.state.clearErrors();
        await ctx.report(
          "onWatcherRerun",
          files,
          "File change detected. Triggering rerun."
        );
      }
      await checker.collectTests();
      ctx.state.collectFiles(project, checker.getTestFiles());
      await ctx.report("onTaskUpdate", checker.getTestPacks());
      await ctx.report("onCollected");
    });
    await checker.prepare();
    return checker;
  }
  async function startTypechecker(project, files) {
    if (project.typechecker) {
      return project.typechecker;
    }
    const checker = await createWorkspaceTypechecker(project, files);
    await checker.collectTests();
    await checker.start();
  }
  async function collectTests(specs) {
    const specsByProject = groupBy(specs, ([project]) => project.getName());
    for (const name in specsByProject) {
      const project = specsByProject[name][0][0];
      const files = specsByProject[name].map(([_, file]) => file);
      const checker = await createWorkspaceTypechecker(project, files);
      checker.setFiles(files);
      await checker.collectTests();
      ctx.state.collectFiles(project, checker.getTestFiles());
      await ctx.report("onCollected");
    }
  }
  async function runTests(specs) {
    const specsByProject = groupBy(specs, ([project]) => project.getName());
    const promises = [];
    for (const name in specsByProject) {
      const project = specsByProject[name][0][0];
      const files = specsByProject[name].map(([_, file]) => file);
      const promise = createDefer();
      const _p = new Promise((resolve) => {
        const _i = setInterval(() => {
          if (!project.typechecker || rerunTriggered.get(project)) {
            resolve(true);
            clearInterval(_i);
          }
        });
        setTimeout(() => {
          resolve(false);
          clearInterval(_i);
        }, 500).unref();
      });
      const triggered = await _p;
      if (project.typechecker && !triggered) {
        ctx.state.collectFiles(project, project.typechecker.getTestFiles());
        await ctx.report("onCollected");
        await onParseEnd(project, project.typechecker.getResult());
        continue;
      }
      promises.push(promise);
      promisesMap.set(project, promise);
      startTypechecker(project, files);
    }
    await Promise.all(promises);
  }
  return {
    name: "typescript",
    runTests,
    collectTests,
    async close() {
      const promises = ctx.projects.map(
        (project) => project.typechecker?.stop()
      );
      await Promise.all(promises);
    }
  };
}

const suppressWarningsPath = resolve(rootDir, "./suppress-warnings.cjs");
function createChildProcessChannel(project) {
  const emitter = new EventEmitter$2();
  const cleanup = () => emitter.removeAllListeners();
  const events = { message: "message", response: "response" };
  const channel = {
    onMessage: (callback) => emitter.on(events.message, callback),
    postMessage: (message) => emitter.emit(events.response, message)
  };
  const rpc = createBirpc(
    createMethodsRPC(project, { cacheFs: true }),
    {
      eventNames: ["onCancel"],
      serialize: v8.serialize,
      deserialize: (v) => v8.deserialize(Buffer.from(v)),
      post(v) {
        emitter.emit(events.message, v);
      },
      on(fn) {
        emitter.on(events.response, fn);
      },
      onTimeoutError(functionName) {
        throw new Error(`[vitest-pool]: Timeout calling "${functionName}"`);
      }
    }
  );
  project.ctx.onCancel((reason) => rpc.onCancel(reason));
  return { channel, cleanup };
}
function createVmForksPool(ctx, { execArgv, env }) {
  const numCpus = typeof nodeos.availableParallelism === "function" ? nodeos.availableParallelism() : nodeos.cpus().length;
  const threadsCount = ctx.config.watch ? Math.max(Math.floor(numCpus / 2), 1) : Math.max(numCpus - 1, 1);
  const poolOptions = ctx.config.poolOptions?.vmForks ?? {};
  const maxThreads = poolOptions.maxForks ?? ctx.config.maxWorkers ?? threadsCount;
  const minThreads = poolOptions.maxForks ?? ctx.config.minWorkers ?? threadsCount;
  const worker = resolve(ctx.distPath, "workers/vmForks.js");
  const options = {
    runtime: "child_process",
    filename: resolve(ctx.distPath, "worker.js"),
    maxThreads,
    minThreads,
    env,
    execArgv: [
      "--experimental-import-meta-resolve",
      "--experimental-vm-modules",
      "--require",
      suppressWarningsPath,
      ...poolOptions.execArgv ?? [],
      ...execArgv
    ],
    terminateTimeout: ctx.config.teardownTimeout,
    concurrentTasksPerWorker: 1,
    maxMemoryLimitBeforeRecycle: getMemoryLimit(ctx.config) || void 0
  };
  if (poolOptions.singleFork || !ctx.config.fileParallelism) {
    options.maxThreads = 1;
    options.minThreads = 1;
  }
  const pool = new Tinypool$1(options);
  const runWithFiles = (name) => {
    let id = 0;
    async function runFiles(project, config, files, environment, invalidates = []) {
      ctx.state.clearFiles(project, files);
      const { channel, cleanup } = createChildProcessChannel(project);
      const workerId = ++id;
      const data = {
        pool: "forks",
        worker,
        config,
        files,
        invalidates,
        environment,
        workerId,
        projectName: project.getName(),
        providedContext: project.getProvidedContext()
      };
      try {
        await pool.run(data, { name, channel });
      } catch (error) {
        if (error instanceof Error && /Failed to terminate worker/.test(error.message)) {
          ctx.state.addProcessTimeoutCause(
            `Failed to terminate worker while running ${files.join(", ")}.`
          );
        } else if (ctx.isCancelling && error instanceof Error && /The task has been cancelled/.test(error.message)) {
          ctx.state.cancelFiles(files, project);
        } else {
          throw error;
        }
      } finally {
        cleanup();
      }
    }
    return async (specs, invalidates) => {
      ctx.onCancel(() => pool.cancelPendingTasks());
      const configs = /* @__PURE__ */ new Map();
      const getConfig = (project) => {
        if (configs.has(project)) {
          return configs.get(project);
        }
        const _config = project.getSerializableConfig();
        const config = wrapSerializableConfig(_config);
        configs.set(project, config);
        return config;
      };
      const filesByEnv = await groupFilesByEnv(specs);
      const promises = Object.values(filesByEnv).flat();
      const results = await Promise.allSettled(
        promises.map(
          ({ file, environment, project }) => runFiles(
            project,
            getConfig(project),
            [file],
            environment,
            invalidates
          )
        )
      );
      const errors = results.filter((r) => r.status === "rejected").map((r) => r.reason);
      if (errors.length > 0) {
        throw new AggregateErrorPonyfill(
          errors,
          "Errors occurred while running tests. For more information, see serialized error."
        );
      }
    };
  };
  return {
    name: "vmForks",
    runTests: runWithFiles("run"),
    collectTests: runWithFiles("collect"),
    close: () => pool.destroy()
  };
}
function getMemoryLimit(config) {
  const memory = nodeos.totalmem();
  const limit = getWorkerMemoryLimit(config);
  if (typeof memory === "number") {
    return stringToBytes(limit, config.watch ? memory / 2 : memory);
  }
  if (typeof limit === "number" && limit > 1 || typeof limit === "string" && limit.at(-1) !== "%") {
    return stringToBytes(limit);
  }
  return null;
}

const builtinPools = [
  "forks",
  "threads",
  "browser",
  "vmThreads",
  "vmForks",
  "typescript"
];
function getDefaultPoolName(project, file) {
  if (project.config.typecheck.enabled) {
    for (const glob of project.config.typecheck.include) {
      if (mm.isMatch(file, glob, { cwd: project.config.root })) {
        return "typescript";
      }
    }
  }
  if (project.config.browser.enabled) {
    return "browser";
  }
  return project.config.pool;
}
function getFilePoolName(project, file) {
  for (const [glob, pool] of project.config.poolMatchGlobs) {
    if (pool === "browser") {
      throw new Error(
        'Since Vitest 0.31.0 "browser" pool is not supported in "poolMatchGlobs". You can create a workspace to run some of your tests in browser in parallel. Read more: https://vitest.dev/guide/workspace'
      );
    }
    if (mm.isMatch(file, glob, { cwd: project.config.root })) {
      return pool;
    }
  }
  return getDefaultPoolName(project, file);
}
function createPool(ctx) {
  const pools = {
    forks: null,
    threads: null,
    browser: null,
    vmThreads: null,
    vmForks: null,
    typescript: null
  };
  const potentialConditions = /* @__PURE__ */ new Set([
    "production",
    "development",
    ...ctx.server.config.resolve.conditions
  ]);
  const conditions = [...potentialConditions].filter((condition) => {
    if (condition === "production") {
      return ctx.server.config.isProduction;
    }
    if (condition === "development") {
      return !ctx.server.config.isProduction;
    }
    return true;
  }).flatMap((c) => ["--conditions", c]);
  const execArgv = process.execArgv.filter(
    (execArg) => execArg.startsWith("--cpu-prof") || execArg.startsWith("--heap-prof") || execArg.startsWith("--diagnostic-dir")
  );
  async function executeTests(method, files, invalidate) {
    const options = {
      execArgv: [...execArgv, ...conditions],
      env: {
        TEST: "true",
        VITEST: "true",
        NODE_ENV: process.env.NODE_ENV || "test",
        VITEST_MODE: ctx.config.watch ? "WATCH" : "RUN",
        ...process.env,
        ...ctx.config.env
      }
    };
    if (isWindows) {
      for (const name in options.env) {
        options.env[name.toUpperCase()] = options.env[name];
      }
    }
    const customPools = /* @__PURE__ */ new Map();
    async function resolveCustomPool(filepath) {
      if (customPools.has(filepath)) {
        return customPools.get(filepath);
      }
      const pool = await ctx.runner.executeId(filepath);
      if (typeof pool.default !== "function") {
        throw new TypeError(
          `Custom pool "${filepath}" must export a function as default export`
        );
      }
      const poolInstance = await pool.default(ctx, options);
      if (typeof poolInstance?.name !== "string") {
        throw new TypeError(
          `Custom pool "${filepath}" should return an object with "name" property`
        );
      }
      if (typeof poolInstance?.[method] !== "function") {
        throw new TypeError(
          `Custom pool "${filepath}" should return an object with "${method}" method`
        );
      }
      customPools.set(filepath, poolInstance);
      return poolInstance;
    }
    const filesByPool = {
      forks: [],
      threads: [],
      // browser: [],
      vmThreads: [],
      vmForks: [],
      typescript: []
    };
    const factories = {
      // browser: () => createBrowserPool(ctx),
      vmThreads: () => createVmThreadsPool(ctx, options),
      threads: () => createThreadsPool(ctx, options),
      forks: () => createForksPool(ctx, options),
      vmForks: () => createVmForksPool(ctx, options),
      typescript: () => createTypecheckPool(ctx)
    };
    for (const spec of files) {
      const pool = getFilePoolName(spec[0], spec[1]);
      filesByPool[pool] ??= [];
      filesByPool[pool].push(spec);
    }
    const Sequencer = ctx.config.sequence.sequencer;
    const sequencer = new Sequencer(ctx);
    async function sortSpecs(specs) {
      if (ctx.config.shard) {
        specs = await sequencer.shard(specs);
      }
      return sequencer.sort(specs);
    }
    await Promise.all(
      Object.entries(filesByPool).map(async (entry) => {
        const [pool, files2] = entry;
        if (!files2.length) {
          return null;
        }
        const specs = await sortSpecs(files2);
        if (pool in factories) {
          const factory = factories[pool];
          pools[pool] ??= factory();
          return pools[pool][method](specs, invalidate);
        }
        if (pool === "browser") {
          pools[pool] ??= await (async () => {
            const { createBrowserPool } = await import('@vitest/browser');
            return createBrowserPool(ctx);
          })();
          return pools[pool][method](specs, invalidate);
        }
        const poolHandler = await resolveCustomPool(pool);
        pools[poolHandler.name] ??= poolHandler;
        return poolHandler[method](specs, invalidate);
      })
    );
  }
  return {
    name: "default",
    runTests: (files, invalidates) => executeTests("runTests", files, invalidates),
    collectTests: (files, invalidates) => executeTests("collectTests", files, invalidates),
    async close() {
      await Promise.all(Object.values(pools).map((p) => p?.close?.()));
    }
  };
}

async function loadCustomReporterModule(path, runner) {
  let customReporterModule;
  try {
    customReporterModule = await runner.executeId(path);
  } catch (customReporterModuleError) {
    throw new Error(`Failed to load custom Reporter from ${path}`, {
      cause: customReporterModuleError
    });
  }
  if (customReporterModule.default === null || customReporterModule.default === void 0) {
    throw new Error(
      `Custom reporter loaded from ${path} was not the default export`
    );
  }
  return customReporterModule.default;
}
function createReporters(reporterReferences, ctx) {
  const runner = ctx.runner;
  const promisedReporters = reporterReferences.map(
    async (referenceOrInstance) => {
      if (Array.isArray(referenceOrInstance)) {
        const [reporterName, reporterOptions] = referenceOrInstance;
        if (reporterName === "html") {
          await ctx.packageInstaller.ensureInstalled("@vitest/ui", runner.root);
          const CustomReporter = await loadCustomReporterModule(
            "@vitest/ui/reporter",
            runner
          );
          return new CustomReporter(reporterOptions);
        } else if (reporterName in ReportersMap) {
          const BuiltinReporter = ReportersMap[reporterName];
          return new BuiltinReporter(reporterOptions);
        } else {
          const CustomReporter = await loadCustomReporterModule(
            reporterName,
            runner
          );
          return new CustomReporter(reporterOptions);
        }
      }
      return referenceOrInstance;
    }
  );
  return Promise.all(promisedReporters);
}
function createBenchmarkReporters(reporterReferences, runner) {
  const promisedReporters = reporterReferences.map(
    async (referenceOrInstance) => {
      if (typeof referenceOrInstance === "string") {
        if (referenceOrInstance in BenchmarkReportsMap) {
          const BuiltinReporter = BenchmarkReportsMap[referenceOrInstance];
          return new BuiltinReporter();
        } else {
          const CustomReporter = await loadCustomReporterModule(
            referenceOrInstance,
            runner
          );
          return new CustomReporter();
        }
      }
      return referenceOrInstance;
    }
  );
  return Promise.all(promisedReporters);
}

function isAggregateError(err) {
  if (typeof AggregateError !== "undefined" && err instanceof AggregateError) {
    return true;
  }
  return err instanceof Error && "errors" in err;
}
class StateManager {
  filesMap = /* @__PURE__ */ new Map();
  pathsSet = /* @__PURE__ */ new Set();
  idMap = /* @__PURE__ */ new Map();
  taskFileMap = /* @__PURE__ */ new WeakMap();
  errorsSet = /* @__PURE__ */ new Set();
  processTimeoutCauses = /* @__PURE__ */ new Set();
  reportedTasksMap = /* @__PURE__ */ new WeakMap();
  catchError(err, type) {
    if (isAggregateError(err)) {
      return err.errors.forEach((error) => this.catchError(error, type));
    }
    if (err === Object(err)) {
      err.type = type;
    } else {
      err = { type, message: err };
    }
    const _err = err;
    if (_err && typeof _err === "object" && _err.code === "VITEST_PENDING") {
      const task = this.idMap.get(_err.taskId);
      if (task) {
        task.mode = "skip";
        task.result ??= { state: "skip" };
        task.result.state = "skip";
      }
      return;
    }
    this.errorsSet.add(err);
  }
  clearErrors() {
    this.errorsSet.clear();
  }
  getUnhandledErrors() {
    return Array.from(this.errorsSet.values());
  }
  addProcessTimeoutCause(cause) {
    this.processTimeoutCauses.add(cause);
  }
  getProcessTimeoutCauses() {
    return Array.from(this.processTimeoutCauses.values());
  }
  getPaths() {
    return Array.from(this.pathsSet);
  }
  /**
   * Return files that were running or collected.
   */
  getFiles(keys) {
    if (keys) {
      return keys.map((key) => this.filesMap.get(key)).flat().filter((file) => file && !file.local);
    }
    return Array.from(this.filesMap.values()).flat().filter((file) => !file.local);
  }
  getFilepaths() {
    return Array.from(this.filesMap.keys());
  }
  getFailedFilepaths() {
    return this.getFiles().filter((i) => i.result?.state === "fail").map((i) => i.filepath);
  }
  collectPaths(paths = []) {
    paths.forEach((path) => {
      this.pathsSet.add(path);
    });
  }
  collectFiles(project, files = []) {
    files.forEach((file) => {
      const existing = this.filesMap.get(file.filepath) || [];
      const otherProject = existing.filter(
        (i) => i.projectName !== file.projectName
      );
      const currentFile = existing.find(
        (i) => i.projectName === file.projectName
      );
      if (currentFile) {
        file.logs = currentFile.logs;
      }
      otherProject.push(file);
      this.filesMap.set(file.filepath, otherProject);
      this.updateId(file, project);
    });
  }
  clearFiles(project, paths = []) {
    paths.forEach((path) => {
      const files = this.filesMap.get(path);
      const fileTask = createFileTask(
        path,
        project.config.root,
        project.config.name
      );
      fileTask.local = true;
      TestFile.register(fileTask, project);
      this.idMap.set(fileTask.id, fileTask);
      if (!files) {
        this.filesMap.set(path, [fileTask]);
        return;
      }
      const filtered = files.filter(
        (file) => file.projectName !== project.config.name
      );
      if (!filtered.length) {
        this.filesMap.set(path, [fileTask]);
      } else {
        this.filesMap.set(path, [...filtered, fileTask]);
      }
    });
  }
  updateId(task, project) {
    if (this.idMap.get(task.id) === task) {
      return;
    }
    if (task.type === "suite" && "filepath" in task) {
      TestFile.register(task, project);
    } else if (task.type === "suite") {
      TestSuite.register(task, project);
    } else {
      TestCase.register(task, project);
    }
    this.idMap.set(task.id, task);
    if (task.type === "suite") {
      task.tasks.forEach((task2) => {
        this.updateId(task2, project);
      });
    }
  }
  getReportedEntity(task) {
    return this.reportedTasksMap.get(task);
  }
  updateTasks(packs) {
    for (const [id, result, meta] of packs) {
      const task = this.idMap.get(id);
      if (task) {
        task.result = result;
        task.meta = meta;
        if (result?.state === "skip") {
          task.mode = "skip";
        }
      }
    }
  }
  updateUserLog(log) {
    const task = log.taskId && this.idMap.get(log.taskId);
    if (task) {
      if (!task.logs) {
        task.logs = [];
      }
      task.logs.push(log);
    }
  }
  getCountOfFailedTests() {
    return Array.from(this.idMap.values()).filter(
      (t) => t.result?.state === "fail"
    ).length;
  }
  cancelFiles(files, project) {
    this.collectFiles(
      project,
      files.map(
        (filepath) => createFileTask(filepath, project.config.root, project.config.name)
      )
    );
  }
}

const JOIN_LEADING_SLASH_RE = /^\.?\//;
function withTrailingSlash(input = "", respectQueryAndFragment) {
  {
    return input.endsWith("/") ? input : input + "/";
  }
}
function isNonEmptyURL(url) {
  return url && url !== "/";
}
function joinURL(base, ...input) {
  let url = base || "";
  for (const segment of input.filter((url2) => isNonEmptyURL(url2))) {
    if (url) {
      const _segment = segment.replace(JOIN_LEADING_SLASH_RE, "");
      url = withTrailingSlash(url) + _segment;
    } else {
      url = segment;
    }
  }
  return url;
}

const BUILTIN_MODULES = new Set(builtinModules);
function normalizeSlash(path) {
  return path.replace(/\\/g, "/");
}

/**
 * @typedef ErrnoExceptionFields
 * @property {number | undefined} [errnode]
 * @property {string | undefined} [code]
 * @property {string | undefined} [path]
 * @property {string | undefined} [syscall]
 * @property {string | undefined} [url]
 *
 * @typedef {Error & ErrnoExceptionFields} ErrnoException
 */


const own$1 = {}.hasOwnProperty;

const classRegExp = /^([A-Z][a-z\d]*)+$/;
// Sorted by a rough estimate on most frequently used entries.
const kTypes = new Set([
  'string',
  'function',
  'number',
  'object',
  // Accept 'Function' and 'Object' as alternative to the lower cased version.
  'Function',
  'Object',
  'boolean',
  'bigint',
  'symbol'
]);

const codes = {};

/**
 * Create a list string in the form like 'A and B' or 'A, B, ..., and Z'.
 * We cannot use Intl.ListFormat because it's not available in
 * --without-intl builds.
 *
 * @param {Array<string>} array
 *   An array of strings.
 * @param {string} [type]
 *   The list type to be inserted before the last element.
 * @returns {string}
 */
function formatList(array, type = 'and') {
  return array.length < 3
    ? array.join(` ${type} `)
    : `${array.slice(0, -1).join(', ')}, ${type} ${array[array.length - 1]}`
}

/** @type {Map<string, MessageFunction | string>} */
const messages = new Map();
const nodeInternalPrefix = '__node_internal_';
/** @type {number} */
let userStackTraceLimit;

codes.ERR_INVALID_ARG_TYPE = createError(
  'ERR_INVALID_ARG_TYPE',
  /**
   * @param {string} name
   * @param {Array<string> | string} expected
   * @param {unknown} actual
   */
  (name, expected, actual) => {
    assert(typeof name === 'string', "'name' must be a string");
    if (!Array.isArray(expected)) {
      expected = [expected];
    }

    let message = 'The ';
    if (name.endsWith(' argument')) {
      // For cases like 'first argument'
      message += `${name} `;
    } else {
      const type = name.includes('.') ? 'property' : 'argument';
      message += `"${name}" ${type} `;
    }

    message += 'must be ';

    /** @type {Array<string>} */
    const types = [];
    /** @type {Array<string>} */
    const instances = [];
    /** @type {Array<string>} */
    const other = [];

    for (const value of expected) {
      assert(
        typeof value === 'string',
        'All expected entries have to be of type string'
      );

      if (kTypes.has(value)) {
        types.push(value.toLowerCase());
      } else if (classRegExp.exec(value) === null) {
        assert(
          value !== 'object',
          'The value "object" should be written as "Object"'
        );
        other.push(value);
      } else {
        instances.push(value);
      }
    }

    // Special handle `object` in case other instances are allowed to outline
    // the differences between each other.
    if (instances.length > 0) {
      const pos = types.indexOf('object');
      if (pos !== -1) {
        types.slice(pos, 1);
        instances.push('Object');
      }
    }

    if (types.length > 0) {
      message += `${types.length > 1 ? 'one of type' : 'of type'} ${formatList(
        types,
        'or'
      )}`;
      if (instances.length > 0 || other.length > 0) message += ' or ';
    }

    if (instances.length > 0) {
      message += `an instance of ${formatList(instances, 'or')}`;
      if (other.length > 0) message += ' or ';
    }

    if (other.length > 0) {
      if (other.length > 1) {
        message += `one of ${formatList(other, 'or')}`;
      } else {
        if (other[0].toLowerCase() !== other[0]) message += 'an ';
        message += `${other[0]}`;
      }
    }

    message += `. Received ${determineSpecificType(actual)}`;

    return message
  },
  TypeError
);

codes.ERR_INVALID_MODULE_SPECIFIER = createError(
  'ERR_INVALID_MODULE_SPECIFIER',
  /**
   * @param {string} request
   * @param {string} reason
   * @param {string} [base]
   */
  (request, reason, base = undefined) => {
    return `Invalid module "${request}" ${reason}${
      base ? ` imported from ${base}` : ''
    }`
  },
  TypeError
);

codes.ERR_INVALID_PACKAGE_CONFIG = createError(
  'ERR_INVALID_PACKAGE_CONFIG',
  /**
   * @param {string} path
   * @param {string} [base]
   * @param {string} [message]
   */
  (path, base, message) => {
    return `Invalid package config ${path}${
      base ? ` while importing ${base}` : ''
    }${message ? `. ${message}` : ''}`
  },
  Error
);

codes.ERR_INVALID_PACKAGE_TARGET = createError(
  'ERR_INVALID_PACKAGE_TARGET',
  /**
   * @param {string} packagePath
   * @param {string} key
   * @param {unknown} target
   * @param {boolean} [isImport=false]
   * @param {string} [base]
   */
  (packagePath, key, target, isImport = false, base = undefined) => {
    const relatedError =
      typeof target === 'string' &&
      !isImport &&
      target.length > 0 &&
      !target.startsWith('./');
    if (key === '.') {
      assert(isImport === false);
      return (
        `Invalid "exports" main target ${JSON.stringify(target)} defined ` +
        `in the package config ${packagePath}package.json${
          base ? ` imported from ${base}` : ''
        }${relatedError ? '; targets must start with "./"' : ''}`
      )
    }

    return `Invalid "${
      isImport ? 'imports' : 'exports'
    }" target ${JSON.stringify(
      target
    )} defined for '${key}' in the package config ${packagePath}package.json${
      base ? ` imported from ${base}` : ''
    }${relatedError ? '; targets must start with "./"' : ''}`
  },
  Error
);

codes.ERR_MODULE_NOT_FOUND = createError(
  'ERR_MODULE_NOT_FOUND',
  /**
   * @param {string} path
   * @param {string} base
   * @param {boolean} [exactUrl]
   */
  (path, base, exactUrl = false) => {
    return `Cannot find ${
      exactUrl ? 'module' : 'package'
    } '${path}' imported from ${base}`
  },
  Error
);

codes.ERR_NETWORK_IMPORT_DISALLOWED = createError(
  'ERR_NETWORK_IMPORT_DISALLOWED',
  "import of '%s' by %s is not supported: %s",
  Error
);

codes.ERR_PACKAGE_IMPORT_NOT_DEFINED = createError(
  'ERR_PACKAGE_IMPORT_NOT_DEFINED',
  /**
   * @param {string} specifier
   * @param {string} packagePath
   * @param {string} base
   */
  (specifier, packagePath, base) => {
    return `Package import specifier "${specifier}" is not defined${
      packagePath ? ` in package ${packagePath}package.json` : ''
    } imported from ${base}`
  },
  TypeError
);

codes.ERR_PACKAGE_PATH_NOT_EXPORTED = createError(
  'ERR_PACKAGE_PATH_NOT_EXPORTED',
  /**
   * @param {string} packagePath
   * @param {string} subpath
   * @param {string} [base]
   */
  (packagePath, subpath, base = undefined) => {
    if (subpath === '.')
      return `No "exports" main defined in ${packagePath}package.json${
        base ? ` imported from ${base}` : ''
      }`
    return `Package subpath '${subpath}' is not defined by "exports" in ${packagePath}package.json${
      base ? ` imported from ${base}` : ''
    }`
  },
  Error
);

codes.ERR_UNSUPPORTED_DIR_IMPORT = createError(
  'ERR_UNSUPPORTED_DIR_IMPORT',
  "Directory import '%s' is not supported " +
    'resolving ES modules imported from %s',
  Error
);

codes.ERR_UNSUPPORTED_RESOLVE_REQUEST = createError(
  'ERR_UNSUPPORTED_RESOLVE_REQUEST',
  'Failed to resolve module specifier "%s" from "%s": Invalid relative URL or base scheme is not hierarchical.',
  TypeError
);

codes.ERR_UNKNOWN_FILE_EXTENSION = createError(
  'ERR_UNKNOWN_FILE_EXTENSION',
  /**
   * @param {string} extension
   * @param {string} path
   */
  (extension, path) => {
    return `Unknown file extension "${extension}" for ${path}`
  },
  TypeError
);

codes.ERR_INVALID_ARG_VALUE = createError(
  'ERR_INVALID_ARG_VALUE',
  /**
   * @param {string} name
   * @param {unknown} value
   * @param {string} [reason='is invalid']
   */
  (name, value, reason = 'is invalid') => {
    let inspected = inspect(value);

    if (inspected.length > 128) {
      inspected = `${inspected.slice(0, 128)}...`;
    }

    const type = name.includes('.') ? 'property' : 'argument';

    return `The ${type} '${name}' ${reason}. Received ${inspected}`
  },
  TypeError
  // Note: extra classes have been shaken out.
  // , RangeError
);

/**
 * Utility function for registering the error codes. Only used here. Exported
 * *only* to allow for testing.
 * @param {string} sym
 * @param {MessageFunction | string} value
 * @param {ErrorConstructor} constructor
 * @returns {new (...parameters: Array<any>) => Error}
 */
function createError(sym, value, constructor) {
  // Special case for SystemError that formats the error message differently
  // The SystemErrors only have SystemError as their base classes.
  messages.set(sym, value);

  return makeNodeErrorWithCode(constructor, sym)
}

/**
 * @param {ErrorConstructor} Base
 * @param {string} key
 * @returns {ErrorConstructor}
 */
function makeNodeErrorWithCode(Base, key) {
  // @ts-expect-error It’s a Node error.
  return NodeError
  /**
   * @param {Array<unknown>} parameters
   */
  function NodeError(...parameters) {
    const limit = Error.stackTraceLimit;
    if (isErrorStackTraceLimitWritable()) Error.stackTraceLimit = 0;
    const error = new Base();
    // Reset the limit and setting the name property.
    if (isErrorStackTraceLimitWritable()) Error.stackTraceLimit = limit;
    const message = getMessage(key, parameters, error);
    Object.defineProperties(error, {
      // Note: no need to implement `kIsNodeError` symbol, would be hard,
      // probably.
      message: {
        value: message,
        enumerable: false,
        writable: true,
        configurable: true
      },
      toString: {
        /** @this {Error} */
        value() {
          return `${this.name} [${key}]: ${this.message}`
        },
        enumerable: false,
        writable: true,
        configurable: true
      }
    });

    captureLargerStackTrace(error);
    // @ts-expect-error It’s a Node error.
    error.code = key;
    return error
  }
}

/**
 * @returns {boolean}
 */
function isErrorStackTraceLimitWritable() {
  // Do no touch Error.stackTraceLimit as V8 would attempt to install
  // it again during deserialization.
  try {
    if (v8.startupSnapshot.isBuildingSnapshot()) {
      return false
    }
  } catch {}

  const desc = Object.getOwnPropertyDescriptor(Error, 'stackTraceLimit');
  if (desc === undefined) {
    return Object.isExtensible(Error)
  }

  return own$1.call(desc, 'writable') && desc.writable !== undefined
    ? desc.writable
    : desc.set !== undefined
}

/**
 * This function removes unnecessary frames from Node.js core errors.
 * @template {(...parameters: unknown[]) => unknown} T
 * @param {T} wrappedFunction
 * @returns {T}
 */
function hideStackFrames(wrappedFunction) {
  // We rename the functions that will be hidden to cut off the stacktrace
  // at the outermost one
  const hidden = nodeInternalPrefix + wrappedFunction.name;
  Object.defineProperty(wrappedFunction, 'name', {value: hidden});
  return wrappedFunction
}

const captureLargerStackTrace = hideStackFrames(
  /**
   * @param {Error} error
   * @returns {Error}
   */
  // @ts-expect-error: fine
  function (error) {
    const stackTraceLimitIsWritable = isErrorStackTraceLimitWritable();
    if (stackTraceLimitIsWritable) {
      userStackTraceLimit = Error.stackTraceLimit;
      Error.stackTraceLimit = Number.POSITIVE_INFINITY;
    }

    Error.captureStackTrace(error);

    // Reset the limit
    if (stackTraceLimitIsWritable) Error.stackTraceLimit = userStackTraceLimit;

    return error
  }
);

/**
 * @param {string} key
 * @param {Array<unknown>} parameters
 * @param {Error} self
 * @returns {string}
 */
function getMessage(key, parameters, self) {
  const message = messages.get(key);
  assert(message !== undefined, 'expected `message` to be found');

  if (typeof message === 'function') {
    assert(
      message.length <= parameters.length, // Default options do not count.
      `Code: ${key}; The provided arguments length (${parameters.length}) does not ` +
        `match the required ones (${message.length}).`
    );
    return Reflect.apply(message, self, parameters)
  }

  const regex = /%[dfijoOs]/g;
  let expectedLength = 0;
  while (regex.exec(message) !== null) expectedLength++;
  assert(
    expectedLength === parameters.length,
    `Code: ${key}; The provided arguments length (${parameters.length}) does not ` +
      `match the required ones (${expectedLength}).`
  );
  if (parameters.length === 0) return message

  parameters.unshift(message);
  return Reflect.apply(format$2, null, parameters)
}

/**
 * Determine the specific type of a value for type-mismatch errors.
 * @param {unknown} value
 * @returns {string}
 */
function determineSpecificType(value) {
  if (value === null || value === undefined) {
    return String(value)
  }

  if (typeof value === 'function' && value.name) {
    return `function ${value.name}`
  }

  if (typeof value === 'object') {
    if (value.constructor && value.constructor.name) {
      return `an instance of ${value.constructor.name}`
    }

    return `${inspect(value, {depth: -1})}`
  }

  let inspected = inspect(value, {colors: false});

  if (inspected.length > 28) {
    inspected = `${inspected.slice(0, 25)}...`;
  }

  return `type ${typeof value} (${inspected})`
}

// Manually “tree shaken” from:
// <https://github.com/nodejs/node/blob/7c3dce0/lib/internal/modules/package_json_reader.js>
// Last checked on: Apr 29, 2023.
// Removed the native dependency.
// Also: no need to cache, we do that in resolve already.


const hasOwnProperty$1 = {}.hasOwnProperty;

const {ERR_INVALID_PACKAGE_CONFIG: ERR_INVALID_PACKAGE_CONFIG$1} = codes;

/** @type {Map<string, PackageConfig>} */
const cache = new Map();

/**
 * @param {string} jsonPath
 * @param {{specifier: URL | string, base?: URL}} options
 * @returns {PackageConfig}
 */
function read(jsonPath, {base, specifier}) {
  const existing = cache.get(jsonPath);

  if (existing) {
    return existing
  }

  /** @type {string | undefined} */
  let string;

  try {
    string = fs$8.readFileSync(path$8.toNamespacedPath(jsonPath), 'utf8');
  } catch (error) {
    const exception = /** @type {ErrnoException} */ (error);

    if (exception.code !== 'ENOENT') {
      throw exception
    }
  }

  /** @type {PackageConfig} */
  const result = {
    exists: false,
    pjsonPath: jsonPath,
    main: undefined,
    name: undefined,
    type: 'none', // Ignore unknown types for forwards compatibility
    exports: undefined,
    imports: undefined
  };

  if (string !== undefined) {
    /** @type {Record<string, unknown>} */
    let parsed;

    try {
      parsed = JSON.parse(string);
    } catch (error_) {
      const cause = /** @type {ErrnoException} */ (error_);
      const error = new ERR_INVALID_PACKAGE_CONFIG$1(
        jsonPath,
        (base ? `"${specifier}" from ` : '') + fileURLToPath$1(base || specifier),
        cause.message
      );
      error.cause = cause;
      throw error
    }

    result.exists = true;

    if (
      hasOwnProperty$1.call(parsed, 'name') &&
      typeof parsed.name === 'string'
    ) {
      result.name = parsed.name;
    }

    if (
      hasOwnProperty$1.call(parsed, 'main') &&
      typeof parsed.main === 'string'
    ) {
      result.main = parsed.main;
    }

    if (hasOwnProperty$1.call(parsed, 'exports')) {
      // @ts-expect-error: assume valid.
      result.exports = parsed.exports;
    }

    if (hasOwnProperty$1.call(parsed, 'imports')) {
      // @ts-expect-error: assume valid.
      result.imports = parsed.imports;
    }

    // Ignore unknown types for forwards compatibility
    if (
      hasOwnProperty$1.call(parsed, 'type') &&
      (parsed.type === 'commonjs' || parsed.type === 'module')
    ) {
      result.type = parsed.type;
    }
  }

  cache.set(jsonPath, result);

  return result
}

/**
 * @param {URL | string} resolved
 * @returns {PackageConfig}
 */
function getPackageScopeConfig(resolved) {
  // Note: in Node, this is now a native module.
  let packageJSONUrl = new URL('package.json', resolved);

  while (true) {
    const packageJSONPath = packageJSONUrl.pathname;
    if (packageJSONPath.endsWith('node_modules/package.json')) {
      break
    }

    const packageConfig = read(fileURLToPath$1(packageJSONUrl), {
      specifier: resolved
    });

    if (packageConfig.exists) {
      return packageConfig
    }

    const lastPackageJSONUrl = packageJSONUrl;
    packageJSONUrl = new URL('../package.json', packageJSONUrl);

    // Terminates at root where ../package.json equals ../../package.json
    // (can't just check "/package.json" for Windows support).
    if (packageJSONUrl.pathname === lastPackageJSONUrl.pathname) {
      break
    }
  }

  const packageJSONPath = fileURLToPath$1(packageJSONUrl);
  // ^^ Note: in Node, this is now a native module.

  return {
    pjsonPath: packageJSONPath,
    exists: false,
    type: 'none'
  }
}

/**
 * Returns the package type for a given URL.
 * @param {URL} url - The URL to get the package type for.
 * @returns {PackageType}
 */
function getPackageType(url) {
  // To do @anonrig: Write a C++ function that returns only "type".
  return getPackageScopeConfig(url).type
}

// Manually “tree shaken” from:
// <https://github.com/nodejs/node/blob/7c3dce0/lib/internal/modules/esm/get_format.js>
// Last checked on: Apr 29, 2023.


const {ERR_UNKNOWN_FILE_EXTENSION} = codes;

const hasOwnProperty = {}.hasOwnProperty;

/** @type {Record<string, string>} */
const extensionFormatMap = {
  // @ts-expect-error: hush.
  __proto__: null,
  '.cjs': 'commonjs',
  '.js': 'module',
  '.json': 'json',
  '.mjs': 'module'
};

/**
 * @param {string | null} mime
 * @returns {string | null}
 */
function mimeToFormat(mime) {
  if (
    mime &&
    /\s*(text|application)\/javascript\s*(;\s*charset=utf-?8\s*)?/i.test(mime)
  )
    return 'module'
  if (mime === 'application/json') return 'json'
  return null
}

/**
 * @callback ProtocolHandler
 * @param {URL} parsed
 * @param {{parentURL: string, source?: Buffer}} context
 * @param {boolean} ignoreErrors
 * @returns {string | null | void}
 */

/**
 * @type {Record<string, ProtocolHandler>}
 */
const protocolHandlers = {
  // @ts-expect-error: hush.
  __proto__: null,
  'data:': getDataProtocolModuleFormat,
  'file:': getFileProtocolModuleFormat,
  'http:': getHttpProtocolModuleFormat,
  'https:': getHttpProtocolModuleFormat,
  'node:'() {
    return 'builtin'
  }
};

/**
 * @param {URL} parsed
 */
function getDataProtocolModuleFormat(parsed) {
  const {1: mime} = /^([^/]+\/[^;,]+)[^,]*?(;base64)?,/.exec(
    parsed.pathname
  ) || [null, null, null];
  return mimeToFormat(mime)
}

/**
 * Returns the file extension from a URL.
 *
 * Should give similar result to
 * `require('node:path').extname(require('node:url').fileURLToPath(url))`
 * when used with a `file:` URL.
 *
 * @param {URL} url
 * @returns {string}
 */
function extname(url) {
  const pathname = url.pathname;
  let index = pathname.length;

  while (index--) {
    const code = pathname.codePointAt(index);

    if (code === 47 /* `/` */) {
      return ''
    }

    if (code === 46 /* `.` */) {
      return pathname.codePointAt(index - 1) === 47 /* `/` */
        ? ''
        : pathname.slice(index)
    }
  }

  return ''
}

/**
 * @type {ProtocolHandler}
 */
function getFileProtocolModuleFormat(url, _context, ignoreErrors) {
  const value = extname(url);

  if (value === '.js') {
    const packageType = getPackageType(url);

    if (packageType !== 'none') {
      return packageType
    }

    return 'commonjs'
  }

  if (value === '') {
    const packageType = getPackageType(url);

    // Legacy behavior
    if (packageType === 'none' || packageType === 'commonjs') {
      return 'commonjs'
    }

    // Note: we don’t implement WASM, so we don’t need
    // `getFormatOfExtensionlessFile` from `formats`.
    return 'module'
  }

  const format = extensionFormatMap[value];
  if (format) return format

  // Explicit undefined return indicates load hook should rerun format check
  if (ignoreErrors) {
    return undefined
  }

  const filepath = fileURLToPath$1(url);
  throw new ERR_UNKNOWN_FILE_EXTENSION(value, filepath)
}

function getHttpProtocolModuleFormat() {
  // To do: HTTPS imports.
}

/**
 * @param {URL} url
 * @param {{parentURL: string}} context
 * @returns {string | null}
 */
function defaultGetFormatWithoutErrors(url, context) {
  const protocol = url.protocol;

  if (!hasOwnProperty.call(protocolHandlers, protocol)) {
    return null
  }

  return protocolHandlers[protocol](url, context, true) || null
}

// Manually “tree shaken” from:
// <https://github.com/nodejs/node/blob/81a9a97/lib/internal/modules/esm/resolve.js>
// Last checked on: Apr 29, 2023.


const RegExpPrototypeSymbolReplace = RegExp.prototype[Symbol.replace];

const {
  ERR_NETWORK_IMPORT_DISALLOWED,
  ERR_INVALID_MODULE_SPECIFIER,
  ERR_INVALID_PACKAGE_CONFIG,
  ERR_INVALID_PACKAGE_TARGET,
  ERR_MODULE_NOT_FOUND,
  ERR_PACKAGE_IMPORT_NOT_DEFINED,
  ERR_PACKAGE_PATH_NOT_EXPORTED,
  ERR_UNSUPPORTED_DIR_IMPORT,
  ERR_UNSUPPORTED_RESOLVE_REQUEST
} = codes;

const own = {}.hasOwnProperty;

const invalidSegmentRegEx =
  /(^|\\|\/)((\.|%2e)(\.|%2e)?|(n|%6e|%4e)(o|%6f|%4f)(d|%64|%44)(e|%65|%45)(_|%5f)(m|%6d|%4d)(o|%6f|%4f)(d|%64|%44)(u|%75|%55)(l|%6c|%4c)(e|%65|%45)(s|%73|%53))?(\\|\/|$)/i;
const deprecatedInvalidSegmentRegEx =
  /(^|\\|\/)((\.|%2e)(\.|%2e)?|(n|%6e|%4e)(o|%6f|%4f)(d|%64|%44)(e|%65|%45)(_|%5f)(m|%6d|%4d)(o|%6f|%4f)(d|%64|%44)(u|%75|%55)(l|%6c|%4c)(e|%65|%45)(s|%73|%53))(\\|\/|$)/i;
const invalidPackageNameRegEx = /^\.|%|\\/;
const patternRegEx = /\*/g;
const encodedSeparatorRegEx = /%2f|%5c/i;
/** @type {Set<string>} */
const emittedPackageWarnings = new Set();

const doubleSlashRegEx = /[/\\]{2}/;

/**
 *
 * @param {string} target
 * @param {string} request
 * @param {string} match
 * @param {URL} packageJsonUrl
 * @param {boolean} internal
 * @param {URL} base
 * @param {boolean} isTarget
 */
function emitInvalidSegmentDeprecation(
  target,
  request,
  match,
  packageJsonUrl,
  internal,
  base,
  isTarget
) {
  // @ts-expect-error: apparently it does exist, TS.
  if (process$1.noDeprecation) {
    return
  }

  const pjsonPath = fileURLToPath$1(packageJsonUrl);
  const double = doubleSlashRegEx.exec(isTarget ? target : request) !== null;
  process$1.emitWarning(
    `Use of deprecated ${
      double ? 'double slash' : 'leading or trailing slash matching'
    } resolving "${target}" for module ` +
      `request "${request}" ${
        request === match ? '' : `matched to "${match}" `
      }in the "${
        internal ? 'imports' : 'exports'
      }" field module resolution of the package at ${pjsonPath}${
        base ? ` imported from ${fileURLToPath$1(base)}` : ''
      }.`,
    'DeprecationWarning',
    'DEP0166'
  );
}

/**
 * @param {URL} url
 * @param {URL} packageJsonUrl
 * @param {URL} base
 * @param {string} [main]
 * @returns {void}
 */
function emitLegacyIndexDeprecation(url, packageJsonUrl, base, main) {
  // @ts-expect-error: apparently it does exist, TS.
  if (process$1.noDeprecation) {
    return
  }

  const format = defaultGetFormatWithoutErrors(url, {parentURL: base.href});
  if (format !== 'module') return
  const urlPath = fileURLToPath$1(url.href);
  const packagePath = fileURLToPath$1(new URL$2('.', packageJsonUrl));
  const basePath = fileURLToPath$1(base);
  if (!main) {
    process$1.emitWarning(
      `No "main" or "exports" field defined in the package.json for ${packagePath} resolving the main entry point "${urlPath.slice(
        packagePath.length
      )}", imported from ${basePath}.\nDefault "index" lookups for the main are deprecated for ES modules.`,
      'DeprecationWarning',
      'DEP0151'
    );
  } else if (path$8.resolve(packagePath, main) !== urlPath) {
    process$1.emitWarning(
      `Package ${packagePath} has a "main" field set to "${main}", ` +
        `excluding the full filename and extension to the resolved file at "${urlPath.slice(
          packagePath.length
        )}", imported from ${basePath}.\n Automatic extension resolution of the "main" field is ` +
        'deprecated for ES modules.',
      'DeprecationWarning',
      'DEP0151'
    );
  }
}

/**
 * @param {string} path
 * @returns {Stats | undefined}
 */
function tryStatSync(path) {
  // Note: from Node 15 onwards we can use `throwIfNoEntry: false` instead.
  try {
    return statSync$1(path)
  } catch {
    // Note: in Node code this returns `new Stats`,
    // but in Node 22 that’s marked as a deprecated internal API.
    // Which, well, we kinda are, but still to prevent that warning,
    // just yield `undefined`.
  }
}

/**
 * Legacy CommonJS main resolution:
 * 1. let M = pkg_url + (json main field)
 * 2. TRY(M, M.js, M.json, M.node)
 * 3. TRY(M/index.js, M/index.json, M/index.node)
 * 4. TRY(pkg_url/index.js, pkg_url/index.json, pkg_url/index.node)
 * 5. NOT_FOUND
 *
 * @param {URL} url
 * @returns {boolean}
 */
function fileExists(url) {
  const stats = statSync$1(url, {throwIfNoEntry: false});
  const isFile = stats ? stats.isFile() : undefined;
  return isFile === null || isFile === undefined ? false : isFile
}

/**
 * @param {URL} packageJsonUrl
 * @param {PackageConfig} packageConfig
 * @param {URL} base
 * @returns {URL}
 */
function legacyMainResolve(packageJsonUrl, packageConfig, base) {
  /** @type {URL | undefined} */
  let guess;
  if (packageConfig.main !== undefined) {
    guess = new URL$2(packageConfig.main, packageJsonUrl);
    // Note: fs check redundances will be handled by Descriptor cache here.
    if (fileExists(guess)) return guess

    const tries = [
      `./${packageConfig.main}.js`,
      `./${packageConfig.main}.json`,
      `./${packageConfig.main}.node`,
      `./${packageConfig.main}/index.js`,
      `./${packageConfig.main}/index.json`,
      `./${packageConfig.main}/index.node`
    ];
    let i = -1;

    while (++i < tries.length) {
      guess = new URL$2(tries[i], packageJsonUrl);
      if (fileExists(guess)) break
      guess = undefined;
    }

    if (guess) {
      emitLegacyIndexDeprecation(
        guess,
        packageJsonUrl,
        base,
        packageConfig.main
      );
      return guess
    }
    // Fallthrough.
  }

  const tries = ['./index.js', './index.json', './index.node'];
  let i = -1;

  while (++i < tries.length) {
    guess = new URL$2(tries[i], packageJsonUrl);
    if (fileExists(guess)) break
    guess = undefined;
  }

  if (guess) {
    emitLegacyIndexDeprecation(guess, packageJsonUrl, base, packageConfig.main);
    return guess
  }

  // Not found.
  throw new ERR_MODULE_NOT_FOUND(
    fileURLToPath$1(new URL$2('.', packageJsonUrl)),
    fileURLToPath$1(base)
  )
}

/**
 * @param {URL} resolved
 * @param {URL} base
 * @param {boolean} [preserveSymlinks]
 * @returns {URL}
 */
function finalizeResolution(resolved, base, preserveSymlinks) {
  if (encodedSeparatorRegEx.exec(resolved.pathname) !== null) {
    throw new ERR_INVALID_MODULE_SPECIFIER(
      resolved.pathname,
      'must not include encoded "/" or "\\" characters',
      fileURLToPath$1(base)
    )
  }

  /** @type {string} */
  let filePath;

  try {
    filePath = fileURLToPath$1(resolved);
  } catch (error) {
    const cause = /** @type {ErrnoException} */ (error);
    Object.defineProperty(cause, 'input', {value: String(resolved)});
    Object.defineProperty(cause, 'module', {value: String(base)});
    throw cause
  }

  const stats = tryStatSync(
    filePath.endsWith('/') ? filePath.slice(-1) : filePath
  );

  if (stats && stats.isDirectory()) {
    const error = new ERR_UNSUPPORTED_DIR_IMPORT(filePath, fileURLToPath$1(base));
    // @ts-expect-error Add this for `import.meta.resolve`.
    error.url = String(resolved);
    throw error
  }

  if (!stats || !stats.isFile()) {
    const error = new ERR_MODULE_NOT_FOUND(
      filePath || resolved.pathname,
      base && fileURLToPath$1(base),
      true
    );
    // @ts-expect-error Add this for `import.meta.resolve`.
    error.url = String(resolved);
    throw error
  }

  {
    const real = realpathSync(filePath);
    const {search, hash} = resolved;
    resolved = pathToFileURL$1(real + (filePath.endsWith(path$8.sep) ? '/' : ''));
    resolved.search = search;
    resolved.hash = hash;
  }

  return resolved
}

/**
 * @param {string} specifier
 * @param {URL | undefined} packageJsonUrl
 * @param {URL} base
 * @returns {Error}
 */
function importNotDefined(specifier, packageJsonUrl, base) {
  return new ERR_PACKAGE_IMPORT_NOT_DEFINED(
    specifier,
    packageJsonUrl && fileURLToPath$1(new URL$2('.', packageJsonUrl)),
    fileURLToPath$1(base)
  )
}

/**
 * @param {string} subpath
 * @param {URL} packageJsonUrl
 * @param {URL} base
 * @returns {Error}
 */
function exportsNotFound(subpath, packageJsonUrl, base) {
  return new ERR_PACKAGE_PATH_NOT_EXPORTED(
    fileURLToPath$1(new URL$2('.', packageJsonUrl)),
    subpath,
    base && fileURLToPath$1(base)
  )
}

/**
 * @param {string} request
 * @param {string} match
 * @param {URL} packageJsonUrl
 * @param {boolean} internal
 * @param {URL} [base]
 * @returns {never}
 */
function throwInvalidSubpath(request, match, packageJsonUrl, internal, base) {
  const reason = `request is not a valid match in pattern "${match}" for the "${
    internal ? 'imports' : 'exports'
  }" resolution of ${fileURLToPath$1(packageJsonUrl)}`;
  throw new ERR_INVALID_MODULE_SPECIFIER(
    request,
    reason,
    base && fileURLToPath$1(base)
  )
}

/**
 * @param {string} subpath
 * @param {unknown} target
 * @param {URL} packageJsonUrl
 * @param {boolean} internal
 * @param {URL} [base]
 * @returns {Error}
 */
function invalidPackageTarget(subpath, target, packageJsonUrl, internal, base) {
  target =
    typeof target === 'object' && target !== null
      ? JSON.stringify(target, null, '')
      : `${target}`;

  return new ERR_INVALID_PACKAGE_TARGET(
    fileURLToPath$1(new URL$2('.', packageJsonUrl)),
    subpath,
    target,
    internal,
    base && fileURLToPath$1(base)
  )
}

/**
 * @param {string} target
 * @param {string} subpath
 * @param {string} match
 * @param {URL} packageJsonUrl
 * @param {URL} base
 * @param {boolean} pattern
 * @param {boolean} internal
 * @param {boolean} isPathMap
 * @param {Set<string> | undefined} conditions
 * @returns {URL}
 */
function resolvePackageTargetString(
  target,
  subpath,
  match,
  packageJsonUrl,
  base,
  pattern,
  internal,
  isPathMap,
  conditions
) {
  if (subpath !== '' && !pattern && target[target.length - 1] !== '/')
    throw invalidPackageTarget(match, target, packageJsonUrl, internal, base)

  if (!target.startsWith('./')) {
    if (internal && !target.startsWith('../') && !target.startsWith('/')) {
      let isURL = false;

      try {
        new URL$2(target);
        isURL = true;
      } catch {
        // Continue regardless of error.
      }

      if (!isURL) {
        const exportTarget = pattern
          ? RegExpPrototypeSymbolReplace.call(
              patternRegEx,
              target,
              () => subpath
            )
          : target + subpath;

        return packageResolve(exportTarget, packageJsonUrl, conditions)
      }
    }

    throw invalidPackageTarget(match, target, packageJsonUrl, internal, base)
  }

  if (invalidSegmentRegEx.exec(target.slice(2)) !== null) {
    if (deprecatedInvalidSegmentRegEx.exec(target.slice(2)) === null) {
      if (!isPathMap) {
        const request = pattern
          ? match.replace('*', () => subpath)
          : match + subpath;
        const resolvedTarget = pattern
          ? RegExpPrototypeSymbolReplace.call(
              patternRegEx,
              target,
              () => subpath
            )
          : target;
        emitInvalidSegmentDeprecation(
          resolvedTarget,
          request,
          match,
          packageJsonUrl,
          internal,
          base,
          true
        );
      }
    } else {
      throw invalidPackageTarget(match, target, packageJsonUrl, internal, base)
    }
  }

  const resolved = new URL$2(target, packageJsonUrl);
  const resolvedPath = resolved.pathname;
  const packagePath = new URL$2('.', packageJsonUrl).pathname;

  if (!resolvedPath.startsWith(packagePath))
    throw invalidPackageTarget(match, target, packageJsonUrl, internal, base)

  if (subpath === '') return resolved

  if (invalidSegmentRegEx.exec(subpath) !== null) {
    const request = pattern
      ? match.replace('*', () => subpath)
      : match + subpath;
    if (deprecatedInvalidSegmentRegEx.exec(subpath) === null) {
      if (!isPathMap) {
        const resolvedTarget = pattern
          ? RegExpPrototypeSymbolReplace.call(
              patternRegEx,
              target,
              () => subpath
            )
          : target;
        emitInvalidSegmentDeprecation(
          resolvedTarget,
          request,
          match,
          packageJsonUrl,
          internal,
          base,
          false
        );
      }
    } else {
      throwInvalidSubpath(request, match, packageJsonUrl, internal, base);
    }
  }

  if (pattern) {
    return new URL$2(
      RegExpPrototypeSymbolReplace.call(
        patternRegEx,
        resolved.href,
        () => subpath
      )
    )
  }

  return new URL$2(subpath, resolved)
}

/**
 * @param {string} key
 * @returns {boolean}
 */
function isArrayIndex(key) {
  const keyNumber = Number(key);
  if (`${keyNumber}` !== key) return false
  return keyNumber >= 0 && keyNumber < 0xff_ff_ff_ff
}

/**
 * @param {URL} packageJsonUrl
 * @param {unknown} target
 * @param {string} subpath
 * @param {string} packageSubpath
 * @param {URL} base
 * @param {boolean} pattern
 * @param {boolean} internal
 * @param {boolean} isPathMap
 * @param {Set<string> | undefined} conditions
 * @returns {URL | null}
 */
function resolvePackageTarget(
  packageJsonUrl,
  target,
  subpath,
  packageSubpath,
  base,
  pattern,
  internal,
  isPathMap,
  conditions
) {
  if (typeof target === 'string') {
    return resolvePackageTargetString(
      target,
      subpath,
      packageSubpath,
      packageJsonUrl,
      base,
      pattern,
      internal,
      isPathMap,
      conditions
    )
  }

  if (Array.isArray(target)) {
    /** @type {Array<unknown>} */
    const targetList = target;
    if (targetList.length === 0) return null

    /** @type {ErrnoException | null | undefined} */
    let lastException;
    let i = -1;

    while (++i < targetList.length) {
      const targetItem = targetList[i];
      /** @type {URL | null} */
      let resolveResult;
      try {
        resolveResult = resolvePackageTarget(
          packageJsonUrl,
          targetItem,
          subpath,
          packageSubpath,
          base,
          pattern,
          internal,
          isPathMap,
          conditions
        );
      } catch (error) {
        const exception = /** @type {ErrnoException} */ (error);
        lastException = exception;
        if (exception.code === 'ERR_INVALID_PACKAGE_TARGET') continue
        throw error
      }

      if (resolveResult === undefined) continue

      if (resolveResult === null) {
        lastException = null;
        continue
      }

      return resolveResult
    }

    if (lastException === undefined || lastException === null) {
      return null
    }

    throw lastException
  }

  if (typeof target === 'object' && target !== null) {
    const keys = Object.getOwnPropertyNames(target);
    let i = -1;

    while (++i < keys.length) {
      const key = keys[i];
      if (isArrayIndex(key)) {
        throw new ERR_INVALID_PACKAGE_CONFIG(
          fileURLToPath$1(packageJsonUrl),
          base,
          '"exports" cannot contain numeric property keys.'
        )
      }
    }

    i = -1;

    while (++i < keys.length) {
      const key = keys[i];
      if (key === 'default' || (conditions && conditions.has(key))) {
        // @ts-expect-error: indexable.
        const conditionalTarget = /** @type {unknown} */ (target[key]);
        const resolveResult = resolvePackageTarget(
          packageJsonUrl,
          conditionalTarget,
          subpath,
          packageSubpath,
          base,
          pattern,
          internal,
          isPathMap,
          conditions
        );
        if (resolveResult === undefined) continue
        return resolveResult
      }
    }

    return null
  }

  if (target === null) {
    return null
  }

  throw invalidPackageTarget(
    packageSubpath,
    target,
    packageJsonUrl,
    internal,
    base
  )
}

/**
 * @param {unknown} exports
 * @param {URL} packageJsonUrl
 * @param {URL} base
 * @returns {boolean}
 */
function isConditionalExportsMainSugar(exports, packageJsonUrl, base) {
  if (typeof exports === 'string' || Array.isArray(exports)) return true
  if (typeof exports !== 'object' || exports === null) return false

  const keys = Object.getOwnPropertyNames(exports);
  let isConditionalSugar = false;
  let i = 0;
  let keyIndex = -1;
  while (++keyIndex < keys.length) {
    const key = keys[keyIndex];
    const currentIsConditionalSugar = key === '' || key[0] !== '.';
    if (i++ === 0) {
      isConditionalSugar = currentIsConditionalSugar;
    } else if (isConditionalSugar !== currentIsConditionalSugar) {
      throw new ERR_INVALID_PACKAGE_CONFIG(
        fileURLToPath$1(packageJsonUrl),
        base,
        '"exports" cannot contain some keys starting with \'.\' and some not.' +
          ' The exports object must either be an object of package subpath keys' +
          ' or an object of main entry condition name keys only.'
      )
    }
  }

  return isConditionalSugar
}

/**
 * @param {string} match
 * @param {URL} pjsonUrl
 * @param {URL} base
 */
function emitTrailingSlashPatternDeprecation(match, pjsonUrl, base) {
  // @ts-expect-error: apparently it does exist, TS.
  if (process$1.noDeprecation) {
    return
  }

  const pjsonPath = fileURLToPath$1(pjsonUrl);
  if (emittedPackageWarnings.has(pjsonPath + '|' + match)) return
  emittedPackageWarnings.add(pjsonPath + '|' + match);
  process$1.emitWarning(
    `Use of deprecated trailing slash pattern mapping "${match}" in the ` +
      `"exports" field module resolution of the package at ${pjsonPath}${
        base ? ` imported from ${fileURLToPath$1(base)}` : ''
      }. Mapping specifiers ending in "/" is no longer supported.`,
    'DeprecationWarning',
    'DEP0155'
  );
}

/**
 * @param {URL} packageJsonUrl
 * @param {string} packageSubpath
 * @param {Record<string, unknown>} packageConfig
 * @param {URL} base
 * @param {Set<string> | undefined} conditions
 * @returns {URL}
 */
function packageExportsResolve(
  packageJsonUrl,
  packageSubpath,
  packageConfig,
  base,
  conditions
) {
  let exports = packageConfig.exports;

  if (isConditionalExportsMainSugar(exports, packageJsonUrl, base)) {
    exports = {'.': exports};
  }

  if (
    own.call(exports, packageSubpath) &&
    !packageSubpath.includes('*') &&
    !packageSubpath.endsWith('/')
  ) {
    // @ts-expect-error: indexable.
    const target = exports[packageSubpath];
    const resolveResult = resolvePackageTarget(
      packageJsonUrl,
      target,
      '',
      packageSubpath,
      base,
      false,
      false,
      false,
      conditions
    );
    if (resolveResult === null || resolveResult === undefined) {
      throw exportsNotFound(packageSubpath, packageJsonUrl, base)
    }

    return resolveResult
  }

  let bestMatch = '';
  let bestMatchSubpath = '';
  const keys = Object.getOwnPropertyNames(exports);
  let i = -1;

  while (++i < keys.length) {
    const key = keys[i];
    const patternIndex = key.indexOf('*');

    if (
      patternIndex !== -1 &&
      packageSubpath.startsWith(key.slice(0, patternIndex))
    ) {
      // When this reaches EOL, this can throw at the top of the whole function:
      //
      // if (StringPrototypeEndsWith(packageSubpath, '/'))
      //   throwInvalidSubpath(packageSubpath)
      //
      // To match "imports" and the spec.
      if (packageSubpath.endsWith('/')) {
        emitTrailingSlashPatternDeprecation(
          packageSubpath,
          packageJsonUrl,
          base
        );
      }

      const patternTrailer = key.slice(patternIndex + 1);

      if (
        packageSubpath.length >= key.length &&
        packageSubpath.endsWith(patternTrailer) &&
        patternKeyCompare(bestMatch, key) === 1 &&
        key.lastIndexOf('*') === patternIndex
      ) {
        bestMatch = key;
        bestMatchSubpath = packageSubpath.slice(
          patternIndex,
          packageSubpath.length - patternTrailer.length
        );
      }
    }
  }

  if (bestMatch) {
    // @ts-expect-error: indexable.
    const target = /** @type {unknown} */ (exports[bestMatch]);
    const resolveResult = resolvePackageTarget(
      packageJsonUrl,
      target,
      bestMatchSubpath,
      bestMatch,
      base,
      true,
      false,
      packageSubpath.endsWith('/'),
      conditions
    );

    if (resolveResult === null || resolveResult === undefined) {
      throw exportsNotFound(packageSubpath, packageJsonUrl, base)
    }

    return resolveResult
  }

  throw exportsNotFound(packageSubpath, packageJsonUrl, base)
}

/**
 * @param {string} a
 * @param {string} b
 */
function patternKeyCompare(a, b) {
  const aPatternIndex = a.indexOf('*');
  const bPatternIndex = b.indexOf('*');
  const baseLengthA = aPatternIndex === -1 ? a.length : aPatternIndex + 1;
  const baseLengthB = bPatternIndex === -1 ? b.length : bPatternIndex + 1;
  if (baseLengthA > baseLengthB) return -1
  if (baseLengthB > baseLengthA) return 1
  if (aPatternIndex === -1) return 1
  if (bPatternIndex === -1) return -1
  if (a.length > b.length) return -1
  if (b.length > a.length) return 1
  return 0
}

/**
 * @param {string} name
 * @param {URL} base
 * @param {Set<string>} [conditions]
 * @returns {URL}
 */
function packageImportsResolve(name, base, conditions) {
  if (name === '#' || name.startsWith('#/') || name.endsWith('/')) {
    const reason = 'is not a valid internal imports specifier name';
    throw new ERR_INVALID_MODULE_SPECIFIER(name, reason, fileURLToPath$1(base))
  }

  /** @type {URL | undefined} */
  let packageJsonUrl;

  const packageConfig = getPackageScopeConfig(base);

  if (packageConfig.exists) {
    packageJsonUrl = pathToFileURL$1(packageConfig.pjsonPath);
    const imports = packageConfig.imports;
    if (imports) {
      if (own.call(imports, name) && !name.includes('*')) {
        const resolveResult = resolvePackageTarget(
          packageJsonUrl,
          imports[name],
          '',
          name,
          base,
          false,
          true,
          false,
          conditions
        );
        if (resolveResult !== null && resolveResult !== undefined) {
          return resolveResult
        }
      } else {
        let bestMatch = '';
        let bestMatchSubpath = '';
        const keys = Object.getOwnPropertyNames(imports);
        let i = -1;

        while (++i < keys.length) {
          const key = keys[i];
          const patternIndex = key.indexOf('*');

          if (patternIndex !== -1 && name.startsWith(key.slice(0, -1))) {
            const patternTrailer = key.slice(patternIndex + 1);
            if (
              name.length >= key.length &&
              name.endsWith(patternTrailer) &&
              patternKeyCompare(bestMatch, key) === 1 &&
              key.lastIndexOf('*') === patternIndex
            ) {
              bestMatch = key;
              bestMatchSubpath = name.slice(
                patternIndex,
                name.length - patternTrailer.length
              );
            }
          }
        }

        if (bestMatch) {
          const target = imports[bestMatch];
          const resolveResult = resolvePackageTarget(
            packageJsonUrl,
            target,
            bestMatchSubpath,
            bestMatch,
            base,
            true,
            true,
            false,
            conditions
          );

          if (resolveResult !== null && resolveResult !== undefined) {
            return resolveResult
          }
        }
      }
    }
  }

  throw importNotDefined(name, packageJsonUrl, base)
}

/**
 * @param {string} specifier
 * @param {URL} base
 */
function parsePackageName(specifier, base) {
  let separatorIndex = specifier.indexOf('/');
  let validPackageName = true;
  let isScoped = false;
  if (specifier[0] === '@') {
    isScoped = true;
    if (separatorIndex === -1 || specifier.length === 0) {
      validPackageName = false;
    } else {
      separatorIndex = specifier.indexOf('/', separatorIndex + 1);
    }
  }

  const packageName =
    separatorIndex === -1 ? specifier : specifier.slice(0, separatorIndex);

  // Package name cannot have leading . and cannot have percent-encoding or
  // \\ separators.
  if (invalidPackageNameRegEx.exec(packageName) !== null) {
    validPackageName = false;
  }

  if (!validPackageName) {
    throw new ERR_INVALID_MODULE_SPECIFIER(
      specifier,
      'is not a valid package name',
      fileURLToPath$1(base)
    )
  }

  const packageSubpath =
    '.' + (separatorIndex === -1 ? '' : specifier.slice(separatorIndex));

  return {packageName, packageSubpath, isScoped}
}

/**
 * @param {string} specifier
 * @param {URL} base
 * @param {Set<string> | undefined} conditions
 * @returns {URL}
 */
function packageResolve(specifier, base, conditions) {
  if (builtinModules.includes(specifier)) {
    return new URL$2('node:' + specifier)
  }

  const {packageName, packageSubpath, isScoped} = parsePackageName(
    specifier,
    base
  );

  // ResolveSelf
  const packageConfig = getPackageScopeConfig(base);

  // Can’t test.
  /* c8 ignore next 16 */
  if (packageConfig.exists) {
    const packageJsonUrl = pathToFileURL$1(packageConfig.pjsonPath);
    if (
      packageConfig.name === packageName &&
      packageConfig.exports !== undefined &&
      packageConfig.exports !== null
    ) {
      return packageExportsResolve(
        packageJsonUrl,
        packageSubpath,
        packageConfig,
        base,
        conditions
      )
    }
  }

  let packageJsonUrl = new URL$2(
    './node_modules/' + packageName + '/package.json',
    base
  );
  let packageJsonPath = fileURLToPath$1(packageJsonUrl);
  /** @type {string} */
  let lastPath;
  do {
    const stat = tryStatSync(packageJsonPath.slice(0, -13));
    if (!stat || !stat.isDirectory()) {
      lastPath = packageJsonPath;
      packageJsonUrl = new URL$2(
        (isScoped ? '../../../../node_modules/' : '../../../node_modules/') +
          packageName +
          '/package.json',
        packageJsonUrl
      );
      packageJsonPath = fileURLToPath$1(packageJsonUrl);
      continue
    }

    // Package match.
    const packageConfig = read(packageJsonPath, {base, specifier});
    if (packageConfig.exports !== undefined && packageConfig.exports !== null) {
      return packageExportsResolve(
        packageJsonUrl,
        packageSubpath,
        packageConfig,
        base,
        conditions
      )
    }

    if (packageSubpath === '.') {
      return legacyMainResolve(packageJsonUrl, packageConfig, base)
    }

    return new URL$2(packageSubpath, packageJsonUrl)
    // Cross-platform root check.
  } while (packageJsonPath.length !== lastPath.length)

  throw new ERR_MODULE_NOT_FOUND(packageName, fileURLToPath$1(base), false)
}

/**
 * @param {string} specifier
 * @returns {boolean}
 */
function isRelativeSpecifier(specifier) {
  if (specifier[0] === '.') {
    if (specifier.length === 1 || specifier[1] === '/') return true
    if (
      specifier[1] === '.' &&
      (specifier.length === 2 || specifier[2] === '/')
    ) {
      return true
    }
  }

  return false
}

/**
 * @param {string} specifier
 * @returns {boolean}
 */
function shouldBeTreatedAsRelativeOrAbsolutePath(specifier) {
  if (specifier === '') return false
  if (specifier[0] === '/') return true
  return isRelativeSpecifier(specifier)
}

/**
 * The “Resolver Algorithm Specification” as detailed in the Node docs (which is
 * sync and slightly lower-level than `resolve`).
 *
 * @param {string} specifier
 *   `/example.js`, `./example.js`, `../example.js`, `some-package`, `fs`, etc.
 * @param {URL} base
 *   Full URL (to a file) that `specifier` is resolved relative from.
 * @param {Set<string>} [conditions]
 *   Conditions.
 * @param {boolean} [preserveSymlinks]
 *   Keep symlinks instead of resolving them.
 * @returns {URL}
 *   A URL object to the found thing.
 */
function moduleResolve(specifier, base, conditions, preserveSymlinks) {
  // Note: The Node code supports `base` as a string (in this internal API) too,
  // we don’t.
  const protocol = base.protocol;
  const isData = protocol === 'data:';
  const isRemote = isData || protocol === 'http:' || protocol === 'https:';
  // Order swapped from spec for minor perf gain.
  // Ok since relative URLs cannot parse as URLs.
  /** @type {URL | undefined} */
  let resolved;

  if (shouldBeTreatedAsRelativeOrAbsolutePath(specifier)) {
    try {
      resolved = new URL$2(specifier, base);
    } catch (error_) {
      const error = new ERR_UNSUPPORTED_RESOLVE_REQUEST(specifier, base);
      error.cause = error_;
      throw error
    }
  } else if (protocol === 'file:' && specifier[0] === '#') {
    resolved = packageImportsResolve(specifier, base, conditions);
  } else {
    try {
      resolved = new URL$2(specifier);
    } catch (error_) {
      // Note: actual code uses `canBeRequiredWithoutScheme`.
      if (isRemote && !builtinModules.includes(specifier)) {
        const error = new ERR_UNSUPPORTED_RESOLVE_REQUEST(specifier, base);
        error.cause = error_;
        throw error
      }

      resolved = packageResolve(specifier, base, conditions);
    }
  }

  assert(resolved !== undefined, 'expected to be defined');

  if (resolved.protocol !== 'file:') {
    return resolved
  }

  return finalizeResolution(resolved, base)
}

function fileURLToPath(id) {
  if (typeof id === "string" && !id.startsWith("file://")) {
    return normalizeSlash(id);
  }
  return normalizeSlash(fileURLToPath$1(id));
}
function pathToFileURL(id) {
  return pathToFileURL$1(fileURLToPath(id)).toString();
}
function normalizeid(id) {
  if (typeof id !== "string") {
    id = id.toString();
  }
  if (/(node|data|http|https|file):/.test(id)) {
    return id;
  }
  if (BUILTIN_MODULES.has(id)) {
    return "node:" + id;
  }
  return "file://" + encodeURI(normalizeSlash(id));
}

const DEFAULT_CONDITIONS_SET = /* @__PURE__ */ new Set(["node", "import"]);
const DEFAULT_EXTENSIONS = [".mjs", ".cjs", ".js", ".json"];
const NOT_FOUND_ERRORS = /* @__PURE__ */ new Set([
  "ERR_MODULE_NOT_FOUND",
  "ERR_UNSUPPORTED_DIR_IMPORT",
  "MODULE_NOT_FOUND",
  "ERR_PACKAGE_PATH_NOT_EXPORTED"
]);
function _tryModuleResolve(id, url, conditions) {
  try {
    return moduleResolve(id, url, conditions);
  } catch (error) {
    if (!NOT_FOUND_ERRORS.has(error?.code)) {
      throw error;
    }
  }
}
function _resolve$1(id, options = {}) {
  if (typeof id !== "string") {
    if (id instanceof URL) {
      id = fileURLToPath(id);
    } else {
      throw new TypeError("input must be a `string` or `URL`");
    }
  }
  if (/(node|data|http|https):/.test(id)) {
    return id;
  }
  if (BUILTIN_MODULES.has(id)) {
    return "node:" + id;
  }
  if (id.startsWith("file://")) {
    id = fileURLToPath(id);
  }
  if (isAbsolute(id)) {
    try {
      const stat = statSync$1(id);
      if (stat.isFile()) {
        return pathToFileURL(id);
      }
    } catch (error) {
      if (error?.code !== "ENOENT") {
        throw error;
      }
    }
  }
  const conditionsSet = options.conditions ? new Set(options.conditions) : DEFAULT_CONDITIONS_SET;
  const _urls = (Array.isArray(options.url) ? options.url : [options.url]).filter(Boolean).map((url) => new URL(normalizeid(url.toString())));
  if (_urls.length === 0) {
    _urls.push(new URL(pathToFileURL(process.cwd())));
  }
  const urls = [..._urls];
  for (const url of _urls) {
    if (url.protocol === "file:") {
      urls.push(
        new URL("./", url),
        // If url is directory
        new URL(joinURL(url.pathname, "_index.js"), url),
        // TODO: Remove in next major version?
        new URL("node_modules", url)
      );
    }
  }
  let resolved;
  for (const url of urls) {
    resolved = _tryModuleResolve(id, url, conditionsSet);
    if (resolved) {
      break;
    }
    for (const prefix of ["", "/index"]) {
      for (const extension of options.extensions || DEFAULT_EXTENSIONS) {
        resolved = _tryModuleResolve(
          id + prefix + extension,
          url,
          conditionsSet
        );
        if (resolved) {
          break;
        }
      }
      if (resolved) {
        break;
      }
    }
    if (resolved) {
      break;
    }
  }
  if (!resolved) {
    const error = new Error(
      `Cannot find module ${id} imported from ${urls.join(", ")}`
    );
    error.code = "ERR_MODULE_NOT_FOUND";
    throw error;
  }
  return pathToFileURL(resolved);
}
function resolveSync(id, options) {
  return _resolve$1(id, options);
}
function resolvePathSync(id, options) {
  return fileURLToPath(resolveSync(id, options));
}

function _resolve(path, options = {}) {
  if (options.platform === "auto" || !options.platform)
    options.platform = process$1.platform === "win32" ? "win32" : "posix";
  const modulePath = resolvePathSync(path, {
    url: options.paths
  });
  if (options.platform === "win32")
    return win32.normalize(modulePath);
  return modulePath;
}
function resolveModule(name, options = {}) {
  try {
    return _resolve(name, options);
  } catch (e) {
    return void 0;
  }
}
function isPackageExists(name, options = {}) {
  return !!resolvePackage(name, options);
}
function resolvePackage(name, options = {}) {
  try {
    return _resolve(`${name}/package.json`, options);
  } catch {
  }
  try {
    return _resolve(name, options);
  } catch (e) {
    if (e.code !== "MODULE_NOT_FOUND" && e.code !== "ERR_MODULE_NOT_FOUND")
      console.error(e);
    return false;
  }
}

const defaultInclude = ["**/*.{test,spec}.?(c|m)[jt]s?(x)"];
const defaultExclude = [
  "**/node_modules/**",
  "**/dist/**",
  "**/cypress/**",
  "**/.{idea,git,cache,output,temp}/**",
  "**/{karma,rollup,webpack,vite,vitest,jest,ava,babel,nyc,cypress,tsup,build,eslint,prettier}.config.*"
];
const benchmarkConfigDefaults = {
  include: ["**/*.{bench,benchmark}.?(c|m)[jt]s?(x)"],
  exclude: defaultExclude,
  includeSource: [],
  reporters: ["default"]
};
const defaultCoverageExcludes = [
  "coverage/**",
  "dist/**",
  "**/node_modules/**",
  "**/[.]**",
  "packages/*/test?(s)/**",
  "**/*.d.ts",
  "**/virtual:*",
  "**/__x00__*",
  "**/\0*",
  "cypress/**",
  "test?(s)/**",
  "test?(-*).?(c|m)[jt]s?(x)",
  "**/*{.,-}{test,spec,bench,benchmark}?(-d).?(c|m)[jt]s?(x)",
  "**/__tests__/**",
  "**/{karma,rollup,webpack,vite,vitest,jest,ava,babel,nyc,cypress,tsup,build,eslint,prettier}.config.*",
  "**/vitest.{workspace,projects}.[jt]s?(on)",
  "**/.{eslint,mocha,prettier}rc.{?(c|m)js,yml}"
];
const coverageConfigDefaults = {
  provider: "v8",
  enabled: false,
  all: true,
  clean: true,
  cleanOnRerun: true,
  reportsDirectory: "./coverage",
  exclude: defaultCoverageExcludes,
  reportOnFailure: false,
  reporter: [
    ["text", {}],
    ["html", {}],
    ["clover", {}],
    ["json", {}]
  ],
  extension: [
    ".js",
    ".cjs",
    ".mjs",
    ".ts",
    ".mts",
    ".tsx",
    ".jsx",
    ".vue",
    ".svelte",
    ".marko"
  ],
  allowExternal: false,
  ignoreEmptyLines: true,
  processingConcurrency: Math.min(
    20,
    nodeos__default.availableParallelism?.() ?? nodeos__default.cpus().length
  )
};
const fakeTimersDefaults = {
  loopLimit: 1e4,
  shouldClearNativeTimers: true,
  toFake: [
    "setTimeout",
    "clearTimeout",
    "setInterval",
    "clearInterval",
    "setImmediate",
    "clearImmediate",
    "Date"
  ]
};
const config = {
  allowOnly: !isCI,
  isolate: true,
  watch: !isCI,
  globals: false,
  environment: "node",
  pool: "forks",
  clearMocks: false,
  restoreMocks: false,
  mockReset: false,
  unstubGlobals: false,
  unstubEnvs: false,
  include: defaultInclude,
  exclude: defaultExclude,
  teardownTimeout: 1e4,
  forceRerunTriggers: ["**/package.json/**", "**/{vitest,vite}.config.*/**"],
  update: false,
  reporters: [],
  silent: false,
  hideSkippedTests: false,
  api: false,
  ui: false,
  uiBase: "/__vitest__/",
  open: !isCI,
  css: {
    include: []
  },
  coverage: coverageConfigDefaults,
  fakeTimers: fakeTimersDefaults,
  maxConcurrency: 5,
  dangerouslyIgnoreUnhandledErrors: false,
  typecheck: {
    checker: "tsc",
    include: ["**/*.{test,spec}-d.?(c|m)[jt]s?(x)"],
    exclude: defaultExclude
  },
  slowTestThreshold: 300,
  disableConsoleIntercept: false
};
const configDefaults = Object.freeze(config);

function getWorkersCountByPercentage(percent) {
  const maxWorkersCount = nodeos__default.availableParallelism?.() ?? nodeos__default.cpus().length;
  const workersCountByPercentage = Math.round(Number.parseInt(percent) / 100 * maxWorkersCount);
  return Math.max(1, Math.min(maxWorkersCount, workersCountByPercentage));
}

class FilesStatsCache {
  cache = /* @__PURE__ */ new Map();
  getStats(key) {
    return this.cache.get(key);
  }
  async populateStats(root, specs) {
    const promises = specs.map((spec) => {
      const key = `${spec[0].getName()}:${relative(root, spec[1])}`;
      return this.updateStats(spec[1], key);
    });
    await Promise.all(promises);
  }
  async updateStats(fsPath, key) {
    if (!fs$8.existsSync(fsPath)) {
      return;
    }
    const stats = await fs$8.promises.stat(fsPath);
    this.cache.set(key, { size: stats.size });
  }
  removeStats(fsPath) {
    this.cache.forEach((_, key) => {
      if (key.endsWith(fsPath)) {
        this.cache.delete(key);
      }
    });
  }
}

class ResultsCache {
  cache = /* @__PURE__ */ new Map();
  workspacesKeyMap = /* @__PURE__ */ new Map();
  cachePath = null;
  version;
  root = "/";
  constructor(version) {
    this.version = version;
  }
  getCachePath() {
    return this.cachePath;
  }
  setConfig(root, config) {
    this.root = root;
    if (config) {
      this.cachePath = resolve(config.dir, "results.json");
    }
  }
  getResults(key) {
    return this.cache.get(key);
  }
  async readFromCache() {
    if (!this.cachePath) {
      return;
    }
    if (!fs$8.existsSync(this.cachePath)) {
      return;
    }
    const resultsCache = await fs$8.promises.readFile(this.cachePath, "utf8");
    const { results, version } = JSON.parse(resultsCache || "[]");
    if (Number(version.split(".")[1]) >= 30) {
      this.cache = new Map(results);
      this.version = version;
      results.forEach(([spec]) => {
        const [projectName, relativePath] = spec.split(":");
        const keyMap = this.workspacesKeyMap.get(relativePath) || [];
        keyMap.push(projectName);
        this.workspacesKeyMap.set(relativePath, keyMap);
      });
    }
  }
  updateResults(files) {
    files.forEach((file) => {
      const result = file.result;
      if (!result) {
        return;
      }
      const duration = result.duration || 0;
      const relativePath = relative(this.root, file.filepath);
      this.cache.set(`${file.projectName || ""}:${relativePath}`, {
        duration: duration >= 0 ? duration : 0,
        failed: result.state === "fail"
      });
    });
  }
  removeFromCache(filepath) {
    this.cache.forEach((_, key) => {
      if (key.endsWith(filepath)) {
        this.cache.delete(key);
      }
    });
  }
  async writeToCache() {
    if (!this.cachePath) {
      return;
    }
    const results = Array.from(this.cache.entries());
    const cacheDirname = dirname(this.cachePath);
    if (!fs$8.existsSync(cacheDirname)) {
      await fs$8.promises.mkdir(cacheDirname, { recursive: true });
    }
    const cache = JSON.stringify({
      version: this.version,
      results
    });
    await fs$8.promises.writeFile(this.cachePath, cache);
  }
}

class VitestCache {
  results;
  stats = new FilesStatsCache();
  constructor(version) {
    this.results = new ResultsCache(version);
  }
  getFileTestResults(key) {
    return this.results.getResults(key);
  }
  getFileStats(key) {
    return this.stats.getStats(key);
  }
  static resolveCacheDir(root, dir, projectName) {
    const baseDir = slash$1(dir || "node_modules/.vite/vitest");
    return projectName ? resolve(
      root,
      baseDir,
      crypto.createHash("md5").update(projectName, "utf-8").digest("hex")
    ) : resolve(root, baseDir);
  }
}

function resolvePath(path, root) {
  return normalize(
    /* @__PURE__ */ resolveModule(path, { paths: [root] }) ?? resolve(root, path)
  );
}
function parseInspector(inspect) {
  if (typeof inspect === "boolean" || inspect === void 0) {
    return {};
  }
  if (typeof inspect === "number") {
    return { port: inspect };
  }
  if (inspect.match(/https?:\//)) {
    throw new Error(
      `Inspector host cannot be a URL. Use "host:port" instead of "${inspect}"`
    );
  }
  const [host, port] = inspect.split(":");
  if (!port) {
    return { host };
  }
  return { host, port: Number(port) || defaultInspectPort };
}
function resolveApiServerConfig(options, defaultPort2) {
  let api;
  if (options.ui && !options.api) {
    api = { port: defaultPort2 };
  } else if (options.api === true) {
    api = { port: defaultPort2 };
  } else if (typeof options.api === "number") {
    api = { port: options.api };
  }
  if (typeof options.api === "object") {
    if (api) {
      if (options.api.port) {
        api.port = options.api.port;
      }
      if (options.api.strictPort) {
        api.strictPort = options.api.strictPort;
      }
      if (options.api.host) {
        api.host = options.api.host;
      }
    } else {
      api = { ...options.api };
    }
  }
  if (api) {
    if (!api.port && !api.middlewareMode) {
      api.port = defaultPort2;
    }
  } else {
    api = { middlewareMode: true };
  }
  return api;
}
function resolveInlineWorkerOption(value) {
  if (typeof value === "string" && value.trim().endsWith("%")) {
    return getWorkersCountByPercentage(value);
  } else {
    return Number(value);
  }
}
function resolveConfig(mode, options, viteConfig, logger) {
  if (options.dom) {
    if (viteConfig.test?.environment != null && viteConfig.test.environment !== "happy-dom") {
      logger.console.warn(
        c.yellow(
          `${c.inverse(c.yellow(" Vitest "))} Your config.test.environment ("${viteConfig.test.environment}") conflicts with --dom flag ("happy-dom"), ignoring "${viteConfig.test.environment}"`
        )
      );
    }
    options.environment = "happy-dom";
  }
  const resolved = {
    ...configDefaults,
    ...options,
    root: viteConfig.root,
    mode
  };
  const inspector = resolved.inspect || resolved.inspectBrk;
  resolved.inspector = {
    ...resolved.inspector,
    ...parseInspector(inspector),
    enabled: !!inspector,
    waitForDebugger: options.inspector?.waitForDebugger ?? !!resolved.inspectBrk
  };
  if (viteConfig.base !== "/") {
    resolved.base = viteConfig.base;
  }
  resolved.clearScreen = resolved.clearScreen ?? viteConfig.clearScreen ?? true;
  if (options.shard) {
    if (resolved.watch) {
      throw new Error("You cannot use --shard option with enabled watch");
    }
    const [indexString, countString] = options.shard.split("/");
    const index = Math.abs(Number.parseInt(indexString, 10));
    const count = Math.abs(Number.parseInt(countString, 10));
    if (Number.isNaN(count) || count <= 0) {
      throw new Error("--shard <count> must be a positive number");
    }
    if (Number.isNaN(index) || index <= 0 || index > count) {
      throw new Error(
        "--shard <index> must be a positive number less then <count>"
      );
    }
    resolved.shard = { index, count };
  }
  if (resolved.standalone && !resolved.watch) {
    throw new Error(`Vitest standalone mode requires --watch`);
  }
  if (resolved.mergeReports && resolved.watch) {
    throw new Error(`Cannot merge reports with --watch enabled`);
  }
  if (resolved.maxWorkers) {
    resolved.maxWorkers = resolveInlineWorkerOption(resolved.maxWorkers);
  }
  if (resolved.minWorkers) {
    resolved.minWorkers = resolveInlineWorkerOption(resolved.minWorkers);
  }
  resolved.browser ??= {};
  resolved.fileParallelism ??= mode !== "benchmark";
  if (!resolved.fileParallelism) {
    resolved.maxWorkers = 1;
    resolved.minWorkers = 1;
  }
  if (resolved.inspect || resolved.inspectBrk) {
    const isSingleThread = resolved.pool === "threads" && resolved.poolOptions?.threads?.singleThread;
    const isSingleFork = resolved.pool === "forks" && resolved.poolOptions?.forks?.singleFork;
    if (resolved.fileParallelism && !isSingleThread && !isSingleFork) {
      const inspectOption = `--inspect${resolved.inspectBrk ? "-brk" : ""}`;
      throw new Error(
        `You cannot use ${inspectOption} without "--no-file-parallelism", "poolOptions.threads.singleThread" or "poolOptions.forks.singleFork"`
      );
    }
  }
  if (resolved.coverage.provider === "v8" && resolved.coverage.enabled && isBrowserEnabled(resolved)) {
    throw new Error(
      "@vitest/coverage-v8 does not work with --browser. Use @vitest/coverage-istanbul instead"
    );
  }
  if (resolved.coverage.enabled && resolved.coverage.reportsDirectory) {
    const reportsDirectory = resolve(
      resolved.root,
      resolved.coverage.reportsDirectory
    );
    if (reportsDirectory === resolved.root || reportsDirectory === process.cwd()) {
      throw new Error(
        `You cannot set "coverage.reportsDirectory" as ${reportsDirectory}. Vitest needs to be able to remove this directory before test run`
      );
    }
  }
  if (resolved.coverage.enabled && resolved.coverage.provider === "custom" && resolved.coverage.customProviderModule) {
    resolved.coverage.customProviderModule = resolvePath(
      resolved.coverage.customProviderModule,
      resolved.root
    );
  }
  resolved.expect ??= {};
  resolved.deps ??= {};
  resolved.deps.moduleDirectories ??= [];
  resolved.deps.moduleDirectories = resolved.deps.moduleDirectories.map(
    (dir) => {
      if (!dir.startsWith("/")) {
        dir = `/${dir}`;
      }
      if (!dir.endsWith("/")) {
        dir += "/";
      }
      return normalize(dir);
    }
  );
  if (!resolved.deps.moduleDirectories.includes("/node_modules/")) {
    resolved.deps.moduleDirectories.push("/node_modules/");
  }
  resolved.deps.optimizer ??= {};
  resolved.deps.optimizer.ssr ??= {};
  resolved.deps.optimizer.ssr.enabled ??= true;
  resolved.deps.optimizer.web ??= {};
  resolved.deps.optimizer.web.enabled ??= true;
  resolved.deps.web ??= {};
  resolved.deps.web.transformAssets ??= true;
  resolved.deps.web.transformCss ??= true;
  resolved.deps.web.transformGlobPattern ??= [];
  resolved.server ??= {};
  resolved.server.deps ??= {};
  const deprecatedDepsOptions = ["inline", "external", "fallbackCJS"];
  deprecatedDepsOptions.forEach((option) => {
    if (resolved.deps[option] === void 0) {
      return;
    }
    if (option === "fallbackCJS") {
      logger.console.warn(
        c.yellow(
          `${c.inverse(
            c.yellow(" Vitest ")
          )} "deps.${option}" is deprecated. Use "server.deps.${option}" instead`
        )
      );
    } else {
      const transformMode = resolved.environment === "happy-dom" || resolved.environment === "jsdom" ? "web" : "ssr";
      logger.console.warn(
        c.yellow(
          `${c.inverse(
            c.yellow(" Vitest ")
          )} "deps.${option}" is deprecated. If you rely on vite-node directly, use "server.deps.${option}" instead. Otherwise, consider using "deps.optimizer.${transformMode}.${option === "external" ? "exclude" : "include"}"`
        )
      );
    }
    if (resolved.server.deps[option] === void 0) {
      resolved.server.deps[option] = resolved.deps[option];
    }
  });
  if (resolved.cliExclude) {
    resolved.exclude.push(...resolved.cliExclude);
  }
  if (resolved.server.deps.inline !== true) {
    const ssrOptions = viteConfig.ssr;
    if (ssrOptions?.noExternal === true && resolved.server.deps.inline == null) {
      resolved.server.deps.inline = true;
    } else {
      resolved.server.deps.inline ??= [];
      resolved.server.deps.inline.push(...extraInlineDeps);
    }
  }
  resolved.server.deps.moduleDirectories ??= [];
  resolved.server.deps.moduleDirectories.push(
    ...resolved.deps.moduleDirectories
  );
  if (resolved.runner) {
    resolved.runner = resolvePath(resolved.runner, resolved.root);
  }
  if (resolved.snapshotEnvironment) {
    resolved.snapshotEnvironment = resolvePath(
      resolved.snapshotEnvironment,
      resolved.root
    );
  }
  resolved.testNamePattern = resolved.testNamePattern ? resolved.testNamePattern instanceof RegExp ? resolved.testNamePattern : new RegExp(resolved.testNamePattern) : void 0;
  if (resolved.snapshotFormat && "plugins" in resolved.snapshotFormat) {
    resolved.snapshotFormat.plugins = [];
  }
  const UPDATE_SNAPSHOT = resolved.update || process.env.UPDATE_SNAPSHOT;
  resolved.snapshotOptions = {
    expand: resolved.expandSnapshotDiff ?? false,
    snapshotFormat: resolved.snapshotFormat || {},
    updateSnapshot: isCI && !UPDATE_SNAPSHOT ? "none" : UPDATE_SNAPSHOT ? "all" : "new",
    resolveSnapshotPath: options.resolveSnapshotPath,
    // resolved inside the worker
    snapshotEnvironment: null
  };
  resolved.snapshotSerializers ??= [];
  resolved.snapshotSerializers = resolved.snapshotSerializers.map(
    (file) => resolvePath(file, resolved.root)
  );
  resolved.forceRerunTriggers.push(...resolved.snapshotSerializers);
  if (options.resolveSnapshotPath) {
    delete resolved.resolveSnapshotPath;
  }
  resolved.pool ??= "threads";
  if (process.env.VITEST_MAX_THREADS) {
    resolved.poolOptions = {
      ...resolved.poolOptions,
      threads: {
        ...resolved.poolOptions?.threads,
        maxThreads: Number.parseInt(process.env.VITEST_MAX_THREADS)
      },
      vmThreads: {
        ...resolved.poolOptions?.vmThreads,
        maxThreads: Number.parseInt(process.env.VITEST_MAX_THREADS)
      }
    };
  }
  if (process.env.VITEST_MIN_THREADS) {
    resolved.poolOptions = {
      ...resolved.poolOptions,
      threads: {
        ...resolved.poolOptions?.threads,
        minThreads: Number.parseInt(process.env.VITEST_MIN_THREADS)
      },
      vmThreads: {
        ...resolved.poolOptions?.vmThreads,
        minThreads: Number.parseInt(process.env.VITEST_MIN_THREADS)
      }
    };
  }
  if (process.env.VITEST_MAX_FORKS) {
    resolved.poolOptions = {
      ...resolved.poolOptions,
      forks: {
        ...resolved.poolOptions?.forks,
        maxForks: Number.parseInt(process.env.VITEST_MAX_FORKS)
      },
      vmForks: {
        ...resolved.poolOptions?.vmForks,
        maxForks: Number.parseInt(process.env.VITEST_MAX_FORKS)
      }
    };
  }
  if (process.env.VITEST_MIN_FORKS) {
    resolved.poolOptions = {
      ...resolved.poolOptions,
      forks: {
        ...resolved.poolOptions?.forks,
        minForks: Number.parseInt(process.env.VITEST_MIN_FORKS)
      },
      vmForks: {
        ...resolved.poolOptions?.vmForks,
        minForks: Number.parseInt(process.env.VITEST_MIN_FORKS)
      }
    };
  }
  const poolThreadsOptions = [
    ["threads", "minThreads"],
    ["threads", "maxThreads"],
    ["vmThreads", "minThreads"],
    ["vmThreads", "maxThreads"]
  ];
  for (const [poolOptionKey, workerOptionKey] of poolThreadsOptions) {
    if (resolved.poolOptions?.[poolOptionKey]?.[workerOptionKey]) {
      resolved.poolOptions[poolOptionKey][workerOptionKey] = resolveInlineWorkerOption(resolved.poolOptions[poolOptionKey][workerOptionKey]);
    }
  }
  const poolForksOptions = [
    ["forks", "minForks"],
    ["forks", "maxForks"],
    ["vmForks", "minForks"],
    ["vmForks", "maxForks"]
  ];
  for (const [poolOptionKey, workerOptionKey] of poolForksOptions) {
    if (resolved.poolOptions?.[poolOptionKey]?.[workerOptionKey]) {
      resolved.poolOptions[poolOptionKey][workerOptionKey] = resolveInlineWorkerOption(resolved.poolOptions[poolOptionKey][workerOptionKey]);
    }
  }
  if (resolved.workspace) {
    resolved.workspace = options.workspace && options.workspace[0] === "." ? resolve(process.cwd(), options.workspace) : resolvePath(resolved.workspace, resolved.root);
  }
  if (!builtinPools.includes(resolved.pool)) {
    resolved.pool = resolvePath(resolved.pool, resolved.root);
  }
  resolved.poolMatchGlobs = (resolved.poolMatchGlobs || []).map(
    ([glob, pool]) => {
      if (!builtinPools.includes(pool)) {
        pool = resolvePath(pool, resolved.root);
      }
      return [glob, pool];
    }
  );
  if (mode === "benchmark") {
    resolved.benchmark = {
      ...benchmarkConfigDefaults,
      ...resolved.benchmark
    };
    resolved.coverage.enabled = false;
    resolved.include = resolved.benchmark.include;
    resolved.exclude = resolved.benchmark.exclude;
    resolved.includeSource = resolved.benchmark.includeSource;
    const reporters = Array.from(
      /* @__PURE__ */ new Set([
        ...toArray(resolved.benchmark.reporters),
        // @ts-expect-error reporter is CLI flag
        ...toArray(options.reporter)
      ])
    ).filter(Boolean);
    if (reporters.length) {
      resolved.benchmark.reporters = reporters;
    } else {
      resolved.benchmark.reporters = ["default"];
    }
    if (options.outputFile) {
      resolved.benchmark.outputFile = options.outputFile;
    }
    if (options.compare) {
      resolved.benchmark.compare = options.compare;
    }
    if (options.outputJson) {
      resolved.benchmark.outputJson = options.outputJson;
    }
  }
  resolved.setupFiles = toArray(resolved.setupFiles || []).map(
    (file) => resolvePath(file, resolved.root)
  );
  resolved.globalSetup = toArray(resolved.globalSetup || []).map(
    (file) => resolvePath(file, resolved.root)
  );
  resolved.coverage.exclude.push(
    ...resolved.setupFiles.map(
      (file) => `${resolved.coverage.allowExternal ? "**/" : ""}${relative(
        resolved.root,
        file
      )}`
    )
  );
  resolved.forceRerunTriggers = [
    ...resolved.forceRerunTriggers,
    ...resolved.setupFiles
  ];
  if (resolved.diff) {
    resolved.diff = resolvePath(resolved.diff, resolved.root);
    resolved.forceRerunTriggers.push(resolved.diff);
  }
  resolved.api = resolveApiServerConfig(options, defaultPort);
  if (options.related) {
    resolved.related = toArray(options.related).map(
      (file) => resolve(resolved.root, file)
    );
  }
  if (options.reporters) {
    if (!Array.isArray(options.reporters)) {
      if (typeof options.reporters === "string") {
        resolved.reporters = [[options.reporters, {}]];
      } else {
        resolved.reporters = [options.reporters];
      }
    } else {
      resolved.reporters = [];
      for (const reporter of options.reporters) {
        if (Array.isArray(reporter)) {
          resolved.reporters.push([reporter[0], reporter[1] || {}]);
        } else if (typeof reporter === "string") {
          resolved.reporters.push([reporter, {}]);
        } else {
          resolved.reporters.push(reporter);
        }
      }
    }
  }
  if (mode !== "benchmark") {
    const reportersFromCLI = resolved.reporter;
    const cliReporters = toArray(reportersFromCLI || []).map(
      (reporter) => {
        if (/^\.\.?\//.test(reporter)) {
          return resolve(process.cwd(), reporter);
        }
        return reporter;
      }
    );
    if (cliReporters.length) {
      resolved.reporters = Array.from(new Set(toArray(cliReporters))).filter(Boolean).map((reporter) => [reporter, {}]);
    }
  }
  if (!resolved.reporters.length) {
    resolved.reporters.push(["default", {}]);
    if (process.env.GITHUB_ACTIONS === "true") {
      resolved.reporters.push(["github-actions", {}]);
    }
  }
  if (resolved.changed) {
    resolved.passWithNoTests ??= true;
  }
  resolved.css ??= {};
  if (typeof resolved.css === "object") {
    resolved.css.modules ??= {};
    resolved.css.modules.classNameStrategy ??= "stable";
  }
  if (resolved.cache !== false) {
    let cacheDir = VitestCache.resolveCacheDir(
      "",
      resolve(viteConfig.cacheDir, "vitest"),
      resolved.name
    );
    if (resolved.cache && resolved.cache.dir) {
      logger.console.warn(
        c.yellow(
          `${c.inverse(
            c.yellow(" Vitest ")
          )} "cache.dir" is deprecated, use Vite's "cacheDir" instead if you want to change the cache director. Note caches will be written to "cacheDir/vitest"`
        )
      );
      cacheDir = VitestCache.resolveCacheDir(
        resolved.root,
        resolved.cache.dir,
        resolved.name
      );
    }
    resolved.cache = { dir: cacheDir };
  }
  resolved.sequence ??= {};
  if (resolved.sequence.shuffle && typeof resolved.sequence.shuffle === "object") {
    const { files, tests } = resolved.sequence.shuffle;
    resolved.sequence.sequencer ??= files ? RandomSequencer : BaseSequencer;
    resolved.sequence.shuffle = tests;
  }
  if (!resolved.sequence?.sequencer) {
    resolved.sequence.sequencer = resolved.sequence.shuffle ? RandomSequencer : BaseSequencer;
  }
  resolved.sequence.hooks ??= "stack";
  if (resolved.sequence.sequencer === RandomSequencer) {
    resolved.sequence.seed ??= Date.now();
  }
  resolved.typecheck = {
    ...configDefaults.typecheck,
    ...resolved.typecheck
  };
  resolved.environmentMatchGlobs = (resolved.environmentMatchGlobs || []).map(
    (i) => [resolve(resolved.root, i[0]), i[1]]
  );
  resolved.typecheck ??= {};
  resolved.typecheck.enabled ??= false;
  if (resolved.typecheck.enabled) {
    logger.console.warn(
      c.yellow(
        "Testing types with tsc and vue-tsc is an experimental feature.\nBreaking changes might not follow SemVer, please pin Vitest's version when using it."
      )
    );
  }
  resolved.browser ??= {};
  resolved.browser.enabled ??= false;
  resolved.browser.headless ??= isCI;
  resolved.browser.isolate ??= true;
  resolved.browser.fileParallelism ??= options.fileParallelism ?? mode !== "benchmark";
  resolved.browser.ui ??= resolved.browser.headless === true ? false : !isCI;
  if (resolved.browser.screenshotDirectory) {
    resolved.browser.screenshotDirectory = resolve(
      resolved.root,
      resolved.browser.screenshotDirectory
    );
  }
  const isPreview = resolved.browser.provider === "preview";
  if (isPreview && resolved.browser.screenshotFailures === true) {
    console.warn(c.yellow(
      [
        `Browser provider "preview" doesn't support screenshots, `,
        `so "browser.screenshotFailures" option is forcefully disabled. `,
        `Set "browser.screenshotFailures" to false or remove it from the config to suppress this warning.`
      ].join("")
    ));
    resolved.browser.screenshotFailures = false;
  } else {
    resolved.browser.screenshotFailures ??= !isPreview && !resolved.browser.ui;
  }
  resolved.browser.viewport ??= {};
  resolved.browser.viewport.width ??= 414;
  resolved.browser.viewport.height ??= 896;
  if (resolved.browser.enabled && provider$1 === "stackblitz") {
    resolved.browser.provider = "preview";
  }
  resolved.browser.api = resolveApiServerConfig(
    resolved.browser,
    defaultBrowserPort
  ) || {
    port: defaultBrowserPort
  };
  if (resolved.browser.enabled) {
    if (resolved.browser.ui) {
      resolved.includeTaskLocation ??= true;
    }
  } else if (resolved.ui) {
    resolved.includeTaskLocation ??= true;
  }
  const htmlReporter = toArray(resolved.reporters).some((reporter) => {
    if (Array.isArray(reporter)) {
      return reporter[0] === "html";
    }
    return false;
  });
  if (htmlReporter) {
    resolved.includeTaskLocation ??= true;
  }
  resolved.testTransformMode ??= {};
  resolved.testTimeout ??= resolved.browser.enabled ? 15e3 : 5e3;
  resolved.hookTimeout ??= resolved.browser.enabled ? 3e4 : 1e4;
  return resolved;
}
function isBrowserEnabled(config) {
  return Boolean(config.browser?.enabled);
}

function generateCssFilenameHash(filepath) {
  return createHash$2("md5").update(filepath).digest("hex").slice(0, 6);
}
function generateScopedClassName(strategy, name, filename) {
  if (strategy === "scoped") {
    return null;
  }
  if (strategy === "non-scoped") {
    return name;
  }
  const hash = generateCssFilenameHash(filename);
  return `_${name}_${hash}`;
}

function CoverageTransform(ctx) {
  return {
    name: "vitest:coverage-transform",
    transform(srcCode, id) {
      return ctx.coverageProvider?.onFileTransform?.(
        srcCode,
        normalizeRequestId(id),
        this
      );
    }
  };
}

const cssLangs = "\\.(?:css|less|sass|scss|styl|stylus|pcss|postcss)(?:$|\\?)";
const cssLangRE = new RegExp(cssLangs);
const cssModuleRE = new RegExp(`\\.module${cssLangs}`);
const cssInlineRE = /[?&]inline(?:&|$)/;
function isCSS(id) {
  return cssLangRE.test(id);
}
function isCSSModule(id) {
  return cssModuleRE.test(id);
}
function isInline(id) {
  return cssInlineRE.test(id);
}
function getCSSModuleProxyReturn(strategy, filename) {
  if (strategy === "non-scoped") {
    return "style";
  }
  const hash = generateCssFilenameHash(filename);
  return `\`_\${style}_${hash}\``;
}
function CSSEnablerPlugin(ctx) {
  const shouldProcessCSS = (id) => {
    const { css } = ctx.config;
    if (typeof css === "boolean") {
      return css;
    }
    if (toArray(css.exclude).some((re) => re.test(id))) {
      return false;
    }
    if (toArray(css.include).some((re) => re.test(id))) {
      return true;
    }
    return false;
  };
  return [
    {
      name: "vitest:css-disable",
      enforce: "pre",
      transform(code, id) {
        if (!isCSS(id)) {
          return;
        }
        if (!shouldProcessCSS(id)) {
          return { code: "" };
        }
      }
    },
    {
      name: "vitest:css-empty-post",
      enforce: "post",
      transform(_, id) {
        if (!isCSS(id) || shouldProcessCSS(id)) {
          return;
        }
        if (isCSSModule(id) && !isInline(id)) {
          const scopeStrategy = typeof ctx.config.css !== "boolean" && ctx.config.css.modules?.classNameStrategy || "stable";
          const proxyReturn = getCSSModuleProxyReturn(
            scopeStrategy,
            relative(ctx.config.root, id)
          );
          const code = `export default new Proxy(Object.create(null), {
            get(_, style) {
              return ${proxyReturn};
            },
          })`;
          return { code };
        }
        return { code: 'export default ""' };
      }
    }
  ];
}

// Copyright 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023 Simon Lydell
// License: MIT.
var HashbangComment, Identifier, JSXIdentifier, JSXPunctuator, JSXString, JSXText, KeywordsWithExpressionAfter, KeywordsWithNoLineTerminatorAfter, LineTerminatorSequence, MultiLineComment, Newline, NumericLiteral, Punctuator, RegularExpressionLiteral, SingleLineComment, StringLiteral, Template, TokensNotPrecedingObjectLiteral, TokensPrecedingExpression, WhiteSpace;
RegularExpressionLiteral = /\/(?![*\/])(?:\[(?:[^\]\\\n\r\u2028\u2029]+|\\.)*\]|[^\/\\\n\r\u2028\u2029]+|\\.)*(\/[$_\u200C\u200D\p{ID_Continue}]*|\\)?/yu;
Punctuator = /--|\+\+|=>|\.{3}|\??\.(?!\d)|(?:&&|\|\||\?\?|[+\-%&|^]|\*{1,2}|<{1,2}|>{1,3}|!=?|={1,2}|\/(?![\/*]))=?|[?~,:;[\](){}]/y;
Identifier = /(\x23?)(?=[$_\p{ID_Start}\\])(?:[$_\u200C\u200D\p{ID_Continue}]+|\\u[\da-fA-F]{4}|\\u\{[\da-fA-F]+\})+/yu;
StringLiteral = /(['"])(?:[^'"\\\n\r]+|(?!\1)['"]|\\(?:\r\n|[^]))*(\1)?/y;
NumericLiteral = /(?:0[xX][\da-fA-F](?:_?[\da-fA-F])*|0[oO][0-7](?:_?[0-7])*|0[bB][01](?:_?[01])*)n?|0n|[1-9](?:_?\d)*n|(?:(?:0(?!\d)|0\d*[89]\d*|[1-9](?:_?\d)*)(?:\.(?:\d(?:_?\d)*)?)?|\.\d(?:_?\d)*)(?:[eE][+-]?\d(?:_?\d)*)?|0[0-7]+/y;
Template = /[`}](?:[^`\\$]+|\\[^]|\$(?!\{))*(`|\$\{)?/y;
WhiteSpace = /[\t\v\f\ufeff\p{Zs}]+/yu;
LineTerminatorSequence = /\r?\n|[\r\u2028\u2029]/y;
MultiLineComment = /\/\*(?:[^*]+|\*(?!\/))*(\*\/)?/y;
SingleLineComment = /\/\/.*/y;
HashbangComment = /^#!.*/;
JSXPunctuator = /[<>.:={}]|\/(?![\/*])/y;
JSXIdentifier = /[$_\p{ID_Start}][$_\u200C\u200D\p{ID_Continue}-]*/yu;
JSXString = /(['"])(?:[^'"]+|(?!\1)['"])*(\1)?/y;
JSXText = /[^<>{}]+/y;
TokensPrecedingExpression = /^(?:[\/+-]|\.{3}|\?(?:InterpolationIn(?:JSX|Template)|NoLineTerminatorHere|NonExpressionParenEnd|UnaryIncDec))?$|[{}([,;<>=*%&|^!~?:]$/;
TokensNotPrecedingObjectLiteral = /^(?:=>|[;\]){}]|else|\?(?:NoLineTerminatorHere|NonExpressionParenEnd))?$/;
KeywordsWithExpressionAfter = /^(?:await|case|default|delete|do|else|instanceof|new|return|throw|typeof|void|yield)$/;
KeywordsWithNoLineTerminatorAfter = /^(?:return|throw|yield)$/;
Newline = RegExp(LineTerminatorSequence.source);
var jsTokens_1 = function*(input, {jsx = false} = {}) {
	var braces, firstCodePoint, isExpression, lastIndex, lastSignificantToken, length, match, mode, nextLastIndex, nextLastSignificantToken, parenNesting, postfixIncDec, punctuator, stack;
	({length} = input);
	lastIndex = 0;
	lastSignificantToken = "";
	stack = [
		{tag: "JS"}
	];
	braces = [];
	parenNesting = 0;
	postfixIncDec = false;
	if (match = HashbangComment.exec(input)) {
		yield ({
			type: "HashbangComment",
			value: match[0]
		});
		lastIndex = match[0].length;
	}
	while (lastIndex < length) {
		mode = stack[stack.length - 1];
		switch (mode.tag) {
			case "JS":
			case "JSNonExpressionParen":
			case "InterpolationInTemplate":
			case "InterpolationInJSX":
				if (input[lastIndex] === "/" && (TokensPrecedingExpression.test(lastSignificantToken) || KeywordsWithExpressionAfter.test(lastSignificantToken))) {
					RegularExpressionLiteral.lastIndex = lastIndex;
					if (match = RegularExpressionLiteral.exec(input)) {
						lastIndex = RegularExpressionLiteral.lastIndex;
						lastSignificantToken = match[0];
						postfixIncDec = true;
						yield ({
							type: "RegularExpressionLiteral",
							value: match[0],
							closed: match[1] !== void 0 && match[1] !== "\\"
						});
						continue;
					}
				}
				Punctuator.lastIndex = lastIndex;
				if (match = Punctuator.exec(input)) {
					punctuator = match[0];
					nextLastIndex = Punctuator.lastIndex;
					nextLastSignificantToken = punctuator;
					switch (punctuator) {
						case "(":
							if (lastSignificantToken === "?NonExpressionParenKeyword") {
								stack.push({
									tag: "JSNonExpressionParen",
									nesting: parenNesting
								});
							}
							parenNesting++;
							postfixIncDec = false;
							break;
						case ")":
							parenNesting--;
							postfixIncDec = true;
							if (mode.tag === "JSNonExpressionParen" && parenNesting === mode.nesting) {
								stack.pop();
								nextLastSignificantToken = "?NonExpressionParenEnd";
								postfixIncDec = false;
							}
							break;
						case "{":
							Punctuator.lastIndex = 0;
							isExpression = !TokensNotPrecedingObjectLiteral.test(lastSignificantToken) && (TokensPrecedingExpression.test(lastSignificantToken) || KeywordsWithExpressionAfter.test(lastSignificantToken));
							braces.push(isExpression);
							postfixIncDec = false;
							break;
						case "}":
							switch (mode.tag) {
								case "InterpolationInTemplate":
									if (braces.length === mode.nesting) {
										Template.lastIndex = lastIndex;
										match = Template.exec(input);
										lastIndex = Template.lastIndex;
										lastSignificantToken = match[0];
										if (match[1] === "${") {
											lastSignificantToken = "?InterpolationInTemplate";
											postfixIncDec = false;
											yield ({
												type: "TemplateMiddle",
												value: match[0]
											});
										} else {
											stack.pop();
											postfixIncDec = true;
											yield ({
												type: "TemplateTail",
												value: match[0],
												closed: match[1] === "`"
											});
										}
										continue;
									}
									break;
								case "InterpolationInJSX":
									if (braces.length === mode.nesting) {
										stack.pop();
										lastIndex += 1;
										lastSignificantToken = "}";
										yield ({
											type: "JSXPunctuator",
											value: "}"
										});
										continue;
									}
							}
							postfixIncDec = braces.pop();
							nextLastSignificantToken = postfixIncDec ? "?ExpressionBraceEnd" : "}";
							break;
						case "]":
							postfixIncDec = true;
							break;
						case "++":
						case "--":
							nextLastSignificantToken = postfixIncDec ? "?PostfixIncDec" : "?UnaryIncDec";
							break;
						case "<":
							if (jsx && (TokensPrecedingExpression.test(lastSignificantToken) || KeywordsWithExpressionAfter.test(lastSignificantToken))) {
								stack.push({tag: "JSXTag"});
								lastIndex += 1;
								lastSignificantToken = "<";
								yield ({
									type: "JSXPunctuator",
									value: punctuator
								});
								continue;
							}
							postfixIncDec = false;
							break;
						default:
							postfixIncDec = false;
					}
					lastIndex = nextLastIndex;
					lastSignificantToken = nextLastSignificantToken;
					yield ({
						type: "Punctuator",
						value: punctuator
					});
					continue;
				}
				Identifier.lastIndex = lastIndex;
				if (match = Identifier.exec(input)) {
					lastIndex = Identifier.lastIndex;
					nextLastSignificantToken = match[0];
					switch (match[0]) {
						case "for":
						case "if":
						case "while":
						case "with":
							if (lastSignificantToken !== "." && lastSignificantToken !== "?.") {
								nextLastSignificantToken = "?NonExpressionParenKeyword";
							}
					}
					lastSignificantToken = nextLastSignificantToken;
					postfixIncDec = !KeywordsWithExpressionAfter.test(match[0]);
					yield ({
						type: match[1] === "#" ? "PrivateIdentifier" : "IdentifierName",
						value: match[0]
					});
					continue;
				}
				StringLiteral.lastIndex = lastIndex;
				if (match = StringLiteral.exec(input)) {
					lastIndex = StringLiteral.lastIndex;
					lastSignificantToken = match[0];
					postfixIncDec = true;
					yield ({
						type: "StringLiteral",
						value: match[0],
						closed: match[2] !== void 0
					});
					continue;
				}
				NumericLiteral.lastIndex = lastIndex;
				if (match = NumericLiteral.exec(input)) {
					lastIndex = NumericLiteral.lastIndex;
					lastSignificantToken = match[0];
					postfixIncDec = true;
					yield ({
						type: "NumericLiteral",
						value: match[0]
					});
					continue;
				}
				Template.lastIndex = lastIndex;
				if (match = Template.exec(input)) {
					lastIndex = Template.lastIndex;
					lastSignificantToken = match[0];
					if (match[1] === "${") {
						lastSignificantToken = "?InterpolationInTemplate";
						stack.push({
							tag: "InterpolationInTemplate",
							nesting: braces.length
						});
						postfixIncDec = false;
						yield ({
							type: "TemplateHead",
							value: match[0]
						});
					} else {
						postfixIncDec = true;
						yield ({
							type: "NoSubstitutionTemplate",
							value: match[0],
							closed: match[1] === "`"
						});
					}
					continue;
				}
				break;
			case "JSXTag":
			case "JSXTagEnd":
				JSXPunctuator.lastIndex = lastIndex;
				if (match = JSXPunctuator.exec(input)) {
					lastIndex = JSXPunctuator.lastIndex;
					nextLastSignificantToken = match[0];
					switch (match[0]) {
						case "<":
							stack.push({tag: "JSXTag"});
							break;
						case ">":
							stack.pop();
							if (lastSignificantToken === "/" || mode.tag === "JSXTagEnd") {
								nextLastSignificantToken = "?JSX";
								postfixIncDec = true;
							} else {
								stack.push({tag: "JSXChildren"});
							}
							break;
						case "{":
							stack.push({
								tag: "InterpolationInJSX",
								nesting: braces.length
							});
							nextLastSignificantToken = "?InterpolationInJSX";
							postfixIncDec = false;
							break;
						case "/":
							if (lastSignificantToken === "<") {
								stack.pop();
								if (stack[stack.length - 1].tag === "JSXChildren") {
									stack.pop();
								}
								stack.push({tag: "JSXTagEnd"});
							}
					}
					lastSignificantToken = nextLastSignificantToken;
					yield ({
						type: "JSXPunctuator",
						value: match[0]
					});
					continue;
				}
				JSXIdentifier.lastIndex = lastIndex;
				if (match = JSXIdentifier.exec(input)) {
					lastIndex = JSXIdentifier.lastIndex;
					lastSignificantToken = match[0];
					yield ({
						type: "JSXIdentifier",
						value: match[0]
					});
					continue;
				}
				JSXString.lastIndex = lastIndex;
				if (match = JSXString.exec(input)) {
					lastIndex = JSXString.lastIndex;
					lastSignificantToken = match[0];
					yield ({
						type: "JSXString",
						value: match[0],
						closed: match[2] !== void 0
					});
					continue;
				}
				break;
			case "JSXChildren":
				JSXText.lastIndex = lastIndex;
				if (match = JSXText.exec(input)) {
					lastIndex = JSXText.lastIndex;
					lastSignificantToken = match[0];
					yield ({
						type: "JSXText",
						value: match[0]
					});
					continue;
				}
				switch (input[lastIndex]) {
					case "<":
						stack.push({tag: "JSXTag"});
						lastIndex++;
						lastSignificantToken = "<";
						yield ({
							type: "JSXPunctuator",
							value: "<"
						});
						continue;
					case "{":
						stack.push({
							tag: "InterpolationInJSX",
							nesting: braces.length
						});
						lastIndex++;
						lastSignificantToken = "?InterpolationInJSX";
						postfixIncDec = false;
						yield ({
							type: "JSXPunctuator",
							value: "{"
						});
						continue;
				}
		}
		WhiteSpace.lastIndex = lastIndex;
		if (match = WhiteSpace.exec(input)) {
			lastIndex = WhiteSpace.lastIndex;
			yield ({
				type: "WhiteSpace",
				value: match[0]
			});
			continue;
		}
		LineTerminatorSequence.lastIndex = lastIndex;
		if (match = LineTerminatorSequence.exec(input)) {
			lastIndex = LineTerminatorSequence.lastIndex;
			postfixIncDec = false;
			if (KeywordsWithNoLineTerminatorAfter.test(lastSignificantToken)) {
				lastSignificantToken = "?NoLineTerminatorHere";
			}
			yield ({
				type: "LineTerminatorSequence",
				value: match[0]
			});
			continue;
		}
		MultiLineComment.lastIndex = lastIndex;
		if (match = MultiLineComment.exec(input)) {
			lastIndex = MultiLineComment.lastIndex;
			if (Newline.test(match[0])) {
				postfixIncDec = false;
				if (KeywordsWithNoLineTerminatorAfter.test(lastSignificantToken)) {
					lastSignificantToken = "?NoLineTerminatorHere";
				}
			}
			yield ({
				type: "MultiLineComment",
				value: match[0],
				closed: match[1] !== void 0
			});
			continue;
		}
		SingleLineComment.lastIndex = lastIndex;
		if (match = SingleLineComment.exec(input)) {
			lastIndex = SingleLineComment.lastIndex;
			postfixIncDec = false;
			yield ({
				type: "SingleLineComment",
				value: match[0]
			});
			continue;
		}
		firstCodePoint = String.fromCodePoint(input.codePointAt(lastIndex));
		lastIndex += firstCodePoint.length;
		lastSignificantToken = firstCodePoint;
		postfixIncDec = false;
		yield ({
			type: mode.tag.startsWith("JSX") ? "JSXInvalid" : "Invalid",
			value: firstCodePoint
		});
	}
	return void 0;
};

var jsTokens = /*@__PURE__*/getDefaultExportFromCjs(jsTokens_1);

function stripLiteralJsTokens(code, options) {
  const FILL = " ";
  const FILL_COMMENT = " ";
  let result = "";
  const tokens = [];
  for (const token of jsTokens(code, { jsx: false })) {
    tokens.push(token);
    if (token.type === "SingleLineComment") {
      result += FILL_COMMENT.repeat(token.value.length);
      continue;
    }
    if (token.type === "MultiLineComment") {
      result += token.value.replace(/[^\n]/g, FILL_COMMENT);
      continue;
    }
    if (token.type === "StringLiteral") {
      if (!token.closed) {
        result += token.value;
        continue;
      }
      const body = token.value.slice(1, -1);
      {
        result += token.value[0] + FILL.repeat(body.length) + token.value[token.value.length - 1];
        continue;
      }
    }
    if (token.type === "NoSubstitutionTemplate") {
      const body = token.value.slice(1, -1);
      {
        result += `\`${body.replace(/[^\n]/g, FILL)}\``;
        continue;
      }
    }
    if (token.type === "RegularExpressionLiteral") {
      const body = token.value;
      {
        result += body.replace(/\/(.*)\/(\w?)$/g, (_, $1, $2) => `/${FILL.repeat($1.length)}/${$2}`);
        continue;
      }
    }
    if (token.type === "TemplateHead") {
      const body = token.value.slice(1, -2);
      {
        result += `\`${body.replace(/[^\n]/g, FILL)}\${`;
        continue;
      }
    }
    if (token.type === "TemplateTail") {
      const body = token.value.slice(0, -2);
      {
        result += `}${body.replace(/[^\n]/g, FILL)}\``;
        continue;
      }
    }
    if (token.type === "TemplateMiddle") {
      const body = token.value.slice(1, -2);
      {
        result += `}${body.replace(/[^\n]/g, FILL)}\${`;
        continue;
      }
    }
    result += token.value;
  }
  return {
    result,
    tokens
  };
}

function stripLiteral(code, options) {
  return stripLiteralDetailed(code).result;
}
function stripLiteralDetailed(code, options) {
  return stripLiteralJsTokens(code);
}

function SsrReplacerPlugin() {
  return {
    name: "vitest:ssr-replacer",
    enforce: "pre",
    transform(code, id) {
      if (!/\bimport\.meta\.env\b/.test(code)) {
        return null;
      }
      let s = null;
      const cleanCode = stripLiteral(code);
      const envs = cleanCode.matchAll(/\bimport\.meta\.env\b/g);
      for (const env of envs) {
        s ||= new MagicString(code);
        const startIndex = env.index;
        const endIndex = startIndex + env[0].length;
        s.overwrite(startIndex, endIndex, "__vite_ssr_import_meta__.env");
      }
      if (s) {
        return {
          code: s.toString(),
          map: s.generateMap({
            hires: "boundary",
            // Remove possible query parameters, e.g. vue's "?vue&type=script&src=true&lang.ts"
            source: cleanUrl(id)
          })
        };
      }
    }
  };
}

const API_NOT_FOUND_ERROR = `There are some problems in resolving the mocks API.
You may encounter this issue when importing the mocks API from another module other than 'vitest'.
To fix this issue you can either:
- import the mocks API directly from 'vitest'
- enable the 'globals' options`;
const API_NOT_FOUND_CHECK = `
if (typeof globalThis.vi === "undefined" && typeof globalThis.vitest === "undefined") { throw new Error(${JSON.stringify(API_NOT_FOUND_ERROR)}) }
`;
function isIdentifier(node) {
  return node.type === "Identifier";
}
function transformImportSpecifiers(node) {
  const dynamicImports = node.specifiers.map((specifier) => {
    if (specifier.type === "ImportDefaultSpecifier") {
      return `default: ${specifier.local.name}`;
    }
    if (specifier.type === "ImportSpecifier") {
      const local = specifier.local.name;
      const imported = specifier.imported.name;
      if (local === imported) {
        return local;
      }
      return `${imported}: ${local}`;
    }
    return null;
  }).filter(Boolean).join(", ");
  if (!dynamicImports.length) {
    return "";
  }
  return `{ ${dynamicImports} }`;
}
function getBetterEnd(code, node) {
  let end = node.end;
  if (code[node.end] === ";") {
    end += 1;
  }
  if (code[node.end + 1] === "\n") {
    end += 1;
  }
  return end;
}
const regexpHoistable = /\b(?:vi|vitest)\s*\.\s*(?:mock|unmock|hoisted|doMock|doUnmock)\(/;
const hashbangRE = /^#!.*\n/;
function hoistMocks(code, id, parse, colors) {
  const needHoisting = regexpHoistable.test(code);
  if (!needHoisting) {
    return;
  }
  const s = new MagicString(code);
  let ast;
  try {
    ast = parse(code);
  } catch (err) {
    console.error(`Cannot parse ${id}:
${err.message}`);
    return;
  }
  const hoistIndex = code.match(hashbangRE)?.[0].length ?? 0;
  let hoistedVitestImports = "";
  let uid = 0;
  const idToImportMap = /* @__PURE__ */ new Map();
  const transformImportDeclaration = (node) => {
    const source = node.source.value;
    const importId = `__vi_import_${uid++}__`;
    const hasSpecifiers = node.specifiers.length > 0;
    const code2 = hasSpecifiers ? `const ${importId} = await import('${source}')
` : `await import('${source}')
`;
    return {
      code: code2,
      id: importId
    };
  };
  function defineImport(node) {
    if (node.source.value === "vitest") {
      const code2 = `const ${transformImportSpecifiers(
        node
      )} = await import('vitest')
`;
      hoistedVitestImports += code2;
      s.remove(node.start, getBetterEnd(code2, node));
      return;
    }
    const declaration = transformImportDeclaration(node);
    if (!declaration) {
      return null;
    }
    s.appendLeft(hoistIndex, declaration.code);
    return declaration.id;
  }
  for (const node of ast.body) {
    if (node.type === "ImportDeclaration") {
      const importId = defineImport(node);
      if (!importId) {
        continue;
      }
      s.remove(node.start, getBetterEnd(code, node));
      for (const spec of node.specifiers) {
        if (spec.type === "ImportSpecifier") {
          idToImportMap.set(
            spec.local.name,
            `${importId}.${spec.imported.name}`
          );
        } else if (spec.type === "ImportDefaultSpecifier") {
          idToImportMap.set(spec.local.name, `${importId}.default`);
        } else {
          idToImportMap.set(spec.local.name, importId);
        }
      }
    }
  }
  const declaredConst = /* @__PURE__ */ new Set();
  const hoistedNodes = [];
  function createSyntaxError(node, message) {
    const _error = new SyntaxError(message);
    Error.captureStackTrace(_error, createSyntaxError);
    return {
      name: "SyntaxError",
      message: _error.message,
      stack: _error.stack,
      frame: generateCodeFrame(
        highlightCode(id, code),
        4,
        node.start + 1
      )
    };
  }
  function assertNotDefaultExport(node, error) {
    const defaultExport = findNodeAround(
      ast,
      node.start,
      "ExportDefaultDeclaration"
    )?.node;
    if (defaultExport?.declaration === node || defaultExport?.declaration.type === "AwaitExpression" && defaultExport.declaration.argument === node) {
      throw createSyntaxError(defaultExport, error);
    }
  }
  function assertNotNamedExport(node, error) {
    const nodeExported = findNodeAround(
      ast,
      node.start,
      "ExportNamedDeclaration"
    )?.node;
    if (nodeExported?.declaration === node) {
      throw createSyntaxError(nodeExported, error);
    }
  }
  function getVariableDeclaration(node) {
    const declarationNode = findNodeAround(
      ast,
      node.start,
      "VariableDeclaration"
    )?.node;
    const init = declarationNode?.declarations[0]?.init;
    if (init && (init === node || init.type === "AwaitExpression" && init.argument === node)) {
      return declarationNode;
    }
  }
  esmWalker(ast, {
    onIdentifier(id2, info, parentStack) {
      const binding = idToImportMap.get(id2.name);
      if (!binding) {
        return;
      }
      if (info.hasBindingShortcut) {
        s.appendLeft(id2.end, `: ${binding}`);
      } else if (info.classDeclaration) {
        if (!declaredConst.has(id2.name)) {
          declaredConst.add(id2.name);
          const topNode = parentStack[parentStack.length - 2];
          s.prependRight(topNode.start, `const ${id2.name} = ${binding};
`);
        }
      } else if (
        // don't transform class name identifier
        !info.classExpression
      ) {
        s.update(id2.start, id2.end, binding);
      }
    },
    onCallExpression(node) {
      if (node.callee.type === "MemberExpression" && isIdentifier(node.callee.object) && (node.callee.object.name === "vi" || node.callee.object.name === "vitest") && isIdentifier(node.callee.property)) {
        const methodName = node.callee.property.name;
        if (methodName === "mock" || methodName === "unmock") {
          const method = `${node.callee.object.name}.${methodName}`;
          assertNotDefaultExport(
            node,
            `Cannot export the result of "${method}". Remove export declaration because "${method}" doesn't return anything.`
          );
          const declarationNode = getVariableDeclaration(node);
          if (declarationNode) {
            assertNotNamedExport(
              declarationNode,
              `Cannot export the result of "${method}". Remove export declaration because "${method}" doesn't return anything.`
            );
          }
          hoistedNodes.push(node);
        }
        if (methodName === "doMock" || methodName === "doUnmock") {
          const moduleInfo = node.arguments[0];
          let source = null;
          if (moduleInfo.type === "ImportExpression") {
            source = moduleInfo.source;
          }
          if (moduleInfo.type === "AwaitExpression" && moduleInfo.argument.type === "ImportExpression") {
            source = moduleInfo.argument.source;
          }
          if (source) {
            s.overwrite(
              moduleInfo.start,
              moduleInfo.end,
              s.slice(source.start, source.end)
            );
          }
        }
        if (methodName === "hoisted") {
          assertNotDefaultExport(
            node,
            "Cannot export hoisted variable. You can control hoisting behavior by placing the import from this file first."
          );
          const declarationNode = getVariableDeclaration(node);
          if (declarationNode) {
            assertNotNamedExport(
              declarationNode,
              "Cannot export hoisted variable. You can control hoisting behavior by placing the import from this file first."
            );
            hoistedNodes.push(declarationNode);
          } else {
            const awaitedExpression = findNodeAround(
              ast,
              node.start,
              "AwaitExpression"
            )?.node;
            hoistedNodes.push(
              awaitedExpression?.argument === node ? awaitedExpression : node
            );
          }
        }
      }
    }
  });
  function getNodeName(node) {
    const callee = node.callee || {};
    if (callee.type === "MemberExpression" && isIdentifier(callee.property) && isIdentifier(callee.object)) {
      return `${callee.object.name}.${callee.property.name}()`;
    }
    return '"hoisted method"';
  }
  function getNodeCall(node) {
    if (node.type === "CallExpression") {
      return node;
    }
    if (node.type === "VariableDeclaration") {
      const { declarations } = node;
      const init = declarations[0].init;
      if (init) {
        return getNodeCall(init);
      }
    }
    if (node.type === "AwaitExpression") {
      const { argument } = node;
      if (argument.type === "CallExpression") {
        return getNodeCall(argument);
      }
    }
    return node;
  }
  function createError(outsideNode, insideNode) {
    const outsideCall = getNodeCall(outsideNode);
    const insideCall = getNodeCall(insideNode);
    throw createSyntaxError(
      insideCall,
      `Cannot call ${getNodeName(insideCall)} inside ${getNodeName(
        outsideCall
      )}: both methods are hoisted to the top of the file and not actually called inside each other.`
    );
  }
  function rewriteMockDynamicImport(nodeCode, moduleInfo, expressionStart, expressionEnd, mockStart) {
    const source = moduleInfo.source;
    const importPath = s.slice(source.start, source.end);
    const nodeCodeStart = expressionStart - mockStart;
    const nodeCodeEnd = expressionEnd - mockStart;
    return nodeCode.slice(0, nodeCodeStart) + importPath + nodeCode.slice(nodeCodeEnd);
  }
  for (let i = 0; i < hoistedNodes.length; i++) {
    const node = hoistedNodes[i];
    for (let j = i + 1; j < hoistedNodes.length; j++) {
      const otherNode = hoistedNodes[j];
      if (node.start >= otherNode.start && node.end <= otherNode.end) {
        throw createError(otherNode, node);
      }
      if (otherNode.start >= node.start && otherNode.end <= node.end) {
        throw createError(node, otherNode);
      }
    }
  }
  const hoistedCode = hoistedNodes.map((node) => {
    const end = getBetterEnd(code, node);
    let nodeCode = s.slice(node.start, end);
    if (node.type === "CallExpression" && node.callee.type === "MemberExpression" && (node.callee.property.name === "mock" || node.callee.property.name === "unmock")) {
      const moduleInfo = node.arguments[0];
      if (moduleInfo.type === "ImportExpression") {
        nodeCode = rewriteMockDynamicImport(
          nodeCode,
          moduleInfo,
          moduleInfo.start,
          moduleInfo.end,
          node.start
        );
      }
      if (moduleInfo.type === "AwaitExpression" && moduleInfo.argument.type === "ImportExpression") {
        nodeCode = rewriteMockDynamicImport(
          nodeCode,
          moduleInfo.argument,
          moduleInfo.start,
          moduleInfo.end,
          node.start
        );
      }
    }
    s.remove(node.start, end);
    return `${nodeCode}${nodeCode.endsWith("\n") ? "" : "\n"}`;
  }).join("");
  if (hoistedCode || hoistedVitestImports) {
    s.prepend(
      hoistedVitestImports + (!hoistedVitestImports && hoistedCode ? API_NOT_FOUND_CHECK : "") + hoistedCode
    );
  }
  return {
    ast,
    code: s.toString(),
    map: s.generateMap({ hires: "boundary", source: id })
  };
}

function automockModule(code, parse) {
  const ast = parse(code);
  const m = new MagicString(code);
  const allSpecifiers = [];
  let importIndex = 0;
  for (const _node of ast.body) {
    if (_node.type === "ExportAllDeclaration") {
      throw new Error(
        `automocking files with \`export *\` is not supported in browser mode because it cannot be statically analysed`
      );
    }
    if (_node.type === "ExportNamedDeclaration") {
      let traversePattern2 = function(expression) {
        if (expression.type === "Identifier") {
          allSpecifiers.push({ name: expression.name });
        } else if (expression.type === "ArrayPattern") {
          expression.elements.forEach((element) => {
            if (!element) {
              return;
            }
            traversePattern2(element);
          });
        } else if (expression.type === "ObjectPattern") {
          expression.properties.forEach((property) => {
            if (property.type === "RestElement") {
              traversePattern2(property);
            } else if (property.type === "Property") {
              traversePattern2(property.value);
            } else ;
          });
        } else if (expression.type === "RestElement") {
          traversePattern2(expression.argument);
        } else if (expression.type === "AssignmentPattern") {
          throw new Error(
            `AssignmentPattern is not supported. Please open a new bug report.`
          );
        } else if (expression.type === "MemberExpression") {
          throw new Error(
            `MemberExpression is not supported. Please open a new bug report.`
          );
        } else ;
      };
      const node = _node;
      const declaration = node.declaration;
      if (declaration) {
        if (declaration.type === "FunctionDeclaration") {
          allSpecifiers.push({ name: declaration.id.name });
        } else if (declaration.type === "VariableDeclaration") {
          declaration.declarations.forEach((declaration2) => {
            traversePattern2(declaration2.id);
          });
        } else if (declaration.type === "ClassDeclaration") {
          allSpecifiers.push({ name: declaration.id.name });
        } else ;
        m.remove(node.start, declaration.start);
      }
      const specifiers = node.specifiers || [];
      const source = node.source;
      if (!source && specifiers.length) {
        specifiers.forEach((specifier) => {
          const exported = specifier.exported;
          allSpecifiers.push({
            alias: exported.type === "Literal" ? exported.raw : exported.name,
            name: specifier.local.name
          });
        });
        m.remove(node.start, node.end);
      } else if (source && specifiers.length) {
        const importNames = [];
        specifiers.forEach((specifier) => {
          const importedName = `__vitest_imported_${importIndex++}__`;
          const exported = specifier.exported;
          importNames.push([specifier.local.name, importedName]);
          allSpecifiers.push({
            name: importedName,
            alias: exported.type === "Literal" ? exported.raw : exported.name
          });
        });
        const importString = `import { ${importNames.map(([name, alias]) => `${name} as ${alias}`).join(", ")} } from '${source.value}'`;
        m.overwrite(node.start, node.end, importString);
      }
    }
    if (_node.type === "ExportDefaultDeclaration") {
      const node = _node;
      const declaration = node.declaration;
      allSpecifiers.push({ name: "__vitest_default", alias: "default" });
      m.overwrite(node.start, declaration.start, `const __vitest_default = `);
    }
  }
  const moduleObject = `
const __vitest_es_current_module__ = {
  __esModule: true,
  ${allSpecifiers.map(({ name }) => `["${name}"]: ${name},`).join("\n  ")}
}
const __vitest_mocked_module__ = __vitest_mocker__.mockObject(__vitest_es_current_module__)
`;
  const assigning = allSpecifiers.map(({ name }, index) => {
    return `const __vitest_mocked_${index}__ = __vitest_mocked_module__["${name}"]`;
  }).join("\n");
  const redeclarations = allSpecifiers.map(({ name, alias }, index) => {
    return `  __vitest_mocked_${index}__ as ${alias || name},`;
  }).join("\n");
  const specifiersExports = `
export {
${redeclarations}
}
`;
  m.append(moduleObject + assigning + specifiersExports);
  return m;
}

function MocksPlugins() {
  return [
    {
      name: "vitest:mocks",
      enforce: "post",
      transform(code, id) {
        if (id.includes(distDir)) {
          return;
        }
        return hoistMocks(code, id, this.parse);
      }
    },
    {
      name: "vitest:automock",
      enforce: "post",
      transform(code, id) {
        if (id.includes("mock=auto")) {
          const ms = automockModule(code, this.parse);
          return {
            code: ms.toString(),
            map: ms.generateMap({ hires: true, source: cleanUrl(id) })
          };
        }
      }
    }
  ];
}

function resolveOptimizerConfig(_testOptions, viteOptions, testConfig) {
  const testOptions = _testOptions || {};
  const newConfig = {};
  const [major, minor, fix] = version.split(".").map(Number);
  const allowed = major >= 5 || major === 4 && minor >= 4 || major === 4 && minor === 3 && fix >= 2;
  if (!allowed && testOptions?.enabled === true) {
    console.warn(
      `Vitest: "deps.optimizer" is only available in Vite >= 4.3.2, current Vite version: ${version}`
    );
  } else {
    testOptions.enabled ??= false;
  }
  if (!allowed || testOptions?.enabled !== true) {
    newConfig.cacheDir = void 0;
    newConfig.optimizeDeps = {
      // experimental in Vite >2.9.2, entries remains to help with older versions
      disabled: true,
      entries: []
    };
  } else {
    const root = testConfig.root ?? process.cwd();
    const cacheDir = testConfig.cache !== false ? testConfig.cache?.dir : void 0;
    const currentInclude = testOptions.include || viteOptions?.include || [];
    const exclude = [
      "vitest",
      // Ideally, we shouldn't optimize react in test mode, otherwise we need to optimize _every_ dependency that uses react.
      "react",
      "vue",
      ...testOptions.exclude || viteOptions?.exclude || []
    ];
    const runtime = currentInclude.filter(
      (n) => n.endsWith("jsx-dev-runtime") || n.endsWith("jsx-runtime")
    );
    exclude.push(...runtime);
    const include = (testOptions.include || viteOptions?.include || []).filter(
      (n) => !exclude.includes(n)
    );
    newConfig.cacheDir = cacheDir ?? VitestCache.resolveCacheDir(root, cacheDir, testConfig.name);
    newConfig.optimizeDeps = {
      ...viteOptions,
      ...testOptions,
      noDiscovery: true,
      disabled: false,
      entries: [],
      exclude,
      include
    };
  }
  if (major >= 5 && minor >= 1) {
    if (newConfig.optimizeDeps.disabled) {
      newConfig.optimizeDeps.noDiscovery = true;
      newConfig.optimizeDeps.include = [];
    }
    delete newConfig.optimizeDeps.disabled;
  }
  return newConfig;
}
function deleteDefineConfig(viteConfig) {
  const defines = {};
  if (viteConfig.define) {
    delete viteConfig.define["import.meta.vitest"];
    delete viteConfig.define["process.env"];
    delete viteConfig.define.process;
    delete viteConfig.define.global;
  }
  for (const key in viteConfig.define) {
    const val = viteConfig.define[key];
    let replacement;
    try {
      replacement = typeof val === "string" ? JSON.parse(val) : val;
    } catch {
      continue;
    }
    if (key.startsWith("import.meta.env.")) {
      const envKey = key.slice("import.meta.env.".length);
      process.env[envKey] = replacement;
      delete viteConfig.define[key];
    } else if (key.startsWith("process.env.")) {
      const envKey = key.slice("process.env.".length);
      process.env[envKey] = replacement;
      delete viteConfig.define[key];
    } else if (!key.includes(".")) {
      defines[key] = replacement;
      delete viteConfig.define[key];
    }
  }
  return defines;
}
function hijackVitePluginInject(viteConfig) {
  const processEnvPlugin = viteConfig.plugins.find(
    (p) => p.name === "vite:client-inject"
  );
  if (processEnvPlugin) {
    const originalTransform = processEnvPlugin.transform;
    processEnvPlugin.transform = function transform(code, id, options) {
      return originalTransform.call(this, code, id, { ...options, ssr: true });
    };
  }
}
function resolveFsAllow(projectRoot, rootConfigFile) {
  if (!rootConfigFile) {
    return [searchForWorkspaceRoot(projectRoot), rootDir];
  }
  return [
    dirname(rootConfigFile),
    searchForWorkspaceRoot(projectRoot),
    rootDir
  ];
}

function VitestResolver(ctx) {
  return {
    name: "vitest:resolve-root",
    enforce: "pre",
    async resolveId(id) {
      if (id === "vitest" || id.startsWith("@vitest/")) {
        return this.resolve(id, join(ctx.config.root, "index.html"), {
          skipSelf: true
        });
      }
    }
  };
}

function VitestOptimizer() {
  return {
    name: "vitest:normalize-optimizer",
    config: {
      order: "post",
      handler(viteConfig) {
        const testConfig = viteConfig.test || {};
        const webOptimizer = resolveOptimizerConfig(
          testConfig.deps?.optimizer?.web,
          viteConfig.optimizeDeps,
          testConfig
        );
        const ssrOptimizer = resolveOptimizerConfig(
          testConfig.deps?.optimizer?.ssr,
          viteConfig.ssr?.optimizeDeps,
          testConfig
        );
        viteConfig.cacheDir = webOptimizer.cacheDir || ssrOptimizer.cacheDir || viteConfig.cacheDir;
        viteConfig.optimizeDeps = webOptimizer.optimizeDeps;
        viteConfig.ssr ??= {};
        viteConfig.ssr.optimizeDeps = ssrOptimizer.optimizeDeps;
      }
    }
  };
}

const metaUrlLength = "import.meta.url".length;
const locationString = "self.location".padEnd(metaUrlLength, " ");
function NormalizeURLPlugin() {
  return {
    name: "vitest:normalize-url",
    enforce: "post",
    transform(code, id, options) {
      const ssr = options?.ssr === true;
      if (ssr || !code.includes("new URL") || !code.includes("import.meta.url")) {
        return;
      }
      const cleanString = stripLiteral(code);
      const assetImportMetaUrlRE = /\bnew\s+URL\s*\(\s*(?:'[^']+'|"[^"]+"|`[^`]+`)\s*,\s*import\.meta\.url\s*(?:,\s*)?\)/g;
      let updatedCode = code;
      let match;
      while (match = assetImportMetaUrlRE.exec(cleanString)) {
        const { 0: exp, index } = match;
        const metaUrlIndex = index + exp.indexOf("import.meta.url");
        updatedCode = updatedCode.slice(0, metaUrlIndex) + locationString + updatedCode.slice(metaUrlIndex + metaUrlLength);
      }
      return {
        code: updatedCode,
        map: null
      };
    }
  };
}

function WorkspaceVitestPlugin(project, options) {
  return [
    {
      name: "vitest:project",
      enforce: "pre",
      options() {
        this.meta.watchMode = false;
      },
      config(viteConfig) {
        const defines = deleteDefineConfig(viteConfig);
        const testConfig = viteConfig.test || {};
        const root = testConfig.root || viteConfig.root || options.root;
        let name = testConfig.name;
        if (!name) {
          if (typeof options.workspacePath === "string") {
            const dir = options.workspacePath.endsWith("/") ? options.workspacePath.slice(0, -1) : dirname(options.workspacePath);
            const pkgJsonPath = resolve(dir, "package.json");
            if (existsSync(pkgJsonPath)) {
              name = JSON.parse(readFileSync(pkgJsonPath, "utf-8")).name;
            }
            if (typeof name !== "string" || !name) {
              name = basename(dir);
            }
          } else {
            name = options.workspacePath.toString();
          }
        }
        const config = {
          root,
          resolve: {
            // by default Vite resolves `module` field, which not always a native ESM module
            // setting this option can bypass that and fallback to cjs version
            mainFields: [],
            alias: testConfig.alias,
            conditions: ["node"]
          },
          esbuild: viteConfig.esbuild === false ? false : {
            // Lowest target Vitest supports is Node18
            target: viteConfig.esbuild?.target || "node18",
            sourcemap: "external",
            // Enables using ignore hint for coverage providers with @preserve keyword
            legalComments: "inline"
          },
          server: {
            // disable watch mode in workspaces,
            // because it is handled by the top-level watcher
            watch: null,
            open: false,
            hmr: false,
            preTransformRequests: false,
            middlewareMode: true,
            fs: {
              allow: resolveFsAllow(
                project.ctx.config.root,
                project.ctx.server.config.configFile
              )
            }
          },
          test: {
            name
          }
        };
        config.test.defines = defines;
        const classNameStrategy = typeof testConfig.css !== "boolean" && testConfig.css?.modules?.classNameStrategy || "stable";
        if (classNameStrategy !== "scoped") {
          config.css ??= {};
          config.css.modules ??= {};
          if (config.css.modules) {
            config.css.modules.generateScopedName = (name2, filename) => {
              const root2 = project.config.root;
              return generateScopedClassName(
                classNameStrategy,
                name2,
                relative(root2, filename)
              );
            };
          }
        }
        return config;
      },
      configResolved(viteConfig) {
        hijackVitePluginInject(viteConfig);
      },
      async configureServer(server) {
        const options2 = deepMerge({}, configDefaults, server.config.test || {});
        await project.setServer(options2, server);
        await server.watcher.close();
      }
    },
    SsrReplacerPlugin(),
    ...CSSEnablerPlugin(project),
    CoverageTransform(project.ctx),
    ...MocksPlugins(),
    VitestResolver(project.ctx),
    VitestOptimizer(),
    NormalizeURLPlugin()
  ];
}

async function createViteServer(inlineConfig) {
  const error = console.error;
  console.error = (...args) => {
    if (typeof args[0] === "string" && args[0].includes("WebSocket server error:")) {
      return;
    }
    error(...args);
  };
  const server = await createServer({
    logLevel: "error",
    ...inlineConfig
  });
  console.error = error;
  return server;
}

async function loadGlobalSetupFiles(runner, globalSetup) {
  const globalSetupFiles = toArray$1(globalSetup);
  return Promise.all(
    globalSetupFiles.map((file) => loadGlobalSetupFile(file, runner))
  );
}
async function loadGlobalSetupFile(file, runner) {
  const m = await runner.executeFile(file);
  for (const exp of ["default", "setup", "teardown"]) {
    if (m[exp] != null && typeof m[exp] !== "function") {
      throw new Error(
        `invalid export in globalSetup file ${file}: ${exp} must be a function`
      );
    }
  }
  if (m.default) {
    return {
      file,
      setup: m.default
    };
  } else if (m.setup || m.teardown) {
    return {
      file,
      setup: m.setup,
      teardown: m.teardown
    };
  } else {
    throw new Error(
      `invalid globalSetup file ${file}. Must export setup, teardown or have a default export`
    );
  }
}

function serializeConfig(config, coreConfig, viteConfig) {
  const optimizer = config.deps?.optimizer;
  const poolOptions = config.poolOptions;
  const isolate = viteConfig?.test?.isolate;
  return {
    // TODO: remove functions from environmentOptions
    environmentOptions: config.environmentOptions,
    mode: config.mode,
    isolate: config.isolate,
    base: config.base,
    logHeapUsage: config.logHeapUsage,
    runner: config.runner,
    bail: config.bail,
    defines: config.defines,
    chaiConfig: config.chaiConfig,
    setupFiles: config.setupFiles,
    allowOnly: config.allowOnly,
    testTimeout: config.testTimeout,
    testNamePattern: config.testNamePattern,
    hookTimeout: config.hookTimeout,
    clearMocks: config.clearMocks,
    mockReset: config.mockReset,
    restoreMocks: config.restoreMocks,
    unstubEnvs: config.unstubEnvs,
    unstubGlobals: config.unstubGlobals,
    maxConcurrency: config.maxConcurrency,
    pool: config.pool,
    expect: config.expect,
    snapshotSerializers: config.snapshotSerializers,
    diff: config.diff,
    retry: config.retry,
    disableConsoleIntercept: config.disableConsoleIntercept,
    root: config.root,
    name: config.name,
    globals: config.globals,
    snapshotEnvironment: config.snapshotEnvironment,
    passWithNoTests: config.passWithNoTests,
    coverage: ((coverage) => {
      const htmlReporter = coverage.reporter.find(([reporterName]) => reporterName === "html");
      const subdir = htmlReporter && htmlReporter[1]?.subdir;
      return {
        reportsDirectory: coverage.reportsDirectory,
        provider: coverage.provider,
        enabled: coverage.enabled,
        htmlReporter: htmlReporter ? { subdir } : void 0,
        customProviderModule: "customProviderModule" in coverage ? coverage.customProviderModule : void 0
      };
    })(config.coverage),
    fakeTimers: config.fakeTimers,
    poolOptions: {
      forks: {
        singleFork: poolOptions?.forks?.singleFork ?? coreConfig.poolOptions?.forks?.singleFork ?? false,
        isolate: poolOptions?.forks?.isolate ?? isolate ?? coreConfig.poolOptions?.forks?.isolate ?? true
      },
      threads: {
        singleThread: poolOptions?.threads?.singleThread ?? coreConfig.poolOptions?.threads?.singleThread ?? false,
        isolate: poolOptions?.threads?.isolate ?? isolate ?? coreConfig.poolOptions?.threads?.isolate ?? true
      },
      vmThreads: {
        singleThread: poolOptions?.vmThreads?.singleThread ?? coreConfig.poolOptions?.vmThreads?.singleThread ?? false
      },
      vmForks: {
        singleFork: poolOptions?.vmForks?.singleFork ?? coreConfig.poolOptions?.vmForks?.singleFork ?? false
      }
    },
    deps: {
      web: config.deps.web || {},
      optimizer: {
        web: {
          enabled: optimizer?.web?.enabled ?? true
        },
        ssr: {
          enabled: optimizer?.ssr?.enabled ?? true
        }
      },
      interopDefault: config.deps.interopDefault,
      moduleDirectories: config.deps.moduleDirectories
    },
    snapshotOptions: {
      // TODO: store it differently, not on the config
      snapshotEnvironment: void 0,
      updateSnapshot: coreConfig.snapshotOptions.updateSnapshot,
      snapshotFormat: {
        ...coreConfig.snapshotOptions.snapshotFormat,
        compareKeys: void 0
      },
      expand: config.snapshotOptions.expand ?? coreConfig.snapshotOptions.expand
    },
    sequence: {
      shuffle: coreConfig.sequence.shuffle,
      concurrent: coreConfig.sequence.concurrent,
      seed: coreConfig.sequence.seed,
      hooks: coreConfig.sequence.hooks,
      setupFiles: coreConfig.sequence.setupFiles
    },
    inspect: coreConfig.inspect,
    inspectBrk: coreConfig.inspectBrk,
    inspector: coreConfig.inspector,
    watch: config.watch,
    includeTaskLocation: config.includeTaskLocation ?? coreConfig.includeTaskLocation,
    env: {
      ...viteConfig?.env,
      ...config.env
    },
    browser: ((browser) => {
      return {
        name: browser.name,
        headless: browser.headless,
        isolate: browser.isolate,
        fileParallelism: browser.fileParallelism,
        ui: browser.ui,
        viewport: browser.viewport,
        screenshotFailures: browser.screenshotFailures
      };
    })(config.browser),
    standalone: config.standalone,
    printConsoleTrace: config.printConsoleTrace ?? coreConfig.printConsoleTrace
  };
}

async function initializeProject(workspacePath, ctx, options) {
  const project = new WorkspaceProject(workspacePath, ctx, options);
  const configFile = options.extends ? resolve(dirname(options.workspaceConfigPath), options.extends) : typeof workspacePath === "number" || workspacePath.endsWith("/") ? false : workspacePath;
  const root = options.root || (typeof workspacePath === "number" ? void 0 : workspacePath.endsWith("/") ? workspacePath : dirname(workspacePath));
  const config = {
    ...options,
    root,
    logLevel: "error",
    configFile,
    // this will make "mode": "test" | "benchmark" inside defineConfig
    mode: options.test?.mode || options.mode || ctx.config.mode,
    plugins: [
      ...options.plugins || [],
      WorkspaceVitestPlugin(project, { ...options, root, workspacePath })
    ]
  };
  await createViteServer(config);
  return project;
}
class WorkspaceProject {
  constructor(path, ctx, options) {
    this.path = path;
    this.ctx = ctx;
    this.options = options;
  }
  configOverride;
  config;
  server;
  vitenode;
  runner;
  browser;
  typechecker;
  closingPromise;
  testFilesList = null;
  testProject;
  id = nanoid();
  tmpDir = join(tmpdir(), this.id);
  _globalSetups;
  _provided = {};
  getName() {
    return this.config.name || "";
  }
  isCore() {
    return this.ctx.getCoreWorkspaceProject() === this;
  }
  provide(key, value) {
    try {
      structuredClone(value);
    } catch (err) {
      throw new Error(
        `Cannot provide "${key}" because it's not serializable.`,
        {
          cause: err
        }
      );
    }
    this._provided[key] = value;
  }
  getProvidedContext() {
    if (this.isCore()) {
      return this._provided;
    }
    return {
      ...this.ctx.getCoreWorkspaceProject().getProvidedContext(),
      ...this._provided
    };
  }
  async initializeGlobalSetup() {
    if (this._globalSetups) {
      return;
    }
    this._globalSetups = await loadGlobalSetupFiles(
      this.runner,
      this.config.globalSetup
    );
    for (const globalSetupFile of this._globalSetups) {
      const teardown = await globalSetupFile.setup?.({
        provide: (key, value) => this.provide(key, value),
        config: this.config
      });
      if (teardown == null || !!globalSetupFile.teardown) {
        continue;
      }
      if (typeof teardown !== "function") {
        throw new TypeError(
          `invalid return value in globalSetup file ${globalSetupFile.file}. Must return a function`
        );
      }
      globalSetupFile.teardown = teardown;
    }
  }
  async teardownGlobalSetup() {
    if (!this._globalSetups) {
      return;
    }
    for (const globalSetupFile of [...this._globalSetups].reverse()) {
      await globalSetupFile.teardown?.();
    }
  }
  get logger() {
    return this.ctx.logger;
  }
  // it's possible that file path was imported with different queries (?raw, ?url, etc)
  getModulesByFilepath(file) {
    const set = this.server.moduleGraph.getModulesByFile(file) || this.browser?.vite.moduleGraph.getModulesByFile(file);
    return set || /* @__PURE__ */ new Set();
  }
  getModuleById(id) {
    return this.server.moduleGraph.getModuleById(id) || this.browser?.vite.moduleGraph.getModuleById(id);
  }
  getSourceMapModuleById(id) {
    const mod = this.server.moduleGraph.getModuleById(id);
    return mod?.ssrTransformResult?.map || mod?.transformResult?.map;
  }
  get reporters() {
    return this.ctx.reporters;
  }
  async globTestFiles(filters = []) {
    const dir = this.config.dir || this.config.root;
    const { include, exclude, includeSource } = this.config;
    const typecheck = this.config.typecheck;
    const [testFiles, typecheckTestFiles] = await Promise.all([
      typecheck.enabled && typecheck.only ? [] : this.globAllTestFiles(include, exclude, includeSource, dir),
      typecheck.enabled ? this.globFiles(typecheck.include, typecheck.exclude, dir) : []
    ]);
    return this.filterFiles(
      [...testFiles, ...typecheckTestFiles],
      filters,
      dir
    );
  }
  async globAllTestFiles(include, exclude, includeSource, cwd) {
    if (this.testFilesList) {
      return this.testFilesList;
    }
    const testFiles = await this.globFiles(include, exclude, cwd);
    if (includeSource?.length) {
      const files = await this.globFiles(includeSource, exclude, cwd);
      await Promise.all(
        files.map(async (file) => {
          try {
            const code = await promises$1.readFile(file, "utf-8");
            if (this.isInSourceTestFile(code)) {
              testFiles.push(file);
            }
          } catch {
            return null;
          }
        })
      );
    }
    this.testFilesList = testFiles;
    return testFiles;
  }
  isTestFile(id) {
    return this.testFilesList && this.testFilesList.includes(id);
  }
  async globFiles(include, exclude, cwd) {
    const globOptions = {
      dot: true,
      cwd,
      ignore: exclude
    };
    const files = await fg(include, globOptions);
    return files.map((file) => resolve(cwd, file));
  }
  async isTargetFile(id, source) {
    const relativeId = relative(this.config.dir || this.config.root, id);
    if (mm.isMatch(relativeId, this.config.exclude)) {
      return false;
    }
    if (mm.isMatch(relativeId, this.config.include)) {
      return true;
    }
    if (this.config.includeSource?.length && mm.isMatch(relativeId, this.config.includeSource)) {
      source = source || await promises$1.readFile(id, "utf-8");
      return this.isInSourceTestFile(source);
    }
    return false;
  }
  isInSourceTestFile(code) {
    return code.includes("import.meta.vitest");
  }
  filterFiles(testFiles, filters, dir) {
    if (filters.length && process.platform === "win32") {
      filters = filters.map((f) => toNamespacedPath(f));
    }
    if (filters.length) {
      return testFiles.filter((t) => {
        const testFile = relative(dir, t).toLocaleLowerCase();
        return filters.some((f) => {
          if (isAbsolute(f) && t.startsWith(f)) {
            return true;
          }
          const relativePath = f.endsWith("/") ? join(relative(dir, f), "/") : relative(dir, f);
          return testFile.includes(f.toLocaleLowerCase()) || testFile.includes(relativePath.toLocaleLowerCase());
        });
      });
    }
    return testFiles;
  }
  async initBrowserServer(configFile) {
    if (!this.isBrowserEnabled()) {
      return;
    }
    await this.ctx.packageInstaller.ensureInstalled("@vitest/browser", this.config.root);
    const { createBrowserServer } = await import('@vitest/browser');
    await this.browser?.close();
    const browser = await createBrowserServer(
      this,
      configFile,
      [...MocksPlugins()],
      [CoverageTransform(this.ctx)]
    );
    this.browser = browser;
    if (this.config.browser.ui) {
      setup(this.ctx, browser.vite);
    }
  }
  static createBasicProject(ctx) {
    const project = new WorkspaceProject(
      ctx.config.name || ctx.config.root,
      ctx
    );
    project.vitenode = ctx.vitenode;
    project.server = ctx.server;
    project.runner = ctx.runner;
    project.config = ctx.config;
    project.testProject = new TestProject(project);
    return project;
  }
  static async createCoreProject(ctx) {
    const project = WorkspaceProject.createBasicProject(ctx);
    await project.initBrowserServer(ctx.server.config.configFile);
    return project;
  }
  async setServer(options, server) {
    this.config = resolveConfig(
      this.ctx.mode,
      {
        ...options,
        coverage: this.ctx.config.coverage
      },
      server.config,
      this.ctx.logger
    );
    this.testProject = new TestProject(this);
    this.server = server;
    this.vitenode = new ViteNodeServer(server, this.config.server);
    const node = this.vitenode;
    this.runner = new ViteNodeRunner({
      root: server.config.root,
      base: server.config.base,
      fetchModule(id) {
        return node.fetchModule(id);
      },
      resolveId(id, importer) {
        return node.resolveId(id, importer);
      }
    });
    await this.initBrowserServer(this.server.config.configFile);
  }
  isBrowserEnabled() {
    return isBrowserEnabled(this.config);
  }
  getSerializableConfig() {
    const config = serializeConfig(
      this.config,
      this.ctx.config,
      this.server.config
    );
    if (!this.ctx.configOverride) {
      return config;
    }
    return deepMerge(
      config,
      this.ctx.configOverride
    );
  }
  close() {
    if (!this.closingPromise) {
      this.closingPromise = Promise.all(
        [
          this.server.close(),
          this.typechecker?.stop(),
          this.browser?.close(),
          this.clearTmpDir()
        ].filter(Boolean)
      ).then(() => this._provided = {});
    }
    return this.closingPromise;
  }
  async clearTmpDir() {
    try {
      await rm(this.tmpDir, { recursive: true });
    } catch {
    }
  }
  async initBrowserProvider() {
    if (!this.isBrowserEnabled()) {
      return;
    }
    await this.browser?.initBrowserProvider();
  }
}

const __dirname = url.fileURLToPath(new URL(".", import.meta.url));
class VitestPackageInstaller {
  async ensureInstalled(dependency, root) {
    if (process.env.VITEST_SKIP_INSTALL_CHECKS) {
      return true;
    }
    if (process.versions.pnp) {
      const targetRequire = createRequire(__dirname);
      try {
        targetRequire.resolve(dependency, { paths: [root, __dirname] });
        return true;
      } catch {
      }
    }
    if (/* @__PURE__ */ isPackageExists(dependency, { paths: [root, __dirname] })) {
      return true;
    }
    const promptInstall = !isCI && process.stdout.isTTY;
    process.stderr.write(
      c.red(
        `${c.inverse(
          c.red(" MISSING DEPENDENCY ")
        )} Cannot find dependency '${dependency}'

`
      )
    );
    if (!promptInstall) {
      return false;
    }
    const prompts = await import('./index.CM5UI-4O.js').then(function (n) { return n.i; });
    const { install } = await prompts.prompt({
      type: "confirm",
      name: "install",
      message: c.reset(`Do you want to install ${c.green(dependency)}?`)
    });
    if (install) {
      await (await import('./index.DNUmWFkO.js')).installPackage(dependency, { dev: true });
      process.stderr.write(
        c.yellow(
          `
Package ${dependency} installed, re-run the command to start.
`
        )
      );
      process.exit();
      return true;
    }
    return false;
  }
}

class FilesNotFoundError extends Error {
  code = "VITEST_FILES_NOT_FOUND";
  constructor(mode) {
    super(`No ${mode} files found`);
  }
}
class GitNotFoundError extends Error {
  code = "VITEST_GIT_NOT_FOUND";
  constructor() {
    super("Could not find Git root. Have you initialized git with `git init`?");
  }
}

const WATCHER_DEBOUNCE = 100;
class Vitest {
  constructor(mode, options = {}) {
    this.mode = mode;
    this.logger = new Logger(this, options.stdout, options.stderr);
    this.packageInstaller = options.packageInstaller || new VitestPackageInstaller();
  }
  version = version$1;
  config = void 0;
  configOverride = {};
  server = void 0;
  state = void 0;
  snapshot = void 0;
  cache = void 0;
  reporters = void 0;
  coverageProvider;
  logger;
  pool;
  vitenode = void 0;
  invalidates = /* @__PURE__ */ new Set();
  changedTests = /* @__PURE__ */ new Set();
  watchedTests = /* @__PURE__ */ new Set();
  filenamePattern;
  runningPromise;
  closingPromise;
  isCancelling = false;
  isFirstRun = true;
  restartsCount = 0;
  runner = void 0;
  packageInstaller;
  coreWorkspaceProject;
  resolvedProjects = [];
  projects = [];
  projectsTestFiles = /* @__PURE__ */ new Map();
  distPath;
  _onRestartListeners = [];
  _onClose = [];
  _onSetServer = [];
  _onCancelListeners = [];
  async setServer(options, server, cliOptions) {
    this.unregisterWatcher?.();
    clearTimeout(this._rerunTimer);
    this.restartsCount += 1;
    this.pool?.close?.();
    this.pool = void 0;
    this.coverageProvider = void 0;
    this.runningPromise = void 0;
    this.distPath = void 0;
    this.projectsTestFiles.clear();
    const resolved = resolveConfig(this.mode, options, server.config, this.logger);
    this.server = server;
    this.config = resolved;
    this.state = new StateManager();
    this.cache = new VitestCache(this.version);
    this.snapshot = new SnapshotManager({ ...resolved.snapshotOptions });
    if (this.config.watch) {
      this.registerWatcher();
    }
    this.vitenode = new ViteNodeServer(server, this.config.server);
    const node = this.vitenode;
    this.runner = new ViteNodeRunner({
      root: server.config.root,
      base: server.config.base,
      fetchModule(id) {
        return node.fetchModule(id);
      },
      resolveId(id, importer) {
        return node.resolveId(id, importer);
      }
    });
    if (this.config.watch) {
      const serverRestart = server.restart;
      server.restart = async (...args) => {
        await Promise.all(this._onRestartListeners.map((fn) => fn()));
        await serverRestart(...args);
        this.unregisterWatcher();
        this.registerWatcher();
      };
      server.watcher.on("change", async (file) => {
        file = normalize(file);
        const isConfig = file === server.config.configFile;
        if (isConfig) {
          await Promise.all(this._onRestartListeners.map((fn) => fn("config")));
          await serverRestart();
          this.unregisterWatcher();
          this.registerWatcher();
        }
      });
    }
    this.reporters = resolved.mode === "benchmark" ? await createBenchmarkReporters(toArray(resolved.benchmark?.reporters), this.runner) : await createReporters(resolved.reporters, this);
    this.cache.results.setConfig(resolved.root, resolved.cache);
    try {
      await this.cache.results.readFromCache();
    } catch {
    }
    await Promise.all(this._onSetServer.map((fn) => fn()));
    const projects = await this.resolveWorkspace(cliOptions);
    this.resolvedProjects = projects;
    this.projects = projects;
    const filters = toArray(resolved.project).map((s) => wildcardPatternToRegExp(s));
    if (filters.length > 0) {
      this.projects = this.projects.filter(
        (p) => filters.some((pattern) => pattern.test(p.getName()))
      );
    }
    if (!this.coreWorkspaceProject) {
      this.coreWorkspaceProject = WorkspaceProject.createBasicProject(this);
    }
    if (this.config.testNamePattern) {
      this.configOverride.testNamePattern = this.config.testNamePattern;
    }
  }
  provide(key, value) {
    this.getCoreWorkspaceProject().provide(key, value);
  }
  async createCoreProject() {
    this.coreWorkspaceProject = await WorkspaceProject.createCoreProject(this);
    return this.coreWorkspaceProject;
  }
  getCoreWorkspaceProject() {
    return this.coreWorkspaceProject;
  }
  getProjectByTaskId(taskId) {
    const task = this.state.idMap.get(taskId);
    const projectName = task.projectName || task?.file?.projectName || "";
    return this.projects.find((p) => p.getName() === projectName) || this.getCoreWorkspaceProject() || this.projects[0];
  }
  getProjectByName(name = "") {
    return this.projects.find((p) => p.getName() === name) || this.getCoreWorkspaceProject() || this.projects[0];
  }
  async getWorkspaceConfigPath() {
    if (this.config.workspace) {
      return this.config.workspace;
    }
    const configDir = this.server.config.configFile ? dirname(this.server.config.configFile) : this.config.root;
    const rootFiles = await promises$1.readdir(configDir);
    const workspaceConfigName = workspacesFiles.find((configFile) => {
      return rootFiles.includes(configFile);
    });
    if (!workspaceConfigName) {
      return null;
    }
    return join(configDir, workspaceConfigName);
  }
  async resolveWorkspace(cliOptions) {
    const workspaceConfigPath = await this.getWorkspaceConfigPath();
    if (!workspaceConfigPath) {
      return [await this.createCoreProject()];
    }
    const workspaceModule = await this.runner.executeFile(workspaceConfigPath);
    if (!workspaceModule.default || !Array.isArray(workspaceModule.default)) {
      throw new Error(`Workspace config file ${workspaceConfigPath} must export a default array of project paths.`);
    }
    const workspaceGlobMatches = [];
    const projectsOptions = [];
    for (const project of workspaceModule.default) {
      if (typeof project === "string") {
        workspaceGlobMatches.push(project.replace("<rootDir>", this.config.root));
      } else if (typeof project === "function") {
        projectsOptions.push(await project({
          command: this.server.config.command,
          mode: this.server.config.mode,
          isPreview: false,
          isSsrBuild: false
        }));
      } else {
        projectsOptions.push(await project);
      }
    }
    const globOptions = {
      absolute: true,
      dot: true,
      onlyFiles: false,
      markDirectories: true,
      cwd: this.config.root,
      ignore: ["**/node_modules/**", "**/*.timestamp-*"]
    };
    const workspacesFs = await fg(workspaceGlobMatches, globOptions);
    const resolvedWorkspacesPaths = await Promise.all(workspacesFs.filter((file) => {
      if (file.endsWith("/")) {
        const hasWorkspaceWithConfig = workspacesFs.some((file2) => {
          return file2 !== file && `${dirname(file2)}/` === file;
        });
        return !hasWorkspaceWithConfig;
      }
      const filename = basename(file);
      return CONFIG_NAMES.some((configName) => filename.startsWith(configName));
    }).map(async (filepath) => {
      if (filepath.endsWith("/")) {
        const filesInside = await promises$1.readdir(filepath);
        const configFile = configFiles.find((config) => filesInside.includes(config));
        return configFile ? join(filepath, configFile) : filepath;
      }
      return filepath;
    }));
    const workspacesByFolder = resolvedWorkspacesPaths.reduce((configByFolder, filepath) => {
      const dir = filepath.endsWith("/") ? filepath.slice(0, -1) : dirname(filepath);
      configByFolder[dir] ??= [];
      configByFolder[dir].push(filepath);
      return configByFolder;
    }, {});
    const filteredWorkspaces = Object.values(workspacesByFolder).map((configFiles2) => {
      if (configFiles2.length === 1) {
        return configFiles2[0];
      }
      const vitestConfig = configFiles2.find((configFile) => basename(configFile).startsWith("vitest.config"));
      return vitestConfig || configFiles2[0];
    });
    const overridesOptions = [
      "logHeapUsage",
      "allowOnly",
      "sequence",
      "testTimeout",
      "pool",
      "update",
      "globals",
      "expandSnapshotDiff",
      "disableConsoleIntercept",
      "retry",
      "testNamePattern",
      "passWithNoTests",
      "bail",
      "isolate",
      "printConsoleTrace"
    ];
    const cliOverrides = overridesOptions.reduce((acc, name) => {
      if (name in cliOptions) {
        acc[name] = cliOptions[name];
      }
      return acc;
    }, {});
    const cwd = process.cwd();
    const projects = [];
    try {
      for (const filepath of filteredWorkspaces) {
        if (this.server.config.configFile === filepath) {
          const project = await this.createCoreProject();
          projects.push(project);
          continue;
        }
        const dir = filepath.endsWith("/") ? filepath.slice(0, -1) : dirname(filepath);
        if (isMainThread) {
          process.chdir(dir);
        }
        projects.push(
          await initializeProject(filepath, this, { workspaceConfigPath, test: cliOverrides })
        );
      }
    } finally {
      if (isMainThread) {
        process.chdir(cwd);
      }
    }
    const projectPromises = [];
    projectsOptions.forEach((options, index) => {
      projectPromises.push(initializeProject(index, this, mergeConfig(options, { workspaceConfigPath, test: cliOverrides })));
    });
    if (!projects.length && !projectPromises.length) {
      return [await this.createCoreProject()];
    }
    const resolvedProjects = await Promise.all([
      ...projects,
      ...await Promise.all(projectPromises)
    ]);
    const names = /* @__PURE__ */ new Set();
    for (const project of resolvedProjects) {
      const name = project.getName();
      if (names.has(name)) {
        throw new Error(`Project name "${name}" is not unique. All projects in a workspace should have unique names.`);
      }
      names.add(name);
    }
    return resolvedProjects;
  }
  async initCoverageProvider() {
    if (this.coverageProvider !== void 0) {
      return;
    }
    this.coverageProvider = await getCoverageProvider(
      this.config.coverage,
      this.runner
    );
    if (this.coverageProvider) {
      await this.coverageProvider.initialize(this);
      this.config.coverage = this.coverageProvider.resolveOptions();
    }
    return this.coverageProvider;
  }
  async initBrowserProviders() {
    return Promise.all(this.projects.map((w) => w.initBrowserProvider()));
  }
  async mergeReports() {
    if (this.reporters.some((r) => r instanceof BlobReporter)) {
      throw new Error("Cannot merge reports when `--reporter=blob` is used. Remove blob reporter from the config first.");
    }
    const { files, errors, coverages } = await readBlobs(this.config.mergeReports, this.projects);
    await this.report("onInit", this);
    await this.report("onPathsCollected", files.flatMap((f) => f.filepath));
    const workspaceSpecs = /* @__PURE__ */ new Map();
    for (const file of files) {
      const project = this.getProjectByName(file.projectName);
      const specs = workspaceSpecs.get(project) || [];
      specs.push(file);
      workspaceSpecs.set(project, specs);
    }
    for (const [project, files2] of workspaceSpecs) {
      const filepaths = files2.map((f) => f.filepath);
      this.state.clearFiles(project, filepaths);
      files2.forEach((file) => {
        file.logs?.forEach((log) => this.state.updateUserLog(log));
      });
      this.state.collectFiles(project, files2);
    }
    await this.report("onCollected", files).catch(noop$1);
    for (const file of files) {
      const logs = [];
      const taskPacks = [];
      const tasks = getTasks(file);
      for (const task of tasks) {
        if (task.logs) {
          logs.push(...task.logs);
        }
        taskPacks.push([task.id, task.result, task.meta]);
      }
      logs.sort((log1, log2) => log1.time - log2.time);
      for (const log of logs) {
        await this.report("onUserConsoleLog", log).catch(noop$1);
      }
      await this.report("onTaskUpdate", taskPacks).catch(noop$1);
    }
    if (hasFailed(files)) {
      process.exitCode = 1;
    }
    await this.report("onFinished", files, errors);
    await this.initCoverageProvider();
    await this.coverageProvider?.mergeReports?.(coverages);
  }
  async collect(filters) {
    this._onClose = [];
    await this.initBrowserProviders();
    const files = await this.filterTestsBySource(
      await this.globTestFiles(filters)
    );
    if (!files.length) {
      return { tests: [], errors: [] };
    }
    await this.collectFiles(files);
    return {
      tests: this.state.getFiles(),
      errors: this.state.getUnhandledErrors()
    };
  }
  async start(filters) {
    this._onClose = [];
    try {
      await this.initCoverageProvider();
      await this.coverageProvider?.clean(this.config.coverage.clean);
      await this.initBrowserProviders();
    } finally {
      await this.report("onInit", this);
    }
    const files = await this.filterTestsBySource(
      await this.globTestFiles(filters)
    );
    if (!files.length) {
      const coverage = await this.coverageProvider?.generateCoverage?.({ allTestsRun: true });
      await this.reportCoverage(coverage, true);
      this.logger.printNoTestFound(filters);
      if (!this.config.watch || !(this.config.changed || this.config.related?.length)) {
        const exitCode = this.config.passWithNoTests ? 0 : 1;
        process.exitCode = exitCode;
        throw new FilesNotFoundError(this.mode);
      }
    }
    if (files.length) {
      await this.cache.stats.populateStats(this.config.root, files);
      await this.runFiles(files, true);
    }
    if (this.config.watch) {
      await this.report("onWatcherStart");
    }
  }
  async init() {
    this._onClose = [];
    try {
      await this.initCoverageProvider();
      await this.coverageProvider?.clean(this.config.coverage.clean);
      await this.initBrowserProviders();
    } finally {
      await this.report("onInit", this);
    }
    await this.globTestFiles();
    if (this.config.watch) {
      await this.report("onWatcherStart");
    }
  }
  async getTestDependencies(filepath, deps = /* @__PURE__ */ new Set()) {
    const addImports = async ([project, filepath2]) => {
      if (deps.has(filepath2)) {
        return;
      }
      deps.add(filepath2);
      const mod = project.server.moduleGraph.getModuleById(filepath2);
      const transformed = mod?.ssrTransformResult || await project.vitenode.transformRequest(filepath2);
      if (!transformed) {
        return;
      }
      const dependencies = [...transformed.deps || [], ...transformed.dynamicDeps || []];
      await Promise.all(dependencies.map(async (dep) => {
        const path = await project.server.pluginContainer.resolveId(dep, filepath2, { ssr: true });
        const fsPath = path && !path.external && path.id.split("?")[0];
        if (fsPath && !fsPath.includes("node_modules") && !deps.has(fsPath) && existsSync(fsPath)) {
          await addImports([project, fsPath]);
        }
      }));
    };
    await addImports(filepath);
    deps.delete(filepath[1]);
    return deps;
  }
  async filterTestsBySource(specs) {
    if (this.config.changed && !this.config.related) {
      const { VitestGit } = await import('./git.ZtkbKc8u.js');
      const vitestGit = new VitestGit(this.config.root);
      const related2 = await vitestGit.findChangedFiles({
        changedSince: this.config.changed
      });
      if (!related2) {
        process.exitCode = 1;
        throw new GitNotFoundError();
      }
      this.config.related = Array.from(new Set(related2));
    }
    const related = this.config.related;
    if (!related) {
      return specs;
    }
    const forceRerunTriggers = this.config.forceRerunTriggers;
    if (forceRerunTriggers.length && mm(related, forceRerunTriggers).length) {
      return specs;
    }
    if (!this.config.watch && !related.length) {
      return [];
    }
    const testGraphs = await Promise.all(
      specs.map(async (spec) => {
        const deps = await this.getTestDependencies(spec);
        return [spec, deps];
      })
    );
    const runningTests = [];
    for (const [filepath, deps] of testGraphs) {
      if (related.some((path) => path === filepath[1] || deps.has(path))) {
        runningTests.push(filepath);
      }
    }
    return runningTests;
  }
  getProjectsByTestFile(file) {
    const projects = this.projectsTestFiles.get(file);
    if (!projects) {
      return [];
    }
    return Array.from(projects).map((project) => [project, file]);
  }
  async initializeGlobalSetup(paths) {
    const projects = new Set(paths.map(([project]) => project));
    const coreProject = this.getCoreWorkspaceProject();
    if (!projects.has(coreProject)) {
      projects.add(coreProject);
    }
    for (const project of projects) {
      await project.initializeGlobalSetup();
    }
  }
  async initializeDistPath() {
    if (this.distPath) {
      return;
    }
    const projectVitestPath = await this.vitenode.resolveId("vitest");
    const vitestDir = projectVitestPath ? resolve(projectVitestPath.id, "../..") : rootDir;
    this.distPath = join(vitestDir, "dist");
  }
  async runFiles(specs, allTestsRun) {
    await this.initializeDistPath();
    const filepaths = specs.map(([, file]) => file);
    this.state.collectPaths(filepaths);
    await this.report("onPathsCollected", filepaths);
    await this.report("onSpecsCollected", specs.map(
      ([project, file]) => [{ name: project.config.name, root: project.config.root }, file]
    ));
    await this.runningPromise;
    this._onCancelListeners = [];
    this.isCancelling = false;
    this.runningPromise = (async () => {
      if (!this.pool) {
        this.pool = createPool(this);
      }
      const invalidates = Array.from(this.invalidates);
      this.invalidates.clear();
      this.snapshot.clear();
      this.state.clearErrors();
      if (!this.isFirstRun && this.config.coverage.cleanOnRerun) {
        await this.coverageProvider?.clean();
      }
      await this.initializeGlobalSetup(specs);
      try {
        await this.pool.runTests(specs, invalidates);
      } catch (err) {
        this.state.catchError(err, "Unhandled Error");
      }
      const files = this.state.getFiles();
      if (hasFailed(files)) {
        process.exitCode = 1;
      }
      this.cache.results.updateResults(files);
      await this.cache.results.writeToCache();
    })().finally(async () => {
      const files = Array.from(new Set(specs.map(([, p]) => p)));
      const coverage = await this.coverageProvider?.generateCoverage({ allTestsRun });
      await this.report("onFinished", this.state.getFiles(files), this.state.getUnhandledErrors(), coverage);
      await this.reportCoverage(coverage, allTestsRun);
      this.runningPromise = void 0;
      this.isFirstRun = false;
      this.config.changed = false;
      this.config.related = void 0;
    });
    return await this.runningPromise;
  }
  async collectFiles(specs) {
    await this.initializeDistPath();
    const filepaths = specs.map(([, file]) => file);
    this.state.collectPaths(filepaths);
    await this.runningPromise;
    this._onCancelListeners = [];
    this.isCancelling = false;
    this.runningPromise = (async () => {
      if (!this.pool) {
        this.pool = createPool(this);
      }
      const invalidates = Array.from(this.invalidates);
      this.invalidates.clear();
      this.snapshot.clear();
      this.state.clearErrors();
      await this.initializeGlobalSetup(specs);
      try {
        await this.pool.collectTests(specs, invalidates);
      } catch (err) {
        this.state.catchError(err, "Unhandled Error");
      }
      const files = this.state.getFiles();
      if (hasFailed(files)) {
        process.exitCode = 1;
      }
    })().finally(async () => {
      this.runningPromise = void 0;
      this.config.changed = false;
      this.config.related = void 0;
    });
    return await this.runningPromise;
  }
  async cancelCurrentRun(reason) {
    this.isCancelling = true;
    await Promise.all(this._onCancelListeners.splice(0).map((listener) => listener(reason)));
  }
  async rerunFiles(files = this.state.getFilepaths(), trigger) {
    if (this.filenamePattern) {
      const filteredFiles = await this.globTestFiles([this.filenamePattern]);
      files = files.filter((file) => filteredFiles.some((f) => f[1] === file));
    }
    await this.report("onWatcherRerun", files, trigger);
    await this.runFiles(files.flatMap((file) => this.getProjectsByTestFile(file)), !trigger);
    await this.report("onWatcherStart", this.state.getFiles(files));
  }
  async changeProjectName(pattern) {
    if (pattern === "") {
      delete this.configOverride.project;
    } else {
      this.configOverride.project = pattern;
    }
    this.projects = this.resolvedProjects.filter((p) => p.getName() === pattern);
    const files = (await this.globTestFiles()).map(([, file]) => file);
    await this.rerunFiles(files, "change project filter");
  }
  async changeNamePattern(pattern, files = this.state.getFilepaths(), trigger) {
    if (pattern === "") {
      this.filenamePattern = void 0;
    }
    const testNamePattern = pattern ? new RegExp(pattern) : void 0;
    this.configOverride.testNamePattern = testNamePattern;
    if (testNamePattern) {
      files = files.filter((filepath) => {
        const files2 = this.state.getFiles([filepath]);
        return !files2.length || files2.some((file) => {
          const tasks = getTasks(file);
          return !tasks.length || tasks.some((task) => testNamePattern.test(task.name));
        });
      });
    }
    await this.rerunFiles(files, trigger);
  }
  async changeFilenamePattern(pattern, files = this.state.getFilepaths()) {
    this.filenamePattern = pattern;
    const trigger = this.filenamePattern ? "change filename pattern" : "reset filename pattern";
    await this.rerunFiles(files, trigger);
  }
  async rerunFailed() {
    await this.rerunFiles(this.state.getFailedFilepaths(), "rerun failed");
  }
  async updateSnapshot(files) {
    files = files || [
      ...this.state.getFailedFilepaths(),
      ...this.snapshot.summary.uncheckedKeysByFile.map((s) => s.filePath)
    ];
    this.configOverride.snapshotOptions = {
      updateSnapshot: "all",
      // environment is resolved inside a worker thread
      snapshotEnvironment: null
    };
    try {
      await this.rerunFiles(files, "update snapshot");
    } finally {
      delete this.configOverride.snapshotOptions;
    }
  }
  _rerunTimer;
  async scheduleRerun(triggerId) {
    const currentCount = this.restartsCount;
    clearTimeout(this._rerunTimer);
    await this.runningPromise;
    clearTimeout(this._rerunTimer);
    if (this.restartsCount !== currentCount) {
      return;
    }
    this._rerunTimer = setTimeout(async () => {
      if (this.watchedTests.size) {
        this.changedTests.forEach((test) => {
          if (!this.watchedTests.has(test)) {
            this.changedTests.delete(test);
          }
        });
      }
      if (this.changedTests.size === 0) {
        this.invalidates.clear();
        return;
      }
      if (this.restartsCount !== currentCount) {
        return;
      }
      this.isFirstRun = false;
      this.snapshot.clear();
      let files = Array.from(this.changedTests);
      if (this.filenamePattern) {
        const filteredFiles = await this.globTestFiles([this.filenamePattern]);
        files = files.filter((file) => filteredFiles.some((f) => f[1] === file));
        if (files.length === 0) {
          return;
        }
      }
      this.changedTests.clear();
      const triggerIds = new Set(triggerId.map((id) => relative(this.config.root, id)));
      const triggerLabel = Array.from(triggerIds).join(", ");
      await this.report("onWatcherRerun", files, triggerLabel);
      await this.runFiles(files.flatMap((file) => this.getProjectsByTestFile(file)), false);
      await this.report("onWatcherStart", this.state.getFiles(files));
    }, WATCHER_DEBOUNCE);
  }
  getModuleProjects(filepath) {
    return this.projects.filter((project) => {
      return project.getModulesByFilepath(filepath).size;
    });
  }
  /**
   * Watch only the specified tests. If no tests are provided, all tests will be watched.
   */
  watchTests(tests) {
    this.watchedTests = new Set(
      tests.map((test) => slash$1(test))
    );
  }
  unregisterWatcher = noop$1;
  registerWatcher() {
    const updateLastChanged = (filepath) => {
      const projects = this.getModuleProjects(filepath);
      projects.forEach(({ server, browser }) => {
        const serverMods = server.moduleGraph.getModulesByFile(filepath);
        serverMods?.forEach((mod) => server.moduleGraph.invalidateModule(mod));
        if (browser) {
          const browserMods = browser.vite.moduleGraph.getModulesByFile(filepath);
          browserMods?.forEach((mod) => browser.vite.moduleGraph.invalidateModule(mod));
        }
      });
    };
    const onChange = (id) => {
      id = slash$1(id);
      this.logger.clearHighlightCache(id);
      updateLastChanged(id);
      const needsRerun = this.handleFileChanged(id);
      if (needsRerun.length) {
        this.scheduleRerun(needsRerun);
      }
    };
    const onUnlink = (id) => {
      id = slash$1(id);
      this.logger.clearHighlightCache(id);
      this.invalidates.add(id);
      if (this.state.filesMap.has(id)) {
        this.state.filesMap.delete(id);
        this.cache.results.removeFromCache(id);
        this.cache.stats.removeStats(id);
        this.changedTests.delete(id);
        this.report("onTestRemoved", id);
      }
    };
    const onAdd = async (id) => {
      id = slash$1(id);
      updateLastChanged(id);
      const matchingProjects = [];
      await Promise.all(this.projects.map(async (project) => {
        if (await project.isTargetFile(id)) {
          matchingProjects.push(project);
          project.testFilesList?.push(id);
        }
      }));
      if (matchingProjects.length > 0) {
        this.projectsTestFiles.set(id, new Set(matchingProjects));
        this.changedTests.add(id);
        this.scheduleRerun([id]);
      } else {
        const needsRerun = this.handleFileChanged(id);
        if (needsRerun.length) {
          this.scheduleRerun(needsRerun);
        }
      }
    };
    const watcher = this.server.watcher;
    if (this.config.forceRerunTriggers.length) {
      watcher.add(this.config.forceRerunTriggers);
    }
    watcher.on("change", onChange);
    watcher.on("unlink", onUnlink);
    watcher.on("add", onAdd);
    this.unregisterWatcher = () => {
      watcher.off("change", onChange);
      watcher.off("unlink", onUnlink);
      watcher.off("add", onAdd);
      this.unregisterWatcher = noop$1;
    };
  }
  /**
   * @returns A value indicating whether rerun is needed (changedTests was mutated)
   */
  handleFileChanged(filepath) {
    if (this.changedTests.has(filepath) || this.invalidates.has(filepath)) {
      return [];
    }
    if (mm.isMatch(filepath, this.config.forceRerunTriggers)) {
      this.state.getFilepaths().forEach((file) => this.changedTests.add(file));
      return [filepath];
    }
    const projects = this.getModuleProjects(filepath);
    if (!projects.length) {
      if (this.state.filesMap.has(filepath) || this.projects.some((project) => project.isTestFile(filepath))) {
        this.changedTests.add(filepath);
        return [filepath];
      }
      return [];
    }
    const files = [];
    for (const project of projects) {
      const mods = project.getModulesByFilepath(filepath);
      if (!mods.size) {
        continue;
      }
      this.invalidates.add(filepath);
      if (this.state.filesMap.has(filepath) || project.isTestFile(filepath)) {
        this.changedTests.add(filepath);
        files.push(filepath);
        continue;
      }
      let rerun = false;
      for (const mod of mods) {
        mod.importers.forEach((i) => {
          if (!i.file) {
            return;
          }
          const heedsRerun = this.handleFileChanged(i.file);
          if (heedsRerun.length) {
            rerun = true;
          }
        });
      }
      if (rerun) {
        files.push(filepath);
      }
    }
    return Array.from(new Set(files));
  }
  async reportCoverage(coverage, allTestsRun) {
    if (!this.config.coverage.reportOnFailure && this.state.getCountOfFailedTests() > 0) {
      return;
    }
    if (this.coverageProvider) {
      await this.coverageProvider.reportCoverage(coverage, { allTestsRun });
      for (const reporter of this.reporters) {
        if (reporter instanceof WebSocketReporter) {
          reporter.onFinishedReportCoverage();
        }
      }
    }
  }
  async close() {
    if (!this.closingPromise) {
      this.closingPromise = (async () => {
        const teardownProjects = [...this.projects];
        if (!teardownProjects.includes(this.coreWorkspaceProject)) {
          teardownProjects.push(this.coreWorkspaceProject);
        }
        for await (const project of teardownProjects.reverse()) {
          await project.teardownGlobalSetup();
        }
        const closePromises = this.resolvedProjects.map((w) => w.close().then(() => w.server = void 0));
        if (!this.resolvedProjects.includes(this.coreWorkspaceProject)) {
          closePromises.push(this.coreWorkspaceProject.close().then(() => this.server = void 0));
        }
        if (this.pool) {
          closePromises.push((async () => {
            await this.pool?.close?.();
            this.pool = void 0;
          })());
        }
        closePromises.push(...this._onClose.map((fn) => fn()));
        return Promise.allSettled(closePromises).then((results) => {
          results.forEach((r) => {
            if (r.status === "rejected") {
              this.logger.error("error during close", r.reason);
            }
          });
          this.logger.logUpdate.done();
        });
      })();
    }
    return this.closingPromise;
  }
  /**
   * Close the thread pool and exit the process
   */
  async exit(force = false) {
    setTimeout(() => {
      this.report("onProcessTimeout").then(() => {
        console.warn(`close timed out after ${this.config.teardownTimeout}ms`);
        this.state.getProcessTimeoutCauses().forEach((cause) => console.warn(cause));
        if (!this.pool) {
          const runningServers = [this.server, ...this.resolvedProjects.map((p) => p.server)].filter(Boolean).length;
          if (runningServers === 1) {
            console.warn("Tests closed successfully but something prevents Vite server from exiting");
          } else if (runningServers > 1) {
            console.warn(`Tests closed successfully but something prevents ${runningServers} Vite servers from exiting`);
          } else {
            console.warn("Tests closed successfully but something prevents the main process from exiting");
          }
          console.warn('You can try to identify the cause by enabling "hanging-process" reporter. See https://vitest.dev/config/#reporters');
        }
        process.exit();
      });
    }, this.config.teardownTimeout).unref();
    await this.close();
    if (force) {
      process.exit();
    }
  }
  async report(name, ...args) {
    await Promise.all(this.reporters.map((r) => r[name]?.(
      ...args
    )));
  }
  async getTestFilepaths() {
    return this.globTestFiles().then((files) => files.map(([, file]) => file));
  }
  async globTestFiles(filters = []) {
    const files = [];
    await Promise.all(this.projects.map(async (project) => {
      const specs = await project.globTestFiles(filters);
      specs.forEach((file) => {
        files.push([project, file]);
        const projects = this.projectsTestFiles.get(file) || /* @__PURE__ */ new Set();
        projects.add(project);
        this.projectsTestFiles.set(file, projects);
      });
    }));
    return files;
  }
  // The server needs to be running for communication
  shouldKeepServer() {
    return !!this.config?.watch;
  }
  onServerRestart(fn) {
    this._onRestartListeners.push(fn);
  }
  onAfterSetServer(fn) {
    this._onSetServer.push(fn);
  }
  onCancel(fn) {
    this._onCancelListeners.push(fn);
  }
  onClose(fn) {
    this._onClose.push(fn);
  }
}

async function VitestPlugin(options = {}, ctx = new Vitest("test")) {
  const userConfig = deepMerge({}, options);
  const getRoot = () => ctx.config?.root || options.root || process.cwd();
  async function UIPlugin() {
    await ctx.packageInstaller.ensureInstalled("@vitest/ui", getRoot());
    return (await import('@vitest/ui')).default(ctx);
  }
  return [
    {
      name: "vitest",
      enforce: "pre",
      options() {
        this.meta.watchMode = false;
      },
      async config(viteConfig) {
        if (options.watch) {
          options = deepMerge({}, userConfig);
        }
        const testConfig = deepMerge(
          {},
          configDefaults,
          removeUndefinedValues(viteConfig.test ?? {}),
          options
        );
        testConfig.api = resolveApiServerConfig(testConfig, defaultPort);
        const defines = deleteDefineConfig(viteConfig);
        options.defines = defines;
        let open = false;
        if (testConfig.ui && testConfig.open) {
          open = testConfig.uiBase ?? "/__vitest__/";
        }
        const config = {
          root: viteConfig.test?.root || options.root,
          esbuild: viteConfig.esbuild === false ? false : {
            // Lowest target Vitest supports is Node18
            target: viteConfig.esbuild?.target || "node18",
            sourcemap: "external",
            // Enables using ignore hint for coverage providers with @preserve keyword
            legalComments: "inline"
          },
          resolve: {
            // by default Vite resolves `module` field, which not always a native ESM module
            // setting this option can bypass that and fallback to cjs version
            mainFields: [],
            alias: testConfig.alias,
            conditions: ["node"]
          },
          server: {
            ...testConfig.api,
            open,
            hmr: false,
            preTransformRequests: false,
            fs: {
              allow: resolveFsAllow(getRoot(), testConfig.config)
            }
          },
          build: {
            // Vitest doesn't use outputDir, but this value affects what folders are watched
            // https://github.com/vitest-dev/vitest/issues/5429
            // This works for Vite <5.2.10
            outDir: "dummy-non-existing-folder",
            // This works for Vite >=5.2.10
            // https://github.com/vitejs/vite/pull/16453
            emptyOutDir: false
          },
          test: {
            poolOptions: {
              threads: {
                isolate: options.poolOptions?.threads?.isolate ?? options.isolate ?? testConfig.poolOptions?.threads?.isolate ?? viteConfig.test?.isolate
              },
              forks: {
                isolate: options.poolOptions?.forks?.isolate ?? options.isolate ?? testConfig.poolOptions?.forks?.isolate ?? viteConfig.test?.isolate
              }
            }
          }
        };
        if (userConfig.coverage?.enabled && !userConfig.coverage.exclude && userConfig.include && config.test) {
          config.test.coverage = {
            exclude: [...coverageConfigDefaults.exclude, ...userConfig.include]
          };
        }
        if (viteConfig.ssr?.noExternal !== true) {
          const inline = testConfig.server?.deps?.inline;
          if (inline === true) {
            config.ssr = { noExternal: true };
          } else {
            const noExternal = viteConfig.ssr?.noExternal;
            const noExternalArray = typeof noExternal !== "undefined" ? toArray(noExternal) : void 0;
            const uniqueInline = inline && noExternalArray ? inline.filter((dep) => !noExternalArray.includes(dep)) : inline;
            config.ssr = {
              noExternal: uniqueInline
            };
          }
        }
        if (process.platform === "darwin" && process.env.VITE_TEST_WATCHER_DEBUG) {
          const watch = config.server.watch;
          if (watch) {
            watch.useFsEvents = false;
            watch.usePolling = false;
          }
        }
        const classNameStrategy = typeof testConfig.css !== "boolean" && testConfig.css?.modules?.classNameStrategy || "stable";
        if (classNameStrategy !== "scoped") {
          config.css ??= {};
          config.css.modules ??= {};
          if (config.css.modules) {
            config.css.modules.generateScopedName = (name, filename) => {
              const root = getRoot();
              return generateScopedClassName(
                classNameStrategy,
                name,
                relative(root, filename)
              );
            };
          }
        }
        return config;
      },
      async configResolved(viteConfig) {
        const viteConfigTest = viteConfig.test || {};
        if (viteConfigTest.watch === false) {
          viteConfigTest.run = true;
        }
        if ("alias" in viteConfigTest) {
          delete viteConfigTest.alias;
        }
        options = deepMerge({}, configDefaults, viteConfigTest, options);
        options.api = resolveApiServerConfig(options, defaultPort);
        const { PROD, DEV, ...envs } = viteConfig.env;
        process.env.PROD ??= PROD ? "1" : "";
        process.env.DEV ??= DEV ? "1" : "";
        for (const name in envs) {
          process.env[name] ??= envs[name];
        }
        if (!options.watch) {
          viteConfig.server.watch = null;
        }
        hijackVitePluginInject(viteConfig);
      },
      async configureServer(server) {
        if (options.watch && process.env.VITE_TEST_WATCHER_DEBUG) {
          server.watcher.on("ready", () => {
            console.log("[debug] watcher is ready");
          });
        }
        await ctx.setServer(options, server, userConfig);
        if (options.api && options.watch) {
          (await Promise.resolve().then(function () { return setup$1; })).setup(ctx);
        }
        if (!options.watch) {
          await server.watcher.close();
        }
      }
    },
    SsrReplacerPlugin(),
    ...CSSEnablerPlugin(ctx),
    CoverageTransform(ctx),
    options.ui ? await UIPlugin() : null,
    ...MocksPlugins(),
    VitestResolver(ctx),
    VitestOptimizer(),
    NormalizeURLPlugin()
  ].filter(notNullish);
}

async function createVitest(mode, options, viteOverrides = {}, vitestOptions = {}) {
  const ctx = new Vitest(mode, vitestOptions);
  const root = resolve(options.root || process.cwd());
  const configPath = options.config === false ? false : options.config ? resolve(root, options.config) : await findUp(configFiles, { cwd: root });
  options.config = configPath;
  const config = {
    logLevel: "error",
    configFile: configPath,
    // this will make "mode": "test" | "benchmark" inside defineConfig
    mode: options.mode || mode,
    plugins: await VitestPlugin(options, ctx)
  };
  const server = await createViteServer(
    mergeConfig(config, mergeConfig(viteOverrides, { root: options.root }))
  );
  if (ctx.config.api?.port) {
    await server.listen();
  }
  return ctx;
}

const MAX_RESULT_COUNT = 10;
const SELECTION_MAX_INDEX = 7;
const ESC = "\x1B[";
class WatchFilter {
  filterRL;
  currentKeyword = void 0;
  message;
  results = [];
  selectionIndex = -1;
  onKeyPress;
  stdin;
  stdout;
  constructor(message, stdin = process.stdin, stdout$1 = stdout()) {
    this.message = message;
    this.stdin = stdin;
    this.stdout = stdout$1;
    this.filterRL = readline.createInterface({
      input: this.stdin,
      escapeCodeTimeout: 50
    });
    readline.emitKeypressEvents(this.stdin, this.filterRL);
    if (this.stdin.isTTY) {
      this.stdin.setRawMode(true);
    }
  }
  async filter(filterFunc) {
    this.write(this.promptLine());
    const resultPromise = createDefer();
    this.onKeyPress = this.filterHandler(filterFunc, (result) => {
      resultPromise.resolve(result);
    });
    this.stdin.on("keypress", this.onKeyPress);
    try {
      return await resultPromise;
    } finally {
      this.close();
    }
  }
  filterHandler(filterFunc, onSubmit) {
    return async (str, key) => {
      switch (true) {
        case key.sequence === "\x7F":
          if (this.currentKeyword && this.currentKeyword?.length > 1) {
            this.currentKeyword = this.currentKeyword?.slice(0, -1);
          } else {
            this.currentKeyword = void 0;
          }
          break;
        case (key?.ctrl && key?.name === "c"):
        case key?.name === "escape":
          this.cancel();
          onSubmit(void 0);
          break;
        case key?.name === "enter":
        case key?.name === "return":
          onSubmit(
            this.results[this.selectionIndex] || this.currentKeyword || ""
          );
          this.currentKeyword = void 0;
          break;
        case key?.name === "up":
          if (this.selectionIndex && this.selectionIndex > 0) {
            this.selectionIndex--;
          } else {
            this.selectionIndex = -1;
          }
          break;
        case key?.name === "down":
          if (this.selectionIndex < this.results.length - 1) {
            this.selectionIndex++;
          } else if (this.selectionIndex >= this.results.length - 1) {
            this.selectionIndex = this.results.length - 1;
          }
          break;
        case (!key?.ctrl && !key?.meta):
          if (this.currentKeyword === void 0) {
            this.currentKeyword = str;
          } else {
            this.currentKeyword += str || "";
          }
          break;
      }
      if (this.currentKeyword) {
        this.results = await filterFunc(this.currentKeyword);
      }
      this.render();
    };
  }
  render() {
    let printStr = this.promptLine();
    if (!this.currentKeyword) {
      printStr += "\nPlease input filter pattern";
    } else if (this.currentKeyword && this.results.length === 0) {
      printStr += "\nPattern matches no results";
    } else {
      const resultCountLine = this.results.length === 1 ? `Pattern matches ${this.results.length} result` : `Pattern matches ${this.results.length} results`;
      let resultBody = "";
      if (this.results.length > MAX_RESULT_COUNT) {
        const offset = this.selectionIndex > SELECTION_MAX_INDEX ? this.selectionIndex - SELECTION_MAX_INDEX : 0;
        const displayResults = this.results.slice(
          offset,
          MAX_RESULT_COUNT + offset
        );
        const remainingResultCount = this.results.length - offset - displayResults.length;
        resultBody = `${displayResults.map(
          (result, index) => index + offset === this.selectionIndex ? c.green(` \u203A ${result}`) : c.dim(` \u203A ${result}`)
        ).join("\n")}`;
        if (remainingResultCount > 0) {
          resultBody += `
${c.dim(
            `   ...and ${remainingResultCount} more ${remainingResultCount === 1 ? "result" : "results"}`
          )}`;
        }
      } else {
        resultBody = this.results.map(
          (result, index) => index === this.selectionIndex ? c.green(` \u203A ${result}`) : c.dim(` \u203A ${result}`)
        ).join("\n");
      }
      printStr += `
${resultCountLine}
${resultBody}`;
    }
    this.eraseAndPrint(printStr);
    this.restoreCursor();
  }
  keywordOffset() {
    return `? ${this.message} \u203A `.length + 1;
  }
  promptLine() {
    return `${c.cyan("?")} ${c.bold(this.message)} \u203A ${this.currentKeyword || ""}`;
  }
  eraseAndPrint(str) {
    let rows = 0;
    const lines = str.split(/\r?\n/);
    for (const line of lines) {
      const columns = "columns" in this.stdout ? this.stdout.columns : 80;
      rows += 1 + Math.floor(Math.max(stripAnsi(line).length - 1, 0) / columns);
    }
    this.write(`${ESC}1G`);
    this.write(`${ESC}J`);
    this.write(str);
    this.write(`${ESC}${rows - 1}A`);
  }
  close() {
    this.filterRL.close();
    if (this.onKeyPress) {
      this.stdin.removeListener("keypress", this.onKeyPress);
    }
    if (this.stdin.isTTY) {
      this.stdin.setRawMode(false);
    }
  }
  restoreCursor() {
    const cursortPos = this.keywordOffset() + (this.currentKeyword?.length || 0);
    this.write(`${ESC}${cursortPos}G`);
  }
  cancel() {
    this.write(`${ESC}J`);
  }
  write(data) {
    this.stdout.write(data);
  }
  getLastResults() {
    return this.results;
  }
}

const keys = [
  [["a", "return"], "rerun all tests"],
  ["r", "rerun current pattern tests"],
  ["f", "rerun only failed tests"],
  ["u", "update snapshot"],
  ["p", "filter by a filename"],
  ["t", "filter by a test name regex pattern"],
  ["w", "filter by a project name"],
  ["q", "quit"]
];
const cancelKeys = ["space", "c", "h", ...keys.map((key) => key[0]).flat()];
function printShortcutsHelp() {
  stdout().write(
    `
${c.bold("  Watch Usage")}
${keys.map(
      (i) => c.dim("  press ") + c.reset([i[0]].flat().map(c.bold).join(", ")) + c.dim(` to ${i[1]}`)
    ).join("\n")}
`
  );
}
function registerConsoleShortcuts(ctx, stdin = process.stdin, stdout2) {
  let latestFilename = "";
  async function _keypressHandler(str, key) {
    if (str === "" || str === "\x1B" || key && key.ctrl && key.name === "c") {
      if (!ctx.isCancelling) {
        ctx.logger.logUpdate.clear();
        ctx.logger.log(
          c.red("Cancelling test run. Press CTRL+c again to exit forcefully.\n")
        );
        process.exitCode = 130;
        await ctx.cancelCurrentRun("keyboard-input");
        await ctx.runningPromise;
      }
      return ctx.exit(true);
    }
    if (!isWindows && key && key.ctrl && key.name === "z") {
      process.kill(process.ppid, "SIGTSTP");
      process.kill(process.pid, "SIGTSTP");
      return;
    }
    const name = key?.name;
    if (ctx.runningPromise) {
      if (cancelKeys.includes(name)) {
        await ctx.cancelCurrentRun("keyboard-input");
      }
      return;
    }
    if (name === "q") {
      return ctx.exit(true);
    }
    if (name === "h") {
      return printShortcutsHelp();
    }
    if (name === "u") {
      return ctx.updateSnapshot();
    }
    if (name === "a" || name === "return") {
      const files = await ctx.getTestFilepaths();
      return ctx.changeNamePattern("", files, "rerun all tests");
    }
    if (name === "r") {
      return ctx.rerunFiles();
    }
    if (name === "f") {
      return ctx.rerunFailed();
    }
    if (name === "w") {
      return inputProjectName();
    }
    if (name === "t") {
      return inputNamePattern();
    }
    if (name === "p") {
      return inputFilePattern();
    }
  }
  async function keypressHandler(str, key) {
    await _keypressHandler(str, key);
  }
  async function inputNamePattern() {
    off();
    const watchFilter = new WatchFilter(
      "Input test name pattern (RegExp)",
      stdin,
      stdout2
    );
    const filter = await watchFilter.filter((str) => {
      const files2 = ctx.state.getFiles();
      const tests = getTests(files2);
      try {
        const reg = new RegExp(str);
        return tests.map((test) => test.name).filter((testName) => testName.match(reg));
      } catch {
        return [];
      }
    });
    on();
    const files = ctx.state.getFilepaths();
    const cliFiles = ctx.config.standalone && !files.length ? await ctx.getTestFilepaths() : void 0;
    await ctx.changeNamePattern(
      filter?.trim() || "",
      cliFiles,
      "change pattern"
    );
  }
  async function inputProjectName() {
    off();
    const { filter = "" } = await prompt([
      {
        name: "filter",
        type: "text",
        message: "Input a single project name",
        initial: toArray(ctx.configOverride.project)[0] || ""
      }
    ]);
    on();
    await ctx.changeProjectName(filter.trim());
  }
  async function inputFilePattern() {
    off();
    const watchFilter = new WatchFilter(
      "Input filename pattern",
      stdin,
      stdout2
    );
    const filter = await watchFilter.filter(async (str) => {
      const files = await ctx.globTestFiles([str]);
      return files.map((file) => relative(ctx.config.root, file[1]));
    });
    on();
    latestFilename = filter?.trim() || "";
    const lastResults = watchFilter.getLastResults();
    await ctx.changeFilenamePattern(
      latestFilename,
      filter && lastResults.length ? lastResults.map((i) => resolve(ctx.config.root, i)) : void 0
    );
  }
  let rl;
  function on() {
    off();
    rl = readline.createInterface({ input: stdin, escapeCodeTimeout: 50 });
    readline.emitKeypressEvents(stdin, rl);
    if (stdin.isTTY) {
      stdin.setRawMode(true);
    }
    stdin.on("keypress", keypressHandler);
  }
  function off() {
    rl?.close();
    rl = void 0;
    stdin.removeListener("keypress", keypressHandler);
    if (stdin.isTTY) {
      stdin.setRawMode(false);
    }
  }
  on();
  return function cleanup() {
    off();
  };
}

async function startVitest(mode, cliFilters = [], options = {}, viteOverrides, vitestOptions) {
  const root = resolve(options.root || process.cwd());
  const ctx = await prepareVitest(
    mode,
    options,
    viteOverrides,
    vitestOptions
  );
  if (mode === "test" && ctx.config.coverage.enabled) {
    const provider = ctx.config.coverage.provider || "v8";
    const requiredPackages = CoverageProviderMap[provider];
    if (requiredPackages) {
      if (!await ctx.packageInstaller.ensureInstalled(requiredPackages, root)) {
        process.exitCode = 1;
        return ctx;
      }
    }
  }
  const stdin = vitestOptions?.stdin || process.stdin;
  const stdout = vitestOptions?.stdout || process.stdout;
  let stdinCleanup;
  if (stdin.isTTY && ctx.config.watch) {
    stdinCleanup = registerConsoleShortcuts(ctx, stdin, stdout);
  }
  ctx.onServerRestart((reason) => {
    ctx.report("onServerRestart", reason);
  });
  ctx.onAfterSetServer(() => {
    if (ctx.config.standalone) {
      ctx.init();
    } else {
      ctx.start(cliFilters);
    }
  });
  try {
    if (ctx.config.mergeReports) {
      await ctx.mergeReports();
    } else if (ctx.config.standalone) {
      await ctx.init();
    } else {
      await ctx.start(cliFilters);
    }
  } catch (e) {
    if (e instanceof FilesNotFoundError) {
      return ctx;
    }
    if (e instanceof GitNotFoundError) {
      ctx.logger.error(e.message);
      return ctx;
    }
    process.exitCode = 1;
    ctx.logger.printError(e, { fullStack: true, type: "Unhandled Error" });
    ctx.logger.error("\n\n");
    return ctx;
  }
  if (ctx.shouldKeepServer()) {
    return ctx;
  }
  stdinCleanup?.();
  await ctx.close();
  return ctx;
}
async function prepareVitest(mode, options = {}, viteOverrides, vitestOptions) {
  process.env.TEST = "true";
  process.env.VITEST = "true";
  process.env.NODE_ENV ??= "test";
  if (options.run) {
    options.watch = false;
  }
  const root = resolve(options.root || process.cwd());
  if (typeof options.browser === "object" && !("enabled" in options.browser)) {
    options.browser.enabled = true;
  }
  if (typeof options.typecheck?.only === "boolean") {
    options.typecheck.enabled ??= true;
  }
  const ctx = await createVitest(mode, options, viteOverrides, vitestOptions);
  const environmentPackage = getEnvPackageName(ctx.config.environment);
  if (environmentPackage && !await ctx.packageInstaller.ensureInstalled(environmentPackage, root)) {
    process.exitCode = 1;
    return ctx;
  }
  return ctx;
}
function processCollected(ctx, files, options) {
  let errorsPrinted = false;
  forEachSuite(files, (suite) => {
    const errors = suite.result?.errors || [];
    errors.forEach((error) => {
      errorsPrinted = true;
      ctx.logger.printError(error, {
        project: ctx.getProjectByName(suite.file.projectName)
      });
    });
  });
  if (errorsPrinted) {
    return;
  }
  if (typeof options.json !== "undefined") {
    return processJsonOutput(files, options);
  }
  return formatCollectedAsString(files).forEach((test) => console.log(test));
}
function processJsonOutput(files, options) {
  if (typeof options.json === "boolean") {
    return console.log(JSON.stringify(formatCollectedAsJSON(files), null, 2));
  }
  if (typeof options.json === "string") {
    const jsonPath = resolve(options.root || process.cwd(), options.json);
    mkdirSync(dirname(jsonPath), { recursive: true });
    writeFileSync(jsonPath, JSON.stringify(formatCollectedAsJSON(files), null, 2));
  }
}
function forEachSuite(tasks, callback) {
  tasks.forEach((task) => {
    if (task.type === "suite") {
      callback(task);
      forEachSuite(task.tasks, callback);
    }
  });
}
function formatCollectedAsJSON(files) {
  return files.map((file) => {
    const tests = getTests(file).filter((test) => test.mode === "run" || test.mode === "only");
    return tests.map((test) => {
      const result = {
        name: getNames(test).slice(1).join(" > "),
        file: file.filepath
      };
      if (test.file.projectName) {
        result.projectName = test.file.projectName;
      }
      if (test.location) {
        result.location = test.location;
      }
      return result;
    });
  }).flat();
}
function formatCollectedAsString(files) {
  return files.map((file) => {
    const tests = getTests(file).filter((test) => test.mode === "run" || test.mode === "only");
    return tests.map((test) => {
      const name = getNames(test).join(" > ");
      if (test.file.projectName) {
        return `[${test.file.projectName}] ${name}`;
      }
      return name;
    });
  }).flat();
}
const envPackageNames = {
  "jsdom": "jsdom",
  "happy-dom": "happy-dom",
  "edge-runtime": "@edge-runtime/vm"
};
function getEnvPackageName(env) {
  if (env === "node") {
    return null;
  }
  if (env in envPackageNames) {
    return envPackageNames[env];
  }
  if (env[0] === "." || env[0] === "/") {
    return null;
  }
  return `vitest-environment-${env}`;
}

var cliApi = /*#__PURE__*/Object.freeze({
  __proto__: null,
  formatCollectedAsJSON: formatCollectedAsJSON,
  formatCollectedAsString: formatCollectedAsString,
  prepareVitest: prepareVitest,
  processCollected: processCollected,
  startVitest: startVitest
});

export { FilesNotFoundError as F, GitNotFoundError as G, VitestPlugin as V, createMethodsRPC as a, VitestPackageInstaller as b, createVitest as c, resolveFsAllow as d, resolveApiServerConfig as e, resolveConfig as f, getFilePoolName as g, cliApi as h, registerConsoleShortcuts as r, startVitest as s };
