(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require map.Map.

(* Why3 assumption *)
Definition unit  := unit.

(* Why3 assumption *)
Inductive ref (a:Type) {a_WT:WhyType a} :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a] [a_WT]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a}(v:(ref a)): a :=
  match v with
  | (mk_ref x) => x
  end.

Axiom pointer : Type.
Parameter pointer_WhyType : WhyType pointer.
Existing Instance pointer_WhyType.

Axiom pointer_dec : forall (p1:pointer) (p2:pointer), (p1 = p2) \/
  ~ (p1 = p2).

(* Why3 assumption *)
Definition next  := (map.Map.map pointer pointer).

Parameter null: pointer.

(* Why3 assumption *)
Inductive is_list : (map.Map.map pointer pointer) -> pointer -> Prop :=
  | is_list_null : forall (next1:(map.Map.map pointer pointer)) (p:pointer),
      (p = null) -> (is_list next1 p)
  | is_list_next : forall (next1:(map.Map.map pointer pointer)) (p:pointer),
      (~ (p = null)) -> ((is_list next1 (map.Map.get next1 p)) ->
      (is_list next1 p)).

Axiom ft : forall (a:Type) {a_WT:WhyType a}, Type.
Parameter ft_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ft a).
Existing Instance ft_WhyType.

Parameter in_ft: pointer -> (ft pointer) -> Prop.

Axiom set_eq : forall (ft1:(ft pointer)) (ft2:(ft pointer)),
  (forall (q:pointer), (in_ft q ft1) <-> (in_ft q ft2)) -> (ft1 = ft2).

Parameter list_ft: (map.Map.map pointer pointer) -> pointer -> (ft pointer).

Axiom list_ft_node_null_cor : forall (next1:(map.Map.map pointer pointer))
  (q:pointer) (p:pointer), (q = null) -> ~ (in_ft p (list_ft next1 q)).

Axiom list_ft_node_next1 : forall (next1:(map.Map.map pointer pointer))
  (q:pointer) (p:pointer), (~ (q = null)) -> ((is_list next1
  (map.Map.get next1 q)) -> ((in_ft p (list_ft next1 (map.Map.get next1
  q))) -> (in_ft p (list_ft next1 q)))).

Axiom list_ft_node_next2 : forall (next1:(map.Map.map pointer pointer))
  (q:pointer), (~ (q = null)) -> ((is_list next1 (map.Map.get next1 q)) ->
  (in_ft q (list_ft next1 q))).

Axiom list_ft_node_next_inv : forall (next1:(map.Map.map pointer pointer))
  (q:pointer) (p:pointer), (~ (q = null)) -> ((is_list next1
  (map.Map.get next1 q)) -> ((~ (q = p)) -> ((in_ft p (list_ft next1 q)) ->
  (in_ft p (list_ft next1 (map.Map.get next1 q)))))).

Axiom frame_list : forall (next1:(map.Map.map pointer pointer)) (p:pointer)
  (q:pointer) (v:pointer), (~ (in_ft q (list_ft next1 p))) -> ((is_list next1
  p) -> (is_list (map.Map.set next1 q v) p)).

(* Why3 assumption *)
Definition sep_node_list(next1:(map.Map.map pointer pointer)) (p1:pointer)
  (p2:pointer): Prop := ~ (in_ft p1 (list_ft next1 p2)).

(* Why3 goal *)
Theorem frame_list_ft : forall (next1:(map.Map.map pointer pointer))
  (p:pointer) (q:pointer) (v:pointer), (~ (in_ft q (list_ft next1 p))) ->
  ((is_list next1 p) -> ((list_ft next1 p) = (list_ft (map.Map.set next1 q v)
  p))).
Proof.
intros.
apply set_eq.
intros.
split;intro.
(** First part *)
induction H0.
apply (list_ft_node_null_cor _ _ _ H0) in H1;contradiction.
(* some asserts *)
assert (q<>p) by (intro eq;apply H;rewrite eq;clear eq;apply (list_ft_node_next2 _ _ H0 H2)).
assert  (H2' : is_list (Map.set next1 q v) (Map.get (Map.set next1 q v) p))
by (rewrite (Map.Select_neq _ _ _ v H3);refine (frame_list _ _ _ _ _ H2);contradict H;exact (list_ft_node_next1 _ _ _ H0 H2 H)).
(* *)
destruct (pointer_dec p q0).
rewrite <- H4.
exact (list_ft_node_next2 _ p H0 H2').
(* p <> q0 *)
apply (list_ft_node_next1 _ _ _ H0 H2').
rewrite (Map.Select_neq _ _ _ _ H3).
apply IHis_list.
contradict H;exact (list_ft_node_next1 _ _ _ H0 H2 H).
exact (list_ft_node_next_inv _ _ _ H0 H2 H4 H1).
(** Second part *)
induction H0.
apply (list_ft_node_null_cor _ _ _ H0) in H1;contradiction.
(* some asserts *)
assert (q<>p) by (intro eq;apply H;rewrite eq;clear eq;apply (list_ft_node_next2 _ _ H0 H2)).
assert  (H2' : is_list (Map.set next1 q v) (Map.get (Map.set next1 q v) p))
by (rewrite (Map.Select_neq _ _ _ v H3);refine (frame_list _ _ _ _ _ H2);contradict H;exact (list_ft_node_next1 _ _ _ H0 H2 H)).
(* *)
destruct (pointer_dec p q0).
rewrite <- H4.
exact (list_ft_node_next2 _ p H0 H2).
(* p <> q0 *)
apply (list_ft_node_next1 _ _ _ H0 H2).
apply IHis_list.
contradict H;exact (list_ft_node_next1 _ _ _ H0 H2 H).
rewrite <- (Map.Select_neq _ _ _ v H3).
exact (list_ft_node_next_inv _ _ _ H0 H2' H4 H1).
Qed.


