/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright CANON INC. 2010
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <string.h>
#include "cngplpmodIF.h"

#define ID(s) {s, #s}

typedef struct id_pair{
	int number;
	const char* string;
}ID_PAIR;

ID_PAIR g_IDs[]={
	ID(ID_PPD_OPTION),
	ID(ID_PAGESIZE),
	ID(ID_MEDIATYPE),
	ID(ID_INPUTSLOT),
	ID(ID_OUTPUTBIN),
	ID(ID_DUPLEX),
	ID(ID_BOOKLET),
	ID(ID_BINDEDGE),
	ID(ID_CNOUTPUTPARTITION),
	ID(ID_COLLATE),
	ID(ID_STAPLELOCATION),
	ID(ID_CNSADDLESTITCH),
	ID(ID_CNTRIMMING),
	ID(ID_CNZFOLDING),
	ID(ID_CNPUNCH),
	ID(ID_CNINSERTER),
	ID(ID_RESOLUTION),
	ID(ID_CNCOLORMODE),
	ID(ID_CNHALFTONE),
	ID(ID_CNBLACKSUBSTITUTE),
	ID(ID_CNPUREBLACKPROCESS),
	ID(ID_CNTONERSAVING),
	ID(ID_CNFINISHER),
	ID(ID_CNPUNCHER),
	ID(ID_CNFOLDER),
	ID(ID_CNINSERTUNIT),
	ID(ID_CNTRIMMER),
	ID(ID_CNDUPLEXUNIT),
	ID(ID_CNJOBEXECMODE),
	ID(ID_CNTONERDENSITY),
	ID(ID_CNSUPERSMOOTH),
	ID(ID_CNFIXINGMODE),
	ID(ID_CNBACKPAPERPRINT),
	ID(ID_CNOUTPUTFACE),
	ID(ID_CNROTATEPRINT),
	ID(ID_CNIMAGESPECIALPROCESS),
	ID(ID_CNCOPYSETNUMBERING),
	ID(ID_CNDRAFTMODE),
	ID(ID_CNINTERLEAFSHEET),
	ID(ID_CNINTERLEAFMEDIATYPE),
	ID(ID_CNINTERLEAFPRINT),
	ID(ID_CNSRCOPTION),
	ID(ID_CNCOLORHALFTONE),
	ID(ID_CNCTONERDENSITY),
	ID(ID_CNMTONERDENSITY),
	ID(ID_CNYTONERDENSITY),
	ID(ID_CNKEEPGRAY),
	ID(ID_CNSKIPBLANK),
	ID(ID_CNDETECTPAPERSIZE),
	ID(ID_CNPUREBLACKTEXT),
	ID(ID_CNBLACKOVERPRINT),
	ID(ID_CNRGBSOURCEPROFILE),
	ID(ID_CNRGBMATCHINGMETHOD),
	ID(ID_CNRGBPUREBLACKPROCESS),
	ID(ID_CNCMYKSIMULATIONPROFILE),
	ID(ID_CNUSEGRAYSCALEPROFILE),
	ID(ID_CNOUTPUTPROFILE),
	ID(ID_CNGRADATIONSMOOTHING),
	ID(ID_CNIMAGEREFINEMENT),
	ID(ID_CNLINEREFINEMENT),
	ID(ID_CNMIRRORPRINT),
	ID(ID_CNSPECIALPRINTINGMODE),
	ID(ID_CNPOSTCARDPRINTING),
	ID(ID_CNLASTPAGEPRINTMODE),
	ID(ID_CNPAPERSELECTION),
	ID(ID_CNINTERLEAFSLOT),
	ID(ID_CNCONTINUEPRINTING),
	ID(ID_CNPOSTCARDPRINTMODE),
	ID(ID_CNGRADATION),
	ID(ID_CNGRADATIONPRINT),
	ID(ID_CNXCOLORADJUSTMENT),
	ID(ID_CNYCOLORADJUSTMENT),
	ID(ID_CNBRIGHTNESS),
	ID(ID_CNCONTRAST),
	ID(ID_CNIMAGEADJUSTMENT),
	ID(ID_CNGRAPHICSADJUSTMENT),
	ID(ID_CNTEXTADJUSTMENT),
	ID(ID_CNMATCHINGMODE),
	ID(ID_CNMATCHINGMETHOD),
	ID(ID_CNIMGAGEMATCHINGMETHOD),
	ID(ID_CNGRAPHICSMATCHINGMETHOD),
	ID(ID_CNTEXTMATCHINGMETHOD),
	ID(ID_CNMONITORPROFILE),
	ID(ID_CNIMAGEMONITORPROFILE),
	ID(ID_CNGRAPHICSMONITORPROFILE),
	ID(ID_CNTEXTMONITORPROFILE),
	ID(ID_CNGAMMA),
	ID(ID_CNBWHALFTONE),
	ID(ID_CNSPOTCOLORMATCHING),
	ID(ID_CNOHPPRINTMODE),
	ID(ID_CNADVANCEDSMOOTHING),
	ID(ID_CNSET_FRONT_COVER),
	ID(ID_CNFRONT_PRINT_SHEET),
	ID(ID_CNFRONT_PAPER_SRC),
	ID(ID_CNSET_BACK_COVER),
	ID(ID_CNBACK_PRINT_SHEET),
	ID(ID_CNBACK_PAPER_SRC),
	ID(ID_CNTRAYCSETTING),
	ID(ID_CNSIDEPAPERDECK),
	ID(ID_CNHARDDISK),
	ID(ID_CNSPECIALFINELINEPROCESS),
	ID(ID_CNSHIFTSTARTPRINTPOSITION),
	ID(ID_CNPROCESSCOLORMODE),
	ID(ID_CNDUPLEXFIXMODE),
	ID(ID_CNCALIBRATE),
	ID(ID_CNDUPLEX),
	ID(ID_CNCREEP),
	ID(ID_CNSTAPLE),
	ID(ID_CNTYPEWING),
	ID(ID_CNIMAGECOMPRESSION),
	ID(ID_CNDENSITYFINEADJUSTMENT),
	ID(ID_CNDENSITYFINEADJUSTMENTNUM),
	ID(ID_CNCADMODE),
	ID(ID_CNGRAPHICSMODE),
	ID(ID_CNCOMPOSITEOVERPRINT),
	ID(ID_CNCOMBINECOLORSEPARATION),
	ID(ID_CNCURLCORRECTION),
	ID(ID_CNPAUSEPRINTINGMT),
	ID(ID_CNAPPCOLORMATCHING),
	ID(ID_CNFEEDCUSTOMHORIZONTALLY),
	ID(ID_CNDISPLACEMENTCORRECTION),
	ID(ID_CNPROGRESS),
	ID(ID_CNNOTIFICATION),
	ID(ID_CNOVERLAY),
	ID(ID_CNSELECTBY),
	ID(ID_CNOHPPRINT),
	ID(ID_CNINTERLEAFINPUTSLOT),
	ID(ID_CNPRINTOTHERSIDE),
	ID(ID_CNINSERTSHEET),
	ID(ID_CNSHEETFORINSERTION),
	ID(ID_CNINSERTPRINTSIDE),
	ID(ID_CNINSERTINPUTSLOT),
	ID(ID_PRIORITIES),
	ID(ID_USEPSBRIGHTNESS),
	ID(ID_PSBRIGHTNESS),
	ID(ID_CNCOLLATE),
	ID(ID_CNCFOLDING),
	ID(ID_CNPBINDCOVERSHEET),
	ID(ID_CNPBINDFINISHING),
	ID(ID_CNPBINDMAINPAPER),
	ID(ID_CNADJUSTTRIM),
	ID(ID_CNTRUSTPRINT),
	ID(ID_CNOVERLAYFORMCOMPOSITION),
	ID(ID_CNUSESHARPNESS),
	ID(ID_CNSHARPNESS),
	ID(ID_CNTONERDENSITYADJUSTMENT),
	ID(ID_CNLINECONTROL),
	ID(ID_CNSMALLSIZECURL),
	ID(ID_CNAUTHENTICATE),
	ID(ID_CNUSEJOBACCOUNT),
	ID(ID_CNSENDTIME),
	ID(ID_CNCOVERPAGEMODE),
	ID(ID_CNINSLOTMANMEDIATYPE),
	ID(ID_CNINSLOT1MEDIATYPE),
	ID(ID_CNINSLOT2MEDIATYPE),
	ID(ID_CNINSLOT3MEDIATYPE),
	ID(ID_CNINSLOT4MEDIATYPE),
	ID(ID_CNSIDEDECKMEDIATYPE),
	ID(ID_CNUSEOUTSIDELINENUM),
	ID(ID_CNLINESELECTION),
	ID(ID_CNFAXNUMOFLINE),
	ID(ID_CNSPECID),
	ID(ID_CNTOTALMEMSIZE),
	ID(ID_CNDUPUNIT),
	ID(ID_CNFAXLINETYPE),
	ID(ID_CNENABLETRUSTPRINT),
	ID(ID_CNFINTRAY),
	ID(ID_CNSTACKER),
	ID(ID_CNBINDEROPTION),
	ID(ID_CNENABLEMULTIINSERTER),
	ID(ID_CNTONERVOLUMEADJUSTMENT),
	ID(ID_CNCOPYTRAY),
	ID(ID_CNCFOLDSETTING),
	ID(ID_CNTABPRINTMODE),
	ID(ID_CNOUTPUTCOLORSPEED),
	ID(ID_CNINSLOT5MEDIATYPE),
	ID(ID_CNINSLOT6MEDIATYPE),
	ID(ID_CNINSLOT7MEDIATYPE),
	ID(ID_CNINSLOT8MEDIATYPE),
	ID(ID_CNOPTIONSTAPLE),
	ID(ID_CNSPECIALPRINTADJUSTMENTA),
	ID(ID_CNSPECIALPRINTADJUSTMENTB),
	ID(ID_CNREVICEPOSTCARD),
	ID(ID_CNOUTPUTADJUSTMENT),
	ID(ID_CNSPECIALSMOOTH),
	ID(ID_CNENABLEQUICK),
	ID(ID_CNENABLEFINE),
	ID(ID_CNENABLESUPERFINE),
	ID(ID_CNFAXDIALLINE1),
	ID(ID_CNFAXDIALLINE2),
	ID(ID_CNFAXDIALLINE3),
	ID(ID_CNWRINKLESCORRECTIONOUTPUT),
	ID(ID_CNPDEUSEJOBACCOUNT),
	ID(ID_CNPROPUNCHER),
	ID(ID_CNMULTIPUNCH),
	ID(ID_CNTOPBOTTOMTRIMMER),
	ID(ID_CNFAXDIALLINE4),
	ID(ID_CNSADDLEUNIT),
	ID(ID_CNCLEARCOATINGAPPLICATION),
	ID(ID_CNGLOSSYPLAINPAPERPROC),
	ID(ID_CNVFOLDING),
	ID(ID_CNHALFFOLDING),
	ID(ID_CNACCORDIONZFOLDING),
	ID(ID_CNDOUBLEPARALLELFOLDING),
	ID(ID_CNHALFFOLDSETTING),
	ID(ID_CNACCORDIONZFOLDSETTING),
	ID(ID_CNDOUBLEPARALLELFOLDSETTING),
	ID(ID_CNSADDLESETTING),
	ID(ID_CNTRAPPING),
	ID(ID_CNTRAPWIDTH),
	ID(ID_CNTRAPDENSITY),
	ID(ID_CNSIZEOVERRIDE),
	ID(ID_CNREVERSEORDER),
	ID(ID_CNDOTGAIN),
	ID(ID_CNGRAYCONVERSION),
	ID(ID_CNPBINDCOVERSELECTBY),
	ID(ID_CNPBINDCOVERPAPERSOURCE),
	ID(ID_CNPBINDCOVERMEDIATYPE),
	ID(ID_CNPBINDSPECIFYFINISHINGBY),
	ID(ID_CNSPECIFYNUMOFCOPIESSTACK),
	ID(ID_CNRGBMATCHINGMODE),
	ID(ID_CNRGBINPUTLIGHTCLRSPACE),
	ID(ID_CNCMYKMATCHINGMODE),
	ID(ID_CNCMYKINPUTLIGHTCLRSPACE),
	ID(ID_CNINSLOT9MEDIATYPE),
	ID(ID_CNINSLOT10MEDIATYPE),
	ID(ID_CNINNERTRIMMER),
	ID(ID_CNUSERSEPARATEMODE),
	ID(ID_CNSORTERFINISH),
	ID(ID_CNSTACKERFINISH),
	ID(ID_CNBINNAMEMODE),
	ID(ID_CNUSESUBSTITUTEFONT),
	ID(ID_CNPRINTERFONT),
	ID(ID_CNSUBSTITUTEEUROFONT),
	ID(ID_CNENABLESUBSTITUTEFONT),
	ID(ID_CNPDEDISPAYALLWARNING),
	ID(ID_CNPLAINPAPERCURLCORRECT),
	ID(ID_CNWRINKLEESCAPEMODE),
	ID(ID_CNCURLPAPERMODEB),
	ID(ID_CNSPECIALPRINTADJUSTMENTC),
	ID(ID_CNUSECOLORANTDENSITY),
	ID(ID_CNCOLORANTDENSITY),
	ID(ID_CNSPECIALPRINTINGMODEA),
	ID(ID_CNSPECIALPRINTINGMODEB),
	ID(ID_CNBARCODE),
	ID(ID_CNWHITEGAP),
	ID(ID_CNNUMBEROFCOLORS),
	ID(ID_CNCOLORTOUSEWITHBLACK),
	ID(ID_CNSADDLEPRESS),
	ID(ID_CNPRINTIMAGEADJUSTMENT),
	ID(ID_CNDEVICETYPE),
	ID(ID_CNFEEDAFIVEVERTICALLY),
	ID(ID_CNSPECIALPRINTADJUSTMENT),
	ID(ID_CNFOLDSETTING),
	ID(ID_CNPRINTSTYLE),
	ID(ID_CNFOLDDETAIL),
	ID(ID_CNUSESECUREDPRINT),
	ID(ID_CNFINEADJUSTDENSITYHIGH),
	ID(ID_CNFINEADJUSTDENSITYMEDIUM),
	ID(ID_CNFINEADJUSTDENSITYLOW),
	ID(ID_CNCFINEADJUSTDENSITYHIGH),
	ID(ID_CNCFINEADJUSTDENSITYMEDIUM),
	ID(ID_CNCFINEADJUSTDENSITYLOW),
	ID(ID_CNMFINEADJUSTDENSITYHIGH),
	ID(ID_CNMFINEADJUSTDENSITYMEDIUM),
	ID(ID_CNMFINEADJUSTDENSITYLOW),
	ID(ID_CNYFINEADJUSTDENSITYHIGH),
	ID(ID_CNYFINEADJUSTDENSITYMEDIUM),
	ID(ID_CNYFINEADJUSTDENSITYLOW),
	ID(ID_CNVFOLDINGTRIMMING),
	ID(ID_CNBARCODEMODE),
	ID(ID_CNCOVERPAGESTYLE),
	ID(ID_CNBOOKLETOFFSET),
	ID(ID_CNENABLECMSSETTINGS),
	ID(ID_CNUSECPCASECURITYUSER),
	ID(ID_CNUSECPCASECURITYJOBPASSWORD),
	ID(ID_CNUSECPCASECURITYFCODE),
	ID(ID_CNDENSITYFINEADJUSTMENTREOS2),
	ID(ID_CNFEEDAFIVEHORIZONTALLY),
	ID(ID_CNFEEDSTATEMENTHORIZONTALLY),
	ID(ID_CNSPECIALSETTINGSONE),
	ID(ID_CNDRAFTMODETWO),
	ID(ID_CNHYPERSHARPNESS),
	ID(ID_CNFAXIPFAXINTRA),
	ID(ID_CNFAXIPFAXVOIP),
	ID(ID_CNFAXIPFAXNGN),
	ID(ID_CNFAXIPFAXMYNUMBERNGN),
    ID(ID_SPECIALPRINTPROCESS),
	ID(ID_CNWIDTHADJUSTMENT),
	ID(ID_CNTRAPUPPERWIDTH),
	ID(ID_CNTRAPLOWERWIDTH),
	ID(ID_CNTRAPLEFTWIDTH),
	ID(ID_CNTRAPRIGHTWIDTH),
	ID(ID_CNTRAPCYANDENSITY),
	ID(ID_CNTRAPMAGENTADENSITY),
	ID(ID_CNTRAPYELLOWDENSITY),
	ID(ID_CNOPTIMIZEIMAGECOMP),
	ID(ID_CNTRIMSPECIFYMETHOD),
    ID(ID_CNIMPROVEPRINTSPEED),
	ID(ID_CNCOLORTONERVOLUMEADJUSTMENT),
    ID(ID_CNTIMINGOFAUTOEJECTSTACKER),
    ID(ID_CNINTERLEAFSELECTBY),
	ID(ID_CNSADDLEFOLDING),
	ID(ID_CNSADDLEFOLDSETTING),
	ID(ID_CNSADDLEFOLDSHEETSNUM_L),
	ID(ID_PPD_OPTION_BOTTOM),
	ID(ID_DEVICE_INFO),
	ID(ID_SIDED1PRINT),
	ID(ID_SELECTBY),
	ID(ID_BOOKLET_DLG),
	ID(ID_DATANAME),
	ID(ID_ENTERNAME),
	ID(ID_BOXIDNUM),
	ID(ID_GUTTER),
	ID(ID_SECURED_DOCNAME),
	ID(ID_SECURED_USRNAME),
	ID(ID_SECURED_PASSWD),
	ID(ID_JOBACCOUNT),
	ID(ID_SHOW_JOBACCOUNT),
	ID(ID_JOBACCOUNT_ID),
	ID(ID_JOBACCOUNT_PASSWD),
	ID(ID_PRINTERTYPE),
	ID(ID_COLOR_MODE),
	ID(ID_SPECIAL_FUNC),
	ID(ID_MAX_COPIES),
	ID(ID_MAX_BOXIDNUM),
	ID(ID_MAX_GUTTER),
	ID(ID_DOC_LENGTH),
	ID(ID_STARTNUM),
	ID(ID_LIST_MEDIATYPE),
	ID(ID_USERID),
	ID(ID_BACKPAPERPRINT_LABEL),
	ID(ID_DISABLE_JOBACCOUNT_BW),
	ID(ID_SHOW_DISABLE_JOBACCOUNT_BW),
	ID(ID_DETECTPAPER_LABEL),
	ID(ID_CNDPICONPICTID),
	ID(ID_CNENABLEFINISHFLAG),
	ID(ID_CNENABLEINPUTFLAG),
	ID(ID_CNENABLEQUALITYTYPE),
	ID(ID_USTYPE),
	ID(ID_INPUTSLOT_TYPE),
	ID(ID_CNSHIFTTYPE),
	ID(ID_CNSHIFTUPWARDS),
	ID(ID_CNSHIFTRIGHT),
	ID(ID_CNSHIFTFRLONGEDGE),
	ID(ID_CNSHIFTFRSHORTEDGE),
	ID(ID_CNSHIFTBKLONGEDGE),
	ID(ID_CNSHIFTBKSHORTEDGE),
	ID(ID_CNJOBNOTE),
	ID(ID_CNJOBDETAILS),
	ID(ID_CNOFFSETNUM),
	ID(ID_CNINPUTSELECT),
	ID(ID_CNGUTTERSHIFTNUM),
	ID(ID_MAX_GUTTER_SHIFT_NUM),
	ID(ID_CNTABSHIFT),
	ID(ID_DRIVERROOTPATH),
	ID(ID_CNMEDIABRANDLIST),
	ID(ID_CNMEDIABRAND),
	ID(ID_CNMEDIALIBRARYID),
	ID(ID_CNMEDIASHAPE),
	ID(ID_CNINSERTMEDIABRANDLIST),
	ID(ID_CNINSERTMEDIABRAND),
	ID(ID_CNINSERTMEDIALIBRARYID),
	ID(ID_CNINTERLEAFMEDIABRANDLIST),
	ID(ID_CNINTERLEAFMEDIABRAND),
	ID(ID_CNINTERLEAFMEDIALIBRARYID),
	ID(ID_CNMONITORPROFILELIST),
	ID(ID_CNRGBSOURCEPROFILELIST),
	ID(ID_CNCMYKSIMULATIONPROFILELIST),
	ID(ID_CNOUTPUTPROFILELIST),
	ID(ID_CNINSERTTABSHIFT),
	ID(ID_CNINSERTPOS),
	ID(ID_CNTABINSERTPOS),
	ID(ID_CNOVERLAYFILENAME),
	ID(ID_CNFORMHANDLE),
	ID(ID_CNMAXBOXNUM),
	ID(ID_CNADJUSTTRIMNUM),
	ID(ID_CNMAXINSERTCOUNT),
	ID(ID_CNSHIFTSTARTPRINTPOSTYPE),
	ID(ID_CNSENDTIMENUM),
	ID(ID_CNOUTSIDELINENUMBER),
	ID(ID_CNSENDER),
	ID(ID_HOLD_NAME),
	ID(ID_HOLDQUEUE_DATANAME),
	ID(ID_MIN_GUTTER_SHIFT_NUM),
	ID(ID_DEFAULT_GUTTER_SHIFT_NUM),
	ID(ID_LIST_PAGESIZE),
	ID(ID_CNSHIFTPOSITIONMAX),
	ID(ID_CNSHIFTPOSITIONMIN),
	ID(ID_CNFINDETAILS),
	ID(ID_CNUITRIMVALMAX),
	ID(ID_CNUITRIMVALMIN),
	ID(ID_CNUIADJUSTTRIMNUMDEFAULT),
	ID(ID_ENABLECNOFFSETNUM),
	ID(ID_CNUIOFFSETMAX),
	ID(ID_CNADJUSTFORETRIMNUM),
	ID(ID_CNADJUSTTOPBOTTOMTRIMNUM),
	ID(ID_CNFEEDPAPERNAME),
	ID(ID_CNPBINDCOVERMEDIABRANDLIST),
	ID(ID_CNPBINDCOVERMEDIABRAND),
	ID(ID_CNPBINDCOVERMEDIALIBRARYID),
	ID(ID_CNPBINDFINISHFORETRIMNUM),
	ID(ID_CNPBINDFINISHTOPBOTTOMTRIMNUM),
	ID(ID_CNSTACKCOPIESNUM),
	ID(ID_CNRGBDEVICELINKPROFILELIST),
	ID(ID_CNCMYKDEVICELINKPROFILELIST),
	ID(ID_CNINSERTPOSPAPERSOURCE),
	ID(ID_CNINSERTPOSPRINTON),
	ID(ID_CNTABINSERTPOSPAPERSOURCE),
	ID(ID_CNTABINSERTPOSPRINTON),
	ID(ID_CNLISTIDSPECIALPRINTMODE),
	ID(ID_CNUIPAPERSOURCETYPE),
	ID(ID_CNBINNAME),
	ID(ID_CNBINNAME_ARRAY),
	ID(ID_CNSADDLEPRESSADJUSTMENT),
	ID(ID_PCFILENAME),
	ID(ID_MANUFACTURER),
	ID(ID_NICKNAME),
	ID(ID_CNPDLTYPE),
	ID(ID_APPRINTERICONPATH),
	ID(ID_CNTABINSERTMULTIPAPERNUMBER),
	ID(ID_CNTABINSERTMULTIPAPERSOURCE),
	ID(ID_CNTABINSERTMULTIPAPERTYPE),
	ID(ID_CNOUTSIDELINENUMINTRA),
	ID(ID_CNOUTSIDELINENUMNGN),
	ID(ID_CNOUTSIDELINENUMMYNUMBERNGN),
	ID(ID_CNOUTSIDELINENUMVOIP),
	ID(ID_CONFLICTCNOFFSETNUM),
	ID(ID_ENABLEINSERTPOSPAPERSOURCE),
	ID(ID_ENABLETABINSERTPOSPAPERSOURCE),
	ID(ID_SHOW_USERAUTHENTICATION),
	ID(ID_USERAUTHENTICATION),
	ID(ID_USERAUTHENTICATION_ID),
	ID(ID_CNUSRPASSWORD),
	ID(ID_DEVICE_INFO_BOTTOM),
	ID(ID_COMMON_OPTION),
	ID(ID_CNCOPIES),
	ID(ID_PAGE_SET),
	ID(ID_PAGE_RANGES),
	ID(ID_OUTPUTORDER),
	ID(ID_NUMBER_UP),
	ID(ID_ORIENTATION_REQUESTED),
	ID(ID_BRIGHTNESS),
	ID(ID_GAMMA),
	ID(ID_JOB_SHEETS_START),
	ID(ID_JOB_SHEETS_END),
	ID(ID_PRINTERNAME),
	ID(ID_FILTER),
	ID(ID_MEDIA),
	ID(ID_CNQUEUEDESCRIPTION),
	ID(ID_CNHOSTADDRESIPV4),
	ID(ID_CNHOSTADDRESIPV6),
	ID(ID_COMMON_OPTION_BOTTOM),
	ID(ID_IMAGE_OPTION),
	ID(ID_HUE),
	ID(ID_SATURATION),
	ID(ID_PPI),
	ID(ID_SCALING),
	ID(ID_NATURAL_SCALING),
	ID(ID_POSITION),
	ID(ID_RESO_SCALE),
	ID(ID_IMAGE_OPTION_BOTTOM),
	ID(ID_TEXT_OPTION),
	ID(ID_CPI),
	ID(ID_LPI),
	ID(ID_COLUMNS),
	ID(ID_PAGE_LEFT),
	ID(ID_PAGE_RIGHT),
	ID(ID_PAGE_TOP),
	ID(ID_PAGE_BOTTOM),
	ID(ID_PRETTYPRINT),
	ID(ID_MARGIN),
	ID(ID_TEXT_OPTION_BOTTOM),
	ID(ID_HPGL_OPTION),
	ID(ID_BLACKPLOT),
	ID(ID_FITPLOT),
	ID(ID_PENWIDTH),
	ID(ID_HPGL_OPTION_BOTTOM),
	ID(ID_BOTTON_EVENT),
	ID(ID_SETDEFAULT),
	ID(ID_EXECLPR),
	ID(ID_SHOWDLG),
	ID(ID_OK),
	ID(ID_CANCEL),
	ID(ID_PRINTERINFO),
	ID(ID_RESTOREDEFAULT),
	ID(ID_BOTTON_EVENT_BOTTOM),
    ID(ID_CNDLCUSTOMPROFILE),
	ID(ID_CNTBLDUPLEX),
	ID(ID_CNPREVENTPOSTCARDFOGGING),
	ID(ID_CNOBJECTPRIORITIZEPROCESSING),
	ID(ID_CNDUPLEXOPTION)
};

int GetModID(const char *key)
{
	int i = 0;
	for(i = 0; i < (sizeof(g_IDs)/sizeof(g_IDs[0])); i++){
		if(strcmp(g_IDs[i].string, key) == 0){
			return g_IDs[i].number;
		}
	}
	return -1;
}

const char* GetModStringID(const int id)
{
	int i = 0;
	for(i = 0; i < (sizeof(g_IDs)/sizeof(g_IDs[0])); i++){
		if(g_IDs[i].number == id){
			return g_IDs[i].string;
		}
	}
	return NULL;
}
