// Code generated by go-swagger; DO NOT EDIT.

package consul_telemetry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-consul-telemetry-gateway/preview/2023-04-14/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// QueryRangeBatchReader is a Reader for the QueryRangeBatch structure.
type QueryRangeBatchReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryRangeBatchReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryRangeBatchOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQueryRangeBatchDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQueryRangeBatchOK creates a QueryRangeBatchOK with default headers values
func NewQueryRangeBatchOK() *QueryRangeBatchOK {
	return &QueryRangeBatchOK{}
}

/*
QueryRangeBatchOK describes a response with status code 200, with default header values.

A successful response.
*/
type QueryRangeBatchOK struct {
	Payload *models.HashicorpCloudConsulTelemetry20230414QueryRangeBatchResponse
}

// IsSuccess returns true when this query range batch o k response has a 2xx status code
func (o *QueryRangeBatchOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query range batch o k response has a 3xx status code
func (o *QueryRangeBatchOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query range batch o k response has a 4xx status code
func (o *QueryRangeBatchOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query range batch o k response has a 5xx status code
func (o *QueryRangeBatchOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query range batch o k response a status code equal to that given
func (o *QueryRangeBatchOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query range batch o k response
func (o *QueryRangeBatchOK) Code() int {
	return 200
}

func (o *QueryRangeBatchOK) Error() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/query_range_batch][%d] queryRangeBatchOK  %+v", 200, o.Payload)
}

func (o *QueryRangeBatchOK) String() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/query_range_batch][%d] queryRangeBatchOK  %+v", 200, o.Payload)
}

func (o *QueryRangeBatchOK) GetPayload() *models.HashicorpCloudConsulTelemetry20230414QueryRangeBatchResponse {
	return o.Payload
}

func (o *QueryRangeBatchOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudConsulTelemetry20230414QueryRangeBatchResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRangeBatchDefault creates a QueryRangeBatchDefault with default headers values
func NewQueryRangeBatchDefault(code int) *QueryRangeBatchDefault {
	return &QueryRangeBatchDefault{
		_statusCode: code,
	}
}

/*
QueryRangeBatchDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type QueryRangeBatchDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this query range batch default response has a 2xx status code
func (o *QueryRangeBatchDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this query range batch default response has a 3xx status code
func (o *QueryRangeBatchDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this query range batch default response has a 4xx status code
func (o *QueryRangeBatchDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this query range batch default response has a 5xx status code
func (o *QueryRangeBatchDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this query range batch default response a status code equal to that given
func (o *QueryRangeBatchDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the query range batch default response
func (o *QueryRangeBatchDefault) Code() int {
	return o._statusCode
}

func (o *QueryRangeBatchDefault) Error() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/query_range_batch][%d] QueryRangeBatch default  %+v", o._statusCode, o.Payload)
}

func (o *QueryRangeBatchDefault) String() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/query_range_batch][%d] QueryRangeBatch default  %+v", o._statusCode, o.Payload)
}

func (o *QueryRangeBatchDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *QueryRangeBatchDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
QueryRangeBatchBody QueryRangeBatchRequest
//
// QueryRangeBatchRequest is a custom endpoint request to have multiple QueryRangeReuqests in a single endpoint that will multiple QueryRangeRequests in a single endpoint. Same
// restricuts on the type and the response type are required and must return a map of <string(the QueryRangeType), MetricMatrix>.
swagger:model QueryRangeBatchBody
*/
type QueryRangeBatchBody struct {

	// cluster_internal_id is the internal UUID of the cluster. This is used, instead of the public id,
	// to separate metrics per cluster. There could be two clusters in the same organization with the same public id,
	// or a two clusters with the same name in the same project, one created after the other is deleted. In either
	// scenario, we do not want to show the other cluster's metrics.
	ClusterInternalID string `json:"cluster_internal_id,omitempty"`

	// end
	// Format: date-time
	End strfmt.DateTime `json:"end,omitempty"`

	// location
	Location *QueryRangeBatchParamsBodyLocation `json:"location,omitempty"`

	// query is the set of QueryRangeTypes (QRT) to query for. Between 1 and 10 queries can be issued in one batch.
	Query []*models.HashicorpCloudConsulTelemetry20230414QRT `json:"query"`

	// service_name is an optional filter for service-level queries. Required for service-specific queries.
	ServiceName string `json:"service_name,omitempty"`

	// service_namespace is an optional filter for service-level queries. Required for service-specific queries.
	ServiceNamespace string `json:"service_namespace,omitempty"`

	// service_partition is an optional filter for service-level queries. Required for service-specific queries.
	ServicePartition string `json:"service_partition,omitempty"`

	// start
	// Format: date-time
	Start strfmt.DateTime `json:"start,omitempty"`

	// step
	Step string `json:"step,omitempty"`
}

// Validate validates this query range batch body
func (o *QueryRangeBatchBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateEnd(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQuery(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStart(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QueryRangeBatchBody) validateEnd(formats strfmt.Registry) error {
	if swag.IsZero(o.End) { // not required
		return nil
	}

	if err := validate.FormatOf("body"+"."+"end", "body", "date-time", o.End.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *QueryRangeBatchBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *QueryRangeBatchBody) validateQuery(formats strfmt.Registry) error {
	if swag.IsZero(o.Query) { // not required
		return nil
	}

	for i := 0; i < len(o.Query); i++ {
		if swag.IsZero(o.Query[i]) { // not required
			continue
		}

		if o.Query[i] != nil {
			if err := o.Query[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("body" + "." + "query" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("body" + "." + "query" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *QueryRangeBatchBody) validateStart(formats strfmt.Registry) error {
	if swag.IsZero(o.Start) { // not required
		return nil
	}

	if err := validate.FormatOf("body"+"."+"start", "body", "date-time", o.Start.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this query range batch body based on the context it is used
func (o *QueryRangeBatchBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQuery(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QueryRangeBatchBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *QueryRangeBatchBody) contextValidateQuery(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Query); i++ {

		if o.Query[i] != nil {

			if swag.IsZero(o.Query[i]) { // not required
				return nil
			}

			if err := o.Query[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("body" + "." + "query" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("body" + "." + "query" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *QueryRangeBatchBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QueryRangeBatchBody) UnmarshalBinary(b []byte) error {
	var res QueryRangeBatchBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QueryRangeBatchParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model QueryRangeBatchParamsBodyLocation
*/
type QueryRangeBatchParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *cloud.HashicorpCloudLocationRegion `json:"region,omitempty"`
}

// Validate validates this query range batch params body location
func (o *QueryRangeBatchParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QueryRangeBatchParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this query range batch params body location based on the context it is used
func (o *QueryRangeBatchParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QueryRangeBatchParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QueryRangeBatchParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QueryRangeBatchParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res QueryRangeBatchParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
