// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudGlobalNetworkManager20220215ListClustersWithAcceptorEligibilityResponseClusterWithAcceptorEligibility hashicorp cloud global network manager 20220215 list clusters with acceptor eligibility response cluster with acceptor eligibility
//
// swagger:model hashicorp.cloud.global_network_manager_20220215.ListClustersWithAcceptorEligibilityResponse.ClusterWithAcceptorEligibility
type HashicorpCloudGlobalNetworkManager20220215ListClustersWithAcceptorEligibilityResponseClusterWithAcceptorEligibility struct {

	// hcp_public indicates if this is an HCP-managed, public cluster
	HcpPublic bool `json:"hcp_public,omitempty"`

	// id is the user settable GNM cluster name.
	ID string `json:"id,omitempty"`

	// ineligibility_reasons is the list of reasons why this cluster is ineligible. Empty
	// list means this cluster is eligible.
	IneligibilityReasons []*HashicorpCloudGlobalNetworkManager20220215PeeringIneligibilityReason `json:"ineligibility_reasons"`

	// partitions are the Consul admin partitions on the cluster
	Partitions []*HashicorpCloudGlobalNetworkManager20220215AdminPartition `json:"partitions"`
}

// Validate validates this hashicorp cloud global network manager 20220215 list clusters with acceptor eligibility response cluster with acceptor eligibility
func (m *HashicorpCloudGlobalNetworkManager20220215ListClustersWithAcceptorEligibilityResponseClusterWithAcceptorEligibility) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIneligibilityReasons(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartitions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215ListClustersWithAcceptorEligibilityResponseClusterWithAcceptorEligibility) validateIneligibilityReasons(formats strfmt.Registry) error {
	if swag.IsZero(m.IneligibilityReasons) { // not required
		return nil
	}

	for i := 0; i < len(m.IneligibilityReasons); i++ {
		if swag.IsZero(m.IneligibilityReasons[i]) { // not required
			continue
		}

		if m.IneligibilityReasons[i] != nil {
			if err := m.IneligibilityReasons[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ineligibility_reasons" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("ineligibility_reasons" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215ListClustersWithAcceptorEligibilityResponseClusterWithAcceptorEligibility) validatePartitions(formats strfmt.Registry) error {
	if swag.IsZero(m.Partitions) { // not required
		return nil
	}

	for i := 0; i < len(m.Partitions); i++ {
		if swag.IsZero(m.Partitions[i]) { // not required
			continue
		}

		if m.Partitions[i] != nil {
			if err := m.Partitions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("partitions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("partitions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud global network manager 20220215 list clusters with acceptor eligibility response cluster with acceptor eligibility based on the context it is used
func (m *HashicorpCloudGlobalNetworkManager20220215ListClustersWithAcceptorEligibilityResponseClusterWithAcceptorEligibility) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIneligibilityReasons(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartitions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215ListClustersWithAcceptorEligibilityResponseClusterWithAcceptorEligibility) contextValidateIneligibilityReasons(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IneligibilityReasons); i++ {

		if m.IneligibilityReasons[i] != nil {

			if swag.IsZero(m.IneligibilityReasons[i]) { // not required
				return nil
			}

			if err := m.IneligibilityReasons[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ineligibility_reasons" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("ineligibility_reasons" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215ListClustersWithAcceptorEligibilityResponseClusterWithAcceptorEligibility) contextValidatePartitions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Partitions); i++ {

		if m.Partitions[i] != nil {

			if swag.IsZero(m.Partitions[i]) { // not required
				return nil
			}

			if err := m.Partitions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("partitions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("partitions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215ListClustersWithAcceptorEligibilityResponseClusterWithAcceptorEligibility) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215ListClustersWithAcceptorEligibilityResponseClusterWithAcceptorEligibility) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudGlobalNetworkManager20220215ListClustersWithAcceptorEligibilityResponseClusterWithAcceptorEligibility
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
