/* SPDX-FileCopyrightText: 2024 Greenbone AG
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

import {_, _l} from 'gmp/locale/lang';

import {OS_FILTER_FILTER} from 'gmp/models/filter';

import CvssDisplay from 'web/components/dashboard/display/cvss/cvssdisplay';
import CvssTableDisplay from 'web/components/dashboard/display/cvss/cvsstabledisplay'; // eslint-disable-line max-len
import createDisplay from 'web/components/dashboard/display/createDisplay';
import {registerDisplay} from 'web/components/dashboard/registry';

import {OsAverageSeverityLoader} from './loaders';

export const OsCvssDisplay = createDisplay({
  loaderComponent: OsAverageSeverityLoader,
  displayComponent: CvssDisplay,
  yLabel: _l('# of Vulnerabilities'),
  title: ({data: tdata}) =>
    _('Operating Systems by CVSS (Total: {{count}})', {count: tdata.total}),
  filtersFilter: OS_FILTER_FILTER,
  displayId: 'os-by-cvss',
  displayName: 'OsCvssDisplay',
});

export const OsCvssTableDisplay = createDisplay({
  loaderComponent: OsAverageSeverityLoader,
  displayComponent: CvssTableDisplay,
  filtersFilter: OS_FILTER_FILTER,
  dataTitles: [_l('Severity'), _l('# of Operating Systems')],
  title: ({data: tdata = {}}) =>
    _('Operating Systems by CVSS (Total: {{count}})', {count: tdata.total}),
  displayId: 'os-by-cvss-table',
  displayName: 'OsCvssTableDisplay',
});

registerDisplay(OsCvssTableDisplay.displayId, OsCvssTableDisplay, {
  title: _l('Table: Operating Systems by CVSS'),
});

registerDisplay(OsCvssDisplay.displayId, OsCvssDisplay, {
  title: _l('Chart: Operating Systems by CVSS'),
});

// vim: set ts=2 sw=2 tw=80:
