/* SPDX-FileCopyrightText: 2024 Greenbone AG
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

import Model from 'gmp/model';
import {isDefined} from 'gmp/utils/identity';
import {parseDate} from 'gmp/parser';

class Vulnerability extends Model {
  static entityType = 'vulnerability';

  static parseElement(element) {
    const ret = super.parseElement(element);

    if (isDefined(ret.results)) {
      ret.results.newest = parseDate(ret.results.newest);
      ret.results.oldest = parseDate(ret.results.oldest);
    }

    return ret;
  }
}

export default Vulnerability;

// vim: set ts=2 sw=2 tw=80:
