// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

// ⚠️This file was generated by GENERATOR!🦹‍♂️

use crate::code_asm::asm_traits::*;
use crate::code_asm::CodeAssembler;
use crate::IcedError;

#[rustfmt::skip]
impl CodeAssembler {
	/// `AAA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AAA` | `37` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn aaa(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmAaa,
	{
		<Self as CodeAsmAaa>::aaa(self)
	}

	/// `AAD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AAD imm8` | `D5 ib` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn aad<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmAad<T>,
	{
		<Self as CodeAsmAad<T>>::aad(self, op0)
	}

	/// `AADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AADD m32, r32` | `NP 0F 38 FC !(11):rrr:bbb` | `RAO-INT`
	/// `AADD m64, r64` | `NP o64 0F 38 FC !(11):rrr:bbb` | `RAO-INT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aadd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAadd<T, U>,
	{
		<Self as CodeAsmAadd<T, U>>::aadd(self, op0, op1)
	}

	/// `AAM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AAM imm8` | `D4 ib` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn aam<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmAam<T>,
	{
		<Self as CodeAsmAam<T>>::aam(self, op0)
	}

	/// `AAND` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AAND m32, r32` | `66 0F 38 FC !(11):rrr:bbb` | `RAO-INT`
	/// `AAND m64, r64` | `66 o64 0F 38 FC !(11):rrr:bbb` | `RAO-INT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aand<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAand<T, U>,
	{
		<Self as CodeAsmAand<T, U>>::aand(self, op0, op1)
	}

	/// `AAS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AAS` | `3F` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn aas(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmAas,
	{
		<Self as CodeAsmAas>::aas(self)
	}

	/// `ADC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ADC r/m8, r8` | `10 /r` | `8086+`
	/// `ADC r/m16, r16` | `o16 11 /r` | `8086+`
	/// `ADC r/m32, r32` | `o32 11 /r` | `386+`
	/// `ADC r/m64, r64` | `o64 11 /r` | `X64`
	/// `ADC r8, r/m8` | `12 /r` | `8086+`
	/// `ADC r16, r/m16` | `o16 13 /r` | `8086+`
	/// `ADC r32, r/m32` | `o32 13 /r` | `386+`
	/// `ADC r64, r/m64` | `o64 13 /r` | `X64`
	/// `ADC AL, imm8` | `14 ib` | `8086+`
	/// `ADC AX, imm16` | `o16 15 iw` | `8086+`
	/// `ADC EAX, imm32` | `o32 15 id` | `386+`
	/// `ADC RAX, imm32` | `o64 15 id` | `X64`
	/// `ADC r/m8, imm8` | `80 /2 ib` | `8086+`
	/// `ADC r/m16, imm16` | `o16 81 /2 iw` | `8086+`
	/// `ADC r/m32, imm32` | `o32 81 /2 id` | `386+`
	/// `ADC r/m64, imm32` | `o64 81 /2 id` | `X64`
	/// `ADC r/m16, imm8` | `o16 83 /2 ib` | `8086+`
	/// `ADC r/m32, imm8` | `o32 83 /2 ib` | `386+`
	/// `ADC r/m64, imm8` | `o64 83 /2 ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn adc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAdc<T, U>,
	{
		<Self as CodeAsmAdc<T, U>>::adc(self, op0, op1)
	}

	/// `ADCX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ADCX r32, r/m32` | `66 0F 38 F6 /r` | `ADX`
	/// `ADCX r64, r/m64` | `66 o64 0F 38 F6 /r` | `ADX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn adcx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAdcx<T, U>,
	{
		<Self as CodeAsmAdcx<T, U>>::adcx(self, op0, op1)
	}

	/// `ADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ADD r/m8, r8` | `00 /r` | `8086+`
	/// `ADD r/m16, r16` | `o16 01 /r` | `8086+`
	/// `ADD r/m32, r32` | `o32 01 /r` | `386+`
	/// `ADD r/m64, r64` | `o64 01 /r` | `X64`
	/// `ADD r8, r/m8` | `02 /r` | `8086+`
	/// `ADD r16, r/m16` | `o16 03 /r` | `8086+`
	/// `ADD r32, r/m32` | `o32 03 /r` | `386+`
	/// `ADD r64, r/m64` | `o64 03 /r` | `X64`
	/// `ADD AL, imm8` | `04 ib` | `8086+`
	/// `ADD AX, imm16` | `o16 05 iw` | `8086+`
	/// `ADD EAX, imm32` | `o32 05 id` | `386+`
	/// `ADD RAX, imm32` | `o64 05 id` | `X64`
	/// `ADD r/m8, imm8` | `80 /0 ib` | `8086+`
	/// `ADD r/m16, imm16` | `o16 81 /0 iw` | `8086+`
	/// `ADD r/m32, imm32` | `o32 81 /0 id` | `386+`
	/// `ADD r/m64, imm32` | `o64 81 /0 id` | `X64`
	/// `ADD r/m16, imm8` | `o16 83 /0 ib` | `8086+`
	/// `ADD r/m32, imm8` | `o32 83 /0 ib` | `386+`
	/// `ADD r/m64, imm8` | `o64 83 /0 ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn add<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAdd<T, U>,
	{
		<Self as CodeAsmAdd<T, U>>::add(self, op0, op1)
	}

	/// `ADDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ADDPD xmm1, xmm2/m128` | `66 0F 58 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn addpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAddpd<T, U>,
	{
		<Self as CodeAsmAddpd<T, U>>::addpd(self, op0, op1)
	}

	/// `ADDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ADDPS xmm1, xmm2/m128` | `NP 0F 58 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn addps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAddps<T, U>,
	{
		<Self as CodeAsmAddps<T, U>>::addps(self, op0, op1)
	}

	/// `ADDSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ADDSD xmm1, xmm2/m64` | `F2 0F 58 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn addsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAddsd<T, U>,
	{
		<Self as CodeAsmAddsd<T, U>>::addsd(self, op0, op1)
	}

	/// `ADDSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ADDSS xmm1, xmm2/m32` | `F3 0F 58 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn addss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAddss<T, U>,
	{
		<Self as CodeAsmAddss<T, U>>::addss(self, op0, op1)
	}

	/// `ADDSUBPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ADDSUBPD xmm1, xmm2/m128` | `66 0F D0 /r` | `SSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn addsubpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAddsubpd<T, U>,
	{
		<Self as CodeAsmAddsubpd<T, U>>::addsubpd(self, op0, op1)
	}

	/// `ADDSUBPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ADDSUBPS xmm1, xmm2/m128` | `F2 0F D0 /r` | `SSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn addsubps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAddsubps<T, U>,
	{
		<Self as CodeAsmAddsubps<T, U>>::addsubps(self, op0, op1)
	}

	/// `ADOX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ADOX r32, r/m32` | `F3 0F 38 F6 /r` | `ADX`
	/// `ADOX r64, r/m64` | `F3 o64 0F 38 F6 /r` | `ADX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn adox<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAdox<T, U>,
	{
		<Self as CodeAsmAdox<T, U>>::adox(self, op0, op1)
	}

	/// `AESDEC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESDEC xmm1, xmm2/m128` | `66 0F 38 DE /r` | `AES`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aesdec<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAesdec<T, U>,
	{
		<Self as CodeAsmAesdec<T, U>>::aesdec(self, op0, op1)
	}

	/// `AESDEC128KL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESDEC128KL xmm, m384` | `F3 0F 38 DD !(11):rrr:bbb` | `AESKLE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aesdec128kl<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAesdec128kl<T, U>,
	{
		<Self as CodeAsmAesdec128kl<T, U>>::aesdec128kl(self, op0, op1)
	}

	/// `AESDEC256KL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESDEC256KL xmm, m512` | `F3 0F 38 DF !(11):rrr:bbb` | `AESKLE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aesdec256kl<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAesdec256kl<T, U>,
	{
		<Self as CodeAsmAesdec256kl<T, U>>::aesdec256kl(self, op0, op1)
	}

	/// `AESDECLAST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESDECLAST xmm1, xmm2/m128` | `66 0F 38 DF /r` | `AES`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aesdeclast<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAesdeclast<T, U>,
	{
		<Self as CodeAsmAesdeclast<T, U>>::aesdeclast(self, op0, op1)
	}

	/// `AESDECWIDE128KL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESDECWIDE128KL m384, <XMM0-7>` | `F3 0F 38 D8 !(11):001:bbb` | `AESKLE WIDE_KL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn aesdecwide128kl<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmAesdecwide128kl<T>,
	{
		<Self as CodeAsmAesdecwide128kl<T>>::aesdecwide128kl(self, op0)
	}

	/// `AESDECWIDE256KL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESDECWIDE256KL m512, <XMM0-7>` | `F3 0F 38 D8 !(11):011:bbb` | `AESKLE WIDE_KL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn aesdecwide256kl<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmAesdecwide256kl<T>,
	{
		<Self as CodeAsmAesdecwide256kl<T>>::aesdecwide256kl(self, op0)
	}

	/// `AESENC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESENC xmm1, xmm2/m128` | `66 0F 38 DC /r` | `AES`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aesenc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAesenc<T, U>,
	{
		<Self as CodeAsmAesenc<T, U>>::aesenc(self, op0, op1)
	}

	/// `AESENC128KL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESENC128KL xmm, m384` | `F3 0F 38 DC !(11):rrr:bbb` | `AESKLE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aesenc128kl<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAesenc128kl<T, U>,
	{
		<Self as CodeAsmAesenc128kl<T, U>>::aesenc128kl(self, op0, op1)
	}

	/// `AESENC256KL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESENC256KL xmm, m512` | `F3 0F 38 DE !(11):rrr:bbb` | `AESKLE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aesenc256kl<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAesenc256kl<T, U>,
	{
		<Self as CodeAsmAesenc256kl<T, U>>::aesenc256kl(self, op0, op1)
	}

	/// `AESENCLAST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESENCLAST xmm1, xmm2/m128` | `66 0F 38 DD /r` | `AES`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aesenclast<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAesenclast<T, U>,
	{
		<Self as CodeAsmAesenclast<T, U>>::aesenclast(self, op0, op1)
	}

	/// `AESENCWIDE128KL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESENCWIDE128KL m384, <XMM0-7>` | `F3 0F 38 D8 !(11):000:bbb` | `AESKLE WIDE_KL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn aesencwide128kl<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmAesencwide128kl<T>,
	{
		<Self as CodeAsmAesencwide128kl<T>>::aesencwide128kl(self, op0)
	}

	/// `AESENCWIDE256KL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESENCWIDE256KL m512, <XMM0-7>` | `F3 0F 38 D8 !(11):010:bbb` | `AESKLE WIDE_KL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn aesencwide256kl<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmAesencwide256kl<T>,
	{
		<Self as CodeAsmAesencwide256kl<T>>::aesencwide256kl(self, op0)
	}

	/// `AESIMC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESIMC xmm1, xmm2/m128` | `66 0F 38 DB /r` | `AES`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aesimc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAesimc<T, U>,
	{
		<Self as CodeAsmAesimc<T, U>>::aesimc(self, op0, op1)
	}

	/// `AESKEYGENASSIST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AESKEYGENASSIST xmm1, xmm2/m128, imm8` | `66 0F 3A DF /r ib` | `AES`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn aeskeygenassist<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmAeskeygenassist<T, U, V>,
	{
		<Self as CodeAsmAeskeygenassist<T, U, V>>::aeskeygenassist(self, op0, op1, op2)
	}

	/// `ALTINST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ALTINST` | `0F 3F` | `Centaur AIS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn altinst(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmAltinst,
	{
		<Self as CodeAsmAltinst>::altinst(self)
	}

	/// `AND` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AND r/m8, r8` | `20 /r` | `8086+`
	/// `AND r/m16, r16` | `o16 21 /r` | `8086+`
	/// `AND r/m32, r32` | `o32 21 /r` | `386+`
	/// `AND r/m64, r64` | `o64 21 /r` | `X64`
	/// `AND r8, r/m8` | `22 /r` | `8086+`
	/// `AND r16, r/m16` | `o16 23 /r` | `8086+`
	/// `AND r32, r/m32` | `o32 23 /r` | `386+`
	/// `AND r64, r/m64` | `o64 23 /r` | `X64`
	/// `AND AL, imm8` | `24 ib` | `8086+`
	/// `AND AX, imm16` | `o16 25 iw` | `8086+`
	/// `AND EAX, imm32` | `o32 25 id` | `386+`
	/// `AND RAX, imm32` | `o64 25 id` | `X64`
	/// `AND r/m8, imm8` | `80 /4 ib` | `8086+`
	/// `AND r/m16, imm16` | `o16 81 /4 iw` | `8086+`
	/// `AND r/m32, imm32` | `o32 81 /4 id` | `386+`
	/// `AND r/m64, imm32` | `o64 81 /4 id` | `X64`
	/// `AND r/m16, imm8` | `o16 83 /4 ib` | `8086+`
	/// `AND r/m32, imm8` | `o32 83 /4 ib` | `386+`
	/// `AND r/m64, imm8` | `o64 83 /4 ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn and<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAnd<T, U>,
	{
		<Self as CodeAsmAnd<T, U>>::and(self, op0, op1)
	}

	/// `ANDN` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ANDN r32a, r32b, r/m32` | `VEX.LZ.0F38.W0 F2 /r` | `BMI1`
	/// `ANDN r64a, r64b, r/m64` | `VEX.LZ.0F38.W1 F2 /r` | `BMI1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn andn<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmAndn<T, U, V>,
	{
		<Self as CodeAsmAndn<T, U, V>>::andn(self, op0, op1, op2)
	}

	/// `ANDNPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ANDNPD xmm1, xmm2/m128` | `66 0F 55 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn andnpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAndnpd<T, U>,
	{
		<Self as CodeAsmAndnpd<T, U>>::andnpd(self, op0, op1)
	}

	/// `ANDNPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ANDNPS xmm1, xmm2/m128` | `NP 0F 55 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn andnps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAndnps<T, U>,
	{
		<Self as CodeAsmAndnps<T, U>>::andnps(self, op0, op1)
	}

	/// `ANDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ANDPD xmm1, xmm2/m128` | `66 0F 54 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn andpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAndpd<T, U>,
	{
		<Self as CodeAsmAndpd<T, U>>::andpd(self, op0, op1)
	}

	/// `ANDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ANDPS xmm1, xmm2/m128` | `NP 0F 54 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn andps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAndps<T, U>,
	{
		<Self as CodeAsmAndps<T, U>>::andps(self, op0, op1)
	}

	/// `AOR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AOR m32, r32` | `F2 0F 38 FC !(11):rrr:bbb` | `RAO-INT`
	/// `AOR m64, r64` | `F2 o64 0F 38 FC !(11):rrr:bbb` | `RAO-INT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn aor<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAor<T, U>,
	{
		<Self as CodeAsmAor<T, U>>::aor(self, op0, op1)
	}

	/// `ARPL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ARPL r/m16, r16` | `o16 63 /r` | `286+`
	/// `ARPL r32/m16, r32` | `o32 63 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn arpl<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmArpl<T, U>,
	{
		<Self as CodeAsmArpl<T, U>>::arpl(self, op0, op1)
	}

	/// `AXOR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `AXOR m32, r32` | `F3 0F 38 FC !(11):rrr:bbb` | `RAO-INT`
	/// `AXOR m64, r64` | `F3 o64 0F 38 FC !(11):rrr:bbb` | `RAO-INT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn axor<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmAxor<T, U>,
	{
		<Self as CodeAsmAxor<T, U>>::axor(self, op0, op1)
	}

	/// `BB0_RESET` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BB0_RESET` | `0F 3A` | `Cyrix MediaGX, GXm, GXLV, GX1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn bb0_reset(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmBb0_reset,
	{
		<Self as CodeAsmBb0_reset>::bb0_reset(self)
	}

	/// `BB1_RESET` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BB1_RESET` | `0F 3B` | `Cyrix MediaGX, GXm, GXLV, GX1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn bb1_reset(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmBb1_reset,
	{
		<Self as CodeAsmBb1_reset>::bb1_reset(self)
	}

	/// `BEXTR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BEXTR r32a, r/m32, r32b` | `VEX.LZ.0F38.W0 F7 /r` | `BMI1`
	/// `BEXTR r64a, r/m64, r64b` | `VEX.LZ.0F38.W1 F7 /r` | `BMI1`
	/// `BEXTR r32, r/m32, imm32` | `XOP.L0.XA.W0 10 /r id` | `TBM`
	/// `BEXTR r64, r/m64, imm32` | `XOP.L0.XA.W1 10 /r id` | `TBM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn bextr<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmBextr<T, U, V>,
	{
		<Self as CodeAsmBextr<T, U, V>>::bextr(self, op0, op1, op2)
	}

	/// `BLCFILL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLCFILL r32, r/m32` | `XOP.L0.X9.W0 01 /1` | `TBM`
	/// `BLCFILL r64, r/m64` | `XOP.L0.X9.W1 01 /1` | `TBM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blcfill<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlcfill<T, U>,
	{
		<Self as CodeAsmBlcfill<T, U>>::blcfill(self, op0, op1)
	}

	/// `BLCI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLCI r32, r/m32` | `XOP.L0.X9.W0 02 /6` | `TBM`
	/// `BLCI r64, r/m64` | `XOP.L0.X9.W1 02 /6` | `TBM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blci<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlci<T, U>,
	{
		<Self as CodeAsmBlci<T, U>>::blci(self, op0, op1)
	}

	/// `BLCIC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLCIC r32, r/m32` | `XOP.L0.X9.W0 01 /5` | `TBM`
	/// `BLCIC r64, r/m64` | `XOP.L0.X9.W1 01 /5` | `TBM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blcic<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlcic<T, U>,
	{
		<Self as CodeAsmBlcic<T, U>>::blcic(self, op0, op1)
	}

	/// `BLCMSK` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLCMSK r32, r/m32` | `XOP.L0.X9.W0 02 /1` | `TBM`
	/// `BLCMSK r64, r/m64` | `XOP.L0.X9.W1 02 /1` | `TBM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blcmsk<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlcmsk<T, U>,
	{
		<Self as CodeAsmBlcmsk<T, U>>::blcmsk(self, op0, op1)
	}

	/// `BLCS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLCS r32, r/m32` | `XOP.L0.X9.W0 01 /3` | `TBM`
	/// `BLCS r64, r/m64` | `XOP.L0.X9.W1 01 /3` | `TBM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blcs<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlcs<T, U>,
	{
		<Self as CodeAsmBlcs<T, U>>::blcs(self, op0, op1)
	}

	/// `BLENDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLENDPD xmm1, xmm2/m128, imm8` | `66 0F 3A 0D /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn blendpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmBlendpd<T, U, V>,
	{
		<Self as CodeAsmBlendpd<T, U, V>>::blendpd(self, op0, op1, op2)
	}

	/// `BLENDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLENDPS xmm1, xmm2/m128, imm8` | `66 0F 3A 0C /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn blendps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmBlendps<T, U, V>,
	{
		<Self as CodeAsmBlendps<T, U, V>>::blendps(self, op0, op1, op2)
	}

	/// `BLENDVPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLENDVPD xmm1, xmm2/m128, <XMM0>` | `66 0F 38 15 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blendvpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlendvpd<T, U>,
	{
		<Self as CodeAsmBlendvpd<T, U>>::blendvpd(self, op0, op1)
	}

	/// `BLENDVPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLENDVPS xmm1, xmm2/m128, <XMM0>` | `66 0F 38 14 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blendvps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlendvps<T, U>,
	{
		<Self as CodeAsmBlendvps<T, U>>::blendvps(self, op0, op1)
	}

	/// `BLSFILL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLSFILL r32, r/m32` | `XOP.L0.X9.W0 01 /2` | `TBM`
	/// `BLSFILL r64, r/m64` | `XOP.L0.X9.W1 01 /2` | `TBM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blsfill<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlsfill<T, U>,
	{
		<Self as CodeAsmBlsfill<T, U>>::blsfill(self, op0, op1)
	}

	/// `BLSI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLSI r32, r/m32` | `VEX.LZ.0F38.W0 F3 /3` | `BMI1`
	/// `BLSI r64, r/m64` | `VEX.LZ.0F38.W1 F3 /3` | `BMI1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blsi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlsi<T, U>,
	{
		<Self as CodeAsmBlsi<T, U>>::blsi(self, op0, op1)
	}

	/// `BLSIC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLSIC r32, r/m32` | `XOP.L0.X9.W0 01 /6` | `TBM`
	/// `BLSIC r64, r/m64` | `XOP.L0.X9.W1 01 /6` | `TBM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blsic<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlsic<T, U>,
	{
		<Self as CodeAsmBlsic<T, U>>::blsic(self, op0, op1)
	}

	/// `BLSMSK` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLSMSK r32, r/m32` | `VEX.LZ.0F38.W0 F3 /2` | `BMI1`
	/// `BLSMSK r64, r/m64` | `VEX.LZ.0F38.W1 F3 /2` | `BMI1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blsmsk<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlsmsk<T, U>,
	{
		<Self as CodeAsmBlsmsk<T, U>>::blsmsk(self, op0, op1)
	}

	/// `BLSR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BLSR r32, r/m32` | `VEX.LZ.0F38.W0 F3 /1` | `BMI1`
	/// `BLSR r64, r/m64` | `VEX.LZ.0F38.W1 F3 /1` | `BMI1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn blsr<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBlsr<T, U>,
	{
		<Self as CodeAsmBlsr<T, U>>::blsr(self, op0, op1)
	}

	/// `BNDCL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BNDCL bnd, r/m32` | `F3 0F 1A /r` | `MPX`
	/// `BNDCL bnd, r/m64` | `F3 0F 1A /r` | `MPX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bndcl<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBndcl<T, U>,
	{
		<Self as CodeAsmBndcl<T, U>>::bndcl(self, op0, op1)
	}

	/// `BNDCN` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BNDCN bnd, r/m32` | `F2 0F 1B /r` | `MPX`
	/// `BNDCN bnd, r/m64` | `F2 0F 1B /r` | `MPX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bndcn<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBndcn<T, U>,
	{
		<Self as CodeAsmBndcn<T, U>>::bndcn(self, op0, op1)
	}

	/// `BNDCU` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BNDCU bnd, r/m32` | `F2 0F 1A /r` | `MPX`
	/// `BNDCU bnd, r/m64` | `F2 0F 1A /r` | `MPX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bndcu<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBndcu<T, U>,
	{
		<Self as CodeAsmBndcu<T, U>>::bndcu(self, op0, op1)
	}

	/// `BNDLDX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BNDLDX bnd, mib` | `NP 0F 1A /r` | `MPX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bndldx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBndldx<T, U>,
	{
		<Self as CodeAsmBndldx<T, U>>::bndldx(self, op0, op1)
	}

	/// `BNDMK` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BNDMK bnd, m32` | `F3 0F 1B /r` | `MPX`
	/// `BNDMK bnd, m64` | `F3 0F 1B /r` | `MPX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bndmk<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBndmk<T, U>,
	{
		<Self as CodeAsmBndmk<T, U>>::bndmk(self, op0, op1)
	}

	/// `BNDMOV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BNDMOV bnd1, bnd2/m64` | `66 0F 1A /r` | `MPX`
	/// `BNDMOV bnd1, bnd2/m128` | `66 0F 1A /r` | `MPX`
	/// `BNDMOV bnd1/m64, bnd2` | `66 0F 1B /r` | `MPX`
	/// `BNDMOV bnd1/m128, bnd2` | `66 0F 1B /r` | `MPX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bndmov<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBndmov<T, U>,
	{
		<Self as CodeAsmBndmov<T, U>>::bndmov(self, op0, op1)
	}

	/// `BNDSTX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BNDSTX mib, bnd` | `NP 0F 1B /r` | `MPX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bndstx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBndstx<T, U>,
	{
		<Self as CodeAsmBndstx<T, U>>::bndstx(self, op0, op1)
	}

	/// `BOUND` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BOUND r16, m16&16` | `o16 62 /r` | `186+`
	/// `BOUND r32, m32&32` | `o32 62 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bound<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBound<T, U>,
	{
		<Self as CodeAsmBound<T, U>>::bound(self, op0, op1)
	}

	/// `BSF` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BSF r16, r/m16` | `o16 0F BC /r` | `386+`
	/// `BSF r32, r/m32` | `o32 0F BC /r` | `386+`
	/// `BSF r64, r/m64` | `o64 0F BC /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bsf<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBsf<T, U>,
	{
		<Self as CodeAsmBsf<T, U>>::bsf(self, op0, op1)
	}

	/// `BSR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BSR r16, r/m16` | `o16 0F BD /r` | `386+`
	/// `BSR r32, r/m32` | `o32 0F BD /r` | `386+`
	/// `BSR r64, r/m64` | `o64 0F BD /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bsr<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBsr<T, U>,
	{
		<Self as CodeAsmBsr<T, U>>::bsr(self, op0, op1)
	}

	/// `BSWAP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BSWAP r16` | `o16 0F C8+rw` | `486+`
	/// `BSWAP r32` | `o32 0F C8+rd` | `486+`
	/// `BSWAP r64` | `o64 0F C8+ro` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn bswap<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmBswap<T>,
	{
		<Self as CodeAsmBswap<T>>::bswap(self, op0)
	}

	/// `BT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BT r/m16, r16` | `o16 0F A3 /r` | `386+`
	/// `BT r/m32, r32` | `o32 0F A3 /r` | `386+`
	/// `BT r/m64, r64` | `o64 0F A3 /r` | `X64`
	/// `BT r/m16, imm8` | `o16 0F BA /4 ib` | `386+`
	/// `BT r/m32, imm8` | `o32 0F BA /4 ib` | `386+`
	/// `BT r/m64, imm8` | `o64 0F BA /4 ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bt<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBt<T, U>,
	{
		<Self as CodeAsmBt<T, U>>::bt(self, op0, op1)
	}

	/// `BTC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BTC r/m16, imm8` | `o16 0F BA /7 ib` | `386+`
	/// `BTC r/m32, imm8` | `o32 0F BA /7 ib` | `386+`
	/// `BTC r/m64, imm8` | `o64 0F BA /7 ib` | `X64`
	/// `BTC r/m16, r16` | `o16 0F BB /r` | `386+`
	/// `BTC r/m32, r32` | `o32 0F BB /r` | `386+`
	/// `BTC r/m64, r64` | `o64 0F BB /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn btc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBtc<T, U>,
	{
		<Self as CodeAsmBtc<T, U>>::btc(self, op0, op1)
	}

	/// `BTR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BTR r/m16, r16` | `o16 0F B3 /r` | `386+`
	/// `BTR r/m32, r32` | `o32 0F B3 /r` | `386+`
	/// `BTR r/m64, r64` | `o64 0F B3 /r` | `X64`
	/// `BTR r/m16, imm8` | `o16 0F BA /6 ib` | `386+`
	/// `BTR r/m32, imm8` | `o32 0F BA /6 ib` | `386+`
	/// `BTR r/m64, imm8` | `o64 0F BA /6 ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn btr<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBtr<T, U>,
	{
		<Self as CodeAsmBtr<T, U>>::btr(self, op0, op1)
	}

	/// `BTS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BTS r/m16, r16` | `o16 0F AB /r` | `386+`
	/// `BTS r/m32, r32` | `o32 0F AB /r` | `386+`
	/// `BTS r/m64, r64` | `o64 0F AB /r` | `X64`
	/// `BTS r/m16, imm8` | `o16 0F BA /5 ib` | `386+`
	/// `BTS r/m32, imm8` | `o32 0F BA /5 ib` | `386+`
	/// `BTS r/m64, imm8` | `o64 0F BA /5 ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn bts<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmBts<T, U>,
	{
		<Self as CodeAsmBts<T, U>>::bts(self, op0, op1)
	}

	/// `BZHI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `BZHI r32a, r/m32, r32b` | `VEX.LZ.0F38.W0 F5 /r` | `BMI2`
	/// `BZHI r64a, r/m64, r64b` | `VEX.LZ.0F38.W1 F5 /r` | `BMI2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn bzhi<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmBzhi<T, U, V>,
	{
		<Self as CodeAsmBzhi<T, U, V>>::bzhi(self, op0, op1, op2)
	}

	/// `CALL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CALL rel16` | `o16 E8 cw` | `8086+`
	/// `CALL rel32` | `o32 E8 cd` | `386+`
	/// `CALL rel32` | `o64 E8 cd` | `X64`
	/// `CALL r/m16` | `o16 FF /2` | `8086+`
	/// `CALL r/m32` | `o32 FF /2` | `386+`
	/// `CALL r/m64` | `o64 FF /2` | `X64`
	/// `CALL m16:16` | `o16 FF /3` | `8086+`
	/// `CALL m16:32` | `o32 FF /3` | `386+`
	/// `CALL m16:64` | `o64 FF /3` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn call<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmCall<T>,
	{
		<Self as CodeAsmCall<T>>::call(self, op0)
	}

	/// `CBW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CBW` | `o16 98` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cbw(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCbw,
	{
		<Self as CodeAsmCbw>::cbw(self)
	}

	/// `CCS_ENCRYPT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CCS_ENCRYPT` | `a16 F3 0F A7 F0` | `PADLOCK_GMI`
	/// `CCS_ENCRYPT` | `a32 F3 0F A7 F0` | `PADLOCK_GMI`
	/// `CCS_ENCRYPT` | `a64 F3 0F A7 F0` | `PADLOCK_GMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn ccs_encrypt(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCcs_encrypt,
	{
		<Self as CodeAsmCcs_encrypt>::ccs_encrypt(self)
	}

	/// `CCS_HASH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CCS_HASH` | `a16 F3 0F A6 E8` | `PADLOCK_GMI`
	/// `CCS_HASH` | `a32 F3 0F A6 E8` | `PADLOCK_GMI`
	/// `CCS_HASH` | `a64 F3 0F A6 E8` | `PADLOCK_GMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn ccs_hash(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCcs_hash,
	{
		<Self as CodeAsmCcs_hash>::ccs_hash(self)
	}

	/// `CDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CDQ` | `o32 99` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cdq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCdq,
	{
		<Self as CodeAsmCdq>::cdq(self)
	}

	/// `CDQE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CDQE` | `o64 98` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cdqe(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCdqe,
	{
		<Self as CodeAsmCdqe>::cdqe(self)
	}

	/// `CL1INVMB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CL1INVMB` | `0F 0A` | `CL1INVMB`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cl1invmb(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCl1invmb,
	{
		<Self as CodeAsmCl1invmb>::cl1invmb(self)
	}

	/// `CLAC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLAC` | `NP 0F 01 CA` | `SMAP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn clac(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmClac,
	{
		<Self as CodeAsmClac>::clac(self)
	}

	/// `CLC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLC` | `F8` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn clc(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmClc,
	{
		<Self as CodeAsmClc>::clc(self)
	}

	/// `CLD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLD` | `FC` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cld(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCld,
	{
		<Self as CodeAsmCld>::cld(self)
	}

	/// `CLDEMOTE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLDEMOTE m8` | `NP 0F 1C /0` | `CLDEMOTE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn cldemote<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmCldemote<T>,
	{
		<Self as CodeAsmCldemote<T>>::cldemote(self, op0)
	}

	/// `CLFLUSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLFLUSH m8` | `NP 0F AE /7` | `CLFSH`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn clflush<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmClflush<T>,
	{
		<Self as CodeAsmClflush<T>>::clflush(self, op0)
	}

	/// `CLFLUSHOPT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLFLUSHOPT m8` | `66 0F AE /7` | `CLFLUSHOPT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn clflushopt<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmClflushopt<T>,
	{
		<Self as CodeAsmClflushopt<T>>::clflushopt(self, op0)
	}

	/// `CLGI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLGI` | `0F 01 DD` | `SVM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn clgi(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmClgi,
	{
		<Self as CodeAsmClgi>::clgi(self)
	}

	/// `CLI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLI` | `FA` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cli(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCli,
	{
		<Self as CodeAsmCli>::cli(self)
	}

	/// `CLRSSBSY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLRSSBSY m64` | `F3 0F AE /6` | `CET_SS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn clrssbsy<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmClrssbsy<T>,
	{
		<Self as CodeAsmClrssbsy<T>>::clrssbsy(self, op0)
	}

	/// `CLTS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLTS` | `0F 06` | `286+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn clts(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmClts,
	{
		<Self as CodeAsmClts>::clts(self)
	}

	/// `CLUI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLUI` | `F3 0F 01 EE` | `UINTR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn clui(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmClui,
	{
		<Self as CodeAsmClui>::clui(self)
	}

	/// `CLWB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLWB m8` | `66 0F AE /6` | `CLWB`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn clwb<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmClwb<T>,
	{
		<Self as CodeAsmClwb<T>>::clwb(self, op0)
	}

	/// `CLZERO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CLZERO` | `a16 0F 01 FC` | `CLZERO`
	/// `CLZERO` | `a32 0F 01 FC` | `CLZERO`
	/// `CLZERO` | `a64 0F 01 FC` | `CLZERO`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn clzero(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmClzero,
	{
		<Self as CodeAsmClzero>::clzero(self)
	}

	/// `CMC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMC` | `F5` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cmc(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCmc,
	{
		<Self as CodeAsmCmc>::cmc(self)
	}

	/// `CMOVA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVA r16, r/m16` | `o16 0F 47 /r` | `CMOV`
	/// `CMOVA r32, r/m32` | `o32 0F 47 /r` | `CMOV`
	/// `CMOVA r64, r/m64` | `o64 0F 47 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmova<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmova<T, U>,
	{
		<Self as CodeAsmCmova<T, U>>::cmova(self, op0, op1)
	}

	/// `CMOVAE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVAE r16, r/m16` | `o16 0F 43 /r` | `CMOV`
	/// `CMOVAE r32, r/m32` | `o32 0F 43 /r` | `CMOV`
	/// `CMOVAE r64, r/m64` | `o64 0F 43 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovae<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovae<T, U>,
	{
		<Self as CodeAsmCmovae<T, U>>::cmovae(self, op0, op1)
	}

	/// `CMOVB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVB r16, r/m16` | `o16 0F 42 /r` | `CMOV`
	/// `CMOVB r32, r/m32` | `o32 0F 42 /r` | `CMOV`
	/// `CMOVB r64, r/m64` | `o64 0F 42 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovb<T, U>,
	{
		<Self as CodeAsmCmovb<T, U>>::cmovb(self, op0, op1)
	}

	/// `CMOVBE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVBE r16, r/m16` | `o16 0F 46 /r` | `CMOV`
	/// `CMOVBE r32, r/m32` | `o32 0F 46 /r` | `CMOV`
	/// `CMOVBE r64, r/m64` | `o64 0F 46 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovbe<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovbe<T, U>,
	{
		<Self as CodeAsmCmovbe<T, U>>::cmovbe(self, op0, op1)
	}

	/// `CMOVC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVB r16, r/m16` | `o16 0F 42 /r` | `CMOV`
	/// `CMOVB r32, r/m32` | `o32 0F 42 /r` | `CMOV`
	/// `CMOVB r64, r/m64` | `o64 0F 42 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovc<T, U>,
	{
		<Self as CodeAsmCmovc<T, U>>::cmovc(self, op0, op1)
	}

	/// `CMOVE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVE r16, r/m16` | `o16 0F 44 /r` | `CMOV`
	/// `CMOVE r32, r/m32` | `o32 0F 44 /r` | `CMOV`
	/// `CMOVE r64, r/m64` | `o64 0F 44 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmove<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmove<T, U>,
	{
		<Self as CodeAsmCmove<T, U>>::cmove(self, op0, op1)
	}

	/// `CMOVG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVG r16, r/m16` | `o16 0F 4F /r` | `CMOV`
	/// `CMOVG r32, r/m32` | `o32 0F 4F /r` | `CMOV`
	/// `CMOVG r64, r/m64` | `o64 0F 4F /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovg<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovg<T, U>,
	{
		<Self as CodeAsmCmovg<T, U>>::cmovg(self, op0, op1)
	}

	/// `CMOVGE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVGE r16, r/m16` | `o16 0F 4D /r` | `CMOV`
	/// `CMOVGE r32, r/m32` | `o32 0F 4D /r` | `CMOV`
	/// `CMOVGE r64, r/m64` | `o64 0F 4D /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovge<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovge<T, U>,
	{
		<Self as CodeAsmCmovge<T, U>>::cmovge(self, op0, op1)
	}

	/// `CMOVL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVL r16, r/m16` | `o16 0F 4C /r` | `CMOV`
	/// `CMOVL r32, r/m32` | `o32 0F 4C /r` | `CMOV`
	/// `CMOVL r64, r/m64` | `o64 0F 4C /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovl<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovl<T, U>,
	{
		<Self as CodeAsmCmovl<T, U>>::cmovl(self, op0, op1)
	}

	/// `CMOVLE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVLE r16, r/m16` | `o16 0F 4E /r` | `CMOV`
	/// `CMOVLE r32, r/m32` | `o32 0F 4E /r` | `CMOV`
	/// `CMOVLE r64, r/m64` | `o64 0F 4E /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovle<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovle<T, U>,
	{
		<Self as CodeAsmCmovle<T, U>>::cmovle(self, op0, op1)
	}

	/// `CMOVNA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVBE r16, r/m16` | `o16 0F 46 /r` | `CMOV`
	/// `CMOVBE r32, r/m32` | `o32 0F 46 /r` | `CMOV`
	/// `CMOVBE r64, r/m64` | `o64 0F 46 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovna<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovna<T, U>,
	{
		<Self as CodeAsmCmovna<T, U>>::cmovna(self, op0, op1)
	}

	/// `CMOVNAE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVB r16, r/m16` | `o16 0F 42 /r` | `CMOV`
	/// `CMOVB r32, r/m32` | `o32 0F 42 /r` | `CMOV`
	/// `CMOVB r64, r/m64` | `o64 0F 42 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovnae<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovnae<T, U>,
	{
		<Self as CodeAsmCmovnae<T, U>>::cmovnae(self, op0, op1)
	}

	/// `CMOVNB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVAE r16, r/m16` | `o16 0F 43 /r` | `CMOV`
	/// `CMOVAE r32, r/m32` | `o32 0F 43 /r` | `CMOV`
	/// `CMOVAE r64, r/m64` | `o64 0F 43 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovnb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovnb<T, U>,
	{
		<Self as CodeAsmCmovnb<T, U>>::cmovnb(self, op0, op1)
	}

	/// `CMOVNBE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVA r16, r/m16` | `o16 0F 47 /r` | `CMOV`
	/// `CMOVA r32, r/m32` | `o32 0F 47 /r` | `CMOV`
	/// `CMOVA r64, r/m64` | `o64 0F 47 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovnbe<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovnbe<T, U>,
	{
		<Self as CodeAsmCmovnbe<T, U>>::cmovnbe(self, op0, op1)
	}

	/// `CMOVNC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVAE r16, r/m16` | `o16 0F 43 /r` | `CMOV`
	/// `CMOVAE r32, r/m32` | `o32 0F 43 /r` | `CMOV`
	/// `CMOVAE r64, r/m64` | `o64 0F 43 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovnc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovnc<T, U>,
	{
		<Self as CodeAsmCmovnc<T, U>>::cmovnc(self, op0, op1)
	}

	/// `CMOVNE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVNE r16, r/m16` | `o16 0F 45 /r` | `CMOV`
	/// `CMOVNE r32, r/m32` | `o32 0F 45 /r` | `CMOV`
	/// `CMOVNE r64, r/m64` | `o64 0F 45 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovne<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovne<T, U>,
	{
		<Self as CodeAsmCmovne<T, U>>::cmovne(self, op0, op1)
	}

	/// `CMOVNG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVLE r16, r/m16` | `o16 0F 4E /r` | `CMOV`
	/// `CMOVLE r32, r/m32` | `o32 0F 4E /r` | `CMOV`
	/// `CMOVLE r64, r/m64` | `o64 0F 4E /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovng<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovng<T, U>,
	{
		<Self as CodeAsmCmovng<T, U>>::cmovng(self, op0, op1)
	}

	/// `CMOVNGE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVL r16, r/m16` | `o16 0F 4C /r` | `CMOV`
	/// `CMOVL r32, r/m32` | `o32 0F 4C /r` | `CMOV`
	/// `CMOVL r64, r/m64` | `o64 0F 4C /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovnge<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovnge<T, U>,
	{
		<Self as CodeAsmCmovnge<T, U>>::cmovnge(self, op0, op1)
	}

	/// `CMOVNL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVGE r16, r/m16` | `o16 0F 4D /r` | `CMOV`
	/// `CMOVGE r32, r/m32` | `o32 0F 4D /r` | `CMOV`
	/// `CMOVGE r64, r/m64` | `o64 0F 4D /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovnl<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovnl<T, U>,
	{
		<Self as CodeAsmCmovnl<T, U>>::cmovnl(self, op0, op1)
	}

	/// `CMOVNLE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVG r16, r/m16` | `o16 0F 4F /r` | `CMOV`
	/// `CMOVG r32, r/m32` | `o32 0F 4F /r` | `CMOV`
	/// `CMOVG r64, r/m64` | `o64 0F 4F /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovnle<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovnle<T, U>,
	{
		<Self as CodeAsmCmovnle<T, U>>::cmovnle(self, op0, op1)
	}

	/// `CMOVNO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVNO r16, r/m16` | `o16 0F 41 /r` | `CMOV`
	/// `CMOVNO r32, r/m32` | `o32 0F 41 /r` | `CMOV`
	/// `CMOVNO r64, r/m64` | `o64 0F 41 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovno<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovno<T, U>,
	{
		<Self as CodeAsmCmovno<T, U>>::cmovno(self, op0, op1)
	}

	/// `CMOVNP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVNP r16, r/m16` | `o16 0F 4B /r` | `CMOV`
	/// `CMOVNP r32, r/m32` | `o32 0F 4B /r` | `CMOV`
	/// `CMOVNP r64, r/m64` | `o64 0F 4B /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovnp<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovnp<T, U>,
	{
		<Self as CodeAsmCmovnp<T, U>>::cmovnp(self, op0, op1)
	}

	/// `CMOVNS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVNS r16, r/m16` | `o16 0F 49 /r` | `CMOV`
	/// `CMOVNS r32, r/m32` | `o32 0F 49 /r` | `CMOV`
	/// `CMOVNS r64, r/m64` | `o64 0F 49 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovns<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovns<T, U>,
	{
		<Self as CodeAsmCmovns<T, U>>::cmovns(self, op0, op1)
	}

	/// `CMOVNZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVNE r16, r/m16` | `o16 0F 45 /r` | `CMOV`
	/// `CMOVNE r32, r/m32` | `o32 0F 45 /r` | `CMOV`
	/// `CMOVNE r64, r/m64` | `o64 0F 45 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovnz<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovnz<T, U>,
	{
		<Self as CodeAsmCmovnz<T, U>>::cmovnz(self, op0, op1)
	}

	/// `CMOVO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVO r16, r/m16` | `o16 0F 40 /r` | `CMOV`
	/// `CMOVO r32, r/m32` | `o32 0F 40 /r` | `CMOV`
	/// `CMOVO r64, r/m64` | `o64 0F 40 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovo<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovo<T, U>,
	{
		<Self as CodeAsmCmovo<T, U>>::cmovo(self, op0, op1)
	}

	/// `CMOVP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVP r16, r/m16` | `o16 0F 4A /r` | `CMOV`
	/// `CMOVP r32, r/m32` | `o32 0F 4A /r` | `CMOV`
	/// `CMOVP r64, r/m64` | `o64 0F 4A /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovp<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovp<T, U>,
	{
		<Self as CodeAsmCmovp<T, U>>::cmovp(self, op0, op1)
	}

	/// `CMOVPE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVP r16, r/m16` | `o16 0F 4A /r` | `CMOV`
	/// `CMOVP r32, r/m32` | `o32 0F 4A /r` | `CMOV`
	/// `CMOVP r64, r/m64` | `o64 0F 4A /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovpe<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovpe<T, U>,
	{
		<Self as CodeAsmCmovpe<T, U>>::cmovpe(self, op0, op1)
	}

	/// `CMOVPO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVNP r16, r/m16` | `o16 0F 4B /r` | `CMOV`
	/// `CMOVNP r32, r/m32` | `o32 0F 4B /r` | `CMOV`
	/// `CMOVNP r64, r/m64` | `o64 0F 4B /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovpo<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovpo<T, U>,
	{
		<Self as CodeAsmCmovpo<T, U>>::cmovpo(self, op0, op1)
	}

	/// `CMOVS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVS r16, r/m16` | `o16 0F 48 /r` | `CMOV`
	/// `CMOVS r32, r/m32` | `o32 0F 48 /r` | `CMOV`
	/// `CMOVS r64, r/m64` | `o64 0F 48 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovs<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovs<T, U>,
	{
		<Self as CodeAsmCmovs<T, U>>::cmovs(self, op0, op1)
	}

	/// `CMOVZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMOVE r16, r/m16` | `o16 0F 44 /r` | `CMOV`
	/// `CMOVE r32, r/m32` | `o32 0F 44 /r` | `CMOV`
	/// `CMOVE r64, r/m64` | `o64 0F 44 /r` | `CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmovz<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmovz<T, U>,
	{
		<Self as CodeAsmCmovz<T, U>>::cmovz(self, op0, op1)
	}

	/// `CMP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMP r/m8, r8` | `38 /r` | `8086+`
	/// `CMP r/m16, r16` | `o16 39 /r` | `8086+`
	/// `CMP r/m32, r32` | `o32 39 /r` | `386+`
	/// `CMP r/m64, r64` | `o64 39 /r` | `X64`
	/// `CMP r8, r/m8` | `3A /r` | `8086+`
	/// `CMP r16, r/m16` | `o16 3B /r` | `8086+`
	/// `CMP r32, r/m32` | `o32 3B /r` | `386+`
	/// `CMP r64, r/m64` | `o64 3B /r` | `X64`
	/// `CMP AL, imm8` | `3C ib` | `8086+`
	/// `CMP AX, imm16` | `o16 3D iw` | `8086+`
	/// `CMP EAX, imm32` | `o32 3D id` | `386+`
	/// `CMP RAX, imm32` | `o64 3D id` | `X64`
	/// `CMP r/m8, imm8` | `80 /7 ib` | `8086+`
	/// `CMP r/m16, imm16` | `o16 81 /7 iw` | `8086+`
	/// `CMP r/m32, imm32` | `o32 81 /7 id` | `386+`
	/// `CMP r/m64, imm32` | `o64 81 /7 id` | `X64`
	/// `CMP r/m16, imm8` | `o16 83 /7 ib` | `8086+`
	/// `CMP r/m32, imm8` | `o32 83 /7 ib` | `386+`
	/// `CMP r/m64, imm8` | `o64 83 /7 ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmp<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmp<T, U>,
	{
		<Self as CodeAsmCmp<T, U>>::cmp(self, op0, op1)
	}

	/// `CMPBEXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPBEXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E6 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPBEXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E6 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpbexadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpbexadd<T, U, V>,
	{
		<Self as CodeAsmCmpbexadd<T, U, V>>::cmpbexadd(self, op0, op1, op2)
	}

	/// `CMPBXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPBXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E2 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPBXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E2 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpbxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpbxadd<T, U, V>,
	{
		<Self as CodeAsmCmpbxadd<T, U, V>>::cmpbxadd(self, op0, op1, op2)
	}

	/// `CMPCXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPBXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E2 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPBXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E2 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpcxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpcxadd<T, U, V>,
	{
		<Self as CodeAsmCmpcxadd<T, U, V>>::cmpcxadd(self, op0, op1, op2)
	}

	/// `CMPEQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPD xmm1, xmm2/m128, imm8` | `66 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpeqpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpeqpd<T, U>,
	{
		<Self as CodeAsmCmpeqpd<T, U>>::cmpeqpd(self, op0, op1)
	}

	/// `CMPEQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPS xmm1, xmm2/m128, imm8` | `NP 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpeqps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpeqps<T, U>,
	{
		<Self as CodeAsmCmpeqps<T, U>>::cmpeqps(self, op0, op1)
	}

	/// `CMPEQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSD xmm1, xmm2/m64, imm8` | `F2 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpeqsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpeqsd<T, U>,
	{
		<Self as CodeAsmCmpeqsd<T, U>>::cmpeqsd(self, op0, op1)
	}

	/// `CMPEQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSS xmm1, xmm2/m32, imm8` | `F3 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpeqss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpeqss<T, U>,
	{
		<Self as CodeAsmCmpeqss<T, U>>::cmpeqss(self, op0, op1)
	}

	/// `CMPLEPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPD xmm1, xmm2/m128, imm8` | `66 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmplepd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmplepd<T, U>,
	{
		<Self as CodeAsmCmplepd<T, U>>::cmplepd(self, op0, op1)
	}

	/// `CMPLEPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPS xmm1, xmm2/m128, imm8` | `NP 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpleps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpleps<T, U>,
	{
		<Self as CodeAsmCmpleps<T, U>>::cmpleps(self, op0, op1)
	}

	/// `CMPLESD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSD xmm1, xmm2/m64, imm8` | `F2 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmplesd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmplesd<T, U>,
	{
		<Self as CodeAsmCmplesd<T, U>>::cmplesd(self, op0, op1)
	}

	/// `CMPLESS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSS xmm1, xmm2/m32, imm8` | `F3 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpless<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpless<T, U>,
	{
		<Self as CodeAsmCmpless<T, U>>::cmpless(self, op0, op1)
	}

	/// `CMPLEXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPLEXADD m32, r32, r32` | `VEX.128.66.0F38.W0 EE !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPLEXADD m64, r64, r64` | `VEX.128.66.0F38.W1 EE !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmplexadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmplexadd<T, U, V>,
	{
		<Self as CodeAsmCmplexadd<T, U, V>>::cmplexadd(self, op0, op1, op2)
	}

	/// `CMPLTPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPD xmm1, xmm2/m128, imm8` | `66 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpltpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpltpd<T, U>,
	{
		<Self as CodeAsmCmpltpd<T, U>>::cmpltpd(self, op0, op1)
	}

	/// `CMPLTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPS xmm1, xmm2/m128, imm8` | `NP 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpltps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpltps<T, U>,
	{
		<Self as CodeAsmCmpltps<T, U>>::cmpltps(self, op0, op1)
	}

	/// `CMPLTSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSD xmm1, xmm2/m64, imm8` | `F2 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpltsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpltsd<T, U>,
	{
		<Self as CodeAsmCmpltsd<T, U>>::cmpltsd(self, op0, op1)
	}

	/// `CMPLTSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSS xmm1, xmm2/m32, imm8` | `F3 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpltss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpltss<T, U>,
	{
		<Self as CodeAsmCmpltss<T, U>>::cmpltss(self, op0, op1)
	}

	/// `CMPLXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPLXADD m32, r32, r32` | `VEX.128.66.0F38.W0 EC !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPLXADD m64, r64, r64` | `VEX.128.66.0F38.W1 EC !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmplxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmplxadd<T, U, V>,
	{
		<Self as CodeAsmCmplxadd<T, U, V>>::cmplxadd(self, op0, op1, op2)
	}

	/// `CMPNAEXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPBXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E2 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPBXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E2 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpnaexadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnaexadd<T, U, V>,
	{
		<Self as CodeAsmCmpnaexadd<T, U, V>>::cmpnaexadd(self, op0, op1, op2)
	}

	/// `CMPNAXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPBEXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E6 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPBEXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E6 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpnaxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnaxadd<T, U, V>,
	{
		<Self as CodeAsmCmpnaxadd<T, U, V>>::cmpnaxadd(self, op0, op1, op2)
	}

	/// `CMPNBEXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPNBEXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E7 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPNBEXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E7 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpnbexadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnbexadd<T, U, V>,
	{
		<Self as CodeAsmCmpnbexadd<T, U, V>>::cmpnbexadd(self, op0, op1, op2)
	}

	/// `CMPNBXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPNBXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E3 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPNBXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E3 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpnbxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnbxadd<T, U, V>,
	{
		<Self as CodeAsmCmpnbxadd<T, U, V>>::cmpnbxadd(self, op0, op1, op2)
	}

	/// `CMPNCXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPNBXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E3 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPNBXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E3 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpncxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpncxadd<T, U, V>,
	{
		<Self as CodeAsmCmpncxadd<T, U, V>>::cmpncxadd(self, op0, op1, op2)
	}

	/// `CMPNEQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPD xmm1, xmm2/m128, imm8` | `66 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpneqpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpneqpd<T, U>,
	{
		<Self as CodeAsmCmpneqpd<T, U>>::cmpneqpd(self, op0, op1)
	}

	/// `CMPNEQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPS xmm1, xmm2/m128, imm8` | `NP 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpneqps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpneqps<T, U>,
	{
		<Self as CodeAsmCmpneqps<T, U>>::cmpneqps(self, op0, op1)
	}

	/// `CMPNEQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSD xmm1, xmm2/m64, imm8` | `F2 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpneqsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpneqsd<T, U>,
	{
		<Self as CodeAsmCmpneqsd<T, U>>::cmpneqsd(self, op0, op1)
	}

	/// `CMPNEQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSS xmm1, xmm2/m32, imm8` | `F3 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpneqss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpneqss<T, U>,
	{
		<Self as CodeAsmCmpneqss<T, U>>::cmpneqss(self, op0, op1)
	}

	/// `CMPNGEXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPLXADD m32, r32, r32` | `VEX.128.66.0F38.W0 EC !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPLXADD m64, r64, r64` | `VEX.128.66.0F38.W1 EC !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpngexadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpngexadd<T, U, V>,
	{
		<Self as CodeAsmCmpngexadd<T, U, V>>::cmpngexadd(self, op0, op1, op2)
	}

	/// `CMPNGXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPLEXADD m32, r32, r32` | `VEX.128.66.0F38.W0 EE !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPLEXADD m64, r64, r64` | `VEX.128.66.0F38.W1 EE !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpngxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpngxadd<T, U, V>,
	{
		<Self as CodeAsmCmpngxadd<T, U, V>>::cmpngxadd(self, op0, op1, op2)
	}

	/// `CMPNLEPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPD xmm1, xmm2/m128, imm8` | `66 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpnlepd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnlepd<T, U>,
	{
		<Self as CodeAsmCmpnlepd<T, U>>::cmpnlepd(self, op0, op1)
	}

	/// `CMPNLEPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPS xmm1, xmm2/m128, imm8` | `NP 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpnleps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnleps<T, U>,
	{
		<Self as CodeAsmCmpnleps<T, U>>::cmpnleps(self, op0, op1)
	}

	/// `CMPNLESD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSD xmm1, xmm2/m64, imm8` | `F2 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpnlesd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnlesd<T, U>,
	{
		<Self as CodeAsmCmpnlesd<T, U>>::cmpnlesd(self, op0, op1)
	}

	/// `CMPNLESS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSS xmm1, xmm2/m32, imm8` | `F3 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpnless<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnless<T, U>,
	{
		<Self as CodeAsmCmpnless<T, U>>::cmpnless(self, op0, op1)
	}

	/// `CMPNLEXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPNLEXADD m32, r32, r32` | `VEX.128.66.0F38.W0 EF !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPNLEXADD m64, r64, r64` | `VEX.128.66.0F38.W1 EF !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpnlexadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnlexadd<T, U, V>,
	{
		<Self as CodeAsmCmpnlexadd<T, U, V>>::cmpnlexadd(self, op0, op1, op2)
	}

	/// `CMPNLTPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPD xmm1, xmm2/m128, imm8` | `66 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpnltpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnltpd<T, U>,
	{
		<Self as CodeAsmCmpnltpd<T, U>>::cmpnltpd(self, op0, op1)
	}

	/// `CMPNLTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPS xmm1, xmm2/m128, imm8` | `NP 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpnltps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnltps<T, U>,
	{
		<Self as CodeAsmCmpnltps<T, U>>::cmpnltps(self, op0, op1)
	}

	/// `CMPNLTSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSD xmm1, xmm2/m64, imm8` | `F2 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpnltsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnltsd<T, U>,
	{
		<Self as CodeAsmCmpnltsd<T, U>>::cmpnltsd(self, op0, op1)
	}

	/// `CMPNLTSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSS xmm1, xmm2/m32, imm8` | `F3 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpnltss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnltss<T, U>,
	{
		<Self as CodeAsmCmpnltss<T, U>>::cmpnltss(self, op0, op1)
	}

	/// `CMPNLXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPNLXADD m32, r32, r32` | `VEX.128.66.0F38.W0 ED !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPNLXADD m64, r64, r64` | `VEX.128.66.0F38.W1 ED !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpnlxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnlxadd<T, U, V>,
	{
		<Self as CodeAsmCmpnlxadd<T, U, V>>::cmpnlxadd(self, op0, op1, op2)
	}

	/// `CMPNOXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPNOXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E1 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPNOXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E1 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpnoxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnoxadd<T, U, V>,
	{
		<Self as CodeAsmCmpnoxadd<T, U, V>>::cmpnoxadd(self, op0, op1, op2)
	}

	/// `CMPNPXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPNPXADD m32, r32, r32` | `VEX.128.66.0F38.W0 EB !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPNPXADD m64, r64, r64` | `VEX.128.66.0F38.W1 EB !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpnpxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnpxadd<T, U, V>,
	{
		<Self as CodeAsmCmpnpxadd<T, U, V>>::cmpnpxadd(self, op0, op1, op2)
	}

	/// `CMPNSXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPNSXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E9 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPNSXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E9 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpnsxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnsxadd<T, U, V>,
	{
		<Self as CodeAsmCmpnsxadd<T, U, V>>::cmpnsxadd(self, op0, op1, op2)
	}

	/// `CMPNZXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPNZXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E5 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPNZXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E5 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpnzxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpnzxadd<T, U, V>,
	{
		<Self as CodeAsmCmpnzxadd<T, U, V>>::cmpnzxadd(self, op0, op1, op2)
	}

	/// `CMPORDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPD xmm1, xmm2/m128, imm8` | `66 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpordpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpordpd<T, U>,
	{
		<Self as CodeAsmCmpordpd<T, U>>::cmpordpd(self, op0, op1)
	}

	/// `CMPORDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPS xmm1, xmm2/m128, imm8` | `NP 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpordps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpordps<T, U>,
	{
		<Self as CodeAsmCmpordps<T, U>>::cmpordps(self, op0, op1)
	}

	/// `CMPORDSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSD xmm1, xmm2/m64, imm8` | `F2 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpordsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpordsd<T, U>,
	{
		<Self as CodeAsmCmpordsd<T, U>>::cmpordsd(self, op0, op1)
	}

	/// `CMPORDSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSS xmm1, xmm2/m32, imm8` | `F3 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpordss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpordss<T, U>,
	{
		<Self as CodeAsmCmpordss<T, U>>::cmpordss(self, op0, op1)
	}

	/// `CMPOXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPOXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E0 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPOXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E0 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpoxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpoxadd<T, U, V>,
	{
		<Self as CodeAsmCmpoxadd<T, U, V>>::cmpoxadd(self, op0, op1, op2)
	}

	/// `CMPPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPD xmm1, xmm2/m128, imm8` | `66 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmppd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmppd<T, U, V>,
	{
		<Self as CodeAsmCmppd<T, U, V>>::cmppd(self, op0, op1, op2)
	}

	/// `CMPPEXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPXADD m32, r32, r32` | `VEX.128.66.0F38.W0 EA !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPPXADD m64, r64, r64` | `VEX.128.66.0F38.W1 EA !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmppexadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmppexadd<T, U, V>,
	{
		<Self as CodeAsmCmppexadd<T, U, V>>::cmppexadd(self, op0, op1, op2)
	}

	/// `CMPPOXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPNPXADD m32, r32, r32` | `VEX.128.66.0F38.W0 EB !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPNPXADD m64, r64, r64` | `VEX.128.66.0F38.W1 EB !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmppoxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmppoxadd<T, U, V>,
	{
		<Self as CodeAsmCmppoxadd<T, U, V>>::cmppoxadd(self, op0, op1, op2)
	}

	/// `CMPPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPS xmm1, xmm2/m128, imm8` | `NP 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpps<T, U, V>,
	{
		<Self as CodeAsmCmpps<T, U, V>>::cmpps(self, op0, op1, op2)
	}

	/// `CMPPXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPXADD m32, r32, r32` | `VEX.128.66.0F38.W0 EA !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPPXADD m64, r64, r64` | `VEX.128.66.0F38.W1 EA !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmppxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmppxadd<T, U, V>,
	{
		<Self as CodeAsmCmppxadd<T, U, V>>::cmppxadd(self, op0, op1, op2)
	}

	/// `CMPSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSB` | `A6` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cmpsb(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpsb,
	{
		<Self as CodeAsmCmpsb>::cmpsb(self)
	}

	/// `CMPSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSD` | `o32 A7` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cmpsd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpsd,
	{
		<Self as CodeAsmCmpsd>::cmpsd(self)
	}

	/// `CMPSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSD xmm1, xmm2/m64, imm8` | `F2 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpsd_3<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpsd3<T, U, V>,
	{
		<Self as CodeAsmCmpsd3<T, U, V>>::cmpsd_3(self, op0, op1, op2)
	}

	/// `CMPSQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSQ` | `o64 A7` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cmpsq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpsq,
	{
		<Self as CodeAsmCmpsq>::cmpsq(self)
	}

	/// `CMPSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSS xmm1, xmm2/m32, imm8` | `F3 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpss<T, U, V>,
	{
		<Self as CodeAsmCmpss<T, U, V>>::cmpss(self, op0, op1, op2)
	}

	/// `CMPSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSW` | `o16 A7` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cmpsw(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpsw,
	{
		<Self as CodeAsmCmpsw>::cmpsw(self)
	}

	/// `CMPSXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E8 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPSXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E8 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpsxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpsxadd<T, U, V>,
	{
		<Self as CodeAsmCmpsxadd<T, U, V>>::cmpsxadd(self, op0, op1, op2)
	}

	/// `CMPUNORDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPD xmm1, xmm2/m128, imm8` | `66 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpunordpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpunordpd<T, U>,
	{
		<Self as CodeAsmCmpunordpd<T, U>>::cmpunordpd(self, op0, op1)
	}

	/// `CMPUNORDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPPS xmm1, xmm2/m128, imm8` | `NP 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpunordps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpunordps<T, U>,
	{
		<Self as CodeAsmCmpunordps<T, U>>::cmpunordps(self, op0, op1)
	}

	/// `CMPUNORDSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSD xmm1, xmm2/m64, imm8` | `F2 0F C2 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpunordsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpunordsd<T, U>,
	{
		<Self as CodeAsmCmpunordsd<T, U>>::cmpunordsd(self, op0, op1)
	}

	/// `CMPUNORDSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPSS xmm1, xmm2/m32, imm8` | `F3 0F C2 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpunordss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpunordss<T, U>,
	{
		<Self as CodeAsmCmpunordss<T, U>>::cmpunordss(self, op0, op1)
	}

	/// `CMPXCHG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPXCHG r/m8, r8` | `0F B0 /r` | `486+`
	/// `CMPXCHG r/m16, r16` | `o16 0F B1 /r` | `486+`
	/// `CMPXCHG r/m32, r32` | `o32 0F B1 /r` | `486+`
	/// `CMPXCHG r/m64, r64` | `o64 0F B1 /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cmpxchg<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpxchg<T, U>,
	{
		<Self as CodeAsmCmpxchg<T, U>>::cmpxchg(self, op0, op1)
	}

	/// `CMPXCHG16B` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPXCHG16B m128` | `o64 0F C7 /1` | `CMPXCHG16B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn cmpxchg16b<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpxchg16b<T>,
	{
		<Self as CodeAsmCmpxchg16b<T>>::cmpxchg16b(self, op0)
	}

	/// `CMPXCHG8B` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPXCHG8B m64` | `0F C7 /1` | `CX8`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn cmpxchg8b<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpxchg8b<T>,
	{
		<Self as CodeAsmCmpxchg8b<T>>::cmpxchg8b(self, op0)
	}

	/// `CMPZXADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CMPZXADD m32, r32, r32` | `VEX.128.66.0F38.W0 E4 !(11):rrr:bbb` | `CMPCCXADD`
	/// `CMPZXADD m64, r64, r64` | `VEX.128.66.0F38.W1 E4 !(11):rrr:bbb` | `CMPCCXADD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn cmpzxadd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmCmpzxadd<T, U, V>,
	{
		<Self as CodeAsmCmpzxadd<T, U, V>>::cmpzxadd(self, op0, op1, op2)
	}

	/// `COMISD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `COMISD xmm1, xmm2/m64` | `66 0F 2F /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn comisd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmComisd<T, U>,
	{
		<Self as CodeAsmComisd<T, U>>::comisd(self, op0, op1)
	}

	/// `COMISS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `COMISS xmm1, xmm2/m32` | `NP 0F 2F /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn comiss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmComiss<T, U>,
	{
		<Self as CodeAsmComiss<T, U>>::comiss(self, op0, op1)
	}

	/// `CPU_READ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CPU_READ` | `0F 3D` | `Cyrix MediaGX, GXm, GXLV, GX1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cpu_read(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCpu_read,
	{
		<Self as CodeAsmCpu_read>::cpu_read(self)
	}

	/// `CPU_WRITE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CPU_WRITE` | `0F 3C` | `Cyrix MediaGX, GXm, GXLV, GX1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cpu_write(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCpu_write,
	{
		<Self as CodeAsmCpu_write>::cpu_write(self)
	}

	/// `CPUID` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CPUID` | `0F A2` | `CPUID`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cpuid(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCpuid,
	{
		<Self as CodeAsmCpuid>::cpuid(self)
	}

	/// `CQO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CQO` | `o64 99` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cqo(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCqo,
	{
		<Self as CodeAsmCqo>::cqo(self)
	}

	/// `CRC32` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CRC32 r32, r/m8` | `F2 0F 38 F0 /r` | `SSE4.2`
	/// `CRC32 r64, r/m8` | `F2 o64 0F 38 F0 /r` | `SSE4.2`
	/// `CRC32 r32, r/m16` | `o16 F2 0F 38 F1 /r` | `SSE4.2`
	/// `CRC32 r32, r/m32` | `o32 F2 0F 38 F1 /r` | `SSE4.2`
	/// `CRC32 r64, r/m64` | `F2 o64 0F 38 F1 /r` | `SSE4.2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn crc32<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCrc32<T, U>,
	{
		<Self as CodeAsmCrc32<T, U>>::crc32(self, op0, op1)
	}

	/// `CVTDQ2PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTDQ2PD xmm1, xmm2/m64` | `F3 0F E6 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtdq2pd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtdq2pd<T, U>,
	{
		<Self as CodeAsmCvtdq2pd<T, U>>::cvtdq2pd(self, op0, op1)
	}

	/// `CVTDQ2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTDQ2PS xmm1, xmm2/m128` | `NP 0F 5B /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtdq2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtdq2ps<T, U>,
	{
		<Self as CodeAsmCvtdq2ps<T, U>>::cvtdq2ps(self, op0, op1)
	}

	/// `CVTPD2DQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTPD2DQ xmm1, xmm2/m128` | `F2 0F E6 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtpd2dq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtpd2dq<T, U>,
	{
		<Self as CodeAsmCvtpd2dq<T, U>>::cvtpd2dq(self, op0, op1)
	}

	/// `CVTPD2PI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTPD2PI mm, xmm/m128` | `66 0F 2D /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtpd2pi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtpd2pi<T, U>,
	{
		<Self as CodeAsmCvtpd2pi<T, U>>::cvtpd2pi(self, op0, op1)
	}

	/// `CVTPD2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTPD2PS xmm1, xmm2/m128` | `66 0F 5A /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtpd2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtpd2ps<T, U>,
	{
		<Self as CodeAsmCvtpd2ps<T, U>>::cvtpd2ps(self, op0, op1)
	}

	/// `CVTPI2PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTPI2PD xmm, mm/m64` | `66 0F 2A /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtpi2pd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtpi2pd<T, U>,
	{
		<Self as CodeAsmCvtpi2pd<T, U>>::cvtpi2pd(self, op0, op1)
	}

	/// `CVTPI2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTPI2PS xmm, mm/m64` | `NP 0F 2A /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtpi2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtpi2ps<T, U>,
	{
		<Self as CodeAsmCvtpi2ps<T, U>>::cvtpi2ps(self, op0, op1)
	}

	/// `CVTPS2DQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTPS2DQ xmm1, xmm2/m128` | `66 0F 5B /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtps2dq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtps2dq<T, U>,
	{
		<Self as CodeAsmCvtps2dq<T, U>>::cvtps2dq(self, op0, op1)
	}

	/// `CVTPS2PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTPS2PD xmm1, xmm2/m64` | `NP 0F 5A /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtps2pd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtps2pd<T, U>,
	{
		<Self as CodeAsmCvtps2pd<T, U>>::cvtps2pd(self, op0, op1)
	}

	/// `CVTPS2PI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTPS2PI mm, xmm/m64` | `NP 0F 2D /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtps2pi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtps2pi<T, U>,
	{
		<Self as CodeAsmCvtps2pi<T, U>>::cvtps2pi(self, op0, op1)
	}

	/// `CVTSD2SI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTSD2SI r32, xmm1/m64` | `F2 0F 2D /r` | `SSE2`
	/// `CVTSD2SI r64, xmm1/m64` | `F2 o64 0F 2D /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtsd2si<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtsd2si<T, U>,
	{
		<Self as CodeAsmCvtsd2si<T, U>>::cvtsd2si(self, op0, op1)
	}

	/// `CVTSD2SS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTSD2SS xmm1, xmm2/m64` | `F2 0F 5A /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtsd2ss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtsd2ss<T, U>,
	{
		<Self as CodeAsmCvtsd2ss<T, U>>::cvtsd2ss(self, op0, op1)
	}

	/// `CVTSI2SD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTSI2SD xmm1, r/m32` | `F2 0F 2A /r` | `SSE2`
	/// `CVTSI2SD xmm1, r/m64` | `F2 o64 0F 2A /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtsi2sd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtsi2sd<T, U>,
	{
		<Self as CodeAsmCvtsi2sd<T, U>>::cvtsi2sd(self, op0, op1)
	}

	/// `CVTSI2SS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTSI2SS xmm1, r/m32` | `F3 0F 2A /r` | `SSE`
	/// `CVTSI2SS xmm1, r/m64` | `F3 o64 0F 2A /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtsi2ss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtsi2ss<T, U>,
	{
		<Self as CodeAsmCvtsi2ss<T, U>>::cvtsi2ss(self, op0, op1)
	}

	/// `CVTSS2SD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTSS2SD xmm1, xmm2/m32` | `F3 0F 5A /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtss2sd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtss2sd<T, U>,
	{
		<Self as CodeAsmCvtss2sd<T, U>>::cvtss2sd(self, op0, op1)
	}

	/// `CVTSS2SI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTSS2SI r32, xmm1/m32` | `F3 0F 2D /r` | `SSE`
	/// `CVTSS2SI r64, xmm1/m32` | `F3 o64 0F 2D /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvtss2si<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvtss2si<T, U>,
	{
		<Self as CodeAsmCvtss2si<T, U>>::cvtss2si(self, op0, op1)
	}

	/// `CVTTPD2DQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTTPD2DQ xmm1, xmm2/m128` | `66 0F E6 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvttpd2dq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvttpd2dq<T, U>,
	{
		<Self as CodeAsmCvttpd2dq<T, U>>::cvttpd2dq(self, op0, op1)
	}

	/// `CVTTPD2PI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTTPD2PI mm, xmm/m128` | `66 0F 2C /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvttpd2pi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvttpd2pi<T, U>,
	{
		<Self as CodeAsmCvttpd2pi<T, U>>::cvttpd2pi(self, op0, op1)
	}

	/// `CVTTPS2DQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTTPS2DQ xmm1, xmm2/m128` | `F3 0F 5B /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvttps2dq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvttps2dq<T, U>,
	{
		<Self as CodeAsmCvttps2dq<T, U>>::cvttps2dq(self, op0, op1)
	}

	/// `CVTTPS2PI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTTPS2PI mm, xmm/m64` | `NP 0F 2C /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvttps2pi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvttps2pi<T, U>,
	{
		<Self as CodeAsmCvttps2pi<T, U>>::cvttps2pi(self, op0, op1)
	}

	/// `CVTTSD2SI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTTSD2SI r32, xmm1/m64` | `F2 0F 2C /r` | `SSE2`
	/// `CVTTSD2SI r64, xmm1/m64` | `F2 o64 0F 2C /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvttsd2si<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvttsd2si<T, U>,
	{
		<Self as CodeAsmCvttsd2si<T, U>>::cvttsd2si(self, op0, op1)
	}

	/// `CVTTSS2SI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CVTTSS2SI r32, xmm1/m32` | `F3 0F 2C /r` | `SSE`
	/// `CVTTSS2SI r64, xmm1/m32` | `F3 o64 0F 2C /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn cvttss2si<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmCvttss2si<T, U>,
	{
		<Self as CodeAsmCvttss2si<T, U>>::cvttss2si(self, op0, op1)
	}

	/// `CWD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CWD` | `o16 99` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cwd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCwd,
	{
		<Self as CodeAsmCwd>::cwd(self)
	}

	/// `CWDE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `CWDE` | `o32 98` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn cwde(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmCwde,
	{
		<Self as CodeAsmCwde>::cwde(self)
	}

	/// `DAA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `DAA` | `27` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn daa(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmDaa,
	{
		<Self as CodeAsmDaa>::daa(self)
	}

	/// `DAS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `DAS` | `2F` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn das(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmDas,
	{
		<Self as CodeAsmDas>::das(self)
	}

	/// `DEC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `DEC r16` | `o16 48+rw` | `8086+`
	/// `DEC r32` | `o32 48+rd` | `386+`
	/// `DEC r/m8` | `FE /1` | `8086+`
	/// `DEC r/m16` | `o16 FF /1` | `8086+`
	/// `DEC r/m32` | `o32 FF /1` | `386+`
	/// `DEC r/m64` | `o64 FF /1` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn dec<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmDec<T>,
	{
		<Self as CodeAsmDec<T>>::dec(self, op0)
	}

	/// `DIV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `DIV r/m8` | `F6 /6` | `8086+`
	/// `DIV r/m16` | `o16 F7 /6` | `8086+`
	/// `DIV r/m32` | `o32 F7 /6` | `386+`
	/// `DIV r/m64` | `o64 F7 /6` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn div<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmDiv<T>,
	{
		<Self as CodeAsmDiv<T>>::div(self, op0)
	}

	/// `DIVPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `DIVPD xmm1, xmm2/m128` | `66 0F 5E /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn divpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmDivpd<T, U>,
	{
		<Self as CodeAsmDivpd<T, U>>::divpd(self, op0, op1)
	}

	/// `DIVPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `DIVPS xmm1, xmm2/m128` | `NP 0F 5E /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn divps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmDivps<T, U>,
	{
		<Self as CodeAsmDivps<T, U>>::divps(self, op0, op1)
	}

	/// `DIVSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `DIVSD xmm1, xmm2/m64` | `F2 0F 5E /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn divsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmDivsd<T, U>,
	{
		<Self as CodeAsmDivsd<T, U>>::divsd(self, op0, op1)
	}

	/// `DIVSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `DIVSS xmm1, xmm2/m32` | `F3 0F 5E /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn divss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmDivss<T, U>,
	{
		<Self as CodeAsmDivss<T, U>>::divss(self, op0, op1)
	}

	/// `DMINT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `DMINT` | `0F 39` | `AMD Geode GX/LX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn dmint(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmDmint,
	{
		<Self as CodeAsmDmint>::dmint(self)
	}

	/// `DPPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `DPPD xmm1, xmm2/m128, imm8` | `66 0F 3A 41 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn dppd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmDppd<T, U, V>,
	{
		<Self as CodeAsmDppd<T, U, V>>::dppd(self, op0, op1, op2)
	}

	/// `DPPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `DPPS xmm1, xmm2/m128, imm8` | `66 0F 3A 40 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn dpps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmDpps<T, U, V>,
	{
		<Self as CodeAsmDpps<T, U, V>>::dpps(self, op0, op1, op2)
	}

	/// `EMMS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `EMMS` | `NP 0F 77` | `MMX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn emms(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmEmms,
	{
		<Self as CodeAsmEmms>::emms(self)
	}

	/// `ENCLS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ENCLS` | `NP 0F 01 CF` | `SGX1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn encls(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmEncls,
	{
		<Self as CodeAsmEncls>::encls(self)
	}

	/// `ENCLU` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ENCLU` | `NP 0F 01 D7` | `SGX1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn enclu(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmEnclu,
	{
		<Self as CodeAsmEnclu>::enclu(self)
	}

	/// `ENCLV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ENCLV` | `NP 0F 01 C0` | `OSS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn enclv(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmEnclv,
	{
		<Self as CodeAsmEnclv>::enclv(self)
	}

	/// `ENCODEKEY128` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ENCODEKEY128 r32, r32, <XMM0-2>, <XMM4-6>` | `F3 0F 38 FA 11:rrr:bbb` | `AESKLE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn encodekey128<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmEncodekey128<T, U>,
	{
		<Self as CodeAsmEncodekey128<T, U>>::encodekey128(self, op0, op1)
	}

	/// `ENCODEKEY256` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ENCODEKEY256 r32, r32, <XMM0-6>` | `F3 0F 38 FB 11:rrr:bbb` | `AESKLE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn encodekey256<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmEncodekey256<T, U>,
	{
		<Self as CodeAsmEncodekey256<T, U>>::encodekey256(self, op0, op1)
	}

	/// `ENDBR32` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ENDBR32` | `F3 0F 1E FB` | `CET_IBT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn endbr32(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmEndbr32,
	{
		<Self as CodeAsmEndbr32>::endbr32(self)
	}

	/// `ENDBR64` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ENDBR64` | `F3 0F 1E FA` | `CET_IBT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn endbr64(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmEndbr64,
	{
		<Self as CodeAsmEndbr64>::endbr64(self)
	}

	/// `ENQCMD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ENQCMD r16, m512` | `a16 F2 0F 38 F8 !(11):rrr:bbb` | `ENQCMD`
	/// `ENQCMD r32, m512` | `a32 F2 0F 38 F8 !(11):rrr:bbb` | `ENQCMD`
	/// `ENQCMD r64, m512` | `a64 F2 0F 38 F8 !(11):rrr:bbb` | `ENQCMD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn enqcmd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmEnqcmd<T, U>,
	{
		<Self as CodeAsmEnqcmd<T, U>>::enqcmd(self, op0, op1)
	}

	/// `ENQCMDS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ENQCMDS r16, m512` | `a16 F3 0F 38 F8 !(11):rrr:bbb` | `ENQCMD`
	/// `ENQCMDS r32, m512` | `a32 F3 0F 38 F8 !(11):rrr:bbb` | `ENQCMD`
	/// `ENQCMDS r64, m512` | `a64 F3 0F 38 F8 !(11):rrr:bbb` | `ENQCMD`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn enqcmds<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmEnqcmds<T, U>,
	{
		<Self as CodeAsmEnqcmds<T, U>>::enqcmds(self, op0, op1)
	}

	/// `ENTER` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ENTER imm16, imm8` | `o16 C8 iw ib` | `186+`
	/// `ENTER imm16, imm8` | `o32 C8 iw ib` | `386+`
	/// `ENTER imm16, imm8` | `o64 C8 iw ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn enter<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmEnter<T, U>,
	{
		<Self as CodeAsmEnter<T, U>>::enter(self, op0, op1)
	}

	/// `ERETS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ERETS` | `F2 0F 01 CA` | `FRED`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn erets(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmErets,
	{
		<Self as CodeAsmErets>::erets(self)
	}

	/// `ERETU` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ERETU` | `F3 0F 01 CA` | `FRED`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn eretu(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmEretu,
	{
		<Self as CodeAsmEretu>::eretu(self)
	}

	/// `EXTRACTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `EXTRACTPS r/m32, xmm1, imm8` | `66 0F 3A 17 /r ib` | `SSE4.1`
	/// `EXTRACTPS r64/m32, xmm1, imm8` | `66 o64 0F 3A 17 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn extractps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmExtractps<T, U, V>,
	{
		<Self as CodeAsmExtractps<T, U, V>>::extractps(self, op0, op1, op2)
	}

	/// `EXTRQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `EXTRQ xmm1, xmm2` | `66 0F 79 /r` | `SSE4A`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn extrq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmExtrq<T, U>,
	{
		<Self as CodeAsmExtrq<T, U>>::extrq(self, op0, op1)
	}

	/// `EXTRQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `EXTRQ xmm1, imm8, imm8` | `66 0F 78 /0 ib ib` | `SSE4A`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn extrq_3<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmExtrq3<T, U, V>,
	{
		<Self as CodeAsmExtrq3<T, U, V>>::extrq_3(self, op0, op1, op2)
	}

	/// `F2XM1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `F2XM1` | `D9 F0` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn f2xm1(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmF2xm1,
	{
		<Self as CodeAsmF2xm1>::f2xm1(self)
	}

	/// `FABS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FABS` | `D9 E1` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fabs(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFabs,
	{
		<Self as CodeAsmFabs>::fabs(self)
	}

	/// `FADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FADD m32fp` | `D8 /0` | `8087+`
	/// `FADD m64fp` | `DC /0` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fadd<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFadd<T>,
	{
		<Self as CodeAsmFadd<T>>::fadd(self, op0)
	}

	/// `FADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FADD ST(0), ST(i)` | `D8 C0+i` | `8087+`
	/// `FADD ST(i), ST(0)` | `DC C0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fadd_2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFadd2<T, U>,
	{
		<Self as CodeAsmFadd2<T, U>>::fadd_2(self, op0, op1)
	}

	/// `FADDP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FADDP ST(i), ST(0)` | `DE C0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn faddp<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFaddp<T, U>,
	{
		<Self as CodeAsmFaddp<T, U>>::faddp(self, op0, op1)
	}

	/// `FBLD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FBLD m80bcd` | `DF /4` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fbld<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFbld<T>,
	{
		<Self as CodeAsmFbld<T>>::fbld(self, op0)
	}

	/// `FBSTP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FBSTP m80bcd` | `DF /6` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fbstp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFbstp<T>,
	{
		<Self as CodeAsmFbstp<T>>::fbstp(self, op0)
	}

	/// `FCHS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCHS` | `D9 E0` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fchs(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFchs,
	{
		<Self as CodeAsmFchs>::fchs(self)
	}

	/// `FCLEX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCLEX` | `9B DB E2` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fclex(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFclex,
	{
		<Self as CodeAsmFclex>::fclex(self)
	}

	/// `FCMOVB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCMOVB ST(0), ST(i)` | `DA C0+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcmovb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcmovb<T, U>,
	{
		<Self as CodeAsmFcmovb<T, U>>::fcmovb(self, op0, op1)
	}

	/// `FCMOVBE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCMOVBE ST(0), ST(i)` | `DA D0+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcmovbe<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcmovbe<T, U>,
	{
		<Self as CodeAsmFcmovbe<T, U>>::fcmovbe(self, op0, op1)
	}

	/// `FCMOVE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCMOVE ST(0), ST(i)` | `DA C8+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcmove<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcmove<T, U>,
	{
		<Self as CodeAsmFcmove<T, U>>::fcmove(self, op0, op1)
	}

	/// `FCMOVNB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCMOVNB ST(0), ST(i)` | `DB C0+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcmovnb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcmovnb<T, U>,
	{
		<Self as CodeAsmFcmovnb<T, U>>::fcmovnb(self, op0, op1)
	}

	/// `FCMOVNBE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCMOVNBE ST(0), ST(i)` | `DB D0+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcmovnbe<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcmovnbe<T, U>,
	{
		<Self as CodeAsmFcmovnbe<T, U>>::fcmovnbe(self, op0, op1)
	}

	/// `FCMOVNE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCMOVNE ST(0), ST(i)` | `DB C8+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcmovne<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcmovne<T, U>,
	{
		<Self as CodeAsmFcmovne<T, U>>::fcmovne(self, op0, op1)
	}

	/// `FCMOVNU` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCMOVNU ST(0), ST(i)` | `DB D8+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcmovnu<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcmovnu<T, U>,
	{
		<Self as CodeAsmFcmovnu<T, U>>::fcmovnu(self, op0, op1)
	}

	/// `FCMOVU` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCMOVU ST(0), ST(i)` | `DA D8+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcmovu<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcmovu<T, U>,
	{
		<Self as CodeAsmFcmovu<T, U>>::fcmovu(self, op0, op1)
	}

	/// `FCOM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCOM m32fp` | `D8 /2` | `8087+`
	/// `FCOM m64fp` | `DC /2` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fcom<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFcom<T>,
	{
		<Self as CodeAsmFcom<T>>::fcom(self, op0)
	}

	/// `FCOM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCOM ST(i)` | `D8 D0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcom_2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcom2<T, U>,
	{
		<Self as CodeAsmFcom2<T, U>>::fcom_2(self, op0, op1)
	}

	/// `FCOMI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCOMI ST, ST(i)` | `DB F0+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcomi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcomi<T, U>,
	{
		<Self as CodeAsmFcomi<T, U>>::fcomi(self, op0, op1)
	}

	/// `FCOMIP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCOMIP ST, ST(i)` | `DF F0+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcomip<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcomip<T, U>,
	{
		<Self as CodeAsmFcomip<T, U>>::fcomip(self, op0, op1)
	}

	/// `FCOMP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCOMP m32fp` | `D8 /3` | `8087+`
	/// `FCOMP m64fp` | `DC /3` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fcomp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFcomp<T>,
	{
		<Self as CodeAsmFcomp<T>>::fcomp(self, op0)
	}

	/// `FCOMP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCOMP ST(i)` | `D8 D8+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fcomp_2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFcomp2<T, U>,
	{
		<Self as CodeAsmFcomp2<T, U>>::fcomp_2(self, op0, op1)
	}

	/// `FCOMPP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCOMPP` | `DE D9` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fcompp(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFcompp,
	{
		<Self as CodeAsmFcompp>::fcompp(self)
	}

	/// `FCOS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FCOS` | `D9 FF` | `387+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fcos(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFcos,
	{
		<Self as CodeAsmFcos>::fcos(self)
	}

	/// `FDECSTP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FDECSTP` | `D9 F6` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fdecstp(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFdecstp,
	{
		<Self as CodeAsmFdecstp>::fdecstp(self)
	}

	/// `FDISI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FDISI` | `9B DB E1` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fdisi(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFdisi,
	{
		<Self as CodeAsmFdisi>::fdisi(self)
	}

	/// `FDIV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FDIV m32fp` | `D8 /6` | `8087+`
	/// `FDIV m64fp` | `DC /6` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fdiv<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFdiv<T>,
	{
		<Self as CodeAsmFdiv<T>>::fdiv(self, op0)
	}

	/// `FDIV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FDIV ST(0), ST(i)` | `D8 F0+i` | `8087+`
	/// `FDIV ST(i), ST(0)` | `DC F8+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fdiv_2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFdiv2<T, U>,
	{
		<Self as CodeAsmFdiv2<T, U>>::fdiv_2(self, op0, op1)
	}

	/// `FDIVP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FDIVP ST(i), ST(0)` | `DE F8+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fdivp<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFdivp<T, U>,
	{
		<Self as CodeAsmFdivp<T, U>>::fdivp(self, op0, op1)
	}

	/// `FDIVR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FDIVR m32fp` | `D8 /7` | `8087+`
	/// `FDIVR m64fp` | `DC /7` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fdivr<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFdivr<T>,
	{
		<Self as CodeAsmFdivr<T>>::fdivr(self, op0)
	}

	/// `FDIVR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FDIVR ST(0), ST(i)` | `D8 F8+i` | `8087+`
	/// `FDIVR ST(i), ST(0)` | `DC F0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fdivr_2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFdivr2<T, U>,
	{
		<Self as CodeAsmFdivr2<T, U>>::fdivr_2(self, op0, op1)
	}

	/// `FDIVRP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FDIVRP ST(i), ST(0)` | `DE F0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fdivrp<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFdivrp<T, U>,
	{
		<Self as CodeAsmFdivrp<T, U>>::fdivrp(self, op0, op1)
	}

	/// `FEMMS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FEMMS` | `0F 0E` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn femms(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFemms,
	{
		<Self as CodeAsmFemms>::femms(self)
	}

	/// `FENI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FENI` | `9B DB E0` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn feni(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFeni,
	{
		<Self as CodeAsmFeni>::feni(self)
	}

	/// `FFREE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FFREE ST(i)` | `DD C0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn ffree<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFfree<T>,
	{
		<Self as CodeAsmFfree<T>>::ffree(self, op0)
	}

	/// `FFREEP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FFREEP ST(i)` | `DF C0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn ffreep<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFfreep<T>,
	{
		<Self as CodeAsmFfreep<T>>::ffreep(self, op0)
	}

	/// `FIADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FIADD m32int` | `DA /0` | `8087+`
	/// `FIADD m16int` | `DE /0` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fiadd<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFiadd<T>,
	{
		<Self as CodeAsmFiadd<T>>::fiadd(self, op0)
	}

	/// `FICOM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FICOM m32int` | `DA /2` | `8087+`
	/// `FICOM m16int` | `DE /2` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn ficom<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFicom<T>,
	{
		<Self as CodeAsmFicom<T>>::ficom(self, op0)
	}

	/// `FICOMP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FICOMP m32int` | `DA /3` | `8087+`
	/// `FICOMP m16int` | `DE /3` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn ficomp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFicomp<T>,
	{
		<Self as CodeAsmFicomp<T>>::ficomp(self, op0)
	}

	/// `FIDIV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FIDIV m32int` | `DA /6` | `8087+`
	/// `FIDIV m16int` | `DE /6` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fidiv<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFidiv<T>,
	{
		<Self as CodeAsmFidiv<T>>::fidiv(self, op0)
	}

	/// `FIDIVR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FIDIVR m32int` | `DA /7` | `8087+`
	/// `FIDIVR m16int` | `DE /7` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fidivr<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFidivr<T>,
	{
		<Self as CodeAsmFidivr<T>>::fidivr(self, op0)
	}

	/// `FILD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FILD m32int` | `DB /0` | `8087+`
	/// `FILD m16int` | `DF /0` | `8087+`
	/// `FILD m64int` | `DF /5` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fild<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFild<T>,
	{
		<Self as CodeAsmFild<T>>::fild(self, op0)
	}

	/// `FIMUL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FIMUL m32int` | `DA /1` | `8087+`
	/// `FIMUL m16int` | `DE /1` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fimul<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFimul<T>,
	{
		<Self as CodeAsmFimul<T>>::fimul(self, op0)
	}

	/// `FINCSTP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FINCSTP` | `D9 F7` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fincstp(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFincstp,
	{
		<Self as CodeAsmFincstp>::fincstp(self)
	}

	/// `FINIT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FINIT` | `9B DB E3` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn finit(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFinit,
	{
		<Self as CodeAsmFinit>::finit(self)
	}

	/// `FIST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FIST m32int` | `DB /2` | `8087+`
	/// `FIST m16int` | `DF /2` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fist<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFist<T>,
	{
		<Self as CodeAsmFist<T>>::fist(self, op0)
	}

	/// `FISTP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FISTP m32int` | `DB /3` | `8087+`
	/// `FISTP m16int` | `DF /3` | `8087+`
	/// `FISTP m64int` | `DF /7` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fistp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFistp<T>,
	{
		<Self as CodeAsmFistp<T>>::fistp(self, op0)
	}

	/// `FISTTP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FISTTP m32int` | `DB /1` | `8087+ SSE3`
	/// `FISTTP m64int` | `DD /1` | `8087+ SSE3`
	/// `FISTTP m16int` | `DF /1` | `8087+ SSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fisttp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFisttp<T>,
	{
		<Self as CodeAsmFisttp<T>>::fisttp(self, op0)
	}

	/// `FISUB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FISUB m32int` | `DA /4` | `8087+`
	/// `FISUB m16int` | `DE /4` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fisub<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFisub<T>,
	{
		<Self as CodeAsmFisub<T>>::fisub(self, op0)
	}

	/// `FISUBR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FISUBR m32int` | `DA /5` | `8087+`
	/// `FISUBR m16int` | `DE /5` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fisubr<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFisubr<T>,
	{
		<Self as CodeAsmFisubr<T>>::fisubr(self, op0)
	}

	/// `FLD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FLD m32fp` | `D9 /0` | `8087+`
	/// `FLD m80fp` | `DB /5` | `8087+`
	/// `FLD m64fp` | `DD /0` | `8087+`
	/// `FLD ST(i)` | `D9 C0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fld<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFld<T>,
	{
		<Self as CodeAsmFld<T>>::fld(self, op0)
	}

	/// `FLD1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FLD1` | `D9 E8` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fld1(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFld1,
	{
		<Self as CodeAsmFld1>::fld1(self)
	}

	/// `FLDCW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FLDCW m2byte` | `D9 /5` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fldcw<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFldcw<T>,
	{
		<Self as CodeAsmFldcw<T>>::fldcw(self, op0)
	}

	/// `FLDENV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FLDENV m14byte` | `o16 D9 /4` | `8087+`
	/// `FLDENV m28byte` | `o32 D9 /4` | `387+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fldenv<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFldenv<T>,
	{
		<Self as CodeAsmFldenv<T>>::fldenv(self, op0)
	}

	/// `FLDL2E` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FLDL2E` | `D9 EA` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fldl2e(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFldl2e,
	{
		<Self as CodeAsmFldl2e>::fldl2e(self)
	}

	/// `FLDL2T` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FLDL2T` | `D9 E9` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fldl2t(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFldl2t,
	{
		<Self as CodeAsmFldl2t>::fldl2t(self)
	}

	/// `FLDLG2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FLDLG2` | `D9 EC` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fldlg2(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFldlg2,
	{
		<Self as CodeAsmFldlg2>::fldlg2(self)
	}

	/// `FLDLN2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FLDLN2` | `D9 ED` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fldln2(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFldln2,
	{
		<Self as CodeAsmFldln2>::fldln2(self)
	}

	/// `FLDPI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FLDPI` | `D9 EB` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fldpi(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFldpi,
	{
		<Self as CodeAsmFldpi>::fldpi(self)
	}

	/// `FLDZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FLDZ` | `D9 EE` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fldz(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFldz,
	{
		<Self as CodeAsmFldz>::fldz(self)
	}

	/// `FMUL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FMUL m32fp` | `D8 /1` | `8087+`
	/// `FMUL m64fp` | `DC /1` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fmul<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFmul<T>,
	{
		<Self as CodeAsmFmul<T>>::fmul(self, op0)
	}

	/// `FMUL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FMUL ST(0), ST(i)` | `D8 C8+i` | `8087+`
	/// `FMUL ST(i), ST(0)` | `DC C8+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fmul_2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFmul2<T, U>,
	{
		<Self as CodeAsmFmul2<T, U>>::fmul_2(self, op0, op1)
	}

	/// `FMULP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FMULP ST(i), ST(0)` | `DE C8+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fmulp<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFmulp<T, U>,
	{
		<Self as CodeAsmFmulp<T, U>>::fmulp(self, op0, op1)
	}

	/// `FNCLEX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNCLEX` | `DB E2` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fnclex(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFnclex,
	{
		<Self as CodeAsmFnclex>::fnclex(self)
	}

	/// `FNDISI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNDISI` | `DB E1` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fndisi(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFndisi,
	{
		<Self as CodeAsmFndisi>::fndisi(self)
	}

	/// `FNENI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNENI` | `DB E0` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fneni(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFneni,
	{
		<Self as CodeAsmFneni>::fneni(self)
	}

	/// `FNINIT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNINIT` | `DB E3` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fninit(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFninit,
	{
		<Self as CodeAsmFninit>::fninit(self)
	}

	/// `FNOP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNOP` | `D9 D0` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fnop(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFnop,
	{
		<Self as CodeAsmFnop>::fnop(self)
	}

	/// `FNSAVE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNSAVE m94byte` | `o16 DD /6` | `8087+`
	/// `FNSAVE m108byte` | `o32 DD /6` | `387+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fnsave<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFnsave<T>,
	{
		<Self as CodeAsmFnsave<T>>::fnsave(self, op0)
	}

	/// `FNSETPM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNSETPM` | `DB E4` | `287+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fnsetpm(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFnsetpm,
	{
		<Self as CodeAsmFnsetpm>::fnsetpm(self)
	}

	/// `FNSTCW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNSTCW m2byte` | `D9 /7` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fnstcw<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFnstcw<T>,
	{
		<Self as CodeAsmFnstcw<T>>::fnstcw(self, op0)
	}

	/// `FNSTDW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNSTDW AX` | `DF E1` | `387 SL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fnstdw<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFnstdw<T>,
	{
		<Self as CodeAsmFnstdw<T>>::fnstdw(self, op0)
	}

	/// `FNSTENV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNSTENV m14byte` | `o16 D9 /6` | `8087+`
	/// `FNSTENV m28byte` | `o32 D9 /6` | `387+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fnstenv<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFnstenv<T>,
	{
		<Self as CodeAsmFnstenv<T>>::fnstenv(self, op0)
	}

	/// `FNSTSG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNSTSG AX` | `DF E2` | `387 SL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fnstsg<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFnstsg<T>,
	{
		<Self as CodeAsmFnstsg<T>>::fnstsg(self, op0)
	}

	/// `FNSTSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FNSTSW m2byte` | `DD /7` | `8087+`
	/// `FNSTSW AX` | `DF E0` | `287+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fnstsw<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFnstsw<T>,
	{
		<Self as CodeAsmFnstsw<T>>::fnstsw(self, op0)
	}

	/// `FPATAN` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FPATAN` | `D9 F3` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fpatan(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFpatan,
	{
		<Self as CodeAsmFpatan>::fpatan(self)
	}

	/// `FPREM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FPREM` | `D9 F8` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fprem(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFprem,
	{
		<Self as CodeAsmFprem>::fprem(self)
	}

	/// `FPREM1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FPREM1` | `D9 F5` | `387+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fprem1(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFprem1,
	{
		<Self as CodeAsmFprem1>::fprem1(self)
	}

	/// `FPTAN` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FPTAN` | `D9 F2` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fptan(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFptan,
	{
		<Self as CodeAsmFptan>::fptan(self)
	}

	/// `FRNDINT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FRNDINT` | `D9 FC` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn frndint(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFrndint,
	{
		<Self as CodeAsmFrndint>::frndint(self)
	}

	/// `FRSTOR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FRSTOR m94byte` | `o16 DD /4` | `8087+`
	/// `FRSTOR m108byte` | `o32 DD /4` | `387+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn frstor<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFrstor<T>,
	{
		<Self as CodeAsmFrstor<T>>::frstor(self, op0)
	}

	/// `FRSTPM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FRSTPM` | `DB E5` | `287 XL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn frstpm(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFrstpm,
	{
		<Self as CodeAsmFrstpm>::frstpm(self)
	}

	/// `FSAVE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSAVE m94byte` | `9B o16 DD /6` | `8087+`
	/// `FSAVE m108byte` | `9B o32 DD /6` | `387+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fsave<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFsave<T>,
	{
		<Self as CodeAsmFsave<T>>::fsave(self, op0)
	}

	/// `FSCALE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSCALE` | `D9 FD` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fscale(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFscale,
	{
		<Self as CodeAsmFscale>::fscale(self)
	}

	/// `FSETPM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSETPM` | `9B DB E4` | `287+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fsetpm(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFsetpm,
	{
		<Self as CodeAsmFsetpm>::fsetpm(self)
	}

	/// `FSIN` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSIN` | `D9 FE` | `387+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fsin(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFsin,
	{
		<Self as CodeAsmFsin>::fsin(self)
	}

	/// `FSINCOS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSINCOS` | `D9 FB` | `387+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fsincos(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFsincos,
	{
		<Self as CodeAsmFsincos>::fsincos(self)
	}

	/// `FSQRT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSQRT` | `D9 FA` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fsqrt(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFsqrt,
	{
		<Self as CodeAsmFsqrt>::fsqrt(self)
	}

	/// `FST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FST m32fp` | `D9 /2` | `8087+`
	/// `FST m64fp` | `DD /2` | `8087+`
	/// `FST ST(i)` | `DD D0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fst<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFst<T>,
	{
		<Self as CodeAsmFst<T>>::fst(self, op0)
	}

	/// `FSTCW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSTCW m2byte` | `9B D9 /7` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fstcw<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFstcw<T>,
	{
		<Self as CodeAsmFstcw<T>>::fstcw(self, op0)
	}

	/// `FSTDW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSTDW AX` | `9B DF E1` | `387 SL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fstdw<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFstdw<T>,
	{
		<Self as CodeAsmFstdw<T>>::fstdw(self, op0)
	}

	/// `FSTENV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSTENV m14byte` | `9B o16 D9 /6` | `8087+`
	/// `FSTENV m28byte` | `9B o32 D9 /6` | `387+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fstenv<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFstenv<T>,
	{
		<Self as CodeAsmFstenv<T>>::fstenv(self, op0)
	}

	/// `FSTP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSTP m32fp` | `D9 /3` | `8087+`
	/// `FSTP m80fp` | `DB /7` | `8087+`
	/// `FSTP m64fp` | `DD /3` | `8087+`
	/// `FSTP ST(i)` | `DD D8+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fstp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFstp<T>,
	{
		<Self as CodeAsmFstp<T>>::fstp(self, op0)
	}

	/// `FSTPNCE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSTPNCE ST(i)` | `D9 D8+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fstpnce<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFstpnce<T>,
	{
		<Self as CodeAsmFstpnce<T>>::fstpnce(self, op0)
	}

	/// `FSTSG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSTSG AX` | `9B DF E2` | `387 SL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fstsg<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFstsg<T>,
	{
		<Self as CodeAsmFstsg<T>>::fstsg(self, op0)
	}

	/// `FSTSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSTSW m2byte` | `9B DD /7` | `8087+`
	/// `FSTSW AX` | `9B DF E0` | `287+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fstsw<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFstsw<T>,
	{
		<Self as CodeAsmFstsw<T>>::fstsw(self, op0)
	}

	/// `FSUB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSUB m32fp` | `D8 /4` | `8087+`
	/// `FSUB m64fp` | `DC /4` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fsub<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFsub<T>,
	{
		<Self as CodeAsmFsub<T>>::fsub(self, op0)
	}

	/// `FSUB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSUB ST(0), ST(i)` | `D8 E0+i` | `8087+`
	/// `FSUB ST(i), ST(0)` | `DC E8+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fsub_2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFsub2<T, U>,
	{
		<Self as CodeAsmFsub2<T, U>>::fsub_2(self, op0, op1)
	}

	/// `FSUBP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSUBP ST(i), ST(0)` | `DE E8+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fsubp<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFsubp<T, U>,
	{
		<Self as CodeAsmFsubp<T, U>>::fsubp(self, op0, op1)
	}

	/// `FSUBR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSUBR m32fp` | `D8 /5` | `8087+`
	/// `FSUBR m64fp` | `DC /5` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fsubr<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFsubr<T>,
	{
		<Self as CodeAsmFsubr<T>>::fsubr(self, op0)
	}

	/// `FSUBR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSUBR ST(0), ST(i)` | `D8 E8+i` | `8087+`
	/// `FSUBR ST(i), ST(0)` | `DC E0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fsubr_2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFsubr2<T, U>,
	{
		<Self as CodeAsmFsubr2<T, U>>::fsubr_2(self, op0, op1)
	}

	/// `FSUBRP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FSUBRP ST(i), ST(0)` | `DE E0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fsubrp<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFsubrp<T, U>,
	{
		<Self as CodeAsmFsubrp<T, U>>::fsubrp(self, op0, op1)
	}

	/// `FTST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FTST` | `D9 E4` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn ftst(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFtst,
	{
		<Self as CodeAsmFtst>::ftst(self)
	}

	/// `FUCOM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FUCOM ST(i)` | `DD E0+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fucom<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFucom<T, U>,
	{
		<Self as CodeAsmFucom<T, U>>::fucom(self, op0, op1)
	}

	/// `FUCOMI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FUCOMI ST, ST(i)` | `DB E8+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fucomi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFucomi<T, U>,
	{
		<Self as CodeAsmFucomi<T, U>>::fucomi(self, op0, op1)
	}

	/// `FUCOMIP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FUCOMIP ST, ST(i)` | `DF E8+i` | `8087+ CMOV`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fucomip<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFucomip<T, U>,
	{
		<Self as CodeAsmFucomip<T, U>>::fucomip(self, op0, op1)
	}

	/// `FUCOMP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FUCOMP ST(i)` | `DD E8+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fucomp<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFucomp<T, U>,
	{
		<Self as CodeAsmFucomp<T, U>>::fucomp(self, op0, op1)
	}

	/// `FUCOMPP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FUCOMPP` | `DA E9` | `387+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fucompp(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFucompp,
	{
		<Self as CodeAsmFucompp>::fucompp(self)
	}

	/// `FXAM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FXAM` | `D9 E5` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fxam(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFxam,
	{
		<Self as CodeAsmFxam>::fxam(self)
	}

	/// `FXCH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FXCH ST(i)` | `D9 C8+i` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn fxch<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmFxch<T, U>,
	{
		<Self as CodeAsmFxch<T, U>>::fxch(self, op0, op1)
	}

	/// `FXRSTOR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FXRSTOR m512byte` | `NP 0F AE /1` | `FXSR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fxrstor<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFxrstor<T>,
	{
		<Self as CodeAsmFxrstor<T>>::fxrstor(self, op0)
	}

	/// `FXRSTOR64` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FXRSTOR64 m512byte` | `NP o64 0F AE /1` | `FXSR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fxrstor64<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFxrstor64<T>,
	{
		<Self as CodeAsmFxrstor64<T>>::fxrstor64(self, op0)
	}

	/// `FXSAVE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FXSAVE m512byte` | `NP 0F AE /0` | `FXSR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fxsave<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFxsave<T>,
	{
		<Self as CodeAsmFxsave<T>>::fxsave(self, op0)
	}

	/// `FXSAVE64` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FXSAVE64 m512byte` | `NP o64 0F AE /0` | `FXSR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn fxsave64<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmFxsave64<T>,
	{
		<Self as CodeAsmFxsave64<T>>::fxsave64(self, op0)
	}

	/// `FXTRACT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FXTRACT` | `D9 F4` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fxtract(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFxtract,
	{
		<Self as CodeAsmFxtract>::fxtract(self)
	}

	/// `FYL2X` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FYL2X` | `D9 F1` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fyl2x(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFyl2x,
	{
		<Self as CodeAsmFyl2x>::fyl2x(self)
	}

	/// `FYL2XP1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `FYL2XP1` | `D9 F9` | `8087+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn fyl2xp1(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmFyl2xp1,
	{
		<Self as CodeAsmFyl2xp1>::fyl2xp1(self)
	}

	/// `GETSEC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `GETSEC` | `NP 0F 37` | `SMX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn getsec(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmGetsec,
	{
		<Self as CodeAsmGetsec>::getsec(self)
	}

	/// `GETSECQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `GETSECQ` | `NP o64 0F 37` | `SMX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn getsecq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmGetsecq,
	{
		<Self as CodeAsmGetsecq>::getsecq(self)
	}

	/// `GF2P8AFFINEINVQB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `GF2P8AFFINEINVQB xmm1, xmm2/m128, imm8` | `66 0F 3A CF /r ib` | `GFNI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn gf2p8affineinvqb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmGf2p8affineinvqb<T, U, V>,
	{
		<Self as CodeAsmGf2p8affineinvqb<T, U, V>>::gf2p8affineinvqb(self, op0, op1, op2)
	}

	/// `GF2P8AFFINEQB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `GF2P8AFFINEQB xmm1, xmm2/m128, imm8` | `66 0F 3A CE /r ib` | `GFNI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn gf2p8affineqb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmGf2p8affineqb<T, U, V>,
	{
		<Self as CodeAsmGf2p8affineqb<T, U, V>>::gf2p8affineqb(self, op0, op1, op2)
	}

	/// `GF2P8MULB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `GF2P8MULB xmm1, xmm2/m128` | `66 0F 38 CF /r` | `GFNI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn gf2p8mulb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmGf2p8mulb<T, U>,
	{
		<Self as CodeAsmGf2p8mulb<T, U>>::gf2p8mulb(self, op0, op1)
	}

	/// `HADDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `HADDPD xmm1, xmm2/m128` | `66 0F 7C /r` | `SSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn haddpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmHaddpd<T, U>,
	{
		<Self as CodeAsmHaddpd<T, U>>::haddpd(self, op0, op1)
	}

	/// `HADDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `HADDPS xmm1, xmm2/m128` | `F2 0F 7C /r` | `SSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn haddps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmHaddps<T, U>,
	{
		<Self as CodeAsmHaddps<T, U>>::haddps(self, op0, op1)
	}

	/// `HLT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `HLT` | `F4` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn hlt(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmHlt,
	{
		<Self as CodeAsmHlt>::hlt(self)
	}

	/// `HRESET` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `HRESET imm8, <EAX>` | `F3 0F 3A F0 C0 ib` | `HRESET`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn hreset<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmHreset<T>,
	{
		<Self as CodeAsmHreset<T>>::hreset(self, op0)
	}

	/// `HSUBPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `HSUBPD xmm1, xmm2/m128` | `66 0F 7D /r` | `SSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn hsubpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmHsubpd<T, U>,
	{
		<Self as CodeAsmHsubpd<T, U>>::hsubpd(self, op0, op1)
	}

	/// `HSUBPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `HSUBPS xmm1, xmm2/m128` | `F2 0F 7D /r` | `SSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn hsubps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmHsubps<T, U>,
	{
		<Self as CodeAsmHsubps<T, U>>::hsubps(self, op0, op1)
	}

	/// `IBTS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `IBTS r/m16, r16` | `o16 0F A7 /r` | `386 A0`
	/// `IBTS r/m32, r32` | `o32 0F A7 /r` | `386 A0`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn ibts<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmIbts<T, U>,
	{
		<Self as CodeAsmIbts<T, U>>::ibts(self, op0, op1)
	}

	/// `IDIV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `IDIV r/m8` | `F6 /7` | `8086+`
	/// `IDIV r/m16` | `o16 F7 /7` | `8086+`
	/// `IDIV r/m32` | `o32 F7 /7` | `386+`
	/// `IDIV r/m64` | `o64 F7 /7` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn idiv<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmIdiv<T>,
	{
		<Self as CodeAsmIdiv<T>>::idiv(self, op0)
	}

	/// `IMUL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `IMUL r/m8` | `F6 /5` | `8086+`
	/// `IMUL r/m16` | `o16 F7 /5` | `8086+`
	/// `IMUL r/m32` | `o32 F7 /5` | `386+`
	/// `IMUL r/m64` | `o64 F7 /5` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn imul<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmImul<T>,
	{
		<Self as CodeAsmImul<T>>::imul(self, op0)
	}

	/// `IMUL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `IMUL r16, r/m16` | `o16 0F AF /r` | `386+`
	/// `IMUL r32, r/m32` | `o32 0F AF /r` | `386+`
	/// `IMUL r64, r/m64` | `o64 0F AF /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn imul_2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmImul2<T, U>,
	{
		<Self as CodeAsmImul2<T, U>>::imul_2(self, op0, op1)
	}

	/// `IMUL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `IMUL r16, r/m16, imm16` | `o16 69 /r iw` | `186+`
	/// `IMUL r32, r/m32, imm32` | `o32 69 /r id` | `386+`
	/// `IMUL r64, r/m64, imm32` | `o64 69 /r id` | `X64`
	/// `IMUL r16, r/m16, imm8` | `o16 6B /r ib` | `186+`
	/// `IMUL r32, r/m32, imm8` | `o32 6B /r ib` | `386+`
	/// `IMUL r64, r/m64, imm8` | `o64 6B /r ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn imul_3<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmImul3<T, U, V>,
	{
		<Self as CodeAsmImul3<T, U, V>>::imul_3(self, op0, op1, op2)
	}

	/// `IN` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `IN AL, imm8` | `E4 ib` | `8086+`
	/// `IN AX, imm8` | `o16 E5 ib` | `8086+`
	/// `IN EAX, imm8` | `o32 E5 ib` | `386+`
	/// `IN AL, DX` | `EC` | `8086+`
	/// `IN AX, DX` | `o16 ED` | `8086+`
	/// `IN EAX, DX` | `o32 ED` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn in_<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmIn<T, U>,
	{
		<Self as CodeAsmIn<T, U>>::in_(self, op0, op1)
	}

	/// `INC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INC r16` | `o16 40+rw` | `8086+`
	/// `INC r32` | `o32 40+rd` | `386+`
	/// `INC r/m8` | `FE /0` | `8086+`
	/// `INC r/m16` | `o16 FF /0` | `8086+`
	/// `INC r/m32` | `o32 FF /0` | `386+`
	/// `INC r/m64` | `o64 FF /0` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn inc<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmInc<T>,
	{
		<Self as CodeAsmInc<T>>::inc(self, op0)
	}

	/// `INCSSPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INCSSPD r32` | `F3 0F AE /5` | `CET_SS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn incsspd<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmIncsspd<T>,
	{
		<Self as CodeAsmIncsspd<T>>::incsspd(self, op0)
	}

	/// `INCSSPQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INCSSPQ r64` | `F3 o64 0F AE /5` | `CET_SS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn incsspq<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmIncsspq<T>,
	{
		<Self as CodeAsmIncsspq<T>>::incsspq(self, op0)
	}

	/// `INSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INSB` | `6C` | `186+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn insb(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmInsb,
	{
		<Self as CodeAsmInsb>::insb(self)
	}

	/// `INSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INSD` | `o32 6D` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn insd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmInsd,
	{
		<Self as CodeAsmInsd>::insd(self)
	}

	/// `INSERTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INSERTPS xmm1, xmm2/m32, imm8` | `66 0F 3A 21 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn insertps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmInsertps<T, U, V>,
	{
		<Self as CodeAsmInsertps<T, U, V>>::insertps(self, op0, op1, op2)
	}

	/// `INSERTQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INSERTQ xmm1, xmm2` | `F2 0F 79 /r` | `SSE4A`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn insertq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmInsertq<T, U>,
	{
		<Self as CodeAsmInsertq<T, U>>::insertq(self, op0, op1)
	}

	/// `INSERTQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INSERTQ xmm1, xmm2, imm8, imm8` | `F2 0F 78 /r ib ib` | `SSE4A`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn insertq_4<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmInsertq4<T, U, V, W>,
	{
		<Self as CodeAsmInsertq4<T, U, V, W>>::insertq_4(self, op0, op1, op2, op3)
	}

	/// `INSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INSW` | `o16 6D` | `186+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn insw(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmInsw,
	{
		<Self as CodeAsmInsw>::insw(self)
	}

	/// `INT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INT imm8` | `CD ib` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn int<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmInt<T>,
	{
		<Self as CodeAsmInt<T>>::int(self, op0)
	}

	/// `INT1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INT1` | `F1` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn int1(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmInt1,
	{
		<Self as CodeAsmInt1>::int1(self)
	}

	/// `INT3` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INT3` | `CC` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn int3(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmInt3,
	{
		<Self as CodeAsmInt3>::int3(self)
	}

	/// `INTO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INTO` | `CE` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn into(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmInto,
	{
		<Self as CodeAsmInto>::into(self)
	}

	/// `INVD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INVD` | `0F 08` | `486+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn invd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmInvd,
	{
		<Self as CodeAsmInvd>::invd(self)
	}

	/// `INVEPT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INVEPT r32, m128` | `66 0F 38 80 /r` | `VMX IA32_VMX_EPT_VPID_CAP[bit 20]`
	/// `INVEPT r64, m128` | `66 0F 38 80 /r` | `VMX IA32_VMX_EPT_VPID_CAP[bit 20]`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn invept<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmInvept<T, U>,
	{
		<Self as CodeAsmInvept<T, U>>::invept(self, op0, op1)
	}

	/// `INVLPG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INVLPG m` | `0F 01 /7` | `486+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn invlpg<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmInvlpg<T>,
	{
		<Self as CodeAsmInvlpg<T>>::invlpg(self, op0)
	}

	/// `INVLPGA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INVLPGA` | `a16 0F 01 DF` | `SVM`
	/// `INVLPGA` | `a32 0F 01 DF` | `SVM`
	/// `INVLPGA` | `a64 0F 01 DF` | `SVM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn invlpga(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmInvlpga,
	{
		<Self as CodeAsmInvlpga>::invlpga(self)
	}

	/// `INVLPGB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INVLPGB` | `a16 NP 0F 01 FE` | `INVLPGB`
	/// `INVLPGB` | `a32 NP 0F 01 FE` | `INVLPGB`
	/// `INVLPGB` | `a64 NP 0F 01 FE` | `INVLPGB`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn invlpgb(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmInvlpgb,
	{
		<Self as CodeAsmInvlpgb>::invlpgb(self)
	}

	/// `INVPCID` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INVPCID r32, m128` | `66 0F 38 82 /r` | `INVPCID`
	/// `INVPCID r64, m128` | `66 0F 38 82 /r` | `INVPCID`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn invpcid<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmInvpcid<T, U>,
	{
		<Self as CodeAsmInvpcid<T, U>>::invpcid(self, op0, op1)
	}

	/// `INVVPID` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `INVVPID r32, m128` | `66 0F 38 81 /r` | `VMX IA32_VMX_EPT_VPID_CAP[bit 32]`
	/// `INVVPID r64, m128` | `66 0F 38 81 /r` | `VMX IA32_VMX_EPT_VPID_CAP[bit 32]`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn invvpid<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmInvvpid<T, U>,
	{
		<Self as CodeAsmInvvpid<T, U>>::invvpid(self, op0, op1)
	}

	/// `IRET` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `IRET` | `o16 CF` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn iret(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmIret,
	{
		<Self as CodeAsmIret>::iret(self)
	}

	/// `IRETD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `IRETD` | `o32 CF` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn iretd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmIretd,
	{
		<Self as CodeAsmIretd>::iretd(self)
	}

	/// `IRETQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `IRETQ` | `o64 CF` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn iretq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmIretq,
	{
		<Self as CodeAsmIretq>::iretq(self)
	}

	/// `JA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JA rel8` | `o16 77 cb` | `8086+`
	/// `JA rel8` | `o32 77 cb` | `386+`
	/// `JA rel8` | `o64 77 cb` | `X64`
	/// `JA rel16` | `o16 0F 87 cw` | `386+`
	/// `JA rel32` | `o32 0F 87 cd` | `386+`
	/// `JA rel32` | `o64 0F 87 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn ja<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJa<T>,
	{
		<Self as CodeAsmJa<T>>::ja(self, op0)
	}

	/// `JAE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JAE rel8` | `o16 73 cb` | `8086+`
	/// `JAE rel8` | `o32 73 cb` | `386+`
	/// `JAE rel8` | `o64 73 cb` | `X64`
	/// `JAE rel16` | `o16 0F 83 cw` | `386+`
	/// `JAE rel32` | `o32 0F 83 cd` | `386+`
	/// `JAE rel32` | `o64 0F 83 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jae<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJae<T>,
	{
		<Self as CodeAsmJae<T>>::jae(self, op0)
	}

	/// `JB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JB rel8` | `o16 72 cb` | `8086+`
	/// `JB rel8` | `o32 72 cb` | `386+`
	/// `JB rel8` | `o64 72 cb` | `X64`
	/// `JB rel16` | `o16 0F 82 cw` | `386+`
	/// `JB rel32` | `o32 0F 82 cd` | `386+`
	/// `JB rel32` | `o64 0F 82 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jb<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJb<T>,
	{
		<Self as CodeAsmJb<T>>::jb(self, op0)
	}

	/// `JBE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JBE rel8` | `o16 76 cb` | `8086+`
	/// `JBE rel8` | `o32 76 cb` | `386+`
	/// `JBE rel8` | `o64 76 cb` | `X64`
	/// `JBE rel16` | `o16 0F 86 cw` | `386+`
	/// `JBE rel32` | `o32 0F 86 cd` | `386+`
	/// `JBE rel32` | `o64 0F 86 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jbe<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJbe<T>,
	{
		<Self as CodeAsmJbe<T>>::jbe(self, op0)
	}

	/// `JC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JB rel8` | `o16 72 cb` | `8086+`
	/// `JB rel8` | `o32 72 cb` | `386+`
	/// `JB rel8` | `o64 72 cb` | `X64`
	/// `JB rel16` | `o16 0F 82 cw` | `386+`
	/// `JB rel32` | `o32 0F 82 cd` | `386+`
	/// `JB rel32` | `o64 0F 82 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jc<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJc<T>,
	{
		<Self as CodeAsmJc<T>>::jc(self, op0)
	}

	/// `JCXZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JCXZ rel8` | `a16 o16 E3 cb` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jcxz<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJcxz<T>,
	{
		<Self as CodeAsmJcxz<T>>::jcxz(self, op0)
	}

	/// `JE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JE rel8` | `o16 74 cb` | `8086+`
	/// `JE rel8` | `o32 74 cb` | `386+`
	/// `JE rel8` | `o64 74 cb` | `X64`
	/// `JE rel16` | `o16 0F 84 cw` | `386+`
	/// `JE rel32` | `o32 0F 84 cd` | `386+`
	/// `JE rel32` | `o64 0F 84 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn je<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJe<T>,
	{
		<Self as CodeAsmJe<T>>::je(self, op0)
	}

	/// `JECXZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JECXZ rel8` | `a32 o32 E3 cb` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jecxz<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJecxz<T>,
	{
		<Self as CodeAsmJecxz<T>>::jecxz(self, op0)
	}

	/// `JG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JG rel8` | `o16 7F cb` | `8086+`
	/// `JG rel8` | `o32 7F cb` | `386+`
	/// `JG rel8` | `o64 7F cb` | `X64`
	/// `JG rel16` | `o16 0F 8F cw` | `386+`
	/// `JG rel32` | `o32 0F 8F cd` | `386+`
	/// `JG rel32` | `o64 0F 8F cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jg<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJg<T>,
	{
		<Self as CodeAsmJg<T>>::jg(self, op0)
	}

	/// `JGE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JGE rel8` | `o16 7D cb` | `8086+`
	/// `JGE rel8` | `o32 7D cb` | `386+`
	/// `JGE rel8` | `o64 7D cb` | `X64`
	/// `JGE rel16` | `o16 0F 8D cw` | `386+`
	/// `JGE rel32` | `o32 0F 8D cd` | `386+`
	/// `JGE rel32` | `o64 0F 8D cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jge<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJge<T>,
	{
		<Self as CodeAsmJge<T>>::jge(self, op0)
	}

	/// `JL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JL rel8` | `o16 7C cb` | `8086+`
	/// `JL rel8` | `o32 7C cb` | `386+`
	/// `JL rel8` | `o64 7C cb` | `X64`
	/// `JL rel16` | `o16 0F 8C cw` | `386+`
	/// `JL rel32` | `o32 0F 8C cd` | `386+`
	/// `JL rel32` | `o64 0F 8C cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jl<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJl<T>,
	{
		<Self as CodeAsmJl<T>>::jl(self, op0)
	}

	/// `JLE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JLE rel8` | `o16 7E cb` | `8086+`
	/// `JLE rel8` | `o32 7E cb` | `386+`
	/// `JLE rel8` | `o64 7E cb` | `X64`
	/// `JLE rel16` | `o16 0F 8E cw` | `386+`
	/// `JLE rel32` | `o32 0F 8E cd` | `386+`
	/// `JLE rel32` | `o64 0F 8E cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jle<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJle<T>,
	{
		<Self as CodeAsmJle<T>>::jle(self, op0)
	}

	/// `JMP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JMP rel16` | `o16 E9 cw` | `8086+`
	/// `JMP rel32` | `o32 E9 cd` | `386+`
	/// `JMP rel32` | `o64 E9 cd` | `X64`
	/// `JMP rel8` | `o16 EB cb` | `8086+`
	/// `JMP rel8` | `o32 EB cb` | `386+`
	/// `JMP rel8` | `o64 EB cb` | `X64`
	/// `JMP r/m16` | `o16 FF /4` | `8086+`
	/// `JMP r/m32` | `o32 FF /4` | `386+`
	/// `JMP r/m64` | `o64 FF /4` | `X64`
	/// `JMP m16:16` | `o16 FF /5` | `8086+`
	/// `JMP m16:32` | `o32 FF /5` | `386+`
	/// `JMP m16:64` | `o64 FF /5` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jmp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJmp<T>,
	{
		<Self as CodeAsmJmp<T>>::jmp(self, op0)
	}

	/// `JMPE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JMPE r/m16` | `o16 0F 00 /6` | `IA-64`
	/// `JMPE r/m32` | `o32 0F 00 /6` | `IA-64`
	/// `JMPE disp16` | `o16 0F B8 cw` | `IA-64`
	/// `JMPE disp32` | `o32 0F B8 cd` | `IA-64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jmpe<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJmpe<T>,
	{
		<Self as CodeAsmJmpe<T>>::jmpe(self, op0)
	}

	/// `JNA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JBE rel8` | `o16 76 cb` | `8086+`
	/// `JBE rel8` | `o32 76 cb` | `386+`
	/// `JBE rel8` | `o64 76 cb` | `X64`
	/// `JBE rel16` | `o16 0F 86 cw` | `386+`
	/// `JBE rel32` | `o32 0F 86 cd` | `386+`
	/// `JBE rel32` | `o64 0F 86 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jna<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJna<T>,
	{
		<Self as CodeAsmJna<T>>::jna(self, op0)
	}

	/// `JNAE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JB rel8` | `o16 72 cb` | `8086+`
	/// `JB rel8` | `o32 72 cb` | `386+`
	/// `JB rel8` | `o64 72 cb` | `X64`
	/// `JB rel16` | `o16 0F 82 cw` | `386+`
	/// `JB rel32` | `o32 0F 82 cd` | `386+`
	/// `JB rel32` | `o64 0F 82 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jnae<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJnae<T>,
	{
		<Self as CodeAsmJnae<T>>::jnae(self, op0)
	}

	/// `JNB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JAE rel8` | `o16 73 cb` | `8086+`
	/// `JAE rel8` | `o32 73 cb` | `386+`
	/// `JAE rel8` | `o64 73 cb` | `X64`
	/// `JAE rel16` | `o16 0F 83 cw` | `386+`
	/// `JAE rel32` | `o32 0F 83 cd` | `386+`
	/// `JAE rel32` | `o64 0F 83 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jnb<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJnb<T>,
	{
		<Self as CodeAsmJnb<T>>::jnb(self, op0)
	}

	/// `JNBE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JA rel8` | `o16 77 cb` | `8086+`
	/// `JA rel8` | `o32 77 cb` | `386+`
	/// `JA rel8` | `o64 77 cb` | `X64`
	/// `JA rel16` | `o16 0F 87 cw` | `386+`
	/// `JA rel32` | `o32 0F 87 cd` | `386+`
	/// `JA rel32` | `o64 0F 87 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jnbe<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJnbe<T>,
	{
		<Self as CodeAsmJnbe<T>>::jnbe(self, op0)
	}

	/// `JNC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JAE rel8` | `o16 73 cb` | `8086+`
	/// `JAE rel8` | `o32 73 cb` | `386+`
	/// `JAE rel8` | `o64 73 cb` | `X64`
	/// `JAE rel16` | `o16 0F 83 cw` | `386+`
	/// `JAE rel32` | `o32 0F 83 cd` | `386+`
	/// `JAE rel32` | `o64 0F 83 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jnc<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJnc<T>,
	{
		<Self as CodeAsmJnc<T>>::jnc(self, op0)
	}

	/// `JNE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JNE rel8` | `o16 75 cb` | `8086+`
	/// `JNE rel8` | `o32 75 cb` | `386+`
	/// `JNE rel8` | `o64 75 cb` | `X64`
	/// `JNE rel16` | `o16 0F 85 cw` | `386+`
	/// `JNE rel32` | `o32 0F 85 cd` | `386+`
	/// `JNE rel32` | `o64 0F 85 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jne<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJne<T>,
	{
		<Self as CodeAsmJne<T>>::jne(self, op0)
	}

	/// `JNG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JLE rel8` | `o16 7E cb` | `8086+`
	/// `JLE rel8` | `o32 7E cb` | `386+`
	/// `JLE rel8` | `o64 7E cb` | `X64`
	/// `JLE rel16` | `o16 0F 8E cw` | `386+`
	/// `JLE rel32` | `o32 0F 8E cd` | `386+`
	/// `JLE rel32` | `o64 0F 8E cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jng<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJng<T>,
	{
		<Self as CodeAsmJng<T>>::jng(self, op0)
	}

	/// `JNGE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JL rel8` | `o16 7C cb` | `8086+`
	/// `JL rel8` | `o32 7C cb` | `386+`
	/// `JL rel8` | `o64 7C cb` | `X64`
	/// `JL rel16` | `o16 0F 8C cw` | `386+`
	/// `JL rel32` | `o32 0F 8C cd` | `386+`
	/// `JL rel32` | `o64 0F 8C cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jnge<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJnge<T>,
	{
		<Self as CodeAsmJnge<T>>::jnge(self, op0)
	}

	/// `JNL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JGE rel8` | `o16 7D cb` | `8086+`
	/// `JGE rel8` | `o32 7D cb` | `386+`
	/// `JGE rel8` | `o64 7D cb` | `X64`
	/// `JGE rel16` | `o16 0F 8D cw` | `386+`
	/// `JGE rel32` | `o32 0F 8D cd` | `386+`
	/// `JGE rel32` | `o64 0F 8D cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jnl<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJnl<T>,
	{
		<Self as CodeAsmJnl<T>>::jnl(self, op0)
	}

	/// `JNLE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JG rel8` | `o16 7F cb` | `8086+`
	/// `JG rel8` | `o32 7F cb` | `386+`
	/// `JG rel8` | `o64 7F cb` | `X64`
	/// `JG rel16` | `o16 0F 8F cw` | `386+`
	/// `JG rel32` | `o32 0F 8F cd` | `386+`
	/// `JG rel32` | `o64 0F 8F cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jnle<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJnle<T>,
	{
		<Self as CodeAsmJnle<T>>::jnle(self, op0)
	}

	/// `JNO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JNO rel8` | `o16 71 cb` | `8086+`
	/// `JNO rel8` | `o32 71 cb` | `386+`
	/// `JNO rel8` | `o64 71 cb` | `X64`
	/// `JNO rel16` | `o16 0F 81 cw` | `386+`
	/// `JNO rel32` | `o32 0F 81 cd` | `386+`
	/// `JNO rel32` | `o64 0F 81 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jno<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJno<T>,
	{
		<Self as CodeAsmJno<T>>::jno(self, op0)
	}

	/// `JNP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JNP rel8` | `o16 7B cb` | `8086+`
	/// `JNP rel8` | `o32 7B cb` | `386+`
	/// `JNP rel8` | `o64 7B cb` | `X64`
	/// `JNP rel16` | `o16 0F 8B cw` | `386+`
	/// `JNP rel32` | `o32 0F 8B cd` | `386+`
	/// `JNP rel32` | `o64 0F 8B cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jnp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJnp<T>,
	{
		<Self as CodeAsmJnp<T>>::jnp(self, op0)
	}

	/// `JNS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JNS rel8` | `o16 79 cb` | `8086+`
	/// `JNS rel8` | `o32 79 cb` | `386+`
	/// `JNS rel8` | `o64 79 cb` | `X64`
	/// `JNS rel16` | `o16 0F 89 cw` | `386+`
	/// `JNS rel32` | `o32 0F 89 cd` | `386+`
	/// `JNS rel32` | `o64 0F 89 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jns<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJns<T>,
	{
		<Self as CodeAsmJns<T>>::jns(self, op0)
	}

	/// `JNZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JNE rel8` | `o16 75 cb` | `8086+`
	/// `JNE rel8` | `o32 75 cb` | `386+`
	/// `JNE rel8` | `o64 75 cb` | `X64`
	/// `JNE rel16` | `o16 0F 85 cw` | `386+`
	/// `JNE rel32` | `o32 0F 85 cd` | `386+`
	/// `JNE rel32` | `o64 0F 85 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jnz<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJnz<T>,
	{
		<Self as CodeAsmJnz<T>>::jnz(self, op0)
	}

	/// `JO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JO rel8` | `o16 70 cb` | `8086+`
	/// `JO rel8` | `o32 70 cb` | `386+`
	/// `JO rel8` | `o64 70 cb` | `X64`
	/// `JO rel16` | `o16 0F 80 cw` | `386+`
	/// `JO rel32` | `o32 0F 80 cd` | `386+`
	/// `JO rel32` | `o64 0F 80 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jo<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJo<T>,
	{
		<Self as CodeAsmJo<T>>::jo(self, op0)
	}

	/// `JP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JP rel8` | `o16 7A cb` | `8086+`
	/// `JP rel8` | `o32 7A cb` | `386+`
	/// `JP rel8` | `o64 7A cb` | `X64`
	/// `JP rel16` | `o16 0F 8A cw` | `386+`
	/// `JP rel32` | `o32 0F 8A cd` | `386+`
	/// `JP rel32` | `o64 0F 8A cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJp<T>,
	{
		<Self as CodeAsmJp<T>>::jp(self, op0)
	}

	/// `JPE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JP rel8` | `o16 7A cb` | `8086+`
	/// `JP rel8` | `o32 7A cb` | `386+`
	/// `JP rel8` | `o64 7A cb` | `X64`
	/// `JP rel16` | `o16 0F 8A cw` | `386+`
	/// `JP rel32` | `o32 0F 8A cd` | `386+`
	/// `JP rel32` | `o64 0F 8A cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jpe<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJpe<T>,
	{
		<Self as CodeAsmJpe<T>>::jpe(self, op0)
	}

	/// `JPO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JNP rel8` | `o16 7B cb` | `8086+`
	/// `JNP rel8` | `o32 7B cb` | `386+`
	/// `JNP rel8` | `o64 7B cb` | `X64`
	/// `JNP rel16` | `o16 0F 8B cw` | `386+`
	/// `JNP rel32` | `o32 0F 8B cd` | `386+`
	/// `JNP rel32` | `o64 0F 8B cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jpo<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJpo<T>,
	{
		<Self as CodeAsmJpo<T>>::jpo(self, op0)
	}

	/// `JRCXZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JRCXZ rel8` | `a64 o64 E3 cb` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jrcxz<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJrcxz<T>,
	{
		<Self as CodeAsmJrcxz<T>>::jrcxz(self, op0)
	}

	/// `JS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JS rel8` | `o16 78 cb` | `8086+`
	/// `JS rel8` | `o32 78 cb` | `386+`
	/// `JS rel8` | `o64 78 cb` | `X64`
	/// `JS rel16` | `o16 0F 88 cw` | `386+`
	/// `JS rel32` | `o32 0F 88 cd` | `386+`
	/// `JS rel32` | `o64 0F 88 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn js<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJs<T>,
	{
		<Self as CodeAsmJs<T>>::js(self, op0)
	}

	/// `JZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `JE rel8` | `o16 74 cb` | `8086+`
	/// `JE rel8` | `o32 74 cb` | `386+`
	/// `JE rel8` | `o64 74 cb` | `X64`
	/// `JE rel16` | `o16 0F 84 cw` | `386+`
	/// `JE rel32` | `o32 0F 84 cd` | `386+`
	/// `JE rel32` | `o64 0F 84 cd` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn jz<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmJz<T>,
	{
		<Self as CodeAsmJz<T>>::jz(self, op0)
	}

	/// `KADDB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KADDB k1, k2, k3` | `VEX.L1.66.0F.W0 4A /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kaddb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKaddb<T, U, V>,
	{
		<Self as CodeAsmKaddb<T, U, V>>::kaddb(self, op0, op1, op2)
	}

	/// `KADDD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KADDD k1, k2, k3` | `VEX.L1.66.0F.W1 4A /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kaddd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKaddd<T, U, V>,
	{
		<Self as CodeAsmKaddd<T, U, V>>::kaddd(self, op0, op1, op2)
	}

	/// `KADDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KADDQ k1, k2, k3` | `VEX.L1.0F.W1 4A /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kaddq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKaddq<T, U, V>,
	{
		<Self as CodeAsmKaddq<T, U, V>>::kaddq(self, op0, op1, op2)
	}

	/// `KADDW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KADDW k1, k2, k3` | `VEX.L1.0F.W0 4A /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kaddw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKaddw<T, U, V>,
	{
		<Self as CodeAsmKaddw<T, U, V>>::kaddw(self, op0, op1, op2)
	}

	/// `KANDB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KANDB k1, k2, k3` | `VEX.L1.66.0F.W0 41 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kandb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKandb<T, U, V>,
	{
		<Self as CodeAsmKandb<T, U, V>>::kandb(self, op0, op1, op2)
	}

	/// `KANDD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KANDD k1, k2, k3` | `VEX.L1.66.0F.W1 41 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kandd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKandd<T, U, V>,
	{
		<Self as CodeAsmKandd<T, U, V>>::kandd(self, op0, op1, op2)
	}

	/// `KANDNB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KANDNB k1, k2, k3` | `VEX.L1.66.0F.W0 42 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kandnb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKandnb<T, U, V>,
	{
		<Self as CodeAsmKandnb<T, U, V>>::kandnb(self, op0, op1, op2)
	}

	/// `KANDND` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KANDND k1, k2, k3` | `VEX.L1.66.0F.W1 42 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kandnd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKandnd<T, U, V>,
	{
		<Self as CodeAsmKandnd<T, U, V>>::kandnd(self, op0, op1, op2)
	}

	/// `KANDNQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KANDNQ k1, k2, k3` | `VEX.L1.0F.W1 42 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kandnq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKandnq<T, U, V>,
	{
		<Self as CodeAsmKandnq<T, U, V>>::kandnq(self, op0, op1, op2)
	}

	/// `KANDNW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KANDNW k1, k2, k3` | `VEX.L1.0F.W0 42 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kandnw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKandnw<T, U, V>,
	{
		<Self as CodeAsmKandnw<T, U, V>>::kandnw(self, op0, op1, op2)
	}

	/// `KANDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KANDQ k1, k2, k3` | `VEX.L1.0F.W1 41 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kandq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKandq<T, U, V>,
	{
		<Self as CodeAsmKandq<T, U, V>>::kandq(self, op0, op1, op2)
	}

	/// `KANDW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KANDW k1, k2, k3` | `VEX.L1.0F.W0 41 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kandw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKandw<T, U, V>,
	{
		<Self as CodeAsmKandw<T, U, V>>::kandw(self, op0, op1, op2)
	}

	/// `KMOVB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KMOVB k1, k2/m8` | `VEX.L0.66.0F.W0 90 /r` | `AVX512DQ`
	/// `KMOVB m8, k1` | `VEX.L0.66.0F.W0 91 /r` | `AVX512DQ`
	/// `KMOVB k1, r32` | `VEX.L0.66.0F.W0 92 /r` | `AVX512DQ`
	/// `KMOVB r32, k1` | `VEX.L0.66.0F.W0 93 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn kmovb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKmovb<T, U>,
	{
		<Self as CodeAsmKmovb<T, U>>::kmovb(self, op0, op1)
	}

	/// `KMOVD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KMOVD k1, k2/m32` | `VEX.L0.66.0F.W1 90 /r` | `AVX512BW`
	/// `KMOVD m32, k1` | `VEX.L0.66.0F.W1 91 /r` | `AVX512BW`
	/// `KMOVD k1, r32` | `VEX.L0.F2.0F.W0 92 /r` | `AVX512BW`
	/// `KMOVD r32, k1` | `VEX.L0.F2.0F.W0 93 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn kmovd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKmovd<T, U>,
	{
		<Self as CodeAsmKmovd<T, U>>::kmovd(self, op0, op1)
	}

	/// `KMOVQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KMOVQ k1, k2/m64` | `VEX.L0.0F.W1 90 /r` | `AVX512BW`
	/// `KMOVQ m64, k1` | `VEX.L0.0F.W1 91 /r` | `AVX512BW`
	/// `KMOVQ k1, r64` | `VEX.L0.F2.0F.W1 92 /r` | `AVX512BW`
	/// `KMOVQ r64, k1` | `VEX.L0.F2.0F.W1 93 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn kmovq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKmovq<T, U>,
	{
		<Self as CodeAsmKmovq<T, U>>::kmovq(self, op0, op1)
	}

	/// `KMOVW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KMOVW k1, k2/m16` | `VEX.L0.0F.W0 90 /r` | `AVX512F`
	/// `KMOVW m16, k1` | `VEX.L0.0F.W0 91 /r` | `AVX512F`
	/// `KMOVW k1, r32` | `VEX.L0.0F.W0 92 /r` | `AVX512F`
	/// `KMOVW r32, k1` | `VEX.L0.0F.W0 93 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn kmovw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKmovw<T, U>,
	{
		<Self as CodeAsmKmovw<T, U>>::kmovw(self, op0, op1)
	}

	/// `KNOTB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KNOTB k1, k2` | `VEX.L0.66.0F.W0 44 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn knotb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKnotb<T, U>,
	{
		<Self as CodeAsmKnotb<T, U>>::knotb(self, op0, op1)
	}

	/// `KNOTD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KNOTD k1, k2` | `VEX.L0.66.0F.W1 44 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn knotd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKnotd<T, U>,
	{
		<Self as CodeAsmKnotd<T, U>>::knotd(self, op0, op1)
	}

	/// `KNOTQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KNOTQ k1, k2` | `VEX.L0.0F.W1 44 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn knotq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKnotq<T, U>,
	{
		<Self as CodeAsmKnotq<T, U>>::knotq(self, op0, op1)
	}

	/// `KNOTW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KNOTW k1, k2` | `VEX.L0.0F.W0 44 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn knotw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKnotw<T, U>,
	{
		<Self as CodeAsmKnotw<T, U>>::knotw(self, op0, op1)
	}

	/// `KORB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KORB k1, k2, k3` | `VEX.L1.66.0F.W0 45 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn korb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKorb<T, U, V>,
	{
		<Self as CodeAsmKorb<T, U, V>>::korb(self, op0, op1, op2)
	}

	/// `KORD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KORD k1, k2, k3` | `VEX.L1.66.0F.W1 45 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kord<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKord<T, U, V>,
	{
		<Self as CodeAsmKord<T, U, V>>::kord(self, op0, op1, op2)
	}

	/// `KORQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KORQ k1, k2, k3` | `VEX.L1.0F.W1 45 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn korq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKorq<T, U, V>,
	{
		<Self as CodeAsmKorq<T, U, V>>::korq(self, op0, op1, op2)
	}

	/// `KORTESTB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KORTESTB k1, k2` | `VEX.L0.66.0F.W0 98 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn kortestb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKortestb<T, U>,
	{
		<Self as CodeAsmKortestb<T, U>>::kortestb(self, op0, op1)
	}

	/// `KORTESTD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KORTESTD k1, k2` | `VEX.L0.66.0F.W1 98 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn kortestd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKortestd<T, U>,
	{
		<Self as CodeAsmKortestd<T, U>>::kortestd(self, op0, op1)
	}

	/// `KORTESTQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KORTESTQ k1, k2` | `VEX.L0.0F.W1 98 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn kortestq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKortestq<T, U>,
	{
		<Self as CodeAsmKortestq<T, U>>::kortestq(self, op0, op1)
	}

	/// `KORTESTW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KORTESTW k1, k2` | `VEX.L0.0F.W0 98 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn kortestw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKortestw<T, U>,
	{
		<Self as CodeAsmKortestw<T, U>>::kortestw(self, op0, op1)
	}

	/// `KORW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KORW k1, k2, k3` | `VEX.L1.0F.W0 45 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn korw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKorw<T, U, V>,
	{
		<Self as CodeAsmKorw<T, U, V>>::korw(self, op0, op1, op2)
	}

	/// `KSHIFTLB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KSHIFTLB k1, k2, imm8` | `VEX.L0.66.0F3A.W0 32 /r ib` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kshiftlb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKshiftlb<T, U, V>,
	{
		<Self as CodeAsmKshiftlb<T, U, V>>::kshiftlb(self, op0, op1, op2)
	}

	/// `KSHIFTLD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KSHIFTLD k1, k2, imm8` | `VEX.L0.66.0F3A.W0 33 /r ib` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kshiftld<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKshiftld<T, U, V>,
	{
		<Self as CodeAsmKshiftld<T, U, V>>::kshiftld(self, op0, op1, op2)
	}

	/// `KSHIFTLQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KSHIFTLQ k1, k2, imm8` | `VEX.L0.66.0F3A.W1 33 /r ib` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kshiftlq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKshiftlq<T, U, V>,
	{
		<Self as CodeAsmKshiftlq<T, U, V>>::kshiftlq(self, op0, op1, op2)
	}

	/// `KSHIFTLW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KSHIFTLW k1, k2, imm8` | `VEX.L0.66.0F3A.W1 32 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kshiftlw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKshiftlw<T, U, V>,
	{
		<Self as CodeAsmKshiftlw<T, U, V>>::kshiftlw(self, op0, op1, op2)
	}

	/// `KSHIFTRB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KSHIFTRB k1, k2, imm8` | `VEX.L0.66.0F3A.W0 30 /r ib` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kshiftrb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKshiftrb<T, U, V>,
	{
		<Self as CodeAsmKshiftrb<T, U, V>>::kshiftrb(self, op0, op1, op2)
	}

	/// `KSHIFTRD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KSHIFTRD k1, k2, imm8` | `VEX.L0.66.0F3A.W0 31 /r ib` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kshiftrd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKshiftrd<T, U, V>,
	{
		<Self as CodeAsmKshiftrd<T, U, V>>::kshiftrd(self, op0, op1, op2)
	}

	/// `KSHIFTRQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KSHIFTRQ k1, k2, imm8` | `VEX.L0.66.0F3A.W1 31 /r ib` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kshiftrq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKshiftrq<T, U, V>,
	{
		<Self as CodeAsmKshiftrq<T, U, V>>::kshiftrq(self, op0, op1, op2)
	}

	/// `KSHIFTRW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KSHIFTRW k1, k2, imm8` | `VEX.L0.66.0F3A.W1 30 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kshiftrw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKshiftrw<T, U, V>,
	{
		<Self as CodeAsmKshiftrw<T, U, V>>::kshiftrw(self, op0, op1, op2)
	}

	/// `KTESTB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KTESTB k1, k2` | `VEX.L0.66.0F.W0 99 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn ktestb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKtestb<T, U>,
	{
		<Self as CodeAsmKtestb<T, U>>::ktestb(self, op0, op1)
	}

	/// `KTESTD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KTESTD k1, k2` | `VEX.L0.66.0F.W1 99 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn ktestd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKtestd<T, U>,
	{
		<Self as CodeAsmKtestd<T, U>>::ktestd(self, op0, op1)
	}

	/// `KTESTQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KTESTQ k1, k2` | `VEX.L0.0F.W1 99 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn ktestq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKtestq<T, U>,
	{
		<Self as CodeAsmKtestq<T, U>>::ktestq(self, op0, op1)
	}

	/// `KTESTW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KTESTW k1, k2` | `VEX.L0.0F.W0 99 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn ktestw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmKtestw<T, U>,
	{
		<Self as CodeAsmKtestw<T, U>>::ktestw(self, op0, op1)
	}

	/// `KUNPCKBW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KUNPCKBW k1, k2, k3` | `VEX.L1.66.0F.W0 4B /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kunpckbw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKunpckbw<T, U, V>,
	{
		<Self as CodeAsmKunpckbw<T, U, V>>::kunpckbw(self, op0, op1, op2)
	}

	/// `KUNPCKDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KUNPCKDQ k1, k2, k3` | `VEX.L1.0F.W1 4B /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kunpckdq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKunpckdq<T, U, V>,
	{
		<Self as CodeAsmKunpckdq<T, U, V>>::kunpckdq(self, op0, op1, op2)
	}

	/// `KUNPCKWD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KUNPCKWD k1, k2, k3` | `VEX.L1.0F.W0 4B /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kunpckwd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKunpckwd<T, U, V>,
	{
		<Self as CodeAsmKunpckwd<T, U, V>>::kunpckwd(self, op0, op1, op2)
	}

	/// `KXNORB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KXNORB k1, k2, k3` | `VEX.L1.66.0F.W0 46 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kxnorb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKxnorb<T, U, V>,
	{
		<Self as CodeAsmKxnorb<T, U, V>>::kxnorb(self, op0, op1, op2)
	}

	/// `KXNORD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KXNORD k1, k2, k3` | `VEX.L1.66.0F.W1 46 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kxnord<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKxnord<T, U, V>,
	{
		<Self as CodeAsmKxnord<T, U, V>>::kxnord(self, op0, op1, op2)
	}

	/// `KXNORQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KXNORQ k1, k2, k3` | `VEX.L1.0F.W1 46 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kxnorq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKxnorq<T, U, V>,
	{
		<Self as CodeAsmKxnorq<T, U, V>>::kxnorq(self, op0, op1, op2)
	}

	/// `KXNORW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KXNORW k1, k2, k3` | `VEX.L1.0F.W0 46 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kxnorw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKxnorw<T, U, V>,
	{
		<Self as CodeAsmKxnorw<T, U, V>>::kxnorw(self, op0, op1, op2)
	}

	/// `KXORB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KXORB k1, k2, k3` | `VEX.L1.66.0F.W0 47 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kxorb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKxorb<T, U, V>,
	{
		<Self as CodeAsmKxorb<T, U, V>>::kxorb(self, op0, op1, op2)
	}

	/// `KXORD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KXORD k1, k2, k3` | `VEX.L1.66.0F.W1 47 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kxord<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKxord<T, U, V>,
	{
		<Self as CodeAsmKxord<T, U, V>>::kxord(self, op0, op1, op2)
	}

	/// `KXORQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KXORQ k1, k2, k3` | `VEX.L1.0F.W1 47 /r` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kxorq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKxorq<T, U, V>,
	{
		<Self as CodeAsmKxorq<T, U, V>>::kxorq(self, op0, op1, op2)
	}

	/// `KXORW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `KXORW k1, k2, k3` | `VEX.L1.0F.W0 47 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn kxorw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmKxorw<T, U, V>,
	{
		<Self as CodeAsmKxorw<T, U, V>>::kxorw(self, op0, op1, op2)
	}

	/// `LAHF` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LAHF` | `9F` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn lahf(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmLahf,
	{
		<Self as CodeAsmLahf>::lahf(self)
	}

	/// `LAR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LAR r16, r/m16` | `o16 0F 02 /r` | `286+`
	/// `LAR r32, r32/m16` | `o32 0F 02 /r` | `386+`
	/// `LAR r64, r64/m16` | `o64 0F 02 /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn lar<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmLar<T, U>,
	{
		<Self as CodeAsmLar<T, U>>::lar(self, op0, op1)
	}

	/// `LDDQU` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LDDQU xmm1, m128` | `F2 0F F0 /r` | `SSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn lddqu<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmLddqu<T, U>,
	{
		<Self as CodeAsmLddqu<T, U>>::lddqu(self, op0, op1)
	}

	/// `LDMXCSR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LDMXCSR m32` | `NP 0F AE /2` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn ldmxcsr<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLdmxcsr<T>,
	{
		<Self as CodeAsmLdmxcsr<T>>::ldmxcsr(self, op0)
	}

	/// `LDS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LDS r16, m16:16` | `o16 C5 /r` | `8086+`
	/// `LDS r32, m16:32` | `o32 C5 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn lds<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmLds<T, U>,
	{
		<Self as CodeAsmLds<T, U>>::lds(self, op0, op1)
	}

	/// `LDTILECFG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LDTILECFG m512` | `VEX.128.0F38.W0 49 !(11):000:bbb` | `AMX-TILE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn ldtilecfg<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLdtilecfg<T>,
	{
		<Self as CodeAsmLdtilecfg<T>>::ldtilecfg(self, op0)
	}

	/// `LEA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LEA r16, m` | `o16 8D /r` | `8086+`
	/// `LEA r32, m` | `o32 8D /r` | `386+`
	/// `LEA r64, m` | `o64 8D /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn lea<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmLea<T, U>,
	{
		<Self as CodeAsmLea<T, U>>::lea(self, op0, op1)
	}

	/// `LEAVE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LEAVE` | `o16 C9` | `186+`
	/// `LEAVE` | `o32 C9` | `386+`
	/// `LEAVE` | `o64 C9` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn leave(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmLeave,
	{
		<Self as CodeAsmLeave>::leave(self)
	}

	/// `LES` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LES r16, m16:16` | `o16 C4 /r` | `8086+`
	/// `LES r32, m16:32` | `o32 C4 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn les<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmLes<T, U>,
	{
		<Self as CodeAsmLes<T, U>>::les(self, op0, op1)
	}

	/// `LFENCE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LFENCE` | `NP 0F AE E8` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn lfence(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmLfence,
	{
		<Self as CodeAsmLfence>::lfence(self)
	}

	/// `LFS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LFS r16, m16:16` | `o16 0F B4 /r` | `386+`
	/// `LFS r32, m16:32` | `o32 0F B4 /r` | `386+`
	/// `LFS r64, m16:64` | `o64 0F B4 /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn lfs<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmLfs<T, U>,
	{
		<Self as CodeAsmLfs<T, U>>::lfs(self, op0, op1)
	}

	/// `LGDT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LGDT m16&64` | `0F 01 /2` | `X64`
	/// `LGDT m16&32` | `o16 0F 01 /2` | `286+`
	/// `LGDT m16&32` | `o32 0F 01 /2` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn lgdt<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLgdt<T>,
	{
		<Self as CodeAsmLgdt<T>>::lgdt(self, op0)
	}

	/// `LGS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LGS r16, m16:16` | `o16 0F B5 /r` | `386+`
	/// `LGS r32, m16:32` | `o32 0F B5 /r` | `386+`
	/// `LGS r64, m16:64` | `o64 0F B5 /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn lgs<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmLgs<T, U>,
	{
		<Self as CodeAsmLgs<T, U>>::lgs(self, op0, op1)
	}

	/// `LIDT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LIDT m16&64` | `0F 01 /3` | `X64`
	/// `LIDT m16&32` | `o16 0F 01 /3` | `286+`
	/// `LIDT m16&32` | `o32 0F 01 /3` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn lidt<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLidt<T>,
	{
		<Self as CodeAsmLidt<T>>::lidt(self, op0)
	}

	/// `LKGS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LKGS r/m16` | `o16 F2 0F 00 /6` | `LKGS`
	/// `LKGS r32/m16` | `o32 F2 0F 00 /6` | `LKGS`
	/// `LKGS r64/m16` | `F2 o64 0F 00 /6` | `LKGS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn lkgs<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLkgs<T>,
	{
		<Self as CodeAsmLkgs<T>>::lkgs(self, op0)
	}

	/// `LLDT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LLDT r/m16` | `o16 0F 00 /2` | `286+`
	/// `LLDT r32/m16` | `o32 0F 00 /2` | `386+`
	/// `LLDT r64/m16` | `o64 0F 00 /2` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn lldt<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLldt<T>,
	{
		<Self as CodeAsmLldt<T>>::lldt(self, op0)
	}

	/// `LLWPCB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LLWPCB r32` | `XOP.L0.X9.W0 12 /0` | `LWP`
	/// `LLWPCB r64` | `XOP.L0.X9.W1 12 /0` | `LWP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn llwpcb<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLlwpcb<T>,
	{
		<Self as CodeAsmLlwpcb<T>>::llwpcb(self, op0)
	}

	/// `LMSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LMSW r/m16` | `o16 0F 01 /6` | `286+`
	/// `LMSW r32/m16` | `o32 0F 01 /6` | `386+`
	/// `LMSW r64/m16` | `o64 0F 01 /6` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn lmsw<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLmsw<T>,
	{
		<Self as CodeAsmLmsw<T>>::lmsw(self, op0)
	}

	/// `LOADALL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LOADALL` | `0F 07` | `386`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn loadall(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmLoadall,
	{
		<Self as CodeAsmLoadall>::loadall(self)
	}

	/// `LOADIWKEY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LOADIWKEY xmm1, xmm2, <EAX>, <XMM0>` | `F3 0F 38 DC 11:rrr:bbb` | `KL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn loadiwkey<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmLoadiwkey<T, U>,
	{
		<Self as CodeAsmLoadiwkey<T, U>>::loadiwkey(self, op0, op1)
	}

	/// `LODSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LODSB` | `AC` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn lodsb(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmLodsb,
	{
		<Self as CodeAsmLodsb>::lodsb(self)
	}

	/// `LODSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LODSD` | `o32 AD` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn lodsd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmLodsd,
	{
		<Self as CodeAsmLodsd>::lodsd(self)
	}

	/// `LODSQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LODSQ` | `o64 AD` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn lodsq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmLodsq,
	{
		<Self as CodeAsmLodsq>::lodsq(self)
	}

	/// `LODSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LODSW` | `o16 AD` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn lodsw(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmLodsw,
	{
		<Self as CodeAsmLodsw>::lodsw(self)
	}

	/// `LOOP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LOOP rel8` | `a16 o16 E2 cb` | `8086+`
	/// `LOOP rel8` | `a32 o32 E2 cb` | `386+`
	/// `LOOP rel8` | `a64 o64 E2 cb` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn loop_<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLoop<T>,
	{
		<Self as CodeAsmLoop<T>>::loop_(self, op0)
	}

	/// `LOOPE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LOOPE rel8` | `a16 o16 E1 cb` | `8086+`
	/// `LOOPE rel8` | `a32 o32 E1 cb` | `386+`
	/// `LOOPE rel8` | `a64 o64 E1 cb` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn loope<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLoope<T>,
	{
		<Self as CodeAsmLoope<T>>::loope(self, op0)
	}

	/// `LOOPNE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LOOPNE rel8` | `a16 o16 E0 cb` | `8086+`
	/// `LOOPNE rel8` | `a32 o32 E0 cb` | `386+`
	/// `LOOPNE rel8` | `a64 o64 E0 cb` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn loopne<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLoopne<T>,
	{
		<Self as CodeAsmLoopne<T>>::loopne(self, op0)
	}

	/// `LOOPNZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LOOPNE rel8` | `a16 o16 E0 cb` | `8086+`
	/// `LOOPNE rel8` | `a32 o32 E0 cb` | `386+`
	/// `LOOPNE rel8` | `a64 o64 E0 cb` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn loopnz<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLoopnz<T>,
	{
		<Self as CodeAsmLoopnz<T>>::loopnz(self, op0)
	}

	/// `LOOPZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LOOPE rel8` | `a16 o16 E1 cb` | `8086+`
	/// `LOOPE rel8` | `a32 o32 E1 cb` | `386+`
	/// `LOOPE rel8` | `a64 o64 E1 cb` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn loopz<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLoopz<T>,
	{
		<Self as CodeAsmLoopz<T>>::loopz(self, op0)
	}

	/// `LSL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LSL r16, r/m16` | `o16 0F 03 /r` | `286+`
	/// `LSL r32, r32/m16` | `o32 0F 03 /r` | `386+`
	/// `LSL r64, r64/m16` | `o64 0F 03 /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn lsl<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmLsl<T, U>,
	{
		<Self as CodeAsmLsl<T, U>>::lsl(self, op0, op1)
	}

	/// `LSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LSS r16, m16:16` | `o16 0F B2 /r` | `386+`
	/// `LSS r32, m16:32` | `o32 0F B2 /r` | `386+`
	/// `LSS r64, m16:64` | `o64 0F B2 /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn lss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmLss<T, U>,
	{
		<Self as CodeAsmLss<T, U>>::lss(self, op0, op1)
	}

	/// `LTR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LTR r/m16` | `o16 0F 00 /3` | `286+`
	/// `LTR r32/m16` | `o32 0F 00 /3` | `386+`
	/// `LTR r64/m16` | `o64 0F 00 /3` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn ltr<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmLtr<T>,
	{
		<Self as CodeAsmLtr<T>>::ltr(self, op0)
	}

	/// `LWPINS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LWPINS r32, r/m32, imm32` | `XOP.L0.XA.W0 12 /0 id` | `LWP`
	/// `LWPINS r64, r/m32, imm32` | `XOP.L0.XA.W1 12 /0 id` | `LWP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn lwpins<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmLwpins<T, U, V>,
	{
		<Self as CodeAsmLwpins<T, U, V>>::lwpins(self, op0, op1, op2)
	}

	/// `LWPVAL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LWPVAL r32, r/m32, imm32` | `XOP.L0.XA.W0 12 /1 id` | `LWP`
	/// `LWPVAL r64, r/m32, imm32` | `XOP.L0.XA.W1 12 /1 id` | `LWP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn lwpval<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmLwpval<T, U, V>,
	{
		<Self as CodeAsmLwpval<T, U, V>>::lwpval(self, op0, op1, op2)
	}

	/// `LZCNT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `LZCNT r16, r/m16` | `o16 F3 0F BD /r` | `LZCNT`
	/// `LZCNT r32, r/m32` | `o32 F3 0F BD /r` | `LZCNT`
	/// `LZCNT r64, r/m64` | `F3 o64 0F BD /r` | `LZCNT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn lzcnt<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmLzcnt<T, U>,
	{
		<Self as CodeAsmLzcnt<T, U>>::lzcnt(self, op0, op1)
	}

	/// `MASKMOVDQU` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MASKMOVDQU xmm1, xmm2` | `66 0F F7 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn maskmovdqu<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMaskmovdqu<T, U>,
	{
		<Self as CodeAsmMaskmovdqu<T, U>>::maskmovdqu(self, op0, op1)
	}

	/// `MASKMOVQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MASKMOVQ mm1, mm2` | `NP 0F F7 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn maskmovq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMaskmovq<T, U>,
	{
		<Self as CodeAsmMaskmovq<T, U>>::maskmovq(self, op0, op1)
	}

	/// `MAXPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MAXPD xmm1, xmm2/m128` | `66 0F 5F /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn maxpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMaxpd<T, U>,
	{
		<Self as CodeAsmMaxpd<T, U>>::maxpd(self, op0, op1)
	}

	/// `MAXPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MAXPS xmm1, xmm2/m128` | `NP 0F 5F /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn maxps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMaxps<T, U>,
	{
		<Self as CodeAsmMaxps<T, U>>::maxps(self, op0, op1)
	}

	/// `MAXSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MAXSD xmm1, xmm2/m64` | `F2 0F 5F /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn maxsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMaxsd<T, U>,
	{
		<Self as CodeAsmMaxsd<T, U>>::maxsd(self, op0, op1)
	}

	/// `MAXSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MAXSS xmm1, xmm2/m32` | `F3 0F 5F /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn maxss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMaxss<T, U>,
	{
		<Self as CodeAsmMaxss<T, U>>::maxss(self, op0, op1)
	}

	/// `MCOMMIT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MCOMMIT` | `F3 0F 01 FA` | `MCOMMIT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn mcommit(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmMcommit,
	{
		<Self as CodeAsmMcommit>::mcommit(self)
	}

	/// `MFENCE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MFENCE` | `NP 0F AE F0` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn mfence(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmMfence,
	{
		<Self as CodeAsmMfence>::mfence(self)
	}

	/// `MINPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MINPD xmm1, xmm2/m128` | `66 0F 5D /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn minpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMinpd<T, U>,
	{
		<Self as CodeAsmMinpd<T, U>>::minpd(self, op0, op1)
	}

	/// `MINPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MINPS xmm1, xmm2/m128` | `NP 0F 5D /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn minps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMinps<T, U>,
	{
		<Self as CodeAsmMinps<T, U>>::minps(self, op0, op1)
	}

	/// `MINSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MINSD xmm1, xmm2/m64` | `F2 0F 5D /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn minsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMinsd<T, U>,
	{
		<Self as CodeAsmMinsd<T, U>>::minsd(self, op0, op1)
	}

	/// `MINSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MINSS xmm1, xmm2/m32` | `F3 0F 5D /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn minss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMinss<T, U>,
	{
		<Self as CodeAsmMinss<T, U>>::minss(self, op0, op1)
	}

	/// `MONITOR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MONITOR` | `a16 NP 0F 01 C8` | `MONITOR`
	/// `MONITOR` | `a32 NP 0F 01 C8` | `MONITOR`
	/// `MONITOR` | `a64 NP 0F 01 C8` | `MONITOR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn monitor(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmMonitor,
	{
		<Self as CodeAsmMonitor>::monitor(self)
	}

	/// `MONITORX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MONITORX` | `a16 NP 0F 01 FA` | `MONITORX`
	/// `MONITORX` | `a32 NP 0F 01 FA` | `MONITORX`
	/// `MONITORX` | `a64 NP 0F 01 FA` | `MONITORX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn monitorx(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmMonitorx,
	{
		<Self as CodeAsmMonitorx>::monitorx(self)
	}

	/// `MONTMUL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MONTMUL` | `a16 F3 0F A6 C0` | `PADLOCK_PMM`
	/// `MONTMUL` | `a32 F3 0F A6 C0` | `PADLOCK_PMM`
	/// `MONTMUL` | `a64 F3 0F A6 C0` | `PADLOCK_PMM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn montmul(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmMontmul,
	{
		<Self as CodeAsmMontmul>::montmul(self)
	}

	/// `MOV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOV r/m8, r8` | `88 /r` | `8086+`
	/// `MOV r/m16, r16` | `o16 89 /r` | `8086+`
	/// `MOV r/m32, r32` | `o32 89 /r` | `386+`
	/// `MOV r/m64, r64` | `o64 89 /r` | `X64`
	/// `MOV r8, r/m8` | `8A /r` | `8086+`
	/// `MOV r16, r/m16` | `o16 8B /r` | `8086+`
	/// `MOV r32, r/m32` | `o32 8B /r` | `386+`
	/// `MOV r64, r/m64` | `o64 8B /r` | `X64`
	/// `MOV r/m16, Sreg` | `o16 8C /r` | `8086+`
	/// `MOV r32/m16, Sreg` | `o32 8C /r` | `386+`
	/// `MOV r64/m16, Sreg` | `o64 8C /r` | `X64`
	/// `MOV Sreg, r/m16` | `o16 8E /r` | `8086+`
	/// `MOV Sreg, r32/m16` | `o32 8E /r` | `386+`
	/// `MOV Sreg, r64/m16` | `o64 8E /r` | `X64`
	/// `MOV AL, moffs8` | `A0 mo` | `8086+`
	/// `MOV AX, moffs16` | `o16 A1 mo` | `8086+`
	/// `MOV EAX, moffs32` | `o32 A1 mo` | `386+`
	/// `MOV RAX, moffs64` | `o64 A1 mo` | `X64`
	/// `MOV moffs8, AL` | `A2 mo` | `8086+`
	/// `MOV moffs16, AX` | `o16 A3 mo` | `8086+`
	/// `MOV moffs32, EAX` | `o32 A3 mo` | `386+`
	/// `MOV moffs64, RAX` | `o64 A3 mo` | `X64`
	/// `MOV r8, imm8` | `B0+rb ib` | `8086+`
	/// `MOV r16, imm16` | `o16 B8+rw iw` | `8086+`
	/// `MOV r32, imm32` | `o32 B8+rd id` | `386+`
	/// `MOV r64, imm64` | `o64 B8+ro io` | `X64`
	/// `MOV r/m8, imm8` | `C6 /0 ib` | `8086+`
	/// `MOV r/m16, imm16` | `o16 C7 /0 iw` | `8086+`
	/// `MOV r/m32, imm32` | `o32 C7 /0 id` | `386+`
	/// `MOV r/m64, imm32` | `o64 C7 /0 id` | `X64`
	/// `MOV r32, cr` | `0F 20 /r` | `386+`
	/// `MOV r64, cr` | `0F 20 /r` | `X64`
	/// `MOV r32, dr` | `0F 21 /r` | `386+`
	/// `MOV r64, dr` | `0F 21 /r` | `X64`
	/// `MOV cr, r32` | `0F 22 /r` | `386+`
	/// `MOV cr, r64` | `0F 22 /r` | `X64`
	/// `MOV dr, r32` | `0F 23 /r` | `386+`
	/// `MOV dr, r64` | `0F 23 /r` | `X64`
	/// `MOV r32, tr` | `0F 24 /r` | `386/486/Cyrix/Geode`
	/// `MOV tr, r32` | `0F 26 /r` | `386/486/Cyrix/Geode`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn mov<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMov<T, U>,
	{
		<Self as CodeAsmMov<T, U>>::mov(self, op0, op1)
	}

	/// `MOVAPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVAPD xmm1, xmm2/m128` | `66 0F 28 /r` | `SSE2`
	/// `MOVAPD xmm2/m128, xmm1` | `66 0F 29 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movapd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovapd<T, U>,
	{
		<Self as CodeAsmMovapd<T, U>>::movapd(self, op0, op1)
	}

	/// `MOVAPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVAPS xmm1, xmm2/m128` | `NP 0F 28 /r` | `SSE`
	/// `MOVAPS xmm2/m128, xmm1` | `NP 0F 29 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movaps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovaps<T, U>,
	{
		<Self as CodeAsmMovaps<T, U>>::movaps(self, op0, op1)
	}

	/// `MOVBE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVBE r16, m16` | `o16 0F 38 F0 /r` | `MOVBE`
	/// `MOVBE r32, m32` | `o32 0F 38 F0 /r` | `MOVBE`
	/// `MOVBE r64, m64` | `o64 0F 38 F0 /r` | `MOVBE`
	/// `MOVBE m16, r16` | `o16 0F 38 F1 /r` | `MOVBE`
	/// `MOVBE m32, r32` | `o32 0F 38 F1 /r` | `MOVBE`
	/// `MOVBE m64, r64` | `o64 0F 38 F1 /r` | `MOVBE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movbe<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovbe<T, U>,
	{
		<Self as CodeAsmMovbe<T, U>>::movbe(self, op0, op1)
	}

	/// `MOVD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVD mm, r/m32` | `NP 0F 6E /r` | `MMX`
	/// `MOVD xmm, r/m32` | `66 0F 6E /r` | `SSE2`
	/// `MOVD r/m32, mm` | `NP 0F 7E /r` | `MMX`
	/// `MOVD r/m32, xmm` | `66 0F 7E /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovd<T, U>,
	{
		<Self as CodeAsmMovd<T, U>>::movd(self, op0, op1)
	}

	/// `MOVDDUP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVDDUP xmm1, xmm2/m64` | `F2 0F 12 /r` | `SSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movddup<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovddup<T, U>,
	{
		<Self as CodeAsmMovddup<T, U>>::movddup(self, op0, op1)
	}

	/// `MOVDIR64B` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVDIR64B r16, m512` | `a16 66 0F 38 F8 /r` | `MOVDIR64B`
	/// `MOVDIR64B r32, m512` | `a32 66 0F 38 F8 /r` | `MOVDIR64B`
	/// `MOVDIR64B r64, m512` | `a64 66 0F 38 F8 /r` | `MOVDIR64B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movdir64b<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovdir64b<T, U>,
	{
		<Self as CodeAsmMovdir64b<T, U>>::movdir64b(self, op0, op1)
	}

	/// `MOVDIRI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVDIRI m32, r32` | `NP 0F 38 F9 /r` | `MOVDIRI`
	/// `MOVDIRI m64, r64` | `NP o64 0F 38 F9 /r` | `MOVDIRI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movdiri<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovdiri<T, U>,
	{
		<Self as CodeAsmMovdiri<T, U>>::movdiri(self, op0, op1)
	}

	/// `MOVDQ2Q` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVDQ2Q mm, xmm` | `F2 0F D6 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movdq2q<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovdq2q<T, U>,
	{
		<Self as CodeAsmMovdq2q<T, U>>::movdq2q(self, op0, op1)
	}

	/// `MOVDQA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVDQA xmm1, xmm2/m128` | `66 0F 6F /r` | `SSE2`
	/// `MOVDQA xmm2/m128, xmm1` | `66 0F 7F /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movdqa<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovdqa<T, U>,
	{
		<Self as CodeAsmMovdqa<T, U>>::movdqa(self, op0, op1)
	}

	/// `MOVDQU` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVDQU xmm1, xmm2/m128` | `F3 0F 6F /r` | `SSE2`
	/// `MOVDQU xmm2/m128, xmm1` | `F3 0F 7F /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movdqu<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovdqu<T, U>,
	{
		<Self as CodeAsmMovdqu<T, U>>::movdqu(self, op0, op1)
	}

	/// `MOVHLPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVHLPS xmm1, xmm2` | `NP 0F 12 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movhlps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovhlps<T, U>,
	{
		<Self as CodeAsmMovhlps<T, U>>::movhlps(self, op0, op1)
	}

	/// `MOVHPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVHPD xmm1, m64` | `66 0F 16 /r` | `SSE2`
	/// `MOVHPD m64, xmm1` | `66 0F 17 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movhpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovhpd<T, U>,
	{
		<Self as CodeAsmMovhpd<T, U>>::movhpd(self, op0, op1)
	}

	/// `MOVHPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVHPS xmm1, m64` | `NP 0F 16 /r` | `SSE`
	/// `MOVHPS m64, xmm1` | `NP 0F 17 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movhps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovhps<T, U>,
	{
		<Self as CodeAsmMovhps<T, U>>::movhps(self, op0, op1)
	}

	/// `MOVLHPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVLHPS xmm1, xmm2` | `NP 0F 16 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movlhps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovlhps<T, U>,
	{
		<Self as CodeAsmMovlhps<T, U>>::movlhps(self, op0, op1)
	}

	/// `MOVLPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVLPD xmm1, m64` | `66 0F 12 /r` | `SSE2`
	/// `MOVLPD m64, xmm1` | `66 0F 13 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movlpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovlpd<T, U>,
	{
		<Self as CodeAsmMovlpd<T, U>>::movlpd(self, op0, op1)
	}

	/// `MOVLPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVLPS xmm1, m64` | `NP 0F 12 /r` | `SSE`
	/// `MOVLPS m64, xmm1` | `NP 0F 13 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movlps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovlps<T, U>,
	{
		<Self as CodeAsmMovlps<T, U>>::movlps(self, op0, op1)
	}

	/// `MOVMSKPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVMSKPD r32, xmm` | `66 0F 50 /r` | `SSE2`
	/// `MOVMSKPD r64, xmm` | `66 o64 0F 50 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movmskpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovmskpd<T, U>,
	{
		<Self as CodeAsmMovmskpd<T, U>>::movmskpd(self, op0, op1)
	}

	/// `MOVMSKPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVMSKPS r32, xmm` | `NP 0F 50 /r` | `SSE`
	/// `MOVMSKPS r64, xmm` | `NP o64 0F 50 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movmskps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovmskps<T, U>,
	{
		<Self as CodeAsmMovmskps<T, U>>::movmskps(self, op0, op1)
	}

	/// `MOVNTDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVNTDQ m128, xmm1` | `66 0F E7 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movntdq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovntdq<T, U>,
	{
		<Self as CodeAsmMovntdq<T, U>>::movntdq(self, op0, op1)
	}

	/// `MOVNTDQA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVNTDQA xmm1, m128` | `66 0F 38 2A /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movntdqa<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovntdqa<T, U>,
	{
		<Self as CodeAsmMovntdqa<T, U>>::movntdqa(self, op0, op1)
	}

	/// `MOVNTI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVNTI m32, r32` | `NP 0F C3 /r` | `SSE2`
	/// `MOVNTI m64, r64` | `NP o64 0F C3 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movnti<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovnti<T, U>,
	{
		<Self as CodeAsmMovnti<T, U>>::movnti(self, op0, op1)
	}

	/// `MOVNTPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVNTPD m128, xmm1` | `66 0F 2B /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movntpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovntpd<T, U>,
	{
		<Self as CodeAsmMovntpd<T, U>>::movntpd(self, op0, op1)
	}

	/// `MOVNTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVNTPS m128, xmm1` | `NP 0F 2B /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movntps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovntps<T, U>,
	{
		<Self as CodeAsmMovntps<T, U>>::movntps(self, op0, op1)
	}

	/// `MOVNTQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVNTQ m64, mm` | `NP 0F E7 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movntq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovntq<T, U>,
	{
		<Self as CodeAsmMovntq<T, U>>::movntq(self, op0, op1)
	}

	/// `MOVNTSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVNTSD m64, xmm1` | `F2 0F 2B /r` | `SSE4A`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movntsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovntsd<T, U>,
	{
		<Self as CodeAsmMovntsd<T, U>>::movntsd(self, op0, op1)
	}

	/// `MOVNTSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVNTSS m32, xmm1` | `F3 0F 2B /r` | `SSE4A`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movntss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovntss<T, U>,
	{
		<Self as CodeAsmMovntss<T, U>>::movntss(self, op0, op1)
	}

	/// `MOVQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVQ mm, r/m64` | `NP o64 0F 6E /r` | `MMX`
	/// `MOVQ xmm, r/m64` | `66 o64 0F 6E /r` | `SSE2`
	/// `MOVQ mm, mm/m64` | `NP 0F 6F /r` | `MMX`
	/// `MOVQ r/m64, mm` | `NP o64 0F 7E /r` | `MMX`
	/// `MOVQ r/m64, xmm` | `66 o64 0F 7E /r` | `SSE2`
	/// `MOVQ xmm1, xmm2/m64` | `F3 0F 7E /r` | `SSE2`
	/// `MOVQ mm/m64, mm` | `NP 0F 7F /r` | `MMX`
	/// `MOVQ xmm2/m64, xmm1` | `66 0F D6 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovq<T, U>,
	{
		<Self as CodeAsmMovq<T, U>>::movq(self, op0, op1)
	}

	/// `MOVQ2DQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVQ2DQ xmm, mm` | `F3 0F D6 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movq2dq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovq2dq<T, U>,
	{
		<Self as CodeAsmMovq2dq<T, U>>::movq2dq(self, op0, op1)
	}

	/// `MOVSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVSB` | `A4` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn movsb(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmMovsb,
	{
		<Self as CodeAsmMovsb>::movsb(self)
	}

	/// `MOVSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVSD` | `o32 A5` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn movsd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmMovsd,
	{
		<Self as CodeAsmMovsd>::movsd(self)
	}

	/// `MOVSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVSD xmm1, xmm2/m64` | `F2 0F 10 /r` | `SSE2`
	/// `MOVSD xmm1/m64, xmm2` | `F2 0F 11 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movsd_2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovsd2<T, U>,
	{
		<Self as CodeAsmMovsd2<T, U>>::movsd_2(self, op0, op1)
	}

	/// `MOVSHDUP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVSHDUP xmm1, xmm2/m128` | `F3 0F 16 /r` | `SSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movshdup<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovshdup<T, U>,
	{
		<Self as CodeAsmMovshdup<T, U>>::movshdup(self, op0, op1)
	}

	/// `MOVSLDUP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVSLDUP xmm1, xmm2/m128` | `F3 0F 12 /r` | `SSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movsldup<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovsldup<T, U>,
	{
		<Self as CodeAsmMovsldup<T, U>>::movsldup(self, op0, op1)
	}

	/// `MOVSQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVSQ` | `o64 A5` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn movsq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmMovsq,
	{
		<Self as CodeAsmMovsq>::movsq(self)
	}

	/// `MOVSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVSS xmm1, xmm2/m32` | `F3 0F 10 /r` | `SSE`
	/// `MOVSS xmm2/m32, xmm1` | `F3 0F 11 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovss<T, U>,
	{
		<Self as CodeAsmMovss<T, U>>::movss(self, op0, op1)
	}

	/// `MOVSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVSW` | `o16 A5` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn movsw(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmMovsw,
	{
		<Self as CodeAsmMovsw>::movsw(self)
	}

	/// `MOVSX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVSX r16, r/m8` | `o16 0F BE /r` | `386+`
	/// `MOVSX r32, r/m8` | `o32 0F BE /r` | `386+`
	/// `MOVSX r64, r/m8` | `o64 0F BE /r` | `X64`
	/// `MOVSX r16, r/m16` | `o16 0F BF /r` | `386+`
	/// `MOVSX r32, r/m16` | `o32 0F BF /r` | `386+`
	/// `MOVSX r64, r/m16` | `o64 0F BF /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movsx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovsx<T, U>,
	{
		<Self as CodeAsmMovsx<T, U>>::movsx(self, op0, op1)
	}

	/// `MOVSXD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVSXD r16, r/m16` | `o16 63 /r` | `X64`
	/// `MOVSXD r32, r/m32` | `o32 63 /r` | `X64`
	/// `MOVSXD r64, r/m32` | `o64 63 /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movsxd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovsxd<T, U>,
	{
		<Self as CodeAsmMovsxd<T, U>>::movsxd(self, op0, op1)
	}

	/// `MOVUPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVUPD xmm1, xmm2/m128` | `66 0F 10 /r` | `SSE2`
	/// `MOVUPD xmm2/m128, xmm1` | `66 0F 11 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movupd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovupd<T, U>,
	{
		<Self as CodeAsmMovupd<T, U>>::movupd(self, op0, op1)
	}

	/// `MOVUPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVUPS xmm1, xmm2/m128` | `NP 0F 10 /r` | `SSE`
	/// `MOVUPS xmm2/m128, xmm1` | `NP 0F 11 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movups<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovups<T, U>,
	{
		<Self as CodeAsmMovups<T, U>>::movups(self, op0, op1)
	}

	/// `MOVZX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MOVZX r16, r/m8` | `o16 0F B6 /r` | `386+`
	/// `MOVZX r32, r/m8` | `o32 0F B6 /r` | `386+`
	/// `MOVZX r64, r/m8` | `o64 0F B6 /r` | `X64`
	/// `MOVZX r16, r/m16` | `o16 0F B7 /r` | `386+`
	/// `MOVZX r32, r/m16` | `o32 0F B7 /r` | `386+`
	/// `MOVZX r64, r/m16` | `o64 0F B7 /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn movzx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMovzx<T, U>,
	{
		<Self as CodeAsmMovzx<T, U>>::movzx(self, op0, op1)
	}

	/// `MPSADBW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MPSADBW xmm1, xmm2/m128, imm8` | `66 0F 3A 42 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn mpsadbw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmMpsadbw<T, U, V>,
	{
		<Self as CodeAsmMpsadbw<T, U, V>>::mpsadbw(self, op0, op1, op2)
	}

	/// `MUL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MUL r/m8` | `F6 /4` | `8086+`
	/// `MUL r/m16` | `o16 F7 /4` | `8086+`
	/// `MUL r/m32` | `o32 F7 /4` | `386+`
	/// `MUL r/m64` | `o64 F7 /4` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn mul<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmMul<T>,
	{
		<Self as CodeAsmMul<T>>::mul(self, op0)
	}

	/// `MULPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MULPD xmm1, xmm2/m128` | `66 0F 59 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn mulpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMulpd<T, U>,
	{
		<Self as CodeAsmMulpd<T, U>>::mulpd(self, op0, op1)
	}

	/// `MULPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MULPS xmm1, xmm2/m128` | `NP 0F 59 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn mulps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMulps<T, U>,
	{
		<Self as CodeAsmMulps<T, U>>::mulps(self, op0, op1)
	}

	/// `MULSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MULSD xmm1, xmm2/m64` | `F2 0F 59 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn mulsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMulsd<T, U>,
	{
		<Self as CodeAsmMulsd<T, U>>::mulsd(self, op0, op1)
	}

	/// `MULSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MULSS xmm1, xmm2/m32` | `F3 0F 59 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn mulss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmMulss<T, U>,
	{
		<Self as CodeAsmMulss<T, U>>::mulss(self, op0, op1)
	}

	/// `MULX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MULX r32a, r32b, r/m32` | `VEX.LZ.F2.0F38.W0 F6 /r` | `BMI2`
	/// `MULX r64a, r64b, r/m64` | `VEX.LZ.F2.0F38.W1 F6 /r` | `BMI2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn mulx<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmMulx<T, U, V>,
	{
		<Self as CodeAsmMulx<T, U, V>>::mulx(self, op0, op1, op2)
	}

	/// `MWAIT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MWAIT` | `NP 0F 01 C9` | `MONITOR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn mwait(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmMwait,
	{
		<Self as CodeAsmMwait>::mwait(self)
	}

	/// `MWAITX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `MWAITX` | `NP 0F 01 FB` | `MONITORX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn mwaitx(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmMwaitx,
	{
		<Self as CodeAsmMwaitx>::mwaitx(self)
	}

	/// `NEG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `NEG r/m8` | `F6 /3` | `8086+`
	/// `NEG r/m16` | `o16 F7 /3` | `8086+`
	/// `NEG r/m32` | `o32 F7 /3` | `386+`
	/// `NEG r/m64` | `o64 F7 /3` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn neg<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmNeg<T>,
	{
		<Self as CodeAsmNeg<T>>::neg(self, op0)
	}

	/// `NOP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `NOP` | `o16 90` | `8086+`
	/// `NOP` | `o32 90` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn nop(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmNop,
	{
		<Self as CodeAsmNop>::nop(self)
	}

	/// `NOP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `NOP r/m16` | `o16 0F 1F /0` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `NOP r/m32` | `o32 0F 1F /0` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `NOP r/m64` | `o64 0F 1F /0` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn nop_1<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmNop1<T>,
	{
		<Self as CodeAsmNop1<T>>::nop_1(self, op0)
	}

	/// `NOT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `NOT r/m8` | `F6 /2` | `8086+`
	/// `NOT r/m16` | `o16 F7 /2` | `8086+`
	/// `NOT r/m32` | `o32 F7 /2` | `386+`
	/// `NOT r/m64` | `o64 F7 /2` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn not<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmNot<T>,
	{
		<Self as CodeAsmNot<T>>::not(self, op0)
	}

	/// `OR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `OR r/m8, r8` | `08 /r` | `8086+`
	/// `OR r/m16, r16` | `o16 09 /r` | `8086+`
	/// `OR r/m32, r32` | `o32 09 /r` | `386+`
	/// `OR r/m64, r64` | `o64 09 /r` | `X64`
	/// `OR r8, r/m8` | `0A /r` | `8086+`
	/// `OR r16, r/m16` | `o16 0B /r` | `8086+`
	/// `OR r32, r/m32` | `o32 0B /r` | `386+`
	/// `OR r64, r/m64` | `o64 0B /r` | `X64`
	/// `OR AL, imm8` | `0C ib` | `8086+`
	/// `OR AX, imm16` | `o16 0D iw` | `8086+`
	/// `OR EAX, imm32` | `o32 0D id` | `386+`
	/// `OR RAX, imm32` | `o64 0D id` | `X64`
	/// `OR r/m8, imm8` | `80 /1 ib` | `8086+`
	/// `OR r/m16, imm16` | `o16 81 /1 iw` | `8086+`
	/// `OR r/m32, imm32` | `o32 81 /1 id` | `386+`
	/// `OR r/m64, imm32` | `o64 81 /1 id` | `X64`
	/// `OR r/m16, imm8` | `o16 83 /1 ib` | `8086+`
	/// `OR r/m32, imm8` | `o32 83 /1 ib` | `386+`
	/// `OR r/m64, imm8` | `o64 83 /1 ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn or<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmOr<T, U>,
	{
		<Self as CodeAsmOr<T, U>>::or(self, op0, op1)
	}

	/// `ORPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ORPD xmm1, xmm2/m128` | `66 0F 56 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn orpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmOrpd<T, U>,
	{
		<Self as CodeAsmOrpd<T, U>>::orpd(self, op0, op1)
	}

	/// `ORPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ORPS xmm1, xmm2/m128` | `NP 0F 56 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn orps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmOrps<T, U>,
	{
		<Self as CodeAsmOrps<T, U>>::orps(self, op0, op1)
	}

	/// `OUT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `OUT imm8, AL` | `E6 ib` | `8086+`
	/// `OUT imm8, AX` | `o16 E7 ib` | `8086+`
	/// `OUT imm8, EAX` | `o32 E7 ib` | `386+`
	/// `OUT DX, AL` | `EE` | `8086+`
	/// `OUT DX, AX` | `o16 EF` | `8086+`
	/// `OUT DX, EAX` | `o32 EF` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn out<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmOut<T, U>,
	{
		<Self as CodeAsmOut<T, U>>::out(self, op0, op1)
	}

	/// `OUTSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `OUTSB` | `6E` | `186+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn outsb(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmOutsb,
	{
		<Self as CodeAsmOutsb>::outsb(self)
	}

	/// `OUTSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `OUTSD` | `o32 6F` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn outsd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmOutsd,
	{
		<Self as CodeAsmOutsd>::outsd(self)
	}

	/// `OUTSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `OUTSW` | `o16 6F` | `186+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn outsw(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmOutsw,
	{
		<Self as CodeAsmOutsw>::outsw(self)
	}

	/// `PABSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PABSB mm1, mm2/m64` | `NP 0F 38 1C /r` | `SSSE3`
	/// `PABSB xmm1, xmm2/m128` | `66 0F 38 1C /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pabsb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPabsb<T, U>,
	{
		<Self as CodeAsmPabsb<T, U>>::pabsb(self, op0, op1)
	}

	/// `PABSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PABSD mm1, mm2/m64` | `NP 0F 38 1E /r` | `SSSE3`
	/// `PABSD xmm1, xmm2/m128` | `66 0F 38 1E /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pabsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPabsd<T, U>,
	{
		<Self as CodeAsmPabsd<T, U>>::pabsd(self, op0, op1)
	}

	/// `PABSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PABSW mm1, mm2/m64` | `NP 0F 38 1D /r` | `SSSE3`
	/// `PABSW xmm1, xmm2/m128` | `66 0F 38 1D /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pabsw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPabsw<T, U>,
	{
		<Self as CodeAsmPabsw<T, U>>::pabsw(self, op0, op1)
	}

	/// `PACKSSDW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PACKSSDW mm1, mm2/m64` | `NP 0F 6B /r` | `MMX`
	/// `PACKSSDW xmm1, xmm2/m128` | `66 0F 6B /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn packssdw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPackssdw<T, U>,
	{
		<Self as CodeAsmPackssdw<T, U>>::packssdw(self, op0, op1)
	}

	/// `PACKSSWB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PACKSSWB mm1, mm2/m64` | `NP 0F 63 /r` | `MMX`
	/// `PACKSSWB xmm1, xmm2/m128` | `66 0F 63 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn packsswb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPacksswb<T, U>,
	{
		<Self as CodeAsmPacksswb<T, U>>::packsswb(self, op0, op1)
	}

	/// `PACKUSDW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PACKUSDW xmm1, xmm2/m128` | `66 0F 38 2B /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn packusdw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPackusdw<T, U>,
	{
		<Self as CodeAsmPackusdw<T, U>>::packusdw(self, op0, op1)
	}

	/// `PACKUSWB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PACKUSWB mm, mm/m64` | `NP 0F 67 /r` | `MMX`
	/// `PACKUSWB xmm1, xmm2/m128` | `66 0F 67 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn packuswb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPackuswb<T, U>,
	{
		<Self as CodeAsmPackuswb<T, U>>::packuswb(self, op0, op1)
	}

	/// `PADDB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PADDB mm, mm/m64` | `NP 0F FC /r` | `MMX`
	/// `PADDB xmm1, xmm2/m128` | `66 0F FC /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn paddb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPaddb<T, U>,
	{
		<Self as CodeAsmPaddb<T, U>>::paddb(self, op0, op1)
	}

	/// `PADDD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PADDD mm, mm/m64` | `NP 0F FE /r` | `MMX`
	/// `PADDD xmm1, xmm2/m128` | `66 0F FE /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn paddd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPaddd<T, U>,
	{
		<Self as CodeAsmPaddd<T, U>>::paddd(self, op0, op1)
	}

	/// `PADDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PADDQ mm, mm/m64` | `NP 0F D4 /r` | `MMX`
	/// `PADDQ xmm1, xmm2/m128` | `66 0F D4 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn paddq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPaddq<T, U>,
	{
		<Self as CodeAsmPaddq<T, U>>::paddq(self, op0, op1)
	}

	/// `PADDSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PADDSB mm, mm/m64` | `NP 0F EC /r` | `MMX`
	/// `PADDSB xmm1, xmm2/m128` | `66 0F EC /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn paddsb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPaddsb<T, U>,
	{
		<Self as CodeAsmPaddsb<T, U>>::paddsb(self, op0, op1)
	}

	/// `PADDSIW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PADDSIW mm, mm/m64` | `0F 51 /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn paddsiw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPaddsiw<T, U>,
	{
		<Self as CodeAsmPaddsiw<T, U>>::paddsiw(self, op0, op1)
	}

	/// `PADDSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PADDSW mm, mm/m64` | `NP 0F ED /r` | `MMX`
	/// `PADDSW xmm1, xmm2/m128` | `66 0F ED /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn paddsw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPaddsw<T, U>,
	{
		<Self as CodeAsmPaddsw<T, U>>::paddsw(self, op0, op1)
	}

	/// `PADDUSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PADDUSB mm, mm/m64` | `NP 0F DC /r` | `MMX`
	/// `PADDUSB xmm1, xmm2/m128` | `66 0F DC /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn paddusb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPaddusb<T, U>,
	{
		<Self as CodeAsmPaddusb<T, U>>::paddusb(self, op0, op1)
	}

	/// `PADDUSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PADDUSW mm, mm/m64` | `NP 0F DD /r` | `MMX`
	/// `PADDUSW xmm1, xmm2/m128` | `66 0F DD /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn paddusw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPaddusw<T, U>,
	{
		<Self as CodeAsmPaddusw<T, U>>::paddusw(self, op0, op1)
	}

	/// `PADDW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PADDW mm, mm/m64` | `NP 0F FD /r` | `MMX`
	/// `PADDW xmm1, xmm2/m128` | `66 0F FD /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn paddw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPaddw<T, U>,
	{
		<Self as CodeAsmPaddw<T, U>>::paddw(self, op0, op1)
	}

	/// `PALIGNR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PALIGNR mm1, mm2/m64, imm8` | `NP 0F 3A 0F /r ib` | `SSSE3`
	/// `PALIGNR xmm1, xmm2/m128, imm8` | `66 0F 3A 0F /r ib` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn palignr<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPalignr<T, U, V>,
	{
		<Self as CodeAsmPalignr<T, U, V>>::palignr(self, op0, op1, op2)
	}

	/// `PAND` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PAND mm, mm/m64` | `NP 0F DB /r` | `MMX`
	/// `PAND xmm1, xmm2/m128` | `66 0F DB /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pand<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPand<T, U>,
	{
		<Self as CodeAsmPand<T, U>>::pand(self, op0, op1)
	}

	/// `PANDN` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PANDN mm, mm/m64` | `NP 0F DF /r` | `MMX`
	/// `PANDN xmm1, xmm2/m128` | `66 0F DF /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pandn<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPandn<T, U>,
	{
		<Self as CodeAsmPandn<T, U>>::pandn(self, op0, op1)
	}

	/// `PAUSE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PAUSE` | `F3 90` | `Pentium 4 or later`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn pause(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPause,
	{
		<Self as CodeAsmPause>::pause(self)
	}

	/// `PAVEB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PAVEB mm, mm/m64` | `0F 50 /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn paveb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPaveb<T, U>,
	{
		<Self as CodeAsmPaveb<T, U>>::paveb(self, op0, op1)
	}

	/// `PAVGB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PAVGB mm1, mm2/m64` | `NP 0F E0 /r` | `SSE`
	/// `PAVGB xmm1, xmm2/m128` | `66 0F E0 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pavgb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPavgb<T, U>,
	{
		<Self as CodeAsmPavgb<T, U>>::pavgb(self, op0, op1)
	}

	/// `PAVGUSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PAVGUSB mm, mm/m64` | `0F 0F /r BF` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pavgusb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPavgusb<T, U>,
	{
		<Self as CodeAsmPavgusb<T, U>>::pavgusb(self, op0, op1)
	}

	/// `PAVGW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PAVGW mm1, mm2/m64` | `NP 0F E3 /r` | `SSE`
	/// `PAVGW xmm1, xmm2/m128` | `66 0F E3 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pavgw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPavgw<T, U>,
	{
		<Self as CodeAsmPavgw<T, U>>::pavgw(self, op0, op1)
	}

	/// `PBLENDVB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PBLENDVB xmm1, xmm2/m128, <XMM0>` | `66 0F 38 10 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pblendvb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPblendvb<T, U>,
	{
		<Self as CodeAsmPblendvb<T, U>>::pblendvb(self, op0, op1)
	}

	/// `PBLENDW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PBLENDW xmm1, xmm2/m128, imm8` | `66 0F 3A 0E /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pblendw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPblendw<T, U, V>,
	{
		<Self as CodeAsmPblendw<T, U, V>>::pblendw(self, op0, op1, op2)
	}

	/// `PBNDKB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PBNDKB` | `NP 0F 01 C7` | `TSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn pbndkb(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPbndkb,
	{
		<Self as CodeAsmPbndkb>::pbndkb(self)
	}

	/// `PCLMULHQHQDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCLMULQDQ xmm1, xmm2/m128, imm8` | `66 0F 3A 44 /r ib` | `PCLMULQDQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pclmulhqhqdq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPclmulhqhqdq<T, U>,
	{
		<Self as CodeAsmPclmulhqhqdq<T, U>>::pclmulhqhqdq(self, op0, op1)
	}

	/// `PCLMULHQLQDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCLMULQDQ xmm1, xmm2/m128, imm8` | `66 0F 3A 44 /r ib` | `PCLMULQDQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pclmulhqlqdq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPclmulhqlqdq<T, U>,
	{
		<Self as CodeAsmPclmulhqlqdq<T, U>>::pclmulhqlqdq(self, op0, op1)
	}

	/// `PCLMULLQHQDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCLMULQDQ xmm1, xmm2/m128, imm8` | `66 0F 3A 44 /r ib` | `PCLMULQDQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pclmullqhqdq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPclmullqhqdq<T, U>,
	{
		<Self as CodeAsmPclmullqhqdq<T, U>>::pclmullqhqdq(self, op0, op1)
	}

	/// `PCLMULLQLQDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCLMULQDQ xmm1, xmm2/m128, imm8` | `66 0F 3A 44 /r ib` | `PCLMULQDQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pclmullqlqdq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPclmullqlqdq<T, U>,
	{
		<Self as CodeAsmPclmullqlqdq<T, U>>::pclmullqlqdq(self, op0, op1)
	}

	/// `PCLMULQDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCLMULQDQ xmm1, xmm2/m128, imm8` | `66 0F 3A 44 /r ib` | `PCLMULQDQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pclmulqdq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPclmulqdq<T, U, V>,
	{
		<Self as CodeAsmPclmulqdq<T, U, V>>::pclmulqdq(self, op0, op1, op2)
	}

	/// `PCMPEQB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPEQB mm, mm/m64` | `NP 0F 74 /r` | `MMX`
	/// `PCMPEQB xmm1, xmm2/m128` | `66 0F 74 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pcmpeqb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpeqb<T, U>,
	{
		<Self as CodeAsmPcmpeqb<T, U>>::pcmpeqb(self, op0, op1)
	}

	/// `PCMPEQD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPEQD mm, mm/m64` | `NP 0F 76 /r` | `MMX`
	/// `PCMPEQD xmm1, xmm2/m128` | `66 0F 76 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pcmpeqd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpeqd<T, U>,
	{
		<Self as CodeAsmPcmpeqd<T, U>>::pcmpeqd(self, op0, op1)
	}

	/// `PCMPEQQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPEQQ xmm1, xmm2/m128` | `66 0F 38 29 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pcmpeqq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpeqq<T, U>,
	{
		<Self as CodeAsmPcmpeqq<T, U>>::pcmpeqq(self, op0, op1)
	}

	/// `PCMPEQW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPEQW mm, mm/m64` | `NP 0F 75 /r` | `MMX`
	/// `PCMPEQW xmm1, xmm2/m128` | `66 0F 75 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pcmpeqw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpeqw<T, U>,
	{
		<Self as CodeAsmPcmpeqw<T, U>>::pcmpeqw(self, op0, op1)
	}

	/// `PCMPESTRI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPESTRI xmm1, xmm2/m128, imm8` | `66 0F 3A 61 /r ib` | `SSE4.2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pcmpestri<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpestri<T, U, V>,
	{
		<Self as CodeAsmPcmpestri<T, U, V>>::pcmpestri(self, op0, op1, op2)
	}

	/// `PCMPESTRI64` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPESTRI64 xmm1, xmm2/m128, imm8` | `66 o64 0F 3A 61 /r ib` | `SSE4.2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pcmpestri64<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpestri64<T, U, V>,
	{
		<Self as CodeAsmPcmpestri64<T, U, V>>::pcmpestri64(self, op0, op1, op2)
	}

	/// `PCMPESTRM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPESTRM xmm1, xmm2/m128, imm8` | `66 0F 3A 60 /r ib` | `SSE4.2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pcmpestrm<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpestrm<T, U, V>,
	{
		<Self as CodeAsmPcmpestrm<T, U, V>>::pcmpestrm(self, op0, op1, op2)
	}

	/// `PCMPESTRM64` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPESTRM64 xmm1, xmm2/m128, imm8` | `66 o64 0F 3A 60 /r ib` | `SSE4.2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pcmpestrm64<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpestrm64<T, U, V>,
	{
		<Self as CodeAsmPcmpestrm64<T, U, V>>::pcmpestrm64(self, op0, op1, op2)
	}

	/// `PCMPGTB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPGTB mm, mm/m64` | `NP 0F 64 /r` | `MMX`
	/// `PCMPGTB xmm1, xmm2/m128` | `66 0F 64 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pcmpgtb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpgtb<T, U>,
	{
		<Self as CodeAsmPcmpgtb<T, U>>::pcmpgtb(self, op0, op1)
	}

	/// `PCMPGTD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPGTD mm, mm/m64` | `NP 0F 66 /r` | `MMX`
	/// `PCMPGTD xmm1, xmm2/m128` | `66 0F 66 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pcmpgtd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpgtd<T, U>,
	{
		<Self as CodeAsmPcmpgtd<T, U>>::pcmpgtd(self, op0, op1)
	}

	/// `PCMPGTQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPGTQ xmm1, xmm2/m128` | `66 0F 38 37 /r` | `SSE4.2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pcmpgtq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpgtq<T, U>,
	{
		<Self as CodeAsmPcmpgtq<T, U>>::pcmpgtq(self, op0, op1)
	}

	/// `PCMPGTW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPGTW mm, mm/m64` | `NP 0F 65 /r` | `MMX`
	/// `PCMPGTW xmm1, xmm2/m128` | `66 0F 65 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pcmpgtw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpgtw<T, U>,
	{
		<Self as CodeAsmPcmpgtw<T, U>>::pcmpgtw(self, op0, op1)
	}

	/// `PCMPISTRI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPISTRI xmm1, xmm2/m128, imm8` | `66 0F 3A 63 /r ib` | `SSE4.2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pcmpistri<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpistri<T, U, V>,
	{
		<Self as CodeAsmPcmpistri<T, U, V>>::pcmpistri(self, op0, op1, op2)
	}

	/// `PCMPISTRM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCMPISTRM xmm1, xmm2/m128, imm8` | `66 0F 3A 62 /r ib` | `SSE4.2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pcmpistrm<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPcmpistrm<T, U, V>,
	{
		<Self as CodeAsmPcmpistrm<T, U, V>>::pcmpistrm(self, op0, op1, op2)
	}

	/// `PCOMMIT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCOMMIT` | `66 0F AE F8` | `PCOMMIT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn pcommit(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPcommit,
	{
		<Self as CodeAsmPcommit>::pcommit(self)
	}

	/// `PCONFIG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PCONFIG` | `NP 0F 01 C5` | `PCONFIG`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn pconfig(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPconfig,
	{
		<Self as CodeAsmPconfig>::pconfig(self)
	}

	/// `PDEP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PDEP r32a, r32b, r/m32` | `VEX.LZ.F2.0F38.W0 F5 /r` | `BMI2`
	/// `PDEP r64a, r64b, r/m64` | `VEX.LZ.F2.0F38.W1 F5 /r` | `BMI2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pdep<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPdep<T, U, V>,
	{
		<Self as CodeAsmPdep<T, U, V>>::pdep(self, op0, op1, op2)
	}

	/// `PDISTIB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PDISTIB mm, m64` | `0F 54 /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pdistib<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPdistib<T, U>,
	{
		<Self as CodeAsmPdistib<T, U>>::pdistib(self, op0, op1)
	}

	/// `PEXT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PEXT r32a, r32b, r/m32` | `VEX.LZ.F3.0F38.W0 F5 /r` | `BMI2`
	/// `PEXT r64a, r64b, r/m64` | `VEX.LZ.F3.0F38.W1 F5 /r` | `BMI2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pext<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPext<T, U, V>,
	{
		<Self as CodeAsmPext<T, U, V>>::pext(self, op0, op1, op2)
	}

	/// `PEXTRB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PEXTRB r32/m8, xmm2, imm8` | `66 0F 3A 14 /r ib` | `SSE4.1`
	/// `PEXTRB r64/m8, xmm2, imm8` | `66 o64 0F 3A 14 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pextrb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPextrb<T, U, V>,
	{
		<Self as CodeAsmPextrb<T, U, V>>::pextrb(self, op0, op1, op2)
	}

	/// `PEXTRD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PEXTRD r/m32, xmm2, imm8` | `66 0F 3A 16 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pextrd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPextrd<T, U, V>,
	{
		<Self as CodeAsmPextrd<T, U, V>>::pextrd(self, op0, op1, op2)
	}

	/// `PEXTRQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PEXTRQ r/m64, xmm2, imm8` | `66 o64 0F 3A 16 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pextrq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPextrq<T, U, V>,
	{
		<Self as CodeAsmPextrq<T, U, V>>::pextrq(self, op0, op1, op2)
	}

	/// `PEXTRW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PEXTRW r32, mm, imm8` | `NP 0F C5 /r ib` | `SSE`
	/// `PEXTRW r64, mm, imm8` | `NP o64 0F C5 /r ib` | `SSE`
	/// `PEXTRW r32, xmm, imm8` | `66 0F C5 /r ib` | `SSE2`
	/// `PEXTRW r64, xmm, imm8` | `66 o64 0F C5 /r ib` | `SSE2`
	/// `PEXTRW r32/m16, xmm, imm8` | `66 0F 3A 15 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pextrw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPextrw<T, U, V>,
	{
		<Self as CodeAsmPextrw<T, U, V>>::pextrw(self, op0, op1, op2)
	}

	/// `PF2ID` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PF2ID mm, mm/m64` | `0F 0F /r 1D` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pf2id<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPf2id<T, U>,
	{
		<Self as CodeAsmPf2id<T, U>>::pf2id(self, op0, op1)
	}

	/// `PF2IW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PF2IW mm, mm/m64` | `0F 0F /r 1C` | `3DNOWEXT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pf2iw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPf2iw<T, U>,
	{
		<Self as CodeAsmPf2iw<T, U>>::pf2iw(self, op0, op1)
	}

	/// `PFACC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFACC mm, mm/m64` | `0F 0F /r AE` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfacc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfacc<T, U>,
	{
		<Self as CodeAsmPfacc<T, U>>::pfacc(self, op0, op1)
	}

	/// `PFADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFADD mm, mm/m64` | `0F 0F /r 9E` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfadd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfadd<T, U>,
	{
		<Self as CodeAsmPfadd<T, U>>::pfadd(self, op0, op1)
	}

	/// `PFCMPEQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFCMPEQ mm, mm/m64` | `0F 0F /r B0` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfcmpeq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfcmpeq<T, U>,
	{
		<Self as CodeAsmPfcmpeq<T, U>>::pfcmpeq(self, op0, op1)
	}

	/// `PFCMPGE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFCMPGE mm, mm/m64` | `0F 0F /r 90` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfcmpge<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfcmpge<T, U>,
	{
		<Self as CodeAsmPfcmpge<T, U>>::pfcmpge(self, op0, op1)
	}

	/// `PFCMPGT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFCMPGT mm, mm/m64` | `0F 0F /r A0` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfcmpgt<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfcmpgt<T, U>,
	{
		<Self as CodeAsmPfcmpgt<T, U>>::pfcmpgt(self, op0, op1)
	}

	/// `PFMAX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFMAX mm, mm/m64` | `0F 0F /r A4` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfmax<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfmax<T, U>,
	{
		<Self as CodeAsmPfmax<T, U>>::pfmax(self, op0, op1)
	}

	/// `PFMIN` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFMIN mm, mm/m64` | `0F 0F /r 94` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfmin<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfmin<T, U>,
	{
		<Self as CodeAsmPfmin<T, U>>::pfmin(self, op0, op1)
	}

	/// `PFMUL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFMUL mm, mm/m64` | `0F 0F /r B4` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfmul<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfmul<T, U>,
	{
		<Self as CodeAsmPfmul<T, U>>::pfmul(self, op0, op1)
	}

	/// `PFNACC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFNACC mm, mm/m64` | `0F 0F /r 8A` | `3DNOWEXT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfnacc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfnacc<T, U>,
	{
		<Self as CodeAsmPfnacc<T, U>>::pfnacc(self, op0, op1)
	}

	/// `PFPNACC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFPNACC mm, mm/m64` | `0F 0F /r 8E` | `3DNOWEXT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfpnacc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfpnacc<T, U>,
	{
		<Self as CodeAsmPfpnacc<T, U>>::pfpnacc(self, op0, op1)
	}

	/// `PFRCP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFRCP mm, mm/m64` | `0F 0F /r 96` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfrcp<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfrcp<T, U>,
	{
		<Self as CodeAsmPfrcp<T, U>>::pfrcp(self, op0, op1)
	}

	/// `PFRCPIT1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFRCPIT1 mm, mm/m64` | `0F 0F /r A6` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfrcpit1<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfrcpit1<T, U>,
	{
		<Self as CodeAsmPfrcpit1<T, U>>::pfrcpit1(self, op0, op1)
	}

	/// `PFRCPIT2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFRCPIT2 mm, mm/m64` | `0F 0F /r B6` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfrcpit2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfrcpit2<T, U>,
	{
		<Self as CodeAsmPfrcpit2<T, U>>::pfrcpit2(self, op0, op1)
	}

	/// `PFRCPV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFRCPV mm, mm/m64` | `0F 0F /r 86` | `AMD Geode GX/LX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfrcpv<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfrcpv<T, U>,
	{
		<Self as CodeAsmPfrcpv<T, U>>::pfrcpv(self, op0, op1)
	}

	/// `PFRSQIT1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFRSQIT1 mm, mm/m64` | `0F 0F /r A7` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfrsqit1<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfrsqit1<T, U>,
	{
		<Self as CodeAsmPfrsqit1<T, U>>::pfrsqit1(self, op0, op1)
	}

	/// `PFRSQRT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFRSQRT mm, mm/m64` | `0F 0F /r 97` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfrsqrt<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfrsqrt<T, U>,
	{
		<Self as CodeAsmPfrsqrt<T, U>>::pfrsqrt(self, op0, op1)
	}

	/// `PFRSQRTV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFRSQRTV mm, mm/m64` | `0F 0F /r 87` | `AMD Geode GX/LX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfrsqrtv<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfrsqrtv<T, U>,
	{
		<Self as CodeAsmPfrsqrtv<T, U>>::pfrsqrtv(self, op0, op1)
	}

	/// `PFSUB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFSUB mm, mm/m64` | `0F 0F /r 9A` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfsub<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfsub<T, U>,
	{
		<Self as CodeAsmPfsub<T, U>>::pfsub(self, op0, op1)
	}

	/// `PFSUBR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PFSUBR mm, mm/m64` | `0F 0F /r AA` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pfsubr<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPfsubr<T, U>,
	{
		<Self as CodeAsmPfsubr<T, U>>::pfsubr(self, op0, op1)
	}

	/// `PHADDD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PHADDD mm1, mm2/m64` | `NP 0F 38 02 /r` | `SSSE3`
	/// `PHADDD xmm1, xmm2/m128` | `66 0F 38 02 /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn phaddd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPhaddd<T, U>,
	{
		<Self as CodeAsmPhaddd<T, U>>::phaddd(self, op0, op1)
	}

	/// `PHADDSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PHADDSW mm1, mm2/m64` | `NP 0F 38 03 /r` | `SSSE3`
	/// `PHADDSW xmm1, xmm2/m128` | `66 0F 38 03 /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn phaddsw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPhaddsw<T, U>,
	{
		<Self as CodeAsmPhaddsw<T, U>>::phaddsw(self, op0, op1)
	}

	/// `PHADDW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PHADDW mm1, mm2/m64` | `NP 0F 38 01 /r` | `SSSE3`
	/// `PHADDW xmm1, xmm2/m128` | `66 0F 38 01 /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn phaddw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPhaddw<T, U>,
	{
		<Self as CodeAsmPhaddw<T, U>>::phaddw(self, op0, op1)
	}

	/// `PHMINPOSUW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PHMINPOSUW xmm1, xmm2/m128` | `66 0F 38 41 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn phminposuw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPhminposuw<T, U>,
	{
		<Self as CodeAsmPhminposuw<T, U>>::phminposuw(self, op0, op1)
	}

	/// `PHSUBD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PHSUBD mm1, mm2/m64` | `NP 0F 38 06 /r` | `SSSE3`
	/// `PHSUBD xmm1, xmm2/m128` | `66 0F 38 06 /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn phsubd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPhsubd<T, U>,
	{
		<Self as CodeAsmPhsubd<T, U>>::phsubd(self, op0, op1)
	}

	/// `PHSUBSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PHSUBSW mm1, mm2/m64` | `NP 0F 38 07 /r` | `SSSE3`
	/// `PHSUBSW xmm1, xmm2/m128` | `66 0F 38 07 /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn phsubsw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPhsubsw<T, U>,
	{
		<Self as CodeAsmPhsubsw<T, U>>::phsubsw(self, op0, op1)
	}

	/// `PHSUBW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PHSUBW mm1, mm2/m64` | `NP 0F 38 05 /r` | `SSSE3`
	/// `PHSUBW xmm1, xmm2/m128` | `66 0F 38 05 /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn phsubw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPhsubw<T, U>,
	{
		<Self as CodeAsmPhsubw<T, U>>::phsubw(self, op0, op1)
	}

	/// `PI2FD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PI2FD mm, mm/m64` | `0F 0F /r 0D` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pi2fd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPi2fd<T, U>,
	{
		<Self as CodeAsmPi2fd<T, U>>::pi2fd(self, op0, op1)
	}

	/// `PI2FW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PI2FW mm, mm/m64` | `0F 0F /r 0C` | `3DNOWEXT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pi2fw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPi2fw<T, U>,
	{
		<Self as CodeAsmPi2fw<T, U>>::pi2fw(self, op0, op1)
	}

	/// `PINSRB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PINSRB xmm1, r32/m8, imm8` | `66 0F 3A 20 /r ib` | `SSE4.1`
	/// `PINSRB xmm1, r64/m8, imm8` | `66 o64 0F 3A 20 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pinsrb<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPinsrb<T, U, V>,
	{
		<Self as CodeAsmPinsrb<T, U, V>>::pinsrb(self, op0, op1, op2)
	}

	/// `PINSRD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PINSRD xmm1, r/m32, imm8` | `66 0F 3A 22 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pinsrd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPinsrd<T, U, V>,
	{
		<Self as CodeAsmPinsrd<T, U, V>>::pinsrd(self, op0, op1, op2)
	}

	/// `PINSRQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PINSRQ xmm1, r/m64, imm8` | `66 o64 0F 3A 22 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pinsrq<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPinsrq<T, U, V>,
	{
		<Self as CodeAsmPinsrq<T, U, V>>::pinsrq(self, op0, op1, op2)
	}

	/// `PINSRW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PINSRW mm, r32/m16, imm8` | `NP 0F C4 /r ib` | `SSE`
	/// `PINSRW mm, r64/m16, imm8` | `NP o64 0F C4 /r ib` | `SSE`
	/// `PINSRW xmm, r32/m16, imm8` | `66 0F C4 /r ib` | `SSE2`
	/// `PINSRW xmm, r64/m16, imm8` | `66 o64 0F C4 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pinsrw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPinsrw<T, U, V>,
	{
		<Self as CodeAsmPinsrw<T, U, V>>::pinsrw(self, op0, op1, op2)
	}

	/// `PMACHRIW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMACHRIW mm, m64` | `0F 5E /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmachriw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmachriw<T, U>,
	{
		<Self as CodeAsmPmachriw<T, U>>::pmachriw(self, op0, op1)
	}

	/// `PMADDUBSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMADDUBSW mm1, mm2/m64` | `NP 0F 38 04 /r` | `SSSE3`
	/// `PMADDUBSW xmm1, xmm2/m128` | `66 0F 38 04 /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmaddubsw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmaddubsw<T, U>,
	{
		<Self as CodeAsmPmaddubsw<T, U>>::pmaddubsw(self, op0, op1)
	}

	/// `PMADDWD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMADDWD mm, mm/m64` | `NP 0F F5 /r` | `MMX`
	/// `PMADDWD xmm1, xmm2/m128` | `66 0F F5 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmaddwd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmaddwd<T, U>,
	{
		<Self as CodeAsmPmaddwd<T, U>>::pmaddwd(self, op0, op1)
	}

	/// `PMAGW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMAGW mm, mm/m64` | `0F 52 /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmagw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmagw<T, U>,
	{
		<Self as CodeAsmPmagw<T, U>>::pmagw(self, op0, op1)
	}

	/// `PMAXSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMAXSB xmm1, xmm2/m128` | `66 0F 38 3C /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmaxsb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmaxsb<T, U>,
	{
		<Self as CodeAsmPmaxsb<T, U>>::pmaxsb(self, op0, op1)
	}

	/// `PMAXSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMAXSD xmm1, xmm2/m128` | `66 0F 38 3D /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmaxsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmaxsd<T, U>,
	{
		<Self as CodeAsmPmaxsd<T, U>>::pmaxsd(self, op0, op1)
	}

	/// `PMAXSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMAXSW mm1, mm2/m64` | `NP 0F EE /r` | `SSE`
	/// `PMAXSW xmm1, xmm2/m128` | `66 0F EE /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmaxsw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmaxsw<T, U>,
	{
		<Self as CodeAsmPmaxsw<T, U>>::pmaxsw(self, op0, op1)
	}

	/// `PMAXUB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMAXUB mm1, mm2/m64` | `NP 0F DE /r` | `SSE`
	/// `PMAXUB xmm1, xmm2/m128` | `66 0F DE /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmaxub<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmaxub<T, U>,
	{
		<Self as CodeAsmPmaxub<T, U>>::pmaxub(self, op0, op1)
	}

	/// `PMAXUD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMAXUD xmm1, xmm2/m128` | `66 0F 38 3F /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmaxud<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmaxud<T, U>,
	{
		<Self as CodeAsmPmaxud<T, U>>::pmaxud(self, op0, op1)
	}

	/// `PMAXUW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMAXUW xmm1, xmm2/m128` | `66 0F 38 3E /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmaxuw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmaxuw<T, U>,
	{
		<Self as CodeAsmPmaxuw<T, U>>::pmaxuw(self, op0, op1)
	}

	/// `PMINSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMINSB xmm1, xmm2/m128` | `66 0F 38 38 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pminsb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPminsb<T, U>,
	{
		<Self as CodeAsmPminsb<T, U>>::pminsb(self, op0, op1)
	}

	/// `PMINSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMINSD xmm1, xmm2/m128` | `66 0F 38 39 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pminsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPminsd<T, U>,
	{
		<Self as CodeAsmPminsd<T, U>>::pminsd(self, op0, op1)
	}

	/// `PMINSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMINSW mm1, mm2/m64` | `NP 0F EA /r` | `SSE`
	/// `PMINSW xmm1, xmm2/m128` | `66 0F EA /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pminsw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPminsw<T, U>,
	{
		<Self as CodeAsmPminsw<T, U>>::pminsw(self, op0, op1)
	}

	/// `PMINUB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMINUB mm1, mm2/m64` | `NP 0F DA /r` | `SSE`
	/// `PMINUB xmm1, xmm2/m128` | `66 0F DA /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pminub<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPminub<T, U>,
	{
		<Self as CodeAsmPminub<T, U>>::pminub(self, op0, op1)
	}

	/// `PMINUD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMINUD xmm1, xmm2/m128` | `66 0F 38 3B /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pminud<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPminud<T, U>,
	{
		<Self as CodeAsmPminud<T, U>>::pminud(self, op0, op1)
	}

	/// `PMINUW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMINUW xmm1, xmm2/m128` | `66 0F 38 3A /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pminuw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPminuw<T, U>,
	{
		<Self as CodeAsmPminuw<T, U>>::pminuw(self, op0, op1)
	}

	/// `PMOVMSKB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVMSKB r32, mm` | `NP 0F D7 /r` | `SSE`
	/// `PMOVMSKB r64, mm` | `NP o64 0F D7 /r` | `SSE`
	/// `PMOVMSKB r32, xmm` | `66 0F D7 /r` | `SSE2`
	/// `PMOVMSKB r64, xmm` | `66 o64 0F D7 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovmskb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovmskb<T, U>,
	{
		<Self as CodeAsmPmovmskb<T, U>>::pmovmskb(self, op0, op1)
	}

	/// `PMOVSXBD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVSXBD xmm1, xmm2/m32` | `66 0F 38 21 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovsxbd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovsxbd<T, U>,
	{
		<Self as CodeAsmPmovsxbd<T, U>>::pmovsxbd(self, op0, op1)
	}

	/// `PMOVSXBQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVSXBQ xmm1, xmm2/m16` | `66 0F 38 22 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovsxbq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovsxbq<T, U>,
	{
		<Self as CodeAsmPmovsxbq<T, U>>::pmovsxbq(self, op0, op1)
	}

	/// `PMOVSXBW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVSXBW xmm1, xmm2/m64` | `66 0F 38 20 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovsxbw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovsxbw<T, U>,
	{
		<Self as CodeAsmPmovsxbw<T, U>>::pmovsxbw(self, op0, op1)
	}

	/// `PMOVSXDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVSXDQ xmm1, xmm2/m64` | `66 0F 38 25 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovsxdq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovsxdq<T, U>,
	{
		<Self as CodeAsmPmovsxdq<T, U>>::pmovsxdq(self, op0, op1)
	}

	/// `PMOVSXWD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVSXWD xmm1, xmm2/m64` | `66 0F 38 23 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovsxwd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovsxwd<T, U>,
	{
		<Self as CodeAsmPmovsxwd<T, U>>::pmovsxwd(self, op0, op1)
	}

	/// `PMOVSXWQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVSXWQ xmm1, xmm2/m32` | `66 0F 38 24 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovsxwq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovsxwq<T, U>,
	{
		<Self as CodeAsmPmovsxwq<T, U>>::pmovsxwq(self, op0, op1)
	}

	/// `PMOVZXBD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVZXBD xmm1, xmm2/m32` | `66 0F 38 31 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovzxbd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovzxbd<T, U>,
	{
		<Self as CodeAsmPmovzxbd<T, U>>::pmovzxbd(self, op0, op1)
	}

	/// `PMOVZXBQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVZXBQ xmm1, xmm2/m16` | `66 0F 38 32 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovzxbq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovzxbq<T, U>,
	{
		<Self as CodeAsmPmovzxbq<T, U>>::pmovzxbq(self, op0, op1)
	}

	/// `PMOVZXBW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVZXBW xmm1, xmm2/m64` | `66 0F 38 30 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovzxbw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovzxbw<T, U>,
	{
		<Self as CodeAsmPmovzxbw<T, U>>::pmovzxbw(self, op0, op1)
	}

	/// `PMOVZXDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVZXDQ xmm1, xmm2/m64` | `66 0F 38 35 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovzxdq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovzxdq<T, U>,
	{
		<Self as CodeAsmPmovzxdq<T, U>>::pmovzxdq(self, op0, op1)
	}

	/// `PMOVZXWD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVZXWD xmm1, xmm2/m64` | `66 0F 38 33 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovzxwd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovzxwd<T, U>,
	{
		<Self as CodeAsmPmovzxwd<T, U>>::pmovzxwd(self, op0, op1)
	}

	/// `PMOVZXWQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMOVZXWQ xmm1, xmm2/m32` | `66 0F 38 34 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmovzxwq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmovzxwq<T, U>,
	{
		<Self as CodeAsmPmovzxwq<T, U>>::pmovzxwq(self, op0, op1)
	}

	/// `PMULDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMULDQ xmm1, xmm2/m128` | `66 0F 38 28 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmuldq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmuldq<T, U>,
	{
		<Self as CodeAsmPmuldq<T, U>>::pmuldq(self, op0, op1)
	}

	/// `PMULHRIW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMULHRIW mm, mm/m64` | `0F 5D /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmulhriw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmulhriw<T, U>,
	{
		<Self as CodeAsmPmulhriw<T, U>>::pmulhriw(self, op0, op1)
	}

	/// `PMULHRSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMULHRSW mm1, mm2/m64` | `NP 0F 38 0B /r` | `SSSE3`
	/// `PMULHRSW xmm1, xmm2/m128` | `66 0F 38 0B /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmulhrsw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmulhrsw<T, U>,
	{
		<Self as CodeAsmPmulhrsw<T, U>>::pmulhrsw(self, op0, op1)
	}

	/// `PMULHRW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMULHRW mm, mm/m64` | `0F 0F /r B7` | `3DNOW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmulhrw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmulhrw<T, U>,
	{
		<Self as CodeAsmPmulhrw<T, U>>::pmulhrw(self, op0, op1)
	}

	/// `PMULHRW_CYRIX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMULHRW mm, mm/m64` | `0F 59 /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmulhrw_cyrix<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmulhrw_cyrix<T, U>,
	{
		<Self as CodeAsmPmulhrw_cyrix<T, U>>::pmulhrw_cyrix(self, op0, op1)
	}

	/// `PMULHUW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMULHUW mm1, mm2/m64` | `NP 0F E4 /r` | `SSE`
	/// `PMULHUW xmm1, xmm2/m128` | `66 0F E4 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmulhuw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmulhuw<T, U>,
	{
		<Self as CodeAsmPmulhuw<T, U>>::pmulhuw(self, op0, op1)
	}

	/// `PMULHW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMULHW mm, mm/m64` | `NP 0F E5 /r` | `MMX`
	/// `PMULHW xmm1, xmm2/m128` | `66 0F E5 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmulhw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmulhw<T, U>,
	{
		<Self as CodeAsmPmulhw<T, U>>::pmulhw(self, op0, op1)
	}

	/// `PMULLD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMULLD xmm1, xmm2/m128` | `66 0F 38 40 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmulld<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmulld<T, U>,
	{
		<Self as CodeAsmPmulld<T, U>>::pmulld(self, op0, op1)
	}

	/// `PMULLW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMULLW mm, mm/m64` | `NP 0F D5 /r` | `MMX`
	/// `PMULLW xmm1, xmm2/m128` | `66 0F D5 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmullw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmullw<T, U>,
	{
		<Self as CodeAsmPmullw<T, U>>::pmullw(self, op0, op1)
	}

	/// `PMULUDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMULUDQ mm1, mm2/m64` | `NP 0F F4 /r` | `SSE2`
	/// `PMULUDQ xmm1, xmm2/m128` | `66 0F F4 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmuludq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmuludq<T, U>,
	{
		<Self as CodeAsmPmuludq<T, U>>::pmuludq(self, op0, op1)
	}

	/// `PMVGEZB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMVGEZB mm, m64` | `0F 5C /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmvgezb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmvgezb<T, U>,
	{
		<Self as CodeAsmPmvgezb<T, U>>::pmvgezb(self, op0, op1)
	}

	/// `PMVLZB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMVLZB mm, m64` | `0F 5B /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmvlzb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmvlzb<T, U>,
	{
		<Self as CodeAsmPmvlzb<T, U>>::pmvlzb(self, op0, op1)
	}

	/// `PMVNZB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMVNZB mm, m64` | `0F 5A /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmvnzb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmvnzb<T, U>,
	{
		<Self as CodeAsmPmvnzb<T, U>>::pmvnzb(self, op0, op1)
	}

	/// `PMVZB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PMVZB mm, m64` | `0F 58 /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pmvzb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPmvzb<T, U>,
	{
		<Self as CodeAsmPmvzb<T, U>>::pmvzb(self, op0, op1)
	}

	/// `POP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `POP ES` | `o16 07` | `8086+`
	/// `POP ES` | `o32 07` | `386+`
	/// `POP SS` | `o16 17` | `8086+`
	/// `POP SS` | `o32 17` | `386+`
	/// `POP DS` | `o16 1F` | `8086+`
	/// `POP DS` | `o32 1F` | `386+`
	/// `POP r16` | `o16 58+rw` | `8086+`
	/// `POP r32` | `o32 58+rd` | `386+`
	/// `POP r64` | `o64 58+ro` | `X64`
	/// `POP r/m16` | `o16 8F /0` | `8086+`
	/// `POP r/m32` | `o32 8F /0` | `386+`
	/// `POP r/m64` | `o64 8F /0` | `X64`
	/// `POP FS` | `o16 0F A1` | `386+`
	/// `POP FS` | `o32 0F A1` | `386+`
	/// `POP FS` | `o64 0F A1` | `X64`
	/// `POP GS` | `o16 0F A9` | `386+`
	/// `POP GS` | `o32 0F A9` | `386+`
	/// `POP GS` | `o64 0F A9` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn pop<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPop<T>,
	{
		<Self as CodeAsmPop<T>>::pop(self, op0)
	}

	/// `POPA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `POPA` | `o16 61` | `186+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn popa(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPopa,
	{
		<Self as CodeAsmPopa>::popa(self)
	}

	/// `POPAD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `POPAD` | `o32 61` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn popad(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPopad,
	{
		<Self as CodeAsmPopad>::popad(self)
	}

	/// `POPCNT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `POPCNT r16, r/m16` | `o16 F3 0F B8 /r` | `POPCNT`
	/// `POPCNT r32, r/m32` | `o32 F3 0F B8 /r` | `POPCNT`
	/// `POPCNT r64, r/m64` | `F3 o64 0F B8 /r` | `POPCNT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn popcnt<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPopcnt<T, U>,
	{
		<Self as CodeAsmPopcnt<T, U>>::popcnt(self, op0, op1)
	}

	/// `POPF` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `POPF` | `o16 9D` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn popf(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPopf,
	{
		<Self as CodeAsmPopf>::popf(self)
	}

	/// `POPFD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `POPFD` | `o32 9D` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn popfd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPopfd,
	{
		<Self as CodeAsmPopfd>::popfd(self)
	}

	/// `POPFQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `POPFQ` | `o64 9D` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn popfq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPopfq,
	{
		<Self as CodeAsmPopfq>::popfq(self)
	}

	/// `POR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `POR mm, mm/m64` | `NP 0F EB /r` | `MMX`
	/// `POR xmm1, xmm2/m128` | `66 0F EB /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn por<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPor<T, U>,
	{
		<Self as CodeAsmPor<T, U>>::por(self, op0, op1)
	}

	/// `PREFETCH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PREFETCH m8` | `0F 0D /0` | `PREFETCHW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn prefetch<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPrefetch<T>,
	{
		<Self as CodeAsmPrefetch<T>>::prefetch(self, op0)
	}

	/// `PREFETCHIT0` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PREFETCHIT0 m8` | `0F 18 /7` | `PREFETCHITI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn prefetchit0<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPrefetchit0<T>,
	{
		<Self as CodeAsmPrefetchit0<T>>::prefetchit0(self, op0)
	}

	/// `PREFETCHIT1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PREFETCHIT1 m8` | `0F 18 /6` | `PREFETCHITI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn prefetchit1<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPrefetchit1<T>,
	{
		<Self as CodeAsmPrefetchit1<T>>::prefetchit1(self, op0)
	}

	/// `PREFETCHNTA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PREFETCHNTA m8` | `0F 18 /0` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn prefetchnta<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPrefetchnta<T>,
	{
		<Self as CodeAsmPrefetchnta<T>>::prefetchnta(self, op0)
	}

	/// `PREFETCHT0` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PREFETCHT0 m8` | `0F 18 /1` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn prefetcht0<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPrefetcht0<T>,
	{
		<Self as CodeAsmPrefetcht0<T>>::prefetcht0(self, op0)
	}

	/// `PREFETCHT1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PREFETCHT1 m8` | `0F 18 /2` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn prefetcht1<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPrefetcht1<T>,
	{
		<Self as CodeAsmPrefetcht1<T>>::prefetcht1(self, op0)
	}

	/// `PREFETCHT2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PREFETCHT2 m8` | `0F 18 /3` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn prefetcht2<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPrefetcht2<T>,
	{
		<Self as CodeAsmPrefetcht2<T>>::prefetcht2(self, op0)
	}

	/// `PREFETCHW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PREFETCHW m8` | `0F 0D /1` | `PREFETCHW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn prefetchw<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPrefetchw<T>,
	{
		<Self as CodeAsmPrefetchw<T>>::prefetchw(self, op0)
	}

	/// `PREFETCHWT1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PREFETCHWT1 m8` | `0F 0D /2` | `PREFETCHWT1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn prefetchwt1<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPrefetchwt1<T>,
	{
		<Self as CodeAsmPrefetchwt1<T>>::prefetchwt1(self, op0)
	}

	/// `PSADBW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSADBW mm1, mm2/m64` | `NP 0F F6 /r` | `SSE`
	/// `PSADBW xmm1, xmm2/m128` | `66 0F F6 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psadbw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsadbw<T, U>,
	{
		<Self as CodeAsmPsadbw<T, U>>::psadbw(self, op0, op1)
	}

	/// `PSHUFB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSHUFB mm1, mm2/m64` | `NP 0F 38 00 /r` | `SSSE3`
	/// `PSHUFB xmm1, xmm2/m128` | `66 0F 38 00 /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pshufb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPshufb<T, U>,
	{
		<Self as CodeAsmPshufb<T, U>>::pshufb(self, op0, op1)
	}

	/// `PSHUFD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSHUFD xmm1, xmm2/m128, imm8` | `66 0F 70 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pshufd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPshufd<T, U, V>,
	{
		<Self as CodeAsmPshufd<T, U, V>>::pshufd(self, op0, op1, op2)
	}

	/// `PSHUFHW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSHUFHW xmm1, xmm2/m128, imm8` | `F3 0F 70 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pshufhw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPshufhw<T, U, V>,
	{
		<Self as CodeAsmPshufhw<T, U, V>>::pshufhw(self, op0, op1, op2)
	}

	/// `PSHUFLW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSHUFLW xmm1, xmm2/m128, imm8` | `F2 0F 70 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pshuflw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPshuflw<T, U, V>,
	{
		<Self as CodeAsmPshuflw<T, U, V>>::pshuflw(self, op0, op1, op2)
	}

	/// `PSHUFW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSHUFW mm1, mm2/m64, imm8` | `NP 0F 70 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn pshufw<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmPshufw<T, U, V>,
	{
		<Self as CodeAsmPshufw<T, U, V>>::pshufw(self, op0, op1, op2)
	}

	/// `PSIGNB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSIGNB mm1, mm2/m64` | `NP 0F 38 08 /r` | `SSSE3`
	/// `PSIGNB xmm1, xmm2/m128` | `66 0F 38 08 /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psignb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsignb<T, U>,
	{
		<Self as CodeAsmPsignb<T, U>>::psignb(self, op0, op1)
	}

	/// `PSIGND` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSIGND mm1, mm2/m64` | `NP 0F 38 0A /r` | `SSSE3`
	/// `PSIGND xmm1, xmm2/m128` | `66 0F 38 0A /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psignd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsignd<T, U>,
	{
		<Self as CodeAsmPsignd<T, U>>::psignd(self, op0, op1)
	}

	/// `PSIGNW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSIGNW mm1, mm2/m64` | `NP 0F 38 09 /r` | `SSSE3`
	/// `PSIGNW xmm1, xmm2/m128` | `66 0F 38 09 /r` | `SSSE3`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psignw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsignw<T, U>,
	{
		<Self as CodeAsmPsignw<T, U>>::psignw(self, op0, op1)
	}

	/// `PSLLD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSLLD mm, imm8` | `NP 0F 72 /6 ib` | `MMX`
	/// `PSLLD xmm1, imm8` | `66 0F 72 /6 ib` | `SSE2`
	/// `PSLLD mm, mm/m64` | `NP 0F F2 /r` | `MMX`
	/// `PSLLD xmm1, xmm2/m128` | `66 0F F2 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pslld<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPslld<T, U>,
	{
		<Self as CodeAsmPslld<T, U>>::pslld(self, op0, op1)
	}

	/// `PSLLDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSLLDQ xmm1, imm8` | `66 0F 73 /7 ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pslldq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPslldq<T, U>,
	{
		<Self as CodeAsmPslldq<T, U>>::pslldq(self, op0, op1)
	}

	/// `PSLLQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSLLQ mm, imm8` | `NP 0F 73 /6 ib` | `MMX`
	/// `PSLLQ xmm1, imm8` | `66 0F 73 /6 ib` | `SSE2`
	/// `PSLLQ mm, mm/m64` | `NP 0F F3 /r` | `MMX`
	/// `PSLLQ xmm1, xmm2/m128` | `66 0F F3 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psllq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsllq<T, U>,
	{
		<Self as CodeAsmPsllq<T, U>>::psllq(self, op0, op1)
	}

	/// `PSLLW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSLLW mm1, imm8` | `NP 0F 71 /6 ib` | `MMX`
	/// `PSLLW xmm1, imm8` | `66 0F 71 /6 ib` | `SSE2`
	/// `PSLLW mm, mm/m64` | `NP 0F F1 /r` | `MMX`
	/// `PSLLW xmm1, xmm2/m128` | `66 0F F1 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psllw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsllw<T, U>,
	{
		<Self as CodeAsmPsllw<T, U>>::psllw(self, op0, op1)
	}

	/// `PSMASH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSMASH` | `F3 0F 01 FF` | `SEV-SNP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn psmash(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPsmash,
	{
		<Self as CodeAsmPsmash>::psmash(self)
	}

	/// `PSRAD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSRAD mm, imm8` | `NP 0F 72 /4 ib` | `MMX`
	/// `PSRAD xmm1, imm8` | `66 0F 72 /4 ib` | `SSE2`
	/// `PSRAD mm, mm/m64` | `NP 0F E2 /r` | `MMX`
	/// `PSRAD xmm1, xmm2/m128` | `66 0F E2 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psrad<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsrad<T, U>,
	{
		<Self as CodeAsmPsrad<T, U>>::psrad(self, op0, op1)
	}

	/// `PSRAW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSRAW mm, imm8` | `NP 0F 71 /4 ib` | `MMX`
	/// `PSRAW xmm1, imm8` | `66 0F 71 /4 ib` | `SSE2`
	/// `PSRAW mm, mm/m64` | `NP 0F E1 /r` | `MMX`
	/// `PSRAW xmm1, xmm2/m128` | `66 0F E1 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psraw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsraw<T, U>,
	{
		<Self as CodeAsmPsraw<T, U>>::psraw(self, op0, op1)
	}

	/// `PSRLD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSRLD mm, imm8` | `NP 0F 72 /2 ib` | `MMX`
	/// `PSRLD xmm1, imm8` | `66 0F 72 /2 ib` | `SSE2`
	/// `PSRLD mm, mm/m64` | `NP 0F D2 /r` | `MMX`
	/// `PSRLD xmm1, xmm2/m128` | `66 0F D2 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psrld<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsrld<T, U>,
	{
		<Self as CodeAsmPsrld<T, U>>::psrld(self, op0, op1)
	}

	/// `PSRLDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSRLDQ xmm1, imm8` | `66 0F 73 /3 ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psrldq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsrldq<T, U>,
	{
		<Self as CodeAsmPsrldq<T, U>>::psrldq(self, op0, op1)
	}

	/// `PSRLQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSRLQ mm, imm8` | `NP 0F 73 /2 ib` | `MMX`
	/// `PSRLQ xmm1, imm8` | `66 0F 73 /2 ib` | `SSE2`
	/// `PSRLQ mm, mm/m64` | `NP 0F D3 /r` | `MMX`
	/// `PSRLQ xmm1, xmm2/m128` | `66 0F D3 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psrlq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsrlq<T, U>,
	{
		<Self as CodeAsmPsrlq<T, U>>::psrlq(self, op0, op1)
	}

	/// `PSRLW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSRLW mm, imm8` | `NP 0F 71 /2 ib` | `MMX`
	/// `PSRLW xmm1, imm8` | `66 0F 71 /2 ib` | `SSE2`
	/// `PSRLW mm, mm/m64` | `NP 0F D1 /r` | `MMX`
	/// `PSRLW xmm1, xmm2/m128` | `66 0F D1 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psrlw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsrlw<T, U>,
	{
		<Self as CodeAsmPsrlw<T, U>>::psrlw(self, op0, op1)
	}

	/// `PSUBB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSUBB mm, mm/m64` | `NP 0F F8 /r` | `MMX`
	/// `PSUBB xmm1, xmm2/m128` | `66 0F F8 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psubb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsubb<T, U>,
	{
		<Self as CodeAsmPsubb<T, U>>::psubb(self, op0, op1)
	}

	/// `PSUBD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSUBD mm, mm/m64` | `NP 0F FA /r` | `MMX`
	/// `PSUBD xmm1, xmm2/m128` | `66 0F FA /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psubd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsubd<T, U>,
	{
		<Self as CodeAsmPsubd<T, U>>::psubd(self, op0, op1)
	}

	/// `PSUBQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSUBQ mm1, mm2/m64` | `NP 0F FB /r` | `SSE2`
	/// `PSUBQ xmm1, xmm2/m128` | `66 0F FB /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psubq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsubq<T, U>,
	{
		<Self as CodeAsmPsubq<T, U>>::psubq(self, op0, op1)
	}

	/// `PSUBSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSUBSB mm, mm/m64` | `NP 0F E8 /r` | `MMX`
	/// `PSUBSB xmm1, xmm2/m128` | `66 0F E8 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psubsb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsubsb<T, U>,
	{
		<Self as CodeAsmPsubsb<T, U>>::psubsb(self, op0, op1)
	}

	/// `PSUBSIW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSUBSIW mm, mm/m64` | `0F 55 /r` | `CYRIX_EMMI`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psubsiw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsubsiw<T, U>,
	{
		<Self as CodeAsmPsubsiw<T, U>>::psubsiw(self, op0, op1)
	}

	/// `PSUBSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSUBSW mm, mm/m64` | `NP 0F E9 /r` | `MMX`
	/// `PSUBSW xmm1, xmm2/m128` | `66 0F E9 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psubsw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsubsw<T, U>,
	{
		<Self as CodeAsmPsubsw<T, U>>::psubsw(self, op0, op1)
	}

	/// `PSUBUSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSUBUSB mm, mm/m64` | `NP 0F D8 /r` | `MMX`
	/// `PSUBUSB xmm1, xmm2/m128` | `66 0F D8 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psubusb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsubusb<T, U>,
	{
		<Self as CodeAsmPsubusb<T, U>>::psubusb(self, op0, op1)
	}

	/// `PSUBUSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSUBUSW mm, mm/m64` | `NP 0F D9 /r` | `MMX`
	/// `PSUBUSW xmm1, xmm2/m128` | `66 0F D9 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psubusw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsubusw<T, U>,
	{
		<Self as CodeAsmPsubusw<T, U>>::psubusw(self, op0, op1)
	}

	/// `PSUBW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSUBW mm, mm/m64` | `NP 0F F9 /r` | `MMX`
	/// `PSUBW xmm1, xmm2/m128` | `66 0F F9 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn psubw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPsubw<T, U>,
	{
		<Self as CodeAsmPsubw<T, U>>::psubw(self, op0, op1)
	}

	/// `PSWAPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PSWAPD mm, mm/m64` | `0F 0F /r BB` | `3DNOWEXT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pswapd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPswapd<T, U>,
	{
		<Self as CodeAsmPswapd<T, U>>::pswapd(self, op0, op1)
	}

	/// `PTEST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PTEST xmm1, xmm2/m128` | `66 0F 38 17 /r` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn ptest<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPtest<T, U>,
	{
		<Self as CodeAsmPtest<T, U>>::ptest(self, op0, op1)
	}

	/// `PTWRITE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PTWRITE r/m32` | `F3 0F AE /4` | `PTWRITE`
	/// `PTWRITE r/m64` | `F3 o64 0F AE /4` | `PTWRITE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn ptwrite<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPtwrite<T>,
	{
		<Self as CodeAsmPtwrite<T>>::ptwrite(self, op0)
	}

	/// `PUNPCKHBW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUNPCKHBW mm, mm/m64` | `NP 0F 68 /r` | `MMX`
	/// `PUNPCKHBW xmm1, xmm2/m128` | `66 0F 68 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn punpckhbw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPunpckhbw<T, U>,
	{
		<Self as CodeAsmPunpckhbw<T, U>>::punpckhbw(self, op0, op1)
	}

	/// `PUNPCKHDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUNPCKHDQ mm, mm/m64` | `NP 0F 6A /r` | `MMX`
	/// `PUNPCKHDQ xmm1, xmm2/m128` | `66 0F 6A /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn punpckhdq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPunpckhdq<T, U>,
	{
		<Self as CodeAsmPunpckhdq<T, U>>::punpckhdq(self, op0, op1)
	}

	/// `PUNPCKHQDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUNPCKHQDQ xmm1, xmm2/m128` | `66 0F 6D /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn punpckhqdq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPunpckhqdq<T, U>,
	{
		<Self as CodeAsmPunpckhqdq<T, U>>::punpckhqdq(self, op0, op1)
	}

	/// `PUNPCKHWD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUNPCKHWD mm, mm/m64` | `NP 0F 69 /r` | `MMX`
	/// `PUNPCKHWD xmm1, xmm2/m128` | `66 0F 69 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn punpckhwd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPunpckhwd<T, U>,
	{
		<Self as CodeAsmPunpckhwd<T, U>>::punpckhwd(self, op0, op1)
	}

	/// `PUNPCKLBW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUNPCKLBW mm, mm/m32` | `NP 0F 60 /r` | `MMX`
	/// `PUNPCKLBW xmm1, xmm2/m128` | `66 0F 60 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn punpcklbw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPunpcklbw<T, U>,
	{
		<Self as CodeAsmPunpcklbw<T, U>>::punpcklbw(self, op0, op1)
	}

	/// `PUNPCKLDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUNPCKLDQ mm, mm/m32` | `NP 0F 62 /r` | `MMX`
	/// `PUNPCKLDQ xmm1, xmm2/m128` | `66 0F 62 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn punpckldq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPunpckldq<T, U>,
	{
		<Self as CodeAsmPunpckldq<T, U>>::punpckldq(self, op0, op1)
	}

	/// `PUNPCKLQDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUNPCKLQDQ xmm1, xmm2/m128` | `66 0F 6C /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn punpcklqdq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPunpcklqdq<T, U>,
	{
		<Self as CodeAsmPunpcklqdq<T, U>>::punpcklqdq(self, op0, op1)
	}

	/// `PUNPCKLWD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUNPCKLWD mm, mm/m32` | `NP 0F 61 /r` | `MMX`
	/// `PUNPCKLWD xmm1, xmm2/m128` | `66 0F 61 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn punpcklwd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPunpcklwd<T, U>,
	{
		<Self as CodeAsmPunpcklwd<T, U>>::punpcklwd(self, op0, op1)
	}

	/// `PUSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUSH ES` | `o16 06` | `8086+`
	/// `PUSH ES` | `o32 06` | `386+`
	/// `PUSH CS` | `o16 0E` | `8086+`
	/// `PUSH CS` | `o32 0E` | `386+`
	/// `PUSH SS` | `o16 16` | `8086+`
	/// `PUSH SS` | `o32 16` | `386+`
	/// `PUSH DS` | `o16 1E` | `8086+`
	/// `PUSH DS` | `o32 1E` | `386+`
	/// `PUSH r16` | `o16 50+rw` | `8086+`
	/// `PUSH r32` | `o32 50+rd` | `386+`
	/// `PUSH r64` | `o64 50+ro` | `X64`
	/// `PUSH imm16` | `o16 68 iw` | `186+`
	/// `PUSH imm32` | `o32 68 id` | `386+`
	/// `PUSH imm32` | `o64 68 id` | `X64`
	/// `PUSH imm8` | `o16 6A ib` | `186+`
	/// `PUSH imm8` | `o32 6A ib` | `386+`
	/// `PUSH imm8` | `o64 6A ib` | `X64`
	/// `PUSH r/m16` | `o16 FF /6` | `8086+`
	/// `PUSH r/m32` | `o32 FF /6` | `386+`
	/// `PUSH r/m64` | `o64 FF /6` | `X64`
	/// `PUSH FS` | `o16 0F A0` | `386+`
	/// `PUSH FS` | `o32 0F A0` | `386+`
	/// `PUSH FS` | `o64 0F A0` | `X64`
	/// `PUSH GS` | `o16 0F A8` | `386+`
	/// `PUSH GS` | `o32 0F A8` | `386+`
	/// `PUSH GS` | `o64 0F A8` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn push<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmPush<T>,
	{
		<Self as CodeAsmPush<T>>::push(self, op0)
	}

	/// `PUSHA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUSHA` | `o16 60` | `186+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn pusha(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPusha,
	{
		<Self as CodeAsmPusha>::pusha(self)
	}

	/// `PUSHAD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUSHAD` | `o32 60` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn pushad(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPushad,
	{
		<Self as CodeAsmPushad>::pushad(self)
	}

	/// `PUSHF` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUSHF` | `o16 9C` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn pushf(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPushf,
	{
		<Self as CodeAsmPushf>::pushf(self)
	}

	/// `PUSHFD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUSHFD` | `o32 9C` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn pushfd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPushfd,
	{
		<Self as CodeAsmPushfd>::pushfd(self)
	}

	/// `PUSHFQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PUSHFQ` | `o64 9C` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn pushfq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPushfq,
	{
		<Self as CodeAsmPushfq>::pushfq(self)
	}

	/// `PVALIDATE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PVALIDATE` | `a16 F2 0F 01 FF` | `SEV-SNP`
	/// `PVALIDATE` | `a32 F2 0F 01 FF` | `SEV-SNP`
	/// `PVALIDATE` | `a64 F2 0F 01 FF` | `SEV-SNP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn pvalidate(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmPvalidate,
	{
		<Self as CodeAsmPvalidate>::pvalidate(self)
	}

	/// `PXOR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `PXOR mm, mm/m64` | `NP 0F EF /r` | `MMX`
	/// `PXOR xmm1, xmm2/m128` | `66 0F EF /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn pxor<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmPxor<T, U>,
	{
		<Self as CodeAsmPxor<T, U>>::pxor(self, op0, op1)
	}

	/// `RCL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RCL r/m8, imm8` | `C0 /2 ib` | `186+`
	/// `RCL r/m16, imm8` | `o16 C1 /2 ib` | `186+`
	/// `RCL r/m32, imm8` | `o32 C1 /2 ib` | `386+`
	/// `RCL r/m64, imm8` | `o64 C1 /2 ib` | `X64`
	/// `RCL r/m8, 1` | `D0 /2` | `8086+`
	/// `RCL r/m16, 1` | `o16 D1 /2` | `8086+`
	/// `RCL r/m32, 1` | `o32 D1 /2` | `386+`
	/// `RCL r/m64, 1` | `o64 D1 /2` | `X64`
	/// `RCL r/m8, CL` | `D2 /2` | `8086+`
	/// `RCL r/m16, CL` | `o16 D3 /2` | `8086+`
	/// `RCL r/m32, CL` | `o32 D3 /2` | `386+`
	/// `RCL r/m64, CL` | `o64 D3 /2` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn rcl<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmRcl<T, U>,
	{
		<Self as CodeAsmRcl<T, U>>::rcl(self, op0, op1)
	}

	/// `RCPPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RCPPS xmm1, xmm2/m128` | `NP 0F 53 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn rcpps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmRcpps<T, U>,
	{
		<Self as CodeAsmRcpps<T, U>>::rcpps(self, op0, op1)
	}

	/// `RCPSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RCPSS xmm1, xmm2/m32` | `F3 0F 53 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn rcpss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmRcpss<T, U>,
	{
		<Self as CodeAsmRcpss<T, U>>::rcpss(self, op0, op1)
	}

	/// `RCR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RCR r/m8, imm8` | `C0 /3 ib` | `186+`
	/// `RCR r/m16, imm8` | `o16 C1 /3 ib` | `186+`
	/// `RCR r/m32, imm8` | `o32 C1 /3 ib` | `386+`
	/// `RCR r/m64, imm8` | `o64 C1 /3 ib` | `X64`
	/// `RCR r/m8, 1` | `D0 /3` | `8086+`
	/// `RCR r/m16, 1` | `o16 D1 /3` | `8086+`
	/// `RCR r/m32, 1` | `o32 D1 /3` | `386+`
	/// `RCR r/m64, 1` | `o64 D1 /3` | `X64`
	/// `RCR r/m8, CL` | `D2 /3` | `8086+`
	/// `RCR r/m16, CL` | `o16 D3 /3` | `8086+`
	/// `RCR r/m32, CL` | `o32 D3 /3` | `386+`
	/// `RCR r/m64, CL` | `o64 D3 /3` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn rcr<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmRcr<T, U>,
	{
		<Self as CodeAsmRcr<T, U>>::rcr(self, op0, op1)
	}

	/// `RDFSBASE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDFSBASE r32` | `F3 0F AE /0` | `FSGSBASE`
	/// `RDFSBASE r64` | `F3 o64 0F AE /0` | `FSGSBASE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn rdfsbase<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRdfsbase<T>,
	{
		<Self as CodeAsmRdfsbase<T>>::rdfsbase(self, op0)
	}

	/// `RDGSBASE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDGSBASE r32` | `F3 0F AE /1` | `FSGSBASE`
	/// `RDGSBASE r64` | `F3 o64 0F AE /1` | `FSGSBASE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn rdgsbase<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRdgsbase<T>,
	{
		<Self as CodeAsmRdgsbase<T>>::rdgsbase(self, op0)
	}

	/// `RDM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDM` | `0F 3A` | `AMD Geode GX/LX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rdm(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRdm,
	{
		<Self as CodeAsmRdm>::rdm(self)
	}

	/// `RDMSR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDMSR` | `0F 32` | `MSR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rdmsr(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRdmsr,
	{
		<Self as CodeAsmRdmsr>::rdmsr(self)
	}

	/// `RDMSRLIST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDMSRLIST` | `F2 0F 01 C6` | `MSRLIST`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rdmsrlist(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRdmsrlist,
	{
		<Self as CodeAsmRdmsrlist>::rdmsrlist(self)
	}

	/// `RDPID` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDPID r32` | `F3 0F C7 /7` | `RDPID`
	/// `RDPID r64` | `F3 0F C7 /7` | `RDPID`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn rdpid<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRdpid<T>,
	{
		<Self as CodeAsmRdpid<T>>::rdpid(self, op0)
	}

	/// `RDPKRU` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDPKRU` | `NP 0F 01 EE` | `PKU`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rdpkru(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRdpkru,
	{
		<Self as CodeAsmRdpkru>::rdpkru(self)
	}

	/// `RDPMC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDPMC` | `0F 33` | `Pentium MMX or later, or Pentium Pro or later`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rdpmc(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRdpmc,
	{
		<Self as CodeAsmRdpmc>::rdpmc(self)
	}

	/// `RDPRU` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDPRU` | `NP 0F 01 FD` | `RDPRU`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rdpru(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRdpru,
	{
		<Self as CodeAsmRdpru>::rdpru(self)
	}

	/// `RDRAND` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDRAND r16` | `o16 0F C7 /6` | `RDRAND`
	/// `RDRAND r32` | `o32 0F C7 /6` | `RDRAND`
	/// `RDRAND r64` | `o64 0F C7 /6` | `RDRAND`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn rdrand<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRdrand<T>,
	{
		<Self as CodeAsmRdrand<T>>::rdrand(self, op0)
	}

	/// `RDSEED` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDSEED r16` | `o16 0F C7 /7` | `RDSEED`
	/// `RDSEED r32` | `o32 0F C7 /7` | `RDSEED`
	/// `RDSEED r64` | `o64 0F C7 /7` | `RDSEED`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn rdseed<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRdseed<T>,
	{
		<Self as CodeAsmRdseed<T>>::rdseed(self, op0)
	}

	/// `RDSHR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDSHR r/m32` | `0F 36 /0` | `Cyrix 6x86MX, M II, III`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn rdshr<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRdshr<T>,
	{
		<Self as CodeAsmRdshr<T>>::rdshr(self, op0)
	}

	/// `RDSSPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDSSPD r32` | `F3 0F 1E /1` | `CET_SS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn rdsspd<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRdsspd<T>,
	{
		<Self as CodeAsmRdsspd<T>>::rdsspd(self, op0)
	}

	/// `RDSSPQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDSSPQ r64` | `F3 o64 0F 1E /1` | `CET_SS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn rdsspq<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRdsspq<T>,
	{
		<Self as CodeAsmRdsspq<T>>::rdsspq(self, op0)
	}

	/// `RDTSC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDTSC` | `0F 31` | `TSC`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rdtsc(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRdtsc,
	{
		<Self as CodeAsmRdtsc>::rdtsc(self)
	}

	/// `RDTSCP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDTSCP` | `0F 01 F9` | `RDTSCP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rdtscp(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRdtscp,
	{
		<Self as CodeAsmRdtscp>::rdtscp(self)
	}

	/// `RDUDBG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RDUDBG` | `0F 0E` | `UDBG`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rdudbg(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRdudbg,
	{
		<Self as CodeAsmRdudbg>::rdudbg(self)
	}

	/// `RESERVEDNOP_0F0D` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RESERVEDNOP r/m16, r16` | `o16 0F 0D /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m32, r32` | `o32 0F 0D /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m64, r64` | `o64 0F 0D /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn reservednop_0f0d<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmReservednop_0f0d<T, U>,
	{
		<Self as CodeAsmReservednop_0f0d<T, U>>::reservednop_0f0d(self, op0, op1)
	}

	/// `RESERVEDNOP_0F18` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RESERVEDNOP r/m16, r16` | `o16 0F 18 /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m32, r32` | `o32 0F 18 /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m64, r64` | `o64 0F 18 /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn reservednop_0f18<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmReservednop_0f18<T, U>,
	{
		<Self as CodeAsmReservednop_0f18<T, U>>::reservednop_0f18(self, op0, op1)
	}

	/// `RESERVEDNOP_0F19` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RESERVEDNOP r/m16, r16` | `o16 0F 19 /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m32, r32` | `o32 0F 19 /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m64, r64` | `o64 0F 19 /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn reservednop_0f19<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmReservednop_0f19<T, U>,
	{
		<Self as CodeAsmReservednop_0f19<T, U>>::reservednop_0f19(self, op0, op1)
	}

	/// `RESERVEDNOP_0F1A` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RESERVEDNOP r/m16, r16` | `o16 0F 1A /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m32, r32` | `o32 0F 1A /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m64, r64` | `o64 0F 1A /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn reservednop_0f1a<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmReservednop_0f1a<T, U>,
	{
		<Self as CodeAsmReservednop_0f1a<T, U>>::reservednop_0f1a(self, op0, op1)
	}

	/// `RESERVEDNOP_0F1B` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RESERVEDNOP r/m16, r16` | `o16 0F 1B /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m32, r32` | `o32 0F 1B /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m64, r64` | `o64 0F 1B /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn reservednop_0f1b<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmReservednop_0f1b<T, U>,
	{
		<Self as CodeAsmReservednop_0f1b<T, U>>::reservednop_0f1b(self, op0, op1)
	}

	/// `RESERVEDNOP_0F1C` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RESERVEDNOP r/m16, r16` | `o16 0F 1C /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m32, r32` | `o32 0F 1C /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m64, r64` | `o64 0F 1C /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn reservednop_0f1c<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmReservednop_0f1c<T, U>,
	{
		<Self as CodeAsmReservednop_0f1c<T, U>>::reservednop_0f1c(self, op0, op1)
	}

	/// `RESERVEDNOP_0F1D` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RESERVEDNOP r/m16, r16` | `o16 0F 1D /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m32, r32` | `o32 0F 1D /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m64, r64` | `o64 0F 1D /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn reservednop_0f1d<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmReservednop_0f1d<T, U>,
	{
		<Self as CodeAsmReservednop_0f1d<T, U>>::reservednop_0f1d(self, op0, op1)
	}

	/// `RESERVEDNOP_0F1E` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RESERVEDNOP r/m16, r16` | `o16 0F 1E /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m32, r32` | `o32 0F 1E /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m64, r64` | `o64 0F 1E /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn reservednop_0f1e<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmReservednop_0f1e<T, U>,
	{
		<Self as CodeAsmReservednop_0f1e<T, U>>::reservednop_0f1e(self, op0, op1)
	}

	/// `RESERVEDNOP_0F1F` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RESERVEDNOP r/m16, r16` | `o16 0F 1F /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m32, r32` | `o32 0F 1F /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	/// `RESERVEDNOP r/m64, r64` | `o64 0F 1F /r` | `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn reservednop_0f1f<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmReservednop_0f1f<T, U>,
	{
		<Self as CodeAsmReservednop_0f1f<T, U>>::reservednop_0f1f(self, op0, op1)
	}

	/// `RET` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RET` | `o16 C3` | `8086+`
	/// `RET` | `o32 C3` | `386+`
	/// `RET` | `o64 C3` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn ret(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRet,
	{
		<Self as CodeAsmRet>::ret(self)
	}

	/// `RET` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RET imm16` | `o16 C2 iw` | `8086+`
	/// `RET imm16` | `o32 C2 iw` | `386+`
	/// `RET imm16` | `o64 C2 iw` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn ret_1<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRet1<T>,
	{
		<Self as CodeAsmRet1<T>>::ret_1(self, op0)
	}

	/// `RETF` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RETF` | `o16 CB` | `8086+`
	/// `RETF` | `o32 CB` | `386+`
	/// `RETF` | `o64 CB` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn retf(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRetf,
	{
		<Self as CodeAsmRetf>::retf(self)
	}

	/// `RETF` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RETF imm16` | `o16 CA iw` | `8086+`
	/// `RETF imm16` | `o32 CA iw` | `386+`
	/// `RETF imm16` | `o64 CA iw` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn retf_1<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRetf1<T>,
	{
		<Self as CodeAsmRetf1<T>>::retf_1(self, op0)
	}

	/// `RMPADJUST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RMPADJUST` | `F3 0F 01 FE` | `SEV-SNP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rmpadjust(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRmpadjust,
	{
		<Self as CodeAsmRmpadjust>::rmpadjust(self)
	}

	/// `RMPQUERY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RMPQUERY` | `F3 0F 01 FD` | `RMPQUERY`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rmpquery(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRmpquery,
	{
		<Self as CodeAsmRmpquery>::rmpquery(self)
	}

	/// `RMPUPDATE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RMPUPDATE` | `F2 0F 01 FE` | `SEV-SNP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rmpupdate(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRmpupdate,
	{
		<Self as CodeAsmRmpupdate>::rmpupdate(self)
	}

	/// `ROL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ROL r/m8, imm8` | `C0 /0 ib` | `186+`
	/// `ROL r/m16, imm8` | `o16 C1 /0 ib` | `186+`
	/// `ROL r/m32, imm8` | `o32 C1 /0 ib` | `386+`
	/// `ROL r/m64, imm8` | `o64 C1 /0 ib` | `X64`
	/// `ROL r/m8, 1` | `D0 /0` | `8086+`
	/// `ROL r/m16, 1` | `o16 D1 /0` | `8086+`
	/// `ROL r/m32, 1` | `o32 D1 /0` | `386+`
	/// `ROL r/m64, 1` | `o64 D1 /0` | `X64`
	/// `ROL r/m8, CL` | `D2 /0` | `8086+`
	/// `ROL r/m16, CL` | `o16 D3 /0` | `8086+`
	/// `ROL r/m32, CL` | `o32 D3 /0` | `386+`
	/// `ROL r/m64, CL` | `o64 D3 /0` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn rol<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmRol<T, U>,
	{
		<Self as CodeAsmRol<T, U>>::rol(self, op0, op1)
	}

	/// `ROR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ROR r/m8, imm8` | `C0 /1 ib` | `186+`
	/// `ROR r/m16, imm8` | `o16 C1 /1 ib` | `186+`
	/// `ROR r/m32, imm8` | `o32 C1 /1 ib` | `386+`
	/// `ROR r/m64, imm8` | `o64 C1 /1 ib` | `X64`
	/// `ROR r/m8, 1` | `D0 /1` | `8086+`
	/// `ROR r/m16, 1` | `o16 D1 /1` | `8086+`
	/// `ROR r/m32, 1` | `o32 D1 /1` | `386+`
	/// `ROR r/m64, 1` | `o64 D1 /1` | `X64`
	/// `ROR r/m8, CL` | `D2 /1` | `8086+`
	/// `ROR r/m16, CL` | `o16 D3 /1` | `8086+`
	/// `ROR r/m32, CL` | `o32 D3 /1` | `386+`
	/// `ROR r/m64, CL` | `o64 D3 /1` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn ror<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmRor<T, U>,
	{
		<Self as CodeAsmRor<T, U>>::ror(self, op0, op1)
	}

	/// `RORX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RORX r32, r/m32, imm8` | `VEX.LZ.F2.0F3A.W0 F0 /r ib` | `BMI2`
	/// `RORX r64, r/m64, imm8` | `VEX.LZ.F2.0F3A.W1 F0 /r ib` | `BMI2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn rorx<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmRorx<T, U, V>,
	{
		<Self as CodeAsmRorx<T, U, V>>::rorx(self, op0, op1, op2)
	}

	/// `ROUNDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ROUNDPD xmm1, xmm2/m128, imm8` | `66 0F 3A 09 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn roundpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmRoundpd<T, U, V>,
	{
		<Self as CodeAsmRoundpd<T, U, V>>::roundpd(self, op0, op1, op2)
	}

	/// `ROUNDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ROUNDPS xmm1, xmm2/m128, imm8` | `66 0F 3A 08 /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn roundps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmRoundps<T, U, V>,
	{
		<Self as CodeAsmRoundps<T, U, V>>::roundps(self, op0, op1, op2)
	}

	/// `ROUNDSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ROUNDSD xmm1, xmm2/m64, imm8` | `66 0F 3A 0B /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn roundsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmRoundsd<T, U, V>,
	{
		<Self as CodeAsmRoundsd<T, U, V>>::roundsd(self, op0, op1, op2)
	}

	/// `ROUNDSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `ROUNDSS xmm1, xmm2/m32, imm8` | `66 0F 3A 0A /r ib` | `SSE4.1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn roundss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmRoundss<T, U, V>,
	{
		<Self as CodeAsmRoundss<T, U, V>>::roundss(self, op0, op1, op2)
	}

	/// `RSDC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RSDC Sreg, m80` | `0F 79 /r` | `Cyrix, AMD Geode GX/LX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn rsdc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmRsdc<T, U>,
	{
		<Self as CodeAsmRsdc<T, U>>::rsdc(self, op0, op1)
	}

	/// `RSLDT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RSLDT m80` | `0F 7B /0` | `Cyrix, AMD Geode GX/LX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn rsldt<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRsldt<T>,
	{
		<Self as CodeAsmRsldt<T>>::rsldt(self, op0)
	}

	/// `RSM` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RSM` | `0F AA` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn rsm(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmRsm,
	{
		<Self as CodeAsmRsm>::rsm(self)
	}

	/// `RSQRTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RSQRTPS xmm1, xmm2/m128` | `NP 0F 52 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn rsqrtps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmRsqrtps<T, U>,
	{
		<Self as CodeAsmRsqrtps<T, U>>::rsqrtps(self, op0, op1)
	}

	/// `RSQRTSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RSQRTSS xmm1, xmm2/m32` | `F3 0F 52 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn rsqrtss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmRsqrtss<T, U>,
	{
		<Self as CodeAsmRsqrtss<T, U>>::rsqrtss(self, op0, op1)
	}

	/// `RSTORSSP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RSTORSSP m64` | `F3 0F 01 /5` | `CET_SS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn rstorssp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRstorssp<T>,
	{
		<Self as CodeAsmRstorssp<T>>::rstorssp(self, op0)
	}

	/// `RSTS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `RSTS m80` | `0F 7D /0` | `Cyrix, AMD Geode GX/LX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn rsts<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmRsts<T>,
	{
		<Self as CodeAsmRsts<T>>::rsts(self, op0)
	}

	/// `SAHF` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SAHF` | `9E` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn sahf(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSahf,
	{
		<Self as CodeAsmSahf>::sahf(self)
	}

	/// `SAL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SAL r/m8, imm8` | `C0 /6 ib` | `186+`
	/// `SAL r/m16, imm8` | `o16 C1 /6 ib` | `186+`
	/// `SAL r/m32, imm8` | `o32 C1 /6 ib` | `386+`
	/// `SAL r/m64, imm8` | `o64 C1 /6 ib` | `X64`
	/// `SAL r/m8, 1` | `D0 /6` | `8086+`
	/// `SAL r/m16, 1` | `o16 D1 /6` | `8086+`
	/// `SAL r/m32, 1` | `o32 D1 /6` | `386+`
	/// `SAL r/m64, 1` | `o64 D1 /6` | `X64`
	/// `SAL r/m8, CL` | `D2 /6` | `8086+`
	/// `SAL r/m16, CL` | `o16 D3 /6` | `8086+`
	/// `SAL r/m32, CL` | `o32 D3 /6` | `386+`
	/// `SAL r/m64, CL` | `o64 D3 /6` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sal<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSal<T, U>,
	{
		<Self as CodeAsmSal<T, U>>::sal(self, op0, op1)
	}

	/// `SALC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SALC` | `D6` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn salc(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSalc,
	{
		<Self as CodeAsmSalc>::salc(self)
	}

	/// `SAR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SAR r/m8, imm8` | `C0 /7 ib` | `186+`
	/// `SAR r/m16, imm8` | `o16 C1 /7 ib` | `186+`
	/// `SAR r/m32, imm8` | `o32 C1 /7 ib` | `386+`
	/// `SAR r/m64, imm8` | `o64 C1 /7 ib` | `X64`
	/// `SAR r/m8, 1` | `D0 /7` | `8086+`
	/// `SAR r/m16, 1` | `o16 D1 /7` | `8086+`
	/// `SAR r/m32, 1` | `o32 D1 /7` | `386+`
	/// `SAR r/m64, 1` | `o64 D1 /7` | `X64`
	/// `SAR r/m8, CL` | `D2 /7` | `8086+`
	/// `SAR r/m16, CL` | `o16 D3 /7` | `8086+`
	/// `SAR r/m32, CL` | `o32 D3 /7` | `386+`
	/// `SAR r/m64, CL` | `o64 D3 /7` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sar<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSar<T, U>,
	{
		<Self as CodeAsmSar<T, U>>::sar(self, op0, op1)
	}

	/// `SARX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SARX r32a, r/m32, r32b` | `VEX.LZ.F3.0F38.W0 F7 /r` | `BMI2`
	/// `SARX r64a, r/m64, r64b` | `VEX.LZ.F3.0F38.W1 F7 /r` | `BMI2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn sarx<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmSarx<T, U, V>,
	{
		<Self as CodeAsmSarx<T, U, V>>::sarx(self, op0, op1, op2)
	}

	/// `SAVEPREVSSP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SAVEPREVSSP` | `F3 0F 01 EA` | `CET_SS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn saveprevssp(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSaveprevssp,
	{
		<Self as CodeAsmSaveprevssp>::saveprevssp(self)
	}

	/// `SBB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SBB r/m8, r8` | `18 /r` | `8086+`
	/// `SBB r/m16, r16` | `o16 19 /r` | `8086+`
	/// `SBB r/m32, r32` | `o32 19 /r` | `386+`
	/// `SBB r/m64, r64` | `o64 19 /r` | `X64`
	/// `SBB r8, r/m8` | `1A /r` | `8086+`
	/// `SBB r16, r/m16` | `o16 1B /r` | `8086+`
	/// `SBB r32, r/m32` | `o32 1B /r` | `386+`
	/// `SBB r64, r/m64` | `o64 1B /r` | `X64`
	/// `SBB AL, imm8` | `1C ib` | `8086+`
	/// `SBB AX, imm16` | `o16 1D iw` | `8086+`
	/// `SBB EAX, imm32` | `o32 1D id` | `386+`
	/// `SBB RAX, imm32` | `o64 1D id` | `X64`
	/// `SBB r/m8, imm8` | `80 /3 ib` | `8086+`
	/// `SBB r/m16, imm16` | `o16 81 /3 iw` | `8086+`
	/// `SBB r/m32, imm32` | `o32 81 /3 id` | `386+`
	/// `SBB r/m64, imm32` | `o64 81 /3 id` | `X64`
	/// `SBB r/m16, imm8` | `o16 83 /3 ib` | `8086+`
	/// `SBB r/m32, imm8` | `o32 83 /3 ib` | `386+`
	/// `SBB r/m64, imm8` | `o64 83 /3 ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sbb<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSbb<T, U>,
	{
		<Self as CodeAsmSbb<T, U>>::sbb(self, op0, op1)
	}

	/// `SCASB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SCASB` | `AE` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn scasb(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmScasb,
	{
		<Self as CodeAsmScasb>::scasb(self)
	}

	/// `SCASD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SCASD` | `o32 AF` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn scasd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmScasd,
	{
		<Self as CodeAsmScasd>::scasd(self)
	}

	/// `SCASQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SCASQ` | `o64 AF` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn scasq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmScasq,
	{
		<Self as CodeAsmScasq>::scasq(self)
	}

	/// `SCASW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SCASW` | `o16 AF` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn scasw(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmScasw,
	{
		<Self as CodeAsmScasw>::scasw(self)
	}

	/// `SEAMCALL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SEAMCALL` | `66 0F 01 CF` | `TDX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn seamcall(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSeamcall,
	{
		<Self as CodeAsmSeamcall>::seamcall(self)
	}

	/// `SEAMOPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SEAMOPS` | `66 0F 01 CE` | `TDX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn seamops(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSeamops,
	{
		<Self as CodeAsmSeamops>::seamops(self)
	}

	/// `SEAMRET` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SEAMRET` | `66 0F 01 CD` | `TDX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn seamret(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSeamret,
	{
		<Self as CodeAsmSeamret>::seamret(self)
	}

	/// `SENDUIPI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SENDUIPI r64` | `F3 0F C7 /6` | `UINTR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn senduipi<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSenduipi<T>,
	{
		<Self as CodeAsmSenduipi<T>>::senduipi(self, op0)
	}

	/// `SERIALIZE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SERIALIZE` | `NP 0F 01 E8` | `SERIALIZE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn serialize(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSerialize,
	{
		<Self as CodeAsmSerialize>::serialize(self)
	}

	/// `SETA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETA r/m8` | `0F 97 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn seta<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSeta<T>,
	{
		<Self as CodeAsmSeta<T>>::seta(self, op0)
	}

	/// `SETAE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETAE r/m8` | `0F 93 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setae<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetae<T>,
	{
		<Self as CodeAsmSetae<T>>::setae(self, op0)
	}

	/// `SETB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETB r/m8` | `0F 92 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setb<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetb<T>,
	{
		<Self as CodeAsmSetb<T>>::setb(self, op0)
	}

	/// `SETBE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETBE r/m8` | `0F 96 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setbe<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetbe<T>,
	{
		<Self as CodeAsmSetbe<T>>::setbe(self, op0)
	}

	/// `SETC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETB r/m8` | `0F 92 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setc<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetc<T>,
	{
		<Self as CodeAsmSetc<T>>::setc(self, op0)
	}

	/// `SETE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETE r/m8` | `0F 94 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn sete<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSete<T>,
	{
		<Self as CodeAsmSete<T>>::sete(self, op0)
	}

	/// `SETG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETG r/m8` | `0F 9F /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setg<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetg<T>,
	{
		<Self as CodeAsmSetg<T>>::setg(self, op0)
	}

	/// `SETGE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETGE r/m8` | `0F 9D /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setge<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetge<T>,
	{
		<Self as CodeAsmSetge<T>>::setge(self, op0)
	}

	/// `SETL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETL r/m8` | `0F 9C /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setl<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetl<T>,
	{
		<Self as CodeAsmSetl<T>>::setl(self, op0)
	}

	/// `SETLE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETLE r/m8` | `0F 9E /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setle<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetle<T>,
	{
		<Self as CodeAsmSetle<T>>::setle(self, op0)
	}

	/// `SETNA` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETBE r/m8` | `0F 96 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setna<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetna<T>,
	{
		<Self as CodeAsmSetna<T>>::setna(self, op0)
	}

	/// `SETNAE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETB r/m8` | `0F 92 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setnae<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetnae<T>,
	{
		<Self as CodeAsmSetnae<T>>::setnae(self, op0)
	}

	/// `SETNB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETAE r/m8` | `0F 93 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setnb<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetnb<T>,
	{
		<Self as CodeAsmSetnb<T>>::setnb(self, op0)
	}

	/// `SETNBE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETA r/m8` | `0F 97 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setnbe<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetnbe<T>,
	{
		<Self as CodeAsmSetnbe<T>>::setnbe(self, op0)
	}

	/// `SETNC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETAE r/m8` | `0F 93 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setnc<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetnc<T>,
	{
		<Self as CodeAsmSetnc<T>>::setnc(self, op0)
	}

	/// `SETNE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETNE r/m8` | `0F 95 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setne<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetne<T>,
	{
		<Self as CodeAsmSetne<T>>::setne(self, op0)
	}

	/// `SETNG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETLE r/m8` | `0F 9E /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setng<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetng<T>,
	{
		<Self as CodeAsmSetng<T>>::setng(self, op0)
	}

	/// `SETNGE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETL r/m8` | `0F 9C /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setnge<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetnge<T>,
	{
		<Self as CodeAsmSetnge<T>>::setnge(self, op0)
	}

	/// `SETNL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETGE r/m8` | `0F 9D /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setnl<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetnl<T>,
	{
		<Self as CodeAsmSetnl<T>>::setnl(self, op0)
	}

	/// `SETNLE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETG r/m8` | `0F 9F /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setnle<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetnle<T>,
	{
		<Self as CodeAsmSetnle<T>>::setnle(self, op0)
	}

	/// `SETNO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETNO r/m8` | `0F 91 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setno<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetno<T>,
	{
		<Self as CodeAsmSetno<T>>::setno(self, op0)
	}

	/// `SETNP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETNP r/m8` | `0F 9B /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setnp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetnp<T>,
	{
		<Self as CodeAsmSetnp<T>>::setnp(self, op0)
	}

	/// `SETNS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETNS r/m8` | `0F 99 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setns<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetns<T>,
	{
		<Self as CodeAsmSetns<T>>::setns(self, op0)
	}

	/// `SETNZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETNE r/m8` | `0F 95 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setnz<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetnz<T>,
	{
		<Self as CodeAsmSetnz<T>>::setnz(self, op0)
	}

	/// `SETO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETO r/m8` | `0F 90 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn seto<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSeto<T>,
	{
		<Self as CodeAsmSeto<T>>::seto(self, op0)
	}

	/// `SETP` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETP r/m8` | `0F 9A /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setp<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetp<T>,
	{
		<Self as CodeAsmSetp<T>>::setp(self, op0)
	}

	/// `SETPE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETP r/m8` | `0F 9A /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setpe<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetpe<T>,
	{
		<Self as CodeAsmSetpe<T>>::setpe(self, op0)
	}

	/// `SETPO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETNP r/m8` | `0F 9B /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setpo<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetpo<T>,
	{
		<Self as CodeAsmSetpo<T>>::setpo(self, op0)
	}

	/// `SETS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETS r/m8` | `0F 98 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn sets<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSets<T>,
	{
		<Self as CodeAsmSets<T>>::sets(self, op0)
	}

	/// `SETSSBSY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETSSBSY` | `F3 0F 01 E8` | `CET_SS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn setssbsy(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSetssbsy,
	{
		<Self as CodeAsmSetssbsy>::setssbsy(self)
	}

	/// `SETZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SETE r/m8` | `0F 94 /r` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn setz<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSetz<T>,
	{
		<Self as CodeAsmSetz<T>>::setz(self, op0)
	}

	/// `SFENCE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SFENCE` | `NP 0F AE F8` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn sfence(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSfence,
	{
		<Self as CodeAsmSfence>::sfence(self)
	}

	/// `SGDT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SGDT m` | `0F 01 /0` | `X64`
	/// `SGDT m` | `o16 0F 01 /0` | `286+`
	/// `SGDT m` | `o32 0F 01 /0` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn sgdt<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSgdt<T>,
	{
		<Self as CodeAsmSgdt<T>>::sgdt(self, op0)
	}

	/// `SHA1MSG1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHA1MSG1 xmm1, xmm2/m128` | `NP 0F 38 C9 /r` | `SHA`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sha1msg1<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSha1msg1<T, U>,
	{
		<Self as CodeAsmSha1msg1<T, U>>::sha1msg1(self, op0, op1)
	}

	/// `SHA1MSG2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHA1MSG2 xmm1, xmm2/m128` | `NP 0F 38 CA /r` | `SHA`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sha1msg2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSha1msg2<T, U>,
	{
		<Self as CodeAsmSha1msg2<T, U>>::sha1msg2(self, op0, op1)
	}

	/// `SHA1NEXTE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHA1NEXTE xmm1, xmm2/m128` | `NP 0F 38 C8 /r` | `SHA`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sha1nexte<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSha1nexte<T, U>,
	{
		<Self as CodeAsmSha1nexte<T, U>>::sha1nexte(self, op0, op1)
	}

	/// `SHA1RNDS4` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHA1RNDS4 xmm1, xmm2/m128, imm8` | `NP 0F 3A CC /r ib` | `SHA`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn sha1rnds4<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmSha1rnds4<T, U, V>,
	{
		<Self as CodeAsmSha1rnds4<T, U, V>>::sha1rnds4(self, op0, op1, op2)
	}

	/// `SHA256MSG1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHA256MSG1 xmm1, xmm2/m128` | `NP 0F 38 CC /r` | `SHA`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sha256msg1<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSha256msg1<T, U>,
	{
		<Self as CodeAsmSha256msg1<T, U>>::sha256msg1(self, op0, op1)
	}

	/// `SHA256MSG2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHA256MSG2 xmm1, xmm2/m128` | `NP 0F 38 CD /r` | `SHA`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sha256msg2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSha256msg2<T, U>,
	{
		<Self as CodeAsmSha256msg2<T, U>>::sha256msg2(self, op0, op1)
	}

	/// `SHA256RNDS2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHA256RNDS2 xmm1, xmm2/m128, <XMM0>` | `NP 0F 38 CB /r` | `SHA`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sha256rnds2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSha256rnds2<T, U>,
	{
		<Self as CodeAsmSha256rnds2<T, U>>::sha256rnds2(self, op0, op1)
	}

	/// `SHL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHL r/m8, imm8` | `C0 /4 ib` | `186+`
	/// `SHL r/m16, imm8` | `o16 C1 /4 ib` | `186+`
	/// `SHL r/m32, imm8` | `o32 C1 /4 ib` | `386+`
	/// `SHL r/m64, imm8` | `o64 C1 /4 ib` | `X64`
	/// `SHL r/m8, 1` | `D0 /4` | `8086+`
	/// `SHL r/m16, 1` | `o16 D1 /4` | `8086+`
	/// `SHL r/m32, 1` | `o32 D1 /4` | `386+`
	/// `SHL r/m64, 1` | `o64 D1 /4` | `X64`
	/// `SHL r/m8, CL` | `D2 /4` | `8086+`
	/// `SHL r/m16, CL` | `o16 D3 /4` | `8086+`
	/// `SHL r/m32, CL` | `o32 D3 /4` | `386+`
	/// `SHL r/m64, CL` | `o64 D3 /4` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn shl<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmShl<T, U>,
	{
		<Self as CodeAsmShl<T, U>>::shl(self, op0, op1)
	}

	/// `SHLD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHLD r/m16, r16, imm8` | `o16 0F A4 /r ib` | `386+`
	/// `SHLD r/m32, r32, imm8` | `o32 0F A4 /r ib` | `386+`
	/// `SHLD r/m64, r64, imm8` | `o64 0F A4 /r ib` | `X64`
	/// `SHLD r/m16, r16, CL` | `o16 0F A5 /r` | `386+`
	/// `SHLD r/m32, r32, CL` | `o32 0F A5 /r` | `386+`
	/// `SHLD r/m64, r64, CL` | `o64 0F A5 /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn shld<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmShld<T, U, V>,
	{
		<Self as CodeAsmShld<T, U, V>>::shld(self, op0, op1, op2)
	}

	/// `SHLX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHLX r32a, r/m32, r32b` | `VEX.LZ.66.0F38.W0 F7 /r` | `BMI2`
	/// `SHLX r64a, r/m64, r64b` | `VEX.LZ.66.0F38.W1 F7 /r` | `BMI2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn shlx<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmShlx<T, U, V>,
	{
		<Self as CodeAsmShlx<T, U, V>>::shlx(self, op0, op1, op2)
	}

	/// `SHR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHR r/m8, imm8` | `C0 /5 ib` | `186+`
	/// `SHR r/m16, imm8` | `o16 C1 /5 ib` | `186+`
	/// `SHR r/m32, imm8` | `o32 C1 /5 ib` | `386+`
	/// `SHR r/m64, imm8` | `o64 C1 /5 ib` | `X64`
	/// `SHR r/m8, 1` | `D0 /5` | `8086+`
	/// `SHR r/m16, 1` | `o16 D1 /5` | `8086+`
	/// `SHR r/m32, 1` | `o32 D1 /5` | `386+`
	/// `SHR r/m64, 1` | `o64 D1 /5` | `X64`
	/// `SHR r/m8, CL` | `D2 /5` | `8086+`
	/// `SHR r/m16, CL` | `o16 D3 /5` | `8086+`
	/// `SHR r/m32, CL` | `o32 D3 /5` | `386+`
	/// `SHR r/m64, CL` | `o64 D3 /5` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn shr<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmShr<T, U>,
	{
		<Self as CodeAsmShr<T, U>>::shr(self, op0, op1)
	}

	/// `SHRD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHRD r/m16, r16, imm8` | `o16 0F AC /r ib` | `386+`
	/// `SHRD r/m32, r32, imm8` | `o32 0F AC /r ib` | `386+`
	/// `SHRD r/m64, r64, imm8` | `o64 0F AC /r ib` | `X64`
	/// `SHRD r/m16, r16, CL` | `o16 0F AD /r` | `386+`
	/// `SHRD r/m32, r32, CL` | `o32 0F AD /r` | `386+`
	/// `SHRD r/m64, r64, CL` | `o64 0F AD /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn shrd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmShrd<T, U, V>,
	{
		<Self as CodeAsmShrd<T, U, V>>::shrd(self, op0, op1, op2)
	}

	/// `SHRX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHRX r32a, r/m32, r32b` | `VEX.LZ.F2.0F38.W0 F7 /r` | `BMI2`
	/// `SHRX r64a, r/m64, r64b` | `VEX.LZ.F2.0F38.W1 F7 /r` | `BMI2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn shrx<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmShrx<T, U, V>,
	{
		<Self as CodeAsmShrx<T, U, V>>::shrx(self, op0, op1, op2)
	}

	/// `SHUFPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHUFPD xmm1, xmm2/m128, imm8` | `66 0F C6 /r ib` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn shufpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmShufpd<T, U, V>,
	{
		<Self as CodeAsmShufpd<T, U, V>>::shufpd(self, op0, op1, op2)
	}

	/// `SHUFPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SHUFPS xmm1, xmm2/m128, imm8` | `NP 0F C6 /r ib` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn shufps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmShufps<T, U, V>,
	{
		<Self as CodeAsmShufps<T, U, V>>::shufps(self, op0, op1, op2)
	}

	/// `SIDT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SIDT m` | `0F 01 /1` | `X64`
	/// `SIDT m` | `o16 0F 01 /1` | `286+`
	/// `SIDT m` | `o32 0F 01 /1` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn sidt<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSidt<T>,
	{
		<Self as CodeAsmSidt<T>>::sidt(self, op0)
	}

	/// `SKINIT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SKINIT` | `0F 01 DE` | `SKINIT or SVM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn skinit(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSkinit,
	{
		<Self as CodeAsmSkinit>::skinit(self)
	}

	/// `SLDT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SLDT r/m16` | `o16 0F 00 /0` | `286+`
	/// `SLDT r32/m16` | `o32 0F 00 /0` | `386+`
	/// `SLDT r64/m16` | `o64 0F 00 /0` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn sldt<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSldt<T>,
	{
		<Self as CodeAsmSldt<T>>::sldt(self, op0)
	}

	/// `SLWPCB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SLWPCB r32` | `XOP.L0.X9.W0 12 /1` | `LWP`
	/// `SLWPCB r64` | `XOP.L0.X9.W1 12 /1` | `LWP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn slwpcb<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSlwpcb<T>,
	{
		<Self as CodeAsmSlwpcb<T>>::slwpcb(self, op0)
	}

	/// `SMINT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SMINT` | `0F 38` | `Cyrix 6x86MX+, AMD Geode GX/LX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn smint(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSmint,
	{
		<Self as CodeAsmSmint>::smint(self)
	}

	/// `SMINT_0F7E` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SMINT` | `0F 7E` | `Cyrix 6x86 or earlier`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn smint_0f7e(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSmint_0f7e,
	{
		<Self as CodeAsmSmint_0f7e>::smint_0f7e(self)
	}

	/// `SMSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SMSW r/m16` | `o16 0F 01 /4` | `286+`
	/// `SMSW r32/m16` | `o32 0F 01 /4` | `386+`
	/// `SMSW r64/m16` | `o64 0F 01 /4` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn smsw<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSmsw<T>,
	{
		<Self as CodeAsmSmsw<T>>::smsw(self, op0)
	}

	/// `SQRTPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SQRTPD xmm1, xmm2/m128` | `66 0F 51 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sqrtpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSqrtpd<T, U>,
	{
		<Self as CodeAsmSqrtpd<T, U>>::sqrtpd(self, op0, op1)
	}

	/// `SQRTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SQRTPS xmm1, xmm2/m128` | `NP 0F 51 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sqrtps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSqrtps<T, U>,
	{
		<Self as CodeAsmSqrtps<T, U>>::sqrtps(self, op0, op1)
	}

	/// `SQRTSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SQRTSD xmm1, xmm2/m64` | `F2 0F 51 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sqrtsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSqrtsd<T, U>,
	{
		<Self as CodeAsmSqrtsd<T, U>>::sqrtsd(self, op0, op1)
	}

	/// `SQRTSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SQRTSS xmm1, xmm2/m32` | `F3 0F 51 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sqrtss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSqrtss<T, U>,
	{
		<Self as CodeAsmSqrtss<T, U>>::sqrtss(self, op0, op1)
	}

	/// `STAC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STAC` | `NP 0F 01 CB` | `SMAP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn stac(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmStac,
	{
		<Self as CodeAsmStac>::stac(self)
	}

	/// `STC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STC` | `F9` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn stc(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmStc,
	{
		<Self as CodeAsmStc>::stc(self)
	}

	/// `STD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STD` | `FD` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn std(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmStd,
	{
		<Self as CodeAsmStd>::std(self)
	}

	/// `STGI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STGI` | `0F 01 DC` | `SKINIT or SVM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn stgi(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmStgi,
	{
		<Self as CodeAsmStgi>::stgi(self)
	}

	/// `STI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STI` | `FB` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn sti(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSti,
	{
		<Self as CodeAsmSti>::sti(self)
	}

	/// `STMXCSR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STMXCSR m32` | `NP 0F AE /3` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn stmxcsr<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmStmxcsr<T>,
	{
		<Self as CodeAsmStmxcsr<T>>::stmxcsr(self, op0)
	}

	/// `STOSB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STOSB` | `AA` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn stosb(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmStosb,
	{
		<Self as CodeAsmStosb>::stosb(self)
	}

	/// `STOSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STOSD` | `o32 AB` | `386+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn stosd(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmStosd,
	{
		<Self as CodeAsmStosd>::stosd(self)
	}

	/// `STOSQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STOSQ` | `o64 AB` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn stosq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmStosq,
	{
		<Self as CodeAsmStosq>::stosq(self)
	}

	/// `STOSW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STOSW` | `o16 AB` | `8086+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn stosw(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmStosw,
	{
		<Self as CodeAsmStosw>::stosw(self)
	}

	/// `STR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STR r/m16` | `o16 0F 00 /1` | `286+`
	/// `STR r32/m16` | `o32 0F 00 /1` | `386+`
	/// `STR r64/m16` | `o64 0F 00 /1` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn str<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmStr<T>,
	{
		<Self as CodeAsmStr<T>>::str(self, op0)
	}

	/// `STTILECFG` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STTILECFG m512` | `VEX.128.66.0F38.W0 49 !(11):000:bbb` | `AMX-TILE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn sttilecfg<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSttilecfg<T>,
	{
		<Self as CodeAsmSttilecfg<T>>::sttilecfg(self, op0)
	}

	/// `STUI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `STUI` | `F3 0F 01 EF` | `UINTR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn stui(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmStui,
	{
		<Self as CodeAsmStui>::stui(self)
	}

	/// `SUB` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SUB r/m8, r8` | `28 /r` | `8086+`
	/// `SUB r/m16, r16` | `o16 29 /r` | `8086+`
	/// `SUB r/m32, r32` | `o32 29 /r` | `386+`
	/// `SUB r/m64, r64` | `o64 29 /r` | `X64`
	/// `SUB r8, r/m8` | `2A /r` | `8086+`
	/// `SUB r16, r/m16` | `o16 2B /r` | `8086+`
	/// `SUB r32, r/m32` | `o32 2B /r` | `386+`
	/// `SUB r64, r/m64` | `o64 2B /r` | `X64`
	/// `SUB AL, imm8` | `2C ib` | `8086+`
	/// `SUB AX, imm16` | `o16 2D iw` | `8086+`
	/// `SUB EAX, imm32` | `o32 2D id` | `386+`
	/// `SUB RAX, imm32` | `o64 2D id` | `X64`
	/// `SUB r/m8, imm8` | `80 /5 ib` | `8086+`
	/// `SUB r/m16, imm16` | `o16 81 /5 iw` | `8086+`
	/// `SUB r/m32, imm32` | `o32 81 /5 id` | `386+`
	/// `SUB r/m64, imm32` | `o64 81 /5 id` | `X64`
	/// `SUB r/m16, imm8` | `o16 83 /5 ib` | `8086+`
	/// `SUB r/m32, imm8` | `o32 83 /5 ib` | `386+`
	/// `SUB r/m64, imm8` | `o64 83 /5 ib` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn sub<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSub<T, U>,
	{
		<Self as CodeAsmSub<T, U>>::sub(self, op0, op1)
	}

	/// `SUBPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SUBPD xmm1, xmm2/m128` | `66 0F 5C /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn subpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSubpd<T, U>,
	{
		<Self as CodeAsmSubpd<T, U>>::subpd(self, op0, op1)
	}

	/// `SUBPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SUBPS xmm1, xmm2/m128` | `NP 0F 5C /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn subps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSubps<T, U>,
	{
		<Self as CodeAsmSubps<T, U>>::subps(self, op0, op1)
	}

	/// `SUBSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SUBSD xmm1, xmm2/m64` | `F2 0F 5C /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn subsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSubsd<T, U>,
	{
		<Self as CodeAsmSubsd<T, U>>::subsd(self, op0, op1)
	}

	/// `SUBSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SUBSS xmm1, xmm2/m32` | `F3 0F 5C /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn subss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSubss<T, U>,
	{
		<Self as CodeAsmSubss<T, U>>::subss(self, op0, op1)
	}

	/// `SVDC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SVDC m80, Sreg` | `0F 78 /r` | `Cyrix, AMD Geode GX/LX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn svdc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmSvdc<T, U>,
	{
		<Self as CodeAsmSvdc<T, U>>::svdc(self, op0, op1)
	}

	/// `SVLDT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SVLDT m80` | `0F 7A /0` | `Cyrix, AMD Geode GX/LX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn svldt<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSvldt<T>,
	{
		<Self as CodeAsmSvldt<T>>::svldt(self, op0)
	}

	/// `SVTS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SVTS m80` | `0F 7C /0` | `Cyrix, AMD Geode GX/LX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn svts<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmSvts<T>,
	{
		<Self as CodeAsmSvts<T>>::svts(self, op0)
	}

	/// `SWAPGS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SWAPGS` | `0F 01 F8` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn swapgs(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSwapgs,
	{
		<Self as CodeAsmSwapgs>::swapgs(self)
	}

	/// `SYSCALL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SYSCALL` | `0F 05` | `SYSCALL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn syscall(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSyscall,
	{
		<Self as CodeAsmSyscall>::syscall(self)
	}

	/// `SYSENTER` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SYSENTER` | `0F 34` | `SEP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn sysenter(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSysenter,
	{
		<Self as CodeAsmSysenter>::sysenter(self)
	}

	/// `SYSEXIT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SYSEXIT` | `0F 35` | `SEP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn sysexit(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSysexit,
	{
		<Self as CodeAsmSysexit>::sysexit(self)
	}

	/// `SYSEXITQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SYSEXITQ` | `o64 0F 35` | `SEP`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn sysexitq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSysexitq,
	{
		<Self as CodeAsmSysexitq>::sysexitq(self)
	}

	/// `SYSRET` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SYSRET` | `0F 07` | `SYSCALL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn sysret(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSysret,
	{
		<Self as CodeAsmSysret>::sysret(self)
	}

	/// `SYSRETQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `SYSRETQ` | `o64 0F 07` | `SYSCALL`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn sysretq(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmSysretq,
	{
		<Self as CodeAsmSysretq>::sysretq(self)
	}

	/// `T1MSKC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `T1MSKC r32, r/m32` | `XOP.L0.X9.W0 01 /7` | `TBM`
	/// `T1MSKC r64, r/m64` | `XOP.L0.X9.W1 01 /7` | `TBM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn t1mskc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmT1mskc<T, U>,
	{
		<Self as CodeAsmT1mskc<T, U>>::t1mskc(self, op0, op1)
	}

	/// `TCMMIMFP16PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TCMMIMFP16PS tmm1, tmm2, tmm3` | `VEX.128.66.0F38.W0 6C 11:rrr:bbb` | `AMX-COMPLEX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn tcmmimfp16ps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmTcmmimfp16ps<T, U, V>,
	{
		<Self as CodeAsmTcmmimfp16ps<T, U, V>>::tcmmimfp16ps(self, op0, op1, op2)
	}

	/// `TCMMRLFP16PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TCMMRLFP16PS tmm1, tmm2, tmm3` | `VEX.128.0F38.W0 6C 11:rrr:bbb` | `AMX-COMPLEX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn tcmmrlfp16ps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmTcmmrlfp16ps<T, U, V>,
	{
		<Self as CodeAsmTcmmrlfp16ps<T, U, V>>::tcmmrlfp16ps(self, op0, op1, op2)
	}

	/// `TDCALL` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TDCALL` | `66 0F 01 CC` | `TDX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn tdcall(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmTdcall,
	{
		<Self as CodeAsmTdcall>::tdcall(self)
	}

	/// `TDPBF16PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TDPBF16PS tmm1, tmm2, tmm3` | `VEX.128.F3.0F38.W0 5C 11:rrr:bbb` | `AMX-BF16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn tdpbf16ps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmTdpbf16ps<T, U, V>,
	{
		<Self as CodeAsmTdpbf16ps<T, U, V>>::tdpbf16ps(self, op0, op1, op2)
	}

	/// `TDPBSSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TDPBSSD tmm1, tmm2, tmm3` | `VEX.128.F2.0F38.W0 5E 11:rrr:bbb` | `AMX-INT8`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn tdpbssd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmTdpbssd<T, U, V>,
	{
		<Self as CodeAsmTdpbssd<T, U, V>>::tdpbssd(self, op0, op1, op2)
	}

	/// `TDPBSUD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TDPBSUD tmm1, tmm2, tmm3` | `VEX.128.F3.0F38.W0 5E 11:rrr:bbb` | `AMX-INT8`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn tdpbsud<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmTdpbsud<T, U, V>,
	{
		<Self as CodeAsmTdpbsud<T, U, V>>::tdpbsud(self, op0, op1, op2)
	}

	/// `TDPBUSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TDPBUSD tmm1, tmm2, tmm3` | `VEX.128.66.0F38.W0 5E 11:rrr:bbb` | `AMX-INT8`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn tdpbusd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmTdpbusd<T, U, V>,
	{
		<Self as CodeAsmTdpbusd<T, U, V>>::tdpbusd(self, op0, op1, op2)
	}

	/// `TDPBUUD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TDPBUUD tmm1, tmm2, tmm3` | `VEX.128.0F38.W0 5E 11:rrr:bbb` | `AMX-INT8`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn tdpbuud<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmTdpbuud<T, U, V>,
	{
		<Self as CodeAsmTdpbuud<T, U, V>>::tdpbuud(self, op0, op1, op2)
	}

	/// `TDPFP16PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TDPFP16PS tmm1, tmm2, tmm3` | `VEX.128.F2.0F38.W0 5C 11:rrr:bbb` | `AMX-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn tdpfp16ps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmTdpfp16ps<T, U, V>,
	{
		<Self as CodeAsmTdpfp16ps<T, U, V>>::tdpfp16ps(self, op0, op1, op2)
	}

	/// `TEST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TEST r/m8, r8` | `84 /r` | `8086+`
	/// `TEST r/m16, r16` | `o16 85 /r` | `8086+`
	/// `TEST r/m32, r32` | `o32 85 /r` | `386+`
	/// `TEST r/m64, r64` | `o64 85 /r` | `X64`
	/// `TEST AL, imm8` | `A8 ib` | `8086+`
	/// `TEST AX, imm16` | `o16 A9 iw` | `8086+`
	/// `TEST EAX, imm32` | `o32 A9 id` | `386+`
	/// `TEST RAX, imm32` | `o64 A9 id` | `X64`
	/// `TEST r/m8, imm8` | `F6 /0 ib` | `8086+`
	/// `TEST r/m16, imm16` | `o16 F7 /0 iw` | `8086+`
	/// `TEST r/m32, imm32` | `o32 F7 /0 id` | `386+`
	/// `TEST r/m64, imm32` | `o64 F7 /0 id` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn test<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmTest<T, U>,
	{
		<Self as CodeAsmTest<T, U>>::test(self, op0, op1)
	}

	/// `TESTUI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TESTUI` | `F3 0F 01 ED` | `UINTR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn testui(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmTestui,
	{
		<Self as CodeAsmTestui>::testui(self)
	}

	/// `TILELOADD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TILELOADD tmm1, sibmem` | `VEX.128.F2.0F38.W0 4B !(11):rrr:100` | `AMX-TILE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn tileloadd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmTileloadd<T, U>,
	{
		<Self as CodeAsmTileloadd<T, U>>::tileloadd(self, op0, op1)
	}

	/// `TILELOADDT1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TILELOADDT1 tmm1, sibmem` | `VEX.128.66.0F38.W0 4B !(11):rrr:100` | `AMX-TILE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn tileloaddt1<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmTileloaddt1<T, U>,
	{
		<Self as CodeAsmTileloaddt1<T, U>>::tileloaddt1(self, op0, op1)
	}

	/// `TILERELEASE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TILERELEASE` | `VEX.128.0F38.W0 49 C0` | `AMX-TILE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn tilerelease(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmTilerelease,
	{
		<Self as CodeAsmTilerelease>::tilerelease(self)
	}

	/// `TILESTORED` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TILESTORED sibmem, tmm1` | `VEX.128.F3.0F38.W0 4B !(11):rrr:100` | `AMX-TILE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn tilestored<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmTilestored<T, U>,
	{
		<Self as CodeAsmTilestored<T, U>>::tilestored(self, op0, op1)
	}

	/// `TILEZERO` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TILEZERO tmm1` | `VEX.128.F2.0F38.W0 49 11:rrr:000` | `AMX-TILE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn tilezero<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmTilezero<T>,
	{
		<Self as CodeAsmTilezero<T>>::tilezero(self, op0)
	}

	/// `TLBSYNC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TLBSYNC` | `NP 0F 01 FF` | `INVLPGB`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn tlbsync(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmTlbsync,
	{
		<Self as CodeAsmTlbsync>::tlbsync(self)
	}

	/// `TPAUSE` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TPAUSE r32, <edx>, <eax>` | `66 0F AE /6` | `WAITPKG`
	/// `TPAUSE r64, <edx>, <eax>` | `66 o64 0F AE /6` | `WAITPKG`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn tpause<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmTpause<T>,
	{
		<Self as CodeAsmTpause<T>>::tpause(self, op0)
	}

	/// `TZCNT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TZCNT r16, r/m16` | `o16 F3 0F BC /r` | `BMI1`
	/// `TZCNT r32, r/m32` | `o32 F3 0F BC /r` | `BMI1`
	/// `TZCNT r64, r/m64` | `F3 o64 0F BC /r` | `BMI1`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn tzcnt<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmTzcnt<T, U>,
	{
		<Self as CodeAsmTzcnt<T, U>>::tzcnt(self, op0, op1)
	}

	/// `TZMSK` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `TZMSK r32, r/m32` | `XOP.L0.X9.W0 01 /4` | `TBM`
	/// `TZMSK r64, r/m64` | `XOP.L0.X9.W1 01 /4` | `TBM`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn tzmsk<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmTzmsk<T, U>,
	{
		<Self as CodeAsmTzmsk<T, U>>::tzmsk(self, op0, op1)
	}

	/// `UCOMISD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UCOMISD xmm1, xmm2/m64` | `66 0F 2E /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn ucomisd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmUcomisd<T, U>,
	{
		<Self as CodeAsmUcomisd<T, U>>::ucomisd(self, op0, op1)
	}

	/// `UCOMISS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UCOMISS xmm1, xmm2/m32` | `NP 0F 2E /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn ucomiss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmUcomiss<T, U>,
	{
		<Self as CodeAsmUcomiss<T, U>>::ucomiss(self, op0, op1)
	}

	/// `UD0` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UD0` | `0F FF` | `286+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn ud0(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmUd0,
	{
		<Self as CodeAsmUd0>::ud0(self)
	}

	/// `UD0` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UD0 r16, r/m16` | `o16 0F FF /r` | `286+`
	/// `UD0 r32, r/m32` | `o32 0F FF /r` | `386+`
	/// `UD0 r64, r/m64` | `o64 0F FF /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn ud0_2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmUd02<T, U>,
	{
		<Self as CodeAsmUd02<T, U>>::ud0_2(self, op0, op1)
	}

	/// `UD1` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UD1 r16, r/m16` | `o16 0F B9 /r` | `286+`
	/// `UD1 r32, r/m32` | `o32 0F B9 /r` | `386+`
	/// `UD1 r64, r/m64` | `o64 0F B9 /r` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn ud1<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmUd1<T, U>,
	{
		<Self as CodeAsmUd1<T, U>>::ud1(self, op0, op1)
	}

	/// `UD2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UD2` | `0F 0B` | `286+`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn ud2(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmUd2,
	{
		<Self as CodeAsmUd2>::ud2(self)
	}

	/// `UIRET` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UIRET` | `F3 0F 01 EC` | `UINTR`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	#[inline]
	pub fn uiret(&mut self) -> Result<(), IcedError>
	where
		Self: CodeAsmUiret,
	{
		<Self as CodeAsmUiret>::uiret(self)
	}

	/// `UMONITOR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UMONITOR r16` | `a16 F3 0F AE /6` | `WAITPKG`
	/// `UMONITOR r32` | `a32 F3 0F AE /6` | `WAITPKG`
	/// `UMONITOR r64` | `a64 F3 0F AE /6` | `WAITPKG`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn umonitor<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmUmonitor<T>,
	{
		<Self as CodeAsmUmonitor<T>>::umonitor(self, op0)
	}

	/// `UMOV` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UMOV r/m8, r8` | `0F 10 /r` | `386/486`
	/// `UMOV r/m16, r16` | `o16 0F 11 /r` | `386/486`
	/// `UMOV r/m32, r32` | `o32 0F 11 /r` | `386/486`
	/// `UMOV r8, r/m8` | `0F 12 /r` | `386/486`
	/// `UMOV r16, r/m16` | `o16 0F 13 /r` | `386/486`
	/// `UMOV r32, r/m32` | `o32 0F 13 /r` | `386/486`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn umov<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmUmov<T, U>,
	{
		<Self as CodeAsmUmov<T, U>>::umov(self, op0, op1)
	}

	/// `UMWAIT` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UMWAIT r32, <edx>, <eax>` | `F2 0F AE /6` | `WAITPKG`
	/// `UMWAIT r64, <edx>, <eax>` | `F2 o64 0F AE /6` | `WAITPKG`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn umwait<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmUmwait<T>,
	{
		<Self as CodeAsmUmwait<T>>::umwait(self, op0)
	}

	/// `UNPCKHPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UNPCKHPD xmm1, xmm2/m128` | `66 0F 15 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn unpckhpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmUnpckhpd<T, U>,
	{
		<Self as CodeAsmUnpckhpd<T, U>>::unpckhpd(self, op0, op1)
	}

	/// `UNPCKHPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UNPCKHPS xmm1, xmm2/m128` | `NP 0F 15 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn unpckhps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmUnpckhps<T, U>,
	{
		<Self as CodeAsmUnpckhps<T, U>>::unpckhps(self, op0, op1)
	}

	/// `UNPCKLPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UNPCKLPD xmm1, xmm2/m128` | `66 0F 14 /r` | `SSE2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn unpcklpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmUnpcklpd<T, U>,
	{
		<Self as CodeAsmUnpcklpd<T, U>>::unpcklpd(self, op0, op1)
	}

	/// `UNPCKLPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `UNPCKLPS xmm1, xmm2/m128` | `NP 0F 14 /r` | `SSE`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn unpcklps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmUnpcklps<T, U>,
	{
		<Self as CodeAsmUnpcklps<T, U>>::unpcklps(self, op0, op1)
	}

	/// `V4FMADDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `V4FMADDPS zmm1 {k1}{z}, zmm2+3, m128` | `EVEX.512.F2.0F38.W0 9A /r` | `AVX512_4FMAPS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn v4fmaddps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmV4fmaddps<T, U, V>,
	{
		<Self as CodeAsmV4fmaddps<T, U, V>>::v4fmaddps(self, op0, op1, op2)
	}

	/// `V4FMADDSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `V4FMADDSS xmm1 {k1}{z}, xmm2+3, m128` | `EVEX.LIG.F2.0F38.W0 9B /r` | `AVX512_4FMAPS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn v4fmaddss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmV4fmaddss<T, U, V>,
	{
		<Self as CodeAsmV4fmaddss<T, U, V>>::v4fmaddss(self, op0, op1, op2)
	}

	/// `V4FNMADDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `V4FNMADDPS zmm1 {k1}{z}, zmm2+3, m128` | `EVEX.512.F2.0F38.W0 AA /r` | `AVX512_4FMAPS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn v4fnmaddps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmV4fnmaddps<T, U, V>,
	{
		<Self as CodeAsmV4fnmaddps<T, U, V>>::v4fnmaddps(self, op0, op1, op2)
	}

	/// `V4FNMADDSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `V4FNMADDSS xmm1 {k1}{z}, xmm2+3, m128` | `EVEX.LIG.F2.0F38.W0 AB /r` | `AVX512_4FMAPS`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn v4fnmaddss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmV4fnmaddss<T, U, V>,
	{
		<Self as CodeAsmV4fnmaddss<T, U, V>>::v4fnmaddss(self, op0, op1, op2)
	}

	/// `VADDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VADDPD xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F.WIG 58 /r` | `AVX`
	/// `VADDPD ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F.WIG 58 /r` | `AVX`
	/// `VADDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst` | `EVEX.128.66.0F.W1 58 /r` | `AVX512VL AVX512F`
	/// `VADDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst` | `EVEX.256.66.0F.W1 58 /r` | `AVX512VL AVX512F`
	/// `VADDPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}` | `EVEX.512.66.0F.W1 58 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaddpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaddpd<T, U, V>,
	{
		<Self as CodeAsmVaddpd<T, U, V>>::vaddpd(self, op0, op1, op2)
	}

	/// `VADDPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VADDPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst` | `EVEX.128.MAP5.W0 58 /r` | `AVX512VL AVX512-FP16`
	/// `VADDPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst` | `EVEX.256.MAP5.W0 58 /r` | `AVX512VL AVX512-FP16`
	/// `VADDPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}` | `EVEX.512.MAP5.W0 58 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaddph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaddph<T, U, V>,
	{
		<Self as CodeAsmVaddph<T, U, V>>::vaddph(self, op0, op1, op2)
	}

	/// `VADDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VADDPS xmm1, xmm2, xmm3/m128` | `VEX.128.0F.WIG 58 /r` | `AVX`
	/// `VADDPS ymm1, ymm2, ymm3/m256` | `VEX.256.0F.WIG 58 /r` | `AVX`
	/// `VADDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.0F.W0 58 /r` | `AVX512VL AVX512F`
	/// `VADDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.0F.W0 58 /r` | `AVX512VL AVX512F`
	/// `VADDPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}` | `EVEX.512.0F.W0 58 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaddps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaddps<T, U, V>,
	{
		<Self as CodeAsmVaddps<T, U, V>>::vaddps(self, op0, op1, op2)
	}

	/// `VADDSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VADDSD xmm1, xmm2, xmm3/m64` | `VEX.LIG.F2.0F.WIG 58 /r` | `AVX`
	/// `VADDSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}` | `EVEX.LIG.F2.0F.W1 58 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaddsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaddsd<T, U, V>,
	{
		<Self as CodeAsmVaddsd<T, U, V>>::vaddsd(self, op0, op1, op2)
	}

	/// `VADDSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VADDSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}` | `EVEX.LIG.F3.MAP5.W0 58 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaddsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaddsh<T, U, V>,
	{
		<Self as CodeAsmVaddsh<T, U, V>>::vaddsh(self, op0, op1, op2)
	}

	/// `VADDSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VADDSS xmm1, xmm2, xmm3/m32` | `VEX.LIG.F3.0F.WIG 58 /r` | `AVX`
	/// `VADDSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}` | `EVEX.LIG.F3.0F.W0 58 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaddss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaddss<T, U, V>,
	{
		<Self as CodeAsmVaddss<T, U, V>>::vaddss(self, op0, op1, op2)
	}

	/// `VADDSUBPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VADDSUBPD xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F.WIG D0 /r` | `AVX`
	/// `VADDSUBPD ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F.WIG D0 /r` | `AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaddsubpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaddsubpd<T, U, V>,
	{
		<Self as CodeAsmVaddsubpd<T, U, V>>::vaddsubpd(self, op0, op1, op2)
	}

	/// `VADDSUBPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VADDSUBPS xmm1, xmm2, xmm3/m128` | `VEX.128.F2.0F.WIG D0 /r` | `AVX`
	/// `VADDSUBPS ymm1, ymm2, ymm3/m256` | `VEX.256.F2.0F.WIG D0 /r` | `AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaddsubps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaddsubps<T, U, V>,
	{
		<Self as CodeAsmVaddsubps<T, U, V>>::vaddsubps(self, op0, op1, op2)
	}

	/// `VAESDEC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VAESDEC xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F38.WIG DE /r` | `AES AVX`
	/// `VAESDEC ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F38.WIG DE /r` | `VAES`
	/// `VAESDEC xmm1, xmm2, xmm3/m128` | `EVEX.128.66.0F38.WIG DE /r` | `AVX512VL VAES`
	/// `VAESDEC ymm1, ymm2, ymm3/m256` | `EVEX.256.66.0F38.WIG DE /r` | `AVX512VL VAES`
	/// `VAESDEC zmm1, zmm2, zmm3/m512` | `EVEX.512.66.0F38.WIG DE /r` | `AVX512F VAES`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaesdec<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaesdec<T, U, V>,
	{
		<Self as CodeAsmVaesdec<T, U, V>>::vaesdec(self, op0, op1, op2)
	}

	/// `VAESDECLAST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VAESDECLAST xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F38.WIG DF /r` | `AES AVX`
	/// `VAESDECLAST ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F38.WIG DF /r` | `VAES`
	/// `VAESDECLAST xmm1, xmm2, xmm3/m128` | `EVEX.128.66.0F38.WIG DF /r` | `AVX512VL VAES`
	/// `VAESDECLAST ymm1, ymm2, ymm3/m256` | `EVEX.256.66.0F38.WIG DF /r` | `AVX512VL VAES`
	/// `VAESDECLAST zmm1, zmm2, zmm3/m512` | `EVEX.512.66.0F38.WIG DF /r` | `AVX512F VAES`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaesdeclast<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaesdeclast<T, U, V>,
	{
		<Self as CodeAsmVaesdeclast<T, U, V>>::vaesdeclast(self, op0, op1, op2)
	}

	/// `VAESENC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VAESENC xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F38.WIG DC /r` | `AES AVX`
	/// `VAESENC ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F38.WIG DC /r` | `VAES`
	/// `VAESENC xmm1, xmm2, xmm3/m128` | `EVEX.128.66.0F38.WIG DC /r` | `AVX512VL VAES`
	/// `VAESENC ymm1, ymm2, ymm3/m256` | `EVEX.256.66.0F38.WIG DC /r` | `AVX512VL VAES`
	/// `VAESENC zmm1, zmm2, zmm3/m512` | `EVEX.512.66.0F38.WIG DC /r` | `AVX512F VAES`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaesenc<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaesenc<T, U, V>,
	{
		<Self as CodeAsmVaesenc<T, U, V>>::vaesenc(self, op0, op1, op2)
	}

	/// `VAESENCLAST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VAESENCLAST xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F38.WIG DD /r` | `AES AVX`
	/// `VAESENCLAST ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F38.WIG DD /r` | `VAES`
	/// `VAESENCLAST xmm1, xmm2, xmm3/m128` | `EVEX.128.66.0F38.WIG DD /r` | `AVX512VL VAES`
	/// `VAESENCLAST ymm1, ymm2, ymm3/m256` | `EVEX.256.66.0F38.WIG DD /r` | `AVX512VL VAES`
	/// `VAESENCLAST zmm1, zmm2, zmm3/m512` | `EVEX.512.66.0F38.WIG DD /r` | `AVX512F VAES`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaesenclast<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaesenclast<T, U, V>,
	{
		<Self as CodeAsmVaesenclast<T, U, V>>::vaesenclast(self, op0, op1, op2)
	}

	/// `VAESIMC` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VAESIMC xmm1, xmm2/m128` | `VEX.128.66.0F38.WIG DB /r` | `AES AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vaesimc<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVaesimc<T, U>,
	{
		<Self as CodeAsmVaesimc<T, U>>::vaesimc(self, op0, op1)
	}

	/// `VAESKEYGENASSIST` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VAESKEYGENASSIST xmm1, xmm2/m128, imm8` | `VEX.128.66.0F3A.WIG DF /r ib` | `AES AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vaeskeygenassist<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVaeskeygenassist<T, U, V>,
	{
		<Self as CodeAsmVaeskeygenassist<T, U, V>>::vaeskeygenassist(self, op0, op1, op2)
	}

	/// `VALIGND` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VALIGND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.66.0F3A.W0 03 /r ib` | `AVX512VL AVX512F`
	/// `VALIGND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.66.0F3A.W0 03 /r ib` | `AVX512VL AVX512F`
	/// `VALIGND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8` | `EVEX.512.66.0F3A.W0 03 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn valignd<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmValignd<T, U, V, W>,
	{
		<Self as CodeAsmValignd<T, U, V, W>>::valignd(self, op0, op1, op2, op3)
	}

	/// `VALIGNQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VALIGNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F3A.W1 03 /r ib` | `AVX512VL AVX512F`
	/// `VALIGNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F3A.W1 03 /r ib` | `AVX512VL AVX512F`
	/// `VALIGNQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8` | `EVEX.512.66.0F3A.W1 03 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn valignq<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmValignq<T, U, V, W>,
	{
		<Self as CodeAsmValignq<T, U, V, W>>::valignq(self, op0, op1, op2, op3)
	}

	/// `VANDNPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VANDNPD xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F.WIG 55 /r` | `AVX`
	/// `VANDNPD ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F.WIG 55 /r` | `AVX`
	/// `VANDNPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst` | `EVEX.128.66.0F.W1 55 /r` | `AVX512VL AVX512DQ`
	/// `VANDNPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst` | `EVEX.256.66.0F.W1 55 /r` | `AVX512VL AVX512DQ`
	/// `VANDNPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst` | `EVEX.512.66.0F.W1 55 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vandnpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVandnpd<T, U, V>,
	{
		<Self as CodeAsmVandnpd<T, U, V>>::vandnpd(self, op0, op1, op2)
	}

	/// `VANDNPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VANDNPS xmm1, xmm2, xmm3/m128` | `VEX.128.0F.WIG 55 /r` | `AVX`
	/// `VANDNPS ymm1, ymm2, ymm3/m256` | `VEX.256.0F.WIG 55 /r` | `AVX`
	/// `VANDNPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.0F.W0 55 /r` | `AVX512VL AVX512DQ`
	/// `VANDNPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.0F.W0 55 /r` | `AVX512VL AVX512DQ`
	/// `VANDNPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst` | `EVEX.512.0F.W0 55 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vandnps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVandnps<T, U, V>,
	{
		<Self as CodeAsmVandnps<T, U, V>>::vandnps(self, op0, op1, op2)
	}

	/// `VANDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VANDPD xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F.WIG 54 /r` | `AVX`
	/// `VANDPD ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F.WIG 54 /r` | `AVX`
	/// `VANDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst` | `EVEX.128.66.0F.W1 54 /r` | `AVX512VL AVX512DQ`
	/// `VANDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst` | `EVEX.256.66.0F.W1 54 /r` | `AVX512VL AVX512DQ`
	/// `VANDPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst` | `EVEX.512.66.0F.W1 54 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vandpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVandpd<T, U, V>,
	{
		<Self as CodeAsmVandpd<T, U, V>>::vandpd(self, op0, op1, op2)
	}

	/// `VANDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VANDPS xmm1, xmm2, xmm3/m128` | `VEX.128.0F.WIG 54 /r` | `AVX`
	/// `VANDPS ymm1, ymm2, ymm3/m256` | `VEX.256.0F.WIG 54 /r` | `AVX`
	/// `VANDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.0F.W0 54 /r` | `AVX512VL AVX512DQ`
	/// `VANDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.0F.W0 54 /r` | `AVX512VL AVX512DQ`
	/// `VANDPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst` | `EVEX.512.0F.W0 54 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vandps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVandps<T, U, V>,
	{
		<Self as CodeAsmVandps<T, U, V>>::vandps(self, op0, op1, op2)
	}

	/// `VBCSTNEBF162PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBCSTNEBF162PS xmm1, m16` | `VEX.128.F3.0F38.W0 B1 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	/// `VBCSTNEBF162PS ymm1, m16` | `VEX.256.F3.0F38.W0 B1 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbcstnebf162ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbcstnebf162ps<T, U>,
	{
		<Self as CodeAsmVbcstnebf162ps<T, U>>::vbcstnebf162ps(self, op0, op1)
	}

	/// `VBCSTNESH2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBCSTNESH2PS xmm1, m16` | `VEX.128.66.0F38.W0 B1 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	/// `VBCSTNESH2PS ymm1, m16` | `VEX.256.66.0F38.W0 B1 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbcstnesh2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbcstnesh2ps<T, U>,
	{
		<Self as CodeAsmVbcstnesh2ps<T, U>>::vbcstnesh2ps(self, op0, op1)
	}

	/// `VBLENDMPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBLENDMPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst` | `EVEX.128.66.0F38.W1 65 /r` | `AVX512VL AVX512F`
	/// `VBLENDMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst` | `EVEX.256.66.0F38.W1 65 /r` | `AVX512VL AVX512F`
	/// `VBLENDMPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst` | `EVEX.512.66.0F38.W1 65 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vblendmpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVblendmpd<T, U, V>,
	{
		<Self as CodeAsmVblendmpd<T, U, V>>::vblendmpd(self, op0, op1, op2)
	}

	/// `VBLENDMPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBLENDMPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.66.0F38.W0 65 /r` | `AVX512VL AVX512F`
	/// `VBLENDMPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.66.0F38.W0 65 /r` | `AVX512VL AVX512F`
	/// `VBLENDMPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst` | `EVEX.512.66.0F38.W0 65 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vblendmps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVblendmps<T, U, V>,
	{
		<Self as CodeAsmVblendmps<T, U, V>>::vblendmps(self, op0, op1, op2)
	}

	/// `VBLENDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBLENDPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F3A.WIG 0D /r ib` | `AVX`
	/// `VBLENDPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F3A.WIG 0D /r ib` | `AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vblendpd<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVblendpd<T, U, V, W>,
	{
		<Self as CodeAsmVblendpd<T, U, V, W>>::vblendpd(self, op0, op1, op2, op3)
	}

	/// `VBLENDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBLENDPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F3A.WIG 0C /r ib` | `AVX`
	/// `VBLENDPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F3A.WIG 0C /r ib` | `AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vblendps<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVblendps<T, U, V, W>,
	{
		<Self as CodeAsmVblendps<T, U, V, W>>::vblendps(self, op0, op1, op2, op3)
	}

	/// `VBLENDVPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBLENDVPD xmm1, xmm2, xmm3/m128, xmm4` | `VEX.128.66.0F3A.W0 4B /r /is4` | `AVX`
	/// `VBLENDVPD ymm1, ymm2, ymm3/m256, ymm4` | `VEX.256.66.0F3A.W0 4B /r /is4` | `AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vblendvpd<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVblendvpd<T, U, V, W>,
	{
		<Self as CodeAsmVblendvpd<T, U, V, W>>::vblendvpd(self, op0, op1, op2, op3)
	}

	/// `VBLENDVPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBLENDVPS xmm1, xmm2, xmm3/m128, xmm4` | `VEX.128.66.0F3A.W0 4A /r /is4` | `AVX`
	/// `VBLENDVPS ymm1, ymm2, ymm3/m256, ymm4` | `VEX.256.66.0F3A.W0 4A /r /is4` | `AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vblendvps<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVblendvps<T, U, V, W>,
	{
		<Self as CodeAsmVblendvps<T, U, V, W>>::vblendvps(self, op0, op1, op2, op3)
	}

	/// `VBROADCASTF128` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTF128 ymm1, m128` | `VEX.256.66.0F38.W0 1A /r` | `AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcastf128<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcastf128<T, U>,
	{
		<Self as CodeAsmVbroadcastf128<T, U>>::vbroadcastf128(self, op0, op1)
	}

	/// `VBROADCASTF32X2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTF32X2 ymm1 {k1}{z}, xmm2/m64` | `EVEX.256.66.0F38.W0 19 /r` | `AVX512VL AVX512DQ`
	/// `VBROADCASTF32X2 zmm1 {k1}{z}, xmm2/m64` | `EVEX.512.66.0F38.W0 19 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcastf32x2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcastf32x2<T, U>,
	{
		<Self as CodeAsmVbroadcastf32x2<T, U>>::vbroadcastf32x2(self, op0, op1)
	}

	/// `VBROADCASTF32X4` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTF32X4 ymm1 {k1}{z}, m128` | `EVEX.256.66.0F38.W0 1A /r` | `AVX512VL AVX512F`
	/// `VBROADCASTF32X4 zmm1 {k1}{z}, m128` | `EVEX.512.66.0F38.W0 1A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcastf32x4<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcastf32x4<T, U>,
	{
		<Self as CodeAsmVbroadcastf32x4<T, U>>::vbroadcastf32x4(self, op0, op1)
	}

	/// `VBROADCASTF32X8` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTF32X8 zmm1 {k1}{z}, m256` | `EVEX.512.66.0F38.W0 1B /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcastf32x8<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcastf32x8<T, U>,
	{
		<Self as CodeAsmVbroadcastf32x8<T, U>>::vbroadcastf32x8(self, op0, op1)
	}

	/// `VBROADCASTF64X2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTF64X2 ymm1 {k1}{z}, m128` | `EVEX.256.66.0F38.W1 1A /r` | `AVX512VL AVX512DQ`
	/// `VBROADCASTF64X2 zmm1 {k1}{z}, m128` | `EVEX.512.66.0F38.W1 1A /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcastf64x2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcastf64x2<T, U>,
	{
		<Self as CodeAsmVbroadcastf64x2<T, U>>::vbroadcastf64x2(self, op0, op1)
	}

	/// `VBROADCASTF64X4` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTF64X4 zmm1 {k1}{z}, m256` | `EVEX.512.66.0F38.W1 1B /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcastf64x4<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcastf64x4<T, U>,
	{
		<Self as CodeAsmVbroadcastf64x4<T, U>>::vbroadcastf64x4(self, op0, op1)
	}

	/// `VBROADCASTI128` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTI128 ymm1, m128` | `VEX.256.66.0F38.W0 5A /r` | `AVX2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcasti128<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcasti128<T, U>,
	{
		<Self as CodeAsmVbroadcasti128<T, U>>::vbroadcasti128(self, op0, op1)
	}

	/// `VBROADCASTI32X2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTI32X2 xmm1 {k1}{z}, xmm2/m64` | `EVEX.128.66.0F38.W0 59 /r` | `AVX512VL AVX512DQ`
	/// `VBROADCASTI32X2 ymm1 {k1}{z}, xmm2/m64` | `EVEX.256.66.0F38.W0 59 /r` | `AVX512VL AVX512DQ`
	/// `VBROADCASTI32X2 zmm1 {k1}{z}, xmm2/m64` | `EVEX.512.66.0F38.W0 59 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcasti32x2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcasti32x2<T, U>,
	{
		<Self as CodeAsmVbroadcasti32x2<T, U>>::vbroadcasti32x2(self, op0, op1)
	}

	/// `VBROADCASTI32X4` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTI32X4 ymm1 {k1}{z}, m128` | `EVEX.256.66.0F38.W0 5A /r` | `AVX512VL AVX512F`
	/// `VBROADCASTI32X4 zmm1 {k1}{z}, m128` | `EVEX.512.66.0F38.W0 5A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcasti32x4<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcasti32x4<T, U>,
	{
		<Self as CodeAsmVbroadcasti32x4<T, U>>::vbroadcasti32x4(self, op0, op1)
	}

	/// `VBROADCASTI32X8` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTI32X8 zmm1 {k1}{z}, m256` | `EVEX.512.66.0F38.W0 5B /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcasti32x8<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcasti32x8<T, U>,
	{
		<Self as CodeAsmVbroadcasti32x8<T, U>>::vbroadcasti32x8(self, op0, op1)
	}

	/// `VBROADCASTI64X2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTI64X2 ymm1 {k1}{z}, m128` | `EVEX.256.66.0F38.W1 5A /r` | `AVX512VL AVX512DQ`
	/// `VBROADCASTI64X2 zmm1 {k1}{z}, m128` | `EVEX.512.66.0F38.W1 5A /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcasti64x2<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcasti64x2<T, U>,
	{
		<Self as CodeAsmVbroadcasti64x2<T, U>>::vbroadcasti64x2(self, op0, op1)
	}

	/// `VBROADCASTI64X4` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTI64X4 zmm1 {k1}{z}, m256` | `EVEX.512.66.0F38.W1 5B /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcasti64x4<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcasti64x4<T, U>,
	{
		<Self as CodeAsmVbroadcasti64x4<T, U>>::vbroadcasti64x4(self, op0, op1)
	}

	/// `VBROADCASTSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTSD ymm1, m64` | `VEX.256.66.0F38.W0 19 /r` | `AVX`
	/// `VBROADCASTSD ymm1, xmm2` | `VEX.256.66.0F38.W0 19 /r` | `AVX2`
	/// `VBROADCASTSD ymm1 {k1}{z}, xmm2/m64` | `EVEX.256.66.0F38.W1 19 /r` | `AVX512VL AVX512F`
	/// `VBROADCASTSD zmm1 {k1}{z}, xmm2/m64` | `EVEX.512.66.0F38.W1 19 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcastsd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcastsd<T, U>,
	{
		<Self as CodeAsmVbroadcastsd<T, U>>::vbroadcastsd(self, op0, op1)
	}

	/// `VBROADCASTSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VBROADCASTSS xmm1, m32` | `VEX.128.66.0F38.W0 18 /r` | `AVX`
	/// `VBROADCASTSS xmm1, xmm2` | `VEX.128.66.0F38.W0 18 /r` | `AVX2`
	/// `VBROADCASTSS ymm1, m32` | `VEX.256.66.0F38.W0 18 /r` | `AVX`
	/// `VBROADCASTSS ymm1, xmm2` | `VEX.256.66.0F38.W0 18 /r` | `AVX2`
	/// `VBROADCASTSS xmm1 {k1}{z}, xmm2/m32` | `EVEX.128.66.0F38.W0 18 /r` | `AVX512VL AVX512F`
	/// `VBROADCASTSS ymm1 {k1}{z}, xmm2/m32` | `EVEX.256.66.0F38.W0 18 /r` | `AVX512VL AVX512F`
	/// `VBROADCASTSS zmm1 {k1}{z}, xmm2/m32` | `EVEX.512.66.0F38.W0 18 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vbroadcastss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVbroadcastss<T, U>,
	{
		<Self as CodeAsmVbroadcastss<T, U>>::vbroadcastss(self, op0, op1)
	}

	/// `VCMPEQ_OSPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_ospd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_ospd<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_ospd<T, U, V>>::vcmpeq_ospd(self, op0, op1, op2)
	}

	/// `VCMPEQ_OSPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_osph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_osph<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_osph<T, U, V>>::vcmpeq_osph(self, op0, op1, op2)
	}

	/// `VCMPEQ_OSPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_osps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_osps<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_osps<T, U, V>>::vcmpeq_osps(self, op0, op1, op2)
	}

	/// `VCMPEQ_OSSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_ossd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_ossd<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_ossd<T, U, V>>::vcmpeq_ossd(self, op0, op1, op2)
	}

	/// `VCMPEQ_OSSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_ossh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_ossh<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_ossh<T, U, V>>::vcmpeq_ossh(self, op0, op1, op2)
	}

	/// `VCMPEQ_OSSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_osss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_osss<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_osss<T, U, V>>::vcmpeq_osss(self, op0, op1, op2)
	}

	/// `VCMPEQ_UQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_uqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_uqpd<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_uqpd<T, U, V>>::vcmpeq_uqpd(self, op0, op1, op2)
	}

	/// `VCMPEQ_UQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_uqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_uqph<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_uqph<T, U, V>>::vcmpeq_uqph(self, op0, op1, op2)
	}

	/// `VCMPEQ_UQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_uqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_uqps<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_uqps<T, U, V>>::vcmpeq_uqps(self, op0, op1, op2)
	}

	/// `VCMPEQ_UQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_uqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_uqsd<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_uqsd<T, U, V>>::vcmpeq_uqsd(self, op0, op1, op2)
	}

	/// `VCMPEQ_UQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_uqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_uqsh<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_uqsh<T, U, V>>::vcmpeq_uqsh(self, op0, op1, op2)
	}

	/// `VCMPEQ_UQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_uqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_uqss<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_uqss<T, U, V>>::vcmpeq_uqss(self, op0, op1, op2)
	}

	/// `VCMPEQ_USPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_uspd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_uspd<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_uspd<T, U, V>>::vcmpeq_uspd(self, op0, op1, op2)
	}

	/// `VCMPEQ_USPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_usph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_usph<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_usph<T, U, V>>::vcmpeq_usph(self, op0, op1, op2)
	}

	/// `VCMPEQ_USPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_usps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_usps<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_usps<T, U, V>>::vcmpeq_usps(self, op0, op1, op2)
	}

	/// `VCMPEQ_USSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_ussd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_ussd<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_ussd<T, U, V>>::vcmpeq_ussd(self, op0, op1, op2)
	}

	/// `VCMPEQ_USSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_ussh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_ussh<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_ussh<T, U, V>>::vcmpeq_ussh(self, op0, op1, op2)
	}

	/// `VCMPEQ_USSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeq_usss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeq_usss<T, U, V>,
	{
		<Self as CodeAsmVcmpeq_usss<T, U, V>>::vcmpeq_usss(self, op0, op1, op2)
	}

	/// `VCMPEQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeqpd<T, U, V>,
	{
		<Self as CodeAsmVcmpeqpd<T, U, V>>::vcmpeqpd(self, op0, op1, op2)
	}

	/// `VCMPEQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeqph<T, U, V>,
	{
		<Self as CodeAsmVcmpeqph<T, U, V>>::vcmpeqph(self, op0, op1, op2)
	}

	/// `VCMPEQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeqps<T, U, V>,
	{
		<Self as CodeAsmVcmpeqps<T, U, V>>::vcmpeqps(self, op0, op1, op2)
	}

	/// `VCMPEQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeqsd<T, U, V>,
	{
		<Self as CodeAsmVcmpeqsd<T, U, V>>::vcmpeqsd(self, op0, op1, op2)
	}

	/// `VCMPEQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeqsh<T, U, V>,
	{
		<Self as CodeAsmVcmpeqsh<T, U, V>>::vcmpeqsh(self, op0, op1, op2)
	}

	/// `VCMPEQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpeqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpeqss<T, U, V>,
	{
		<Self as CodeAsmVcmpeqss<T, U, V>>::vcmpeqss(self, op0, op1, op2)
	}

	/// `VCMPFALSE_OSPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalse_ospd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalse_ospd<T, U, V>,
	{
		<Self as CodeAsmVcmpfalse_ospd<T, U, V>>::vcmpfalse_ospd(self, op0, op1, op2)
	}

	/// `VCMPFALSE_OSPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalse_osph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalse_osph<T, U, V>,
	{
		<Self as CodeAsmVcmpfalse_osph<T, U, V>>::vcmpfalse_osph(self, op0, op1, op2)
	}

	/// `VCMPFALSE_OSPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalse_osps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalse_osps<T, U, V>,
	{
		<Self as CodeAsmVcmpfalse_osps<T, U, V>>::vcmpfalse_osps(self, op0, op1, op2)
	}

	/// `VCMPFALSE_OSSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalse_ossd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalse_ossd<T, U, V>,
	{
		<Self as CodeAsmVcmpfalse_ossd<T, U, V>>::vcmpfalse_ossd(self, op0, op1, op2)
	}

	/// `VCMPFALSE_OSSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalse_ossh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalse_ossh<T, U, V>,
	{
		<Self as CodeAsmVcmpfalse_ossh<T, U, V>>::vcmpfalse_ossh(self, op0, op1, op2)
	}

	/// `VCMPFALSE_OSSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalse_osss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalse_osss<T, U, V>,
	{
		<Self as CodeAsmVcmpfalse_osss<T, U, V>>::vcmpfalse_osss(self, op0, op1, op2)
	}

	/// `VCMPFALSEPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalsepd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalsepd<T, U, V>,
	{
		<Self as CodeAsmVcmpfalsepd<T, U, V>>::vcmpfalsepd(self, op0, op1, op2)
	}

	/// `VCMPFALSEPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalseph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalseph<T, U, V>,
	{
		<Self as CodeAsmVcmpfalseph<T, U, V>>::vcmpfalseph(self, op0, op1, op2)
	}

	/// `VCMPFALSEPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalseps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalseps<T, U, V>,
	{
		<Self as CodeAsmVcmpfalseps<T, U, V>>::vcmpfalseps(self, op0, op1, op2)
	}

	/// `VCMPFALSESD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalsesd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalsesd<T, U, V>,
	{
		<Self as CodeAsmVcmpfalsesd<T, U, V>>::vcmpfalsesd(self, op0, op1, op2)
	}

	/// `VCMPFALSESH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalsesh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalsesh<T, U, V>,
	{
		<Self as CodeAsmVcmpfalsesh<T, U, V>>::vcmpfalsesh(self, op0, op1, op2)
	}

	/// `VCMPFALSESS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpfalsess<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpfalsess<T, U, V>,
	{
		<Self as CodeAsmVcmpfalsess<T, U, V>>::vcmpfalsess(self, op0, op1, op2)
	}

	/// `VCMPGE_OQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpge_oqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpge_oqpd<T, U, V>,
	{
		<Self as CodeAsmVcmpge_oqpd<T, U, V>>::vcmpge_oqpd(self, op0, op1, op2)
	}

	/// `VCMPGE_OQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpge_oqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpge_oqph<T, U, V>,
	{
		<Self as CodeAsmVcmpge_oqph<T, U, V>>::vcmpge_oqph(self, op0, op1, op2)
	}

	/// `VCMPGE_OQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpge_oqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpge_oqps<T, U, V>,
	{
		<Self as CodeAsmVcmpge_oqps<T, U, V>>::vcmpge_oqps(self, op0, op1, op2)
	}

	/// `VCMPGE_OQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpge_oqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpge_oqsd<T, U, V>,
	{
		<Self as CodeAsmVcmpge_oqsd<T, U, V>>::vcmpge_oqsd(self, op0, op1, op2)
	}

	/// `VCMPGE_OQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpge_oqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpge_oqsh<T, U, V>,
	{
		<Self as CodeAsmVcmpge_oqsh<T, U, V>>::vcmpge_oqsh(self, op0, op1, op2)
	}

	/// `VCMPGE_OQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpge_oqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpge_oqss<T, U, V>,
	{
		<Self as CodeAsmVcmpge_oqss<T, U, V>>::vcmpge_oqss(self, op0, op1, op2)
	}

	/// `VCMPGEPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgepd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgepd<T, U, V>,
	{
		<Self as CodeAsmVcmpgepd<T, U, V>>::vcmpgepd(self, op0, op1, op2)
	}

	/// `VCMPGEPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgeph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgeph<T, U, V>,
	{
		<Self as CodeAsmVcmpgeph<T, U, V>>::vcmpgeph(self, op0, op1, op2)
	}

	/// `VCMPGEPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgeps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgeps<T, U, V>,
	{
		<Self as CodeAsmVcmpgeps<T, U, V>>::vcmpgeps(self, op0, op1, op2)
	}

	/// `VCMPGESD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgesd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgesd<T, U, V>,
	{
		<Self as CodeAsmVcmpgesd<T, U, V>>::vcmpgesd(self, op0, op1, op2)
	}

	/// `VCMPGESH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgesh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgesh<T, U, V>,
	{
		<Self as CodeAsmVcmpgesh<T, U, V>>::vcmpgesh(self, op0, op1, op2)
	}

	/// `VCMPGESS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgess<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgess<T, U, V>,
	{
		<Self as CodeAsmVcmpgess<T, U, V>>::vcmpgess(self, op0, op1, op2)
	}

	/// `VCMPGT_OQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgt_oqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgt_oqpd<T, U, V>,
	{
		<Self as CodeAsmVcmpgt_oqpd<T, U, V>>::vcmpgt_oqpd(self, op0, op1, op2)
	}

	/// `VCMPGT_OQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgt_oqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgt_oqph<T, U, V>,
	{
		<Self as CodeAsmVcmpgt_oqph<T, U, V>>::vcmpgt_oqph(self, op0, op1, op2)
	}

	/// `VCMPGT_OQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgt_oqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgt_oqps<T, U, V>,
	{
		<Self as CodeAsmVcmpgt_oqps<T, U, V>>::vcmpgt_oqps(self, op0, op1, op2)
	}

	/// `VCMPGT_OQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgt_oqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgt_oqsd<T, U, V>,
	{
		<Self as CodeAsmVcmpgt_oqsd<T, U, V>>::vcmpgt_oqsd(self, op0, op1, op2)
	}

	/// `VCMPGT_OQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgt_oqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgt_oqsh<T, U, V>,
	{
		<Self as CodeAsmVcmpgt_oqsh<T, U, V>>::vcmpgt_oqsh(self, op0, op1, op2)
	}

	/// `VCMPGT_OQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgt_oqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgt_oqss<T, U, V>,
	{
		<Self as CodeAsmVcmpgt_oqss<T, U, V>>::vcmpgt_oqss(self, op0, op1, op2)
	}

	/// `VCMPGTPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgtpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgtpd<T, U, V>,
	{
		<Self as CodeAsmVcmpgtpd<T, U, V>>::vcmpgtpd(self, op0, op1, op2)
	}

	/// `VCMPGTPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgtph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgtph<T, U, V>,
	{
		<Self as CodeAsmVcmpgtph<T, U, V>>::vcmpgtph(self, op0, op1, op2)
	}

	/// `VCMPGTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgtps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgtps<T, U, V>,
	{
		<Self as CodeAsmVcmpgtps<T, U, V>>::vcmpgtps(self, op0, op1, op2)
	}

	/// `VCMPGTSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgtsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgtsd<T, U, V>,
	{
		<Self as CodeAsmVcmpgtsd<T, U, V>>::vcmpgtsd(self, op0, op1, op2)
	}

	/// `VCMPGTSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgtsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgtsh<T, U, V>,
	{
		<Self as CodeAsmVcmpgtsh<T, U, V>>::vcmpgtsh(self, op0, op1, op2)
	}

	/// `VCMPGTSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpgtss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpgtss<T, U, V>,
	{
		<Self as CodeAsmVcmpgtss<T, U, V>>::vcmpgtss(self, op0, op1, op2)
	}

	/// `VCMPLE_OQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmple_oqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmple_oqpd<T, U, V>,
	{
		<Self as CodeAsmVcmple_oqpd<T, U, V>>::vcmple_oqpd(self, op0, op1, op2)
	}

	/// `VCMPLE_OQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmple_oqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmple_oqph<T, U, V>,
	{
		<Self as CodeAsmVcmple_oqph<T, U, V>>::vcmple_oqph(self, op0, op1, op2)
	}

	/// `VCMPLE_OQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmple_oqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmple_oqps<T, U, V>,
	{
		<Self as CodeAsmVcmple_oqps<T, U, V>>::vcmple_oqps(self, op0, op1, op2)
	}

	/// `VCMPLE_OQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmple_oqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmple_oqsd<T, U, V>,
	{
		<Self as CodeAsmVcmple_oqsd<T, U, V>>::vcmple_oqsd(self, op0, op1, op2)
	}

	/// `VCMPLE_OQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmple_oqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmple_oqsh<T, U, V>,
	{
		<Self as CodeAsmVcmple_oqsh<T, U, V>>::vcmple_oqsh(self, op0, op1, op2)
	}

	/// `VCMPLE_OQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmple_oqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmple_oqss<T, U, V>,
	{
		<Self as CodeAsmVcmple_oqss<T, U, V>>::vcmple_oqss(self, op0, op1, op2)
	}

	/// `VCMPLEPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmplepd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmplepd<T, U, V>,
	{
		<Self as CodeAsmVcmplepd<T, U, V>>::vcmplepd(self, op0, op1, op2)
	}

	/// `VCMPLEPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpleph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpleph<T, U, V>,
	{
		<Self as CodeAsmVcmpleph<T, U, V>>::vcmpleph(self, op0, op1, op2)
	}

	/// `VCMPLEPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpleps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpleps<T, U, V>,
	{
		<Self as CodeAsmVcmpleps<T, U, V>>::vcmpleps(self, op0, op1, op2)
	}

	/// `VCMPLESD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmplesd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmplesd<T, U, V>,
	{
		<Self as CodeAsmVcmplesd<T, U, V>>::vcmplesd(self, op0, op1, op2)
	}

	/// `VCMPLESH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmplesh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmplesh<T, U, V>,
	{
		<Self as CodeAsmVcmplesh<T, U, V>>::vcmplesh(self, op0, op1, op2)
	}

	/// `VCMPLESS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpless<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpless<T, U, V>,
	{
		<Self as CodeAsmVcmpless<T, U, V>>::vcmpless(self, op0, op1, op2)
	}

	/// `VCMPLT_OQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmplt_oqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmplt_oqpd<T, U, V>,
	{
		<Self as CodeAsmVcmplt_oqpd<T, U, V>>::vcmplt_oqpd(self, op0, op1, op2)
	}

	/// `VCMPLT_OQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmplt_oqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmplt_oqph<T, U, V>,
	{
		<Self as CodeAsmVcmplt_oqph<T, U, V>>::vcmplt_oqph(self, op0, op1, op2)
	}

	/// `VCMPLT_OQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmplt_oqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmplt_oqps<T, U, V>,
	{
		<Self as CodeAsmVcmplt_oqps<T, U, V>>::vcmplt_oqps(self, op0, op1, op2)
	}

	/// `VCMPLT_OQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmplt_oqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmplt_oqsd<T, U, V>,
	{
		<Self as CodeAsmVcmplt_oqsd<T, U, V>>::vcmplt_oqsd(self, op0, op1, op2)
	}

	/// `VCMPLT_OQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmplt_oqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmplt_oqsh<T, U, V>,
	{
		<Self as CodeAsmVcmplt_oqsh<T, U, V>>::vcmplt_oqsh(self, op0, op1, op2)
	}

	/// `VCMPLT_OQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmplt_oqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmplt_oqss<T, U, V>,
	{
		<Self as CodeAsmVcmplt_oqss<T, U, V>>::vcmplt_oqss(self, op0, op1, op2)
	}

	/// `VCMPLTPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpltpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpltpd<T, U, V>,
	{
		<Self as CodeAsmVcmpltpd<T, U, V>>::vcmpltpd(self, op0, op1, op2)
	}

	/// `VCMPLTPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpltph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpltph<T, U, V>,
	{
		<Self as CodeAsmVcmpltph<T, U, V>>::vcmpltph(self, op0, op1, op2)
	}

	/// `VCMPLTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpltps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpltps<T, U, V>,
	{
		<Self as CodeAsmVcmpltps<T, U, V>>::vcmpltps(self, op0, op1, op2)
	}

	/// `VCMPLTSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpltsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpltsd<T, U, V>,
	{
		<Self as CodeAsmVcmpltsd<T, U, V>>::vcmpltsd(self, op0, op1, op2)
	}

	/// `VCMPLTSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpltsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpltsh<T, U, V>,
	{
		<Self as CodeAsmVcmpltsh<T, U, V>>::vcmpltsh(self, op0, op1, op2)
	}

	/// `VCMPLTSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpltss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpltss<T, U, V>,
	{
		<Self as CodeAsmVcmpltss<T, U, V>>::vcmpltss(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_oqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_oqpd<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_oqpd<T, U, V>>::vcmpneq_oqpd(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_oqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_oqph<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_oqph<T, U, V>>::vcmpneq_oqph(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_oqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_oqps<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_oqps<T, U, V>>::vcmpneq_oqps(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_oqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_oqsd<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_oqsd<T, U, V>>::vcmpneq_oqsd(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_oqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_oqsh<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_oqsh<T, U, V>>::vcmpneq_oqsh(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_oqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_oqss<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_oqss<T, U, V>>::vcmpneq_oqss(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OSPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_ospd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_ospd<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_ospd<T, U, V>>::vcmpneq_ospd(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OSPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_osph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_osph<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_osph<T, U, V>>::vcmpneq_osph(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OSPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_osps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_osps<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_osps<T, U, V>>::vcmpneq_osps(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OSSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_ossd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_ossd<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_ossd<T, U, V>>::vcmpneq_ossd(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OSSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_ossh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_ossh<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_ossh<T, U, V>>::vcmpneq_ossh(self, op0, op1, op2)
	}

	/// `VCMPNEQ_OSSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_osss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_osss<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_osss<T, U, V>>::vcmpneq_osss(self, op0, op1, op2)
	}

	/// `VCMPNEQ_USPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_uspd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_uspd<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_uspd<T, U, V>>::vcmpneq_uspd(self, op0, op1, op2)
	}

	/// `VCMPNEQ_USPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_usph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_usph<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_usph<T, U, V>>::vcmpneq_usph(self, op0, op1, op2)
	}

	/// `VCMPNEQ_USPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_usps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_usps<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_usps<T, U, V>>::vcmpneq_usps(self, op0, op1, op2)
	}

	/// `VCMPNEQ_USSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_ussd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_ussd<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_ussd<T, U, V>>::vcmpneq_ussd(self, op0, op1, op2)
	}

	/// `VCMPNEQ_USSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_ussh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_ussh<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_ussh<T, U, V>>::vcmpneq_ussh(self, op0, op1, op2)
	}

	/// `VCMPNEQ_USSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneq_usss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneq_usss<T, U, V>,
	{
		<Self as CodeAsmVcmpneq_usss<T, U, V>>::vcmpneq_usss(self, op0, op1, op2)
	}

	/// `VCMPNEQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneqpd<T, U, V>,
	{
		<Self as CodeAsmVcmpneqpd<T, U, V>>::vcmpneqpd(self, op0, op1, op2)
	}

	/// `VCMPNEQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneqph<T, U, V>,
	{
		<Self as CodeAsmVcmpneqph<T, U, V>>::vcmpneqph(self, op0, op1, op2)
	}

	/// `VCMPNEQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneqps<T, U, V>,
	{
		<Self as CodeAsmVcmpneqps<T, U, V>>::vcmpneqps(self, op0, op1, op2)
	}

	/// `VCMPNEQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneqsd<T, U, V>,
	{
		<Self as CodeAsmVcmpneqsd<T, U, V>>::vcmpneqsd(self, op0, op1, op2)
	}

	/// `VCMPNEQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneqsh<T, U, V>,
	{
		<Self as CodeAsmVcmpneqsh<T, U, V>>::vcmpneqsh(self, op0, op1, op2)
	}

	/// `VCMPNEQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpneqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpneqss<T, U, V>,
	{
		<Self as CodeAsmVcmpneqss<T, U, V>>::vcmpneqss(self, op0, op1, op2)
	}

	/// `VCMPNGE_UQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnge_uqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnge_uqpd<T, U, V>,
	{
		<Self as CodeAsmVcmpnge_uqpd<T, U, V>>::vcmpnge_uqpd(self, op0, op1, op2)
	}

	/// `VCMPNGE_UQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnge_uqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnge_uqph<T, U, V>,
	{
		<Self as CodeAsmVcmpnge_uqph<T, U, V>>::vcmpnge_uqph(self, op0, op1, op2)
	}

	/// `VCMPNGE_UQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnge_uqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnge_uqps<T, U, V>,
	{
		<Self as CodeAsmVcmpnge_uqps<T, U, V>>::vcmpnge_uqps(self, op0, op1, op2)
	}

	/// `VCMPNGE_UQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnge_uqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnge_uqsd<T, U, V>,
	{
		<Self as CodeAsmVcmpnge_uqsd<T, U, V>>::vcmpnge_uqsd(self, op0, op1, op2)
	}

	/// `VCMPNGE_UQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnge_uqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnge_uqsh<T, U, V>,
	{
		<Self as CodeAsmVcmpnge_uqsh<T, U, V>>::vcmpnge_uqsh(self, op0, op1, op2)
	}

	/// `VCMPNGE_UQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnge_uqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnge_uqss<T, U, V>,
	{
		<Self as CodeAsmVcmpnge_uqss<T, U, V>>::vcmpnge_uqss(self, op0, op1, op2)
	}

	/// `VCMPNGEPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngepd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngepd<T, U, V>,
	{
		<Self as CodeAsmVcmpngepd<T, U, V>>::vcmpngepd(self, op0, op1, op2)
	}

	/// `VCMPNGEPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngeph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngeph<T, U, V>,
	{
		<Self as CodeAsmVcmpngeph<T, U, V>>::vcmpngeph(self, op0, op1, op2)
	}

	/// `VCMPNGEPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngeps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngeps<T, U, V>,
	{
		<Self as CodeAsmVcmpngeps<T, U, V>>::vcmpngeps(self, op0, op1, op2)
	}

	/// `VCMPNGESD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngesd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngesd<T, U, V>,
	{
		<Self as CodeAsmVcmpngesd<T, U, V>>::vcmpngesd(self, op0, op1, op2)
	}

	/// `VCMPNGESH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngesh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngesh<T, U, V>,
	{
		<Self as CodeAsmVcmpngesh<T, U, V>>::vcmpngesh(self, op0, op1, op2)
	}

	/// `VCMPNGESS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngess<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngess<T, U, V>,
	{
		<Self as CodeAsmVcmpngess<T, U, V>>::vcmpngess(self, op0, op1, op2)
	}

	/// `VCMPNGT_UQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngt_uqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngt_uqpd<T, U, V>,
	{
		<Self as CodeAsmVcmpngt_uqpd<T, U, V>>::vcmpngt_uqpd(self, op0, op1, op2)
	}

	/// `VCMPNGT_UQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngt_uqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngt_uqph<T, U, V>,
	{
		<Self as CodeAsmVcmpngt_uqph<T, U, V>>::vcmpngt_uqph(self, op0, op1, op2)
	}

	/// `VCMPNGT_UQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngt_uqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngt_uqps<T, U, V>,
	{
		<Self as CodeAsmVcmpngt_uqps<T, U, V>>::vcmpngt_uqps(self, op0, op1, op2)
	}

	/// `VCMPNGT_UQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngt_uqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngt_uqsd<T, U, V>,
	{
		<Self as CodeAsmVcmpngt_uqsd<T, U, V>>::vcmpngt_uqsd(self, op0, op1, op2)
	}

	/// `VCMPNGT_UQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngt_uqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngt_uqsh<T, U, V>,
	{
		<Self as CodeAsmVcmpngt_uqsh<T, U, V>>::vcmpngt_uqsh(self, op0, op1, op2)
	}

	/// `VCMPNGT_UQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngt_uqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngt_uqss<T, U, V>,
	{
		<Self as CodeAsmVcmpngt_uqss<T, U, V>>::vcmpngt_uqss(self, op0, op1, op2)
	}

	/// `VCMPNGTPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngtpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngtpd<T, U, V>,
	{
		<Self as CodeAsmVcmpngtpd<T, U, V>>::vcmpngtpd(self, op0, op1, op2)
	}

	/// `VCMPNGTPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngtph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngtph<T, U, V>,
	{
		<Self as CodeAsmVcmpngtph<T, U, V>>::vcmpngtph(self, op0, op1, op2)
	}

	/// `VCMPNGTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngtps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngtps<T, U, V>,
	{
		<Self as CodeAsmVcmpngtps<T, U, V>>::vcmpngtps(self, op0, op1, op2)
	}

	/// `VCMPNGTSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngtsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngtsd<T, U, V>,
	{
		<Self as CodeAsmVcmpngtsd<T, U, V>>::vcmpngtsd(self, op0, op1, op2)
	}

	/// `VCMPNGTSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngtsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngtsh<T, U, V>,
	{
		<Self as CodeAsmVcmpngtsh<T, U, V>>::vcmpngtsh(self, op0, op1, op2)
	}

	/// `VCMPNGTSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpngtss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpngtss<T, U, V>,
	{
		<Self as CodeAsmVcmpngtss<T, U, V>>::vcmpngtss(self, op0, op1, op2)
	}

	/// `VCMPNLE_UQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnle_uqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnle_uqpd<T, U, V>,
	{
		<Self as CodeAsmVcmpnle_uqpd<T, U, V>>::vcmpnle_uqpd(self, op0, op1, op2)
	}

	/// `VCMPNLE_UQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnle_uqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnle_uqph<T, U, V>,
	{
		<Self as CodeAsmVcmpnle_uqph<T, U, V>>::vcmpnle_uqph(self, op0, op1, op2)
	}

	/// `VCMPNLE_UQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnle_uqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnle_uqps<T, U, V>,
	{
		<Self as CodeAsmVcmpnle_uqps<T, U, V>>::vcmpnle_uqps(self, op0, op1, op2)
	}

	/// `VCMPNLE_UQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnle_uqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnle_uqsd<T, U, V>,
	{
		<Self as CodeAsmVcmpnle_uqsd<T, U, V>>::vcmpnle_uqsd(self, op0, op1, op2)
	}

	/// `VCMPNLE_UQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnle_uqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnle_uqsh<T, U, V>,
	{
		<Self as CodeAsmVcmpnle_uqsh<T, U, V>>::vcmpnle_uqsh(self, op0, op1, op2)
	}

	/// `VCMPNLE_UQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnle_uqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnle_uqss<T, U, V>,
	{
		<Self as CodeAsmVcmpnle_uqss<T, U, V>>::vcmpnle_uqss(self, op0, op1, op2)
	}

	/// `VCMPNLEPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnlepd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnlepd<T, U, V>,
	{
		<Self as CodeAsmVcmpnlepd<T, U, V>>::vcmpnlepd(self, op0, op1, op2)
	}

	/// `VCMPNLEPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnleph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnleph<T, U, V>,
	{
		<Self as CodeAsmVcmpnleph<T, U, V>>::vcmpnleph(self, op0, op1, op2)
	}

	/// `VCMPNLEPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnleps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnleps<T, U, V>,
	{
		<Self as CodeAsmVcmpnleps<T, U, V>>::vcmpnleps(self, op0, op1, op2)
	}

	/// `VCMPNLESD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnlesd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnlesd<T, U, V>,
	{
		<Self as CodeAsmVcmpnlesd<T, U, V>>::vcmpnlesd(self, op0, op1, op2)
	}

	/// `VCMPNLESH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnlesh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnlesh<T, U, V>,
	{
		<Self as CodeAsmVcmpnlesh<T, U, V>>::vcmpnlesh(self, op0, op1, op2)
	}

	/// `VCMPNLESS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnless<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnless<T, U, V>,
	{
		<Self as CodeAsmVcmpnless<T, U, V>>::vcmpnless(self, op0, op1, op2)
	}

	/// `VCMPNLT_UQPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnlt_uqpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnlt_uqpd<T, U, V>,
	{
		<Self as CodeAsmVcmpnlt_uqpd<T, U, V>>::vcmpnlt_uqpd(self, op0, op1, op2)
	}

	/// `VCMPNLT_UQPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnlt_uqph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnlt_uqph<T, U, V>,
	{
		<Self as CodeAsmVcmpnlt_uqph<T, U, V>>::vcmpnlt_uqph(self, op0, op1, op2)
	}

	/// `VCMPNLT_UQPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnlt_uqps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnlt_uqps<T, U, V>,
	{
		<Self as CodeAsmVcmpnlt_uqps<T, U, V>>::vcmpnlt_uqps(self, op0, op1, op2)
	}

	/// `VCMPNLT_UQSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnlt_uqsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnlt_uqsd<T, U, V>,
	{
		<Self as CodeAsmVcmpnlt_uqsd<T, U, V>>::vcmpnlt_uqsd(self, op0, op1, op2)
	}

	/// `VCMPNLT_UQSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnlt_uqsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnlt_uqsh<T, U, V>,
	{
		<Self as CodeAsmVcmpnlt_uqsh<T, U, V>>::vcmpnlt_uqsh(self, op0, op1, op2)
	}

	/// `VCMPNLT_UQSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnlt_uqss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnlt_uqss<T, U, V>,
	{
		<Self as CodeAsmVcmpnlt_uqss<T, U, V>>::vcmpnlt_uqss(self, op0, op1, op2)
	}

	/// `VCMPNLTPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnltpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnltpd<T, U, V>,
	{
		<Self as CodeAsmVcmpnltpd<T, U, V>>::vcmpnltpd(self, op0, op1, op2)
	}

	/// `VCMPNLTPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnltph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnltph<T, U, V>,
	{
		<Self as CodeAsmVcmpnltph<T, U, V>>::vcmpnltph(self, op0, op1, op2)
	}

	/// `VCMPNLTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnltps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnltps<T, U, V>,
	{
		<Self as CodeAsmVcmpnltps<T, U, V>>::vcmpnltps(self, op0, op1, op2)
	}

	/// `VCMPNLTSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnltsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnltsd<T, U, V>,
	{
		<Self as CodeAsmVcmpnltsd<T, U, V>>::vcmpnltsd(self, op0, op1, op2)
	}

	/// `VCMPNLTSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnltsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnltsh<T, U, V>,
	{
		<Self as CodeAsmVcmpnltsh<T, U, V>>::vcmpnltsh(self, op0, op1, op2)
	}

	/// `VCMPNLTSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpnltss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpnltss<T, U, V>,
	{
		<Self as CodeAsmVcmpnltss<T, U, V>>::vcmpnltss(self, op0, op1, op2)
	}

	/// `VCMPORD_SPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpord_spd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpord_spd<T, U, V>,
	{
		<Self as CodeAsmVcmpord_spd<T, U, V>>::vcmpord_spd(self, op0, op1, op2)
	}

	/// `VCMPORD_SPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpord_sph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpord_sph<T, U, V>,
	{
		<Self as CodeAsmVcmpord_sph<T, U, V>>::vcmpord_sph(self, op0, op1, op2)
	}

	/// `VCMPORD_SPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpord_sps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpord_sps<T, U, V>,
	{
		<Self as CodeAsmVcmpord_sps<T, U, V>>::vcmpord_sps(self, op0, op1, op2)
	}

	/// `VCMPORD_SSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpord_ssd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpord_ssd<T, U, V>,
	{
		<Self as CodeAsmVcmpord_ssd<T, U, V>>::vcmpord_ssd(self, op0, op1, op2)
	}

	/// `VCMPORD_SSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpord_ssh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpord_ssh<T, U, V>,
	{
		<Self as CodeAsmVcmpord_ssh<T, U, V>>::vcmpord_ssh(self, op0, op1, op2)
	}

	/// `VCMPORD_SSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpord_sss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpord_sss<T, U, V>,
	{
		<Self as CodeAsmVcmpord_sss<T, U, V>>::vcmpord_sss(self, op0, op1, op2)
	}

	/// `VCMPORDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpordpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpordpd<T, U, V>,
	{
		<Self as CodeAsmVcmpordpd<T, U, V>>::vcmpordpd(self, op0, op1, op2)
	}

	/// `VCMPORDPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpordph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpordph<T, U, V>,
	{
		<Self as CodeAsmVcmpordph<T, U, V>>::vcmpordph(self, op0, op1, op2)
	}

	/// `VCMPORDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpordps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpordps<T, U, V>,
	{
		<Self as CodeAsmVcmpordps<T, U, V>>::vcmpordps(self, op0, op1, op2)
	}

	/// `VCMPORDSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpordsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpordsd<T, U, V>,
	{
		<Self as CodeAsmVcmpordsd<T, U, V>>::vcmpordsd(self, op0, op1, op2)
	}

	/// `VCMPORDSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpordsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpordsh<T, U, V>,
	{
		<Self as CodeAsmVcmpordsh<T, U, V>>::vcmpordsh(self, op0, op1, op2)
	}

	/// `VCMPORDSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpordss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpordss<T, U, V>,
	{
		<Self as CodeAsmVcmpordss<T, U, V>>::vcmpordss(self, op0, op1, op2)
	}

	/// `VCMPPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vcmppd<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmppd<T, U, V, W>,
	{
		<Self as CodeAsmVcmppd<T, U, V, W>>::vcmppd(self, op0, op1, op2, op3)
	}

	/// `VCMPPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vcmpph<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpph<T, U, V, W>,
	{
		<Self as CodeAsmVcmpph<T, U, V, W>>::vcmpph(self, op0, op1, op2, op3)
	}

	/// `VCMPPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vcmpps<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpps<T, U, V, W>,
	{
		<Self as CodeAsmVcmpps<T, U, V, W>>::vcmpps(self, op0, op1, op2, op3)
	}

	/// `VCMPSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vcmpsd<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpsd<T, U, V, W>,
	{
		<Self as CodeAsmVcmpsd<T, U, V, W>>::vcmpsd(self, op0, op1, op2, op3)
	}

	/// `VCMPSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vcmpsh<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpsh<T, U, V, W>,
	{
		<Self as CodeAsmVcmpsh<T, U, V, W>>::vcmpsh(self, op0, op1, op2, op3)
	}

	/// `VCMPSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vcmpss<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpss<T, U, V, W>,
	{
		<Self as CodeAsmVcmpss<T, U, V, W>>::vcmpss(self, op0, op1, op2, op3)
	}

	/// `VCMPTRUE_USPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptrue_uspd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptrue_uspd<T, U, V>,
	{
		<Self as CodeAsmVcmptrue_uspd<T, U, V>>::vcmptrue_uspd(self, op0, op1, op2)
	}

	/// `VCMPTRUE_USPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptrue_usph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptrue_usph<T, U, V>,
	{
		<Self as CodeAsmVcmptrue_usph<T, U, V>>::vcmptrue_usph(self, op0, op1, op2)
	}

	/// `VCMPTRUE_USPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptrue_usps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptrue_usps<T, U, V>,
	{
		<Self as CodeAsmVcmptrue_usps<T, U, V>>::vcmptrue_usps(self, op0, op1, op2)
	}

	/// `VCMPTRUE_USSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptrue_ussd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptrue_ussd<T, U, V>,
	{
		<Self as CodeAsmVcmptrue_ussd<T, U, V>>::vcmptrue_ussd(self, op0, op1, op2)
	}

	/// `VCMPTRUE_USSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptrue_ussh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptrue_ussh<T, U, V>,
	{
		<Self as CodeAsmVcmptrue_ussh<T, U, V>>::vcmptrue_ussh(self, op0, op1, op2)
	}

	/// `VCMPTRUE_USSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptrue_usss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptrue_usss<T, U, V>,
	{
		<Self as CodeAsmVcmptrue_usss<T, U, V>>::vcmptrue_usss(self, op0, op1, op2)
	}

	/// `VCMPTRUEPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptruepd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptruepd<T, U, V>,
	{
		<Self as CodeAsmVcmptruepd<T, U, V>>::vcmptruepd(self, op0, op1, op2)
	}

	/// `VCMPTRUEPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptrueph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptrueph<T, U, V>,
	{
		<Self as CodeAsmVcmptrueph<T, U, V>>::vcmptrueph(self, op0, op1, op2)
	}

	/// `VCMPTRUEPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptrueps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptrueps<T, U, V>,
	{
		<Self as CodeAsmVcmptrueps<T, U, V>>::vcmptrueps(self, op0, op1, op2)
	}

	/// `VCMPTRUESD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptruesd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptruesd<T, U, V>,
	{
		<Self as CodeAsmVcmptruesd<T, U, V>>::vcmptruesd(self, op0, op1, op2)
	}

	/// `VCMPTRUESH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptruesh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptruesh<T, U, V>,
	{
		<Self as CodeAsmVcmptruesh<T, U, V>>::vcmptruesh(self, op0, op1, op2)
	}

	/// `VCMPTRUESS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmptruess<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmptruess<T, U, V>,
	{
		<Self as CodeAsmVcmptruess<T, U, V>>::vcmptruess(self, op0, op1, op2)
	}

	/// `VCMPUNORD_SPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunord_spd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunord_spd<T, U, V>,
	{
		<Self as CodeAsmVcmpunord_spd<T, U, V>>::vcmpunord_spd(self, op0, op1, op2)
	}

	/// `VCMPUNORD_SPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunord_sph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunord_sph<T, U, V>,
	{
		<Self as CodeAsmVcmpunord_sph<T, U, V>>::vcmpunord_sph(self, op0, op1, op2)
	}

	/// `VCMPUNORD_SPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunord_sps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunord_sps<T, U, V>,
	{
		<Self as CodeAsmVcmpunord_sps<T, U, V>>::vcmpunord_sps(self, op0, op1, op2)
	}

	/// `VCMPUNORD_SSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunord_ssd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunord_ssd<T, U, V>,
	{
		<Self as CodeAsmVcmpunord_ssd<T, U, V>>::vcmpunord_ssd(self, op0, op1, op2)
	}

	/// `VCMPUNORD_SSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunord_ssh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunord_ssh<T, U, V>,
	{
		<Self as CodeAsmVcmpunord_ssh<T, U, V>>::vcmpunord_ssh(self, op0, op1, op2)
	}

	/// `VCMPUNORD_SSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunord_sss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunord_sss<T, U, V>,
	{
		<Self as CodeAsmVcmpunord_sss<T, U, V>>::vcmpunord_sss(self, op0, op1, op2)
	}

	/// `VCMPUNORDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F.W1 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunordpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunordpd<T, U, V>,
	{
		<Self as CodeAsmVcmpunordpd<T, U, V>>::vcmpunordpd(self, op0, op1, op2)
	}

	/// `VCMPUNORDPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8` | `EVEX.128.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8` | `EVEX.256.0F3A.W0 C2 /r ib` | `AVX512VL AVX512-FP16`
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8` | `EVEX.512.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunordph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunordph<T, U, V>,
	{
		<Self as CodeAsmVcmpunordph<T, U, V>>::vcmpunordph(self, op0, op1, op2)
	}

	/// `VCMPUNORDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.0F.W0 C2 /r ib` | `AVX512VL AVX512F`
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunordps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunordps<T, U, V>,
	{
		<Self as CodeAsmVcmpunordps<T, U, V>>::vcmpunordps(self, op0, op1, op2)
	}

	/// `VCMPUNORDSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8` | `VEX.LIG.F2.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.F2.0F.W1 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunordsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunordsd<T, U, V>,
	{
		<Self as CodeAsmVcmpunordsd<T, U, V>>::vcmpunordsd(self, op0, op1, op2)
	}

	/// `VCMPUNORDSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8` | `EVEX.LIG.F3.0F3A.W0 C2 /r ib` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunordsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunordsh<T, U, V>,
	{
		<Self as CodeAsmVcmpunordsh<T, U, V>>::vcmpunordsh(self, op0, op1, op2)
	}

	/// `VCMPUNORDSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8` | `VEX.LIG.F3.0F.WIG C2 /r ib` | `AVX`
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.F3.0F.W0 C2 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcmpunordss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcmpunordss<T, U, V>,
	{
		<Self as CodeAsmVcmpunordss<T, U, V>>::vcmpunordss(self, op0, op1, op2)
	}

	/// `VCOMISD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCOMISD xmm1, xmm2/m64` | `VEX.LIG.66.0F.WIG 2F /r` | `AVX`
	/// `VCOMISD xmm1, xmm2/m64{sae}` | `EVEX.LIG.66.0F.W1 2F /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcomisd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcomisd<T, U>,
	{
		<Self as CodeAsmVcomisd<T, U>>::vcomisd(self, op0, op1)
	}

	/// `VCOMISH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCOMISH xmm1, xmm2/m16{sae}` | `EVEX.LIG.MAP5.W0 2F /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcomish<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcomish<T, U>,
	{
		<Self as CodeAsmVcomish<T, U>>::vcomish(self, op0, op1)
	}

	/// `VCOMISS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCOMISS xmm1, xmm2/m32` | `VEX.LIG.0F.WIG 2F /r` | `AVX`
	/// `VCOMISS xmm1, xmm2/m32{sae}` | `EVEX.LIG.0F.W0 2F /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcomiss<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcomiss<T, U>,
	{
		<Self as CodeAsmVcomiss<T, U>>::vcomiss(self, op0, op1)
	}

	/// `VCOMPRESSPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCOMPRESSPD xmm1/m128 {k1}{z}, xmm2` | `EVEX.128.66.0F38.W1 8A /r` | `AVX512VL AVX512F`
	/// `VCOMPRESSPD ymm1/m256 {k1}{z}, ymm2` | `EVEX.256.66.0F38.W1 8A /r` | `AVX512VL AVX512F`
	/// `VCOMPRESSPD zmm1/m512 {k1}{z}, zmm2` | `EVEX.512.66.0F38.W1 8A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcompresspd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcompresspd<T, U>,
	{
		<Self as CodeAsmVcompresspd<T, U>>::vcompresspd(self, op0, op1)
	}

	/// `VCOMPRESSPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCOMPRESSPS xmm1/m128 {k1}{z}, xmm2` | `EVEX.128.66.0F38.W0 8A /r` | `AVX512VL AVX512F`
	/// `VCOMPRESSPS ymm1/m256 {k1}{z}, ymm2` | `EVEX.256.66.0F38.W0 8A /r` | `AVX512VL AVX512F`
	/// `VCOMPRESSPS zmm1/m512 {k1}{z}, zmm2` | `EVEX.512.66.0F38.W0 8A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcompressps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcompressps<T, U>,
	{
		<Self as CodeAsmVcompressps<T, U>>::vcompressps(self, op0, op1)
	}

	/// `VCVTDQ2PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTDQ2PD xmm1, xmm2/m64` | `VEX.128.F3.0F.WIG E6 /r` | `AVX`
	/// `VCVTDQ2PD ymm1, xmm2/m128` | `VEX.256.F3.0F.WIG E6 /r` | `AVX`
	/// `VCVTDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst` | `EVEX.128.F3.0F.W0 E6 /r` | `AVX512VL AVX512F`
	/// `VCVTDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.256.F3.0F.W0 E6 /r` | `AVX512VL AVX512F`
	/// `VCVTDQ2PD zmm1 {k1}{z}, ymm2/m256/m32bcst{er}` | `EVEX.512.F3.0F.W0 E6 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtdq2pd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtdq2pd<T, U>,
	{
		<Self as CodeAsmVcvtdq2pd<T, U>>::vcvtdq2pd(self, op0, op1)
	}

	/// `VCVTDQ2PH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTDQ2PH xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.MAP5.W0 5B /r` | `AVX512VL AVX512-FP16`
	/// `VCVTDQ2PH xmm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.MAP5.W0 5B /r` | `AVX512VL AVX512-FP16`
	/// `VCVTDQ2PH ymm1 {k1}{z}, zmm2/m512/m32bcst{er}` | `EVEX.512.MAP5.W0 5B /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtdq2ph<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtdq2ph<T, U>,
	{
		<Self as CodeAsmVcvtdq2ph<T, U>>::vcvtdq2ph(self, op0, op1)
	}

	/// `VCVTDQ2PHX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTDQ2PH xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.MAP5.W0 5B /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtdq2phx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtdq2phx<T, U>,
	{
		<Self as CodeAsmVcvtdq2phx<T, U>>::vcvtdq2phx(self, op0, op1)
	}

	/// `VCVTDQ2PHY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTDQ2PH xmm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.MAP5.W0 5B /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtdq2phy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtdq2phy<T, U>,
	{
		<Self as CodeAsmVcvtdq2phy<T, U>>::vcvtdq2phy(self, op0, op1)
	}

	/// `VCVTDQ2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTDQ2PS xmm1, xmm2/m128` | `VEX.128.0F.WIG 5B /r` | `AVX`
	/// `VCVTDQ2PS ymm1, ymm2/m256` | `VEX.256.0F.WIG 5B /r` | `AVX`
	/// `VCVTDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.0F.W0 5B /r` | `AVX512VL AVX512F`
	/// `VCVTDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.0F.W0 5B /r` | `AVX512VL AVX512F`
	/// `VCVTDQ2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{er}` | `EVEX.512.0F.W0 5B /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtdq2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtdq2ps<T, U>,
	{
		<Self as CodeAsmVcvtdq2ps<T, U>>::vcvtdq2ps(self, op0, op1)
	}

	/// `VCVTNE2PS2BF16` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTNE2PS2BF16 xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.F2.0F38.W0 72 /r` | `AVX512VL AVX512_BF16`
	/// `VCVTNE2PS2BF16 ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.F2.0F38.W0 72 /r` | `AVX512VL AVX512_BF16`
	/// `VCVTNE2PS2BF16 zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst` | `EVEX.512.F2.0F38.W0 72 /r` | `AVX512F AVX512_BF16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtne2ps2bf16<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtne2ps2bf16<T, U, V>,
	{
		<Self as CodeAsmVcvtne2ps2bf16<T, U, V>>::vcvtne2ps2bf16(self, op0, op1, op2)
	}

	/// `VCVTNEEBF162PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTNEEBF162PS xmm1, m128` | `VEX.128.F3.0F38.W0 B0 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	/// `VCVTNEEBF162PS ymm1, m256` | `VEX.256.F3.0F38.W0 B0 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtneebf162ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtneebf162ps<T, U>,
	{
		<Self as CodeAsmVcvtneebf162ps<T, U>>::vcvtneebf162ps(self, op0, op1)
	}

	/// `VCVTNEEPH2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTNEEPH2PS xmm1, m128` | `VEX.128.66.0F38.W0 B0 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	/// `VCVTNEEPH2PS ymm1, m256` | `VEX.256.66.0F38.W0 B0 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtneeph2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtneeph2ps<T, U>,
	{
		<Self as CodeAsmVcvtneeph2ps<T, U>>::vcvtneeph2ps(self, op0, op1)
	}

	/// `VCVTNEOBF162PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTNEOBF162PS xmm1, m128` | `VEX.128.F2.0F38.W0 B0 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	/// `VCVTNEOBF162PS ymm1, m256` | `VEX.256.F2.0F38.W0 B0 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtneobf162ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtneobf162ps<T, U>,
	{
		<Self as CodeAsmVcvtneobf162ps<T, U>>::vcvtneobf162ps(self, op0, op1)
	}

	/// `VCVTNEOPH2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTNEOPH2PS xmm1, m128` | `VEX.128.0F38.W0 B0 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	/// `VCVTNEOPH2PS ymm1, m256` | `VEX.256.0F38.W0 B0 !(11):rrr:bbb` | `AVX-NE-CONVERT`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtneoph2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtneoph2ps<T, U>,
	{
		<Self as CodeAsmVcvtneoph2ps<T, U>>::vcvtneoph2ps(self, op0, op1)
	}

	/// `VCVTNEPS2BF16` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTNEPS2BF16 xmm1, xmm2/m128` | `VEX.128.F3.0F38.W0 72 /r` | `AVX-NE-CONVERT`
	/// `VCVTNEPS2BF16 xmm1, ymm2/m256` | `VEX.256.F3.0F38.W0 72 /r` | `AVX-NE-CONVERT`
	/// `VCVTNEPS2BF16 xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.F3.0F38.W0 72 /r` | `AVX512VL AVX512_BF16`
	/// `VCVTNEPS2BF16 xmm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.F3.0F38.W0 72 /r` | `AVX512VL AVX512_BF16`
	/// `VCVTNEPS2BF16 ymm1 {k1}{z}, zmm2/m512/m32bcst` | `EVEX.512.F3.0F38.W0 72 /r` | `AVX512F AVX512_BF16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtneps2bf16<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtneps2bf16<T, U>,
	{
		<Self as CodeAsmVcvtneps2bf16<T, U>>::vcvtneps2bf16(self, op0, op1)
	}

	/// `VCVTNEPS2BF16X` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTNEPS2BF16 xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.F3.0F38.W0 72 /r` | `AVX512VL AVX512_BF16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtneps2bf16x<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtneps2bf16x<T, U>,
	{
		<Self as CodeAsmVcvtneps2bf16x<T, U>>::vcvtneps2bf16x(self, op0, op1)
	}

	/// `VCVTNEPS2BF16Y` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTNEPS2BF16 xmm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.F3.0F38.W0 72 /r` | `AVX512VL AVX512_BF16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtneps2bf16y<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtneps2bf16y<T, U>,
	{
		<Self as CodeAsmVcvtneps2bf16y<T, U>>::vcvtneps2bf16y(self, op0, op1)
	}

	/// `VCVTPD2DQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2DQ xmm1, xmm2/m128` | `VEX.128.F2.0F.WIG E6 /r` | `AVX`
	/// `VCVTPD2DQ xmm1, ymm2/m256` | `VEX.256.F2.0F.WIG E6 /r` | `AVX`
	/// `VCVTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.F2.0F.W1 E6 /r` | `AVX512VL AVX512F`
	/// `VCVTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.F2.0F.W1 E6 /r` | `AVX512VL AVX512F`
	/// `VCVTPD2DQ ymm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.F2.0F.W1 E6 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2dq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2dq<T, U>,
	{
		<Self as CodeAsmVcvtpd2dq<T, U>>::vcvtpd2dq(self, op0, op1)
	}

	/// `VCVTPD2DQX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.F2.0F.W1 E6 /r` | `AVX512VL AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2dqx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2dqx<T, U>,
	{
		<Self as CodeAsmVcvtpd2dqx<T, U>>::vcvtpd2dqx(self, op0, op1)
	}

	/// `VCVTPD2DQY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.F2.0F.W1 E6 /r` | `AVX512VL AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2dqy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2dqy<T, U>,
	{
		<Self as CodeAsmVcvtpd2dqy<T, U>>::vcvtpd2dqy(self, op0, op1)
	}

	/// `VCVTPD2PH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2PH xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.66.MAP5.W1 5A /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPD2PH xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.66.MAP5.W1 5A /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPD2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.66.MAP5.W1 5A /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2ph<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2ph<T, U>,
	{
		<Self as CodeAsmVcvtpd2ph<T, U>>::vcvtpd2ph(self, op0, op1)
	}

	/// `VCVTPD2PHX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2PH xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.66.MAP5.W1 5A /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2phx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2phx<T, U>,
	{
		<Self as CodeAsmVcvtpd2phx<T, U>>::vcvtpd2phx(self, op0, op1)
	}

	/// `VCVTPD2PHY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2PH xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.66.MAP5.W1 5A /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2phy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2phy<T, U>,
	{
		<Self as CodeAsmVcvtpd2phy<T, U>>::vcvtpd2phy(self, op0, op1)
	}

	/// `VCVTPD2PHZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.66.MAP5.W1 5A /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2phz<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2phz<T, U>,
	{
		<Self as CodeAsmVcvtpd2phz<T, U>>::vcvtpd2phz(self, op0, op1)
	}

	/// `VCVTPD2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2PS xmm1, xmm2/m128` | `VEX.128.66.0F.WIG 5A /r` | `AVX`
	/// `VCVTPD2PS xmm1, ymm2/m256` | `VEX.256.66.0F.WIG 5A /r` | `AVX`
	/// `VCVTPD2PS xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.66.0F.W1 5A /r` | `AVX512VL AVX512F`
	/// `VCVTPD2PS xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.66.0F.W1 5A /r` | `AVX512VL AVX512F`
	/// `VCVTPD2PS ymm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.66.0F.W1 5A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2ps<T, U>,
	{
		<Self as CodeAsmVcvtpd2ps<T, U>>::vcvtpd2ps(self, op0, op1)
	}

	/// `VCVTPD2PSX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2PS xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.66.0F.W1 5A /r` | `AVX512VL AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2psx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2psx<T, U>,
	{
		<Self as CodeAsmVcvtpd2psx<T, U>>::vcvtpd2psx(self, op0, op1)
	}

	/// `VCVTPD2PSY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2PS xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.66.0F.W1 5A /r` | `AVX512VL AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2psy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2psy<T, U>,
	{
		<Self as CodeAsmVcvtpd2psy<T, U>>::vcvtpd2psy(self, op0, op1)
	}

	/// `VCVTPD2QQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2QQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.66.0F.W1 7B /r` | `AVX512VL AVX512DQ`
	/// `VCVTPD2QQ ymm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.66.0F.W1 7B /r` | `AVX512VL AVX512DQ`
	/// `VCVTPD2QQ zmm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.66.0F.W1 7B /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2qq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2qq<T, U>,
	{
		<Self as CodeAsmVcvtpd2qq<T, U>>::vcvtpd2qq(self, op0, op1)
	}

	/// `VCVTPD2UDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.0F.W1 79 /r` | `AVX512VL AVX512F`
	/// `VCVTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.0F.W1 79 /r` | `AVX512VL AVX512F`
	/// `VCVTPD2UDQ ymm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.0F.W1 79 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2udq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2udq<T, U>,
	{
		<Self as CodeAsmVcvtpd2udq<T, U>>::vcvtpd2udq(self, op0, op1)
	}

	/// `VCVTPD2UDQX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.0F.W1 79 /r` | `AVX512VL AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2udqx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2udqx<T, U>,
	{
		<Self as CodeAsmVcvtpd2udqx<T, U>>::vcvtpd2udqx(self, op0, op1)
	}

	/// `VCVTPD2UDQY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.0F.W1 79 /r` | `AVX512VL AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2udqy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2udqy<T, U>,
	{
		<Self as CodeAsmVcvtpd2udqy<T, U>>::vcvtpd2udqy(self, op0, op1)
	}

	/// `VCVTPD2UQQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPD2UQQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.66.0F.W1 79 /r` | `AVX512VL AVX512DQ`
	/// `VCVTPD2UQQ ymm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.66.0F.W1 79 /r` | `AVX512VL AVX512DQ`
	/// `VCVTPD2UQQ zmm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.66.0F.W1 79 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtpd2uqq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtpd2uqq<T, U>,
	{
		<Self as CodeAsmVcvtpd2uqq<T, U>>::vcvtpd2uqq(self, op0, op1)
	}

	/// `VCVTPH2DQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPH2DQ xmm1 {k1}{z}, xmm2/m64/m16bcst` | `EVEX.128.66.MAP5.W0 5B /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2DQ ymm1 {k1}{z}, xmm2/m128/m16bcst` | `EVEX.256.66.MAP5.W0 5B /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2DQ zmm1 {k1}{z}, ymm2/m256/m16bcst{er}` | `EVEX.512.66.MAP5.W0 5B /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtph2dq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtph2dq<T, U>,
	{
		<Self as CodeAsmVcvtph2dq<T, U>>::vcvtph2dq(self, op0, op1)
	}

	/// `VCVTPH2PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPH2PD xmm1 {k1}{z}, xmm2/m32/m16bcst` | `EVEX.128.MAP5.W0 5A /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2PD ymm1 {k1}{z}, xmm2/m64/m16bcst` | `EVEX.256.MAP5.W0 5A /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2PD zmm1 {k1}{z}, xmm2/m128/m16bcst{sae}` | `EVEX.512.MAP5.W0 5A /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtph2pd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtph2pd<T, U>,
	{
		<Self as CodeAsmVcvtph2pd<T, U>>::vcvtph2pd(self, op0, op1)
	}

	/// `VCVTPH2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPH2PS xmm1, xmm2/m64` | `VEX.128.66.0F38.W0 13 /r` | `F16C`
	/// `VCVTPH2PS ymm1, xmm2/m128` | `VEX.256.66.0F38.W0 13 /r` | `F16C`
	/// `VCVTPH2PS xmm1 {k1}{z}, xmm2/m64` | `EVEX.128.66.0F38.W0 13 /r` | `AVX512VL AVX512F`
	/// `VCVTPH2PS ymm1 {k1}{z}, xmm2/m128` | `EVEX.256.66.0F38.W0 13 /r` | `AVX512VL AVX512F`
	/// `VCVTPH2PS zmm1 {k1}{z}, ymm2/m256{sae}` | `EVEX.512.66.0F38.W0 13 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtph2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtph2ps<T, U>,
	{
		<Self as CodeAsmVcvtph2ps<T, U>>::vcvtph2ps(self, op0, op1)
	}

	/// `VCVTPH2PSX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPH2PSX xmm1 {k1}{z}, xmm2/m64/m16bcst` | `EVEX.128.66.MAP6.W0 13 /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2PSX ymm1 {k1}{z}, xmm2/m128/m16bcst` | `EVEX.256.66.MAP6.W0 13 /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2PSX zmm1 {k1}{z}, ymm2/m256/m16bcst{sae}` | `EVEX.512.66.MAP6.W0 13 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtph2psx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtph2psx<T, U>,
	{
		<Self as CodeAsmVcvtph2psx<T, U>>::vcvtph2psx(self, op0, op1)
	}

	/// `VCVTPH2QQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPH2QQ xmm1 {k1}{z}, xmm2/m32/m16bcst` | `EVEX.128.66.MAP5.W0 7B /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2QQ ymm1 {k1}{z}, xmm2/m64/m16bcst` | `EVEX.256.66.MAP5.W0 7B /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2QQ zmm1 {k1}{z}, xmm2/m128/m16bcst{er}` | `EVEX.512.66.MAP5.W0 7B /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtph2qq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtph2qq<T, U>,
	{
		<Self as CodeAsmVcvtph2qq<T, U>>::vcvtph2qq(self, op0, op1)
	}

	/// `VCVTPH2UDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPH2UDQ xmm1 {k1}{z}, xmm2/m64/m16bcst` | `EVEX.128.MAP5.W0 79 /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2UDQ ymm1 {k1}{z}, xmm2/m128/m16bcst` | `EVEX.256.MAP5.W0 79 /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2UDQ zmm1 {k1}{z}, ymm2/m256/m16bcst{er}` | `EVEX.512.MAP5.W0 79 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtph2udq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtph2udq<T, U>,
	{
		<Self as CodeAsmVcvtph2udq<T, U>>::vcvtph2udq(self, op0, op1)
	}

	/// `VCVTPH2UQQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPH2UQQ xmm1 {k1}{z}, xmm2/m32/m16bcst` | `EVEX.128.66.MAP5.W0 79 /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2UQQ ymm1 {k1}{z}, xmm2/m64/m16bcst` | `EVEX.256.66.MAP5.W0 79 /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2UQQ zmm1 {k1}{z}, xmm2/m128/m16bcst{er}` | `EVEX.512.66.MAP5.W0 79 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtph2uqq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtph2uqq<T, U>,
	{
		<Self as CodeAsmVcvtph2uqq<T, U>>::vcvtph2uqq(self, op0, op1)
	}

	/// `VCVTPH2UW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPH2UW xmm1 {k1}{z}, xmm2/m128/m16bcst` | `EVEX.128.MAP5.W0 7D /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2UW ymm1 {k1}{z}, ymm2/m256/m16bcst` | `EVEX.256.MAP5.W0 7D /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2UW zmm1 {k1}{z}, zmm2/m512/m16bcst{er}` | `EVEX.512.MAP5.W0 7D /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtph2uw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtph2uw<T, U>,
	{
		<Self as CodeAsmVcvtph2uw<T, U>>::vcvtph2uw(self, op0, op1)
	}

	/// `VCVTPH2W` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPH2W xmm1 {k1}{z}, xmm2/m128/m16bcst` | `EVEX.128.66.MAP5.W0 7D /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2W ymm1 {k1}{z}, ymm2/m256/m16bcst` | `EVEX.256.66.MAP5.W0 7D /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPH2W zmm1 {k1}{z}, zmm2/m512/m16bcst{er}` | `EVEX.512.66.MAP5.W0 7D /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtph2w<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtph2w<T, U>,
	{
		<Self as CodeAsmVcvtph2w<T, U>>::vcvtph2w(self, op0, op1)
	}

	/// `VCVTPS2DQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPS2DQ xmm1, xmm2/m128` | `VEX.128.66.0F.WIG 5B /r` | `AVX`
	/// `VCVTPS2DQ ymm1, ymm2/m256` | `VEX.256.66.0F.WIG 5B /r` | `AVX`
	/// `VCVTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.66.0F.W0 5B /r` | `AVX512VL AVX512F`
	/// `VCVTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.66.0F.W0 5B /r` | `AVX512VL AVX512F`
	/// `VCVTPS2DQ zmm1 {k1}{z}, zmm2/m512/m32bcst{er}` | `EVEX.512.66.0F.W0 5B /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtps2dq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtps2dq<T, U>,
	{
		<Self as CodeAsmVcvtps2dq<T, U>>::vcvtps2dq(self, op0, op1)
	}

	/// `VCVTPS2PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPS2PD xmm1, xmm2/m64` | `VEX.128.0F.WIG 5A /r` | `AVX`
	/// `VCVTPS2PD ymm1, xmm2/m128` | `VEX.256.0F.WIG 5A /r` | `AVX`
	/// `VCVTPS2PD xmm1 {k1}{z}, xmm2/m64/m32bcst` | `EVEX.128.0F.W0 5A /r` | `AVX512VL AVX512F`
	/// `VCVTPS2PD ymm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.256.0F.W0 5A /r` | `AVX512VL AVX512F`
	/// `VCVTPS2PD zmm1 {k1}{z}, ymm2/m256/m32bcst{sae}` | `EVEX.512.0F.W0 5A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtps2pd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtps2pd<T, U>,
	{
		<Self as CodeAsmVcvtps2pd<T, U>>::vcvtps2pd(self, op0, op1)
	}

	/// `VCVTPS2PH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPS2PH xmm1/m64, xmm2, imm8` | `VEX.128.66.0F3A.W0 1D /r ib` | `F16C`
	/// `VCVTPS2PH xmm1/m128, ymm2, imm8` | `VEX.256.66.0F3A.W0 1D /r ib` | `F16C`
	/// `VCVTPS2PH xmm1/m64 {k1}{z}, xmm2, imm8` | `EVEX.128.66.0F3A.W0 1D /r ib` | `AVX512VL AVX512F`
	/// `VCVTPS2PH xmm1/m128 {k1}{z}, ymm2, imm8` | `EVEX.256.66.0F3A.W0 1D /r ib` | `AVX512VL AVX512F`
	/// `VCVTPS2PH ymm1/m256 {k1}{z}, zmm2{sae}, imm8` | `EVEX.512.66.0F3A.W0 1D /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtps2ph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtps2ph<T, U, V>,
	{
		<Self as CodeAsmVcvtps2ph<T, U, V>>::vcvtps2ph(self, op0, op1, op2)
	}

	/// `VCVTPS2PHX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPS2PHX xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.66.MAP5.W0 1D /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPS2PHX xmm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.66.MAP5.W0 1D /r` | `AVX512VL AVX512-FP16`
	/// `VCVTPS2PHX ymm1 {k1}{z}, zmm2/m512/m32bcst{er}` | `EVEX.512.66.MAP5.W0 1D /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtps2phx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtps2phx<T, U>,
	{
		<Self as CodeAsmVcvtps2phx<T, U>>::vcvtps2phx(self, op0, op1)
	}

	/// `VCVTPS2PHXX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPS2PHX xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.66.MAP5.W0 1D /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtps2phxx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtps2phxx<T, U>,
	{
		<Self as CodeAsmVcvtps2phxx<T, U>>::vcvtps2phxx(self, op0, op1)
	}

	/// `VCVTPS2PHXY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPS2PHX xmm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.66.MAP5.W0 1D /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtps2phxy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtps2phxy<T, U>,
	{
		<Self as CodeAsmVcvtps2phxy<T, U>>::vcvtps2phxy(self, op0, op1)
	}

	/// `VCVTPS2QQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPS2QQ xmm1 {k1}{z}, xmm2/m64/m32bcst` | `EVEX.128.66.0F.W0 7B /r` | `AVX512VL AVX512DQ`
	/// `VCVTPS2QQ ymm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.256.66.0F.W0 7B /r` | `AVX512VL AVX512DQ`
	/// `VCVTPS2QQ zmm1 {k1}{z}, ymm2/m256/m32bcst{er}` | `EVEX.512.66.0F.W0 7B /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtps2qq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtps2qq<T, U>,
	{
		<Self as CodeAsmVcvtps2qq<T, U>>::vcvtps2qq(self, op0, op1)
	}

	/// `VCVTPS2UDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPS2UDQ xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.0F.W0 79 /r` | `AVX512VL AVX512F`
	/// `VCVTPS2UDQ ymm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.0F.W0 79 /r` | `AVX512VL AVX512F`
	/// `VCVTPS2UDQ zmm1 {k1}{z}, zmm2/m512/m32bcst{er}` | `EVEX.512.0F.W0 79 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtps2udq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtps2udq<T, U>,
	{
		<Self as CodeAsmVcvtps2udq<T, U>>::vcvtps2udq(self, op0, op1)
	}

	/// `VCVTPS2UQQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTPS2UQQ xmm1 {k1}{z}, xmm2/m64/m32bcst` | `EVEX.128.66.0F.W0 79 /r` | `AVX512VL AVX512DQ`
	/// `VCVTPS2UQQ ymm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.256.66.0F.W0 79 /r` | `AVX512VL AVX512DQ`
	/// `VCVTPS2UQQ zmm1 {k1}{z}, ymm2/m256/m32bcst{er}` | `EVEX.512.66.0F.W0 79 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtps2uqq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtps2uqq<T, U>,
	{
		<Self as CodeAsmVcvtps2uqq<T, U>>::vcvtps2uqq(self, op0, op1)
	}

	/// `VCVTQQ2PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTQQ2PD xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.F3.0F.W1 E6 /r` | `AVX512VL AVX512DQ`
	/// `VCVTQQ2PD ymm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.F3.0F.W1 E6 /r` | `AVX512VL AVX512DQ`
	/// `VCVTQQ2PD zmm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.F3.0F.W1 E6 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtqq2pd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtqq2pd<T, U>,
	{
		<Self as CodeAsmVcvtqq2pd<T, U>>::vcvtqq2pd(self, op0, op1)
	}

	/// `VCVTQQ2PH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTQQ2PH xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.MAP5.W1 5B /r` | `AVX512VL AVX512-FP16`
	/// `VCVTQQ2PH xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.MAP5.W1 5B /r` | `AVX512VL AVX512-FP16`
	/// `VCVTQQ2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.MAP5.W1 5B /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtqq2ph<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtqq2ph<T, U>,
	{
		<Self as CodeAsmVcvtqq2ph<T, U>>::vcvtqq2ph(self, op0, op1)
	}

	/// `VCVTQQ2PHX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTQQ2PH xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.MAP5.W1 5B /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtqq2phx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtqq2phx<T, U>,
	{
		<Self as CodeAsmVcvtqq2phx<T, U>>::vcvtqq2phx(self, op0, op1)
	}

	/// `VCVTQQ2PHY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTQQ2PH xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.MAP5.W1 5B /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtqq2phy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtqq2phy<T, U>,
	{
		<Self as CodeAsmVcvtqq2phy<T, U>>::vcvtqq2phy(self, op0, op1)
	}

	/// `VCVTQQ2PHZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTQQ2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.MAP5.W1 5B /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtqq2phz<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtqq2phz<T, U>,
	{
		<Self as CodeAsmVcvtqq2phz<T, U>>::vcvtqq2phz(self, op0, op1)
	}

	/// `VCVTQQ2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTQQ2PS xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.0F.W1 5B /r` | `AVX512VL AVX512DQ`
	/// `VCVTQQ2PS xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.0F.W1 5B /r` | `AVX512VL AVX512DQ`
	/// `VCVTQQ2PS ymm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.0F.W1 5B /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtqq2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtqq2ps<T, U>,
	{
		<Self as CodeAsmVcvtqq2ps<T, U>>::vcvtqq2ps(self, op0, op1)
	}

	/// `VCVTQQ2PSX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTQQ2PS xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.0F.W1 5B /r` | `AVX512VL AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtqq2psx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtqq2psx<T, U>,
	{
		<Self as CodeAsmVcvtqq2psx<T, U>>::vcvtqq2psx(self, op0, op1)
	}

	/// `VCVTQQ2PSY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTQQ2PS xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.0F.W1 5B /r` | `AVX512VL AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtqq2psy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtqq2psy<T, U>,
	{
		<Self as CodeAsmVcvtqq2psy<T, U>>::vcvtqq2psy(self, op0, op1)
	}

	/// `VCVTSD2SH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSD2SH xmm1 {k1}{z}, xmm2, xmm3/m64{er}` | `EVEX.LIG.F2.MAP5.W1 5A /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtsd2sh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtsd2sh<T, U, V>,
	{
		<Self as CodeAsmVcvtsd2sh<T, U, V>>::vcvtsd2sh(self, op0, op1, op2)
	}

	/// `VCVTSD2SI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSD2SI r32, xmm1/m64` | `VEX.LIG.F2.0F.W0 2D /r` | `AVX`
	/// `VCVTSD2SI r64, xmm1/m64` | `VEX.LIG.F2.0F.W1 2D /r` | `AVX`
	/// `VCVTSD2SI r32, xmm1/m64{er}` | `EVEX.LIG.F2.0F.W0 2D /r` | `AVX512F`
	/// `VCVTSD2SI r64, xmm1/m64{er}` | `EVEX.LIG.F2.0F.W1 2D /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtsd2si<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtsd2si<T, U>,
	{
		<Self as CodeAsmVcvtsd2si<T, U>>::vcvtsd2si(self, op0, op1)
	}

	/// `VCVTSD2SS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSD2SS xmm1, xmm2, xmm3/m64` | `VEX.LIG.F2.0F.WIG 5A /r` | `AVX`
	/// `VCVTSD2SS xmm1 {k1}{z}, xmm2, xmm3/m64{er}` | `EVEX.LIG.F2.0F.W1 5A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtsd2ss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtsd2ss<T, U, V>,
	{
		<Self as CodeAsmVcvtsd2ss<T, U, V>>::vcvtsd2ss(self, op0, op1, op2)
	}

	/// `VCVTSD2USI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSD2USI r32, xmm1/m64{er}` | `EVEX.LIG.F2.0F.W0 79 /r` | `AVX512F`
	/// `VCVTSD2USI r64, xmm1/m64{er}` | `EVEX.LIG.F2.0F.W1 79 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtsd2usi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtsd2usi<T, U>,
	{
		<Self as CodeAsmVcvtsd2usi<T, U>>::vcvtsd2usi(self, op0, op1)
	}

	/// `VCVTSH2SD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSH2SD xmm1 {k1}{z}, xmm2, xmm3/m16{sae}` | `EVEX.LIG.F3.MAP5.W0 5A /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtsh2sd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtsh2sd<T, U, V>,
	{
		<Self as CodeAsmVcvtsh2sd<T, U, V>>::vcvtsh2sd(self, op0, op1, op2)
	}

	/// `VCVTSH2SI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSH2SI r32, xmm1/m16{er}` | `EVEX.LIG.F3.MAP5.W0 2D /r` | `AVX512-FP16`
	/// `VCVTSH2SI r64, xmm1/m16{er}` | `EVEX.LIG.F3.MAP5.W1 2D /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtsh2si<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtsh2si<T, U>,
	{
		<Self as CodeAsmVcvtsh2si<T, U>>::vcvtsh2si(self, op0, op1)
	}

	/// `VCVTSH2SS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSH2SS xmm1 {k1}{z}, xmm2, xmm3/m16{sae}` | `EVEX.LIG.MAP6.W0 13 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtsh2ss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtsh2ss<T, U, V>,
	{
		<Self as CodeAsmVcvtsh2ss<T, U, V>>::vcvtsh2ss(self, op0, op1, op2)
	}

	/// `VCVTSH2USI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSH2USI r32, xmm1/m16{er}` | `EVEX.LIG.F3.MAP5.W0 79 /r` | `AVX512-FP16`
	/// `VCVTSH2USI r64, xmm1/m16{er}` | `EVEX.LIG.F3.MAP5.W1 79 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtsh2usi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtsh2usi<T, U>,
	{
		<Self as CodeAsmVcvtsh2usi<T, U>>::vcvtsh2usi(self, op0, op1)
	}

	/// `VCVTSI2SD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSI2SD xmm1, xmm2, r/m32` | `VEX.LIG.F2.0F.W0 2A /r` | `AVX`
	/// `VCVTSI2SD xmm1, xmm2, r/m64` | `VEX.LIG.F2.0F.W1 2A /r` | `AVX`
	/// `VCVTSI2SD xmm1, xmm2, r/m32{er}` | `EVEX.LIG.F2.0F.W0 2A /r` | `AVX512F`
	/// `VCVTSI2SD xmm1, xmm2, r/m64{er}` | `EVEX.LIG.F2.0F.W1 2A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtsi2sd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtsi2sd<T, U, V>,
	{
		<Self as CodeAsmVcvtsi2sd<T, U, V>>::vcvtsi2sd(self, op0, op1, op2)
	}

	/// `VCVTSI2SH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSI2SH xmm1, xmm2, r/m32{er}` | `EVEX.LIG.F3.MAP5.W0 2A /r` | `AVX512-FP16`
	/// `VCVTSI2SH xmm1, xmm2, r/m64{er}` | `EVEX.LIG.F3.MAP5.W1 2A /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtsi2sh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtsi2sh<T, U, V>,
	{
		<Self as CodeAsmVcvtsi2sh<T, U, V>>::vcvtsi2sh(self, op0, op1, op2)
	}

	/// `VCVTSI2SS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSI2SS xmm1, xmm2, r/m32` | `VEX.LIG.F3.0F.W0 2A /r` | `AVX`
	/// `VCVTSI2SS xmm1, xmm2, r/m64` | `VEX.LIG.F3.0F.W1 2A /r` | `AVX`
	/// `VCVTSI2SS xmm1, xmm2, r/m32{er}` | `EVEX.LIG.F3.0F.W0 2A /r` | `AVX512F`
	/// `VCVTSI2SS xmm1, xmm2, r/m64{er}` | `EVEX.LIG.F3.0F.W1 2A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtsi2ss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtsi2ss<T, U, V>,
	{
		<Self as CodeAsmVcvtsi2ss<T, U, V>>::vcvtsi2ss(self, op0, op1, op2)
	}

	/// `VCVTSS2SD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSS2SD xmm1, xmm2, xmm3/m32` | `VEX.LIG.F3.0F.WIG 5A /r` | `AVX`
	/// `VCVTSS2SD xmm1 {k1}{z}, xmm2, xmm3/m32{sae}` | `EVEX.LIG.F3.0F.W0 5A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtss2sd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtss2sd<T, U, V>,
	{
		<Self as CodeAsmVcvtss2sd<T, U, V>>::vcvtss2sd(self, op0, op1, op2)
	}

	/// `VCVTSS2SH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSS2SH xmm1 {k1}{z}, xmm2, xmm3/m32{er}` | `EVEX.LIG.MAP5.W0 1D /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtss2sh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtss2sh<T, U, V>,
	{
		<Self as CodeAsmVcvtss2sh<T, U, V>>::vcvtss2sh(self, op0, op1, op2)
	}

	/// `VCVTSS2SI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSS2SI r32, xmm1/m32` | `VEX.LIG.F3.0F.W0 2D /r` | `AVX`
	/// `VCVTSS2SI r64, xmm1/m32` | `VEX.LIG.F3.0F.W1 2D /r` | `AVX`
	/// `VCVTSS2SI r32, xmm1/m32{er}` | `EVEX.LIG.F3.0F.W0 2D /r` | `AVX512F`
	/// `VCVTSS2SI r64, xmm1/m32{er}` | `EVEX.LIG.F3.0F.W1 2D /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtss2si<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtss2si<T, U>,
	{
		<Self as CodeAsmVcvtss2si<T, U>>::vcvtss2si(self, op0, op1)
	}

	/// `VCVTSS2USI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTSS2USI r32, xmm1/m32{er}` | `EVEX.LIG.F3.0F.W0 79 /r` | `AVX512F`
	/// `VCVTSS2USI r64, xmm1/m32{er}` | `EVEX.LIG.F3.0F.W1 79 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtss2usi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtss2usi<T, U>,
	{
		<Self as CodeAsmVcvtss2usi<T, U>>::vcvtss2usi(self, op0, op1)
	}

	/// `VCVTTPD2DQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPD2DQ xmm1, xmm2/m128` | `VEX.128.66.0F.WIG E6 /r` | `AVX`
	/// `VCVTTPD2DQ xmm1, ymm2/m256` | `VEX.256.66.0F.WIG E6 /r` | `AVX`
	/// `VCVTTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.66.0F.W1 E6 /r` | `AVX512VL AVX512F`
	/// `VCVTTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.66.0F.W1 E6 /r` | `AVX512VL AVX512F`
	/// `VCVTTPD2DQ ymm1 {k1}{z}, zmm2/m512/m64bcst{sae}` | `EVEX.512.66.0F.W1 E6 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttpd2dq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttpd2dq<T, U>,
	{
		<Self as CodeAsmVcvttpd2dq<T, U>>::vcvttpd2dq(self, op0, op1)
	}

	/// `VCVTTPD2DQX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.66.0F.W1 E6 /r` | `AVX512VL AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttpd2dqx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttpd2dqx<T, U>,
	{
		<Self as CodeAsmVcvttpd2dqx<T, U>>::vcvttpd2dqx(self, op0, op1)
	}

	/// `VCVTTPD2DQY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.66.0F.W1 E6 /r` | `AVX512VL AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttpd2dqy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttpd2dqy<T, U>,
	{
		<Self as CodeAsmVcvttpd2dqy<T, U>>::vcvttpd2dqy(self, op0, op1)
	}

	/// `VCVTTPD2QQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPD2QQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.66.0F.W1 7A /r` | `AVX512VL AVX512DQ`
	/// `VCVTTPD2QQ ymm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.66.0F.W1 7A /r` | `AVX512VL AVX512DQ`
	/// `VCVTTPD2QQ zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}` | `EVEX.512.66.0F.W1 7A /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttpd2qq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttpd2qq<T, U>,
	{
		<Self as CodeAsmVcvttpd2qq<T, U>>::vcvttpd2qq(self, op0, op1)
	}

	/// `VCVTTPD2UDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.0F.W1 78 /r` | `AVX512VL AVX512F`
	/// `VCVTTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.0F.W1 78 /r` | `AVX512VL AVX512F`
	/// `VCVTTPD2UDQ ymm1 {k1}{z}, zmm2/m512/m64bcst{sae}` | `EVEX.512.0F.W1 78 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttpd2udq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttpd2udq<T, U>,
	{
		<Self as CodeAsmVcvttpd2udq<T, U>>::vcvttpd2udq(self, op0, op1)
	}

	/// `VCVTTPD2UDQX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.0F.W1 78 /r` | `AVX512VL AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttpd2udqx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttpd2udqx<T, U>,
	{
		<Self as CodeAsmVcvttpd2udqx<T, U>>::vcvttpd2udqx(self, op0, op1)
	}

	/// `VCVTTPD2UDQY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.0F.W1 78 /r` | `AVX512VL AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttpd2udqy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttpd2udqy<T, U>,
	{
		<Self as CodeAsmVcvttpd2udqy<T, U>>::vcvttpd2udqy(self, op0, op1)
	}

	/// `VCVTTPD2UQQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPD2UQQ xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.66.0F.W1 78 /r` | `AVX512VL AVX512DQ`
	/// `VCVTTPD2UQQ ymm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.66.0F.W1 78 /r` | `AVX512VL AVX512DQ`
	/// `VCVTTPD2UQQ zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}` | `EVEX.512.66.0F.W1 78 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttpd2uqq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttpd2uqq<T, U>,
	{
		<Self as CodeAsmVcvttpd2uqq<T, U>>::vcvttpd2uqq(self, op0, op1)
	}

	/// `VCVTTPH2DQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPH2DQ xmm1 {k1}{z}, xmm2/m64/m16bcst` | `EVEX.128.F3.MAP5.W0 5B /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2DQ ymm1 {k1}{z}, xmm2/m128/m16bcst` | `EVEX.256.F3.MAP5.W0 5B /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2DQ zmm1 {k1}{z}, ymm2/m256/m16bcst{sae}` | `EVEX.512.F3.MAP5.W0 5B /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttph2dq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttph2dq<T, U>,
	{
		<Self as CodeAsmVcvttph2dq<T, U>>::vcvttph2dq(self, op0, op1)
	}

	/// `VCVTTPH2QQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPH2QQ xmm1 {k1}{z}, xmm2/m32/m16bcst` | `EVEX.128.66.MAP5.W0 7A /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2QQ ymm1 {k1}{z}, xmm2/m64/m16bcst` | `EVEX.256.66.MAP5.W0 7A /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2QQ zmm1 {k1}{z}, xmm2/m128/m16bcst{sae}` | `EVEX.512.66.MAP5.W0 7A /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttph2qq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttph2qq<T, U>,
	{
		<Self as CodeAsmVcvttph2qq<T, U>>::vcvttph2qq(self, op0, op1)
	}

	/// `VCVTTPH2UDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPH2UDQ xmm1 {k1}{z}, xmm2/m64/m16bcst` | `EVEX.128.MAP5.W0 78 /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2UDQ ymm1 {k1}{z}, xmm2/m128/m16bcst` | `EVEX.256.MAP5.W0 78 /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2UDQ zmm1 {k1}{z}, ymm2/m256/m16bcst{sae}` | `EVEX.512.MAP5.W0 78 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttph2udq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttph2udq<T, U>,
	{
		<Self as CodeAsmVcvttph2udq<T, U>>::vcvttph2udq(self, op0, op1)
	}

	/// `VCVTTPH2UQQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPH2UQQ xmm1 {k1}{z}, xmm2/m32/m16bcst` | `EVEX.128.66.MAP5.W0 78 /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2UQQ ymm1 {k1}{z}, xmm2/m64/m16bcst` | `EVEX.256.66.MAP5.W0 78 /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2UQQ zmm1 {k1}{z}, xmm2/m128/m16bcst{sae}` | `EVEX.512.66.MAP5.W0 78 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttph2uqq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttph2uqq<T, U>,
	{
		<Self as CodeAsmVcvttph2uqq<T, U>>::vcvttph2uqq(self, op0, op1)
	}

	/// `VCVTTPH2UW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPH2UW xmm1 {k1}{z}, xmm2/m128/m16bcst` | `EVEX.128.MAP5.W0 7C /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2UW ymm1 {k1}{z}, ymm2/m256/m16bcst` | `EVEX.256.MAP5.W0 7C /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2UW zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}` | `EVEX.512.MAP5.W0 7C /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttph2uw<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttph2uw<T, U>,
	{
		<Self as CodeAsmVcvttph2uw<T, U>>::vcvttph2uw(self, op0, op1)
	}

	/// `VCVTTPH2W` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPH2W xmm1 {k1}{z}, xmm2/m128/m16bcst` | `EVEX.128.66.MAP5.W0 7C /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2W ymm1 {k1}{z}, ymm2/m256/m16bcst` | `EVEX.256.66.MAP5.W0 7C /r` | `AVX512VL AVX512-FP16`
	/// `VCVTTPH2W zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}` | `EVEX.512.66.MAP5.W0 7C /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttph2w<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttph2w<T, U>,
	{
		<Self as CodeAsmVcvttph2w<T, U>>::vcvttph2w(self, op0, op1)
	}

	/// `VCVTTPS2DQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPS2DQ xmm1, xmm2/m128` | `VEX.128.F3.0F.WIG 5B /r` | `AVX`
	/// `VCVTTPS2DQ ymm1, ymm2/m256` | `VEX.256.F3.0F.WIG 5B /r` | `AVX`
	/// `VCVTTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.F3.0F.W0 5B /r` | `AVX512VL AVX512F`
	/// `VCVTTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.F3.0F.W0 5B /r` | `AVX512VL AVX512F`
	/// `VCVTTPS2DQ zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}` | `EVEX.512.F3.0F.W0 5B /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttps2dq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttps2dq<T, U>,
	{
		<Self as CodeAsmVcvttps2dq<T, U>>::vcvttps2dq(self, op0, op1)
	}

	/// `VCVTTPS2QQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPS2QQ xmm1 {k1}{z}, xmm2/m64/m32bcst` | `EVEX.128.66.0F.W0 7A /r` | `AVX512VL AVX512DQ`
	/// `VCVTTPS2QQ ymm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.256.66.0F.W0 7A /r` | `AVX512VL AVX512DQ`
	/// `VCVTTPS2QQ zmm1 {k1}{z}, ymm2/m256/m32bcst{sae}` | `EVEX.512.66.0F.W0 7A /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttps2qq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttps2qq<T, U>,
	{
		<Self as CodeAsmVcvttps2qq<T, U>>::vcvttps2qq(self, op0, op1)
	}

	/// `VCVTTPS2UDQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPS2UDQ xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.0F.W0 78 /r` | `AVX512VL AVX512F`
	/// `VCVTTPS2UDQ ymm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.0F.W0 78 /r` | `AVX512VL AVX512F`
	/// `VCVTTPS2UDQ zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}` | `EVEX.512.0F.W0 78 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttps2udq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttps2udq<T, U>,
	{
		<Self as CodeAsmVcvttps2udq<T, U>>::vcvttps2udq(self, op0, op1)
	}

	/// `VCVTTPS2UQQ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTPS2UQQ xmm1 {k1}{z}, xmm2/m64/m32bcst` | `EVEX.128.66.0F.W0 78 /r` | `AVX512VL AVX512DQ`
	/// `VCVTTPS2UQQ ymm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.256.66.0F.W0 78 /r` | `AVX512VL AVX512DQ`
	/// `VCVTTPS2UQQ zmm1 {k1}{z}, ymm2/m256/m32bcst{sae}` | `EVEX.512.66.0F.W0 78 /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttps2uqq<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttps2uqq<T, U>,
	{
		<Self as CodeAsmVcvttps2uqq<T, U>>::vcvttps2uqq(self, op0, op1)
	}

	/// `VCVTTSD2SI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTSD2SI r32, xmm1/m64` | `VEX.LIG.F2.0F.W0 2C /r` | `AVX`
	/// `VCVTTSD2SI r64, xmm1/m64` | `VEX.LIG.F2.0F.W1 2C /r` | `AVX`
	/// `VCVTTSD2SI r32, xmm1/m64{sae}` | `EVEX.LIG.F2.0F.W0 2C /r` | `AVX512F`
	/// `VCVTTSD2SI r64, xmm1/m64{sae}` | `EVEX.LIG.F2.0F.W1 2C /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttsd2si<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttsd2si<T, U>,
	{
		<Self as CodeAsmVcvttsd2si<T, U>>::vcvttsd2si(self, op0, op1)
	}

	/// `VCVTTSD2USI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTSD2USI r32, xmm1/m64{sae}` | `EVEX.LIG.F2.0F.W0 78 /r` | `AVX512F`
	/// `VCVTTSD2USI r64, xmm1/m64{sae}` | `EVEX.LIG.F2.0F.W1 78 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttsd2usi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttsd2usi<T, U>,
	{
		<Self as CodeAsmVcvttsd2usi<T, U>>::vcvttsd2usi(self, op0, op1)
	}

	/// `VCVTTSH2SI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTSH2SI r32, xmm1/m16{sae}` | `EVEX.LIG.F3.MAP5.W0 2C /r` | `AVX512-FP16`
	/// `VCVTTSH2SI r64, xmm1/m16{sae}` | `EVEX.LIG.F3.MAP5.W1 2C /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttsh2si<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttsh2si<T, U>,
	{
		<Self as CodeAsmVcvttsh2si<T, U>>::vcvttsh2si(self, op0, op1)
	}

	/// `VCVTTSH2USI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTSH2USI r32, xmm1/m16{sae}` | `EVEX.LIG.F3.MAP5.W0 78 /r` | `AVX512-FP16`
	/// `VCVTTSH2USI r64, xmm1/m16{sae}` | `EVEX.LIG.F3.MAP5.W1 78 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttsh2usi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttsh2usi<T, U>,
	{
		<Self as CodeAsmVcvttsh2usi<T, U>>::vcvttsh2usi(self, op0, op1)
	}

	/// `VCVTTSS2SI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTSS2SI r32, xmm1/m32` | `VEX.LIG.F3.0F.W0 2C /r` | `AVX`
	/// `VCVTTSS2SI r64, xmm1/m32` | `VEX.LIG.F3.0F.W1 2C /r` | `AVX`
	/// `VCVTTSS2SI r32, xmm1/m32{sae}` | `EVEX.LIG.F3.0F.W0 2C /r` | `AVX512F`
	/// `VCVTTSS2SI r64, xmm1/m32{sae}` | `EVEX.LIG.F3.0F.W1 2C /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttss2si<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttss2si<T, U>,
	{
		<Self as CodeAsmVcvttss2si<T, U>>::vcvttss2si(self, op0, op1)
	}

	/// `VCVTTSS2USI` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTTSS2USI r32, xmm1/m32{sae}` | `EVEX.LIG.F3.0F.W0 78 /r` | `AVX512F`
	/// `VCVTTSS2USI r64, xmm1/m32{sae}` | `EVEX.LIG.F3.0F.W1 78 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvttss2usi<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvttss2usi<T, U>,
	{
		<Self as CodeAsmVcvttss2usi<T, U>>::vcvttss2usi(self, op0, op1)
	}

	/// `VCVTUDQ2PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst` | `EVEX.128.F3.0F.W0 7A /r` | `AVX512VL AVX512F`
	/// `VCVTUDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.256.F3.0F.W0 7A /r` | `AVX512VL AVX512F`
	/// `VCVTUDQ2PD zmm1 {k1}{z}, ymm2/m256/m32bcst{er}` | `EVEX.512.F3.0F.W0 7A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtudq2pd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtudq2pd<T, U>,
	{
		<Self as CodeAsmVcvtudq2pd<T, U>>::vcvtudq2pd(self, op0, op1)
	}

	/// `VCVTUDQ2PH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUDQ2PH xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.F2.MAP5.W0 7A /r` | `AVX512VL AVX512-FP16`
	/// `VCVTUDQ2PH xmm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.F2.MAP5.W0 7A /r` | `AVX512VL AVX512-FP16`
	/// `VCVTUDQ2PH ymm1 {k1}{z}, zmm2/m512/m32bcst{er}` | `EVEX.512.F2.MAP5.W0 7A /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtudq2ph<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtudq2ph<T, U>,
	{
		<Self as CodeAsmVcvtudq2ph<T, U>>::vcvtudq2ph(self, op0, op1)
	}

	/// `VCVTUDQ2PHX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUDQ2PH xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.F2.MAP5.W0 7A /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtudq2phx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtudq2phx<T, U>,
	{
		<Self as CodeAsmVcvtudq2phx<T, U>>::vcvtudq2phx(self, op0, op1)
	}

	/// `VCVTUDQ2PHY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUDQ2PH xmm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.F2.MAP5.W0 7A /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtudq2phy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtudq2phy<T, U>,
	{
		<Self as CodeAsmVcvtudq2phy<T, U>>::vcvtudq2phy(self, op0, op1)
	}

	/// `VCVTUDQ2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst` | `EVEX.128.F2.0F.W0 7A /r` | `AVX512VL AVX512F`
	/// `VCVTUDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst` | `EVEX.256.F2.0F.W0 7A /r` | `AVX512VL AVX512F`
	/// `VCVTUDQ2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{er}` | `EVEX.512.F2.0F.W0 7A /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtudq2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtudq2ps<T, U>,
	{
		<Self as CodeAsmVcvtudq2ps<T, U>>::vcvtudq2ps(self, op0, op1)
	}

	/// `VCVTUQQ2PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUQQ2PD xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.F3.0F.W1 7A /r` | `AVX512VL AVX512DQ`
	/// `VCVTUQQ2PD ymm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.F3.0F.W1 7A /r` | `AVX512VL AVX512DQ`
	/// `VCVTUQQ2PD zmm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.F3.0F.W1 7A /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtuqq2pd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtuqq2pd<T, U>,
	{
		<Self as CodeAsmVcvtuqq2pd<T, U>>::vcvtuqq2pd(self, op0, op1)
	}

	/// `VCVTUQQ2PH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUQQ2PH xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.F2.MAP5.W1 7A /r` | `AVX512VL AVX512-FP16`
	/// `VCVTUQQ2PH xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.F2.MAP5.W1 7A /r` | `AVX512VL AVX512-FP16`
	/// `VCVTUQQ2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.F2.MAP5.W1 7A /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtuqq2ph<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtuqq2ph<T, U>,
	{
		<Self as CodeAsmVcvtuqq2ph<T, U>>::vcvtuqq2ph(self, op0, op1)
	}

	/// `VCVTUQQ2PHX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUQQ2PH xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.F2.MAP5.W1 7A /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtuqq2phx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtuqq2phx<T, U>,
	{
		<Self as CodeAsmVcvtuqq2phx<T, U>>::vcvtuqq2phx(self, op0, op1)
	}

	/// `VCVTUQQ2PHY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUQQ2PH xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.F2.MAP5.W1 7A /r` | `AVX512VL AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtuqq2phy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtuqq2phy<T, U>,
	{
		<Self as CodeAsmVcvtuqq2phy<T, U>>::vcvtuqq2phy(self, op0, op1)
	}

	/// `VCVTUQQ2PHZ` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUQQ2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.F2.MAP5.W1 7A /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtuqq2phz<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtuqq2phz<T, U>,
	{
		<Self as CodeAsmVcvtuqq2phz<T, U>>::vcvtuqq2phz(self, op0, op1)
	}

	/// `VCVTUQQ2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUQQ2PS xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.F2.0F.W1 7A /r` | `AVX512VL AVX512DQ`
	/// `VCVTUQQ2PS xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.F2.0F.W1 7A /r` | `AVX512VL AVX512DQ`
	/// `VCVTUQQ2PS ymm1 {k1}{z}, zmm2/m512/m64bcst{er}` | `EVEX.512.F2.0F.W1 7A /r` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtuqq2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtuqq2ps<T, U>,
	{
		<Self as CodeAsmVcvtuqq2ps<T, U>>::vcvtuqq2ps(self, op0, op1)
	}

	/// `VCVTUQQ2PSX` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUQQ2PS xmm1 {k1}{z}, xmm2/m128/m64bcst` | `EVEX.128.F2.0F.W1 7A /r` | `AVX512VL AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtuqq2psx<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtuqq2psx<T, U>,
	{
		<Self as CodeAsmVcvtuqq2psx<T, U>>::vcvtuqq2psx(self, op0, op1)
	}

	/// `VCVTUQQ2PSY` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUQQ2PS xmm1 {k1}{z}, ymm2/m256/m64bcst` | `EVEX.256.F2.0F.W1 7A /r` | `AVX512VL AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtuqq2psy<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtuqq2psy<T, U>,
	{
		<Self as CodeAsmVcvtuqq2psy<T, U>>::vcvtuqq2psy(self, op0, op1)
	}

	/// `VCVTUSI2SD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUSI2SD xmm1, xmm2, r/m32{er}` | `EVEX.LIG.F2.0F.W0 7B /r` | `AVX512F`
	/// `VCVTUSI2SD xmm1, xmm2, r/m64{er}` | `EVEX.LIG.F2.0F.W1 7B /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtusi2sd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtusi2sd<T, U, V>,
	{
		<Self as CodeAsmVcvtusi2sd<T, U, V>>::vcvtusi2sd(self, op0, op1, op2)
	}

	/// `VCVTUSI2SH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUSI2SH xmm1, xmm2, r/m32{er}` | `EVEX.LIG.F3.MAP5.W0 7B /r` | `AVX512-FP16`
	/// `VCVTUSI2SH xmm1, xmm2, r/m64{er}` | `EVEX.LIG.F3.MAP5.W1 7B /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtusi2sh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtusi2sh<T, U, V>,
	{
		<Self as CodeAsmVcvtusi2sh<T, U, V>>::vcvtusi2sh(self, op0, op1, op2)
	}

	/// `VCVTUSI2SS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUSI2SS xmm1, xmm2, r/m32{er}` | `EVEX.LIG.F3.0F.W0 7B /r` | `AVX512F`
	/// `VCVTUSI2SS xmm1, xmm2, r/m64{er}` | `EVEX.LIG.F3.0F.W1 7B /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vcvtusi2ss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtusi2ss<T, U, V>,
	{
		<Self as CodeAsmVcvtusi2ss<T, U, V>>::vcvtusi2ss(self, op0, op1, op2)
	}

	/// `VCVTUW2PH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTUW2PH xmm1 {k1}{z}, xmm2/m128/m16bcst` | `EVEX.128.F2.MAP5.W0 7D /r` | `AVX512VL AVX512-FP16`
	/// `VCVTUW2PH ymm1 {k1}{z}, ymm2/m256/m16bcst` | `EVEX.256.F2.MAP5.W0 7D /r` | `AVX512VL AVX512-FP16`
	/// `VCVTUW2PH zmm1 {k1}{z}, zmm2/m512/m16bcst{er}` | `EVEX.512.F2.MAP5.W0 7D /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtuw2ph<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtuw2ph<T, U>,
	{
		<Self as CodeAsmVcvtuw2ph<T, U>>::vcvtuw2ph(self, op0, op1)
	}

	/// `VCVTW2PH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VCVTW2PH xmm1 {k1}{z}, xmm2/m128/m16bcst` | `EVEX.128.F3.MAP5.W0 7D /r` | `AVX512VL AVX512-FP16`
	/// `VCVTW2PH ymm1 {k1}{z}, ymm2/m256/m16bcst` | `EVEX.256.F3.MAP5.W0 7D /r` | `AVX512VL AVX512-FP16`
	/// `VCVTW2PH zmm1 {k1}{z}, zmm2/m512/m16bcst{er}` | `EVEX.512.F3.MAP5.W0 7D /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vcvtw2ph<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVcvtw2ph<T, U>,
	{
		<Self as CodeAsmVcvtw2ph<T, U>>::vcvtw2ph(self, op0, op1)
	}

	/// `VDBPSADBW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VDBPSADBW xmm1 {k1}{z}, xmm2, xmm3/m128, imm8` | `EVEX.128.66.0F3A.W0 42 /r ib` | `AVX512VL AVX512BW`
	/// `VDBPSADBW ymm1 {k1}{z}, ymm2, ymm3/m256, imm8` | `EVEX.256.66.0F3A.W0 42 /r ib` | `AVX512VL AVX512BW`
	/// `VDBPSADBW zmm1 {k1}{z}, zmm2, zmm3/m512, imm8` | `EVEX.512.66.0F3A.W0 42 /r ib` | `AVX512BW`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vdbpsadbw<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVdbpsadbw<T, U, V, W>,
	{
		<Self as CodeAsmVdbpsadbw<T, U, V, W>>::vdbpsadbw(self, op0, op1, op2, op3)
	}

	/// `VDIVPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VDIVPD xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F.WIG 5E /r` | `AVX`
	/// `VDIVPD ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F.WIG 5E /r` | `AVX`
	/// `VDIVPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst` | `EVEX.128.66.0F.W1 5E /r` | `AVX512VL AVX512F`
	/// `VDIVPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst` | `EVEX.256.66.0F.W1 5E /r` | `AVX512VL AVX512F`
	/// `VDIVPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}` | `EVEX.512.66.0F.W1 5E /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vdivpd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVdivpd<T, U, V>,
	{
		<Self as CodeAsmVdivpd<T, U, V>>::vdivpd(self, op0, op1, op2)
	}

	/// `VDIVPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VDIVPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst` | `EVEX.128.MAP5.W0 5E /r` | `AVX512VL AVX512-FP16`
	/// `VDIVPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst` | `EVEX.256.MAP5.W0 5E /r` | `AVX512VL AVX512-FP16`
	/// `VDIVPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}` | `EVEX.512.MAP5.W0 5E /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vdivph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVdivph<T, U, V>,
	{
		<Self as CodeAsmVdivph<T, U, V>>::vdivph(self, op0, op1, op2)
	}

	/// `VDIVPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VDIVPS xmm1, xmm2, xmm3/m128` | `VEX.128.0F.WIG 5E /r` | `AVX`
	/// `VDIVPS ymm1, ymm2, ymm3/m256` | `VEX.256.0F.WIG 5E /r` | `AVX`
	/// `VDIVPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.0F.W0 5E /r` | `AVX512VL AVX512F`
	/// `VDIVPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.0F.W0 5E /r` | `AVX512VL AVX512F`
	/// `VDIVPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}` | `EVEX.512.0F.W0 5E /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vdivps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVdivps<T, U, V>,
	{
		<Self as CodeAsmVdivps<T, U, V>>::vdivps(self, op0, op1, op2)
	}

	/// `VDIVSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VDIVSD xmm1, xmm2, xmm3/m64` | `VEX.LIG.F2.0F.WIG 5E /r` | `AVX`
	/// `VDIVSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}` | `EVEX.LIG.F2.0F.W1 5E /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vdivsd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVdivsd<T, U, V>,
	{
		<Self as CodeAsmVdivsd<T, U, V>>::vdivsd(self, op0, op1, op2)
	}

	/// `VDIVSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VDIVSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}` | `EVEX.LIG.F3.MAP5.W0 5E /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vdivsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVdivsh<T, U, V>,
	{
		<Self as CodeAsmVdivsh<T, U, V>>::vdivsh(self, op0, op1, op2)
	}

	/// `VDIVSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VDIVSS xmm1, xmm2, xmm3/m32` | `VEX.LIG.F3.0F.WIG 5E /r` | `AVX`
	/// `VDIVSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}` | `EVEX.LIG.F3.0F.W0 5E /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vdivss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVdivss<T, U, V>,
	{
		<Self as CodeAsmVdivss<T, U, V>>::vdivss(self, op0, op1, op2)
	}

	/// `VDPBF16PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VDPBF16PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.F3.0F38.W0 52 /r` | `AVX512VL AVX512_BF16`
	/// `VDPBF16PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.F3.0F38.W0 52 /r` | `AVX512VL AVX512_BF16`
	/// `VDPBF16PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst` | `EVEX.512.F3.0F38.W0 52 /r` | `AVX512F AVX512_BF16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vdpbf16ps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVdpbf16ps<T, U, V>,
	{
		<Self as CodeAsmVdpbf16ps<T, U, V>>::vdpbf16ps(self, op0, op1, op2)
	}

	/// `VDPPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VDPPD xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F3A.WIG 41 /r ib` | `AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vdppd<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVdppd<T, U, V, W>,
	{
		<Self as CodeAsmVdppd<T, U, V, W>>::vdppd(self, op0, op1, op2, op3)
	}

	/// `VDPPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VDPPS xmm1, xmm2, xmm3/m128, imm8` | `VEX.128.66.0F3A.WIG 40 /r ib` | `AVX`
	/// `VDPPS ymm1, ymm2, ymm3/m256, imm8` | `VEX.256.66.0F3A.WIG 40 /r ib` | `AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vdpps<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVdpps<T, U, V, W>,
	{
		<Self as CodeAsmVdpps<T, U, V, W>>::vdpps(self, op0, op1, op2, op3)
	}

	/// `VERR` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VERR r/m16` | `o16 0F 00 /4` | `286+`
	/// `VERR r32/m16` | `o32 0F 00 /4` | `386+`
	/// `VERR r64/m16` | `o64 0F 00 /4` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn verr<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmVerr<T>,
	{
		<Self as CodeAsmVerr<T>>::verr(self, op0)
	}

	/// `VERW` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VERW r/m16` | `o16 0F 00 /5` | `286+`
	/// `VERW r32/m16` | `o32 0F 00 /5` | `386+`
	/// `VERW r64/m16` | `o64 0F 00 /5` | `X64`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	#[inline]
	pub fn verw<T>(&mut self, op0: T) -> Result<(), IcedError>
	where
		Self: CodeAsmVerw<T>,
	{
		<Self as CodeAsmVerw<T>>::verw(self, op0)
	}

	/// `VEXP2PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXP2PD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}` | `EVEX.512.66.0F38.W1 C8 /r` | `AVX512ER`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vexp2pd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVexp2pd<T, U>,
	{
		<Self as CodeAsmVexp2pd<T, U>>::vexp2pd(self, op0, op1)
	}

	/// `VEXP2PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXP2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}` | `EVEX.512.66.0F38.W0 C8 /r` | `AVX512ER`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vexp2ps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVexp2ps<T, U>,
	{
		<Self as CodeAsmVexp2ps<T, U>>::vexp2ps(self, op0, op1)
	}

	/// `VEXPANDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXPANDPD xmm1 {k1}{z}, xmm2/m128` | `EVEX.128.66.0F38.W1 88 /r` | `AVX512VL AVX512F`
	/// `VEXPANDPD ymm1 {k1}{z}, ymm2/m256` | `EVEX.256.66.0F38.W1 88 /r` | `AVX512VL AVX512F`
	/// `VEXPANDPD zmm1 {k1}{z}, zmm2/m512` | `EVEX.512.66.0F38.W1 88 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vexpandpd<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVexpandpd<T, U>,
	{
		<Self as CodeAsmVexpandpd<T, U>>::vexpandpd(self, op0, op1)
	}

	/// `VEXPANDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXPANDPS xmm1 {k1}{z}, xmm2/m128` | `EVEX.128.66.0F38.W0 88 /r` | `AVX512VL AVX512F`
	/// `VEXPANDPS ymm1 {k1}{z}, ymm2/m256` | `EVEX.256.66.0F38.W0 88 /r` | `AVX512VL AVX512F`
	/// `VEXPANDPS zmm1 {k1}{z}, zmm2/m512` | `EVEX.512.66.0F38.W0 88 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	#[inline]
	pub fn vexpandps<T, U>(&mut self, op0: T, op1: U) -> Result<(), IcedError>
	where
		Self: CodeAsmVexpandps<T, U>,
	{
		<Self as CodeAsmVexpandps<T, U>>::vexpandps(self, op0, op1)
	}

	/// `VEXTRACTF128` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXTRACTF128 xmm1/m128, ymm2, imm8` | `VEX.256.66.0F3A.W0 19 /r ib` | `AVX`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vextractf128<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVextractf128<T, U, V>,
	{
		<Self as CodeAsmVextractf128<T, U, V>>::vextractf128(self, op0, op1, op2)
	}

	/// `VEXTRACTF32X4` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXTRACTF32X4 xmm1/m128 {k1}{z}, ymm2, imm8` | `EVEX.256.66.0F3A.W0 19 /r ib` | `AVX512VL AVX512F`
	/// `VEXTRACTF32X4 xmm1/m128 {k1}{z}, zmm2, imm8` | `EVEX.512.66.0F3A.W0 19 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vextractf32x4<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVextractf32x4<T, U, V>,
	{
		<Self as CodeAsmVextractf32x4<T, U, V>>::vextractf32x4(self, op0, op1, op2)
	}

	/// `VEXTRACTF32X8` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXTRACTF32X8 ymm1/m256 {k1}{z}, zmm2, imm8` | `EVEX.512.66.0F3A.W0 1B /r ib` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vextractf32x8<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVextractf32x8<T, U, V>,
	{
		<Self as CodeAsmVextractf32x8<T, U, V>>::vextractf32x8(self, op0, op1, op2)
	}

	/// `VEXTRACTF64X2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXTRACTF64X2 xmm1/m128 {k1}{z}, ymm2, imm8` | `EVEX.256.66.0F3A.W1 19 /r ib` | `AVX512VL AVX512DQ`
	/// `VEXTRACTF64X2 xmm1/m128 {k1}{z}, zmm2, imm8` | `EVEX.512.66.0F3A.W1 19 /r ib` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vextractf64x2<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVextractf64x2<T, U, V>,
	{
		<Self as CodeAsmVextractf64x2<T, U, V>>::vextractf64x2(self, op0, op1, op2)
	}

	/// `VEXTRACTF64X4` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXTRACTF64X4 ymm1/m256 {k1}{z}, zmm2, imm8` | `EVEX.512.66.0F3A.W1 1B /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vextractf64x4<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVextractf64x4<T, U, V>,
	{
		<Self as CodeAsmVextractf64x4<T, U, V>>::vextractf64x4(self, op0, op1, op2)
	}

	/// `VEXTRACTI128` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXTRACTI128 xmm1/m128, ymm2, imm8` | `VEX.256.66.0F3A.W0 39 /r ib` | `AVX2`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vextracti128<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVextracti128<T, U, V>,
	{
		<Self as CodeAsmVextracti128<T, U, V>>::vextracti128(self, op0, op1, op2)
	}

	/// `VEXTRACTI32X4` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXTRACTI32X4 xmm1/m128 {k1}{z}, ymm2, imm8` | `EVEX.256.66.0F3A.W0 39 /r ib` | `AVX512VL AVX512F`
	/// `VEXTRACTI32X4 xmm1/m128 {k1}{z}, zmm2, imm8` | `EVEX.512.66.0F3A.W0 39 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vextracti32x4<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVextracti32x4<T, U, V>,
	{
		<Self as CodeAsmVextracti32x4<T, U, V>>::vextracti32x4(self, op0, op1, op2)
	}

	/// `VEXTRACTI32X8` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXTRACTI32X8 ymm1/m256 {k1}{z}, zmm2, imm8` | `EVEX.512.66.0F3A.W0 3B /r ib` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vextracti32x8<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVextracti32x8<T, U, V>,
	{
		<Self as CodeAsmVextracti32x8<T, U, V>>::vextracti32x8(self, op0, op1, op2)
	}

	/// `VEXTRACTI64X2` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXTRACTI64X2 xmm1/m128 {k1}{z}, ymm2, imm8` | `EVEX.256.66.0F3A.W1 39 /r ib` | `AVX512VL AVX512DQ`
	/// `VEXTRACTI64X2 xmm1/m128 {k1}{z}, zmm2, imm8` | `EVEX.512.66.0F3A.W1 39 /r ib` | `AVX512DQ`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vextracti64x2<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVextracti64x2<T, U, V>,
	{
		<Self as CodeAsmVextracti64x2<T, U, V>>::vextracti64x2(self, op0, op1, op2)
	}

	/// `VEXTRACTI64X4` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXTRACTI64X4 ymm1/m256 {k1}{z}, zmm2, imm8` | `EVEX.512.66.0F3A.W1 3B /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vextracti64x4<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVextracti64x4<T, U, V>,
	{
		<Self as CodeAsmVextracti64x4<T, U, V>>::vextracti64x4(self, op0, op1, op2)
	}

	/// `VEXTRACTPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VEXTRACTPS r/m32, xmm1, imm8` | `VEX.128.66.0F3A.W0 17 /r ib` | `AVX`
	/// `VEXTRACTPS r64/m32, xmm1, imm8` | `VEX.128.66.0F3A.W1 17 /r ib` | `AVX`
	/// `VEXTRACTPS r/m32, xmm1, imm8` | `EVEX.128.66.0F3A.W0 17 /r ib` | `AVX512F`
	/// `VEXTRACTPS r64/m32, xmm1, imm8` | `EVEX.128.66.0F3A.W1 17 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vextractps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVextractps<T, U, V>,
	{
		<Self as CodeAsmVextractps<T, U, V>>::vextractps(self, op0, op1, op2)
	}

	/// `VFCMADDCPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFCMADDCPH xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.F2.MAP6.W0 56 /r` | `AVX512VL AVX512-FP16`
	/// `VFCMADDCPH ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.F2.MAP6.W0 56 /r` | `AVX512VL AVX512-FP16`
	/// `VFCMADDCPH zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}` | `EVEX.512.F2.MAP6.W0 56 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfcmaddcph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfcmaddcph<T, U, V>,
	{
		<Self as CodeAsmVfcmaddcph<T, U, V>>::vfcmaddcph(self, op0, op1, op2)
	}

	/// `VFCMADDCSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFCMADDCSH xmm1 {k1}{z}, xmm2, xmm3/m32{er}` | `EVEX.LIG.F2.MAP6.W0 57 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfcmaddcsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfcmaddcsh<T, U, V>,
	{
		<Self as CodeAsmVfcmaddcsh<T, U, V>>::vfcmaddcsh(self, op0, op1, op2)
	}

	/// `VFCMULCPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFCMULCPH xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.F2.MAP6.W0 D6 /r` | `AVX512VL AVX512-FP16`
	/// `VFCMULCPH ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.F2.MAP6.W0 D6 /r` | `AVX512VL AVX512-FP16`
	/// `VFCMULCPH zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}` | `EVEX.512.F2.MAP6.W0 D6 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfcmulcph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfcmulcph<T, U, V>,
	{
		<Self as CodeAsmVfcmulcph<T, U, V>>::vfcmulcph(self, op0, op1, op2)
	}

	/// `VFCMULCSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFCMULCSH xmm1 {k1}{z}, xmm2, xmm3/m32{er}` | `EVEX.LIG.F2.MAP6.W0 D7 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfcmulcsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfcmulcsh<T, U, V>,
	{
		<Self as CodeAsmVfcmulcsh<T, U, V>>::vfcmulcsh(self, op0, op1, op2)
	}

	/// `VFIXUPIMMPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFIXUPIMMPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8` | `EVEX.128.66.0F3A.W1 54 /r ib` | `AVX512VL AVX512F`
	/// `VFIXUPIMMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8` | `EVEX.256.66.0F3A.W1 54 /r ib` | `AVX512VL AVX512F`
	/// `VFIXUPIMMPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{sae}, imm8` | `EVEX.512.66.0F3A.W1 54 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vfixupimmpd<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVfixupimmpd<T, U, V, W>,
	{
		<Self as CodeAsmVfixupimmpd<T, U, V, W>>::vfixupimmpd(self, op0, op1, op2, op3)
	}

	/// `VFIXUPIMMPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFIXUPIMMPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8` | `EVEX.128.66.0F3A.W0 54 /r ib` | `AVX512VL AVX512F`
	/// `VFIXUPIMMPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8` | `EVEX.256.66.0F3A.W0 54 /r ib` | `AVX512VL AVX512F`
	/// `VFIXUPIMMPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{sae}, imm8` | `EVEX.512.66.0F3A.W0 54 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vfixupimmps<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVfixupimmps<T, U, V, W>,
	{
		<Self as CodeAsmVfixupimmps<T, U, V, W>>::vfixupimmps(self, op0, op1, op2, op3)
	}

	/// `VFIXUPIMMSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFIXUPIMMSD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}, imm8` | `EVEX.LIG.66.0F3A.W1 55 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vfixupimmsd<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVfixupimmsd<T, U, V, W>,
	{
		<Self as CodeAsmVfixupimmsd<T, U, V, W>>::vfixupimmsd(self, op0, op1, op2, op3)
	}

	/// `VFIXUPIMMSS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFIXUPIMMSS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}, imm8` | `EVEX.LIG.66.0F3A.W0 55 /r ib` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vfixupimmss<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVfixupimmss<T, U, V, W>,
	{
		<Self as CodeAsmVfixupimmss<T, U, V, W>>::vfixupimmss(self, op0, op1, op2, op3)
	}

	/// `VFMADD132PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD132PD xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F38.W1 98 /r` | `FMA`
	/// `VFMADD132PD ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F38.W1 98 /r` | `FMA`
	/// `VFMADD132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst` | `EVEX.128.66.0F38.W1 98 /r` | `AVX512VL AVX512F`
	/// `VFMADD132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst` | `EVEX.256.66.0F38.W1 98 /r` | `AVX512VL AVX512F`
	/// `VFMADD132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}` | `EVEX.512.66.0F38.W1 98 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd132pd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd132pd<T, U, V>,
	{
		<Self as CodeAsmVfmadd132pd<T, U, V>>::vfmadd132pd(self, op0, op1, op2)
	}

	/// `VFMADD132PH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst` | `EVEX.128.66.MAP6.W0 98 /r` | `AVX512VL AVX512-FP16`
	/// `VFMADD132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst` | `EVEX.256.66.MAP6.W0 98 /r` | `AVX512VL AVX512-FP16`
	/// `VFMADD132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}` | `EVEX.512.66.MAP6.W0 98 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd132ph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd132ph<T, U, V>,
	{
		<Self as CodeAsmVfmadd132ph<T, U, V>>::vfmadd132ph(self, op0, op1, op2)
	}

	/// `VFMADD132PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD132PS xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F38.W0 98 /r` | `FMA`
	/// `VFMADD132PS ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F38.W0 98 /r` | `FMA`
	/// `VFMADD132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.66.0F38.W0 98 /r` | `AVX512VL AVX512F`
	/// `VFMADD132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.66.0F38.W0 98 /r` | `AVX512VL AVX512F`
	/// `VFMADD132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}` | `EVEX.512.66.0F38.W0 98 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd132ps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd132ps<T, U, V>,
	{
		<Self as CodeAsmVfmadd132ps<T, U, V>>::vfmadd132ps(self, op0, op1, op2)
	}

	/// `VFMADD132SD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD132SD xmm1, xmm2, xmm3/m64` | `VEX.LIG.66.0F38.W1 99 /r` | `FMA`
	/// `VFMADD132SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}` | `EVEX.LIG.66.0F38.W1 99 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd132sd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd132sd<T, U, V>,
	{
		<Self as CodeAsmVfmadd132sd<T, U, V>>::vfmadd132sd(self, op0, op1, op2)
	}

	/// `VFMADD132SH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD132SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}` | `EVEX.LIG.66.MAP6.W0 99 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd132sh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd132sh<T, U, V>,
	{
		<Self as CodeAsmVfmadd132sh<T, U, V>>::vfmadd132sh(self, op0, op1, op2)
	}

	/// `VFMADD132SS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD132SS xmm1, xmm2, xmm3/m32` | `VEX.LIG.66.0F38.W0 99 /r` | `FMA`
	/// `VFMADD132SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}` | `EVEX.LIG.66.0F38.W0 99 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd132ss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd132ss<T, U, V>,
	{
		<Self as CodeAsmVfmadd132ss<T, U, V>>::vfmadd132ss(self, op0, op1, op2)
	}

	/// `VFMADD213PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD213PD xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F38.W1 A8 /r` | `FMA`
	/// `VFMADD213PD ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F38.W1 A8 /r` | `FMA`
	/// `VFMADD213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst` | `EVEX.128.66.0F38.W1 A8 /r` | `AVX512VL AVX512F`
	/// `VFMADD213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst` | `EVEX.256.66.0F38.W1 A8 /r` | `AVX512VL AVX512F`
	/// `VFMADD213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}` | `EVEX.512.66.0F38.W1 A8 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd213pd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd213pd<T, U, V>,
	{
		<Self as CodeAsmVfmadd213pd<T, U, V>>::vfmadd213pd(self, op0, op1, op2)
	}

	/// `VFMADD213PH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst` | `EVEX.128.66.MAP6.W0 A8 /r` | `AVX512VL AVX512-FP16`
	/// `VFMADD213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst` | `EVEX.256.66.MAP6.W0 A8 /r` | `AVX512VL AVX512-FP16`
	/// `VFMADD213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}` | `EVEX.512.66.MAP6.W0 A8 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd213ph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd213ph<T, U, V>,
	{
		<Self as CodeAsmVfmadd213ph<T, U, V>>::vfmadd213ph(self, op0, op1, op2)
	}

	/// `VFMADD213PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD213PS xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F38.W0 A8 /r` | `FMA`
	/// `VFMADD213PS ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F38.W0 A8 /r` | `FMA`
	/// `VFMADD213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.66.0F38.W0 A8 /r` | `AVX512VL AVX512F`
	/// `VFMADD213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.66.0F38.W0 A8 /r` | `AVX512VL AVX512F`
	/// `VFMADD213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}` | `EVEX.512.66.0F38.W0 A8 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd213ps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd213ps<T, U, V>,
	{
		<Self as CodeAsmVfmadd213ps<T, U, V>>::vfmadd213ps(self, op0, op1, op2)
	}

	/// `VFMADD213SD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD213SD xmm1, xmm2, xmm3/m64` | `VEX.LIG.66.0F38.W1 A9 /r` | `FMA`
	/// `VFMADD213SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}` | `EVEX.LIG.66.0F38.W1 A9 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd213sd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd213sd<T, U, V>,
	{
		<Self as CodeAsmVfmadd213sd<T, U, V>>::vfmadd213sd(self, op0, op1, op2)
	}

	/// `VFMADD213SH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD213SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}` | `EVEX.LIG.66.MAP6.W0 A9 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd213sh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd213sh<T, U, V>,
	{
		<Self as CodeAsmVfmadd213sh<T, U, V>>::vfmadd213sh(self, op0, op1, op2)
	}

	/// `VFMADD213SS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD213SS xmm1, xmm2, xmm3/m32` | `VEX.LIG.66.0F38.W0 A9 /r` | `FMA`
	/// `VFMADD213SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}` | `EVEX.LIG.66.0F38.W0 A9 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd213ss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd213ss<T, U, V>,
	{
		<Self as CodeAsmVfmadd213ss<T, U, V>>::vfmadd213ss(self, op0, op1, op2)
	}

	/// `VFMADD231PD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD231PD xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F38.W1 B8 /r` | `FMA`
	/// `VFMADD231PD ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F38.W1 B8 /r` | `FMA`
	/// `VFMADD231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst` | `EVEX.128.66.0F38.W1 B8 /r` | `AVX512VL AVX512F`
	/// `VFMADD231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst` | `EVEX.256.66.0F38.W1 B8 /r` | `AVX512VL AVX512F`
	/// `VFMADD231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}` | `EVEX.512.66.0F38.W1 B8 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd231pd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd231pd<T, U, V>,
	{
		<Self as CodeAsmVfmadd231pd<T, U, V>>::vfmadd231pd(self, op0, op1, op2)
	}

	/// `VFMADD231PH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst` | `EVEX.128.66.MAP6.W0 B8 /r` | `AVX512VL AVX512-FP16`
	/// `VFMADD231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst` | `EVEX.256.66.MAP6.W0 B8 /r` | `AVX512VL AVX512-FP16`
	/// `VFMADD231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}` | `EVEX.512.66.MAP6.W0 B8 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd231ph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd231ph<T, U, V>,
	{
		<Self as CodeAsmVfmadd231ph<T, U, V>>::vfmadd231ph(self, op0, op1, op2)
	}

	/// `VFMADD231PS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD231PS xmm1, xmm2, xmm3/m128` | `VEX.128.66.0F38.W0 B8 /r` | `FMA`
	/// `VFMADD231PS ymm1, ymm2, ymm3/m256` | `VEX.256.66.0F38.W0 B8 /r` | `FMA`
	/// `VFMADD231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.66.0F38.W0 B8 /r` | `AVX512VL AVX512F`
	/// `VFMADD231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.66.0F38.W0 B8 /r` | `AVX512VL AVX512F`
	/// `VFMADD231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}` | `EVEX.512.66.0F38.W0 B8 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd231ps<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd231ps<T, U, V>,
	{
		<Self as CodeAsmVfmadd231ps<T, U, V>>::vfmadd231ps(self, op0, op1, op2)
	}

	/// `VFMADD231SD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD231SD xmm1, xmm2, xmm3/m64` | `VEX.LIG.66.0F38.W1 B9 /r` | `FMA`
	/// `VFMADD231SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}` | `EVEX.LIG.66.0F38.W1 B9 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd231sd<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd231sd<T, U, V>,
	{
		<Self as CodeAsmVfmadd231sd<T, U, V>>::vfmadd231sd(self, op0, op1, op2)
	}

	/// `VFMADD231SH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD231SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}` | `EVEX.LIG.66.MAP6.W0 B9 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd231sh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd231sh<T, U, V>,
	{
		<Self as CodeAsmVfmadd231sh<T, U, V>>::vfmadd231sh(self, op0, op1, op2)
	}

	/// `VFMADD231SS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADD231SS xmm1, xmm2, xmm3/m32` | `VEX.LIG.66.0F38.W0 B9 /r` | `FMA`
	/// `VFMADD231SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}` | `EVEX.LIG.66.0F38.W0 B9 /r` | `AVX512F`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmadd231ss<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmadd231ss<T, U, V>,
	{
		<Self as CodeAsmVfmadd231ss<T, U, V>>::vfmadd231ss(self, op0, op1, op2)
	}

	/// `VFMADDCPH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADDCPH xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst` | `EVEX.128.F3.MAP6.W0 56 /r` | `AVX512VL AVX512-FP16`
	/// `VFMADDCPH ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst` | `EVEX.256.F3.MAP6.W0 56 /r` | `AVX512VL AVX512-FP16`
	/// `VFMADDCPH zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}` | `EVEX.512.F3.MAP6.W0 56 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmaddcph<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmaddcph<T, U, V>,
	{
		<Self as CodeAsmVfmaddcph<T, U, V>>::vfmaddcph(self, op0, op1, op2)
	}

	/// `VFMADDCSH` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADDCSH xmm1 {k1}{z}, xmm2, xmm3/m32{er}` | `EVEX.LIG.F3.MAP6.W0 57 /r` | `AVX512-FP16`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	#[inline]
	pub fn vfmaddcsh<T, U, V>(&mut self, op0: T, op1: U, op2: V) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmaddcsh<T, U, V>,
	{
		<Self as CodeAsmVfmaddcsh<T, U, V>>::vfmaddcsh(self, op0, op1, op2)
	}

	/// `VFMADDPD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADDPD xmm1, xmm2, xmm3/m128, xmm4` | `VEX.128.66.0F3A.W0 69 /r /is4` | `FMA4`
	/// `VFMADDPD ymm1, ymm2, ymm3/m256, ymm4` | `VEX.256.66.0F3A.W0 69 /r /is4` | `FMA4`
	/// `VFMADDPD xmm1, xmm2, xmm3, xmm4/m128` | `VEX.128.66.0F3A.W1 69 /r /is4` | `FMA4`
	/// `VFMADDPD ymm1, ymm2, ymm3, ymm4/m256` | `VEX.256.66.0F3A.W1 69 /r /is4` | `FMA4`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vfmaddpd<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmaddpd<T, U, V, W>,
	{
		<Self as CodeAsmVfmaddpd<T, U, V, W>>::vfmaddpd(self, op0, op1, op2, op3)
	}

	/// `VFMADDPS` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADDPS xmm1, xmm2, xmm3/m128, xmm4` | `VEX.128.66.0F3A.W0 68 /r /is4` | `FMA4`
	/// `VFMADDPS ymm1, ymm2, ymm3/m256, ymm4` | `VEX.256.66.0F3A.W0 68 /r /is4` | `FMA4`
	/// `VFMADDPS xmm1, xmm2, xmm3, xmm4/m128` | `VEX.128.66.0F3A.W1 68 /r /is4` | `FMA4`
	/// `VFMADDPS ymm1, ymm2, ymm3, ymm4/m256` | `VEX.256.66.0F3A.W1 68 /r /is4` | `FMA4`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vfmaddps<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmaddps<T, U, V, W>,
	{
		<Self as CodeAsmVfmaddps<T, U, V, W>>::vfmaddps(self, op0, op1, op2, op3)
	}

	/// `VFMADDSD` instruction
	///
	/// Instruction | Opcode | CPUID
	/// ------------|--------|------
	/// `VFMADDSD xmm1, xmm2, xmm3/m64, xmm4` | `VEX.LIG.66.0F3A.W0 6B /r /is4` | `FMA4`
	/// `VFMADDSD xmm1, xmm2, xmm3, xmm4/m64` | `VEX.LIG.66.0F3A.W1 6B /r /is4` | `FMA4`
	///
	/// # Errors
	///
	/// Fails if an operand is invalid (basic checks only)
	///
	/// # Arguments
	///
	/// * `op0`: First operand (eg. an integer (a `u32`/`i64`/`u64` number suffix is sometimes needed), a register (`rdx`), memory (`dword_ptr(rcx+r13*4)`) or a label)
	/// * `op1`: Second operand
	/// * `op2`: Third operand
	/// * `op3`: Fourth operand
	#[inline]
	pub fn vfmaddsd<T, U, V, W>(&mut self, op0: T, op1: U, op2: V, op3: W) -> Result<(), IcedError>
	where
		Self: CodeAsmVfmaddsd<T, U, V, W>,
	{
		<Self as CodeAsmVfmaddsd<T, U, V, W>>::vfmaddsd(self, op0, op1, op2, op3)
	}

	/// `VFMADDSS` instruction
	///
	/