// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: private/pbservice/healthcheck.proto

package pbservice

import (
	pbcommon "github.com/hashicorp/consul/proto/private/pbcommon"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// HealthCheck represents a single check on a given node
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HealthCheck
// output=healthcheck.gen.go
// name=Structs
type HealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Node string `protobuf:"bytes,1,opt,name=Node,proto3" json:"Node,omitempty"`
	// mog: func-to=CheckIDType func-from=string
	CheckID     string                 `protobuf:"bytes,2,opt,name=CheckID,proto3" json:"CheckID,omitempty"`
	Name        string                 `protobuf:"bytes,3,opt,name=Name,proto3" json:"Name,omitempty"`
	Status      string                 `protobuf:"bytes,4,opt,name=Status,proto3" json:"Status,omitempty"`           // The current check status
	Notes       string                 `protobuf:"bytes,5,opt,name=Notes,proto3" json:"Notes,omitempty"`             // Additional notes with the status
	Output      string                 `protobuf:"bytes,6,opt,name=Output,proto3" json:"Output,omitempty"`           // Holds output of script runs
	ServiceID   string                 `protobuf:"bytes,7,opt,name=ServiceID,proto3" json:"ServiceID,omitempty"`     // optional associated service
	ServiceName string                 `protobuf:"bytes,8,opt,name=ServiceName,proto3" json:"ServiceName,omitempty"` // optional service name
	ServiceTags []string               `protobuf:"bytes,9,rep,name=ServiceTags,proto3" json:"ServiceTags,omitempty"` // optional service tags
	Type        string                 `protobuf:"bytes,12,opt,name=Type,proto3" json:"Type,omitempty"`              // Check type: http/ttl/tcp/etc
	Definition  *HealthCheckDefinition `protobuf:"bytes,10,opt,name=Definition,proto3" json:"Definition,omitempty"`
	// mog: func-to=RaftIndexToStructs func-from=NewRaftIndexFromStructs
	RaftIndex *pbcommon.RaftIndex `protobuf:"bytes,11,opt,name=RaftIndex,proto3" json:"RaftIndex,omitempty"`
	// mog: func-to=EnterpriseMetaToStructs func-from=NewEnterpriseMetaFromStructs
	EnterpriseMeta *pbcommon.EnterpriseMeta `protobuf:"bytes,13,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	// mog: func-to=int func-from=int32
	ExposedPort int32  `protobuf:"varint,14,opt,name=ExposedPort,proto3" json:"ExposedPort,omitempty"`
	Interval    string `protobuf:"bytes,15,opt,name=Interval,proto3" json:"Interval,omitempty"`
	Timeout     string `protobuf:"bytes,16,opt,name=Timeout,proto3" json:"Timeout,omitempty"`
	PeerName    string `protobuf:"bytes,17,opt,name=PeerName,proto3" json:"PeerName,omitempty"`
}

func (x *HealthCheck) Reset() {
	*x = HealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbservice_healthcheck_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheck) ProtoMessage() {}

func (x *HealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheck.ProtoReflect.Descriptor instead.
func (*HealthCheck) Descriptor() ([]byte, []int) {
	return file_private_pbservice_healthcheck_proto_rawDescGZIP(), []int{0}
}

func (x *HealthCheck) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *HealthCheck) GetCheckID() string {
	if x != nil {
		return x.CheckID
	}
	return ""
}

func (x *HealthCheck) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HealthCheck) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *HealthCheck) GetNotes() string {
	if x != nil {
		return x.Notes
	}
	return ""
}

func (x *HealthCheck) GetOutput() string {
	if x != nil {
		return x.Output
	}
	return ""
}

func (x *HealthCheck) GetServiceID() string {
	if x != nil {
		return x.ServiceID
	}
	return ""
}

func (x *HealthCheck) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *HealthCheck) GetServiceTags() []string {
	if x != nil {
		return x.ServiceTags
	}
	return nil
}

func (x *HealthCheck) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *HealthCheck) GetDefinition() *HealthCheckDefinition {
	if x != nil {
		return x.Definition
	}
	return nil
}

func (x *HealthCheck) GetRaftIndex() *pbcommon.RaftIndex {
	if x != nil {
		return x.RaftIndex
	}
	return nil
}

func (x *HealthCheck) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *HealthCheck) GetExposedPort() int32 {
	if x != nil {
		return x.ExposedPort
	}
	return 0
}

func (x *HealthCheck) GetInterval() string {
	if x != nil {
		return x.Interval
	}
	return ""
}

func (x *HealthCheck) GetTimeout() string {
	if x != nil {
		return x.Timeout
	}
	return ""
}

func (x *HealthCheck) GetPeerName() string {
	if x != nil {
		return x.PeerName
	}
	return ""
}

type HeaderValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value []string `protobuf:"bytes,1,rep,name=Value,proto3" json:"Value,omitempty"`
}

func (x *HeaderValue) Reset() {
	*x = HeaderValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbservice_healthcheck_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeaderValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeaderValue) ProtoMessage() {}

func (x *HeaderValue) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeaderValue.ProtoReflect.Descriptor instead.
func (*HeaderValue) Descriptor() ([]byte, []int) {
	return file_private_pbservice_healthcheck_proto_rawDescGZIP(), []int{1}
}

func (x *HeaderValue) GetValue() []string {
	if x != nil {
		return x.Value
	}
	return nil
}

// HealthCheckDefinition of a single HealthCheck.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HealthCheckDefinition
// output=healthcheck.gen.go
// name=Structs
type HealthCheckDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	HTTP          string `protobuf:"bytes,1,opt,name=HTTP,proto3" json:"HTTP,omitempty"`
	TLSServerName string `protobuf:"bytes,19,opt,name=TLSServerName,proto3" json:"TLSServerName,omitempty"`
	TLSSkipVerify bool   `protobuf:"varint,2,opt,name=TLSSkipVerify,proto3" json:"TLSSkipVerify,omitempty"`
	// mog: func-to=MapHeadersToStructs func-from=NewMapHeadersFromStructs
	Header           map[string]*HeaderValue `protobuf:"bytes,3,rep,name=Header,proto3" json:"Header,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Method           string                  `protobuf:"bytes,4,opt,name=Method,proto3" json:"Method,omitempty"`
	Body             string                  `protobuf:"bytes,18,opt,name=Body,proto3" json:"Body,omitempty"`
	DisableRedirects bool                    `protobuf:"varint,22,opt,name=DisableRedirects,proto3" json:"DisableRedirects,omitempty"`
	TCP              string                  `protobuf:"bytes,5,opt,name=TCP,proto3" json:"TCP,omitempty"`
	TCPUseTLS        bool                    `protobuf:"varint,25,opt,name=TCPUseTLS,proto3" json:"TCPUseTLS,omitempty"`
	UDP              string                  `protobuf:"bytes,23,opt,name=UDP,proto3" json:"UDP,omitempty"`
	OSService        string                  `protobuf:"bytes,24,opt,name=OSService,proto3" json:"OSService,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	Interval *durationpb.Duration `protobuf:"bytes,6,opt,name=Interval,proto3" json:"Interval,omitempty"`
	// mog: func-to=uint func-from=uint32
	OutputMaxSize uint32 `protobuf:"varint,9,opt,name=OutputMaxSize,proto3" json:"OutputMaxSize,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	Timeout *durationpb.Duration `protobuf:"bytes,7,opt,name=Timeout,proto3" json:"Timeout,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	DeregisterCriticalServiceAfter *durationpb.Duration `protobuf:"bytes,8,opt,name=DeregisterCriticalServiceAfter,proto3" json:"DeregisterCriticalServiceAfter,omitempty"`
	ScriptArgs                     []string             `protobuf:"bytes,10,rep,name=ScriptArgs,proto3" json:"ScriptArgs,omitempty"`
	DockerContainerID              string               `protobuf:"bytes,11,opt,name=DockerContainerID,proto3" json:"DockerContainerID,omitempty"`
	Shell                          string               `protobuf:"bytes,12,opt,name=Shell,proto3" json:"Shell,omitempty"`
	H2PING                         string               `protobuf:"bytes,20,opt,name=H2PING,proto3" json:"H2PING,omitempty"`
	H2PingUseTLS                   bool                 `protobuf:"varint,21,opt,name=H2PingUseTLS,proto3" json:"H2PingUseTLS,omitempty"`
	GRPC                           string               `protobuf:"bytes,13,opt,name=GRPC,proto3" json:"GRPC,omitempty"`
	GRPCUseTLS                     bool                 `protobuf:"varint,14,opt,name=GRPCUseTLS,proto3" json:"GRPCUseTLS,omitempty"`
	AliasNode                      string               `protobuf:"bytes,15,opt,name=AliasNode,proto3" json:"AliasNode,omitempty"`
	AliasService                   string               `protobuf:"bytes,16,opt,name=AliasService,proto3" json:"AliasService,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	TTL *durationpb.Duration `protobuf:"bytes,17,opt,name=TTL,proto3" json:"TTL,omitempty"`
}

func (x *HealthCheckDefinition) Reset() {
	*x = HealthCheckDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbservice_healthcheck_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheckDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheckDefinition) ProtoMessage() {}

func (x *HealthCheckDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheckDefinition.ProtoReflect.Descriptor instead.
func (*HealthCheckDefinition) Descriptor() ([]byte, []int) {
	return file_private_pbservice_healthcheck_proto_rawDescGZIP(), []int{2}
}

func (x *HealthCheckDefinition) GetHTTP() string {
	if x != nil {
		return x.HTTP
	}
	return ""
}

func (x *HealthCheckDefinition) GetTLSServerName() string {
	if x != nil {
		return x.TLSServerName
	}
	return ""
}

func (x *HealthCheckDefinition) GetTLSSkipVerify() bool {
	if x != nil {
		return x.TLSSkipVerify
	}
	return false
}

func (x *HealthCheckDefinition) GetHeader() map[string]*HeaderValue {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *HealthCheckDefinition) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *HealthCheckDefinition) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *HealthCheckDefinition) GetDisableRedirects() bool {
	if x != nil {
		return x.DisableRedirects
	}
	return false
}

func (x *HealthCheckDefinition) GetTCP() string {
	if x != nil {
		return x.TCP
	}
	return ""
}

func (x *HealthCheckDefinition) GetTCPUseTLS() bool {
	if x != nil {
		return x.TCPUseTLS
	}
	return false
}

func (x *HealthCheckDefinition) GetUDP() string {
	if x != nil {
		return x.UDP
	}
	return ""
}

func (x *HealthCheckDefinition) GetOSService() string {
	if x != nil {
		return x.OSService
	}
	return ""
}

func (x *HealthCheckDefinition) GetInterval() *durationpb.Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *HealthCheckDefinition) GetOutputMaxSize() uint32 {
	if x != nil {
		return x.OutputMaxSize
	}
	return 0
}

func (x *HealthCheckDefinition) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *HealthCheckDefinition) GetDeregisterCriticalServiceAfter() *durationpb.Duration {
	if x != nil {
		return x.DeregisterCriticalServiceAfter
	}
	return nil
}

func (x *HealthCheckDefinition) GetScriptArgs() []string {
	if x != nil {
		return x.ScriptArgs
	}
	return nil
}

func (x *HealthCheckDefinition) GetDockerContainerID() string {
	if x != nil {
		return x.DockerContainerID
	}
	return ""
}

func (x *HealthCheckDefinition) GetShell() string {
	if x != nil {
		return x.Shell
	}
	return ""
}

func (x *HealthCheckDefinition) GetH2PING() string {
	if x != nil {
		return x.H2PING
	}
	return ""
}

func (x *HealthCheckDefinition) GetH2PingUseTLS() bool {
	if x != nil {
		return x.H2PingUseTLS
	}
	return false
}

func (x *HealthCheckDefinition) GetGRPC() string {
	if x != nil {
		return x.GRPC
	}
	return ""
}

func (x *HealthCheckDefinition) GetGRPCUseTLS() bool {
	if x != nil {
		return x.GRPCUseTLS
	}
	return false
}

func (x *HealthCheckDefinition) GetAliasNode() string {
	if x != nil {
		return x.AliasNode
	}
	return ""
}

func (x *HealthCheckDefinition) GetAliasService() string {
	if x != nil {
		return x.AliasService
	}
	return ""
}

func (x *HealthCheckDefinition) GetTTL() *durationpb.Duration {
	if x != nil {
		return x.TTL
	}
	return nil
}

// CheckType is used to create either the CheckMonitor or the CheckTTL.
// The following types are supported: Script, HTTP, TCP, Docker, TTL, GRPC,
// Alias. Script, H2PING,
// HTTP, Docker, TCP, H2PING and GRPC all require Interval. Only one of the types may
// to be provided: TTL or Script/Interval or HTTP/Interval or TCP/Interval or
// Docker/Interval or GRPC/Interval or H2PING/Interval or AliasService.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.CheckType
// output=healthcheck.gen.go
// name=Structs
type CheckType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=CheckIDType func-from=string
	CheckID    string   `protobuf:"bytes,1,opt,name=CheckID,proto3" json:"CheckID,omitempty"`
	Name       string   `protobuf:"bytes,2,opt,name=Name,proto3" json:"Name,omitempty"`
	Status     string   `protobuf:"bytes,3,opt,name=Status,proto3" json:"Status,omitempty"`
	Notes      string   `protobuf:"bytes,4,opt,name=Notes,proto3" json:"Notes,omitempty"`
	ScriptArgs []string `protobuf:"bytes,5,rep,name=ScriptArgs,proto3" json:"ScriptArgs,omitempty"`
	HTTP       string   `protobuf:"bytes,6,opt,name=HTTP,proto3" json:"HTTP,omitempty"`
	// mog: func-to=MapHeadersToStructs func-from=NewMapHeadersFromStructs
	Header           map[string]*HeaderValue `protobuf:"bytes,20,rep,name=Header,proto3" json:"Header,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Method           string                  `protobuf:"bytes,7,opt,name=Method,proto3" json:"Method,omitempty"`
	Body             string                  `protobuf:"bytes,26,opt,name=Body,proto3" json:"Body,omitempty"`
	DisableRedirects bool                    `protobuf:"varint,31,opt,name=DisableRedirects,proto3" json:"DisableRedirects,omitempty"`
	TCP              string                  `protobuf:"bytes,8,opt,name=TCP,proto3" json:"TCP,omitempty"`
	TCPUseTLS        bool                    `protobuf:"varint,34,opt,name=TCPUseTLS,proto3" json:"TCPUseTLS,omitempty"`
	UDP              string                  `protobuf:"bytes,32,opt,name=UDP,proto3" json:"UDP,omitempty"`
	OSService        string                  `protobuf:"bytes,33,opt,name=OSService,proto3" json:"OSService,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	Interval          *durationpb.Duration `protobuf:"bytes,9,opt,name=Interval,proto3" json:"Interval,omitempty"`
	AliasNode         string               `protobuf:"bytes,10,opt,name=AliasNode,proto3" json:"AliasNode,omitempty"`
	AliasService      string               `protobuf:"bytes,11,opt,name=AliasService,proto3" json:"AliasService,omitempty"`
	DockerContainerID string               `protobuf:"bytes,12,opt,name=DockerContainerID,proto3" json:"DockerContainerID,omitempty"`
	Shell             string               `protobuf:"bytes,13,opt,name=Shell,proto3" json:"Shell,omitempty"`
	H2PING            string               `protobuf:"bytes,28,opt,name=H2PING,proto3" json:"H2PING,omitempty"`
	H2PingUseTLS      bool                 `protobuf:"varint,30,opt,name=H2PingUseTLS,proto3" json:"H2PingUseTLS,omitempty"`
	GRPC              string               `protobuf:"bytes,14,opt,name=GRPC,proto3" json:"GRPC,omitempty"`
	GRPCUseTLS        bool                 `protobuf:"varint,15,opt,name=GRPCUseTLS,proto3" json:"GRPCUseTLS,omitempty"`
	TLSServerName     string               `protobuf:"bytes,27,opt,name=TLSServerName,proto3" json:"TLSServerName,omitempty"`
	TLSSkipVerify     bool                 `protobuf:"varint,16,opt,name=TLSSkipVerify,proto3" json:"TLSSkipVerify,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	Timeout *durationpb.Duration `protobuf:"bytes,17,opt,name=Timeout,proto3" json:"Timeout,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	TTL *durationpb.Duration `protobuf:"bytes,18,opt,name=TTL,proto3" json:"TTL,omitempty"`
	// mog: func-to=int func-from=int32
	SuccessBeforePassing int32 `protobuf:"varint,21,opt,name=SuccessBeforePassing,proto3" json:"SuccessBeforePassing,omitempty"`
	// mog: func-to=int func-from=int32
	FailuresBeforeWarning int32 `protobuf:"varint,29,opt,name=FailuresBeforeWarning,proto3" json:"FailuresBeforeWarning,omitempty"`
	// mog: func-to=int func-from=int32
	FailuresBeforeCritical int32 `protobuf:"varint,22,opt,name=FailuresBeforeCritical,proto3" json:"FailuresBeforeCritical,omitempty"`
	// Definition fields used when exposing checks through a proxy
	ProxyHTTP string `protobuf:"bytes,23,opt,name=ProxyHTTP,proto3" json:"ProxyHTTP,omitempty"`
	ProxyGRPC string `protobuf:"bytes,24,opt,name=ProxyGRPC,proto3" json:"ProxyGRPC,omitempty"`
	// DeregisterCriticalServiceAfter, if >0, will cause the associated
	// service, if any, to be deregistered if this check is critical for
	// longer than this duration.
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	DeregisterCriticalServiceAfter *durationpb.Duration `protobuf:"bytes,19,opt,name=DeregisterCriticalServiceAfter,proto3" json:"DeregisterCriticalServiceAfter,omitempty"`
	// mog: func-to=int func-from=int32
	OutputMaxSize int32 `protobuf:"varint,25,opt,name=OutputMaxSize,proto3" json:"OutputMaxSize,omitempty"`
}

func (x *CheckType) Reset() {
	*x = CheckType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbservice_healthcheck_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckType) ProtoMessage() {}

func (x *CheckType) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckType.ProtoReflect.Descriptor instead.
func (*CheckType) Descriptor() ([]byte, []int) {
	return file_private_pbservice_healthcheck_proto_rawDescGZIP(), []int{3}
}

func (x *CheckType) GetCheckID() string {
	if x != nil {
		return x.CheckID
	}
	return ""
}

func (x *CheckType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CheckType) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *CheckType) GetNotes() string {
	if x != nil {
		return x.Notes
	}
	return ""
}

func (x *CheckType) GetScriptArgs() []string {
	if x != nil {
		return x.ScriptArgs
	}
	return nil
}

func (x *CheckType) GetHTTP() string {
	if x != nil {
		return x.HTTP
	}
	return ""
}

func (x *CheckType) GetHeader() map[string]*HeaderValue {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *CheckType) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *CheckType) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *CheckType) GetDisableRedirects() bool {
	if x != nil {
		return x.DisableRedirects
	}
	return false
}

func (x *CheckType) GetTCP() string {
	if x != nil {
		return x.TCP
	}
	return ""
}

func (x *CheckType) GetTCPUseTLS() bool {
	if x != nil {
		return x.TCPUseTLS
	}
	return false
}

func (x *CheckType) GetUDP() string {
	if x != nil {
		return x.UDP
	}
	return ""
}

func (x *CheckType) GetOSService() string {
	if x != nil {
		return x.OSService
	}
	return ""
}

func (x *CheckType) GetInterval() *durationpb.Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *CheckType) GetAliasNode() string {
	if x != nil {
		return x.AliasNode
	}
	return ""
}

func (x *CheckType) GetAliasService() string {
	if x != nil {
		return x.AliasService
	}
	return ""
}

func (x *CheckType) GetDockerContainerID() string {
	if x != nil {
		return x.DockerContainerID
	}
	return ""
}

func (x *CheckType) GetShell() string {
	if x != nil {
		return x.Shell
	}
	return ""
}

func (x *CheckType) GetH2PING() string {
	if x != nil {
		return x.H2PING
	}
	return ""
}

func (x *CheckType) GetH2PingUseTLS() bool {
	if x != nil {
		return x.H2PingUseTLS
	}
	return false
}

func (x *CheckType) GetGRPC() string {
	if x != nil {
		return x.GRPC
	}
	return ""
}

func (x *CheckType) GetGRPCUseTLS() bool {
	if x != nil {
		return x.GRPCUseTLS
	}
	return false
}

func (x *CheckType) GetTLSServerName() string {
	if x != nil {
		return x.TLSServerName
	}
	return ""
}

func (x *CheckType) GetTLSSkipVerify() bool {
	if x != nil {
		return x.TLSSkipVerify
	}
	return false
}

func (x *CheckType) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *CheckType) GetTTL() *durationpb.Duration {
	if x != nil {
		return x.TTL
	}
	return nil
}

func (x *CheckType) GetSuccessBeforePassing() int32 {
	if x != nil {
		return x.SuccessBeforePassing
	}
	return 0
}

func (x *CheckType) GetFailuresBeforeWarning() int32 {
	if x != nil {
		return x.FailuresBeforeWarning
	}
	return 0
}

func (x *CheckType) GetFailuresBeforeCritical() int32 {
	if x != nil {
		return x.FailuresBeforeCritical
	}
	return 0
}

func (x *CheckType) GetProxyHTTP() string {
	if x != nil {
		return x.ProxyHTTP
	}
	return ""
}

func (x *CheckType) GetProxyGRPC() string {
	if x != nil {
		return x.ProxyGRPC
	}
	return ""
}

func (x *CheckType) GetDeregisterCriticalServiceAfter() *durationpb.Duration {
	if x != nil {
		return x.DeregisterCriticalServiceAfter
	}
	return nil
}

func (x *CheckType) GetOutputMaxSize() int32 {
	if x != nil {
		return x.OutputMaxSize
	}
	return 0
}

var File_private_pbservice_healthcheck_proto protoreflect.FileDescriptor

var file_private_pbservice_healthcheck_proto_rawDesc = []byte{
	0x0a, 0x23, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x62, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x2f, 0x70, 0x62, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfe, 0x04, 0x0a, 0x0b, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x49, 0x44, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x14, 0x0a, 0x05, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12,
	0x1c, 0x0a, 0x09, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44, 0x12, 0x20, 0x0a,
	0x0b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x61, 0x67, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x61, 0x67,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x58, 0x0a, 0x0a, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x49, 0x0a, 0x09, 0x52, 0x61, 0x66, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52,
	0x09, 0x52, 0x61, 0x66, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x58, 0x0a, 0x0e, 0x45, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x52, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x12, 0x20, 0x0a, 0x0b, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x50,
	0x6f, 0x72, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x45, 0x78, 0x70, 0x6f, 0x73,
	0x65, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x1a, 0x0a, 0x08,
	0x50, 0x65, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x50, 0x65, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x23, 0x0a, 0x0b, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xb0, 0x08,
	0x0a, 0x15, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x44, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x54, 0x54, 0x50, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x48, 0x54, 0x54, 0x50, 0x12, 0x24, 0x0a, 0x0d, 0x54,
	0x4c, 0x53, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x54, 0x4c, 0x53, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x24, 0x0a, 0x0d, 0x54, 0x4c, 0x53, 0x53, 0x6b, 0x69, 0x70, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x54, 0x4c, 0x53, 0x53, 0x6b, 0x69,
	0x70, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x12, 0x5c, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x12, 0x0a,
	0x04, 0x42, 0x6f, 0x64, 0x79, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x42, 0x6f, 0x64,
	0x79, 0x12, 0x2a, 0x0a, 0x10, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x44, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x73, 0x12, 0x10, 0x0a,
	0x03, 0x54, 0x43, 0x50, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x54, 0x43, 0x50, 0x12,
	0x1c, 0x0a, 0x09, 0x54, 0x43, 0x50, 0x55, 0x73, 0x65, 0x54, 0x4c, 0x53, 0x18, 0x19, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x09, 0x54, 0x43, 0x50, 0x55, 0x73, 0x65, 0x54, 0x4c, 0x53, 0x12, 0x10, 0x0a,
	0x03, 0x55, 0x44, 0x50, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x55, 0x44, 0x50, 0x12,
	0x1c, 0x0a, 0x09, 0x4f, 0x53, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x18, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x4f, 0x53, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x35, 0x0a,
	0x08, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x12, 0x24, 0x0a, 0x0d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4d, 0x61,
	0x78, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x4d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x33, 0x0a, 0x07, 0x54, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12,
	0x61, 0x0a, 0x1e, 0x44, 0x65, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x43, 0x72, 0x69,
	0x74, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x66, 0x74, 0x65,
	0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x1e, 0x44, 0x65, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x43, 0x72,
	0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x66, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x41, 0x72, 0x67, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x41, 0x72,
	0x67, 0x73, 0x12, 0x2c, 0x0a, 0x11, 0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x44, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x44,
	0x6f, 0x63, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x44,
	0x12, 0x14, 0x0a, 0x05, 0x53, 0x68, 0x65, 0x6c, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x53, 0x68, 0x65, 0x6c, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x48, 0x32, 0x50, 0x49, 0x4e, 0x47,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x48, 0x32, 0x50, 0x49, 0x4e, 0x47, 0x12, 0x22,
	0x0a, 0x0c, 0x48, 0x32, 0x50, 0x69, 0x6e, 0x67, 0x55, 0x73, 0x65, 0x54, 0x4c, 0x53, 0x18, 0x15,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x48, 0x32, 0x50, 0x69, 0x6e, 0x67, 0x55, 0x73, 0x65, 0x54,
	0x4c, 0x53, 0x12, 0x12, 0x0a, 0x04, 0x47, 0x52, 0x50, 0x43, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x47, 0x52, 0x50, 0x43, 0x12, 0x1e, 0x0a, 0x0a, 0x47, 0x52, 0x50, 0x43, 0x55, 0x73,
	0x65, 0x54, 0x4c, 0x53, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x47, 0x52, 0x50, 0x43,
	0x55, 0x73, 0x65, 0x54, 0x4c, 0x53, 0x12, 0x1c, 0x0a, 0x09, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x4e,
	0x6f, 0x64, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x41, 0x6c, 0x69, 0x61, 0x73,
	0x4e, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x41, 0x6c, 0x69, 0x61,
	0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2b, 0x0a, 0x03, 0x54, 0x54, 0x4c, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x03, 0x54, 0x54, 0x4c, 0x1a, 0x69, 0x0a, 0x0b, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x44, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0xd2, 0x0a, 0x0a, 0x09, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x44, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x53, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x41, 0x72, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x41, 0x72, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x54,
	0x54, 0x50, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x48, 0x54, 0x54, 0x50, 0x12, 0x50,
	0x0a, 0x06, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x16, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x42, 0x6f, 0x64, 0x79,
	0x18, 0x1a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x42, 0x6f, 0x64, 0x79, 0x12, 0x2a, 0x0a, 0x10,
	0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x73,
	0x18, 0x1f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x54, 0x43, 0x50, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x54, 0x43, 0x50, 0x12, 0x1c, 0x0a, 0x09, 0x54, 0x43,
	0x50, 0x55, 0x73, 0x65, 0x54, 0x4c, 0x53, 0x18, 0x22, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x54,
	0x43, 0x50, 0x55, 0x73, 0x65, 0x54, 0x4c, 0x53, 0x12, 0x10, 0x0a, 0x03, 0x55, 0x44, 0x50, 0x18,
	0x20, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x55, 0x44, 0x50, 0x12, 0x1c, 0x0a, 0x09, 0x4f, 0x53,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x21, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x4f,
	0x53, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12,
	0x1c, 0x0a, 0x09, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a,
	0x0c, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x2c, 0x0a, 0x11, 0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x49, 0x44, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x44, 0x6f,
	0x63, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x44, 0x12,
	0x14, 0x0a, 0x05, 0x53, 0x68, 0x65, 0x6c, 0x6c, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x53, 0x68, 0x65, 0x6c, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x48, 0x32, 0x50, 0x49, 0x4e, 0x47, 0x18,
	0x1c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x48, 0x32, 0x50, 0x49, 0x4e, 0x47, 0x12, 0x22, 0x0a,
	0x0c, 0x48, 0x32, 0x50, 0x69, 0x6e, 0x67, 0x55, 0x73, 0x65, 0x54, 0x4c, 0x53, 0x18, 0x1e, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x48, 0x32, 0x50, 0x69, 0x6e, 0x67, 0x55, 0x73, 0x65, 0x54, 0x4c,
	0x53, 0x12, 0x12, 0x0a, 0x04, 0x47, 0x52, 0x50, 0x43, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x47, 0x52, 0x50, 0x43, 0x12, 0x1e, 0x0a, 0x0a, 0x47, 0x52, 0x50, 0x43, 0x55, 0x73, 0x65,
	0x54, 0x4c, 0x53, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x47, 0x52, 0x50, 0x43, 0x55,
	0x73, 0x65, 0x54, 0x4c, 0x53, 0x12, 0x24, 0x0a, 0x0d, 0x54, 0x4c, 0x53, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x54, 0x4c,
	0x53, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x54,
	0x4c, 0x53, 0x53, 0x6b, 0x69, 0x70, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0d, 0x54, 0x4c, 0x53, 0x53, 0x6b, 0x69, 0x70, 0x56, 0x65, 0x72, 0x69, 0x66,
	0x79, 0x12, 0x33, 0x0a, 0x07, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x54,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x2b, 0x0a, 0x03, 0x54, 0x54, 0x4c, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03,
	0x54, 0x54, 0x4c, 0x12, 0x32, 0x0a, 0x14, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x65,
	0x66, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x14, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65,
	0x50, 0x61, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x34, 0x0a, 0x15, 0x46, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x73, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67,
	0x18, 0x1d, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73,
	0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x36, 0x0a,
	0x16, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x43,
	0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x16, 0x20, 0x01, 0x28, 0x05, 0x52, 0x16, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x43, 0x72, 0x69,
	0x74, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x48, 0x54,
	0x54, 0x50, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x48,
	0x54, 0x54, 0x50, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x47, 0x52, 0x50, 0x43,
	0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x47, 0x52, 0x50,
	0x43, 0x12, 0x61, 0x0a, 0x1e, 0x44, 0x65, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x43,
	0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x66,
	0x74, 0x65, 0x72, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1e, 0x44, 0x65, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x43, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x66, 0x74, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4d, 0x61,
	0x78, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x4d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0x69, 0x0a, 0x0b, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x44, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x96, 0x02, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42,
	0x10, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x33, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x70,
	0x62, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0xa2, 0x02, 0x04, 0x48, 0x43, 0x49, 0x53, 0xaa,
	0x02, 0x21, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0xca, 0x02, 0x21, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c,
	0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5c,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0xe2, 0x02, 0x2d, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5c, 0x47, 0x50, 0x42, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x24, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x3a, 0x3a, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x3a, 0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_private_pbservice_healthcheck_proto_rawDescOnce sync.Once
	file_private_pbservice_healthcheck_proto_rawDescData = file_private_pbservice_healthcheck_proto_rawDesc
)

func file_private_pbservice_healthcheck_proto_rawDescGZIP() []byte {
	file_private_pbservice_healthcheck_proto_rawDescOnce.Do(func() {
		file_private_pbservice_healthcheck_proto_rawDescData = protoimpl.X.CompressGZIP(file_private_pbservice_healthcheck_proto_rawDescData)
	})
	return file_private_pbservice_healthcheck_proto_rawDescData
}

var file_private_pbservice_healthcheck_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_private_pbservice_healthcheck_proto_goTypes = []interface{}{
	(*HealthCheck)(nil),             // 0: hashicorp.consul.internal.service.HealthCheck
	(*HeaderValue)(nil),             // 1: hashicorp.consul.internal.service.HeaderValue
	(*HealthCheckDefinition)(nil),   // 2: hashicorp.consul.internal.service.HealthCheckDefinition
	(*CheckType)(nil),               // 3: hashicorp.consul.internal.service.CheckType
	nil,                             // 4: hashicorp.consul.internal.service.HealthCheckDefinition.HeaderEntry
	nil,                             // 5: hashicorp.consul.internal.service.CheckType.HeaderEntry
	(*pbcommon.RaftIndex)(nil),      // 6: hashicorp.consul.internal.common.RaftIndex
	(*pbcommon.EnterpriseMeta)(nil), // 7: hashicorp.consul.internal.common.EnterpriseMeta
	(*durationpb.Duration)(nil),     // 8: google.protobuf.Duration
}
var file_private_pbservice_healthcheck_proto_depIdxs = []int32{
	2,  // 0: hashicorp.consul.internal.service.HealthCheck.Definition:type_name -> hashicorp.consul.internal.service.HealthCheckDefinition
	6,  // 1: hashicorp.consul.internal.service.HealthCheck.RaftIndex:type_name -> hashicorp.consul.internal.common.RaftIndex
	7,  // 2: hashicorp.consul.internal.service.HealthCheck.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	4,  // 3: hashicorp.consul.internal.service.HealthCheckDefinition.Header:type_name -> hashicorp.consul.internal.service.HealthCheckDefinition.HeaderEntry
	8,  // 4: hashicorp.consul.internal.service.HealthCheckDefinition.Interval:type_name -> google.protobuf.Duration
	8,  // 5: hashicorp.consul.internal.service.HealthCheckDefinition.Timeout:type_name -> google.protobuf.Duration
	8,  // 6: hashicorp.consul.internal.service.HealthCheckDefinition.DeregisterCriticalServiceAfter:type_name -> google.protobuf.Duration
	8,  // 7: hashicorp.consul.internal.service.HealthCheckDefinition.TTL:type_name -> google.protobuf.Duration
	5,  // 8: hashicorp.consul.internal.service.CheckType.Header:type_name -> hashicorp.consul.internal.service.CheckType.HeaderEntry
	8,  // 9: hashicorp.consul.internal.service.CheckType.Interval:type_name -> google.protobuf.Duration
	8,  // 10: hashicorp.consul.internal.service.CheckType.Timeout:type_name -> google.protobuf.Duration
	8,  // 11: hashicorp.consul.internal.service.CheckType.TTL:type_name -> google.protobuf.Duration
	8,  // 12: hashicorp.consul.internal.service.CheckType.DeregisterCriticalServiceAfter:type_name -> google.protobuf.Duration
	1,  // 13: hashicorp.consul.internal.service.HealthCheckDefinition.HeaderEntry.value:type_name -> hashicorp.consul.internal.service.HeaderValue
	1,  // 14: hashicorp.consul.internal.service.CheckType.HeaderEntry.value:type_name -> hashicorp.consul.internal.service.HeaderValue
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_private_pbservice_healthcheck_proto_init() }
func file_private_pbservice_healthcheck_proto_init() {
	if File_private_pbservice_healthcheck_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_private_pbservice_healthcheck_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HealthCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbservice_healthcheck_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeaderValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbservice_healthcheck_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HealthCheckDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbservice_healthcheck_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_private_pbservice_healthcheck_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_private_pbservice_healthcheck_proto_goTypes,
		DependencyIndexes: file_private_pbservice_healthcheck_proto_depIdxs,
		MessageInfos:      file_private_pbservice_healthcheck_proto_msgTypes,
	}.Build()
	File_private_pbservice_healthcheck_proto = out.File
	file_private_pbservice_healthcheck_proto_rawDesc = nil
	file_private_pbservice_healthcheck_proto_goTypes = nil
	file_private_pbservice_healthcheck_proto_depIdxs = nil
}
