// Copyright (C) 2018 Nippon Telegraph and Telephone Corporation.
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation files
// (the "Software"), to deal in the Software without restriction,
// including without limitation the rights to use, copy, modify, merge,
// publish, distribute, sublicense, and/or sell copies of the Software,
// and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v4.25.6
// source: attribute.proto

package apipb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type LsOspfRouteType int32

const (
	LsOspfRouteType_LS_OSPF_ROUTE_TYPE_UNKNOWN    LsOspfRouteType = 0
	LsOspfRouteType_LS_OSPF_ROUTE_TYPE_INTRA_AREA LsOspfRouteType = 1
	LsOspfRouteType_LS_OSPF_ROUTE_TYPE_INTER_AREA LsOspfRouteType = 2
	LsOspfRouteType_LS_OSPF_ROUTE_TYPE_EXTERNAL1  LsOspfRouteType = 3
	LsOspfRouteType_LS_OSPF_ROUTE_TYPE_EXTERNAL2  LsOspfRouteType = 4
	LsOspfRouteType_LS_OSPF_ROUTE_TYPE_NSSA1      LsOspfRouteType = 5
	LsOspfRouteType_LS_OSPF_ROUTE_TYPE_NSSA2      LsOspfRouteType = 6
)

// Enum value maps for LsOspfRouteType.
var (
	LsOspfRouteType_name = map[int32]string{
		0: "LS_OSPF_ROUTE_TYPE_UNKNOWN",
		1: "LS_OSPF_ROUTE_TYPE_INTRA_AREA",
		2: "LS_OSPF_ROUTE_TYPE_INTER_AREA",
		3: "LS_OSPF_ROUTE_TYPE_EXTERNAL1",
		4: "LS_OSPF_ROUTE_TYPE_EXTERNAL2",
		5: "LS_OSPF_ROUTE_TYPE_NSSA1",
		6: "LS_OSPF_ROUTE_TYPE_NSSA2",
	}
	LsOspfRouteType_value = map[string]int32{
		"LS_OSPF_ROUTE_TYPE_UNKNOWN":    0,
		"LS_OSPF_ROUTE_TYPE_INTRA_AREA": 1,
		"LS_OSPF_ROUTE_TYPE_INTER_AREA": 2,
		"LS_OSPF_ROUTE_TYPE_EXTERNAL1":  3,
		"LS_OSPF_ROUTE_TYPE_EXTERNAL2":  4,
		"LS_OSPF_ROUTE_TYPE_NSSA1":      5,
		"LS_OSPF_ROUTE_TYPE_NSSA2":      6,
	}
)

func (x LsOspfRouteType) Enum() *LsOspfRouteType {
	p := new(LsOspfRouteType)
	*p = x
	return p
}

func (x LsOspfRouteType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LsOspfRouteType) Descriptor() protoreflect.EnumDescriptor {
	return file_attribute_proto_enumTypes[0].Descriptor()
}

func (LsOspfRouteType) Type() protoreflect.EnumType {
	return &file_attribute_proto_enumTypes[0]
}

func (x LsOspfRouteType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LsOspfRouteType.Descriptor instead.
func (LsOspfRouteType) EnumDescriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{0}
}

// Based om RFC 7752, Table 1.
type LsNLRIType int32

const (
	LsNLRIType_LS_NLRI_UNKNOWN   LsNLRIType = 0
	LsNLRIType_LS_NLRI_NODE      LsNLRIType = 1
	LsNLRIType_LS_NLRI_LINK      LsNLRIType = 2
	LsNLRIType_LS_NLRI_PREFIX_V4 LsNLRIType = 3
	LsNLRIType_LS_NLRI_PREFIX_V6 LsNLRIType = 4
)

// Enum value maps for LsNLRIType.
var (
	LsNLRIType_name = map[int32]string{
		0: "LS_NLRI_UNKNOWN",
		1: "LS_NLRI_NODE",
		2: "LS_NLRI_LINK",
		3: "LS_NLRI_PREFIX_V4",
		4: "LS_NLRI_PREFIX_V6",
	}
	LsNLRIType_value = map[string]int32{
		"LS_NLRI_UNKNOWN":   0,
		"LS_NLRI_NODE":      1,
		"LS_NLRI_LINK":      2,
		"LS_NLRI_PREFIX_V4": 3,
		"LS_NLRI_PREFIX_V6": 4,
	}
)

func (x LsNLRIType) Enum() *LsNLRIType {
	p := new(LsNLRIType)
	*p = x
	return p
}

func (x LsNLRIType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LsNLRIType) Descriptor() protoreflect.EnumDescriptor {
	return file_attribute_proto_enumTypes[1].Descriptor()
}

func (LsNLRIType) Type() protoreflect.EnumType {
	return &file_attribute_proto_enumTypes[1]
}

func (x LsNLRIType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LsNLRIType.Descriptor instead.
func (LsNLRIType) EnumDescriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{1}
}

type LsProtocolID int32

const (
	LsProtocolID_LS_PROTOCOL_UNKNOWN LsProtocolID = 0
	LsProtocolID_LS_PROTOCOL_ISIS_L1 LsProtocolID = 1
	LsProtocolID_LS_PROTOCOL_ISIS_L2 LsProtocolID = 2
	LsProtocolID_LS_PROTOCOL_OSPF_V2 LsProtocolID = 3
	LsProtocolID_LS_PROTOCOL_DIRECT  LsProtocolID = 4
	LsProtocolID_LS_PROTOCOL_STATIC  LsProtocolID = 5
	LsProtocolID_LS_PROTOCOL_OSPF_V3 LsProtocolID = 6
)

// Enum value maps for LsProtocolID.
var (
	LsProtocolID_name = map[int32]string{
		0: "LS_PROTOCOL_UNKNOWN",
		1: "LS_PROTOCOL_ISIS_L1",
		2: "LS_PROTOCOL_ISIS_L2",
		3: "LS_PROTOCOL_OSPF_V2",
		4: "LS_PROTOCOL_DIRECT",
		5: "LS_PROTOCOL_STATIC",
		6: "LS_PROTOCOL_OSPF_V3",
	}
	LsProtocolID_value = map[string]int32{
		"LS_PROTOCOL_UNKNOWN": 0,
		"LS_PROTOCOL_ISIS_L1": 1,
		"LS_PROTOCOL_ISIS_L2": 2,
		"LS_PROTOCOL_OSPF_V2": 3,
		"LS_PROTOCOL_DIRECT":  4,
		"LS_PROTOCOL_STATIC":  5,
		"LS_PROTOCOL_OSPF_V3": 6,
	}
)

func (x LsProtocolID) Enum() *LsProtocolID {
	p := new(LsProtocolID)
	*p = x
	return p
}

func (x LsProtocolID) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LsProtocolID) Descriptor() protoreflect.EnumDescriptor {
	return file_attribute_proto_enumTypes[2].Descriptor()
}

func (LsProtocolID) Type() protoreflect.EnumType {
	return &file_attribute_proto_enumTypes[2]
}

func (x LsProtocolID) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LsProtocolID.Descriptor instead.
func (LsProtocolID) EnumDescriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{2}
}

type SRv6Behavior int32

const (
	SRv6Behavior_RESERVED              SRv6Behavior = 0
	SRv6Behavior_END                   SRv6Behavior = 1
	SRv6Behavior_END_WITH_PSP          SRv6Behavior = 2
	SRv6Behavior_END_WITH_USP          SRv6Behavior = 3
	SRv6Behavior_END_WITH_PSP_USP      SRv6Behavior = 4
	SRv6Behavior_ENDX                  SRv6Behavior = 5
	SRv6Behavior_ENDX_WITH_PSP         SRv6Behavior = 6
	SRv6Behavior_ENDX_WITH_USP         SRv6Behavior = 7
	SRv6Behavior_ENDX_WITH_PSP_USP     SRv6Behavior = 8
	SRv6Behavior_ENDT                  SRv6Behavior = 9
	SRv6Behavior_ENDT_WITH_PSP         SRv6Behavior = 10
	SRv6Behavior_ENDT_WITH_USP         SRv6Behavior = 11
	SRv6Behavior_ENDT_WITH_PSP_USP     SRv6Behavior = 12
	SRv6Behavior_END_B6_ENCAPS         SRv6Behavior = 14
	SRv6Behavior_END_BM                SRv6Behavior = 15
	SRv6Behavior_END_DX6               SRv6Behavior = 16
	SRv6Behavior_END_DX4               SRv6Behavior = 17
	SRv6Behavior_END_DT6               SRv6Behavior = 18
	SRv6Behavior_END_DT4               SRv6Behavior = 19
	SRv6Behavior_END_DT46              SRv6Behavior = 20
	SRv6Behavior_END_DX2               SRv6Behavior = 21
	SRv6Behavior_END_DX2V              SRv6Behavior = 22
	SRv6Behavior_END_DT2U              SRv6Behavior = 23
	SRv6Behavior_END_DT2M              SRv6Behavior = 24
	SRv6Behavior_END_B6_ENCAPS_Red     SRv6Behavior = 27
	SRv6Behavior_END_WITH_USD          SRv6Behavior = 28
	SRv6Behavior_END_WITH_PSP_USD      SRv6Behavior = 29
	SRv6Behavior_END_WITH_USP_USD      SRv6Behavior = 30
	SRv6Behavior_END_WITH_PSP_USP_USD  SRv6Behavior = 31
	SRv6Behavior_ENDX_WITH_USD         SRv6Behavior = 32
	SRv6Behavior_ENDX_WITH_PSP_USD     SRv6Behavior = 33
	SRv6Behavior_ENDX_WITH_USP_USD     SRv6Behavior = 34
	SRv6Behavior_ENDX_WITH_PSP_USP_USD SRv6Behavior = 35
	SRv6Behavior_ENDT_WITH_USD         SRv6Behavior = 36
	SRv6Behavior_ENDT_WITH_PSP_USD     SRv6Behavior = 37
	SRv6Behavior_ENDT_WITH_USP_USD     SRv6Behavior = 38
	SRv6Behavior_ENDT_WITH_PSP_USP_USD SRv6Behavior = 39
	SRv6Behavior_ENDM_GTP6D            SRv6Behavior = 69 // 0x0045
	SRv6Behavior_ENDM_GTP6DI           SRv6Behavior = 70 // 0x0046
	SRv6Behavior_ENDM_GTP6E            SRv6Behavior = 71 // 0x0047
	SRv6Behavior_ENDM_GTP4E            SRv6Behavior = 72 // 0x0048
)

// Enum value maps for SRv6Behavior.
var (
	SRv6Behavior_name = map[int32]string{
		0:  "RESERVED",
		1:  "END",
		2:  "END_WITH_PSP",
		3:  "END_WITH_USP",
		4:  "END_WITH_PSP_USP",
		5:  "ENDX",
		6:  "ENDX_WITH_PSP",
		7:  "ENDX_WITH_USP",
		8:  "ENDX_WITH_PSP_USP",
		9:  "ENDT",
		10: "ENDT_WITH_PSP",
		11: "ENDT_WITH_USP",
		12: "ENDT_WITH_PSP_USP",
		14: "END_B6_ENCAPS",
		15: "END_BM",
		16: "END_DX6",
		17: "END_DX4",
		18: "END_DT6",
		19: "END_DT4",
		20: "END_DT46",
		21: "END_DX2",
		22: "END_DX2V",
		23: "END_DT2U",
		24: "END_DT2M",
		27: "END_B6_ENCAPS_Red",
		28: "END_WITH_USD",
		29: "END_WITH_PSP_USD",
		30: "END_WITH_USP_USD",
		31: "END_WITH_PSP_USP_USD",
		32: "ENDX_WITH_USD",
		33: "ENDX_WITH_PSP_USD",
		34: "ENDX_WITH_USP_USD",
		35: "ENDX_WITH_PSP_USP_USD",
		36: "ENDT_WITH_USD",
		37: "ENDT_WITH_PSP_USD",
		38: "ENDT_WITH_USP_USD",
		39: "ENDT_WITH_PSP_USP_USD",
		69: "ENDM_GTP6D",
		70: "ENDM_GTP6DI",
		71: "ENDM_GTP6E",
		72: "ENDM_GTP4E",
	}
	SRv6Behavior_value = map[string]int32{
		"RESERVED":              0,
		"END":                   1,
		"END_WITH_PSP":          2,
		"END_WITH_USP":          3,
		"END_WITH_PSP_USP":      4,
		"ENDX":                  5,
		"ENDX_WITH_PSP":         6,
		"ENDX_WITH_USP":         7,
		"ENDX_WITH_PSP_USP":     8,
		"ENDT":                  9,
		"ENDT_WITH_PSP":         10,
		"ENDT_WITH_USP":         11,
		"ENDT_WITH_PSP_USP":     12,
		"END_B6_ENCAPS":         14,
		"END_BM":                15,
		"END_DX6":               16,
		"END_DX4":               17,
		"END_DT6":               18,
		"END_DT4":               19,
		"END_DT46":              20,
		"END_DX2":               21,
		"END_DX2V":              22,
		"END_DT2U":              23,
		"END_DT2M":              24,
		"END_B6_ENCAPS_Red":     27,
		"END_WITH_USD":          28,
		"END_WITH_PSP_USD":      29,
		"END_WITH_USP_USD":      30,
		"END_WITH_PSP_USP_USD":  31,
		"ENDX_WITH_USD":         32,
		"ENDX_WITH_PSP_USD":     33,
		"ENDX_WITH_USP_USD":     34,
		"ENDX_WITH_PSP_USP_USD": 35,
		"ENDT_WITH_USD":         36,
		"ENDT_WITH_PSP_USD":     37,
		"ENDT_WITH_USP_USD":     38,
		"ENDT_WITH_PSP_USP_USD": 39,
		"ENDM_GTP6D":            69,
		"ENDM_GTP6DI":           70,
		"ENDM_GTP6E":            71,
		"ENDM_GTP4E":            72,
	}
)

func (x SRv6Behavior) Enum() *SRv6Behavior {
	p := new(SRv6Behavior)
	*p = x
	return p
}

func (x SRv6Behavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SRv6Behavior) Descriptor() protoreflect.EnumDescriptor {
	return file_attribute_proto_enumTypes[3].Descriptor()
}

func (SRv6Behavior) Type() protoreflect.EnumType {
	return &file_attribute_proto_enumTypes[3]
}

func (x SRv6Behavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SRv6Behavior.Descriptor instead.
func (SRv6Behavior) EnumDescriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{3}
}

type ENLPType int32

const (
	ENLPType_Reserved ENLPType = 0
	ENLPType_Type1    ENLPType = 1
	ENLPType_Type2    ENLPType = 2
	ENLPType_Type3    ENLPType = 3
	ENLPType_Type4    ENLPType = 4
)

// Enum value maps for ENLPType.
var (
	ENLPType_name = map[int32]string{
		0: "Reserved",
		1: "Type1",
		2: "Type2",
		3: "Type3",
		4: "Type4",
	}
	ENLPType_value = map[string]int32{
		"Reserved": 0,
		"Type1":    1,
		"Type2":    2,
		"Type3":    3,
		"Type4":    4,
	}
)

func (x ENLPType) Enum() *ENLPType {
	p := new(ENLPType)
	*p = x
	return p
}

func (x ENLPType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ENLPType) Descriptor() protoreflect.EnumDescriptor {
	return file_attribute_proto_enumTypes[4].Descriptor()
}

func (ENLPType) Type() protoreflect.EnumType {
	return &file_attribute_proto_enumTypes[4]
}

func (x ENLPType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ENLPType.Descriptor instead.
func (ENLPType) EnumDescriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{4}
}

type AsSegment_Type int32

const (
	AsSegment_UNKNOWN            AsSegment_Type = 0
	AsSegment_AS_SET             AsSegment_Type = 1
	AsSegment_AS_SEQUENCE        AsSegment_Type = 2
	AsSegment_AS_CONFED_SEQUENCE AsSegment_Type = 3
	AsSegment_AS_CONFED_SET      AsSegment_Type = 4
)

// Enum value maps for AsSegment_Type.
var (
	AsSegment_Type_name = map[int32]string{
		0: "UNKNOWN",
		1: "AS_SET",
		2: "AS_SEQUENCE",
		3: "AS_CONFED_SEQUENCE",
		4: "AS_CONFED_SET",
	}
	AsSegment_Type_value = map[string]int32{
		"UNKNOWN":            0,
		"AS_SET":             1,
		"AS_SEQUENCE":        2,
		"AS_CONFED_SEQUENCE": 3,
		"AS_CONFED_SET":      4,
	}
)

func (x AsSegment_Type) Enum() *AsSegment_Type {
	p := new(AsSegment_Type)
	*p = x
	return p
}

func (x AsSegment_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AsSegment_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_attribute_proto_enumTypes[5].Descriptor()
}

func (AsSegment_Type) Type() protoreflect.EnumType {
	return &file_attribute_proto_enumTypes[5]
}

func (x AsSegment_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AsSegment_Type.Descriptor instead.
func (AsSegment_Type) EnumDescriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{1, 0}
}

type OriginAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Origin        uint32                 `protobuf:"varint,1,opt,name=origin,proto3" json:"origin,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OriginAttribute) Reset() {
	*x = OriginAttribute{}
	mi := &file_attribute_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OriginAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OriginAttribute) ProtoMessage() {}

func (x *OriginAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OriginAttribute.ProtoReflect.Descriptor instead.
func (*OriginAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{0}
}

func (x *OriginAttribute) GetOrigin() uint32 {
	if x != nil {
		return x.Origin
	}
	return 0
}

type AsSegment struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          AsSegment_Type         `protobuf:"varint,1,opt,name=type,proto3,enum=apipb.AsSegment_Type" json:"type,omitempty"`
	Numbers       []uint32               `protobuf:"varint,2,rep,packed,name=numbers,proto3" json:"numbers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AsSegment) Reset() {
	*x = AsSegment{}
	mi := &file_attribute_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AsSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsSegment) ProtoMessage() {}

func (x *AsSegment) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsSegment.ProtoReflect.Descriptor instead.
func (*AsSegment) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{1}
}

func (x *AsSegment) GetType() AsSegment_Type {
	if x != nil {
		return x.Type
	}
	return AsSegment_UNKNOWN
}

func (x *AsSegment) GetNumbers() []uint32 {
	if x != nil {
		return x.Numbers
	}
	return nil
}

type AsPathAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Segments      []*AsSegment           `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AsPathAttribute) Reset() {
	*x = AsPathAttribute{}
	mi := &file_attribute_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AsPathAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsPathAttribute) ProtoMessage() {}

func (x *AsPathAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsPathAttribute.ProtoReflect.Descriptor instead.
func (*AsPathAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{2}
}

func (x *AsPathAttribute) GetSegments() []*AsSegment {
	if x != nil {
		return x.Segments
	}
	return nil
}

type NextHopAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	NextHop       string                 `protobuf:"bytes,1,opt,name=next_hop,json=nextHop,proto3" json:"next_hop,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NextHopAttribute) Reset() {
	*x = NextHopAttribute{}
	mi := &file_attribute_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NextHopAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NextHopAttribute) ProtoMessage() {}

func (x *NextHopAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NextHopAttribute.ProtoReflect.Descriptor instead.
func (*NextHopAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{3}
}

func (x *NextHopAttribute) GetNextHop() string {
	if x != nil {
		return x.NextHop
	}
	return ""
}

type MultiExitDiscAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Med           uint32                 `protobuf:"varint,1,opt,name=med,proto3" json:"med,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MultiExitDiscAttribute) Reset() {
	*x = MultiExitDiscAttribute{}
	mi := &file_attribute_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MultiExitDiscAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiExitDiscAttribute) ProtoMessage() {}

func (x *MultiExitDiscAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiExitDiscAttribute.ProtoReflect.Descriptor instead.
func (*MultiExitDiscAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{4}
}

func (x *MultiExitDiscAttribute) GetMed() uint32 {
	if x != nil {
		return x.Med
	}
	return 0
}

type LocalPrefAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	LocalPref     uint32                 `protobuf:"varint,1,opt,name=local_pref,json=localPref,proto3" json:"local_pref,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LocalPrefAttribute) Reset() {
	*x = LocalPrefAttribute{}
	mi := &file_attribute_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalPrefAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalPrefAttribute) ProtoMessage() {}

func (x *LocalPrefAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalPrefAttribute.ProtoReflect.Descriptor instead.
func (*LocalPrefAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{5}
}

func (x *LocalPrefAttribute) GetLocalPref() uint32 {
	if x != nil {
		return x.LocalPref
	}
	return 0
}

type AtomicAggregateAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AtomicAggregateAttribute) Reset() {
	*x = AtomicAggregateAttribute{}
	mi := &file_attribute_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AtomicAggregateAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AtomicAggregateAttribute) ProtoMessage() {}

func (x *AtomicAggregateAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AtomicAggregateAttribute.ProtoReflect.Descriptor instead.
func (*AtomicAggregateAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{6}
}

type AggregatorAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Asn           uint32                 `protobuf:"varint,1,opt,name=asn,proto3" json:"asn,omitempty"`
	Address       string                 `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AggregatorAttribute) Reset() {
	*x = AggregatorAttribute{}
	mi := &file_attribute_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AggregatorAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatorAttribute) ProtoMessage() {}

func (x *AggregatorAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatorAttribute.ProtoReflect.Descriptor instead.
func (*AggregatorAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{7}
}

func (x *AggregatorAttribute) GetAsn() uint32 {
	if x != nil {
		return x.Asn
	}
	return 0
}

func (x *AggregatorAttribute) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type CommunitiesAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Communities   []uint32               `protobuf:"varint,1,rep,packed,name=communities,proto3" json:"communities,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CommunitiesAttribute) Reset() {
	*x = CommunitiesAttribute{}
	mi := &file_attribute_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CommunitiesAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommunitiesAttribute) ProtoMessage() {}

func (x *CommunitiesAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommunitiesAttribute.ProtoReflect.Descriptor instead.
func (*CommunitiesAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{8}
}

func (x *CommunitiesAttribute) GetCommunities() []uint32 {
	if x != nil {
		return x.Communities
	}
	return nil
}

type OriginatorIdAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OriginatorIdAttribute) Reset() {
	*x = OriginatorIdAttribute{}
	mi := &file_attribute_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OriginatorIdAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OriginatorIdAttribute) ProtoMessage() {}

func (x *OriginatorIdAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OriginatorIdAttribute.ProtoReflect.Descriptor instead.
func (*OriginatorIdAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{9}
}

func (x *OriginatorIdAttribute) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type ClusterListAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Ids           []string               `protobuf:"bytes,1,rep,name=ids,proto3" json:"ids,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClusterListAttribute) Reset() {
	*x = ClusterListAttribute{}
	mi := &file_attribute_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterListAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterListAttribute) ProtoMessage() {}

func (x *ClusterListAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterListAttribute.ProtoReflect.Descriptor instead.
func (*ClusterListAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{10}
}

func (x *ClusterListAttribute) GetIds() []string {
	if x != nil {
		return x.Ids
	}
	return nil
}

// IPAddressPrefix represents the NLRI for:
// - AFI=1, SAFI=1
// - AFI=2, SAFI=1
type IPAddressPrefix struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PrefixLen     uint32                 `protobuf:"varint,1,opt,name=prefix_len,json=prefixLen,proto3" json:"prefix_len,omitempty"`
	Prefix        string                 `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IPAddressPrefix) Reset() {
	*x = IPAddressPrefix{}
	mi := &file_attribute_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IPAddressPrefix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IPAddressPrefix) ProtoMessage() {}

func (x *IPAddressPrefix) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IPAddressPrefix.ProtoReflect.Descriptor instead.
func (*IPAddressPrefix) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{11}
}

func (x *IPAddressPrefix) GetPrefixLen() uint32 {
	if x != nil {
		return x.PrefixLen
	}
	return 0
}

func (x *IPAddressPrefix) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

// LabeledIPAddressPrefix represents the NLRI for:
// - AFI=1, SAFI=4
// - AFI=2, SAFI=4
type LabeledIPAddressPrefix struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Labels        []uint32               `protobuf:"varint,1,rep,packed,name=labels,proto3" json:"labels,omitempty"`
	PrefixLen     uint32                 `protobuf:"varint,2,opt,name=prefix_len,json=prefixLen,proto3" json:"prefix_len,omitempty"`
	Prefix        string                 `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LabeledIPAddressPrefix) Reset() {
	*x = LabeledIPAddressPrefix{}
	mi := &file_attribute_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabeledIPAddressPrefix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabeledIPAddressPrefix) ProtoMessage() {}

func (x *LabeledIPAddressPrefix) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabeledIPAddressPrefix.ProtoReflect.Descriptor instead.
func (*LabeledIPAddressPrefix) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{12}
}

func (x *LabeledIPAddressPrefix) GetLabels() []uint32 {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *LabeledIPAddressPrefix) GetPrefixLen() uint32 {
	if x != nil {
		return x.PrefixLen
	}
	return 0
}

func (x *LabeledIPAddressPrefix) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

// EncapsulationNLRI represents the NLRI for:
// - AFI=1, SAFI=7
// - AFI=2, SAFI=7
type EncapsulationNLRI struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Address       string                 `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EncapsulationNLRI) Reset() {
	*x = EncapsulationNLRI{}
	mi := &file_attribute_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EncapsulationNLRI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncapsulationNLRI) ProtoMessage() {}

func (x *EncapsulationNLRI) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncapsulationNLRI.ProtoReflect.Descriptor instead.
func (*EncapsulationNLRI) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{13}
}

func (x *EncapsulationNLRI) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type RouteDistinguisherTwoOctetASN struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Admin         uint32                 `protobuf:"varint,1,opt,name=admin,proto3" json:"admin,omitempty"`
	Assigned      uint32                 `protobuf:"varint,2,opt,name=assigned,proto3" json:"assigned,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RouteDistinguisherTwoOctetASN) Reset() {
	*x = RouteDistinguisherTwoOctetASN{}
	mi := &file_attribute_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RouteDistinguisherTwoOctetASN) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteDistinguisherTwoOctetASN) ProtoMessage() {}

func (x *RouteDistinguisherTwoOctetASN) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteDistinguisherTwoOctetASN.ProtoReflect.Descriptor instead.
func (*RouteDistinguisherTwoOctetASN) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{14}
}

func (x *RouteDistinguisherTwoOctetASN) GetAdmin() uint32 {
	if x != nil {
		return x.Admin
	}
	return 0
}

func (x *RouteDistinguisherTwoOctetASN) GetAssigned() uint32 {
	if x != nil {
		return x.Assigned
	}
	return 0
}

type RouteDistinguisherIPAddress struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Admin         string                 `protobuf:"bytes,1,opt,name=admin,proto3" json:"admin,omitempty"`
	Assigned      uint32                 `protobuf:"varint,2,opt,name=assigned,proto3" json:"assigned,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RouteDistinguisherIPAddress) Reset() {
	*x = RouteDistinguisherIPAddress{}
	mi := &file_attribute_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RouteDistinguisherIPAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteDistinguisherIPAddress) ProtoMessage() {}

func (x *RouteDistinguisherIPAddress) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteDistinguisherIPAddress.ProtoReflect.Descriptor instead.
func (*RouteDistinguisherIPAddress) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{15}
}

func (x *RouteDistinguisherIPAddress) GetAdmin() string {
	if x != nil {
		return x.Admin
	}
	return ""
}

func (x *RouteDistinguisherIPAddress) GetAssigned() uint32 {
	if x != nil {
		return x.Assigned
	}
	return 0
}

type RouteDistinguisherFourOctetASN struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Admin         uint32                 `protobuf:"varint,1,opt,name=admin,proto3" json:"admin,omitempty"`
	Assigned      uint32                 `protobuf:"varint,2,opt,name=assigned,proto3" json:"assigned,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RouteDistinguisherFourOctetASN) Reset() {
	*x = RouteDistinguisherFourOctetASN{}
	mi := &file_attribute_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RouteDistinguisherFourOctetASN) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteDistinguisherFourOctetASN) ProtoMessage() {}

func (x *RouteDistinguisherFourOctetASN) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteDistinguisherFourOctetASN.ProtoReflect.Descriptor instead.
func (*RouteDistinguisherFourOctetASN) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{16}
}

func (x *RouteDistinguisherFourOctetASN) GetAdmin() uint32 {
	if x != nil {
		return x.Admin
	}
	return 0
}

func (x *RouteDistinguisherFourOctetASN) GetAssigned() uint32 {
	if x != nil {
		return x.Assigned
	}
	return 0
}

type EthernetSegmentIdentifier struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	Value         []byte                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EthernetSegmentIdentifier) Reset() {
	*x = EthernetSegmentIdentifier{}
	mi := &file_attribute_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EthernetSegmentIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EthernetSegmentIdentifier) ProtoMessage() {}

func (x *EthernetSegmentIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EthernetSegmentIdentifier.ProtoReflect.Descriptor instead.
func (*EthernetSegmentIdentifier) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{17}
}

func (x *EthernetSegmentIdentifier) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *EthernetSegmentIdentifier) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// VPLSNLRI represents the NLRI for:
// - AFI=25, SAFI=65
type VPLSNLRI struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetASN
	// - RouteDistinguisherIPAddress
	// - RouteDistinguisherFourOctetASN
	Rd             *anypb.Any `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	VeId           uint32     `protobuf:"varint,2,opt,name=ve_id,json=veId,proto3" json:"ve_id,omitempty"`
	VeBlockOffset  uint32     `protobuf:"varint,3,opt,name=ve_block_offset,json=veBlockOffset,proto3" json:"ve_block_offset,omitempty"`
	VeBlockSize    uint32     `protobuf:"varint,4,opt,name=ve_block_size,json=veBlockSize,proto3" json:"ve_block_size,omitempty"`
	LabelBlockBase uint32     `protobuf:"varint,5,opt,name=label_block_base,json=labelBlockBase,proto3" json:"label_block_base,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *VPLSNLRI) Reset() {
	*x = VPLSNLRI{}
	mi := &file_attribute_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VPLSNLRI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VPLSNLRI) ProtoMessage() {}

func (x *VPLSNLRI) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VPLSNLRI.ProtoReflect.Descriptor instead.
func (*VPLSNLRI) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{18}
}

func (x *VPLSNLRI) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *VPLSNLRI) GetVeId() uint32 {
	if x != nil {
		return x.VeId
	}
	return 0
}

func (x *VPLSNLRI) GetVeBlockOffset() uint32 {
	if x != nil {
		return x.VeBlockOffset
	}
	return 0
}

func (x *VPLSNLRI) GetVeBlockSize() uint32 {
	if x != nil {
		return x.VeBlockSize
	}
	return 0
}

func (x *VPLSNLRI) GetLabelBlockBase() uint32 {
	if x != nil {
		return x.LabelBlockBase
	}
	return 0
}

// EVPNEthernetAutoDiscoveryRoute represents the NLRI for:
// - AFI=25, SAFI=70, RouteType=1
type EVPNEthernetAutoDiscoveryRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetASN
	// - RouteDistinguisherIPAddress
	// - RouteDistinguisherFourOctetASN
	Rd            *anypb.Any                 `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	Esi           *EthernetSegmentIdentifier `protobuf:"bytes,2,opt,name=esi,proto3" json:"esi,omitempty"`
	EthernetTag   uint32                     `protobuf:"varint,3,opt,name=ethernet_tag,json=ethernetTag,proto3" json:"ethernet_tag,omitempty"`
	Label         uint32                     `protobuf:"varint,4,opt,name=label,proto3" json:"label,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EVPNEthernetAutoDiscoveryRoute) Reset() {
	*x = EVPNEthernetAutoDiscoveryRoute{}
	mi := &file_attribute_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EVPNEthernetAutoDiscoveryRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EVPNEthernetAutoDiscoveryRoute) ProtoMessage() {}

func (x *EVPNEthernetAutoDiscoveryRoute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EVPNEthernetAutoDiscoveryRoute.ProtoReflect.Descriptor instead.
func (*EVPNEthernetAutoDiscoveryRoute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{19}
}

func (x *EVPNEthernetAutoDiscoveryRoute) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *EVPNEthernetAutoDiscoveryRoute) GetEsi() *EthernetSegmentIdentifier {
	if x != nil {
		return x.Esi
	}
	return nil
}

func (x *EVPNEthernetAutoDiscoveryRoute) GetEthernetTag() uint32 {
	if x != nil {
		return x.EthernetTag
	}
	return 0
}

func (x *EVPNEthernetAutoDiscoveryRoute) GetLabel() uint32 {
	if x != nil {
		return x.Label
	}
	return 0
}

// EVPNMACIPAdvertisementRoute represents the NLRI for:
// - AFI=25, SAFI=70, RouteType=2
type EVPNMACIPAdvertisementRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetASN
	// - RouteDistinguisherIPAddress
	// - RouteDistinguisherFourOctetASN
	Rd            *anypb.Any                 `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	Esi           *EthernetSegmentIdentifier `protobuf:"bytes,2,opt,name=esi,proto3" json:"esi,omitempty"`
	EthernetTag   uint32                     `protobuf:"varint,3,opt,name=ethernet_tag,json=ethernetTag,proto3" json:"ethernet_tag,omitempty"`
	MacAddress    string                     `protobuf:"bytes,4,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	IpAddress     string                     `protobuf:"bytes,5,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	Labels        []uint32                   `protobuf:"varint,6,rep,packed,name=labels,proto3" json:"labels,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EVPNMACIPAdvertisementRoute) Reset() {
	*x = EVPNMACIPAdvertisementRoute{}
	mi := &file_attribute_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EVPNMACIPAdvertisementRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EVPNMACIPAdvertisementRoute) ProtoMessage() {}

func (x *EVPNMACIPAdvertisementRoute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EVPNMACIPAdvertisementRoute.ProtoReflect.Descriptor instead.
func (*EVPNMACIPAdvertisementRoute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{20}
}

func (x *EVPNMACIPAdvertisementRoute) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *EVPNMACIPAdvertisementRoute) GetEsi() *EthernetSegmentIdentifier {
	if x != nil {
		return x.Esi
	}
	return nil
}

func (x *EVPNMACIPAdvertisementRoute) GetEthernetTag() uint32 {
	if x != nil {
		return x.EthernetTag
	}
	return 0
}

func (x *EVPNMACIPAdvertisementRoute) GetMacAddress() string {
	if x != nil {
		return x.MacAddress
	}
	return ""
}

func (x *EVPNMACIPAdvertisementRoute) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *EVPNMACIPAdvertisementRoute) GetLabels() []uint32 {
	if x != nil {
		return x.Labels
	}
	return nil
}

// EVPNInclusiveMulticastEthernetTagRoute represents the NLRI for:
// - AFI=25, SAFI=70, RouteType=3
type EVPNInclusiveMulticastEthernetTagRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetASN
	// - RouteDistinguisherIPAddress
	// - RouteDistinguisherFourOctetASN
	Rd            *anypb.Any `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	EthernetTag   uint32     `protobuf:"varint,2,opt,name=ethernet_tag,json=ethernetTag,proto3" json:"ethernet_tag,omitempty"`
	IpAddress     string     `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EVPNInclusiveMulticastEthernetTagRoute) Reset() {
	*x = EVPNInclusiveMulticastEthernetTagRoute{}
	mi := &file_attribute_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EVPNInclusiveMulticastEthernetTagRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EVPNInclusiveMulticastEthernetTagRoute) ProtoMessage() {}

func (x *EVPNInclusiveMulticastEthernetTagRoute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EVPNInclusiveMulticastEthernetTagRoute.ProtoReflect.Descriptor instead.
func (*EVPNInclusiveMulticastEthernetTagRoute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{21}
}

func (x *EVPNInclusiveMulticastEthernetTagRoute) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *EVPNInclusiveMulticastEthernetTagRoute) GetEthernetTag() uint32 {
	if x != nil {
		return x.EthernetTag
	}
	return 0
}

func (x *EVPNInclusiveMulticastEthernetTagRoute) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

// EVPNEthernetSegmentRoute represents the NLRI for:
// - AFI=25, SAFI=70, RouteType=4
type EVPNEthernetSegmentRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetASN
	// - RouteDistinguisherIPAddress
	// - RouteDistinguisherFourOctetASN
	Rd            *anypb.Any                 `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	Esi           *EthernetSegmentIdentifier `protobuf:"bytes,2,opt,name=esi,proto3" json:"esi,omitempty"`
	IpAddress     string                     `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EVPNEthernetSegmentRoute) Reset() {
	*x = EVPNEthernetSegmentRoute{}
	mi := &file_attribute_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EVPNEthernetSegmentRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EVPNEthernetSegmentRoute) ProtoMessage() {}

func (x *EVPNEthernetSegmentRoute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EVPNEthernetSegmentRoute.ProtoReflect.Descriptor instead.
func (*EVPNEthernetSegmentRoute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{22}
}

func (x *EVPNEthernetSegmentRoute) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *EVPNEthernetSegmentRoute) GetEsi() *EthernetSegmentIdentifier {
	if x != nil {
		return x.Esi
	}
	return nil
}

func (x *EVPNEthernetSegmentRoute) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

// EVPNIPPrefixRoute represents the NLRI for:
// - AFI=25, SAFI=70, RouteType=5
type EVPNIPPrefixRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetASN
	// - RouteDistinguisherIPAddress
	// - RouteDistinguisherFourOctetASN
	Rd            *anypb.Any                 `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	Esi           *EthernetSegmentIdentifier `protobuf:"bytes,2,opt,name=esi,proto3" json:"esi,omitempty"`
	EthernetTag   uint32                     `protobuf:"varint,3,opt,name=ethernet_tag,json=ethernetTag,proto3" json:"ethernet_tag,omitempty"`
	IpPrefix      string                     `protobuf:"bytes,4,opt,name=ip_prefix,json=ipPrefix,proto3" json:"ip_prefix,omitempty"`
	IpPrefixLen   uint32                     `protobuf:"varint,5,opt,name=ip_prefix_len,json=ipPrefixLen,proto3" json:"ip_prefix_len,omitempty"`
	GwAddress     string                     `protobuf:"bytes,6,opt,name=gw_address,json=gwAddress,proto3" json:"gw_address,omitempty"`
	Label         uint32                     `protobuf:"varint,7,opt,name=label,proto3" json:"label,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EVPNIPPrefixRoute) Reset() {
	*x = EVPNIPPrefixRoute{}
	mi := &file_attribute_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EVPNIPPrefixRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EVPNIPPrefixRoute) ProtoMessage() {}

func (x *EVPNIPPrefixRoute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EVPNIPPrefixRoute.ProtoReflect.Descriptor instead.
func (*EVPNIPPrefixRoute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{23}
}

func (x *EVPNIPPrefixRoute) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *EVPNIPPrefixRoute) GetEsi() *EthernetSegmentIdentifier {
	if x != nil {
		return x.Esi
	}
	return nil
}

func (x *EVPNIPPrefixRoute) GetEthernetTag() uint32 {
	if x != nil {
		return x.EthernetTag
	}
	return 0
}

func (x *EVPNIPPrefixRoute) GetIpPrefix() string {
	if x != nil {
		return x.IpPrefix
	}
	return ""
}

func (x *EVPNIPPrefixRoute) GetIpPrefixLen() uint32 {
	if x != nil {
		return x.IpPrefixLen
	}
	return 0
}

func (x *EVPNIPPrefixRoute) GetGwAddress() string {
	if x != nil {
		return x.GwAddress
	}
	return ""
}

func (x *EVPNIPPrefixRoute) GetLabel() uint32 {
	if x != nil {
		return x.Label
	}
	return 0
}

// EVPNIPMSIRoute represents the NLRI for:
// - AFI=25, SAFI=70, RouteType=9
type EVPNIPMSIRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetASN
	// - RouteDistinguisherIPAddress
	// - RouteDistinguisherFourOctetASN
	Rd            *anypb.Any `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	EthernetTag   uint32     `protobuf:"varint,2,opt,name=ethernet_tag,json=ethernetTag,proto3" json:"ethernet_tag,omitempty"`
	Rt            *anypb.Any `protobuf:"bytes,3,opt,name=rt,proto3" json:"rt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EVPNIPMSIRoute) Reset() {
	*x = EVPNIPMSIRoute{}
	mi := &file_attribute_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EVPNIPMSIRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EVPNIPMSIRoute) ProtoMessage() {}

func (x *EVPNIPMSIRoute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EVPNIPMSIRoute.ProtoReflect.Descriptor instead.
func (*EVPNIPMSIRoute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{24}
}

func (x *EVPNIPMSIRoute) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *EVPNIPMSIRoute) GetEthernetTag() uint32 {
	if x != nil {
		return x.EthernetTag
	}
	return 0
}

func (x *EVPNIPMSIRoute) GetRt() *anypb.Any {
	if x != nil {
		return x.Rt
	}
	return nil
}

// SRPolicyNLRI represents the NLRI for:
// - AFI=1, SAFI=73
// - AFI=2, SAFI=73
type SRPolicyNLRI struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// length field carries the length of NLRI portion expressed in bits
	Length uint32 `protobuf:"varint,1,opt,name=length,proto3" json:"length,omitempty"`
	// distinguisher field carries 4-octet value uniquely identifying the policy
	// in the context of <color, endpoint> tuple.
	Distinguisher uint32 `protobuf:"varint,2,opt,name=distinguisher,proto3" json:"distinguisher,omitempty"`
	// color field carries 4-octet value identifying (with the endpoint) the
	// policy.  The color is used to match the color of the destination
	// prefixes to steer traffic into the SR Policy
	Color uint32 `protobuf:"varint,3,opt,name=color,proto3" json:"color,omitempty"`
	// endpoint field identifies the endpoint of a policy.  The Endpoint may
	// represent a single node or a set of nodes (e.g., an anycast
	// address).  The Endpoint is an IPv4 (4-octet) address or an IPv6
	// (16-octet) address according to the AFI of the NLRI.
	Endpoint      []byte `protobuf:"bytes,4,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SRPolicyNLRI) Reset() {
	*x = SRPolicyNLRI{}
	mi := &file_attribute_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRPolicyNLRI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRPolicyNLRI) ProtoMessage() {}

func (x *SRPolicyNLRI) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRPolicyNLRI.ProtoReflect.Descriptor instead.
func (*SRPolicyNLRI) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{25}
}

func (x *SRPolicyNLRI) GetLength() uint32 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *SRPolicyNLRI) GetDistinguisher() uint32 {
	if x != nil {
		return x.Distinguisher
	}
	return 0
}

func (x *SRPolicyNLRI) GetColor() uint32 {
	if x != nil {
		return x.Color
	}
	return 0
}

func (x *SRPolicyNLRI) GetEndpoint() []byte {
	if x != nil {
		return x.Endpoint
	}
	return nil
}

// LabeledVPNIPAddressPrefix represents the NLRI for:
// - AFI=1, SAFI=128
// - AFI=2, SAFI=128
type LabeledVPNIPAddressPrefix struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	Labels []uint32               `protobuf:"varint,1,rep,packed,name=labels,proto3" json:"labels,omitempty"`
	// One of:
	// - TwoOctetAsSpecificExtended
	// - IPv4AddressSpecificExtended
	// - FourOctetAsSpecificExtended
	Rd            *anypb.Any `protobuf:"bytes,2,opt,name=rd,proto3" json:"rd,omitempty"`
	PrefixLen     uint32     `protobuf:"varint,3,opt,name=prefix_len,json=prefixLen,proto3" json:"prefix_len,omitempty"`
	Prefix        string     `protobuf:"bytes,4,opt,name=prefix,proto3" json:"prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LabeledVPNIPAddressPrefix) Reset() {
	*x = LabeledVPNIPAddressPrefix{}
	mi := &file_attribute_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabeledVPNIPAddressPrefix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabeledVPNIPAddressPrefix) ProtoMessage() {}

func (x *LabeledVPNIPAddressPrefix) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabeledVPNIPAddressPrefix.ProtoReflect.Descriptor instead.
func (*LabeledVPNIPAddressPrefix) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{26}
}

func (x *LabeledVPNIPAddressPrefix) GetLabels() []uint32 {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *LabeledVPNIPAddressPrefix) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *LabeledVPNIPAddressPrefix) GetPrefixLen() uint32 {
	if x != nil {
		return x.PrefixLen
	}
	return 0
}

func (x *LabeledVPNIPAddressPrefix) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

// RouteTargetMembershipNLRI represents the NLRI for:
// - AFI=1, SAFI=132
type RouteTargetMembershipNLRI struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Asn   uint32                 `protobuf:"varint,1,opt,name=asn,proto3" json:"asn,omitempty"`
	// One of:
	// - TwoOctetAsSpecificExtended
	// - IPv4AddressSpecificExtended
	// - FourOctetAsSpecificExtended
	Rt            *anypb.Any `protobuf:"bytes,2,opt,name=rt,proto3" json:"rt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RouteTargetMembershipNLRI) Reset() {
	*x = RouteTargetMembershipNLRI{}
	mi := &file_attribute_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RouteTargetMembershipNLRI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteTargetMembershipNLRI) ProtoMessage() {}

func (x *RouteTargetMembershipNLRI) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteTargetMembershipNLRI.ProtoReflect.Descriptor instead.
func (*RouteTargetMembershipNLRI) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{27}
}

func (x *RouteTargetMembershipNLRI) GetAsn() uint32 {
	if x != nil {
		return x.Asn
	}
	return 0
}

func (x *RouteTargetMembershipNLRI) GetRt() *anypb.Any {
	if x != nil {
		return x.Rt
	}
	return nil
}

type FlowSpecIPPrefix struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	Type      uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	PrefixLen uint32                 `protobuf:"varint,2,opt,name=prefix_len,json=prefixLen,proto3" json:"prefix_len,omitempty"`
	Prefix    string                 `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// IPv6 only
	Offset        uint32 `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowSpecIPPrefix) Reset() {
	*x = FlowSpecIPPrefix{}
	mi := &file_attribute_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowSpecIPPrefix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowSpecIPPrefix) ProtoMessage() {}

func (x *FlowSpecIPPrefix) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowSpecIPPrefix.ProtoReflect.Descriptor instead.
func (*FlowSpecIPPrefix) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{28}
}

func (x *FlowSpecIPPrefix) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *FlowSpecIPPrefix) GetPrefixLen() uint32 {
	if x != nil {
		return x.PrefixLen
	}
	return 0
}

func (x *FlowSpecIPPrefix) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *FlowSpecIPPrefix) GetOffset() uint32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

type FlowSpecMAC struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	Address       string                 `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowSpecMAC) Reset() {
	*x = FlowSpecMAC{}
	mi := &file_attribute_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowSpecMAC) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowSpecMAC) ProtoMessage() {}

func (x *FlowSpecMAC) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowSpecMAC.ProtoReflect.Descriptor instead.
func (*FlowSpecMAC) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{29}
}

func (x *FlowSpecMAC) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *FlowSpecMAC) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type FlowSpecComponentItem struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Operator for Numeric type, Operand for Bitmask type
	Op            uint32 `protobuf:"varint,1,opt,name=op,proto3" json:"op,omitempty"`
	Value         uint64 `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowSpecComponentItem) Reset() {
	*x = FlowSpecComponentItem{}
	mi := &file_attribute_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowSpecComponentItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowSpecComponentItem) ProtoMessage() {}

func (x *FlowSpecComponentItem) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowSpecComponentItem.ProtoReflect.Descriptor instead.
func (*FlowSpecComponentItem) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{30}
}

func (x *FlowSpecComponentItem) GetOp() uint32 {
	if x != nil {
		return x.Op
	}
	return 0
}

func (x *FlowSpecComponentItem) GetValue() uint64 {
	if x != nil {
		return x.Value
	}
	return 0
}

type FlowSpecComponent struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Type          uint32                   `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	Items         []*FlowSpecComponentItem `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowSpecComponent) Reset() {
	*x = FlowSpecComponent{}
	mi := &file_attribute_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowSpecComponent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowSpecComponent) ProtoMessage() {}

func (x *FlowSpecComponent) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowSpecComponent.ProtoReflect.Descriptor instead.
func (*FlowSpecComponent) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{31}
}

func (x *FlowSpecComponent) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *FlowSpecComponent) GetItems() []*FlowSpecComponentItem {
	if x != nil {
		return x.Items
	}
	return nil
}

// FlowSpecNLRI represents the NLRI for:
// - AFI=1, SAFI=133
// - AFI=2, SAFI=133
type FlowSpecNLRI struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - FlowSpecIPPrefix
	// - FlowSpecMAC
	// - FlowSpecComponent
	Rules         []*anypb.Any `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowSpecNLRI) Reset() {
	*x = FlowSpecNLRI{}
	mi := &file_attribute_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowSpecNLRI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowSpecNLRI) ProtoMessage() {}

func (x *FlowSpecNLRI) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowSpecNLRI.ProtoReflect.Descriptor instead.
func (*FlowSpecNLRI) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{32}
}

func (x *FlowSpecNLRI) GetRules() []*anypb.Any {
	if x != nil {
		return x.Rules
	}
	return nil
}

// VPNFlowSpecNLRI represents the NLRI for:
// - AFI=1, SAFI=134
// - AFI=2, SAFI=134
// - AFI=25, SAFI=134
type VPNFlowSpecNLRI struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetAS
	// - RouteDistinguisherIPAddressAS
	// - RouteDistinguisherFourOctetAS
	Rd *anypb.Any `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	// One of:
	// - FlowSpecIPPrefix
	// - FlowSpecMAC
	// - FlowSpecComponent
	Rules         []*anypb.Any `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VPNFlowSpecNLRI) Reset() {
	*x = VPNFlowSpecNLRI{}
	mi := &file_attribute_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VPNFlowSpecNLRI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VPNFlowSpecNLRI) ProtoMessage() {}

func (x *VPNFlowSpecNLRI) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VPNFlowSpecNLRI.ProtoReflect.Descriptor instead.
func (*VPNFlowSpecNLRI) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{33}
}

func (x *VPNFlowSpecNLRI) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *VPNFlowSpecNLRI) GetRules() []*anypb.Any {
	if x != nil {
		return x.Rules
	}
	return nil
}

// OpaqueNLRI represents the NLRI for:
// - AFI=16397, SAFI=241
type OpaqueNLRI struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           []byte                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value         []byte                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpaqueNLRI) Reset() {
	*x = OpaqueNLRI{}
	mi := &file_attribute_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpaqueNLRI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpaqueNLRI) ProtoMessage() {}

func (x *OpaqueNLRI) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpaqueNLRI.ProtoReflect.Descriptor instead.
func (*OpaqueNLRI) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{34}
}

func (x *OpaqueNLRI) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *OpaqueNLRI) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type LsNodeDescriptor struct {
	state                  protoimpl.MessageState `protogen:"open.v1"`
	Asn                    uint32                 `protobuf:"varint,1,opt,name=asn,proto3" json:"asn,omitempty"`
	BgpLsId                uint32                 `protobuf:"varint,2,opt,name=bgp_ls_id,json=bgpLsId,proto3" json:"bgp_ls_id,omitempty"`
	OspfAreaId             uint32                 `protobuf:"varint,3,opt,name=ospf_area_id,json=ospfAreaId,proto3" json:"ospf_area_id,omitempty"`
	Pseudonode             bool                   `protobuf:"varint,4,opt,name=pseudonode,proto3" json:"pseudonode,omitempty"`
	IgpRouterId            string                 `protobuf:"bytes,5,opt,name=igp_router_id,json=igpRouterId,proto3" json:"igp_router_id,omitempty"`
	BgpRouterId            string                 `protobuf:"bytes,6,opt,name=bgp_router_id,json=bgpRouterId,proto3" json:"bgp_router_id,omitempty"`
	BgpConfederationMember uint32                 `protobuf:"varint,7,opt,name=bgp_confederation_member,json=bgpConfederationMember,proto3" json:"bgp_confederation_member,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *LsNodeDescriptor) Reset() {
	*x = LsNodeDescriptor{}
	mi := &file_attribute_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsNodeDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsNodeDescriptor) ProtoMessage() {}

func (x *LsNodeDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsNodeDescriptor.ProtoReflect.Descriptor instead.
func (*LsNodeDescriptor) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{35}
}

func (x *LsNodeDescriptor) GetAsn() uint32 {
	if x != nil {
		return x.Asn
	}
	return 0
}

func (x *LsNodeDescriptor) GetBgpLsId() uint32 {
	if x != nil {
		return x.BgpLsId
	}
	return 0
}

func (x *LsNodeDescriptor) GetOspfAreaId() uint32 {
	if x != nil {
		return x.OspfAreaId
	}
	return 0
}

func (x *LsNodeDescriptor) GetPseudonode() bool {
	if x != nil {
		return x.Pseudonode
	}
	return false
}

func (x *LsNodeDescriptor) GetIgpRouterId() string {
	if x != nil {
		return x.IgpRouterId
	}
	return ""
}

func (x *LsNodeDescriptor) GetBgpRouterId() string {
	if x != nil {
		return x.BgpRouterId
	}
	return ""
}

func (x *LsNodeDescriptor) GetBgpConfederationMember() uint32 {
	if x != nil {
		return x.BgpConfederationMember
	}
	return 0
}

type LsLinkDescriptor struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	LinkLocalId       uint32                 `protobuf:"varint,1,opt,name=link_local_id,json=linkLocalId,proto3" json:"link_local_id,omitempty"`
	LinkRemoteId      uint32                 `protobuf:"varint,2,opt,name=link_remote_id,json=linkRemoteId,proto3" json:"link_remote_id,omitempty"`
	InterfaceAddrIpv4 string                 `protobuf:"bytes,3,opt,name=interface_addr_ipv4,json=interfaceAddrIpv4,proto3" json:"interface_addr_ipv4,omitempty"`
	NeighborAddrIpv4  string                 `protobuf:"bytes,4,opt,name=neighbor_addr_ipv4,json=neighborAddrIpv4,proto3" json:"neighbor_addr_ipv4,omitempty"`
	InterfaceAddrIpv6 string                 `protobuf:"bytes,5,opt,name=interface_addr_ipv6,json=interfaceAddrIpv6,proto3" json:"interface_addr_ipv6,omitempty"`
	NeighborAddrIpv6  string                 `protobuf:"bytes,6,opt,name=neighbor_addr_ipv6,json=neighborAddrIpv6,proto3" json:"neighbor_addr_ipv6,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *LsLinkDescriptor) Reset() {
	*x = LsLinkDescriptor{}
	mi := &file_attribute_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsLinkDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsLinkDescriptor) ProtoMessage() {}

func (x *LsLinkDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsLinkDescriptor.ProtoReflect.Descriptor instead.
func (*LsLinkDescriptor) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{36}
}

func (x *LsLinkDescriptor) GetLinkLocalId() uint32 {
	if x != nil {
		return x.LinkLocalId
	}
	return 0
}

func (x *LsLinkDescriptor) GetLinkRemoteId() uint32 {
	if x != nil {
		return x.LinkRemoteId
	}
	return 0
}

func (x *LsLinkDescriptor) GetInterfaceAddrIpv4() string {
	if x != nil {
		return x.InterfaceAddrIpv4
	}
	return ""
}

func (x *LsLinkDescriptor) GetNeighborAddrIpv4() string {
	if x != nil {
		return x.NeighborAddrIpv4
	}
	return ""
}

func (x *LsLinkDescriptor) GetInterfaceAddrIpv6() string {
	if x != nil {
		return x.InterfaceAddrIpv6
	}
	return ""
}

func (x *LsLinkDescriptor) GetNeighborAddrIpv6() string {
	if x != nil {
		return x.NeighborAddrIpv6
	}
	return ""
}

type LsPrefixDescriptor struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	IpReachability []string               `protobuf:"bytes,1,rep,name=ip_reachability,json=ipReachability,proto3" json:"ip_reachability,omitempty"`
	OspfRouteType  LsOspfRouteType        `protobuf:"varint,2,opt,name=ospf_route_type,json=ospfRouteType,proto3,enum=apipb.LsOspfRouteType" json:"ospf_route_type,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *LsPrefixDescriptor) Reset() {
	*x = LsPrefixDescriptor{}
	mi := &file_attribute_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsPrefixDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsPrefixDescriptor) ProtoMessage() {}

func (x *LsPrefixDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsPrefixDescriptor.ProtoReflect.Descriptor instead.
func (*LsPrefixDescriptor) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{37}
}

func (x *LsPrefixDescriptor) GetIpReachability() []string {
	if x != nil {
		return x.IpReachability
	}
	return nil
}

func (x *LsPrefixDescriptor) GetOspfRouteType() LsOspfRouteType {
	if x != nil {
		return x.OspfRouteType
	}
	return LsOspfRouteType_LS_OSPF_ROUTE_TYPE_UNKNOWN
}

type LsNodeNLRI struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	LocalNode     *LsNodeDescriptor      `protobuf:"bytes,1,opt,name=local_node,json=localNode,proto3" json:"local_node,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LsNodeNLRI) Reset() {
	*x = LsNodeNLRI{}
	mi := &file_attribute_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsNodeNLRI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsNodeNLRI) ProtoMessage() {}

func (x *LsNodeNLRI) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsNodeNLRI.ProtoReflect.Descriptor instead.
func (*LsNodeNLRI) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{38}
}

func (x *LsNodeNLRI) GetLocalNode() *LsNodeDescriptor {
	if x != nil {
		return x.LocalNode
	}
	return nil
}

type LsLinkNLRI struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	LocalNode      *LsNodeDescriptor      `protobuf:"bytes,1,opt,name=local_node,json=localNode,proto3" json:"local_node,omitempty"`
	RemoteNode     *LsNodeDescriptor      `protobuf:"bytes,2,opt,name=remote_node,json=remoteNode,proto3" json:"remote_node,omitempty"`
	LinkDescriptor *LsLinkDescriptor      `protobuf:"bytes,3,opt,name=link_descriptor,json=linkDescriptor,proto3" json:"link_descriptor,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *LsLinkNLRI) Reset() {
	*x = LsLinkNLRI{}
	mi := &file_attribute_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsLinkNLRI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsLinkNLRI) ProtoMessage() {}

func (x *LsLinkNLRI) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsLinkNLRI.ProtoReflect.Descriptor instead.
func (*LsLinkNLRI) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{39}
}

func (x *LsLinkNLRI) GetLocalNode() *LsNodeDescriptor {
	if x != nil {
		return x.LocalNode
	}
	return nil
}

func (x *LsLinkNLRI) GetRemoteNode() *LsNodeDescriptor {
	if x != nil {
		return x.RemoteNode
	}
	return nil
}

func (x *LsLinkNLRI) GetLinkDescriptor() *LsLinkDescriptor {
	if x != nil {
		return x.LinkDescriptor
	}
	return nil
}

type LsPrefixV4NLRI struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	LocalNode        *LsNodeDescriptor      `protobuf:"bytes,1,opt,name=local_node,json=localNode,proto3" json:"local_node,omitempty"`
	PrefixDescriptor *LsPrefixDescriptor    `protobuf:"bytes,2,opt,name=prefix_descriptor,json=prefixDescriptor,proto3" json:"prefix_descriptor,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *LsPrefixV4NLRI) Reset() {
	*x = LsPrefixV4NLRI{}
	mi := &file_attribute_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsPrefixV4NLRI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsPrefixV4NLRI) ProtoMessage() {}

func (x *LsPrefixV4NLRI) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsPrefixV4NLRI.ProtoReflect.Descriptor instead.
func (*LsPrefixV4NLRI) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{40}
}

func (x *LsPrefixV4NLRI) GetLocalNode() *LsNodeDescriptor {
	if x != nil {
		return x.LocalNode
	}
	return nil
}

func (x *LsPrefixV4NLRI) GetPrefixDescriptor() *LsPrefixDescriptor {
	if x != nil {
		return x.PrefixDescriptor
	}
	return nil
}

type LsPrefixV6NLRI struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	LocalNode        *LsNodeDescriptor      `protobuf:"bytes,1,opt,name=local_node,json=localNode,proto3" json:"local_node,omitempty"`
	PrefixDescriptor *LsPrefixDescriptor    `protobuf:"bytes,2,opt,name=prefix_descriptor,json=prefixDescriptor,proto3" json:"prefix_descriptor,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *LsPrefixV6NLRI) Reset() {
	*x = LsPrefixV6NLRI{}
	mi := &file_attribute_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsPrefixV6NLRI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsPrefixV6NLRI) ProtoMessage() {}

func (x *LsPrefixV6NLRI) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsPrefixV6NLRI.ProtoReflect.Descriptor instead.
func (*LsPrefixV6NLRI) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{41}
}

func (x *LsPrefixV6NLRI) GetLocalNode() *LsNodeDescriptor {
	if x != nil {
		return x.LocalNode
	}
	return nil
}

func (x *LsPrefixV6NLRI) GetPrefixDescriptor() *LsPrefixDescriptor {
	if x != nil {
		return x.PrefixDescriptor
	}
	return nil
}

// LsAddrPrefix represents the NLRI for:
// - AFI=16388, SAFI=71
type LsAddrPrefix struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Type  LsNLRIType             `protobuf:"varint,1,opt,name=type,proto3,enum=apipb.LsNLRIType" json:"type,omitempty"`
	// One of:
	// - LsNodeNLRI
	// - LsLinkNLRI
	// - LsPrefixV4NLRI
	// - LsPrefixV6NLRI
	Nlri          *anypb.Any   `protobuf:"bytes,2,opt,name=nlri,proto3" json:"nlri,omitempty"`
	Length        uint32       `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
	ProtocolId    LsProtocolID `protobuf:"varint,4,opt,name=protocol_id,json=protocolId,proto3,enum=apipb.LsProtocolID" json:"protocol_id,omitempty"`
	Identifier    uint64       `protobuf:"varint,5,opt,name=identifier,proto3" json:"identifier,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LsAddrPrefix) Reset() {
	*x = LsAddrPrefix{}
	mi := &file_attribute_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsAddrPrefix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsAddrPrefix) ProtoMessage() {}

func (x *LsAddrPrefix) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsAddrPrefix.ProtoReflect.Descriptor instead.
func (*LsAddrPrefix) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{42}
}

func (x *LsAddrPrefix) GetType() LsNLRIType {
	if x != nil {
		return x.Type
	}
	return LsNLRIType_LS_NLRI_UNKNOWN
}

func (x *LsAddrPrefix) GetNlri() *anypb.Any {
	if x != nil {
		return x.Nlri
	}
	return nil
}

func (x *LsAddrPrefix) GetLength() uint32 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *LsAddrPrefix) GetProtocolId() LsProtocolID {
	if x != nil {
		return x.ProtocolId
	}
	return LsProtocolID_LS_PROTOCOL_UNKNOWN
}

func (x *LsAddrPrefix) GetIdentifier() uint64 {
	if x != nil {
		return x.Identifier
	}
	return 0
}

type MUPInterworkSegmentDiscoveryRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetASN
	// - RouteDistinguisherIPAddress
	// - RouteDistinguisherFourOctetASN
	Rd            *anypb.Any `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	Prefix        string     `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MUPInterworkSegmentDiscoveryRoute) Reset() {
	*x = MUPInterworkSegmentDiscoveryRoute{}
	mi := &file_attribute_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MUPInterworkSegmentDiscoveryRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MUPInterworkSegmentDiscoveryRoute) ProtoMessage() {}

func (x *MUPInterworkSegmentDiscoveryRoute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MUPInterworkSegmentDiscoveryRoute.ProtoReflect.Descriptor instead.
func (*MUPInterworkSegmentDiscoveryRoute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{43}
}

func (x *MUPInterworkSegmentDiscoveryRoute) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *MUPInterworkSegmentDiscoveryRoute) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

type MUPDirectSegmentDiscoveryRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetASN
	// - RouteDistinguisherIPAddress
	// - RouteDistinguisherFourOctetASN
	Rd            *anypb.Any `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	Address       string     `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MUPDirectSegmentDiscoveryRoute) Reset() {
	*x = MUPDirectSegmentDiscoveryRoute{}
	mi := &file_attribute_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MUPDirectSegmentDiscoveryRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MUPDirectSegmentDiscoveryRoute) ProtoMessage() {}

func (x *MUPDirectSegmentDiscoveryRoute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MUPDirectSegmentDiscoveryRoute.ProtoReflect.Descriptor instead.
func (*MUPDirectSegmentDiscoveryRoute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{44}
}

func (x *MUPDirectSegmentDiscoveryRoute) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *MUPDirectSegmentDiscoveryRoute) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type MUPType1SessionTransformedRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetASN
	// - RouteDistinguisherIPAddress
	// - RouteDistinguisherFourOctetASN
	Rd *anypb.Any `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	// Deprecated: Marked as deprecated in attribute.proto.
	PrefixLength          uint32 `protobuf:"varint,2,opt,name=prefix_length,json=prefixLength,proto3" json:"prefix_length,omitempty"`
	Prefix                string `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
	Teid                  uint32 `protobuf:"varint,4,opt,name=teid,proto3" json:"teid,omitempty"`
	Qfi                   uint32 `protobuf:"varint,5,opt,name=qfi,proto3" json:"qfi,omitempty"`
	EndpointAddressLength uint32 `protobuf:"varint,6,opt,name=endpoint_address_length,json=endpointAddressLength,proto3" json:"endpoint_address_length,omitempty"`
	EndpointAddress       string `protobuf:"bytes,7,opt,name=endpoint_address,json=endpointAddress,proto3" json:"endpoint_address,omitempty"`
	SourceAddressLength   uint32 `protobuf:"varint,8,opt,name=source_address_length,json=sourceAddressLength,proto3" json:"source_address_length,omitempty"`
	SourceAddress         string `protobuf:"bytes,9,opt,name=source_address,json=sourceAddress,proto3" json:"source_address,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *MUPType1SessionTransformedRoute) Reset() {
	*x = MUPType1SessionTransformedRoute{}
	mi := &file_attribute_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MUPType1SessionTransformedRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MUPType1SessionTransformedRoute) ProtoMessage() {}

func (x *MUPType1SessionTransformedRoute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MUPType1SessionTransformedRoute.ProtoReflect.Descriptor instead.
func (*MUPType1SessionTransformedRoute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{45}
}

func (x *MUPType1SessionTransformedRoute) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

// Deprecated: Marked as deprecated in attribute.proto.
func (x *MUPType1SessionTransformedRoute) GetPrefixLength() uint32 {
	if x != nil {
		return x.PrefixLength
	}
	return 0
}

func (x *MUPType1SessionTransformedRoute) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *MUPType1SessionTransformedRoute) GetTeid() uint32 {
	if x != nil {
		return x.Teid
	}
	return 0
}

func (x *MUPType1SessionTransformedRoute) GetQfi() uint32 {
	if x != nil {
		return x.Qfi
	}
	return 0
}

func (x *MUPType1SessionTransformedRoute) GetEndpointAddressLength() uint32 {
	if x != nil {
		return x.EndpointAddressLength
	}
	return 0
}

func (x *MUPType1SessionTransformedRoute) GetEndpointAddress() string {
	if x != nil {
		return x.EndpointAddress
	}
	return ""
}

func (x *MUPType1SessionTransformedRoute) GetSourceAddressLength() uint32 {
	if x != nil {
		return x.SourceAddressLength
	}
	return 0
}

func (x *MUPType1SessionTransformedRoute) GetSourceAddress() string {
	if x != nil {
		return x.SourceAddress
	}
	return ""
}

type MUPType2SessionTransformedRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of:
	// - RouteDistinguisherTwoOctetASN
	// - RouteDistinguisherIPAddress
	// - RouteDistinguisherFourOctetASN
	Rd                    *anypb.Any `protobuf:"bytes,1,opt,name=rd,proto3" json:"rd,omitempty"`
	EndpointAddressLength uint32     `protobuf:"varint,2,opt,name=endpoint_address_length,json=endpointAddressLength,proto3" json:"endpoint_address_length,omitempty"`
	EndpointAddress       string     `protobuf:"bytes,3,opt,name=endpoint_address,json=endpointAddress,proto3" json:"endpoint_address,omitempty"`
	Teid                  uint32     `protobuf:"varint,4,opt,name=teid,proto3" json:"teid,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *MUPType2SessionTransformedRoute) Reset() {
	*x = MUPType2SessionTransformedRoute{}
	mi := &file_attribute_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MUPType2SessionTransformedRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MUPType2SessionTransformedRoute) ProtoMessage() {}

func (x *MUPType2SessionTransformedRoute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MUPType2SessionTransformedRoute.ProtoReflect.Descriptor instead.
func (*MUPType2SessionTransformedRoute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{46}
}

func (x *MUPType2SessionTransformedRoute) GetRd() *anypb.Any {
	if x != nil {
		return x.Rd
	}
	return nil
}

func (x *MUPType2SessionTransformedRoute) GetEndpointAddressLength() uint32 {
	if x != nil {
		return x.EndpointAddressLength
	}
	return 0
}

func (x *MUPType2SessionTransformedRoute) GetEndpointAddress() string {
	if x != nil {
		return x.EndpointAddress
	}
	return ""
}

func (x *MUPType2SessionTransformedRoute) GetTeid() uint32 {
	if x != nil {
		return x.Teid
	}
	return 0
}

type MpReachNLRIAttribute struct {
	state    protoimpl.MessageState `protogen:"open.v1"`
	Family   *Family                `protobuf:"bytes,1,opt,name=family,proto3" json:"family,omitempty"`
	NextHops []string               `protobuf:"bytes,2,rep,name=next_hops,json=nextHops,proto3" json:"next_hops,omitempty"`
	// Each NLRI must be one of:
	// - IPAddressPrefix
	// - LabeledIPAddressPrefix
	// - EncapsulationNLRI
	// - EVPNEthernetAutoDiscoveryRoute
	// - EVPNMACIPAdvertisementRoute
	// - EVPNInclusiveMulticastEthernetTagRoute
	// - EVPNEthernetSegmentRoute
	// - EVPNIPPrefixRoute
	// - EVPNIPMSIRoute
	// - LabeledVPNIPAddressPrefix
	// - RouteTargetMembershipNLRI
	// - FlowSpecNLRI
	// - VPNFlowSpecNLRI
	// - OpaqueNLRI
	// - LsAddrPrefix
	// - SR Policy NLRI
	// - MUPInterworkSegmentDiscoveryRoute
	// - MUPDirectSegmentDiscoveryRoute
	// - MUPType1SessionTransformedRoute
	// - MUPType2SessionTransformedRoute
	Nlris         []*anypb.Any `protobuf:"bytes,3,rep,name=nlris,proto3" json:"nlris,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MpReachNLRIAttribute) Reset() {
	*x = MpReachNLRIAttribute{}
	mi := &file_attribute_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MpReachNLRIAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MpReachNLRIAttribute) ProtoMessage() {}

func (x *MpReachNLRIAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MpReachNLRIAttribute.ProtoReflect.Descriptor instead.
func (*MpReachNLRIAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{47}
}

func (x *MpReachNLRIAttribute) GetFamily() *Family {
	if x != nil {
		return x.Family
	}
	return nil
}

func (x *MpReachNLRIAttribute) GetNextHops() []string {
	if x != nil {
		return x.NextHops
	}
	return nil
}

func (x *MpReachNLRIAttribute) GetNlris() []*anypb.Any {
	if x != nil {
		return x.Nlris
	}
	return nil
}

type MpUnreachNLRIAttribute struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	Family *Family                `protobuf:"bytes,1,opt,name=family,proto3" json:"family,omitempty"`
	// The same as NLRI field of MpReachNLRIAttribute
	Nlris         []*anypb.Any `protobuf:"bytes,3,rep,name=nlris,proto3" json:"nlris,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MpUnreachNLRIAttribute) Reset() {
	*x = MpUnreachNLRIAttribute{}
	mi := &file_attribute_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MpUnreachNLRIAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MpUnreachNLRIAttribute) ProtoMessage() {}

func (x *MpUnreachNLRIAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MpUnreachNLRIAttribute.ProtoReflect.Descriptor instead.
func (*MpUnreachNLRIAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{48}
}

func (x *MpUnreachNLRIAttribute) GetFamily() *Family {
	if x != nil {
		return x.Family
	}
	return nil
}

func (x *MpUnreachNLRIAttribute) GetNlris() []*anypb.Any {
	if x != nil {
		return x.Nlris
	}
	return nil
}

type TwoOctetAsSpecificExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IsTransitive  bool                   `protobuf:"varint,1,opt,name=is_transitive,json=isTransitive,proto3" json:"is_transitive,omitempty"`
	SubType       uint32                 `protobuf:"varint,2,opt,name=sub_type,json=subType,proto3" json:"sub_type,omitempty"`
	Asn           uint32                 `protobuf:"varint,3,opt,name=asn,proto3" json:"asn,omitempty"`
	LocalAdmin    uint32                 `protobuf:"varint,4,opt,name=local_admin,json=localAdmin,proto3" json:"local_admin,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TwoOctetAsSpecificExtended) Reset() {
	*x = TwoOctetAsSpecificExtended{}
	mi := &file_attribute_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TwoOctetAsSpecificExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TwoOctetAsSpecificExtended) ProtoMessage() {}

func (x *TwoOctetAsSpecificExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TwoOctetAsSpecificExtended.ProtoReflect.Descriptor instead.
func (*TwoOctetAsSpecificExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{49}
}

func (x *TwoOctetAsSpecificExtended) GetIsTransitive() bool {
	if x != nil {
		return x.IsTransitive
	}
	return false
}

func (x *TwoOctetAsSpecificExtended) GetSubType() uint32 {
	if x != nil {
		return x.SubType
	}
	return 0
}

func (x *TwoOctetAsSpecificExtended) GetAsn() uint32 {
	if x != nil {
		return x.Asn
	}
	return 0
}

func (x *TwoOctetAsSpecificExtended) GetLocalAdmin() uint32 {
	if x != nil {
		return x.LocalAdmin
	}
	return 0
}

type IPv4AddressSpecificExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IsTransitive  bool                   `protobuf:"varint,1,opt,name=is_transitive,json=isTransitive,proto3" json:"is_transitive,omitempty"`
	SubType       uint32                 `protobuf:"varint,2,opt,name=sub_type,json=subType,proto3" json:"sub_type,omitempty"`
	Address       string                 `protobuf:"bytes,3,opt,name=address,proto3" json:"address,omitempty"`
	LocalAdmin    uint32                 `protobuf:"varint,4,opt,name=local_admin,json=localAdmin,proto3" json:"local_admin,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IPv4AddressSpecificExtended) Reset() {
	*x = IPv4AddressSpecificExtended{}
	mi := &file_attribute_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IPv4AddressSpecificExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IPv4AddressSpecificExtended) ProtoMessage() {}

func (x *IPv4AddressSpecificExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IPv4AddressSpecificExtended.ProtoReflect.Descriptor instead.
func (*IPv4AddressSpecificExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{50}
}

func (x *IPv4AddressSpecificExtended) GetIsTransitive() bool {
	if x != nil {
		return x.IsTransitive
	}
	return false
}

func (x *IPv4AddressSpecificExtended) GetSubType() uint32 {
	if x != nil {
		return x.SubType
	}
	return 0
}

func (x *IPv4AddressSpecificExtended) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *IPv4AddressSpecificExtended) GetLocalAdmin() uint32 {
	if x != nil {
		return x.LocalAdmin
	}
	return 0
}

type FourOctetAsSpecificExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IsTransitive  bool                   `protobuf:"varint,1,opt,name=is_transitive,json=isTransitive,proto3" json:"is_transitive,omitempty"`
	SubType       uint32                 `protobuf:"varint,2,opt,name=sub_type,json=subType,proto3" json:"sub_type,omitempty"`
	Asn           uint32                 `protobuf:"varint,3,opt,name=asn,proto3" json:"asn,omitempty"`
	LocalAdmin    uint32                 `protobuf:"varint,4,opt,name=local_admin,json=localAdmin,proto3" json:"local_admin,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FourOctetAsSpecificExtended) Reset() {
	*x = FourOctetAsSpecificExtended{}
	mi := &file_attribute_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FourOctetAsSpecificExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FourOctetAsSpecificExtended) ProtoMessage() {}

func (x *FourOctetAsSpecificExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FourOctetAsSpecificExtended.ProtoReflect.Descriptor instead.
func (*FourOctetAsSpecificExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{51}
}

func (x *FourOctetAsSpecificExtended) GetIsTransitive() bool {
	if x != nil {
		return x.IsTransitive
	}
	return false
}

func (x *FourOctetAsSpecificExtended) GetSubType() uint32 {
	if x != nil {
		return x.SubType
	}
	return 0
}

func (x *FourOctetAsSpecificExtended) GetAsn() uint32 {
	if x != nil {
		return x.Asn
	}
	return 0
}

func (x *FourOctetAsSpecificExtended) GetLocalAdmin() uint32 {
	if x != nil {
		return x.LocalAdmin
	}
	return 0
}

type LinkBandwidthExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Asn           uint32                 `protobuf:"varint,1,opt,name=asn,proto3" json:"asn,omitempty"`
	Bandwidth     float32                `protobuf:"fixed32,2,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LinkBandwidthExtended) Reset() {
	*x = LinkBandwidthExtended{}
	mi := &file_attribute_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinkBandwidthExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkBandwidthExtended) ProtoMessage() {}

func (x *LinkBandwidthExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkBandwidthExtended.ProtoReflect.Descriptor instead.
func (*LinkBandwidthExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{52}
}

func (x *LinkBandwidthExtended) GetAsn() uint32 {
	if x != nil {
		return x.Asn
	}
	return 0
}

func (x *LinkBandwidthExtended) GetBandwidth() float32 {
	if x != nil {
		return x.Bandwidth
	}
	return 0
}

type ValidationExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	State         uint32                 `protobuf:"varint,1,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidationExtended) Reset() {
	*x = ValidationExtended{}
	mi := &file_attribute_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidationExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationExtended) ProtoMessage() {}

func (x *ValidationExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationExtended.ProtoReflect.Descriptor instead.
func (*ValidationExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{53}
}

func (x *ValidationExtended) GetState() uint32 {
	if x != nil {
		return x.State
	}
	return 0
}

type ColorExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Color         uint32                 `protobuf:"varint,1,opt,name=color,proto3" json:"color,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ColorExtended) Reset() {
	*x = ColorExtended{}
	mi := &file_attribute_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ColorExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColorExtended) ProtoMessage() {}

func (x *ColorExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColorExtended.ProtoReflect.Descriptor instead.
func (*ColorExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{54}
}

func (x *ColorExtended) GetColor() uint32 {
	if x != nil {
		return x.Color
	}
	return 0
}

type EncapExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TunnelType    uint32                 `protobuf:"varint,1,opt,name=tunnel_type,json=tunnelType,proto3" json:"tunnel_type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EncapExtended) Reset() {
	*x = EncapExtended{}
	mi := &file_attribute_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EncapExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncapExtended) ProtoMessage() {}

func (x *EncapExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncapExtended.ProtoReflect.Descriptor instead.
func (*EncapExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{55}
}

func (x *EncapExtended) GetTunnelType() uint32 {
	if x != nil {
		return x.TunnelType
	}
	return 0
}

type DefaultGatewayExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DefaultGatewayExtended) Reset() {
	*x = DefaultGatewayExtended{}
	mi := &file_attribute_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DefaultGatewayExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultGatewayExtended) ProtoMessage() {}

func (x *DefaultGatewayExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultGatewayExtended.ProtoReflect.Descriptor instead.
func (*DefaultGatewayExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{56}
}

type OpaqueExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IsTransitive  bool                   `protobuf:"varint,1,opt,name=is_transitive,json=isTransitive,proto3" json:"is_transitive,omitempty"`
	Value         []byte                 `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpaqueExtended) Reset() {
	*x = OpaqueExtended{}
	mi := &file_attribute_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpaqueExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpaqueExtended) ProtoMessage() {}

func (x *OpaqueExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpaqueExtended.ProtoReflect.Descriptor instead.
func (*OpaqueExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{57}
}

func (x *OpaqueExtended) GetIsTransitive() bool {
	if x != nil {
		return x.IsTransitive
	}
	return false
}

func (x *OpaqueExtended) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type ESILabelExtended struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	IsSingleActive bool                   `protobuf:"varint,1,opt,name=is_single_active,json=isSingleActive,proto3" json:"is_single_active,omitempty"`
	Label          uint32                 `protobuf:"varint,2,opt,name=label,proto3" json:"label,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ESILabelExtended) Reset() {
	*x = ESILabelExtended{}
	mi := &file_attribute_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ESILabelExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ESILabelExtended) ProtoMessage() {}

func (x *ESILabelExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ESILabelExtended.ProtoReflect.Descriptor instead.
func (*ESILabelExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{58}
}

func (x *ESILabelExtended) GetIsSingleActive() bool {
	if x != nil {
		return x.IsSingleActive
	}
	return false
}

func (x *ESILabelExtended) GetLabel() uint32 {
	if x != nil {
		return x.Label
	}
	return 0
}

type ESImportRouteTarget struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	EsImport      string                 `protobuf:"bytes,1,opt,name=es_import,json=esImport,proto3" json:"es_import,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ESImportRouteTarget) Reset() {
	*x = ESImportRouteTarget{}
	mi := &file_attribute_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ESImportRouteTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ESImportRouteTarget) ProtoMessage() {}

func (x *ESImportRouteTarget) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ESImportRouteTarget.ProtoReflect.Descriptor instead.
func (*ESImportRouteTarget) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{59}
}

func (x *ESImportRouteTarget) GetEsImport() string {
	if x != nil {
		return x.EsImport
	}
	return ""
}

type MacMobilityExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IsSticky      bool                   `protobuf:"varint,1,opt,name=is_sticky,json=isSticky,proto3" json:"is_sticky,omitempty"`
	SequenceNum   uint32                 `protobuf:"varint,2,opt,name=sequence_num,json=sequenceNum,proto3" json:"sequence_num,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MacMobilityExtended) Reset() {
	*x = MacMobilityExtended{}
	mi := &file_attribute_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MacMobilityExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MacMobilityExtended) ProtoMessage() {}

func (x *MacMobilityExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MacMobilityExtended.ProtoReflect.Descriptor instead.
func (*MacMobilityExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{60}
}

func (x *MacMobilityExtended) GetIsSticky() bool {
	if x != nil {
		return x.IsSticky
	}
	return false
}

func (x *MacMobilityExtended) GetSequenceNum() uint32 {
	if x != nil {
		return x.SequenceNum
	}
	return 0
}

type RouterMacExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Mac           string                 `protobuf:"bytes,1,opt,name=mac,proto3" json:"mac,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RouterMacExtended) Reset() {
	*x = RouterMacExtended{}
	mi := &file_attribute_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RouterMacExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouterMacExtended) ProtoMessage() {}

func (x *RouterMacExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouterMacExtended.ProtoReflect.Descriptor instead.
func (*RouterMacExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{61}
}

func (x *RouterMacExtended) GetMac() string {
	if x != nil {
		return x.Mac
	}
	return ""
}

type TrafficRateExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Asn           uint32                 `protobuf:"varint,1,opt,name=asn,proto3" json:"asn,omitempty"`
	Rate          float32                `protobuf:"fixed32,2,opt,name=rate,proto3" json:"rate,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrafficRateExtended) Reset() {
	*x = TrafficRateExtended{}
	mi := &file_attribute_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficRateExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficRateExtended) ProtoMessage() {}

func (x *TrafficRateExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficRateExtended.ProtoReflect.Descriptor instead.
func (*TrafficRateExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{62}
}

func (x *TrafficRateExtended) GetAsn() uint32 {
	if x != nil {
		return x.Asn
	}
	return 0
}

func (x *TrafficRateExtended) GetRate() float32 {
	if x != nil {
		return x.Rate
	}
	return 0
}

type TrafficActionExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Terminal      bool                   `protobuf:"varint,1,opt,name=terminal,proto3" json:"terminal,omitempty"`
	Sample        bool                   `protobuf:"varint,2,opt,name=sample,proto3" json:"sample,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrafficActionExtended) Reset() {
	*x = TrafficActionExtended{}
	mi := &file_attribute_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficActionExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficActionExtended) ProtoMessage() {}

func (x *TrafficActionExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficActionExtended.ProtoReflect.Descriptor instead.
func (*TrafficActionExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{63}
}

func (x *TrafficActionExtended) GetTerminal() bool {
	if x != nil {
		return x.Terminal
	}
	return false
}

func (x *TrafficActionExtended) GetSample() bool {
	if x != nil {
		return x.Sample
	}
	return false
}

type RedirectTwoOctetAsSpecificExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Asn           uint32                 `protobuf:"varint,1,opt,name=asn,proto3" json:"asn,omitempty"`
	LocalAdmin    uint32                 `protobuf:"varint,2,opt,name=local_admin,json=localAdmin,proto3" json:"local_admin,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RedirectTwoOctetAsSpecificExtended) Reset() {
	*x = RedirectTwoOctetAsSpecificExtended{}
	mi := &file_attribute_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedirectTwoOctetAsSpecificExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedirectTwoOctetAsSpecificExtended) ProtoMessage() {}

func (x *RedirectTwoOctetAsSpecificExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedirectTwoOctetAsSpecificExtended.ProtoReflect.Descriptor instead.
func (*RedirectTwoOctetAsSpecificExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{64}
}

func (x *RedirectTwoOctetAsSpecificExtended) GetAsn() uint32 {
	if x != nil {
		return x.Asn
	}
	return 0
}

func (x *RedirectTwoOctetAsSpecificExtended) GetLocalAdmin() uint32 {
	if x != nil {
		return x.LocalAdmin
	}
	return 0
}

type RedirectIPv4AddressSpecificExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Address       string                 `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	LocalAdmin    uint32                 `protobuf:"varint,2,opt,name=local_admin,json=localAdmin,proto3" json:"local_admin,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RedirectIPv4AddressSpecificExtended) Reset() {
	*x = RedirectIPv4AddressSpecificExtended{}
	mi := &file_attribute_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedirectIPv4AddressSpecificExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedirectIPv4AddressSpecificExtended) ProtoMessage() {}

func (x *RedirectIPv4AddressSpecificExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedirectIPv4AddressSpecificExtended.ProtoReflect.Descriptor instead.
func (*RedirectIPv4AddressSpecificExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{65}
}

func (x *RedirectIPv4AddressSpecificExtended) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *RedirectIPv4AddressSpecificExtended) GetLocalAdmin() uint32 {
	if x != nil {
		return x.LocalAdmin
	}
	return 0
}

type RedirectFourOctetAsSpecificExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Asn           uint32                 `protobuf:"varint,1,opt,name=asn,proto3" json:"asn,omitempty"`
	LocalAdmin    uint32                 `protobuf:"varint,2,opt,name=local_admin,json=localAdmin,proto3" json:"local_admin,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RedirectFourOctetAsSpecificExtended) Reset() {
	*x = RedirectFourOctetAsSpecificExtended{}
	mi := &file_attribute_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedirectFourOctetAsSpecificExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedirectFourOctetAsSpecificExtended) ProtoMessage() {}

func (x *RedirectFourOctetAsSpecificExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedirectFourOctetAsSpecificExtended.ProtoReflect.Descriptor instead.
func (*RedirectFourOctetAsSpecificExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{66}
}

func (x *RedirectFourOctetAsSpecificExtended) GetAsn() uint32 {
	if x != nil {
		return x.Asn
	}
	return 0
}

func (x *RedirectFourOctetAsSpecificExtended) GetLocalAdmin() uint32 {
	if x != nil {
		return x.LocalAdmin
	}
	return 0
}

type TrafficRemarkExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Dscp          uint32                 `protobuf:"varint,1,opt,name=dscp,proto3" json:"dscp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrafficRemarkExtended) Reset() {
	*x = TrafficRemarkExtended{}
	mi := &file_attribute_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficRemarkExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficRemarkExtended) ProtoMessage() {}

func (x *TrafficRemarkExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficRemarkExtended.ProtoReflect.Descriptor instead.
func (*TrafficRemarkExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{67}
}

func (x *TrafficRemarkExtended) GetDscp() uint32 {
	if x != nil {
		return x.Dscp
	}
	return 0
}

type MUPExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	SubType       uint32                 `protobuf:"varint,1,opt,name=sub_type,json=subType,proto3" json:"sub_type,omitempty"`
	SegmentId2    uint32                 `protobuf:"varint,2,opt,name=segment_id2,json=segmentId2,proto3" json:"segment_id2,omitempty"`
	SegmentId4    uint32                 `protobuf:"varint,3,opt,name=segment_id4,json=segmentId4,proto3" json:"segment_id4,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MUPExtended) Reset() {
	*x = MUPExtended{}
	mi := &file_attribute_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MUPExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MUPExtended) ProtoMessage() {}

func (x *MUPExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MUPExtended.ProtoReflect.Descriptor instead.
func (*MUPExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{68}
}

func (x *MUPExtended) GetSubType() uint32 {
	if x != nil {
		return x.SubType
	}
	return 0
}

func (x *MUPExtended) GetSegmentId2() uint32 {
	if x != nil {
		return x.SegmentId2
	}
	return 0
}

func (x *MUPExtended) GetSegmentId4() uint32 {
	if x != nil {
		return x.SegmentId4
	}
	return 0
}

type VPLSExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ControlFlags  uint32                 `protobuf:"varint,1,opt,name=control_flags,json=controlFlags,proto3" json:"control_flags,omitempty"`
	Mtu           uint32                 `protobuf:"varint,2,opt,name=mtu,proto3" json:"mtu,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VPLSExtended) Reset() {
	*x = VPLSExtended{}
	mi := &file_attribute_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VPLSExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VPLSExtended) ProtoMessage() {}

func (x *VPLSExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VPLSExtended.ProtoReflect.Descriptor instead.
func (*VPLSExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{69}
}

func (x *VPLSExtended) GetControlFlags() uint32 {
	if x != nil {
		return x.ControlFlags
	}
	return 0
}

func (x *VPLSExtended) GetMtu() uint32 {
	if x != nil {
		return x.Mtu
	}
	return 0
}

type UnknownExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	Value         []byte                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UnknownExtended) Reset() {
	*x = UnknownExtended{}
	mi := &file_attribute_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UnknownExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnknownExtended) ProtoMessage() {}

func (x *UnknownExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnknownExtended.ProtoReflect.Descriptor instead.
func (*UnknownExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{70}
}

func (x *UnknownExtended) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *UnknownExtended) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type ExtendedCommunitiesAttribute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Each Community must be one of:
	// - TwoOctetAsSpecificExtended
	// - IPv4AddressSpecificExtended
	// - FourOctetAsSpecificExtended
	// - OpaqueExtended
	// - ESILabelExtended
	// - MacMobilityExtended
	// - RouterMacExtended
	// - TrafficRateExtended
	// - TrafficActionExtended
	// - RedirectTwoOctetAsSpecificExtended
	// - RedirectIPv4AddressSpecificExtended
	// - RedirectFourOctetAsSpecificExtended
	// - TrafficRemarkExtended
	// - MUPExtended
	// - VPLSExtended
	// - UnknownExtended
	Communities   []*anypb.Any `protobuf:"bytes,1,rep,name=communities,proto3" json:"communities,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExtendedCommunitiesAttribute) Reset() {
	*x = ExtendedCommunitiesAttribute{}
	mi := &file_attribute_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtendedCommunitiesAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtendedCommunitiesAttribute) ProtoMessage() {}

func (x *ExtendedCommunitiesAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtendedCommunitiesAttribute.ProtoReflect.Descriptor instead.
func (*ExtendedCommunitiesAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{71}
}

func (x *ExtendedCommunitiesAttribute) GetCommunities() []*anypb.Any {
	if x != nil {
		return x.Communities
	}
	return nil
}

type As4PathAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Segments      []*AsSegment           `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *As4PathAttribute) Reset() {
	*x = As4PathAttribute{}
	mi := &file_attribute_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *As4PathAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*As4PathAttribute) ProtoMessage() {}

func (x *As4PathAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use As4PathAttribute.ProtoReflect.Descriptor instead.
func (*As4PathAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{72}
}

func (x *As4PathAttribute) GetSegments() []*AsSegment {
	if x != nil {
		return x.Segments
	}
	return nil
}

type As4AggregatorAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Asn           uint32                 `protobuf:"varint,2,opt,name=asn,proto3" json:"asn,omitempty"`
	Address       string                 `protobuf:"bytes,3,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *As4AggregatorAttribute) Reset() {
	*x = As4AggregatorAttribute{}
	mi := &file_attribute_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *As4AggregatorAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*As4AggregatorAttribute) ProtoMessage() {}

func (x *As4AggregatorAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use As4AggregatorAttribute.ProtoReflect.Descriptor instead.
func (*As4AggregatorAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{73}
}

func (x *As4AggregatorAttribute) GetAsn() uint32 {
	if x != nil {
		return x.Asn
	}
	return 0
}

func (x *As4AggregatorAttribute) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type PmsiTunnelAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Flags         uint32                 `protobuf:"varint,1,opt,name=flags,proto3" json:"flags,omitempty"`
	Type          uint32                 `protobuf:"varint,2,opt,name=type,proto3" json:"type,omitempty"`
	Label         uint32                 `protobuf:"varint,3,opt,name=label,proto3" json:"label,omitempty"`
	Id            []byte                 `protobuf:"bytes,4,opt,name=id,proto3" json:"id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PmsiTunnelAttribute) Reset() {
	*x = PmsiTunnelAttribute{}
	mi := &file_attribute_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PmsiTunnelAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PmsiTunnelAttribute) ProtoMessage() {}

func (x *PmsiTunnelAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PmsiTunnelAttribute.ProtoReflect.Descriptor instead.
func (*PmsiTunnelAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{74}
}

func (x *PmsiTunnelAttribute) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *PmsiTunnelAttribute) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *PmsiTunnelAttribute) GetLabel() uint32 {
	if x != nil {
		return x.Label
	}
	return 0
}

func (x *PmsiTunnelAttribute) GetId() []byte {
	if x != nil {
		return x.Id
	}
	return nil
}

type TunnelEncapSubTLVEncapsulation struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           uint32                 `protobuf:"varint,1,opt,name=key,proto3" json:"key,omitempty"`
	Cookie        []byte                 `protobuf:"bytes,2,opt,name=cookie,proto3" json:"cookie,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVEncapsulation) Reset() {
	*x = TunnelEncapSubTLVEncapsulation{}
	mi := &file_attribute_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVEncapsulation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVEncapsulation) ProtoMessage() {}

func (x *TunnelEncapSubTLVEncapsulation) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVEncapsulation.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVEncapsulation) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{75}
}

func (x *TunnelEncapSubTLVEncapsulation) GetKey() uint32 {
	if x != nil {
		return x.Key
	}
	return 0
}

func (x *TunnelEncapSubTLVEncapsulation) GetCookie() []byte {
	if x != nil {
		return x.Cookie
	}
	return nil
}

type TunnelEncapSubTLVProtocol struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Protocol      uint32                 `protobuf:"varint,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVProtocol) Reset() {
	*x = TunnelEncapSubTLVProtocol{}
	mi := &file_attribute_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVProtocol) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVProtocol) ProtoMessage() {}

func (x *TunnelEncapSubTLVProtocol) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVProtocol.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVProtocol) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{76}
}

func (x *TunnelEncapSubTLVProtocol) GetProtocol() uint32 {
	if x != nil {
		return x.Protocol
	}
	return 0
}

type TunnelEncapSubTLVColor struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Color         uint32                 `protobuf:"varint,1,opt,name=color,proto3" json:"color,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVColor) Reset() {
	*x = TunnelEncapSubTLVColor{}
	mi := &file_attribute_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVColor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVColor) ProtoMessage() {}

func (x *TunnelEncapSubTLVColor) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVColor.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVColor) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{77}
}

func (x *TunnelEncapSubTLVColor) GetColor() uint32 {
	if x != nil {
		return x.Color
	}
	return 0
}

type TunnelEncapSubTLVSRPreference struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Flags         uint32                 `protobuf:"varint,1,opt,name=flags,proto3" json:"flags,omitempty"`
	Preference    uint32                 `protobuf:"varint,2,opt,name=preference,proto3" json:"preference,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVSRPreference) Reset() {
	*x = TunnelEncapSubTLVSRPreference{}
	mi := &file_attribute_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVSRPreference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVSRPreference) ProtoMessage() {}

func (x *TunnelEncapSubTLVSRPreference) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVSRPreference.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVSRPreference) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{78}
}

func (x *TunnelEncapSubTLVSRPreference) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *TunnelEncapSubTLVSRPreference) GetPreference() uint32 {
	if x != nil {
		return x.Preference
	}
	return 0
}

type TunnelEncapSubTLVSRCandidatePathName struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	CandidatePathName string                 `protobuf:"bytes,1,opt,name=candidate_path_name,json=candidatePathName,proto3" json:"candidate_path_name,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVSRCandidatePathName) Reset() {
	*x = TunnelEncapSubTLVSRCandidatePathName{}
	mi := &file_attribute_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVSRCandidatePathName) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVSRCandidatePathName) ProtoMessage() {}

func (x *TunnelEncapSubTLVSRCandidatePathName) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVSRCandidatePathName.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVSRCandidatePathName) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{79}
}

func (x *TunnelEncapSubTLVSRCandidatePathName) GetCandidatePathName() string {
	if x != nil {
		return x.CandidatePathName
	}
	return ""
}

type TunnelEncapSubTLVSRPriority struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Priority      uint32                 `protobuf:"varint,1,opt,name=priority,proto3" json:"priority,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVSRPriority) Reset() {
	*x = TunnelEncapSubTLVSRPriority{}
	mi := &file_attribute_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVSRPriority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVSRPriority) ProtoMessage() {}

func (x *TunnelEncapSubTLVSRPriority) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVSRPriority.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVSRPriority) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{80}
}

func (x *TunnelEncapSubTLVSRPriority) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

type TunnelEncapSubTLVSRBindingSID struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// bsid must be one of:
	// - SRBindingSID
	// - SRv6BindingSID
	Bsid          *anypb.Any `protobuf:"bytes,1,opt,name=bsid,proto3" json:"bsid,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVSRBindingSID) Reset() {
	*x = TunnelEncapSubTLVSRBindingSID{}
	mi := &file_attribute_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVSRBindingSID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVSRBindingSID) ProtoMessage() {}

func (x *TunnelEncapSubTLVSRBindingSID) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVSRBindingSID.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVSRBindingSID) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{81}
}

func (x *TunnelEncapSubTLVSRBindingSID) GetBsid() *anypb.Any {
	if x != nil {
		return x.Bsid
	}
	return nil
}

type SRBindingSID struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	SFlag         bool                   `protobuf:"varint,1,opt,name=s_flag,json=sFlag,proto3" json:"s_flag,omitempty"`
	IFlag         bool                   `protobuf:"varint,2,opt,name=i_flag,json=iFlag,proto3" json:"i_flag,omitempty"`
	Sid           []byte                 `protobuf:"bytes,3,opt,name=sid,proto3" json:"sid,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SRBindingSID) Reset() {
	*x = SRBindingSID{}
	mi := &file_attribute_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRBindingSID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRBindingSID) ProtoMessage() {}

func (x *SRBindingSID) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRBindingSID.ProtoReflect.Descriptor instead.
func (*SRBindingSID) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{82}
}

func (x *SRBindingSID) GetSFlag() bool {
	if x != nil {
		return x.SFlag
	}
	return false
}

func (x *SRBindingSID) GetIFlag() bool {
	if x != nil {
		return x.IFlag
	}
	return false
}

func (x *SRBindingSID) GetSid() []byte {
	if x != nil {
		return x.Sid
	}
	return nil
}

type SRv6EndPointBehavior struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Behavior      SRv6Behavior           `protobuf:"varint,1,opt,name=behavior,proto3,enum=apipb.SRv6Behavior" json:"behavior,omitempty"`
	BlockLen      uint32                 `protobuf:"varint,2,opt,name=block_len,json=blockLen,proto3" json:"block_len,omitempty"`
	NodeLen       uint32                 `protobuf:"varint,3,opt,name=node_len,json=nodeLen,proto3" json:"node_len,omitempty"`
	FuncLen       uint32                 `protobuf:"varint,4,opt,name=func_len,json=funcLen,proto3" json:"func_len,omitempty"`
	ArgLen        uint32                 `protobuf:"varint,5,opt,name=arg_len,json=argLen,proto3" json:"arg_len,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SRv6EndPointBehavior) Reset() {
	*x = SRv6EndPointBehavior{}
	mi := &file_attribute_proto_msgTypes[83]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRv6EndPointBehavior) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRv6EndPointBehavior) ProtoMessage() {}

func (x *SRv6EndPointBehavior) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[83]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRv6EndPointBehavior.ProtoReflect.Descriptor instead.
func (*SRv6EndPointBehavior) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{83}
}

func (x *SRv6EndPointBehavior) GetBehavior() SRv6Behavior {
	if x != nil {
		return x.Behavior
	}
	return SRv6Behavior_RESERVED
}

func (x *SRv6EndPointBehavior) GetBlockLen() uint32 {
	if x != nil {
		return x.BlockLen
	}
	return 0
}

func (x *SRv6EndPointBehavior) GetNodeLen() uint32 {
	if x != nil {
		return x.NodeLen
	}
	return 0
}

func (x *SRv6EndPointBehavior) GetFuncLen() uint32 {
	if x != nil {
		return x.FuncLen
	}
	return 0
}

func (x *SRv6EndPointBehavior) GetArgLen() uint32 {
	if x != nil {
		return x.ArgLen
	}
	return 0
}

type SRv6BindingSID struct {
	state                     protoimpl.MessageState `protogen:"open.v1"`
	SFlag                     bool                   `protobuf:"varint,1,opt,name=s_flag,json=sFlag,proto3" json:"s_flag,omitempty"`
	IFlag                     bool                   `protobuf:"varint,2,opt,name=i_flag,json=iFlag,proto3" json:"i_flag,omitempty"`
	BFlag                     bool                   `protobuf:"varint,3,opt,name=b_flag,json=bFlag,proto3" json:"b_flag,omitempty"`
	Sid                       []byte                 `protobuf:"bytes,4,opt,name=sid,proto3" json:"sid,omitempty"`
	EndpointBehaviorStructure *SRv6EndPointBehavior  `protobuf:"bytes,5,opt,name=endpoint_behavior_structure,json=endpointBehaviorStructure,proto3" json:"endpoint_behavior_structure,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *SRv6BindingSID) Reset() {
	*x = SRv6BindingSID{}
	mi := &file_attribute_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRv6BindingSID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRv6BindingSID) ProtoMessage() {}

func (x *SRv6BindingSID) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRv6BindingSID.ProtoReflect.Descriptor instead.
func (*SRv6BindingSID) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{84}
}

func (x *SRv6BindingSID) GetSFlag() bool {
	if x != nil {
		return x.SFlag
	}
	return false
}

func (x *SRv6BindingSID) GetIFlag() bool {
	if x != nil {
		return x.IFlag
	}
	return false
}

func (x *SRv6BindingSID) GetBFlag() bool {
	if x != nil {
		return x.BFlag
	}
	return false
}

func (x *SRv6BindingSID) GetSid() []byte {
	if x != nil {
		return x.Sid
	}
	return nil
}

func (x *SRv6BindingSID) GetEndpointBehaviorStructure() *SRv6EndPointBehavior {
	if x != nil {
		return x.EndpointBehaviorStructure
	}
	return nil
}

type TunnelEncapSubTLVSRENLP struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Flags         uint32                 `protobuf:"varint,1,opt,name=flags,proto3" json:"flags,omitempty"`
	Enlp          ENLPType               `protobuf:"varint,2,opt,name=enlp,proto3,enum=apipb.ENLPType" json:"enlp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVSRENLP) Reset() {
	*x = TunnelEncapSubTLVSRENLP{}
	mi := &file_attribute_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVSRENLP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVSRENLP) ProtoMessage() {}

func (x *TunnelEncapSubTLVSRENLP) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVSRENLP.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVSRENLP) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{85}
}

func (x *TunnelEncapSubTLVSRENLP) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *TunnelEncapSubTLVSRENLP) GetEnlp() ENLPType {
	if x != nil {
		return x.Enlp
	}
	return ENLPType_Reserved
}

type SRWeight struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Flags         uint32                 `protobuf:"varint,1,opt,name=flags,proto3" json:"flags,omitempty"`
	Weight        uint32                 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SRWeight) Reset() {
	*x = SRWeight{}
	mi := &file_attribute_proto_msgTypes[86]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRWeight) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRWeight) ProtoMessage() {}

func (x *SRWeight) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[86]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRWeight.ProtoReflect.Descriptor instead.
func (*SRWeight) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{86}
}

func (x *SRWeight) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *SRWeight) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

type SegmentFlags struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	VFlag         bool                   `protobuf:"varint,1,opt,name=v_flag,json=vFlag,proto3" json:"v_flag,omitempty"`
	AFlag         bool                   `protobuf:"varint,2,opt,name=a_flag,json=aFlag,proto3" json:"a_flag,omitempty"`
	SFlag         bool                   `protobuf:"varint,3,opt,name=s_flag,json=sFlag,proto3" json:"s_flag,omitempty"`
	BFlag         bool                   `protobuf:"varint,4,opt,name=b_flag,json=bFlag,proto3" json:"b_flag,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SegmentFlags) Reset() {
	*x = SegmentFlags{}
	mi := &file_attribute_proto_msgTypes[87]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SegmentFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentFlags) ProtoMessage() {}

func (x *SegmentFlags) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[87]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentFlags.ProtoReflect.Descriptor instead.
func (*SegmentFlags) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{87}
}

func (x *SegmentFlags) GetVFlag() bool {
	if x != nil {
		return x.VFlag
	}
	return false
}

func (x *SegmentFlags) GetAFlag() bool {
	if x != nil {
		return x.AFlag
	}
	return false
}

func (x *SegmentFlags) GetSFlag() bool {
	if x != nil {
		return x.SFlag
	}
	return false
}

func (x *SegmentFlags) GetBFlag() bool {
	if x != nil {
		return x.BFlag
	}
	return false
}

type SegmentTypeA struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Flags         *SegmentFlags          `protobuf:"bytes,1,opt,name=flags,proto3" json:"flags,omitempty"`
	Label         uint32                 `protobuf:"varint,2,opt,name=label,proto3" json:"label,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SegmentTypeA) Reset() {
	*x = SegmentTypeA{}
	mi := &file_attribute_proto_msgTypes[88]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SegmentTypeA) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentTypeA) ProtoMessage() {}

func (x *SegmentTypeA) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[88]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentTypeA.ProtoReflect.Descriptor instead.
func (*SegmentTypeA) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{88}
}

func (x *SegmentTypeA) GetFlags() *SegmentFlags {
	if x != nil {
		return x.Flags
	}
	return nil
}

func (x *SegmentTypeA) GetLabel() uint32 {
	if x != nil {
		return x.Label
	}
	return 0
}

type SegmentTypeB struct {
	state                     protoimpl.MessageState `protogen:"open.v1"`
	Flags                     *SegmentFlags          `protobuf:"bytes,1,opt,name=flags,proto3" json:"flags,omitempty"`
	Sid                       []byte                 `protobuf:"bytes,2,opt,name=sid,proto3" json:"sid,omitempty"`
	EndpointBehaviorStructure *SRv6EndPointBehavior  `protobuf:"bytes,3,opt,name=endpoint_behavior_structure,json=endpointBehaviorStructure,proto3" json:"endpoint_behavior_structure,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *SegmentTypeB) Reset() {
	*x = SegmentTypeB{}
	mi := &file_attribute_proto_msgTypes[89]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SegmentTypeB) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentTypeB) ProtoMessage() {}

func (x *SegmentTypeB) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[89]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentTypeB.ProtoReflect.Descriptor instead.
func (*SegmentTypeB) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{89}
}

func (x *SegmentTypeB) GetFlags() *SegmentFlags {
	if x != nil {
		return x.Flags
	}
	return nil
}

func (x *SegmentTypeB) GetSid() []byte {
	if x != nil {
		return x.Sid
	}
	return nil
}

func (x *SegmentTypeB) GetEndpointBehaviorStructure() *SRv6EndPointBehavior {
	if x != nil {
		return x.EndpointBehaviorStructure
	}
	return nil
}

type TunnelEncapSubTLVSRSegmentList struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	Weight *SRWeight              `protobuf:"bytes,1,opt,name=weight,proto3" json:"weight,omitempty"`
	// segments must be one of:
	// - SegmentTypeA
	// - SegmentTypeB
	Segments      []*anypb.Any `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVSRSegmentList) Reset() {
	*x = TunnelEncapSubTLVSRSegmentList{}
	mi := &file_attribute_proto_msgTypes[90]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVSRSegmentList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVSRSegmentList) ProtoMessage() {}

func (x *TunnelEncapSubTLVSRSegmentList) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[90]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVSRSegmentList.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVSRSegmentList) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{90}
}

func (x *TunnelEncapSubTLVSRSegmentList) GetWeight() *SRWeight {
	if x != nil {
		return x.Weight
	}
	return nil
}

func (x *TunnelEncapSubTLVSRSegmentList) GetSegments() []*anypb.Any {
	if x != nil {
		return x.Segments
	}
	return nil
}

type TunnelEncapSubTLVEgressEndpoint struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Address       string                 `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVEgressEndpoint) Reset() {
	*x = TunnelEncapSubTLVEgressEndpoint{}
	mi := &file_attribute_proto_msgTypes[91]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVEgressEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVEgressEndpoint) ProtoMessage() {}

func (x *TunnelEncapSubTLVEgressEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[91]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVEgressEndpoint.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVEgressEndpoint) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{91}
}

func (x *TunnelEncapSubTLVEgressEndpoint) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type TunnelEncapSubTLVUDPDestPort struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Port          uint32                 `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVUDPDestPort) Reset() {
	*x = TunnelEncapSubTLVUDPDestPort{}
	mi := &file_attribute_proto_msgTypes[92]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVUDPDestPort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVUDPDestPort) ProtoMessage() {}

func (x *TunnelEncapSubTLVUDPDestPort) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[92]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVUDPDestPort.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVUDPDestPort) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{92}
}

func (x *TunnelEncapSubTLVUDPDestPort) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

type TunnelEncapSubTLVUnknown struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	Value         []byte                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapSubTLVUnknown) Reset() {
	*x = TunnelEncapSubTLVUnknown{}
	mi := &file_attribute_proto_msgTypes[93]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapSubTLVUnknown) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapSubTLVUnknown) ProtoMessage() {}

func (x *TunnelEncapSubTLVUnknown) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[93]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapSubTLVUnknown.ProtoReflect.Descriptor instead.
func (*TunnelEncapSubTLVUnknown) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{93}
}

func (x *TunnelEncapSubTLVUnknown) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *TunnelEncapSubTLVUnknown) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type TunnelEncapTLV struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Type  uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	// Each TLV must be one of:
	// - TunnelEncapSubTLVEncapsulation
	// - TunnelEncapSubTLVProtocol
	// - TunnelEncapSubTLVColor
	// - TunnelEncapSubTLVSRPolicy
	// - TunnelEncapSubTLVUnknown
	Tlvs          []*anypb.Any `protobuf:"bytes,2,rep,name=tlvs,proto3" json:"tlvs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapTLV) Reset() {
	*x = TunnelEncapTLV{}
	mi := &file_attribute_proto_msgTypes[94]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapTLV) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapTLV) ProtoMessage() {}

func (x *TunnelEncapTLV) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[94]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapTLV.ProtoReflect.Descriptor instead.
func (*TunnelEncapTLV) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{94}
}

func (x *TunnelEncapTLV) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *TunnelEncapTLV) GetTlvs() []*anypb.Any {
	if x != nil {
		return x.Tlvs
	}
	return nil
}

type TunnelEncapAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Tlvs          []*TunnelEncapTLV      `protobuf:"bytes,1,rep,name=tlvs,proto3" json:"tlvs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TunnelEncapAttribute) Reset() {
	*x = TunnelEncapAttribute{}
	mi := &file_attribute_proto_msgTypes[95]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunnelEncapAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelEncapAttribute) ProtoMessage() {}

func (x *TunnelEncapAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[95]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelEncapAttribute.ProtoReflect.Descriptor instead.
func (*TunnelEncapAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{95}
}

func (x *TunnelEncapAttribute) GetTlvs() []*TunnelEncapTLV {
	if x != nil {
		return x.Tlvs
	}
	return nil
}

type IPv6AddressSpecificExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IsTransitive  bool                   `protobuf:"varint,1,opt,name=is_transitive,json=isTransitive,proto3" json:"is_transitive,omitempty"`
	SubType       uint32                 `protobuf:"varint,2,opt,name=sub_type,json=subType,proto3" json:"sub_type,omitempty"`
	Address       string                 `protobuf:"bytes,3,opt,name=address,proto3" json:"address,omitempty"`
	LocalAdmin    uint32                 `protobuf:"varint,4,opt,name=local_admin,json=localAdmin,proto3" json:"local_admin,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IPv6AddressSpecificExtended) Reset() {
	*x = IPv6AddressSpecificExtended{}
	mi := &file_attribute_proto_msgTypes[96]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IPv6AddressSpecificExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IPv6AddressSpecificExtended) ProtoMessage() {}

func (x *IPv6AddressSpecificExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[96]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IPv6AddressSpecificExtended.ProtoReflect.Descriptor instead.
func (*IPv6AddressSpecificExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{96}
}

func (x *IPv6AddressSpecificExtended) GetIsTransitive() bool {
	if x != nil {
		return x.IsTransitive
	}
	return false
}

func (x *IPv6AddressSpecificExtended) GetSubType() uint32 {
	if x != nil {
		return x.SubType
	}
	return 0
}

func (x *IPv6AddressSpecificExtended) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *IPv6AddressSpecificExtended) GetLocalAdmin() uint32 {
	if x != nil {
		return x.LocalAdmin
	}
	return 0
}

type RedirectIPv6AddressSpecificExtended struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Address       string                 `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	LocalAdmin    uint32                 `protobuf:"varint,2,opt,name=local_admin,json=localAdmin,proto3" json:"local_admin,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RedirectIPv6AddressSpecificExtended) Reset() {
	*x = RedirectIPv6AddressSpecificExtended{}
	mi := &file_attribute_proto_msgTypes[97]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedirectIPv6AddressSpecificExtended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedirectIPv6AddressSpecificExtended) ProtoMessage() {}

func (x *RedirectIPv6AddressSpecificExtended) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[97]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedirectIPv6AddressSpecificExtended.ProtoReflect.Descriptor instead.
func (*RedirectIPv6AddressSpecificExtended) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{97}
}

func (x *RedirectIPv6AddressSpecificExtended) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *RedirectIPv6AddressSpecificExtended) GetLocalAdmin() uint32 {
	if x != nil {
		return x.LocalAdmin
	}
	return 0
}

type IP6ExtendedCommunitiesAttribute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Each Community must be one of:
	// - IPv6AddressSpecificExtended
	// - RedirectIPv6AddressSpecificExtended
	Communities   []*anypb.Any `protobuf:"bytes,1,rep,name=communities,proto3" json:"communities,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IP6ExtendedCommunitiesAttribute) Reset() {
	*x = IP6ExtendedCommunitiesAttribute{}
	mi := &file_attribute_proto_msgTypes[98]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IP6ExtendedCommunitiesAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IP6ExtendedCommunitiesAttribute) ProtoMessage() {}

func (x *IP6ExtendedCommunitiesAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[98]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IP6ExtendedCommunitiesAttribute.ProtoReflect.Descriptor instead.
func (*IP6ExtendedCommunitiesAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{98}
}

func (x *IP6ExtendedCommunitiesAttribute) GetCommunities() []*anypb.Any {
	if x != nil {
		return x.Communities
	}
	return nil
}

type AigpTLVIGPMetric struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Metric        uint64                 `protobuf:"varint,1,opt,name=metric,proto3" json:"metric,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AigpTLVIGPMetric) Reset() {
	*x = AigpTLVIGPMetric{}
	mi := &file_attribute_proto_msgTypes[99]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AigpTLVIGPMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AigpTLVIGPMetric) ProtoMessage() {}

func (x *AigpTLVIGPMetric) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[99]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AigpTLVIGPMetric.ProtoReflect.Descriptor instead.
func (*AigpTLVIGPMetric) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{99}
}

func (x *AigpTLVIGPMetric) GetMetric() uint64 {
	if x != nil {
		return x.Metric
	}
	return 0
}

type AigpTLVUnknown struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	Value         []byte                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AigpTLVUnknown) Reset() {
	*x = AigpTLVUnknown{}
	mi := &file_attribute_proto_msgTypes[100]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AigpTLVUnknown) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AigpTLVUnknown) ProtoMessage() {}

func (x *AigpTLVUnknown) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[100]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AigpTLVUnknown.ProtoReflect.Descriptor instead.
func (*AigpTLVUnknown) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{100}
}

func (x *AigpTLVUnknown) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *AigpTLVUnknown) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type AigpAttribute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Each TLV must be one of:
	// - AigpTLVIGPMetric
	// - AigpTLVUnknown
	Tlvs          []*anypb.Any `protobuf:"bytes,1,rep,name=tlvs,proto3" json:"tlvs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AigpAttribute) Reset() {
	*x = AigpAttribute{}
	mi := &file_attribute_proto_msgTypes[101]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AigpAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AigpAttribute) ProtoMessage() {}

func (x *AigpAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[101]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AigpAttribute.ProtoReflect.Descriptor instead.
func (*AigpAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{101}
}

func (x *AigpAttribute) GetTlvs() []*anypb.Any {
	if x != nil {
		return x.Tlvs
	}
	return nil
}

type LargeCommunity struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GlobalAdmin   uint32                 `protobuf:"varint,1,opt,name=global_admin,json=globalAdmin,proto3" json:"global_admin,omitempty"`
	LocalData1    uint32                 `protobuf:"varint,2,opt,name=local_data1,json=localData1,proto3" json:"local_data1,omitempty"`
	LocalData2    uint32                 `protobuf:"varint,3,opt,name=local_data2,json=localData2,proto3" json:"local_data2,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LargeCommunity) Reset() {
	*x = LargeCommunity{}
	mi := &file_attribute_proto_msgTypes[102]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LargeCommunity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LargeCommunity) ProtoMessage() {}

func (x *LargeCommunity) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[102]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LargeCommunity.ProtoReflect.Descriptor instead.
func (*LargeCommunity) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{102}
}

func (x *LargeCommunity) GetGlobalAdmin() uint32 {
	if x != nil {
		return x.GlobalAdmin
	}
	return 0
}

func (x *LargeCommunity) GetLocalData1() uint32 {
	if x != nil {
		return x.LocalData1
	}
	return 0
}

func (x *LargeCommunity) GetLocalData2() uint32 {
	if x != nil {
		return x.LocalData2
	}
	return 0
}

type LargeCommunitiesAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Communities   []*LargeCommunity      `protobuf:"bytes,1,rep,name=communities,proto3" json:"communities,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LargeCommunitiesAttribute) Reset() {
	*x = LargeCommunitiesAttribute{}
	mi := &file_attribute_proto_msgTypes[103]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LargeCommunitiesAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LargeCommunitiesAttribute) ProtoMessage() {}

func (x *LargeCommunitiesAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[103]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LargeCommunitiesAttribute.ProtoReflect.Descriptor instead.
func (*LargeCommunitiesAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{103}
}

func (x *LargeCommunitiesAttribute) GetCommunities() []*LargeCommunity {
	if x != nil {
		return x.Communities
	}
	return nil
}

type LsNodeFlags struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Overload      bool                   `protobuf:"varint,1,opt,name=overload,proto3" json:"overload,omitempty"`
	Attached      bool                   `protobuf:"varint,2,opt,name=attached,proto3" json:"attached,omitempty"`
	External      bool                   `protobuf:"varint,3,opt,name=external,proto3" json:"external,omitempty"`
	Abr           bool                   `protobuf:"varint,4,opt,name=abr,proto3" json:"abr,omitempty"`
	Router        bool                   `protobuf:"varint,5,opt,name=router,proto3" json:"router,omitempty"`
	V6            bool                   `protobuf:"varint,6,opt,name=v6,proto3" json:"v6,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LsNodeFlags) Reset() {
	*x = LsNodeFlags{}
	mi := &file_attribute_proto_msgTypes[104]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsNodeFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsNodeFlags) ProtoMessage() {}

func (x *LsNodeFlags) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[104]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsNodeFlags.ProtoReflect.Descriptor instead.
func (*LsNodeFlags) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{104}
}

func (x *LsNodeFlags) GetOverload() bool {
	if x != nil {
		return x.Overload
	}
	return false
}

func (x *LsNodeFlags) GetAttached() bool {
	if x != nil {
		return x.Attached
	}
	return false
}

func (x *LsNodeFlags) GetExternal() bool {
	if x != nil {
		return x.External
	}
	return false
}

func (x *LsNodeFlags) GetAbr() bool {
	if x != nil {
		return x.Abr
	}
	return false
}

func (x *LsNodeFlags) GetRouter() bool {
	if x != nil {
		return x.Router
	}
	return false
}

func (x *LsNodeFlags) GetV6() bool {
	if x != nil {
		return x.V6
	}
	return false
}

type LsIGPFlags struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Down          bool                   `protobuf:"varint,1,opt,name=down,proto3" json:"down,omitempty"`
	NoUnicast     bool                   `protobuf:"varint,2,opt,name=no_unicast,json=noUnicast,proto3" json:"no_unicast,omitempty"`
	LocalAddress  bool                   `protobuf:"varint,3,opt,name=local_address,json=localAddress,proto3" json:"local_address,omitempty"`
	PropagateNssa bool                   `protobuf:"varint,4,opt,name=propagate_nssa,json=propagateNssa,proto3" json:"propagate_nssa,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LsIGPFlags) Reset() {
	*x = LsIGPFlags{}
	mi := &file_attribute_proto_msgTypes[105]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsIGPFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsIGPFlags) ProtoMessage() {}

func (x *LsIGPFlags) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[105]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsIGPFlags.ProtoReflect.Descriptor instead.
func (*LsIGPFlags) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{105}
}

func (x *LsIGPFlags) GetDown() bool {
	if x != nil {
		return x.Down
	}
	return false
}

func (x *LsIGPFlags) GetNoUnicast() bool {
	if x != nil {
		return x.NoUnicast
	}
	return false
}

func (x *LsIGPFlags) GetLocalAddress() bool {
	if x != nil {
		return x.LocalAddress
	}
	return false
}

func (x *LsIGPFlags) GetPropagateNssa() bool {
	if x != nil {
		return x.PropagateNssa
	}
	return false
}

type LsSrRange struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Begin         uint32                 `protobuf:"varint,1,opt,name=begin,proto3" json:"begin,omitempty"`
	End           uint32                 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LsSrRange) Reset() {
	*x = LsSrRange{}
	mi := &file_attribute_proto_msgTypes[106]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsSrRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsSrRange) ProtoMessage() {}

func (x *LsSrRange) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[106]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsSrRange.ProtoReflect.Descriptor instead.
func (*LsSrRange) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{106}
}

func (x *LsSrRange) GetBegin() uint32 {
	if x != nil {
		return x.Begin
	}
	return 0
}

func (x *LsSrRange) GetEnd() uint32 {
	if x != nil {
		return x.End
	}
	return 0
}

type LsSrCapabilities struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Ipv4Supported bool                   `protobuf:"varint,1,opt,name=ipv4_supported,json=ipv4Supported,proto3" json:"ipv4_supported,omitempty"`
	Ipv6Supported bool                   `protobuf:"varint,2,opt,name=ipv6_supported,json=ipv6Supported,proto3" json:"ipv6_supported,omitempty"`
	Ranges        []*LsSrRange           `protobuf:"bytes,3,rep,name=ranges,proto3" json:"ranges,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LsSrCapabilities) Reset() {
	*x = LsSrCapabilities{}
	mi := &file_attribute_proto_msgTypes[107]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsSrCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsSrCapabilities) ProtoMessage() {}

func (x *LsSrCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[107]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsSrCapabilities.ProtoReflect.Descriptor instead.
func (*LsSrCapabilities) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{107}
}

func (x *LsSrCapabilities) GetIpv4Supported() bool {
	if x != nil {
		return x.Ipv4Supported
	}
	return false
}

func (x *LsSrCapabilities) GetIpv6Supported() bool {
	if x != nil {
		return x.Ipv6Supported
	}
	return false
}

func (x *LsSrCapabilities) GetRanges() []*LsSrRange {
	if x != nil {
		return x.Ranges
	}
	return nil
}

type LsSrLocalBlock struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Ranges        []*LsSrRange           `protobuf:"bytes,1,rep,name=ranges,proto3" json:"ranges,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LsSrLocalBlock) Reset() {
	*x = LsSrLocalBlock{}
	mi := &file_attribute_proto_msgTypes[108]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsSrLocalBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsSrLocalBlock) ProtoMessage() {}

func (x *LsSrLocalBlock) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[108]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsSrLocalBlock.ProtoReflect.Descriptor instead.
func (*LsSrLocalBlock) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{108}
}

func (x *LsSrLocalBlock) GetRanges() []*LsSrRange {
	if x != nil {
		return x.Ranges
	}
	return nil
}

type LsAttributeNode struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	Name            string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Flags           *LsNodeFlags           `protobuf:"bytes,2,opt,name=flags,proto3" json:"flags,omitempty"`
	LocalRouterId   string                 `protobuf:"bytes,3,opt,name=local_router_id,json=localRouterId,proto3" json:"local_router_id,omitempty"`
	LocalRouterIdV6 string                 `protobuf:"bytes,4,opt,name=local_router_id_v6,json=localRouterIdV6,proto3" json:"local_router_id_v6,omitempty"`
	IsisArea        []byte                 `protobuf:"bytes,5,opt,name=isis_area,json=isisArea,proto3" json:"isis_area,omitempty"`
	Opaque          []byte                 `protobuf:"bytes,6,opt,name=opaque,proto3" json:"opaque,omitempty"`
	SrCapabilities  *LsSrCapabilities      `protobuf:"bytes,7,opt,name=sr_capabilities,json=srCapabilities,proto3" json:"sr_capabilities,omitempty"`
	SrAlgorithms    []byte                 `protobuf:"bytes,8,opt,name=sr_algorithms,json=srAlgorithms,proto3" json:"sr_algorithms,omitempty"`
	SrLocalBlock    *LsSrLocalBlock        `protobuf:"bytes,9,opt,name=sr_local_block,json=srLocalBlock,proto3" json:"sr_local_block,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *LsAttributeNode) Reset() {
	*x = LsAttributeNode{}
	mi := &file_attribute_proto_msgTypes[109]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsAttributeNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsAttributeNode) ProtoMessage() {}

func (x *LsAttributeNode) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[109]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsAttributeNode.ProtoReflect.Descriptor instead.
func (*LsAttributeNode) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{109}
}

func (x *LsAttributeNode) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LsAttributeNode) GetFlags() *LsNodeFlags {
	if x != nil {
		return x.Flags
	}
	return nil
}

func (x *LsAttributeNode) GetLocalRouterId() string {
	if x != nil {
		return x.LocalRouterId
	}
	return ""
}

func (x *LsAttributeNode) GetLocalRouterIdV6() string {
	if x != nil {
		return x.LocalRouterIdV6
	}
	return ""
}

func (x *LsAttributeNode) GetIsisArea() []byte {
	if x != nil {
		return x.IsisArea
	}
	return nil
}

func (x *LsAttributeNode) GetOpaque() []byte {
	if x != nil {
		return x.Opaque
	}
	return nil
}

func (x *LsAttributeNode) GetSrCapabilities() *LsSrCapabilities {
	if x != nil {
		return x.SrCapabilities
	}
	return nil
}

func (x *LsAttributeNode) GetSrAlgorithms() []byte {
	if x != nil {
		return x.SrAlgorithms
	}
	return nil
}

func (x *LsAttributeNode) GetSrLocalBlock() *LsSrLocalBlock {
	if x != nil {
		return x.SrLocalBlock
	}
	return nil
}

type LsAttributeLink struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	Name                string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	LocalRouterId       string                 `protobuf:"bytes,2,opt,name=local_router_id,json=localRouterId,proto3" json:"local_router_id,omitempty"`
	LocalRouterIdV6     string                 `protobuf:"bytes,3,opt,name=local_router_id_v6,json=localRouterIdV6,proto3" json:"local_router_id_v6,omitempty"`
	RemoteRouterId      string                 `protobuf:"bytes,4,opt,name=remote_router_id,json=remoteRouterId,proto3" json:"remote_router_id,omitempty"`
	RemoteRouterIdV6    string                 `protobuf:"bytes,5,opt,name=remote_router_id_v6,json=remoteRouterIdV6,proto3" json:"remote_router_id_v6,omitempty"`
	AdminGroup          uint32                 `protobuf:"varint,6,opt,name=admin_group,json=adminGroup,proto3" json:"admin_group,omitempty"`
	DefaultTeMetric     uint32                 `protobuf:"varint,7,opt,name=default_te_metric,json=defaultTeMetric,proto3" json:"default_te_metric,omitempty"`
	IgpMetric           uint32                 `protobuf:"varint,8,opt,name=igp_metric,json=igpMetric,proto3" json:"igp_metric,omitempty"`
	Opaque              []byte                 `protobuf:"bytes,9,opt,name=opaque,proto3" json:"opaque,omitempty"`
	Bandwidth           float32                `protobuf:"fixed32,10,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	ReservableBandwidth float32                `protobuf:"fixed32,11,opt,name=reservable_bandwidth,json=reservableBandwidth,proto3" json:"reservable_bandwidth,omitempty"`
	UnreservedBandwidth []float32              `protobuf:"fixed32,12,rep,packed,name=unreserved_bandwidth,json=unreservedBandwidth,proto3" json:"unreserved_bandwidth,omitempty"`
	SrAdjacencySid      uint32                 `protobuf:"varint,13,opt,name=sr_adjacency_sid,json=srAdjacencySid,proto3" json:"sr_adjacency_sid,omitempty"`
	Srlgs               []uint32               `protobuf:"varint,14,rep,packed,name=srlgs,proto3" json:"srlgs,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *LsAttributeLink) Reset() {
	*x = LsAttributeLink{}
	mi := &file_attribute_proto_msgTypes[110]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsAttributeLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsAttributeLink) ProtoMessage() {}

func (x *LsAttributeLink) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[110]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsAttributeLink.ProtoReflect.Descriptor instead.
func (*LsAttributeLink) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{110}
}

func (x *LsAttributeLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LsAttributeLink) GetLocalRouterId() string {
	if x != nil {
		return x.LocalRouterId
	}
	return ""
}

func (x *LsAttributeLink) GetLocalRouterIdV6() string {
	if x != nil {
		return x.LocalRouterIdV6
	}
	return ""
}

func (x *LsAttributeLink) GetRemoteRouterId() string {
	if x != nil {
		return x.RemoteRouterId
	}
	return ""
}

func (x *LsAttributeLink) GetRemoteRouterIdV6() string {
	if x != nil {
		return x.RemoteRouterIdV6
	}
	return ""
}

func (x *LsAttributeLink) GetAdminGroup() uint32 {
	if x != nil {
		return x.AdminGroup
	}
	return 0
}

func (x *LsAttributeLink) GetDefaultTeMetric() uint32 {
	if x != nil {
		return x.DefaultTeMetric
	}
	return 0
}

func (x *LsAttributeLink) GetIgpMetric() uint32 {
	if x != nil {
		return x.IgpMetric
	}
	return 0
}

func (x *LsAttributeLink) GetOpaque() []byte {
	if x != nil {
		return x.Opaque
	}
	return nil
}

func (x *LsAttributeLink) GetBandwidth() float32 {
	if x != nil {
		return x.Bandwidth
	}
	return 0
}

func (x *LsAttributeLink) GetReservableBandwidth() float32 {
	if x != nil {
		return x.ReservableBandwidth
	}
	return 0
}

func (x *LsAttributeLink) GetUnreservedBandwidth() []float32 {
	if x != nil {
		return x.UnreservedBandwidth
	}
	return nil
}

func (x *LsAttributeLink) GetSrAdjacencySid() uint32 {
	if x != nil {
		return x.SrAdjacencySid
	}
	return 0
}

func (x *LsAttributeLink) GetSrlgs() []uint32 {
	if x != nil {
		return x.Srlgs
	}
	return nil
}

type LsAttributePrefix struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IgpFlags      *LsIGPFlags            `protobuf:"bytes,1,opt,name=igp_flags,json=igpFlags,proto3" json:"igp_flags,omitempty"`
	Opaque        []byte                 `protobuf:"bytes,2,opt,name=opaque,proto3" json:"opaque,omitempty"`
	SrPrefixSid   uint32                 `protobuf:"varint,3,opt,name=sr_prefix_sid,json=srPrefixSid,proto3" json:"sr_prefix_sid,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LsAttributePrefix) Reset() {
	*x = LsAttributePrefix{}
	mi := &file_attribute_proto_msgTypes[111]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsAttributePrefix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsAttributePrefix) ProtoMessage() {}

func (x *LsAttributePrefix) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[111]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsAttributePrefix.ProtoReflect.Descriptor instead.
func (*LsAttributePrefix) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{111}
}

func (x *LsAttributePrefix) GetIgpFlags() *LsIGPFlags {
	if x != nil {
		return x.IgpFlags
	}
	return nil
}

func (x *LsAttributePrefix) GetOpaque() []byte {
	if x != nil {
		return x.Opaque
	}
	return nil
}

func (x *LsAttributePrefix) GetSrPrefixSid() uint32 {
	if x != nil {
		return x.SrPrefixSid
	}
	return 0
}

type LsBgpPeerSegmentSIDFlags struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Value         bool                   `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	Local         bool                   `protobuf:"varint,2,opt,name=local,proto3" json:"local,omitempty"`
	Backup        bool                   `protobuf:"varint,3,opt,name=backup,proto3" json:"backup,omitempty"`
	Persistent    bool                   `protobuf:"varint,4,opt,name=persistent,proto3" json:"persistent,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LsBgpPeerSegmentSIDFlags) Reset() {
	*x = LsBgpPeerSegmentSIDFlags{}
	mi := &file_attribute_proto_msgTypes[112]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsBgpPeerSegmentSIDFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsBgpPeerSegmentSIDFlags) ProtoMessage() {}

func (x *LsBgpPeerSegmentSIDFlags) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[112]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsBgpPeerSegmentSIDFlags.ProtoReflect.Descriptor instead.
func (*LsBgpPeerSegmentSIDFlags) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{112}
}

func (x *LsBgpPeerSegmentSIDFlags) GetValue() bool {
	if x != nil {
		return x.Value
	}
	return false
}

func (x *LsBgpPeerSegmentSIDFlags) GetLocal() bool {
	if x != nil {
		return x.Local
	}
	return false
}

func (x *LsBgpPeerSegmentSIDFlags) GetBackup() bool {
	if x != nil {
		return x.Backup
	}
	return false
}

func (x *LsBgpPeerSegmentSIDFlags) GetPersistent() bool {
	if x != nil {
		return x.Persistent
	}
	return false
}

type LsBgpPeerSegmentSID struct {
	state         protoimpl.MessageState    `protogen:"open.v1"`
	Flags         *LsBgpPeerSegmentSIDFlags `protobuf:"bytes,1,opt,name=flags,proto3" json:"flags,omitempty"`
	Weight        uint32                    `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	Sid           uint32                    `protobuf:"varint,3,opt,name=sid,proto3" json:"sid,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LsBgpPeerSegmentSID) Reset() {
	*x = LsBgpPeerSegmentSID{}
	mi := &file_attribute_proto_msgTypes[113]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsBgpPeerSegmentSID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsBgpPeerSegmentSID) ProtoMessage() {}

func (x *LsBgpPeerSegmentSID) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[113]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsBgpPeerSegmentSID.ProtoReflect.Descriptor instead.
func (*LsBgpPeerSegmentSID) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{113}
}

func (x *LsBgpPeerSegmentSID) GetFlags() *LsBgpPeerSegmentSIDFlags {
	if x != nil {
		return x.Flags
	}
	return nil
}

func (x *LsBgpPeerSegmentSID) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *LsBgpPeerSegmentSID) GetSid() uint32 {
	if x != nil {
		return x.Sid
	}
	return 0
}

type LsAttributeBgpPeerSegment struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	BgpPeerNodeSid      *LsBgpPeerSegmentSID   `protobuf:"bytes,1,opt,name=bgp_peer_node_sid,json=bgpPeerNodeSid,proto3" json:"bgp_peer_node_sid,omitempty"`
	BgpPeerAdjacencySid *LsBgpPeerSegmentSID   `protobuf:"bytes,2,opt,name=bgp_peer_adjacency_sid,json=bgpPeerAdjacencySid,proto3" json:"bgp_peer_adjacency_sid,omitempty"`
	BgpPeerSetSid       *LsBgpPeerSegmentSID   `protobuf:"bytes,3,opt,name=bgp_peer_set_sid,json=bgpPeerSetSid,proto3" json:"bgp_peer_set_sid,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *LsAttributeBgpPeerSegment) Reset() {
	*x = LsAttributeBgpPeerSegment{}
	mi := &file_attribute_proto_msgTypes[114]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsAttributeBgpPeerSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsAttributeBgpPeerSegment) ProtoMessage() {}

func (x *LsAttributeBgpPeerSegment) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[114]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsAttributeBgpPeerSegment.ProtoReflect.Descriptor instead.
func (*LsAttributeBgpPeerSegment) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{114}
}

func (x *LsAttributeBgpPeerSegment) GetBgpPeerNodeSid() *LsBgpPeerSegmentSID {
	if x != nil {
		return x.BgpPeerNodeSid
	}
	return nil
}

func (x *LsAttributeBgpPeerSegment) GetBgpPeerAdjacencySid() *LsBgpPeerSegmentSID {
	if x != nil {
		return x.BgpPeerAdjacencySid
	}
	return nil
}

func (x *LsAttributeBgpPeerSegment) GetBgpPeerSetSid() *LsBgpPeerSegmentSID {
	if x != nil {
		return x.BgpPeerSetSid
	}
	return nil
}

type LsAttribute struct {
	state          protoimpl.MessageState     `protogen:"open.v1"`
	Node           *LsAttributeNode           `protobuf:"bytes,1,opt,name=node,proto3" json:"node,omitempty"`
	Link           *LsAttributeLink           `protobuf:"bytes,2,opt,name=link,proto3" json:"link,omitempty"`
	Prefix         *LsAttributePrefix         `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
	BgpPeerSegment *LsAttributeBgpPeerSegment `protobuf:"bytes,4,opt,name=bgp_peer_segment,json=bgpPeerSegment,proto3" json:"bgp_peer_segment,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *LsAttribute) Reset() {
	*x = LsAttribute{}
	mi := &file_attribute_proto_msgTypes[115]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LsAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LsAttribute) ProtoMessage() {}

func (x *LsAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[115]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LsAttribute.ProtoReflect.Descriptor instead.
func (*LsAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{115}
}

func (x *LsAttribute) GetNode() *LsAttributeNode {
	if x != nil {
		return x.Node
	}
	return nil
}

func (x *LsAttribute) GetLink() *LsAttributeLink {
	if x != nil {
		return x.Link
	}
	return nil
}

func (x *LsAttribute) GetPrefix() *LsAttributePrefix {
	if x != nil {
		return x.Prefix
	}
	return nil
}

func (x *LsAttribute) GetBgpPeerSegment() *LsAttributeBgpPeerSegment {
	if x != nil {
		return x.BgpPeerSegment
	}
	return nil
}

type UnknownAttribute struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Flags         uint32                 `protobuf:"varint,1,opt,name=flags,proto3" json:"flags,omitempty"`
	Type          uint32                 `protobuf:"varint,2,opt,name=type,proto3" json:"type,omitempty"`
	Value         []byte                 `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UnknownAttribute) Reset() {
	*x = UnknownAttribute{}
	mi := &file_attribute_proto_msgTypes[116]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UnknownAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnknownAttribute) ProtoMessage() {}

func (x *UnknownAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[116]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnknownAttribute.ProtoReflect.Descriptor instead.
func (*UnknownAttribute) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{116}
}

func (x *UnknownAttribute) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *UnknownAttribute) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *UnknownAttribute) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// https://www.rfc-editor.org/rfc/rfc9252.html#section-3.2.1
type SRv6StructureSubSubTLV struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	LocatorBlockLength  uint32                 `protobuf:"varint,1,opt,name=locator_block_length,json=locatorBlockLength,proto3" json:"locator_block_length,omitempty"`
	LocatorNodeLength   uint32                 `protobuf:"varint,2,opt,name=locator_node_length,json=locatorNodeLength,proto3" json:"locator_node_length,omitempty"`
	FunctionLength      uint32                 `protobuf:"varint,3,opt,name=function_length,json=functionLength,proto3" json:"function_length,omitempty"`
	ArgumentLength      uint32                 `protobuf:"varint,4,opt,name=argument_length,json=argumentLength,proto3" json:"argument_length,omitempty"`
	TranspositionLength uint32                 `protobuf:"varint,5,opt,name=transposition_length,json=transpositionLength,proto3" json:"transposition_length,omitempty"`
	TranspositionOffset uint32                 `protobuf:"varint,6,opt,name=transposition_offset,json=transpositionOffset,proto3" json:"transposition_offset,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *SRv6StructureSubSubTLV) Reset() {
	*x = SRv6StructureSubSubTLV{}
	mi := &file_attribute_proto_msgTypes[117]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRv6StructureSubSubTLV) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRv6StructureSubSubTLV) ProtoMessage() {}

func (x *SRv6StructureSubSubTLV) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[117]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRv6StructureSubSubTLV.ProtoReflect.Descriptor instead.
func (*SRv6StructureSubSubTLV) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{117}
}

func (x *SRv6StructureSubSubTLV) GetLocatorBlockLength() uint32 {
	if x != nil {
		return x.LocatorBlockLength
	}
	return 0
}

func (x *SRv6StructureSubSubTLV) GetLocatorNodeLength() uint32 {
	if x != nil {
		return x.LocatorNodeLength
	}
	return 0
}

func (x *SRv6StructureSubSubTLV) GetFunctionLength() uint32 {
	if x != nil {
		return x.FunctionLength
	}
	return 0
}

func (x *SRv6StructureSubSubTLV) GetArgumentLength() uint32 {
	if x != nil {
		return x.ArgumentLength
	}
	return 0
}

func (x *SRv6StructureSubSubTLV) GetTranspositionLength() uint32 {
	if x != nil {
		return x.TranspositionLength
	}
	return 0
}

func (x *SRv6StructureSubSubTLV) GetTranspositionOffset() uint32 {
	if x != nil {
		return x.TranspositionOffset
	}
	return 0
}

type SRv6SIDFlags struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Placeholder for future sid flags
	Flag_1        bool `protobuf:"varint,1,opt,name=flag_1,json=flag1,proto3" json:"flag_1,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SRv6SIDFlags) Reset() {
	*x = SRv6SIDFlags{}
	mi := &file_attribute_proto_msgTypes[118]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRv6SIDFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRv6SIDFlags) ProtoMessage() {}

func (x *SRv6SIDFlags) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[118]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRv6SIDFlags.ProtoReflect.Descriptor instead.
func (*SRv6SIDFlags) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{118}
}

func (x *SRv6SIDFlags) GetFlag_1() bool {
	if x != nil {
		return x.Flag_1
	}
	return false
}

type SRv6TLV struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Tlv           []*anypb.Any           `protobuf:"bytes,1,rep,name=tlv,proto3" json:"tlv,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SRv6TLV) Reset() {
	*x = SRv6TLV{}
	mi := &file_attribute_proto_msgTypes[119]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRv6TLV) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRv6TLV) ProtoMessage() {}

func (x *SRv6TLV) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[119]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRv6TLV.ProtoReflect.Descriptor instead.
func (*SRv6TLV) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{119}
}

func (x *SRv6TLV) GetTlv() []*anypb.Any {
	if x != nil {
		return x.Tlv
	}
	return nil
}

// https://tools.ietf.org/html/draft-dawra-bess-srv6-services-02#section-2.1.1
type SRv6InformationSubTLV struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	Sid              []byte                 `protobuf:"bytes,1,opt,name=sid,proto3" json:"sid,omitempty"`
	Flags            *SRv6SIDFlags          `protobuf:"bytes,2,opt,name=flags,proto3" json:"flags,omitempty"`
	EndpointBehavior uint32                 `protobuf:"varint,3,opt,name=endpoint_behavior,json=endpointBehavior,proto3" json:"endpoint_behavior,omitempty"`
	// SRv6TLV is one of:
	// - SRv6StructureSubSubTLV
	SubSubTlvs    map[uint32]*SRv6TLV `protobuf:"bytes,4,rep,name=sub_sub_tlvs,json=subSubTlvs,proto3" json:"sub_sub_tlvs,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SRv6InformationSubTLV) Reset() {
	*x = SRv6InformationSubTLV{}
	mi := &file_attribute_proto_msgTypes[120]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRv6InformationSubTLV) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRv6InformationSubTLV) ProtoMessage() {}

func (x *SRv6InformationSubTLV) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[120]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRv6InformationSubTLV.ProtoReflect.Descriptor instead.
func (*SRv6InformationSubTLV) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{120}
}

func (x *SRv6InformationSubTLV) GetSid() []byte {
	if x != nil {
		return x.Sid
	}
	return nil
}

func (x *SRv6InformationSubTLV) GetFlags() *SRv6SIDFlags {
	if x != nil {
		return x.Flags
	}
	return nil
}

func (x *SRv6InformationSubTLV) GetEndpointBehavior() uint32 {
	if x != nil {
		return x.EndpointBehavior
	}
	return 0
}

func (x *SRv6InformationSubTLV) GetSubSubTlvs() map[uint32]*SRv6TLV {
	if x != nil {
		return x.SubSubTlvs
	}
	return nil
}

// https://www.rfc-editor.org/rfc/rfc9252.html#section-2
type SRv6L3ServiceTLV struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// SRv6TLV is one of:
	// - SRv6InformationSubTLV
	SubTlvs       map[uint32]*SRv6TLV `protobuf:"bytes,1,rep,name=sub_tlvs,json=subTlvs,proto3" json:"sub_tlvs,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SRv6L3ServiceTLV) Reset() {
	*x = SRv6L3ServiceTLV{}
	mi := &file_attribute_proto_msgTypes[121]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRv6L3ServiceTLV) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRv6L3ServiceTLV) ProtoMessage() {}

func (x *SRv6L3ServiceTLV) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[121]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRv6L3ServiceTLV.ProtoReflect.Descriptor instead.
func (*SRv6L3ServiceTLV) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{121}
}

func (x *SRv6L3ServiceTLV) GetSubTlvs() map[uint32]*SRv6TLV {
	if x != nil {
		return x.SubTlvs
	}
	return nil
}

// https://www.rfc-editor.org/rfc/rfc9252.html#section-2
type SRv6L2ServiceTLV struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// SRv6TLV is one of:
	// - SRv6InformationSubTLV
	SubTlvs       map[uint32]*SRv6TLV `protobuf:"bytes,1,rep,name=sub_tlvs,json=subTlvs,proto3" json:"sub_tlvs,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SRv6L2ServiceTLV) Reset() {
	*x = SRv6L2ServiceTLV{}
	mi := &file_attribute_proto_msgTypes[122]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRv6L2ServiceTLV) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRv6L2ServiceTLV) ProtoMessage() {}

func (x *SRv6L2ServiceTLV) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[122]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRv6L2ServiceTLV.ProtoReflect.Descriptor instead.
func (*SRv6L2ServiceTLV) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{122}
}

func (x *SRv6L2ServiceTLV) GetSubTlvs() map[uint32]*SRv6TLV {
	if x != nil {
		return x.SubTlvs
	}
	return nil
}

// https://tools.ietf.org/html/rfc8669
type PrefixSID struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// tlv is one of:
	// - IndexLabelTLV Type 1 (not yet implemented)
	// - OriginatorSRGBTLV Type 3 (not yet implemented)
	// - SRv6L3ServiceTLV Type 5
	// - SRv6L2ServiceTLV Type 6
	Tlvs          []*anypb.Any `protobuf:"bytes,1,rep,name=tlvs,proto3" json:"tlvs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PrefixSID) Reset() {
	*x = PrefixSID{}
	mi := &file_attribute_proto_msgTypes[123]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrefixSID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrefixSID) ProtoMessage() {}

func (x *PrefixSID) ProtoReflect() protoreflect.Message {
	mi := &file_attribute_proto_msgTypes[123]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrefixSID.ProtoReflect.Descriptor instead.
func (*PrefixSID) Descriptor() ([]byte, []int) {
	return file_attribute_proto_rawDescGZIP(), []int{123}
}

func (x *PrefixSID) GetTlvs() []*anypb.Any {
	if x != nil {
		return x.Tlvs
	}
	return nil
}

var File_attribute_proto protoreflect.FileDescriptor

var file_attribute_proto_rawDesc = string([]byte{
	0x0a, 0x0f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x05, 0x61, 0x70, 0x69, 0x70, 0x62, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x0b, 0x67, 0x6f, 0x62, 0x67, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x29, 0x0a, 0x0f, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x22, 0xad, 0x01, 0x0a, 0x09,
	0x41, 0x73, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e,
	0x41, 0x73, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x07, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x22, 0x5b,
	0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x53, 0x5f, 0x53, 0x45, 0x54, 0x10, 0x01, 0x12,
	0x0f, 0x0a, 0x0b, 0x41, 0x53, 0x5f, 0x53, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x02,
	0x12, 0x16, 0x0a, 0x12, 0x41, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x45, 0x44, 0x5f, 0x53, 0x45,
	0x51, 0x55, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x53, 0x5f, 0x43,
	0x4f, 0x4e, 0x46, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x54, 0x10, 0x04, 0x22, 0x3f, 0x0a, 0x0f, 0x41,
	0x73, 0x50, 0x61, 0x74, 0x68, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x2c,
	0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x10, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x41, 0x73, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x2d, 0x0a, 0x10,
	0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x12, 0x19, 0x0a, 0x08, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x22, 0x2a, 0x0a, 0x16, 0x4d,
	0x75, 0x6c, 0x74, 0x69, 0x45, 0x78, 0x69, 0x74, 0x44, 0x69, 0x73, 0x63, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x03, 0x6d, 0x65, 0x64, 0x22, 0x33, 0x0a, 0x12, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x50, 0x72, 0x65, 0x66, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x22, 0x1a, 0x0a, 0x18,
	0x41, 0x74, 0x6f, 0x6d, 0x69, 0x63, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x22, 0x41, 0x0a, 0x13, 0x41, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12,
	0x10, 0x0a, 0x03, 0x61, 0x73, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x61, 0x73,
	0x6e, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x38, 0x0a, 0x14, 0x43,
	0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x27, 0x0a, 0x15, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x74, 0x6f, 0x72, 0x49, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x28,
	0x0a, 0x14, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x03, 0x69, 0x64, 0x73, 0x22, 0x48, 0x0a, 0x0f, 0x49, 0x50, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x09, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4c, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x22, 0x67, 0x0a, 0x16, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x65, 0x64, 0x49, 0x50, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x16, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6c,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x4c, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0x2d, 0x0a, 0x11, 0x45,
	0x6e, 0x63, 0x61, 0x70, 0x73, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x4c, 0x52, 0x49,
	0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x51, 0x0a, 0x1d, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x44, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x54, 0x77, 0x6f, 0x4f, 0x63, 0x74, 0x65, 0x74, 0x41, 0x53, 0x4e, 0x12, 0x14, 0x0a, 0x05, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x22, 0x4f, 0x0a,
	0x1b, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x44, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x49, 0x50, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x14, 0x0a, 0x05,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x22, 0x52,
	0x0a, 0x1e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x44, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75, 0x69,
	0x73, 0x68, 0x65, 0x72, 0x46, 0x6f, 0x75, 0x72, 0x4f, 0x63, 0x74, 0x65, 0x74, 0x41, 0x53, 0x4e,
	0x12, 0x14, 0x0a, 0x05, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x05, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x22, 0x45, 0x0a, 0x19, 0x45, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xbb, 0x01, 0x0a, 0x08, 0x56, 0x50,
	0x4c, 0x53, 0x4e, 0x4c, 0x52, 0x49, 0x12, 0x24, 0x0a, 0x02, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x02, 0x72, 0x64, 0x12, 0x13, 0x0a, 0x05,
	0x76, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x76, 0x65, 0x49,
	0x64, 0x12, 0x26, 0x0a, 0x0f, 0x76, 0x65, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x76, 0x65, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x22, 0x0a, 0x0d, 0x76, 0x65, 0x5f,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0b, 0x76, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x28, 0x0a,
	0x10, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x62, 0x61, 0x73,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x42, 0x61, 0x73, 0x65, 0x22, 0xb3, 0x01, 0x0a, 0x1e, 0x45, 0x56, 0x50, 0x4e,
	0x45, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x02, 0x72, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x02, 0x72, 0x64,
	0x12, 0x32, 0x0a, 0x03, 0x65, 0x73, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x45, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52,
	0x03, 0x65, 0x73, 0x69, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74,
	0x5f, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x65, 0x74, 0x68, 0x65,
	0x72, 0x6e, 0x65, 0x74, 0x54, 0x61, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0xf2, 0x01,
	0x0a, 0x1b, 0x45, 0x56, 0x50, 0x4e, 0x4d, 0x41, 0x43, 0x49, 0x50, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x24, 0x0a,
	0x02, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52,
	0x02, 0x72, 0x64, 0x12, 0x32, 0x0a, 0x03, 0x65, 0x73, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x45, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65,
	0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x52, 0x03, 0x65, 0x73, 0x69, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x74, 0x68, 0x65, 0x72,
	0x6e, 0x65, 0x74, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x65,
	0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x54, 0x61, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61,
	0x63, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x6d, 0x61, 0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x69,
	0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x22, 0x90, 0x01, 0x0a, 0x26, 0x45, 0x56, 0x50, 0x4e, 0x49, 0x6e, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x76, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x45, 0x74, 0x68,
	0x65, 0x72, 0x6e, 0x65, 0x74, 0x54, 0x61, 0x67, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x24, 0x0a,
	0x02, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52,
	0x02, 0x72, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x5f,
	0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x65, 0x74, 0x68, 0x65, 0x72,
	0x6e, 0x65, 0x74, 0x54, 0x61, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x93, 0x01, 0x0a, 0x18, 0x45, 0x56, 0x50, 0x4e, 0x45, 0x74,
	0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x12, 0x24, 0x0a, 0x02, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x41, 0x6e, 0x79, 0x52, 0x02, 0x72, 0x64, 0x12, 0x32, 0x0a, 0x03, 0x65, 0x73, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x45, 0x74,
	0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x03, 0x65, 0x73, 0x69, 0x12, 0x1d, 0x0a, 0x0a,
	0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x86, 0x02, 0x0a, 0x11,
	0x45, 0x56, 0x50, 0x4e, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x12, 0x24, 0x0a, 0x02, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x41, 0x6e, 0x79, 0x52, 0x02, 0x72, 0x64, 0x12, 0x32, 0x0a, 0x03, 0x65, 0x73, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x45, 0x74, 0x68,
	0x65, 0x72, 0x6e, 0x65, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x03, 0x65, 0x73, 0x69, 0x12, 0x21, 0x0a, 0x0c, 0x65,
	0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0b, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x54, 0x61, 0x67, 0x12, 0x1b,
	0x0a, 0x09, 0x69, 0x70, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x70, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x22, 0x0a, 0x0d, 0x69,
	0x70, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0b, 0x69, 0x70, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4c, 0x65, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x67, 0x77, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x77, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x14,
	0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x22, 0x7f, 0x0a, 0x0e, 0x45, 0x56, 0x50, 0x4e, 0x49, 0x50, 0x4d, 0x53,
	0x49, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x02, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x02, 0x72, 0x64, 0x12, 0x21, 0x0a, 0x0c,
	0x65, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0b, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x54, 0x61, 0x67, 0x12,
	0x24, 0x0a, 0x02, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e,
	0x79, 0x52, 0x02, 0x72, 0x74, 0x22, 0x7e, 0x0a, 0x0c, 0x53, 0x52, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x4e, 0x4c, 0x52, 0x49, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x24, 0x0a,
	0x0d, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x90, 0x01, 0x0a, 0x19, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x65,
	0x64, 0x56, 0x50, 0x4e, 0x49, 0x50, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x50, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0d, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x24, 0x0a, 0x02, 0x72,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x02, 0x72,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4c, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0x53, 0x0a, 0x19, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x4e, 0x4c, 0x52, 0x49, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x73, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x03, 0x61, 0x73, 0x6e, 0x12, 0x24, 0x0a, 0x02, 0x72, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x02, 0x72, 0x74, 0x22, 0x75, 0x0a,
	0x10, 0x46, 0x6c, 0x6f, 0x77, 0x53, 0x70, 0x65, 0x63, 0x49, 0x50, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f,
	0x6c, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x4c, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x16, 0x0a, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x22, 0x3b, 0x0a, 0x0b, 0x46, 0x6c, 0x6f, 0x77, 0x53, 0x70, 0x65, 0x63,
	0x4d, 0x41, 0x43, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x22, 0x3d, 0x0a, 0x15, 0x46, 0x6c, 0x6f, 0x77, 0x53, 0x70, 0x65, 0x63, 0x43, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x0e, 0x0a, 0x02, 0x6f, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0x5b, 0x0a, 0x11, 0x46, 0x6c, 0x6f, 0x77, 0x53, 0x70, 0x65, 0x63, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x69, 0x74, 0x65,
	0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62,
	0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x53, 0x70, 0x65, 0x63, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x3a, 0x0a,
	0x0c, 0x46, 0x6c, 0x6f, 0x77, 0x53, 0x70, 0x65, 0x63, 0x4e, 0x4c, 0x52, 0x49, 0x12, 0x2a, 0x0a,
	0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x63, 0x0a, 0x0f, 0x56, 0x50, 0x4e,
	0x46, 0x6c, 0x6f, 0x77, 0x53, 0x70, 0x65, 0x63, 0x4e, 0x4c, 0x52, 0x49, 0x12, 0x24, 0x0a, 0x02,
	0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x02,
	0x72, 0x64, 0x12, 0x2a, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x34,
	0x0a, 0x0a, 0x4f, 0x70, 0x61, 0x71, 0x75, 0x65, 0x4e, 0x4c, 0x52, 0x49, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x84, 0x02, 0x0a, 0x10, 0x4c, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x73, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x61, 0x73, 0x6e, 0x12, 0x1a, 0x0a, 0x09, 0x62,
	0x67, 0x70, 0x5f, 0x6c, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07,
	0x62, 0x67, 0x70, 0x4c, 0x73, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0c, 0x6f, 0x73, 0x70, 0x66, 0x5f,
	0x61, 0x72, 0x65, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6f,
	0x73, 0x70, 0x66, 0x41, 0x72, 0x65, 0x61, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x73, 0x65,
	0x75, 0x64, 0x6f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x70,
	0x73, 0x65, 0x75, 0x64, 0x6f, 0x6e, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x69, 0x67, 0x70,
	0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x69, 0x67, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x22, 0x0a,
	0x0d, 0x62, 0x67, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x62, 0x67, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x38, 0x0a, 0x18, 0x62, 0x67, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x64, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x16, 0x62, 0x67, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x64, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x98, 0x02, 0x0a, 0x10,
	0x4c, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x12, 0x22, 0x0a, 0x0d, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x6c, 0x69, 0x6e, 0x6b, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x72, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x6c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x5f, 0x69, 0x70, 0x76,
	0x34, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
	0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x49, 0x70, 0x76, 0x34, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x65,
	0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72,
	0x41, 0x64, 0x64, 0x72, 0x49, 0x70, 0x76, 0x34, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x41, 0x64, 0x64, 0x72, 0x49, 0x70, 0x76, 0x36, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x65, 0x69, 0x67,
	0x68, 0x62, 0x6f, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x41, 0x64,
	0x64, 0x72, 0x49, 0x70, 0x76, 0x36, 0x22, 0x7d, 0x0a, 0x12, 0x4c, 0x73, 0x50, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x27, 0x0a, 0x0f,
	0x69, 0x70, 0x5f, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x69, 0x70, 0x52, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x3e, 0x0a, 0x0f, 0x6f, 0x73, 0x70, 0x66, 0x5f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16,
	0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x4f, 0x73, 0x70, 0x66, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x6f, 0x73, 0x70, 0x66, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x44, 0x0a, 0x0a, 0x4c, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x4e,
	0x4c, 0x52, 0x49, 0x12, 0x36, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e,
	0x4c, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x22, 0xc0, 0x01, 0x0a, 0x0a,
	0x4c, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x4e, 0x4c, 0x52, 0x49, 0x12, 0x36, 0x0a, 0x0a, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4e, 0x6f,
	0x64, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e,
	0x4c, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x52, 0x0a, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x0f,
	0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x0e,
	0x6c, 0x69, 0x6e, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x22, 0x90,
	0x01, 0x0a, 0x0e, 0x4c, 0x73, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x56, 0x34, 0x4e, 0x4c, 0x52,
	0x49, 0x12, 0x36, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73,
	0x4e, 0x6f, 0x64, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x09,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x46, 0x0a, 0x11, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x50,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52,
	0x10, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x22, 0x90, 0x01, 0x0a, 0x0e, 0x4c, 0x73, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x56, 0x36,
	0x4e, 0x4c, 0x52, 0x49, 0x12, 0x36, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62,
	0x2e, 0x4c, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x46, 0x0a, 0x11,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e,
	0x4c, 0x73, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x52, 0x10, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x6f, 0x72, 0x22, 0xcd, 0x01, 0x0a, 0x0c, 0x4c, 0x73, 0x41, 0x64, 0x64, 0x72, 0x50,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x25, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x11, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x4e, 0x4c,
	0x52, 0x49, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x04,
	0x6e, 0x6c, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79,
	0x52, 0x04, 0x6e, 0x6c, 0x72, 0x69, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x34,
	0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x49, 0x44, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x22, 0x61, 0x0a, 0x21, 0x4d, 0x55, 0x50, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x02, 0x72, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x02, 0x72, 0x64, 0x12,
	0x16, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0x60, 0x0a, 0x1e, 0x4d, 0x55, 0x50, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x02, 0x72, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x02, 0x72, 0x64, 0x12,
	0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0xec, 0x02, 0x0a, 0x1f, 0x4d, 0x55,
	0x50, 0x54, 0x79, 0x70, 0x65, 0x31, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x24, 0x0a,
	0x02, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52,
	0x02, 0x72, 0x64, 0x12, 0x27, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x04, 0x74, 0x65, 0x69, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x71, 0x66, 0x69, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x71, 0x66, 0x69, 0x12, 0x36, 0x0a, 0x17, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x15, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x32, 0x0a,
	0x15, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x13, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x6e, 0x67, 0x74,
	0x68, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0xbe, 0x01, 0x0a, 0x1f, 0x4d, 0x55, 0x50,
	0x54, 0x79, 0x70, 0x65, 0x32, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x02,
	0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x02,
	0x72, 0x64, 0x12, 0x36, 0x0a, 0x17, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x15, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x04, 0x74, 0x65, 0x69, 0x64, 0x22, 0x86, 0x01, 0x0a, 0x14, 0x4d, 0x70,
	0x52, 0x65, 0x61, 0x63, 0x68, 0x4e, 0x4c, 0x52, 0x49, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x12, 0x25, 0x0a, 0x06, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x46, 0x61, 0x6d, 0x69, 0x6c,
	0x79, 0x52, 0x06, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x68, 0x6f, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x65,
	0x78, 0x74, 0x48, 0x6f, 0x70, 0x73, 0x12, 0x2a, 0x0a, 0x05, 0x6e, 0x6c, 0x72, 0x69, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x05, 0x6e, 0x6c, 0x72,
	0x69, 0x73, 0x22, 0x6b, 0x0a, 0x16, 0x4d, 0x70, 0x55, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x4e,
	0x4c, 0x52, 0x49, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x06,
	0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x61,
	0x70, 0x69, 0x70, 0x62, 0x2e, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x52, 0x06, 0x66, 0x61, 0x6d,
	0x69, 0x6c, 0x79, 0x12, 0x2a, 0x0a, 0x05, 0x6e, 0x6c, 0x72, 0x69, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x05, 0x6e, 0x6c, 0x72, 0x69, 0x73, 0x22,
	0x8f, 0x01, 0x0a, 0x1a, 0x54, 0x77, 0x6f, 0x4f, 0x63, 0x74, 0x65, 0x74, 0x41, 0x73, 0x53, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x23,
	0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74,
	0x69, 0x76, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x73, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x61, 0x73, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x61, 0x73, 0x6e,
	0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x41, 0x64, 0x6d, 0x69,
	0x6e, 0x22, 0x98, 0x01, 0x0a, 0x1b, 0x49, 0x50, 0x76, 0x34, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65,
	0x64, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x73, 0x75, 0x62, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x22, 0x90, 0x01, 0x0a,
	0x1b, 0x46, 0x6f, 0x75, 0x72, 0x4f, 0x63, 0x74, 0x65, 0x74, 0x41, 0x73, 0x53, 0x70, 0x65, 0x63,
	0x69, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0d,
	0x69, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x07, 0x73, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x61, 0x73, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x61, 0x73, 0x6e, 0x12, 0x1f,
	0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x22,
	0x47, 0x0a, 0x15, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x73, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x61, 0x73, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x62, 0x61,
	0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x62,
	0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x22, 0x2a, 0x0a, 0x12, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x22, 0x25, 0x0a, 0x0d, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x22, 0x30, 0x0a, 0x0d, 0x45,
	0x6e, 0x63, 0x61, 0x70, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b,
	0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0a, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x22, 0x18, 0x0a,
	0x16, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x22, 0x4b, 0x0a, 0x0e, 0x4f, 0x70, 0x61, 0x71, 0x75,
	0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x73, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x69, 0x73, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x52, 0x0a, 0x10, 0x45, 0x53, 0x49, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x69, 0x73, 0x5f, 0x73,
	0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0e, 0x69, 0x73, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x32, 0x0a, 0x13, 0x45, 0x53, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x65, 0x73, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x65, 0x73, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x55, 0x0a, 0x13,
	0x4d, 0x61, 0x63, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x64, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x73, 0x5f, 0x73, 0x74, 0x69, 0x63, 0x6b, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x69, 0x73, 0x53, 0x74, 0x69, 0x63, 0x6b, 0x79,
	0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65,
	0x4e, 0x75, 0x6d, 0x22, 0x25, 0x0a, 0x11, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x63,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x61, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6d, 0x61, 0x63, 0x22, 0x3b, 0x0a, 0x13, 0x54, 0x72,
	0x61, 0x66, 0x66, 0x69, 0x63, 0x52, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65,
	0x64, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x73, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03,
	0x61, 0x73, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x04, 0x72, 0x61, 0x74, 0x65, 0x22, 0x4b, 0x0a, 0x15, 0x54, 0x72, 0x61, 0x66, 0x66,
	0x69, 0x63, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64,
	0x12, 0x1a, 0x0a, 0x08, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x08, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x22, 0x57, 0x0a, 0x22, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x54, 0x77, 0x6f, 0x4f, 0x63, 0x74, 0x65, 0x74, 0x41, 0x73, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66,
	0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x73,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x61, 0x73, 0x6e, 0x12, 0x1f, 0x0a, 0x0b,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x22, 0x60, 0x0a,
	0x23, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x49, 0x50, 0x76, 0x34, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f,
	0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x22,
	0x58, 0x0a, 0x23, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x46, 0x6f, 0x75, 0x72, 0x4f,
	0x63, 0x74, 0x65, 0x74, 0x41, 0x73, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x73, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x03, 0x61, 0x73, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x22, 0x2b, 0x0a, 0x15, 0x54, 0x72, 0x61,
	0x66, 0x66, 0x69, 0x63, 0x52, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64,
	0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x73, 0x63, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x04, 0x64, 0x73, 0x63, 0x70, 0x22, 0x6a, 0x0a, 0x0b, 0x4d, 0x55, 0x50, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x73, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x32, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x32, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x34,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x34, 0x22, 0x45, 0x0a, 0x0c, 0x56, 0x50, 0x4c, 0x53, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64,
	0x65, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x74, 0x75, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6d, 0x74, 0x75, 0x22, 0x3b, 0x0a, 0x0f, 0x55, 0x6e, 0x6b,
	0x6e, 0x6f, 0x77, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x56, 0x0a, 0x1c, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64,
	0x65, 0x64, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e,
	0x79, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x40,
	0x0a, 0x10, 0x41, 0x73, 0x34, 0x50, 0x61, 0x74, 0x68, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x12, 0x2c, 0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x41, 0x73, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x22, 0x44, 0x0a, 0x16, 0x41, 0x73, 0x34, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x6f,
	0x72, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x73,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x61, 0x73, 0x6e, 0x12, 0x18, 0x0a, 0x07,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x65, 0x0a, 0x13, 0x50, 0x6d, 0x73, 0x69, 0x54, 0x75,
	0x6e, 0x6e, 0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x69, 0x64, 0x22, 0x4a, 0x0a,
	0x1e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61, 0x70, 0x53, 0x75, 0x62, 0x54,
	0x4c, 0x56, 0x45, 0x6e, 0x63, 0x61, 0x70, 0x73, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x06, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x22, 0x37, 0x0a, 0x19, 0x54, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61, 0x70, 0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x22, 0x2e, 0x0a, 0x16, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61,
	0x70, 0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05,
	0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x63, 0x6f, 0x6c,
	0x6f, 0x72, 0x22, 0x55, 0x0a, 0x1d, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61,
	0x70, 0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x53, 0x52, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x70,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x56, 0x0a, 0x24, 0x54, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61, 0x70, 0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x53, 0x52,
	0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x74, 0x68, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x74, 0x68, 0x4e, 0x61, 0x6d,
	0x65, 0x22, 0x39, 0x0a, 0x1b, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61, 0x70,
	0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x53, 0x52, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x22, 0x49, 0x0a, 0x1d,
	0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61, 0x70, 0x53, 0x75, 0x62, 0x54, 0x4c,
	0x56, 0x53, 0x52, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x49, 0x44, 0x12, 0x28, 0x0a,
	0x04, 0x62, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e,
	0x79, 0x52, 0x04, 0x62, 0x73, 0x69, 0x64, 0x22, 0x4e, 0x0a, 0x0c, 0x53, 0x52, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x53, 0x49, 0x44, 0x12, 0x15, 0x0a, 0x06, 0x73, 0x5f, 0x66, 0x6c, 0x61,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x15,
	0x0a, 0x06, 0x69, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05,
	0x69, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x03, 0x73, 0x69, 0x64, 0x22, 0xb3, 0x01, 0x0a, 0x14, 0x53, 0x52, 0x76, 0x36,
	0x45, 0x6e, 0x64, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x12, 0x2f, 0x0a, 0x08, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x13, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x53, 0x52, 0x76, 0x36, 0x42,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x52, 0x08, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x6c, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x65, 0x6e, 0x12, 0x19,
	0x0a, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6c, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x07, 0x6e, 0x6f, 0x64, 0x65, 0x4c, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x66, 0x75, 0x6e,
	0x63, 0x5f, 0x6c, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x66, 0x75, 0x6e,
	0x63, 0x4c, 0x65, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x61, 0x72, 0x67, 0x5f, 0x6c, 0x65, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x61, 0x72, 0x67, 0x4c, 0x65, 0x6e, 0x22, 0xc4, 0x01,
	0x0a, 0x0e, 0x53, 0x52, 0x76, 0x36, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x49, 0x44,
	0x12, 0x15, 0x0a, 0x06, 0x73, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x05, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x15, 0x0a, 0x06, 0x69, 0x5f, 0x66, 0x6c, 0x61,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x69, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x15,
	0x0a, 0x06, 0x62, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05,
	0x62, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x03, 0x73, 0x69, 0x64, 0x12, 0x5b, 0x0a, 0x1b, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61,
	0x70, 0x69, 0x70, 0x62, 0x2e, 0x53, 0x52, 0x76, 0x36, 0x45, 0x6e, 0x64, 0x50, 0x6f, 0x69, 0x6e,
	0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x52, 0x19, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x22, 0x54, 0x0a, 0x17, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e,
	0x63, 0x61, 0x70, 0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x53, 0x52, 0x45, 0x4e, 0x4c, 0x50, 0x12,
	0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x23, 0x0a, 0x04, 0x65, 0x6e, 0x6c, 0x70, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x0f, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x45, 0x4e, 0x4c, 0x50,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x65, 0x6e, 0x6c, 0x70, 0x22, 0x38, 0x0a, 0x08, 0x53, 0x52,
	0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x16, 0x0a, 0x06,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x77, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x22, 0x6a, 0x0a, 0x0c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46,
	0x6c, 0x61, 0x67, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x76, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x76, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x15, 0x0a, 0x06, 0x61,
	0x5f, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x61, 0x46, 0x6c,
	0x61, 0x67, 0x12, 0x15, 0x0a, 0x06, 0x73, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x05, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x15, 0x0a, 0x06, 0x62, 0x5f, 0x66,
	0x6c, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x62, 0x46, 0x6c, 0x61, 0x67,
	0x22, 0x4f, 0x0a, 0x0c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x41,
	0x12, 0x29, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46,
	0x6c, 0x61, 0x67, 0x73, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x22, 0xa8, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x12, 0x29, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x10, 0x0a,
	0x03, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x73, 0x69, 0x64, 0x12,
	0x5b, 0x0a, 0x1b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x53, 0x52, 0x76,
	0x36, 0x45, 0x6e, 0x64, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x52, 0x19, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x22, 0x7b, 0x0a, 0x1e,
	0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61, 0x70, 0x53, 0x75, 0x62, 0x54, 0x4c,
	0x56, 0x53, 0x52, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x27,
	0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f,
	0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x53, 0x52, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x52,
	0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x30, 0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52,
	0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x3b, 0x0a, 0x1f, 0x54, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61, 0x70, 0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x45, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x32, 0x0a, 0x1c, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c,
	0x45, 0x6e, 0x63, 0x61, 0x70, 0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x55, 0x44, 0x50, 0x44, 0x65,
	0x73, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x44, 0x0a, 0x18, 0x54, 0x75,
	0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61, 0x70, 0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x55,
	0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0x4e, 0x0a, 0x0e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61, 0x70, 0x54,
	0x4c, 0x56, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x04, 0x74, 0x6c, 0x76, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x04, 0x74, 0x6c, 0x76, 0x73,
	0x22, 0x41, 0x0a, 0x14, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61, 0x70, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x29, 0x0a, 0x04, 0x74, 0x6c, 0x76, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x54,
	0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x63, 0x61, 0x70, 0x54, 0x4c, 0x56, 0x52, 0x04, 0x74,
	0x6c, 0x76, 0x73, 0x22, 0x98, 0x01, 0x0a, 0x1b, 0x49, 0x50, 0x76, 0x36, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x64, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x73, 0x75, 0x62, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x22, 0x60,
	0x0a, 0x23, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x49, 0x50, 0x76, 0x36, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x41, 0x64, 0x6d, 0x69, 0x6e,
	0x22, 0x59, 0x0a, 0x1f, 0x49, 0x50, 0x36, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x43,
	0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x0b,
	0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x2a, 0x0a, 0x10, 0x41,
	0x69, 0x67, 0x70, 0x54, 0x4c, 0x56, 0x49, 0x47, 0x50, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12,
	0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x3a, 0x0a, 0x0e, 0x41, 0x69, 0x67, 0x70, 0x54,
	0x4c, 0x56, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0x39, 0x0a, 0x0d, 0x41, 0x69, 0x67, 0x70, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x04, 0x74, 0x6c, 0x76, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x04, 0x74, 0x6c, 0x76, 0x73, 0x22, 0x75,
	0x0a, 0x0e, 0x4c, 0x61, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x79,
	0x12, 0x21, 0x0a, 0x0c, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x31, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x44,
	0x61, 0x74, 0x61, 0x31, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x32, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x44, 0x61, 0x74, 0x61, 0x32, 0x22, 0x54, 0x0a, 0x19, 0x4c, 0x61, 0x72, 0x67, 0x65, 0x43, 0x6f,
	0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e,
	0x4c, 0x61, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x79, 0x52, 0x0b,
	0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x9b, 0x01, 0x0a, 0x0b,
	0x4c, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x6f,
	0x76, 0x65, 0x72, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6f,
	0x76, 0x65, 0x72, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x12,
	0x10, 0x0a, 0x03, 0x61, 0x62, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x61, 0x62,
	0x72, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x76, 0x36, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x02, 0x76, 0x36, 0x22, 0x8b, 0x01, 0x0a, 0x0a, 0x4c, 0x73,
	0x49, 0x47, 0x50, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x6f, 0x77, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x64, 0x6f, 0x77, 0x6e, 0x12, 0x1d, 0x0a, 0x0a,
	0x6e, 0x6f, 0x5f, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x09, 0x6e, 0x6f, 0x55, 0x6e, 0x69, 0x63, 0x61, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x73,
	0x73, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x70, 0x61, 0x67,
	0x61, 0x74, 0x65, 0x4e, 0x73, 0x73, 0x61, 0x22, 0x33, 0x0a, 0x09, 0x4c, 0x73, 0x53, 0x72, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x05, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x22, 0x8a, 0x01, 0x0a,
	0x10, 0x4c, 0x73, 0x53, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x70, 0x76, 0x34, 0x53,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x70, 0x76, 0x36,
	0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x69, 0x70, 0x76, 0x36, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12,
	0x28, 0x0a, 0x06, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x10, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x53, 0x72, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x06, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x22, 0x3a, 0x0a, 0x0e, 0x4c, 0x73, 0x53,
	0x72, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x28, 0x0a, 0x06, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x61, 0x70,
	0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x53, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x06, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x22, 0xfd, 0x02, 0x0a, 0x0f, 0x4c, 0x73, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a,
	0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x61,
	0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x2b, 0x0a, 0x12, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x5f, 0x76, 0x36, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x49, 0x64, 0x56, 0x36, 0x12, 0x1b, 0x0a, 0x09,
	0x69, 0x73, 0x69, 0x73, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x08, 0x69, 0x73, 0x69, 0x73, 0x41, 0x72, 0x65, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x70, 0x61,
	0x71, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x6f, 0x70, 0x61, 0x71, 0x75,
	0x65, 0x12, 0x40, 0x0a, 0x0f, 0x73, 0x72, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x69,
	0x70, 0x62, 0x2e, 0x4c, 0x73, 0x53, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x52, 0x0e, 0x73, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x72, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x73, 0x72, 0x41, 0x6c,
	0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x73, 0x12, 0x3b, 0x0a, 0x0e, 0x73, 0x72, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x53, 0x72, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x0c, 0x73, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x22, 0x9b, 0x04, 0x0a, 0x0f, 0x4c, 0x73, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x12, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x5f, 0x76, 0x36, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x49, 0x64,
	0x56, 0x36, 0x12, 0x28, 0x0a, 0x10, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x2d, 0x0a, 0x13,
	0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x5f, 0x76, 0x36, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x49, 0x64, 0x56, 0x36, 0x12, 0x1f, 0x0a, 0x0b, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0a, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2a, 0x0a, 0x11,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x54, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x67, 0x70, 0x5f,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x69, 0x67,
	0x70, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x70, 0x61, 0x71, 0x75,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x6f, 0x70, 0x61, 0x71, 0x75, 0x65, 0x12,
	0x1c, 0x0a, 0x09, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x09, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x31, 0x0a,
	0x14, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x62, 0x61, 0x6e, 0x64,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x12, 0x31, 0x0a, 0x14, 0x75, 0x6e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x62,
	0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x02, 0x52, 0x13,
	0x75, 0x6e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x42, 0x61, 0x6e, 0x64, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x72, 0x5f, 0x61, 0x64, 0x6a, 0x61, 0x63, 0x65,
	0x6e, 0x63, 0x79, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x73,
	0x72, 0x41, 0x64, 0x6a, 0x61, 0x63, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x69, 0x64, 0x12, 0x14, 0x0a,
	0x05, 0x73, 0x72, 0x6c, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x05, 0x73, 0x72,
	0x6c, 0x67, 0x73, 0x22, 0x7f, 0x0a, 0x11, 0x4c, 0x73, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x2e, 0x0a, 0x09, 0x69, 0x67, 0x70, 0x5f,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x61, 0x70,
	0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x49, 0x47, 0x50, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x08,
	0x69, 0x67, 0x70, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x70, 0x61, 0x71,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x6f, 0x70, 0x61, 0x71, 0x75, 0x65,
	0x12, 0x22, 0x0a, 0x0d, 0x73, 0x72, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x73, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x73, 0x72, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x53, 0x69, 0x64, 0x22, 0x7e, 0x0a, 0x18, 0x4c, 0x73, 0x42, 0x67, 0x70, 0x50, 0x65, 0x65,
	0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x49, 0x44, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x12, 0x16, 0x0a, 0x06,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x74, 0x22, 0x76, 0x0a, 0x13, 0x4c, 0x73, 0x42, 0x67, 0x70, 0x50, 0x65, 0x65,
	0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x49, 0x44, 0x12, 0x35, 0x0a, 0x05, 0x66,
	0x6c, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x61, 0x70, 0x69,
	0x70, 0x62, 0x2e, 0x4c, 0x73, 0x42, 0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x49, 0x44, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x05, 0x66, 0x6c, 0x61,
	0x67, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x73, 0x69, 0x64, 0x22, 0xf8, 0x01, 0x0a,
	0x19, 0x4c, 0x73, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x42, 0x67, 0x70, 0x50,
	0x65, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x11, 0x62, 0x67,
	0x70, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x73, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73,
	0x42, 0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x49,
	0x44, 0x52, 0x0e, 0x62, 0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x69,
	0x64, 0x12, 0x4f, 0x0a, 0x16, 0x62, 0x67, 0x70, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x61, 0x64,
	0x6a, 0x61, 0x63, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x42, 0x67, 0x70, 0x50,
	0x65, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x49, 0x44, 0x52, 0x13, 0x62,
	0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x41, 0x64, 0x6a, 0x61, 0x63, 0x65, 0x6e, 0x63, 0x79, 0x53,
	0x69, 0x64, 0x12, 0x43, 0x0a, 0x10, 0x62, 0x67, 0x70, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61,
	0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x42, 0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x49, 0x44, 0x52, 0x0d, 0x62, 0x67, 0x70, 0x50, 0x65, 0x65,
	0x72, 0x53, 0x65, 0x74, 0x53, 0x69, 0x64, 0x22, 0xe3, 0x01, 0x0a, 0x0b, 0x4c, 0x73, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6e,
	0x6f, 0x64, 0x65, 0x12, 0x2a, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x12,
	0x30, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x12, 0x4a, 0x0a, 0x10, 0x62, 0x67, 0x70, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x61, 0x70,
	0x69, 0x70, 0x62, 0x2e, 0x4c, 0x73, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x42,
	0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0e, 0x62,
	0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x52, 0x0a,
	0x10, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0xb2, 0x02, 0x0a, 0x16, 0x53, 0x52, 0x76, 0x36, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x53, 0x75, 0x62, 0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x12, 0x30, 0x0a, 0x14,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x6c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x12, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x6f, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x2e,
	0x0a, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x6f, 0x72, 0x4e, 0x6f, 0x64, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x27,
	0x0a, 0x0f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74,
	0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x72, 0x67, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0e, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x31, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x13,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x12, 0x31, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x25, 0x0a, 0x0c, 0x53, 0x52, 0x76, 0x36, 0x53, 0x49,
	0x44, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x66, 0x6c, 0x61, 0x67, 0x5f, 0x31,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x31, 0x22, 0x31, 0x0a,
	0x07, 0x53, 0x52, 0x76, 0x36, 0x54, 0x4c, 0x56, 0x12, 0x26, 0x0a, 0x03, 0x74, 0x6c, 0x76, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x03, 0x74, 0x6c, 0x76,
	0x22, 0xa0, 0x02, 0x0a, 0x15, 0x53, 0x52, 0x76, 0x36, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x73, 0x69, 0x64, 0x12, 0x29, 0x0a, 0x05,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x61, 0x70,
	0x69, 0x70, 0x62, 0x2e, 0x53, 0x52, 0x76, 0x36, 0x53, 0x49, 0x44, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x10, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x12, 0x4e, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x5f,
	0x74, 0x6c, 0x76, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x61, 0x70, 0x69,
	0x70, 0x62, 0x2e, 0x53, 0x52, 0x76, 0x36, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x75, 0x62, 0x54, 0x4c, 0x56, 0x2e, 0x53, 0x75, 0x62, 0x53, 0x75, 0x62, 0x54,
	0x6c, 0x76, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x53, 0x75, 0x62,
	0x54, 0x6c, 0x76, 0x73, 0x1a, 0x4d, 0x0a, 0x0f, 0x53, 0x75, 0x62, 0x53, 0x75, 0x62, 0x54, 0x6c,
	0x76, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x24, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62,
	0x2e, 0x53, 0x52, 0x76, 0x36, 0x54, 0x4c, 0x56, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x9f, 0x01, 0x0a, 0x10, 0x53, 0x52, 0x76, 0x36, 0x4c, 0x33, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x4c, 0x56, 0x12, 0x3f, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x5f,
	0x74, 0x6c, 0x76, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61, 0x70, 0x69,
	0x70, 0x62, 0x2e, 0x53, 0x52, 0x76, 0x36, 0x4c, 0x33, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x54, 0x4c, 0x56, 0x2e, 0x53, 0x75, 0x62, 0x54, 0x6c, 0x76, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x07, 0x73, 0x75, 0x62, 0x54, 0x6c, 0x76, 0x73, 0x1a, 0x4a, 0x0a, 0x0c, 0x53, 0x75, 0x62,
	0x54, 0x6c, 0x76, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x24, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x61, 0x70, 0x69,
	0x70, 0x62, 0x2e, 0x53, 0x52, 0x76, 0x36, 0x54, 0x4c, 0x56, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x9f, 0x01, 0x0a, 0x10, 0x53, 0x52, 0x76, 0x36, 0x4c, 0x32,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x4c, 0x56, 0x12, 0x3f, 0x0a, 0x08, 0x73, 0x75,
	0x62, 0x5f, 0x74, 0x6c, 0x76, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61,
	0x70, 0x69, 0x70, 0x62, 0x2e, 0x53, 0x52, 0x76, 0x36, 0x4c, 0x32, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x54, 0x4c, 0x56, 0x2e, 0x53, 0x75, 0x62, 0x54, 0x6c, 0x76, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x07, 0x73, 0x75, 0x62, 0x54, 0x6c, 0x76, 0x73, 0x1a, 0x4a, 0x0a, 0x0c, 0x53,
	0x75, 0x62, 0x54, 0x6c, 0x76, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x24, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x61,
	0x70, 0x69, 0x70, 0x62, 0x2e, 0x53, 0x52, 0x76, 0x36, 0x54, 0x4c, 0x56, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x35, 0x0a, 0x09, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x53, 0x49, 0x44, 0x12, 0x28, 0x0a, 0x04, 0x74, 0x6c, 0x76, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x04, 0x74, 0x6c, 0x76, 0x73, 0x2a, 0xf7,
	0x01, 0x0a, 0x0f, 0x4c, 0x73, 0x4f, 0x73, 0x70, 0x66, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x4c, 0x53, 0x5f, 0x4f, 0x53, 0x50, 0x46, 0x5f, 0x52, 0x4f,
	0x55, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x4c, 0x53, 0x5f, 0x4f, 0x53, 0x50, 0x46, 0x5f, 0x52, 0x4f,
	0x55, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x52, 0x41, 0x5f, 0x41,
	0x52, 0x45, 0x41, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x4c, 0x53, 0x5f, 0x4f, 0x53, 0x50, 0x46,
	0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x5f, 0x41, 0x52, 0x45, 0x41, 0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x4c, 0x53, 0x5f, 0x4f,
	0x53, 0x50, 0x46, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45,
	0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x31, 0x10, 0x03, 0x12, 0x20, 0x0a, 0x1c, 0x4c, 0x53,
	0x5f, 0x4f, 0x53, 0x50, 0x46, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x32, 0x10, 0x04, 0x12, 0x1c, 0x0a, 0x18,
	0x4c, 0x53, 0x5f, 0x4f, 0x53, 0x50, 0x46, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x4e, 0x53, 0x53, 0x41, 0x31, 0x10, 0x05, 0x12, 0x1c, 0x0a, 0x18, 0x4c, 0x53,
	0x5f, 0x4f, 0x53, 0x50, 0x46, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x4e, 0x53, 0x53, 0x41, 0x32, 0x10, 0x06, 0x2a, 0x73, 0x0a, 0x0a, 0x4c, 0x73, 0x4e, 0x4c,
	0x52, 0x49, 0x54, 0x79, 0x70, 0x65, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x53, 0x5f, 0x4e, 0x4c, 0x52,
	0x49, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4c,
	0x53, 0x5f, 0x4e, 0x4c, 0x52, 0x49, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a,
	0x0c, 0x4c, 0x53, 0x5f, 0x4e, 0x4c, 0x52, 0x49, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x02, 0x12,
	0x15, 0x0a, 0x11, 0x4c, 0x53, 0x5f, 0x4e, 0x4c, 0x52, 0x49, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x49,
	0x58, 0x5f, 0x56, 0x34, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x53, 0x5f, 0x4e, 0x4c, 0x52,
	0x49, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x49, 0x58, 0x5f, 0x56, 0x36, 0x10, 0x04, 0x2a, 0xbb, 0x01,
	0x0a, 0x0c, 0x4c, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x49, 0x44, 0x12, 0x17,
	0x0a, 0x13, 0x4c, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x4c, 0x53, 0x5f, 0x50, 0x52,
	0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x49, 0x53, 0x49, 0x53, 0x5f, 0x4c, 0x31, 0x10, 0x01,
	0x12, 0x17, 0x0a, 0x13, 0x4c, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f,
	0x49, 0x53, 0x49, 0x53, 0x5f, 0x4c, 0x32, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x4c, 0x53, 0x5f,
	0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x4f, 0x53, 0x50, 0x46, 0x5f, 0x56, 0x32,
	0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f,
	0x4c, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x53,
	0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x49, 0x43,
	0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x4c, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f,
	0x4c, 0x5f, 0x4f, 0x53, 0x50, 0x46, 0x5f, 0x56, 0x33, 0x10, 0x06, 0x2a, 0xed, 0x05, 0x0a, 0x0c,
	0x53, 0x52, 0x76, 0x36, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x0c, 0x0a, 0x08,
	0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x45, 0x4e,
	0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x4e, 0x44, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f,
	0x50, 0x53, 0x50, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x4e, 0x44, 0x5f, 0x57, 0x49, 0x54,
	0x48, 0x5f, 0x55, 0x53, 0x50, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x4e, 0x44, 0x5f, 0x57,
	0x49, 0x54, 0x48, 0x5f, 0x50, 0x53, 0x50, 0x5f, 0x55, 0x53, 0x50, 0x10, 0x04, 0x12, 0x08, 0x0a,
	0x04, 0x45, 0x4e, 0x44, 0x58, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x4e, 0x44, 0x58, 0x5f,
	0x57, 0x49, 0x54, 0x48, 0x5f, 0x50, 0x53, 0x50, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x4e,
	0x44, 0x58, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x55, 0x53, 0x50, 0x10, 0x07, 0x12, 0x15, 0x0a,
	0x11, 0x45, 0x4e, 0x44, 0x58, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x50, 0x53, 0x50, 0x5f, 0x55,
	0x53, 0x50, 0x10, 0x08, 0x12, 0x08, 0x0a, 0x04, 0x45, 0x4e, 0x44, 0x54, 0x10, 0x09, 0x12, 0x11,
	0x0a, 0x0d, 0x45, 0x4e, 0x44, 0x54, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x50, 0x53, 0x50, 0x10,
	0x0a, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x4e, 0x44, 0x54, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x55,
	0x53, 0x50, 0x10, 0x0b, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x4e, 0x44, 0x54, 0x5f, 0x57, 0x49, 0x54,
	0x48, 0x5f, 0x50, 0x53, 0x50, 0x5f, 0x55, 0x53, 0x50, 0x10, 0x0c, 0x12, 0x11, 0x0a, 0x0d, 0x45,
	0x4e, 0x44, 0x5f, 0x42, 0x36, 0x5f, 0x45, 0x4e, 0x43, 0x41, 0x50, 0x53, 0x10, 0x0e, 0x12, 0x0a,
	0x0a, 0x06, 0x45, 0x4e, 0x44, 0x5f, 0x42, 0x4d, 0x10, 0x0f, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e,
	0x44, 0x5f, 0x44, 0x58, 0x36, 0x10, 0x10, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x44, 0x5f, 0x44,
	0x58, 0x34, 0x10, 0x11, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x44, 0x5f, 0x44, 0x54, 0x36, 0x10,
	0x12, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x44, 0x5f, 0x44, 0x54, 0x34, 0x10, 0x13, 0x12, 0x0c,
	0x0a, 0x08, 0x45, 0x4e, 0x44, 0x5f, 0x44, 0x54, 0x34, 0x36, 0x10, 0x14, 0x12, 0x0b, 0x0a, 0x07,
	0x45, 0x4e, 0x44, 0x5f, 0x44, 0x58, 0x32, 0x10, 0x15, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x44,
	0x5f, 0x44, 0x58, 0x32, 0x56, 0x10, 0x16, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x44, 0x5f, 0x44,
	0x54, 0x32, 0x55, 0x10, 0x17, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x44, 0x5f, 0x44, 0x54, 0x32,
	0x4d, 0x10, 0x18, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x4e, 0x44, 0x5f, 0x42, 0x36, 0x5f, 0x45, 0x4e,
	0x43, 0x41, 0x50, 0x53, 0x5f, 0x52, 0x65, 0x64, 0x10, 0x1b, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x4e,
	0x44, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x55, 0x53, 0x44, 0x10, 0x1c, 0x12, 0x14, 0x0a, 0x10,
	0x45, 0x4e, 0x44, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x50, 0x53, 0x50, 0x5f, 0x55, 0x53, 0x44,
	0x10, 0x1d, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x4e, 0x44, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x55,
	0x53, 0x50, 0x5f, 0x55, 0x53, 0x44, 0x10, 0x1e, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x44, 0x5f,
	0x57, 0x49, 0x54, 0x48, 0x5f, 0x50, 0x53, 0x50, 0x5f, 0x55, 0x53, 0x50, 0x5f, 0x55, 0x53, 0x44,
	0x10, 0x1f, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x4e, 0x44, 0x58, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f,
	0x55, 0x53, 0x44, 0x10, 0x20, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x4e, 0x44, 0x58, 0x5f, 0x57, 0x49,
	0x54, 0x48, 0x5f, 0x50, 0x53, 0x50, 0x5f, 0x55, 0x53, 0x44, 0x10, 0x21, 0x12, 0x15, 0x0a, 0x11,
	0x45, 0x4e, 0x44, 0x58, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x55, 0x53, 0x50, 0x5f, 0x55, 0x53,
	0x44, 0x10, 0x22, 0x12, 0x19, 0x0a, 0x15, 0x45, 0x4e, 0x44, 0x58, 0x5f, 0x57, 0x49, 0x54, 0x48,
	0x5f, 0x50, 0x53, 0x50, 0x5f, 0x55, 0x53, 0x50, 0x5f, 0x55, 0x53, 0x44, 0x10, 0x23, 0x12, 0x11,
	0x0a, 0x0d, 0x45, 0x4e, 0x44, 0x54, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x55, 0x53, 0x44, 0x10,
	0x24, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x4e, 0x44, 0x54, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x50,
	0x53, 0x50, 0x5f, 0x55, 0x53, 0x44, 0x10, 0x25, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x4e, 0x44, 0x54,
	0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x55, 0x53, 0x50, 0x5f, 0x55, 0x53, 0x44, 0x10, 0x26, 0x12,
	0x19, 0x0a, 0x15, 0x45, 0x4e, 0x44, 0x54, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x50, 0x53, 0x50,
	0x5f, 0x55, 0x53, 0x50, 0x5f, 0x55, 0x53, 0x44, 0x10, 0x27, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x4e,
	0x44, 0x4d, 0x5f, 0x47, 0x54, 0x50, 0x36, 0x44, 0x10, 0x45, 0x12, 0x0f, 0x0a, 0x0b, 0x45, 0x4e,
	0x44, 0x4d, 0x5f, 0x47, 0x54, 0x50, 0x36, 0x44, 0x49, 0x10, 0x46, 0x12, 0x0e, 0x0a, 0x0a, 0x45,
	0x4e, 0x44, 0x4d, 0x5f, 0x47, 0x54, 0x50, 0x36, 0x45, 0x10, 0x47, 0x12, 0x0e, 0x0a, 0x0a, 0x45,
	0x4e, 0x44, 0x4d, 0x5f, 0x47, 0x54, 0x50, 0x34, 0x45, 0x10, 0x48, 0x2a, 0x44, 0x0a, 0x08, 0x45,
	0x4e, 0x4c, 0x50, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x64, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x79, 0x70, 0x65, 0x31, 0x10, 0x01,
	0x12, 0x09, 0x0a, 0x05, 0x54, 0x79, 0x70, 0x65, 0x32, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x54,
	0x79, 0x70, 0x65, 0x33, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x79, 0x70, 0x65, 0x34, 0x10,
	0x04, 0x42, 0x24, 0x5a, 0x22, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x6f, 0x73, 0x72, 0x67, 0x2f, 0x67, 0x6f, 0x62, 0x67, 0x70, 0x2f, 0x76, 0x33, 0x2f, 0x61, 0x70,
	0x69, 0x3b, 0x61, 0x70, 0x69, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_attribute_proto_rawDescOnce sync.Once
	file_attribute_proto_rawDescData []byte
)

func file_attribute_proto_rawDescGZIP() []byte {
	file_attribute_proto_rawDescOnce.Do(func() {
		file_attribute_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_attribute_proto_rawDesc), len(file_attribute_proto_rawDesc)))
	})
	return file_attribute_proto_rawDescData
}

var file_attribute_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_attribute_proto_msgTypes = make([]protoimpl.MessageInfo, 127)
var file_attribute_proto_goTypes = []any{
	(LsOspfRouteType)(0),                           // 0: apipb.LsOspfRouteType
	(LsNLRIType)(0),                                // 1: apipb.LsNLRIType
	(LsProtocolID)(0),                              // 2: apipb.LsProtocolID
	(SRv6Behavior)(0),                              // 3: apipb.SRv6Behavior
	(ENLPType)(0),                                  // 4: apipb.ENLPType
	(AsSegment_Type)(0),                            // 5: apipb.AsSegment.Type
	(*OriginAttribute)(nil),                        // 6: apipb.OriginAttribute
	(*AsSegment)(nil),                              // 7: apipb.AsSegment
	(*AsPathAttribute)(nil),                        // 8: apipb.AsPathAttribute
	(*NextHopAttribute)(nil),                       // 9: apipb.NextHopAttribute
	(*MultiExitDiscAttribute)(nil),                 // 10: apipb.MultiExitDiscAttribute
	(*LocalPrefAttribute)(nil),                     // 11: apipb.LocalPrefAttribute
	(*AtomicAggregateAttribute)(nil),               // 12: apipb.AtomicAggregateAttribute
	(*AggregatorAttribute)(nil),                    // 13: apipb.AggregatorAttribute
	(*CommunitiesAttribute)(nil),                   // 14: apipb.CommunitiesAttribute
	(*OriginatorIdAttribute)(nil),                  // 15: apipb.OriginatorIdAttribute
	(*ClusterListAttribute)(nil),                   // 16: apipb.ClusterListAttribute
	(*IPAddressPrefix)(nil),                        // 17: apipb.IPAddressPrefix
	(*LabeledIPAddressPrefix)(nil),                 // 18: apipb.LabeledIPAddressPrefix
	(*EncapsulationNLRI)(nil),                      // 19: apipb.EncapsulationNLRI
	(*RouteDistinguisherTwoOctetASN)(nil),          // 20: apipb.RouteDistinguisherTwoOctetASN
	(*RouteDistinguisherIPAddress)(nil),            // 21: apipb.RouteDistinguisherIPAddress
	(*RouteDistinguisherFourOctetASN)(nil),         // 22: apipb.RouteDistinguisherFourOctetASN
	(*EthernetSegmentIdentifier)(nil),              // 23: apipb.EthernetSegmentIdentifier
	(*VPLSNLRI)(nil),                               // 24: apipb.VPLSNLRI
	(*EVPNEthernetAutoDiscoveryRoute)(nil),         // 25: apipb.EVPNEthernetAutoDiscoveryRoute
	(*EVPNMACIPAdvertisementRoute)(nil),            // 26: apipb.EVPNMACIPAdvertisementRoute
	(*EVPNInclusiveMulticastEthernetTagRoute)(nil), // 27: apipb.EVPNInclusiveMulticastEthernetTagRoute
	(*EVPNEthernetSegmentRoute)(nil),               // 28: apipb.EVPNEthernetSegmentRoute
	(*EVPNIPPrefixRoute)(nil),                      // 29: apipb.EVPNIPPrefixRoute
	(*EVPNIPMSIRoute)(nil),                         // 30: apipb.EVPNIPMSIRoute
	(*SRPolicyNLRI)(nil),                           // 31: apipb.SRPolicyNLRI
	(*LabeledVPNIPAddressPrefix)(nil),              // 32: apipb.LabeledVPNIPAddressPrefix
	(*RouteTargetMembershipNLRI)(nil),              // 33: apipb.RouteTargetMembershipNLRI
	(*FlowSpecIPPrefix)(nil),                       // 34: apipb.FlowSpecIPPrefix
	(*FlowSpecMAC)(nil),                            // 35: apipb.FlowSpecMAC
	(*FlowSpecComponentItem)(nil),                  // 36: apipb.FlowSpecComponentItem
	(*FlowSpecComponent)(nil),                      // 37: apipb.FlowSpecComponent
	(*FlowSpecNLRI)(nil),                           // 38: apipb.FlowSpecNLRI
	(*VPNFlowSpecNLRI)(nil),                        // 39: apipb.VPNFlowSpecNLRI
	(*OpaqueNLRI)(nil),                             // 40: apipb.OpaqueNLRI
	(*LsNodeDescriptor)(nil),                       // 41: apipb.LsNodeDescriptor
	(*LsLinkDescriptor)(nil),                       // 42: apipb.LsLinkDescriptor
	(*LsPrefixDescriptor)(nil),                     // 43: apipb.LsPrefixDescriptor
	(*LsNodeNLRI)(nil),                             // 44: apipb.LsNodeNLRI
	(*LsLinkNLRI)(nil),                             // 45: apipb.LsLinkNLRI
	(*LsPrefixV4NLRI)(nil),                         // 46: apipb.LsPrefixV4NLRI
	(*LsPrefixV6NLRI)(nil),                         // 47: apipb.LsPrefixV6NLRI
	(*LsAddrPrefix)(nil),                           // 48: apipb.LsAddrPrefix
	(*MUPInterworkSegmentDiscoveryRoute)(nil),      // 49: apipb.MUPInterworkSegmentDiscoveryRoute
	(*MUPDirectSegmentDiscoveryRoute)(nil),         // 50: apipb.MUPDirectSegmentDiscoveryRoute
	(*MUPType1SessionTransformedRoute)(nil),        // 51: apipb.MUPType1SessionTransformedRoute
	(*MUPType2SessionTransformedRoute)(nil),        // 52: apipb.MUPType2SessionTransformedRoute
	(*MpReachNLRIAttribute)(nil),                   // 53: apipb.MpReachNLRIAttribute
	(*MpUnreachNLRIAttribute)(nil),                 // 54: apipb.MpUnreachNLRIAttribute
	(*TwoOctetAsSpecificExtended)(nil),             // 55: apipb.TwoOctetAsSpecificExtended
	(*IPv4AddressSpecificExtended)(nil),            // 56: apipb.IPv4AddressSpecificExtended
	(*FourOctetAsSpecificExtended)(nil),            // 57: apipb.FourOctetAsSpecificExtended
	(*LinkBandwidthExtended)(nil),                  // 58: apipb.LinkBandwidthExtended
	(*ValidationExtended)(nil),                     // 59: apipb.ValidationExtended
	(*ColorExtended)(nil),                          // 60: apipb.ColorExtended
	(*EncapExtended)(nil),                          // 61: apipb.EncapExtended
	(*DefaultGatewayExtended)(nil),                 // 62: apipb.DefaultGatewayExtended
	(*OpaqueExtended)(nil),                         // 63: apipb.OpaqueExtended
	(*ESILabelExtended)(nil),                       // 64: apipb.ESILabelExtended
	(*ESImportRouteTarget)(nil),                    // 65: apipb.ESImportRouteTarget
	(*MacMobilityExtended)(nil),                    // 66: apipb.MacMobilityExtended
	(*RouterMacExtended)(nil),                      // 67: apipb.RouterMacExtended
	(*TrafficRateExtended)(nil),                    // 68: apipb.TrafficRateExtended
	(*TrafficActionExtended)(nil),                  // 69: apipb.TrafficActionExtended
	(*RedirectTwoOctetAsSpecificExtended)(nil),     // 70: apipb.RedirectTwoOctetAsSpecificExtended
	(*RedirectIPv4AddressSpecificExtended)(nil),    // 71: apipb.RedirectIPv4AddressSpecificExtended
	(*RedirectFourOctetAsSpecificExtended)(nil),    // 72: apipb.RedirectFourOctetAsSpecificExtended
	(*TrafficRemarkExtended)(nil),                  // 73: apipb.TrafficRemarkExtended
	(*MUPExtended)(nil),                            // 74: apipb.MUPExtended
	(*VPLSExtended)(nil),                           // 75: apipb.VPLSExtended
	(*UnknownExtended)(nil),                        // 76: apipb.UnknownExtended
	(*ExtendedCommunitiesAttribute)(nil),           // 77: apipb.ExtendedCommunitiesAttribute
	(*As4PathAttribute)(nil),                       // 78: apipb.As4PathAttribute
	(*As4AggregatorAttribute)(nil),                 // 79: apipb.As4AggregatorAttribute
	(*PmsiTunnelAttribute)(nil),                    // 80: apipb.PmsiTunnelAttribute
	(*TunnelEncapSubTLVEncapsulation)(nil),         // 81: apipb.TunnelEncapSubTLVEncapsulation
	(*TunnelEncapSubTLVProtocol)(nil),              // 82: apipb.TunnelEncapSubTLVProtocol
	(*TunnelEncapSubTLVColor)(nil),                 // 83: apipb.TunnelEncapSubTLVColor
	(*TunnelEncapSubTLVSRPreference)(nil),          // 84: apipb.TunnelEncapSubTLVSRPreference
	(*TunnelEncapSubTLVSRCandidatePathName)(nil),   // 85: apipb.TunnelEncapSubTLVSRCandidatePathName
	(*TunnelEncapSubTLVSRPriority)(nil),            // 86: apipb.TunnelEncapSubTLVSRPriority
	(*TunnelEncapSubTLVSRBindingSID)(nil),          // 87: apipb.TunnelEncapSubTLVSRBindingSID
	(*SRBindingSID)(nil),                           // 88: apipb.SRBindingSID
	(*SRv6EndPointBehavior)(nil),                   // 89: apipb.SRv6EndPointBehavior
	(*SRv6BindingSID)(nil),                         // 90: apipb.SRv6BindingSID
	(*TunnelEncapSubTLVSRENLP)(nil),                // 91: apipb.TunnelEncapSubTLVSRENLP
	(*SRWeight)(nil),                               // 92: apipb.SRWeight
	(*SegmentFlags)(nil),                           // 93: apipb.SegmentFlags
	(*SegmentTypeA)(nil),                           // 94: apipb.SegmentTypeA
	(*SegmentTypeB)(nil),                           // 95: apipb.SegmentTypeB
	(*TunnelEncapSubTLVSRSegmentList)(nil),         // 96: apipb.TunnelEncapSubTLVSRSegmentList
	(*TunnelEncapSubTLVEgressEndpoint)(nil),        // 97: apipb.TunnelEncapSubTLVEgressEndpoint
	(*TunnelEncapSubTLVUDPDestPort)(nil),           // 98: apipb.TunnelEncapSubTLVUDPDestPort
	(*TunnelEncapSubTLVUnknown)(nil),               // 99: apipb.TunnelEncapSubTLVUnknown
	(*TunnelEncapTLV)(nil),                         // 100: apipb.TunnelEncapTLV
	(*TunnelEncapAttribute)(nil),                   // 101: apipb.TunnelEncapAttribute
	(*IPv6AddressSpecificExtended)(nil),            // 102: apipb.IPv6AddressSpecificExtended
	(*RedirectIPv6AddressSpecificExtended)(nil),    // 103: apipb.RedirectIPv6AddressSpecificExtended
	(*IP6ExtendedCommunitiesAttribute)(nil),        // 104: apipb.IP6ExtendedCommunitiesAttribute
	(*AigpTLVIGPMetric)(nil),                       // 105: apipb.AigpTLVIGPMetric
	(*AigpTLVUnknown)(nil),                         // 106: apipb.AigpTLVUnknown
	(*AigpAttribute)(nil),                          // 107: apipb.AigpAttribute
	(*LargeCommunity)(nil),                         // 108: apipb.LargeCommunity
	(*LargeCommunitiesAttribute)(nil),              // 109: apipb.LargeCommunitiesAttribute
	(*LsNodeFlags)(nil),                            // 110: apipb.LsNodeFlags
	(*LsIGPFlags)(nil),                             // 111: apipb.LsIGPFlags
	(*LsSrRange)(nil),                              // 112: apipb.LsSrRange
	(*LsSrCapabilities)(nil),                       // 113: apipb.LsSrCapabilities
	(*LsSrLocalBlock)(nil),                         // 114: apipb.LsSrLocalBlock
	(*LsAttributeNode)(nil),                        // 115: apipb.LsAttributeNode
	(*LsAttributeLink)(nil),                        // 116: apipb.LsAttributeLink
	(*LsAttributePrefix)(nil),                      // 117: apipb.LsAttributePrefix
	(*LsBgpPeerSegmentSIDFlags)(nil),               // 118: apipb.LsBgpPeerSegmentSIDFlags
	(*LsBgpPeerSegmentSID)(nil),                    // 119: apipb.LsBgpPeerSegmentSID
	(*LsAttributeBgpPeerSegment)(nil),              // 120: apipb.LsAttributeBgpPeerSegment
	(*LsAttribute)(nil),                            // 121: apipb.LsAttribute
	(*UnknownAttribute)(nil),                       // 122: apipb.UnknownAttribute
	(*SRv6StructureSubSubTLV)(nil),                 // 123: apipb.SRv6StructureSubSubTLV
	(*SRv6SIDFlags)(nil),                           // 124: apipb.SRv6SIDFlags
	(*SRv6TLV)(nil),                                // 125: apipb.SRv6TLV
	(*SRv6InformationSubTLV)(nil),                  // 126: apipb.SRv6InformationSubTLV
	(*SRv6L3ServiceTLV)(nil),                       // 127: apipb.SRv6L3ServiceTLV
	(*SRv6L2ServiceTLV)(nil),                       // 128: apipb.SRv6L2ServiceTLV
	(*PrefixSID)(nil),                              // 129: apipb.PrefixSID
	nil,                                            // 130: apipb.SRv6InformationSubTLV.SubSubTlvsEntry
	nil,                                            // 131: apipb.SRv6L3ServiceTLV.SubTlvsEntry
	nil,                                            // 132: apipb.SRv6L2ServiceTLV.SubTlvsEntry
	(*anypb.Any)(nil),                              // 133: google.protobuf.Any
	(*Family)(nil),                                 // 134: apipb.Family
}
var file_attribute_proto_depIdxs = []int32{
	5,   // 0: apipb.AsSegment.type:type_name -> apipb.AsSegment.Type
	7,   // 1: apipb.AsPathAttribute.segments:type_name -> apipb.AsSegment
	133, // 2: apipb.VPLSNLRI.rd:type_name -> google.protobuf.Any
	133, // 3: apipb.EVPNEthernetAutoDiscoveryRoute.rd:type_name -> google.protobuf.Any
	23,  // 4: apipb.EVPNEthernetAutoDiscoveryRoute.esi:type_name -> apipb.EthernetSegmentIdentifier
	133, // 5: apipb.EVPNMACIPAdvertisementRoute.rd:type_name -> google.protobuf.Any
	23,  // 6: apipb.EVPNMACIPAdvertisementRoute.esi:type_name -> apipb.EthernetSegmentIdentifier
	133, // 7: apipb.EVPNInclusiveMulticastEthernetTagRoute.rd:type_name -> google.protobuf.Any
	133, // 8: apipb.EVPNEthernetSegmentRoute.rd:type_name -> google.protobuf.Any
	23,  // 9: apipb.EVPNEthernetSegmentRoute.esi:type_name -> apipb.EthernetSegmentIdentifier
	133, // 10: apipb.EVPNIPPrefixRoute.rd:type_name -> google.protobuf.Any
	23,  // 11: apipb.EVPNIPPrefixRoute.esi:type_name -> apipb.EthernetSegmentIdentifier
	133, // 12: apipb.EVPNIPMSIRoute.rd:type_name -> google.protobuf.Any
	133, // 13: apipb.EVPNIPMSIRoute.rt:type_name -> google.protobuf.Any
	133, // 14: apipb.LabeledVPNIPAddressPrefix.rd:type_name -> google.protobuf.Any
	133, // 15: apipb.RouteTargetMembershipNLRI.rt:type_name -> google.protobuf.Any
	36,  // 16: apipb.FlowSpecComponent.items:type_name -> apipb.FlowSpecComponentItem
	133, // 17: apipb.FlowSpecNLRI.rules:type_name -> google.protobuf.Any
	133, // 18: apipb.VPNFlowSpecNLRI.rd:type_name -> google.protobuf.Any
	133, // 19: apipb.VPNFlowSpecNLRI.rules:type_name -> google.protobuf.Any
	0,   // 20: apipb.LsPrefixDescriptor.ospf_route_type:type_name -> apipb.LsOspfRouteType
	41,  // 21: apipb.LsNodeNLRI.local_node:type_name -> apipb.LsNodeDescriptor
	41,  // 22: apipb.LsLinkNLRI.local_node:type_name -> apipb.LsNodeDescriptor
	41,  // 23: apipb.LsLinkNLRI.remote_node:type_name -> apipb.LsNodeDescriptor
	42,  // 24: apipb.LsLinkNLRI.link_descriptor:type_name -> apipb.LsLinkDescriptor
	41,  // 25: apipb.LsPrefixV4NLRI.local_node:type_name -> apipb.LsNodeDescriptor
	43,  // 26: apipb.LsPrefixV4NLRI.prefix_descriptor:type_name -> apipb.LsPrefixDescriptor
	41,  // 27: apipb.LsPrefixV6NLRI.local_node:type_name -> apipb.LsNodeDescriptor
	43,  // 28: apipb.LsPrefixV6NLRI.prefix_descriptor:type_name -> apipb.LsPrefixDescriptor
	1,   // 29: apipb.LsAddrPrefix.type:type_name -> apipb.LsNLRIType
	133, // 30: apipb.LsAddrPrefix.nlri:type_name -> google.protobuf.Any
	2,   // 31: apipb.LsAddrPrefix.protocol_id:type_name -> apipb.LsProtocolID
	133, // 32: apipb.MUPInterworkSegmentDiscoveryRoute.rd:type_name -> google.protobuf.Any
	133, // 33: apipb.MUPDirectSegmentDiscoveryRoute.rd:type_name -> google.protobuf.Any
	133, // 34: apipb.MUPType1SessionTransformedRoute.rd:type_name -> google.protobuf.Any
	133, // 35: apipb.MUPType2SessionTransformedRoute.rd:type_name -> google.protobuf.Any
	134, // 36: apipb.MpReachNLRIAttribute.family:type_name -> apipb.Family
	133, // 37: apipb.MpReachNLRIAttribute.nlris:type_name -> google.protobuf.Any
	134, // 38: apipb.MpUnreachNLRIAttribute.family:type_name -> apipb.Family
	133, // 39: apipb.MpUnreachNLRIAttribute.nlris:type_name -> google.protobuf.Any
	133, // 40: apipb.ExtendedCommunitiesAttribute.communities:type_name -> google.protobuf.Any
	7,   // 41: apipb.As4PathAttribute.segments:type_name -> apipb.AsSegment
	133, // 42: apipb.TunnelEncapSubTLVSRBindingSID.bsid:type_name -> google.protobuf.Any
	3,   // 43: apipb.SRv6EndPointBehavior.behavior:type_name -> apipb.SRv6Behavior
	89,  // 44: apipb.SRv6BindingSID.endpoint_behavior_structure:type_name -> apipb.SRv6EndPointBehavior
	4,   // 45: apipb.TunnelEncapSubTLVSRENLP.enlp:type_name -> apipb.ENLPType
	93,  // 46: apipb.SegmentTypeA.flags:type_name -> apipb.SegmentFlags
	93,  // 47: apipb.SegmentTypeB.flags:type_name -> apipb.SegmentFlags
	89,  // 48: apipb.SegmentTypeB.endpoint_behavior_structure:type_name -> apipb.SRv6EndPointBehavior
	92,  // 49: apipb.TunnelEncapSubTLVSRSegmentList.weight:type_name -> apipb.SRWeight
	133, // 50: apipb.TunnelEncapSubTLVSRSegmentList.segments:type_name -> google.protobuf.Any
	133, // 51: apipb.TunnelEncapTLV.tlvs:type_name -> google.protobuf.Any
	100, // 52: apipb.TunnelEncapAttribute.tlvs:type_name -> apipb.TunnelEncapTLV
	133, // 53: apipb.IP6ExtendedCommunitiesAttribute.communities:type_name -> google.protobuf.Any
	133, // 54: apipb.AigpAttribute.tlvs:type_name -> google.protobuf.Any
	108, // 55: apipb.LargeCommunitiesAttribute.communities:type_name -> apipb.LargeCommunity
	112, // 56: apipb.LsSrCapabilities.ranges:type_name -> apipb.LsSrRange
	112, // 57: apipb.LsSrLocalBlock.ranges:type_name -> apipb.LsSrRange
	110, // 58: apipb.LsAttributeNode.flags:type_name -> apipb.LsNodeFlags
	113, // 59: apipb.LsAttributeNode.sr_capabilities:type_name -> apipb.LsSrCapabilities
	114, // 60: apipb.LsAttributeNode.sr_local_block:type_name -> apipb.LsSrLocalBlock
	111, // 61: apipb.LsAttributePrefix.igp_flags:type_name -> apipb.LsIGPFlags
	118, // 62: apipb.LsBgpPeerSegmentSID.flags:type_name -> apipb.LsBgpPeerSegmentSIDFlags
	119, // 63: apipb.LsAttributeBgpPeerSegment.bgp_peer_node_sid:type_name -> apipb.LsBgpPeerSegmentSID
	119, // 64: apipb.LsAttributeBgpPeerSegment.bgp_peer_adjacency_sid:type_name -> apipb.LsBgpPeerSegmentSID
	119, // 65: apipb.LsAttributeBgpPeerSegment.bgp_peer_set_sid:type_name -> apipb.LsBgpPeerSegmentSID
	115, // 66: apipb.LsAttribute.node:type_name -> apipb.LsAttributeNode
	116, // 67: apipb.LsAttribute.link:type_name -> apipb.LsAttributeLink
	117, // 68: apipb.LsAttribute.prefix:type_name -> apipb.LsAttributePrefix
	120, // 69: apipb.LsAttribute.bgp_peer_segment:type_name -> apipb.LsAttributeBgpPeerSegment
	133, // 70: apipb.SRv6TLV.tlv:type_name -> google.protobuf.Any
	124, // 71: apipb.SRv6InformationSubTLV.flags:type_name -> apipb.SRv6SIDFlags
	130, // 72: apipb.SRv6InformationSubTLV.sub_sub_tlvs:type_name -> apipb.SRv6InformationSubTLV.SubSubTlvsEntry
	131, // 73: apipb.SRv6L3ServiceTLV.sub_tlvs:type_name -> apipb.SRv6L3ServiceTLV.SubTlvsEntry
	132, // 74: apipb.SRv6L2ServiceTLV.sub_tlvs:type_name -> apipb.SRv6L2ServiceTLV.SubTlvsEntry
	133, // 75: apipb.PrefixSID.tlvs:type_name -> google.protobuf.Any
	125, // 76: apipb.SRv6InformationSubTLV.SubSubTlvsEntry.value:type_name -> apipb.SRv6TLV
	125, // 77: apipb.SRv6L3ServiceTLV.SubTlvsEntry.value:type_name -> apipb.SRv6TLV
	125, // 78: apipb.SRv6L2ServiceTLV.SubTlvsEntry.value:type_name -> apipb.SRv6TLV
	79,  // [79:79] is the sub-list for method output_type
	79,  // [79:79] is the sub-list for method input_type
	79,  // [79:79] is the sub-list for extension type_name
	79,  // [79:79] is the sub-list for extension extendee
	0,   // [0:79] is the sub-list for field type_name
}

func init() { file_attribute_proto_init() }
func file_attribute_proto_init() {
	if File_attribute_proto != nil {
		return
	}
	file_gobgp_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_attribute_proto_rawDesc), len(file_attribute_proto_rawDesc)),
			NumEnums:      6,
			NumMessages:   127,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_attribute_proto_goTypes,
		DependencyIndexes: file_attribute_proto_depIdxs,
		EnumInfos:         file_attribute_proto_enumTypes,
		MessageInfos:      file_attribute_proto_msgTypes,
	}.Build()
	File_attribute_proto = out.File
	file_attribute_proto_goTypes = nil
	file_attribute_proto_depIdxs = nil
}
