/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Transfers200Response {
    #[serde(rename = "place")]
    pub place: Box<models::Place>,
    #[serde(rename = "root")]
    pub root: Box<models::Place>,
    #[serde(rename = "equivalences")]
    pub equivalences: Vec<models::Place>,
    /// true if the server has foot transfers computed
    #[serde(rename = "hasFootTransfers")]
    pub has_foot_transfers: bool,
    /// true if the server has wheelchair transfers computed
    #[serde(rename = "hasWheelchairTransfers")]
    pub has_wheelchair_transfers: bool,
    /// true if the server has car transfers computed
    #[serde(rename = "hasCarTransfers")]
    pub has_car_transfers: bool,
    /// all outgoing transfers of this location
    #[serde(rename = "transfers")]
    pub transfers: Vec<models::Transfer>,
}

impl Transfers200Response {
    pub fn new(place: models::Place, root: models::Place, equivalences: Vec<models::Place>, has_foot_transfers: bool, has_wheelchair_transfers: bool, has_car_transfers: bool, transfers: Vec<models::Transfer>) -> Transfers200Response {
        Transfers200Response {
            place: Box::new(place),
            root: Box::new(root),
            equivalences,
            has_foot_transfers,
            has_wheelchair_transfers,
            has_car_transfers,
            transfers,
        }
    }
}

