/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;

abstract class MessageBuilderHelper {
    MessageBuilderHelper() {
    }

    static Collection<String> pathTo(EdgeState edge) {
        return MessageBuilderHelper.pathTo(edge, true);
    }

    static Collection<String> pathTo(EdgeState edge, boolean includeLast) {
        ArrayList<List<EdgeState>> acc = new ArrayList<List<EdgeState>>(1);
        MessageBuilderHelper.pathTo(edge, new ArrayList<EdgeState>(), acc, new HashSet<NodeState>());
        ArrayList<String> result = new ArrayList<String>(acc.size());
        for (List list : acc) {
            EdgeState target = (EdgeState)Iterators.getLast(list.iterator());
            StringBuilder sb = new StringBuilder();
            if (target.getSelector().getDependencyMetadata().isConstraint()) {
                sb.append("Constraint path ");
            } else {
                sb.append("Dependency path ");
            }
            boolean first = true;
            String variantDetails = null;
            for (EdgeState e : list) {
                if (!first) {
                    sb.append(" --> ");
                }
                first = false;
                ModuleVersionIdentifier id = e.getFrom().getComponent().getModuleVersion();
                sb.append('\'').append(id).append('\'');
                if (variantDetails != null) {
                    sb.append(variantDetails);
                }
                variantDetails = MessageBuilderHelper.variantDetails(e);
            }
            if (includeLast) {
                sb.append(" --> ");
                SelectorState selector = edge.getSelector();
                ModuleIdentifier moduleId = selector.getTargetModule().getId();
                sb.append('\'').append(moduleId.getGroup()).append(':').append(moduleId.getName()).append('\'');
                if (variantDetails != null) {
                    sb.append(variantDetails);
                }
            }
            result.add(sb.toString());
        }
        return result;
    }

    @Nullable
    private static String variantDetails(EdgeState e) {
        String selectedVariantName;
        String string = selectedVariantName = e.hasSelectedVariant() ? e.getSelectedNode().getMetadata().getName() : null;
        if (selectedVariantName != null) {
            return " (" + selectedVariantName + ")";
        }
        return null;
    }

    static void pathTo(EdgeState component, List<EdgeState> currentPath, List<List<EdgeState>> accumulator, Set<NodeState> alreadySeen) {
        if (alreadySeen.add(component.getFrom())) {
            currentPath.add(0, component);
            for (EdgeState dependent : component.getFrom().getIncomingEdges()) {
                ArrayList<EdgeState> otherPath = new ArrayList<EdgeState>(currentPath);
                MessageBuilderHelper.pathTo(dependent, otherPath, accumulator, alreadySeen);
            }
            if (component.getFrom().isRoot()) {
                accumulator.add(currentPath);
            }
        }
    }
}

