/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.builtins.IrBuiltInsMapGeneratedKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterAssertionError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterException;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicEvaluator;
import org.jetbrains.kotlin.ir.interpreter.proxy.ProxyKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002@AB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J4\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%H\u0016J,\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%H\u0016J\u001e\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%H\u0016J\u001e\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020.2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%H\u0016J\u0010\u0010/\u001a\u00020 2\u0006\u0010*\u001a\u000200H\u0016J$\u00101\u001a\u00020 *\u0004\u0018\u0001022\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u00105\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\u00172\u0006\u00107\u001a\u000208H\u0002J\u001e\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020;2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0016\u0010<\u001a\u00020;*\u0004\u0018\u00010\u00172\u0006\u0010=\u001a\u00020;H\u0002J\u000e\u0010>\u001a\u0004\u0018\u00010?*\u00020\u0019H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor;", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;)V", "getInterpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getEnvironment", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "interceptProxy", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "valueArguments", "", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "expectedResultClass", "Ljava/lang/Class;", "interceptCall", "", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "args", "defaultAction", "Lkotlin/Function0;", "interceptConstructor", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interceptGetObjectValue", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interceptEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interceptJavaStaticField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "invokeMethod", "Ljava/lang/invoke/MethodHandle;", "handleIntrinsicMethods", "", "calculateBuiltIns", "interpretBuiltinFunction", "signature", "Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor$Signature;", "calculateRangeTo", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getType", "defaultType", "trySubstituteFunctionBody", "Lorg/jetbrains/kotlin/ir/IrElement;", "Signature", "Arg", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nCallInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallInterceptor.kt\norg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor\n+ 2 ExceptionUtils.kt\norg/jetbrains/kotlin/ir/interpreter/exceptions/ExceptionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,220:1\n20#2,2:221\n20#2,2:259\n24#2,8:261\n24#2,2:275\n26#2,6:281\n808#3,11:223\n626#3,12:234\n1863#3,2:269\n1557#3:271\n1628#3,3:272\n1557#3:277\n1628#3,3:278\n1557#3:287\n1628#3,3:288\n1557#3:291\n1628#3,3:292\n1872#3,3:295\n1863#3,2:298\n1#4:246\n350#5,12:247\n*S KotlinDebug\n*F\n+ 1 CallInterceptor.kt\norg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor\n*L\n92#1:221,2\n138#1:259,2\n140#1:261,8\n165#1:275,2\n165#1:281,6\n96#1:223,11\n97#1:234,12\n148#1:269,2\n162#1:271\n162#1:272,3\n167#1:277\n167#1:278,3\n187#1:287\n187#1:288,3\n189#1:291\n189#1:292,3\n190#1:295,3\n55#1:298,2\n122#1:247,12\n*E\n"})
public final class DefaultCallInterceptor
implements CallInterceptor {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrInterpreterEnvironment environment;
    @NotNull
    private final CallStack callStack;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;

    public DefaultCallInterceptor(@NotNull IrInterpreter interpreter2) {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        this.interpreter = interpreter2;
        this.environment = this.getInterpreter().getEnvironment$ir_interpreter();
        this.callStack = this.getEnvironment().getCallStack$ir_interpreter();
        this.irBuiltIns = this.getEnvironment().getIrBuiltIns();
        this.bodyMap = this.getInterpreter().getBodyMap$ir_interpreter();
    }

    @Override
    @NotNull
    public IrInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    @NotNull
    public IrInterpreterEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @Override
    @Nullable
    public Object interceptProxy(@NotNull IrFunction irFunction, @NotNull List<? extends State> valueArguments, @NotNull Class<?> expectedResultClass) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter(valueArguments, (String)"valueArguments");
        Intrinsics.checkNotNullParameter(expectedResultClass, (String)"expectedResultClass");
        IrCall irCall = IrTreeBuildUtilsKt.createCall$default(irFunction, null, 1, null);
        return ProxyKt.wrap(this.getInterpreter().withNewCallStack$ir_interpreter(irCall, (Function1<? super IrInterpreter, ? extends Object>)((Function1)arg_0 -> DefaultCallInterceptor.interceptProxy$lambda$1(irCall, valueArguments, arg_0))), (CallInterceptor)this, false, expectedResultClass);
    }

    @Override
    public void interceptCall(@NotNull IrCall call2, @NotNull IrFunction irFunction, @NotNull List<? extends State> args, @NotNull Function0<Unit> defaultAction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        boolean isInlineOnly = IrUtilsKt.hasAnnotation((IrAnnotationContainer)irFunction, new FqName("kotlin.internal.InlineOnly"));
        boolean isSyntheticDefault = Intrinsics.areEqual((Object)irFunction.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER());
        State receiver = irFunction.getDispatchReceiverParameter() != null ? args.get(0) : null;
        if (receiver instanceof Wrapper && !isInlineOnly && !isSyntheticDefault) {
            this.invokeMethod(((Wrapper)receiver).getMethod(irFunction), irFunction, args);
            object = Unit.INSTANCE;
        } else if (Wrapper.Companion.mustBeHandledWithWrapper(irFunction)) {
            this.invokeMethod(Wrapper.Companion.getStaticMethod(irFunction), irFunction, args);
            object = Unit.INSTANCE;
        } else {
            if (this.handleIntrinsicMethods(irFunction)) {
                return;
            }
            if (StateKt.mustBeHandledAsReflection(receiver, call2)) {
                this.invokeMethod(Wrapper.Companion.getReflectionMethod(irFunction), irFunction, args);
                object = Unit.INSTANCE;
            } else if (receiver instanceof Primitive) {
                this.calculateBuiltIns(irFunction, args);
                object = Unit.INSTANCE;
            } else if (irFunction.getBody() == null && UtilsKt.isAccessorOfPropertyWithBackingField(irFunction)) {
                InstructionKt.pushCompoundInstruction(this.callStack, IrTreeBuildUtilsKt.createGetField(irFunction));
                object = Unit.INSTANCE;
            } else if (irFunction.getBody() == null) {
                object = this.trySubstituteFunctionBody(irFunction);
                if (object == null) {
                    this.calculateBuiltIns(irFunction, args);
                    object = Unit.INSTANCE;
                }
            } else {
                defaultAction.invoke();
                object = Unit.INSTANCE;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void interceptConstructor(@NotNull IrFunctionAccessExpression constructorCall, @NotNull List<? extends State> args, @NotNull Function0<Unit> defaultAction) {
        block12: {
            block14: {
                block13: {
                    block11: {
                        Intrinsics.checkNotNullParameter((Object)constructorCall, (String)"constructorCall");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
                        receiver = this.callStack.loadState(UtilsKt.getThisReceiver(constructorCall));
                        irConstructor = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
                        irClass = IrUtilsKt.getParentAsClass(irConstructor);
                        if (!Wrapper.Companion.mustBeHandledWithWrapper(irClass)) break block11;
                        this.invokeMethod(Wrapper.Companion.getConstructorMethod(irConstructor), irConstructor, args);
                        if (UtilsKt.isSubclassOfThrowable(irClass)) {
                            Intrinsics.checkNotNull((Object)receiver, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.ExceptionState");
                            v0 = (ExceptionState)receiver;
                            v1 = this.callStack.popState();
                            Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Wrapper");
                            v0.copyFieldsFrom((Wrapper)v1);
                        } else if (constructorCall instanceof IrConstructorCall) {
                            this.callStack.rewriteState(UtilsKt.getThisReceiver(constructorCall), this.callStack.popState());
                        } else {
                            Intrinsics.checkNotNull((Object)receiver, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
                            v2 = (Complex)receiver;
                            v3 = this.callStack.popState();
                            Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Wrapper");
                            v2.setSuperWrapperClass((Wrapper)v3);
                        }
                        break block12;
                    }
                    if (!IrTypePredicatesKt.isArray(IrUtilsKt.getDefaultType(irClass)) && !UtilsKt.isPrimitiveArray(IrUtilsKt.getDefaultType(irClass))) break block13;
                    value$iv = this.handleIntrinsicMethods(irConstructor);
                    $i$f$verify = false;
                    if (!value$iv) {
                        $i$a$-verify-DefaultCallInterceptor$interceptConstructor$1 = false;
                        var18_13 = ("Unsupported intrinsic constructor: " + RenderIrElementKt.render$default(irConstructor, null, 1, null)).toString();
                        throw new InterpreterAssertionError(var18_13);
                    }
                    break block12;
                }
                if (!IrTypePredicatesKt.isUnsignedType$default(IrUtilsKt.getDefaultType(irClass), false, 1, null)) break block14;
                v4 = IrDeclarationsKt.getInlineClassRepresentation(irClass);
                propertyName = v4 != null ? v4.getUnderlyingPropertyName() : null;
                $this$filterIsInstance$iv = irClass.getDeclarations();
                $i$f$filterIsInstance = false;
                var11_16 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                $i$f$single = false;
                single$iv = null;
                found$iv = false;
                for (T element$iv : $this$single$iv) {
                    it = (IrProperty)element$iv;
                    $i$a$-single-DefaultCallInterceptor$interceptConstructor$propertySymbol$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)propertyName)) ** GOTO lbl-1000
                    v5 = it.getGetter();
                    if ((v5 != null ? v5.getExtensionReceiverParameter() : null) == null) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                propertySymbol = ((IrProperty)single$iv).getSymbol();
                $i$f$single = var9_12 = receiver;
                var17_25 = this.callStack;
                $i$a$-apply-DefaultCallInterceptor$interceptConstructor$2 = false;
                $this$interceptConstructor_u24lambda_u244.setField(propertySymbol, (State)CollectionsKt.single(args));
                var17_25.pushState(var9_12);
                break block12;
            }
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        IrClass objectClass = (IrClass)expression2.getSymbol().getOwner();
        if (Wrapper.Companion.mustBeHandledWithWrapper(objectClass)) {
            Wrapper result2 = Wrapper.Companion.getCompanionObject(objectClass, this.getEnvironment());
            this.getEnvironment().getMapOfObjects$ir_interpreter().put(expression2.getSymbol(), result2);
            this.callStack.pushState(result2);
        } else {
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptEnumEntry(@NotNull IrEnumEntry enumEntry, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        IrClass enumClass = IrUtilsKt.getParentAsClass((IrDeclaration)enumEntry.getSymbol().getOwner());
        if (Wrapper.Companion.mustBeHandledWithWrapper(enumClass)) {
            State enumEntryName = this.getEnvironment().convertToState$ir_interpreter(enumEntry.getName().asString(), this.getEnvironment().getIrBuiltIns().getStringType());
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(enumClass);
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"valueOf")) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction valueOfFun = single$iv;
            this.invokeMethod(Wrapper.Companion.getEnumEntry(enumClass), valueOfFun, CollectionsKt.listOf((Object)enumEntryName));
            Map<IrSymbol, Complex> map = this.getEnvironment().getMapOfEnums$ir_interpreter();
            IrEnumEntrySymbol irEnumEntrySymbol = enumEntry.getSymbol();
            State state = this.callStack.popState();
            Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
            Complex complex = (Complex)state;
            map.put(irEnumEntrySymbol, complex);
        } else {
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptJavaStaticField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        ExceptionUtilsKt.verify(Intrinsics.areEqual((Object)field.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) && field.isStatic());
        IrExpressionBody irExpressionBody = field.getInitializer();
        ExceptionUtilsKt.verify(!((irExpressionBody != null ? irExpressionBody.getExpression() : null) instanceof IrConst));
        this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(Wrapper.Companion.getStaticGetter(field).invokeWithArguments(new Object[0]), field.getType()));
    }

    private final void invokeMethod(MethodHandle $this$invokeMethod, IrFunction irFunction, List<? extends State> args) {
        if ($this$invokeMethod == null) {
            boolean value$iv = this.handleIntrinsicMethods(irFunction);
            boolean $i$f$verify = false;
            if (!value$iv) {
                boolean bl = false;
                String string2 = ("Unsupported intrinsic function: " + RenderIrElementKt.render$default(irFunction, null, 1, null)).toString();
                throw new InterpreterAssertionError(string2);
            }
            return;
        }
        CallInterceptor callInterceptor = this;
        MethodType methodType = $this$invokeMethod.type();
        Intrinsics.checkNotNullExpressionValue((Object)methodType, (String)"type(...)");
        List<Object> argsForMethodInvocation = UtilsKt.getArgsForMethodInvocation(irFunction, callInterceptor, methodType, args);
        IrInterpreterEnvironment environment$iv = this.getEnvironment();
        boolean $i$f$withExceptionHandler = false;
        try {
            boolean bl = false;
            Object result2 = $this$invokeMethod.invokeWithArguments(argsForMethodInvocation);
            this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(result2, this.getType(result2, irFunction.getReturnType())));
        }
        catch (InterpreterException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            ExceptionUtilsKt.handleUserException(e$iv, environment$iv);
        }
    }

    private final boolean handleIntrinsicMethods(IrFunction irFunction) {
        List<Instruction> list = IntrinsicEvaluator.INSTANCE.unwindInstructions(irFunction, this.getEnvironment());
        if (list == null) {
            return false;
        }
        List<Instruction> instructions = list;
        Iterable $this$forEach$iv = instructions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Instruction it = (Instruction)element$iv;
            boolean bl = false;
            this.callStack.pushInstruction(it);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateBuiltIns(IrFunction irFunction, List<? extends State> args) {
        IrType it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        IrProperty property = UtilsKt.getProperty(irFunction);
        String string2 = property == null ? irFunction.getName().asString() : property.getName().asString();
        Intrinsics.checkNotNull((Object)string2);
        String methodName = string2;
        IrAnnotationContainer irAnnotationContainer = irFunction.getDispatchReceiverParameter();
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            IrValueParameter irValueParameter = irFunction.getExtensionReceiverParameter();
            irAnnotationContainer = irValueParameter != null ? irValueParameter.getType() : null;
        }
        IrAnnotationContainer receiverType = irAnnotationContainer;
        Iterable iterable = irFunction.getValueParameters();
        Collection collection = CollectionsKt.listOfNotNull((Object)receiverType);
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getType());
        }
        $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilsKt.fqNameWithNullability(it));
        }
        List argsType = (List)destination$iv$iv;
        List argsValues = ProxyKt.wrap$default(args, (CallInterceptor)this, irFunction, null, 4, null);
        IrInterpreterEnvironment environment$iv = this.getEnvironment();
        boolean $i$f$withExceptionHandler = false;
        try {
            Collection<Arg> collection3;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)methodName, (Object)"rangeTo")) {
                this.calculateRangeTo(irFunction.getReturnType(), args);
                return;
            }
            Iterable $i$f$mapTo2 = CollectionsKt.zip((Iterable)argsType, (Iterable)argsValues);
            String string3 = methodName;
            DefaultCallInterceptor defaultCallInterceptor = this;
            boolean $i$f$map2 = false;
            void var16_23 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                Pair pair = (Pair)item$iv$iv;
                collection3 = destination$iv$iv2;
                boolean bl2 = false;
                collection3.add(new Arg((String)it2.getFirst(), it2.getSecond()));
            }
            collection3 = (List)destination$iv$iv2;
            List list = collection3;
            String string4 = string3;
            Object result2 = defaultCallInterceptor.interpretBuiltinFunction(new Signature(string4, list));
            this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(result2, this.getType(result2, irFunction.getReturnType())));
        }
        catch (InterpreterException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            ExceptionUtilsKt.handleUserException(e$iv, environment$iv);
        }
    }

    private final Object interpretBuiltinFunction(Signature signature) {
        Object object;
        String name2 = signature.getName();
        List<Arg> args = signature.getArgs();
        switch (args.size()) {
            case 1: {
                object = IrBuiltInsMapGeneratedKt.interpretUnaryFunction(name2, args.get(0).getType(), args.get(0).getValue());
                break;
            }
            case 2: {
                object = IrBuiltInsMapGeneratedKt.interpretBinaryFunction(name2, args.get(0).getType(), args.get(1).getType(), args.get(0).getValue(), args.get(1).getValue());
                break;
            }
            case 3: {
                object = IrBuiltInsMapGeneratedKt.interpretTernaryFunction(name2, args.get(0).getType(), args.get(1).getType(), args.get(2).getType(), args.get(0).getValue(), args.get(1).getValue(), args.get(2).getValue());
                break;
            }
            default: {
                throw new InterpreterError("Unsupported number of arguments for invocation as builtin function: " + name2);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateRangeTo(IrType type2, List<? extends State> args) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(type2);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        IrConstructor constructor = (IrConstructor)SequencesKt.first(IrUtilsKt.getConstructors((IrClass)irClassSymbol.getOwner()));
        IrConstructorCall constructorCall = IrTreeBuildUtilsKt.createConstructorCall$default(constructor, null, 1, null);
        Iterable $this$map$iv = constructor.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        List constructorValueParameters = (List)destination$iv$iv;
        Iterable $this$map$iv2 = args;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            State bl = (State)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
            collection.add((Primitive)it);
        }
        List primitiveValueParameters = (List)destination$iv$iv2;
        Iterable $this$forEachIndexed$iv = primitiveValueParameters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void primitive;
            int n;
            Object item$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (Primitive)item$iv;
            int index = n;
            boolean bl = false;
            constructorCall.putValueArgument(index, IrUtilsKt.toIrConst$default(primitive.getValue(), ((IrValueParameter)((IrValueParameterSymbol)constructorValueParameters.get(index)).getOwner()).getType(), 0, 0, 6, null));
        }
        InstructionKt.pushCompoundInstruction(this.callStack, constructorCall);
    }

    private final IrType getType(Object $this$getType, IrType defaultType) {
        Object object = $this$getType;
        return object instanceof Boolean ? this.getIrBuiltIns().getBooleanType() : (object instanceof Character ? this.getIrBuiltIns().getCharType() : (object instanceof Byte ? this.getIrBuiltIns().getByteType() : (object instanceof Short ? this.getIrBuiltIns().getShortType() : (object instanceof Integer ? this.getIrBuiltIns().getIntType() : (object instanceof Long ? this.getIrBuiltIns().getLongType() : (object instanceof String ? this.getIrBuiltIns().getStringType() : (object instanceof Float ? this.getIrBuiltIns().getFloatType() : (object instanceof Double ? this.getIrBuiltIns().getDoubleType() : (object == null ? this.getIrBuiltIns().getNothingNType() : defaultType)))))))));
    }

    private final IrElement trySubstituteFunctionBody(IrFunction $this$trySubstituteFunctionBody) {
        IdSignature idSignature = $this$trySubstituteFunctionBody.getSymbol().getSignature();
        if (idSignature == null) {
            return null;
        }
        IdSignature signature = idSignature;
        IrBody irBody = this.bodyMap.get(signature);
        if (irBody == null) {
            return null;
        }
        $this$trySubstituteFunctionBody.setBody(irBody);
        InstructionKt.pushCompoundInstruction(this.callStack, $this$trySubstituteFunctionBody);
        return $this$trySubstituteFunctionBody.getBody();
    }

    private static final Unit interceptProxy$lambda$1(IrCall $irCall, List $valueArguments, IrInterpreter $this$withNewCallStack) {
        Intrinsics.checkNotNullParameter((Object)$this$withNewCallStack, (String)"$this$withNewCallStack");
        InstructionKt.pushSimpleInstruction($this$withNewCallStack.getEnvironment$ir_interpreter().getCallStack$ir_interpreter(), $irCall);
        Iterable $this$forEach$iv = $valueArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            State it = (State)element$iv;
            boolean bl = false;
            $this$withNewCallStack.getEnvironment$ir_interpreter().getCallStack$ir_interpreter().pushState(it);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u001f\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor$Arg;", "", "type", "", "value", "<init>", "(Ljava/lang/String;Ljava/lang/Object;)V", "getType", "()Ljava/lang/String;", "setType", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.interpreter"})
    private static final class Arg {
        @NotNull
        private String type;
        @Nullable
        private Object value;

        public Arg(@NotNull String type2, @Nullable Object value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            this.type = type2;
            this.value = value2;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final void setType(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.type = string2;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }

        public final void setValue(@Nullable Object object) {
            this.value = object;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @Nullable
        public final Object component2() {
            return this.value;
        }

        @NotNull
        public final Arg copy(@NotNull String type2, @Nullable Object value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new Arg(type2, value2);
        }

        public static /* synthetic */ Arg copy$default(Arg arg, String string2, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                string2 = arg.type;
            }
            if ((n & 2) != 0) {
                object = arg.value;
            }
            return arg.copy(string2, object);
        }

        @NotNull
        public String toString() {
            return "Arg(type=" + this.type + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Arg)) {
                return false;
            }
            Arg arg = (Arg)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)arg.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)arg.value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor$Signature;", "", "name", "", "args", "", "Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor$Arg;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getArgs", "()Ljava/util/List;", "setArgs", "(Ljava/util/List;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.interpreter"})
    private static final class Signature {
        @NotNull
        private String name;
        @NotNull
        private List<Arg> args;

        public Signature(@NotNull String name2, @NotNull List<Arg> args) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            this.name = name2;
            this.args = args;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.name = string2;
        }

        @NotNull
        public final List<Arg> getArgs() {
            return this.args;
        }

        public final void setArgs(@NotNull List<Arg> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.args = list;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<Arg> component2() {
            return this.args;
        }

        @NotNull
        public final Signature copy(@NotNull String name2, @NotNull List<Arg> args) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return new Signature(name2, args);
        }

        public static /* synthetic */ Signature copy$default(Signature signature, String string2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = signature.name;
            }
            if ((n & 2) != 0) {
                list = signature.args;
            }
            return signature.copy(string2, list);
        }

        @NotNull
        public String toString() {
            return "Signature(name=" + this.name + ", args=" + this.args + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + ((Object)this.args).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Signature)) {
                return false;
            }
            Signature signature = (Signature)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)signature.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.args, signature.args);
        }
    }
}

