#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/types.h>
#include <unistd.h>
#include <glib.h>

GString *
libmt_read_line (int sock)
{
  char c;
  GString *gs;

  gs = g_string_sized_new (30);	/* put another initial value if 30 is not optimal */
  c = '\0';
  while (c != '\n')
    {
      int l = read (sock, &c, sizeof (char));
      if (l != sizeof (char))
	{
	  g_string_free (gs, TRUE);
	  return (NULL);
	}
      gs = g_string_append_c (gs, c);
    }
  return (gs);
}

char **
libmt_convert_line_to_array (GString * gs)
{
  char **a;
  int p0, p1, p2, n;
  p1 = 0;
  p2 = 0;
  n = 0;
/* Count the number of separators */
  for (p1 = 0; gs->str[p1]; p1++)
    {
      if (gs->str[p1] == ' ')
	{
	  n++;
	  /* Test here if the separator is escaped */
	  /* Notice that the following can deal with "\\\\\\ " strings */
	  p2 = p1 - 1;
	  while (p2 >= 0)
	    {
	      if (gs->str[p2] != '\\')
		break;
	      p2--;
	    }
	  p2++;
	  if ((p1 - p2) % 2)
	    n--;
	}
    }

  a = g_malloc ((n + 2) * sizeof (char *));

  p0 = 0;
  n = 0;
  for (p1 = 0; gs->str[p1]; p1++)
    {
      if (gs->str[p1] == ' ')
	{
	  p2 = p1 - 1;
	  while (p2 >= p0)
	    {
	      if (gs->str[p2] != '\\')
		break;
	      p2--;
	    }
	  p2++;
	  if (!((p1 - p2) % 2))
	    {
	      a[n] = g_strndup (&(gs->str[p0]), p1 - p0);
	      n++;
	      p0 = p1 + 1;
	    }
	}
    }
  a[n++] = g_strdup (&(gs->str[p0]));
  a[n] = NULL;

  /* remove backslashs */
  for (n = 0; a[n]; n++)
    {
      p1 = 0;
      for (p2 = 0; a[n][p2]; p2++)
	{
	  if (a[n][p2] == '\\')
	    {
	      p2++;
	    }
	  a[n][p1++] = a[n][p2];
	  if (!a[n][p2])
	    break;
	}
    }
  return (a);
}

GString *
libmt_convert_array_to_line (char **a)
{
  GString *gs = g_string_sized_new (30);
  int n = 0;

  for (n = 0; a[n]; n++)
    {
      int i;
      for (i = 0; a[n][i]; i++)
	{
	  if ((a[n][i] == ' ') || (a[n][i] == '\\'))
	    gs = g_string_append_c (gs, '\\');
	  gs = g_string_append_c (gs, a[n][i]);
	}
      gs = g_string_append_c (gs, ' ');
    }
  return (gs);
}

GString *
libmt_new_message_string (int n, ...)
{
  va_list args;
  char **a;
  int i;
  GString *gs;

  va_start (args, n);

  a = g_malloc ((n + 1) * sizeof (char *));
  for (i = 0; i < n; i++)
    {
      a[i] = va_arg (args, char *);
    }
  va_end (args);
  a[n] = NULL;

  gs = libmt_convert_array_to_line (a);
  g_free (a);
  return (gs);
}
