/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.OID;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CRLDistributionPoint;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.X509CertificateExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CRLDistributionPointsExtension
extends X509CertificateExtension {
    @NotNull
    public static final OID CRL_DISTRIBUTION_POINTS_OID = new OID("2.5.29.31");
    private static final long serialVersionUID = -4710958813506834961L;
    @NotNull
    private final List<CRLDistributionPoint> crlDistributionPoints;

    CRLDistributionPointsExtension(boolean isCritical, @NotNull List<CRLDistributionPoint> crlDistributionPoints) throws CertException {
        super(CRL_DISTRIBUTION_POINTS_OID, isCritical, CRLDistributionPointsExtension.encodeValue(crlDistributionPoints));
        this.crlDistributionPoints = crlDistributionPoints;
    }

    CRLDistributionPointsExtension(@NotNull X509CertificateExtension extension) throws CertException {
        super(extension);
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(extension.getValue()).elements();
            ArrayList<CRLDistributionPoint> dps = new ArrayList<CRLDistributionPoint>(elements.length);
            for (ASN1Element e : elements) {
                dps.add(new CRLDistributionPoint(e));
            }
            this.crlDistributionPoints = Collections.unmodifiableList(dps);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CRL_DP_EXTENSION_CANNOT_PARSE.get(String.valueOf(extension), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static byte[] encodeValue(@NotNull List<CRLDistributionPoint> crlDistributionPoints) throws CertException {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(crlDistributionPoints.size());
        for (CRLDistributionPoint p : crlDistributionPoints) {
            elements.add(p.encode());
        }
        return new ASN1Sequence(elements).encode();
    }

    @NotNull
    public List<CRLDistributionPoint> getCRLDistributionPoints() {
        return this.crlDistributionPoints;
    }

    @Override
    @NotNull
    public String getExtensionName() {
        return CertMessages.INFO_CRL_DP_EXTENSION_NAME.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("CRLDistributionPointsExtension(oid='");
        buffer.append(this.getOID());
        buffer.append("', isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", distributionPoints={");
        Iterator<CRLDistributionPoint> iterator = this.crlDistributionPoints.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

