package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFilteringAlgorithms invokes the airec.ListFilteringAlgorithms API synchronously
func (client *Client) ListFilteringAlgorithms(request *ListFilteringAlgorithmsRequest) (response *ListFilteringAlgorithmsResponse, err error) {
	response = CreateListFilteringAlgorithmsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFilteringAlgorithmsWithChan invokes the airec.ListFilteringAlgorithms API asynchronously
func (client *Client) ListFilteringAlgorithmsWithChan(request *ListFilteringAlgorithmsRequest) (<-chan *ListFilteringAlgorithmsResponse, <-chan error) {
	responseChan := make(chan *ListFilteringAlgorithmsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFilteringAlgorithms(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFilteringAlgorithmsWithCallback invokes the airec.ListFilteringAlgorithms API asynchronously
func (client *Client) ListFilteringAlgorithmsWithCallback(request *ListFilteringAlgorithmsRequest, callback func(response *ListFilteringAlgorithmsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFilteringAlgorithmsResponse
		var err error
		defer close(result)
		response, err = client.ListFilteringAlgorithms(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFilteringAlgorithmsRequest is the request struct for api ListFilteringAlgorithms
type ListFilteringAlgorithmsRequest struct {
	*requests.RoaRequest
	InstanceId  string           `position:"Path" name:"instanceId"`
	Size        requests.Integer `position:"Query" name:"size"`
	Page        requests.Integer `position:"Query" name:"page"`
	Status      string           `position:"Query" name:"status"`
	AlgorithmId string           `position:"Query" name:"algorithmId"`
}

// ListFilteringAlgorithmsResponse is the response struct for api ListFilteringAlgorithms
type ListFilteringAlgorithmsResponse struct {
	*responses.BaseResponse
	RequestId string               `json:"requestId" xml:"requestId"`
	Headers   Headers              `json:"headers" xml:"headers"`
	Result    []FilteringAlgorithm `json:"result" xml:"result"`
}

// CreateListFilteringAlgorithmsRequest creates a request to invoke ListFilteringAlgorithms API
func CreateListFilteringAlgorithmsRequest() (request *ListFilteringAlgorithmsRequest) {
	request = &ListFilteringAlgorithmsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ListFilteringAlgorithms", "/v2/openapi/instances/[instanceId]/filtering-algorithms", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListFilteringAlgorithmsResponse creates a response to parse from ListFilteringAlgorithms response
func CreateListFilteringAlgorithmsResponse() (response *ListFilteringAlgorithmsResponse) {
	response = &ListFilteringAlgorithmsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
