package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateServiceVersion invokes the eas.UpdateServiceVersion API synchronously
func (client *Client) UpdateServiceVersion(request *UpdateServiceVersionRequest) (response *UpdateServiceVersionResponse, err error) {
	response = CreateUpdateServiceVersionResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateServiceVersionWithChan invokes the eas.UpdateServiceVersion API asynchronously
func (client *Client) UpdateServiceVersionWithChan(request *UpdateServiceVersionRequest) (<-chan *UpdateServiceVersionResponse, <-chan error) {
	responseChan := make(chan *UpdateServiceVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateServiceVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateServiceVersionWithCallback invokes the eas.UpdateServiceVersion API asynchronously
func (client *Client) UpdateServiceVersionWithCallback(request *UpdateServiceVersionRequest, callback func(response *UpdateServiceVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateServiceVersionResponse
		var err error
		defer close(result)
		response, err = client.UpdateServiceVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateServiceVersionRequest is the request struct for api UpdateServiceVersion
type UpdateServiceVersionRequest struct {
	*requests.RoaRequest
	ServiceName string `position:"Path" name:"ServiceName"`
	ClusterId   string `position:"Path" name:"ClusterId"`
	Body        string `position:"Body" name:"body"`
}

// UpdateServiceVersionResponse is the response struct for api UpdateServiceVersion
type UpdateServiceVersionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUpdateServiceVersionRequest creates a request to invoke UpdateServiceVersion API
func CreateUpdateServiceVersionRequest() (request *UpdateServiceVersionRequest) {
	request = &UpdateServiceVersionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "UpdateServiceVersion", "/api/v2/services/[ClusterId]/[ServiceName]/version", "eas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateServiceVersionResponse creates a response to parse from UpdateServiceVersion response
func CreateUpdateServiceVersionResponse() (response *UpdateServiceVersionResponse) {
	response = &UpdateServiceVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
