package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveLazyPullStreamInfoConfig invokes the live.DeleteLiveLazyPullStreamInfoConfig API synchronously
func (client *Client) DeleteLiveLazyPullStreamInfoConfig(request *DeleteLiveLazyPullStreamInfoConfigRequest) (response *DeleteLiveLazyPullStreamInfoConfigResponse, err error) {
	response = CreateDeleteLiveLazyPullStreamInfoConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveLazyPullStreamInfoConfigWithChan invokes the live.DeleteLiveLazyPullStreamInfoConfig API asynchronously
func (client *Client) DeleteLiveLazyPullStreamInfoConfigWithChan(request *DeleteLiveLazyPullStreamInfoConfigRequest) (<-chan *DeleteLiveLazyPullStreamInfoConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveLazyPullStreamInfoConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveLazyPullStreamInfoConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveLazyPullStreamInfoConfigWithCallback invokes the live.DeleteLiveLazyPullStreamInfoConfig API asynchronously
func (client *Client) DeleteLiveLazyPullStreamInfoConfigWithCallback(request *DeleteLiveLazyPullStreamInfoConfigRequest, callback func(response *DeleteLiveLazyPullStreamInfoConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveLazyPullStreamInfoConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveLazyPullStreamInfoConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveLazyPullStreamInfoConfigRequest is the request struct for api DeleteLiveLazyPullStreamInfoConfig
type DeleteLiveLazyPullStreamInfoConfigRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	AppName    string           `position:"Query" name:"AppName"`
}

// DeleteLiveLazyPullStreamInfoConfigResponse is the response struct for api DeleteLiveLazyPullStreamInfoConfig
type DeleteLiveLazyPullStreamInfoConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveLazyPullStreamInfoConfigRequest creates a request to invoke DeleteLiveLazyPullStreamInfoConfig API
func CreateDeleteLiveLazyPullStreamInfoConfigRequest() (request *DeleteLiveLazyPullStreamInfoConfigRequest) {
	request = &DeleteLiveLazyPullStreamInfoConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveLazyPullStreamInfoConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveLazyPullStreamInfoConfigResponse creates a response to parse from DeleteLiveLazyPullStreamInfoConfig response
func CreateDeleteLiveLazyPullStreamInfoConfigResponse() (response *DeleteLiveLazyPullStreamInfoConfigResponse) {
	response = &DeleteLiveLazyPullStreamInfoConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
