package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListZnodeChildren invokes the mse.ListZnodeChildren API synchronously
func (client *Client) ListZnodeChildren(request *ListZnodeChildrenRequest) (response *ListZnodeChildrenResponse, err error) {
	response = CreateListZnodeChildrenResponse()
	err = client.DoAction(request, response)
	return
}

// ListZnodeChildrenWithChan invokes the mse.ListZnodeChildren API asynchronously
func (client *Client) ListZnodeChildrenWithChan(request *ListZnodeChildrenRequest) (<-chan *ListZnodeChildrenResponse, <-chan error) {
	responseChan := make(chan *ListZnodeChildrenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListZnodeChildren(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListZnodeChildrenWithCallback invokes the mse.ListZnodeChildren API asynchronously
func (client *Client) ListZnodeChildrenWithCallback(request *ListZnodeChildrenRequest, callback func(response *ListZnodeChildrenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListZnodeChildrenResponse
		var err error
		defer close(result)
		response, err = client.ListZnodeChildren(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListZnodeChildrenRequest is the request struct for api ListZnodeChildren
type ListZnodeChildrenRequest struct {
	*requests.RpcRequest
	ClusterId      string `position:"Query" name:"ClusterId"`
	Path           string `position:"Query" name:"Path"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// ListZnodeChildrenResponse is the response struct for api ListZnodeChildren
type ListZnodeChildrenResponse struct {
	*responses.BaseResponse
	Message   string       `json:"Message" xml:"Message"`
	RequestId string       `json:"RequestId" xml:"RequestId"`
	ErrorCode string       `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool         `json:"Success" xml:"Success"`
	Data      []ZnodeModel `json:"Data" xml:"Data"`
}

// CreateListZnodeChildrenRequest creates a request to invoke ListZnodeChildren API
func CreateListZnodeChildrenRequest() (request *ListZnodeChildrenRequest) {
	request = &ListZnodeChildrenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListZnodeChildren", "", "")
	request.Method = requests.GET
	return
}

// CreateListZnodeChildrenResponse creates a response to parse from ListZnodeChildren response
func CreateListZnodeChildrenResponse() (response *ListZnodeChildrenResponse) {
	response = &ListZnodeChildrenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
