package sas_api

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccountProfileByKey invokes the sas_api.DescribeAccountProfileByKey API synchronously
// api document: https://help.aliyun.com/api/sas-api/describeaccountprofilebykey.html
func (client *Client) DescribeAccountProfileByKey(request *DescribeAccountProfileByKeyRequest) (response *DescribeAccountProfileByKeyResponse, err error) {
	response = CreateDescribeAccountProfileByKeyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccountProfileByKeyWithChan invokes the sas_api.DescribeAccountProfileByKey API asynchronously
// api document: https://help.aliyun.com/api/sas-api/describeaccountprofilebykey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccountProfileByKeyWithChan(request *DescribeAccountProfileByKeyRequest) (<-chan *DescribeAccountProfileByKeyResponse, <-chan error) {
	responseChan := make(chan *DescribeAccountProfileByKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccountProfileByKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccountProfileByKeyWithCallback invokes the sas_api.DescribeAccountProfileByKey API asynchronously
// api document: https://help.aliyun.com/api/sas-api/describeaccountprofilebykey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccountProfileByKeyWithCallback(request *DescribeAccountProfileByKeyRequest, callback func(response *DescribeAccountProfileByKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccountProfileByKeyResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccountProfileByKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccountProfileByKeyRequest is the request struct for api DescribeAccountProfileByKey
type DescribeAccountProfileByKeyRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Keyword  string `position:"Query" name:"Keyword"`
}

// DescribeAccountProfileByKeyResponse is the response struct for api DescribeAccountProfileByKey
type DescribeAccountProfileByKeyResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Ip           string `json:"Ip" xml:"Ip"`
	IpInfo       string `json:"IpInfo" xml:"IpInfo"`
	Phone        string `json:"Phone" xml:"Phone"`
	PhoneInfo    string `json:"PhoneInfo" xml:"PhoneInfo"`
	KeywordCount int    `json:"KeywordCount" xml:"KeywordCount"`
	KeywordLimit int    `json:"KeywordLimit" xml:"KeywordLimit"`
}

// CreateDescribeAccountProfileByKeyRequest creates a request to invoke DescribeAccountProfileByKey API
func CreateDescribeAccountProfileByKeyRequest() (request *DescribeAccountProfileByKeyRequest) {
	request = &DescribeAccountProfileByKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas-api", "2017-07-05", "DescribeAccountProfileByKey", "sas-api", "openAPI")
	return
}

// CreateDescribeAccountProfileByKeyResponse creates a response to parse from DescribeAccountProfileByKey response
func CreateDescribeAccountProfileByKeyResponse() (response *DescribeAccountProfileByKeyResponse) {
	response = &DescribeAccountProfileByKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
