/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.validation;

import java.util.List;
import java.util.Objects;
import javax.measure.Quantity;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.library.CoreItemFactory;
import org.openhab.core.model.items.ItemsPackage;
import org.openhab.core.model.items.ModelItem;
import org.openhab.core.model.validation.AbstractItemsValidator;
import org.openhab.core.types.util.UnitUtils;

public class ItemsValidator
extends AbstractItemsValidator {
    @Check
    public void checkItemName(ModelItem item) {
        boolean _not;
        if (item == null || item.getName() == null) {
            return;
        }
        boolean _isValidItemName = ItemUtil.isValidItemName((String)item.getName());
        boolean bl = _not = !_isValidItemName;
        if (_not) {
            String _name = item.getName();
            String _plus = "Item name \"" + _name;
            String _plus_1 = _plus + "\" is invalid. It must begin with a letter or underscore followed by alphanumeric characters and underscores, and must not contain any other symbols.";
            this.error(_plus_1, (EStructuralFeature)ItemsPackage.Literals.MODEL_ITEM__NAME);
        }
    }

    @Check
    public void checkValidItemType(ModelItem item) {
        block13: {
            block11: {
                if (item == null || item.getType() == null) {
                    return;
                }
                String[] segments = item.getType().split(":");
                String mainType = segments[0];
                if (mainType == null) break block11;
                switch (mainType) {
                    case "Group": {
                        this.checkGroupType(item, segments);
                        break;
                    }
                    case "Number": {
                        this.checkNumberType(item, segments);
                        break;
                    }
                    default: {
                        this.checkBasicItemType(item);
                        break;
                    }
                }
                break block13;
            }
            this.checkBasicItemType(item);
        }
    }

    public void checkNumberType(ModelItem item, String[] segments) {
        int _size = ((List)Conversions.doWrapArray((Object)segments)).size();
        switch (_size) {
            case 1: {
                return;
            }
            case 2: {
                this.checkDimension(item, segments[1]);
                break;
            }
            default: {
                String _name = item.getName();
                String _plus = "Item: '" + _name;
                String _plus_1 = _plus + "' has an invalid Number type, too many segments: ";
                String _type = item.getType();
                String _plus_2 = _plus_1 + _type;
                this.error(_plus_2, (EStructuralFeature)ItemsPackage.Literals.MODEL_ITEM__TYPE);
            }
        }
    }

    public void checkBasicItemType(ModelItem item) {
        boolean _not;
        boolean _contains = CoreItemFactory.VALID_ITEM_TYPES.contains(item.getType());
        boolean bl = _not = !_contains;
        if (_not) {
            String _name = item.getName();
            String _plus = "Item '" + _name;
            String _plus_1 = _plus + "' has an invalid type: '";
            String _type = item.getType();
            String _plus_2 = _plus_1 + _type;
            String _plus_3 = _plus_2 + "'";
            this.error(_plus_3, (EStructuralFeature)ItemsPackage.Literals.MODEL_ITEM__TYPE);
        }
    }

    public void checkGroupType(ModelItem item, String[] segments) {
        int _size = ((List)Conversions.doWrapArray((Object)segments)).size();
        switch (_size) {
            case 1: {
                return;
            }
            case 2: {
                this.checkGroupBaseType(item, segments[1]);
                break;
            }
            case 3: {
                this.checkGroupWithOneParam(item, segments[1], segments[2]);
                break;
            }
            case 4: {
                this.checkGroupWithTwoParams(item, segments[1], segments[2], segments[3]);
            }
        }
    }

    public void checkGroupBaseType(ModelItem item, String baseType) {
        boolean _not;
        boolean _contains = CoreItemFactory.VALID_ITEM_TYPES.contains(baseType);
        boolean bl = _not = !_contains;
        if (_not) {
            String _name = item.getName();
            String _plus = "Item '" + _name;
            String _plus_1 = _plus + "' has an invalid base item type: '";
            String _plus_2 = _plus_1 + baseType;
            String _plus_3 = _plus_2 + "'";
            this.error(_plus_3, (EStructuralFeature)ItemsPackage.Literals.MODEL_ITEM__TYPE);
        }
    }

    public Class<? extends Quantity<?>> checkGroupWithOneParam(ModelItem item, String baseType, String param) {
        Class<? extends Quantity<?>> _xblockexpression = null;
        this.checkGroupBaseType(item, baseType);
        Class<? extends Quantity<?>> _xifexpression = null;
        if (item.getArgs().size() == 0 && Objects.equals(baseType, "Number")) {
            boolean _not;
            Class<? extends Quantity<?>> _xifexpression_1 = null;
            boolean _isValidGroupFunction = this.isValidGroupFunction(param);
            boolean bl = _not = !_isValidGroupFunction;
            if (_not) {
                _xifexpression_1 = this.checkDimension(item, param);
            }
            _xifexpression = _xifexpression_1;
        } else {
            this.checkGroupFunction(item, param);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void checkGroupWithTwoParams(ModelItem item, String baseType, String dimension, String function) {
        this.checkGroupBaseType(item, baseType);
        boolean _equals = Objects.equals(baseType, "Number");
        if (_equals) {
            this.checkDimension(item, dimension);
        } else {
            String _name = item.getName();
            String _plus = "Item '" + _name;
            String _plus_1 = _plus + "' with type '";
            String _type = item.getType();
            String _plus_2 = _plus_1 + _type;
            String _plus_3 = _plus_2 + "' cannot have a dimension. Dimensions are only valid for Number base type. The dimension '";
            String _plus_4 = _plus_3 + dimension;
            String _plus_5 = _plus_4 + "' is ignored.";
            this.error(_plus_5, (EStructuralFeature)ItemsPackage.Literals.MODEL_ITEM__TYPE);
        }
        this.checkGroupFunction(item, function);
    }

    public Class<? extends Quantity<?>> checkDimension(ModelItem item, String dimension) {
        Class _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = UnitUtils.parseDimension((String)dimension);
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                String _name = item.getName();
                String _plus = "Item '" + _name;
                String _plus_1 = _plus + "' has an unknown dimension: '";
                String _plus_2 = _plus_1 + dimension;
                String _plus_3 = _plus_2 + "'. The Item will not be created.";
                this.error(_plus_3, (EStructuralFeature)ItemsPackage.Literals.MODEL_ITEM__TYPE);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    public void checkGroupFunction(ModelItem item, String function) {
        boolean _not;
        boolean _isValidGroupFunction = this.isValidGroupFunction(function);
        boolean bl = _not = !_isValidGroupFunction;
        if (_not) {
            String _name = item.getName();
            String _plus = "Item '" + _name;
            String _plus_1 = _plus + "' has an unknown group function: '";
            String _plus_2 = _plus_1 + function;
            String _plus_3 = _plus_2 + "'. Using EQUALITY instead.";
            this.warning(_plus_3, (EStructuralFeature)ItemsPackage.Literals.MODEL_ITEM__TYPE);
        }
    }

    public boolean isValidGroupFunction(String value) {
        return GroupFunction.VALID_FUNCTIONS.contains(value);
    }
}

