/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class CliProcessResult {
    @NotNull
    private final PostAction postAction;
    private final short exitCode;
    @Nullable
    private final String output;

    public CliProcessResult(@NotNull PostAction postAction) {
        this(postAction, null, postAction.defaultExitCode);
    }

    public CliProcessResult(@NotNull PostAction postAction, short exitCode) {
        this(postAction, null, exitCode);
    }

    public CliProcessResult(@NotNull PostAction postAction, @Nullable String output) {
        this(postAction, output, postAction.defaultExitCode);
    }

    public CliProcessResult(@NotNull PostAction postAction, @Nullable String output, short exitCode) {
        this.postAction = postAction;
        this.output = output;
        this.exitCode = exitCode;
    }

    @NotNull
    public PostAction getPostAction() {
        return this.postAction;
    }

    @Nullable
    public String getOutput() {
        return this.output;
    }

    public short getExitCode() {
        return this.exitCode;
    }

    public static enum PostAction {
        START_INSTANCE(-1),
        SHUTDOWN(0),
        ERROR(1),
        UNKNOWN_COMMAND(2);

        private final short defaultExitCode;

        private PostAction(short exitCode) {
            this.defaultExitCode = exitCode;
        }
    }
}

