/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader.relax.core.checker;

import com.sun.msv.datatype.xsd.IDREFType;
import com.sun.msv.datatype.xsd.IDType;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.relax.AttPoolClause;
import com.sun.msv.grammar.relax.ElementRules;
import com.sun.msv.grammar.relax.HedgeRules;
import com.sun.msv.grammar.relax.RELAXExpressionVisitorVoid;
import com.sun.msv.grammar.relax.RELAXModule;
import com.sun.msv.grammar.relax.TagClause;
import com.sun.msv.reader.relax.core.RELAXCoreReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.relaxng.datatype.Datatype;

public class IdAbuseChecker
implements RELAXExpressionVisitorVoid {
    private final Set tagNames = new HashSet();
    private final Set overloadedNames = new HashSet();
    private final Set nonIdAttrNames = new HashSet();
    private final Set idAttributes = new HashSet();
    private final RELAXModule module;
    private final RELAXCoreReader reader;
    private String currentTagName;

    private IdAbuseChecker(RELAXCoreReader rELAXCoreReader, RELAXModule rELAXModule) {
        this.reader = rELAXCoreReader;
        this.module = rELAXModule;
    }

    public static void check(RELAXCoreReader rELAXCoreReader, RELAXModule rELAXModule) {
        new IdAbuseChecker(rELAXCoreReader, rELAXModule).run();
    }

    private void run() {
        Object object;
        Expression expression;
        Iterator iterator = this.module.tags.iterator();
        while (iterator.hasNext()) {
            expression = (TagClause)iterator.next();
            if (!(expression.nameClass instanceof SimpleNameClass)) continue;
            object = (SimpleNameClass)expression.nameClass;
            if (this.tagNames.contains(((SimpleNameClass)object).localName)) {
                this.overloadedNames.add(((SimpleNameClass)object).localName);
                continue;
            }
            this.tagNames.add(((SimpleNameClass)object).localName);
        }
        iterator = this.module.tags.iterator();
        while (iterator.hasNext()) {
            expression = (TagClause)iterator.next();
            this.currentTagName = expression.nameClass instanceof SimpleNameClass ? ((SimpleNameClass)expression.nameClass).localName : null;
            expression.exp.visit(this);
        }
        iterator = this.idAttributes.iterator();
        while (iterator.hasNext()) {
            expression = (AttributeExp)iterator.next();
            if (((AttributeExp)expression).nameClass instanceof SimpleNameClass) {
                object = ((SimpleNameClass)((AttributeExp)expression).nameClass).localName;
                if (!this.nonIdAttrNames.contains(object)) continue;
                this.reader.reportError("RELAXReader.IdAbuse.1", object);
                continue;
            }
            this.reader.reportError("RELAXReader.IdAbuse");
        }
    }

    public void onAttribute(AttributeExp attributeExp) {
        if (!(attributeExp.nameClass instanceof SimpleNameClass)) {
            return;
        }
        if (!(attributeExp.exp instanceof DataExp)) {
            return;
        }
        SimpleNameClass simpleNameClass = (SimpleNameClass)attributeExp.nameClass;
        if (!simpleNameClass.namespaceURI.equals("")) {
            return;
        }
        Datatype datatype = ((DataExp)attributeExp.exp).dt;
        if (datatype == IDType.theInstance || datatype == IDREFType.theInstance) {
            if (this.currentTagName == null || this.overloadedNames.contains(this.currentTagName)) {
                this.idAttributes.add(attributeExp);
            }
        } else {
            this.nonIdAttrNames.add(simpleNameClass.localName);
        }
    }

    public void onChoice(ChoiceExp choiceExp) {
        choiceExp.exp1.visit(this);
        choiceExp.exp2.visit(this);
    }

    public void onElement(ElementExp elementExp) {
        throw new Error();
    }

    public void onOneOrMore(OneOrMoreExp oneOrMoreExp) {
        oneOrMoreExp.exp.visit(this);
    }

    public void onMixed(MixedExp mixedExp) {
        throw new Error();
    }

    public void onRef(ReferenceExp referenceExp) {
        referenceExp.exp.visit(this);
    }

    public void onOther(OtherExp otherExp) {
        otherExp.exp.visit(this);
    }

    public void onEpsilon() {
    }

    public void onNullSet() {
    }

    public void onAnyString() {
    }

    public void onSequence(SequenceExp sequenceExp) {
    }

    public void onData(DataExp dataExp) {
        throw new Error();
    }

    public void onValue(ValueExp valueExp) {
        throw new Error();
    }

    public void onAttPool(AttPoolClause attPoolClause) {
        attPoolClause.exp.visit(this);
    }

    public void onTag(TagClause tagClause) {
        throw new Error();
    }

    public void onElementRules(ElementRules elementRules) {
        throw new Error();
    }

    public void onHedgeRules(HedgeRules hedgeRules) {
        throw new Error();
    }

    public void onInterleave(InterleaveExp interleaveExp) {
        throw new Error();
    }

    public void onConcur(ConcurExp concurExp) {
        throw new Error();
    }

    public void onList(ListExp listExp) {
        throw new Error();
    }
}

