--TEST--
test operations done in finite field and elliptic curve cryptography, using operator overloads. (GH-16870)
--DESCRIPTION--
Test overload operators of gmp with number sizes useful in cryptography.
It has the same content as `gmp_cryptography.phpt`, to which we refer for motivation of the operations.

The only difference in this file is that whenever possible operator overloads are used.
The reason is that while fixing GH-16870, it was noticed that the overload operators and the functions evolved independently.
--EXTENSIONS--
gmp
--FILE--
<?php
// 8192-bit MODP Group of https://datatracker.ietf.org/doc/html/rfc3526
$generator = gmp_init(2);
$prime = gmp_init('
FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1
29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD
EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245
E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7ED
EE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE45B3D
C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8 FD24CF5F
83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B
E39E772C 180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9
DE2BCBF6 95581718 3995497C EA956AE5 15D22618 98FA0510
15728E5A 8AAAC42D AD33170D 04507A33 A85521AB DF1CBA64
ECFB8504 58DBEF0A 8AEA7157 5D060C7D B3970F85 A6E1E4C7
ABF5AE8C DB0933D7 1E8C94E0 4A25619D CEE3D226 1AD2EE6B
F12FFA06 D98A0864 D8760273 3EC86A64 521F2B18 177B200C
BBE11757 7A615D6C 770988C0 BAD946E2 08E24FA0 74E5AB31
43DB5BFC E0FD108E 4B82D120 A9210801 1A723C12 A787E6D7
88719A10 BDBA5B26 99C32718 6AF4E23C 1A946834 B6150BDA
2583E9CA 2AD44CE8 DBBBC2DB 04DE8EF9 2E8EFC14 1FBECAA6
287C5947 4E6BC05D 99B2964F A090C3A2 233BA186 515BE7ED
1F612970 CEE2D7AF B81BDD76 2170481C D0069127 D5B05AA9
93B4EA98 8D8FDDC1 86FFB7DC 90A6C08F 4DF435C9 34028492
36C3FAB4 D27C7026 C1D4DCB2 602646DE C9751E76 3DBA37BD
F8FF9406 AD9E530E E5DB382F 413001AE B06A53ED 9027D831
179727B0 865A8918 DA3EDBEB CF9B14ED 44CE6CBA CED4BB1B
DB7F1447 E6CC254B 33205151 2BD7AF42 6FB8F401 378CD2BF
5983CA01 C64B92EC F032EA15 D1721D03 F482D7CE 6E74FEF6
D55E702F 46980C82 B5A84031 900B1C9E 59E7C97F BEC7E8F3
23A97A7E 36CC88BE 0F1D45B7 FF585AC5 4BD407B2 2B4154AA
CC8F6D7E BF48E1D8 14CC5ED2 0F8037E0 A79715EE F29BE328
06A1D58B B7C5DA76 F550AA3D 8A1FBFF0 EB19CCB1 A313D55C
DA56C9EC 2EF29632 387FE8D7 6E3C0468 043E8F66 3F4860EE
12BF2D5B 0B7474D6 E694F91E 6DBE1159 74A3926F 12FEE5E4
38777CB6 A932DF8C D8BEC4D0 73B931BA 3BC832B6 8D9DD300
741FA7BF 8AFC47ED 2576F693 6BA42466 3AAB639C 5AE4F568
3423B474 2BF1C978 238F16CB E39D652D E3FDB8BE FC848AD9
22222E04 A4037C07 13EB57A8 1A23F0C7 3473FC64 6CEA306B
4BCBC886 2F8385DD FA9D4B7F A2C087E8 79683303 ED5BDD3A
062B3CF5 B3A278A6 6D2A13F8 3F44F82D DF310EE0 74AB6A36
4597E899 A0255DC1 64F31CC5 0846851D F9AB4819 5DED7EA1
B1D510BD 7EE74D73 FAF36BC3 1ECFA268 359046F4 EB879F92
4009438B 481C6CD7 889A002E D5EE382B C9190DA6 FC026E47
9558E447 5677E9AA 9E3050E2 765694DF C81F56E8 80B96E71
60C980DD 98EDD3DF FFFFFFFF FFFFFFFF', 16);

$factor512 = gmp_init('
3F174D30 1AA08EF0 3556CF48 C6E53D8A 926067DA 50563B72 
42037431 C3144C7C A49937EF 1A6D940A 7228EC8E E2278808 
FD4C0344 D9E03882 A7C65C49 F47E843A', 16);

$factor = gmp_powm($generator, $factor512, $prime);
var_dump(gmp_strval($factor, 16));

$result = $factor + $prime;
$result = $result % $prime;
$result = $result - $factor;
var_dump(gmp_cmp($result, 0) === 0);

$factor = gmp_random_range(0, $prime);
$factorInverted = gmp_invert($factor, $prime);
$result = $factor * $factorInverted;
$result = $result % $prime;
var_dump(gmp_cmp($result, 1) === 0);

$primeP = ($prime - 1) / 2;
var_dump(gmp_prob_prime($prime) > 0);


// prime and b of secp521r1 from https://www.secg.org/sec2-v2.pdf
$p = gmp_init('01FF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
FFFFFFFF FFFFFFFF FFFFFFFF', 16);
$b = gmp_init('0051 953EB961 8E1C9A1F 929A21A0 B68540EE A2DA725B 99B315F3
B8B48991 8EF109E1 56193951 EC7E937B 1652C0BD 3BB1BF07 3573DF88
3D2C34F1 EF451FD4 6B503F00', 16);

$jacobi = gmp_jacobi($b, $p);
var_dump($jacobi === 1);

$result = $p & $b;
var_dump(gmp_cmp($result, $b) === 0);

$result = $p ^ $p;
var_dump(gmp_cmp($result, 0) === 0);

$result = $b ** 3;
var_dump(gmp_strval($result, 16));

?>
--EXPECT--
string(2048) "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"
bool(true)
bool(true)
bool(true)
bool(true)
bool(true)
bool(true)
string(389) "84916bf590f1bad61b6ede6cd6da703bca41cfb661c94b8cf66a1c92f0e2ebb24ad4683b908600ddf7145cac3b4808d6bbed18332d58d93c8ced3e0d3d19fd214a987f86116dd46c9709fd7d8a2b8ade79ba75e41df983b02082e89e3f729de3c6f42613a6b79b5e1967ab712e34cfb79e0d6f6168f7f758c2785da8ac1c36624fbb421a6502b2bbe9ad035c2577864aa12eee3173db7ffb915fce65a918041b95239d66d339de820a7d162cfccdfbd2222c91383ef0c4e903128cbd04dc0bf000000"
