/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;

public abstract class GenericTrigger<OWNER extends DBSObject>
implements DBSTrigger,
GenericScriptObject,
DBPNamedObject2,
DBPQualifiedObject {
    @NotNull
    private final OWNER container;
    private String name;
    private String description;
    protected String source;

    public GenericTrigger(@NotNull OWNER container, String name, String description) {
        this.container = container;
        this.name = name;
        this.description = description;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public OWNER getContainer() {
        return this.container;
    }

    public OWNER getParentObject() {
        return this.container;
    }

    @NotNull
    public GenericDataSource getDataSource() {
        return (GenericDataSource)this.container.getDataSource();
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.source == null) {
            this.source = this.getDataSource().getMetaModel().getTriggerDDL(monitor, this);
        }
        return this.source;
    }

    public void setSource(String sourceText) {
        this.source = sourceText;
    }
}

