/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit.struct;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexOrdering;

public abstract class SQLConstraintManager<OBJECT_TYPE extends AbstractTableConstraint, TABLE_TYPE extends AbstractTable>
extends SQLObjectEditor<OBJECT_TYPE, TABLE_TYPE> {
    @Override
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    @Override
    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        AbstractTable table = (AbstractTable)((AbstractTableConstraint)command.getObject()).getTable();
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_constraint, "ALTER TABLE " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD " + String.valueOf(this.getNestedDeclaration(monitor, (TABLE_TYPE)table, (DBECommandAbstract<OBJECT_TYPE>)command, options))));
    }

    @Override
    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_constraint, this.getDropConstraintPattern((AbstractTableConstraint)command.getObject()).replace("%TABLE%", ((AbstractTableConstraint)command.getObject()).getTable().getFullyQualifiedName(DBPEvaluationContext.DDL)).replace("%CONSTRAINT%", DBUtils.getQuotedIdentifier((DBSObject)command.getObject()))));
    }

    @Override
    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, TABLE_TYPE owner, DBECommandAbstract<OBJECT_TYPE> command, Map<String, Object> options) {
        AbstractTableConstraint constraint = (AbstractTableConstraint)command.getObject();
        String constraintName = DBUtils.getQuotedIdentifier(constraint.getDataSource(), constraint.getName());
        boolean legacySyntax = this.isLegacyConstraintsSyntax(owner);
        boolean shortNotation = this.isShortNotation(owner);
        StringBuilder decl = new StringBuilder(40);
        if (!(legacySyntax && constraint.isPersisted() || shortNotation)) {
            decl.append("CONSTRAINT ");
        }
        if (!legacySyntax && !shortNotation) {
            decl.append(constraintName).append(" ");
        }
        decl.append(this.getAddConstraintTypeClause(constraint));
        this.appendConstraintDefinition(decl, command);
        if (legacySyntax) {
            decl.append(" CONSTRAINT ").append(constraintName);
        }
        return decl;
    }

    protected void appendConstraintDefinition(StringBuilder decl, DBECommandAbstract<OBJECT_TYPE> command) {
        decl.append(" (");
        try {
            List attrs = ((AbstractTableConstraint)command.getObject()).getAttributeReferences(new VoidProgressMonitor());
            if (attrs != null) {
                boolean firstColumn = true;
                for (DBSEntityAttributeRef constraintColumn : attrs) {
                    DBSTableIndexOrdering ordering;
                    DBSEntityAttribute attribute = constraintColumn.getAttribute();
                    if (attribute == null) continue;
                    if (!firstColumn) {
                        decl.append(",");
                    }
                    firstColumn = false;
                    decl.append(DBUtils.getQuotedIdentifier(attribute));
                    if (!this.isPrimaryKeyOrdered() || !(constraintColumn instanceof DBSTableIndexOrdering) || (ordering = (DBSTableIndexOrdering)((Object)constraintColumn)).isAscending()) continue;
                    decl.append(" DESC");
                }
            }
        }
        catch (DBException e) {
            log.warn("Can't obtain attribute references", e);
        }
        decl.append(")");
    }

    @NotNull
    protected String getAddConstraintTypeClause(OBJECT_TYPE constraint) {
        if (((AbstractTableConstraint)constraint).getConstraintType() == DBSEntityConstraintType.UNIQUE_KEY) {
            return "UNIQUE";
        }
        return ((AbstractTableConstraint)constraint).getConstraintType().getName().toUpperCase(Locale.ENGLISH);
    }

    protected String getDropConstraintPattern(OBJECT_TYPE constraint) {
        return "ALTER TABLE %TABLE% DROP CONSTRAINT %CONSTRAINT%";
    }

    protected boolean isLegacyConstraintsSyntax(TABLE_TYPE owner) {
        return false;
    }

    protected boolean isShortNotation(TABLE_TYPE owner) {
        return false;
    }

    protected boolean isPrimaryKeyOrdered() {
        return false;
    }
}

