#![allow(clippy::disallowed_methods)]
#![allow(clippy::print_stderr)]
#![allow(clippy::print_stdout)]

mod advanced_env;
mod alt_registry;
mod artifact_dep;
mod artifact_dir;
mod bad_config;
mod bad_manifest_path;
mod bench;
mod binary_name;
mod build;
mod build_analysis;
mod build_dir;
mod build_dir_legacy;
mod build_plan;
mod build_script;
mod build_script_env;
mod build_script_extra_link_arg;
mod build_scripts_multiple;
mod cache_lock;
mod cache_messages;
mod cargo;
mod cargo_add;
mod cargo_alias_config;
mod cargo_bench;
mod cargo_build;
mod cargo_check;
mod cargo_clean;
mod cargo_command;
mod cargo_config;
mod cargo_doc;
mod cargo_env_config;
mod cargo_features;
mod cargo_fetch;
mod cargo_fix;
mod cargo_generate_lockfile;
mod cargo_git_checkout;
mod cargo_help;
mod cargo_info;
mod cargo_init;
mod cargo_install;
mod cargo_locate_project;
mod cargo_login;
mod cargo_logout;
mod cargo_metadata;
mod cargo_new;
mod cargo_owner;
mod cargo_package;
mod cargo_pkgid;
mod cargo_publish;
mod cargo_read_manifest;
mod cargo_remove;
mod cargo_report;
mod cargo_run;
mod cargo_rustc;
mod cargo_rustdoc;
mod cargo_search;
mod cargo_targets;
mod cargo_test;
mod cargo_tree;
mod cargo_uninstall;
mod cargo_update;
mod cargo_vendor;
mod cargo_verify_project;
mod cargo_version;
mod cargo_yank;
mod cfg;
mod check;
mod check_cfg;
mod clean;
mod collisions;
mod compile_time_deps;
mod concurrent;
mod config;
mod config_cli;
mod config_include;
mod corrupt_git;
mod credential_process;
mod cross_compile;
mod cross_publish;
mod custom_target;
mod death;
mod dep_info;
mod diagnostics;
mod direct_minimal_versions;
mod directory;
mod doc;
mod docscrape;
mod edition;
mod error;
mod feature_unification;
mod features;
mod features2;
mod features_namespaced;
mod fetch;
mod fix;
mod fix_n_times;
mod freshness;
mod freshness_checksum;
mod future_incompat_report;
mod generate_lockfile;
mod git;
mod git_auth;
mod git_gc;
mod git_shallow;
mod glob_targets;
mod global_cache_tracker;
mod help;
mod hints;
mod https;
mod inheritable_workspace_fields;
mod install;
mod install_upgrade;
mod jobserver;
mod lints;
mod lints_table;
mod list_availables;
mod local_registry;
mod locate_project;
mod lockfile_compat;
mod lockfile_path;
mod login;
mod logout;
mod lto;
mod member_discovery;
mod member_errors;
mod message_format;
mod messages;
mod metabuild;
mod metadata;
mod minimal_versions;
mod multitarget;
mod net_config;
mod new;
mod offline;
mod old_cargos;
mod open_namespaces;
mod owner;
mod package;
mod package_features;
mod package_message_format;
mod patch;
mod path;
mod paths;
mod pgo;
mod pkgid;
mod precise_pre_release;
mod proc_macro;
mod profile_config;
mod profile_custom;
mod profile_overrides;
mod profile_panic_immediate_abort;
mod profile_targets;
mod profile_trim_paths;
mod profiles;
mod progress;
mod pub_priv;
mod publish;
mod publish_lockfile;
mod read_manifest;
mod registry;
mod registry_auth;
mod registry_overlay;
mod rename_deps;
mod replace;
mod required_features;
mod run;
mod rust_version;
mod rustc;
mod rustc_info_cache;
mod rustdoc;
mod rustdoc_extern_html;
mod rustdocflags;
mod rustflags;
mod rustup;
mod sbom;
mod script;
mod search;
mod shell_quoting;
mod source_replacement;
mod ssh;
mod standard_lib;
mod test;
mod timings;
mod tool_paths;
mod unit_graph;
mod update;
mod utils;
mod vendor;
mod verify_project;
mod version;
mod warn_on_failure;
mod warning_override;
mod weak_dep_features;
mod workspaces;
mod yank;

use crate::prelude::*;

pub mod prelude {
    pub use crate::utils::ext::CargoCommandExt;
    pub use crate::utils::ext::CargoProjectExt;
    pub use cargo_test_support::prelude::*;
}

#[cargo_test]
fn aaa_trigger_cross_compile_disabled_check() {
    // This triggers the cross compile disabled check to run ASAP, see #5141
    crate::utils::cross_compile::disabled();
}
