//! Direct translation of the C code found at
//! [ubc_check.c](https://github.com/cr-marcstevens/sha1collisiondetection/blob/master/lib/ubc_check.c).
//!
//! For the original license and source details see the comments in `src/checked.rs`.
//!
//! The original C code file was generated by the 'parse_bitrel' program in the tools section
//! using the data files from directory 'tools/data/3565'.

const DV_I_43_0_BIT: u32 = 1 << 0;
const DV_I_44_0_BIT: u32 = 1 << 1;
const DV_I_45_0_BIT: u32 = 1 << 2;
const DV_I_46_0_BIT: u32 = 1 << 3;
const DV_I_46_2_BIT: u32 = 1 << 4;
const DV_I_47_0_BIT: u32 = 1 << 5;
const DV_I_47_2_BIT: u32 = 1 << 6;
const DV_I_48_0_BIT: u32 = 1 << 7;
const DV_I_48_2_BIT: u32 = 1 << 8;
const DV_I_49_0_BIT: u32 = 1 << 9;
const DV_I_49_2_BIT: u32 = 1 << 10;
const DV_I_50_0_BIT: u32 = 1 << 11;
const DV_I_50_2_BIT: u32 = 1 << 12;
const DV_I_51_0_BIT: u32 = 1 << 13;
const DV_I_51_2_BIT: u32 = 1 << 14;
const DV_I_52_0_BIT: u32 = 1 << 15;
const DV_II_45_0_BIT: u32 = 1 << 16;
const DV_II_46_0_BIT: u32 = 1 << 17;
const DV_II_46_2_BIT: u32 = 1 << 18;
const DV_II_47_0_BIT: u32 = 1 << 19;
const DV_II_48_0_BIT: u32 = 1 << 20;
const DV_II_49_0_BIT: u32 = 1 << 21;
const DV_II_49_2_BIT: u32 = 1 << 22;
const DV_II_50_0_BIT: u32 = 1 << 23;
const DV_II_50_2_BIT: u32 = 1 << 24;
const DV_II_51_0_BIT: u32 = 1 << 25;
const DV_II_51_2_BIT: u32 = 1 << 26;
const DV_II_52_0_BIT: u32 = 1 << 27;
const DV_II_53_0_BIT: u32 = 1 << 28;
const DV_II_54_0_BIT: u32 = 1 << 29;
const DV_II_55_0_BIT: u32 = 1 << 30;
const DV_II_56_0_BIT: u32 = 1 << 31;

pub struct Info {
    pub dv_type: u32,
    pub dv_k: u32,
    pub dv_b: u32,
    pub testt: Testt,
    pub maski: i32,
    pub maskb: i32,
    pub dm: [u32; 80],
}

#[derive(Copy, Clone)]
#[repr(u32)]
pub enum Testt {
    T58 = 58,
    T65 = 65,
}

/// Contains a list of SHA-1 Disturbance Vectors (DV) to check
/// `dv_type`, `dv_k` and `dv_b` define the DV: I(K,B) or II(K,B) (see the paper)
/// `dm[80]` is the expanded message block XOR-difference defined by the DV
/// testt is the step to do the recompression from for collision detection
/// `maski` and `maskb` define the bit to check for each DV in the dvmask returned by [`ubc_check`].
pub const SHA1_DVS: [Info; 32] = [
    Info {
        dv_type: 1,
        dv_k: 43,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 0,
        dm: [
            0x8000000, 0x9800000c, 0xd8000010, 0x8000010, 0xb8000010, 0x98000000, 0x60000000, 0x8,
            0xc0000000, 0x90000014, 0x10000010, 0xb8000014, 0x28000000, 0x20000010, 0x48000000,
            0x8000018, 0x60000000, 0x90000010, 0xf0000010, 0x90000008, 0xc0000000, 0x90000010,
            0xf0000010, 0xb0000008, 0x40000000, 0x90000000, 0xf0000010, 0x90000018, 0x60000000,
            0x90000010, 0x90000010, 0x90000000, 0x80000000, 0x10, 0xa0000000, 0x20000000,
            0xa0000000, 0x20000010, 0, 0x20000010, 0x20000000, 0x10, 0x20000000, 0x10, 0xa0000000,
            0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002,
            0x40000040, 0x40000002, 0x80000004, 0x80000080, 0x80000006, 0x49, 0x103, 0x80000009,
            0x80000012, 0x80000202, 0x18, 0x164, 0x408, 0x800000e6, 0x8000004c, 0x803, 0x80000161,
            0x80000599,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 44,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 1,
        dm: [
            0xb4000008, 0x8000000, 0x9800000c, 0xd8000010, 0x8000010, 0xb8000010, 0x98000000,
            0x60000000, 0x8, 0xc0000000, 0x90000014, 0x10000010, 0xb8000014, 0x28000000,
            0x20000010, 0x48000000, 0x8000018, 0x60000000, 0x90000010, 0xf0000010, 0x90000008,
            0xc0000000, 0x90000010, 0xf0000010, 0xb0000008, 0x40000000, 0x90000000, 0xf0000010,
            0x90000018, 0x60000000, 0x90000010, 0x90000010, 0x90000000, 0x80000000, 0x10,
            0xa0000000, 0x20000000, 0xa0000000, 0x20000010, 0, 0x20000010, 0x20000000, 0x10,
            0x20000000, 0x10, 0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0x1, 0x20, 0x1, 0x40000002, 0x40000040, 0x40000002, 0x80000004, 0x80000080, 0x80000006,
            0x49, 0x103, 0x80000009, 0x80000012, 0x80000202, 0x18, 0x164, 0x408, 0x800000e6,
            0x8000004c, 0x803, 0x80000161,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 45,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 2,
        dm: [
            0xf4000014, 0xb4000008, 0x8000000, 0x9800000c, 0xd8000010, 0x8000010, 0xb8000010,
            0x98000000, 0x60000000, 0x8, 0xc0000000, 0x90000014, 0x10000010, 0xb8000014,
            0x28000000, 0x20000010, 0x48000000, 0x8000018, 0x60000000, 0x90000010, 0xf0000010,
            0x90000008, 0xc0000000, 0x90000010, 0xf0000010, 0xb0000008, 0x40000000, 0x90000000,
            0xf0000010, 0x90000018, 0x60000000, 0x90000010, 0x90000010, 0x90000000, 0x80000000,
            0x10, 0xa0000000, 0x20000000, 0xa0000000, 0x20000010, 0, 0x20000010, 0x20000000, 0x10,
            0x20000000, 0x10, 0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0x1, 0x20, 0x1, 0x40000002, 0x40000040, 0x40000002, 0x80000004, 0x80000080, 0x80000006,
            0x49, 0x103, 0x80000009, 0x80000012, 0x80000202, 0x18, 0x164, 0x408, 0x800000e6,
            0x8000004c, 0x803,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 46,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 3,
        dm: [
            0x2c000010, 0xf4000014, 0xb4000008, 0x8000000, 0x9800000c, 0xd8000010, 0x8000010,
            0xb8000010, 0x98000000, 0x60000000, 0x8, 0xc0000000, 0x90000014, 0x10000010,
            0xb8000014, 0x28000000, 0x20000010, 0x48000000, 0x8000018, 0x60000000, 0x90000010,
            0xf0000010, 0x90000008, 0xc0000000, 0x90000010, 0xf0000010, 0xb0000008, 0x40000000,
            0x90000000, 0xf0000010, 0x90000018, 0x60000000, 0x90000010, 0x90000010, 0x90000000,
            0x80000000, 0x10, 0xa0000000, 0x20000000, 0xa0000000, 0x20000010, 0, 0x20000010,
            0x20000000, 0x10, 0x20000000, 0x10, 0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002, 0x40000040, 0x40000002, 0x80000004,
            0x80000080, 0x80000006, 0x49, 0x103, 0x80000009, 0x80000012, 0x80000202, 0x18, 0x164,
            0x408, 0x800000e6, 0x8000004c,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 46,
        dv_b: 2,
        testt: Testt::T58,
        maski: 0,
        maskb: 4,
        dm: [
            0xb0000040, 0xd0000053, 0xd0000022, 0x20000000, 0x60000032, 0x60000043, 0x20000040,
            0xe0000042, 0x60000002, 0x80000001, 0x20, 0x3, 0x40000052, 0x40000040, 0xe0000052,
            0xa0000000, 0x80000040, 0x20000001, 0x20000060, 0x80000001, 0x40000042, 0xc0000043,
            0x40000022, 0x3, 0x40000042, 0xc0000043, 0xc0000022, 0x1, 0x40000002, 0xc0000043,
            0x40000062, 0x80000001, 0x40000042, 0x40000042, 0x40000002, 0x2, 0x40, 0x80000002,
            0x80000000, 0x80000002, 0x80000040, 0, 0x80000040, 0x80000000, 0x40, 0x80000000, 0x40,
            0x80000002, 0, 0x80000000, 0x80000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4, 0x80, 0x4,
            0x9, 0x101, 0x9, 0x12, 0x202, 0x1a, 0x124, 0x40c, 0x26, 0x4a, 0x80a, 0x60, 0x590,
            0x1020, 0x39a, 0x132,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 47,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 5,
        dm: [
            0xc8000010, 0x2c000010, 0xf4000014, 0xb4000008, 0x8000000, 0x9800000c, 0xd8000010,
            0x8000010, 0xb8000010, 0x98000000, 0x60000000, 0x8, 0xc0000000, 0x90000014, 0x10000010,
            0xb8000014, 0x28000000, 0x20000010, 0x48000000, 0x8000018, 0x60000000, 0x90000010,
            0xf0000010, 0x90000008, 0xc0000000, 0x90000010, 0xf0000010, 0xb0000008, 0x40000000,
            0x90000000, 0xf0000010, 0x90000018, 0x60000000, 0x90000010, 0x90000010, 0x90000000,
            0x80000000, 0x10, 0xa0000000, 0x20000000, 0xa0000000, 0x20000010, 0, 0x20000010,
            0x20000000, 0x10, 0x20000000, 0x10, 0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002, 0x40000040, 0x40000002, 0x80000004,
            0x80000080, 0x80000006, 0x49, 0x103, 0x80000009, 0x80000012, 0x80000202, 0x18, 0x164,
            0x408, 0x800000e6,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 47,
        dv_b: 2,
        testt: Testt::T58,
        maski: 0,
        maskb: 6,
        dm: [
            0x20000043, 0xb0000040, 0xd0000053, 0xd0000022, 0x20000000, 0x60000032, 0x60000043,
            0x20000040, 0xe0000042, 0x60000002, 0x80000001, 0x20, 0x3, 0x40000052, 0x40000040,
            0xe0000052, 0xa0000000, 0x80000040, 0x20000001, 0x20000060, 0x80000001, 0x40000042,
            0xc0000043, 0x40000022, 0x3, 0x40000042, 0xc0000043, 0xc0000022, 0x1, 0x40000002,
            0xc0000043, 0x40000062, 0x80000001, 0x40000042, 0x40000042, 0x40000002, 0x2, 0x40,
            0x80000002, 0x80000000, 0x80000002, 0x80000040, 0, 0x80000040, 0x80000000, 0x40,
            0x80000000, 0x40, 0x80000002, 0, 0x80000000, 0x80000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0x4, 0x80, 0x4, 0x9, 0x101, 0x9, 0x12, 0x202, 0x1a, 0x124, 0x40c, 0x26, 0x4a, 0x80a,
            0x60, 0x590, 0x1020, 0x39a,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 48,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 7,
        dm: [
            0xb800000a, 0xc8000010, 0x2c000010, 0xf4000014, 0xb4000008, 0x8000000, 0x9800000c,
            0xd8000010, 0x8000010, 0xb8000010, 0x98000000, 0x60000000, 0x8, 0xc0000000, 0x90000014,
            0x10000010, 0xb8000014, 0x28000000, 0x20000010, 0x48000000, 0x8000018, 0x60000000,
            0x90000010, 0xf0000010, 0x90000008, 0xc0000000, 0x90000010, 0xf0000010, 0xb0000008,
            0x40000000, 0x90000000, 0xf0000010, 0x90000018, 0x60000000, 0x90000010, 0x90000010,
            0x90000000, 0x80000000, 0x10, 0xa0000000, 0x20000000, 0xa0000000, 0x20000010, 0,
            0x20000010, 0x20000000, 0x10, 0x20000000, 0x10, 0xa0000000, 0, 0x20000000, 0x20000000,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002, 0x40000040, 0x40000002,
            0x80000004, 0x80000080, 0x80000006, 0x49, 0x103, 0x80000009, 0x80000012, 0x80000202,
            0x18, 0x164, 0x408,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 48,
        dv_b: 2,
        testt: Testt::T58,
        maski: 0,
        maskb: 8,
        dm: [
            0xe000002a, 0x20000043, 0xb0000040, 0xd0000053, 0xd0000022, 0x20000000, 0x60000032,
            0x60000043, 0x20000040, 0xe0000042, 0x60000002, 0x80000001, 0x20, 0x3, 0x40000052,
            0x40000040, 0xe0000052, 0xa0000000, 0x80000040, 0x20000001, 0x20000060, 0x80000001,
            0x40000042, 0xc0000043, 0x40000022, 0x3, 0x40000042, 0xc0000043, 0xc0000022, 0x1,
            0x40000002, 0xc0000043, 0x40000062, 0x80000001, 0x40000042, 0x40000042, 0x40000002,
            0x2, 0x40, 0x80000002, 0x80000000, 0x80000002, 0x80000040, 0, 0x80000040, 0x80000000,
            0x40, 0x80000000, 0x40, 0x80000002, 0, 0x80000000, 0x80000000, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0x4, 0x80, 0x4, 0x9, 0x101, 0x9, 0x12, 0x202, 0x1a, 0x124, 0x40c, 0x26, 0x4a,
            0x80a, 0x60, 0x590, 0x1020,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 49,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 9,
        dm: [
            0x18000000, 0xb800000a, 0xc8000010, 0x2c000010, 0xf4000014, 0xb4000008, 0x8000000,
            0x9800000c, 0xd8000010, 0x8000010, 0xb8000010, 0x98000000, 0x60000000, 0x8, 0xc0000000,
            0x90000014, 0x10000010, 0xb8000014, 0x28000000, 0x20000010, 0x48000000, 0x8000018,
            0x60000000, 0x90000010, 0xf0000010, 0x90000008, 0xc0000000, 0x90000010, 0xf0000010,
            0xb0000008, 0x40000000, 0x90000000, 0xf0000010, 0x90000018, 0x60000000, 0x90000010,
            0x90000010, 0x90000000, 0x80000000, 0x10, 0xa0000000, 0x20000000, 0xa0000000,
            0x20000010, 0, 0x20000010, 0x20000000, 0x10, 0x20000000, 0x10, 0xa0000000, 0,
            0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002,
            0x40000040, 0x40000002, 0x80000004, 0x80000080, 0x80000006, 0x49, 0x103, 0x80000009,
            0x80000012, 0x80000202, 0x18, 0x164,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 49,
        dv_b: 2,
        testt: Testt::T58,
        maski: 0,
        maskb: 10,
        dm: [
            0x60000000, 0xe000002a, 0x20000043, 0xb0000040, 0xd0000053, 0xd0000022, 0x20000000,
            0x60000032, 0x60000043, 0x20000040, 0xe0000042, 0x60000002, 0x80000001, 0x20, 0x3,
            0x40000052, 0x40000040, 0xe0000052, 0xa0000000, 0x80000040, 0x20000001, 0x20000060,
            0x80000001, 0x40000042, 0xc0000043, 0x40000022, 0x3, 0x40000042, 0xc0000043,
            0xc0000022, 0x1, 0x40000002, 0xc0000043, 0x40000062, 0x80000001, 0x40000042,
            0x40000042, 0x40000002, 0x2, 0x40, 0x80000002, 0x80000000, 0x80000002, 0x80000040, 0,
            0x80000040, 0x80000000, 0x40, 0x80000000, 0x40, 0x80000002, 0, 0x80000000, 0x80000000,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4, 0x80, 0x4, 0x9, 0x101, 0x9, 0x12, 0x202, 0x1a,
            0x124, 0x40c, 0x26, 0x4a, 0x80a, 0x60, 0x590,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 50,
        dv_b: 0,
        testt: Testt::T65,
        maski: 0,
        maskb: 11,
        dm: [
            0x800000c, 0x18000000, 0xb800000a, 0xc8000010, 0x2c000010, 0xf4000014, 0xb4000008,
            0x8000000, 0x9800000c, 0xd8000010, 0x8000010, 0xb8000010, 0x98000000, 0x60000000, 0x8,
            0xc0000000, 0x90000014, 0x10000010, 0xb8000014, 0x28000000, 0x20000010, 0x48000000,
            0x8000018, 0x60000000, 0x90000010, 0xf0000010, 0x90000008, 0xc0000000, 0x90000010,
            0xf0000010, 0xb0000008, 0x40000000, 0x90000000, 0xf0000010, 0x90000018, 0x60000000,
            0x90000010, 0x90000010, 0x90000000, 0x80000000, 0x10, 0xa0000000, 0x20000000,
            0xa0000000, 0x20000010, 0, 0x20000010, 0x20000000, 0x10, 0x20000000, 0x10, 0xa0000000,
            0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002,
            0x40000040, 0x40000002, 0x80000004, 0x80000080, 0x80000006, 0x49, 0x103, 0x80000009,
            0x80000012, 0x80000202, 0x18,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 50,
        dv_b: 2,
        testt: Testt::T65,
        maski: 0,
        maskb: 12,
        dm: [
            0x20000030, 0x60000000, 0xe000002a, 0x20000043, 0xb0000040, 0xd0000053, 0xd0000022,
            0x20000000, 0x60000032, 0x60000043, 0x20000040, 0xe0000042, 0x60000002, 0x80000001,
            0x20, 0x3, 0x40000052, 0x40000040, 0xe0000052, 0xa0000000, 0x80000040, 0x20000001,
            0x20000060, 0x80000001, 0x40000042, 0xc0000043, 0x40000022, 0x3, 0x40000042,
            0xc0000043, 0xc0000022, 0x1, 0x40000002, 0xc0000043, 0x40000062, 0x80000001,
            0x40000042, 0x40000042, 0x40000002, 0x2, 0x40, 0x80000002, 0x80000000, 0x80000002,
            0x80000040, 0, 0x80000040, 0x80000000, 0x40, 0x80000000, 0x40, 0x80000002, 0,
            0x80000000, 0x80000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4, 0x80, 0x4, 0x9, 0x101, 0x9,
            0x12, 0x202, 0x1a, 0x124, 0x40c, 0x26, 0x4a, 0x80a, 0x60,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 51,
        dv_b: 0,
        testt: Testt::T65,
        maski: 0,
        maskb: 13,
        dm: [
            0xe8000000, 0x800000c, 0x18000000, 0xb800000a, 0xc8000010, 0x2c000010, 0xf4000014,
            0xb4000008, 0x8000000, 0x9800000c, 0xd8000010, 0x8000010, 0xb8000010, 0x98000000,
            0x60000000, 0x8, 0xc0000000, 0x90000014, 0x10000010, 0xb8000014, 0x28000000,
            0x20000010, 0x48000000, 0x8000018, 0x60000000, 0x90000010, 0xf0000010, 0x90000008,
            0xc0000000, 0x90000010, 0xf0000010, 0xb0000008, 0x40000000, 0x90000000, 0xf0000010,
            0x90000018, 0x60000000, 0x90000010, 0x90000010, 0x90000000, 0x80000000, 0x10,
            0xa0000000, 0x20000000, 0xa0000000, 0x20000010, 0, 0x20000010, 0x20000000, 0x10,
            0x20000000, 0x10, 0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0x1, 0x20, 0x1, 0x40000002, 0x40000040, 0x40000002, 0x80000004, 0x80000080, 0x80000006,
            0x49, 0x103, 0x80000009, 0x80000012, 0x80000202,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 51,
        dv_b: 2,
        testt: Testt::T65,
        maski: 0,
        maskb: 14,
        dm: [
            0xa0000003, 0x20000030, 0x60000000, 0xe000002a, 0x20000043, 0xb0000040, 0xd0000053,
            0xd0000022, 0x20000000, 0x60000032, 0x60000043, 0x20000040, 0xe0000042, 0x60000002,
            0x80000001, 0x20, 0x3, 0x40000052, 0x40000040, 0xe0000052, 0xa0000000, 0x80000040,
            0x20000001, 0x20000060, 0x80000001, 0x40000042, 0xc0000043, 0x40000022, 0x3,
            0x40000042, 0xc0000043, 0xc0000022, 0x1, 0x40000002, 0xc0000043, 0x40000062,
            0x80000001, 0x40000042, 0x40000042, 0x40000002, 0x2, 0x40, 0x80000002, 0x80000000,
            0x80000002, 0x80000040, 0, 0x80000040, 0x80000000, 0x40, 0x80000000, 0x40, 0x80000002,
            0, 0x80000000, 0x80000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4, 0x80, 0x4, 0x9, 0x101,
            0x9, 0x12, 0x202, 0x1a, 0x124, 0x40c, 0x26, 0x4a, 0x80a,
        ],
    },
    Info {
        dv_type: 1,
        dv_k: 52,
        dv_b: 0,
        testt: Testt::T65,
        maski: 0,
        maskb: 15,
        dm: [
            0x4000010, 0xe8000000, 0x800000c, 0x18000000, 0xb800000a, 0xc8000010, 0x2c000010,
            0xf4000014, 0xb4000008, 0x8000000, 0x9800000c, 0xd8000010, 0x8000010, 0xb8000010,
            0x98000000, 0x60000000, 0x8, 0xc0000000, 0x90000014, 0x10000010, 0xb8000014,
            0x28000000, 0x20000010, 0x48000000, 0x8000018, 0x60000000, 0x90000010, 0xf0000010,
            0x90000008, 0xc0000000, 0x90000010, 0xf0000010, 0xb0000008, 0x40000000, 0x90000000,
            0xf0000010, 0x90000018, 0x60000000, 0x90000010, 0x90000010, 0x90000000, 0x80000000,
            0x10, 0xa0000000, 0x20000000, 0xa0000000, 0x20000010, 0, 0x20000010, 0x20000000, 0x10,
            0x20000000, 0x10, 0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0x1, 0x20, 0x1, 0x40000002, 0x40000040, 0x40000002, 0x80000004, 0x80000080, 0x80000006,
            0x49, 0x103, 0x80000009, 0x80000012,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 45,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 16,
        dm: [
            0xec000014, 0xc000002, 0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018, 0xb0000010, 0xc,
            0xb8000010, 0x8000018, 0x78000010, 0x8000014, 0x70000010, 0xb800001c, 0xe8000000,
            0xb0000004, 0x58000010, 0xb000000c, 0x48000000, 0xb0000000, 0xb8000010, 0x98000010,
            0xa0000000, 0, 0, 0x20000000, 0x80000000, 0x10, 0, 0x20000010, 0x20000000, 0x10,
            0x60000000, 0x18, 0xe0000000, 0x90000000, 0x30000010, 0xb0000000, 0x20000000,
            0x20000000, 0xa0000000, 0x10, 0x80000000, 0x20000000, 0x20000000, 0x20000000,
            0x80000000, 0x10, 0, 0x20000010, 0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0,
            0, 0x1, 0x20, 0x1, 0x40000002, 0x40000041, 0x40000022, 0x80000005, 0xc0000082,
            0xc0000046, 0x4000004b, 0x80000107, 0x89, 0x14, 0x8000024b, 0x11b, 0x8000016d,
            0x8000041a, 0x2e4, 0x80000054, 0x967,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 46,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 17,
        dm: [
            0x2400001c, 0xec000014, 0xc000002, 0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018,
            0xb0000010, 0xc, 0xb8000010, 0x8000018, 0x78000010, 0x8000014, 0x70000010, 0xb800001c,
            0xe8000000, 0xb0000004, 0x58000010, 0xb000000c, 0x48000000, 0xb0000000, 0xb8000010,
            0x98000010, 0xa0000000, 0, 0, 0x20000000, 0x80000000, 0x10, 0, 0x20000010, 0x20000000,
            0x10, 0x60000000, 0x18, 0xe0000000, 0x90000000, 0x30000010, 0xb0000000, 0x20000000,
            0x20000000, 0xa0000000, 0x10, 0x80000000, 0x20000000, 0x20000000, 0x20000000,
            0x80000000, 0x10, 0, 0x20000010, 0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0,
            0, 0x1, 0x20, 0x1, 0x40000002, 0x40000041, 0x40000022, 0x80000005, 0xc0000082,
            0xc0000046, 0x4000004b, 0x80000107, 0x89, 0x14, 0x8000024b, 0x11b, 0x8000016d,
            0x8000041a, 0x2e4, 0x80000054,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 46,
        dv_b: 2,
        testt: Testt::T58,
        maski: 0,
        maskb: 18,
        dm: [
            0x90000070, 0xb0000053, 0x30000008, 0x43, 0xd0000072, 0xb0000010, 0xf0000062,
            0xc0000042, 0x30, 0xe0000042, 0x20000060, 0xe0000041, 0x20000050, 0xc0000041,
            0xe0000072, 0xa0000003, 0xc0000012, 0x60000041, 0xc0000032, 0x20000001, 0xc0000002,
            0xe0000042, 0x60000042, 0x80000002, 0, 0, 0x80000000, 0x2, 0x40, 0, 0x80000040,
            0x80000000, 0x40, 0x80000001, 0x60, 0x80000003, 0x40000002, 0xc0000040, 0xc0000002,
            0x80000000, 0x80000000, 0x80000002, 0x40, 0x2, 0x80000000, 0x80000000, 0x80000000, 0x2,
            0x40, 0, 0x80000040, 0x80000002, 0, 0x80000000, 0x80000000, 0, 0, 0, 0, 0, 0, 0x4,
            0x80, 0x4, 0x9, 0x105, 0x89, 0x16, 0x20b, 0x11b, 0x12d, 0x41e, 0x224, 0x50, 0x92e,
            0x46c, 0x5b6, 0x106a, 0xb90, 0x152,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 47,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 19,
        dm: [
            0x20000010, 0x2400001c, 0xec000014, 0xc000002, 0xc0000010, 0xb400001c, 0x2c000004,
            0xbc000018, 0xb0000010, 0xc, 0xb8000010, 0x8000018, 0x78000010, 0x8000014, 0x70000010,
            0xb800001c, 0xe8000000, 0xb0000004, 0x58000010, 0xb000000c, 0x48000000, 0xb0000000,
            0xb8000010, 0x98000010, 0xa0000000, 0, 0, 0x20000000, 0x80000000, 0x10, 0, 0x20000010,
            0x20000000, 0x10, 0x60000000, 0x18, 0xe0000000, 0x90000000, 0x30000010, 0xb0000000,
            0x20000000, 0x20000000, 0xa0000000, 0x10, 0x80000000, 0x20000000, 0x20000000,
            0x20000000, 0x80000000, 0x10, 0, 0x20000010, 0xa0000000, 0, 0x20000000, 0x20000000, 0,
            0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002, 0x40000041, 0x40000022, 0x80000005,
            0xc0000082, 0xc0000046, 0x4000004b, 0x80000107, 0x89, 0x14, 0x8000024b, 0x11b,
            0x8000016d, 0x8000041a, 0x2e4,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 48,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 20,
        dm: [
            0xbc00001a, 0x20000010, 0x2400001c, 0xec000014, 0xc000002, 0xc0000010, 0xb400001c,
            0x2c000004, 0xbc000018, 0xb0000010, 0xc, 0xb8000010, 0x8000018, 0x78000010, 0x8000014,
            0x70000010, 0xb800001c, 0xe8000000, 0xb0000004, 0x58000010, 0xb000000c, 0x48000000,
            0xb0000000, 0xb8000010, 0x98000010, 0xa0000000, 0, 0, 0x20000000, 0x80000000, 0x10, 0,
            0x20000010, 0x20000000, 0x10, 0x60000000, 0x18, 0xe0000000, 0x90000000, 0x30000010,
            0xb0000000, 0x20000000, 0x20000000, 0xa0000000, 0x10, 0x80000000, 0x20000000,
            0x20000000, 0x20000000, 0x80000000, 0x10, 0, 0x20000010, 0xa0000000, 0, 0x20000000,
            0x20000000, 0, 0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002, 0x40000041, 0x40000022,
            0x80000005, 0xc0000082, 0xc0000046, 0x4000004b, 0x80000107, 0x89, 0x14, 0x8000024b,
            0x11b, 0x8000016d, 0x8000041a,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 49,
        dv_b: 0,
        testt: Testt::T58,
        maski: 0,
        maskb: 21,
        dm: [
            0x3c000004, 0xbc00001a, 0x20000010, 0x2400001c, 0xec000014, 0xc000002, 0xc0000010,
            0xb400001c, 0x2c000004, 0xbc000018, 0xb0000010, 0xc, 0xb8000010, 0x8000018, 0x78000010,
            0x8000014, 0x70000010, 0xb800001c, 0xe8000000, 0xb0000004, 0x58000010, 0xb000000c,
            0x48000000, 0xb0000000, 0xb8000010, 0x98000010, 0xa0000000, 0, 0, 0x20000000,
            0x80000000, 0x10, 0, 0x20000010, 0x20000000, 0x10, 0x60000000, 0x18, 0xe0000000,
            0x90000000, 0x30000010, 0xb0000000, 0x20000000, 0x20000000, 0xa0000000, 0x10,
            0x80000000, 0x20000000, 0x20000000, 0x20000000, 0x80000000, 0x10, 0, 0x20000010,
            0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002,
            0x40000041, 0x40000022, 0x80000005, 0xc0000082, 0xc0000046, 0x4000004b, 0x80000107,
            0x89, 0x14, 0x8000024b, 0x11b, 0x8000016d,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 49,
        dv_b: 2,
        testt: Testt::T58,
        maski: 0,
        maskb: 22,
        dm: [
            0xf0000010, 0xf000006a, 0x80000040, 0x90000070, 0xb0000053, 0x30000008, 0x43,
            0xd0000072, 0xb0000010, 0xf0000062, 0xc0000042, 0x30, 0xe0000042, 0x20000060,
            0xe0000041, 0x20000050, 0xc0000041, 0xe0000072, 0xa0000003, 0xc0000012, 0x60000041,
            0xc0000032, 0x20000001, 0xc0000002, 0xe0000042, 0x60000042, 0x80000002, 0, 0,
            0x80000000, 0x2, 0x40, 0, 0x80000040, 0x80000000, 0x40, 0x80000001, 0x60, 0x80000003,
            0x40000002, 0xc0000040, 0xc0000002, 0x80000000, 0x80000000, 0x80000002, 0x40, 0x2,
            0x80000000, 0x80000000, 0x80000000, 0x2, 0x40, 0, 0x80000040, 0x80000002, 0,
            0x80000000, 0x80000000, 0, 0, 0, 0, 0, 0, 0x4, 0x80, 0x4, 0x9, 0x105, 0x89, 0x16,
            0x20b, 0x11b, 0x12d, 0x41e, 0x224, 0x50, 0x92e, 0x46c, 0x5b6,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 50,
        dv_b: 0,
        testt: Testt::T65,
        maski: 0,
        maskb: 23,
        dm: [
            0xb400001c, 0x3c000004, 0xbc00001a, 0x20000010, 0x2400001c, 0xec000014, 0xc000002,
            0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018, 0xb0000010, 0xc, 0xb8000010, 0x8000018,
            0x78000010, 0x8000014, 0x70000010, 0xb800001c, 0xe8000000, 0xb0000004, 0x58000010,
            0xb000000c, 0x48000000, 0xb0000000, 0xb8000010, 0x98000010, 0xa0000000, 0, 0,
            0x20000000, 0x80000000, 0x10, 0, 0x20000010, 0x20000000, 0x10, 0x60000000, 0x18,
            0xe0000000, 0x90000000, 0x30000010, 0xb0000000, 0x20000000, 0x20000000, 0xa0000000,
            0x10, 0x80000000, 0x20000000, 0x20000000, 0x20000000, 0x80000000, 0x10, 0, 0x20000010,
            0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002,
            0x40000041, 0x40000022, 0x80000005, 0xc0000082, 0xc0000046, 0x4000004b, 0x80000107,
            0x89, 0x14, 0x8000024b, 0x11b,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 50,
        dv_b: 2,
        testt: Testt::T65,
        maski: 0,
        maskb: 24,
        dm: [
            0xd0000072, 0xf0000010, 0xf000006a, 0x80000040, 0x90000070, 0xb0000053, 0x30000008,
            0x43, 0xd0000072, 0xb0000010, 0xf0000062, 0xc0000042, 0x30, 0xe0000042, 0x20000060,
            0xe0000041, 0x20000050, 0xc0000041, 0xe0000072, 0xa0000003, 0xc0000012, 0x60000041,
            0xc0000032, 0x20000001, 0xc0000002, 0xe0000042, 0x60000042, 0x80000002, 0, 0,
            0x80000000, 0x2, 0x40, 0, 0x80000040, 0x80000000, 0x40, 0x80000001, 0x60, 0x80000003,
            0x40000002, 0xc0000040, 0xc0000002, 0x80000000, 0x80000000, 0x80000002, 0x40, 0x2,
            0x80000000, 0x80000000, 0x80000000, 0x2, 0x40, 0, 0x80000040, 0x80000002, 0,
            0x80000000, 0x80000000, 0, 0, 0, 0, 0, 0, 0x4, 0x80, 0x4, 0x9, 0x105, 0x89, 0x16,
            0x20b, 0x11b, 0x12d, 0x41e, 0x224, 0x50, 0x92e, 0x46c,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 51,
        dv_b: 0,
        testt: Testt::T65,
        maski: 0,
        maskb: 25,
        dm: [
            0xc0000010, 0xb400001c, 0x3c000004, 0xbc00001a, 0x20000010, 0x2400001c, 0xec000014,
            0xc000002, 0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018, 0xb0000010, 0xc, 0xb8000010,
            0x8000018, 0x78000010, 0x8000014, 0x70000010, 0xb800001c, 0xe8000000, 0xb0000004,
            0x58000010, 0xb000000c, 0x48000000, 0xb0000000, 0xb8000010, 0x98000010, 0xa0000000, 0,
            0, 0x20000000, 0x80000000, 0x10, 0, 0x20000010, 0x20000000, 0x10, 0x60000000, 0x18,
            0xe0000000, 0x90000000, 0x30000010, 0xb0000000, 0x20000000, 0x20000000, 0xa0000000,
            0x10, 0x80000000, 0x20000000, 0x20000000, 0x20000000, 0x80000000, 0x10, 0, 0x20000010,
            0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002,
            0x40000041, 0x40000022, 0x80000005, 0xc0000082, 0xc0000046, 0x4000004b, 0x80000107,
            0x89, 0x14, 0x8000024b,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 51,
        dv_b: 2,
        testt: Testt::T65,
        maski: 0,
        maskb: 26,
        dm: [
            0x43, 0xd0000072, 0xf0000010, 0xf000006a, 0x80000040, 0x90000070, 0xb0000053,
            0x30000008, 0x43, 0xd0000072, 0xb0000010, 0xf0000062, 0xc0000042, 0x30, 0xe0000042,
            0x20000060, 0xe0000041, 0x20000050, 0xc0000041, 0xe0000072, 0xa0000003, 0xc0000012,
            0x60000041, 0xc0000032, 0x20000001, 0xc0000002, 0xe0000042, 0x60000042, 0x80000002, 0,
            0, 0x80000000, 0x2, 0x40, 0, 0x80000040, 0x80000000, 0x40, 0x80000001, 0x60,
            0x80000003, 0x40000002, 0xc0000040, 0xc0000002, 0x80000000, 0x80000000, 0x80000002,
            0x40, 0x2, 0x80000000, 0x80000000, 0x80000000, 0x2, 0x40, 0, 0x80000040, 0x80000002, 0,
            0x80000000, 0x80000000, 0, 0, 0, 0, 0, 0, 0x4, 0x80, 0x4, 0x9, 0x105, 0x89, 0x16,
            0x20b, 0x11b, 0x12d, 0x41e, 0x224, 0x50, 0x92e,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 52,
        dv_b: 0,
        testt: Testt::T65,
        maski: 0,
        maskb: 27,
        dm: [
            0xc000002, 0xc0000010, 0xb400001c, 0x3c000004, 0xbc00001a, 0x20000010, 0x2400001c,
            0xec000014, 0xc000002, 0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018, 0xb0000010, 0xc,
            0xb8000010, 0x8000018, 0x78000010, 0x8000014, 0x70000010, 0xb800001c, 0xe8000000,
            0xb0000004, 0x58000010, 0xb000000c, 0x48000000, 0xb0000000, 0xb8000010, 0x98000010,
            0xa0000000, 0, 0, 0x20000000, 0x80000000, 0x10, 0, 0x20000010, 0x20000000, 0x10,
            0x60000000, 0x18, 0xe0000000, 0x90000000, 0x30000010, 0xb0000000, 0x20000000,
            0x20000000, 0xa0000000, 0x10, 0x80000000, 0x20000000, 0x20000000, 0x20000000,
            0x80000000, 0x10, 0, 0x20000010, 0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0,
            0, 0x1, 0x20, 0x1, 0x40000002, 0x40000041, 0x40000022, 0x80000005, 0xc0000082,
            0xc0000046, 0x4000004b, 0x80000107, 0x89, 0x14,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 53,
        dv_b: 0,
        testt: Testt::T65,
        maski: 0,
        maskb: 28,
        dm: [
            0xcc000014, 0xc000002, 0xc0000010, 0xb400001c, 0x3c000004, 0xbc00001a, 0x20000010,
            0x2400001c, 0xec000014, 0xc000002, 0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018,
            0xb0000010, 0xc, 0xb8000010, 0x8000018, 0x78000010, 0x8000014, 0x70000010, 0xb800001c,
            0xe8000000, 0xb0000004, 0x58000010, 0xb000000c, 0x48000000, 0xb0000000, 0xb8000010,
            0x98000010, 0xa0000000, 0, 0, 0x20000000, 0x80000000, 0x10, 0, 0x20000010, 0x20000000,
            0x10, 0x60000000, 0x18, 0xe0000000, 0x90000000, 0x30000010, 0xb0000000, 0x20000000,
            0x20000000, 0xa0000000, 0x10, 0x80000000, 0x20000000, 0x20000000, 0x20000000,
            0x80000000, 0x10, 0, 0x20000010, 0xa0000000, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 0,
            0, 0x1, 0x20, 0x1, 0x40000002, 0x40000041, 0x40000022, 0x80000005, 0xc0000082,
            0xc0000046, 0x4000004b, 0x80000107, 0x89,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 54,
        dv_b: 0,
        testt: Testt::T65,
        maski: 0,
        maskb: 29,
        dm: [
            0x400001c, 0xcc000014, 0xc000002, 0xc0000010, 0xb400001c, 0x3c000004, 0xbc00001a,
            0x20000010, 0x2400001c, 0xec000014, 0xc000002, 0xc0000010, 0xb400001c, 0x2c000004,
            0xbc000018, 0xb0000010, 0xc, 0xb8000010, 0x8000018, 0x78000010, 0x8000014, 0x70000010,
            0xb800001c, 0xe8000000, 0xb0000004, 0x58000010, 0xb000000c, 0x48000000, 0xb0000000,
            0xb8000010, 0x98000010, 0xa0000000, 0, 0, 0x20000000, 0x80000000, 0x10, 0, 0x20000010,
            0x20000000, 0x10, 0x60000000, 0x18, 0xe0000000, 0x90000000, 0x30000010, 0xb0000000,
            0x20000000, 0x20000000, 0xa0000000, 0x10, 0x80000000, 0x20000000, 0x20000000,
            0x20000000, 0x80000000, 0x10, 0, 0x20000010, 0xa0000000, 0, 0x20000000, 0x20000000, 0,
            0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002, 0x40000041, 0x40000022, 0x80000005,
            0xc0000082, 0xc0000046, 0x4000004b, 0x80000107,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 55,
        dv_b: 0,
        testt: Testt::T65,
        maski: 0,
        maskb: 30,
        dm: [
            0x10, 0x400001c, 0xcc000014, 0xc000002, 0xc0000010, 0xb400001c, 0x3c000004, 0xbc00001a,
            0x20000010, 0x2400001c, 0xec000014, 0xc000002, 0xc0000010, 0xb400001c, 0x2c000004,
            0xbc000018, 0xb0000010, 0xc, 0xb8000010, 0x8000018, 0x78000010, 0x8000014, 0x70000010,
            0xb800001c, 0xe8000000, 0xb0000004, 0x58000010, 0xb000000c, 0x48000000, 0xb0000000,
            0xb8000010, 0x98000010, 0xa0000000, 0, 0, 0x20000000, 0x80000000, 0x10, 0, 0x20000010,
            0x20000000, 0x10, 0x60000000, 0x18, 0xe0000000, 0x90000000, 0x30000010, 0xb0000000,
            0x20000000, 0x20000000, 0xa0000000, 0x10, 0x80000000, 0x20000000, 0x20000000,
            0x20000000, 0x80000000, 0x10, 0, 0x20000010, 0xa0000000, 0, 0x20000000, 0x20000000, 0,
            0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002, 0x40000041, 0x40000022, 0x80000005,
            0xc0000082, 0xc0000046, 0x4000004b,
        ],
    },
    Info {
        dv_type: 2,
        dv_k: 56,
        dv_b: 0,
        testt: Testt::T65,
        maski: 0,
        maskb: 31,
        dm: [
            0x2600001a, 0x10, 0x400001c, 0xcc000014, 0xc000002, 0xc0000010, 0xb400001c, 0x3c000004,
            0xbc00001a, 0x20000010, 0x2400001c, 0xec000014, 0xc000002, 0xc0000010, 0xb400001c,
            0x2c000004, 0xbc000018, 0xb0000010, 0xc, 0xb8000010, 0x8000018, 0x78000010, 0x8000014,
            0x70000010, 0xb800001c, 0xe8000000, 0xb0000004, 0x58000010, 0xb000000c, 0x48000000,
            0xb0000000, 0xb8000010, 0x98000010, 0xa0000000, 0, 0, 0x20000000, 0x80000000, 0x10, 0,
            0x20000010, 0x20000000, 0x10, 0x60000000, 0x18, 0xe0000000, 0x90000000, 0x30000010,
            0xb0000000, 0x20000000, 0x20000000, 0xa0000000, 0x10, 0x80000000, 0x20000000,
            0x20000000, 0x20000000, 0x80000000, 0x10, 0, 0x20000010, 0xa0000000, 0, 0x20000000,
            0x20000000, 0, 0, 0, 0, 0, 0, 0x1, 0x20, 0x1, 0x40000002, 0x40000041, 0x40000022,
            0x80000005, 0xc0000082, 0xc0000046,
        ],
    },
];

/// Takes as input an expanded message block and verifies the unavoidable bitconditions
/// for all listed DVs it returns a dvmask where each bit belonging to a DV is set if
/// all unavoidable bitconditions for that DV have been met thus one needs to do the
/// recompression check for each DV that has its bit set.
#[inline]
pub const fn ubc_check(w: &[u32; 80]) -> u32 {
    let mut mask: u32 = !0;
    mask &= ((w[44] ^ w[45]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_48_0_BIT
            | DV_I_51_0_BIT
            | DV_I_52_0_BIT
            | DV_II_45_0_BIT
            | DV_II_46_0_BIT
            | DV_II_50_0_BIT
            | DV_II_51_0_BIT);
    mask &= ((w[49] ^ w[50]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_46_0_BIT
            | DV_II_45_0_BIT
            | DV_II_50_0_BIT
            | DV_II_51_0_BIT
            | DV_II_55_0_BIT
            | DV_II_56_0_BIT);
    mask &= ((w[48] ^ w[49]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_45_0_BIT
            | DV_I_52_0_BIT
            | DV_II_49_0_BIT
            | DV_II_50_0_BIT
            | DV_II_54_0_BIT
            | DV_II_55_0_BIT);
    mask &= ((w[47] ^ w[50] >> 25) & (1 << 4)).wrapping_sub((1) << 4)
        | !(DV_I_47_0_BIT
            | DV_I_49_0_BIT
            | DV_I_51_0_BIT
            | DV_II_45_0_BIT
            | DV_II_51_0_BIT
            | DV_II_56_0_BIT);
    mask &= ((w[47] ^ w[48]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_44_0_BIT
            | DV_I_51_0_BIT
            | DV_II_48_0_BIT
            | DV_II_49_0_BIT
            | DV_II_53_0_BIT
            | DV_II_54_0_BIT);
    mask &= ((w[46] >> 4 ^ w[49] >> 29) & 1).wrapping_sub(1)
        | !(DV_I_46_0_BIT
            | DV_I_48_0_BIT
            | DV_I_50_0_BIT
            | DV_I_52_0_BIT
            | DV_II_50_0_BIT
            | DV_II_55_0_BIT);
    mask &= ((w[46] ^ w[47]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_43_0_BIT
            | DV_I_50_0_BIT
            | DV_II_47_0_BIT
            | DV_II_48_0_BIT
            | DV_II_52_0_BIT
            | DV_II_53_0_BIT);
    mask &= ((w[45] >> 4 ^ w[48] >> 29) & 1).wrapping_sub(1)
        | !(DV_I_45_0_BIT
            | DV_I_47_0_BIT
            | DV_I_49_0_BIT
            | DV_I_51_0_BIT
            | DV_II_49_0_BIT
            | DV_II_54_0_BIT);
    mask &= ((w[45] ^ w[46]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_49_0_BIT
            | DV_I_52_0_BIT
            | DV_II_46_0_BIT
            | DV_II_47_0_BIT
            | DV_II_51_0_BIT
            | DV_II_52_0_BIT);
    mask &= ((w[44] >> 4 ^ w[47] >> 29) & 1).wrapping_sub(1)
        | !(DV_I_44_0_BIT
            | DV_I_46_0_BIT
            | DV_I_48_0_BIT
            | DV_I_50_0_BIT
            | DV_II_48_0_BIT
            | DV_II_53_0_BIT);
    mask &= ((w[43] >> 4 ^ w[46] >> 29) & 1).wrapping_sub(1)
        | !(DV_I_43_0_BIT
            | DV_I_45_0_BIT
            | DV_I_47_0_BIT
            | DV_I_49_0_BIT
            | DV_II_47_0_BIT
            | DV_II_52_0_BIT);
    mask &= ((w[43] ^ w[44]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_47_0_BIT
            | DV_I_50_0_BIT
            | DV_I_51_0_BIT
            | DV_II_45_0_BIT
            | DV_II_49_0_BIT
            | DV_II_50_0_BIT);
    mask &= ((w[42] >> 4 ^ w[45] >> 29) & 1).wrapping_sub(1)
        | !(DV_I_44_0_BIT
            | DV_I_46_0_BIT
            | DV_I_48_0_BIT
            | DV_I_52_0_BIT
            | DV_II_46_0_BIT
            | DV_II_51_0_BIT);
    mask &= ((w[41] >> 4 ^ w[44] >> 29) & 1).wrapping_sub(1)
        | !(DV_I_43_0_BIT
            | DV_I_45_0_BIT
            | DV_I_47_0_BIT
            | DV_I_51_0_BIT
            | DV_II_45_0_BIT
            | DV_II_50_0_BIT);
    mask &= ((w[40] ^ w[41]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_44_0_BIT
            | DV_I_47_0_BIT
            | DV_I_48_0_BIT
            | DV_II_46_0_BIT
            | DV_II_47_0_BIT
            | DV_II_56_0_BIT);
    mask &= ((w[54] ^ w[55]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_51_0_BIT | DV_II_47_0_BIT | DV_II_50_0_BIT | DV_II_55_0_BIT | DV_II_56_0_BIT);
    mask &= ((w[53] ^ w[54]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_50_0_BIT | DV_II_46_0_BIT | DV_II_49_0_BIT | DV_II_54_0_BIT | DV_II_55_0_BIT);
    mask &= ((w[52] ^ w[53]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_49_0_BIT | DV_II_45_0_BIT | DV_II_48_0_BIT | DV_II_53_0_BIT | DV_II_54_0_BIT);
    mask &= ((w[50] ^ w[53] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
        | !(DV_I_50_0_BIT | DV_I_52_0_BIT | DV_II_46_0_BIT | DV_II_48_0_BIT | DV_II_54_0_BIT);
    mask &= ((w[50] ^ w[51]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_47_0_BIT | DV_II_46_0_BIT | DV_II_51_0_BIT | DV_II_52_0_BIT | DV_II_56_0_BIT);
    mask &= ((w[49] ^ w[52] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
        | !(DV_I_49_0_BIT | DV_I_51_0_BIT | DV_II_45_0_BIT | DV_II_47_0_BIT | DV_II_53_0_BIT);
    mask &= ((w[48] ^ w[51] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
        | !(DV_I_48_0_BIT | DV_I_50_0_BIT | DV_I_52_0_BIT | DV_II_46_0_BIT | DV_II_52_0_BIT);
    mask &= ((w[42] ^ w[43]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_46_0_BIT | DV_I_49_0_BIT | DV_I_50_0_BIT | DV_II_48_0_BIT | DV_II_49_0_BIT);
    mask &= ((w[41] ^ w[42]) >> 29 & 1).wrapping_sub(1)
        | !(DV_I_45_0_BIT | DV_I_48_0_BIT | DV_I_49_0_BIT | DV_II_47_0_BIT | DV_II_48_0_BIT);
    mask &= ((w[40] >> 4 ^ w[43] >> 29) & 1).wrapping_sub(1)
        | !(DV_I_44_0_BIT | DV_I_46_0_BIT | DV_I_50_0_BIT | DV_II_49_0_BIT | DV_II_56_0_BIT);
    mask &= ((w[39] >> 4 ^ w[42] >> 29) & 1).wrapping_sub(1)
        | !(DV_I_43_0_BIT | DV_I_45_0_BIT | DV_I_49_0_BIT | DV_II_48_0_BIT | DV_II_55_0_BIT);
    if mask & (DV_I_44_0_BIT | DV_I_48_0_BIT | DV_II_47_0_BIT | DV_II_54_0_BIT | DV_II_56_0_BIT)
        != 0
    {
        mask &= ((w[38] >> 4 ^ w[41] >> 29) & 1).wrapping_sub(1)
            | !(DV_I_44_0_BIT | DV_I_48_0_BIT | DV_II_47_0_BIT | DV_II_54_0_BIT | DV_II_56_0_BIT)
    }
    mask &= ((w[37] >> 4 ^ w[40] >> 29) & 1).wrapping_sub(1)
        | !(DV_I_43_0_BIT | DV_I_47_0_BIT | DV_II_46_0_BIT | DV_II_53_0_BIT | DV_II_55_0_BIT);
    if mask & (DV_I_52_0_BIT | DV_II_48_0_BIT | DV_II_51_0_BIT | DV_II_56_0_BIT) != 0 {
        mask &= ((w[55] ^ w[56]) >> 29 & 1).wrapping_sub(1)
            | !(DV_I_52_0_BIT | DV_II_48_0_BIT | DV_II_51_0_BIT | DV_II_56_0_BIT)
    }
    if mask & (DV_I_52_0_BIT | DV_II_48_0_BIT | DV_II_50_0_BIT | DV_II_56_0_BIT) != 0 {
        mask &= ((w[52] ^ w[55] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
            | !(DV_I_52_0_BIT | DV_II_48_0_BIT | DV_II_50_0_BIT | DV_II_56_0_BIT)
    }
    if mask & (DV_I_51_0_BIT | DV_II_47_0_BIT | DV_II_49_0_BIT | DV_II_55_0_BIT) != 0 {
        mask &= ((w[51] ^ w[54] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
            | !(DV_I_51_0_BIT | DV_II_47_0_BIT | DV_II_49_0_BIT | DV_II_55_0_BIT)
    }
    if mask & (DV_I_48_0_BIT | DV_II_47_0_BIT | DV_II_52_0_BIT | DV_II_53_0_BIT) != 0 {
        mask &= ((w[51] ^ w[52]) >> 29 & 1).wrapping_sub(1)
            | !(DV_I_48_0_BIT | DV_II_47_0_BIT | DV_II_52_0_BIT | DV_II_53_0_BIT)
    }
    if mask & (DV_I_46_0_BIT | DV_I_49_0_BIT | DV_II_45_0_BIT | DV_II_48_0_BIT) != 0 {
        mask &= ((w[36] >> 4 ^ w[40] >> 29) & 1).wrapping_sub(1)
            | !(DV_I_46_0_BIT | DV_I_49_0_BIT | DV_II_45_0_BIT | DV_II_48_0_BIT)
    }
    if mask & (DV_I_52_0_BIT | DV_II_48_0_BIT | DV_II_49_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[53] ^ w[56]) >> 29 & 1)
            | !(DV_I_52_0_BIT | DV_II_48_0_BIT | DV_II_49_0_BIT)
    }
    if mask & (DV_I_50_0_BIT | DV_II_46_0_BIT | DV_II_47_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[51] ^ w[54]) >> 29 & 1)
            | !(DV_I_50_0_BIT | DV_II_46_0_BIT | DV_II_47_0_BIT)
    }
    if mask & (DV_I_49_0_BIT | DV_I_51_0_BIT | DV_II_45_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[50] ^ w[52]) >> 29 & 1)
            | !(DV_I_49_0_BIT | DV_I_51_0_BIT | DV_II_45_0_BIT)
    }
    if mask & (DV_I_48_0_BIT | DV_I_50_0_BIT | DV_I_52_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[49] ^ w[51]) >> 29 & 1)
            | !(DV_I_48_0_BIT | DV_I_50_0_BIT | DV_I_52_0_BIT)
    }
    if mask & (DV_I_47_0_BIT | DV_I_49_0_BIT | DV_I_51_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[48] ^ w[50]) >> 29 & 1)
            | !(DV_I_47_0_BIT | DV_I_49_0_BIT | DV_I_51_0_BIT)
    }
    if mask & (DV_I_46_0_BIT | DV_I_48_0_BIT | DV_I_50_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[47] ^ w[49]) >> 29 & 1)
            | !(DV_I_46_0_BIT | DV_I_48_0_BIT | DV_I_50_0_BIT)
    }
    if mask & (DV_I_45_0_BIT | DV_I_47_0_BIT | DV_I_49_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[46] ^ w[48]) >> 29 & 1)
            | !(DV_I_45_0_BIT | DV_I_47_0_BIT | DV_I_49_0_BIT)
    }
    mask &= ((w[45] ^ w[47]) & (1 << 6)).wrapping_sub(1 << 6)
        | !(DV_I_47_2_BIT | DV_I_49_2_BIT | DV_I_51_2_BIT);
    if mask & (DV_I_44_0_BIT | DV_I_46_0_BIT | DV_I_48_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[45] ^ w[47]) >> 29 & 1)
            | !(DV_I_44_0_BIT | DV_I_46_0_BIT | DV_I_48_0_BIT)
    }
    mask &= ((w[44] ^ w[46]) >> 6 & 1).wrapping_sub(1)
        | !(DV_I_46_2_BIT | DV_I_48_2_BIT | DV_I_50_2_BIT);
    if mask & (DV_I_43_0_BIT | DV_I_45_0_BIT | DV_I_47_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[44] ^ w[46]) >> 29 & 1)
            | !(DV_I_43_0_BIT | DV_I_45_0_BIT | DV_I_47_0_BIT)
    }
    mask &= (0u32).wrapping_sub((w[41] ^ w[42] >> 5) & (1 << 1))
        | !(DV_I_48_2_BIT | DV_II_46_2_BIT | DV_II_51_2_BIT);
    mask &= (0u32).wrapping_sub((w[40] ^ w[41] >> 5) & (1 << 1))
        | !(DV_I_47_2_BIT | DV_I_51_2_BIT | DV_II_50_2_BIT);
    if mask & (DV_I_44_0_BIT | DV_I_46_0_BIT | DV_II_56_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[40] ^ w[42]) >> 4 & 1)
            | !(DV_I_44_0_BIT | DV_I_46_0_BIT | DV_II_56_0_BIT)
    }
    mask &= (0u32).wrapping_sub((w[39] ^ w[40] >> 5) & (1 << 1))
        | !(DV_I_46_2_BIT | DV_I_50_2_BIT | DV_II_49_2_BIT);
    if mask & (DV_I_43_0_BIT | DV_I_45_0_BIT | DV_II_55_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[39] ^ w[41]) >> 4 & 1)
            | !(DV_I_43_0_BIT | DV_I_45_0_BIT | DV_II_55_0_BIT)
    }
    if mask & (DV_I_44_0_BIT | DV_II_54_0_BIT | DV_II_56_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[38] ^ w[40]) >> 4 & 1)
            | !(DV_I_44_0_BIT | DV_II_54_0_BIT | DV_II_56_0_BIT)
    }
    if mask & (DV_I_43_0_BIT | DV_II_53_0_BIT | DV_II_55_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[37] ^ w[39]) >> 4 & 1)
            | !(DV_I_43_0_BIT | DV_II_53_0_BIT | DV_II_55_0_BIT)
    }
    mask &= (0u32).wrapping_sub((w[36] ^ w[37] >> 5) & (1 << 1))
        | !(DV_I_47_2_BIT | DV_I_50_2_BIT | DV_II_46_2_BIT);
    if mask & (DV_I_45_0_BIT | DV_I_48_0_BIT | DV_II_47_0_BIT) != 0 {
        mask &= ((w[35] >> 4 ^ w[39] >> 29) & 1).wrapping_sub(1)
            | !(DV_I_45_0_BIT | DV_I_48_0_BIT | DV_II_47_0_BIT)
    }
    if mask & (DV_I_48_0_BIT | DV_II_48_0_BIT) != 0 {
        mask &=
            (0u32).wrapping_sub((w[63] ^ w[64] >> 5) & (1 << 0)) | !(DV_I_48_0_BIT | DV_II_48_0_BIT)
    }
    if mask & (DV_I_45_0_BIT | DV_II_45_0_BIT) != 0 {
        mask &=
            (0u32).wrapping_sub((w[63] ^ w[64] >> 5) & (1 << 1)) | !(DV_I_45_0_BIT | DV_II_45_0_BIT)
    }
    if mask & (DV_I_47_0_BIT | DV_II_47_0_BIT) != 0 {
        mask &=
            (0u32).wrapping_sub((w[62] ^ w[63] >> 5) & (1 << 0)) | !(DV_I_47_0_BIT | DV_II_47_0_BIT)
    }
    if mask & (DV_I_46_0_BIT | DV_II_46_0_BIT) != 0 {
        mask &=
            (0u32).wrapping_sub((w[61] ^ w[62] >> 5) & (1 << 0)) | !(DV_I_46_0_BIT | DV_II_46_0_BIT)
    }
    mask &=
        (0u32).wrapping_sub((w[61] ^ w[62] >> 5) & (1 << 2)) | !(DV_I_46_2_BIT | DV_II_46_2_BIT);
    if mask & (DV_I_45_0_BIT | DV_II_45_0_BIT) != 0 {
        mask &=
            (0u32).wrapping_sub((w[60] ^ w[61] >> 5) & (1 << 0)) | !(DV_I_45_0_BIT | DV_II_45_0_BIT)
    }
    if mask & (DV_II_51_0_BIT | DV_II_54_0_BIT) != 0 {
        mask &= ((w[58] ^ w[59]) >> 29 & 1).wrapping_sub(1) | !(DV_II_51_0_BIT | DV_II_54_0_BIT)
    }
    if mask & (DV_II_50_0_BIT | DV_II_53_0_BIT) != 0 {
        mask &= ((w[57] ^ w[58]) >> 29 & 1).wrapping_sub(1) | !(DV_II_50_0_BIT | DV_II_53_0_BIT)
    }
    if mask & (DV_II_52_0_BIT | DV_II_54_0_BIT) != 0 {
        mask &= ((w[56] ^ w[59] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
            | !(DV_II_52_0_BIT | DV_II_54_0_BIT)
    }
    if mask & (DV_II_51_0_BIT | DV_II_52_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[56] ^ w[59]) >> 29 & 1) | !(DV_II_51_0_BIT | DV_II_52_0_BIT)
    }
    if mask & (DV_II_49_0_BIT | DV_II_52_0_BIT) != 0 {
        mask &= ((w[56] ^ w[57]) >> 29 & 1).wrapping_sub(1) | !(DV_II_49_0_BIT | DV_II_52_0_BIT)
    }
    if mask & (DV_II_51_0_BIT | DV_II_53_0_BIT) != 0 {
        mask &= ((w[55] ^ w[58] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
            | !(DV_II_51_0_BIT | DV_II_53_0_BIT)
    }
    if mask & (DV_II_50_0_BIT | DV_II_52_0_BIT) != 0 {
        mask &= ((w[54] ^ w[57] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
            | !(DV_II_50_0_BIT | DV_II_52_0_BIT)
    }
    if mask & (DV_II_49_0_BIT | DV_II_51_0_BIT) != 0 {
        mask &= ((w[53] ^ w[56] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
            | !(DV_II_49_0_BIT | DV_II_51_0_BIT)
    }
    mask &=
        ((w[51] ^ w[50] >> 5) & (1 << 1)).wrapping_sub(1 << 1) | !(DV_I_50_2_BIT | DV_II_46_2_BIT);
    mask &= ((w[48] ^ w[50]) & (1 << 6)).wrapping_sub(1 << 6) | !(DV_I_50_2_BIT | DV_II_46_2_BIT);
    if mask & (DV_I_51_0_BIT | DV_I_52_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[48] ^ w[55]) >> 29 & 1) | !(DV_I_51_0_BIT | DV_I_52_0_BIT)
    }
    mask &= ((w[47] ^ w[49]) & (1 << 6)).wrapping_sub(1 << 6) | !(DV_I_49_2_BIT | DV_I_51_2_BIT);
    mask &=
        ((w[48] ^ w[47] >> 5) & (1 << 1)).wrapping_sub(1 << 1) | !(DV_I_47_2_BIT | DV_II_51_2_BIT);
    mask &= ((w[46] ^ w[48]) & (1 << 6)).wrapping_sub(1 << 6) | !(DV_I_48_2_BIT | DV_I_50_2_BIT);
    mask &=
        ((w[47] ^ w[46] >> 5) & (1 << 1)).wrapping_sub(1 << 1) | !(DV_I_46_2_BIT | DV_II_50_2_BIT);
    mask &=
        (0u32).wrapping_sub((w[44] ^ w[45] >> 5) & (1 << 1)) | !(DV_I_51_2_BIT | DV_II_49_2_BIT);
    mask &= ((w[43] ^ w[45]) & (1 << 6)).wrapping_sub(1 << 6) | !(DV_I_47_2_BIT | DV_I_49_2_BIT);
    mask &= ((w[42] ^ w[44]) >> 6 & 1).wrapping_sub(1) | !(DV_I_46_2_BIT | DV_I_48_2_BIT);
    mask &=
        ((w[43] ^ w[42] >> 5) & (1 << 1)).wrapping_sub(1 << 1) | !(DV_II_46_2_BIT | DV_II_51_2_BIT);
    mask &=
        ((w[42] ^ w[41] >> 5) & (1 << 1)).wrapping_sub(1 << 1) | !(DV_I_51_2_BIT | DV_II_50_2_BIT);
    mask &=
        ((w[41] ^ w[40] >> 5) & (1 << 1)).wrapping_sub(1 << 1) | !(DV_I_50_2_BIT | DV_II_49_2_BIT);
    if mask & (DV_I_52_0_BIT | DV_II_51_0_BIT) != 0 {
        mask &= ((w[39] ^ w[43] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
            | !(DV_I_52_0_BIT | DV_II_51_0_BIT)
    }
    if mask & (DV_I_51_0_BIT | DV_II_50_0_BIT) != 0 {
        mask &= ((w[38] ^ w[42] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
            | !(DV_I_51_0_BIT | DV_II_50_0_BIT)
    }
    if mask & (DV_I_48_2_BIT | DV_I_51_2_BIT) != 0 {
        mask &=
            (0u32).wrapping_sub((w[37] ^ w[38] >> 5) & (1 << 1)) | !(DV_I_48_2_BIT | DV_I_51_2_BIT)
    }
    if mask & (DV_I_50_0_BIT | DV_II_49_0_BIT) != 0 {
        mask &= ((w[37] ^ w[41] >> 25) & (1 << 4)).wrapping_sub(1 << 4)
            | !(DV_I_50_0_BIT | DV_II_49_0_BIT)
    }
    if mask & (DV_II_52_0_BIT | DV_II_54_0_BIT) != 0 {
        mask &= (0u32).wrapping_sub((w[36] ^ w[38]) & (1 << 4)) | !(DV_II_52_0_BIT | DV_II_54_0_BIT)
    }
    mask &= (0u32).wrapping_sub((w[35] ^ w[36] >> 5) & (1 << 1)) | !(DV_I_46_2_BIT | DV_I_49_2_BIT);
    if mask & (DV_I_51_0_BIT | DV_II_47_0_BIT) != 0 {
        mask &= ((w[35] ^ w[39] >> 25) & (1 << 3)).wrapping_sub(1 << 3)
            | !(DV_I_51_0_BIT | DV_II_47_0_BIT)
    }
    if mask != 0 {
        if mask & DV_I_43_0_BIT != 0
            && ((w[61] ^ w[62] >> 5) & (1 << 1) == 0
                || (w[59] ^ w[63] >> 25) & (1 << 5) != 0
                || (w[58] ^ w[63] >> 30) & (1 << 0) == 0)
        {
            mask &= !DV_I_43_0_BIT
        }
        if mask & DV_I_44_0_BIT != 0
            && ((w[62] ^ w[63] >> 5) & (1 << 1) == 0
                || (w[60] ^ w[64] >> 25) & (1 << 5) != 0
                || (w[59] ^ w[64] >> 30) & (1 << 0) == 0)
        {
            mask &= !DV_I_44_0_BIT
        }
        if mask & DV_I_46_2_BIT != 0 {
            mask &= !((w[40] ^ w[42]) >> 2) | !DV_I_46_2_BIT
        }
        if mask & DV_I_47_2_BIT != 0
            && ((w[62] ^ w[63] >> 5) & (1 << 2) == 0 || (w[41] ^ w[43]) & (1 << 6) != 0)
        {
            mask &= !DV_I_47_2_BIT
        }
        if mask & DV_I_48_2_BIT != 0
            && ((w[63] ^ w[64] >> 5) & (1 << 2) == 0 || (w[48] ^ w[49] << 5) & (1 << 6) != 0)
        {
            mask &= !DV_I_48_2_BIT
        }
        if mask & DV_I_49_2_BIT != 0
            && ((w[49] ^ w[50] << 5) & (1 << 6) != 0
                || (w[42] ^ w[50]) & (1 << 1) == 0
                || (w[39] ^ w[40] << 5) & (1 << 6) != 0
                || (w[38] ^ w[40]) & (1 << 1) == 0)
        {
            mask &= !DV_I_49_2_BIT
        }
        if mask & DV_I_50_0_BIT != 0 {
            mask &= (w[36] ^ w[37]) << 7 | !DV_I_50_0_BIT
        }
        if mask & DV_I_50_2_BIT != 0 {
            mask &= (w[43] ^ w[51]) << 11 | !DV_I_50_2_BIT
        }
        if mask & DV_I_51_0_BIT != 0 {
            mask &= (w[37] ^ w[38]) << 9 | !DV_I_51_0_BIT
        }
        if mask & DV_I_51_2_BIT != 0
            && ((w[51] ^ w[52] << 5) & (1 << 6) != 0
                || (w[49] ^ w[51]) & (1 << 6) != 0
                || (w[37] ^ w[37] >> 5) & (1 << 1) != 0
                || (w[35] ^ w[39] >> 25) & (1 << 5) != 0)
        {
            mask &= !DV_I_51_2_BIT
        }
        if mask & DV_I_52_0_BIT != 0 {
            mask &= (w[38] ^ w[39]) << 11 | !DV_I_52_0_BIT
        }
        if mask & DV_II_46_2_BIT != 0 {
            mask &= (w[47] ^ w[51]) << 17 | !DV_II_46_2_BIT
        }
        if mask & DV_II_48_0_BIT != 0
            && ((w[36] ^ w[40] >> 25) & (1 << 3) != 0 || (w[35] ^ w[40] << 2) & (1 << 30) == 0)
        {
            mask &= !DV_II_48_0_BIT
        }
        if mask & DV_II_49_0_BIT != 0
            && ((w[37] ^ w[41] >> 25) & (1 << 3) != 0 || (w[36] ^ w[41] << 2) & (1 << 30) == 0)
        {
            mask &= !DV_II_49_0_BIT
        }
        if mask & DV_II_49_2_BIT != 0
            && ((w[53] ^ w[54] << 5) & (1 << 6) != 0
                || (w[51] ^ w[53]) & (1 << 6) != 0
                || (w[50] ^ w[54]) & (1 << 1) == 0
                || (w[45] ^ w[46] << 5) & (1 << 6) != 0
                || (w[37] ^ w[41] >> 25) & (1 << 5) != 0
                || (w[36] ^ w[41] >> 30) & (1 << 0) == 0)
        {
            mask &= !DV_II_49_2_BIT
        }
        if mask & DV_II_50_0_BIT != 0
            && ((w[55] ^ w[58]) & (1 << 29) == 0
                || (w[38] ^ w[42] >> 25) & (1 << 3) != 0
                || (w[37] ^ w[42] << 2) & (1 << 30) == 0)
        {
            mask &= !DV_II_50_0_BIT
        }
        if mask & DV_II_50_2_BIT != 0
            && ((w[54] ^ w[55] << 5) & (1 << 6) != 0
                || (w[52] ^ w[54]) & (1 << 6) != 0
                || (w[51] ^ w[55]) & (1 << 1) == 0
                || (w[45] ^ w[47]) & (1 << 1) == 0
                || (w[38] ^ w[42] >> 25) & (1 << 5) != 0
                || (w[37] ^ w[42] >> 30) & (1 << 0) == 0)
        {
            mask &= !DV_II_50_2_BIT
        }
        if mask & DV_II_51_0_BIT != 0
            && ((w[39] ^ w[43] >> 25) & (1 << 3) != 0 || (w[38] ^ w[43] << 2) & (1 << 30) == 0)
        {
            mask &= !DV_II_51_0_BIT
        }
        if mask & DV_II_51_2_BIT != 0
            && ((w[55] ^ w[56] << 5) & (1 << 6) != 0
                || (w[53] ^ w[55]) & (1 << 6) != 0
                || (w[52] ^ w[56]) & (1 << 1) == 0
                || (w[46] ^ w[48]) & (1 << 1) == 0
                || (w[39] ^ w[43] >> 25) & (1 << 5) != 0
                || (w[38] ^ w[43] >> 30) & (1 << 0) == 0)
        {
            mask &= !DV_II_51_2_BIT
        }
        if mask & DV_II_52_0_BIT != 0
            && ((w[59] ^ w[60]) & (1 << 29) != 0
                || (w[40] ^ w[44] >> 25) & (1 << 3) != 0
                || (w[40] ^ w[44] >> 25) & (1 << 4) != 0
                || (w[39] ^ w[44] << 2) & (1 << 30) == 0)
        {
            mask &= !DV_II_52_0_BIT
        }
        if mask & DV_II_53_0_BIT != 0
            && ((w[58] ^ w[61]) & (1 << 29) == 0
                || (w[57] ^ w[61] >> 25) & (1 << 4) != 0
                || (w[41] ^ w[45] >> 25) & (1 << 3) != 0
                || (w[41] ^ w[45] >> 25) & (1 << 4) != 0)
        {
            mask &= !DV_II_53_0_BIT
        }
        if mask & DV_II_54_0_BIT != 0
            && ((w[58] ^ w[62] >> 25) & (1 << 4) != 0
                || (w[42] ^ w[46] >> 25) & (1 << 3) != 0
                || (w[42] ^ w[46] >> 25) & (1 << 4) != 0)
        {
            mask &= !DV_II_54_0_BIT
        }
        if mask & DV_II_55_0_BIT != 0
            && ((w[59] ^ w[63] >> 25) & (1 << 4) != 0
                || (w[57] ^ w[59] >> 25) & (1 << 4) != 0
                || (w[43] ^ w[47] >> 25) & (1 << 3) != 0
                || (w[43] ^ w[47] >> 25) & (1 << 4) != 0)
        {
            mask &= !DV_II_55_0_BIT
        }
        if mask & DV_II_56_0_BIT != 0
            && ((w[60] ^ w[64] >> 25) & (1 << 4) != 0
                || (w[44] ^ w[48] >> 25) & (1 << 3) != 0
                || (w[44] ^ w[48] >> 25) & (1 << 4) != 0)
        {
            mask &= !DV_II_56_0_BIT
        }
    }
    mask
}
