---
myst:
  html_meta:
    keywords: LaTeX,flottants,illustrations
---

# Illustrations


Ce thème comporte regroupe les questions portant sur les *illustrations*
(graphiques, images et autres figures), leur construction, leur
inclusion et leur mise en forme. Si certaines questions évoquent le
positionnement des illustrations, il est intéressant ici de parcourir
également les questions portant sur les
[flottants](/3_composition/flottants/start) (ces derniers permettant,
entre autres, de donner une légende et une numération aux figures
contenant les illustrations).

Trois types d'illustrations font l'objet de pages dédiées :

-   les [animations](/3_composition/illustrations/animations/start)
    (pour des documents PDF) ;
-   les [images](/3_composition/illustrations/inclure_une_image/start) ;
-   les [visualisations de
    données](/3_composition/illustrations/graphiques/start).

## Création d'illustrations

### Sans TeX et LaTeX

-   [Où trouver un logiciel de dessin ?](/3_composition/illustrations/logiciels_de_dessins_compatibles_avec_latex)

### Avec TeX et LaTeX

-   [Comment dessiner avec TeX ?](/3_composition/illustrations/dessiner_avec_tex)
-   [Comment définir de nouvelles couleurs ?](/3_composition/illustrations/definir_de_nouvelles_couleurs)
-   [Comment tracer un filet ?](/3_composition/illustrations/tracer_des_lignes)
-   [Comment dessiner en style 8-bits ?](/3_composition/illustrations/dessiner_en_style_8bits)
-   [Quels langages de description graphique peut-on utiliser avec LaTeX ?](/3_composition/illustrations/dessiner_avec_tex2)
-   [Comment dessiner un arbre ?](/3_composition/illustrations/construire_un_arbre)
-   [Comment faire un organigramme ?](/3_composition/illustrations/construire_un_organigramme)
-   [Comment inclure des formules LaTeX dans Xfig ?](/3_composition/illustrations/inclure_des_formules_latex_dans_xfig)
-   [Comment créer une image indépendante en
    SVG ?](/3_composition/illustrations/creer_une_image_en_svg_avec_latex)

## Style des illustrations

-   [Comment superposer du texte sur des figures ?](/3_composition/illustrations/ecrire_par-dessus_une_figure)
-   [Comment placer du texte LaTeX dans un graphique ?](/3_composition/illustrations/annoter_un_graphique)
-   [Comment centrer une figure très large ?](/3_composition/illustrations/centrer_une_figure_tres_large)
-   [Comment aligner le haut de graphiques importés ?](/3_composition/illustrations/aligner_des_images_en_haut)
-   [Comment insérer plusieurs fois une image dans un document ?](/3_composition/illustrations/repeter_une_image_dans_un_document)
-   [Comment créer une ombre sous une image ?](/3_composition/illustrations/ombre_sous_une_image)
- [](/3_composition/illustrations/tracer_des_lignes)
- [](/3_composition/illustrations/tracer_ligne_fleche_au_milieu.md)

```{toctree}
:glob: true
:maxdepth: 1
:hidden:

*/start
*
```
