---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux, cellules, cellule d'angle, trait en diagonale, 
              deux traits obliques, cellule barrée
---

# Comment diviser une cellule par une diagonale ?

## Avec l'extension <ctanpkg:diagbox>

L'extension <ctanpkg:diagbox> fournit la commande `\diagbox` qui prend 
deux arguments. Cette commande sépare la cellule courante en deux, 
par un trait diagonal du coin supérieur gauche vers le coin inférieur droit,
 place son premier argument *sous* ce trait et son deuxième argument 
 *au-dessus*. En voici un exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{diagbox}

\begin{document}
\begin{tabular}{|l|c|c|c|c|c|c|}
  \hline
  \diagbox{qui}{quoi} &
  voiture & tente & corde \\
  \hline
  Nico   & 1 & 1 & 1 \\ \hline
  Hélène &   &   & 1 \\ \hline
  Tof    &   & 1 & 1 \\ \hline
  Xav    & 1 &   &   \\ \hline
\end{tabular}
\end{document}
```

Si la première ligne est trop haute, <ctanpkg:diagbox> n'arrivera pas 
à s'aligner sur le coin supérieur gauche, et s'alignera uniquement 
sur le coin inférieur droit. Le résultat reste généralement acceptable :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{diagbox}
  \usepackage{rotating}

\begin{document}
\begin{tabular}{|l|c|c|c|}
  \hline
  \diagbox{qui}{quoi} &
    \begin{turn}{90}voiture\end{turn} &
    \begin{turn}{90}tente\end{turn} &
    \begin{turn}{90}corde\end{turn}
  \\ \hline
  Nico   & 1 & 1 & 1 \\ \hline
  Hélène &   &   & 1 \\ \hline
  Tof    &   & 1 & 1 \\ \hline
  Xav    & 1 &   &   \\ \hline
\end{tabular}
\end{document}
```

Il est également possible de passer trois argument à `\diagbox`, 
pour dessiner *deux* lignes obliques :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{diagbox}

\begin{document}
\begin{tabular}{|l|c|c|c|}
  \hline
  \diagbox{heure}{Bureau 1}{jour} &
    Lundi & Mardi & Mercredi \\ \hline
    9h -- 12h  & occupé & occupé &  \\ \hline
    14h -- 17h &  & occupé & occupé \\ \hline
\end{tabular}
\end{document}
```


## Avec l'extension <ctanpkg:slashbox>

:::{warning}
L’extension <ctanpkg:slashbox> est classée comme
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). Ce qui suit
est informatif.
:::

L'extension <ctanpkg:slashbox> fournit la commande `\backslashbox`, 
qui a la même syntaxe que `\diagbox` ci-dessus, avec deux arguments. 
Elle est toujours disponible dans CTAN mais n'est plus distribuée dans 
TeX live.

L'extension <ctanpkg:diagbox> fournit d'ailleurs les commandes compatibles 
`\backslashbox` et `\slashbox` pour permettre une transition facile 
entre les deux extensions.


:::{sources}
[Diagonal separation in corner cells of tables](faquk:FAQ-slashbox).
:::