
#include "fileHandle.h"

/**************************************************************************
 **SA Network Connection Profiler [sancp] - A TCP/IP statistical/collection tool
 * ************************************************************************
 * * Copyright (C) 2003 John Curry <john.curry@metre.net>
 * *
 * * This program is distributed under the terms of version 1.0 of the
 * * Q Public License.  See LICENSE.QPL for further details.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * *
 * ***********************************************************************/

fileHandle::fileHandle():in_use(1),handle(0),filename(0){ }

fileHandle::fileHandle(FILE *OFH, int mode = APPEND_MODE):in_use(1),handle(OFH),filename(0),mode(mode){ }
 
fileHandle::fileHandle(const char *newfilename):in_use(1),handle(0),filename(0),mode(APPEND_MODE)
{
	setFileName(newfilename);
}
fileHandle::fileHandle(const char *newfilename, int mode = APPEND_MODE ):in_use(1),handle(0),filename(0),mode(mode)
{
	setFileName(newfilename);
}

void fileHandle::setFileName(const char *newfilename){
	if( filename!=0 ){ ::free(filename); }
	if( newfilename != 0 )
	{
	        filename=(char *) calloc(1,strlen(newfilename)+1);
	        strncpy(filename,newfilename,strlen(newfilename));
	}else{
		filename = 0;
	}
}	

FILE * fileHandle::getFileHandle()
{ 
	return handle; 
}	
 
char * fileHandle::getFileName()
{ 
	return filename; 
}	

int fileHandle::isOpen()
{

	if(handle){ return 1; }
	return 0;
}

int fileHandle::open()
{ 
	if(isOpen()){ return 1; }
	if(mode == WRITE_MODE ) { 
		if(filename==0){ handle=stdout; return 1;}
		// Open file in write mode
		if((handle = fopen(filename,"w+"))==NULL){ return 0; }
		flock(fileno(handle),LOCK_EX|LOCK_NB);
	}else if(mode == APPEND_MODE ) {
		if(filename==0){ handle=stdout; return 1;}
		// Open file in append mode
		if((handle = fopen(filename,"a"))==NULL){ return 0; }
		flock(fileno(handle),LOCK_EX|LOCK_NB);
	}else{
		if(filename==0){ handle=stdin; return 1;}
		// Open file in read mode
		if((handle = fopen(filename,"r"))==NULL){ return 0; }
		flock(fileno(handle),LOCK_SH|LOCK_NB);
	}
	return 1;
}

int fileHandle::getMode()
{
	return mode;
}

void fileHandle::setMode(int tmode)
{
	mode = tmode;
}

void fileHandle::reopen()
{
	close();
	open();
}

long fileHandle::tell()
{
 	if(open())
	{
		return ::ftell(handle);
	}else{
		//Unable to read from file
		return -1;
	}
}

int fileHandle::seek(long offset, int whence)
{
 	if(open())
	{
		return ::fseek(handle,offset,whence);
	}else{
		//Unable to read from file
		return -1;
	}
}

int fileHandle::read(char *data, int len)
{
 	if(open())
	{
		return ::read(fileno(handle),data,len);
	}else{
		//Unable to read from file
		return -1;
	}
}

ssize_t fileHandle::write(const char *data, int len)
{
	if( mode == READ_MODE )
	{
		//File in READ-ONLY MODE 
		return -2;
	}
 	if(open()) 
	{
		return ::write(fileno(handle),data,len);
	}else{
		//Unable to print to file
		return -3;
	}
}

fileHandle * fileHandle::attach()
{
	in_use++;
	return this;
}

void fileHandle::detach()
{
	if(in_use)
		in_use--;
}

void fileHandle::destroy()
{
	detach();
	if(!in_use){ delete this; }
}

void fileHandle::close() 
{ 
	if(handle && filename) 
	{
		fflush(handle);
		flock(fileno(handle),LOCK_UN|LOCK_NB);
		fclose(handle); 
	}
	handle=0;
}

fileHandle::~fileHandle()
{
	close();
	if(filename)
		free(filename);
	filename=0;
}

