// Code generated by sdkgen. DO NOT EDIT.

// nolint
package eventrouter

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	eventrouter "github.com/yandex-cloud/go-genproto/yandex/cloud/serverless/eventrouter/v1"
)

//revive:disable

// BusServiceClient is a eventrouter.BusServiceClient with
// lazy GRPC connection initialization.
type BusServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements eventrouter.BusServiceClient
func (c *BusServiceClient) Create(ctx context.Context, in *eventrouter.CreateBusRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewBusServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements eventrouter.BusServiceClient
func (c *BusServiceClient) Delete(ctx context.Context, in *eventrouter.DeleteBusRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewBusServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements eventrouter.BusServiceClient
func (c *BusServiceClient) Get(ctx context.Context, in *eventrouter.GetBusRequest, opts ...grpc.CallOption) (*eventrouter.Bus, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewBusServiceClient(conn).Get(ctx, in, opts...)
}

// List implements eventrouter.BusServiceClient
func (c *BusServiceClient) List(ctx context.Context, in *eventrouter.ListBusesRequest, opts ...grpc.CallOption) (*eventrouter.ListBusesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewBusServiceClient(conn).List(ctx, in, opts...)
}

type BusIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BusServiceClient
	request *eventrouter.ListBusesRequest

	items []*eventrouter.Bus
}

func (c *BusServiceClient) BusIterator(ctx context.Context, req *eventrouter.ListBusesRequest, opts ...grpc.CallOption) *BusIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BusIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BusIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Buses
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *BusIterator) Take(size int64) ([]*eventrouter.Bus, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*eventrouter.Bus

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BusIterator) TakeAll() ([]*eventrouter.Bus, error) {
	return it.Take(0)
}

func (it *BusIterator) Value() *eventrouter.Bus {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BusIterator) Error() error {
	return it.err
}

// ListAccessBindings implements eventrouter.BusServiceClient
func (c *BusServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewBusServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type BusAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BusServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *BusServiceClient) BusAccessBindingsIterator(ctx context.Context, req *access.ListAccessBindingsRequest, opts ...grpc.CallOption) *BusAccessBindingsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BusAccessBindingsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BusAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *BusAccessBindingsIterator) Take(size int64) ([]*access.AccessBinding, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*access.AccessBinding

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BusAccessBindingsIterator) TakeAll() ([]*access.AccessBinding, error) {
	return it.Take(0)
}

func (it *BusAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BusAccessBindingsIterator) Error() error {
	return it.err
}

// ListOperations implements eventrouter.BusServiceClient
func (c *BusServiceClient) ListOperations(ctx context.Context, in *eventrouter.ListBusOperationsRequest, opts ...grpc.CallOption) (*eventrouter.ListBusOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewBusServiceClient(conn).ListOperations(ctx, in, opts...)
}

type BusOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BusServiceClient
	request *eventrouter.ListBusOperationsRequest

	items []*operation.Operation
}

func (c *BusServiceClient) BusOperationsIterator(ctx context.Context, req *eventrouter.ListBusOperationsRequest, opts ...grpc.CallOption) *BusOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BusOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BusOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *BusOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BusOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *BusOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BusOperationsIterator) Error() error {
	return it.err
}

// SetAccessBindings implements eventrouter.BusServiceClient
func (c *BusServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewBusServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// Update implements eventrouter.BusServiceClient
func (c *BusServiceClient) Update(ctx context.Context, in *eventrouter.UpdateBusRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewBusServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements eventrouter.BusServiceClient
func (c *BusServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewBusServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}
