/*  ---------------------------------------------------------------
    xhkeys. Jul 2002
    Copyright (C) 2002,  Michael Glickman  <wmalms@yahoo.com>
    License: GPL
    --------------------------------------------------------------- */
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>

#include "xhkeys_conf.h"

#ifdef USE_DMALLOC
#include <dmalloc.h>
#endif

#include "xhkeys.h"

extern Display *dpy;
extern Window wnd;
extern Atom WMStateAtom;
extern int keyTimeout;
extern int btnTimeout;
extern int count;

// return 0 - error, 1 - ok, 2 - timeout
short getScanCodeEvent(XEvent *xevPtr, unsigned int timeout, char **errMsg)
{
  time_t timeCurrent, timeToStop;
  XEvent xev;
  int count;

  if (XGrabKeyboard(dpy, wnd, False, GrabModeAsync, GrabModeAsync, CurrentTime) != 0) {
	*errMsg = "Grab keyboard error";
	return 0;
  }

/*  XSelectInput(dpy, wnd, KeyPressMask | KeyReleaseMask); */
  timeCurrent = clock();
  timeToStop = timeCurrent + timeout * CLOCKS_PER_SEC;
  count = 0;

  for(;timeCurrent < timeToStop; timeCurrent = clock())
  {
	if (XPending(dpy) == 0) {
	  sleep(0);
	  continue;
	}  

	XNextEvent(dpy, &xev);
	if (xev.type == KeyPress) {
	  memcpy(xevPtr, &xev, sizeof(XKeyEvent));
	  ++count;
//	  if (++count > 1) break;
	}  
	else
	if (xev.type == KeyRelease && count > 0)
	  break;
  }

  XUngrabKeyboard(dpy, CurrentTime);
  XSync(dpy, True);

  return (count > 0) ? 1 : 2;
}

Bool showScanCodes(char **errMsg)
{
  XEvent xev;
  KeyCode keycode;	
  unsigned int state;
  char *ksStr;
  char msgBuffer[81], strBuf[2], strChar;
  KeySym ks;
  int cnt;
  short res;
  
  printf("Type any key to see its information\n");
  printf ("Quits ");
  if (count > 1)  printf("after %d types, or ", count);
  printf ("if idle within %d secs\n", keyTimeout);
  cnt = count;

  while ((res = getScanCodeEvent(&xev, keyTimeout, errMsg)) == 1) {
  
	if (XLookupString(&(xev.xkey), strBuf, sizeof(strBuf), &ks, NULL) > 0) {
	  strChar = *strBuf;
	  ksStr = XKeysymToString(ks);
	}  
	else {
	  strChar = '\0';
	  ksStr = "[undefined]";	
	}  
	  
	keycode = xev.xkey.keycode;
	state = xev.xkey.state;
	
	sprintf (msgBuffer, "Scan code: %3u (0x%02x)  State: %3u (0x%02x)  Char code: 0x%02x  Keysym: 0x%04lx %s",
	                                    keycode, keycode, state, state, strChar, ks, ksStr); 	  
    puts (msgBuffer);

	if (cnt>0 && --cnt==0) break;
  } 

	
  if (res == 2)
	printf("\nQuit on time-out. Bye\n");

  return (res != 0);

}


// return 0 - error, 1 - button event, 2 - keyEvent, 3 - timeout
short getMouseOrKeyEvent(XEvent *xevPtr, unsigned int timeout,
                        const char *keysAllowed, char *keyPressed,  char **errMsg)
{
  time_t timeCurrent, timeToStop;
  XEvent xev;
  Bool rc = False;


  if(XGrabPointer(dpy, wnd, True, ButtonPressMask, GrabModeAsync, 
                 GrabModeAsync, None, None, CurrentTime) != 0) {
	*errMsg = "Grab pointer error";
	return 0;
  }

  if (XGrabKeyboard(dpy, wnd, False, GrabModeAsync, GrabModeAsync, CurrentTime) != 0) {
	*errMsg = "Grab keyboard error";
	return 0;
  }

//  XSelectInput(dpy, wnd, ButtonPressMask);
  timeCurrent = clock();
  timeToStop = timeCurrent + timeout * CLOCKS_PER_SEC;
  rc = 3;  		// Awaiting timeout

  for(;timeCurrent < timeToStop; timeCurrent = clock())
  {
	if (XPending(dpy) == 0) {
	  sleep(0);
	  continue;
	}  

	XNextEvent(dpy, &xev);
	if (xev.type == ButtonPress) {
	  memcpy(xevPtr, &xev, sizeof(XKeyEvent));
	  rc = 1;
	  break;
	}  

	if (xev.type == KeyPress) {
          char pressedChar;		
	  KeySym ks;
	  if (XLookupString(&(xev.xkey), &pressedChar, 1, &ks, NULL) > 0) {
	  	pressedChar = toupper(pressedChar);
		if (strchr(keysAllowed, pressedChar)) {
			*keyPressed = pressedChar;
			rc = 2;
			break;
	  	}
	  }
	
	}	
	
  }

  XUngrabKeyboard(dpy,  CurrentTime);
  XUngrabPointer(dpy,  CurrentTime);
  XSync(dpy, True);
  return rc;
}


Bool showMouseEventInfos(char **errMsg)
{
  XEvent xev;
  XClassHint xch;
  Window cur, tmp;
  XTextProperty xtp;
  char **list;
  unsigned int state;
  int x, y;
  short res;
  int cnt;
  
  printf("Click any place on the screen with a mouse button\n");
  printf ("Quits ");
  if (count > 1)  printf("after %d clicks, or ", count);
  printf ("if idle within %d secs\n", btnTimeout);
  cnt = count;

  while ((res = getMouseEvent(&xev, btnTimeout, errMsg)) == 1) {
	state = xev.xbutton.state;
	tmp = xev.xbutton.subwindow;
	if (tmp == None)
	  cur = wnd;
	else {  
	  cur = findClientWindow(tmp, -1);
	  if (cur == None) cur = tmp;
	}  
	
    printf ("Id = %10ld (0x%lx)\n",   cur, cur);

    if (cur == wnd) 
	    printf ("\tRoot window\n");
	
    if (XGetClassHint(dpy, cur, &xch)) 
	    printf ("\tWM Hints: App = '%s'   Class = '%s'\n",
	        xch.res_name, xch.res_class);
			
	if (XGetWMName(dpy, cur, &xtp) &&
	    XTextPropertyToStringList(&xtp, &list, &x)) {
	  if (x > 0) 
		printf ("\tTitle: '%s'\n", list[0]);		
	  XFreeStringList(list);		
	}  	 

    printf ("\tMouse click: button %d   state  %d\n", xev.xbutton.button, xev.xbutton.state);

	if (XTranslateCoordinates(dpy, xev.xbutton.root, cur,
	                               xev.xbutton.x_root,  xev.xbutton.y_root,
								   &x, &y, &tmp))
	  printf ("\tRelative coordinates (x, y):  %d, %d\n",  x, y);

	printf ("\n");

	if (cnt>0 && --cnt==0) break;
  } 
	
  if (res == 2)
	printf("\nQuit on time-out. Bye\n");

  return (res != 0);

}
